/***************************************************************************
    begin                : Thu Apr 24 2003
    copyright            : (C) 2003 by Christian Hubinger
    email                : chubinger@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfobjectinfo.h"

// KDE Includes
#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>

// QT includes
#include <qstring.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtextedit.h>

// Project includes
#include "../core/iptrule.h"
#include "../core/iptchain.h"
#include "../core/iptable.h"
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"

KMFObjectInfo::KMFObjectInfo(QWidget *parent, const char *name, bool modal ) : KMyFirewallObjectInfo(parent, name, modal) {
}

KMFObjectInfo::~KMFObjectInfo(){
}

void KMFObjectInfo::loadNetfilterObject( NetfilterObject* obj ) {
	if ( ! obj )
		return;
	m_netfilter_object = obj;
	m_doc = 0;
	switch( m_netfilter_object->type() ) {
		case NetfilterObject::RULE:
			m_header->setText( i18n("Rule Documentation") );
			break;
		case NetfilterObject::CHAIN:
			m_header->setText( i18n("Chain Documentation") );
			break;
		default:
			m_header->setText( i18n("Object Documentation") );
			break;
	}
	te_desc->setText( m_netfilter_object->description() );
}

void KMFObjectInfo::loadKMFDoc( KMFDoc* obj ){
	if ( ! obj )
		return;
	m_doc = obj;
	m_netfilter_object = 0;
	m_header->setText( i18n("Firewall Documentation") );
	te_desc->setText( m_doc->description() );
}

void KMFObjectInfo::accept() {
	if ( m_netfilter_object ) {
		if ( m_netfilter_object->description() != te_desc->text() ) {
			m_netfilter_object->setDescription( te_desc->text() );
			if ( IPTChain* cast = dynamic_cast<IPTChain*>(m_netfilter_object) ) {
				cast->table()->kmfDoc()->changed();
			}
			if ( IPTRule* cast = dynamic_cast<IPTRule*>(m_netfilter_object) ) {
				cast->chain()->table()->kmfDoc()->changed();
			}
			kdDebug()  << "Description Changed: " << te_desc->text() <<  endl;
		}
	} else if ( m_doc ) {
		if ( m_doc->description() != te_desc->text() ) {
			m_doc->setDescription( te_desc->text() );
			m_doc->changed();
			kdDebug()  << "Description Changed: " << te_desc->text() <<  endl;
		}
	}
	
	emit sigDocumentChanged();
	emit sigHideMe();
}

void KMFObjectInfo::reject() {
	emit sigHideMe();
}

void KMFObjectInfo::slotHelp() {
	kapp->invokeHelp( "rule_documentation" );
}

#include "kmfobjectinfo.moc"

