//
// C++ Interface: $MODULE$
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFPROTOCOL_H
#define KMFPROTOCOL_H

#include "netfilterobject.h"

// QT includes
#include <qstringlist.h>
#include <qstring.h>
#include <qguardedptr.h>

// KDE includes
#include <kdemacros.h>

// Project includes

/**
@author Christian Hubinger
*/

class KMFGenericDoc;
class KMFNetZone;

class KDE_EXPORT KMFProtocol : public NetfilterObject {
public:
    KMFProtocol( QObject* );
    ~KMFProtocol();

public:
	void addPort( const QString& , int );
	void delPort( const QString&, int );
	void setLimitInterval( const QString& );
	void setLimit( int );
	void setLogging( bool );
	const QDomDocument& getDOMTree();
	void loadXML(const QDomDocument& );

	bool logging() const {
		return m_log;
	};

	QStringList udpPorts() const {
		return m_udpPorts;
	};

	QStringList tcpPorts() const {
		return m_tcpPorts;
	};

	int type() const {
		return m_type;
	};

	int io() const {
		return m_io;
	};

	void setIO ( int );

	KMFGenericDoc* doc() const {
		return m_doc;
	};

	KMFNetZone* zone() const {
		return m_zone;
	};

	int limit() const {
		return m_limit;
	};

	const QString& limitInterval() const {
		return m_limit_interval;
	};

	enum { TCP, UDP, ICMP } Protocol;
	enum { OUTGOING, INCOMING } IO;
	enum { LIBRARY, USER, CUSTOM } Type;

private:
	private: QStringList m_udpPorts, m_tcpPorts;
	private: QString m_limit_interval;
	private: int m_limit;
	private: int m_type, m_io;
	private: bool m_log;
	private: QGuardedPtr<KMFGenericDoc> m_doc;
	private: QGuardedPtr<KMFNetZone> m_zone;
};

#endif
