//
// C++ Interface: kmfpluginfactory
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFPLUGINFACTORY_H
#define KMFPLUGINFACTORY_H

/**
@author Christian Hubinger
*/
// QT includes
#include <qstring.h>
#include <qptrlist.h>

// KDE includes
// #include <kparts>
#include <kparts/part.h>
#include <kparts/mainwindow.h>

class QObject;
class KMFError;
class KMFCompilerInterface;
class KMFIPTInstallerInterface;
class KMFRuleOptionEditInterface;
class KMFRuleTargetOptionEditInterface;

class KDE_EXPORT KMFPluginFactory {
private:
	KMFPluginFactory();
	~KMFPluginFactory();
public:
static KMFCompilerInterface* KMFCompiler( const QString& platform, const QString& language, QObject* parent  ); 

static KMFIPTInstallerInterface* KMFIPTInstaller( const QString& platform, const QString& language, QObject* parent  ); 

static QPtrList<KMFRuleOptionEditInterface>* KMFRuleOptionEditors(  QObject *parent );

static QPtrList<KMFRuleTargetOptionEditInterface>* KMFRuleTargetOptionEditors( QObject *parent );


static KParts::ReadWritePart* KMFMainView( KParts::MainWindow* parent, KMFError* err );

};

#endif
