/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef WIN32
#include <stdlib.h>
#endif

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>
#include <qlabel.h>

#include "dcconfig.h"
#include "dcsplash.h"
#include "dcgui.h"

#ifdef HAVE_SIGCONTEXT
#include <signal.h>

/** */
void inline z_dump_backtrace(unsigned long eip, unsigned long first_ebp)
{
	/* NOTE: this is i386 specific */
	unsigned long *ebp;

	fprintf(stderr, "retaddr=0x%lx, ebp=0x%lx\n", eip, first_ebp);

	ebp = (unsigned long *) first_ebp;
	while (ebp > (unsigned long *) &ebp && *ebp)
	{
		fprintf(stderr, "retaddr=0x%lx, ebp=0x%lx\n", *(ebp+1), *ebp);
		ebp = (unsigned long *) *ebp;
	}
}

#ifdef HAVE_SIGCONTEXT_LINUX
/** */
void sigsegv_handler(int signo)
{
	struct sigcontext *p = (struct sigcontext *) (((char *) &p) + 16);

	fprintf(stderr, "Signal (%d) received, stackdump follows; eax='%08lx', ebx='%08lx', ecx='%08lx', edx='%08lx', eip='%08lx'\n",
        	signo,p->eax,p->ebx,p->ecx,p->edx,p->eip);
	z_dump_backtrace(p->eip, p->ebp);
	exit(1);
}
#endif

#ifdef HAVE_SIGCONTEXT_FREEBSD
/** */
void sigsegv_handler(int signo)
{
	struct sigcontext *p = (struct sigcontext *) (((char *) &p) + 16);

	fprintf(stderr, "Signal (%d) received, stackdump follows; eax='%08lx', ebx='%08lx', ecx='%08lx', edx='%08lx', eip='%08lx'\n",
        	signo,p->sc_eax,p->sc_ebx,p->sc_ecx,p->sc_edx,p->sc_eip);
	z_dump_backtrace(p->sc_eip, p->sc_ebp);
	exit(1);
}
#endif

#endif

/** */
int main(int argc, char *argv[])
{
	int i;
	int ret;
	CString configpath = "";
	QApplication * pApplication;

	// startup parameter
	bool bSplash = TRUE;
#ifdef HAVE_SIGCONTEXT
	bool bBacktrace = TRUE;
#endif

	// parameter stuff ...
	for(i=1;i<argc;i++)
	{
		if ( QString(argv[i]) == "--disable-splash" )
			bSplash = FALSE;
#ifdef HAVE_SIGCONTEXT
		else if ( QString(argv[i]) == "--disable-backtrace" )
			bSplash = FALSE;
#endif
		else if ( QString(argv[i]) == "-c" )
		{
			i++;
			if ( i<argc )
			{
				configpath = argv[i];
			}
			else
			{
				printf("Wrong parameter !\n");
				return -1;
			}
		}
		else
		{
			printf("Wrong parameter !\n");
			return -1;
		}
	}

#ifdef HAVE_SIGCONTEXT
	if(bBacktrace)
		signal(SIGSEGV, sigsegv_handler);
#endif
	pApplication = new QApplication(argc, argv);

	DCSplash * s;
	s = new DCSplash(0);
	if (bSplash)
		s->show();
	else
		s->hide();

	s->TextLabel_STATUS->setText("Load config ...");
	pApplication->processEvents();

	Config = new DCConfig(configpath);

	ret = Config->Load();

	QFont appFont;
	if (appFont.fromString( QString(Config->GetAppFont().Data()) ) == FALSE)
	{
		// In case the xml file is messed up
		appFont.fromString(DEFAULT_APP_FONT);
	}
	pApplication->setFont(appFont);

	s->TextLabel_STATUS->setText("Install translator ...");
	pApplication->processEvents();

	QTranslator tor(0);

	if ( Config->GetLanguageFile() != "" )
	{
		tor.load( Config->GetLanguageFile().Data(), "." );
	}
	else
	{
		tor.load( QString("dcgui.") + QTextCodec::locale(), "." );
	}

	pApplication->installTranslator( &tor );

	s->TextLabel_STATUS->setText("Create sharelist ...");
	pApplication->processEvents();

	// create share list
	Config->CreateShareList();

	s->TextLabel_STATUS->setText("Start ...");
	pApplication->processEvents();

	DCGuiApp *dcgui=new DCGuiApp();

	s->hide();
	delete s;

	if ( ret != 0 )
	{
		// open options dialog ...
		dcgui->ShowOptionsDialog();
	}

	pApplication->setMainWidget(dcgui);

	dcgui->show();

	ret = pApplication->exec();

	pApplication->setMainWidget(0);
	delete dcgui;
	delete pApplication;

	if(Config)
	{
		delete Config;
		Config = 0;
	}

	printf("application exit ok %d\n",ret);//fflush(stdout);

	return ret;
}
