/***************************************************************************
                          dcwidget.h  -  description
                             -------------------
    begin                : Don Mai 30 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCWIDGET_H
#define DCWIDGET_H

#include <qlistview.h>

#include <dclib/dcos.h>
#include <dclib/cmessagehandler.h>

/**
  *@author Mathias Kster
  */

class DC_QNumericSortItem : public QObject {
public:
	/** */
	int mycol;
	/** */
	ulonglong myvalue;
	/** */
	DC_QNumericSortItem() { mycol=-1;myvalue=0; };
	/** */
	virtual ~DC_QNumericSortItem() {};
	/** */
	int mycompare( ulonglong v1, ulonglong v2, int col, bool ascending ) const;
};

class DC_QListViewItem : public QListViewItem, public DC_QNumericSortItem {
public:
	/** */
	DC_QListViewItem( QListView * parent ) : QListViewItem(parent) {};
	/** */
	DC_QListViewItem( QListViewItem * parent ) : QListViewItem(parent) {};
	/** */
	virtual ~DC_QListViewItem() {};
	/** */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;
};

class DC_QCheckListItem : public QCheckListItem, public DC_QNumericSortItem {
public:
	/** */
	DC_QCheckListItem( QListView *parent, const QString &text, const QPixmap & );
	/** */
	virtual ~DC_QCheckListItem() {};
	/** */
	virtual void paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align );
	/** */
	QColor colorText;
	/** */
	virtual int compare( QListViewItem * i, int col, bool ascending ) const;
};

#endif
