/***************************************************************************
                          dcwidget.cpp  -  description
                             -------------------
    begin                : Don Mai 30 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcwidget.h"

/** */
DC_QCheckListItem::DC_QCheckListItem( QListView *parent, const QString &text, const QPixmap & p ) : QCheckListItem( parent, text, p )
{
	colorText.setNamedColor("black");
}

/** */
void DC_QCheckListItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
	if ( column == 0 )
	{
		QColorGroup _cg(cg);

		_cg.setColor( QColorGroup::Text, colorText );

		QCheckListItem::paintCell( p, _cg, column, width, align );
	}
	else
	{
		QCheckListItem::paintCell( p, cg, column, width, align );
	}
}

/** */
int DC_QListViewItem::compare( QListViewItem * i, int col, bool ascending ) const
{
	if(col==DC_QNumericSortItem::mycol)
		return DC_QNumericSortItem::mycompare(((DC_QListViewItem*)i)->myvalue,myvalue,col,ascending);
	else
		return QListViewItem::compare(i,col,ascending);
}

/** */
int DC_QCheckListItem::compare( QListViewItem * i, int col, bool ascending ) const
{
	if(col==DC_QNumericSortItem::mycol)
		return DC_QNumericSortItem::mycompare(((DC_QCheckListItem*)i)->myvalue,myvalue,col,ascending);
	else
		return QListViewItem::compare(i,col,ascending);
}

/** */
int DC_QNumericSortItem::mycompare( ulonglong v1, ulonglong v2, int , bool ) const
{
	if(v1<v2) return -1;
	else if(v1==v2) return 0;
	else return 1;
}
