/***************************************************************************
                          dctransferview.h  -  description
                             -------------------
    begin                : Sat Feb 23 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSFERVIEW_H
#define DCTRANSFERVIEW_H

#include <dclib/dcos.h>

#include <qwidget.h>
#include <qtimer.h>
#include <qworkspace.h>

#include <dclib/ctransfer.h>
#include <dclib/clist.h>
#include <dclib/cthread.h>
#include <dclib/clisten.h>
#include <dclib/cdownloadmanager.h>
#include <dclib/cdownloadqueue.h>

#include <dcconfig.h>

#include <DCDialogTransfer.h>

/**
  *@author Mathias Kster
  */

class DCBrowseFileTree;

class DCTransferQueueItem : public CObject {
public:
	/** */
	DCTransferQueueItem() {};
	/** */
	virtual ~DCTransferQueueItem() {};

	/** */
	CObject * pObject;
	/** */
	QListViewItem * pItem;
};

class DCTransferListItem : public CObject {
public:
	/** */
	DCTransferListItem() {};
	/** */
	virtual ~DCTransferListItem() {};

	/** */
	CObject * pObject;
	/** */
	QListViewItem * pItem;
};

class DCTransferView : public DCDialogTransfer, public CDownloadManager {
Q_OBJECT
public:
	/** */
	DCTransferView(QWidget* parent, const char *name, int wflags);
	/** */
	virtual ~DCTransferView();

	/** */
	void SetWorkspace(QWidget* workspace);
	/** */
	void InitDocument();
	/** */
	void NewFileBrowser( QString nick, QString hubname, QString hubhost, QString share );
	/** download manager callback function */
	virtual int DC_DownloadManagerCallBack( CObject * );
	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	CList<CObject> * pMessageList;
	/** */
	CList<DCTransferListItem> * pTransferList;
	/** */
	CThread Thread;
	/** */
	QWorkspace *pWorkspace;
	/** */
	CList<DCBrowseFileTree> *pFileList;
	/** */
	QTimer Timer;
	/** */
	CStringList * pQueueList;

	/** */
	int state_slot;
	/** */
	int state_slot_use;
	/** */
	ulonglong state_files;
	/** */
	ulonglong state_filesize;
	/** */
	int state_upload;
	/** */
	int state_download;
	/** */
	ulonglong state_upload_rate;
	/** */
	ulonglong state_download_rate;

private slots:
	/** */
	void timerDone();
	/** */
	void slotRightButtonClickedTransferList( QListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedTransferWaitList( QListViewItem*, const QPoint &, int );
	/** */
	void slotTabWidgetCurrentChange(QWidget*);
};

/** */
extern DCTransferView * pTransferView;

#endif
