/***************************************************************************
                          dctransferview.cpp  -  description
                             -------------------
    begin                : Sat Feb 23 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistview.h>
#include <qstringlist.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qmessagebox.h>
#include <qtextedit.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <qinputdialog.h>

#include <dcconfig.h>
#include <dcbrowsefiletree.h>
#include <dcserverlist.h>
#include <dcmenuhandler.h>

#include "dctransferview.h"

#define TIMER_BASE 500

DCTransferView * pTransferView = 0;

/** */
DCTransferView::DCTransferView(QWidget* parent, const char *name, int wflags) : DCDialogTransfer(parent, name, wflags)
{
	int idx;

	// set the ColumnWidthMode to manual, we will take care of this task
	for( idx = 0; idx < ListView_TRANSFER->columns(); idx++ )
	{
		ListView_TRANSFER->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_TRANSFERWAIT->columns(); idx++ )
	{
		ListView_TRANSFERWAIT->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_SLOTS->columns(); idx++ )
	{
		ListView_SLOTS->setColumnWidthMode( idx, QListView::Manual );
	}

	pFileList     = new CList<DCBrowseFileTree>();
	pMessageList  = new CList<CObject>;
	pQueueList    = new CStringList();
	pTransferList = new CList<DCTransferListItem>;

	state_slot          = 0;
	state_slot_use      = 0;
	state_files         = 0;
	state_filesize      = 0;
	state_upload        = 0;
	state_download      = 0;
	state_upload_rate   = 0;
	state_download_rate = 0;

	InitDocument();
}

/** */
DCTransferView::~DCTransferView()
{
	DCBrowseFileTree * FileList;

	Timer.stop();

	Thread.Lock();

	// clear filelist
	while ( (FileList=pFileList->Next(0)) != 0 )
	{
		// remove from the list
		pFileList->Del(FileList);
	}

	delete pFileList;
	pFileList = 0;

	ListView_TRANSFERWAIT->clear();

	if ( pMessageList )
	{
		delete pMessageList;
		pMessageList = 0;
	}

	if ( pQueueList )
	{
		delete pQueueList;
		pQueueList = 0;
	}

	if ( pTransferList )
	{
		delete pTransferList;
		pTransferList = 0;
	}

	SaveQueue();

	Thread.UnLock();
}

/** */
void DCTransferView::SetWorkspace( QWidget* workspace )
{
	pWorkspace = (QWorkspace*)workspace;
}

/** */
void DCTransferView::InitDocument()
{
	connect( TabWidget_TRANSFER,SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetCurrentChange(QWidget*)) );
	connect( ListView_TRANSFER, SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedTransferList(QListViewItem*, const QPoint &, int )) );
	connect( ListView_TRANSFERWAIT, SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedTransferWaitList(QListViewItem*, const QPoint &, int )) );

	// load download manager queue
	LoadQueue();

	connect( &Timer, SIGNAL(timeout()), this, SLOT(timerDone()) );

	Timer.start( TIMER_BASE, TRUE );
}

/** */
bool DCTransferView::eventFilter( QObject * object, QEvent * event )
{
	DCBrowseFileTree * FileList;

	if((event->type() == QEvent::Close)&&((DCTransferView*)object!=this))
	{
		// file list closed
		Thread.Lock();

		if ( pFileList != 0 )
		{
			FileList = (DCBrowseFileTree *)object;
			pFileList->Remove(FileList);
		}

		Thread.UnLock();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/** current tab widget change slot */
void DCTransferView::slotTabWidgetCurrentChange(QWidget*)
{
	ResizeListViewColumn();
}

/** overridden so that the columns are resized on show() */
void DCTransferView::show()
{
	QWidget::show();

	ResizeListViewColumn();
}

/** resize event handler */
void DCTransferView::resizeEvent( QResizeEvent * )
{
	ResizeListViewColumn();
}

/** resize the ListView columns */
void DCTransferView::ResizeListViewColumn()
{
	int width;

	if ( ListView_TRANSFER->isVisible() )
	{
		width = ListView_TRANSFER->width();
	
		ListView_TRANSFER->setColumnWidth( 0, ((width*1)/10) );
		ListView_TRANSFER->setColumnWidth( 1, ((width*2)/10) );
		ListView_TRANSFER->setColumnWidth( 2, ((width*1)/10) );
		ListView_TRANSFER->setColumnWidth( 3, ((width*3)/10) );
		ListView_TRANSFER->setColumnWidth( 4, ((width*3)/10) );
	}
	if ( ListView_TRANSFERWAIT->isVisible() )
	{
		width = ListView_TRANSFERWAIT->width();

		ListView_TRANSFERWAIT->setColumnWidth( 0, ((width*4 )/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 1, ((width*11)/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 2, ((width*5 )/24) );
		ListView_TRANSFERWAIT->setColumnWidth( 3, ((width*4 )/24) );
	}
	if ( ListView_SLOTS->isVisible() )
	{
		width = ListView_SLOTS->width();

		ListView_SLOTS->setColumnWidth( 0, ((width*3)/9) );
		ListView_SLOTS->setColumnWidth( 1, ((width*3)/9) );
		ListView_SLOTS->setColumnWidth( 2, ((width*3)/9) );
	}
}

/** download manager callback function */
int DCTransferView::DC_DownloadManagerCallBack( CObject * Object )
{
	int err;

	Thread.Lock();

	if ( Object != NULL )
	{
		if ( pMessageList != 0 )
		{
			pMessageList->Add(Object);
			err = 0;
		}
		else
		{
			err = -1;
		}
        }
	else
	{
		err = -1;
	}

	Thread.UnLock();

	return err;
}

/** */
void DCTransferView::timerDone()
{
	CObject * Object;
	CDCMessage *DCMsg;
	bool bLVWaiUpdate = FALSE;

	for(;;)
	{
		if ( Thread.TryLock() == FALSE )
		{
			break;
		}

		if ( pMessageList != 0 )
		{
			Object = pMessageList->Next(0);

			if ( Object != 0 )
			{
				pMessageList->Remove(Object);
			}
		}
		else
		{
			Object = 0;
		}

		Thread.UnLock();

		if ( Object == 0 )
		{
			break;
		}

		DCMsg = (CDCMessage*) Object;

		switch ( DCMsg->eType )
		{
			case DC_MESSAGE_DM_INFO:
			{
				CDownloadManagerInfo * msg = (CDownloadManagerInfo*)Object;

				TextLabel_SLOT->setText(CString().setNum(msg->slot_use).Data()+QString("/")+CString().setNum(msg->slot_max).Data());

				CString sul,sdl;
				ulonglong lul,ldl;
				lul = msg->rate_ul;
				sul = "B/s";
				if ( lul >= 1024 )
				{
					sul = "KB/s";
					lul/=1024;
				}
				ldl = msg->rate_dl;
				sdl = "B/s";
				if ( ldl >= 1024 )
				{
					sdl = "KB/s";
					ldl/=1024;
				}

				TextLabel_SPEED->setText((CString().setNum(lul)+sul).Data()+QString(" / ")+(CString().setNum(ldl)+sdl).Data());

				break;
			}

			case DC_MESSAGE_SLOT_OBJECT:
			{
				CMessageDMSlotObject * msg = (CMessageDMSlotObject *)Object;

				QListViewItem * item = ListView_SLOTS->firstChild();

				while(item)
				{
					if ( (item->text(0) == msg->sNick.Data()) &&
					     (item->text(1) == msg->sHubName.Data()) )
					{
						if ( (msg->iSlots == 0) && (!msg->bPermanent) )
						{
							ListView_SLOTS->takeItem(item);
							delete item;
							item=0;
						}

						break;
					}

					item = item->nextSibling();
				}

				if ( (!item) && ((msg->iSlots > 0) || (msg->bPermanent)) )
				{
					item = new QListViewItem( ListView_SLOTS, msg->sNick.Data(), msg->sHubName.Data() );
				}

				if (item)
				{
					if ( msg->bPermanent )
					{
						item->setText(2,"X");
					}
					else
					{
						item->setText(2,QString().setNum(msg->iSlots));
					}
				}

				break;
			}

			case DC_MESSAGE_LOG:
			{
				CMessageLog * msg = (CMessageLog*)Object;
				bool bscroll;

				if ( TextEdit_LOG->verticalScrollBar()->maxValue() == TextEdit_LOG->verticalScrollBar()->value() )
				{
					bscroll = TRUE;
				}
				else
				{
					bscroll = FALSE;
				}

				TextEdit_LOG->append( QTime::currentTime().toString("[hh:mm:ss] ") + msg->sMessage.Data());

				if ( bscroll )
				{
					TextEdit_LOG->scrollToBottom();
					TextEdit_LOG->moveCursor( QTextEdit::MoveEnd, FALSE );
				}

				break;
			}

			case DC_MESSAGE_FILE_OBJECT:
			{
				CMessageDMFileObject * msg = (CMessageDMFileObject*)Object;

				CStringList * StringList1=0, *StringList2=0;
				DCTransferQueueItem * TransferQueueItem1=0,* TransferQueueItem2=0;

				if ( pQueueList->Get( msg->sNick, (CObject *&) StringList1) != 0 )
				{
					StringList1 = new CStringList();
					pQueueList->Add( msg->sNick, StringList1 );
				}

				if ( StringList1->Get( msg->sHubName, (CObject *&) TransferQueueItem1 ) != 0 )
				{
					ListView_TRANSFERWAIT->setUpdatesEnabled(FALSE);
					bLVWaiUpdate = TRUE;

					TransferQueueItem1 = new DCTransferQueueItem();
					TransferQueueItem1->pObject = new CStringList();
					TransferQueueItem1->pItem   = new QListViewItem( ListView_TRANSFERWAIT, msg->sNick.Data() );
					TransferQueueItem1->pItem->setText(1,msg->sHubName.Data());
					TransferQueueItem1->pItem->setText(2,msg->sHubHost.Data());

					StringList1->Add( msg->sHubName, TransferQueueItem1 );
				}

				StringList2 = (CStringList*)TransferQueueItem1->pObject;

				QString s;

				switch(msg->eWaitState)
				{
					case etwsWAIT:
						s = tr("Wait");
						break;
					case etwsIDLE:
						s = tr("Idle");
						break;
					case etwsRUN:
						s = tr("Run");
						s += " ["+QString().setNum(msg->iConnections)+"]";
						break;
					case etwsPAUSE:
						s = tr("Pause");
						break;
					case etwsHUBOFFLINE:
						s = tr("Hub offline");
						break;
					case etwsUSEROFFLINE:
						s = tr("User offline");
						break;
					case etwsUSERBUSY:
						s = tr("User busy");
						break;
					case etwsSENDERROR:
						s = tr("Send error");
						break;
					default:
						s = tr("Unknown");
						break;
				}

				TransferQueueItem1->pItem->setText(3,s);

				if ( (msg->sRemoteFile == "") && (msg->bRemoveFile == TRUE) )
				{
					ListView_TRANSFERWAIT->takeItem(TransferQueueItem1->pItem);
					delete TransferQueueItem1->pItem;
					TransferQueueItem1->pItem = 0;
					delete TransferQueueItem1->pObject;
					TransferQueueItem1->pObject = 0;
					StringList1->Del( msg->sHubName );

					if ( StringList1->Count() == 0 )
					{
						pQueueList->Del( msg->sNick );
					}
				}

				if ( msg->sRemoteFile != "" )
				{
					if ( StringList2->Get( msg->sRemoteFile, (CObject *&) TransferQueueItem2 ) != 0 )
					{
						TransferQueueItem2 = new DCTransferQueueItem();

						// clear object pointer
						Object = 0;
						TransferQueueItem2->pObject = msg;
						TransferQueueItem2->pItem   = new QListViewItem ( TransferQueueItem1->pItem, "" );
						TransferQueueItem2->pItem->setText(1, msg->sRemoteFile.Data());
						TransferQueueItem2->pItem->setText(2, CString().setNum(msg->lSize).Data());

						StringList2->Add( msg->sRemoteFile, TransferQueueItem2 );
					}

					if ( msg->bRemoveFile == TRUE )
					{
						TransferQueueItem1->pItem->takeItem(TransferQueueItem2->pItem);
						delete TransferQueueItem2->pItem;
						TransferQueueItem2->pItem = 0;
						StringList2->Del( msg->sRemoteFile );

						// remove empty list ...
						if ( StringList2->Count() == 0 )
						{
							ListView_TRANSFERWAIT->takeItem(TransferQueueItem1->pItem);
							delete TransferQueueItem1->pItem;
							TransferQueueItem1->pItem = 0;
							delete TransferQueueItem1->pObject;
							TransferQueueItem1->pObject = 0;
							StringList1->Del( msg->sHubName );

							if ( StringList1->Count() == 0 )
							{
								pQueueList->Del( msg->sNick );
							}
						}
					}
					else if ( msg->bRemoveFile == FALSE )
					{
						switch(msg->eFileState)
						{
							case etfsNONE:
								TransferQueueItem2->pItem->setText(3,tr("Idle"));
								break;
							case etfsTRANSFER:
								TransferQueueItem2->pItem->setText(3,tr("Transfer"));
								break;
							case etfsERROR:
								TransferQueueItem2->pItem->setText(3,tr("Error"));
								break;
							default:
								TransferQueueItem2->pItem->setText(3,tr("Unknown"));
								break;
       						}
					}
				}

				break;
			}

			case DC_MESSAGE_TRANSFER_OBJECT:
			{
				CMessageDMTransferObject * msg = (CMessageDMTransferObject*)Object;
				CMessageDMTransferObject * msg1;

				DCTransferListItem * TransferListItem = 0;

				while ( (TransferListItem = pTransferList->Next(TransferListItem)) != 0 )
				{
					msg1 = (CMessageDMTransferObject*)TransferListItem->pObject;

					if ( (msg1->sRemoteFile == msg->sRemoteFile) &&
					     (msg1->sNick == msg->sNick) )
					{
						break;
					}
				}

				if ( (msg->lCurrentPosition == msg->lEndPosition) || (msg->bRemoveTransfer == TRUE) )
				{
					if ( TransferListItem )
					{
						ListView_TRANSFER->takeItem(TransferListItem->pItem);
						delete TransferListItem->pItem;
						delete TransferListItem->pObject;
						pTransferList->Del(TransferListItem);
					}

					break;
				}

				if ( (TransferListItem == 0) && (msg->bRemoveTransfer == FALSE) )
				{
					TransferListItem = new DCTransferListItem();
					TransferListItem->pItem = new QListViewItem( ListView_TRANSFER, msg->sNick.Data(), msg->sHost.Data(), "", "", msg->sRemoteFile.Data() );
					TransferListItem->pObject = msg;
					Object = 0;
					pTransferList->Add(TransferListItem);
				}

				switch(msg->eState)
				{
					case estTRANSFERDOWNLOAD:
						TransferListItem->pItem->setText(2,tr("Download"));
						break;
					case estTRANSFERUPLOAD:
						TransferListItem->pItem->setText(2,tr("Upload"));
						break;
					default:
						TransferListItem->pItem->setText(2,tr("Unknown"));
						break;
				}

				ulonglong rate;
				CString r,s;

				rate = msg->lRate;
				r = "B/s";
				if ( rate >= 1024 )
				{
					r = "KB/s";
					rate/=1024;
				}

				s  = CString().setNum(msg->lCurrentPosition);
				s += "/";
				s += CString().setNum(msg->lSize);
				s += " [";
				s += CString().setNum(rate);
				s += " ";
				s += r + "]";

				rate = msg->lEndPosition-msg->lCurrentPosition;

				if ( msg->lRate>0 )
					rate/=msg->lRate;

				// This will Convert Total Secs to how much time is
				// remaining X Days + X Hrs + X Mins + X Secs
				r = " S";
				s += " [";
				if ( rate > (60*60*24) )
				{
					s+= CString().setNum(rate/(60*60*24)) +" D ";
					rate %= (60*60*24);
				}
				if ( rate > (60*60) )
				{
					s+= CString().setNum(rate/(60*60)).RightJustify(2,'0')+":";
					rate %= (60*60);
				}
				else
				{
					s+= "00:";
				}
				if ( rate > 60 )
				{
					s += CString().setNum(rate/60).RightJustify(2,'0')+":";
					rate %= 60;
				}
				else
				{
					s+= "00:";
				}
				s += CString().setNum(rate).RightJustify(2,'0').RightJustify(2,'0');
				s += "]";

				TransferListItem->pItem->setText(3,s.Data());

				break;
			}

			case DC_MESSAGE_FILELIST_OBJECT:
			{
				CMessageDMFileListObject * msg = (CMessageDMFileListObject*)Object;

				NewFileBrowser(msg->sNick.Data(),msg->sHubName.Data(),msg->sHubHost.Data(),msg->sUserFileList.Data());

				break;
			}

			default:
			{
				break;
			}
		}

		if ( Object )
		{
			delete Object;
		}
	}

	if ( bLVWaiUpdate == TRUE )
	{
		ListView_TRANSFERWAIT->setUpdatesEnabled(TRUE);
		ListView_TRANSFERWAIT->triggerUpdate();
	}

	Timer.start( TIMER_BASE, TRUE );
}

/** */
void DCTransferView::NewFileBrowser( QString nick, QString hubname, QString hubhost, QString share )
{
	DCBrowseFileTree *bft;
	bft = new DCBrowseFileTree( pWorkspace, "browsefiletree", WDestructiveClose );

	// set transfer
	bft->setCaption( nick + " - Filebrowser" );
	bft->installEventFilter(this);
	bft->InitTree(nick,hubname,hubhost,share);
	pFileList->Add(bft);
	bft->show();
}

/** */
void DCTransferView::slotRightButtonClickedTransferList( QListViewItem * item , const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	QString nick,host,file;

	if( item == 0 )
	{
		return;
	}

	nick = item->text(0);
	host = item->text(1);
	file = item->text(4);

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiCLOSE_TRANSFER );
	DCMenuHandler::InsertMenuItem( m, emiCHANGE_TRANSFER_RATE, (TransferDirection( nick.ascii(), host.ascii(), file.ascii() ) == edUPLOAD) );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiCLOSE_TRANSFER )
	{
		TransferClose( nick.ascii(), host.ascii(), file.ascii() );
	}
	else if ( id == emiCHANGE_TRANSFER_RATE )
	{
		bool ok = FALSE;
		ulonglong rate;

		rate = TransferGetRate( nick.ascii(), host.ascii(), file.ascii() );

		rate = QInputDialog::getInteger(
			tr("Change Transfer-Rate"),
			tr("Please enter a Transfer-Rate [B/s] (0=off)"), rate, 0, 9999999, 1, &ok, this );

		if ( ok )
		{
			TransferSetRate( nick.ascii(), host.ascii(), file.ascii(), rate );
		}
	}
}

/** */
void DCTransferView::slotRightButtonClickedTransferWaitList( QListViewItem * item , const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	QListViewItem * item1;
	QString nick,hubname,hubhost,file;
	CUserFileInfo UserFileInfo;

	if( item == 0 )
	{
		return;
	}

	if ( item->depth() == 1 )
	{
		item1 = item->parent();
	}
	else
	{
		item1 = item;
	}

	if ( item1 == 0 )
	{
		return;
	}

	nick    = item1->text(0);
	hubname = item1->text(1);
	hubhost = item1->text(2);

	if ( item1 != item )
	{
		file = item->text(1);
	}
	else
	{
		file = "";
	}

	if ( GetUserFileInfo(nick.ascii(),hubname.ascii(),hubhost.ascii(),file.ascii(),&UserFileInfo) == FALSE )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiREMOVE_TRANSFER_QUEUE, ( ((UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT)) || ( (file != "") && (UserFileInfo.eFileState!=etfsTRANSFER))) );
	DCMenuHandler::InsertMenuItem( m, emiREMOVE_TRANSFER_QUEUE_DISK, FALSE ); //(TransferItem.eState == etwsIDLE) );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiTRY_CONNECT, ((UserFileInfo.eWaitState != etwsRUN) && (UserFileInfo.eWaitState != etwsWAIT)) );
	DCMenuHandler::InsertMenuItem( m, emiCONNECT_TO_HUB );
	DCMenuHandler::InsertMenuItem( m, emiBROWSE_USER_FILES, (UserFileInfo.sUserFileList != "") );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiINFO, FALSE );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiSAVE_QUEUE, TRUE );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiCONNECT_TO_HUB )
	{
		pServerList->Connect( hubname, hubhost );
	}
	else if ( id == emiBROWSE_USER_FILES )
	{
		NewFileBrowser(nick,hubname,hubhost,UserFileInfo.sUserFileList.Data());
	}
	else if ( id == emiTRY_CONNECT )
	{
		TryConnect(nick.ascii(),hubname.ascii(),hubhost.ascii());
	}
	else if ( id == emiREMOVE_TRANSFER_QUEUE )
	{
		if ( RemoveQueue(nick.ascii(),hubname.ascii(),file.ascii()) == FALSE )
		{
			// TODO: error handling
		}
	}
	else if ( id == emiSAVE_QUEUE )
	{
		SaveQueue();
	}
}
