/***************************************************************************
                          dcserverlist.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCSERVERLIST_H
#define DCSERVERLIST_H

#include <dclib/dcos.h>

#include <qlistview.h>

#include <DCDialogServerList.h>
#include <qworkspace.h>

#include <dclib/clist.h>
#include <dclib/cstring.h>
#include <dclib/cthread.h>
#include <dclib/cservermanager.h>

class DCClient;
class QStringList;

/**
  *@author Mathias Kster
  */

class DCServerList : public DCDialogServerList, public CServerManager {
Q_OBJECT

public:
	/** */
	DCServerList(QWidget* parent, const char *name, int wflags);
	/** */
	virtual ~DCServerList();

	/** */
	void InitDocument();
	/** */
	CString GetPublicHubList();
	/** */
	void ShowPublicHubList();
	/** */
	void ParsePublicHubList( QString s );

	/** */
	void Connect( QString hubname, QString server );
	/** */
	void AddBookmark( QString name, QString host, QString description );
	/** */
	void DelBookmark( QString name, QString host, QString description );
	/** */
	void UpdateBookmark( QString name, QString host, QString description );

	/** */
	QStringList * GetPublicHubServerList();
	/** */
	QStringList * GetBookmarkHubServerList();

	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** */
	QWorkspace *pWorkspace;

	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter(QObject* object, QEvent* event);
	/** close event handler */
	virtual void closeEvent(QCloseEvent*) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private slots:
	/** reload public hub list */
	void slotReloadPublicHubList();
	/** update public hub list */
	void slotUpdatePublicHubList();
	/** */
	void slotDoubleClicked(QListViewItem*item);
	/** */
	void slotConnect();
	/** */
	void slotRightButtonClickedPublicList(QListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedBookmarkList(QListViewItem*, const QPoint &, int );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange(QWidget*);
};

/** */
extern DCServerList * pServerList;

#endif
