/***************************************************************************
                          dcserverlist.cpp  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qobject.h>
#include <qpainter.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qstringlist.h>
#include <qtabwidget.h>

#include <dcgeturl.h>
#include <dcclient.h>
#include <dcconfig.h>
#include <dcmenuhandler.h>
#include <dcwidget.h>
#include "dcserverlist.h"

#include <dclib/cbz.h>

#include "DCDialogEditServer.h"

DCServerList * pServerList;

/** */
DCServerList::DCServerList(QWidget* parent, const char *name, int wflags) : DCDialogServerList(parent, name, wflags)
{
	int idx;

	pWorkspace = (QWorkspace*)parent;

	// set the ColumnWidthMode to manual, we will take care of this task
	for( idx = 0; idx < ListView_PUBLIC->columns(); idx++ )
	{
		ListView_PUBLIC->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_BOOKMARKS->columns(); idx++ )
	{
		ListView_BOOKMARKS->setColumnWidthMode( idx, QListView::Manual );
	}

	InitDocument();
}

/** */
DCServerList::~DCServerList()
{
	DCClient * Client = 0;

	while( (Client=(DCClient*)pClientList->Next(0)) != 0 )
	{
		Client->removeEventFilter(this);
		pClientList->Remove(Client);
		Client->Disconnect();
	}
}

/** event filter */
bool DCServerList::eventFilter(QObject* object, QEvent* event)
{
	if((event->type() == QEvent::Close)&&((DCServerList*)object!=this))
	{
		QCloseEvent* e=(QCloseEvent*)event;
		DCClient* pView=(DCClient*)object;
		pView->Disconnect();

		Thread.Lock();
		if ( pClientList != 0 )
			pClientList->Remove(pView);
		Thread.UnLock();

		e->accept();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/** current tab widget change slot */
void DCServerList::slotTabWidgetCurrentChange(QWidget*)
{
	ResizeListViewColumn();
}

/** overridden so that the columns are resized on show() */
void DCServerList::show()
{
	QWidget::show();

	ResizeListViewColumn();
}

/** resize event handler */
void DCServerList::resizeEvent( QResizeEvent * )
{
	ResizeListViewColumn();
}

/** resize the ListView columns */
void DCServerList::ResizeListViewColumn()
{
	int width;

	if ( ListView_PUBLIC->isVisible() )
	{
		width = ListView_PUBLIC->width();

		ListView_PUBLIC->setColumnWidth( 0, ((width*3)/10) );
		ListView_PUBLIC->setColumnWidth( 1, ((width*3)/10) );
		ListView_PUBLIC->setColumnWidth( 2, ((width*3)/10) );
		ListView_PUBLIC->setColumnWidth( 3, ((width*1)/10) );
	}

	if ( ListView_BOOKMARKS->isVisible() )
	{
		width = ListView_BOOKMARKS->width();

		ListView_BOOKMARKS->setColumnWidth( 0, ((width*10)/30) );
		ListView_BOOKMARKS->setColumnWidth( 1, ((width*10)/30) );
		ListView_BOOKMARKS->setColumnWidth( 2, ((width*10)/30) );
	}
}

/** */
void DCServerList::InitDocument()
{
	CList<DCConfigHubItem> list;

	connect( PushButton_RELOADPUBLICHUBLIST, SIGNAL(clicked()), this, SLOT(slotReloadPublicHubList()) );
	connect( PushButton_UPDATEPUBLICHUBLIST, SIGNAL(clicked()), this, SLOT(slotUpdatePublicHubList()) );

	connect( PushButton_CONNECT, SIGNAL(clicked()), this, SLOT(slotConnect()) );

	// public list
	connect( ListView_PUBLIC,SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotDoubleClicked(QListViewItem*)) );
	connect( ListView_PUBLIC,SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedPublicList(QListViewItem*, const QPoint &, int )) );

	// bookmark list
	connect( ListView_BOOKMARKS,SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotDoubleClicked(QListViewItem*)) );
	connect( ListView_BOOKMARKS,SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedBookmarkList(QListViewItem*, const QPoint &, int )) );

	connect( TabWidget_SERVERLIST,SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetCurrentChange(QWidget*)) );

	Config->GetBookmarkHubList(&list);

	DCConfigHubItem * hubitem = 0;

	while( (hubitem=list.Next(hubitem)) != 0 )
	{
		new QListViewItem(ListView_BOOKMARKS,hubitem->sName.Data(),hubitem->sHost.Data(),hubitem->sDescription.Data());
	}

	ShowPublicHubList();
}

/** */
QStringList * DCServerList::GetPublicHubServerList()
{
	QStringList * sl;
	QListViewItem * item;
	QListViewItemIterator it(ListView_PUBLIC);

	sl = new QStringList();

	for (;it.current();++it)
	{
		item = it.current();

		if ( item->text(1) != "" )
		{
			sl->append(item->text(1));
		}
	}

	return sl;
}

/** */
QStringList * DCServerList::GetBookmarkHubServerList()
{
	QStringList * sl;
	QListViewItem * item;
	QListViewItemIterator it(ListView_BOOKMARKS);

	sl = new QStringList();

	for (;it.current();++it)
	{
		item = it.current();

		if ( item->text(1) != "" )
		{
			sl->append(item->text(1));
		}
	}

	return sl;
}

/** */
CString DCServerList::GetPublicHubList()
{
	CString s;
	DCGetURL * GetUrl;
	CByteArray in,out;
	CString u;
	QString t;
	CBZ bz2;

	CList<DCConfigHubListUrl> hublisturllist;
	Config->GetHubListUrlList(&hublisturllist);

	s = "";
	u = "";

	DCConfigHubListUrl * hublisturl = 0;

	while( (hublisturl=hublisturllist.Next(hublisturl)) != 0 )
	{
		if ( hublisturl->bEnabled == TRUE )
		{
			GetUrl = new DCGetURL(hublisturl->sUrl.Data());

			if ( GetUrl->Get() == QDialog::Accepted )
			{
				GetUrl->GetData( &in );
				t = hublisturl->sUrl.Data();

				if ( t.find(".bz2") != -1 )
				{
					if ( bz2.Decompress( &in, &out ) == TRUE )
					{
						u.Set( (char*)out.Data(), out.Size() );
						u+="\n";
					}
					else
					{
						u = "";
					}
				}
				else
				{
					u.Set( (char*)in.Data(), in.Size() );
					u+="\xD\xA";
				}

				s+=u;
			}
			else
			{
				s = "";
				delete GetUrl;
				break;
			}

			delete GetUrl;
		}
	}

	return s;
}

/** */
void DCServerList::ParsePublicHubList( QString s )
{
	QString line;
	QString s1,s2,s3,s4;
	int i=0,i1=0;

	if ( s == "" )
	{
		return;
	}

	while( (i = s.find(0x0d,i)) != -1 )
	{
		line = s.mid(i1,i-i1);

		if ( line != "" )
		{
			s1 = line.section( "|", 0, 0 );
			s2 = line.section( "|", 1, 1 );
			s3 = line.section( "|", 2, 2 );
			s4 = line.section( "|", 3, 3 );

			if ( s1.isEmpty() ) s1 = QString::null;
			if ( s2.isEmpty() ) s2 = QString::null;
			if ( s3.isEmpty() ) s3 = QString::null;
			if ( s4.isEmpty() ) s4 = QString::null;

			Config->AddPublicHub( s1.ascii(), s2.ascii(), s3.ascii(), s4.ascii() );
		}

		i1 = i+2;
		i += 2;
	}
}

/** */
void DCServerList::ShowPublicHubList()
{
	DCConfigHubItem * hubitem;
	CList<DCConfigHubItem> PublicHubList;

	LineEdit_SERVERCOUNT->setText("");

	ListView_PUBLIC->setUpdatesEnabled(FALSE);
	ListView_PUBLIC->clear();

	Config->GetPublicHubList(&PublicHubList);

	hubitem = 0;

	while( (hubitem=PublicHubList.Next(hubitem)) != 0 )
	{
		DC_QListViewItem *item = new DC_QListViewItem(ListView_PUBLIC);
		item->myvalue = hubitem->sUserCount.asULL();
		item->mycol = 3;

		item->setText(0,hubitem->sName.Data());
		item->setText(1,hubitem->sHost.Data());
		item->setText(2,hubitem->sDescription.Data());
		item->setText(3,hubitem->sUserCount.Data());
	}

	LineEdit_SERVERCOUNT->setText(QString().setNum(ListView_PUBLIC->childCount()));

	ListView_PUBLIC->setUpdatesEnabled(TRUE);
	ListView_PUBLIC->triggerUpdate();
}

/** */
void DCServerList::slotReloadPublicHubList()
{
	CString s;

	s = GetPublicHubList();

	if ( s != "" )
	{
		Config->ClearPublicHubList();
		ParsePublicHubList(s.Data());
		ShowPublicHubList();

		// store the list
		if ( Config->GetHubListStoreLocal() == TRUE )
			Config->SaveDCHub();
	}
}

/** update public hub list */
void DCServerList::slotUpdatePublicHubList()
{
	CString s;

	s = GetPublicHubList();

	if ( s != "" )
	{
		ParsePublicHubList(s.Data());
		ShowPublicHubList();

		// store the list
		if ( Config->GetHubListStoreLocal() == TRUE )
			Config->SaveDCHub();
	}
}

/** */
void DCServerList::slotDoubleClicked( QListViewItem * item )
{
	if ( item )
		Connect( item->text(0), item->text(1) );
}

/** */
void DCServerList::slotConnect()
{
	Connect( "", LineEdit_SERVER->text() );
}

/** */
void DCServerList::Connect( QString hubname, QString server )
{
	QString addr;
	int port,i;

	DCClient * client;

	if ( server == "" )
	{
		return;
	}

	if ( hubname == "" )
	{
		hubname = server;
	}

	Thread.Lock();

	client = 0;

	while( (client=(DCClient*)pClientList->Next((CClient*)client)) != 0 )
	{
		if( client->GetHubName().Data() == hubname )
		{
			client->setFocus();
			Thread.UnLock();
			return;
		}
	}

	client = new DCClient(pWorkspace,0,WDestructiveClose);

	client->SetHubName(hubname.ascii());
	client->setCaption(hubname.ascii());

	client->installEventFilter(this);
	pClientList->Add(client);

	Thread.UnLock();

	if ( pWorkspace->windowList().isEmpty() ) // show the very first window in maximized mode
		client->showMaximized();
	else
		client->show();

	client->SetNick(Config->GetNick());
	client->SetComment(Config->GetDescription());
	client->SetConnectionType(Config->GetSpeed());
	client->SetEMail(Config->GetEMail());
	client->SetVersion(QString(QString("DCGUI-") + VERSION).ascii());
	client->SetShareSize(CString().setNum(Config->GetShareSize()));
	client->SetMode(Config->GetMode());
	client->SetAwayMode(Config->GetAwayMode());

	if ( (i=server.find(':')) != -1 )
	{
		addr = server.left(i);
		port = atoi(server.mid(i+1,server.length()-i-1));
		client->Connect(addr.ascii(),port);
	}
	else
	{
		client->Connect(server.ascii());
	}
}

/** */
void DCServerList::slotRightButtonClickedBookmarkList( QListViewItem * item, const QPoint &, int )
{
	int id;
	QPopupMenu *m;
	DCDialogEditServer * des;
	QListViewItem *item1;

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiADD );
	DCMenuHandler::InsertMenuItem( m, emiEDIT, (item != 0) );
	DCMenuHandler::InsertMenuItem( m, emiREMOVE, (item != 0) );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiCONNECT, (item != 0) );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiUPDATE_SERVER, (item != 0) );
	DCMenuHandler::InsertMenuItem( m, emiUPDATE_ALL_SERVER, FALSE );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( id == emiADD )
	{
		des = new DCDialogEditServer();
		des->setCaption(tr("Add Bookmark"));

		if ( des->exec() == QDialog::Accepted )
		{
			AddBookmark( des->LineEdit_NAME->text(), des->LineEdit_HOST->text(), des->LineEdit_DESCRIPTION->text() );
		}

		delete des;
	}
	else if ( id == emiEDIT )
	{
		des = new DCDialogEditServer();
		des->setCaption(tr("Edit Bookmark"));

		des->LineEdit_NAME->setText(item->text(0));
		des->LineEdit_HOST->setText(item->text(1));
		des->LineEdit_DESCRIPTION->setText(item->text(2));

		if ( des->exec() == QDialog::Accepted  )
		{
			// quick & dirty ...
			DelBookmark( item->text(0), item->text(1), item->text(2) );
			ListView_BOOKMARKS->takeItem(item);
			delete item;
			AddBookmark( des->LineEdit_NAME->text(), des->LineEdit_HOST->text(), des->LineEdit_DESCRIPTION->text() );
		}

		delete des;
	}
	else if ( id == emiREMOVE )
	{
		DelBookmark( item->text(0), item->text(1), item->text(2) );
		ListView_BOOKMARKS->takeItem(item);
	}
	else if ( id == emiCONNECT )
	{
		Connect( item->text(0), item->text(1) );
	}
	else if ( id == emiUPDATE_SERVER )
	{
		item1 = ListView_PUBLIC->findItem( item->text(0), 0 );

		if ( item1 )
		{
			UpdateBookmark( item->text(0), item1->text(1), item1->text(2) );
			item->setText(1,item1->text(1));
			item->setText(2,item1->text(2));
		}
	}
	else if ( id == emiUPDATE_ALL_SERVER )
	{
	}
}

/** */
void DCServerList::DelBookmark( QString name, QString host, QString description )
{
	if ( Config->RemoveBookmarkHub( name.ascii(), host.ascii(), description.ascii() ) == TRUE )
	{
		Config->SaveDCHub();
	}
}

/** */
void DCServerList::AddBookmark( QString name, QString host, QString description )
{
	if ( Config->AddBookmarkHub( name.ascii(), host.ascii(), description.ascii() ) == TRUE )
	{
		new QListViewItem( ListView_BOOKMARKS, name, host, description );

		Config->SaveDCHub();
	}
}

/** */
void DCServerList::UpdateBookmark( QString name, QString host, QString description )
{
	if ( Config->UpdateBookmarkHub( name.ascii(), host.ascii(), description.ascii() ) == TRUE )
	{
		Config->SaveDCHub();
	}
}

/** */
void DCServerList::slotRightButtonClickedPublicList( QListViewItem * item, const QPoint &, int )
{
	int id;
	QPopupMenu *m;

	if( item == 0 )
	{
		return;
	}

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiCONNECT );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiADD_BOOKMARK );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( id == emiCONNECT )
	{
		Connect( item->text(0), item->text(1) );
	}
	else if ( id == emiADD_BOOKMARK )
	{
		AddBookmark( item->text(0), item->text(1), item->text(2) );
	}
}
