/***************************************************************************
                          dcoptions.cpp  -  description
                             -------------------
    begin                : Sun Feb 24 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qstylefactory.h>
#include <qapplication.h>
#include <qlistview.h>
#include <qinputdialog.h>
#include <qfontdialog.h>
#include <qlayout.h>
#include <qsound.h>

#include <dclib/cbytearray.h>
#include <dclib/cstring.h>
#include <dclib/che3.h>
#include <dclib/csocket.h>

#include <dcbrowsefiletree.h>
#include <dcconfig.h>
#include <dcfiletool.h>
#include "dcoptions.h"

/** */
DCOptions::DCOptions()
{
	InitDocument();
}

/** */
DCOptions::~DCOptions()
{
}

/** */
void DCOptions::InitDocument()
{
	connect( PushButton_BROWSECHATSOUNDFILE, SIGNAL(clicked()), this, SLOT(slotBrowseChatSoundFile()) );
	connect( PushButton_BROWSEDOWNLOADFOLDER, SIGNAL(clicked()), this, SLOT(slotBrowseDownloadFolder()) );
	connect( PushButton_BROWSEFILELIST, SIGNAL(clicked()), this, SLOT(slotBrowseFileList()) );
	connect( PushButton_ADDSHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotAddSharedFolder()) );
	connect( PushButton_CREATESHARELIST, SIGNAL(clicked()), this, SLOT(slotCreateShareList()) );
	connect( PushButton_SHARELISTINFO, SIGNAL(clicked()), this, SLOT(slotShareListInfo()) );
	connect( PushButton_REMOVESHAREDFOLDER, SIGNAL(clicked()), this, SLOT(slotRemoveSharedFolder()) );
	connect( PushButton_SAVE, SIGNAL(clicked()), this, SLOT(slotSave()) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()) );
	connect( PushButton_TESTINTERFACE, SIGNAL(clicked()), this, SLOT(slotTestInterface()) );
	connect( PushButton_SETTHEME, SIGNAL(clicked()), this, SLOT(slotSetTheme()) );
	connect( PushButton_BROWSELANGUAGEFILE, SIGNAL(clicked()), this, SLOT(slotBrowseLanguageFile()) );

	connect( RadioButton_ACTIVEMODE, SIGNAL(toggled(bool)), this, SLOT(slotModeActiveChange(bool)) );
	connect( RadioButton_PASSIVEMODE, SIGNAL(toggled(bool)), this, SLOT(slotModePassiveChange(bool)) );
	connect( RadioButton_WRONGIP, SIGNAL(toggled(bool)), this, SLOT(slotWrongIPChange(bool)) );
	connect( RadioButton_INTERFACEIP, SIGNAL(toggled(bool)), this, SLOT(slotInterfaceIPChange(bool)) );

	connect( PushButton_ADDHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotAddHubListUrl()) );
	connect( PushButton_REMOVEHUBLISTURL, SIGNAL(clicked()), this, SLOT(slotRemoveHubListUrl()) );

	connect( PushButton_BROWSEAPPFONT, SIGNAL(clicked()), this, SLOT(slotBrowseAppFont()) );

	// style options
	QStringList list = QStyleFactory::keys();
	list.sort();
	ComboBox_THEME->clear();
	ComboBox_THEME->insertStringList(list);
}

/** */
void DCOptions::slotSave()
{
	int i;
	bool ok;

	// check if mode change
	if ( ((RadioButton_ACTIVEMODE->isOn() == TRUE) && (Config->GetMode() == ecmPassive)) ||
	     ((RadioButton_ACTIVEMODE->isOn() == FALSE) && (Config->GetMode() == ecmActive)) )
	{
		QMessageBox::warning( 0, "DC-GUI",
			QString(tr("You change the client mode ! Please restart DCGUI !")));
	}

	// check active mode settings
	if ( RadioButton_ACTIVEMODE->isOn() == TRUE )
	{
		// check fake host
		if ( (RadioButton_WRONGIP->isOn() == TRUE) &&
	     	     (LineEdit_FAKEHOST->text() == "") )

		{
			QMessageBox::critical( 0, "DC-GUI",
			QString(tr("You must enter a valid 'Fake Host' !")));
			return;
		}

		// check interface
		if ( (RadioButton_INTERFACEIP->isOn() == TRUE) &&
	     	     (LineEdit_INTERFACE->text() == "") )

		{
			QMessageBox::critical( 0, "DC-GUI",
			QString(tr("You must enter a valid interface !")));
			return;
		}

		// check ports
		i = LineEdit_TCPLISTENPORT->text().toInt(&ok);

		if ( (ok == FALSE) || (i == 0) )
		{
			QMessageBox::critical( 0, "DC-GUI",
			QString(tr("You must enter a valid tcp listen port !")));
			return;
		}

		i = LineEdit_UDPLISTENPORT->text().toInt(&ok);

		if ( (ok == FALSE) || (i == 0) )
		{
			QMessageBox::critical( 0, "DC-GUI",
			QString(tr("You must enter a valid udp listen port !")));
			return;
		}

	}

	// no nick is given
	if ( LineEdit_NICK->text() == "" )
	{
		QMessageBox::critical( 0, "DC-GUI",
		QString(tr("You must enter a valid nick !")));
		return;
	}

	if (LineEdit_APPFONT->text() != "")
	{
		QFont font;
		if (font.fromString(LineEdit_APPFONT->text()) == TRUE)
		{
			QApplication::setFont(font, TRUE);
		}
	}

	accept();
}

/** */
void DCOptions::slotWrongIPChange( bool b )
{
	GroupBox_WRONGIP->setEnabled(b);
	GroupBox_INTERFACEIP->setEnabled(!b);
}

/** */
void DCOptions::slotInterfaceIPChange( bool b )
{
	GroupBox_WRONGIP->setEnabled(!b);
	GroupBox_INTERFACEIP->setEnabled(b);
}

/** */
void DCOptions::slotModeActiveChange(bool b)
{
	ButtonGroup_ACTIVEMODESETTINGS->setEnabled(b);
	ButtonGroup_PASSIVEMODESETTINGS->setEnabled(!b);
}

/** */
void DCOptions::slotModePassiveChange(bool b)
{
	ButtonGroup_ACTIVEMODESETTINGS->setEnabled(!b);
	ButtonGroup_PASSIVEMODESETTINGS->setEnabled(b);
}

/** */
void DCOptions::slotTestInterface()
{
	QString sip;
	CSocket Socket;

	sip = Socket.GetInterfaceIP(LineEdit_INTERFACE->text().ascii()).Data();

	if ( sip != "" )
	{
		QMessageBox::information( 0, "DC-GUI", QString(tr("Interface IP : "))+sip);
	}
	else
	{
		QMessageBox::critical( 0, "DC-GUI", QString(tr("Can't get interface IP !")));
	}
}

/** */
void DCOptions::slotBrowseChatSoundFile()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "wav (*.wav)", this, "blf", tr("Select sound file") );

	if( file != "" )
	{
		QSound::play(file);
		LineEdit_CHATSOUNDFILE->setText(file);
	}
}

/** */
void DCOptions::slotBrowseDownloadFolder()
{
	QString dir;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select download folder"), TRUE );

	if(dir!="")
	{
		LineEdit_DOWNLOADFOLDER->setText(dir);
	}
}

/** */
void DCOptions::slotBrowseFileList()
{
	DCBrowseFileTree *bft;
	CHE3 *he3=0;
	CByteArray ba;
	CString * s=0;

	if ( Config->GetShareBuffer( &ba ) == 0 )
	{
		he3 = new CHE3();
		s = he3->decode_he3_data(&ba);
		delete he3;

		if ( s != 0 )
		{
			QDialog *d = new QDialog(this);
			QGridLayout *Layout = new QGridLayout( d, 1, 1, 4, 4, "Layout"); 
			bft = new DCBrowseFileTree( d, "browsefiletree", 0, TRUE );
			Layout->addWidget( bft, 0, 0 );

			// set transfer
			d->setCaption( tr("My") + " - Filebrowser" );
			bft->InitTree("","","",s->Data());
			bft->layout()->setSpacing( 4 );
			bft->layout()->setMargin( 4 );
			d->exec();
			delete d;

			delete s;
		}
	}	
}

/** */
void DCOptions::slotAddSharedFolder()
{
	QString dir;

	dir = QFileDialog::getExistingDirectory ( "", this, "bdf", tr("Select share folder"), TRUE );

	if( dir != "" )
	{
		if ( ListBox_SHAREDFOLDERS->findItem(dir) == 0 )
		{
			ListBox_SHAREDFOLDERS->insertItem(dir);
		}
	}
}

/** */
void DCOptions::slotRemoveSharedFolder()
{
	int i;

	i = ListBox_SHAREDFOLDERS->currentItem();

	if ( i != -1 )
	{
		ListBox_SHAREDFOLDERS->removeItem(i);
	}
}

/** */
void DCOptions::SetValues()
{
	int i;
	CList<CString> list;
	CString *s;

	LineEdit_NICK->setText(Config->GetNick().Data());
	LineEdit_DESCRIPTION->setText(Config->GetDescription().Data());
	LineEdit_EMAIL->setText(Config->GetEMail(TRUE).Data());
	CheckBox_ANTISPAM->setChecked(Config->GetAntiSpam());

	for(i=0;i<ComboBox_SPEED->count();i++)
	{
		if ( ComboBox_SPEED->text(i) == Config->GetSpeed() )
		{
			ComboBox_SPEED->setCurrentItem(i);
			break;
		}
	}

	LineEdit_DOWNLOADFOLDER->setText(Config->GetDownloadFolder().Data());

	// save shared folders
	ListBox_SHAREDFOLDERS->clear();

	Config->GetSharedFolders(&list);

	s = 0;
	while( (s=list.Next(s)) != 0 )	
	{
		ListBox_SHAREDFOLDERS->insertItem((*s).Data());
	}

	SpinBox_MAXSIMULTANEOUSUPLOADS->setValue( Config->GetMaxUpload() );
	SpinBox_TRANSFERRATELIMIT->setValue( Config->GetMaxTransferrate() );

	LineEdit_TCPLISTENPORT->setText( QString().setNum(Config->GetTCPListenPort()) );
	LineEdit_UDPLISTENPORT->setText( QString().setNum(Config->GetUDPListenPort()) );

	if ( Config->GetFakeHost() == 1 )
	{
		RadioButton_WRONGIP->setChecked(TRUE);
		slotWrongIPChange(TRUE);
	}
	else
	{
		RadioButton_INTERFACEIP->setChecked(TRUE);
		slotWrongIPChange(FALSE);
	}

	if ( Config->GetMode() == ecmPassive )
	{
		RadioButton_PASSIVEMODE->setChecked(TRUE);
		slotModeActiveChange(FALSE);
	}
	else
	{
		RadioButton_ACTIVEMODE->setChecked(TRUE);
		slotModeActiveChange(TRUE);
	}

	LineEdit_FAKEHOST->setText(Config->GetHost().Data());
	LineEdit_INTERFACE->setText(Config->GetInterface().Data());

	// gui settings
	CheckBox_OPENPRIVATECHATWINDOW->setChecked(Config->GetOpenPrivateChatWindow());

	switch(Config->GetUnit())
	{
		case euBYTE:
			RadioButton_UNITBYTE->setChecked(TRUE);
			break;
		case euKBYTE:
			RadioButton_UNITKBYTE->setChecked(TRUE);
			break;
		case euMBYTE:
			RadioButton_UNITMBYTE->setChecked(TRUE);
			break;
		case euGBYTE:
			RadioButton_UNITGBYTE->setChecked(TRUE);
			break;
		default:
			RadioButton_UNITAUTO->setChecked(TRUE);
			break;
	}

	for(i=0;i<ComboBox_THEME->count();i++)
	{
		if ( Config->GetTheme() == CString(ComboBox_THEME->text(i).ascii()) )
		{
			ComboBox_THEME->setCurrentItem(i);
			break;
		}
	}
	
	LineEdit_LANGUAGEFILE->setText( Config->GetLanguageFile().Data() );

	LineEdit_CHATSOUNDFILE->setText( Config->GetChatSoundFile().Data() );
	CheckBox_ENABLESOUND->setChecked(Config->GetSoundEnabled());
	CheckBox_EXTERNALPLAYER->setChecked(Config->GetExternalSoundPlayer());
	LineEdit_EXTERNALPLAYER->setText( Config->GetExternalPlayer().Data() );
	LineEdit_CHATSOUNDFILE->setText( Config->GetChatSoundFile().Data() );

	LineEdit_APPFONT->setText( Config->GetAppFont().Data() );

	// other settings
	CheckBox_HUBLISTSTORELOCAL->setChecked(Config->GetHubListStoreLocal());
	SpinBox_RECONNECTCOUNT->setValue(Config->GetReconnectCount());
	SpinBox_RECONNECTTIMEOUT->setValue(Config->GetReconnectTimeout());
	SpinBox_TRANSFERRESENDTIMEOUT->setValue(Config->GetTransferResendTimeout());
	SpinBox_TRANSFERRESPONSETIMEOUT->setValue(Config->GetTransferResponseTimeout());
	CheckBox_FORCEMOVEENABLED->setChecked(Config->GetForceMoveEnabled());

	CList<DCConfigHubListUrl> hublisturllist;
	Config->GetHubListUrlList(&hublisturllist);

	DCConfigHubListUrl * hublisturl = 0;

	while( (hublisturl=hublisturllist.Next(hublisturl)) != 0 )
	{
		QCheckListItem * cli = new QCheckListItem( ListView_HUBLISTURL, hublisturl->sUrl.Data(), QCheckListItem::CheckBox );
		cli->setOn(hublisturl->bEnabled);
	}
}

/** */
void DCOptions::GetValues()
{
	bool ok;
	unsigned int i;
	CList<CString> sharedfolders;

	Config->SetNick(LineEdit_NICK->text().ascii());
	Config->SetDescription(LineEdit_DESCRIPTION->text().ascii());
	Config->SetEMail(LineEdit_EMAIL->text().ascii());
	Config->SetAntiSpam(CheckBox_ANTISPAM->isChecked());

	Config->SetSpeed(ComboBox_SPEED->currentText().ascii());
	Config->SetDownloadFolder(LineEdit_DOWNLOADFOLDER->text().ascii());

	sharedfolders.Clear();

	for(i=0;i<ListBox_SHAREDFOLDERS->count();i++)
	{
		sharedfolders.Add( new CString(ListBox_SHAREDFOLDERS->text(i).ascii()) );
	}

	Config->SetSharedFolders( &sharedfolders );

	Config->SetMaxUpload( SpinBox_MAXSIMULTANEOUSUPLOADS->value() );
	Config->SetMaxTransferrate( SpinBox_TRANSFERRATELIMIT->value() );

	Config->SetTCPListenPort(LineEdit_TCPLISTENPORT->text().toInt(&ok));
	Config->SetUDPListenPort(LineEdit_UDPLISTENPORT->text().toInt(&ok));
	Config->SetFakeHost(RadioButton_WRONGIP->isOn());

	if ( RadioButton_ACTIVEMODE->isOn() )
		Config->SetMode(ecmActive);
	else
		Config->SetMode(ecmPassive);

	Config->SetHost(LineEdit_FAKEHOST->text().ascii());
	Config->SetInterface(LineEdit_INTERFACE->text().ascii());

	// gui settings
	Config->SetOpenPrivateChatWindow(CheckBox_OPENPRIVATECHATWINDOW->isChecked());

	if ( RadioButton_UNITBYTE->isChecked() )
		Config->SetUnit(euBYTE);
	else if ( RadioButton_UNITKBYTE->isChecked() )
		Config->SetUnit(euKBYTE);
	else if ( RadioButton_UNITMBYTE->isChecked() )
		Config->SetUnit(euMBYTE);
	else if ( RadioButton_UNITGBYTE->isChecked() )
		Config->SetUnit(euGBYTE);
	else
		Config->SetUnit(euAUTO);
	
	Config->SetTheme(ComboBox_THEME->currentText().ascii());
	Config->SetLanguageFile(LineEdit_LANGUAGEFILE->text().ascii());
	Config->SetSoundEnabled(CheckBox_ENABLESOUND->isChecked());
	Config->SetExternalSoundPlayer(CheckBox_EXTERNALPLAYER->isChecked());
	Config->SetExternalPlayer(LineEdit_EXTERNALPLAYER->text().ascii());
	Config->SetChatSoundFile(LineEdit_CHATSOUNDFILE->text().ascii());
	Config->SetAppFont(LineEdit_APPFONT->text().ascii());

	// other settings
	Config->SetHubListStoreLocal(CheckBox_HUBLISTSTORELOCAL->isChecked());
	Config->SetReconnectCount( SpinBox_RECONNECTCOUNT->value() );
	Config->SetReconnectTimeout( SpinBox_RECONNECTTIMEOUT->value() );
	Config->SetTransferResendTimeout(SpinBox_TRANSFERRESENDTIMEOUT->value());
	Config->SetTransferResponseTimeout(SpinBox_TRANSFERRESPONSETIMEOUT->value());
	Config->SetForceMoveEnabled(CheckBox_FORCEMOVEENABLED->isChecked());

	CList<DCConfigHubListUrl> hublisturllist;

	QCheckListItem * cli = (QCheckListItem*)ListView_HUBLISTURL->firstChild();

	while(cli)
	{
		DCConfigHubListUrl * hublisturl = new DCConfigHubListUrl();

		hublisturl->sUrl     = cli->text(0);
		hublisturl->bEnabled = cli->isOn();

		hublisturllist.Add(hublisturl);

		cli = (QCheckListItem*)cli->nextSibling();
	}

	Config->SetHubListUrlList(&hublisturllist);
}

/** */
void DCOptions::slotCreateShareList()
{
        unsigned int i;
	CList<CString> sharedfolders;

	// save shared folders
	sharedfolders.Clear();

	for(i=0;i<ListBox_SHAREDFOLDERS->count();i++)
	{
		sharedfolders.Add( new CString(ListBox_SHAREDFOLDERS->text(i).ascii()) );
	}

	Config->SetSharedFolders( &sharedfolders );

	Config->CreateShareList();
}

/** */
void DCOptions::slotShareListInfo()
{
	QString s;

	if ( Config->GetShareSize() == 0 )
	{
		s = tr("Share list not available");
	}
	else
	{
		s = tr("Compressed list size: ") +
			QString().setNum(Config->GetShareBufferSize()) + " " +
			tr("bytes") + "\n" +
			tr("Total shared: ") +
			DCFileTool::GetSizeString(Config->GetShareSize()).Data();
	}

	QMessageBox::information( this, tr("Share List Info"), s );
}

/** */
void DCOptions::slotSetTheme()
{
	QString s;

	s = ComboBox_THEME->currentText();

	if ( s != "" )
	{
		QApplication::setStyle(s);
	}
}

/** */
void DCOptions::slotBrowseLanguageFile()
{
	QString file;

	file = QFileDialog::getOpenFileName( "", "Language File (*.qm)", this, "blf", tr("Select language file") );

	if( file != "" )
	{
		LineEdit_LANGUAGEFILE->setText(file);
	}
}

void DCOptions::slotBrowseAppFont()
{
  bool ok;
  QFont font = QFontDialog::getFont(&ok, QApplication::font(), this);
  if (ok == TRUE)
  {
	LineEdit_APPFONT->setText(font.toString());
  }
}

/** */
void DCOptions::slotAddHubListUrl()
{
	bool ok = FALSE;
	QString url;

	url = QInputDialog::getText(
		tr("HubList URL"),
		tr("Please enter a url"),
		QLineEdit::Normal, QString::null, &ok, this );

	if (ok)
	{
		new QCheckListItem( ListView_HUBLISTURL, url, QCheckListItem::CheckBox );
	}
}

/** */
void DCOptions::slotRemoveHubListUrl()
{
	QListViewItem * item = ListView_HUBLISTURL->currentItem();

	if (item)
	{
		ListView_HUBLISTURL->takeItem(item);
		delete item;
	}
}
