/***************************************************************************
                          dchubsearch.h  -  description
                             -------------------
    begin                : Fri Mar 15 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBSEARCH_H
#define DCHUBSEARCH_H

#include <dclib/dcos.h>

#include <qtimer.h>
#include <qworkspace.h>

#include <DCDialogHubSearch.h>
#include <dclib/cclient.h>
#include <dclib/chubsearch.h>

/**
  *@author Mathias Kster
  */

class QStringList;

typedef enum eHubSearchType {
	ehstNONE,
	ehstLOCAL,
	ehstGLOBAL,
	ehstWAITTIMEOUT,
	ehstSTOP
} eHubSearchType;

class sHubSearchClient : public CObject {
public:
	/** */
	CClient * Client;
	/** */
	bool bRemove;
	/** */
	time_t timeHubTimeout;
};

class DCHubSearch : public DCDialogHubSearch, public CHubSearch  {
Q_OBJECT
public:
	/** */
	DCHubSearch(QWidget* parent, const char *name, int wflags);
	/** */
	virtual ~DCHubSearch();

	/** */
	void InitDocument();

	/** search result */
	bool DC_SearchResult( CMessageSearchResult * MessageSearchResult );
	/** create new client connection */
	void NewClient();
	/** mark client as removeable */
	void RemoveClient( CClient * Client );
	/** get the search string with protocol */
	QString GetSearchString();
	/** show all search results */
	void ShowResults( bool bClearList );

	/** */
	void SetSearchView( bool enabled );

	/** callback function */
	virtual int DC_CallBack( CObject * Object );
	/** */
	static int DC_ClientCallBack( CClient * Client, CObject * Object );

	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	QStringList *pHubServerList;
	/** */
	QStringList *pLogStringList;
	/** store all messages from udp socket */
	CList<CObject> * pMessageList;
	/** store clients */
	CList<CObject> * pHubSearchClientList;
	/** */
	CThread HubSearchClientListThread;
	/** */
	CThread ClientThread;
	/** */
	CThread SocketCallbackThread;
	/** */
	CThread LogThread;
	/** */
	QWorkspace *pWorkspace;
	/** */
	QTimer Timer;
	/** */
	unsigned int iCurrentHubServer;
	/** */
	int iMaxThreads;
	/** */
	QString sSearchString;
	/** */
	eHubSearchType ehSearchType;

	/** */
	void AddLog( QString line );
	/** */
	void ShowLog();
	/** */
	void CheckClient();

private slots:
	/** */
	void timerDone();
	/** */
	void slotSearchReturnPressed();
	/** */
	void slotClickedStop();
	/** */
	void slotDoubleClickedSearchResult(QListViewItem*item);
	/** */
	void slotRightButtonClickedSearchResult( QListViewItem *, const QPoint &, int );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange(QWidget*);
};

/** */
extern DCHubSearch * pHubSearch;

#endif
