/***************************************************************************
                          dcgui.h  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCGUI_H
#define DCGUI_H

#include <dclib/dcos.h>

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qworkspace.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h>
//#include <qaccel.h>
#include <qtoolbutton.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qstring.h>
#include <qpixmap.h>


// forward declaration of the DCGui classes
class DCGuiView;
class QDockWindow;

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class DCGuiView is
  * created which creates your view.
  * 	
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.3 code generation
  */
class DCGuiApp : public QMainWindow
{
Q_OBJECT
  
public:
	/** construtor */
	DCGuiApp();
	/** destructor */
	virtual ~DCGuiApp();

	/** */
	void ShowOptionsDialog() { slotFileOptions(); };

protected:
	/** overloaded for Message box on last window exit */
	bool queryExit();
	/** event filter to catch close events for MDI child windows and is installed in createClient() on every child window.
	 * Closing a window calls the eventFilter first which removes the view from the connected documents' view list. If the
	 * last view is going to be closed, the eventFilter() tests if the document is modified; if yes, it asks the user to
	 * save the document. If the document title contains "Untitled", slotFileSaveAs() gets called to get a save name and path.
	 */
	virtual bool eventFilter(QObject* object, QEvent* event);

private slots:

	/** */
	void slotFileOptions();
	/** exits the application */
	void slotFileQuit();

	/** toggle the toolbar*/
	void slotViewToolBar(bool toggle);
	/** toggle the statusbar*/
	void slotViewStatusBar(bool toggle);
	/** shows an about dlg*/
	void slotHelpAbout();
	/** check for new versions */
	void slotHelpNewVersion();
	/** change the status message of the whole statusbar temporary */
	void slotStatusHelpMsg(const QString &text);
	/** gets called when the window menu is activated; recreates the window menu with all opened window titles. */
	void windowMenuAboutToShow();
	/** activates the MDI child widget when it gets selected from the window menu. */
	void windowMenuActivated( int id );

	/** show/hide transfer list window */
	void slotActionTransferList();
	/** show/hide server list window */
	void slotActionServerList();
	/** show/hide hub search window */
	void slotActionHubSearch();
	/** change user away mode */
	void slotChangeAwayMode();

private:
	/** */
	void SetTheme();

	/** initializes all QActions of the application */
	void initActions();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** this creates the toolbars. Change the toobar look and add new toolbars in this
	  * function */
	void initToolBar();
	/** setup the statusbar */
	void initStatusBar();
	/** setup the mainview*/
	void initView();

	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu *pFileMenu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu *pViewMenu;
	/** view_menu contains all items of the menubar entry "Help" */
	QPopupMenu *pHelpMenu;
	/** the window menu */
	QPopupMenu *pWindowMenu;

	/** action */
	QPopupMenu *pActionMenu;
	/** away mode */
	QPopupMenu *pAwayMenu;

	QToolBar *fileToolbar;

	/** pWorkspace is the MDI frame widget that handles MDI child widgets. Inititalized in
	* initView()
	*/
	QWorkspace *pWorkspace;

	QAction *fileOptions;
	QAction *fileQuit;

	QAction *viewToolBar;
	QAction *viewStatusBar;

	QActionGroup *windowAction;

	QAction *windowTile;
	QAction *windowCascade;

	QAction *actionServerList;
	QAction *actionTransferList;
	QAction *actionHubSearch;

	QAction *actionAwayModeNormal;
	QAction *actionAwayModeAway;

	QAction *helpAboutApp;
	QAction *helpNewVersionApp;

	QDockWindow * pTransferViewDock;
};
#endif

