/***************************************************************************
                          dcgui.cpp  -  description
                             -------------------
    begin                : Mon Okt  1 19:59:45 CEST 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qvbox.h>
#include <qaccel.h>

// application specific includes
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include "dcgui.h"
#include "dcoptions.h"
#include "dcserverlist.h"
#include "dctransferview.h"
#include "dcconfig.h"
#include "dchubsearch.h"
#include "dcgeturl.h"

DCGuiApp::DCGuiApp()
{
	int width,height;

	pTransferView = 0;
	pServerList   = 0;
	pHubSearch    = 0;

	setCaption(tr("DCGui " VERSION ) );

	///////////////////////////////////////////////////////////////////
	// call inits to invoke all other construction parts
	initView();
	initActions();
	initMenuBar();
	initToolBar();
	initStatusBar();

	Config->GetAppGeometry( width, height );
	resize( width, height );

	viewToolBar->setOn(true);
	viewStatusBar->setOn(true);

	SetTheme();
}

DCGuiApp::~DCGuiApp()
{
	if (pHubSearch)
	{
		pHubSearch->removeEventFilter(this);
		delete pHubSearch;
		pHubSearch = 0;
	}
/*	if (pTransferViewDock)
	{
		pTransferViewDock->removeEventFilter(this);
		delete pTransferViewDock;
		pTransferViewDock = 0;
	}
*/
	if (pTransferView)
	{
		pTransferView->removeEventFilter(this);
		delete pTransferView;
		pTransferView = 0;
	}
	if (pServerList)
	{
		pServerList->removeEventFilter(this);
		delete pServerList;
		pServerList = 0;
	}
}

void DCGuiApp::initActions()
{
	fileOptions = new QAction(tr("Options"), tr("&Options"), QAccel::stringToKey(tr("Ctrl+O")), this);
	fileOptions->setStatusTip(tr("Open option dialog"));
	fileOptions->setWhatsThis(tr(""));
	connect(fileOptions, SIGNAL(activated()), this, SLOT(slotFileOptions()));

	fileQuit = new QAction(tr("Exit"), tr("E&xit"), QAccel::stringToKey(tr("Ctrl+Q")), this);
	fileQuit->setStatusTip(tr("Quits the application"));
	fileQuit->setWhatsThis(tr("Exit\n\nQuits the application"));
	connect(fileQuit, SIGNAL(activated()), this, SLOT(slotFileQuit()));

	viewToolBar = new QAction(tr("Toolbar"), tr("Tool&bar"), 0, this, 0, true);
	viewToolBar->setStatusTip(tr("Enables/disables the toolbar"));
	viewToolBar->setWhatsThis(tr("Toolbar\n\nEnables/disables the toolbar"));
	connect(viewToolBar, SIGNAL(toggled(bool)), this, SLOT(slotViewToolBar(bool)));

	viewStatusBar = new QAction(tr("Statusbar"), tr("&Statusbar"), 0, this, 0, true);
	viewStatusBar->setStatusTip(tr("Enables/disables the statusbar"));
	viewStatusBar->setWhatsThis(tr("Statusbar\n\nEnables/disables the statusbar"));
	connect(viewStatusBar, SIGNAL(toggled(bool)), this, SLOT(slotViewStatusBar(bool)));

	windowCascade = new QAction(tr("Cascade"), tr("&Cascade"), 0, this);
	windowCascade->setStatusTip(tr("Cascades all windows"));
	windowCascade->setWhatsThis(tr("Cascade\n\nCascades all windows"));
	connect(windowCascade, SIGNAL(activated()), pWorkspace, SLOT(cascade()));

	windowTile = new QAction(tr("Tile"), tr("&Tile"), 0, this);
	windowTile->setStatusTip(tr("Tiles all windows"));
	windowTile->setWhatsThis(tr("Tile\n\nTiles all windows"));
	connect(windowTile, SIGNAL(activated()), pWorkspace, SLOT(tile()));

	windowAction = new QActionGroup(this, 0, false);
	windowAction->insert(windowCascade);
	windowAction->insert(windowTile);

	/** server list */
	actionServerList = new QAction(tr("Server List"), tr("&Server List"), QAccel::stringToKey(tr("Ctrl+S")), this, 0, false);
	actionServerList->setStatusTip(tr("Show Server List"));
	actionServerList->setWhatsThis(tr(""));
	connect(actionServerList, SIGNAL(activated()), this, SLOT(slotActionServerList()));

	/** tranfer list */
	actionTransferList = new QAction(tr("Transfer List"), tr("&Transfer List"), QAccel::stringToKey(tr("Ctrl+T")), this, 0, false);
	actionTransferList->setStatusTip(tr("Show Transfer List"));
	actionTransferList->setWhatsThis(tr(""));
	connect(actionTransferList, SIGNAL(activated()), this, SLOT(slotActionTransferList()));

	/** hub search */
	actionHubSearch = new QAction(tr("Hub Search"), tr("&Hub Search"), QAccel::stringToKey(tr("Ctrl+H")), this, 0, false);
	actionHubSearch->setStatusTip(tr("Show Hub Search"));
	actionHubSearch->setWhatsThis(tr(""));
	connect(actionHubSearch, SIGNAL(activated()), this, SLOT(slotActionHubSearch()));

	/** away mode normal */
	actionAwayModeNormal = new QAction(tr("Normal"), tr("&Normal"), QAccel::stringToKey(tr("Ctrl+N")), this, 0, true);
	actionAwayModeNormal->setStatusTip(tr("Set away mode"));
	actionAwayModeNormal->setWhatsThis(tr(""));
	connect(actionAwayModeNormal, SIGNAL(activated()), this, SLOT(slotChangeAwayMode()));
	actionAwayModeNormal->setOn(TRUE);

	/** away mode away */
	actionAwayModeAway = new QAction(tr("Away"), tr("&Away"), QAccel::stringToKey(tr("Ctrl+A")), this, 0, true);
	actionAwayModeAway->setStatusTip(tr("Set away mode"));
	actionAwayModeAway->setWhatsThis(tr(""));
	connect(actionAwayModeAway, SIGNAL(activated()), this, SLOT(slotChangeAwayMode()));

	helpAboutApp = new QAction(tr("About"), tr("&About..."), 0, this);
	helpAboutApp->setStatusTip(tr("About the application"));
	helpAboutApp->setWhatsThis(tr("About\n\nAbout the application"));
	connect(helpAboutApp, SIGNAL(activated()), this, SLOT(slotHelpAbout()));

	helpNewVersionApp = new QAction(tr("New Version"), tr("&New Version..."), 0, this);
	helpNewVersionApp->setStatusTip(tr("Check for new version"));
	helpNewVersionApp->setWhatsThis(tr("New Version\n\nCheck for new version"));
	connect(helpNewVersionApp, SIGNAL(activated()), this, SLOT(slotHelpNewVersion()));

}

void DCGuiApp::initMenuBar()
{
	///////////////////////////////////////////////////////////////////
	// MENUBAR

	///////////////////////////////////////////////////////////////////
	// menuBar entry pFileMenu
	pFileMenu=new QPopupMenu();
	fileOptions->addTo(pFileMenu);
	pFileMenu->insertSeparator();
	fileQuit->addTo(pFileMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar entry viewMenu
	pViewMenu=new QPopupMenu();
	pViewMenu->setCheckable(true);
	viewToolBar->addTo(pViewMenu);
	viewStatusBar->addTo(pViewMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar awayMenu
	pAwayMenu=new QPopupMenu();
	actionAwayModeNormal->addTo(pAwayMenu);
	actionAwayModeAway->addTo(pAwayMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar actionMenu
	pActionMenu=new QPopupMenu();
	actionServerList->addTo(pActionMenu);
	actionTransferList->addTo(pActionMenu);
	actionHubSearch->addTo(pActionMenu);
	pActionMenu->insertSeparator();
	pActionMenu->insertItem("Away &Mode",pAwayMenu);

	///////////////////////////////////////////////////////////////////
	// menuBar entry windowMenu
	pWindowMenu = new QPopupMenu(this);
	pWindowMenu->setCheckable(true);
	connect(pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(windowMenuAboutToShow()));

	///////////////////////////////////////////////////////////////////
	// menuBar entry helpMenu
	pHelpMenu=new QPopupMenu();
	helpAboutApp->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	helpNewVersionApp->addTo(pHelpMenu);
	pHelpMenu->insertSeparator();
	pHelpMenu->insertItem(tr("What's &This"), this, SLOT(whatsThis()), SHIFT+Key_F1);

	menuBar()->insertItem(tr("&File"), pFileMenu);
	menuBar()->insertItem(tr("&View"), pViewMenu);
	menuBar()->insertItem(tr("&Action"), pActionMenu);
	menuBar()->insertItem(tr("&Window"), pWindowMenu);
	menuBar()->insertItem(tr("&Help"), pHelpMenu);
}

void DCGuiApp::initToolBar()
{
	///////////////////////////////////////////////////////////////////
	// TOOLBAR
	fileToolbar = new QToolBar(this, tr("file operations"));
//	fileToolbar->addSeparator();
	QWhatsThis::whatsThisButton(fileToolbar);
}

void DCGuiApp::initStatusBar()
{
	///////////////////////////////////////////////////////////////////
	//STATUSBAR
	statusBar()->message(tr("Ready."));
}

void DCGuiApp::initView()
{ 
	////////////////////////////////////////////////////////////////////
	// set the main widget here
	QVBox* view_back = new QVBox( this );
	view_back->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
	pWorkspace = new QWorkspace( view_back );
	setCentralWidget(view_back);

	setDockMenuEnabled(FALSE);

	// create serverlist view
	pServerList = new DCServerList(pWorkspace,0,WDestructiveClose);
	pServerList->installEventFilter(this);
	pServerList->hide();
	pServerList->setEnabled(FALSE);

	// create dock window for transfer view
	pTransferViewDock = new QDockWindow( QDockWindow::InDock, this );
	pTransferViewDock->setResizeEnabled(TRUE);
	moveDockWindow(pTransferViewDock,Qt::DockBottom);
	pTransferViewDock->hide();

	// create transfer view
	pTransferView = new DCTransferView(pTransferViewDock,0,WDestructiveClose);
	pTransferView->SetWorkspace(pWorkspace);
	pTransferView->installEventFilter(this);

	pTransferViewDock->setWidget(pTransferView);

	// create multi hub search view
	pHubSearch = new DCHubSearch(pWorkspace,0,WDestructiveClose);
	pHubSearch->installEventFilter(this);
	pHubSearch->hide();
	pHubSearch->setEnabled(FALSE);

	if ( Config->GetMode() == ecmActive )
	{
		CString error;
		if ( pTransferView->InitListen(error) == FALSE )
		{
			QString s;
			s = error.Data();

			if ( s == "" )
				s = tr("(no error message from socket)");
			else
				s = "(" + s + ")";

			QMessageBox::critical( 0, "DC-GUI",
			QString(tr("TCP listen failed, change to passive mode ! ") + s));

			Config->SetMode(ecmPassive);
		}
	}
}

bool DCGuiApp::queryExit()
{
	int exit=QMessageBox::information(this, tr("Quit..."),
				tr("Do your really want to quit?"),
				QMessageBox::Ok, QMessageBox::Cancel);

	if (exit==1)
	{
	}
	else
	{
	}

	return (exit==1);
}

bool DCGuiApp::eventFilter(QObject* object, QEvent* event)
{
	if((event->type() == QEvent::Close)&&((DCGuiApp*)object!=this))
	{
		QCloseEvent* e=(QCloseEvent*)event;

		if ( (DCTransferView*)object == pTransferView )
		{
			e->ignore();
			((DCTransferView*)object)->hide();
			((DCTransferView*)object)->setEnabled(FALSE);
		}
		else if ( (DCServerList*)object == pServerList )
		{
			e->ignore();
			((DCServerList*)object)->hide();
			((DCServerList*)object)->setEnabled(FALSE);
		}
		else if ( ((DCHubSearch*)object == pHubSearch) && (pHubSearch != 0) )
		{
			e->ignore();
			((DCHubSearch*)object)->hide();
			((DCHubSearch*)object)->setEnabled(FALSE);
		}
		else
		{
			e->accept();
		}
	}
	else if((event->type() == QEvent::Close)&&((DCGuiApp*)object==this))
	{
		slotFileQuit();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

/** */
void DCGuiApp::slotFileOptions()
{
	DCOptions * od;

	statusBar()->message(tr("Open options dialog..."));

	od = new DCOptions();

	od->SetValues();

	if ( QDialog::Accepted == od->exec() )
	{
		// move values to dcconfig
		od->GetValues();
		// save values
		Config->Save();
		// update connected servers
                pServerList->SendMyInfoToConnectedServers();
	}

	delete od;

	/** reset or set theme */
	SetTheme();

	statusBar()->message(tr("Ready."));
}

void DCGuiApp::slotFileQuit()
{ 
	statusBar()->message(tr("Exiting application..."));

	pTransferView->Shutdown();

	while( pTransferView->GetShutdownState() != 2 )
	{
		qApp->processEvents();
#ifdef WIN32
		Sleep(100);
#else
		usleep(100);
#endif
	}

	Config->SetAppGeometry( width(), height() );
	Config->SaveDCGui();

	qApp->quit();

	statusBar()->message(tr("Ready."));
}

void DCGuiApp::slotViewToolBar(bool toggle)
{
	statusBar()->message(tr("Toggle toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if (toggle== false)
	{
		fileToolbar->hide();
	}
	else
	{
		fileToolbar->show();
	};

	statusBar()->message(tr("Ready."));
}

void DCGuiApp::slotViewStatusBar(bool toggle)
{
	statusBar()->message(tr("Toggle statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off
  
	if (toggle == false)
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::slotHelpAbout()
{
	QMessageBox::about(this,tr("About..."),
                     tr("DCGui\nVersion " VERSION
                     "\n(c) 2001-2002 by Mathias Kster"
		     "\nhttp://dc.ketelhot.de"));
}

/** check for new versions */
void DCGuiApp::slotHelpNewVersion()
{
	QString release="";
	DCGetURL * d;

	d = new DCGetURL("http://dc.ketelhot.de/version.xml");

	if ( d->Get() == QDialog::Accepted )
	{
		CString s;
		CByteArray in;
		d->GetData(&in);
		s.Set((char*)in.Data(),in.Size());

		if ( s != "" )
		{
			release = Config->ParseVersion(s).Data();
		}

		if ( release == "" )
		{
			release = tr("Can't get version info from server");
		}
		else
		{
			release = tr("Current version is: ") + release;
		}

		QMessageBox::about(this,tr("New version..."),
				release );
	}

	delete d;
}

/** */
void DCGuiApp::slotStatusHelpMsg(const QString &text)
{
	///////////////////////////////////////////////////////////////////
	// change status message of whole statusbar temporary (text, msec)
	statusBar()->message(text, 2000);
}

/** change user away mode */
void DCGuiApp::slotChangeAwayMode()
{
	switch(Config->GetAwayMode())
	{
		case euamAWAY:
			if ( (actionAwayModeAway->isOn() == FALSE ) &&
			     (actionAwayModeNormal->isOn() == FALSE ) )
			{
				actionAwayModeAway->setOn(TRUE);
			}
			else
			{
				actionAwayModeAway->setOn(FALSE);
				Config->SetAwayMode(euamNORMAL);
			}
			break;
		default:
			if ( (actionAwayModeAway->isOn() == FALSE ) &&
			     (actionAwayModeNormal->isOn() == FALSE ) )
			{
				actionAwayModeNormal->setOn(TRUE);
			}
			else
			{
				actionAwayModeNormal->setOn(FALSE);
				Config->SetAwayMode(euamAWAY);
			}
			break;
	}

	pServerList->SendMyInfoToConnectedServers();
}


/** */
void DCGuiApp::windowMenuAboutToShow()
{
	int c;

	pWindowMenu->clear();	
	windowCascade->addTo(pWindowMenu);
	windowTile->addTo(pWindowMenu);
	
	if ( pWorkspace->windowList().isEmpty() )
	{
		windowAction->setEnabled(false);
	}
	else
	{
		windowAction->setEnabled(true);
	}

	pWindowMenu->insertSeparator();

	QWidgetList windows = pWorkspace->windowList();

	c = 0;

	for ( int i = 0; i < int(windows.count()); ++i )
	{
		if ( windows.at(i)->isEnabled() )
		{
			int id = pWindowMenu->insertItem(QString("&%1 ").arg(i+1)+windows.at(i)->caption(), this, SLOT( windowMenuActivated( int ) ) );
			pWindowMenu->setItemParameter( id, i );
			pWindowMenu->setItemChecked( id, pWorkspace->activeWindow() == windows.at(i) );
			c++;
		}
	}

	if ( c == 0 )
	{
		windowAction->setEnabled(false);
	}
}

/** */
void DCGuiApp::windowMenuActivated( int id )
{
	QWidget* w = pWorkspace->windowList().at( id );
	if ( w )
	{
		w->show();
		w->setFocus();
	}
}

/** show/hide transfer list window */
void DCGuiApp::slotActionTransferList()
{
	statusBar()->message(tr("Show/hide transfer list window ..."));

	if ( pTransferView->isVisible() )
	{
		pTransferViewDock->hide();
	}
	else
	{
		pTransferViewDock->show();
	}

	statusBar()->message(tr("Ready."));
}

/** show/hide server list window */
void DCGuiApp::slotActionServerList()
{
	statusBar()->message(tr("Show/hide server list window ..."));

	if ( pServerList->isVisible() )
	{
		pServerList->setEnabled(FALSE);
		pServerList->hide();
	}
	else
	{
		pServerList->setEnabled(TRUE);
		pServerList->show();
	}

	statusBar()->message(tr("Ready."));
}

/** show/hide multi hub search window */
void DCGuiApp::slotActionHubSearch()
{
	statusBar()->message(tr("Show/hide hub search window ..."));

	if ( pHubSearch != 0 )
	{
		if ( pHubSearch->isVisible() )
		{
			pHubSearch->setEnabled(FALSE);
			pHubSearch->hide();
		}
		else
		{
			pHubSearch->setEnabled(TRUE);
			pHubSearch->show();
		}
	}

	statusBar()->message(tr("Ready."));
}

/** */
void DCGuiApp::SetTheme()
{
	QApplication::setStyle( Config->GetTheme().Data() );
}
