/***************************************************************************
                          dcgeturl.cpp  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>

#include "dcgeturl.h"

DCGetURL::DCGetURL( QString sURL )
{
	qInitNetworkProtocols();

	pOp = new QUrlOperator(sURL);

	InitDocument();
}

DCGetURL::~DCGetURL()
{
	if(pOp)
		delete pOp;

	baData.SetSize(0);
}

/** */
int DCGetURL::Get()
{
	baData.SetSize(0);

	pOp->get();

	return exec();
}

/** */
void DCGetURL::GetData( CByteArray * data )
{
	if(!data)
		return;

	data->SetSize(0);
	data->Append( baData.Data(), baData.Size() );
}

/** */
void DCGetURL::InitDocument()
{
	connect( pOp, SIGNAL(data(const QByteArray &, QNetworkOperation *)), this, SLOT(slotData(const QByteArray &, QNetworkOperation *)) );
	connect( pOp, SIGNAL(dataTransferProgress(int, int, QNetworkOperation*)), this, SLOT(slotDataTransferProgress( int, int, QNetworkOperation *)) );
	connect( pOp, SIGNAL(finished( QNetworkOperation *)), this, SLOT(slotFinished( QNetworkOperation *)) );
	connect( PushButton_CANCEL, SIGNAL(clicked()), this, SLOT(reject()));
}

/** */
void DCGetURL::slotData( const QByteArray & data, QNetworkOperation * )
{
	baData.Append( (const unsigned char*)data.data(), data.size() );
}

/** */
void DCGetURL::slotDataTransferProgress( int bytesDone, int bytesTotal, QNetworkOperation * )
{
	QString s;

	ProgressBar_Download->setTotalSteps(bytesTotal);
	ProgressBar_Download->setProgress(bytesDone);

	s.sprintf("%d/%d",bytesDone,bytesTotal);

	TextLabel_Status->setText(s);
}

/** */
void DCGetURL::slotFinished( QNetworkOperation * op )
{
	switch( op->state() )
	{
		case QNetworkProtocol::StWaiting:
			TextLabel_Status->setText("waiting ...");
			break;
		case QNetworkProtocol::StInProgress:
			TextLabel_Status->setText("in progress ...");
			break;
		case QNetworkProtocol::StDone:
			TextLabel_Status->setText("done ...");
			accept();
			break;
		case QNetworkProtocol::StFailed:
			TextLabel_Status->setText("failed ...");
			reject();
			break;
		case QNetworkProtocol::StStopped:
			TextLabel_Status->setText("stopped ...");
			reject();
			break;
		default:
			TextLabel_Status->setText("unknown ...");
			break;
	}
}

/*
QNetworkProtocol::StWaiting - The operation is in the queue of the QNetworkProtocol and is waiting to be prcessed.
QNetworkProtocol::StInProgress - The operation is being processed.
QNetworkProtocol::StDone - The operation has been processed succesfully.
QNetworkProtocol::StFailed - The operation has been processed but an error occurred.
QNetworkProtocol::StStopped - The operation has been processed but has been stopped before it finished, and is waiting to be processed.
*/
