/***************************************************************************
                          dcfiletool.cpp  -  description
                             -------------------
    begin                : Die Mr 26 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qstring.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qregexp.h>

#include <dclib/cdir.h>

#include <dcconfig.h>
#include "dcfiletool.h"

/** */
DCFileTool::DCFileTool()
{
}

/** */
DCFileTool::~DCFileTool()
{
}

/** */
bool DCFileTool::CheckFile( QString filename, const ulonglong size, ulonglong & fpos, QString localrootpath )
{
	CDir dir;
	QString name;
	ulonglong fsize;

	if ( localrootpath != "" )
	{
		name = localrootpath;
	}
	else
	{
		name = Config->GetDownloadFolder().Data();
	}

	if ( name == "" )
	{
		return FALSE;
	}

	name = name + "/" + filename;

	QFile f(name);

	fsize = dir.getFileSize(name.ascii(),FALSE);

	if ( fsize == 0 )
	{
		fpos = 0;
	}
	else if ( size == fsize )
	{
		QMessageBox::information( this, tr("File download"),
			tr("File allready download\n"));
		return FALSE;
	}
	else if ( fsize > 0 )
	{
		switch( QMessageBox::warning( this, tr("File download"),
			tr("File allready exist !"),
		        tr("Resume"),
		        tr("Overwrite"),
			tr("Cancel"), 0, 2 ) )
		{
			case 0:
				fpos = fsize;
		        	break;
			case 1:
				f.remove();
				fpos = 0;
		        	break;
			case 2:
				return FALSE;
				break;
		}
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

/** */
CString DCFileTool::GetSizeString( const ulonglong size )
{
	CString s, suffix;
	ulonglong d;
	eUnit unit;

	d = size;

	unit = Config->GetUnit();

	if ( (d > (1024*1024*1024)) && ((unit == euAUTO) || (unit == euGBYTE)) )
	{
		suffix = "GB";
		d /= (1024*1024*1024);
	}
	else if ( (d > (1024*1024)) && ((unit == euAUTO) || (unit == euMBYTE)) )
	{
		suffix = "MB";
		d /= (1024*1024);
	}
	else if ( (d > 1024) && ((unit == euAUTO) || (unit == euKBYTE)) )
	{
		suffix = "KB";
		d /= 1024;
	}
	else if  ( (unit == euAUTO) || (unit == euBYTE) )
	{
		suffix = "";
	}

	s = s.setNum(d);

	s += " " + suffix;

	return s;
}
