/***************************************************************************
                          dcconfig.h  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCONFIG_H
#define DCCONFIG_H

#include <dclib/dcos.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpixmap.h>

#include <dclib/cbytearray.h>
#include <dclib/cstring.h>
#include <dclib/cthread.h>
#include <dclib/dcobject.h>
#include <dclib/cconfig.h>

#include <libxml/xmlversion.h>
#if LIBXML_VERSION > 20406
#include <libxml/globals.h>
#endif
#include <libxml/parser.h>
#include <libxml/tree.h>

typedef enum eUserIconType {
	euitOPERATOR,
	euitUSER,
	euitUSER_AWAY
} eUserIconType;

typedef enum eUserSound {
	eusCHAT
} eUserSound;

/* Default application font. Needed from main.cpp too */
#define DEFAULT_APP_FONT	"Helvetica,12,-1,5,50,0,0,0,0,0"

typedef enum eUnit {
	euAUTO,
	euBYTE,
	euKBYTE,
	euMBYTE,
	euGBYTE
} eUnit;

class QProcess;

/**
  *@author Mathias Kster
  */

class DCConfig : public CConfig {
public:
	/** */
	DCConfig( CString configpath = "" );
	/** */
	virtual ~DCConfig();

	/** */
	int Load();
	/** */
	int Save();

	/** */
	int LoadDCGui();
	/** */
	int SaveDCGui();
	/** */
	void ParseDCGuiConfig( xmlNodePtr node );

	/** */
	bool GetOpenPrivateChatWindow() const;
	/** */
	void SetOpenPrivateChatWindow( bool b );
	/** */
	eUnit GetUnit() const;
	/** */
	void SetUnit( eUnit unit );
	/** */
	CString GetTheme() const;
	/** */
	void SetTheme( CString theme );
	/** */
	CString GetLanguageFile() const;
	/** */
	void SetLanguageFile( CString languagefile );

	/** */
	QPixmap & GetUserIcon( eUserIconType type );
	/** */
	void PlaySound( eUserSound usersound );

	/** */
	void SetAppFont( CString font );
	/** */
	CString GetAppFont() const;
	/** */
	void SetAppGeometry( int width, int height );
	/** */
	void GetAppGeometry( int &width, int &height );

	/** */
	bool GetSoundEnabled() const;
	/** */
	void SetSoundEnabled( bool soundenabled );
	/** */
	bool GetExternalSoundPlayer() const;
	/** */
	void SetExternalSoundPlayer( bool externalsoundplayer );
	/** */
	CString GetExternalPlayer() const;
	/** */
	void SetExternalPlayer( CString externalplayer );
	/** */
	CString GetChatSoundFile() const;
	/** */
	void SetChatSoundFile( CString chatsoundfile );

private:
	/** */
	bool bOpenPrivateChatWindow;
	/** */
	eUnit euUnit;
	/** */
	CString sTheme;
	/** */
	CString sLanguageFile;
	/** Application font */
	CString sAppFont;
	/** Application height */
	int iAppHeight;
	/** Application Width */
	int iAppWidth;
	/** */
	bool bSoundEnabled;
	/** */
	bool bExternalSoundPlayer;
	/** */
	CString sExternalPlayer;
	/** chat sound file */
	CString sChatSoundFile;

	/** */
	QProcess * pProcess;
	/** */
	QPixmap icon_operator,icon_user,icon_user_away;
};

/** global config */
extern DCConfig * Config;

/** inline functions */

/** */
inline bool DCConfig::GetOpenPrivateChatWindow() const
{ return bOpenPrivateChatWindow; }
/** */
inline void DCConfig::SetOpenPrivateChatWindow( bool b )
{ Thread.Lock(); bOpenPrivateChatWindow = b; Thread.UnLock(); }
/** */
inline eUnit DCConfig::GetUnit() const
{ return euUnit; }
/** */
inline void DCConfig::SetUnit( eUnit unit )
{ Thread.Lock(); euUnit = unit; Thread.UnLock(); }
/** */
inline CString DCConfig::GetTheme() const
{ return sTheme; }
/** */
inline void DCConfig::SetTheme( CString theme )
{ Thread.Lock(); sTheme = theme; Thread.UnLock(); }
/** */
inline CString DCConfig::GetLanguageFile() const
{ return sLanguageFile; }
/** */
inline void DCConfig::SetLanguageFile( CString languagefile )
{ Thread.Lock(); sLanguageFile = languagefile; Thread.UnLock(); }

inline CString DCConfig::GetAppFont() const
{ return sAppFont; }
inline void DCConfig::SetAppFont(CString font)
{ Thread.Lock(); sAppFont = font; Thread.UnLock(); }
/** */
inline void DCConfig::SetAppGeometry( int width, int height )
{ iAppWidth=width;iAppHeight=height; }
/** */
inline void DCConfig::GetAppGeometry( int &width, int &height )
{ width=iAppWidth;height=iAppHeight; }
/** */
inline bool DCConfig::GetSoundEnabled() const
{ return bSoundEnabled; }
/** */
inline void DCConfig::SetSoundEnabled( bool soundenabled )
{ Thread.Lock(); bSoundEnabled = soundenabled; Thread.UnLock(); }
/** */
inline bool DCConfig::GetExternalSoundPlayer() const
{ return bExternalSoundPlayer; }
/** */
inline void DCConfig::SetExternalSoundPlayer( bool externalsoundplayer )
{ Thread.Lock(); bExternalSoundPlayer = externalsoundplayer; Thread.UnLock(); }
/** */
inline CString DCConfig::GetExternalPlayer() const
{ return sExternalPlayer; }
/** */
inline void DCConfig::SetExternalPlayer( CString externalplayer )
{ Thread.Lock(); sExternalPlayer = externalplayer; Thread.UnLock(); }
/** */
inline CString DCConfig::GetChatSoundFile() const
{ return sChatSoundFile; }
/** */
inline void DCConfig::SetChatSoundFile( CString chatsoundfile )
{ Thread.Lock(); sChatSoundFile = chatsoundfile; Thread.UnLock(); }

#endif
