/***************************************************************************
                          dcconfig.cpp  -  description
                             -------------------
    begin                : Fri Mar 1 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qstringlist.h>
#include <qregexp.h>
#include <qprocess.h>
#include <qsound.h>

#include <dclib/che3.h>
#include <dclib/cxml.h>
#include <dclib/csocket.h>

// icons
#include "icon_operator.xpm"
#include "icon_user.xpm"
#include "icon_user_away.xpm"

#ifdef WIN32
#include <malloc.h>
#endif

#include "dcconfig.h"

// config files
#define DCGUI_CONFIG		"dcgui.cfg"

#define XML_DCGUI_CONFIG	"dcgui"

#define XML_GUI				"gui"
#define XML_OPENPRIVATECHATWIN		"openprivatechatwindow"
#define XML_UNIT		"unit"
#define XML_THEME			"theme"
#define XML_LANGUAGEFILE		"languagefile"
#define XML_APP_FONT			"appfont"
#define XML_APP_WIDTH			"appwidth"
#define XML_APP_HEIGHT			"appheight"
#define XML_FALSE			"false"
#define XML_TRUE			"true"
#define XML_EXTERNAL_SOUND_PLAYER	"externalsoundplayer"
#define XML_EXTERNAL_PLAYER		"externalplayer"
#define XML_CHAT_SOUND_FILE		"chatsoundfile"
#define XML_SOUND_ENABLED		"soundenabled"


#define XML_UNIT_AUTO	"auto"
#define XML_UNIT_BYTE	"byte"
#define XML_UNIT_KBYTE	"kbyte"
#define XML_UNIT_MBYTE	"mbyte"
#define XML_UNIT_GBYTE	"gbyte"

DCConfig * Config;

DCConfig::DCConfig( CString configpath ) : CConfig(configpath)
{
	// gui defaults
	bOpenPrivateChatWindow = TRUE;
	euUnit                 = euAUTO;
	sTheme                 = "Default";
	sLanguageFile          = "";
	sAppFont               = DEFAULT_APP_FONT;
	iAppHeight             = 480;
	iAppWidth              = 640;

	sChatSoundFile         = "";
	bSoundEnabled          = FALSE;
	bExternalSoundPlayer   = FALSE;
	sExternalPlayer        = "";

	pProcess = new QProcess ();

	icon_operator = QPixmap(icon_operator_xpm);
	icon_user = QPixmap(icon_user_xpm);
	icon_user_away = QPixmap(icon_user_away_xpm);
}

DCConfig::~DCConfig()
{
	delete pProcess;
}

/** */
void DCConfig::ParseDCGuiConfig( xmlNodePtr node )
{
	xmlNodePtr n1,n2;
	CXml xml;

	for(n1=node;n1!=0;n1=n1->next)
	{
		/* gui entrys */
		if ( xml.name(n1) == XML_GUI )
		{
			for(n2=n1->xmlChildrenNode;n2!=0;n2=n2->next)
			{
				if ( xml.name(n2) == XML_OPENPRIVATECHATWIN )
				{
					if ( xml.content(n2) == XML_TRUE )
						bOpenPrivateChatWindow = TRUE;
					else
						bOpenPrivateChatWindow = FALSE;
				}
				else if ( xml.name(n2) == XML_UNIT )
				{
					if ( xml.content(n2) == XML_UNIT_AUTO )
						euUnit = euAUTO;
					else if ( xml.content(n2) == XML_UNIT_BYTE )
						euUnit = euBYTE;
					else if ( xml.content(n2) == XML_UNIT_KBYTE )
						euUnit = euKBYTE;
					else if ( xml.content(n2) == XML_UNIT_MBYTE )
						euUnit = euMBYTE;
					else if ( xml.content(n2) == XML_UNIT_GBYTE )
						euUnit = euGBYTE;
				}
				else if ( xml.name(n2) == XML_THEME )
					sTheme = xml.content(n2);
				else if ( xml.name(n2) == XML_LANGUAGEFILE )
					sLanguageFile = xml.content(n2);
				else if ( xml.name(n2) == XML_APP_FONT )
					sAppFont = xml.content(n2);
				else if ( xml.name(n2) == XML_APP_WIDTH )
					iAppWidth = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_APP_HEIGHT )
					iAppHeight = xml.content(n2).asINT();
				else if ( xml.name(n2) == XML_CHAT_SOUND_FILE )
					sChatSoundFile = xml.content(n2);
				else if ( xml.name(n2) == XML_EXTERNAL_SOUND_PLAYER )
				{
					if ( xml.content(n2) == XML_TRUE )
						bExternalSoundPlayer = TRUE;
					else
						bExternalSoundPlayer = FALSE;
				}
				else if ( xml.name(n2) == XML_EXTERNAL_PLAYER )
					sExternalPlayer = xml.content(n2);
				else if ( xml.name(n2) == XML_SOUND_ENABLED )
				{
					if ( xml.content(n2) == XML_TRUE )
						bSoundEnabled = TRUE;
					else
						bSoundEnabled = FALSE;
				}
			}
		}
	}
}

/** */
int DCConfig::Load()
{
	LoadDCLib();
	return LoadDCGui();
}

/** */
int DCConfig::Save()
{
	SaveDCLib();
	return SaveDCGui();
}

/** */
int DCConfig::LoadDCGui()
{
	CString s;
	xmlNodePtr node;
	CXml xml;

	s = sConfigPath + DCGUI_CONFIG;

	if ( xml.ParseFile(s) == FALSE )
	{
		return -1;
	}

	for(node=xml.doc()->children;node!=0;node=node->next)
	{
		if ( xml.name(node) == XML_DCGUI_CONFIG )
		{
			ParseDCGuiConfig(node->xmlChildrenNode);
		}
	}

	return 0;
}

/** */
int DCConfig::SaveDCGui()
{
	int err=0;
	CString s;
	xmlDocPtr doc;
	xmlNodePtr node;
	CXml xml;

	doc = xmlNewDoc((const xmlChar*)"1.0");

	doc->children = xmlNewDocNode(doc,0,(const xmlChar*)XML_DCGUI_CONFIG,0);

	// gui
	node = xmlNewChild( doc->children, 0, (const xmlChar*)XML_GUI, 0 );

	if (bOpenPrivateChatWindow==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;

	xmlNewChild( node, 0, (const xmlChar*)XML_OPENPRIVATECHATWIN, (const xmlChar*)(const char*)s.Data() );

	switch(euUnit)
	{
		case euBYTE:
			s = XML_UNIT_BYTE;
			break;
		case euKBYTE:
			s = XML_UNIT_KBYTE;
			break;
		case euMBYTE:
			s = XML_UNIT_MBYTE;
			break;
		case euGBYTE:
			s = XML_UNIT_GBYTE;
			break;
		default:
			s = XML_UNIT_AUTO;
			break;
	}

	xmlNewChild( node, 0, (const xmlChar*)XML_UNIT, (const xmlChar*)(const char*)s.Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_THEME, (const xmlChar*) xml.ToUTF8(sTheme).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_LANGUAGEFILE, (const xmlChar*) xml.ToUTF8(sLanguageFile).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_FONT, (const xmlChar*) xml.ToUTF8(sAppFont).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_WIDTH, (const xmlChar*) QString().setNum(iAppWidth).ascii() );
	xmlNewChild( node, 0, (const xmlChar*)XML_APP_HEIGHT, (const xmlChar*) QString().setNum(iAppHeight).ascii() );
	xmlNewChild( node, 0, (const xmlChar*)XML_CHAT_SOUND_FILE, (const xmlChar*) xml.ToUTF8(sChatSoundFile).Data() );
	xmlNewChild( node, 0, (const xmlChar*)XML_EXTERNAL_PLAYER, (const xmlChar*) xml.ToUTF8(sExternalPlayer).Data() );
	if (bExternalSoundPlayer==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;
	xmlNewChild( node, 0, (const xmlChar*)XML_EXTERNAL_SOUND_PLAYER, (const xmlChar*)(const char*)s.Data() );

	if (bSoundEnabled==TRUE)
		s = XML_TRUE;
	else
		s = XML_FALSE;
	xmlNewChild( node, 0, (const xmlChar*)XML_SOUND_ENABLED, (const xmlChar*)(const char*)s.Data() );

	// save file
	s = sConfigPath + DCGUI_CONFIG;

	if ( xmlSaveFile(s.Data(),doc) == -1 )
	{
		err = -1;
	}

	xmlFreeDoc(doc);

	return err;
}

/** */
QPixmap & DCConfig::GetUserIcon( eUserIconType type )
{
	switch(type)
	{
		case euitOPERATOR:
			return icon_operator;
			break;
		case euitUSER_AWAY:
			return icon_user_away;
			break;
		case euitUSER:
		default:
			return icon_user;
			break;
	}
}

/** */
void DCConfig::PlaySound( eUserSound usersound )
{
	QString s;

	if ( bSoundEnabled == FALSE )
	{
		return;
	}

	switch(usersound)
	{
		case eusCHAT:
			s = sChatSoundFile.Data();
			break;
		default:
			s = "";
			break;
	}

	if ( s == "" )
	{
		return;
	}

	if ( bExternalSoundPlayer == FALSE )
	{
		QSound::play(s);
	}
	else
	{
		if ( pProcess->isRunning() == TRUE )
		{
			pProcess->kill();
		}

		pProcess->clearArguments();

		pProcess->addArgument(sExternalPlayer.Data());
		pProcess->addArgument(s);

		if ( !pProcess->start() )
		{
			printf("error start play process\n");
		}
	}
}

