/***************************************************************************
                          dcclient.h  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCLIENT_H
#define DCCLIENT_H

#include <dclib/dcos.h>

#include <qtimer.h>
#include <qworkspace.h>
#include <qlistview.h>

#include <DCDialogClient.h>

#include <dclib/dcobject.h>
#include <dclib/cclient.h>
#include <dclib/cstringlist.h>
#include <dclib/cmessagehandler.h>
#include <dctransferview.h>
#include <dcwidget.h>

/**
  *@author Mathias Kster
  */

typedef enum eReconnectState {
	ersNONE,
	ersFORCEMOVE,
	ersDISABLED,
	ersENABLED
} eReconnectState;


class DCUserItem : public CObject {
public:
	DCUserItem() {};
	virtual ~DCUserItem() {};
	DC_QCheckListItem * pItem;
	CMessageMyInfo MyInfo;
};

class DCChat;
class QListViewItem;

class DCClient : public DCDialogClient, public CClient {
Q_OBJECT
public:
	/** */
	DCClient(QWidget* parent, const char *name, int wflags);
	/** */
	virtual ~DCClient();

	/** */
	void InitDocument();

	/** chat */
	void DC_Chat( CMessageChat * MessageChat );
	/** myinfo */
	void DC_MyInfo( CMessageMyInfo * MessageMyInfo );
	/** nicklist */
	void DC_NickList( CMessageNickList * MessageNickList );
	/** oplist */
	void DC_OpList( CMessageNickList * MessageOpList );
	/** hello */
	void DC_Hello( CMessageHello * MessageHello );
	/** quit */        	
	void DC_Quit( CMessageQuit * MessageQuit );
	/** search */
	void DC_Search( CMessageSearch * MessageSearch );
	/** search result */
	void DC_SearchResult( CMessageSearchResult * MessageSearchResult );
	/** */
	void DC_PrivateChat( QString nick, QString message, bool bLocal = FALSE );

	/** */
	void SetNickColor( QString nick, QColor color );
	/** get the search string with protocol */
	QString GetSearchString();
	/** */
	void UpdateStatusBar();
	/** callback function */
	virtual int DC_CallBack( CObject * Object );

	/** overridden so that the columns are resized on show() */
	virtual void show();

private:
	/** */
	void SetReconnectParams( eReconnectState reconnectstate, int reconnectcount = -1 );

	/** */
	CList<DCChat> *pChatList;
	/** */
	time_t tReconnectTimeout;
	/** */
	eReconnectState eTryReconnect;
	/** */
	int iReconnectCount;

protected:
	/** */
	QWorkspace *pWorkspace;
	/** */
	CThread Thread;
	/** */
	QTimer Timer;
	/** */
	CList<CObject> * pMessageList;
	/** */
	CStringList * pUserList;

	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private slots:
	/** */
	void slotChatReturnPressed();
	/** */
	void slotSearchReturnPressed();
	/** */
	void slotDoubleClickedSearchResult( QListViewItem * item );
	/** */
	void timerDone();
	/** */
	void slotDoubleClickedUserList( QListViewItem * item );
	/** */
	void slotRightButtonClickedUserList( QListViewItem *, const QPoint &, int );
	/** */
	void slotRightButtonClickedSearchResult( QListViewItem *, const QPoint &, int );
	/** */
	void slotDoubleClickedUserChat( QListBoxItem * item );
	/** */
	void slotRightButtonClickedConnState();
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange(QWidget*);

signals:
	/** */
	void signalRightButtonClickedConnState();
};

#endif
