/***************************************************************************
                          dcclient.cpp  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qapp.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qregexp.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlcdnumber.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qtabwidget.h>
#include <qinputdialog.h>
#include <qfiledialog.h>
#include <qclipboard.h>
#include <qsound.h>

#include <dctransferview.h>
#include <dcconfig.h>
#include <dcfiletool.h>
#include <dcchat.h>
#include <dcmenuhandler.h>
#include <dcwidget.h>

#include "dcclient.h"

#include "online.xpm"
#include "offline.xpm"

/** */
DCClient::DCClient(QWidget* parent, const char *name, int wflags) : DCDialogClient(parent, name, wflags)
{
	int idx;

	pWorkspace = (QWorkspace*)parent;

	// set the ColumnWidthMode to manual, we will take care of this task
	for( idx = 0; idx < ListView_USERLIST->columns(); idx++ )
	{
		ListView_USERLIST->setColumnWidthMode( idx, QListView::Manual );
	}
	for( idx = 0; idx < ListView_SEARCHRESULT->columns(); idx++ )
	{
		ListView_SEARCHRESULT->setColumnWidthMode( idx, QListView::Manual );
	}

	pMessageList = new CList<CObject>();
	pUserList    = new CStringList;

	InitDocument();

	LineEdit_STATUS->setText("");

	PixmapLabel_CONNSTATE->setPixmap(QPixmap(offline_xpm));

	pChatList = new CList<DCChat>;

	// set reconnect params
	eTryReconnect     = ersNONE;
	iReconnectCount   = 0;
	tReconnectTimeout = 0;
}

/** */
DCClient::~DCClient()
{
	CObject * Object;

	PixmapLabel_CONNSTATE->removeEventFilter(this);

	Disconnect();

	Timer.stop();

	Thread.Lock();

	if ( pMessageList )
	{
		while ( (Object = pMessageList->Next(0)) != 0 )
		{
			pMessageList->Del(Object);
		}

		delete pMessageList;
		pMessageList = 0;
	}

	Thread.UnLock();
	
	DCChat * chat;

	while( (chat=pChatList->Next(0)) != 0 )
	{
		chat->removeEventFilter(this);
		pChatList->Remove(chat);
        }

	delete pChatList;
	pChatList = 0;

	delete pUserList;
	pUserList = 0;
}

/** */
void DCClient::InitDocument()
{
	connect( LineEdit_CHATINPUT, SIGNAL(returnPressed()), this, SLOT(slotChatReturnPressed()) );
	connect( LineEdit_SEARCH, SIGNAL(returnPressed()), this, SLOT(slotSearchReturnPressed()) );
	connect( PushButton_SEARCH, SIGNAL(clicked()), this, SLOT(slotSearchReturnPressed()) );
	connect( ListView_SEARCHRESULT,SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotDoubleClickedSearchResult(QListViewItem*)) );
	connect( ListView_USERLIST,SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotDoubleClickedUserList(QListViewItem*)) );
	connect( ListView_USERLIST,SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedUserList(QListViewItem*, const QPoint &, int )) );
	connect( ListView_SEARCHRESULT,SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedSearchResult(QListViewItem*, const QPoint &, int )) );
	connect( ListBox_USERCHAT,SIGNAL(doubleClicked(QListBoxItem*)), this, SLOT(slotDoubleClickedUserChat(QListBoxItem*)) );
	connect( TabWidget_CLIENT,SIGNAL(currentChanged(QWidget*)), this, SLOT(slotTabWidgetCurrentChange(QWidget*)) );

	PixmapLabel_CONNSTATE->installEventFilter(this);

	connect( this,SIGNAL(signalRightButtonClickedConnState()), this, SLOT(slotRightButtonClickedConnState()) );

	connect( &Timer, SIGNAL(timeout()), this, SLOT(timerDone()) );

	Timer.start( 500, TRUE );
}

/** event filter */
bool DCClient::eventFilter(QObject* object, QEvent* event)
{
	if((event->type() == QEvent::Close)&&((DCClient*)object!=this))
	{
		QCloseEvent* e=(QCloseEvent*)event;
		DCChat* pView=(DCChat*)object;

		if ( pChatList != 0 )
		{
			pChatList->Remove(pView);
		}

		QListBoxItem * item = ListBox_USERCHAT->findItem(pView->GetNick());
		int index = ListBox_USERCHAT->index(item);

		if (index!=-1)
		{
			ListBox_USERCHAT->removeItem(index);
		}

		e->accept();
	}
	else if ((event->type() == QEvent::MouseButtonPress)&&((DCClient*)object!=this))
	{
		// filter event on conn. state label
		if ( PixmapLabel_CONNSTATE == (QLabel*)object )
		{
			QMouseEvent* e=(QMouseEvent*)event;

			if ( e->button() == RightButton )
			{
				emit signalRightButtonClickedConnState();
			}
		}
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}

/** current tab widget change slot */
void DCClient::slotTabWidgetCurrentChange(QWidget*)
{
	ResizeListViewColumn();
}

/** overridden so that the columns are resized on show() */
void DCClient::show()
{
	QWidget::show();

	ResizeListViewColumn();
}

/** resize event handler */
void DCClient::resizeEvent( QResizeEvent * )
{
	ResizeListViewColumn();
}

/** resize the ListView columns */
void DCClient::ResizeListViewColumn()
{
	int width;

	if ( ListView_USERLIST->isVisible() )
	{
		width = ListView_USERLIST->width();

		ListView_USERLIST->setColumnWidth( 0, ((width*6)/20) );
		ListView_USERLIST->setColumnWidth( 1, ((width*5)/20) );
		ListView_USERLIST->setColumnWidth( 2, ((width*2)/20) );
		ListView_USERLIST->setColumnWidth( 3, ((width*3)/20) );
		ListView_USERLIST->setColumnWidth( 4, ((width*4)/20) );
	}

	if ( ListView_SEARCHRESULT->isVisible() )
	{
		width = ListView_SEARCHRESULT->width();

		ListView_SEARCHRESULT->setColumnWidth( 0, ((width*7)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 1, ((width*3)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 2, ((width*4)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 3, ((width*1)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 4, ((width*4)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 5, ((width*6)/28) );
		ListView_SEARCHRESULT->setColumnWidth( 6, ((width*3)/28) );
	}
}

/** */
void DCClient::UpdateStatusBar()
{
	TextLabel_USERCOUNT->setText( QString().setNum(ListView_USERLIST->childCount()) );
	TextLabel_SHARESIZE->setText( DCFileTool::GetSizeString(GetHubShareSize()).Data() );
}

/** */
void DCClient::SetReconnectParams( eReconnectState reconnectstate, int reconnectcount )
{
	// reconnect disabled
	if ( Config->GetReconnectCount() == 0 )
	{
		eTryReconnect = ersNONE;
		return;
	}

	if ( (eTryReconnect == ersDISABLED) && (reconnectstate != ersNONE) )
	{
		return;
	}

	eTryReconnect     = reconnectstate;
	tReconnectTimeout = 0;

	if ( reconnectcount != -1 )
	{
		iReconnectCount = reconnectcount;
	}
}

/** */
void DCClient::timerDone()
{
	CObject * Object;
	CDCMessage *DCMsg;

	if ( eTryReconnect == ersENABLED )
	{
		if ( iReconnectCount >= Config->GetReconnectCount() )
		{
			SetReconnectParams( ersNONE, 0 );
		}
		else
		{
			if ( GetConnectionState() != estNONE )
			{
				printf("warning, wrong reconnect state, you are connected !\n");//fflush(stdout);
			}

			// init timer
			if ( tReconnectTimeout == 0 )
			{
				tReconnectTimeout = time(0);
			}

			if ( (time(0)-tReconnectTimeout) >= Config->GetReconnectTimeout() )
			{
				SetReconnectParams( ersNONE );
				iReconnectCount++;

				Connect();
			}
		}
	}

	for(;;)
	{
		if ( Thread.TryLock() == FALSE )
		{
			break;
		}

		if ( pMessageList != 0 )
		{
			Object = pMessageList->Next(0);

			if ( Object != 0 )
			{
				pMessageList->Remove(Object);
			}
		}
		else
		{
			Object = 0;
		}

		Thread.UnLock();

		if ( Object == 0 )
		{
			break;
		}

		DCMsg = (CDCMessage*) Object;

		switch ( DCMsg->eType )
		{
			case DC_MESSAGE_CONNECTION_STATE:
			{
				CMessageConnectionState *msg = (CMessageConnectionState*) Object;

				if ( msg->eState == estCONNECTED )
				{
					setCaption( ("[+] " + GetHubName()).Data());
					PixmapLabel_CONNSTATE->setPixmap(QPixmap(online_xpm));

					LineEdit_STATUS->setText("");
					SetReconnectParams( ersNONE );
				}
				else if ( msg->eState == estCONNECTIONTIMEOUT )
				{
					PixmapLabel_CONNSTATE->setPixmap(QPixmap(offline_xpm));

					LineEdit_STATUS->setText(tr("Connection timeout"));
				}
				else if ( msg->eState == estSOCKETERROR )
				{
					PixmapLabel_CONNSTATE->setPixmap(QPixmap(offline_xpm));

					LineEdit_STATUS->setText(tr("Error: '") + msg->sMessage.Data() + "'" );
				}
				else if ( msg->eState == estDISCONNECTED )
				{
					setCaption( ("[-] " + GetHubName()).Data());
					PixmapLabel_CONNSTATE->setPixmap(QPixmap(offline_xpm));

					if ( eTryReconnect == ersFORCEMOVE )
					{
						SetReconnectParams( ersNONE );
					}
					else
					{
						SetReconnectParams( ersENABLED );
					}
				}

				break;
			}

			case DC_MESSAGE_VALIDATEDENIDE:
			{
				LineEdit_STATUS->setText(tr("Validate denide"));
				Disconnect();
				break;
			}

			case DC_MESSAGE_NICKLIST:
			{
				DC_NickList( (CMessageNickList *) Object );
				break;
			}

			case DC_MESSAGE_OPLIST:
			{
				DC_OpList( (CMessageNickList *) Object );
				break;
			}

			case DC_MESSAGE_REVCONNECTTOME:
			{
				CMessageRevConnectToMe * msg = (CMessageRevConnectToMe*) Object;

				if ( GetMode() == ecmPassive )
				{
					SendPrivateMessage( GetNick(), msg->sRemoteNick, tr("Sorry, client work in passive mode").ascii() );
				}
				else
				{
					CString s = Config->GetTCPHostString();

					if ( s != "" )
					{
						if ( pTransferView->AddTransfer( msg->sRemoteNick, "", GetHubName(), GetHost() ) == TRUE )
						{
							SendConnectToMe(msg->sRemoteNick,s);
						}
					}
				}

				break;
			}

			case DC_MESSAGE_CHAT:
			{
				DC_Chat( (CMessageChat *) Object );
				break;
			}

			case DC_MESSAGE_MYINFO:
			{
				DC_MyInfo( (CMessageMyInfo *) Object );
				break;
			}

			case DC_MESSAGE_QUIT:
			{
				DC_Quit( (CMessageQuit *) Object );
				break;
			}

			case DC_MESSAGE_SEARCH:
			{
				DC_Search( (CMessageSearch *) Object );
				break;
			}

			case DC_MESSAGE_SEARCHRESULT:
			{
				DC_SearchResult( (CMessageSearchResult *) Object );
				break;
			}

			case DC_MESSAGE_HELLO:
			{
				CMessageHello * msg = (CMessageHello *) Object;

				DC_Hello(msg);

				if ( msg->sNick == GetNick() )
				{
					RequestNickList();
				}

				break;
			}

			case DC_MESSAGE_CONNECTTOME:
			{
				CMessageConnectToMe * msg = (CMessageConnectToMe*) Object;

				pTransferView->AddTransfer( msg->sHost, msg->iPort, GetHubName(), GetHost() );

				break;
			}

			case DC_MESSAGE_FORCEMOVE:
			{
				CMessageForceMove * msg = (CMessageForceMove*) Object;

				if ( Config->GetForceMoveEnabled() == TRUE )
				{
					SetReconnectParams( ersFORCEMOVE, 0 );

					Connect(msg->sHost,msg->iPort);

					LineEdit_STATUS->setText(tr("Redirect to ")+ msg->sHost.Data() + ":" + QString().setNum(msg->iPort));
				}
				else
				{
					LineEdit_STATUS->setText(tr("Redirect disabled ")+ msg->sHost.Data() + ":" + QString().setNum(msg->iPort));
				}

				break;
			}

			case DC_MESSAGE_HUBNAME:
			{
				CMessageHubName * msg = (CMessageHubName*) Object;

				setCaption( ("[+] " + msg->sHubName).Data());

				break;
			}

			case DC_MESSAGE_PRIVATECHAT:
			{
				CMessagePrivateChat * msg = (CMessagePrivateChat*) Object;

				DC_PrivateChat( msg->sFrom.Data(), msg->sString.Data() );

				break;
			}

			case DC_MESSAGE_GETPASS:
			{
				bool ok = FALSE;
				QString text = QInputDialog::getText(
					tr("Password - ")+GetHubName().Data(),
					tr( "Please enter your password" ),
					QLineEdit::Password, QString::null, &ok, this );

				if ( ok && !text.isEmpty() )
				{
					SendPass(text.ascii());
				}

				break;
			}

			case DC_MESSAGE_BADPASS:
			{
				LineEdit_STATUS->setText(tr("Wrong password"));
				break;
			}

			default:
			{
				break;
			}
		}

		delete Object;
	}

	Timer.start( 500, TRUE );
}

/** */
int DCClient::DC_CallBack( CObject * Object )
{
	int err;

	Thread.Lock();

	if ( Object != NULL )
	{
		if ( pMessageList != 0 )
		{
			pMessageList->Add(Object);
			err = 0;
		}
		else
		{
			err = -1;
		}
        }
	else
	{
		err = -1;
	}

	Thread.UnLock();

	return err;
}

/** chat */
void DCClient::DC_Chat( CMessageChat * MessageChat )
{
	bool bscroll;
	QString s;

	s  = MessageChat->sNick.Data();
	s += ": ";
	s += MessageChat->sMessage.Data();

	if ( TextEdit_CHATOUTPUT->verticalScrollBar()->maxValue() == TextEdit_CHATOUTPUT->verticalScrollBar()->value() )
	{
		bscroll = TRUE;
	}
	else
	{
		bscroll = FALSE;
	}

	TextEdit_CHATOUTPUT->append(s);

	if ( bscroll )
	{
		TextEdit_CHATOUTPUT->scrollToBottom();
		TextEdit_CHATOUTPUT->moveCursor( QTextEdit::MoveEnd, FALSE );
	}
}

/** myinfo */
void DCClient::DC_MyInfo( CMessageMyInfo * MessageMyInfo )
{
	CString s;
	DCFileTool FileTool;
	QPixmap puser;
	eUserIconType type;

	DCUserItem * pui=0;
	if ( pUserList->Get( MessageMyInfo->sNick, (CObject*&)pui ) == -1 )
	{
		pui = new DCUserItem();
		pUserList->Add(MessageMyInfo->sNick,pui);

		if ( MessageMyInfo->eAwayMode == euamNORMAL )
			type = euitUSER;
		else
			type = euitUSER_AWAY;

		pui->pItem = new DC_QCheckListItem( ListView_USERLIST, MessageMyInfo->sNick.Data(), Config->GetUserIcon(type) );
	}
	else if ( pui->MyInfo.bOperator == FALSE )
	{
		if ( pui->MyInfo.eAwayMode != MessageMyInfo->eAwayMode )
		{
			if ( MessageMyInfo->eAwayMode == euamNORMAL )
				type = euitUSER;
			else
				type = euitUSER_AWAY;

			pui->pItem->setPixmap(0,Config->GetUserIcon(type));
		}
	}

	pui->MyInfo = *MessageMyInfo;

	pui->pItem->setText(1,MessageMyInfo->sComment.Data());
	pui->pItem->setText(2,MessageMyInfo->sSpeed.Data());
	pui->pItem->setText(3,MessageMyInfo->sEMail.Data());

	pui->pItem->myvalue = MessageMyInfo->lShared;
	pui->pItem->mycol   = 4;

	s = FileTool.GetSizeString(MessageMyInfo->lShared);
	pui->pItem->setText(4,s.Data());

	UpdateStatusBar();
}

/** hello */
void DCClient::DC_Hello( CMessageHello * MessageHello )
{
	DCUserItem * pui=0;
	if ( pUserList->Get( MessageHello->sNick, (CObject*&)pui ) == -1 )
	{
		pui = new DCUserItem();
		pUserList->Add(MessageHello->sNick,pui);

		pui->pItem = new DC_QCheckListItem( ListView_USERLIST, MessageHello->sNick.Data(), Config->GetUserIcon(euitUSER) );
		pui->MyInfo.sNick = MessageHello->sNick;
		pui->MyInfo.bOperator = FALSE;
		pui->MyInfo.eAwayMode = euamNORMAL;
	}

	pui->pItem->mycol = 4;

	UpdateStatusBar();
}

/** quit */
void DCClient::DC_Quit( CMessageQuit * MessageQuit )
{
	DCUserItem * pui=0;
	if ( pUserList->Get( MessageQuit->sNick, (CObject*&)pui ) == 0 )
	{
		ListView_USERLIST->takeItem(pui->pItem);
		delete pui->pItem;
		pUserList->Del(MessageQuit->sNick);
	}

	UpdateStatusBar();
}

/** nicklist */
void DCClient::DC_NickList( CMessageNickList * MessageNickList )
{
	QString s = "";
	CString * Nick = 0;

	ListView_USERLIST->setUpdatesEnabled(FALSE);
	ListView_USERLIST->clear();

	pUserList->Clear();

	while ( (Nick=MessageNickList->NickList.Next(Nick)) != 0 )
	{
		DCUserItem * pui = new DCUserItem();
		pUserList->Add(*Nick,pui);

		pui->pItem = new DC_QCheckListItem( ListView_USERLIST, (*Nick).Data(), Config->GetUserIcon(euitUSER) );
		pui->pItem->mycol = 4;
		pui->MyInfo.sNick = (*Nick);
		pui->MyInfo.bOperator = FALSE;
		pui->MyInfo.eAwayMode = euamNORMAL;
	}

	ListView_USERLIST->setUpdatesEnabled(TRUE);
	ListView_USERLIST->triggerUpdate();

	UpdateStatusBar();
}

/** oplist */
void DCClient::DC_OpList( CMessageNickList * MessageOpList )
{
	CString * Nick = 0;

	ListView_USERLIST->setUpdatesEnabled(FALSE);

	while ( (Nick=MessageOpList->NickList.Next(Nick)) != 0 )
	{
		DCUserItem * pui=0;
		if ( pUserList->Get( *Nick, (CObject*&)pui ) == -1 )
		{
			pui = new DCUserItem();
			pUserList->Add(*Nick,pui);

			pui->pItem = new DC_QCheckListItem( ListView_USERLIST, (*Nick).Data(), Config->GetUserIcon(euitOPERATOR) );
			pui->pItem->mycol = 4;
			pui->MyInfo.sNick = (*Nick);
		}
		else
		{
			if ( pui->MyInfo.bOperator == FALSE )
				pui->pItem->setPixmap( 0, Config->GetUserIcon(euitOPERATOR) );
		}

		pui->MyInfo.bOperator = TRUE;
		pui->MyInfo.eAwayMode = euamNORMAL;
	}

	ListView_USERLIST->setUpdatesEnabled(TRUE);
	ListView_USERLIST->triggerUpdate();

	UpdateStatusBar();
}

/** */
void DCClient::DC_PrivateChat( QString nick, QString message, bool bLocal )
{
	DCChat * chat;

	if ( nick == "" )
	{
		return;
	}

	chat = 0;
	while( (chat=pChatList->Next(chat)) != 0 )
	{
		if ( chat->GetNick() == nick )
		{
			if ( message != "" )
			{
				chat->AddMessage( nick, message );

				if ( chat->isVisible() == FALSE )
				{
					SetNickColor( nick, Qt::red );
				}
				else
				{
					SetNickColor( nick, Qt::black );
				}
			}

			break;
		}
        }

	if( chat == 0 )
	{
		chat = new DCChat(pWorkspace,0,WDestructiveClose);

		if ( (bLocal == TRUE) || (Config->GetOpenPrivateChatWindow() == TRUE) )
		{
			chat->show();
		}
		else
		{
			chat->hide();
			chat->setEnabled(FALSE);
			SetNickColor( nick, Qt::red );
		}

		chat->installEventFilter(this);
		chat->SetClient(this);
		chat->SetNick(nick,GetHubName().Data());

		ListBox_USERCHAT->insertItem(nick);

		if ( message != "" )
		{
			chat->AddMessage( nick, message );
		}

		pChatList->Add(chat);

		Config->PlaySound(eusCHAT);
	}
}

/** search */
void DCClient::DC_Search( CMessageSearch * MessageSearch )
{
	QString s;

	s = MessageSearch->sString.Data();
	s = s.replace( QRegExp("\\$"), " " );

	if ( CheckBox_SPYON->isChecked() )
	{
		TextEdit_SPY->append(s);
	}
}

/** search result */
void DCClient::DC_SearchResult( CMessageSearchResult * MessageSearchResult )
{
	int i;
	QString s,spath,sname;
	DCFileTool FileTool;

	if ( SpinBox_MAXRESULT->value() > 0 )
	{
		if ( ListView_SEARCHRESULT->childCount() >= SpinBox_MAXRESULT->value() )
		{
			return;
		}
	}

	if ( MessageSearchResult->iFreeSlot < SpinBox_FREESLOTS->value() )
	{
		return;
	}

	// split filename and path
	s = MessageSearchResult->sFile.Data();

	if ( (i = s.findRev('\\')) == -1 )
	{
		spath = "";
		sname = s;
	}
	else
	{
		spath = s.left(i+1);
		sname = s.mid(i+1,s.length()-i-1);
	}

//	if (0)
//	{
/*
		ListView_SEARCHRESULT->setRootIsDecorated(TRUE);

		item = ListView_SEARCHRESULT->findItem( sname, 0 );

		if ( item == 0 )
		{
			item = new QListViewItem(ListView_SEARCHRESULT, \
				sname, \
				MessageSearchResult->sSize.Data() );
		}
		else if ( item->text(1) != MessageSearchResult->sSize.Data() )
		{
			item = new QListViewItem(ListView_SEARCHRESULT, \
				sname, \
				MessageSearchResult->sSize.Data() );
		}

		new QListViewItem(item, \
			sname, \
			MessageSearchResult->sSize.Data(), \
			MessageSearchResult->sNick.Data(), \
			MessageSearchResult->sSlot.Data(), \
			MessageSearchResult->sHubName.Data(), \
			spath,
			MessageSearchResult->sHubHost.Data() );

		item->setText(2,QString().setNum(item->childCount()));
*/
//	}
//	else
	{
		ListView_SEARCHRESULT->setRootIsDecorated(FALSE);

		s = FileTool.GetSizeString(MessageSearchResult->lSize).Data();

		DC_QListViewItem *item = new DC_QListViewItem(ListView_SEARCHRESULT);
		item->myvalue = MessageSearchResult->lSize;
		item->mycol = 1;

		item->setText(0,sname);
		item->setText(1,s);
		item->setText(2,MessageSearchResult->sNick.Data());
		item->setText(3,QString().setNum(MessageSearchResult->iFreeSlot)+'/'+QString().setNum(MessageSearchResult->iMaxSlot));
		item->setText(4,MessageSearchResult->sHubName.Data());
		item->setText(5,spath);
		item->setText(6,MessageSearchResult->sHubHost.Data());
	}

	LCDNumber_RESULTS->display(ListView_SEARCHRESULT->childCount());
}

/** */
void DCClient::SetNickColor( QString nick, QColor color )
{
	DC_QCheckListItem *item;

	if ( (item = (DC_QCheckListItem *)ListView_USERLIST->findItem( nick, 0 )) != 0 )
	{
		if ( item->colorText != color )
		{
			item->colorText = color;
			item->repaint();
		}
	}
}

/** */
void DCClient::slotChatReturnPressed()
{
	if ( LineEdit_CHATINPUT->text() != "" )
	{
		SendChat( GetNick(), LineEdit_CHATINPUT->text().ascii() );
		LineEdit_CHATINPUT->setText("");
	}
}

/** */
void DCClient::slotSearchReturnPressed()
{
	QString s;

	ListView_SEARCHRESULT->clear();
	LCDNumber_RESULTS->display(0);

	s = GetSearchString();

	if ( s != "" )
	{
		SendString( s.ascii() );
	}
	else
	{
		QMessageBox::critical( this, tr("Search Error"),
			QString(tr("You must enter a search word.")));
	}
}

/** */
QString DCClient::GetSearchString()
{
	ulonglong size;
	QString s,l;

	l = LineEdit_SEARCH->text();

	if ( l == "" )
	{
		return "";
	}

	// replace spaces with $
	l = l.replace( QRegExp(" "), "$" );

	s = "$Search ";

	s += QString("Hub:") + GetNick().Data() + " ";

	size = SpinBox_SEARCHSIZE->value();

	if ( size == 0 )
	{
		s += "F?";
	}
	else
	{
		s += "T?";
	}

	if ( ComboBox_SEARCHUNIT->currentItem() == 0 )
	{
		size *= 1024;
	}
	else if ( ComboBox_SEARCHUNIT->currentItem() == 1 )
	{
		size *= 1024*1024;
	}
	else
	{
		size *= 1024*1024*1024;
	}

	// F is default
	if ( (ComboBox_SEARCHLIMIT->currentItem() == 0) || (size==0) )
	{
		s += "F?";
	}
	else
	{
		s += "T?";
	}

	s += CString().setNum(size).Data() + QString("?");

	s += QString().setNum(ComboBox_SEARCHTYPE->currentItem()+1) + "?";

	s += l + "|";

	return s;
}

/** */
void DCClient::slotDoubleClickedSearchResult( QListViewItem * )
{
}

/** */
void DCClient::slotDoubleClickedUserList( QListViewItem * item )
{
	if ( item == 0 )
	{
		return;
	}

	DC_PrivateChat( item->text(0), "", TRUE );
}

/** */
void DCClient::slotRightButtonClickedUserList( QListViewItem * item, const QPoint &, int column )
{
	int id;
	QPopupMenu *m;
	QString username;

	if ( item == 0 )
	{
		return;
	}

	username = item->text(0);

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, tr("User: ") + username, FALSE );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiPRIVATE_CHAT );
	DCMenuHandler::InsertMenuItem( m, emiBROWSE_USER_FILES );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiADD_USER_SLOT );
	DCMenuHandler::InsertMenuItem( m, emiADD_PERMANENT_USER_SLOT );
	DCMenuHandler::InsertMenuItem( m, emiREMOVE_USER_SLOT );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiUPDATE_USER );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiCOPY_COLUMN_TO_CLIPBOARD );
	DCMenuHandler::InsertMenuItem( m, emiCOPY_ROW_TO_CLIPBOARD );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiKICK, IsAdmin() );
	DCMenuHandler::InsertMenuItem( m, emiFORCE_MOVE, IsAdmin() );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( id == emiPRIVATE_CHAT )
	{
		DC_PrivateChat( username, "", TRUE );
	}
	else if ( id == emiBROWSE_USER_FILES )
	{
		if ( GetMode() == ecmNone )
		{
			return;
		}

		/** add transfer to the waitlist */
		pTransferView->AddWaitTransfer( username.ascii(), GetHubName(), GetIP()+":"+QString().setNum(GetPort()).ascii(),
						"MyList.DcLst", "MyList.DcLst", "", "", eltBUFFER,
						0, 0, 0 );
	}
	else if ( id == emiUPDATE_USER )
	{
		CString s = CString("$GetINFO ") + username.ascii() + " " + GetNick() + "|";

		// send getinfo
		SendString( s );
	}
	else if ( id == emiCOPY_COLUMN_TO_CLIPBOARD )
	{
		QListViewItem *item1;
		QClipboard *cb = QApplication::clipboard();
		cb->setText("");

		if ( (item1=ListView_USERLIST->currentItem()) != 0 )
		{
			cb->setText( item->text(column) );
		}
	}
	else if ( id == emiCOPY_ROW_TO_CLIPBOARD )
	{
		int idx;
		QString s="";
		QListViewItem *item1;
		QClipboard *cb = QApplication::clipboard();
		cb->setText("");

		if ( (item1=ListView_USERLIST->currentItem()) != 0 )
		{
			for( idx = 0; idx < ListView_USERLIST->columns(); idx++ )
			{
				s += item1->text(idx) + "\n";
			}
			cb->setText(s);
		}
	}
	else if ( id == emiADD_USER_SLOT )
	{
		pTransferView->AddUserSlot(username.ascii(), GetHubName(), 1);
	}
	else if ( id == emiADD_PERMANENT_USER_SLOT )
	{
		pTransferView->AddUserSlot(username.ascii(), GetHubName(), 0, TRUE);
	}
	else if ( id == emiREMOVE_USER_SLOT )
	{
		pTransferView->AddUserSlot(username.ascii(), GetHubName(), 0);
	}
	else if ( id == emiKICK )
	{
		bool ok = FALSE;
		QString kickmessage;

		kickmessage = QInputDialog::getText(
			tr("OP Kick"),
			tr("Please enter a reason"),
			QLineEdit::Normal, QString::null, &ok, this );

		if ( !ok )
		{
			return;
		}

		SendPrivateMessage( GetNick(), username.ascii(), ("You Are Being kicked Because: " + kickmessage).ascii());
		SendChat( GetNick(), GetNick() + " is kicking " + username.ascii() + " Because: " + kickmessage.ascii() );
		SendKick(username.ascii());
	}
	else if ( id == emiFORCE_MOVE )
	{
		bool ok = FALSE;
		QString host,message;

		host = QInputDialog::getText(
			tr("OP Force Move"),
			tr("Please enter host"),
			QLineEdit::Normal, QString::null, &ok, this );

		if ( !ok )
		{
			return;
		}

		ok = FALSE;
		message = QInputDialog::getText(
			tr("OP Force Move"),
			tr("Please enter a message"),
			QLineEdit::Normal, QString::null, &ok, this );

		if ( !ok )
		{
			return;
		}

		SendOpForceMove(username.ascii(),host.ascii(),message.ascii());
	}
}

/** */
void DCClient::slotRightButtonClickedSearchResult( QListViewItem * item, const QPoint &, int column )
{
	DCFileTool filetool;
	CString s;
	int id;
	ulonglong pos;
	ulonglong size;
	QPopupMenu *m;

	if ( item == 0 )
	{
		return;
	}

	size = ((DC_QListViewItem *)item)->myvalue;

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiDOWNLOAD );
	DCMenuHandler::InsertMenuItem( m, emiDOWNLOAD_TO );
	DCMenuHandler::InsertMenuItem( m, emiDOWNLOAD_AS );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiBROWSE_USER_FILES );
	DCMenuHandler::InsertMenuItem( m, emiPRIVATE_CHAT );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiCOPY_COLUMN_TO_CLIPBOARD );
	DCMenuHandler::InsertMenuItem( m, emiCOPY_ROW_TO_CLIPBOARD );
	DCMenuHandler::InsertMenuItem( m, emiSEPARATOR );
	DCMenuHandler::InsertMenuItem( m, emiKICK, IsAdmin() );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == -1 )
	{
		return;
	}

	if ( (id == emiDOWNLOAD) || (id == emiDOWNLOAD_AS) || (id == emiDOWNLOAD_TO) )
	{
		QString localrootpath = "";
		QString localname = "";

		localname = item->text(0);

		// select downloadfolder
		if ( id == emiDOWNLOAD_TO )
		{
			localrootpath = QFileDialog::getExistingDirectory( "", this, "bdf", tr("Select download folder"), TRUE );

			if ( localrootpath == "" )
				return;
		}
		else if ( id == emiDOWNLOAD_AS )
		{
			localrootpath = QFileDialog::getSaveFileName( "", "", this, "bdf", tr("Select file") );

			if ( localrootpath == "" )
				return;

			QFileInfo fi(localrootpath);
			localrootpath = fi.dirPath();
			localname     = fi.fileName();

			if ( (localrootpath=="") || (localname=="") )
				return;
		}

		if ( filetool.CheckFile( localname, size, pos, localrootpath ) == FALSE )
		{
			return;
		}

		/** add transfer to the waitlist */
		pTransferView->AddWaitTransfer( item->text(2).ascii(), item->text(4).ascii(), item->text(6).ascii(),
						(item->text(5)+item->text(0)).ascii(), localname.ascii(), "", localrootpath.ascii(), eltFILE,
						size, pos, size );
	}
	else if ( id == emiBROWSE_USER_FILES)
	{
		if ( GetMode() == ecmNone )
		{
			return;
		}

		/** add transfer to the waitlist */
		pTransferView->AddWaitTransfer( item->text(2).ascii(), item->text(4).ascii(), item->text(6).ascii(),
						"MyList.DcLst", "MyList.DcLst", "", "", eltBUFFER,
						0, 0, 0 );
	}
	else if ( id == emiPRIVATE_CHAT )
	{
		// open private chat window (only in current hub)
		if ( item->text(4) == GetHubName().Data() )
		{
			DC_PrivateChat( item->text(2), "", TRUE );
		}
		else
		{
			QMessageBox::information( 0, "DC-GUI", tr("Private chat only in current hub !") );
		}
	}
	else if ( id == emiCOPY_COLUMN_TO_CLIPBOARD )
	{
		QListViewItem *item1;
		QClipboard *cb = QApplication::clipboard();
		cb->setText("");

		if ( (item1=ListView_SEARCHRESULT->currentItem()) != 0 )
		{
			cb->setText( item->text(column) );
		}
	}
	else if ( id == emiCOPY_ROW_TO_CLIPBOARD )
	{
		int idx;
		QString s="";
		QListViewItem *item1;
		QClipboard *cb = QApplication::clipboard();
		cb->setText("");

		if ( (item1=ListView_SEARCHRESULT->currentItem()) != 0 )
		{
			for( idx = 0; idx < ListView_SEARCHRESULT->columns(); idx++ )
			{
				s += item1->text(idx) + "\n";
			}
			cb->setText(s);
		}
	}
	else if ( id == emiKICK )
	{
		bool ok = FALSE;
		QString kickmessage;

		kickmessage = QInputDialog::getText(
			tr("OP Kick"),
			tr("Please enter a reason"),
			QLineEdit::Normal, QString::null, &ok, this );

		if ( !ok )
		{
			return;
		}

		SendPrivateMessage( GetNick(), item->text(2).ascii(), ("You Are Being kicked Because: " + kickmessage).ascii());
		SendChat( GetNick(), GetNick() + " is kicking " + item->text(2).ascii() + " Because: " + kickmessage.ascii() );
		SendKick(item->text(2).ascii());
	}
}

/** */
void DCClient::slotDoubleClickedUserChat( QListBoxItem * item )
{
	DCChat * chat;
	QString nick;

	if ( item == 0 )
	{
		return;
	}

	nick = item->text();

	if ( nick == "" )
	{
		return;
	}

	chat = 0;
	while( (chat=pChatList->Next(chat)) != 0 )
	{
		if ( chat->GetNick() == nick )
		{
			chat->setEnabled(TRUE);
			chat->show();
			SetNickColor(nick,Qt::black);
			return;
		}
        }
}

/** */
void DCClient::slotRightButtonClickedConnState()
{
	int id;

	QPopupMenu *m;

	m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem( m, emiCONNECT, (GetConnectionState() == estNONE) );
	DCMenuHandler::InsertMenuItem( m, emiDISCONNECT, (GetConnectionState() == estCONNECTED));
	DCMenuHandler::InsertMenuItem( m, emiRELOAD_USERLIST, (GetConnectionState() == estCONNECTED) );

	id = m->exec(QCursor::pos());

	delete m;

	if ( id == emiCONNECT )
	{
		Connect();
		SetReconnectParams( ersNONE, 0 );
	}
	else if ( id == emiDISCONNECT )
	{
		Disconnect();
		SetReconnectParams( ersDISABLED );
	}
	else if ( id == emiRELOAD_USERLIST )
	{
		RequestNickList();
	}
}
