/***************************************************************************
                          dcchat.cpp  -  description
                             -------------------
    begin                : Don Mr 28 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qdatetime.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <dcclient.h>

#include "dcchat.h"

/** */
DCChat::DCChat(QWidget* parent, const char *name, int wflags) : DCDialogChat(parent, name, wflags)
{
	Client = 0;

	InitDocument();
}

/** */
DCChat::~DCChat()
{
}

/** */
void DCChat::InitDocument()
{
	connect( LineEdit_CHAT,    SIGNAL(returnPressed()), this, SLOT(slotChatReturnPressed()) );
	connect( PushButton_HIDE,  SIGNAL(clicked()), this, SLOT(slotClickedHide()) );
	connect( PushButton_CLEAR, SIGNAL(clicked()), this, SLOT(slotClickedClear()) );
}

/** */
void DCChat::slotClickedClear()
{
	TextEdit_CHAT->clear();
}

/** */
void DCChat::slotClickedHide()
{
	setEnabled(FALSE);
	hide();
}

/** */
void DCChat::SetNick( QString nick, QString hubname )
{
	sNick = nick;

	setCaption(tr("Private Chat:")+" "+nick+" ["+hubname+"]");
}

/** */
void DCChat::AddMessage( QString, QString message )
{
	bool bscroll;

	if ( message == "" )
	{
		return;
	}

	if ( TextEdit_CHAT->verticalScrollBar()->maxValue() == TextEdit_CHAT->verticalScrollBar()->value() )
	{
		bscroll = TRUE;
	}
	else
	{
		bscroll = FALSE;
	}

	TextEdit_CHAT->append( QTime::currentTime().toString("[hh:mm:ss] ") + message);

	if ( bscroll )
	{
		TextEdit_CHAT->scrollToBottom();
		TextEdit_CHAT->moveCursor( QTextEdit::MoveEnd, FALSE );
	}
}

/** */
void DCChat::slotChatReturnPressed()
{
	bool bscroll;

	if ( LineEdit_CHAT->text() != "" )
	{
		if ( Client )
		{
			if ( TextEdit_CHAT->verticalScrollBar()->maxValue() == TextEdit_CHAT->verticalScrollBar()->value() )
			{
				bscroll = TRUE;
			}
			else
			{
				bscroll = FALSE;
			}

			if ( Client->SendPrivateMessage( Client->GetNick(), sNick.ascii(), LineEdit_CHAT->text().ascii() ) == 0 )
			{
				TextEdit_CHAT->append( QTime::currentTime().toString("[hh:mm:ss] ") + QString("<") + Client->GetNick().Data() + "> " + LineEdit_CHAT->text().ascii() );
			}
			else
			{
				TextEdit_CHAT->append( QTime::currentTime().toString("[hh:mm:ss] ") + "<DCGUI> " + tr("Message not send !") );
			}

			if ( bscroll )
			{
				TextEdit_CHAT->scrollToBottom();
				TextEdit_CHAT->moveCursor( QTextEdit::MoveEnd, FALSE );
			}
		}

		LineEdit_CHAT->setText("");
	}
}
