/***************************************************************************
                          dcbrowsefiletree.h  -  description
                             -------------------
    begin                : Tue Feb 26 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCBROWSEFILETREE_H
#define DCBROWSEFILETREE_H

#include <dclib/dcos.h>
#include <DCDialogBrowseFileTree.h>

/**
  *@author Mathias Kster
  */

class DCTransfer;

class DCBrowseFileTree : public DCDialogBrowseFileTree {
Q_OBJECT
public:
        /** */
	DCBrowseFileTree(QWidget* parent=0, const char *name=0, int wflags=0, bool viewonly=FALSE);
        /** */
	virtual ~DCBrowseFileTree();
	/** */
	void InitDocument();
	/** */
	void InitTree( QString nick, QString hubname, QString hubhost, QString s );
	/** */
	void SendAllFiles( QString remotepath, QString localpath, QString localrootpath, QListViewItem * item );
	/** */
	QString CreateRemotePath( QListViewItem * item );

	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	QString sNick;
	/** */
	QString sHubName;
	/** */
	QString sHubHost;

private slots:
	/** */
	void slotRightButtonClickedFileList(QListViewItem*, const QPoint &, int );
};

#endif
