/***************************************************************************
                          dcbrowsefiletree.cpp  -  description
                             -------------------
    begin                : Tue Feb 26 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@ketelhot.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <qstring.h>
#include <qregexp.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qfiledialog.h>
#include <qlineedit.h>

#include <dcconfig.h>
#include <dcfiletool.h>
#include <dctransferview.h>
#include <dcmenuhandler.h>

#include "dcbrowsefiletree.h"

DCBrowseFileTree::DCBrowseFileTree(QWidget* parent, const char *name, int wflags,bool viewonly) : DCDialogBrowseFileTree(parent,name,wflags)
{
	int idx;

	// set the ColumnWidthMode to manual, we will take care of this task
	for( idx = 0; idx < ListView_FILETREE->columns(); idx++ )
	{
		ListView_FILETREE->setColumnWidthMode( idx, QListView::Manual );
	}

	if( viewonly == FALSE )
	{
		InitDocument();
	}
}

DCBrowseFileTree::~DCBrowseFileTree()
{
}

/** overridden so that the columns are resized on show() */
void DCBrowseFileTree::show()
{
	QWidget::show();

	ResizeListViewColumn();
}

/** resize event handler */
void DCBrowseFileTree::resizeEvent( QResizeEvent * )
{
	ResizeListViewColumn();
}

/** resize the ListView columns */
void DCBrowseFileTree::ResizeListViewColumn()
{
	int width;

	if ( ListView_FILETREE->isVisible() )
	{
		width = ListView_FILETREE->width();

		ListView_FILETREE->setColumnWidth( 0, ((width*8)/10) );
		ListView_FILETREE->setColumnWidth( 1, ((width*2)/10) );
	}
}

/** */
void DCBrowseFileTree::InitDocument()
{
	connect( ListView_FILETREE, SIGNAL(rightButtonClicked( QListViewItem *, const QPoint &, int )), this, SLOT(slotRightButtonClickedFileList(QListViewItem*, const QPoint &, int )) );
}

/** */
void DCBrowseFileTree::InitTree( QString nick, QString hubname, QString hubhost, QString s )
{
	QListViewItem * item;
	QString s1,sname,slength;
	long i,j,d;
	int depth;
	ulonglong filecount;
	ulonglong shared;

	sNick    = nick;
	sHubName = hubname;
	sHubHost = hubhost;

	i = j = 0;
	filecount = 0;
	shared = 0;
	item = 0;

	ListView_FILETREE->setUpdatesEnabled(FALSE);

	while((i=s.find("\xD\xA",j))>0)
	{
		s1 = s.mid(j,i-j);

		depth=0;
		while( (s1.find("\x9",depth)) != -1 )
			depth++;
		s1 = s1.replace( QRegExp("\x9"), "" );

		if (item)
			while ( depth <= item->depth() )
				if ( (item=item->parent()) == 0 )
					break;

		if ( s1 != "" )
		{
			d = s1.findRev("|");

			if ( d != -1 ) // parse file entry
			{
				filecount++;

				sname   = s1.mid(0,d);
				slength = s1.right(s1.length()-d-1);

				if ( slength == "" )
					slength = tr("<wrong length>");
				else
					shared += CString(slength.ascii()).asULL();

				if (item==0)
					new QListViewItem( ListView_FILETREE, sname, slength );
				else
					new QListViewItem( item, sname, slength );
			}
			else // parse dir entry
			{
				if (item==0)
					item = new QListViewItem( ListView_FILETREE, s1 );
				else
					item = new QListViewItem( item, s1 );
			}
		}

		j = i+2;
	}

	LineEdit_FILES->setText( CString().setNum(filecount).Data() );
	LineEdit_SHARED->setText( DCFileTool::GetSizeString(shared).Data() );

	ListView_FILETREE->setUpdatesEnabled(TRUE);
	ListView_FILETREE->triggerUpdate();
}

/** */
QString DCBrowseFileTree::CreateRemotePath( QListViewItem * item )
{
	QString s;
	QListViewItem * pitem;

	if(!item)
		return "";

	pitem = item;
	s = item->text(0);

	while ( (pitem=pitem->parent()) != 0 )
	{
		s = pitem->text(0) + "\\" + s;
	}

	return s;
}

/** */
void DCBrowseFileTree::slotRightButtonClickedFileList( QListViewItem * item, const QPoint &, int )
{
	// no nick for download
	if ( sNick == "" )
	{
		return;
	}

	if( item == 0 )
	{
		return;
	}

	QPopupMenu* m = new QPopupMenu(this);

	DCMenuHandler::InsertMenuItem(m, emiDOWNLOAD);
	DCMenuHandler::InsertMenuItem(m, emiDOWNLOAD_TO);
	// disable 'download as' on directories
	DCMenuHandler::InsertMenuItem(m, emiDOWNLOAD_AS,
				(item->text(1) == "" ? FALSE : TRUE));

	int id = m->exec(QCursor::pos());

	delete m;

	if (id == -1)
	{
		return;
	}

	QString rootPath = "";
	QString localName = item->text(0);

	// Check if the user wants a non-default destination
	if (id == emiDOWNLOAD_TO)
	{
		rootPath = QFileDialog::getExistingDirectory("", this, "dldia",
                                                     tr("Select destination"));
		if (rootPath == QString::null)
		{
			// If the user cancel, then we don't download
			return;
		}
	}
	// Should the file be renamed
	else if(id == emiDOWNLOAD_AS)
	{
		rootPath = QFileDialog::getSaveFileName("", "", this, "dldia",
                                                tr("Select a filename"));
		if (rootPath == QString::null)
		{
			return;
		}

		QFileInfo fi(rootPath);
		rootPath = fi.dirPath();
		localName = fi.fileName();

		if (rootPath == "" || localName == "")
		{
			return;
		}
	}

	// Is this a download?
	if ( (id == emiDOWNLOAD) || (id == emiDOWNLOAD_TO) || (id == emiDOWNLOAD_AS) )
	{
		QString remotePath = CreateRemotePath(item);

		// Directory download
		if ( item->text(1) == QString::null )
		{
			SendAllFiles(remotePath, item->text(0), rootPath, item);
		}
		// Single file download
		else
		{
			ulonglong size = CString(item->text(1).ascii()).asULL();
			DCFileTool filetool;
			ulonglong pos = 0;
			if (filetool.CheckFile(localName, size, pos, rootPath) == FALSE )
			{
				return;
			}

			pTransferView->AddWaitTransfer(sNick.ascii(),
                                           sHubName.ascii(),
                                           sHubHost.ascii(),
                                           remotePath.ascii(),
                                           localName.ascii(), "",
                                           rootPath.ascii(), eltFILE,
                                           size, pos, size);
		}
	}
}

/** */
void DCBrowseFileTree::SendAllFiles( QString remotepath, QString localpath, QString localrootpath, QListViewItem * item )
{
	QString s;
	QListViewItem * item1;

	if ( item == 0 )
	{
		return;
	}

	if ( item->childCount() == 0 )
	{
		return;
	}

	item1 = item->firstChild();

	while(item1)
	{
		if ( item1->text(1) == "" )
		{
			SendAllFiles( remotepath + "\\" + item1->text(0), localpath + "\\" + item1->text(0), localrootpath, item1 );
		}

		if ( item1->text(1) != "" )
		{
			s = remotepath + "\\" + item1->text(0);

			// todo: check file ...
			pTransferView->AddWaitTransfer( sNick.ascii(), sHubName.ascii(), sHubHost.ascii(),
							s.ascii(), item1->text(0).ascii(), localpath.ascii(), localrootpath.ascii(), eltFILE,
							CString(item1->text(1).ascii()).asULL(), 0, CString(item1->text(1).ascii()).asULL() );
		}

		item1 = item1->nextSibling();
	}
}
