// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/type/matcher/string.proto

package envoy_type_matcher

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// Validate checks the field values on StringMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *StringMatcher) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for IgnoreCase

	switch m.MatchPattern.(type) {

	case *StringMatcher_Exact:
		// no validation rules for Exact

	case *StringMatcher_Prefix:

		if utf8.RuneCountInString(m.GetPrefix()) < 1 {
			return StringMatcherValidationError{
				field:  "Prefix",
				reason: "value length must be at least 1 runes",
			}
		}

	case *StringMatcher_Suffix:

		if utf8.RuneCountInString(m.GetSuffix()) < 1 {
			return StringMatcherValidationError{
				field:  "Suffix",
				reason: "value length must be at least 1 runes",
			}
		}

	case *StringMatcher_Regex:

		if len(m.GetRegex()) > 1024 {
			return StringMatcherValidationError{
				field:  "Regex",
				reason: "value length must be at most 1024 bytes",
			}
		}

	case *StringMatcher_SafeRegex:

		if m.GetSafeRegex() == nil {
			return StringMatcherValidationError{
				field:  "SafeRegex",
				reason: "value is required",
			}
		}

		if v, ok := interface{}(m.GetSafeRegex()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return StringMatcherValidationError{
					field:  "SafeRegex",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return StringMatcherValidationError{
			field:  "MatchPattern",
			reason: "value is required",
		}

	}

	return nil
}

// StringMatcherValidationError is the validation error returned by
// StringMatcher.Validate if the designated constraints aren't met.
type StringMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StringMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StringMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StringMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StringMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StringMatcherValidationError) ErrorName() string { return "StringMatcherValidationError" }

// Error satisfies the builtin error interface
func (e StringMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStringMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StringMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StringMatcherValidationError{}

// Validate checks the field values on ListStringMatcher with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ListStringMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPatterns()) < 1 {
		return ListStringMatcherValidationError{
			field:  "Patterns",
			reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetPatterns() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListStringMatcherValidationError{
					field:  fmt.Sprintf("Patterns[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// ListStringMatcherValidationError is the validation error returned by
// ListStringMatcher.Validate if the designated constraints aren't met.
type ListStringMatcherValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListStringMatcherValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListStringMatcherValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListStringMatcherValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListStringMatcherValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListStringMatcherValidationError) ErrorName() string {
	return "ListStringMatcherValidationError"
}

// Error satisfies the builtin error interface
func (e ListStringMatcherValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListStringMatcher.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListStringMatcherValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListStringMatcherValidationError{}
