/// <reference types="react" />
import { ButtonProps } from '@patternfly/react-core';
import { TableGridBreakpoint, OnSelect, SortByDirection, ICell } from '@patternfly/react-table';
import { RouteComponentProps } from 'react-router';
import { ExtensionK8sGroupKindModel, K8sKind, PrometheusLabels, PrometheusValue, ResolvedExtension } from '../api/common-types';
import { Extension, ExtensionTypeGuard } from '../types';
export declare type OwnerReference = {
    name: string;
    kind: string;
    uid: string;
    apiVersion: string;
    controller?: boolean;
    blockOwnerDeletion?: boolean;
};
export declare type ObjectReference = {
    kind?: string;
    namespace?: string;
    name?: string;
    uid?: string;
    apiVersion?: string;
    resourceVersion?: string;
    fieldPath?: string;
};
export declare type ObjectMetadata = {
    annotations?: {
        [key: string]: string;
    };
    clusterName?: string;
    creationTimestamp?: string;
    deletionGracePeriodSeconds?: number;
    deletionTimestamp?: string;
    finalizers?: string[];
    generateName?: string;
    generation?: number;
    labels?: {
        [key: string]: string;
    };
    managedFields?: any[];
    name?: string;
    namespace?: string;
    ownerReferences?: OwnerReference[];
    resourceVersion?: string;
    uid?: string;
};
export declare type K8sResourceCommon = {
    apiVersion?: string;
    kind?: string;
    metadata?: ObjectMetadata;
};
export declare type K8sVerb = 'create' | 'get' | 'list' | 'update' | 'patch' | 'delete' | 'deletecollection' | 'watch';
export declare type AccessReviewResourceAttributes = {
    group?: string;
    resource?: string;
    subresource?: string;
    verb?: K8sVerb;
    name?: string;
    namespace?: string;
};
export declare type MatchExpression = {
    key: string;
    operator: 'Exists' | 'DoesNotExist' | 'In' | 'NotIn' | 'Equals' | 'NotEqual';
    values?: string[];
    value?: string;
};
export declare type MatchLabels = {
    [key: string]: string;
};
export declare type Selector = {
    matchLabels?: MatchLabels;
    matchExpressions?: MatchExpression[];
};
/**
 * GroupVersionKind unambiguously identifies a kind.
 * https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupVersionKind
 * TODO: Change this to a regex-type if it ever becomes a thing (https://github.com/Microsoft/TypeScript/issues/6579)
 */
export declare type GroupVersionKind = string;
/**
 * The canonical, unique identifier for a Kubernetes resource type.
 * Maintains backwards-compatibility with references using the `kind` string field.
 */
export declare type K8sResourceKindReference = GroupVersionKind | string;
declare enum InventoryStatusGroup {
    WARN = "WARN",
    ERROR = "ERROR",
    PROGRESS = "PROGRESS",
    NOT_MAPPED = "NOT_MAPPED",
    UNKNOWN = "UNKNOWN"
}
declare type StatusGroup = {
    [key in InventoryStatusGroup | string]: {
        filterType?: string;
        statusIDs: string[];
        count: number;
    };
};
export declare type StatusGroupMapper<T extends K8sResourceCommon = K8sResourceCommon, R extends {
    [key: string]: K8sResourceCommon[];
} = {
    [key: string]: K8sResourceCommon[];
}> = (resources: T[], additionalResources?: R) => StatusGroup;
export declare enum HealthState {
    OK = "OK",
    ERROR = "ERROR",
    WARNING = "WARNING",
    LOADING = "LOADING",
    UNKNOWN = "UNKNOWN",
    UPDATING = "UPDATING",
    PROGRESS = "PROGRESS",
    UPGRADABLE = "UPGRADABLE",
    NOT_AVAILABLE = "NOT_AVAILABLE"
}
export declare type PrometheusResult = {
    metric: PrometheusLabels;
    values?: PrometheusValue[];
    value?: PrometheusValue;
};
export declare type PrometheusData = {
    resultType: 'matrix' | 'vector' | 'scalar' | 'string';
    result: PrometheusResult[];
};
export declare type PrometheusResponse = {
    status: string;
    data: PrometheusData;
    errorType?: string;
    error?: string;
    warnings?: string[];
};
export declare type WatchK8sResource = {
    kind: K8sResourceKindReference;
    name?: string;
    namespace?: string;
    isList?: boolean;
    selector?: Selector;
    namespaced?: boolean;
    limit?: number;
    fieldSelector?: string;
    optional?: boolean;
};
export declare type ResourcesObject = {
    [key: string]: K8sResourceCommon | K8sResourceCommon[];
};
export declare type WatchK8sResultsObject<R extends K8sResourceCommon | K8sResourceCommon[]> = {
    data: R;
    loaded: boolean;
    loadError: any;
};
export declare type WatchK8sResults<R extends ResourcesObject> = {
    [k in keyof R]: WatchK8sResultsObject<R[k]>;
};
export declare type WatchK8sResources<R extends ResourcesObject> = {
    [k in keyof R]: WatchK8sResource;
};
export declare type WatchK8sResourcesGeneric = {
    [key: string]: {
        model?: ExtensionK8sGroupKindModel;
        opts?: Partial<WatchK8sResource>;
    };
};
export declare type FirehoseResource = {
    kind: K8sResourceKindReference;
    name?: string;
    namespace?: string;
    isList?: boolean;
    selector?: Selector;
    prop: string;
    namespaced?: boolean;
    optional?: boolean;
    limit?: number;
    fieldSelector?: string;
};
export declare type FirehoseResult<R extends K8sResourceCommon | K8sResourceCommon[] = K8sResourceCommon[]> = {
    loaded: boolean;
    loadError: string;
    optional?: boolean;
    data: R;
    kind?: string;
};
export declare type FirehoseResourcesResult = {
    [key: string]: FirehoseResult<K8sResourceCommon | K8sResourceCommon[]>;
};
export declare type WatchK8sResult<R extends K8sResourceCommon | K8sResourceCommon[]> = [R, boolean, any];
export declare type UseK8sWatchResource = <R extends K8sResourceCommon | K8sResourceCommon[]>(initResource: WatchK8sResource | null) => WatchK8sResult<R>;
export declare type UseK8sWatchResources = <R extends ResourcesObject>(initResources: WatchK8sResources<R>) => WatchK8sResults<R>;
export declare type UseResolvedExtensions = <E extends Extension>(...typeGuards: ExtensionTypeGuard<E>[]) => [ResolvedExtension<E>[], boolean, any[]];
export declare type ConsoleFetch = (url: string, options?: RequestInit, timeout?: number) => Promise<Response>;
export declare type ConsoleFetchJSON<T = any> = {
    (url: string, method?: string, options?: RequestInit, timeout?: number): Promise<T>;
    delete(url: string, json?: any, options?: RequestInit, timeout?: number): Promise<T>;
    post(url: string, json: any, options?: RequestInit, timeout?: number): Promise<T>;
    put(url: string, json: any, options?: RequestInit, timeout?: number): Promise<T>;
    patch(url: string, json: any, options?: RequestInit, timeout?: number): Promise<T>;
};
export declare type ConsoleFetchText = (...args: Parameters<ConsoleFetch>) => Promise<string>;
export declare type NavPage = {
    href?: string;
    path?: string;
    name: string;
    component: React.ComponentType<RouteComponentProps>;
};
export declare type HorizontalNavProps = {
    resource?: K8sResourceCommon;
    pages: NavPage[];
};
export declare type TableColumn<D> = ICell & {
    title: string;
    id: string;
    additional?: boolean;
    sort?: ((data: D[], sortDirection: SortByDirection) => D[]) | string;
};
export declare type RowProps<D, R extends any = {}> = {
    obj: D;
    rowData: R;
    activeColumnIDs: Set<string>;
};
declare type VirtualizedTableProps<D, R extends any = {}> = {
    data: D[];
    unfilteredData: D[];
    loaded: boolean;
    loadError: any;
    columns: TableColumn<D>[];
    Row: React.ComponentType<RowProps<D, R>>;
    NoDataEmptyMsg?: React.ComponentType<{}>;
    EmptyMsg?: React.ComponentType<{}>;
    scrollNode?: () => HTMLElement;
    onSelect?: OnSelect;
    label?: string;
    'aria-label'?: string;
    gridBreakPoint?: TableGridBreakpoint;
    rowData?: R;
};
export declare type VirtualizedTableFC = <D, R extends any = {}>(props: VirtualizedTableProps<D, R>) => JSX.Element;
export declare type TableDataProps = {
    id: string;
    activeColumnIDs: Set<string>;
    className?: string;
};
export declare type UseActiveColumns = <D = any>({ columns, showNamespaceOverride, columnManagementID, }: {
    columns: TableColumn<D>[];
    showNamespaceOverride: boolean;
    columnManagementID: string;
}) => [TableColumn<D>[], boolean];
export declare type ListPageHeaderProps = {
    title: string;
    helpText?: React.ReactNode;
    badge?: React.ReactNode;
};
export declare type CreateWithPermissionsProps = {
    createAccessReview?: {
        groupVersionKind: GroupVersionKind;
        namespace?: string;
    };
};
export declare type ListPageCreateProps = CreateWithPermissionsProps & {
    groupVersionKind: GroupVersionKind;
};
export declare type ListPageCreateLinkProps = CreateWithPermissionsProps & {
    to: string;
};
export declare type ListPageCreateButtonProps = CreateWithPermissionsProps & ButtonProps;
export declare type ListPageCreateDropdownProps = CreateWithPermissionsProps & {
    items: {
        [key: string]: React.ReactNode;
    };
    onClick: (item: string) => void;
};
export declare type RowFilterItem = {
    id: string;
    title: string;
    hideIfEmpty?: string;
};
export declare type FilterValue = {
    selected?: string[];
    all?: string[];
};
declare type RowFilterBase<R> = {
    filterGroupName: string;
    type: string;
    items: RowFilterItem[];
    filter: (input: FilterValue, obj: R) => boolean;
    defaultSelected?: string[];
};
export declare type RowMatchFilter<R = any> = RowFilterBase<R> & {
    isMatch: (obj: R, id: string) => boolean;
};
export declare type RowReducerFilter<R = any> = RowFilterBase<R> & {
    reducer: (obj: R) => React.ReactText;
};
export declare type RowFilter<R = any> = RowMatchFilter<R> | RowReducerFilter<R>;
export declare type ColumnLayout = {
    id: string;
    columns: ManagedColumn[];
    selectedColumns: Set<string>;
    showNamespaceOverride?: boolean;
    type: string;
};
export declare type ManagedColumn = {
    id: string;
    title: string;
    additional?: boolean;
};
export declare type OnFilterChange = (type: string, value: FilterValue) => void;
export declare type ListPageFilterProps<D = any> = {
    data: D;
    loaded: boolean;
    rowFilters?: RowFilter[];
    nameFilterPlaceholder?: string;
    labelFilterPlaceholder?: string;
    hideNameLabelFilters?: boolean;
    hideLabelFilter?: boolean;
    columnLayout?: ColumnLayout;
    onFilterChange: OnFilterChange;
    hideColumnManagement?: boolean;
};
export declare type UseListPageFilter = <D, R>(data: D[], rowFilters?: RowFilter<R>[], staticFilters?: {
    [key: string]: FilterValue;
}) => [D[], D[], OnFilterChange];
export declare type ResourceLinkProps = {
    kind: GroupVersionKind;
    className?: string;
    displayName?: string;
    inline?: boolean;
    linkTo?: boolean;
    name?: string;
    namespace?: string;
    hideIcon?: boolean;
    title?: string;
    dataTest?: string;
    onClick?: () => void;
};
export declare type UseK8sModel = (groupVersionKind?: GroupVersionKind) => [K8sKind, boolean];
export declare type UseK8sModels = () => [{
    [key: string]: K8sKind;
}, boolean];
export declare type PerspectiveType = string;
export declare type UseActivePerspective = () => [PerspectiveType, React.Dispatch<React.SetStateAction<PerspectiveType>>];
export {};
