/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// source: proto/agent/agent.proto

package agent

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
	client "sigs.k8s.io/apiserver-network-proxy/konnectivity-client/proto/client"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

func init() { proto.RegisterFile("proto/agent/agent.proto", fileDescriptor_656b6c96a18ce683) }

var fileDescriptor_656b6c96a18ce683 = []byte{
	// 155 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x12, 0x2f, 0x28, 0xca, 0x2f,
	0xc9, 0xd7, 0x4f, 0x4c, 0x4f, 0xcd, 0x2b, 0x81, 0x90, 0x7a, 0x60, 0x11, 0x29, 0xdd, 0xec, 0xfc,
	0xbc, 0xbc, 0xd4, 0xe4, 0x92, 0xcc, 0xb2, 0xcc, 0x92, 0x4a, 0xdd, 0xe4, 0x9c, 0x4c, 0x90, 0x02,
	0x88, 0x62, 0x28, 0x07, 0x42, 0x41, 0x94, 0x1b, 0x19, 0x72, 0xf1, 0x38, 0x82, 0x74, 0x07, 0xa7,
	0x16, 0x95, 0x65, 0x26, 0xa7, 0x0a, 0x29, 0x72, 0xb1, 0x3b, 0x43, 0x0c, 0x10, 0x62, 0xd7, 0x0b,
	0x48, 0x4c, 0xce, 0x4e, 0x2d, 0x91, 0x82, 0x31, 0x94, 0x18, 0x34, 0x18, 0x0d, 0x18, 0x9d, 0x0c,
	0xa3, 0xf4, 0x8b, 0x33, 0xd3, 0x8b, 0xf5, 0xb2, 0x2d, 0x8a, 0xf5, 0x32, 0xf3, 0xf5, 0x13, 0x0b,
	0x32, 0x8b, 0x53, 0x8b, 0xca, 0x52, 0x8b, 0x74, 0xf3, 0x52, 0x4b, 0xca, 0xf3, 0x8b, 0xb2, 0x75,
	0x0b, 0x8a, 0xf2, 0x2b, 0x2a, 0xf5, 0x91, 0x1c, 0x98, 0xc4, 0x06, 0xe6, 0x18, 0x03, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x85, 0x25, 0x82, 0x73, 0xb6, 0x00, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentServiceClient is the client API for AgentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentServiceClient interface {
	// Agent Identifier?
	Connect(ctx context.Context, opts ...grpc.CallOption) (AgentService_ConnectClient, error)
}

type agentServiceClient struct {
	cc *grpc.ClientConn
}

func NewAgentServiceClient(cc *grpc.ClientConn) AgentServiceClient {
	return &agentServiceClient{cc}
}

func (c *agentServiceClient) Connect(ctx context.Context, opts ...grpc.CallOption) (AgentService_ConnectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentService_serviceDesc.Streams[0], "/AgentService/Connect", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentServiceConnectClient{stream}
	return x, nil
}

type AgentService_ConnectClient interface {
	Send(*client.Packet) error
	Recv() (*client.Packet, error)
	grpc.ClientStream
}

type agentServiceConnectClient struct {
	grpc.ClientStream
}

func (x *agentServiceConnectClient) Send(m *client.Packet) error {
	return x.ClientStream.SendMsg(m)
}

func (x *agentServiceConnectClient) Recv() (*client.Packet, error) {
	m := new(client.Packet)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// AgentServiceServer is the server API for AgentService service.
type AgentServiceServer interface {
	// Agent Identifier?
	Connect(AgentService_ConnectServer) error
}

// UnimplementedAgentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAgentServiceServer struct {
}

func (*UnimplementedAgentServiceServer) Connect(srv AgentService_ConnectServer) error {
	return status.Errorf(codes.Unimplemented, "method Connect not implemented")
}

func RegisterAgentServiceServer(s *grpc.Server, srv AgentServiceServer) {
	s.RegisterService(&_AgentService_serviceDesc, srv)
}

func _AgentService_Connect_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(AgentServiceServer).Connect(&agentServiceConnectServer{stream})
}

type AgentService_ConnectServer interface {
	Send(*client.Packet) error
	Recv() (*client.Packet, error)
	grpc.ServerStream
}

type agentServiceConnectServer struct {
	grpc.ServerStream
}

func (x *agentServiceConnectServer) Send(m *client.Packet) error {
	return x.ServerStream.SendMsg(m)
}

func (x *agentServiceConnectServer) Recv() (*client.Packet, error) {
	m := new(client.Packet)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _AgentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "AgentService",
	HandlerType: (*AgentServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Connect",
			Handler:       _AgentService_Connect_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "proto/agent/agent.proto",
}
