// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// MagneticFlux represents a magnetic flux in Weber.
type MagneticFlux float64

const (
	Yottaweber MagneticFlux = 1e24
	Zettaweber MagneticFlux = 1e21
	Exaweber   MagneticFlux = 1e18
	Petaweber  MagneticFlux = 1e15
	Teraweber  MagneticFlux = 1e12
	Gigaweber  MagneticFlux = 1e9
	Megaweber  MagneticFlux = 1e6
	Kiloweber  MagneticFlux = 1e3
	Hectoweber MagneticFlux = 1e2
	Decaweber  MagneticFlux = 1e1
	Weber      MagneticFlux = 1.0
	Deciweber  MagneticFlux = 1e-1
	Centiweber MagneticFlux = 1e-2
	Milliweber MagneticFlux = 1e-3
	Microweber MagneticFlux = 1e-6
	Nanoweber  MagneticFlux = 1e-9
	Picoweber  MagneticFlux = 1e-12
	Femtoweber MagneticFlux = 1e-15
	Attoweber  MagneticFlux = 1e-18
	Zeptoweber MagneticFlux = 1e-21
	Yoctoweber MagneticFlux = 1e-24
)

// Unit converts the MagneticFlux to a *Unit
func (m MagneticFlux) Unit() *Unit {
	return New(float64(m), Dimensions{
		CurrentDim: -1,
		LengthDim:  2,
		MassDim:    1,
		TimeDim:    -2,
	})
}

// MagneticFlux allows MagneticFlux to implement a MagneticFluxer interface
func (m MagneticFlux) MagneticFlux() MagneticFlux {
	return m
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (m *MagneticFlux) From(u Uniter) error {
	if !DimensionsMatch(u, Weber) {
		*m = MagneticFlux(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*m = MagneticFlux(u.Unit().Value())
	return nil
}

func (m MagneticFlux) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", m, float64(m))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " Wb"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(m))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(m))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(m))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(m))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g Wb)", c, m, float64(m))
	}
}
