// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "open-cluster-management.io/cluster-proxy/pkg/apis/proxy/v1alpha1"
	scheme "open-cluster-management.io/cluster-proxy/pkg/generated/clientset/versioned/scheme"
)

// ManagedProxyConfigurationsGetter has a method to return a ManagedProxyConfigurationInterface.
// A group's client should implement this interface.
type ManagedProxyConfigurationsGetter interface {
	ManagedProxyConfigurations() ManagedProxyConfigurationInterface
}

// ManagedProxyConfigurationInterface has methods to work with ManagedProxyConfiguration resources.
type ManagedProxyConfigurationInterface interface {
	Create(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.CreateOptions) (*v1alpha1.ManagedProxyConfiguration, error)
	Update(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.UpdateOptions) (*v1alpha1.ManagedProxyConfiguration, error)
	UpdateStatus(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.UpdateOptions) (*v1alpha1.ManagedProxyConfiguration, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ManagedProxyConfiguration, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ManagedProxyConfigurationList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ManagedProxyConfiguration, err error)
	ManagedProxyConfigurationExpansion
}

// managedProxyConfigurations implements ManagedProxyConfigurationInterface
type managedProxyConfigurations struct {
	client rest.Interface
}

// newManagedProxyConfigurations returns a ManagedProxyConfigurations
func newManagedProxyConfigurations(c *ProxyV1alpha1Client) *managedProxyConfigurations {
	return &managedProxyConfigurations{
		client: c.RESTClient(),
	}
}

// Get takes name of the managedProxyConfiguration, and returns the corresponding managedProxyConfiguration object, and an error if there is any.
func (c *managedProxyConfigurations) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ManagedProxyConfiguration, err error) {
	result = &v1alpha1.ManagedProxyConfiguration{}
	err = c.client.Get().
		Resource("managedproxyconfigurations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ManagedProxyConfigurations that match those selectors.
func (c *managedProxyConfigurations) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ManagedProxyConfigurationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ManagedProxyConfigurationList{}
	err = c.client.Get().
		Resource("managedproxyconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested managedProxyConfigurations.
func (c *managedProxyConfigurations) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("managedproxyconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a managedProxyConfiguration and creates it.  Returns the server's representation of the managedProxyConfiguration, and an error, if there is any.
func (c *managedProxyConfigurations) Create(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.CreateOptions) (result *v1alpha1.ManagedProxyConfiguration, err error) {
	result = &v1alpha1.ManagedProxyConfiguration{}
	err = c.client.Post().
		Resource("managedproxyconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedProxyConfiguration).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a managedProxyConfiguration and updates it. Returns the server's representation of the managedProxyConfiguration, and an error, if there is any.
func (c *managedProxyConfigurations) Update(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.UpdateOptions) (result *v1alpha1.ManagedProxyConfiguration, err error) {
	result = &v1alpha1.ManagedProxyConfiguration{}
	err = c.client.Put().
		Resource("managedproxyconfigurations").
		Name(managedProxyConfiguration.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedProxyConfiguration).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *managedProxyConfigurations) UpdateStatus(ctx context.Context, managedProxyConfiguration *v1alpha1.ManagedProxyConfiguration, opts v1.UpdateOptions) (result *v1alpha1.ManagedProxyConfiguration, err error) {
	result = &v1alpha1.ManagedProxyConfiguration{}
	err = c.client.Put().
		Resource("managedproxyconfigurations").
		Name(managedProxyConfiguration.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedProxyConfiguration).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the managedProxyConfiguration and deletes it. Returns an error if one occurs.
func (c *managedProxyConfigurations) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("managedproxyconfigurations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *managedProxyConfigurations) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("managedproxyconfigurations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched managedProxyConfiguration.
func (c *managedProxyConfigurations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ManagedProxyConfiguration, err error) {
	result = &v1alpha1.ManagedProxyConfiguration{}
	err = c.client.Patch(pt).
		Resource("managedproxyconfigurations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
