//
// Copyright (c) 2019-2022 Red Hat, Inc.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package webhook_openshift

import (
	"context"

	"github.com/devfile/devworkspace-operator/pkg/webhook/service"
	logf "sigs.k8s.io/controller-runtime/pkg/log"

	crclient "sigs.k8s.io/controller-runtime/pkg/client"
)

var log = logf.Log.WithName("webhook-openshift")

func SetupSecureService(client crclient.Client, ctx context.Context, secretName, namespace string) error {
	log.Info("Attempting to create the secure service")
	err := service.CreateOrUpdateSecureService(client, ctx, namespace, map[string]string{
		"service.beta.openshift.io/serving-cert-secret-name": secretName,
	})
	if err != nil {
		log.Info("Failed creating the secure service")
		return err
	}
	return nil
}
