// Code generated by go-swagger; DO NOT EDIT.

package channel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewCreateChannelReleaseParams creates a new CreateChannelReleaseParams object
// with the default values initialized.
func NewCreateChannelReleaseParams() *CreateChannelReleaseParams {
	var ()
	return &CreateChannelReleaseParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewCreateChannelReleaseParamsWithTimeout creates a new CreateChannelReleaseParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewCreateChannelReleaseParamsWithTimeout(timeout time.Duration) *CreateChannelReleaseParams {
	var ()
	return &CreateChannelReleaseParams{

		timeout: timeout,
	}
}

// NewCreateChannelReleaseParamsWithContext creates a new CreateChannelReleaseParams object
// with the default values initialized, and the ability to set a context for a request
func NewCreateChannelReleaseParamsWithContext(ctx context.Context) *CreateChannelReleaseParams {
	var ()
	return &CreateChannelReleaseParams{

		Context: ctx,
	}
}

// NewCreateChannelReleaseParamsWithHTTPClient creates a new CreateChannelReleaseParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewCreateChannelReleaseParamsWithHTTPClient(client *http.Client) *CreateChannelReleaseParams {
	var ()
	return &CreateChannelReleaseParams{
		HTTPClient: client,
	}
}

/*CreateChannelReleaseParams contains all the parameters to send to the API endpoint
for the create channel release operation typically these are written to a http.Request
*/
type CreateChannelReleaseParams struct {

	/*Channel
	  channel name

	*/
	Channel string
	/*Namespace
	  namespace

	*/
	Namespace string
	/*Package
	  full package name

	*/
	Package string
	/*Release
	  Release name

	*/
	Release string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the create channel release params
func (o *CreateChannelReleaseParams) WithTimeout(timeout time.Duration) *CreateChannelReleaseParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create channel release params
func (o *CreateChannelReleaseParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create channel release params
func (o *CreateChannelReleaseParams) WithContext(ctx context.Context) *CreateChannelReleaseParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create channel release params
func (o *CreateChannelReleaseParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create channel release params
func (o *CreateChannelReleaseParams) WithHTTPClient(client *http.Client) *CreateChannelReleaseParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create channel release params
func (o *CreateChannelReleaseParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithChannel adds the channel to the create channel release params
func (o *CreateChannelReleaseParams) WithChannel(channel string) *CreateChannelReleaseParams {
	o.SetChannel(channel)
	return o
}

// SetChannel adds the channel to the create channel release params
func (o *CreateChannelReleaseParams) SetChannel(channel string) {
	o.Channel = channel
}

// WithNamespace adds the namespace to the create channel release params
func (o *CreateChannelReleaseParams) WithNamespace(namespace string) *CreateChannelReleaseParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the create channel release params
func (o *CreateChannelReleaseParams) SetNamespace(namespace string) {
	o.Namespace = namespace
}

// WithPackage adds the packageVar to the create channel release params
func (o *CreateChannelReleaseParams) WithPackage(packageVar string) *CreateChannelReleaseParams {
	o.SetPackage(packageVar)
	return o
}

// SetPackage adds the package to the create channel release params
func (o *CreateChannelReleaseParams) SetPackage(packageVar string) {
	o.Package = packageVar
}

// WithRelease adds the release to the create channel release params
func (o *CreateChannelReleaseParams) WithRelease(release string) *CreateChannelReleaseParams {
	o.SetRelease(release)
	return o
}

// SetRelease adds the release to the create channel release params
func (o *CreateChannelReleaseParams) SetRelease(release string) {
	o.Release = release
}

// WriteToRequest writes these params to a swagger request
func (o *CreateChannelReleaseParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param channel
	if err := r.SetPathParam("channel", o.Channel); err != nil {
		return err
	}

	// path param namespace
	if err := r.SetPathParam("namespace", o.Namespace); err != nil {
		return err
	}

	// path param package
	if err := r.SetPathParam("package", o.Package); err != nil {
		return err
	}

	// path param release
	if err := r.SetPathParam("release", o.Release); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
