/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	corev1beta1 "kubevirt.io/containerized-data-importer/pkg/apis/core/v1beta1"
	versioned "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned"
	internalinterfaces "kubevirt.io/containerized-data-importer/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "kubevirt.io/containerized-data-importer/pkg/client/listers/core/v1beta1"
)

// StorageProfileInformer provides access to a shared informer and lister for
// StorageProfiles.
type StorageProfileInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.StorageProfileLister
}

type storageProfileInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewStorageProfileInformer constructs a new informer for StorageProfile type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewStorageProfileInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredStorageProfileInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredStorageProfileInformer constructs a new informer for StorageProfile type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredStorageProfileInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CdiV1beta1().StorageProfiles().List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CdiV1beta1().StorageProfiles().Watch(context.TODO(), options)
			},
		},
		&corev1beta1.StorageProfile{},
		resyncPeriod,
		indexers,
	)
}

func (f *storageProfileInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredStorageProfileInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *storageProfileInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&corev1beta1.StorageProfile{}, f.defaultInformer)
}

func (f *storageProfileInformer) Lister() v1beta1.StorageProfileLister {
	return v1beta1.NewStorageProfileLister(f.Informer().GetIndexer())
}
