/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer/pkg/apis/core/v1beta1"
)

// CDILister helps list CDIs.
// All objects returned here must be treated as read-only.
type CDILister interface {
	// List lists all CDIs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.CDI, err error)
	// Get retrieves the CDI from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.CDI, error)
	CDIListerExpansion
}

// cDILister implements the CDILister interface.
type cDILister struct {
	indexer cache.Indexer
}

// NewCDILister returns a new CDILister.
func NewCDILister(indexer cache.Indexer) CDILister {
	return &cDILister{indexer: indexer}
}

// List lists all CDIs in the indexer.
func (s *cDILister) List(selector labels.Selector) (ret []*v1beta1.CDI, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.CDI))
	})
	return ret, err
}

// Get retrieves the CDI from the index for a given name.
func (s *cDILister) Get(name string) (*v1beta1.CDI, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("cdi"), name)
	}
	return obj.(*v1beta1.CDI), nil
}
