// Code generated by protoc-gen-go. DO NOT EDIT.
// source: pkg/handler-launcher-com/cmd/v1/cmd.proto

/*
Package v1 is a generated protocol buffer package.

It is generated from these files:
	pkg/handler-launcher-com/cmd/v1/cmd.proto

It has these top-level messages:
	VMI
	CPU
	Sibling
	Pages
	Memory
	Cell
	Topology
	SMBios
	DiskInfo
	VirtualMachineOptions
	VMIRequest
	MigrationRequest
	ExecRequest
	EmptyRequest
	Response
	DomainResponse
	DomainStatsResponse
	GuestInfoResponse
	GuestUserListResponse
	GuestFilesystemsResponse
	ExecResponse
	GuestPingRequest
	GuestPingResponse
	FreezeRequest
*/
package v1

import (
	fmt "fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type VMI struct {
	VmiJson []byte `protobuf:"bytes,1,opt,name=vmiJson,proto3" json:"vmiJson,omitempty"`
}

func (m *VMI) Reset()                    { *m = VMI{} }
func (m *VMI) String() string            { return proto.CompactTextString(m) }
func (*VMI) ProtoMessage()               {}
func (*VMI) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *VMI) GetVmiJson() []byte {
	if m != nil {
		return m.VmiJson
	}
	return nil
}

type CPU struct {
	Id       uint32   `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Siblings []uint32 `protobuf:"varint,2,rep,packed,name=siblings" json:"siblings,omitempty"`
}

func (m *CPU) Reset()                    { *m = CPU{} }
func (m *CPU) String() string            { return proto.CompactTextString(m) }
func (*CPU) ProtoMessage()               {}
func (*CPU) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *CPU) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *CPU) GetSiblings() []uint32 {
	if m != nil {
		return m.Siblings
	}
	return nil
}

type Sibling struct {
	Id    uint32 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Value uint64 `protobuf:"varint,2,opt,name=value" json:"value,omitempty"`
}

func (m *Sibling) Reset()                    { *m = Sibling{} }
func (m *Sibling) String() string            { return proto.CompactTextString(m) }
func (*Sibling) ProtoMessage()               {}
func (*Sibling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Sibling) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Sibling) GetValue() uint64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type Pages struct {
	Count uint64 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	Unit  string `protobuf:"bytes,2,opt,name=unit" json:"unit,omitempty"`
	Size  uint32 `protobuf:"varint,3,opt,name=size" json:"size,omitempty"`
}

func (m *Pages) Reset()                    { *m = Pages{} }
func (m *Pages) String() string            { return proto.CompactTextString(m) }
func (*Pages) ProtoMessage()               {}
func (*Pages) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Pages) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Pages) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *Pages) GetSize() uint32 {
	if m != nil {
		return m.Size
	}
	return 0
}

type Memory struct {
	Amount uint64 `protobuf:"varint,1,opt,name=amount" json:"amount,omitempty"`
	Unit   string `protobuf:"bytes,2,opt,name=unit" json:"unit,omitempty"`
}

func (m *Memory) Reset()                    { *m = Memory{} }
func (m *Memory) String() string            { return proto.CompactTextString(m) }
func (*Memory) ProtoMessage()               {}
func (*Memory) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Memory) GetAmount() uint64 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *Memory) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

type Cell struct {
	Id        uint32     `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	Memory    *Memory    `protobuf:"bytes,2,opt,name=memory" json:"memory,omitempty"`
	Pages     []*Pages   `protobuf:"bytes,3,rep,name=pages" json:"pages,omitempty"`
	Distances []*Sibling `protobuf:"bytes,4,rep,name=distances" json:"distances,omitempty"`
	Cpus      []*CPU     `protobuf:"bytes,5,rep,name=cpus" json:"cpus,omitempty"`
}

func (m *Cell) Reset()                    { *m = Cell{} }
func (m *Cell) String() string            { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()               {}
func (*Cell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Cell) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Cell) GetMemory() *Memory {
	if m != nil {
		return m.Memory
	}
	return nil
}

func (m *Cell) GetPages() []*Pages {
	if m != nil {
		return m.Pages
	}
	return nil
}

func (m *Cell) GetDistances() []*Sibling {
	if m != nil {
		return m.Distances
	}
	return nil
}

func (m *Cell) GetCpus() []*CPU {
	if m != nil {
		return m.Cpus
	}
	return nil
}

type Topology struct {
	NumaCells []*Cell `protobuf:"bytes,1,rep,name=numa_cells,json=numaCells" json:"numa_cells,omitempty"`
}

func (m *Topology) Reset()                    { *m = Topology{} }
func (m *Topology) String() string            { return proto.CompactTextString(m) }
func (*Topology) ProtoMessage()               {}
func (*Topology) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Topology) GetNumaCells() []*Cell {
	if m != nil {
		return m.NumaCells
	}
	return nil
}

type SMBios struct {
	Manufacturer string `protobuf:"bytes,1,opt,name=manufacturer" json:"manufacturer,omitempty"`
	Product      string `protobuf:"bytes,2,opt,name=product" json:"product,omitempty"`
	Version      string `protobuf:"bytes,3,opt,name=version" json:"version,omitempty"`
	Sku          string `protobuf:"bytes,4,opt,name=sku" json:"sku,omitempty"`
	Family       string `protobuf:"bytes,5,opt,name=family" json:"family,omitempty"`
}

func (m *SMBios) Reset()                    { *m = SMBios{} }
func (m *SMBios) String() string            { return proto.CompactTextString(m) }
func (*SMBios) ProtoMessage()               {}
func (*SMBios) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *SMBios) GetManufacturer() string {
	if m != nil {
		return m.Manufacturer
	}
	return ""
}

func (m *SMBios) GetProduct() string {
	if m != nil {
		return m.Product
	}
	return ""
}

func (m *SMBios) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *SMBios) GetSku() string {
	if m != nil {
		return m.Sku
	}
	return ""
}

func (m *SMBios) GetFamily() string {
	if m != nil {
		return m.Family
	}
	return ""
}

type DiskInfo struct {
	Format      string `protobuf:"bytes,1,opt,name=format" json:"format,omitempty"`
	BackingFile string `protobuf:"bytes,2,opt,name=backingFile" json:"backingFile,omitempty"`
	ActualSize  uint64 `protobuf:"varint,3,opt,name=actualSize" json:"actualSize,omitempty"`
	VirtualSize uint64 `protobuf:"varint,4,opt,name=virtualSize" json:"virtualSize,omitempty"`
}

func (m *DiskInfo) Reset()                    { *m = DiskInfo{} }
func (m *DiskInfo) String() string            { return proto.CompactTextString(m) }
func (*DiskInfo) ProtoMessage()               {}
func (*DiskInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *DiskInfo) GetFormat() string {
	if m != nil {
		return m.Format
	}
	return ""
}

func (m *DiskInfo) GetBackingFile() string {
	if m != nil {
		return m.BackingFile
	}
	return ""
}

func (m *DiskInfo) GetActualSize() uint64 {
	if m != nil {
		return m.ActualSize
	}
	return 0
}

func (m *DiskInfo) GetVirtualSize() uint64 {
	if m != nil {
		return m.VirtualSize
	}
	return 0
}

type VirtualMachineOptions struct {
	VirtualMachineSMBios  *SMBios              `protobuf:"bytes,1,opt,name=VirtualMachineSMBios" json:"VirtualMachineSMBios,omitempty"`
	MemBalloonStatsPeriod uint32               `protobuf:"varint,2,opt,name=MemBalloonStatsPeriod" json:"MemBalloonStatsPeriod,omitempty"`
	PreallocatedVolumes   []string             `protobuf:"bytes,3,rep,name=PreallocatedVolumes" json:"PreallocatedVolumes,omitempty"`
	Topology              *Topology            `protobuf:"bytes,4,opt,name=topology" json:"topology,omitempty"`
	DisksInfo             map[string]*DiskInfo `protobuf:"bytes,5,rep,name=DisksInfo" json:"DisksInfo,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ExpandDisksEnabled    bool                 `protobuf:"varint,6,opt,name=ExpandDisksEnabled" json:"ExpandDisksEnabled,omitempty"`
}

func (m *VirtualMachineOptions) Reset()                    { *m = VirtualMachineOptions{} }
func (m *VirtualMachineOptions) String() string            { return proto.CompactTextString(m) }
func (*VirtualMachineOptions) ProtoMessage()               {}
func (*VirtualMachineOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *VirtualMachineOptions) GetVirtualMachineSMBios() *SMBios {
	if m != nil {
		return m.VirtualMachineSMBios
	}
	return nil
}

func (m *VirtualMachineOptions) GetMemBalloonStatsPeriod() uint32 {
	if m != nil {
		return m.MemBalloonStatsPeriod
	}
	return 0
}

func (m *VirtualMachineOptions) GetPreallocatedVolumes() []string {
	if m != nil {
		return m.PreallocatedVolumes
	}
	return nil
}

func (m *VirtualMachineOptions) GetTopology() *Topology {
	if m != nil {
		return m.Topology
	}
	return nil
}

func (m *VirtualMachineOptions) GetDisksInfo() map[string]*DiskInfo {
	if m != nil {
		return m.DisksInfo
	}
	return nil
}

func (m *VirtualMachineOptions) GetExpandDisksEnabled() bool {
	if m != nil {
		return m.ExpandDisksEnabled
	}
	return false
}

type VMIRequest struct {
	Vmi     *VMI                   `protobuf:"bytes,1,opt,name=vmi" json:"vmi,omitempty"`
	Options *VirtualMachineOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
}

func (m *VMIRequest) Reset()                    { *m = VMIRequest{} }
func (m *VMIRequest) String() string            { return proto.CompactTextString(m) }
func (*VMIRequest) ProtoMessage()               {}
func (*VMIRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *VMIRequest) GetVmi() *VMI {
	if m != nil {
		return m.Vmi
	}
	return nil
}

func (m *VMIRequest) GetOptions() *VirtualMachineOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

type MigrationRequest struct {
	Vmi     *VMI   `protobuf:"bytes,1,opt,name=vmi" json:"vmi,omitempty"`
	Options []byte `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
}

func (m *MigrationRequest) Reset()                    { *m = MigrationRequest{} }
func (m *MigrationRequest) String() string            { return proto.CompactTextString(m) }
func (*MigrationRequest) ProtoMessage()               {}
func (*MigrationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *MigrationRequest) GetVmi() *VMI {
	if m != nil {
		return m.Vmi
	}
	return nil
}

func (m *MigrationRequest) GetOptions() []byte {
	if m != nil {
		return m.Options
	}
	return nil
}

type ExecRequest struct {
	DomainName     string   `protobuf:"bytes,1,opt,name=domainName" json:"domainName,omitempty"`
	Command        string   `protobuf:"bytes,2,opt,name=Command" json:"Command,omitempty"`
	Args           []string `protobuf:"bytes,3,rep,name=Args" json:"Args,omitempty"`
	TimeoutSeconds int32    `protobuf:"varint,4,opt,name=timeoutSeconds" json:"timeoutSeconds,omitempty"`
}

func (m *ExecRequest) Reset()                    { *m = ExecRequest{} }
func (m *ExecRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecRequest) ProtoMessage()               {}
func (*ExecRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecRequest) GetDomainName() string {
	if m != nil {
		return m.DomainName
	}
	return ""
}

func (m *ExecRequest) GetCommand() string {
	if m != nil {
		return m.Command
	}
	return ""
}

func (m *ExecRequest) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ExecRequest) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

type EmptyRequest struct {
}

func (m *EmptyRequest) Reset()                    { *m = EmptyRequest{} }
func (m *EmptyRequest) String() string            { return proto.CompactTextString(m) }
func (*EmptyRequest) ProtoMessage()               {}
func (*EmptyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type Response struct {
	Success bool   `protobuf:"varint,1,opt,name=success" json:"success,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *Response) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *Response) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type DomainResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Domain   string    `protobuf:"bytes,2,opt,name=domain" json:"domain,omitempty"`
}

func (m *DomainResponse) Reset()                    { *m = DomainResponse{} }
func (m *DomainResponse) String() string            { return proto.CompactTextString(m) }
func (*DomainResponse) ProtoMessage()               {}
func (*DomainResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *DomainResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *DomainResponse) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

type DomainStatsResponse struct {
	Response    *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	DomainStats string    `protobuf:"bytes,2,opt,name=domainStats" json:"domainStats,omitempty"`
}

func (m *DomainStatsResponse) Reset()                    { *m = DomainStatsResponse{} }
func (m *DomainStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*DomainStatsResponse) ProtoMessage()               {}
func (*DomainStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *DomainStatsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *DomainStatsResponse) GetDomainStats() string {
	if m != nil {
		return m.DomainStats
	}
	return ""
}

type GuestInfoResponse struct {
	Response          *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	GuestInfoResponse string    `protobuf:"bytes,2,opt,name=guestInfoResponse" json:"guestInfoResponse,omitempty"`
}

func (m *GuestInfoResponse) Reset()                    { *m = GuestInfoResponse{} }
func (m *GuestInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*GuestInfoResponse) ProtoMessage()               {}
func (*GuestInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GuestInfoResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GuestInfoResponse) GetGuestInfoResponse() string {
	if m != nil {
		return m.GuestInfoResponse
	}
	return ""
}

type GuestUserListResponse struct {
	Response              *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	GuestUserListResponse string    `protobuf:"bytes,2,opt,name=guestUserListResponse" json:"guestUserListResponse,omitempty"`
}

func (m *GuestUserListResponse) Reset()                    { *m = GuestUserListResponse{} }
func (m *GuestUserListResponse) String() string            { return proto.CompactTextString(m) }
func (*GuestUserListResponse) ProtoMessage()               {}
func (*GuestUserListResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GuestUserListResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GuestUserListResponse) GetGuestUserListResponse() string {
	if m != nil {
		return m.GuestUserListResponse
	}
	return ""
}

type GuestFilesystemsResponse struct {
	Response                 *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	GuestFilesystemsResponse string    `protobuf:"bytes,2,opt,name=guestFilesystemsResponse" json:"guestFilesystemsResponse,omitempty"`
}

func (m *GuestFilesystemsResponse) Reset()                    { *m = GuestFilesystemsResponse{} }
func (m *GuestFilesystemsResponse) String() string            { return proto.CompactTextString(m) }
func (*GuestFilesystemsResponse) ProtoMessage()               {}
func (*GuestFilesystemsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *GuestFilesystemsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GuestFilesystemsResponse) GetGuestFilesystemsResponse() string {
	if m != nil {
		return m.GuestFilesystemsResponse
	}
	return ""
}

type ExecResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	ExitCode int32     `protobuf:"varint,2,opt,name=exitCode" json:"exitCode,omitempty"`
	StdOut   string    `protobuf:"bytes,3,opt,name=stdOut" json:"stdOut,omitempty"`
}

func (m *ExecResponse) Reset()                    { *m = ExecResponse{} }
func (m *ExecResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecResponse) ProtoMessage()               {}
func (*ExecResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ExecResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *ExecResponse) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ExecResponse) GetStdOut() string {
	if m != nil {
		return m.StdOut
	}
	return ""
}

type GuestPingRequest struct {
	DomainName     string `protobuf:"bytes,1,opt,name=domainName" json:"domainName,omitempty"`
	TimeoutSeconds int32  `protobuf:"varint,2,opt,name=timeoutSeconds" json:"timeoutSeconds,omitempty"`
}

func (m *GuestPingRequest) Reset()                    { *m = GuestPingRequest{} }
func (m *GuestPingRequest) String() string            { return proto.CompactTextString(m) }
func (*GuestPingRequest) ProtoMessage()               {}
func (*GuestPingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GuestPingRequest) GetDomainName() string {
	if m != nil {
		return m.DomainName
	}
	return ""
}

func (m *GuestPingRequest) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

type GuestPingResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *GuestPingResponse) Reset()                    { *m = GuestPingResponse{} }
func (m *GuestPingResponse) String() string            { return proto.CompactTextString(m) }
func (*GuestPingResponse) ProtoMessage()               {}
func (*GuestPingResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *GuestPingResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type FreezeRequest struct {
	Vmi                    *VMI  `protobuf:"bytes,1,opt,name=vmi" json:"vmi,omitempty"`
	UnfreezeTimeoutSeconds int32 `protobuf:"varint,2,opt,name=unfreezeTimeoutSeconds" json:"unfreezeTimeoutSeconds,omitempty"`
}

func (m *FreezeRequest) Reset()                    { *m = FreezeRequest{} }
func (m *FreezeRequest) String() string            { return proto.CompactTextString(m) }
func (*FreezeRequest) ProtoMessage()               {}
func (*FreezeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *FreezeRequest) GetVmi() *VMI {
	if m != nil {
		return m.Vmi
	}
	return nil
}

func (m *FreezeRequest) GetUnfreezeTimeoutSeconds() int32 {
	if m != nil {
		return m.UnfreezeTimeoutSeconds
	}
	return 0
}

func init() {
	proto.RegisterType((*VMI)(nil), "kubevirt.cmd.v1.VMI")
	proto.RegisterType((*CPU)(nil), "kubevirt.cmd.v1.CPU")
	proto.RegisterType((*Sibling)(nil), "kubevirt.cmd.v1.Sibling")
	proto.RegisterType((*Pages)(nil), "kubevirt.cmd.v1.Pages")
	proto.RegisterType((*Memory)(nil), "kubevirt.cmd.v1.Memory")
	proto.RegisterType((*Cell)(nil), "kubevirt.cmd.v1.Cell")
	proto.RegisterType((*Topology)(nil), "kubevirt.cmd.v1.Topology")
	proto.RegisterType((*SMBios)(nil), "kubevirt.cmd.v1.SMBios")
	proto.RegisterType((*DiskInfo)(nil), "kubevirt.cmd.v1.DiskInfo")
	proto.RegisterType((*VirtualMachineOptions)(nil), "kubevirt.cmd.v1.VirtualMachineOptions")
	proto.RegisterType((*VMIRequest)(nil), "kubevirt.cmd.v1.VMIRequest")
	proto.RegisterType((*MigrationRequest)(nil), "kubevirt.cmd.v1.MigrationRequest")
	proto.RegisterType((*ExecRequest)(nil), "kubevirt.cmd.v1.ExecRequest")
	proto.RegisterType((*EmptyRequest)(nil), "kubevirt.cmd.v1.EmptyRequest")
	proto.RegisterType((*Response)(nil), "kubevirt.cmd.v1.Response")
	proto.RegisterType((*DomainResponse)(nil), "kubevirt.cmd.v1.DomainResponse")
	proto.RegisterType((*DomainStatsResponse)(nil), "kubevirt.cmd.v1.DomainStatsResponse")
	proto.RegisterType((*GuestInfoResponse)(nil), "kubevirt.cmd.v1.GuestInfoResponse")
	proto.RegisterType((*GuestUserListResponse)(nil), "kubevirt.cmd.v1.GuestUserListResponse")
	proto.RegisterType((*GuestFilesystemsResponse)(nil), "kubevirt.cmd.v1.GuestFilesystemsResponse")
	proto.RegisterType((*ExecResponse)(nil), "kubevirt.cmd.v1.ExecResponse")
	proto.RegisterType((*GuestPingRequest)(nil), "kubevirt.cmd.v1.GuestPingRequest")
	proto.RegisterType((*GuestPingResponse)(nil), "kubevirt.cmd.v1.GuestPingResponse")
	proto.RegisterType((*FreezeRequest)(nil), "kubevirt.cmd.v1.FreezeRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Cmd service

type CmdClient interface {
	SyncVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	PauseVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	UnpauseVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	FreezeVirtualMachine(ctx context.Context, in *FreezeRequest, opts ...grpc.CallOption) (*Response, error)
	UnfreezeVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	SoftRebootVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	ShutdownVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	KillVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	DeleteVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	MigrateVirtualMachine(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*Response, error)
	SyncMigrationTarget(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	CancelVirtualMachineMigration(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	SignalTargetPodCleanup(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	FinalizeVirtualMachineMigration(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error)
	GetDomain(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*DomainResponse, error)
	GetDomainStats(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*DomainStatsResponse, error)
	GetGuestInfo(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestInfoResponse, error)
	GetUsers(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestUserListResponse, error)
	GetFilesystems(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestFilesystemsResponse, error)
	Ping(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*Response, error)
	Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error)
	GuestPing(ctx context.Context, in *GuestPingRequest, opts ...grpc.CallOption) (*GuestPingResponse, error)
}

type cmdClient struct {
	cc *grpc.ClientConn
}

func NewCmdClient(cc *grpc.ClientConn) CmdClient {
	return &cmdClient{cc}
}

func (c *cmdClient) SyncVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/SyncVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) PauseVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/PauseVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) UnpauseVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/UnpauseVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) FreezeVirtualMachine(ctx context.Context, in *FreezeRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/FreezeVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) UnfreezeVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/UnfreezeVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) SoftRebootVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/SoftRebootVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) ShutdownVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/ShutdownVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) KillVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/KillVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) DeleteVirtualMachine(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/DeleteVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) MigrateVirtualMachine(ctx context.Context, in *MigrationRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/MigrateVirtualMachine", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) SyncMigrationTarget(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/SyncMigrationTarget", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) CancelVirtualMachineMigration(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/CancelVirtualMachineMigration", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) SignalTargetPodCleanup(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/SignalTargetPodCleanup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) FinalizeVirtualMachineMigration(ctx context.Context, in *VMIRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/FinalizeVirtualMachineMigration", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GetDomain(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*DomainResponse, error) {
	out := new(DomainResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GetDomain", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GetDomainStats(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*DomainStatsResponse, error) {
	out := new(DomainStatsResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GetDomainStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GetGuestInfo(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestInfoResponse, error) {
	out := new(GuestInfoResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GetGuestInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GetUsers(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestUserListResponse, error) {
	out := new(GuestUserListResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GetUsers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GetFilesystems(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*GuestFilesystemsResponse, error) {
	out := new(GuestFilesystemsResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GetFilesystems", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) Ping(ctx context.Context, in *EmptyRequest, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/Ping", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error) {
	out := new(ExecResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/Exec", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cmdClient) GuestPing(ctx context.Context, in *GuestPingRequest, opts ...grpc.CallOption) (*GuestPingResponse, error) {
	out := new(GuestPingResponse)
	err := grpc.Invoke(ctx, "/kubevirt.cmd.v1.Cmd/GuestPing", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Cmd service

type CmdServer interface {
	SyncVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	PauseVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	UnpauseVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	FreezeVirtualMachine(context.Context, *FreezeRequest) (*Response, error)
	UnfreezeVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	SoftRebootVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	ShutdownVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	KillVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	DeleteVirtualMachine(context.Context, *VMIRequest) (*Response, error)
	MigrateVirtualMachine(context.Context, *MigrationRequest) (*Response, error)
	SyncMigrationTarget(context.Context, *VMIRequest) (*Response, error)
	CancelVirtualMachineMigration(context.Context, *VMIRequest) (*Response, error)
	SignalTargetPodCleanup(context.Context, *VMIRequest) (*Response, error)
	FinalizeVirtualMachineMigration(context.Context, *VMIRequest) (*Response, error)
	GetDomain(context.Context, *EmptyRequest) (*DomainResponse, error)
	GetDomainStats(context.Context, *EmptyRequest) (*DomainStatsResponse, error)
	GetGuestInfo(context.Context, *EmptyRequest) (*GuestInfoResponse, error)
	GetUsers(context.Context, *EmptyRequest) (*GuestUserListResponse, error)
	GetFilesystems(context.Context, *EmptyRequest) (*GuestFilesystemsResponse, error)
	Ping(context.Context, *EmptyRequest) (*Response, error)
	Exec(context.Context, *ExecRequest) (*ExecResponse, error)
	GuestPing(context.Context, *GuestPingRequest) (*GuestPingResponse, error)
}

func RegisterCmdServer(s *grpc.Server, srv CmdServer) {
	s.RegisterService(&_Cmd_serviceDesc, srv)
}

func _Cmd_SyncVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).SyncVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/SyncVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).SyncVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_PauseVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).PauseVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/PauseVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).PauseVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_UnpauseVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).UnpauseVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/UnpauseVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).UnpauseVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_FreezeVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FreezeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).FreezeVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/FreezeVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).FreezeVirtualMachine(ctx, req.(*FreezeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_UnfreezeVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).UnfreezeVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/UnfreezeVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).UnfreezeVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_SoftRebootVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).SoftRebootVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/SoftRebootVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).SoftRebootVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_ShutdownVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).ShutdownVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/ShutdownVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).ShutdownVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_KillVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).KillVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/KillVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).KillVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_DeleteVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).DeleteVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/DeleteVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).DeleteVirtualMachine(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_MigrateVirtualMachine_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).MigrateVirtualMachine(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/MigrateVirtualMachine",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).MigrateVirtualMachine(ctx, req.(*MigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_SyncMigrationTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).SyncMigrationTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/SyncMigrationTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).SyncMigrationTarget(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_CancelVirtualMachineMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).CancelVirtualMachineMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/CancelVirtualMachineMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).CancelVirtualMachineMigration(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_SignalTargetPodCleanup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).SignalTargetPodCleanup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/SignalTargetPodCleanup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).SignalTargetPodCleanup(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_FinalizeVirtualMachineMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VMIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).FinalizeVirtualMachineMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/FinalizeVirtualMachineMigration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).FinalizeVirtualMachineMigration(ctx, req.(*VMIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GetDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GetDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GetDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GetDomain(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GetDomainStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GetDomainStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GetDomainStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GetDomainStats(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GetGuestInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GetGuestInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GetGuestInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GetGuestInfo(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GetUsers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GetUsers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GetUsers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GetUsers(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GetFilesystems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GetFilesystems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GetFilesystems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GetFilesystems(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmptyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).Ping(ctx, req.(*EmptyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_Exec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).Exec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/Exec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).Exec(ctx, req.(*ExecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Cmd_GuestPing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GuestPingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CmdServer).GuestPing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kubevirt.cmd.v1.Cmd/GuestPing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CmdServer).GuestPing(ctx, req.(*GuestPingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Cmd_serviceDesc = grpc.ServiceDesc{
	ServiceName: "kubevirt.cmd.v1.Cmd",
	HandlerType: (*CmdServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SyncVirtualMachine",
			Handler:    _Cmd_SyncVirtualMachine_Handler,
		},
		{
			MethodName: "PauseVirtualMachine",
			Handler:    _Cmd_PauseVirtualMachine_Handler,
		},
		{
			MethodName: "UnpauseVirtualMachine",
			Handler:    _Cmd_UnpauseVirtualMachine_Handler,
		},
		{
			MethodName: "FreezeVirtualMachine",
			Handler:    _Cmd_FreezeVirtualMachine_Handler,
		},
		{
			MethodName: "UnfreezeVirtualMachine",
			Handler:    _Cmd_UnfreezeVirtualMachine_Handler,
		},
		{
			MethodName: "SoftRebootVirtualMachine",
			Handler:    _Cmd_SoftRebootVirtualMachine_Handler,
		},
		{
			MethodName: "ShutdownVirtualMachine",
			Handler:    _Cmd_ShutdownVirtualMachine_Handler,
		},
		{
			MethodName: "KillVirtualMachine",
			Handler:    _Cmd_KillVirtualMachine_Handler,
		},
		{
			MethodName: "DeleteVirtualMachine",
			Handler:    _Cmd_DeleteVirtualMachine_Handler,
		},
		{
			MethodName: "MigrateVirtualMachine",
			Handler:    _Cmd_MigrateVirtualMachine_Handler,
		},
		{
			MethodName: "SyncMigrationTarget",
			Handler:    _Cmd_SyncMigrationTarget_Handler,
		},
		{
			MethodName: "CancelVirtualMachineMigration",
			Handler:    _Cmd_CancelVirtualMachineMigration_Handler,
		},
		{
			MethodName: "SignalTargetPodCleanup",
			Handler:    _Cmd_SignalTargetPodCleanup_Handler,
		},
		{
			MethodName: "FinalizeVirtualMachineMigration",
			Handler:    _Cmd_FinalizeVirtualMachineMigration_Handler,
		},
		{
			MethodName: "GetDomain",
			Handler:    _Cmd_GetDomain_Handler,
		},
		{
			MethodName: "GetDomainStats",
			Handler:    _Cmd_GetDomainStats_Handler,
		},
		{
			MethodName: "GetGuestInfo",
			Handler:    _Cmd_GetGuestInfo_Handler,
		},
		{
			MethodName: "GetUsers",
			Handler:    _Cmd_GetUsers_Handler,
		},
		{
			MethodName: "GetFilesystems",
			Handler:    _Cmd_GetFilesystems_Handler,
		},
		{
			MethodName: "Ping",
			Handler:    _Cmd_Ping_Handler,
		},
		{
			MethodName: "Exec",
			Handler:    _Cmd_Exec_Handler,
		},
		{
			MethodName: "GuestPing",
			Handler:    _Cmd_GuestPing_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "pkg/handler-launcher-com/cmd/v1/cmd.proto",
}

func init() { proto.RegisterFile("pkg/handler-launcher-com/cmd/v1/cmd.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1356 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x5f, 0x6f, 0xdb, 0x36,
	0x10, 0x8f, 0x63, 0x27, 0xb5, 0x2f, 0x7f, 0xd6, 0xb2, 0x49, 0xa6, 0x65, 0x6b, 0xeb, 0x09, 0x43,
	0x90, 0x02, 0x6d, 0xb2, 0x64, 0x69, 0x31, 0xf4, 0x61, 0xe8, 0xe2, 0xba, 0x41, 0xdb, 0xb9, 0xf5,
	0xe8, 0x24, 0xc5, 0xba, 0x01, 0x05, 0x23, 0x31, 0x0e, 0x11, 0x89, 0xf4, 0x44, 0xca, 0x8b, 0xfb,
	0xba, 0x61, 0x0f, 0x03, 0xf6, 0x71, 0xf6, 0x59, 0xf6, 0xbc, 0x6f, 0x32, 0x90, 0xa2, 0x1c, 0xdb,
	0x92, 0x9b, 0x16, 0xf6, 0x93, 0x79, 0xff, 0x7e, 0x77, 0x3c, 0xde, 0x91, 0x27, 0xc3, 0xdd, 0xce,
	0x79, 0x7b, 0xfb, 0x8c, 0x70, 0x3f, 0xa0, 0xd1, 0xfd, 0x80, 0xc4, 0xdc, 0x3b, 0xa3, 0xd1, 0x7d,
	0x4f, 0x84, 0xdb, 0x5e, 0xe8, 0x6f, 0x77, 0x77, 0xf4, 0xcf, 0x56, 0x27, 0x12, 0x4a, 0xa0, 0x4f,
	0xce, 0xe3, 0x13, 0xda, 0x65, 0x91, 0xda, 0xd2, 0xbc, 0xee, 0x8e, 0x7b, 0x07, 0x8a, 0xc7, 0x8d,
	0x67, 0xc8, 0x81, 0x6b, 0xdd, 0x90, 0x3d, 0x97, 0x82, 0x3b, 0x85, 0x6a, 0x61, 0x73, 0x11, 0xa7,
	0xa4, 0xbb, 0x03, 0xc5, 0x5a, 0xf3, 0x08, 0x2d, 0xc3, 0x2c, 0xf3, 0x8d, 0x6c, 0x09, 0xcf, 0x32,
	0x1f, 0xad, 0x43, 0x59, 0xb2, 0x93, 0x80, 0xf1, 0xb6, 0x74, 0x66, 0xab, 0xc5, 0xcd, 0x25, 0xdc,
	0xa7, 0xdd, 0x6d, 0xb8, 0xd6, 0x4a, 0xd6, 0x19, 0xb3, 0x15, 0x98, 0xeb, 0x92, 0x20, 0xa6, 0xce,
	0x6c, 0xb5, 0xb0, 0x59, 0xc2, 0x09, 0xe1, 0xd6, 0x61, 0xae, 0x49, 0xda, 0x54, 0x6a, 0xb1, 0x27,
	0x62, 0xae, 0x8c, 0x45, 0x09, 0x27, 0x04, 0x42, 0x50, 0x8a, 0x39, 0x53, 0xc6, 0xa6, 0x82, 0xcd,
	0x5a, 0xf3, 0x24, 0x7b, 0x47, 0x9d, 0xa2, 0x81, 0x36, 0x6b, 0x77, 0x0f, 0xe6, 0x1b, 0x34, 0x14,
	0x51, 0x0f, 0xad, 0xc1, 0x3c, 0x09, 0x07, 0x80, 0x2c, 0x95, 0x87, 0xe4, 0xfe, 0x5b, 0x80, 0x52,
	0x8d, 0x06, 0x41, 0x26, 0xd6, 0x6d, 0x98, 0x0f, 0x0d, 0x9c, 0x51, 0x5f, 0xd8, 0xfd, 0x74, 0x6b,
	0x24, 0x79, 0x5b, 0x89, 0x37, 0x6c, 0xd5, 0xd0, 0x3d, 0x98, 0xeb, 0xe8, 0x6d, 0x38, 0xc5, 0x6a,
	0x71, 0x73, 0x61, 0x77, 0x2d, 0xa3, 0x6f, 0x36, 0x89, 0x13, 0x25, 0xf4, 0x10, 0x2a, 0x3e, 0x93,
	0x8a, 0x70, 0x8f, 0x4a, 0xa7, 0x64, 0x2c, 0x9c, 0x8c, 0x85, 0xcd, 0x23, 0xbe, 0x54, 0x45, 0x9b,
	0x50, 0xf2, 0x3a, 0xb1, 0x74, 0xe6, 0x8c, 0xc9, 0x4a, 0xc6, 0xa4, 0xd6, 0x3c, 0xc2, 0x46, 0xc3,
	0x7d, 0x0c, 0xe5, 0x43, 0xd1, 0x11, 0x81, 0x68, 0xf7, 0xd0, 0x1e, 0x00, 0x8f, 0x43, 0xf2, 0xd6,
	0xa3, 0x41, 0x20, 0x9d, 0x82, 0xb1, 0x5d, 0xcd, 0xda, 0xd2, 0x20, 0xc0, 0x15, 0xad, 0xa8, 0x57,
	0xd2, 0xfd, 0xab, 0x00, 0xf3, 0xad, 0xc6, 0x3e, 0x13, 0x12, 0xb9, 0xb0, 0x18, 0x12, 0x1e, 0x9f,
	0x12, 0x4f, 0xc5, 0x11, 0x8d, 0x4c, 0x9e, 0x2a, 0x78, 0x88, 0xa7, 0xab, 0xa8, 0x13, 0x09, 0x3f,
	0xf6, 0xd2, 0x0c, 0xa7, 0xa4, 0xa9, 0x2f, 0x1a, 0x49, 0x26, 0xb8, 0x39, 0xb1, 0x0a, 0x4e, 0x49,
	0x74, 0x1d, 0x8a, 0xf2, 0x3c, 0x76, 0x4a, 0x86, 0xab, 0x97, 0xfa, 0xf0, 0x4e, 0x49, 0xc8, 0x82,
	0x9e, 0x33, 0x67, 0x98, 0x96, 0x72, 0xff, 0x2c, 0x40, 0xf9, 0x09, 0x93, 0xe7, 0xcf, 0xf8, 0xa9,
	0x30, 0x4a, 0x22, 0x0a, 0x89, 0xb2, 0x81, 0x58, 0x0a, 0x55, 0x61, 0xe1, 0x84, 0x78, 0xe7, 0x8c,
	0xb7, 0x9f, 0xb2, 0x80, 0xda, 0x30, 0x06, 0x59, 0xe8, 0x36, 0x80, 0x8e, 0x97, 0x04, 0xad, 0xb4,
	0x7e, 0x4a, 0x78, 0x80, 0xa3, 0x11, 0x74, 0x4a, 0x52, 0x85, 0x92, 0x51, 0x18, 0x64, 0xb9, 0xff,
	0x15, 0x61, 0xf5, 0x38, 0xa1, 0x1b, 0xc4, 0x3b, 0x63, 0x9c, 0xbe, 0xea, 0x28, 0x26, 0xb8, 0x44,
	0x2f, 0x60, 0x65, 0x58, 0x90, 0x24, 0xcf, 0xc4, 0x98, 0x57, 0x40, 0x89, 0x18, 0xe7, 0x1a, 0xa1,
	0x3d, 0x58, 0x6d, 0xd0, 0x70, 0x9f, 0x04, 0x81, 0x10, 0xbc, 0xa5, 0x88, 0x92, 0x4d, 0x1a, 0x31,
	0xe1, 0x9b, 0x4d, 0x2d, 0xe1, 0x7c, 0x21, 0xfa, 0x1a, 0x6e, 0x36, 0x23, 0xaa, 0xf9, 0x1e, 0x51,
	0xd4, 0x3f, 0x16, 0x41, 0x1c, 0xda, 0x92, 0xac, 0xe0, 0x3c, 0x11, 0x7a, 0x00, 0x65, 0x65, 0xcb,
	0xc4, 0xec, 0x76, 0x61, 0xf7, 0xb3, 0x4c, 0xa0, 0x69, 0x1d, 0xe1, 0xbe, 0x2a, 0x6a, 0x41, 0x45,
	0x9f, 0x86, 0xd4, 0xc7, 0x61, 0x8b, 0xf1, 0x41, 0xc6, 0x2e, 0x37, 0x4d, 0x5b, 0x7d, 0xbb, 0x3a,
	0x57, 0x51, 0x0f, 0x5f, 0xe2, 0xa0, 0x2d, 0x40, 0xf5, 0x8b, 0x0e, 0xe1, 0xbe, 0x61, 0xd5, 0x39,
	0x39, 0x09, 0xa8, 0xef, 0xcc, 0x57, 0x0b, 0x9b, 0x65, 0x9c, 0x23, 0x59, 0x7f, 0x0d, 0xcb, 0xc3,
	0x60, 0xba, 0x9e, 0xce, 0x69, 0xcf, 0x56, 0x85, 0x5e, 0xa2, 0xed, 0xc1, 0x3b, 0x27, 0x6f, 0x73,
	0x69, 0x51, 0xd9, 0xeb, 0xe8, 0xd1, 0xec, 0xb7, 0x05, 0xb7, 0x0b, 0x70, 0xdc, 0x78, 0x86, 0xe9,
	0xaf, 0x31, 0x95, 0x0a, 0x6d, 0x40, 0xb1, 0x1b, 0x32, 0x7b, 0x8c, 0xd9, 0x96, 0xd3, 0x9a, 0x5a,
	0x01, 0x3d, 0x86, 0x6b, 0x22, 0xd9, 0xa3, 0x75, 0xb6, 0xf1, 0x61, 0x19, 0xc1, 0xa9, 0x99, 0x7b,
	0x08, 0xd7, 0x1b, 0xac, 0x1d, 0x11, 0x4d, 0x7d, 0xac, 0x77, 0x67, 0xd8, 0xfb, 0xe2, 0x25, 0xea,
	0xef, 0x05, 0x58, 0xa8, 0x5f, 0x50, 0x2f, 0x45, 0xbc, 0x0d, 0xe0, 0x8b, 0x90, 0x30, 0xfe, 0x92,
	0x84, 0xd4, 0xe6, 0x6a, 0x80, 0xa3, 0x91, 0x6a, 0x22, 0x0c, 0x09, 0xf7, 0xd3, 0x46, 0xb6, 0xa4,
	0xbe, 0x41, 0xbf, 0x8f, 0xda, 0x69, 0x3d, 0x99, 0x35, 0xda, 0x80, 0x65, 0xc5, 0x42, 0x2a, 0x62,
	0xd5, 0xa2, 0x9e, 0xe0, 0xbe, 0x34, 0x65, 0x34, 0x87, 0x47, 0xb8, 0xee, 0x32, 0x2c, 0xd6, 0xc3,
	0x8e, 0xea, 0xd9, 0x28, 0xdc, 0xef, 0xa0, 0x8c, 0xa9, 0xec, 0x08, 0x2e, 0x8d, 0x47, 0x19, 0x7b,
	0x1e, 0x95, 0x49, 0xb3, 0x94, 0x71, 0x4a, 0x6a, 0x49, 0x48, 0xa5, 0x24, 0xed, 0xb4, 0x9b, 0x53,
	0xd2, 0x7d, 0x0b, 0xcb, 0x4f, 0x4c, 0xcc, 0x7d, 0x94, 0x07, 0x50, 0x8e, 0xec, 0xda, 0xa6, 0x2b,
	0x7b, 0xda, 0xa9, 0x32, 0xee, 0xab, 0xea, 0xcb, 0x24, 0xd9, 0xbc, 0xf5, 0x60, 0x29, 0x97, 0xc3,
	0xcd, 0xc4, 0x81, 0x69, 0xb0, 0x49, 0xbd, 0x54, 0x61, 0xc1, 0xbf, 0x44, 0x4b, 0xaf, 0xa6, 0x01,
	0x96, 0x7b, 0x01, 0x37, 0x0e, 0x74, 0x66, 0x4c, 0x31, 0x4e, 0xe8, 0xed, 0x1e, 0xdc, 0x68, 0x8f,
	0x62, 0x59, 0x9f, 0x59, 0x81, 0xfb, 0x47, 0x01, 0x56, 0x8d, 0xeb, 0x23, 0x49, 0xa3, 0x1f, 0x98,
	0x54, 0x93, 0xba, 0xdf, 0x83, 0xd5, 0x76, 0x1e, 0x9e, 0x0d, 0x21, 0x5f, 0xe8, 0xfe, 0x5d, 0x00,
	0xc7, 0x84, 0xa1, 0x6f, 0x6a, 0xd9, 0x93, 0x8a, 0x86, 0x13, 0xa7, 0xfd, 0x11, 0x38, 0xed, 0x31,
	0x90, 0x36, 0x98, 0xb1, 0x72, 0xb7, 0x07, 0x8b, 0x49, 0xdb, 0x4c, 0x16, 0xc2, 0x3a, 0x94, 0xe9,
	0x05, 0x53, 0x35, 0xe1, 0x27, 0x2e, 0xe7, 0x70, 0x9f, 0xd6, 0xb5, 0x27, 0x95, 0xff, 0x2a, 0x56,
	0xf6, 0x61, 0xb4, 0x94, 0xfb, 0x06, 0xae, 0x9b, 0x4c, 0x34, 0xf5, 0xf3, 0xff, 0x81, 0x6d, 0x9b,
	0x6d, 0xc4, 0xd9, 0xdc, 0x46, 0x7c, 0x6e, 0xeb, 0x2c, 0xc1, 0x9e, 0x68, 0x6f, 0xae, 0x80, 0xa5,
	0xa7, 0x11, 0xa5, 0xef, 0xe8, 0xc7, 0xde, 0x56, 0x0f, 0x61, 0x2d, 0xe6, 0xa7, 0xc6, 0xf4, 0x30,
	0x2f, 0xe8, 0x31, 0xd2, 0xdd, 0x7f, 0x96, 0xa1, 0x58, 0x0b, 0x7d, 0xf4, 0x12, 0x50, 0xab, 0xc7,
	0xbd, 0xe1, 0xfb, 0x14, 0x7d, 0x9e, 0xeb, 0x30, 0x09, 0x6d, 0x7d, 0xfc, 0x86, 0xdc, 0x19, 0xf4,
	0x0a, 0x6e, 0x36, 0x49, 0x2c, 0xe9, 0xd4, 0x00, 0x7f, 0x84, 0xd5, 0x23, 0xde, 0x99, 0x2a, 0x64,
	0x0b, 0x56, 0x92, 0x64, 0x8f, 0x20, 0xde, 0xce, 0x18, 0x0d, 0x9d, 0xc9, 0xfb, 0x41, 0x31, 0xac,
	0x1d, 0xd9, 0x54, 0x4f, 0x2d, 0xd0, 0x43, 0x70, 0x5a, 0xe2, 0x54, 0x61, 0x7a, 0x22, 0x84, 0x9a,
	0x1a, 0x2a, 0x86, 0xb5, 0xd6, 0x59, 0xac, 0x7c, 0xf1, 0x1b, 0x9f, 0x1a, 0xe6, 0x4b, 0x40, 0x2f,
	0x58, 0x10, 0x4c, 0x0d, 0xaf, 0x09, 0x2b, 0x4f, 0x68, 0x40, 0xd5, 0xf4, 0x72, 0xf9, 0x1a, 0x56,
	0x93, 0x91, 0x60, 0x14, 0xf2, 0xcb, 0xec, 0x07, 0xc9, 0xc8, 0xe8, 0x70, 0x65, 0xc5, 0xeb, 0x0e,
	0xea, 0x1b, 0x1d, 0x92, 0xa8, 0x4d, 0xd5, 0x04, 0x91, 0xfe, 0x04, 0xb7, 0x6a, 0xfa, 0x23, 0x65,
	0x24, 0x9b, 0x7d, 0x07, 0x13, 0x1e, 0x3d, 0x6b, 0x73, 0x12, 0x24, 0x41, 0x36, 0x85, 0x5f, 0x0b,
	0x28, 0xe1, 0x71, 0x67, 0x02, 0xcc, 0x9f, 0xe1, 0xce, 0x53, 0xc6, 0x49, 0xc0, 0x46, 0x0b, 0x7f,
	0x1a, 0x01, 0x37, 0xa0, 0x72, 0x40, 0x55, 0x32, 0x3e, 0xa0, 0x5b, 0x19, 0xcd, 0xc1, 0x41, 0x68,
	0xfd, 0x4e, 0x76, 0x24, 0x1d, 0x9a, 0x6b, 0x4c, 0x11, 0x2c, 0xf7, 0xe1, 0xcc, 0xb0, 0x70, 0x15,
	0xe6, 0x57, 0x63, 0x30, 0x87, 0x46, 0x19, 0x73, 0xa5, 0x2c, 0x1e, 0x50, 0xd5, 0x1f, 0x3b, 0xae,
	0x82, 0x75, 0x33, 0xe2, 0xcc, 0xc4, 0x62, 0x40, 0xcb, 0x07, 0xd4, 0x3c, 0xef, 0x57, 0xc6, 0xb9,
	0x91, 0x0f, 0x98, 0x19, 0x0d, 0x66, 0xd0, 0x2f, 0x26, 0x05, 0x03, 0xcf, 0xf4, 0x55, 0xd0, 0x77,
	0xf3, 0xa1, 0xf3, 0x1e, 0xfa, 0x19, 0xb4, 0x0f, 0x25, 0xfd, 0x1c, 0x5e, 0x85, 0xf9, 0xde, 0x33,
	0xaf, 0x43, 0x49, 0x8f, 0x0b, 0xe8, 0x8b, 0x2c, 0xc6, 0xe5, 0xf0, 0xbd, 0x7e, 0x6b, 0x8c, 0x74,
	0xe0, 0xf2, 0xac, 0xf4, 0x9f, 0xe7, 0x9c, 0x26, 0x1f, 0x1d, 0x0b, 0xc6, 0x9d, 0xc9, 0xe0, 0xeb,
	0xee, 0xce, 0xec, 0x97, 0xde, 0xcc, 0x76, 0x77, 0x4e, 0xe6, 0xcd, 0xff, 0x40, 0xdf, 0xfc, 0x1f,
	0x00, 0x00, 0xff, 0xff, 0x05, 0xc7, 0x21, 0x6a, 0x34, 0x12, 0x00, 0x00,
}
