// +build !ignore_autogenerated

/*
Copyright 2019 The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1

import (
	spec "github.com/go-openapi/spec"
	common "k8s.io/kube-openapi/pkg/common"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.BIOS":                                      schema_kubevirtio_client_go_api_v1_BIOS(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Bootloader":                                schema_kubevirtio_client_go_api_v1_Bootloader(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CDRomTarget":                               schema_kubevirtio_client_go_api_v1_CDRomTarget(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPU":                                       schema_kubevirtio_client_go_api_v1_CPU(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPUFeature":                                schema_kubevirtio_client_go_api_v1_CPUFeature(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Clock":                                     schema_kubevirtio_client_go_api_v1_Clock(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffset":                               schema_kubevirtio_client_go_api_v1_ClockOffset(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffsetUTC":                            schema_kubevirtio_client_go_api_v1_ClockOffsetUTC(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitConfigDriveSource":                schema_kubevirtio_client_go_api_v1_CloudInitConfigDriveSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitNoCloudSource":                    schema_kubevirtio_client_go_api_v1_CloudInitNoCloudSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ConfigMapVolumeSource":                     schema_kubevirtio_client_go_api_v1_ConfigMapVolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ContainerDiskSource":                       schema_kubevirtio_client_go_api_v1_ContainerDiskSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DHCPOptions":                               schema_kubevirtio_client_go_api_v1_DHCPOptions(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DataVolumeSource":                          schema_kubevirtio_client_go_api_v1_DataVolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Devices":                                   schema_kubevirtio_client_go_api_v1_Devices(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Disk":                                      schema_kubevirtio_client_go_api_v1_Disk(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskDevice":                                schema_kubevirtio_client_go_api_v1_DiskDevice(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskTarget":                                schema_kubevirtio_client_go_api_v1_DiskTarget(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DomainSpec":                                schema_kubevirtio_client_go_api_v1_DomainSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EFI":                                       schema_kubevirtio_client_go_api_v1_EFI(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EmptyDiskSource":                           schema_kubevirtio_client_go_api_v1_EmptyDiskSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EphemeralVolumeSource":                     schema_kubevirtio_client_go_api_v1_EphemeralVolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureAPIC":                               schema_kubevirtio_client_go_api_v1_FeatureAPIC(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureHyperv":                             schema_kubevirtio_client_go_api_v1_FeatureHyperv(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureSpinlocks":                          schema_kubevirtio_client_go_api_v1_FeatureSpinlocks(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState":                              schema_kubevirtio_client_go_api_v1_FeatureState(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureVendorID":                           schema_kubevirtio_client_go_api_v1_FeatureVendorID(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Features":                                  schema_kubevirtio_client_go_api_v1_Features(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Firmware":                                  schema_kubevirtio_client_go_api_v1_Firmware(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FloppyTarget":                              schema_kubevirtio_client_go_api_v1_FloppyTarget(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.GenieNetwork":                              schema_kubevirtio_client_go_api_v1_GenieNetwork(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HPETTimer":                                 schema_kubevirtio_client_go_api_v1_HPETTimer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HostDisk":                                  schema_kubevirtio_client_go_api_v1_HostDisk(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Hugepages":                                 schema_kubevirtio_client_go_api_v1_Hugepages(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HypervTimer":                               schema_kubevirtio_client_go_api_v1_HypervTimer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.I6300ESBWatchdog":                          schema_kubevirtio_client_go_api_v1_I6300ESBWatchdog(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Input":                                     schema_kubevirtio_client_go_api_v1_Input(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Interface":                                 schema_kubevirtio_client_go_api_v1_Interface(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBindingMethod":                    schema_kubevirtio_client_go_api_v1_InterfaceBindingMethod(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBridge":                           schema_kubevirtio_client_go_api_v1_InterfaceBridge(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceMasquerade":                       schema_kubevirtio_client_go_api_v1_InterfaceMasquerade(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSRIOV":                            schema_kubevirtio_client_go_api_v1_InterfaceSRIOV(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSlirp":                            schema_kubevirtio_client_go_api_v1_InterfaceSlirp(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KVMTimer":                                  schema_kubevirtio_client_go_api_v1_KVMTimer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirt":                                  schema_kubevirtio_client_go_api_v1_KubeVirt(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtCondition":                         schema_kubevirtio_client_go_api_v1_KubeVirtCondition(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtList":                              schema_kubevirtio_client_go_api_v1_KubeVirtList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtSpec":                              schema_kubevirtio_client_go_api_v1_KubeVirtSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtStatus":                            schema_kubevirtio_client_go_api_v1_KubeVirtStatus(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.LunTarget":                                 schema_kubevirtio_client_go_api_v1_LunTarget(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Machine":                                   schema_kubevirtio_client_go_api_v1_Machine(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Memory":                                    schema_kubevirtio_client_go_api_v1_Memory(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.MultusNetwork":                             schema_kubevirtio_client_go_api_v1_MultusNetwork(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Network":                                   schema_kubevirtio_client_go_api_v1_Network(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.NetworkSource":                             schema_kubevirtio_client_go_api_v1_NetworkSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PITTimer":                                  schema_kubevirtio_client_go_api_v1_PITTimer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PodNetwork":                                schema_kubevirtio_client_go_api_v1_PodNetwork(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Port":                                      schema_kubevirtio_client_go_api_v1_Port(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.RTCTimer":                                  schema_kubevirtio_client_go_api_v1_RTCTimer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ResourceRequirements":                      schema_kubevirtio_client_go_api_v1_ResourceRequirements(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Rng":                                       schema_kubevirtio_client_go_api_v1_Rng(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.SecretVolumeSource":                        schema_kubevirtio_client_go_api_v1_SecretVolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ServiceAccountVolumeSource":                schema_kubevirtio_client_go_api_v1_ServiceAccountVolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Timer":                                     schema_kubevirtio_client_go_api_v1_Timer(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachine":                            schema_kubevirtio_client_go_api_v1_VirtualMachine(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineCondition":                   schema_kubevirtio_client_go_api_v1_VirtualMachineCondition(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstance":                    schema_kubevirtio_client_go_api_v1_VirtualMachineInstance(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceCondition":           schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceCondition(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceList":                schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigration":           schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigration(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationCondition":  schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationCondition(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationList":       schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationSpec":       schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationStatus":     schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationStatus(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceNetworkInterface":    schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceNetworkInterface(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePreset":              schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePreset(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePresetList":          schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePresetList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePresetSpec":          schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePresetSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSet":          schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSet(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetCondition": schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetCondition(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetList":      schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetSpec":      schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetStatus":    schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetStatus(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceSpec":                schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceStatus":              schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceStatus(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceTemplateSpec":        schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceTemplateSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineList":                        schema_kubevirtio_client_go_api_v1_VirtualMachineList(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineSpec":                        schema_kubevirtio_client_go_api_v1_VirtualMachineSpec(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineStatus":                      schema_kubevirtio_client_go_api_v1_VirtualMachineStatus(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Volume":                                    schema_kubevirtio_client_go_api_v1_Volume(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VolumeSource":                              schema_kubevirtio_client_go_api_v1_VolumeSource(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Watchdog":                                  schema_kubevirtio_client_go_api_v1_Watchdog(ref),
		"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.WatchdogDevice":                            schema_kubevirtio_client_go_api_v1_WatchdogDevice(ref),
	}
}

func schema_kubevirtio_client_go_api_v1_BIOS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "If set (default), BIOS will be used.",
				Properties:  map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Bootloader(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the firmware blob used to assist in the domain creation process. Used for setting the QEMU BIOS file path for the libvirt domain.",
				Properties: map[string]spec.Schema{
					"bios": {
						SchemaProps: spec.SchemaProps{
							Description: "If set (default), BIOS will be used.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.BIOS"),
						},
					},
					"efi": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, EFI will be used instead of BIOS.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EFI"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.BIOS", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EFI"},
	}
}

func schema_kubevirtio_client_go_api_v1_CDRomTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"bus": {
						SchemaProps: spec.SchemaProps{
							Description: "Bus indicates the type of disk device to emulate. supported values: virtio, sata, scsi.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readonly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tray": {
						SchemaProps: spec.SchemaProps{
							Description: "Tray indicates if the tray of the device is open or closed. Allowed values are \"open\" and \"closed\". Defaults to closed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_CPU(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CPU allows specifying the CPU topology.",
				Properties: map[string]spec.Schema{
					"cores": {
						SchemaProps: spec.SchemaProps{
							Description: "Cores specifies the number of cores inside the vmi. Must be a value greater or equal 1.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"sockets": {
						SchemaProps: spec.SchemaProps{
							Description: "Sockets specifies the number of sockets inside the vmi. Must be a value greater or equal 1.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"threads": {
						SchemaProps: spec.SchemaProps{
							Description: "Threads specifies the number of threads inside the vmi. Must be a value greater or equal 1.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"model": {
						SchemaProps: spec.SchemaProps{
							Description: "Model specifies the CPU model inside the VMI. List of available models https://github.com/libvirt/libvirt/tree/master/src/cpu_map. It is possible to specify special cases like \"host-passthrough\" to get the same CPU as the node and \"host-model\" to get CPU closest to the node one. Defaults to host-model.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"features": {
						SchemaProps: spec.SchemaProps{
							Description: "Features specifies the CPU features list inside the VMI.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPUFeature"),
									},
								},
							},
						},
					},
					"dedicatedCpuPlacement": {
						SchemaProps: spec.SchemaProps{
							Description: "DedicatedCPUPlacement requests the scheduler to place the VirtualMachineInstance on a node with enough dedicated pCPUs and pin the vCPUs to it.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPUFeature"},
	}
}

func schema_kubevirtio_client_go_api_v1_CPUFeature(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CPUFeature allows specifying a CPU feature.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the CPU feature",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policy": {
						SchemaProps: spec.SchemaProps{
							Description: "Policy is the CPU feature attribute which can have the following attributes: force    - The virtual CPU will claim the feature is supported regardless of it being supported by host CPU. require  - Guest creation will fail unless the feature is supported by the host CPU or the hypervisor is able to emulate it. optional - The feature will be supported by virtual CPU if and only if it is supported by host CPU. disable  - The feature will not be supported by virtual CPU. forbid   - Guest creation will fail if the feature is supported by host CPU. Defaults to require",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Clock(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the clock and timers of a vmi.",
				Properties: map[string]spec.Schema{
					"utc": {
						SchemaProps: spec.SchemaProps{
							Description: "UTC sets the guest clock to UTC on each boot. If an offset is specified, guest changes to the clock will be kept during reboots and are not reset.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffsetUTC"),
						},
					},
					"timezone": {
						SchemaProps: spec.SchemaProps{
							Description: "Timezone sets the guest clock to the specified timezone. Zone name follows the TZ environment variable format (e.g. 'America/New_York').",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffsetUTC"},
	}
}

func schema_kubevirtio_client_go_api_v1_ClockOffset(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Exactly one of its members must be set.",
				Properties: map[string]spec.Schema{
					"utc": {
						SchemaProps: spec.SchemaProps{
							Description: "UTC sets the guest clock to UTC on each boot. If an offset is specified, guest changes to the clock will be kept during reboots and are not reset.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffsetUTC"),
						},
					},
					"timezone": {
						SchemaProps: spec.SchemaProps{
							Description: "Timezone sets the guest clock to the specified timezone. Zone name follows the TZ environment variable format (e.g. 'America/New_York').",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ClockOffsetUTC"},
	}
}

func schema_kubevirtio_client_go_api_v1_ClockOffsetUTC(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UTC sets the guest clock to UTC on each boot.",
				Properties: map[string]spec.Schema{
					"offsetSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "OffsetSeconds specifies an offset in seconds, relative to UTC. If set, guest changes to the clock will be kept during reboots and not reset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_CloudInitConfigDriveSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a cloud-init config drive user data source. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html",
				Properties: map[string]spec.Schema{
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "UserDataSecretRef references a k8s secret that contains config drive userdata.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"userDataBase64": {
						SchemaProps: spec.SchemaProps{
							Description: "UserDataBase64 contains config drive cloud-init userdata as a base64 encoded string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"userData": {
						SchemaProps: spec.SchemaProps{
							Description: "UserData contains config drive inline cloud-init userdata.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkDataSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkDataSecretRef references a k8s secret that contains config drive networkdata.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"networkDataBase64": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkDataBase64 contains config drive cloud-init networkdata as a base64 encoded string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkData": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkData contains config drive inline cloud-init networkdata.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_kubevirtio_client_go_api_v1_CloudInitNoCloudSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a cloud-init nocloud user data source. More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html",
				Properties: map[string]spec.Schema{
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "UserDataSecretRef references a k8s secret that contains NoCloud userdata.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"userDataBase64": {
						SchemaProps: spec.SchemaProps{
							Description: "UserDataBase64 contains NoCloud cloud-init userdata as a base64 encoded string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"userData": {
						SchemaProps: spec.SchemaProps{
							Description: "UserData contains NoCloud inline cloud-init userdata.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkDataSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkDataSecretRef references a k8s secret that contains NoCloud networkdata.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"networkDataBase64": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkDataBase64 contains NoCloud cloud-init networkdata as a base64 encoded string.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networkData": {
						SchemaProps: spec.SchemaProps{
							Description: "NetworkData contains NoCloud inline cloud-init networkdata.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_kubevirtio_client_go_api_v1_ConfigMapVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapVolumeSource adapts a ConfigMap into a volume. More info: https://kubernetes.io/docs/concepts/storage/volumes/#configmap",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the ConfigMap or it's keys must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_ContainerDiskSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a docker image with an embedded disk.",
				Properties: map[string]spec.Schema{
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Image is the name of the image with the embedded disk.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullSecret": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullSecret is the name of the Docker registry secret required to pull the image. The secret must already exist.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path defines the path to disk file in the container",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"image"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_DHCPOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Extra DHCP options to use in the interface.",
				Properties: map[string]spec.Schema{
					"bootFileName": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified will pass option 67 to interface's DHCP server",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tftpServerName": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified will pass option 66 to interface's DHCP server",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ntpServers": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified will pass the configured NTP server to the VM via DHCP option 042.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"privateOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified will pass extra DHCP options for private use, range: 224-254",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DHCPPrivateOptions"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DHCPPrivateOptions"},
	}
}

func schema_kubevirtio_client_go_api_v1_DataVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name represents the name of the DataVolume in the same namespace",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Devices(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"disks": {
						SchemaProps: spec.SchemaProps{
							Description: "Disks describes disks, cdroms, floppy and luns which are connected to the vmi.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Disk"),
									},
								},
							},
						},
					},
					"watchdog": {
						SchemaProps: spec.SchemaProps{
							Description: "Watchdog describes a watchdog device which can be added to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Watchdog"),
						},
					},
					"interfaces": {
						SchemaProps: spec.SchemaProps{
							Description: "Interfaces describe network interfaces which are added to the vmi.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Interface"),
									},
								},
							},
						},
					},
					"inputs": {
						SchemaProps: spec.SchemaProps{
							Description: "Inputs describe input devices",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Input"),
									},
								},
							},
						},
					},
					"autoattachPodInterface": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether to attach a pod network interface. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"autoattachGraphicsDevice": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether to attach the default graphics device or not. VNC will not be available if set to false. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rng": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether to have random number generator from host",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Rng"),
						},
					},
					"blockMultiQueue": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether or not to enable virtio multi-queue for block devices",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"networkInterfaceMultiqueue": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, virtual network interfaces configured with a virtio bus will also enable the vhost multiqueue feature",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Disk", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Input", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Interface", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Rng", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Watchdog"},
	}
}

func schema_kubevirtio_client_go_api_v1_Disk(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the device name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"disk": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a disk to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskTarget"),
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a LUN to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.LunTarget"),
						},
					},
					"floppy": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a floppy to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FloppyTarget"),
						},
					},
					"cdrom": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a cdrom to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CDRomTarget"),
						},
					},
					"bootOrder": {
						SchemaProps: spec.SchemaProps{
							Description: "BootOrder is an integer value > 0, used to determine ordering of boot devices. Lower values take precedence. Each disk or interface that has a boot order must have a unique value. Disks without a boot order are not tried if a disk with a boot order exists.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"serial": {
						SchemaProps: spec.SchemaProps{
							Description: "Serial provides the ability to specify a serial number for the disk device.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dedicatedIOThread": {
						SchemaProps: spec.SchemaProps{
							Description: "dedicatedIOThread indicates this disk should have an exclusive IO Thread. Enabling this implies useIOThreads = true. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cache": {
						SchemaProps: spec.SchemaProps{
							Description: "Cache specifies which kvm disk cache mode should be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CDRomTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FloppyTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.LunTarget"},
	}
}

func schema_kubevirtio_client_go_api_v1_DiskDevice(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the target of a volume to mount. Only one of its members may be specified.",
				Properties: map[string]spec.Schema{
					"disk": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a disk to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskTarget"),
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a LUN to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.LunTarget"),
						},
					},
					"floppy": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a floppy to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FloppyTarget"),
						},
					},
					"cdrom": {
						SchemaProps: spec.SchemaProps{
							Description: "Attach a volume as a cdrom to the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CDRomTarget"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CDRomTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DiskTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FloppyTarget", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.LunTarget"},
	}
}

func schema_kubevirtio_client_go_api_v1_DiskTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"bus": {
						SchemaProps: spec.SchemaProps{
							Description: "Bus indicates the type of disk device to emulate. supported values: virtio, sata, scsi.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readonly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"pciAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the virtual disk will be placed on the guests pci address with the specifed PCI address. For example: 0000:81:01.10",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_DomainSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources describes the Compute Resources required by this vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ResourceRequirements"),
						},
					},
					"cpu": {
						SchemaProps: spec.SchemaProps{
							Description: "CPU allow specified the detailed CPU topology inside the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPU"),
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Description: "Memory allow specifying the VMI memory features.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Memory"),
						},
					},
					"machine": {
						SchemaProps: spec.SchemaProps{
							Description: "Machine type.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Machine"),
						},
					},
					"firmware": {
						SchemaProps: spec.SchemaProps{
							Description: "Firmware.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Firmware"),
						},
					},
					"clock": {
						SchemaProps: spec.SchemaProps{
							Description: "Clock sets the clock and timers of the vmi.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Clock"),
						},
					},
					"features": {
						SchemaProps: spec.SchemaProps{
							Description: "Features like acpi, apic, hyperv, smm.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Features"),
						},
					},
					"devices": {
						SchemaProps: spec.SchemaProps{
							Description: "Devices allows adding disks, network interfaces, ...",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Devices"),
						},
					},
					"ioThreadsPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Controls whether or not disks will share IOThreads. Omitting IOThreadsPolicy disables use of IOThreads. One of: shared, auto",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"devices"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CPU", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Clock", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Devices", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Features", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Firmware", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Machine", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Memory", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ResourceRequirements"},
	}
}

func schema_kubevirtio_client_go_api_v1_EFI(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "If set, EFI will be used instead of BIOS.",
				Properties:  map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_EmptyDiskSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EmptyDisk represents a temporary disk which shares the vmis lifecycle.",
				Properties: map[string]spec.Schema{
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Capacity of the sparse disk.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"capacity"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_kubevirtio_client_go_api_v1_EphemeralVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"persistentVolumeClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. Directly attached to the vmi via qemu. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource"},
	}
}

func schema_kubevirtio_client_go_api_v1_FeatureAPIC(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled determines if the feature should be enabled or disabled on the guest. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"endOfInterrupt": {
						SchemaProps: spec.SchemaProps{
							Description: "EndOfInterrupt enables the end of interrupt notification in the guest. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_FeatureHyperv(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Hyperv specific features.",
				Properties: map[string]spec.Schema{
					"relaxed": {
						SchemaProps: spec.SchemaProps{
							Description: "Relaxed instructs the guest OS to disable watchdog timeouts. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"vapic": {
						SchemaProps: spec.SchemaProps{
							Description: "VAPIC improves the paravirtualized handling of interrupts. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"spinlocks": {
						SchemaProps: spec.SchemaProps{
							Description: "Spinlocks allows to configure the spinlock retry attempts.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureSpinlocks"),
						},
					},
					"vpindex": {
						SchemaProps: spec.SchemaProps{
							Description: "VPIndex enables the Virtual Processor Index to help windows identifying virtual processors. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"runtime": {
						SchemaProps: spec.SchemaProps{
							Description: "Runtime improves the time accounting to improve scheduling in the guest. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"synic": {
						SchemaProps: spec.SchemaProps{
							Description: "SyNIC enables the Synthetic Interrupt Controller. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"synictimer": {
						SchemaProps: spec.SchemaProps{
							Description: "SyNICTimer enables Synthetic Interrupt Controller Timers, reducing CPU load. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"reset": {
						SchemaProps: spec.SchemaProps{
							Description: "Reset enables Hyperv reboot/reset for the vmi. Requires synic. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"vendorid": {
						SchemaProps: spec.SchemaProps{
							Description: "VendorID allows setting the hypervisor vendor id. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureVendorID"),
						},
					},
					"frequencies": {
						SchemaProps: spec.SchemaProps{
							Description: "Frequencies improves the TSC clock source handling for Hyper-V on KVM. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"reenlightenment": {
						SchemaProps: spec.SchemaProps{
							Description: "Reenlightenment enables the notifications on TSC frequency changes. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"tlbflush": {
						SchemaProps: spec.SchemaProps{
							Description: "TLBFlush improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"ipi": {
						SchemaProps: spec.SchemaProps{
							Description: "IPI improves performances in overcommited environments. Requires vpindex. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"evmcs": {
						SchemaProps: spec.SchemaProps{
							Description: "EVMCS Speeds up L2 vmexits, but disables other virtualization features. Requires vapic. Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureSpinlocks", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureVendorID"},
	}
}

func schema_kubevirtio_client_go_api_v1_FeatureSpinlocks(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled determines if the feature should be enabled or disabled on the guest. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"spinlocks": {
						SchemaProps: spec.SchemaProps{
							Description: "Retries indicates the number of retries. Must be a value greater or equal 4096. Defaults to 4096.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_FeatureState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents if a feature is enabled or disabled.",
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled determines if the feature should be enabled or disabled on the guest. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_FeatureVendorID(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled determines if the feature should be enabled or disabled on the guest. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"vendorid": {
						SchemaProps: spec.SchemaProps{
							Description: "VendorID sets the hypervisor vendor id, visible to the vmi. String up to twelve characters.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Features(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"acpi": {
						SchemaProps: spec.SchemaProps{
							Description: "ACPI enables/disables ACPI insidejsondata guest. Defaults to enabled.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
					"apic": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureAPIC"),
						},
					},
					"hyperv": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to the machine type setting.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureHyperv"),
						},
					},
					"smm": {
						SchemaProps: spec.SchemaProps{
							Description: "SMM enables/disables System Management Mode. TSEG not yet implemented.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureAPIC", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureHyperv", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.FeatureState"},
	}
}

func schema_kubevirtio_client_go_api_v1_Firmware(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"uuid": {
						SchemaProps: spec.SchemaProps{
							Description: "UUID reported by the vmi bios. Defaults to a random generated uid.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bootloader": {
						SchemaProps: spec.SchemaProps{
							Description: "Settings to control the bootloader that is used.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Bootloader"),
						},
					},
					"serial": {
						SchemaProps: spec.SchemaProps{
							Description: "The system-serial-number in SMBIOS",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Bootloader"},
	}
}

func schema_kubevirtio_client_go_api_v1_FloppyTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"readonly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tray": {
						SchemaProps: spec.SchemaProps{
							Description: "Tray indicates if the tray of the device is open or closed. Allowed values are \"open\" and \"closed\". Defaults to closed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_GenieNetwork(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the genie cni network.",
				Properties: map[string]spec.Schema{
					"networkName": {
						SchemaProps: spec.SchemaProps{
							Description: "References the CNI plugin name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"networkName"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_HPETTimer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"tickPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest. One of \"delay\", \"catchup\", \"merge\", \"discard\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"present": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled set to false makes sure that the machine type or a preset can't add the timer. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_HostDisk(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a disk created on the cluster level",
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to HostDisk image located on the cluster",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Contains information if disk.img exists or should be created allowed options are 'Disk' and 'DiskOrCreate'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Capacity of the sparse disk",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"shared": {
						SchemaProps: spec.SchemaProps{
							Description: "Shared indicate whether the path is shared between nodes",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"path", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_kubevirtio_client_go_api_v1_Hugepages(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Hugepages allow to use hugepages for the VirtualMachineInstance instead of regular memory.",
				Properties: map[string]spec.Schema{
					"pageSize": {
						SchemaProps: spec.SchemaProps{
							Description: "PageSize specifies the hugepage size, for x86_64 architecture valid values are 1Gi and 2Mi.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_HypervTimer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"present": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled set to false makes sure that the machine type or a preset can't add the timer. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_I6300ESBWatchdog(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "i6300esb watchdog device.",
				Properties: map[string]spec.Schema{
					"action": {
						SchemaProps: spec.SchemaProps{
							Description: "The action to take. Valid values are poweroff, reset, shutdown. Defaults to reset.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Input(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"bus": {
						SchemaProps: spec.SchemaProps{
							Description: "Bus indicates the bus of input device to emulate. Supported values: virtio, usb.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicated the type of input device. Supported values: tablet.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the device name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "name"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Interface(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Logical name of the interface as well as a reference to the associated networks. Must match the Name of a Network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"model": {
						SchemaProps: spec.SchemaProps{
							Description: "Interface model. One of: e1000, e1000e, ne2k_pci, pcnet, rtl8139, virtio. Defaults to virtio.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bridge": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBridge"),
						},
					},
					"slirp": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSlirp"),
						},
					},
					"masquerade": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceMasquerade"),
						},
					},
					"sriov": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSRIOV"),
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ports to be forwarded to the virtual machine.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Port"),
									},
								},
							},
						},
					},
					"macAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "Interface MAC address. For example: de:ad:00:00:be:af or DE-AD-00-00-BE-AF.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bootOrder": {
						SchemaProps: spec.SchemaProps{
							Description: "BootOrder is an integer value > 0, used to determine ordering of boot devices. Lower values take precedence. Each interface or disk that has a boot order must have a unique value. Interfaces without a boot order are not tried.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"pciAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the virtual network interface will be placed on the guests pci address with the specifed PCI address. For example: 0000:81:01.10",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dhcpOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified the network interface will pass additional DHCP options to the VMI",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DHCPOptions"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DHCPOptions", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBridge", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceMasquerade", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSRIOV", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSlirp", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Port"},
	}
}

func schema_kubevirtio_client_go_api_v1_InterfaceBindingMethod(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the method which will be used to connect the interface to the guest. Only one of its members may be specified.",
				Properties: map[string]spec.Schema{
					"bridge": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBridge"),
						},
					},
					"slirp": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSlirp"),
						},
					},
					"masquerade": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceMasquerade"),
						},
					},
					"sriov": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSRIOV"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceBridge", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceMasquerade", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSRIOV", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.InterfaceSlirp"},
	}
}

func schema_kubevirtio_client_go_api_v1_InterfaceBridge(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_InterfaceMasquerade(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_InterfaceSRIOV(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_InterfaceSlirp(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_KVMTimer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"present": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled set to false makes sure that the machine type or a preset can't add the timer. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_KubeVirt(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeVirt represents the object deploying all KubeVirt resources",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtStatus"},
	}
}

func schema_kubevirtio_client_go_api_v1_KubeVirtCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeVirtCondition represents a condition of a KubeVirt deployment",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_kubevirtio_client_go_api_v1_KubeVirtList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeVirtList is a list of KubeVirts",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirt"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirt"},
	}
}

func schema_kubevirtio_client_go_api_v1_KubeVirtSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"imageTag": {
						SchemaProps: spec.SchemaProps{
							Description: "The image tag to use for the continer images installed. Defaults to the same tag as the operator's container image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageRegistry": {
						SchemaProps: spec.SchemaProps{
							Description: "The image registry to pull the container images from Defaults to the same registry the operator's container image is pulled from.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "The ImagePullPolicy to use.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_KubeVirtStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeVirtStatus represents information pertaining to a KubeVirt deployment.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtCondition"),
									},
								},
							},
						},
					},
					"operatorVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"targetKubeVirtRegistry": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"targetKubeVirtVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"targetDeploymentConfig": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"targetDeploymentID": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"observedKubeVirtRegistry": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"observedKubeVirtVersion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"observedDeploymentConfig": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"observedDeploymentID": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KubeVirtCondition"},
	}
}

func schema_kubevirtio_client_go_api_v1_LunTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"bus": {
						SchemaProps: spec.SchemaProps{
							Description: "Bus indicates the type of disk device to emulate. supported values: virtio, sata, scsi.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readonly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Machine(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "QEMU machine type is the actual chipset of the VirtualMachineInstance.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Memory(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Memory allows specifying the VirtualMachineInstance memory features.",
				Properties: map[string]spec.Schema{
					"hugepages": {
						SchemaProps: spec.SchemaProps{
							Description: "Hugepages allow to use hugepages for the VirtualMachineInstance instead of regular memory.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Hugepages"),
						},
					},
					"guest": {
						SchemaProps: spec.SchemaProps{
							Description: "Guest allows to specifying the amount of memory which is visible inside the Guest OS. The Guest must lie between Requests and Limits from the resources section. Defaults to the requested memory in the resources section if not specified.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Hugepages"},
	}
}

func schema_kubevirtio_client_go_api_v1_MultusNetwork(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the multus cni network.",
				Properties: map[string]spec.Schema{
					"networkName": {
						SchemaProps: spec.SchemaProps{
							Description: "References to a NetworkAttachmentDefinition CRD object. Format: <networkName>, <namespace>/<networkName>. If namespace is not specified, VMI namespace is assumed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Select the default network and add it to the multus-cni.io/default-network annotation.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"networkName"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Network(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Network represents a network type and a resource that should be connected to the vm.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Network name. Must be a DNS_LABEL and unique within the vm. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pod": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PodNetwork"),
						},
					},
					"multus": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.MultusNetwork"),
						},
					},
					"genie": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.GenieNetwork"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.GenieNetwork", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.MultusNetwork", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PodNetwork"},
	}
}

func schema_kubevirtio_client_go_api_v1_NetworkSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the source resource that will be connected to the vm. Only one of its members may be specified.",
				Properties: map[string]spec.Schema{
					"pod": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PodNetwork"),
						},
					},
					"multus": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.MultusNetwork"),
						},
					},
					"genie": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.GenieNetwork"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.GenieNetwork", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.MultusNetwork", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PodNetwork"},
	}
}

func schema_kubevirtio_client_go_api_v1_PITTimer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"tickPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest. One of \"delay\", \"catchup\", \"discard\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"present": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled set to false makes sure that the machine type or a preset can't add the timer. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_PodNetwork(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the stock pod network interface.",
				Properties: map[string]spec.Schema{
					"vmNetworkCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "CIDR for vm network. Default 10.0.2.0/24 if not specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Port(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Port repesents a port to expose from the virtual machine. Default protocol TCP. The port field is mandatory",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Protocol for port. Must be UDP or TCP. Defaults to \"TCP\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of port to expose for the virtual machine. This must be a valid port number, 0 < x < 65536.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_RTCTimer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"tickPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "TickPolicy determines what happens when QEMU misses a deadline for injecting a tick to the guest. One of \"delay\", \"catchup\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"present": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled set to false makes sure that the machine type or a preset can't add the timer. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"track": {
						SchemaProps: spec.SchemaProps{
							Description: "Track the guest or the wall clock.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_ResourceRequirements(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"requests": {
						SchemaProps: spec.SchemaProps{
							Description: "Requests is a description of the initial vmi resources. Valid resource keys are \"memory\" and \"cpu\".",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"limits": {
						SchemaProps: spec.SchemaProps{
							Description: "Limits describes the maximum amount of compute resources allowed. Valid resource keys are \"memory\" and \"cpu\".",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"overcommitGuestOverhead": {
						SchemaProps: spec.SchemaProps{
							Description: "Don't ask the scheduler to take the guest-management overhead into account. Instead put the overhead only into the container's memory limit. This can lead to crashes if all memory is in use on a node. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_kubevirtio_client_go_api_v1_Rng(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Rng represents the random device passed from host",
				Properties:  map[string]spec.Schema{},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_SecretVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretVolumeSource adapts a Secret into a volume.",
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the Secret or it's keys must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_ServiceAccountVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccountVolumeSource adapts a ServiceAccount into a volume.",
				Properties: map[string]spec.Schema{
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the service account in the pod's namespace to use. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_Timer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents all available timers in a vmi.",
				Properties: map[string]spec.Schema{
					"hpet": {
						SchemaProps: spec.SchemaProps{
							Description: "HPET (High Precision Event Timer) - multiple timers with periodic interrupts.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HPETTimer"),
						},
					},
					"kvm": {
						SchemaProps: spec.SchemaProps{
							Description: "KVM \t(KVM clock) - lets guests read the host’s wall clock time (paravirtualized). For linux guests.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KVMTimer"),
						},
					},
					"pit": {
						SchemaProps: spec.SchemaProps{
							Description: "PIT (Programmable Interval Timer) - a timer with periodic interrupts.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PITTimer"),
						},
					},
					"rtc": {
						SchemaProps: spec.SchemaProps{
							Description: "RTC (Real Time Clock) - a continuously running timer with periodic interrupts.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.RTCTimer"),
						},
					},
					"hyperv": {
						SchemaProps: spec.SchemaProps{
							Description: "Hyperv (Hypervclock) - lets guests read the host’s wall clock time (paravirtualized). For windows guests.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HypervTimer"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HPETTimer", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HypervTimer", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.KVMTimer", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.PITTimer", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.RTCTimer"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachine(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachine handles the VirtualMachines that are not running or are in a stopped state The VirtualMachine contains the template to create the VirtualMachineInstance. It also mirrors the running state of the created VirtualMachineInstance in its status.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of VirtualMachineInstance created",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status holds the current state of the controller and brief information about its associated VirtualMachineInstance",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineStatus"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineCondition represents the state of VirtualMachine",
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstance(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstance is *the* VirtualMachineInstance Definition. It represents a virtual machine in the runtime environment of kubernetes.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the high level overview of how the VirtualMachineInstance is doing. It contains information available to controllers and users.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceStatus"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceList is a list of VirtualMachines",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstance"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstance"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceMigration represents the object tracking a VMI's migration to another host in the cluster",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationStatus"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceMigrationList is a list of VirtualMachineMigrations",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigration"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"vmiName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the VMI to perform the migration on. VMI must exist in the migration objects namespace",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceMigrationStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceMigration reprents information pertaining to a VMI's migration.",
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationCondition"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceNetworkInterface(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"ipAddress": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address of a Virtual Machine interface",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"mac": {
						SchemaProps: spec.SchemaProps{
							Description: "Hardware address of a Virtual Machine interface",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the interface, corresponds to name of the network assigned to the interface",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ipAddresses": {
						SchemaProps: spec.SchemaProps{
							Description: "List of all IP addresses of a Virtual Machine interface",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"interfaceName": {
						SchemaProps: spec.SchemaProps{
							Description: "The interface name inside the Virtual Machine",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePreset(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePresetSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePresetSpec"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePresetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstancePresetList is a list of VirtualMachinePresets",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePreset"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstancePreset"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstancePresetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over a set of VMIs. Required.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"domain": {
						SchemaProps: spec.SchemaProps{
							Description: "Domain is the same object type as contained in VirtualMachineInstanceSpec",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DomainSpec"),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DomainSpec"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstance is *the* VirtualMachineInstance Definition. It represents a virtual machine in the runtime environment of kubernetes.",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the high level overview of how the VirtualMachineInstance is doing. It contains information available to controllers and users.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetStatus"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMIList is a list of VMIs",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSet"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceTemplateSpec"),
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the replica set is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceTemplateSpec"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceReplicaSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetCondition"),
									},
								},
							},
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Canonical form of the label selector for HPA which consumes it through the scale subresource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceReplicaSetCondition"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceSpec is a description of a VirtualMachineInstance.",
				Properties: map[string]spec.Schema{
					"domain": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the VirtualMachineInstance on the host.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DomainSpec"),
						},
					},
					"nodeSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeSelector is a selector which must be true for the vmi to fit on a node. Selector which must match a node's labels for the vmi to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"affinity": {
						SchemaProps: spec.SchemaProps{
							Description: "If affinity is specifies, obey all the affinity rules",
							Ref:         ref("k8s.io/api/core/v1.Affinity"),
						},
					},
					"tolerations": {
						SchemaProps: spec.SchemaProps{
							Description: "If toleration is specified, obey all the toleration rules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Toleration"),
									},
								},
							},
						},
					},
					"evictionStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionStrategy can be set to \"LiveMigrate\" if the VirtualMachineInstance should be migrated instead of shut-off in case of a node drain.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationGracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Grace period observed after signalling a VirtualMachineInstance to stop after which the VirtualMachineInstance is force terminated.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Description: "List of volumes that can be mounted by disks belonging to the vmi.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Volume"),
									},
								},
							},
						},
					},
					"livenessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of VirtualMachineInstance liveness. VirtualmachineInstances will be stopped if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Probe"),
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of VirtualMachineInstance service readiness. VirtualmachineInstances will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Probe"),
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the hostname of the vmi If not specified, the hostname will be set to the name of the vmi, if dhcp or cloud-init is configured properly.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subdomain": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the fully qualified vmi hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the vmi will not have a domainname at all. The DNS entry will resolve to the vmi, no matter if the vmi itself can pick up a hostname.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"networks": {
						SchemaProps: spec.SchemaProps{
							Description: "List of networks that can be attached to a vm's virtual interface.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Network"),
									},
								},
							},
						},
					},
					"dnsPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Set DNS policy for the pod. Defaults to \"ClusterFirst\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dnsConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.",
							Ref:         ref("k8s.io/api/core/v1.PodDNSConfig"),
						},
					},
				},
				Required: []string{"domain"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Affinity", "k8s.io/api/core/v1.PodDNSConfig", "k8s.io/api/core/v1.Toleration", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DomainSpec", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Network", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Probe", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.Volume"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineInstanceStatus represents information about the status of a VirtualMachineInstance. Status may trail the actual state of a system.",
				Properties: map[string]spec.Schema{
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeName is the name where the VirtualMachineInstance is currently running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A brief CamelCase message indicating details about why the VMI is in this state. e.g. 'NodeUnresponsive'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Conditions are specific points in VirtualMachineInstance's pod runtime.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceCondition"),
									},
								},
							},
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is the status of the VirtualMachineInstance in kubernetes world. It is not the VirtualMachineInstance status, but partially correlates to it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"interfaces": {
						SchemaProps: spec.SchemaProps{
							Description: "Interfaces represent the details of available network interfaces.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceNetworkInterface"),
									},
								},
							},
						},
					},
					"migrationState": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the status of a live migration",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationState"),
						},
					},
					"migrationMethod": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the method using which the vmi can be migrated: live migration or block migration",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"qosClass": {
						SchemaProps: spec.SchemaProps{
							Description: "The Quality of Service (QOS) classification assigned to the virtual machine instance based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceCondition", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceMigrationState", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceNetworkInterface"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineInstanceTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "VirtualMachineInstance Spec contains the VirtualMachineInstance specification.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceSpec"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineList is a list of virtualmachines",
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of VirtualMachines",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachine"),
									},
								},
							},
						},
					},
				},
				Required: []string{"metadata", "items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachine"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineSpec describes how the proper VirtualMachine should look like",
				Properties: map[string]spec.Schema{
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Running controls whether the associatied VirtualMachineInstance is created or not Mutually exclusive with RunStrategy",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"runStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "Running state indicates the requested running state of the VirtualMachineInstance mutually exclusive with Running",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the direct specification of VirtualMachineInstance",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceTemplateSpec"),
						},
					},
					"dataVolumeTemplates": {
						SchemaProps: spec.SchemaProps{
							Description: "dataVolumeTemplates is a list of dataVolumes that the VirtualMachineInstance template can reference. DataVolumes in this list are dynamically created for the VirtualMachine and are tied to the VirtualMachine's life-cycle.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/containerized-data-importer/pkg/apis/core/v1alpha1.DataVolume"),
									},
								},
							},
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/containerized-data-importer/pkg/apis/core/v1alpha1.DataVolume", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineInstanceTemplateSpec"},
	}
}

func schema_kubevirtio_client_go_api_v1_VirtualMachineStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VirtualMachineStatus represents the status returned by the controller to describe how the VirtualMachine is doing",
				Properties: map[string]spec.Schema{
					"created": {
						SchemaProps: spec.SchemaProps{
							Description: "Created indicates if the virtual machine is created in the cluster",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Ready indicates if the virtual machine is running and ready",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"conditions": {
						SchemaProps: spec.SchemaProps{
							Description: "Hold the state information of the VirtualMachine and its VirtualMachineInstance",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineCondition"),
									},
								},
							},
						},
					},
					"stateChangeRequests": {
						SchemaProps: spec.SchemaProps{
							Description: "StateChangeRequests indicates a list of actions that should be taken on a VMI e.g. stop a specific VMI then start a new one.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineStateChangeRequest"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineCondition", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.VirtualMachineStateChangeRequest"},
	}
}

func schema_kubevirtio_client_go_api_v1_Volume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Volume represents a named volume in a vmi.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume's name. Must be a DNS_LABEL and unique within the vmi. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "HostDisk represents a disk created on the cluster level",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HostDisk"),
						},
					},
					"persistentVolumeClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. Directly attached to the vmi via qemu. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource"),
						},
					},
					"cloudInitNoCloud": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudInitNoCloud represents a cloud-init NoCloud user-data source. The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitNoCloudSource"),
						},
					},
					"cloudInitConfigDrive": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudInitConfigDrive represents a cloud-init Config Drive user-data source. The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitConfigDriveSource"),
						},
					},
					"containerDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerDisk references a docker image, embedding a qcow or raw disk. More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ContainerDiskSource"),
						},
					},
					"ephemeral": {
						SchemaProps: spec.SchemaProps{
							Description: "Ephemeral is a special volume source that \"wraps\" specified source and provides copy-on-write image on top of it.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EphemeralVolumeSource"),
						},
					},
					"emptyDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "EmptyDisk represents a temporary disk which shares the vmis lifecycle. More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EmptyDiskSource"),
						},
					},
					"dataVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "DataVolume represents the dynamic creation a PVC for this volume as well as the process of populating that PVC with a disk image.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DataVolumeSource"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMapSource represents a reference to a ConfigMap in the same namespace. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ConfigMapVolumeSource"),
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretVolumeSource represents a reference to a secret data in the same namespace. More info: https://kubernetes.io/docs/concepts/configuration/secret/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.SecretVolumeSource"),
						},
					},
					"serviceAccount": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountVolumeSource represents a reference to a service account. There can only be one volume of this type! More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ServiceAccountVolumeSource"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitConfigDriveSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitNoCloudSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ConfigMapVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ContainerDiskSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DataVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EmptyDiskSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EphemeralVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HostDisk", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.SecretVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ServiceAccountVolumeSource"},
	}
}

func schema_kubevirtio_client_go_api_v1_VolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents the source of a volume to mount. Only one of its members may be specified.",
				Properties: map[string]spec.Schema{
					"hostDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "HostDisk represents a disk created on the cluster level",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HostDisk"),
						},
					},
					"persistentVolumeClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. Directly attached to the vmi via qemu. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource"),
						},
					},
					"cloudInitNoCloud": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudInitNoCloud represents a cloud-init NoCloud user-data source. The NoCloud data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitNoCloudSource"),
						},
					},
					"cloudInitConfigDrive": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudInitConfigDrive represents a cloud-init Config Drive user-data source. The Config Drive data will be added as a disk to the vmi. A proper cloud-init installation is required inside the guest. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitConfigDriveSource"),
						},
					},
					"containerDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerDisk references a docker image, embedding a qcow or raw disk. More info: https://kubevirt.gitbooks.io/user-guide/registry-disk.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ContainerDiskSource"),
						},
					},
					"ephemeral": {
						SchemaProps: spec.SchemaProps{
							Description: "Ephemeral is a special volume source that \"wraps\" specified source and provides copy-on-write image on top of it.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EphemeralVolumeSource"),
						},
					},
					"emptyDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "EmptyDisk represents a temporary disk which shares the vmis lifecycle. More info: https://kubevirt.gitbooks.io/user-guide/disks-and-volumes.html",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EmptyDiskSource"),
						},
					},
					"dataVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "DataVolume represents the dynamic creation a PVC for this volume as well as the process of populating that PVC with a disk image.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DataVolumeSource"),
						},
					},
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMapSource represents a reference to a ConfigMap in the same namespace. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-pod-configmap/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ConfigMapVolumeSource"),
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretVolumeSource represents a reference to a secret data in the same namespace. More info: https://kubernetes.io/docs/concepts/configuration/secret/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.SecretVolumeSource"),
						},
					},
					"serviceAccount": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountVolumeSource represents a reference to a service account. There can only be one volume of this type! More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ServiceAccountVolumeSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitConfigDriveSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.CloudInitNoCloudSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ConfigMapVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ContainerDiskSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.DataVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EmptyDiskSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.EphemeralVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.HostDisk", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.SecretVolumeSource", "kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.ServiceAccountVolumeSource"},
	}
}

func schema_kubevirtio_client_go_api_v1_Watchdog(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Named watchdog device.",
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the watchdog.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"i6300esb": {
						SchemaProps: spec.SchemaProps{
							Description: "i6300esb watchdog device.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.I6300ESBWatchdog"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.I6300ESBWatchdog"},
	}
}

func schema_kubevirtio_client_go_api_v1_WatchdogDevice(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Hardware watchdog device. Exactly one of its members must be set.",
				Properties: map[string]spec.Schema{
					"i6300esb": {
						SchemaProps: spec.SchemaProps{
							Description: "i6300esb watchdog device.",
							Ref:         ref("kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.I6300ESBWatchdog"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"kubevirt.io/kubevirt/staging/src/kubevirt.io/client-go/api/v1.I6300ESBWatchdog"},
	}
}
