/*
Copyright 2020 The hostpath provisioner operator Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/hostpath-provisioner-operator/pkg/apis/hostpathprovisioner/v1beta1"
)

// FakeHostPathProvisioners implements HostPathProvisionerInterface
type FakeHostPathProvisioners struct {
	Fake *FakeHostpathprovisionerV1beta1
}

var hostpathprovisionersResource = schema.GroupVersionResource{Group: "hostpathprovisioner.kubevirt.io", Version: "v1beta1", Resource: "hostpathprovisioners"}

var hostpathprovisionersKind = schema.GroupVersionKind{Group: "hostpathprovisioner.kubevirt.io", Version: "v1beta1", Kind: "HostPathProvisioner"}

// Get takes name of the hostPathProvisioner, and returns the corresponding hostPathProvisioner object, and an error if there is any.
func (c *FakeHostPathProvisioners) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.HostPathProvisioner, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(hostpathprovisionersResource, name), &v1beta1.HostPathProvisioner{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.HostPathProvisioner), err
}

// List takes label and field selectors, and returns the list of HostPathProvisioners that match those selectors.
func (c *FakeHostPathProvisioners) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.HostPathProvisionerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(hostpathprovisionersResource, hostpathprovisionersKind, opts), &v1beta1.HostPathProvisionerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.HostPathProvisionerList{ListMeta: obj.(*v1beta1.HostPathProvisionerList).ListMeta}
	for _, item := range obj.(*v1beta1.HostPathProvisionerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested hostPathProvisioners.
func (c *FakeHostPathProvisioners) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(hostpathprovisionersResource, opts))
}

// Create takes the representation of a hostPathProvisioner and creates it.  Returns the server's representation of the hostPathProvisioner, and an error, if there is any.
func (c *FakeHostPathProvisioners) Create(ctx context.Context, hostPathProvisioner *v1beta1.HostPathProvisioner, opts v1.CreateOptions) (result *v1beta1.HostPathProvisioner, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(hostpathprovisionersResource, hostPathProvisioner), &v1beta1.HostPathProvisioner{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.HostPathProvisioner), err
}

// Update takes the representation of a hostPathProvisioner and updates it. Returns the server's representation of the hostPathProvisioner, and an error, if there is any.
func (c *FakeHostPathProvisioners) Update(ctx context.Context, hostPathProvisioner *v1beta1.HostPathProvisioner, opts v1.UpdateOptions) (result *v1beta1.HostPathProvisioner, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(hostpathprovisionersResource, hostPathProvisioner), &v1beta1.HostPathProvisioner{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.HostPathProvisioner), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeHostPathProvisioners) UpdateStatus(ctx context.Context, hostPathProvisioner *v1beta1.HostPathProvisioner, opts v1.UpdateOptions) (*v1beta1.HostPathProvisioner, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(hostpathprovisionersResource, "status", hostPathProvisioner), &v1beta1.HostPathProvisioner{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.HostPathProvisioner), err
}

// Delete takes name of the hostPathProvisioner and deletes it. Returns an error if one occurs.
func (c *FakeHostPathProvisioners) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(hostpathprovisionersResource, name), &v1beta1.HostPathProvisioner{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeHostPathProvisioners) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(hostpathprovisionersResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.HostPathProvisionerList{})
	return err
}

// Patch applies the patch and returns the patched hostPathProvisioner.
func (c *FakeHostPathProvisioners) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.HostPathProvisioner, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(hostpathprovisionersResource, name, pt, data, subresources...), &v1beta1.HostPathProvisioner{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.HostPathProvisioner), err
}
