// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/openshift/cert-manager-operator/apis/config/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCertManagers implements CertManagerInterface
type FakeCertManagers struct {
	Fake *FakeConfigV1alpha1
}

var certmanagersResource = schema.GroupVersionResource{Group: "config.openshift.io", Version: "v1alpha1", Resource: "certmanagers"}

var certmanagersKind = schema.GroupVersionKind{Group: "config.openshift.io", Version: "v1alpha1", Kind: "CertManager"}

// Get takes name of the certManager, and returns the corresponding certManager object, and an error if there is any.
func (c *FakeCertManagers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.CertManager, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(certmanagersResource, name), &v1alpha1.CertManager{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CertManager), err
}

// List takes label and field selectors, and returns the list of CertManagers that match those selectors.
func (c *FakeCertManagers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.CertManagerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(certmanagersResource, certmanagersKind, opts), &v1alpha1.CertManagerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.CertManagerList{ListMeta: obj.(*v1alpha1.CertManagerList).ListMeta}
	for _, item := range obj.(*v1alpha1.CertManagerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested certManagers.
func (c *FakeCertManagers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(certmanagersResource, opts))
}

// Create takes the representation of a certManager and creates it.  Returns the server's representation of the certManager, and an error, if there is any.
func (c *FakeCertManagers) Create(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.CreateOptions) (result *v1alpha1.CertManager, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(certmanagersResource, certManager), &v1alpha1.CertManager{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CertManager), err
}

// Update takes the representation of a certManager and updates it. Returns the server's representation of the certManager, and an error, if there is any.
func (c *FakeCertManagers) Update(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (result *v1alpha1.CertManager, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(certmanagersResource, certManager), &v1alpha1.CertManager{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CertManager), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCertManagers) UpdateStatus(ctx context.Context, certManager *v1alpha1.CertManager, opts v1.UpdateOptions) (*v1alpha1.CertManager, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(certmanagersResource, "status", certManager), &v1alpha1.CertManager{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CertManager), err
}

// Delete takes name of the certManager and deletes it. Returns an error if one occurs.
func (c *FakeCertManagers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(certmanagersResource, name, opts), &v1alpha1.CertManager{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCertManagers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(certmanagersResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.CertManagerList{})
	return err
}

// Patch applies the patch and returns the patched certManager.
func (c *FakeCertManagers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.CertManager, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(certmanagersResource, name, pt, data, subresources...), &v1alpha1.CertManager{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CertManager), err
}
