/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing/pkg/apis/messaging/v1alpha1"
)

// FakeChannels implements ChannelInterface
type FakeChannels struct {
	Fake *FakeMessagingV1alpha1
	ns   string
}

var channelsResource = schema.GroupVersionResource{Group: "messaging.knative.dev", Version: "v1alpha1", Resource: "channels"}

var channelsKind = schema.GroupVersionKind{Group: "messaging.knative.dev", Version: "v1alpha1", Kind: "Channel"}

// Get takes name of the channel, and returns the corresponding channel object, and an error if there is any.
func (c *FakeChannels) Get(name string, options v1.GetOptions) (result *v1alpha1.Channel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(channelsResource, c.ns, name), &v1alpha1.Channel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Channel), err
}

// List takes label and field selectors, and returns the list of Channels that match those selectors.
func (c *FakeChannels) List(opts v1.ListOptions) (result *v1alpha1.ChannelList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(channelsResource, channelsKind, c.ns, opts), &v1alpha1.ChannelList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.ChannelList{ListMeta: obj.(*v1alpha1.ChannelList).ListMeta}
	for _, item := range obj.(*v1alpha1.ChannelList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested channels.
func (c *FakeChannels) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(channelsResource, c.ns, opts))

}

// Create takes the representation of a channel and creates it.  Returns the server's representation of the channel, and an error, if there is any.
func (c *FakeChannels) Create(channel *v1alpha1.Channel) (result *v1alpha1.Channel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(channelsResource, c.ns, channel), &v1alpha1.Channel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Channel), err
}

// Update takes the representation of a channel and updates it. Returns the server's representation of the channel, and an error, if there is any.
func (c *FakeChannels) Update(channel *v1alpha1.Channel) (result *v1alpha1.Channel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(channelsResource, c.ns, channel), &v1alpha1.Channel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Channel), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeChannels) UpdateStatus(channel *v1alpha1.Channel) (*v1alpha1.Channel, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(channelsResource, "status", c.ns, channel), &v1alpha1.Channel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Channel), err
}

// Delete takes name of the channel and deletes it. Returns an error if one occurs.
func (c *FakeChannels) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(channelsResource, c.ns, name), &v1alpha1.Channel{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeChannels) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(channelsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.ChannelList{})
	return err
}

// Patch applies the patch and returns the patched channel.
func (c *FakeChannels) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Channel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(channelsResource, c.ns, name, pt, data, subresources...), &v1alpha1.Channel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Channel), err
}
