/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1

import (
	"testing"

	"knative.dev/pkg/apis/duck"
	duckv1 "knative.dev/pkg/apis/duck/v1"
)

func TestTypesImplements(t *testing.T) {
	testCases := []struct {
		instance interface{}
		iface    duck.Implementable
	}{
		// ApiServerSource
		{instance: &ApiServerSource{}, iface: &duckv1.Conditions{}},
		{instance: &ApiServerSource{}, iface: &duckv1.Source{}},
		// PingSourceSource
		{instance: &PingSource{}, iface: &duckv1.Conditions{}},
		{instance: &PingSource{}, iface: &duckv1.Source{}},
		// SinkBinding
		{instance: &SinkBinding{}, iface: &duckv1.Conditions{}},
		{instance: &SinkBinding{}, iface: &duckv1.Source{}},
		{instance: &SinkBinding{}, iface: &duckv1.Binding{}},
		// ContainerSource
		{instance: &ContainerSource{}, iface: &duckv1.Conditions{}},
		{instance: &ContainerSource{}, iface: &duckv1.Source{}},
	}
	for _, tc := range testCases {
		if err := duck.VerifyType(tc.instance, tc.iface); err != nil {
			t.Error(err)
		}
	}
}
