// Copyright © 2020 The Knative Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// go:generate go run github.com/maxbrunsfeld/counterfeiter/v6 -generate

package types

import (
	"github.com/spf13/cobra"
	"knative.dev/client/pkg/kn/commands"
	"knative.dev/client/pkg/kn/commands/flags"
)

type KnSourceParams struct {
	commands.KnParams

	SinkFlag flags.SinkFlags
}

func (p *KnSourceParams) AddCommonFlags(cmd *cobra.Command) {
	commands.AddNamespaceFlags(cmd.Flags(), true)
}

func (p *KnSourceParams) AddCreateUpdateFlags(cmd *cobra.Command) {
	p.SinkFlag.Add(cmd)
}
