package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/web/mgmt/2016-09-01/web"

// AccessControlEntryAction enumerates the values for access control entry action.
type AccessControlEntryAction string

const (
	// Deny ...
	Deny AccessControlEntryAction = "Deny"
	// Permit ...
	Permit AccessControlEntryAction = "Permit"
)

// PossibleAccessControlEntryActionValues returns an array of possible values for the AccessControlEntryAction const type.
func PossibleAccessControlEntryActionValues() []AccessControlEntryAction {
	return []AccessControlEntryAction{Deny, Permit}
}

// AppServicePlanRestrictions enumerates the values for app service plan restrictions.
type AppServicePlanRestrictions string

const (
	// Basic ...
	Basic AppServicePlanRestrictions = "Basic"
	// Free ...
	Free AppServicePlanRestrictions = "Free"
	// None ...
	None AppServicePlanRestrictions = "None"
	// Premium ...
	Premium AppServicePlanRestrictions = "Premium"
	// Shared ...
	Shared AppServicePlanRestrictions = "Shared"
	// Standard ...
	Standard AppServicePlanRestrictions = "Standard"
)

// PossibleAppServicePlanRestrictionsValues returns an array of possible values for the AppServicePlanRestrictions const type.
func PossibleAppServicePlanRestrictionsValues() []AppServicePlanRestrictions {
	return []AppServicePlanRestrictions{Basic, Free, None, Premium, Shared, Standard}
}

// AutoHealActionType enumerates the values for auto heal action type.
type AutoHealActionType string

const (
	// CustomAction ...
	CustomAction AutoHealActionType = "CustomAction"
	// LogEvent ...
	LogEvent AutoHealActionType = "LogEvent"
	// Recycle ...
	Recycle AutoHealActionType = "Recycle"
)

// PossibleAutoHealActionTypeValues returns an array of possible values for the AutoHealActionType const type.
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return []AutoHealActionType{CustomAction, LogEvent, Recycle}
}

// AzureResourceType enumerates the values for azure resource type.
type AzureResourceType string

const (
	// TrafficManager ...
	TrafficManager AzureResourceType = "TrafficManager"
	// Website ...
	Website AzureResourceType = "Website"
)

// PossibleAzureResourceTypeValues returns an array of possible values for the AzureResourceType const type.
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return []AzureResourceType{TrafficManager, Website}
}

// BackupItemStatus enumerates the values for backup item status.
type BackupItemStatus string

const (
	// Created ...
	Created BackupItemStatus = "Created"
	// Deleted ...
	Deleted BackupItemStatus = "Deleted"
	// DeleteFailed ...
	DeleteFailed BackupItemStatus = "DeleteFailed"
	// DeleteInProgress ...
	DeleteInProgress BackupItemStatus = "DeleteInProgress"
	// Failed ...
	Failed BackupItemStatus = "Failed"
	// InProgress ...
	InProgress BackupItemStatus = "InProgress"
	// PartiallySucceeded ...
	PartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	// Skipped ...
	Skipped BackupItemStatus = "Skipped"
	// Succeeded ...
	Succeeded BackupItemStatus = "Succeeded"
	// TimedOut ...
	TimedOut BackupItemStatus = "TimedOut"
)

// PossibleBackupItemStatusValues returns an array of possible values for the BackupItemStatus const type.
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return []BackupItemStatus{Created, Deleted, DeleteFailed, DeleteInProgress, Failed, InProgress, PartiallySucceeded, Skipped, Succeeded, TimedOut}
}

// BackupRestoreOperationType enumerates the values for backup restore operation type.
type BackupRestoreOperationType string

const (
	// BackupRestoreOperationTypeClone ...
	BackupRestoreOperationTypeClone BackupRestoreOperationType = "Clone"
	// BackupRestoreOperationTypeDefault ...
	BackupRestoreOperationTypeDefault BackupRestoreOperationType = "Default"
	// BackupRestoreOperationTypeRelocation ...
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = "Relocation"
	// BackupRestoreOperationTypeSnapshot ...
	BackupRestoreOperationTypeSnapshot BackupRestoreOperationType = "Snapshot"
)

// PossibleBackupRestoreOperationTypeValues returns an array of possible values for the BackupRestoreOperationType const type.
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return []BackupRestoreOperationType{BackupRestoreOperationTypeClone, BackupRestoreOperationTypeDefault, BackupRestoreOperationTypeRelocation, BackupRestoreOperationTypeSnapshot}
}

// BuiltInAuthenticationProvider enumerates the values for built in authentication provider.
type BuiltInAuthenticationProvider string

const (
	// AzureActiveDirectory ...
	AzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	// Facebook ...
	Facebook BuiltInAuthenticationProvider = "Facebook"
	// Google ...
	Google BuiltInAuthenticationProvider = "Google"
	// MicrosoftAccount ...
	MicrosoftAccount BuiltInAuthenticationProvider = "MicrosoftAccount"
	// Twitter ...
	Twitter BuiltInAuthenticationProvider = "Twitter"
)

// PossibleBuiltInAuthenticationProviderValues returns an array of possible values for the BuiltInAuthenticationProvider const type.
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return []BuiltInAuthenticationProvider{AzureActiveDirectory, Facebook, Google, MicrosoftAccount, Twitter}
}

// CertificateOrderActionType enumerates the values for certificate order action type.
type CertificateOrderActionType string

const (
	// CertificateExpirationWarning ...
	CertificateExpirationWarning CertificateOrderActionType = "CertificateExpirationWarning"
	// CertificateExpired ...
	CertificateExpired CertificateOrderActionType = "CertificateExpired"
	// CertificateIssued ...
	CertificateIssued CertificateOrderActionType = "CertificateIssued"
	// CertificateOrderCanceled ...
	CertificateOrderCanceled CertificateOrderActionType = "CertificateOrderCanceled"
	// CertificateOrderCreated ...
	CertificateOrderCreated CertificateOrderActionType = "CertificateOrderCreated"
	// CertificateRevoked ...
	CertificateRevoked CertificateOrderActionType = "CertificateRevoked"
	// DomainValidationComplete ...
	DomainValidationComplete CertificateOrderActionType = "DomainValidationComplete"
	// FraudCleared ...
	FraudCleared CertificateOrderActionType = "FraudCleared"
	// FraudDetected ...
	FraudDetected CertificateOrderActionType = "FraudDetected"
	// FraudDocumentationRequired ...
	FraudDocumentationRequired CertificateOrderActionType = "FraudDocumentationRequired"
	// OrgNameChange ...
	OrgNameChange CertificateOrderActionType = "OrgNameChange"
	// OrgValidationComplete ...
	OrgValidationComplete CertificateOrderActionType = "OrgValidationComplete"
	// SanDrop ...
	SanDrop CertificateOrderActionType = "SanDrop"
	// Unknown ...
	Unknown CertificateOrderActionType = "Unknown"
)

// PossibleCertificateOrderActionTypeValues returns an array of possible values for the CertificateOrderActionType const type.
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return []CertificateOrderActionType{CertificateExpirationWarning, CertificateExpired, CertificateIssued, CertificateOrderCanceled, CertificateOrderCreated, CertificateRevoked, DomainValidationComplete, FraudCleared, FraudDetected, FraudDocumentationRequired, OrgNameChange, OrgValidationComplete, SanDrop, Unknown}
}

// CertificateOrderStatus enumerates the values for certificate order status.
type CertificateOrderStatus string

const (
	// Canceled ...
	Canceled CertificateOrderStatus = "Canceled"
	// Denied ...
	Denied CertificateOrderStatus = "Denied"
	// Expired ...
	Expired CertificateOrderStatus = "Expired"
	// Issued ...
	Issued CertificateOrderStatus = "Issued"
	// NotSubmitted ...
	NotSubmitted CertificateOrderStatus = "NotSubmitted"
	// Pendingissuance ...
	Pendingissuance CertificateOrderStatus = "Pendingissuance"
	// PendingRekey ...
	PendingRekey CertificateOrderStatus = "PendingRekey"
	// Pendingrevocation ...
	Pendingrevocation CertificateOrderStatus = "Pendingrevocation"
	// Revoked ...
	Revoked CertificateOrderStatus = "Revoked"
	// Unused ...
	Unused CertificateOrderStatus = "Unused"
)

// PossibleCertificateOrderStatusValues returns an array of possible values for the CertificateOrderStatus const type.
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return []CertificateOrderStatus{Canceled, Denied, Expired, Issued, NotSubmitted, Pendingissuance, PendingRekey, Pendingrevocation, Revoked, Unused}
}

// CertificateProductType enumerates the values for certificate product type.
type CertificateProductType string

const (
	// StandardDomainValidatedSsl ...
	StandardDomainValidatedSsl CertificateProductType = "StandardDomainValidatedSsl"
	// StandardDomainValidatedWildCardSsl ...
	StandardDomainValidatedWildCardSsl CertificateProductType = "StandardDomainValidatedWildCardSsl"
)

// PossibleCertificateProductTypeValues returns an array of possible values for the CertificateProductType const type.
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return []CertificateProductType{StandardDomainValidatedSsl, StandardDomainValidatedWildCardSsl}
}

// Channels enumerates the values for channels.
type Channels string

const (
	// All ...
	All Channels = "All"
	// API ...
	API Channels = "Api"
	// Email ...
	Email Channels = "Email"
	// Notification ...
	Notification Channels = "Notification"
	// Webhook ...
	Webhook Channels = "Webhook"
)

// PossibleChannelsValues returns an array of possible values for the Channels const type.
func PossibleChannelsValues() []Channels {
	return []Channels{All, API, Email, Notification, Webhook}
}

// CheckNameResourceTypes enumerates the values for check name resource types.
type CheckNameResourceTypes string

const (
	// CheckNameResourceTypesHostingEnvironment ...
	CheckNameResourceTypesHostingEnvironment CheckNameResourceTypes = "HostingEnvironment"
	// CheckNameResourceTypesMicrosoftWebhostingEnvironments ...
	CheckNameResourceTypesMicrosoftWebhostingEnvironments CheckNameResourceTypes = "Microsoft.Web/hostingEnvironments"
	// CheckNameResourceTypesMicrosoftWebpublishingUsers ...
	CheckNameResourceTypesMicrosoftWebpublishingUsers CheckNameResourceTypes = "Microsoft.Web/publishingUsers"
	// CheckNameResourceTypesMicrosoftWebsites ...
	CheckNameResourceTypesMicrosoftWebsites CheckNameResourceTypes = "Microsoft.Web/sites"
	// CheckNameResourceTypesMicrosoftWebsitesslots ...
	CheckNameResourceTypesMicrosoftWebsitesslots CheckNameResourceTypes = "Microsoft.Web/sites/slots"
	// CheckNameResourceTypesPublishingUser ...
	CheckNameResourceTypesPublishingUser CheckNameResourceTypes = "PublishingUser"
	// CheckNameResourceTypesSite ...
	CheckNameResourceTypesSite CheckNameResourceTypes = "Site"
	// CheckNameResourceTypesSlot ...
	CheckNameResourceTypesSlot CheckNameResourceTypes = "Slot"
)

// PossibleCheckNameResourceTypesValues returns an array of possible values for the CheckNameResourceTypes const type.
func PossibleCheckNameResourceTypesValues() []CheckNameResourceTypes {
	return []CheckNameResourceTypes{CheckNameResourceTypesHostingEnvironment, CheckNameResourceTypesMicrosoftWebhostingEnvironments, CheckNameResourceTypesMicrosoftWebpublishingUsers, CheckNameResourceTypesMicrosoftWebsites, CheckNameResourceTypesMicrosoftWebsitesslots, CheckNameResourceTypesPublishingUser, CheckNameResourceTypesSite, CheckNameResourceTypesSlot}
}

// CloneAbilityResult enumerates the values for clone ability result.
type CloneAbilityResult string

const (
	// Cloneable ...
	Cloneable CloneAbilityResult = "Cloneable"
	// NotCloneable ...
	NotCloneable CloneAbilityResult = "NotCloneable"
	// PartiallyCloneable ...
	PartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
)

// PossibleCloneAbilityResultValues returns an array of possible values for the CloneAbilityResult const type.
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return []CloneAbilityResult{Cloneable, NotCloneable, PartiallyCloneable}
}

// ComputeModeOptions enumerates the values for compute mode options.
type ComputeModeOptions string

const (
	// ComputeModeOptionsDedicated ...
	ComputeModeOptionsDedicated ComputeModeOptions = "Dedicated"
	// ComputeModeOptionsDynamic ...
	ComputeModeOptionsDynamic ComputeModeOptions = "Dynamic"
	// ComputeModeOptionsShared ...
	ComputeModeOptionsShared ComputeModeOptions = "Shared"
)

// PossibleComputeModeOptionsValues returns an array of possible values for the ComputeModeOptions const type.
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return []ComputeModeOptions{ComputeModeOptionsDedicated, ComputeModeOptionsDynamic, ComputeModeOptionsShared}
}

// ConnectionStringType enumerates the values for connection string type.
type ConnectionStringType string

const (
	// APIHub ...
	APIHub ConnectionStringType = "ApiHub"
	// Custom ...
	Custom ConnectionStringType = "Custom"
	// DocDb ...
	DocDb ConnectionStringType = "DocDb"
	// EventHub ...
	EventHub ConnectionStringType = "EventHub"
	// MySQL ...
	MySQL ConnectionStringType = "MySql"
	// NotificationHub ...
	NotificationHub ConnectionStringType = "NotificationHub"
	// PostgreSQL ...
	PostgreSQL ConnectionStringType = "PostgreSQL"
	// RedisCache ...
	RedisCache ConnectionStringType = "RedisCache"
	// ServiceBus ...
	ServiceBus ConnectionStringType = "ServiceBus"
	// SQLAzure ...
	SQLAzure ConnectionStringType = "SQLAzure"
	// SQLServer ...
	SQLServer ConnectionStringType = "SQLServer"
)

// PossibleConnectionStringTypeValues returns an array of possible values for the ConnectionStringType const type.
func PossibleConnectionStringTypeValues() []ConnectionStringType {
	return []ConnectionStringType{APIHub, Custom, DocDb, EventHub, MySQL, NotificationHub, PostgreSQL, RedisCache, ServiceBus, SQLAzure, SQLServer}
}

// ContinuousWebJobStatus enumerates the values for continuous web job status.
type ContinuousWebJobStatus string

const (
	// Initializing ...
	Initializing ContinuousWebJobStatus = "Initializing"
	// PendingRestart ...
	PendingRestart ContinuousWebJobStatus = "PendingRestart"
	// Running ...
	Running ContinuousWebJobStatus = "Running"
	// Starting ...
	Starting ContinuousWebJobStatus = "Starting"
	// Stopped ...
	Stopped ContinuousWebJobStatus = "Stopped"
)

// PossibleContinuousWebJobStatusValues returns an array of possible values for the ContinuousWebJobStatus const type.
func PossibleContinuousWebJobStatusValues() []ContinuousWebJobStatus {
	return []ContinuousWebJobStatus{Initializing, PendingRestart, Running, Starting, Stopped}
}

// CustomHostNameDNSRecordType enumerates the values for custom host name dns record type.
type CustomHostNameDNSRecordType string

const (
	// A ...
	A CustomHostNameDNSRecordType = "A"
	// CName ...
	CName CustomHostNameDNSRecordType = "CName"
)

// PossibleCustomHostNameDNSRecordTypeValues returns an array of possible values for the CustomHostNameDNSRecordType const type.
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return []CustomHostNameDNSRecordType{A, CName}
}

// DatabaseType enumerates the values for database type.
type DatabaseType string

const (
	// DatabaseTypeLocalMySQL ...
	DatabaseTypeLocalMySQL DatabaseType = "LocalMySql"
	// DatabaseTypeMySQL ...
	DatabaseTypeMySQL DatabaseType = "MySql"
	// DatabaseTypePostgreSQL ...
	DatabaseTypePostgreSQL DatabaseType = "PostgreSql"
	// DatabaseTypeSQLAzure ...
	DatabaseTypeSQLAzure DatabaseType = "SqlAzure"
)

// PossibleDatabaseTypeValues returns an array of possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{DatabaseTypeLocalMySQL, DatabaseTypeMySQL, DatabaseTypePostgreSQL, DatabaseTypeSQLAzure}
}

// DNSType enumerates the values for dns type.
type DNSType string

const (
	// AzureDNS ...
	AzureDNS DNSType = "AzureDns"
	// DefaultDomainRegistrarDNS ...
	DefaultDomainRegistrarDNS DNSType = "DefaultDomainRegistrarDns"
)

// PossibleDNSTypeValues returns an array of possible values for the DNSType const type.
func PossibleDNSTypeValues() []DNSType {
	return []DNSType{AzureDNS, DefaultDomainRegistrarDNS}
}

// DNSVerificationTestResult enumerates the values for dns verification test result.
type DNSVerificationTestResult string

const (
	// DNSVerificationTestResultFailed ...
	DNSVerificationTestResultFailed DNSVerificationTestResult = "Failed"
	// DNSVerificationTestResultPassed ...
	DNSVerificationTestResultPassed DNSVerificationTestResult = "Passed"
	// DNSVerificationTestResultSkipped ...
	DNSVerificationTestResultSkipped DNSVerificationTestResult = "Skipped"
)

// PossibleDNSVerificationTestResultValues returns an array of possible values for the DNSVerificationTestResult const type.
func PossibleDNSVerificationTestResultValues() []DNSVerificationTestResult {
	return []DNSVerificationTestResult{DNSVerificationTestResultFailed, DNSVerificationTestResultPassed, DNSVerificationTestResultSkipped}
}

// DomainStatus enumerates the values for domain status.
type DomainStatus string

const (
	// DomainStatusActive ...
	DomainStatusActive DomainStatus = "Active"
	// DomainStatusAwaiting ...
	DomainStatusAwaiting DomainStatus = "Awaiting"
	// DomainStatusCancelled ...
	DomainStatusCancelled DomainStatus = "Cancelled"
	// DomainStatusConfiscated ...
	DomainStatusConfiscated DomainStatus = "Confiscated"
	// DomainStatusDisabled ...
	DomainStatusDisabled DomainStatus = "Disabled"
	// DomainStatusExcluded ...
	DomainStatusExcluded DomainStatus = "Excluded"
	// DomainStatusExpired ...
	DomainStatusExpired DomainStatus = "Expired"
	// DomainStatusFailed ...
	DomainStatusFailed DomainStatus = "Failed"
	// DomainStatusHeld ...
	DomainStatusHeld DomainStatus = "Held"
	// DomainStatusJSONConverterFailed ...
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
	// DomainStatusLocked ...
	DomainStatusLocked DomainStatus = "Locked"
	// DomainStatusParked ...
	DomainStatusParked DomainStatus = "Parked"
	// DomainStatusPending ...
	DomainStatusPending DomainStatus = "Pending"
	// DomainStatusReserved ...
	DomainStatusReserved DomainStatus = "Reserved"
	// DomainStatusReverted ...
	DomainStatusReverted DomainStatus = "Reverted"
	// DomainStatusSuspended ...
	DomainStatusSuspended DomainStatus = "Suspended"
	// DomainStatusTransferred ...
	DomainStatusTransferred DomainStatus = "Transferred"
	// DomainStatusUnknown ...
	DomainStatusUnknown DomainStatus = "Unknown"
	// DomainStatusUnlocked ...
	DomainStatusUnlocked DomainStatus = "Unlocked"
	// DomainStatusUnparked ...
	DomainStatusUnparked DomainStatus = "Unparked"
	// DomainStatusUpdated ...
	DomainStatusUpdated DomainStatus = "Updated"
)

// PossibleDomainStatusValues returns an array of possible values for the DomainStatus const type.
func PossibleDomainStatusValues() []DomainStatus {
	return []DomainStatus{DomainStatusActive, DomainStatusAwaiting, DomainStatusCancelled, DomainStatusConfiscated, DomainStatusDisabled, DomainStatusExcluded, DomainStatusExpired, DomainStatusFailed, DomainStatusHeld, DomainStatusJSONConverterFailed, DomainStatusLocked, DomainStatusParked, DomainStatusPending, DomainStatusReserved, DomainStatusReverted, DomainStatusSuspended, DomainStatusTransferred, DomainStatusUnknown, DomainStatusUnlocked, DomainStatusUnparked, DomainStatusUpdated}
}

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Regular ...
	Regular DomainType = "Regular"
	// SoftDeleted ...
	SoftDeleted DomainType = "SoftDeleted"
)

// PossibleDomainTypeValues returns an array of possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{Regular, SoftDeleted}
}

// FrequencyUnit enumerates the values for frequency unit.
type FrequencyUnit string

const (
	// Day ...
	Day FrequencyUnit = "Day"
	// Hour ...
	Hour FrequencyUnit = "Hour"
)

// PossibleFrequencyUnitValues returns an array of possible values for the FrequencyUnit const type.
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return []FrequencyUnit{Day, Hour}
}

// HostingEnvironmentStatus enumerates the values for hosting environment status.
type HostingEnvironmentStatus string

const (
	// Deleting ...
	Deleting HostingEnvironmentStatus = "Deleting"
	// Preparing ...
	Preparing HostingEnvironmentStatus = "Preparing"
	// Ready ...
	Ready HostingEnvironmentStatus = "Ready"
	// Scaling ...
	Scaling HostingEnvironmentStatus = "Scaling"
)

// PossibleHostingEnvironmentStatusValues returns an array of possible values for the HostingEnvironmentStatus const type.
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return []HostingEnvironmentStatus{Deleting, Preparing, Ready, Scaling}
}

// HostNameType enumerates the values for host name type.
type HostNameType string

const (
	// Managed ...
	Managed HostNameType = "Managed"
	// Verified ...
	Verified HostNameType = "Verified"
)

// PossibleHostNameTypeValues returns an array of possible values for the HostNameType const type.
func PossibleHostNameTypeValues() []HostNameType {
	return []HostNameType{Managed, Verified}
}

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeRepository ...
	HostTypeRepository HostType = "Repository"
	// HostTypeStandard ...
	HostTypeStandard HostType = "Standard"
)

// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeRepository, HostTypeStandard}
}

// InAvailabilityReasonType enumerates the values for in availability reason type.
type InAvailabilityReasonType string

const (
	// AlreadyExists ...
	AlreadyExists InAvailabilityReasonType = "AlreadyExists"
	// Invalid ...
	Invalid InAvailabilityReasonType = "Invalid"
)

// PossibleInAvailabilityReasonTypeValues returns an array of possible values for the InAvailabilityReasonType const type.
func PossibleInAvailabilityReasonTypeValues() []InAvailabilityReasonType {
	return []InAvailabilityReasonType{AlreadyExists, Invalid}
}

// InternalLoadBalancingMode enumerates the values for internal load balancing mode.
type InternalLoadBalancingMode string

const (
	// InternalLoadBalancingModeNone ...
	InternalLoadBalancingModeNone InternalLoadBalancingMode = "None"
	// InternalLoadBalancingModePublishing ...
	InternalLoadBalancingModePublishing InternalLoadBalancingMode = "Publishing"
	// InternalLoadBalancingModeWeb ...
	InternalLoadBalancingModeWeb InternalLoadBalancingMode = "Web"
)

// PossibleInternalLoadBalancingModeValues returns an array of possible values for the InternalLoadBalancingMode const type.
func PossibleInternalLoadBalancingModeValues() []InternalLoadBalancingMode {
	return []InternalLoadBalancingMode{InternalLoadBalancingModeNone, InternalLoadBalancingModePublishing, InternalLoadBalancingModeWeb}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// AppCrash ...
	AppCrash IssueType = "AppCrash"
	// AppDeployment ...
	AppDeployment IssueType = "AppDeployment"
	// AseDeployment ...
	AseDeployment IssueType = "AseDeployment"
	// Other ...
	Other IssueType = "Other"
	// PlatformIssue ...
	PlatformIssue IssueType = "PlatformIssue"
	// RuntimeIssueDetected ...
	RuntimeIssueDetected IssueType = "RuntimeIssueDetected"
	// ServiceIncident ...
	ServiceIncident IssueType = "ServiceIncident"
	// UserIssue ...
	UserIssue IssueType = "UserIssue"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{AppCrash, AppDeployment, AseDeployment, Other, PlatformIssue, RuntimeIssueDetected, ServiceIncident, UserIssue}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// Continuous ...
	Continuous JobType = "Continuous"
	// Triggered ...
	Triggered JobType = "Triggered"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{Continuous, Triggered}
}

// KeyVaultSecretStatus enumerates the values for key vault secret status.
type KeyVaultSecretStatus string

const (
	// KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault ...
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	// KeyVaultSecretStatusCertificateOrderFailed ...
	KeyVaultSecretStatusCertificateOrderFailed KeyVaultSecretStatus = "CertificateOrderFailed"
	// KeyVaultSecretStatusExternalPrivateKey ...
	KeyVaultSecretStatusExternalPrivateKey KeyVaultSecretStatus = "ExternalPrivateKey"
	// KeyVaultSecretStatusInitialized ...
	KeyVaultSecretStatusInitialized KeyVaultSecretStatus = "Initialized"
	// KeyVaultSecretStatusKeyVaultDoesNotExist ...
	KeyVaultSecretStatusKeyVaultDoesNotExist KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	// KeyVaultSecretStatusKeyVaultSecretDoesNotExist ...
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	// KeyVaultSecretStatusOperationNotPermittedOnKeyVault ...
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	// KeyVaultSecretStatusSucceeded ...
	KeyVaultSecretStatusSucceeded KeyVaultSecretStatus = "Succeeded"
	// KeyVaultSecretStatusUnknown ...
	KeyVaultSecretStatusUnknown KeyVaultSecretStatus = "Unknown"
	// KeyVaultSecretStatusUnknownError ...
	KeyVaultSecretStatusUnknownError KeyVaultSecretStatus = "UnknownError"
	// KeyVaultSecretStatusWaitingOnCertificateOrder ...
	KeyVaultSecretStatusWaitingOnCertificateOrder KeyVaultSecretStatus = "WaitingOnCertificateOrder"
)

// PossibleKeyVaultSecretStatusValues returns an array of possible values for the KeyVaultSecretStatus const type.
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return []KeyVaultSecretStatus{KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault, KeyVaultSecretStatusCertificateOrderFailed, KeyVaultSecretStatusExternalPrivateKey, KeyVaultSecretStatusInitialized, KeyVaultSecretStatusKeyVaultDoesNotExist, KeyVaultSecretStatusKeyVaultSecretDoesNotExist, KeyVaultSecretStatusOperationNotPermittedOnKeyVault, KeyVaultSecretStatusSucceeded, KeyVaultSecretStatusUnknown, KeyVaultSecretStatusUnknownError, KeyVaultSecretStatusWaitingOnCertificateOrder}
}

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// Error ...
	Error LogLevel = "Error"
	// Information ...
	Information LogLevel = "Information"
	// Off ...
	Off LogLevel = "Off"
	// Verbose ...
	Verbose LogLevel = "Verbose"
	// Warning ...
	Warning LogLevel = "Warning"
)

// PossibleLogLevelValues returns an array of possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{Error, Information, Off, Verbose, Warning}
}

// ManagedPipelineMode enumerates the values for managed pipeline mode.
type ManagedPipelineMode string

const (
	// Classic ...
	Classic ManagedPipelineMode = "Classic"
	// Integrated ...
	Integrated ManagedPipelineMode = "Integrated"
)

// PossibleManagedPipelineModeValues returns an array of possible values for the ManagedPipelineMode const type.
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return []ManagedPipelineMode{Classic, Integrated}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ManagedServiceIdentityType = "SystemAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{SystemAssigned}
}

// MSDeployLogEntryType enumerates the values for ms deploy log entry type.
type MSDeployLogEntryType string

const (
	// MSDeployLogEntryTypeError ...
	MSDeployLogEntryTypeError MSDeployLogEntryType = "Error"
	// MSDeployLogEntryTypeMessage ...
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = "Message"
	// MSDeployLogEntryTypeWarning ...
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = "Warning"
)

// PossibleMSDeployLogEntryTypeValues returns an array of possible values for the MSDeployLogEntryType const type.
func PossibleMSDeployLogEntryTypeValues() []MSDeployLogEntryType {
	return []MSDeployLogEntryType{MSDeployLogEntryTypeError, MSDeployLogEntryTypeMessage, MSDeployLogEntryTypeWarning}
}

// MSDeployProvisioningState enumerates the values for ms deploy provisioning state.
type MSDeployProvisioningState string

const (
	// MSDeployProvisioningStateAccepted ...
	MSDeployProvisioningStateAccepted MSDeployProvisioningState = "accepted"
	// MSDeployProvisioningStateCanceled ...
	MSDeployProvisioningStateCanceled MSDeployProvisioningState = "canceled"
	// MSDeployProvisioningStateFailed ...
	MSDeployProvisioningStateFailed MSDeployProvisioningState = "failed"
	// MSDeployProvisioningStateRunning ...
	MSDeployProvisioningStateRunning MSDeployProvisioningState = "running"
	// MSDeployProvisioningStateSucceeded ...
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = "succeeded"
)

// PossibleMSDeployProvisioningStateValues returns an array of possible values for the MSDeployProvisioningState const type.
func PossibleMSDeployProvisioningStateValues() []MSDeployProvisioningState {
	return []MSDeployProvisioningState{MSDeployProvisioningStateAccepted, MSDeployProvisioningStateCanceled, MSDeployProvisioningStateFailed, MSDeployProvisioningStateRunning, MSDeployProvisioningStateSucceeded}
}

// MySQLMigrationType enumerates the values for my sql migration type.
type MySQLMigrationType string

const (
	// LocalToRemote ...
	LocalToRemote MySQLMigrationType = "LocalToRemote"
	// RemoteToLocal ...
	RemoteToLocal MySQLMigrationType = "RemoteToLocal"
)

// PossibleMySQLMigrationTypeValues returns an array of possible values for the MySQLMigrationType const type.
func PossibleMySQLMigrationTypeValues() []MySQLMigrationType {
	return []MySQLMigrationType{LocalToRemote, RemoteToLocal}
}

// NotificationLevel enumerates the values for notification level.
type NotificationLevel string

const (
	// NotificationLevelCritical ...
	NotificationLevelCritical NotificationLevel = "Critical"
	// NotificationLevelInformation ...
	NotificationLevelInformation NotificationLevel = "Information"
	// NotificationLevelNonUrgentSuggestion ...
	NotificationLevelNonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
	// NotificationLevelWarning ...
	NotificationLevelWarning NotificationLevel = "Warning"
)

// PossibleNotificationLevelValues returns an array of possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{NotificationLevelCritical, NotificationLevelInformation, NotificationLevelNonUrgentSuggestion, NotificationLevelWarning}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCreated ...
	OperationStatusCreated OperationStatus = "Created"
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
	// OperationStatusTimedOut ...
	OperationStatusTimedOut OperationStatus = "TimedOut"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusCreated, OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded, OperationStatusTimedOut}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// PublicCertificateLocation enumerates the values for public certificate location.
type PublicCertificateLocation string

const (
	// PublicCertificateLocationCurrentUserMy ...
	PublicCertificateLocationCurrentUserMy PublicCertificateLocation = "CurrentUserMy"
	// PublicCertificateLocationLocalMachineMy ...
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = "LocalMachineMy"
	// PublicCertificateLocationUnknown ...
	PublicCertificateLocationUnknown PublicCertificateLocation = "Unknown"
)

// PossiblePublicCertificateLocationValues returns an array of possible values for the PublicCertificateLocation const type.
func PossiblePublicCertificateLocationValues() []PublicCertificateLocation {
	return []PublicCertificateLocation{PublicCertificateLocationCurrentUserMy, PublicCertificateLocationLocalMachineMy, PublicCertificateLocationUnknown}
}

// PublishingProfileFormat enumerates the values for publishing profile format.
type PublishingProfileFormat string

const (
	// FileZilla3 ...
	FileZilla3 PublishingProfileFormat = "FileZilla3"
	// Ftp ...
	Ftp PublishingProfileFormat = "Ftp"
	// WebDeploy ...
	WebDeploy PublishingProfileFormat = "WebDeploy"
)

// PossiblePublishingProfileFormatValues returns an array of possible values for the PublishingProfileFormat const type.
func PossiblePublishingProfileFormatValues() []PublishingProfileFormat {
	return []PublishingProfileFormat{FileZilla3, Ftp, WebDeploy}
}

// RenderingType enumerates the values for rendering type.
type RenderingType string

const (
	// NoGraph ...
	NoGraph RenderingType = "NoGraph"
	// Table ...
	Table RenderingType = "Table"
	// TimeSeries ...
	TimeSeries RenderingType = "TimeSeries"
	// TimeSeriesPerInstance ...
	TimeSeriesPerInstance RenderingType = "TimeSeriesPerInstance"
)

// PossibleRenderingTypeValues returns an array of possible values for the RenderingType const type.
func PossibleRenderingTypeValues() []RenderingType {
	return []RenderingType{NoGraph, Table, TimeSeries, TimeSeriesPerInstance}
}

// ResourceScopeType enumerates the values for resource scope type.
type ResourceScopeType string

const (
	// ServerFarm ...
	ServerFarm ResourceScopeType = "ServerFarm"
	// Subscription ...
	Subscription ResourceScopeType = "Subscription"
	// WebSite ...
	WebSite ResourceScopeType = "WebSite"
)

// PossibleResourceScopeTypeValues returns an array of possible values for the ResourceScopeType const type.
func PossibleResourceScopeTypeValues() []ResourceScopeType {
	return []ResourceScopeType{ServerFarm, Subscription, WebSite}
}

// RouteType enumerates the values for route type.
type RouteType string

const (
	// DEFAULT ...
	DEFAULT RouteType = "DEFAULT"
	// INHERITED ...
	INHERITED RouteType = "INHERITED"
	// STATIC ...
	STATIC RouteType = "STATIC"
)

// PossibleRouteTypeValues returns an array of possible values for the RouteType const type.
func PossibleRouteTypeValues() []RouteType {
	return []RouteType{DEFAULT, INHERITED, STATIC}
}

// ScmType enumerates the values for scm type.
type ScmType string

const (
	// ScmTypeBitbucketGit ...
	ScmTypeBitbucketGit ScmType = "BitbucketGit"
	// ScmTypeBitbucketHg ...
	ScmTypeBitbucketHg ScmType = "BitbucketHg"
	// ScmTypeCodePlexGit ...
	ScmTypeCodePlexGit ScmType = "CodePlexGit"
	// ScmTypeCodePlexHg ...
	ScmTypeCodePlexHg ScmType = "CodePlexHg"
	// ScmTypeDropbox ...
	ScmTypeDropbox ScmType = "Dropbox"
	// ScmTypeExternalGit ...
	ScmTypeExternalGit ScmType = "ExternalGit"
	// ScmTypeExternalHg ...
	ScmTypeExternalHg ScmType = "ExternalHg"
	// ScmTypeGitHub ...
	ScmTypeGitHub ScmType = "GitHub"
	// ScmTypeLocalGit ...
	ScmTypeLocalGit ScmType = "LocalGit"
	// ScmTypeNone ...
	ScmTypeNone ScmType = "None"
	// ScmTypeOneDrive ...
	ScmTypeOneDrive ScmType = "OneDrive"
	// ScmTypeTfs ...
	ScmTypeTfs ScmType = "Tfs"
	// ScmTypeVSO ...
	ScmTypeVSO ScmType = "VSO"
)

// PossibleScmTypeValues returns an array of possible values for the ScmType const type.
func PossibleScmTypeValues() []ScmType {
	return []ScmType{ScmTypeBitbucketGit, ScmTypeBitbucketHg, ScmTypeCodePlexGit, ScmTypeCodePlexHg, ScmTypeDropbox, ScmTypeExternalGit, ScmTypeExternalHg, ScmTypeGitHub, ScmTypeLocalGit, ScmTypeNone, ScmTypeOneDrive, ScmTypeTfs, ScmTypeVSO}
}

// SiteAvailabilityState enumerates the values for site availability state.
type SiteAvailabilityState string

const (
	// DisasterRecoveryMode ...
	DisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
	// Limited ...
	Limited SiteAvailabilityState = "Limited"
	// Normal ...
	Normal SiteAvailabilityState = "Normal"
)

// PossibleSiteAvailabilityStateValues returns an array of possible values for the SiteAvailabilityState const type.
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return []SiteAvailabilityState{DisasterRecoveryMode, Limited, Normal}
}

// SiteExtensionType enumerates the values for site extension type.
type SiteExtensionType string

const (
	// Gallery ...
	Gallery SiteExtensionType = "Gallery"
	// WebRoot ...
	WebRoot SiteExtensionType = "WebRoot"
)

// PossibleSiteExtensionTypeValues returns an array of possible values for the SiteExtensionType const type.
func PossibleSiteExtensionTypeValues() []SiteExtensionType {
	return []SiteExtensionType{Gallery, WebRoot}
}

// SiteLoadBalancing enumerates the values for site load balancing.
type SiteLoadBalancing string

const (
	// LeastRequests ...
	LeastRequests SiteLoadBalancing = "LeastRequests"
	// LeastResponseTime ...
	LeastResponseTime SiteLoadBalancing = "LeastResponseTime"
	// RequestHash ...
	RequestHash SiteLoadBalancing = "RequestHash"
	// WeightedRoundRobin ...
	WeightedRoundRobin SiteLoadBalancing = "WeightedRoundRobin"
	// WeightedTotalTraffic ...
	WeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
)

// PossibleSiteLoadBalancingValues returns an array of possible values for the SiteLoadBalancing const type.
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return []SiteLoadBalancing{LeastRequests, LeastResponseTime, RequestHash, WeightedRoundRobin, WeightedTotalTraffic}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameDynamic ...
	SkuNameDynamic SkuName = "Dynamic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameIsolated ...
	SkuNameIsolated SkuName = "Isolated"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNamePremiumV2 ...
	SkuNamePremiumV2 SkuName = "PremiumV2"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameDynamic, SkuNameFree, SkuNameIsolated, SkuNamePremium, SkuNamePremiumV2, SkuNameShared, SkuNameStandard}
}

// SolutionType enumerates the values for solution type.
type SolutionType string

const (
	// BestPractices ...
	BestPractices SolutionType = "BestPractices"
	// DeepInvestigation ...
	DeepInvestigation SolutionType = "DeepInvestigation"
	// QuickSolution ...
	QuickSolution SolutionType = "QuickSolution"
)

// PossibleSolutionTypeValues returns an array of possible values for the SolutionType const type.
func PossibleSolutionTypeValues() []SolutionType {
	return []SolutionType{BestPractices, DeepInvestigation, QuickSolution}
}

// SslState enumerates the values for ssl state.
type SslState string

const (
	// Disabled ...
	Disabled SslState = "Disabled"
	// IPBasedEnabled ...
	IPBasedEnabled SslState = "IpBasedEnabled"
	// SniEnabled ...
	SniEnabled SslState = "SniEnabled"
)

// PossibleSslStateValues returns an array of possible values for the SslState const type.
func PossibleSslStateValues() []SslState {
	return []SslState{Disabled, IPBasedEnabled, SniEnabled}
}

// StatusOptions enumerates the values for status options.
type StatusOptions string

const (
	// StatusOptionsCreating ...
	StatusOptionsCreating StatusOptions = "Creating"
	// StatusOptionsPending ...
	StatusOptionsPending StatusOptions = "Pending"
	// StatusOptionsReady ...
	StatusOptionsReady StatusOptions = "Ready"
)

// PossibleStatusOptionsValues returns an array of possible values for the StatusOptions const type.
func PossibleStatusOptionsValues() []StatusOptions {
	return []StatusOptions{StatusOptionsCreating, StatusOptionsPending, StatusOptionsReady}
}

// SupportedTLSVersions enumerates the values for supported tls versions.
type SupportedTLSVersions string

const (
	// OneFullStopOne ...
	OneFullStopOne SupportedTLSVersions = "1.1"
	// OneFullStopTwo ...
	OneFullStopTwo SupportedTLSVersions = "1.2"
	// OneFullStopZero ...
	OneFullStopZero SupportedTLSVersions = "1.0"
)

// PossibleSupportedTLSVersionsValues returns an array of possible values for the SupportedTLSVersions const type.
func PossibleSupportedTLSVersionsValues() []SupportedTLSVersions {
	return []SupportedTLSVersions{OneFullStopOne, OneFullStopTwo, OneFullStopZero}
}

// TriggeredWebJobStatus enumerates the values for triggered web job status.
type TriggeredWebJobStatus string

const (
	// TriggeredWebJobStatusError ...
	TriggeredWebJobStatusError TriggeredWebJobStatus = "Error"
	// TriggeredWebJobStatusFailed ...
	TriggeredWebJobStatusFailed TriggeredWebJobStatus = "Failed"
	// TriggeredWebJobStatusSuccess ...
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = "Success"
)

// PossibleTriggeredWebJobStatusValues returns an array of possible values for the TriggeredWebJobStatus const type.
func PossibleTriggeredWebJobStatusValues() []TriggeredWebJobStatus {
	return []TriggeredWebJobStatus{TriggeredWebJobStatusError, TriggeredWebJobStatusFailed, TriggeredWebJobStatusSuccess}
}

// UnauthenticatedClientAction enumerates the values for unauthenticated client action.
type UnauthenticatedClientAction string

const (
	// AllowAnonymous ...
	AllowAnonymous UnauthenticatedClientAction = "AllowAnonymous"
	// RedirectToLoginPage ...
	RedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
)

// PossibleUnauthenticatedClientActionValues returns an array of possible values for the UnauthenticatedClientAction const type.
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return []UnauthenticatedClientAction{AllowAnonymous, RedirectToLoginPage}
}

// UsageState enumerates the values for usage state.
type UsageState string

const (
	// UsageStateExceeded ...
	UsageStateExceeded UsageState = "Exceeded"
	// UsageStateNormal ...
	UsageStateNormal UsageState = "Normal"
)

// PossibleUsageStateValues returns an array of possible values for the UsageState const type.
func PossibleUsageStateValues() []UsageState {
	return []UsageState{UsageStateExceeded, UsageStateNormal}
}

// ValidateResourceTypes enumerates the values for validate resource types.
type ValidateResourceTypes string

const (
	// ValidateResourceTypesServerFarm ...
	ValidateResourceTypesServerFarm ValidateResourceTypes = "ServerFarm"
	// ValidateResourceTypesSite ...
	ValidateResourceTypesSite ValidateResourceTypes = "Site"
)

// PossibleValidateResourceTypesValues returns an array of possible values for the ValidateResourceTypes const type.
func PossibleValidateResourceTypesValues() []ValidateResourceTypes {
	return []ValidateResourceTypes{ValidateResourceTypesServerFarm, ValidateResourceTypesSite}
}

// WorkerSizeOptions enumerates the values for worker size options.
type WorkerSizeOptions string

const (
	// D1 ...
	D1 WorkerSizeOptions = "D1"
	// D2 ...
	D2 WorkerSizeOptions = "D2"
	// D3 ...
	D3 WorkerSizeOptions = "D3"
	// Default ...
	Default WorkerSizeOptions = "Default"
	// Large ...
	Large WorkerSizeOptions = "Large"
	// Medium ...
	Medium WorkerSizeOptions = "Medium"
	// Small ...
	Small WorkerSizeOptions = "Small"
)

// PossibleWorkerSizeOptionsValues returns an array of possible values for the WorkerSizeOptions const type.
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return []WorkerSizeOptions{D1, D2, D3, Default, Large, Medium, Small}
}

// AbnormalTimePeriod class representing Abnormal Time Period identified in diagnosis
type AbnormalTimePeriod struct {
	// StartTime - Start time of the downtime
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the downtime
	EndTime *date.Time `json:"endTime,omitempty"`
	// Events - List of Possible Cause of downtime
	Events *[]DetectorAbnormalTimePeriod `json:"events,omitempty"`
	// Solutions - List of proposed solutions
	Solutions *[]Solution `json:"solutions,omitempty"`
}

// Address address information for domain registration.
type Address struct {
	// Address1 - First line of an Address.
	Address1 *string `json:"address1,omitempty"`
	// Address2 - The second line of the Address. Optional.
	Address2 *string `json:"address2,omitempty"`
	// City - The city for the address.
	City *string `json:"city,omitempty"`
	// Country - The country for the address.
	Country *string `json:"country,omitempty"`
	// PostalCode - The postal code for the address.
	PostalCode *string `json:"postalCode,omitempty"`
	// State - The state or province for the address.
	State *string `json:"state,omitempty"`
}

// AddressResponse describes main public IP address and any extra virtual IPs.
type AddressResponse struct {
	autorest.Response `json:"-"`
	// ServiceIPAddress - Main public virtual IP.
	ServiceIPAddress *string `json:"serviceIpAddress,omitempty"`
	// InternalIPAddress - Virtual Network internal IP address of the App Service Environment if it is in internal load-balancing mode.
	InternalIPAddress *string `json:"internalIpAddress,omitempty"`
	// OutboundIPAddresses - IP addresses appearing on outbound connections.
	OutboundIPAddresses *[]string `json:"outboundIpAddresses,omitempty"`
	// VipMappings - Additional virtual IPs.
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
}

// AnalysisData class Representing Detector Evidence used for analysis
type AnalysisData struct {
	// Source - Name of the Detector
	Source *string `json:"source,omitempty"`
	// DetectorDefinition - Detector Definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`
	// Metrics - Source Metrics
	Metrics *[]DiagnosticMetricSet `json:"metrics,omitempty"`
	// Data - Additional Source Data
	Data *[][]NameValuePair `json:"data,omitempty"`
	// DetectorMetaData - Detector Meta Data
	DetectorMetaData *ResponseMetaData `json:"detectorMetaData,omitempty"`
}

// AnalysisDefinition definition of Analysis
type AnalysisDefinition struct {
	// AnalysisDefinitionProperties - AnalysisDefinition resource specific properties
	*AnalysisDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AnalysisDefinition.
func (ad AnalysisDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.AnalysisDefinitionProperties != nil {
		objectMap["properties"] = ad.AnalysisDefinitionProperties
	}
	if ad.ID != nil {
		objectMap["id"] = ad.ID
	}
	if ad.Name != nil {
		objectMap["name"] = ad.Name
	}
	if ad.Kind != nil {
		objectMap["kind"] = ad.Kind
	}
	if ad.Type != nil {
		objectMap["type"] = ad.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AnalysisDefinition struct.
func (ad *AnalysisDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var analysisDefinitionProperties AnalysisDefinitionProperties
				err = json.Unmarshal(*v, &analysisDefinitionProperties)
				if err != nil {
					return err
				}
				ad.AnalysisDefinitionProperties = &analysisDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ad.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ad.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = &typeVar
			}
		}
	}

	return nil
}

// AnalysisDefinitionProperties analysisDefinition resource specific properties
type AnalysisDefinitionProperties struct {
	// Description - Description of the Analysis
	Description *string `json:"description,omitempty"`
}

// APIDefinitionInfo information about the formal API definition for the app.
type APIDefinitionInfo struct {
	// URL - The URL of the API definition.
	URL *string `json:"url,omitempty"`
}

// AppCollection collection of App Service apps.
type AppCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Site `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppCollectionIterator provides access to a complete listing of Site values.
type AppCollectionIterator struct {
	i    int
	page AppCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppCollectionIterator) Response() AppCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppCollectionIterator) Value() Site {
	if !iter.page.NotDone() {
		return Site{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppCollectionIterator type.
func NewAppCollectionIterator(page AppCollectionPage) AppCollectionIterator {
	return AppCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AppCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// appCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AppCollection) appCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ac.NextLink == nil || len(to.String(ac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// AppCollectionPage contains a page of Site values.
type AppCollectionPage struct {
	fn func(context.Context, AppCollection) (AppCollection, error)
	ac AppCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ac)
	if err != nil {
		return err
	}
	page.ac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppCollectionPage) Response() AppCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppCollectionPage) Values() []Site {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the AppCollectionPage type.
func NewAppCollectionPage(getNextPage func(context.Context, AppCollection) (AppCollection, error)) AppCollectionPage {
	return AppCollectionPage{fn: getNextPage}
}

// AppInstanceCollection collection of app instances.
type AppInstanceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteInstance `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppInstanceCollectionIterator provides access to a complete listing of SiteInstance values.
type AppInstanceCollectionIterator struct {
	i    int
	page AppInstanceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppInstanceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppInstanceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppInstanceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppInstanceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppInstanceCollectionIterator) Response() AppInstanceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppInstanceCollectionIterator) Value() SiteInstance {
	if !iter.page.NotDone() {
		return SiteInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppInstanceCollectionIterator type.
func NewAppInstanceCollectionIterator(page AppInstanceCollectionPage) AppInstanceCollectionIterator {
	return AppInstanceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aic AppInstanceCollection) IsEmpty() bool {
	return aic.Value == nil || len(*aic.Value) == 0
}

// appInstanceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aic AppInstanceCollection) appInstanceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if aic.NextLink == nil || len(to.String(aic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aic.NextLink)))
}

// AppInstanceCollectionPage contains a page of SiteInstance values.
type AppInstanceCollectionPage struct {
	fn  func(context.Context, AppInstanceCollection) (AppInstanceCollection, error)
	aic AppInstanceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppInstanceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppInstanceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.aic)
	if err != nil {
		return err
	}
	page.aic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppInstanceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppInstanceCollectionPage) NotDone() bool {
	return !page.aic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppInstanceCollectionPage) Response() AppInstanceCollection {
	return page.aic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppInstanceCollectionPage) Values() []SiteInstance {
	if page.aic.IsEmpty() {
		return nil
	}
	return *page.aic.Value
}

// Creates a new instance of the AppInstanceCollectionPage type.
func NewAppInstanceCollectionPage(getNextPage func(context.Context, AppInstanceCollection) (AppInstanceCollection, error)) AppInstanceCollectionPage {
	return AppInstanceCollectionPage{fn: getNextPage}
}

// ApplicationLogsConfig application logs configuration.
type ApplicationLogsConfig struct {
	// FileSystem - Application logs to file system configuration.
	FileSystem *FileSystemApplicationLogsConfig `json:"fileSystem,omitempty"`
	// AzureTableStorage - Application logs to azure table storage configuration.
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`
	// AzureBlobStorage - Application logs to blob storage configuration.
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig `json:"azureBlobStorage,omitempty"`
}

// ApplicationStack application stack.
type ApplicationStack struct {
	// Name - Application stack name.
	Name *string `json:"name,omitempty"`
	// Display - Application stack display name.
	Display *string `json:"display,omitempty"`
	// Dependency - Application stack dependency.
	Dependency *string `json:"dependency,omitempty"`
	// MajorVersions - List of major versions available.
	MajorVersions *[]StackMajorVersion `json:"majorVersions,omitempty"`
	// Frameworks - List of frameworks associated with application stack.
	Frameworks *[]ApplicationStack `json:"frameworks,omitempty"`
}

// ApplicationStackCollection collection of Application Stacks
type ApplicationStackCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ApplicationStack `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationStackCollectionIterator provides access to a complete listing of ApplicationStack values.
type ApplicationStackCollectionIterator struct {
	i    int
	page ApplicationStackCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationStackCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationStackCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationStackCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationStackCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationStackCollectionIterator) Response() ApplicationStackCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationStackCollectionIterator) Value() ApplicationStack {
	if !iter.page.NotDone() {
		return ApplicationStack{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationStackCollectionIterator type.
func NewApplicationStackCollectionIterator(page ApplicationStackCollectionPage) ApplicationStackCollectionIterator {
	return ApplicationStackCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asc ApplicationStackCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// applicationStackCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc ApplicationStackCollection) applicationStackCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if asc.NextLink == nil || len(to.String(asc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// ApplicationStackCollectionPage contains a page of ApplicationStack values.
type ApplicationStackCollectionPage struct {
	fn  func(context.Context, ApplicationStackCollection) (ApplicationStackCollection, error)
	asc ApplicationStackCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationStackCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationStackCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asc)
	if err != nil {
		return err
	}
	page.asc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationStackCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationStackCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationStackCollectionPage) Response() ApplicationStackCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationStackCollectionPage) Values() []ApplicationStack {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// Creates a new instance of the ApplicationStackCollectionPage type.
func NewApplicationStackCollectionPage(getNextPage func(context.Context, ApplicationStackCollection) (ApplicationStackCollection, error)) ApplicationStackCollectionPage {
	return ApplicationStackCollectionPage{fn: getNextPage}
}

// AppsCreateFunctionFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateFunctionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateFunctionFuture) Result(client AppsClient) (fe FunctionEnvelope, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateFunctionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateFunctionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fe.Response.Response, err = future.GetResult(sender); err == nil && fe.Response.Response.StatusCode != http.StatusNoContent {
		fe, err = client.CreateFunctionResponder(fe.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateFunctionFuture", "Result", fe.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateInstanceFunctionSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateInstanceFunctionSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateInstanceFunctionSlotFuture) Result(client AppsClient) (fe FunctionEnvelope, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceFunctionSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateInstanceFunctionSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fe.Response.Response, err = future.GetResult(sender); err == nil && fe.Response.Response.StatusCode != http.StatusNoContent {
		fe, err = client.CreateInstanceFunctionSlotResponder(fe.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceFunctionSlotFuture", "Result", fe.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateInstanceMSDeployOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateInstanceMSDeployOperationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateInstanceMSDeployOperationFuture) Result(client AppsClient) (mds MSDeployStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceMSDeployOperationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateInstanceMSDeployOperationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mds.Response.Response, err = future.GetResult(sender); err == nil && mds.Response.Response.StatusCode != http.StatusNoContent {
		mds, err = client.CreateInstanceMSDeployOperationResponder(mds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceMSDeployOperationFuture", "Result", mds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateInstanceMSDeployOperationSlotFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AppsCreateInstanceMSDeployOperationSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateInstanceMSDeployOperationSlotFuture) Result(client AppsClient) (mds MSDeployStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceMSDeployOperationSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateInstanceMSDeployOperationSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mds.Response.Response, err = future.GetResult(sender); err == nil && mds.Response.Response.StatusCode != http.StatusNoContent {
		mds, err = client.CreateInstanceMSDeployOperationSlotResponder(mds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateInstanceMSDeployOperationSlotFuture", "Result", mds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateMSDeployOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateMSDeployOperationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateMSDeployOperationFuture) Result(client AppsClient) (mds MSDeployStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateMSDeployOperationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateMSDeployOperationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mds.Response.Response, err = future.GetResult(sender); err == nil && mds.Response.Response.StatusCode != http.StatusNoContent {
		mds, err = client.CreateMSDeployOperationResponder(mds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateMSDeployOperationFuture", "Result", mds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateMSDeployOperationSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateMSDeployOperationSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateMSDeployOperationSlotFuture) Result(client AppsClient) (mds MSDeployStatus, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateMSDeployOperationSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateMSDeployOperationSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mds.Response.Response, err = future.GetResult(sender); err == nil && mds.Response.Response.StatusCode != http.StatusNoContent {
		mds, err = client.CreateMSDeployOperationSlotResponder(mds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateMSDeployOperationSlotFuture", "Result", mds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateOrUpdateFuture) Result(client AppsClient) (s Site, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateOrUpdateSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateOrUpdateSlotFuture) Result(client AppsClient) (s Site, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateOrUpdateSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateSlotResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSlotFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateOrUpdateSourceControlFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateOrUpdateSourceControlFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateOrUpdateSourceControlFuture) Result(client AppsClient) (ssc SiteSourceControl, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSourceControlFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateOrUpdateSourceControlFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssc.Response.Response, err = future.GetResult(sender); err == nil && ssc.Response.Response.StatusCode != http.StatusNoContent {
		ssc, err = client.CreateOrUpdateSourceControlResponder(ssc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSourceControlFuture", "Result", ssc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsCreateOrUpdateSourceControlSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateOrUpdateSourceControlSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateOrUpdateSourceControlSlotFuture) Result(client AppsClient) (ssc SiteSourceControl, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSourceControlSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsCreateOrUpdateSourceControlSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssc.Response.Response, err = future.GetResult(sender); err == nil && ssc.Response.Response.StatusCode != http.StatusNoContent {
		ssc, err = client.CreateOrUpdateSourceControlSlotResponder(ssc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsCreateOrUpdateSourceControlSlotFuture", "Result", ssc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceCertificate key Vault container for a certificate that is purchased through Azure.
type AppServiceCertificate struct {
	// KeyVaultID - Key Vault resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// ProvisioningState - Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	ProvisioningState KeyVaultSecretStatus `json:"provisioningState,omitempty"`
}

// AppServiceCertificateCollection collection of certitificateorder certificates.
type AppServiceCertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceCertificateResource `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppServiceCertificateCollectionIterator provides access to a complete listing of
// AppServiceCertificateResource values.
type AppServiceCertificateCollectionIterator struct {
	i    int
	page AppServiceCertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceCertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceCertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceCertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceCertificateCollectionIterator) Response() AppServiceCertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceCertificateCollectionIterator) Value() AppServiceCertificateResource {
	if !iter.page.NotDone() {
		return AppServiceCertificateResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceCertificateCollectionIterator type.
func NewAppServiceCertificateCollectionIterator(page AppServiceCertificateCollectionPage) AppServiceCertificateCollectionIterator {
	return AppServiceCertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ascc AppServiceCertificateCollection) IsEmpty() bool {
	return ascc.Value == nil || len(*ascc.Value) == 0
}

// appServiceCertificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ascc AppServiceCertificateCollection) appServiceCertificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ascc.NextLink == nil || len(to.String(ascc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ascc.NextLink)))
}

// AppServiceCertificateCollectionPage contains a page of AppServiceCertificateResource values.
type AppServiceCertificateCollectionPage struct {
	fn   func(context.Context, AppServiceCertificateCollection) (AppServiceCertificateCollection, error)
	ascc AppServiceCertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceCertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ascc)
	if err != nil {
		return err
	}
	page.ascc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceCertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceCertificateCollectionPage) NotDone() bool {
	return !page.ascc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceCertificateCollectionPage) Response() AppServiceCertificateCollection {
	return page.ascc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceCertificateCollectionPage) Values() []AppServiceCertificateResource {
	if page.ascc.IsEmpty() {
		return nil
	}
	return *page.ascc.Value
}

// Creates a new instance of the AppServiceCertificateCollectionPage type.
func NewAppServiceCertificateCollectionPage(getNextPage func(context.Context, AppServiceCertificateCollection) (AppServiceCertificateCollection, error)) AppServiceCertificateCollectionPage {
	return AppServiceCertificateCollectionPage{fn: getNextPage}
}

// AppServiceCertificateOrder SSL certificate purchase order.
type AppServiceCertificateOrder struct {
	autorest.Response `json:"-"`
	// AppServiceCertificateOrderProperties - AppServiceCertificateOrder resource specific properties
	*AppServiceCertificateOrderProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrder.
func (asco AppServiceCertificateOrder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asco.AppServiceCertificateOrderProperties != nil {
		objectMap["properties"] = asco.AppServiceCertificateOrderProperties
	}
	if asco.ID != nil {
		objectMap["id"] = asco.ID
	}
	if asco.Name != nil {
		objectMap["name"] = asco.Name
	}
	if asco.Kind != nil {
		objectMap["kind"] = asco.Kind
	}
	if asco.Location != nil {
		objectMap["location"] = asco.Location
	}
	if asco.Type != nil {
		objectMap["type"] = asco.Type
	}
	if asco.Tags != nil {
		objectMap["tags"] = asco.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateOrder struct.
func (asco *AppServiceCertificateOrder) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificateOrderProperties AppServiceCertificateOrderProperties
				err = json.Unmarshal(*v, &appServiceCertificateOrderProperties)
				if err != nil {
					return err
				}
				asco.AppServiceCertificateOrderProperties = &appServiceCertificateOrderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asco.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asco.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asco.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asco.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asco.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asco.Tags = tags
			}
		}
	}

	return nil
}

// AppServiceCertificateOrderCollection collection of certitificate orders.
type AppServiceCertificateOrderCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceCertificateOrder `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppServiceCertificateOrderCollectionIterator provides access to a complete listing of
// AppServiceCertificateOrder values.
type AppServiceCertificateOrderCollectionIterator struct {
	i    int
	page AppServiceCertificateOrderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceCertificateOrderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceCertificateOrderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceCertificateOrderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceCertificateOrderCollectionIterator) Response() AppServiceCertificateOrderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceCertificateOrderCollectionIterator) Value() AppServiceCertificateOrder {
	if !iter.page.NotDone() {
		return AppServiceCertificateOrder{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceCertificateOrderCollectionIterator type.
func NewAppServiceCertificateOrderCollectionIterator(page AppServiceCertificateOrderCollectionPage) AppServiceCertificateOrderCollectionIterator {
	return AppServiceCertificateOrderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ascoc AppServiceCertificateOrderCollection) IsEmpty() bool {
	return ascoc.Value == nil || len(*ascoc.Value) == 0
}

// appServiceCertificateOrderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ascoc AppServiceCertificateOrderCollection) appServiceCertificateOrderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ascoc.NextLink == nil || len(to.String(ascoc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ascoc.NextLink)))
}

// AppServiceCertificateOrderCollectionPage contains a page of AppServiceCertificateOrder values.
type AppServiceCertificateOrderCollectionPage struct {
	fn    func(context.Context, AppServiceCertificateOrderCollection) (AppServiceCertificateOrderCollection, error)
	ascoc AppServiceCertificateOrderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceCertificateOrderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ascoc)
	if err != nil {
		return err
	}
	page.ascoc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceCertificateOrderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceCertificateOrderCollectionPage) NotDone() bool {
	return !page.ascoc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceCertificateOrderCollectionPage) Response() AppServiceCertificateOrderCollection {
	return page.ascoc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceCertificateOrderCollectionPage) Values() []AppServiceCertificateOrder {
	if page.ascoc.IsEmpty() {
		return nil
	}
	return *page.ascoc.Value
}

// Creates a new instance of the AppServiceCertificateOrderCollectionPage type.
func NewAppServiceCertificateOrderCollectionPage(getNextPage func(context.Context, AppServiceCertificateOrderCollection) (AppServiceCertificateOrderCollection, error)) AppServiceCertificateOrderCollectionPage {
	return AppServiceCertificateOrderCollectionPage{fn: getNextPage}
}

// AppServiceCertificateOrderPatchResource ARM resource for a certificate order that is purchased through
// Azure.
type AppServiceCertificateOrderPatchResource struct {
	// AppServiceCertificateOrderPatchResourceProperties - AppServiceCertificateOrderPatchResource resource specific properties
	*AppServiceCertificateOrderPatchResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderPatchResource.
func (ascopr AppServiceCertificateOrderPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascopr.AppServiceCertificateOrderPatchResourceProperties != nil {
		objectMap["properties"] = ascopr.AppServiceCertificateOrderPatchResourceProperties
	}
	if ascopr.ID != nil {
		objectMap["id"] = ascopr.ID
	}
	if ascopr.Name != nil {
		objectMap["name"] = ascopr.Name
	}
	if ascopr.Kind != nil {
		objectMap["kind"] = ascopr.Kind
	}
	if ascopr.Type != nil {
		objectMap["type"] = ascopr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateOrderPatchResource struct.
func (ascopr *AppServiceCertificateOrderPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificateOrderPatchResourceProperties AppServiceCertificateOrderPatchResourceProperties
				err = json.Unmarshal(*v, &appServiceCertificateOrderPatchResourceProperties)
				if err != nil {
					return err
				}
				ascopr.AppServiceCertificateOrderPatchResourceProperties = &appServiceCertificateOrderPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascopr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascopr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascopr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascopr.Type = &typeVar
			}
		}
	}

	return nil
}

// AppServiceCertificateOrderPatchResourceProperties appServiceCertificateOrderPatchResource resource
// specific properties
type AppServiceCertificateOrderPatchResourceProperties struct {
	// Certificates - State of the Key Vault secret.
	Certificates map[string]*AppServiceCertificate `json:"certificates"`
	// DistinguishedName - Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// DomainVerificationToken - Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty"`
	// ValidityInYears - Duration in years (must be between 1 and 3).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`
	// KeySize - Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`
	// ProductType - Certificate product type. Possible values include: 'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
	ProductType CertificateProductType `json:"productType,omitempty"`
	// AutoRenew - <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ProvisioningState - Status of certificate order. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - Current order status. Possible values include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
	Status CertificateOrderStatus `json:"status,omitempty"`
	// SignedCertificate - Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty"`
	// Csr - Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`
	// Intermediate - Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty"`
	// Root - Root certificate.
	Root *CertificateDetails `json:"root,omitempty"`
	// SerialNumber - Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// LastCertificateIssuanceTime - Certificate last issuance time.
	LastCertificateIssuanceTime *date.Time `json:"lastCertificateIssuanceTime,omitempty"`
	// ExpirationTime - Certificate expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// IsPrivateKeyExternal - <code>true</code> if private key is external; otherwise, <code>false</code>.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
	// AppServiceCertificateNotRenewableReasons - Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons *[]string `json:"appServiceCertificateNotRenewableReasons,omitempty"`
	// NextAutoRenewalTimeStamp - Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *date.Time `json:"nextAutoRenewalTimeStamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderPatchResourceProperties.
func (ascopr AppServiceCertificateOrderPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascopr.Certificates != nil {
		objectMap["certificates"] = ascopr.Certificates
	}
	if ascopr.DistinguishedName != nil {
		objectMap["distinguishedName"] = ascopr.DistinguishedName
	}
	if ascopr.DomainVerificationToken != nil {
		objectMap["domainVerificationToken"] = ascopr.DomainVerificationToken
	}
	if ascopr.ValidityInYears != nil {
		objectMap["validityInYears"] = ascopr.ValidityInYears
	}
	if ascopr.KeySize != nil {
		objectMap["keySize"] = ascopr.KeySize
	}
	if ascopr.ProductType != "" {
		objectMap["productType"] = ascopr.ProductType
	}
	if ascopr.AutoRenew != nil {
		objectMap["autoRenew"] = ascopr.AutoRenew
	}
	if ascopr.ProvisioningState != "" {
		objectMap["provisioningState"] = ascopr.ProvisioningState
	}
	if ascopr.Status != "" {
		objectMap["status"] = ascopr.Status
	}
	if ascopr.SignedCertificate != nil {
		objectMap["signedCertificate"] = ascopr.SignedCertificate
	}
	if ascopr.Csr != nil {
		objectMap["csr"] = ascopr.Csr
	}
	if ascopr.Intermediate != nil {
		objectMap["intermediate"] = ascopr.Intermediate
	}
	if ascopr.Root != nil {
		objectMap["root"] = ascopr.Root
	}
	if ascopr.SerialNumber != nil {
		objectMap["serialNumber"] = ascopr.SerialNumber
	}
	if ascopr.LastCertificateIssuanceTime != nil {
		objectMap["lastCertificateIssuanceTime"] = ascopr.LastCertificateIssuanceTime
	}
	if ascopr.ExpirationTime != nil {
		objectMap["expirationTime"] = ascopr.ExpirationTime
	}
	if ascopr.IsPrivateKeyExternal != nil {
		objectMap["isPrivateKeyExternal"] = ascopr.IsPrivateKeyExternal
	}
	if ascopr.AppServiceCertificateNotRenewableReasons != nil {
		objectMap["appServiceCertificateNotRenewableReasons"] = ascopr.AppServiceCertificateNotRenewableReasons
	}
	if ascopr.NextAutoRenewalTimeStamp != nil {
		objectMap["nextAutoRenewalTimeStamp"] = ascopr.NextAutoRenewalTimeStamp
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateOrderProperties appServiceCertificateOrder resource specific properties
type AppServiceCertificateOrderProperties struct {
	// Certificates - State of the Key Vault secret.
	Certificates map[string]*AppServiceCertificate `json:"certificates"`
	// DistinguishedName - Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// DomainVerificationToken - Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty"`
	// ValidityInYears - Duration in years (must be between 1 and 3).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`
	// KeySize - Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`
	// ProductType - Certificate product type. Possible values include: 'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
	ProductType CertificateProductType `json:"productType,omitempty"`
	// AutoRenew - <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ProvisioningState - Status of certificate order. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - Current order status. Possible values include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
	Status CertificateOrderStatus `json:"status,omitempty"`
	// SignedCertificate - Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty"`
	// Csr - Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`
	// Intermediate - Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty"`
	// Root - Root certificate.
	Root *CertificateDetails `json:"root,omitempty"`
	// SerialNumber - Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// LastCertificateIssuanceTime - Certificate last issuance time.
	LastCertificateIssuanceTime *date.Time `json:"lastCertificateIssuanceTime,omitempty"`
	// ExpirationTime - Certificate expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// IsPrivateKeyExternal - <code>true</code> if private key is external; otherwise, <code>false</code>.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
	// AppServiceCertificateNotRenewableReasons - Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons *[]string `json:"appServiceCertificateNotRenewableReasons,omitempty"`
	// NextAutoRenewalTimeStamp - Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *date.Time `json:"nextAutoRenewalTimeStamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderProperties.
func (asco AppServiceCertificateOrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asco.Certificates != nil {
		objectMap["certificates"] = asco.Certificates
	}
	if asco.DistinguishedName != nil {
		objectMap["distinguishedName"] = asco.DistinguishedName
	}
	if asco.DomainVerificationToken != nil {
		objectMap["domainVerificationToken"] = asco.DomainVerificationToken
	}
	if asco.ValidityInYears != nil {
		objectMap["validityInYears"] = asco.ValidityInYears
	}
	if asco.KeySize != nil {
		objectMap["keySize"] = asco.KeySize
	}
	if asco.ProductType != "" {
		objectMap["productType"] = asco.ProductType
	}
	if asco.AutoRenew != nil {
		objectMap["autoRenew"] = asco.AutoRenew
	}
	if asco.ProvisioningState != "" {
		objectMap["provisioningState"] = asco.ProvisioningState
	}
	if asco.Status != "" {
		objectMap["status"] = asco.Status
	}
	if asco.SignedCertificate != nil {
		objectMap["signedCertificate"] = asco.SignedCertificate
	}
	if asco.Csr != nil {
		objectMap["csr"] = asco.Csr
	}
	if asco.Intermediate != nil {
		objectMap["intermediate"] = asco.Intermediate
	}
	if asco.Root != nil {
		objectMap["root"] = asco.Root
	}
	if asco.SerialNumber != nil {
		objectMap["serialNumber"] = asco.SerialNumber
	}
	if asco.LastCertificateIssuanceTime != nil {
		objectMap["lastCertificateIssuanceTime"] = asco.LastCertificateIssuanceTime
	}
	if asco.ExpirationTime != nil {
		objectMap["expirationTime"] = asco.ExpirationTime
	}
	if asco.IsPrivateKeyExternal != nil {
		objectMap["isPrivateKeyExternal"] = asco.IsPrivateKeyExternal
	}
	if asco.AppServiceCertificateNotRenewableReasons != nil {
		objectMap["appServiceCertificateNotRenewableReasons"] = asco.AppServiceCertificateNotRenewableReasons
	}
	if asco.NextAutoRenewalTimeStamp != nil {
		objectMap["nextAutoRenewalTimeStamp"] = asco.NextAutoRenewalTimeStamp
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateOrdersCreateOrUpdateCertificateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type AppServiceCertificateOrdersCreateOrUpdateCertificateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceCertificateOrdersCreateOrUpdateCertificateFuture) Result(client AppServiceCertificateOrdersClient) (ascr AppServiceCertificateResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ascr.Response.Response, err = future.GetResult(sender); err == nil && ascr.Response.Response.StatusCode != http.StatusNoContent {
		ascr, err = client.CreateOrUpdateCertificateResponder(ascr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture", "Result", ascr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceCertificateOrdersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AppServiceCertificateOrdersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceCertificateOrdersCreateOrUpdateFuture) Result(client AppServiceCertificateOrdersClient) (asco AppServiceCertificateOrder, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceCertificateOrdersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if asco.Response.Response, err = future.GetResult(sender); err == nil && asco.Response.Response.StatusCode != http.StatusNoContent {
		asco, err = client.CreateOrUpdateResponder(asco.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceCertificateOrdersCreateOrUpdateFuture", "Result", asco.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceCertificatePatchResource key Vault container ARM resource for a certificate that is purchased
// through Azure.
type AppServiceCertificatePatchResource struct {
	// AppServiceCertificate - Core resource properties
	*AppServiceCertificate `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificatePatchResource.
func (ascpr AppServiceCertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascpr.AppServiceCertificate != nil {
		objectMap["properties"] = ascpr.AppServiceCertificate
	}
	if ascpr.ID != nil {
		objectMap["id"] = ascpr.ID
	}
	if ascpr.Name != nil {
		objectMap["name"] = ascpr.Name
	}
	if ascpr.Kind != nil {
		objectMap["kind"] = ascpr.Kind
	}
	if ascpr.Type != nil {
		objectMap["type"] = ascpr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificatePatchResource struct.
func (ascpr *AppServiceCertificatePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificate AppServiceCertificate
				err = json.Unmarshal(*v, &appServiceCertificate)
				if err != nil {
					return err
				}
				ascpr.AppServiceCertificate = &appServiceCertificate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascpr.Type = &typeVar
			}
		}
	}

	return nil
}

// AppServiceCertificateResource key Vault container ARM resource for a certificate that is purchased
// through Azure.
type AppServiceCertificateResource struct {
	autorest.Response `json:"-"`
	// AppServiceCertificate - Core resource properties
	*AppServiceCertificate `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateResource.
func (ascr AppServiceCertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascr.AppServiceCertificate != nil {
		objectMap["properties"] = ascr.AppServiceCertificate
	}
	if ascr.ID != nil {
		objectMap["id"] = ascr.ID
	}
	if ascr.Name != nil {
		objectMap["name"] = ascr.Name
	}
	if ascr.Kind != nil {
		objectMap["kind"] = ascr.Kind
	}
	if ascr.Location != nil {
		objectMap["location"] = ascr.Location
	}
	if ascr.Type != nil {
		objectMap["type"] = ascr.Type
	}
	if ascr.Tags != nil {
		objectMap["tags"] = ascr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateResource struct.
func (ascr *AppServiceCertificateResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificate AppServiceCertificate
				err = json.Unmarshal(*v, &appServiceCertificate)
				if err != nil {
					return err
				}
				ascr.AppServiceCertificate = &appServiceCertificate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ascr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ascr.Tags = tags
			}
		}
	}

	return nil
}

// AppServiceEnvironment description of an App Service Environment.
type AppServiceEnvironment struct {
	// Name - Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Location - Location of the App Service Environment, e.g. "West US".
	Location *string `json:"location,omitempty"`
	// ProvisioningState - Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - Current status of the App Service Environment. Possible values include: 'Preparing', 'Ready', 'Scaling', 'Deleting'
	Status HostingEnvironmentStatus `json:"status,omitempty"`
	// VnetName - Name of the Virtual Network for the App Service Environment.
	VnetName *string `json:"vnetName,omitempty"`
	// VnetResourceGroupName - Resource group of the Virtual Network.
	VnetResourceGroupName *string `json:"vnetResourceGroupName,omitempty"`
	// VnetSubnetName - Subnet of the Virtual Network.
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
	// VirtualNetwork - Description of the Virtual Network.
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`
	// InternalLoadBalancingMode - Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values include: 'InternalLoadBalancingModeNone', 'InternalLoadBalancingModeWeb', 'InternalLoadBalancingModePublishing'
	InternalLoadBalancingMode InternalLoadBalancingMode `json:"internalLoadBalancingMode,omitempty"`
	// MultiSize - Front-end VM size, e.g. "Medium", "Large".
	MultiSize *string `json:"multiSize,omitempty"`
	// MultiRoleCount - Number of front-end instances.
	MultiRoleCount *int32 `json:"multiRoleCount,omitempty"`
	// WorkerPools - Description of worker pools with worker size IDs, VM sizes, and number of workers in each pool.
	WorkerPools *[]WorkerPool `json:"workerPools,omitempty"`
	// IpsslAddressCount - Number of IP SSL addresses reserved for the App Service Environment.
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`
	// DatabaseEdition - Edition of the metadata database for the App Service Environment, e.g. "Standard".
	DatabaseEdition *string `json:"databaseEdition,omitempty"`
	// DatabaseServiceObjective - Service objective of the metadata database for the App Service Environment, e.g. "S0".
	DatabaseServiceObjective *string `json:"databaseServiceObjective,omitempty"`
	// UpgradeDomains - Number of upgrade domains of the App Service Environment.
	UpgradeDomains *int32 `json:"upgradeDomains,omitempty"`
	// SubscriptionID - Subscription of the App Service Environment.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DNSSuffix - DNS suffix of the App Service Environment.
	DNSSuffix *string `json:"dnsSuffix,omitempty"`
	// LastAction - Last deployment action on the App Service Environment.
	LastAction *string `json:"lastAction,omitempty"`
	// LastActionResult - Result of the last deployment action on the App Service Environment.
	LastActionResult *string `json:"lastActionResult,omitempty"`
	// AllowedMultiSizes - List of comma separated strings describing which VM sizes are allowed for front-ends.
	AllowedMultiSizes *string `json:"allowedMultiSizes,omitempty"`
	// AllowedWorkerSizes - List of comma separated strings describing which VM sizes are allowed for workers.
	AllowedWorkerSizes *string `json:"allowedWorkerSizes,omitempty"`
	// MaximumNumberOfMachines - Maximum number of VMs in the App Service Environment.
	MaximumNumberOfMachines *int32 `json:"maximumNumberOfMachines,omitempty"`
	// VipMappings - Description of IP SSL mapping for the App Service Environment.
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
	// EnvironmentCapacities - Current total, used, and available worker capacities.
	EnvironmentCapacities *[]StampCapacity `json:"environmentCapacities,omitempty"`
	// NetworkAccessControlList - Access control list for controlling traffic to the App Service Environment.
	NetworkAccessControlList *[]NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`
	// EnvironmentIsHealthy - True/false indicating whether the App Service Environment is healthy.
	EnvironmentIsHealthy *bool `json:"environmentIsHealthy,omitempty"`
	// EnvironmentStatus - Detailed message about with results of the last check of the App Service Environment.
	EnvironmentStatus *string `json:"environmentStatus,omitempty"`
	// ResourceGroup - Resource group of the App Service Environment.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FrontEndScaleFactor - Scale factor for front-ends.
	FrontEndScaleFactor *int32 `json:"frontEndScaleFactor,omitempty"`
	// DefaultFrontEndScaleFactor - Default Scale Factor for FrontEnds.
	DefaultFrontEndScaleFactor *int32 `json:"defaultFrontEndScaleFactor,omitempty"`
	// APIManagementAccountID - API Management Account associated with the App Service Environment.
	APIManagementAccountID *string `json:"apiManagementAccountId,omitempty"`
	// Suspended - <code>true</code> if the App Service Environment is suspended; otherwise, <code>false</code>. The environment can be suspended, e.g. when the management endpoint is no longer available
	//  (most likely because NSG blocked the incoming traffic).
	Suspended *bool `json:"suspended,omitempty"`
	// DynamicCacheEnabled - True/false indicating whether the App Service Environment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
	// (most likely because NSG blocked the incoming traffic).
	DynamicCacheEnabled *bool `json:"dynamicCacheEnabled,omitempty"`
	// ClusterSettings - Custom settings for changing the behavior of the App Service Environment.
	ClusterSettings *[]NameValuePair `json:"clusterSettings,omitempty"`
	// UserWhitelistedIPRanges - User added ip ranges to whitelist on ASE db
	UserWhitelistedIPRanges *[]string `json:"userWhitelistedIpRanges,omitempty"`
}

// AppServiceEnvironmentCollection collection of App Service Environments.
type AppServiceEnvironmentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceEnvironmentResource `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppServiceEnvironmentCollectionIterator provides access to a complete listing of
// AppServiceEnvironmentResource values.
type AppServiceEnvironmentCollectionIterator struct {
	i    int
	page AppServiceEnvironmentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceEnvironmentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceEnvironmentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceEnvironmentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceEnvironmentCollectionIterator) Response() AppServiceEnvironmentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceEnvironmentCollectionIterator) Value() AppServiceEnvironmentResource {
	if !iter.page.NotDone() {
		return AppServiceEnvironmentResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceEnvironmentCollectionIterator type.
func NewAppServiceEnvironmentCollectionIterator(page AppServiceEnvironmentCollectionPage) AppServiceEnvironmentCollectionIterator {
	return AppServiceEnvironmentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asec AppServiceEnvironmentCollection) IsEmpty() bool {
	return asec.Value == nil || len(*asec.Value) == 0
}

// appServiceEnvironmentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asec AppServiceEnvironmentCollection) appServiceEnvironmentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if asec.NextLink == nil || len(to.String(asec.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asec.NextLink)))
}

// AppServiceEnvironmentCollectionPage contains a page of AppServiceEnvironmentResource values.
type AppServiceEnvironmentCollectionPage struct {
	fn   func(context.Context, AppServiceEnvironmentCollection) (AppServiceEnvironmentCollection, error)
	asec AppServiceEnvironmentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceEnvironmentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asec)
	if err != nil {
		return err
	}
	page.asec = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceEnvironmentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceEnvironmentCollectionPage) NotDone() bool {
	return !page.asec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceEnvironmentCollectionPage) Response() AppServiceEnvironmentCollection {
	return page.asec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceEnvironmentCollectionPage) Values() []AppServiceEnvironmentResource {
	if page.asec.IsEmpty() {
		return nil
	}
	return *page.asec.Value
}

// Creates a new instance of the AppServiceEnvironmentCollectionPage type.
func NewAppServiceEnvironmentCollectionPage(getNextPage func(context.Context, AppServiceEnvironmentCollection) (AppServiceEnvironmentCollection, error)) AppServiceEnvironmentCollectionPage {
	return AppServiceEnvironmentCollectionPage{fn: getNextPage}
}

// AppServiceEnvironmentPatchResource ARM resource for a app service environment.
type AppServiceEnvironmentPatchResource struct {
	// AppServiceEnvironment - Core resource properties
	*AppServiceEnvironment `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironmentPatchResource.
func (asepr AppServiceEnvironmentPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asepr.AppServiceEnvironment != nil {
		objectMap["properties"] = asepr.AppServiceEnvironment
	}
	if asepr.ID != nil {
		objectMap["id"] = asepr.ID
	}
	if asepr.Name != nil {
		objectMap["name"] = asepr.Name
	}
	if asepr.Kind != nil {
		objectMap["kind"] = asepr.Kind
	}
	if asepr.Type != nil {
		objectMap["type"] = asepr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceEnvironmentPatchResource struct.
func (asepr *AppServiceEnvironmentPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceEnvironment AppServiceEnvironment
				err = json.Unmarshal(*v, &appServiceEnvironment)
				if err != nil {
					return err
				}
				asepr.AppServiceEnvironment = &appServiceEnvironment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asepr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asepr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asepr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asepr.Type = &typeVar
			}
		}
	}

	return nil
}

// AppServiceEnvironmentResource app Service Environment ARM resource.
type AppServiceEnvironmentResource struct {
	autorest.Response `json:"-"`
	// AppServiceEnvironment - Core resource properties
	*AppServiceEnvironment `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironmentResource.
func (aser AppServiceEnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aser.AppServiceEnvironment != nil {
		objectMap["properties"] = aser.AppServiceEnvironment
	}
	if aser.ID != nil {
		objectMap["id"] = aser.ID
	}
	if aser.Name != nil {
		objectMap["name"] = aser.Name
	}
	if aser.Kind != nil {
		objectMap["kind"] = aser.Kind
	}
	if aser.Location != nil {
		objectMap["location"] = aser.Location
	}
	if aser.Type != nil {
		objectMap["type"] = aser.Type
	}
	if aser.Tags != nil {
		objectMap["tags"] = aser.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceEnvironmentResource struct.
func (aser *AppServiceEnvironmentResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceEnvironment AppServiceEnvironment
				err = json.Unmarshal(*v, &appServiceEnvironment)
				if err != nil {
					return err
				}
				aser.AppServiceEnvironment = &appServiceEnvironment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aser.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aser.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aser.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aser.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aser.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aser.Tags = tags
			}
		}
	}

	return nil
}

// AppServiceEnvironmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsCreateOrUpdateFuture) Result(client AppServiceEnvironmentsClient) (aser AppServiceEnvironmentResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if aser.Response.Response, err = future.GetResult(sender); err == nil && aser.Response.Response.StatusCode != http.StatusNoContent {
		aser, err = client.CreateOrUpdateResponder(aser.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateFuture", "Result", aser.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture) Result(client AppServiceEnvironmentsClient) (wpr WorkerPoolResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wpr.Response.Response, err = future.GetResult(sender); err == nil && wpr.Response.Response.StatusCode != http.StatusNoContent {
		wpr, err = client.CreateOrUpdateMultiRolePoolResponder(wpr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture", "Result", wpr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture) Result(client AppServiceEnvironmentsClient) (wpr WorkerPoolResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wpr.Response.Response, err = future.GetResult(sender); err == nil && wpr.Response.Response.StatusCode != http.StatusNoContent {
		wpr, err = client.CreateOrUpdateWorkerPoolResponder(wpr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture", "Result", wpr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsDeleteFuture) Result(client AppServiceEnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppServiceEnvironmentsResumeAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsResumeAllFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsResumeAllFuture) Result(client AppServiceEnvironmentsClient) (acp AppCollectionPage, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsResumeAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsResumeAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acp.ac.Response.Response, err = future.GetResult(sender); err == nil && acp.ac.Response.Response.StatusCode != http.StatusNoContent {
		acp, err = client.ResumeResponder(acp.ac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsResumeAllFuture", "Result", acp.ac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsResumeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsResumeFuture) Result(client AppServiceEnvironmentsClient) (acp AppCollectionPage, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acp.ac.Response.Response, err = future.GetResult(sender); err == nil && acp.ac.Response.Response.StatusCode != http.StatusNoContent {
		acp, err = client.ResumeResponder(acp.ac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsResumeFuture", "Result", acp.ac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsSuspendAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsSuspendAllFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsSuspendAllFuture) Result(client AppServiceEnvironmentsClient) (acp AppCollectionPage, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsSuspendAllFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsSuspendAllFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acp.ac.Response.Response, err = future.GetResult(sender); err == nil && acp.ac.Response.Response.StatusCode != http.StatusNoContent {
		acp, err = client.SuspendResponder(acp.ac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsSuspendAllFuture", "Result", acp.ac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServiceEnvironmentsSuspendFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsSuspendFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServiceEnvironmentsSuspendFuture) Result(client AppServiceEnvironmentsClient) (acp AppCollectionPage, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsSuspendFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServiceEnvironmentsSuspendFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if acp.ac.Response.Response, err = future.GetResult(sender); err == nil && acp.ac.Response.Response.StatusCode != http.StatusNoContent {
		acp, err = client.SuspendResponder(acp.ac.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServiceEnvironmentsSuspendFuture", "Result", acp.ac.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppServicePlan app Service plan.
type AppServicePlan struct {
	autorest.Response `json:"-"`
	// AppServicePlanProperties - AppServicePlan resource specific properties
	*AppServicePlanProperties `json:"properties,omitempty"`
	Sku                       *SkuDescription `json:"sku,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AppServicePlan.
func (asp AppServicePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.AppServicePlanProperties != nil {
		objectMap["properties"] = asp.AppServicePlanProperties
	}
	if asp.Sku != nil {
		objectMap["sku"] = asp.Sku
	}
	if asp.ID != nil {
		objectMap["id"] = asp.ID
	}
	if asp.Name != nil {
		objectMap["name"] = asp.Name
	}
	if asp.Kind != nil {
		objectMap["kind"] = asp.Kind
	}
	if asp.Location != nil {
		objectMap["location"] = asp.Location
	}
	if asp.Type != nil {
		objectMap["type"] = asp.Type
	}
	if asp.Tags != nil {
		objectMap["tags"] = asp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServicePlan struct.
func (asp *AppServicePlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServicePlanProperties AppServicePlanProperties
				err = json.Unmarshal(*v, &appServicePlanProperties)
				if err != nil {
					return err
				}
				asp.AppServicePlanProperties = &appServicePlanProperties
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				asp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asp.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asp.Tags = tags
			}
		}
	}

	return nil
}

// AppServicePlanCollection collection of App Service plans.
type AppServicePlanCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServicePlan `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppServicePlanCollectionIterator provides access to a complete listing of AppServicePlan values.
type AppServicePlanCollectionIterator struct {
	i    int
	page AppServicePlanCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServicePlanCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServicePlanCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServicePlanCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServicePlanCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServicePlanCollectionIterator) Response() AppServicePlanCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServicePlanCollectionIterator) Value() AppServicePlan {
	if !iter.page.NotDone() {
		return AppServicePlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServicePlanCollectionIterator type.
func NewAppServicePlanCollectionIterator(page AppServicePlanCollectionPage) AppServicePlanCollectionIterator {
	return AppServicePlanCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aspc AppServicePlanCollection) IsEmpty() bool {
	return aspc.Value == nil || len(*aspc.Value) == 0
}

// appServicePlanCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aspc AppServicePlanCollection) appServicePlanCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if aspc.NextLink == nil || len(to.String(aspc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aspc.NextLink)))
}

// AppServicePlanCollectionPage contains a page of AppServicePlan values.
type AppServicePlanCollectionPage struct {
	fn   func(context.Context, AppServicePlanCollection) (AppServicePlanCollection, error)
	aspc AppServicePlanCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServicePlanCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServicePlanCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.aspc)
	if err != nil {
		return err
	}
	page.aspc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServicePlanCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServicePlanCollectionPage) NotDone() bool {
	return !page.aspc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServicePlanCollectionPage) Response() AppServicePlanCollection {
	return page.aspc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServicePlanCollectionPage) Values() []AppServicePlan {
	if page.aspc.IsEmpty() {
		return nil
	}
	return *page.aspc.Value
}

// Creates a new instance of the AppServicePlanCollectionPage type.
func NewAppServicePlanCollectionPage(getNextPage func(context.Context, AppServicePlanCollection) (AppServicePlanCollection, error)) AppServicePlanCollectionPage {
	return AppServicePlanCollectionPage{fn: getNextPage}
}

// AppServicePlanPatchResource ARM resource for a app service plan.
type AppServicePlanPatchResource struct {
	// AppServicePlanPatchResourceProperties - AppServicePlanPatchResource resource specific properties
	*AppServicePlanPatchResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlanPatchResource.
func (asppr AppServicePlanPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asppr.AppServicePlanPatchResourceProperties != nil {
		objectMap["properties"] = asppr.AppServicePlanPatchResourceProperties
	}
	if asppr.ID != nil {
		objectMap["id"] = asppr.ID
	}
	if asppr.Name != nil {
		objectMap["name"] = asppr.Name
	}
	if asppr.Kind != nil {
		objectMap["kind"] = asppr.Kind
	}
	if asppr.Type != nil {
		objectMap["type"] = asppr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServicePlanPatchResource struct.
func (asppr *AppServicePlanPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServicePlanPatchResourceProperties AppServicePlanPatchResourceProperties
				err = json.Unmarshal(*v, &appServicePlanPatchResourceProperties)
				if err != nil {
					return err
				}
				asppr.AppServicePlanPatchResourceProperties = &appServicePlanPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asppr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asppr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asppr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asppr.Type = &typeVar
			}
		}
	}

	return nil
}

// AppServicePlanPatchResourceProperties appServicePlanPatchResource resource specific properties
type AppServicePlanPatchResourceProperties struct {
	// Name - Name for the App Service plan.
	Name *string `json:"name,omitempty"`
	// WorkerTierName - Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`
	// Status - App Service plan status. Possible values include: 'StatusOptionsReady', 'StatusOptionsPending', 'StatusOptionsCreating'
	Status StatusOptions `json:"status,omitempty"`
	// Subscription - App Service plan subscription.
	Subscription *string `json:"subscription,omitempty"`
	// AdminSiteName - App Service plan administration site.
	AdminSiteName *string `json:"adminSiteName,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// MaximumNumberOfWorkers - Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty"`
	// GeoRegion - Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// PerSiteScaling - If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
	// If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`
	// NumberOfSites - Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty"`
	// IsSpot - If <code>true</code>, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`
	// SpotExpirationTime - The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *date.Time `json:"spotExpirationTime,omitempty"`
	// ResourceGroup - Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Reserved - If Linux app service plan <code>true</code>, <code>false</code> otherwise.
	Reserved *bool `json:"reserved,omitempty"`
	// TargetWorkerCount - Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`
	// TargetWorkerSizeID - Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`
	// ProvisioningState - Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AppServicePlanProperties appServicePlan resource specific properties
type AppServicePlanProperties struct {
	// Name - Name for the App Service plan.
	Name *string `json:"name,omitempty"`
	// WorkerTierName - Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`
	// Status - App Service plan status. Possible values include: 'StatusOptionsReady', 'StatusOptionsPending', 'StatusOptionsCreating'
	Status StatusOptions `json:"status,omitempty"`
	// Subscription - App Service plan subscription.
	Subscription *string `json:"subscription,omitempty"`
	// AdminSiteName - App Service plan administration site.
	AdminSiteName *string `json:"adminSiteName,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// MaximumNumberOfWorkers - Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty"`
	// GeoRegion - Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// PerSiteScaling - If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
	// If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`
	// NumberOfSites - Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty"`
	// IsSpot - If <code>true</code>, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`
	// SpotExpirationTime - The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *date.Time `json:"spotExpirationTime,omitempty"`
	// ResourceGroup - Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Reserved - If Linux app service plan <code>true</code>, <code>false</code> otherwise.
	Reserved *bool `json:"reserved,omitempty"`
	// TargetWorkerCount - Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`
	// TargetWorkerSizeID - Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`
	// ProvisioningState - Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// AppServicePlansCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServicePlansCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppServicePlansCreateOrUpdateFuture) Result(client AppServicePlansClient) (asp AppServicePlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppServicePlansCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if asp.Response.Response, err = future.GetResult(sender); err == nil && asp.Response.Response.StatusCode != http.StatusNoContent {
		asp, err = client.CreateOrUpdateResponder(asp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServicePlansCreateOrUpdateFuture", "Result", asp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsInstallSiteExtensionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsInstallSiteExtensionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsInstallSiteExtensionFuture) Result(client AppsClient) (sei SiteExtensionInfo, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsInstallSiteExtensionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsInstallSiteExtensionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sei.Response.Response, err = future.GetResult(sender); err == nil && sei.Response.Response.StatusCode != http.StatusNoContent {
		sei, err = client.InstallSiteExtensionResponder(sei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsInstallSiteExtensionFuture", "Result", sei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsInstallSiteExtensionSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsInstallSiteExtensionSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsInstallSiteExtensionSlotFuture) Result(client AppsClient) (sei SiteExtensionInfo, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsInstallSiteExtensionSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsInstallSiteExtensionSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sei.Response.Response, err = future.GetResult(sender); err == nil && sei.Response.Response.StatusCode != http.StatusNoContent {
		sei, err = client.InstallSiteExtensionSlotResponder(sei.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsInstallSiteExtensionSlotFuture", "Result", sei.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsListPublishingCredentialsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsListPublishingCredentialsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsListPublishingCredentialsFuture) Result(client AppsClient) (u User, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsListPublishingCredentialsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsListPublishingCredentialsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.ListPublishingCredentialsResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsListPublishingCredentialsFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsListPublishingCredentialsSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsListPublishingCredentialsSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsListPublishingCredentialsSlotFuture) Result(client AppsClient) (u User, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsListPublishingCredentialsSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsListPublishingCredentialsSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if u.Response.Response, err = future.GetResult(sender); err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
		u, err = client.ListPublishingCredentialsSlotResponder(u.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsListPublishingCredentialsSlotFuture", "Result", u.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsMigrateMySQLFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsMigrateMySQLFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsMigrateMySQLFuture) Result(client AppsClient) (o Operation, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsMigrateMySQLFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsMigrateMySQLFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.MigrateMySQLResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsMigrateMySQLFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsMigrateStorageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsMigrateStorageFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsMigrateStorageFuture) Result(client AppsClient) (smr StorageMigrationResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsMigrateStorageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsMigrateStorageFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if smr.Response.Response, err = future.GetResult(sender); err == nil && smr.Response.Response.StatusCode != http.StatusNoContent {
		smr, err = client.MigrateStorageResponder(smr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsMigrateStorageFuture", "Result", smr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsRecoverFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsRecoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsRecoverFuture) Result(client AppsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsRecoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsRecoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppsRecoverSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsRecoverSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsRecoverSlotFuture) Result(client AppsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsRecoverSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsRecoverSlotFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppsRestoreFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsRestoreFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsRestoreFuture) Result(client AppsClient) (rr RestoreResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsRestoreFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rr.Response.Response, err = future.GetResult(sender); err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
		rr, err = client.RestoreResponder(rr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsRestoreFuture", "Result", rr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsRestoreSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsRestoreSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsRestoreSlotFuture) Result(client AppsClient) (rr RestoreResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsRestoreSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsRestoreSlotFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rr.Response.Response, err = future.GetResult(sender); err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
		rr, err = client.RestoreSlotResponder(rr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsRestoreSlotFuture", "Result", rr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsSwapSlotSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsSwapSlotSlotFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsSwapSlotSlotFuture) Result(client AppsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsSwapSlotSlotFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsSwapSlotSlotFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppsSwapSlotWithProductionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsSwapSlotWithProductionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsSwapSlotWithProductionFuture) Result(client AppsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsSwapSlotWithProductionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.AppsSwapSlotWithProductionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AutoHealActions actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// ActionType - Predefined action to be taken. Possible values include: 'Recycle', 'LogEvent', 'CustomAction'
	ActionType AutoHealActionType `json:"actionType,omitempty"`
	// CustomAction - Custom action to be taken.
	CustomAction *AutoHealCustomAction `json:"customAction,omitempty"`
	// MinProcessExecutionTime - Minimum time the process must execute
	// before taking the action
	MinProcessExecutionTime *string `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction custom action to be executed
// when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Exe - Executable to be run.
	Exe *string `json:"exe,omitempty"`
	// Parameters - Parameters for the executable.
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules rules that can be defined for auto-heal.
type AutoHealRules struct {
	// Triggers - Conditions that describe when to execute the auto-heal actions.
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
	// Actions - Actions to be executed when a rule is triggered.
	Actions *AutoHealActions `json:"actions,omitempty"`
}

// AutoHealTriggers triggers for auto-heal.
type AutoHealTriggers struct {
	// Requests - A rule based on total requests.
	Requests *RequestsBasedTrigger `json:"requests,omitempty"`
	// PrivateBytesInKB - A rule based on private bytes.
	PrivateBytesInKB *int32 `json:"privateBytesInKB,omitempty"`
	// StatusCodes - A rule based on status codes.
	StatusCodes *[]StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
	// SlowRequests - A rule based on request execution time.
	SlowRequests *SlowRequestsBasedTrigger `json:"slowRequests,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove blobs older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove blobs older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// AzureTableStorageApplicationLogsConfig application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS URL to an Azure table with add/query/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// BackupItem backup description.
type BackupItem struct {
	autorest.Response `json:"-"`
	// BackupItemProperties - BackupItem resource specific properties
	*BackupItemProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupItem.
func (bi BackupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bi.BackupItemProperties != nil {
		objectMap["properties"] = bi.BackupItemProperties
	}
	if bi.ID != nil {
		objectMap["id"] = bi.ID
	}
	if bi.Name != nil {
		objectMap["name"] = bi.Name
	}
	if bi.Kind != nil {
		objectMap["kind"] = bi.Kind
	}
	if bi.Type != nil {
		objectMap["type"] = bi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupItem struct.
func (bi *BackupItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupItemProperties BackupItemProperties
				err = json.Unmarshal(*v, &backupItemProperties)
				if err != nil {
					return err
				}
				bi.BackupItemProperties = &backupItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bi.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupItemCollection collection of backup items.
type BackupItemCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]BackupItem `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackupItemCollectionIterator provides access to a complete listing of BackupItem values.
type BackupItemCollectionIterator struct {
	i    int
	page BackupItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupItemCollectionIterator) Response() BackupItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupItemCollectionIterator) Value() BackupItem {
	if !iter.page.NotDone() {
		return BackupItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupItemCollectionIterator type.
func NewBackupItemCollectionIterator(page BackupItemCollectionPage) BackupItemCollectionIterator {
	return BackupItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bic BackupItemCollection) IsEmpty() bool {
	return bic.Value == nil || len(*bic.Value) == 0
}

// backupItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bic BackupItemCollection) backupItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if bic.NextLink == nil || len(to.String(bic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bic.NextLink)))
}

// BackupItemCollectionPage contains a page of BackupItem values.
type BackupItemCollectionPage struct {
	fn  func(context.Context, BackupItemCollection) (BackupItemCollection, error)
	bic BackupItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bic)
	if err != nil {
		return err
	}
	page.bic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupItemCollectionPage) NotDone() bool {
	return !page.bic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupItemCollectionPage) Response() BackupItemCollection {
	return page.bic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupItemCollectionPage) Values() []BackupItem {
	if page.bic.IsEmpty() {
		return nil
	}
	return *page.bic.Value
}

// Creates a new instance of the BackupItemCollectionPage type.
func NewBackupItemCollectionPage(getNextPage func(context.Context, BackupItemCollection) (BackupItemCollection, error)) BackupItemCollectionPage {
	return BackupItemCollectionPage{fn: getNextPage}
}

// BackupItemProperties backupItem resource specific properties
type BackupItemProperties struct {
	// BackupID - Id of the backup.
	BackupID *int32 `json:"id,omitempty"`
	// StorageAccountURL - SAS URL for the storage account container which contains this backup.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - Name of the blob which contains data for this backup.
	BlobName *string `json:"blobName,omitempty"`
	// Name - Name of this backup.
	Name *string `json:"name,omitempty"`
	// Status - Backup status. Possible values include: 'InProgress', 'Failed', 'Succeeded', 'TimedOut', 'Created', 'Skipped', 'PartiallySucceeded', 'DeleteInProgress', 'DeleteFailed', 'Deleted'
	Status BackupItemStatus `json:"status,omitempty"`
	// SizeInBytes - Size of the backup in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// Created - Timestamp of the backup creation.
	Created *date.Time `json:"created,omitempty"`
	// Log - Details regarding this backup. Might contain an error message.
	Log *string `json:"log,omitempty"`
	// Databases - List of databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// Scheduled - True if this backup has been created due to a schedule being triggered.
	Scheduled *bool `json:"scheduled,omitempty"`
	// LastRestoreTimeStamp - Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *date.Time `json:"lastRestoreTimeStamp,omitempty"`
	// FinishedTimeStamp - Timestamp when this backup finished.
	FinishedTimeStamp *date.Time `json:"finishedTimeStamp,omitempty"`
	// CorrelationID - Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string `json:"correlationId,omitempty"`
	// WebsiteSizeInBytes - Size of the original web app which has been backed up.
	WebsiteSizeInBytes *int64 `json:"websiteSizeInBytes,omitempty"`
}

// BackupRequest description of a backup which will be performed.
type BackupRequest struct {
	autorest.Response `json:"-"`
	// BackupRequestProperties - BackupRequest resource specific properties
	*BackupRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupRequest.
func (br BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.BackupRequestProperties != nil {
		objectMap["properties"] = br.BackupRequestProperties
	}
	if br.ID != nil {
		objectMap["id"] = br.ID
	}
	if br.Name != nil {
		objectMap["name"] = br.Name
	}
	if br.Kind != nil {
		objectMap["kind"] = br.Kind
	}
	if br.Type != nil {
		objectMap["type"] = br.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupRequest struct.
func (br *BackupRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupRequestProperties BackupRequestProperties
				err = json.Unmarshal(*v, &backupRequestProperties)
				if err != nil {
					return err
				}
				br.BackupRequestProperties = &backupRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				br.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				br.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				br.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				br.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupRequestProperties backupRequest resource specific properties
type BackupRequestProperties struct {
	// BackupRequestName - Name of the backup.
	BackupRequestName *string `json:"name,omitempty"`
	// Enabled - True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageAccountURL - SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BackupSchedule - Schedule for the backup if it is executed periodically.
	BackupSchedule *BackupSchedule `json:"backupSchedule,omitempty"`
	// Databases - Databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// Type - Type of the backup. Possible values include: 'BackupRestoreOperationTypeDefault', 'BackupRestoreOperationTypeClone', 'BackupRestoreOperationTypeRelocation', 'BackupRestoreOperationTypeSnapshot'
	Type BackupRestoreOperationType `json:"type,omitempty"`
}

// BackupSchedule description of a backup schedule. Describes how often should be the backup performed and
// what should be the retention policy.
type BackupSchedule struct {
	// FrequencyInterval - How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
	FrequencyInterval *int32 `json:"frequencyInterval,omitempty"`
	// FrequencyUnit - The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Possible values include: 'Day', 'Hour'
	FrequencyUnit FrequencyUnit `json:"frequencyUnit,omitempty"`
	// KeepAtLeastOneBackup - True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
	KeepAtLeastOneBackup *bool `json:"keepAtLeastOneBackup,omitempty"`
	// RetentionPeriodInDays - After how many days backups should be deleted.
	RetentionPeriodInDays *int32 `json:"retentionPeriodInDays,omitempty"`
	// StartTime - When the schedule should start working.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastExecutionTime - Last time when this schedule was triggered.
	LastExecutionTime *date.Time `json:"lastExecutionTime,omitempty"`
}

// BillingMeter app Service billing entity that contains information about meter which the Azure billing
// system utilizes to charge users for services.
type BillingMeter struct {
	// BillingMeterProperties - BillingMeter resource specific properties
	*BillingMeterProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BillingMeter.
func (bm BillingMeter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bm.BillingMeterProperties != nil {
		objectMap["properties"] = bm.BillingMeterProperties
	}
	if bm.ID != nil {
		objectMap["id"] = bm.ID
	}
	if bm.Name != nil {
		objectMap["name"] = bm.Name
	}
	if bm.Kind != nil {
		objectMap["kind"] = bm.Kind
	}
	if bm.Type != nil {
		objectMap["type"] = bm.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BillingMeter struct.
func (bm *BillingMeter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var billingMeterProperties BillingMeterProperties
				err = json.Unmarshal(*v, &billingMeterProperties)
				if err != nil {
					return err
				}
				bm.BillingMeterProperties = &billingMeterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bm.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bm.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bm.Type = &typeVar
			}
		}
	}

	return nil
}

// BillingMeterCollection collection of Billing Meters
type BillingMeterCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Billing Meters.
	Value *[]BillingMeter `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BillingMeterCollectionIterator provides access to a complete listing of BillingMeter values.
type BillingMeterCollectionIterator struct {
	i    int
	page BillingMeterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BillingMeterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BillingMeterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BillingMeterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BillingMeterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BillingMeterCollectionIterator) Response() BillingMeterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BillingMeterCollectionIterator) Value() BillingMeter {
	if !iter.page.NotDone() {
		return BillingMeter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BillingMeterCollectionIterator type.
func NewBillingMeterCollectionIterator(page BillingMeterCollectionPage) BillingMeterCollectionIterator {
	return BillingMeterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bmc BillingMeterCollection) IsEmpty() bool {
	return bmc.Value == nil || len(*bmc.Value) == 0
}

// billingMeterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bmc BillingMeterCollection) billingMeterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if bmc.NextLink == nil || len(to.String(bmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bmc.NextLink)))
}

// BillingMeterCollectionPage contains a page of BillingMeter values.
type BillingMeterCollectionPage struct {
	fn  func(context.Context, BillingMeterCollection) (BillingMeterCollection, error)
	bmc BillingMeterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BillingMeterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BillingMeterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bmc)
	if err != nil {
		return err
	}
	page.bmc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BillingMeterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BillingMeterCollectionPage) NotDone() bool {
	return !page.bmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BillingMeterCollectionPage) Response() BillingMeterCollection {
	return page.bmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BillingMeterCollectionPage) Values() []BillingMeter {
	if page.bmc.IsEmpty() {
		return nil
	}
	return *page.bmc.Value
}

// Creates a new instance of the BillingMeterCollectionPage type.
func NewBillingMeterCollectionPage(getNextPage func(context.Context, BillingMeterCollection) (BillingMeterCollection, error)) BillingMeterCollectionPage {
	return BillingMeterCollectionPage{fn: getNextPage}
}

// BillingMeterProperties billingMeter resource specific properties
type BillingMeterProperties struct {
	// MeterID - Meter GUID onboarded in Commerce
	MeterID *string `json:"meterId,omitempty"`
	// BillingLocation - Azure Location of billable resource
	BillingLocation *string `json:"billingLocation,omitempty"`
	// ShortName - Short Name from App Service Azure pricing Page
	ShortName *string `json:"shortName,omitempty"`
	// FriendlyName - Friendly name of the meter
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ResourceType - App Service resource type meter used for
	ResourceType *string `json:"resourceType,omitempty"`
}

// Capability describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	// Name - Name of the SKU capability.
	Name *string `json:"name,omitempty"`
	// Value - Value of the SKU capability.
	Value *string `json:"value,omitempty"`
	// Reason - Reason of the SKU capability.
	Reason *string `json:"reason,omitempty"`
}

// Certificate SSL certificate for an app.
type Certificate struct {
	autorest.Response `json:"-"`
	// CertificateProperties - Certificate resource specific properties
	*CertificateProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// CertificateCollection collection of certificates.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of Certificate values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of Certificate values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []Certificate {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{fn: getNextPage}
}

// CertificateDetails SSL certificate details.
type CertificateDetails struct {
	// Version - Certificate Version.
	Version *int32 `json:"version,omitempty"`
	// SerialNumber - Certificate Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Thumbprint - Certificate Thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - Certificate Subject.
	Subject *string `json:"subject,omitempty"`
	// NotBefore - Date Certificate is valid from.
	NotBefore *date.Time `json:"notBefore,omitempty"`
	// NotAfter - Date Certificate is valid to.
	NotAfter *date.Time `json:"notAfter,omitempty"`
	// SignatureAlgorithm - Certificate Signature algorithm.
	SignatureAlgorithm *string `json:"signatureAlgorithm,omitempty"`
	// Issuer - Certificate Issuer.
	Issuer *string `json:"issuer,omitempty"`
	// RawData - Raw certificate data.
	RawData *string `json:"rawData,omitempty"`
}

// CertificateEmail SSL certificate email.
type CertificateEmail struct {
	// CertificateEmailProperties - CertificateEmail resource specific properties
	*CertificateEmailProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateEmail.
func (ce CertificateEmail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CertificateEmailProperties != nil {
		objectMap["properties"] = ce.CertificateEmailProperties
	}
	if ce.ID != nil {
		objectMap["id"] = ce.ID
	}
	if ce.Name != nil {
		objectMap["name"] = ce.Name
	}
	if ce.Kind != nil {
		objectMap["kind"] = ce.Kind
	}
	if ce.Type != nil {
		objectMap["type"] = ce.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateEmail struct.
func (ce *CertificateEmail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateEmailProperties CertificateEmailProperties
				err = json.Unmarshal(*v, &certificateEmailProperties)
				if err != nil {
					return err
				}
				ce.CertificateEmailProperties = &certificateEmailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ce.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		}
	}

	return nil
}

// CertificateEmailProperties certificateEmail resource specific properties
type CertificateEmailProperties struct {
	// EmailID - Email id.
	EmailID *string `json:"emailId,omitempty"`
	// TimeStamp - Time stamp.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
}

// CertificateOrderAction certificate order action.
type CertificateOrderAction struct {
	// CertificateOrderActionProperties - CertificateOrderAction resource specific properties
	*CertificateOrderActionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateOrderAction.
func (coa CertificateOrderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coa.CertificateOrderActionProperties != nil {
		objectMap["properties"] = coa.CertificateOrderActionProperties
	}
	if coa.ID != nil {
		objectMap["id"] = coa.ID
	}
	if coa.Name != nil {
		objectMap["name"] = coa.Name
	}
	if coa.Kind != nil {
		objectMap["kind"] = coa.Kind
	}
	if coa.Type != nil {
		objectMap["type"] = coa.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateOrderAction struct.
func (coa *CertificateOrderAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateOrderActionProperties CertificateOrderActionProperties
				err = json.Unmarshal(*v, &certificateOrderActionProperties)
				if err != nil {
					return err
				}
				coa.CertificateOrderActionProperties = &certificateOrderActionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coa.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				coa.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coa.Type = &typeVar
			}
		}
	}

	return nil
}

// CertificateOrderActionProperties certificateOrderAction resource specific properties
type CertificateOrderActionProperties struct {
	// Type - Action type. Possible values include: 'CertificateIssued', 'CertificateOrderCanceled', 'CertificateOrderCreated', 'CertificateRevoked', 'DomainValidationComplete', 'FraudDetected', 'OrgNameChange', 'OrgValidationComplete', 'SanDrop', 'FraudCleared', 'CertificateExpired', 'CertificateExpirationWarning', 'FraudDocumentationRequired', 'Unknown'
	Type CertificateOrderActionType `json:"type,omitempty"`
	// CreatedAt - Time at which the certificate action was performed.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
}

// CertificatePatchResource ARM resource for a certificate.
type CertificatePatchResource struct {
	// CertificatePatchResourceProperties - CertificatePatchResource resource specific properties
	*CertificatePatchResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificatePatchResource.
func (cpr CertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpr.CertificatePatchResourceProperties != nil {
		objectMap["properties"] = cpr.CertificatePatchResourceProperties
	}
	if cpr.ID != nil {
		objectMap["id"] = cpr.ID
	}
	if cpr.Name != nil {
		objectMap["name"] = cpr.Name
	}
	if cpr.Kind != nil {
		objectMap["kind"] = cpr.Kind
	}
	if cpr.Type != nil {
		objectMap["type"] = cpr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificatePatchResource struct.
func (cpr *CertificatePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificatePatchResourceProperties CertificatePatchResourceProperties
				err = json.Unmarshal(*v, &certificatePatchResourceProperties)
				if err != nil {
					return err
				}
				cpr.CertificatePatchResourceProperties = &certificatePatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpr.Type = &typeVar
			}
		}
	}

	return nil
}

// CertificatePatchResourceProperties certificatePatchResource resource specific properties
type CertificatePatchResourceProperties struct {
	// FriendlyName - Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// SubjectName - Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// HostNames - Host names the certificate applies to.
	HostNames *[]string `json:"hostNames,omitempty"`
	// PfxBlob - Pfx blob.
	PfxBlob *[]byte `json:"pfxBlob,omitempty"`
	// SiteName - App name.
	SiteName *string `json:"siteName,omitempty"`
	// SelfLink - Self link.
	SelfLink *string `json:"selfLink,omitempty"`
	// Issuer - Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// IssueDate - Certificate issue Date.
	IssueDate *date.Time `json:"issueDate,omitempty"`
	// ExpirationDate - Certificate expriration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Password - Certificate password.
	Password *string `json:"password,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Valid - Is the certificate valid?.
	Valid *bool `json:"valid,omitempty"`
	// CerBlob - Raw bytes of .cer file
	CerBlob *[]byte `json:"cerBlob,omitempty"`
	// PublicKeyHash - Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// KeyVaultID - Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// KeyVaultSecretStatus - Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	KeyVaultSecretStatus KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty"`
	// GeoRegion - Region of the certificate.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
}

// CertificateProperties certificate resource specific properties
type CertificateProperties struct {
	// FriendlyName - Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// SubjectName - Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// HostNames - Host names the certificate applies to.
	HostNames *[]string `json:"hostNames,omitempty"`
	// PfxBlob - Pfx blob.
	PfxBlob *[]byte `json:"pfxBlob,omitempty"`
	// SiteName - App name.
	SiteName *string `json:"siteName,omitempty"`
	// SelfLink - Self link.
	SelfLink *string `json:"selfLink,omitempty"`
	// Issuer - Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// IssueDate - Certificate issue Date.
	IssueDate *date.Time `json:"issueDate,omitempty"`
	// ExpirationDate - Certificate expriration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Password - Certificate password.
	Password *string `json:"password,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Valid - Is the certificate valid?.
	Valid *bool `json:"valid,omitempty"`
	// CerBlob - Raw bytes of .cer file
	CerBlob *[]byte `json:"cerBlob,omitempty"`
	// PublicKeyHash - Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// KeyVaultID - Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// KeyVaultSecretStatus - Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	KeyVaultSecretStatus KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty"`
	// GeoRegion - Region of the certificate.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
}

// CloningInfo information needed for cloning operation.
type CloningInfo struct {
	// CorrelationID - Correlation ID of cloning operation. This ID ties multiple cloning operations
	// together to use the same snapshot.
	CorrelationID *uuid.UUID `json:"correlationId,omitempty"`
	// Overwrite - <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
	Overwrite *bool `json:"overwrite,omitempty"`
	// CloneCustomHostNames - <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
	CloneCustomHostNames *bool `json:"cloneCustomHostNames,omitempty"`
	// CloneSourceControl - <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
	CloneSourceControl *bool `json:"cloneSourceControl,omitempty"`
	// SourceWebAppID - ARM resource ID of the source app. App resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
	SourceWebAppID *string `json:"sourceWebAppId,omitempty"`
	// HostingEnvironment - App Service Environment.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
	// AppSettingsOverrides - Application setting overrides for cloned app. If specified, these settings override the settings cloned
	// from source app. Otherwise, application settings from source app are retained.
	AppSettingsOverrides map[string]*string `json:"appSettingsOverrides"`
	// ConfigureLoadBalancing - <code>true</code> to configure load balancing for source and destination app.
	ConfigureLoadBalancing *bool `json:"configureLoadBalancing,omitempty"`
	// TrafficManagerProfileID - ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
	TrafficManagerProfileID *string `json:"trafficManagerProfileId,omitempty"`
	// TrafficManagerProfileName - Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
	TrafficManagerProfileName *string `json:"trafficManagerProfileName,omitempty"`
	// IgnoreQuotas - <code>true</code> if quotas should be ignored; otherwise, <code>false</code>.
	IgnoreQuotas *bool `json:"ignoreQuotas,omitempty"`
}

// MarshalJSON is the custom marshaler for CloningInfo.
func (ci CloningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CorrelationID != nil {
		objectMap["correlationId"] = ci.CorrelationID
	}
	if ci.Overwrite != nil {
		objectMap["overwrite"] = ci.Overwrite
	}
	if ci.CloneCustomHostNames != nil {
		objectMap["cloneCustomHostNames"] = ci.CloneCustomHostNames
	}
	if ci.CloneSourceControl != nil {
		objectMap["cloneSourceControl"] = ci.CloneSourceControl
	}
	if ci.SourceWebAppID != nil {
		objectMap["sourceWebAppId"] = ci.SourceWebAppID
	}
	if ci.HostingEnvironment != nil {
		objectMap["hostingEnvironment"] = ci.HostingEnvironment
	}
	if ci.AppSettingsOverrides != nil {
		objectMap["appSettingsOverrides"] = ci.AppSettingsOverrides
	}
	if ci.ConfigureLoadBalancing != nil {
		objectMap["configureLoadBalancing"] = ci.ConfigureLoadBalancing
	}
	if ci.TrafficManagerProfileID != nil {
		objectMap["trafficManagerProfileId"] = ci.TrafficManagerProfileID
	}
	if ci.TrafficManagerProfileName != nil {
		objectMap["trafficManagerProfileName"] = ci.TrafficManagerProfileName
	}
	if ci.IgnoreQuotas != nil {
		objectMap["ignoreQuotas"] = ci.IgnoreQuotas
	}
	return json.Marshal(objectMap)
}

// ConnectionStringDictionary string dictionary resource.
type ConnectionStringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Connection strings.
	Properties map[string]*ConnStringValueTypePair `json:"properties"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionStringDictionary.
func (csd ConnectionStringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csd.Properties != nil {
		objectMap["properties"] = csd.Properties
	}
	if csd.ID != nil {
		objectMap["id"] = csd.ID
	}
	if csd.Name != nil {
		objectMap["name"] = csd.Name
	}
	if csd.Kind != nil {
		objectMap["kind"] = csd.Kind
	}
	if csd.Type != nil {
		objectMap["type"] = csd.Type
	}
	return json.Marshal(objectMap)
}

// ConnStringInfo database connection string information.
type ConnStringInfo struct {
	// Name - Name of connection string.
	Name *string `json:"name,omitempty"`
	// ConnectionString - Connection string value.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus', 'EventHub', 'APIHub', 'DocDb', 'RedisCache', 'PostgreSQL'
	Type ConnectionStringType `json:"type,omitempty"`
}

// ConnStringValueTypePair database connection string value to type pair.
type ConnStringValueTypePair struct {
	// Value - Value of pair.
	Value *string `json:"value,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus', 'EventHub', 'APIHub', 'DocDb', 'RedisCache', 'PostgreSQL'
	Type ConnectionStringType `json:"type,omitempty"`
}

// Contact contact information for domain registration. If 'Domain Privacy' option is not selected then the
// contact information is made publicly available through the Whois
// directories as per ICANN requirements.
type Contact struct {
	// AddressMailing - Mailing address.
	AddressMailing *Address `json:"addressMailing,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// Fax - Fax number.
	Fax *string `json:"fax,omitempty"`
	// JobTitle - Job title.
	JobTitle *string `json:"jobTitle,omitempty"`
	// NameFirst - First name.
	NameFirst *string `json:"nameFirst,omitempty"`
	// NameLast - Last name.
	NameLast *string `json:"nameLast,omitempty"`
	// NameMiddle - Middle name.
	NameMiddle *string `json:"nameMiddle,omitempty"`
	// Organization - Organization contact belongs to.
	Organization *string `json:"organization,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// ContinuousWebJob continuous Web Job Information.
type ContinuousWebJob struct {
	autorest.Response `json:"-"`
	// ContinuousWebJobProperties - ContinuousWebJob resource specific properties
	*ContinuousWebJobProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContinuousWebJob.
func (cwj ContinuousWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cwj.ContinuousWebJobProperties != nil {
		objectMap["properties"] = cwj.ContinuousWebJobProperties
	}
	if cwj.ID != nil {
		objectMap["id"] = cwj.ID
	}
	if cwj.Name != nil {
		objectMap["name"] = cwj.Name
	}
	if cwj.Kind != nil {
		objectMap["kind"] = cwj.Kind
	}
	if cwj.Type != nil {
		objectMap["type"] = cwj.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContinuousWebJob struct.
func (cwj *ContinuousWebJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var continuousWebJobProperties ContinuousWebJobProperties
				err = json.Unmarshal(*v, &continuousWebJobProperties)
				if err != nil {
					return err
				}
				cwj.ContinuousWebJobProperties = &continuousWebJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cwj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cwj.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cwj.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cwj.Type = &typeVar
			}
		}
	}

	return nil
}

// ContinuousWebJobCollection collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ContinuousWebJob `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ContinuousWebJobCollectionIterator provides access to a complete listing of ContinuousWebJob values.
type ContinuousWebJobCollectionIterator struct {
	i    int
	page ContinuousWebJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContinuousWebJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContinuousWebJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContinuousWebJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContinuousWebJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContinuousWebJobCollectionIterator) Response() ContinuousWebJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContinuousWebJobCollectionIterator) Value() ContinuousWebJob {
	if !iter.page.NotDone() {
		return ContinuousWebJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContinuousWebJobCollectionIterator type.
func NewContinuousWebJobCollectionIterator(page ContinuousWebJobCollectionPage) ContinuousWebJobCollectionIterator {
	return ContinuousWebJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cwjc ContinuousWebJobCollection) IsEmpty() bool {
	return cwjc.Value == nil || len(*cwjc.Value) == 0
}

// continuousWebJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cwjc ContinuousWebJobCollection) continuousWebJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cwjc.NextLink == nil || len(to.String(cwjc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cwjc.NextLink)))
}

// ContinuousWebJobCollectionPage contains a page of ContinuousWebJob values.
type ContinuousWebJobCollectionPage struct {
	fn   func(context.Context, ContinuousWebJobCollection) (ContinuousWebJobCollection, error)
	cwjc ContinuousWebJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContinuousWebJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContinuousWebJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cwjc)
	if err != nil {
		return err
	}
	page.cwjc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContinuousWebJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContinuousWebJobCollectionPage) NotDone() bool {
	return !page.cwjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContinuousWebJobCollectionPage) Response() ContinuousWebJobCollection {
	return page.cwjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContinuousWebJobCollectionPage) Values() []ContinuousWebJob {
	if page.cwjc.IsEmpty() {
		return nil
	}
	return *page.cwjc.Value
}

// Creates a new instance of the ContinuousWebJobCollectionPage type.
func NewContinuousWebJobCollectionPage(getNextPage func(context.Context, ContinuousWebJobCollection) (ContinuousWebJobCollection, error)) ContinuousWebJobCollectionPage {
	return ContinuousWebJobCollectionPage{fn: getNextPage}
}

// ContinuousWebJobProperties continuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	// Status - Job status. Possible values include: 'Initializing', 'Starting', 'Running', 'PendingRestart', 'Stopped'
	Status ContinuousWebJobStatus `json:"status,omitempty"`
	// DetailedStatus - Detailed status.
	DetailedStatus *string `json:"detailedStatus,omitempty"`
	// LogURL - Log URL.
	LogURL *string `json:"logUrl,omitempty"`
	// Name - Job name. Used as job identifier in ARM resource URI.
	Name *string `json:"name,omitempty"`
	// RunCommand - Run command.
	RunCommand *string `json:"runCommand,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extraInfoUrl,omitempty"`
	// JobType - Job type. Possible values include: 'Continuous', 'Triggered'
	JobType JobType `json:"jobType,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"usingSdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for ContinuousWebJobProperties.
func (cwj ContinuousWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cwj.Status != "" {
		objectMap["status"] = cwj.Status
	}
	if cwj.DetailedStatus != nil {
		objectMap["detailedStatus"] = cwj.DetailedStatus
	}
	if cwj.LogURL != nil {
		objectMap["logUrl"] = cwj.LogURL
	}
	if cwj.Name != nil {
		objectMap["name"] = cwj.Name
	}
	if cwj.RunCommand != nil {
		objectMap["runCommand"] = cwj.RunCommand
	}
	if cwj.URL != nil {
		objectMap["url"] = cwj.URL
	}
	if cwj.ExtraInfoURL != nil {
		objectMap["extraInfoUrl"] = cwj.ExtraInfoURL
	}
	if cwj.JobType != "" {
		objectMap["jobType"] = cwj.JobType
	}
	if cwj.Error != nil {
		objectMap["error"] = cwj.Error
	}
	if cwj.UsingSdk != nil {
		objectMap["usingSdk"] = cwj.UsingSdk
	}
	if cwj.Settings != nil {
		objectMap["settings"] = cwj.Settings
	}
	return json.Marshal(objectMap)
}

// CorsSettings cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	// AllowedOrigins - Gets or sets the list of origins that should be allowed to make cross-origin
	// calls (for example: http://example.com:12345). Use "*" to allow all.
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
}

// CsmMoveResourceEnvelope object with a list of the resources that need to be moved and the resource group
// they should be moved to.
type CsmMoveResourceEnvelope struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// CsmOperationCollection collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]CsmOperationDescription `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// CsmOperationCollectionIterator provides access to a complete listing of CsmOperationDescription values.
type CsmOperationCollectionIterator struct {
	i    int
	page CsmOperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CsmOperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmOperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CsmOperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CsmOperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CsmOperationCollectionIterator) Response() CsmOperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CsmOperationCollectionIterator) Value() CsmOperationDescription {
	if !iter.page.NotDone() {
		return CsmOperationDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CsmOperationCollectionIterator type.
func NewCsmOperationCollectionIterator(page CsmOperationCollectionPage) CsmOperationCollectionIterator {
	return CsmOperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (coc CsmOperationCollection) IsEmpty() bool {
	return coc.Value == nil || len(*coc.Value) == 0
}

// csmOperationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (coc CsmOperationCollection) csmOperationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if coc.NextLink == nil || len(to.String(coc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(coc.NextLink)))
}

// CsmOperationCollectionPage contains a page of CsmOperationDescription values.
type CsmOperationCollectionPage struct {
	fn  func(context.Context, CsmOperationCollection) (CsmOperationCollection, error)
	coc CsmOperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CsmOperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmOperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.coc)
	if err != nil {
		return err
	}
	page.coc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CsmOperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CsmOperationCollectionPage) NotDone() bool {
	return !page.coc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CsmOperationCollectionPage) Response() CsmOperationCollection {
	return page.coc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CsmOperationCollectionPage) Values() []CsmOperationDescription {
	if page.coc.IsEmpty() {
		return nil
	}
	return *page.coc.Value
}

// Creates a new instance of the CsmOperationCollectionPage type.
func NewCsmOperationCollectionPage(getNextPage func(context.Context, CsmOperationCollection) (CsmOperationCollection, error)) CsmOperationCollectionPage {
	return CsmOperationCollectionPage{fn: getNextPage}
}

// CsmOperationDescription description of an operation available for Microsoft.Web resource provider.
type CsmOperationDescription struct {
	Name       *string                            `json:"name,omitempty"`
	Display    *CsmOperationDisplay               `json:"display,omitempty"`
	Origin     *string                            `json:"origin,omitempty"`
	Properties *CsmOperationDescriptionProperties `json:"properties,omitempty"`
}

// CsmOperationDescriptionProperties properties available for a Microsoft.Web resource provider operation.
type CsmOperationDescriptionProperties struct {
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// CsmOperationDisplay meta data about operation used for display in portal.
type CsmOperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// CsmPublishingProfileOptions publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	// Format - Name of the format. Valid values are:
	// FileZilla3
	// WebDeploy -- default
	// Ftp. Possible values include: 'FileZilla3', 'WebDeploy', 'Ftp'
	Format PublishingProfileFormat `json:"format,omitempty"`
}

// CsmSlotEntity deployment slot parameters.
type CsmSlotEntity struct {
	// TargetSlot - Destination deployment slot during swap operation.
	TargetSlot *string `json:"targetSlot,omitempty"`
	// PreserveVnet - <code>true</code> to preserve Virtual Network to the slot during swap; otherwise, <code>false</code>.
	PreserveVnet *bool `json:"preserveVnet,omitempty"`
}

// CsmUsageQuota usage of the quota resource.
type CsmUsageQuota struct {
	// Unit - Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - Next reset time for the resource counter.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// CurrentValue - The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The resource limit.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Quota name.
	Name *LocalizableString `json:"name,omitempty"`
}

// CsmUsageQuotaCollection collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]CsmUsageQuota `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// CsmUsageQuotaCollectionIterator provides access to a complete listing of CsmUsageQuota values.
type CsmUsageQuotaCollectionIterator struct {
	i    int
	page CsmUsageQuotaCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CsmUsageQuotaCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CsmUsageQuotaCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CsmUsageQuotaCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CsmUsageQuotaCollectionIterator) Response() CsmUsageQuotaCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CsmUsageQuotaCollectionIterator) Value() CsmUsageQuota {
	if !iter.page.NotDone() {
		return CsmUsageQuota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CsmUsageQuotaCollectionIterator type.
func NewCsmUsageQuotaCollectionIterator(page CsmUsageQuotaCollectionPage) CsmUsageQuotaCollectionIterator {
	return CsmUsageQuotaCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cuqc CsmUsageQuotaCollection) IsEmpty() bool {
	return cuqc.Value == nil || len(*cuqc.Value) == 0
}

// csmUsageQuotaCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cuqc CsmUsageQuotaCollection) csmUsageQuotaCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cuqc.NextLink == nil || len(to.String(cuqc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cuqc.NextLink)))
}

// CsmUsageQuotaCollectionPage contains a page of CsmUsageQuota values.
type CsmUsageQuotaCollectionPage struct {
	fn   func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)
	cuqc CsmUsageQuotaCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CsmUsageQuotaCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cuqc)
	if err != nil {
		return err
	}
	page.cuqc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CsmUsageQuotaCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CsmUsageQuotaCollectionPage) NotDone() bool {
	return !page.cuqc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CsmUsageQuotaCollectionPage) Response() CsmUsageQuotaCollection {
	return page.cuqc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CsmUsageQuotaCollectionPage) Values() []CsmUsageQuota {
	if page.cuqc.IsEmpty() {
		return nil
	}
	return *page.cuqc.Value
}

// Creates a new instance of the CsmUsageQuotaCollectionPage type.
func NewCsmUsageQuotaCollectionPage(getNextPage func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)) CsmUsageQuotaCollectionPage {
	return CsmUsageQuotaCollectionPage{fn: getNextPage}
}

// CustomHostnameAnalysisResult custom domain analysis.
type CustomHostnameAnalysisResult struct {
	autorest.Response `json:"-"`
	// CustomHostnameAnalysisResultProperties - CustomHostnameAnalysisResult resource specific properties
	*CustomHostnameAnalysisResultProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomHostnameAnalysisResult.
func (char CustomHostnameAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if char.CustomHostnameAnalysisResultProperties != nil {
		objectMap["properties"] = char.CustomHostnameAnalysisResultProperties
	}
	if char.ID != nil {
		objectMap["id"] = char.ID
	}
	if char.Name != nil {
		objectMap["name"] = char.Name
	}
	if char.Kind != nil {
		objectMap["kind"] = char.Kind
	}
	if char.Type != nil {
		objectMap["type"] = char.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomHostnameAnalysisResult struct.
func (char *CustomHostnameAnalysisResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customHostnameAnalysisResultProperties CustomHostnameAnalysisResultProperties
				err = json.Unmarshal(*v, &customHostnameAnalysisResultProperties)
				if err != nil {
					return err
				}
				char.CustomHostnameAnalysisResultProperties = &customHostnameAnalysisResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				char.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				char.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				char.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				char.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomHostnameAnalysisResultProperties customHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	// IsHostnameAlreadyVerified - <code>true</code> if hostname is already verified; otherwise, <code>false</code>.
	IsHostnameAlreadyVerified *bool `json:"isHostnameAlreadyVerified,omitempty"`
	// CustomDomainVerificationTest - DNS verification test result. Possible values include: 'DNSVerificationTestResultPassed', 'DNSVerificationTestResultFailed', 'DNSVerificationTestResultSkipped'
	CustomDomainVerificationTest DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty"`
	// CustomDomainVerificationFailureInfo - Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *ErrorEntity `json:"customDomainVerificationFailureInfo,omitempty"`
	// HasConflictOnScaleUnit - <code>true</code> if there is a conflict on a scale unit; otherwise, <code>false</code>.
	HasConflictOnScaleUnit *bool `json:"hasConflictOnScaleUnit,omitempty"`
	// HasConflictAcrossSubscription - <code>true</code> if htere is a conflict across subscriptions; otherwise, <code>false</code>.
	HasConflictAcrossSubscription *bool `json:"hasConflictAcrossSubscription,omitempty"`
	// ConflictingAppResourceID - Name of the conflicting app on scale unit if it's within the same subscription.
	ConflictingAppResourceID *string `json:"conflictingAppResourceId,omitempty"`
	// CNameRecords - CName records controller can see for this hostname.
	CNameRecords *[]string `json:"cNameRecords,omitempty"`
	// TxtRecords - TXT records controller can see for this hostname.
	TxtRecords *[]string `json:"txtRecords,omitempty"`
	// ARecords - A records controller can see for this hostname.
	ARecords *[]string `json:"aRecords,omitempty"`
	// AlternateCNameRecords - Alternate CName records controller can see for this hostname.
	AlternateCNameRecords *[]string `json:"alternateCNameRecords,omitempty"`
	// AlternateTxtRecords - Alternate TXT records controller can see for this hostname.
	AlternateTxtRecords *[]string `json:"alternateTxtRecords,omitempty"`
}

// DatabaseBackupSetting database backup settings.
type DatabaseBackupSetting struct {
	// DatabaseType - Database type (e.g. SqlAzure / MySql). Possible values include: 'DatabaseTypeSQLAzure', 'DatabaseTypeMySQL', 'DatabaseTypeLocalMySQL', 'DatabaseTypePostgreSQL'
	DatabaseType DatabaseType `json:"databaseType,omitempty"`
	Name         *string      `json:"name,omitempty"`
	// ConnectionStringName - Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
	// This is used during restore with overwrite connection strings options.
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	// ConnectionString - Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
	ConnectionString *string `json:"connectionString,omitempty"`
}

// DataSource class representing data source used by the detectors
type DataSource struct {
	// Instructions - Instrunctions if any for the data source
	Instructions *[]string `json:"instructions,omitempty"`
	// DataSourceURI - Datasource Uri Links
	DataSourceURI *[]NameValuePair `json:"dataSourceUri,omitempty"`
}

// DataTableResponseColumn column definition
type DataTableResponseColumn struct {
	// ColumnName - Name of the column
	ColumnName *string `json:"columnName,omitempty"`
	// DataType - Data type which looks like 'String' or 'Int32'.
	DataType *string `json:"dataType,omitempty"`
	// ColumnType - Column Type
	ColumnType *string `json:"columnType,omitempty"`
}

// DataTableResponseObject data Table which defines columns and raw row values
type DataTableResponseObject struct {
	// TableName - Name of the table
	TableName *string `json:"tableName,omitempty"`
	// Columns - List of columns with data types
	Columns *[]DataTableResponseColumn `json:"columns,omitempty"`
	// Rows - Raw row values
	Rows *[][]string `json:"rows,omitempty"`
}

// DefaultErrorResponse app Service error response.
type DefaultErrorResponse struct {
	// Error - Error model.
	Error *DefaultErrorResponseError `json:"error,omitempty"`
}

// DefaultErrorResponseError error model.
type DefaultErrorResponseError struct {
	// Code - Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - Detailed error description and debugging information.
	Message *string `json:"message,omitempty"`
	// Target - Detailed error description and debugging information.
	Target  *string                                 `json:"target,omitempty"`
	Details *[]DefaultErrorResponseErrorDetailsItem `json:"details,omitempty"`
	// Innererror - More information to debug error.
	Innererror *string `json:"innererror,omitempty"`
}

// DefaultErrorResponseErrorDetailsItem detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// Code - Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - Detailed error description and debugging information.
	Message *string `json:"message,omitempty"`
	// Target - Detailed error description and debugging information.
	Target *string `json:"target,omitempty"`
}

// DeletedSite a deleted app.
type DeletedSite struct {
	// ID - Numeric id for the deleted site
	ID *int32 `json:"id,omitempty"`
	// DeletedTimestamp - Time in UTC when the app was deleted.
	DeletedTimestamp *string `json:"deletedTimestamp,omitempty"`
	// Subscription - Subscription containing the deleted site
	Subscription *string `json:"subscription,omitempty"`
	// ResourceGroup - ResourceGroup that contained the deleted site
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Name - Name of the deleted site
	Name *string `json:"name,omitempty"`
	// Slot - Slot of the deleted site
	Slot *string `json:"slot,omitempty"`
}

// DeletedWebAppCollection collection of deleted apps.
type DeletedWebAppCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DeletedSite `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedWebAppCollectionIterator provides access to a complete listing of DeletedSite values.
type DeletedWebAppCollectionIterator struct {
	i    int
	page DeletedWebAppCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedWebAppCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedWebAppCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedWebAppCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedWebAppCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedWebAppCollectionIterator) Response() DeletedWebAppCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedWebAppCollectionIterator) Value() DeletedSite {
	if !iter.page.NotDone() {
		return DeletedSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedWebAppCollectionIterator type.
func NewDeletedWebAppCollectionIterator(page DeletedWebAppCollectionPage) DeletedWebAppCollectionIterator {
	return DeletedWebAppCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dwac DeletedWebAppCollection) IsEmpty() bool {
	return dwac.Value == nil || len(*dwac.Value) == 0
}

// deletedWebAppCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dwac DeletedWebAppCollection) deletedWebAppCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dwac.NextLink == nil || len(to.String(dwac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dwac.NextLink)))
}

// DeletedWebAppCollectionPage contains a page of DeletedSite values.
type DeletedWebAppCollectionPage struct {
	fn   func(context.Context, DeletedWebAppCollection) (DeletedWebAppCollection, error)
	dwac DeletedWebAppCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedWebAppCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedWebAppCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dwac)
	if err != nil {
		return err
	}
	page.dwac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedWebAppCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedWebAppCollectionPage) NotDone() bool {
	return !page.dwac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedWebAppCollectionPage) Response() DeletedWebAppCollection {
	return page.dwac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedWebAppCollectionPage) Values() []DeletedSite {
	if page.dwac.IsEmpty() {
		return nil
	}
	return *page.dwac.Value
}

// Creates a new instance of the DeletedWebAppCollectionPage type.
func NewDeletedWebAppCollectionPage(getNextPage func(context.Context, DeletedWebAppCollection) (DeletedWebAppCollection, error)) DeletedWebAppCollectionPage {
	return DeletedWebAppCollectionPage{fn: getNextPage}
}

// Deployment user crendentials used for publishing activity.
type Deployment struct {
	autorest.Response `json:"-"`
	// DeploymentProperties - Deployment resource specific properties
	*DeploymentProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DeploymentProperties != nil {
		objectMap["properties"] = d.DeploymentProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Deployment struct.
func (d *Deployment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deploymentProperties DeploymentProperties
				err = json.Unmarshal(*v, &deploymentProperties)
				if err != nil {
					return err
				}
				d.DeploymentProperties = &deploymentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DeploymentCollection collection of app deployments.
type DeploymentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Deployment `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentCollectionIterator provides access to a complete listing of Deployment values.
type DeploymentCollectionIterator struct {
	i    int
	page DeploymentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentCollectionIterator) Response() DeploymentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentCollectionIterator) Value() Deployment {
	if !iter.page.NotDone() {
		return Deployment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentCollectionIterator type.
func NewDeploymentCollectionIterator(page DeploymentCollectionPage) DeploymentCollectionIterator {
	return DeploymentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DeploymentCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// deploymentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DeploymentCollection) deploymentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dc.NextLink == nil || len(to.String(dc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DeploymentCollectionPage contains a page of Deployment values.
type DeploymentCollectionPage struct {
	fn func(context.Context, DeploymentCollection) (DeploymentCollection, error)
	dc DeploymentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dc)
	if err != nil {
		return err
	}
	page.dc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentCollectionPage) Response() DeploymentCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentCollectionPage) Values() []Deployment {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DeploymentCollectionPage type.
func NewDeploymentCollectionPage(getNextPage func(context.Context, DeploymentCollection) (DeploymentCollection, error)) DeploymentCollectionPage {
	return DeploymentCollectionPage{fn: getNextPage}
}

// DeploymentLocations list of available locations (regions or App Service Environments) for
// deployment of App Service resources.
type DeploymentLocations struct {
	autorest.Response `json:"-"`
	// Locations - Available regions.
	Locations *[]GeoRegion `json:"locations,omitempty"`
	// HostingEnvironments - Available App Service Environments with full descriptions of the environments.
	HostingEnvironments *[]AppServiceEnvironment `json:"hostingEnvironments,omitempty"`
	// HostingEnvironmentDeploymentInfos - Available App Service Environments with basic information.
	HostingEnvironmentDeploymentInfos *[]HostingEnvironmentDeploymentInfo `json:"hostingEnvironmentDeploymentInfos,omitempty"`
}

// DeploymentProperties deployment resource specific properties
type DeploymentProperties struct {
	// ID - Identifier for deployment.
	ID *string `json:"id,omitempty"`
	// Status - Deployment status.
	Status *int32 `json:"status,omitempty"`
	// Message - Details about deployment status.
	Message *string `json:"message,omitempty"`
	// Author - Who authored the deployment.
	Author *string `json:"author,omitempty"`
	// Deployer - Who performed the deployment.
	Deployer *string `json:"deployer,omitempty"`
	// AuthorEmail - Author email.
	AuthorEmail *string `json:"authorEmail,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Active - True if deployment is currently active, false if completed and null if not started.
	Active *bool `json:"active,omitempty"`
	// Details - Details on deployment.
	Details *string `json:"details,omitempty"`
}

// DetectorAbnormalTimePeriod class representing Abnormal Time Period detected.
type DetectorAbnormalTimePeriod struct {
	// StartTime - Start time of the corelated event
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the corelated event
	EndTime *date.Time `json:"endTime,omitempty"`
	// Message - Message describing the event
	Message *string `json:"message,omitempty"`
	// Source - Represents the name of the Detector
	Source *string `json:"source,omitempty"`
	// Priority - Represents the rank of the Detector
	Priority *float64 `json:"priority,omitempty"`
	// MetaData - Downtime metadata
	MetaData *[][]NameValuePair `json:"metaData,omitempty"`
	// Type - Represents the type of the Detector. Possible values include: 'ServiceIncident', 'AppDeployment', 'AppCrash', 'RuntimeIssueDetected', 'AseDeployment', 'UserIssue', 'PlatformIssue', 'Other'
	Type IssueType `json:"type,omitempty"`
	// Solutions - List of proposed solutions
	Solutions *[]Solution `json:"solutions,omitempty"`
}

// DetectorDefinition class representing detector definition
type DetectorDefinition struct {
	// DetectorDefinitionProperties - DetectorDefinition resource specific properties
	*DetectorDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DetectorDefinition.
func (dd DetectorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dd.DetectorDefinitionProperties != nil {
		objectMap["properties"] = dd.DetectorDefinitionProperties
	}
	if dd.ID != nil {
		objectMap["id"] = dd.ID
	}
	if dd.Name != nil {
		objectMap["name"] = dd.Name
	}
	if dd.Kind != nil {
		objectMap["kind"] = dd.Kind
	}
	if dd.Type != nil {
		objectMap["type"] = dd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DetectorDefinition struct.
func (dd *DetectorDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var detectorDefinitionProperties DetectorDefinitionProperties
				err = json.Unmarshal(*v, &detectorDefinitionProperties)
				if err != nil {
					return err
				}
				dd.DetectorDefinitionProperties = &detectorDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dd.Type = &typeVar
			}
		}
	}

	return nil
}

// DetectorDefinitionProperties detectorDefinition resource specific properties
type DetectorDefinitionProperties struct {
	// DisplayName - Display name of the detector
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the detector
	Description *string `json:"description,omitempty"`
	// Rank - Detector Rank
	Rank *float64 `json:"rank,omitempty"`
	// IsEnabled - Flag representing whether detector is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// DetectorInfo definition of Detector
type DetectorInfo struct {
	// Description - Short description of the detector and its purpose
	Description *string `json:"description,omitempty"`
	// Category - Support Category
	Category *string `json:"category,omitempty"`
	// SubCategory - Support Sub Category
	SubCategory *string `json:"subCategory,omitempty"`
	// SupportTopicID - Support Topic Id
	SupportTopicID *string `json:"supportTopicId,omitempty"`
}

// DetectorResponse class representing Response from Detector
type DetectorResponse struct {
	autorest.Response `json:"-"`
	// DetectorResponseProperties - DetectorResponse resource specific properties
	*DetectorResponseProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DetectorResponse.
func (dr DetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dr.DetectorResponseProperties != nil {
		objectMap["properties"] = dr.DetectorResponseProperties
	}
	if dr.ID != nil {
		objectMap["id"] = dr.ID
	}
	if dr.Name != nil {
		objectMap["name"] = dr.Name
	}
	if dr.Kind != nil {
		objectMap["kind"] = dr.Kind
	}
	if dr.Type != nil {
		objectMap["type"] = dr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DetectorResponse struct.
func (dr *DetectorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var detectorResponseProperties DetectorResponseProperties
				err = json.Unmarshal(*v, &detectorResponseProperties)
				if err != nil {
					return err
				}
				dr.DetectorResponseProperties = &detectorResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dr.Type = &typeVar
			}
		}
	}

	return nil
}

// DetectorResponseCollection collection of detector responses
type DetectorResponseCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DetectorResponse `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DetectorResponseCollectionIterator provides access to a complete listing of DetectorResponse values.
type DetectorResponseCollectionIterator struct {
	i    int
	page DetectorResponseCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DetectorResponseCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DetectorResponseCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DetectorResponseCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DetectorResponseCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DetectorResponseCollectionIterator) Response() DetectorResponseCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DetectorResponseCollectionIterator) Value() DetectorResponse {
	if !iter.page.NotDone() {
		return DetectorResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DetectorResponseCollectionIterator type.
func NewDetectorResponseCollectionIterator(page DetectorResponseCollectionPage) DetectorResponseCollectionIterator {
	return DetectorResponseCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (drc DetectorResponseCollection) IsEmpty() bool {
	return drc.Value == nil || len(*drc.Value) == 0
}

// detectorResponseCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (drc DetectorResponseCollection) detectorResponseCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if drc.NextLink == nil || len(to.String(drc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(drc.NextLink)))
}

// DetectorResponseCollectionPage contains a page of DetectorResponse values.
type DetectorResponseCollectionPage struct {
	fn  func(context.Context, DetectorResponseCollection) (DetectorResponseCollection, error)
	drc DetectorResponseCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DetectorResponseCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DetectorResponseCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.drc)
	if err != nil {
		return err
	}
	page.drc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DetectorResponseCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DetectorResponseCollectionPage) NotDone() bool {
	return !page.drc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DetectorResponseCollectionPage) Response() DetectorResponseCollection {
	return page.drc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DetectorResponseCollectionPage) Values() []DetectorResponse {
	if page.drc.IsEmpty() {
		return nil
	}
	return *page.drc.Value
}

// Creates a new instance of the DetectorResponseCollectionPage type.
func NewDetectorResponseCollectionPage(getNextPage func(context.Context, DetectorResponseCollection) (DetectorResponseCollection, error)) DetectorResponseCollectionPage {
	return DetectorResponseCollectionPage{fn: getNextPage}
}

// DetectorResponseProperties detectorResponse resource specific properties
type DetectorResponseProperties struct {
	// Metadata - metadata for the detector
	Metadata *DetectorInfo `json:"metadata,omitempty"`
	// Dataset - Data Set
	Dataset *[]DiagnosticData `json:"dataset,omitempty"`
}

// DiagnosticAnalysis class representing a diagnostic analysis done on an application
type DiagnosticAnalysis struct {
	autorest.Response `json:"-"`
	// DiagnosticAnalysisProperties - DiagnosticAnalysis resource specific properties
	*DiagnosticAnalysisProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticAnalysis.
func (da DiagnosticAnalysis) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.DiagnosticAnalysisProperties != nil {
		objectMap["properties"] = da.DiagnosticAnalysisProperties
	}
	if da.ID != nil {
		objectMap["id"] = da.ID
	}
	if da.Name != nil {
		objectMap["name"] = da.Name
	}
	if da.Kind != nil {
		objectMap["kind"] = da.Kind
	}
	if da.Type != nil {
		objectMap["type"] = da.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticAnalysis struct.
func (da *DiagnosticAnalysis) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticAnalysisProperties DiagnosticAnalysisProperties
				err = json.Unmarshal(*v, &diagnosticAnalysisProperties)
				if err != nil {
					return err
				}
				da.DiagnosticAnalysisProperties = &diagnosticAnalysisProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				da.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticAnalysisCollection collection of Diagnostic Analyses
type DiagnosticAnalysisCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AnalysisDefinition `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiagnosticAnalysisCollectionIterator provides access to a complete listing of AnalysisDefinition values.
type DiagnosticAnalysisCollectionIterator struct {
	i    int
	page DiagnosticAnalysisCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticAnalysisCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticAnalysisCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticAnalysisCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticAnalysisCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticAnalysisCollectionIterator) Response() DiagnosticAnalysisCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticAnalysisCollectionIterator) Value() AnalysisDefinition {
	if !iter.page.NotDone() {
		return AnalysisDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticAnalysisCollectionIterator type.
func NewDiagnosticAnalysisCollectionIterator(page DiagnosticAnalysisCollectionPage) DiagnosticAnalysisCollectionIterator {
	return DiagnosticAnalysisCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dac DiagnosticAnalysisCollection) IsEmpty() bool {
	return dac.Value == nil || len(*dac.Value) == 0
}

// diagnosticAnalysisCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dac DiagnosticAnalysisCollection) diagnosticAnalysisCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dac.NextLink == nil || len(to.String(dac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dac.NextLink)))
}

// DiagnosticAnalysisCollectionPage contains a page of AnalysisDefinition values.
type DiagnosticAnalysisCollectionPage struct {
	fn  func(context.Context, DiagnosticAnalysisCollection) (DiagnosticAnalysisCollection, error)
	dac DiagnosticAnalysisCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticAnalysisCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticAnalysisCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dac)
	if err != nil {
		return err
	}
	page.dac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticAnalysisCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticAnalysisCollectionPage) NotDone() bool {
	return !page.dac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticAnalysisCollectionPage) Response() DiagnosticAnalysisCollection {
	return page.dac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticAnalysisCollectionPage) Values() []AnalysisDefinition {
	if page.dac.IsEmpty() {
		return nil
	}
	return *page.dac.Value
}

// Creates a new instance of the DiagnosticAnalysisCollectionPage type.
func NewDiagnosticAnalysisCollectionPage(getNextPage func(context.Context, DiagnosticAnalysisCollection) (DiagnosticAnalysisCollection, error)) DiagnosticAnalysisCollectionPage {
	return DiagnosticAnalysisCollectionPage{fn: getNextPage}
}

// DiagnosticAnalysisProperties diagnosticAnalysis resource specific properties
type DiagnosticAnalysisProperties struct {
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// AbnormalTimePeriods - List of time periods.
	AbnormalTimePeriods *[]AbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`
	// Payload - Data by each detector
	Payload *[]AnalysisData `json:"payload,omitempty"`
	// NonCorrelatedDetectors - Data by each detector for detectors that did not corelate
	NonCorrelatedDetectors *[]DetectorDefinition `json:"nonCorrelatedDetectors,omitempty"`
}

// DiagnosticCategory class representing detector definition
type DiagnosticCategory struct {
	autorest.Response `json:"-"`
	// DiagnosticCategoryProperties - DiagnosticCategory resource specific properties
	*DiagnosticCategoryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticCategory.
func (dc DiagnosticCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DiagnosticCategoryProperties != nil {
		objectMap["properties"] = dc.DiagnosticCategoryProperties
	}
	if dc.ID != nil {
		objectMap["id"] = dc.ID
	}
	if dc.Name != nil {
		objectMap["name"] = dc.Name
	}
	if dc.Kind != nil {
		objectMap["kind"] = dc.Kind
	}
	if dc.Type != nil {
		objectMap["type"] = dc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticCategory struct.
func (dc *DiagnosticCategory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticCategoryProperties DiagnosticCategoryProperties
				err = json.Unmarshal(*v, &diagnosticCategoryProperties)
				if err != nil {
					return err
				}
				dc.DiagnosticCategoryProperties = &diagnosticCategoryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticCategoryCollection collection of Diagnostic Categories
type DiagnosticCategoryCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DiagnosticCategory `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiagnosticCategoryCollectionIterator provides access to a complete listing of DiagnosticCategory values.
type DiagnosticCategoryCollectionIterator struct {
	i    int
	page DiagnosticCategoryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticCategoryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCategoryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticCategoryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticCategoryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticCategoryCollectionIterator) Response() DiagnosticCategoryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticCategoryCollectionIterator) Value() DiagnosticCategory {
	if !iter.page.NotDone() {
		return DiagnosticCategory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticCategoryCollectionIterator type.
func NewDiagnosticCategoryCollectionIterator(page DiagnosticCategoryCollectionPage) DiagnosticCategoryCollectionIterator {
	return DiagnosticCategoryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcc DiagnosticCategoryCollection) IsEmpty() bool {
	return dcc.Value == nil || len(*dcc.Value) == 0
}

// diagnosticCategoryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcc DiagnosticCategoryCollection) diagnosticCategoryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dcc.NextLink == nil || len(to.String(dcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcc.NextLink)))
}

// DiagnosticCategoryCollectionPage contains a page of DiagnosticCategory values.
type DiagnosticCategoryCollectionPage struct {
	fn  func(context.Context, DiagnosticCategoryCollection) (DiagnosticCategoryCollection, error)
	dcc DiagnosticCategoryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticCategoryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCategoryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dcc)
	if err != nil {
		return err
	}
	page.dcc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticCategoryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticCategoryCollectionPage) NotDone() bool {
	return !page.dcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticCategoryCollectionPage) Response() DiagnosticCategoryCollection {
	return page.dcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticCategoryCollectionPage) Values() []DiagnosticCategory {
	if page.dcc.IsEmpty() {
		return nil
	}
	return *page.dcc.Value
}

// Creates a new instance of the DiagnosticCategoryCollectionPage type.
func NewDiagnosticCategoryCollectionPage(getNextPage func(context.Context, DiagnosticCategoryCollection) (DiagnosticCategoryCollection, error)) DiagnosticCategoryCollectionPage {
	return DiagnosticCategoryCollectionPage{fn: getNextPage}
}

// DiagnosticCategoryProperties diagnosticCategory resource specific properties
type DiagnosticCategoryProperties struct {
	// Description - Description of the diagnostic category
	Description *string `json:"description,omitempty"`
}

// DiagnosticData set of data with rendering instructions
type DiagnosticData struct {
	// Table - Data in table form
	Table *DataTableResponseObject `json:"table,omitempty"`
	// RenderingProperties - Properties that describe how the table should be rendered
	RenderingProperties *Rendering `json:"renderingProperties,omitempty"`
}

// DiagnosticDetectorCollection collection of Diagnostic Detectors
type DiagnosticDetectorCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DetectorDefinition `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiagnosticDetectorCollectionIterator provides access to a complete listing of DetectorDefinition values.
type DiagnosticDetectorCollectionIterator struct {
	i    int
	page DiagnosticDetectorCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticDetectorCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticDetectorCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticDetectorCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticDetectorCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticDetectorCollectionIterator) Response() DiagnosticDetectorCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticDetectorCollectionIterator) Value() DetectorDefinition {
	if !iter.page.NotDone() {
		return DetectorDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticDetectorCollectionIterator type.
func NewDiagnosticDetectorCollectionIterator(page DiagnosticDetectorCollectionPage) DiagnosticDetectorCollectionIterator {
	return DiagnosticDetectorCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ddc DiagnosticDetectorCollection) IsEmpty() bool {
	return ddc.Value == nil || len(*ddc.Value) == 0
}

// diagnosticDetectorCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ddc DiagnosticDetectorCollection) diagnosticDetectorCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ddc.NextLink == nil || len(to.String(ddc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ddc.NextLink)))
}

// DiagnosticDetectorCollectionPage contains a page of DetectorDefinition values.
type DiagnosticDetectorCollectionPage struct {
	fn  func(context.Context, DiagnosticDetectorCollection) (DiagnosticDetectorCollection, error)
	ddc DiagnosticDetectorCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticDetectorCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticDetectorCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ddc)
	if err != nil {
		return err
	}
	page.ddc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticDetectorCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticDetectorCollectionPage) NotDone() bool {
	return !page.ddc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticDetectorCollectionPage) Response() DiagnosticDetectorCollection {
	return page.ddc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticDetectorCollectionPage) Values() []DetectorDefinition {
	if page.ddc.IsEmpty() {
		return nil
	}
	return *page.ddc.Value
}

// Creates a new instance of the DiagnosticDetectorCollectionPage type.
func NewDiagnosticDetectorCollectionPage(getNextPage func(context.Context, DiagnosticDetectorCollection) (DiagnosticDetectorCollection, error)) DiagnosticDetectorCollectionPage {
	return DiagnosticDetectorCollectionPage{fn: getNextPage}
}

// DiagnosticDetectorResponse class representing Reponse from Diagnostic Detectors
type DiagnosticDetectorResponse struct {
	autorest.Response `json:"-"`
	// DiagnosticDetectorResponseProperties - DiagnosticDetectorResponse resource specific properties
	*DiagnosticDetectorResponseProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticDetectorResponse.
func (ddr DiagnosticDetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ddr.DiagnosticDetectorResponseProperties != nil {
		objectMap["properties"] = ddr.DiagnosticDetectorResponseProperties
	}
	if ddr.ID != nil {
		objectMap["id"] = ddr.ID
	}
	if ddr.Name != nil {
		objectMap["name"] = ddr.Name
	}
	if ddr.Kind != nil {
		objectMap["kind"] = ddr.Kind
	}
	if ddr.Type != nil {
		objectMap["type"] = ddr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticDetectorResponse struct.
func (ddr *DiagnosticDetectorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticDetectorResponseProperties DiagnosticDetectorResponseProperties
				err = json.Unmarshal(*v, &diagnosticDetectorResponseProperties)
				if err != nil {
					return err
				}
				ddr.DiagnosticDetectorResponseProperties = &diagnosticDetectorResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ddr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ddr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ddr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ddr.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticDetectorResponseProperties diagnosticDetectorResponse resource specific properties
type DiagnosticDetectorResponseProperties struct {
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// IssueDetected - Flag representing Issue was detected.
	IssueDetected *bool `json:"issueDetected,omitempty"`
	// DetectorDefinition - Detector's definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`
	// Metrics - Metrics provided by the detector
	Metrics *[]DiagnosticMetricSet `json:"metrics,omitempty"`
	// AbnormalTimePeriods - List of Correlated events found by the detector
	AbnormalTimePeriods *[]DetectorAbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`
	// Data - Additional Data that detector wants to send.
	Data *[][]NameValuePair `json:"data,omitempty"`
	// ResponseMetaData - Meta Data
	ResponseMetaData *ResponseMetaData `json:"responseMetaData,omitempty"`
}

// DiagnosticMetricSample class representing Diagnostic Metric
type DiagnosticMetricSample struct {
	// Timestamp - Time at which metric is measured
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// RoleInstance - Role Instance. Null if this counter is not per instance
	// This is returned and should be whichever instance name we desire to be returned
	// i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
	// where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis
	RoleInstance *string `json:"roleInstance,omitempty"`
	// Total - Total value of the metric. If multiple measurements are made this will have sum of all.
	Total *float64 `json:"total,omitempty"`
	// Maximum - Maximum of the metric sampled during the time period
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - Minimum of the metric sampled during the time period
	Minimum *float64 `json:"minimum,omitempty"`
	// IsAggregated - Whether the values are aggregates across all workers or not
	IsAggregated *bool `json:"isAggregated,omitempty"`
}

// DiagnosticMetricSet class representing Diagnostic Metric information
type DiagnosticMetricSet struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// Unit - Metric's unit
	Unit *string `json:"unit,omitempty"`
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Values - Collection of metric values for the selected period based on the {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}
	Values *[]DiagnosticMetricSample `json:"values,omitempty"`
}

// Dimension dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
// where instance name is dimension of the metric HTTP request
type Dimension struct {
	Name                   *string `json:"name,omitempty"`
	DisplayName            *string `json:"displayName,omitempty"`
	InternalName           *string `json:"internalName,omitempty"`
	ToBeExportedForShoebox *bool   `json:"toBeExportedForShoebox,omitempty"`
}

// Domain information about a domain.
type Domain struct {
	autorest.Response `json:"-"`
	// DomainProperties - Domain resource specific properties
	*DomainProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DomainProperties != nil {
		objectMap["properties"] = d.DomainProperties
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Domain struct.
func (d *Domain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainProperties DomainProperties
				err = json.Unmarshal(*v, &domainProperties)
				if err != nil {
					return err
				}
				d.DomainProperties = &domainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		}
	}

	return nil
}

// DomainAvailablilityCheckResult domain availablility check result.
type DomainAvailablilityCheckResult struct {
	autorest.Response `json:"-"`
	// Name - Name of the domain.
	Name *string `json:"name,omitempty"`
	// Available - <code>true</code> if domain can be purchased using CreateDomain API; otherwise, <code>false</code>.
	Available *bool `json:"available,omitempty"`
	// DomainType - Valid values are Regular domain: Azure will charge the full price of domain registration, SoftDeleted: Purchasing this domain will simply restore it and this operation will not cost anything. Possible values include: 'Regular', 'SoftDeleted'
	DomainType DomainType `json:"domainType,omitempty"`
}

// DomainCollection collection of domains.
type DomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Domain `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DomainCollectionIterator provides access to a complete listing of Domain values.
type DomainCollectionIterator struct {
	i    int
	page DomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainCollectionIterator) Response() DomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainCollectionIterator) Value() Domain {
	if !iter.page.NotDone() {
		return Domain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainCollectionIterator type.
func NewDomainCollectionIterator(page DomainCollectionPage) DomainCollectionIterator {
	return DomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DomainCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// domainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DomainCollection) domainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dc.NextLink == nil || len(to.String(dc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DomainCollectionPage contains a page of Domain values.
type DomainCollectionPage struct {
	fn func(context.Context, DomainCollection) (DomainCollection, error)
	dc DomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dc)
	if err != nil {
		return err
	}
	page.dc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainCollectionPage) Response() DomainCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainCollectionPage) Values() []Domain {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DomainCollectionPage type.
func NewDomainCollectionPage(getNextPage func(context.Context, DomainCollection) (DomainCollection, error)) DomainCollectionPage {
	return DomainCollectionPage{fn: getNextPage}
}

// DomainControlCenterSsoRequest single sign-on request information for domain management.
type DomainControlCenterSsoRequest struct {
	autorest.Response `json:"-"`
	// URL - URL where the single sign-on request is to be made.
	URL *string `json:"url,omitempty"`
	// PostParameterKey - Post parameter key.
	PostParameterKey *string `json:"postParameterKey,omitempty"`
	// PostParameterValue - Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
	PostParameterValue *string `json:"postParameterValue,omitempty"`
}

// DomainOwnershipIdentifier domain ownership Identifier.
type DomainOwnershipIdentifier struct {
	autorest.Response `json:"-"`
	// DomainOwnershipIdentifierProperties - DomainOwnershipIdentifier resource specific properties
	*DomainOwnershipIdentifierProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainOwnershipIdentifier.
func (doi DomainOwnershipIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if doi.DomainOwnershipIdentifierProperties != nil {
		objectMap["properties"] = doi.DomainOwnershipIdentifierProperties
	}
	if doi.ID != nil {
		objectMap["id"] = doi.ID
	}
	if doi.Name != nil {
		objectMap["name"] = doi.Name
	}
	if doi.Kind != nil {
		objectMap["kind"] = doi.Kind
	}
	if doi.Type != nil {
		objectMap["type"] = doi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainOwnershipIdentifier struct.
func (doi *DomainOwnershipIdentifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainOwnershipIdentifierProperties DomainOwnershipIdentifierProperties
				err = json.Unmarshal(*v, &domainOwnershipIdentifierProperties)
				if err != nil {
					return err
				}
				doi.DomainOwnershipIdentifierProperties = &domainOwnershipIdentifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				doi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				doi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				doi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				doi.Type = &typeVar
			}
		}
	}

	return nil
}

// DomainOwnershipIdentifierCollection collection of domain ownership identifiers.
type DomainOwnershipIdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DomainOwnershipIdentifier `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DomainOwnershipIdentifierCollectionIterator provides access to a complete listing of
// DomainOwnershipIdentifier values.
type DomainOwnershipIdentifierCollectionIterator struct {
	i    int
	page DomainOwnershipIdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainOwnershipIdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainOwnershipIdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainOwnershipIdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainOwnershipIdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainOwnershipIdentifierCollectionIterator) Response() DomainOwnershipIdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainOwnershipIdentifierCollectionIterator) Value() DomainOwnershipIdentifier {
	if !iter.page.NotDone() {
		return DomainOwnershipIdentifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainOwnershipIdentifierCollectionIterator type.
func NewDomainOwnershipIdentifierCollectionIterator(page DomainOwnershipIdentifierCollectionPage) DomainOwnershipIdentifierCollectionIterator {
	return DomainOwnershipIdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (doic DomainOwnershipIdentifierCollection) IsEmpty() bool {
	return doic.Value == nil || len(*doic.Value) == 0
}

// domainOwnershipIdentifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (doic DomainOwnershipIdentifierCollection) domainOwnershipIdentifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if doic.NextLink == nil || len(to.String(doic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(doic.NextLink)))
}

// DomainOwnershipIdentifierCollectionPage contains a page of DomainOwnershipIdentifier values.
type DomainOwnershipIdentifierCollectionPage struct {
	fn   func(context.Context, DomainOwnershipIdentifierCollection) (DomainOwnershipIdentifierCollection, error)
	doic DomainOwnershipIdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainOwnershipIdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainOwnershipIdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.doic)
	if err != nil {
		return err
	}
	page.doic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainOwnershipIdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainOwnershipIdentifierCollectionPage) NotDone() bool {
	return !page.doic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainOwnershipIdentifierCollectionPage) Response() DomainOwnershipIdentifierCollection {
	return page.doic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainOwnershipIdentifierCollectionPage) Values() []DomainOwnershipIdentifier {
	if page.doic.IsEmpty() {
		return nil
	}
	return *page.doic.Value
}

// Creates a new instance of the DomainOwnershipIdentifierCollectionPage type.
func NewDomainOwnershipIdentifierCollectionPage(getNextPage func(context.Context, DomainOwnershipIdentifierCollection) (DomainOwnershipIdentifierCollection, error)) DomainOwnershipIdentifierCollectionPage {
	return DomainOwnershipIdentifierCollectionPage{fn: getNextPage}
}

// DomainOwnershipIdentifierProperties domainOwnershipIdentifier resource specific properties
type DomainOwnershipIdentifierProperties struct {
	// OwnershipID - Ownership Id.
	OwnershipID *string `json:"ownershipId,omitempty"`
}

// DomainPatchResource ARM resource for a domain.
type DomainPatchResource struct {
	// DomainPatchResourceProperties - DomainPatchResource resource specific properties
	*DomainPatchResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainPatchResource.
func (dpr DomainPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpr.DomainPatchResourceProperties != nil {
		objectMap["properties"] = dpr.DomainPatchResourceProperties
	}
	if dpr.ID != nil {
		objectMap["id"] = dpr.ID
	}
	if dpr.Name != nil {
		objectMap["name"] = dpr.Name
	}
	if dpr.Kind != nil {
		objectMap["kind"] = dpr.Kind
	}
	if dpr.Type != nil {
		objectMap["type"] = dpr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainPatchResource struct.
func (dpr *DomainPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainPatchResourceProperties DomainPatchResourceProperties
				err = json.Unmarshal(*v, &domainPatchResourceProperties)
				if err != nil {
					return err
				}
				dpr.DomainPatchResourceProperties = &domainPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpr.Type = &typeVar
			}
		}
	}

	return nil
}

// DomainPatchResourceProperties domainPatchResource resource specific properties
type DomainPatchResourceProperties struct {
	// ContactAdmin - Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - Name servers.
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - Domain creation timestamp.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - Domain expiration timestamp.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - Timestamp when the domain was renewed last time.
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
	//  it is hosted on name servers Azure has programmatic access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - Reasons why domain is not renewable.
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
	// DNSType - Current DNS type. Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	DNSType DNSType `json:"dnsType,omitempty"`
	// DNSZoneID - Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`
	// TargetDNSType - Target DNS type (would be used for migration). Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	TargetDNSType DNSType `json:"targetDnsType,omitempty"`
	AuthCode      *string `json:"authCode,omitempty"`
}

// DomainProperties domain resource specific properties
type DomainProperties struct {
	// ContactAdmin - Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - Name servers.
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - Domain creation timestamp.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - Domain expiration timestamp.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - Timestamp when the domain was renewed last time.
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
	//  it is hosted on name servers Azure has programmatic access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - Reasons why domain is not renewable.
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
	// DNSType - Current DNS type. Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	DNSType DNSType `json:"dnsType,omitempty"`
	// DNSZoneID - Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`
	// TargetDNSType - Target DNS type (would be used for migration). Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	TargetDNSType DNSType `json:"targetDnsType,omitempty"`
	AuthCode      *string `json:"authCode,omitempty"`
}

// DomainPurchaseConsent domain purchase consent object, representing acceptance of applicable legal
// agreements.
type DomainPurchaseConsent struct {
	// AgreementKeys - List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
	AgreementKeys *[]string `json:"agreementKeys,omitempty"`
	// AgreedBy - Client IP address.
	AgreedBy *string `json:"agreedBy,omitempty"`
	// AgreedAt - Timestamp when the agreements were accepted.
	AgreedAt *date.Time `json:"agreedAt,omitempty"`
}

// DomainRecommendationSearchParameters domain recommendation search parameters.
type DomainRecommendationSearchParameters struct {
	// Keywords - Keywords to be used for generating domain recommendations.
	Keywords *string `json:"keywords,omitempty"`
	// MaxDomainRecommendations - Maximum number of recommendations.
	MaxDomainRecommendations *int32 `json:"maxDomainRecommendations,omitempty"`
}

// DomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DomainsCreateOrUpdateFuture) Result(client DomainsClient) (d Domain, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("web.DomainsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.DomainsCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnabledConfig enabled configuration.
type EnabledConfig struct {
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// ErrorEntity body of the error response returned from the API.
type ErrorEntity struct {
	// ExtendedCode - Type of error.
	ExtendedCode *string `json:"extendedCode,omitempty"`
	// MessageTemplate - Message template.
	MessageTemplate *string `json:"messageTemplate,omitempty"`
	// Parameters - Parameters for the template.
	Parameters *[]string `json:"parameters,omitempty"`
	// InnerErrors - Inner errors.
	InnerErrors *[]ErrorEntity `json:"innerErrors,omitempty"`
	// Code - Basic error code.
	Code *string `json:"code,omitempty"`
	// Message - Any details of the error.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Experiments routing rules in production experiments.
type Experiments struct {
	// RampUpRules - List of ramp-up rules.
	RampUpRules *[]RampUpRule `json:"rampUpRules,omitempty"`
}

// FileSystemApplicationLogsConfig application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	// RetentionInMb - Maximum size in megabytes that http log files can use.
	// When reached old log files will be removed to make space for new ones.
	// Value can range between 25 and 100.
	RetentionInMb *int32 `json:"retentionInMb,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove files older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// FunctionEnvelope web Job Information.
type FunctionEnvelope struct {
	autorest.Response `json:"-"`
	// FunctionEnvelopeProperties - FunctionEnvelope resource specific properties
	*FunctionEnvelopeProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionEnvelope.
func (fe FunctionEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.FunctionEnvelopeProperties != nil {
		objectMap["properties"] = fe.FunctionEnvelopeProperties
	}
	if fe.ID != nil {
		objectMap["id"] = fe.ID
	}
	if fe.Name != nil {
		objectMap["name"] = fe.Name
	}
	if fe.Kind != nil {
		objectMap["kind"] = fe.Kind
	}
	if fe.Type != nil {
		objectMap["type"] = fe.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FunctionEnvelope struct.
func (fe *FunctionEnvelope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var functionEnvelopeProperties FunctionEnvelopeProperties
				err = json.Unmarshal(*v, &functionEnvelopeProperties)
				if err != nil {
					return err
				}
				fe.FunctionEnvelopeProperties = &functionEnvelopeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fe.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		}
	}

	return nil
}

// FunctionEnvelopeCollection collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]FunctionEnvelope `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// FunctionEnvelopeCollectionIterator provides access to a complete listing of FunctionEnvelope values.
type FunctionEnvelopeCollectionIterator struct {
	i    int
	page FunctionEnvelopeCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FunctionEnvelopeCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionEnvelopeCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FunctionEnvelopeCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FunctionEnvelopeCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FunctionEnvelopeCollectionIterator) Response() FunctionEnvelopeCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FunctionEnvelopeCollectionIterator) Value() FunctionEnvelope {
	if !iter.page.NotDone() {
		return FunctionEnvelope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FunctionEnvelopeCollectionIterator type.
func NewFunctionEnvelopeCollectionIterator(page FunctionEnvelopeCollectionPage) FunctionEnvelopeCollectionIterator {
	return FunctionEnvelopeCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fec FunctionEnvelopeCollection) IsEmpty() bool {
	return fec.Value == nil || len(*fec.Value) == 0
}

// functionEnvelopeCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fec FunctionEnvelopeCollection) functionEnvelopeCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if fec.NextLink == nil || len(to.String(fec.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fec.NextLink)))
}

// FunctionEnvelopeCollectionPage contains a page of FunctionEnvelope values.
type FunctionEnvelopeCollectionPage struct {
	fn  func(context.Context, FunctionEnvelopeCollection) (FunctionEnvelopeCollection, error)
	fec FunctionEnvelopeCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FunctionEnvelopeCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionEnvelopeCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.fec)
	if err != nil {
		return err
	}
	page.fec = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FunctionEnvelopeCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FunctionEnvelopeCollectionPage) NotDone() bool {
	return !page.fec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FunctionEnvelopeCollectionPage) Response() FunctionEnvelopeCollection {
	return page.fec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FunctionEnvelopeCollectionPage) Values() []FunctionEnvelope {
	if page.fec.IsEmpty() {
		return nil
	}
	return *page.fec.Value
}

// Creates a new instance of the FunctionEnvelopeCollectionPage type.
func NewFunctionEnvelopeCollectionPage(getNextPage func(context.Context, FunctionEnvelopeCollection) (FunctionEnvelopeCollection, error)) FunctionEnvelopeCollectionPage {
	return FunctionEnvelopeCollectionPage{fn: getNextPage}
}

// FunctionEnvelopeProperties functionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	// Name - Function name.
	Name *string `json:"name,omitempty"`
	// FunctionAppID - Function App ID.
	FunctionAppID *string `json:"functionAppId,omitempty"`
	// ScriptRootPathHref - Script root path URI.
	ScriptRootPathHref *string `json:"scriptRootPathHref,omitempty"`
	// ScriptHref - Script URI.
	ScriptHref *string `json:"scriptHref,omitempty"`
	// ConfigHref - Config URI.
	ConfigHref *string `json:"configHref,omitempty"`
	// SecretsFileHref - Secrets file URI.
	SecretsFileHref *string `json:"secretsFileHref,omitempty"`
	// Href - Function URI.
	Href *string `json:"href,omitempty"`
	// Config - Config information.
	Config interface{} `json:"config,omitempty"`
	// Files - File list.
	Files map[string]*string `json:"files"`
	// TestData - Test data used when testing via the Azure Portal.
	TestData *string `json:"testData,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionEnvelopeProperties.
func (fe FunctionEnvelopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.Name != nil {
		objectMap["name"] = fe.Name
	}
	if fe.FunctionAppID != nil {
		objectMap["functionAppId"] = fe.FunctionAppID
	}
	if fe.ScriptRootPathHref != nil {
		objectMap["scriptRootPathHref"] = fe.ScriptRootPathHref
	}
	if fe.ScriptHref != nil {
		objectMap["scriptHref"] = fe.ScriptHref
	}
	if fe.ConfigHref != nil {
		objectMap["configHref"] = fe.ConfigHref
	}
	if fe.SecretsFileHref != nil {
		objectMap["secretsFileHref"] = fe.SecretsFileHref
	}
	if fe.Href != nil {
		objectMap["href"] = fe.Href
	}
	if fe.Config != nil {
		objectMap["config"] = fe.Config
	}
	if fe.Files != nil {
		objectMap["files"] = fe.Files
	}
	if fe.TestData != nil {
		objectMap["testData"] = fe.TestData
	}
	return json.Marshal(objectMap)
}

// FunctionSecrets function secrets.
type FunctionSecrets struct {
	autorest.Response `json:"-"`
	// FunctionSecretsProperties - FunctionSecrets resource specific properties
	*FunctionSecretsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionSecrets.
func (fs FunctionSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fs.FunctionSecretsProperties != nil {
		objectMap["properties"] = fs.FunctionSecretsProperties
	}
	if fs.ID != nil {
		objectMap["id"] = fs.ID
	}
	if fs.Name != nil {
		objectMap["name"] = fs.Name
	}
	if fs.Kind != nil {
		objectMap["kind"] = fs.Kind
	}
	if fs.Type != nil {
		objectMap["type"] = fs.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FunctionSecrets struct.
func (fs *FunctionSecrets) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var functionSecretsProperties FunctionSecretsProperties
				err = json.Unmarshal(*v, &functionSecretsProperties)
				if err != nil {
					return err
				}
				fs.FunctionSecretsProperties = &functionSecretsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fs.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fs.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fs.Type = &typeVar
			}
		}
	}

	return nil
}

// FunctionSecretsProperties functionSecrets resource specific properties
type FunctionSecretsProperties struct {
	// Key - Secret key.
	Key *string `json:"key,omitempty"`
	// TriggerURL - Trigger URL.
	TriggerURL *string `json:"triggerUrl,omitempty"`
}

// GeoRegion geographical region.
type GeoRegion struct {
	// GeoRegionProperties - GeoRegion resource specific properties
	*GeoRegionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoRegion.
func (gr GeoRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.GeoRegionProperties != nil {
		objectMap["properties"] = gr.GeoRegionProperties
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoRegion struct.
func (gr *GeoRegion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoRegionProperties GeoRegionProperties
				err = json.Unmarshal(*v, &geoRegionProperties)
				if err != nil {
					return err
				}
				gr.GeoRegionProperties = &geoRegionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gr.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoRegionCollection collection of geographical regions.
type GeoRegionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]GeoRegion `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// GeoRegionCollectionIterator provides access to a complete listing of GeoRegion values.
type GeoRegionCollectionIterator struct {
	i    int
	page GeoRegionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GeoRegionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GeoRegionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GeoRegionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GeoRegionCollectionIterator) Response() GeoRegionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GeoRegionCollectionIterator) Value() GeoRegion {
	if !iter.page.NotDone() {
		return GeoRegion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GeoRegionCollectionIterator type.
func NewGeoRegionCollectionIterator(page GeoRegionCollectionPage) GeoRegionCollectionIterator {
	return GeoRegionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grc GeoRegionCollection) IsEmpty() bool {
	return grc.Value == nil || len(*grc.Value) == 0
}

// geoRegionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grc GeoRegionCollection) geoRegionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if grc.NextLink == nil || len(to.String(grc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grc.NextLink)))
}

// GeoRegionCollectionPage contains a page of GeoRegion values.
type GeoRegionCollectionPage struct {
	fn  func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)
	grc GeoRegionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GeoRegionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.grc)
	if err != nil {
		return err
	}
	page.grc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GeoRegionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GeoRegionCollectionPage) NotDone() bool {
	return !page.grc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GeoRegionCollectionPage) Response() GeoRegionCollection {
	return page.grc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GeoRegionCollectionPage) Values() []GeoRegion {
	if page.grc.IsEmpty() {
		return nil
	}
	return *page.grc.Value
}

// Creates a new instance of the GeoRegionCollectionPage type.
func NewGeoRegionCollectionPage(getNextPage func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)) GeoRegionCollectionPage {
	return GeoRegionCollectionPage{fn: getNextPage}
}

// GeoRegionProperties geoRegion resource specific properties
type GeoRegionProperties struct {
	// Name - Region name.
	Name *string `json:"name,omitempty"`
	// Description - Region description.
	Description *string `json:"description,omitempty"`
	// DisplayName - Display name for region.
	DisplayName *string `json:"displayName,omitempty"`
}

// GlobalCsmSkuDescription a Global SKU Description.
type GlobalCsmSkuDescription struct {
	// Name - Name of the resource SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Service Tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
	// Size - Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`
	// Family - Family code of the resource SKU.
	Family *string `json:"family,omitempty"`
	// Capacity - Min, max, and default scale values of the SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Locations - Locations of the SKU.
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// HandlerMapping the IIS handler mappings used to define which handler processes HTTP requests with
// certain extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Extension - Requests with this extension will be handled using the specified FastCGI application.
	Extension *string `json:"extension,omitempty"`
	// ScriptProcessor - The absolute path to the FastCGI application.
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
	// Arguments - Command-line arguments to be passed to the script processor.
	Arguments *string `json:"arguments,omitempty"`
}

// HostingEnvironmentDeploymentInfo information needed to create resources on an App Service Environment.
type HostingEnvironmentDeploymentInfo struct {
	// Name - Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Location - Location of the App Service Environment.
	Location *string `json:"location,omitempty"`
}

// HostingEnvironmentDiagnostics diagnostics for an App Service Environment.
type HostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	// Name - Name/identifier of the diagnostics.
	Name *string `json:"name,omitempty"`
	// DiagnosicsOutput - Diagnostics output.
	DiagnosicsOutput *string `json:"diagnosicsOutput,omitempty"`
}

// HostingEnvironmentProfile specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	// ID - Resource ID of the App Service Environment.
	ID *string `json:"id,omitempty"`
	// Name - Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Type - Resource type of the App Service Environment.
	Type *string `json:"type,omitempty"`
}

// HostName details of a hostname derived from a domain.
type HostName struct {
	// Name - Name of the hostname.
	Name *string `json:"name,omitempty"`
	// SiteNames - List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic Manager.
	SiteNames *[]string `json:"siteNames,omitempty"`
	// AzureResourceName - Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Type of the Azure resource the hostname is assigned to. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Type of the DNS record. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Type of the hostname. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
}

// HostNameBinding a hostname binding object.
type HostNameBinding struct {
	autorest.Response `json:"-"`
	// HostNameBindingProperties - HostNameBinding resource specific properties
	*HostNameBindingProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HostNameBinding.
func (hnb HostNameBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hnb.HostNameBindingProperties != nil {
		objectMap["properties"] = hnb.HostNameBindingProperties
	}
	if hnb.ID != nil {
		objectMap["id"] = hnb.ID
	}
	if hnb.Name != nil {
		objectMap["name"] = hnb.Name
	}
	if hnb.Kind != nil {
		objectMap["kind"] = hnb.Kind
	}
	if hnb.Type != nil {
		objectMap["type"] = hnb.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostNameBinding struct.
func (hnb *HostNameBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostNameBindingProperties HostNameBindingProperties
				err = json.Unmarshal(*v, &hostNameBindingProperties)
				if err != nil {
					return err
				}
				hnb.HostNameBindingProperties = &hostNameBindingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hnb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hnb.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hnb.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hnb.Type = &typeVar
			}
		}
	}

	return nil
}

// HostNameBindingCollection collection of hostname bindings.
type HostNameBindingCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]HostNameBinding `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// HostNameBindingCollectionIterator provides access to a complete listing of HostNameBinding values.
type HostNameBindingCollectionIterator struct {
	i    int
	page HostNameBindingCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostNameBindingCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostNameBindingCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostNameBindingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostNameBindingCollectionIterator) Response() HostNameBindingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostNameBindingCollectionIterator) Value() HostNameBinding {
	if !iter.page.NotDone() {
		return HostNameBinding{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostNameBindingCollectionIterator type.
func NewHostNameBindingCollectionIterator(page HostNameBindingCollectionPage) HostNameBindingCollectionIterator {
	return HostNameBindingCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hnbc HostNameBindingCollection) IsEmpty() bool {
	return hnbc.Value == nil || len(*hnbc.Value) == 0
}

// hostNameBindingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hnbc HostNameBindingCollection) hostNameBindingCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if hnbc.NextLink == nil || len(to.String(hnbc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hnbc.NextLink)))
}

// HostNameBindingCollectionPage contains a page of HostNameBinding values.
type HostNameBindingCollectionPage struct {
	fn   func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)
	hnbc HostNameBindingCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostNameBindingCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.hnbc)
	if err != nil {
		return err
	}
	page.hnbc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostNameBindingCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostNameBindingCollectionPage) NotDone() bool {
	return !page.hnbc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostNameBindingCollectionPage) Response() HostNameBindingCollection {
	return page.hnbc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostNameBindingCollectionPage) Values() []HostNameBinding {
	if page.hnbc.IsEmpty() {
		return nil
	}
	return *page.hnbc.Value
}

// Creates a new instance of the HostNameBindingCollectionPage type.
func NewHostNameBindingCollectionPage(getNextPage func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)) HostNameBindingCollectionPage {
	return HostNameBindingCollectionPage{fn: getNextPage}
}

// HostNameBindingProperties hostNameBinding resource specific properties
type HostNameBindingProperties struct {
	// SiteName - App Service app name.
	SiteName *string `json:"siteName,omitempty"`
	// DomainID - Fully qualified ARM domain resource URI.
	DomainID *string `json:"domainId,omitempty"`
	// AzureResourceName - Azure resource name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Azure resource type. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Custom DNS record type. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Hostname type. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
	// SslState - SSL type. Possible values include: 'Disabled', 'SniEnabled', 'IPBasedEnabled'
	SslState SslState `json:"sslState,omitempty"`
	// Thumbprint - SSL certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// VirtualIP - Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// HostNameSslState SSL-enabled hostname.
type HostNameSslState struct {
	// Name - Hostname.
	Name *string `json:"name,omitempty"`
	// SslState - SSL type. Possible values include: 'Disabled', 'SniEnabled', 'IPBasedEnabled'
	SslState SslState `json:"sslState,omitempty"`
	// VirtualIP - Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
	// Thumbprint - SSL certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ToUpdate - Set to <code>true</code> to update existing hostname.
	ToUpdate *bool `json:"toUpdate,omitempty"`
	// HostType - Indicates whether the hostname is a standard or repository hostname. Possible values include: 'HostTypeStandard', 'HostTypeRepository'
	HostType HostType `json:"hostType,omitempty"`
}

// HTTPLogsConfig http logs configuration.
type HTTPLogsConfig struct {
	// FileSystem - Http logs to file system configuration.
	FileSystem *FileSystemHTTPLogsConfig `json:"fileSystem,omitempty"`
	// AzureBlobStorage - Http logs to azure blob storage configuration.
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`
}

// HybridConnection hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	autorest.Response `json:"-"`
	// HybridConnectionProperties - HybridConnection resource specific properties
	*HybridConnectionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnection.
func (hc HybridConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hc.HybridConnectionProperties != nil {
		objectMap["properties"] = hc.HybridConnectionProperties
	}
	if hc.ID != nil {
		objectMap["id"] = hc.ID
	}
	if hc.Name != nil {
		objectMap["name"] = hc.Name
	}
	if hc.Kind != nil {
		objectMap["kind"] = hc.Kind
	}
	if hc.Type != nil {
		objectMap["type"] = hc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnection struct.
func (hc *HybridConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionProperties HybridConnectionProperties
				err = json.Unmarshal(*v, &hybridConnectionProperties)
				if err != nil {
					return err
				}
				hc.HybridConnectionProperties = &hybridConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hc.Type = &typeVar
			}
		}
	}

	return nil
}

// HybridConnectionCollection collection of hostname bindings.
type HybridConnectionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]HybridConnection `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// HybridConnectionCollectionIterator provides access to a complete listing of HybridConnection values.
type HybridConnectionCollectionIterator struct {
	i    int
	page HybridConnectionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HybridConnectionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HybridConnectionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HybridConnectionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HybridConnectionCollectionIterator) Response() HybridConnectionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HybridConnectionCollectionIterator) Value() HybridConnection {
	if !iter.page.NotDone() {
		return HybridConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HybridConnectionCollectionIterator type.
func NewHybridConnectionCollectionIterator(page HybridConnectionCollectionPage) HybridConnectionCollectionIterator {
	return HybridConnectionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hcc HybridConnectionCollection) IsEmpty() bool {
	return hcc.Value == nil || len(*hcc.Value) == 0
}

// hybridConnectionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hcc HybridConnectionCollection) hybridConnectionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if hcc.NextLink == nil || len(to.String(hcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hcc.NextLink)))
}

// HybridConnectionCollectionPage contains a page of HybridConnection values.
type HybridConnectionCollectionPage struct {
	fn  func(context.Context, HybridConnectionCollection) (HybridConnectionCollection, error)
	hcc HybridConnectionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HybridConnectionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.hcc)
	if err != nil {
		return err
	}
	page.hcc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HybridConnectionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HybridConnectionCollectionPage) NotDone() bool {
	return !page.hcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HybridConnectionCollectionPage) Response() HybridConnectionCollection {
	return page.hcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HybridConnectionCollectionPage) Values() []HybridConnection {
	if page.hcc.IsEmpty() {
		return nil
	}
	return *page.hcc.Value
}

// Creates a new instance of the HybridConnectionCollectionPage type.
func NewHybridConnectionCollectionPage(getNextPage func(context.Context, HybridConnectionCollection) (HybridConnectionCollection, error)) HybridConnectionCollectionPage {
	return HybridConnectionCollectionPage{fn: getNextPage}
}

// HybridConnectionKey hybrid Connection key contract. This has the send key name and value for a Hybrid
// Connection.
type HybridConnectionKey struct {
	autorest.Response `json:"-"`
	// HybridConnectionKeyProperties - HybridConnectionKey resource specific properties
	*HybridConnectionKeyProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionKey.
func (hck HybridConnectionKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hck.HybridConnectionKeyProperties != nil {
		objectMap["properties"] = hck.HybridConnectionKeyProperties
	}
	if hck.ID != nil {
		objectMap["id"] = hck.ID
	}
	if hck.Name != nil {
		objectMap["name"] = hck.Name
	}
	if hck.Kind != nil {
		objectMap["kind"] = hck.Kind
	}
	if hck.Type != nil {
		objectMap["type"] = hck.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionKey struct.
func (hck *HybridConnectionKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionKeyProperties HybridConnectionKeyProperties
				err = json.Unmarshal(*v, &hybridConnectionKeyProperties)
				if err != nil {
					return err
				}
				hck.HybridConnectionKeyProperties = &hybridConnectionKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hck.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hck.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hck.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hck.Type = &typeVar
			}
		}
	}

	return nil
}

// HybridConnectionKeyProperties hybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	// SendKeyName - The name of the send key.
	SendKeyName *string `json:"sendKeyName,omitempty"`
	// SendKeyValue - The value of the send key.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`
}

// HybridConnectionLimits hybrid Connection limits contract. This is used to return the plan limits of
// Hybrid Connections.
type HybridConnectionLimits struct {
	autorest.Response `json:"-"`
	// HybridConnectionLimitsProperties - HybridConnectionLimits resource specific properties
	*HybridConnectionLimitsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionLimits.
func (hcl HybridConnectionLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcl.HybridConnectionLimitsProperties != nil {
		objectMap["properties"] = hcl.HybridConnectionLimitsProperties
	}
	if hcl.ID != nil {
		objectMap["id"] = hcl.ID
	}
	if hcl.Name != nil {
		objectMap["name"] = hcl.Name
	}
	if hcl.Kind != nil {
		objectMap["kind"] = hcl.Kind
	}
	if hcl.Type != nil {
		objectMap["type"] = hcl.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionLimits struct.
func (hcl *HybridConnectionLimits) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionLimitsProperties HybridConnectionLimitsProperties
				err = json.Unmarshal(*v, &hybridConnectionLimitsProperties)
				if err != nil {
					return err
				}
				hcl.HybridConnectionLimitsProperties = &hybridConnectionLimitsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hcl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hcl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hcl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hcl.Type = &typeVar
			}
		}
	}

	return nil
}

// HybridConnectionLimitsProperties hybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	// Current - The current number of Hybrid Connections.
	Current *int32 `json:"current,omitempty"`
	// Maximum - The maximum number of Hybrid Connections allowed.
	Maximum *int32 `json:"maximum,omitempty"`
}

// HybridConnectionProperties hybridConnection resource specific properties
type HybridConnectionProperties struct {
	// ServiceBusNamespace - The name of the Service Bus namespace.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// RelayName - The name of the Service Bus relay.
	RelayName *string `json:"relayName,omitempty"`
	// RelayArmURI - The ARM URI to the Service Bus relay.
	RelayArmURI *string `json:"relayArmUri,omitempty"`
	// Hostname - The hostname of the endpoint.
	Hostname *string `json:"hostname,omitempty"`
	// Port - The port of the endpoint.
	Port *int32 `json:"port,omitempty"`
	// SendKeyName - The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
	SendKeyName *string `json:"sendKeyName,omitempty"`
	// SendKeyValue - The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
	// normally, use the POST /listKeys API instead.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`
	// ServiceBusSuffix - The suffix for the service bus endpoint. By default this is .servicebus.windows.net
	ServiceBusSuffix *string `json:"serviceBusSuffix,omitempty"`
}

// Identifier a domain specific resource identifier.
type Identifier struct {
	autorest.Response `json:"-"`
	// IdentifierProperties - Identifier resource specific properties
	*IdentifierProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identifier.
func (i Identifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IdentifierProperties != nil {
		objectMap["properties"] = i.IdentifierProperties
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	if i.Kind != nil {
		objectMap["kind"] = i.Kind
	}
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Identifier struct.
func (i *Identifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var identifierProperties IdentifierProperties
				err = json.Unmarshal(*v, &identifierProperties)
				if err != nil {
					return err
				}
				i.IdentifierProperties = &identifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				i.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// IdentifierCollection collection of identifiers.
type IdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Identifier `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// IdentifierCollectionIterator provides access to a complete listing of Identifier values.
type IdentifierCollectionIterator struct {
	i    int
	page IdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IdentifierCollectionIterator) Response() IdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IdentifierCollectionIterator) Value() Identifier {
	if !iter.page.NotDone() {
		return Identifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IdentifierCollectionIterator type.
func NewIdentifierCollectionIterator(page IdentifierCollectionPage) IdentifierCollectionIterator {
	return IdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ic IdentifierCollection) IsEmpty() bool {
	return ic.Value == nil || len(*ic.Value) == 0
}

// identifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ic IdentifierCollection) identifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ic.NextLink == nil || len(to.String(ic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ic.NextLink)))
}

// IdentifierCollectionPage contains a page of Identifier values.
type IdentifierCollectionPage struct {
	fn func(context.Context, IdentifierCollection) (IdentifierCollection, error)
	ic IdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ic)
	if err != nil {
		return err
	}
	page.ic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IdentifierCollectionPage) NotDone() bool {
	return !page.ic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IdentifierCollectionPage) Response() IdentifierCollection {
	return page.ic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IdentifierCollectionPage) Values() []Identifier {
	if page.ic.IsEmpty() {
		return nil
	}
	return *page.ic.Value
}

// Creates a new instance of the IdentifierCollectionPage type.
func NewIdentifierCollectionPage(getNextPage func(context.Context, IdentifierCollection) (IdentifierCollection, error)) IdentifierCollectionPage {
	return IdentifierCollectionPage{fn: getNextPage}
}

// IdentifierProperties identifier resource specific properties
type IdentifierProperties struct {
	// ID - String representation of the identity.
	ID *string `json:"id,omitempty"`
}

// IPSecurityRestriction IP security restriction on an app.
type IPSecurityRestriction struct {
	// IPAddress - IP address the security restriction is valid for.
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetMask - Subnet mask for the range of IP addresses the restriction is valid for.
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// Job web Job Information.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - WebJob resource specific properties
	*JobProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.ID != nil {
		objectMap["id"] = j.ID
	}
	if j.Name != nil {
		objectMap["name"] = j.Name
	}
	if j.Kind != nil {
		objectMap["kind"] = j.Kind
	}
	if j.Type != nil {
		objectMap["type"] = j.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				j.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCollection collection of Kudu web job information elements.
type JobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCollectionIterator provides access to a complete listing of Job values.
type JobCollectionIterator struct {
	i    int
	page JobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCollectionIterator) Response() JobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCollectionIterator type.
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return JobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jc JobCollection) IsEmpty() bool {
	return jc.Value == nil || len(*jc.Value) == 0
}

// jobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jc JobCollection) jobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if jc.NextLink == nil || len(to.String(jc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jc.NextLink)))
}

// JobCollectionPage contains a page of Job values.
type JobCollectionPage struct {
	fn func(context.Context, JobCollection) (JobCollection, error)
	jc JobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jc)
	if err != nil {
		return err
	}
	page.jc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionPage) NotDone() bool {
	return !page.jc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCollectionPage) Response() JobCollection {
	return page.jc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionPage) Values() []Job {
	if page.jc.IsEmpty() {
		return nil
	}
	return *page.jc.Value
}

// Creates a new instance of the JobCollectionPage type.
func NewJobCollectionPage(getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return JobCollectionPage{fn: getNextPage}
}

// JobProperties webJob resource specific properties
type JobProperties struct {
	// Name - Job name. Used as job identifier in ARM resource URI.
	Name *string `json:"name,omitempty"`
	// RunCommand - Run command.
	RunCommand *string `json:"runCommand,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extraInfoUrl,omitempty"`
	// JobType - Job type. Possible values include: 'Continuous', 'Triggered'
	JobType JobType `json:"jobType,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"usingSdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.Name != nil {
		objectMap["name"] = j.Name
	}
	if j.RunCommand != nil {
		objectMap["runCommand"] = j.RunCommand
	}
	if j.URL != nil {
		objectMap["url"] = j.URL
	}
	if j.ExtraInfoURL != nil {
		objectMap["extraInfoUrl"] = j.ExtraInfoURL
	}
	if j.JobType != "" {
		objectMap["jobType"] = j.JobType
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	if j.UsingSdk != nil {
		objectMap["usingSdk"] = j.UsingSdk
	}
	if j.Settings != nil {
		objectMap["settings"] = j.Settings
	}
	return json.Marshal(objectMap)
}

// ListCapability ...
type ListCapability struct {
	autorest.Response `json:"-"`
	Value             *[]Capability `json:"value,omitempty"`
}

// ListCertificateEmail ...
type ListCertificateEmail struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateEmail `json:"value,omitempty"`
}

// ListCertificateOrderAction ...
type ListCertificateOrderAction struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateOrderAction `json:"value,omitempty"`
}

// ListHostingEnvironmentDiagnostics ...
type ListHostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironmentDiagnostics `json:"value,omitempty"`
}

// ListOperation ...
type ListOperation struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// ListVnetInfo ...
type ListVnetInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VnetInfo `json:"value,omitempty"`
}

// ListVnetRoute ...
type ListVnetRoute struct {
	autorest.Response `json:"-"`
	Value             *[]VnetRoute `json:"value,omitempty"`
}

// LocalizableString localizable string object containing the name and a localized value.
type LocalizableString struct {
	// Value - Non-localized name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ManagedServiceIdentity managed service identity.
type ManagedServiceIdentity struct {
	// Type - Type of managed service identity. Possible values include: 'SystemAssigned'
	Type ManagedServiceIdentityType `json:"type,omitempty"`
	// TenantID - Tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalID - Principal Id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty"`
}

// MetricAvailabilily metric availability and retention.
type MetricAvailabilily struct {
	// TimeGrain - Time grain.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - Retention period for the current time grain.
	Retention *string `json:"retention,omitempty"`
}

// MetricAvailability retention policy of a resource metric.
type MetricAvailability struct {
	TimeGrain    *string `json:"timeGrain,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricDefinition metadata for a metric.
type MetricDefinition struct {
	autorest.Response `json:"-"`
	// MetricDefinitionProperties - MetricDefinition resource specific properties
	*MetricDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.MetricDefinitionProperties != nil {
		objectMap["properties"] = md.MetricDefinitionProperties
	}
	if md.ID != nil {
		objectMap["id"] = md.ID
	}
	if md.Name != nil {
		objectMap["name"] = md.Name
	}
	if md.Kind != nil {
		objectMap["kind"] = md.Kind
	}
	if md.Type != nil {
		objectMap["type"] = md.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MetricDefinition struct.
func (md *MetricDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var metricDefinitionProperties MetricDefinitionProperties
				err = json.Unmarshal(*v, &metricDefinitionProperties)
				if err != nil {
					return err
				}
				md.MetricDefinitionProperties = &metricDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				md.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// MetricDefinitionProperties metricDefinition resource specific properties
type MetricDefinitionProperties struct {
	// Name - Name of the metric.
	Name *string `json:"name,omitempty"`
	// Unit - Unit of the metric.
	Unit *string `json:"unit,omitempty"`
	// PrimaryAggregationType - Primary aggregation type.
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty"`
	// MetricAvailabilities - List of time grains supported for the metric together with retention period.
	MetricAvailabilities *[]MetricAvailabilily `json:"metricAvailabilities,omitempty"`
	// DisplayName - Friendly name shown in the UI.
	DisplayName *string `json:"displayName,omitempty"`
}

// MetricSpecification definition of a single resource metric.
type MetricSpecification struct {
	Name                             *string               `json:"name,omitempty"`
	DisplayName                      *string               `json:"displayName,omitempty"`
	DisplayDescription               *string               `json:"displayDescription,omitempty"`
	Unit                             *string               `json:"unit,omitempty"`
	AggregationType                  *string               `json:"aggregationType,omitempty"`
	SupportsInstanceLevelAggregation *bool                 `json:"supportsInstanceLevelAggregation,omitempty"`
	EnableRegionalMdmAccount         *bool                 `json:"enableRegionalMdmAccount,omitempty"`
	SourceMdmAccount                 *string               `json:"sourceMdmAccount,omitempty"`
	SourceMdmNamespace               *string               `json:"sourceMdmNamespace,omitempty"`
	MetricFilterPattern              *string               `json:"metricFilterPattern,omitempty"`
	FillGapWithZero                  *bool                 `json:"fillGapWithZero,omitempty"`
	IsInternal                       *bool                 `json:"isInternal,omitempty"`
	Dimensions                       *[]Dimension          `json:"dimensions,omitempty"`
	Category                         *string               `json:"category,omitempty"`
	Availabilities                   *[]MetricAvailability `json:"availabilities,omitempty"`
}

// MigrateMySQLRequest mySQL migration request.
type MigrateMySQLRequest struct {
	// MigrateMySQLRequestProperties - MigrateMySqlRequest resource specific properties
	*MigrateMySQLRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLRequest.
func (mmsr MigrateMySQLRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmsr.MigrateMySQLRequestProperties != nil {
		objectMap["properties"] = mmsr.MigrateMySQLRequestProperties
	}
	if mmsr.ID != nil {
		objectMap["id"] = mmsr.ID
	}
	if mmsr.Name != nil {
		objectMap["name"] = mmsr.Name
	}
	if mmsr.Kind != nil {
		objectMap["kind"] = mmsr.Kind
	}
	if mmsr.Type != nil {
		objectMap["type"] = mmsr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLRequest struct.
func (mmsr *MigrateMySQLRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var migrateMySQLRequestProperties MigrateMySQLRequestProperties
				err = json.Unmarshal(*v, &migrateMySQLRequestProperties)
				if err != nil {
					return err
				}
				mmsr.MigrateMySQLRequestProperties = &migrateMySQLRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mmsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmsr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mmsr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mmsr.Type = &typeVar
			}
		}
	}

	return nil
}

// MigrateMySQLRequestProperties migrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	// ConnectionString - Connection string to the remote MySQL database.
	ConnectionString *string `json:"connectionString,omitempty"`
	// MigrationType - The type of migration operation to be done. Possible values include: 'LocalToRemote', 'RemoteToLocal'
	MigrationType MySQLMigrationType `json:"migrationType,omitempty"`
}

// MigrateMySQLStatus mySQL migration status.
type MigrateMySQLStatus struct {
	autorest.Response `json:"-"`
	// MigrateMySQLStatusProperties - MigrateMySqlStatus resource specific properties
	*MigrateMySQLStatusProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLStatus.
func (mmss MigrateMySQLStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmss.MigrateMySQLStatusProperties != nil {
		objectMap["properties"] = mmss.MigrateMySQLStatusProperties
	}
	if mmss.ID != nil {
		objectMap["id"] = mmss.ID
	}
	if mmss.Name != nil {
		objectMap["name"] = mmss.Name
	}
	if mmss.Kind != nil {
		objectMap["kind"] = mmss.Kind
	}
	if mmss.Type != nil {
		objectMap["type"] = mmss.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLStatus struct.
func (mmss *MigrateMySQLStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var migrateMySQLStatusProperties MigrateMySQLStatusProperties
				err = json.Unmarshal(*v, &migrateMySQLStatusProperties)
				if err != nil {
					return err
				}
				mmss.MigrateMySQLStatusProperties = &migrateMySQLStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mmss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmss.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mmss.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mmss.Type = &typeVar
			}
		}
	}

	return nil
}

// MigrateMySQLStatusProperties migrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	// MigrationOperationStatus - Status of the migration task. Possible values include: 'OperationStatusInProgress', 'OperationStatusFailed', 'OperationStatusSucceeded', 'OperationStatusTimedOut', 'OperationStatusCreated'
	MigrationOperationStatus OperationStatus `json:"migrationOperationStatus,omitempty"`
	// OperationID - Operation ID for the migration task.
	OperationID *string `json:"operationId,omitempty"`
	// LocalMySQLEnabled - True if the web app has in app MySql enabled
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`
}

// MSDeploy mSDeploy ARM PUT information
type MSDeploy struct {
	// MSDeployCore - Core resource properties
	*MSDeployCore `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeploy.
func (md MSDeploy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.MSDeployCore != nil {
		objectMap["properties"] = md.MSDeployCore
	}
	if md.ID != nil {
		objectMap["id"] = md.ID
	}
	if md.Name != nil {
		objectMap["name"] = md.Name
	}
	if md.Kind != nil {
		objectMap["kind"] = md.Kind
	}
	if md.Type != nil {
		objectMap["type"] = md.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeploy struct.
func (md *MSDeploy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployCore MSDeployCore
				err = json.Unmarshal(*v, &mSDeployCore)
				if err != nil {
					return err
				}
				md.MSDeployCore = &mSDeployCore
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				md.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// MSDeployCore mSDeploy ARM PUT core information
type MSDeployCore struct {
	// PackageURI - Package URI
	PackageURI *string `json:"packageUri,omitempty"`
	// ConnectionString - SQL Connection String
	ConnectionString *string `json:"connectionString,omitempty"`
	// DbType - Database Type
	DbType *string `json:"dbType,omitempty"`
	// SetParametersXMLFileURI - URI of MSDeploy Parameters file. Must not be set if SetParameters is used.
	SetParametersXMLFileURI *string `json:"setParametersXmlFileUri,omitempty"`
	// SetParameters - MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
	SetParameters map[string]*string `json:"setParameters"`
	// SkipAppData - Controls whether the MSDeploy operation skips the App_Data directory.
	// If set to <code>true</code>, the existing App_Data directory on the destination
	// will not be deleted, and any App_Data directory in the source will be ignored.
	// Setting is <code>false</code> by default.
	SkipAppData *bool `json:"skipAppData,omitempty"`
	// AppOffline - Sets the AppOffline rule while the MSDeploy operation executes.
	// Setting is <code>false</code> by default.
	AppOffline *bool `json:"appOffline,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployCore.
func (mdc MSDeployCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdc.PackageURI != nil {
		objectMap["packageUri"] = mdc.PackageURI
	}
	if mdc.ConnectionString != nil {
		objectMap["connectionString"] = mdc.ConnectionString
	}
	if mdc.DbType != nil {
		objectMap["dbType"] = mdc.DbType
	}
	if mdc.SetParametersXMLFileURI != nil {
		objectMap["setParametersXmlFileUri"] = mdc.SetParametersXMLFileURI
	}
	if mdc.SetParameters != nil {
		objectMap["setParameters"] = mdc.SetParameters
	}
	if mdc.SkipAppData != nil {
		objectMap["skipAppData"] = mdc.SkipAppData
	}
	if mdc.AppOffline != nil {
		objectMap["appOffline"] = mdc.AppOffline
	}
	return json.Marshal(objectMap)
}

// MSDeployLog mSDeploy log
type MSDeployLog struct {
	autorest.Response `json:"-"`
	// MSDeployLogProperties - MSDeployLog resource specific properties
	*MSDeployLogProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployLog.
func (mdl MSDeployLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdl.MSDeployLogProperties != nil {
		objectMap["properties"] = mdl.MSDeployLogProperties
	}
	if mdl.ID != nil {
		objectMap["id"] = mdl.ID
	}
	if mdl.Name != nil {
		objectMap["name"] = mdl.Name
	}
	if mdl.Kind != nil {
		objectMap["kind"] = mdl.Kind
	}
	if mdl.Type != nil {
		objectMap["type"] = mdl.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeployLog struct.
func (mdl *MSDeployLog) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployLogProperties MSDeployLogProperties
				err = json.Unmarshal(*v, &mSDeployLogProperties)
				if err != nil {
					return err
				}
				mdl.MSDeployLogProperties = &mSDeployLogProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdl.Type = &typeVar
			}
		}
	}

	return nil
}

// MSDeployLogEntry mSDeploy log entry
type MSDeployLogEntry struct {
	// Time - Timestamp of log entry
	Time *date.Time `json:"time,omitempty"`
	// Type - Log entry type. Possible values include: 'MSDeployLogEntryTypeMessage', 'MSDeployLogEntryTypeWarning', 'MSDeployLogEntryTypeError'
	Type MSDeployLogEntryType `json:"type,omitempty"`
	// Message - Log entry message
	Message *string `json:"message,omitempty"`
}

// MSDeployLogProperties mSDeployLog resource specific properties
type MSDeployLogProperties struct {
	// Entries - List of log entry messages
	Entries *[]MSDeployLogEntry `json:"entries,omitempty"`
}

// MSDeployStatus mSDeploy ARM response
type MSDeployStatus struct {
	autorest.Response `json:"-"`
	// MSDeployStatusProperties - MSDeployStatus resource specific properties
	*MSDeployStatusProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployStatus.
func (mds MSDeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mds.MSDeployStatusProperties != nil {
		objectMap["properties"] = mds.MSDeployStatusProperties
	}
	if mds.ID != nil {
		objectMap["id"] = mds.ID
	}
	if mds.Name != nil {
		objectMap["name"] = mds.Name
	}
	if mds.Kind != nil {
		objectMap["kind"] = mds.Kind
	}
	if mds.Type != nil {
		objectMap["type"] = mds.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeployStatus struct.
func (mds *MSDeployStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployStatusProperties MSDeployStatusProperties
				err = json.Unmarshal(*v, &mSDeployStatusProperties)
				if err != nil {
					return err
				}
				mds.MSDeployStatusProperties = &mSDeployStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mds.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mds.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mds.Type = &typeVar
			}
		}
	}

	return nil
}

// MSDeployStatusProperties mSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	// Deployer - Username of deployer
	Deployer *string `json:"deployer,omitempty"`
	// ProvisioningState - Provisioning state. Possible values include: 'MSDeployProvisioningStateAccepted', 'MSDeployProvisioningStateRunning', 'MSDeployProvisioningStateSucceeded', 'MSDeployProvisioningStateFailed', 'MSDeployProvisioningStateCanceled'
	ProvisioningState MSDeployProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - Start time of deploy operation
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of deploy operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// Complete - Whether the deployment operation has completed
	Complete *bool `json:"complete,omitempty"`
}

// NameIdentifier identifies an object.
type NameIdentifier struct {
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection collection of domain name identifiers.
type NameIdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]NameIdentifier `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// NameIdentifierCollectionIterator provides access to a complete listing of NameIdentifier values.
type NameIdentifierCollectionIterator struct {
	i    int
	page NameIdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NameIdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NameIdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NameIdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NameIdentifierCollectionIterator) Response() NameIdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NameIdentifierCollectionIterator) Value() NameIdentifier {
	if !iter.page.NotDone() {
		return NameIdentifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NameIdentifierCollectionIterator type.
func NewNameIdentifierCollectionIterator(page NameIdentifierCollectionPage) NameIdentifierCollectionIterator {
	return NameIdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nic NameIdentifierCollection) IsEmpty() bool {
	return nic.Value == nil || len(*nic.Value) == 0
}

// nameIdentifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nic NameIdentifierCollection) nameIdentifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if nic.NextLink == nil || len(to.String(nic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nic.NextLink)))
}

// NameIdentifierCollectionPage contains a page of NameIdentifier values.
type NameIdentifierCollectionPage struct {
	fn  func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)
	nic NameIdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NameIdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nic)
	if err != nil {
		return err
	}
	page.nic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NameIdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NameIdentifierCollectionPage) NotDone() bool {
	return !page.nic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NameIdentifierCollectionPage) Response() NameIdentifierCollection {
	return page.nic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NameIdentifierCollectionPage) Values() []NameIdentifier {
	if page.nic.IsEmpty() {
		return nil
	}
	return *page.nic.Value
}

// Creates a new instance of the NameIdentifierCollectionPage type.
func NewNameIdentifierCollectionPage(getNextPage func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)) NameIdentifierCollectionPage {
	return NameIdentifierCollectionPage{fn: getNextPage}
}

// NameValuePair name value pair.
type NameValuePair struct {
	// Name - Pair name.
	Name *string `json:"name,omitempty"`
	// Value - Pair value.
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry network access control entry.
type NetworkAccessControlEntry struct {
	// Action - Action object. Possible values include: 'Permit', 'Deny'
	Action AccessControlEntryAction `json:"action,omitempty"`
	// Description - Description of network access control entry.
	Description *string `json:"description,omitempty"`
	// Order - Order of precedence.
	Order *int32 `json:"order,omitempty"`
	// RemoteSubnet - Remote subnet.
	RemoteSubnet *string `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures full view of network features for an app (presently VNET integration and Hybrid
// Connections).
type NetworkFeatures struct {
	autorest.Response `json:"-"`
	// NetworkFeaturesProperties - NetworkFeatures resource specific properties
	*NetworkFeaturesProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFeatures.
func (nf NetworkFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nf.NetworkFeaturesProperties != nil {
		objectMap["properties"] = nf.NetworkFeaturesProperties
	}
	if nf.ID != nil {
		objectMap["id"] = nf.ID
	}
	if nf.Name != nil {
		objectMap["name"] = nf.Name
	}
	if nf.Kind != nil {
		objectMap["kind"] = nf.Kind
	}
	if nf.Type != nil {
		objectMap["type"] = nf.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkFeatures struct.
func (nf *NetworkFeatures) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkFeaturesProperties NetworkFeaturesProperties
				err = json.Unmarshal(*v, &networkFeaturesProperties)
				if err != nil {
					return err
				}
				nf.NetworkFeaturesProperties = &networkFeaturesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				nf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nf.Type = &typeVar
			}
		}
	}

	return nil
}

// NetworkFeaturesProperties networkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	// VirtualNetworkName - The Virtual Network name.
	VirtualNetworkName *string `json:"virtualNetworkName,omitempty"`
	// VirtualNetworkConnection - The Virtual Network summary view.
	VirtualNetworkConnection *VnetInfo `json:"virtualNetworkConnection,omitempty"`
	// HybridConnections - The Hybrid Connections summary view.
	HybridConnections *[]RelayServiceConnectionEntity `json:"hybridConnections,omitempty"`
	// HybridConnectionsV2 - The Hybrid Connection V2 (Service Bus) view.
	HybridConnectionsV2 *[]HybridConnection `json:"hybridConnectionsV2,omitempty"`
}

// Operation an operation on a resource.
type Operation struct {
	autorest.Response `json:"-"`
	// ID - Operation ID.
	ID *string `json:"id,omitempty"`
	// Name - Operation name.
	Name *string `json:"name,omitempty"`
	// Status - The current status of the operation. Possible values include: 'OperationStatusInProgress', 'OperationStatusFailed', 'OperationStatusSucceeded', 'OperationStatusTimedOut', 'OperationStatusCreated'
	Status OperationStatus `json:"status,omitempty"`
	// Errors - Any errors associate with the operation.
	Errors *[]ErrorEntity `json:"errors,omitempty"`
	// CreatedTime - Time when operation has started.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ModifiedTime - Time when operation has been updated.
	ModifiedTime *date.Time `json:"modifiedTime,omitempty"`
	// ExpirationTime - Time when operation will expire.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// GeoMasterOperationID - Applicable only for stamp operation ids.
	GeoMasterOperationID *uuid.UUID `json:"geoMasterOperationId,omitempty"`
}

// PerfMonCounterCollection collection of performance monitor counters.
type PerfMonCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PerfMonResponse `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PerfMonCounterCollectionIterator provides access to a complete listing of PerfMonResponse values.
type PerfMonCounterCollectionIterator struct {
	i    int
	page PerfMonCounterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PerfMonCounterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PerfMonCounterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PerfMonCounterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PerfMonCounterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PerfMonCounterCollectionIterator) Response() PerfMonCounterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PerfMonCounterCollectionIterator) Value() PerfMonResponse {
	if !iter.page.NotDone() {
		return PerfMonResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PerfMonCounterCollectionIterator type.
func NewPerfMonCounterCollectionIterator(page PerfMonCounterCollectionPage) PerfMonCounterCollectionIterator {
	return PerfMonCounterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmcc PerfMonCounterCollection) IsEmpty() bool {
	return pmcc.Value == nil || len(*pmcc.Value) == 0
}

// perfMonCounterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmcc PerfMonCounterCollection) perfMonCounterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pmcc.NextLink == nil || len(to.String(pmcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmcc.NextLink)))
}

// PerfMonCounterCollectionPage contains a page of PerfMonResponse values.
type PerfMonCounterCollectionPage struct {
	fn   func(context.Context, PerfMonCounterCollection) (PerfMonCounterCollection, error)
	pmcc PerfMonCounterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PerfMonCounterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PerfMonCounterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pmcc)
	if err != nil {
		return err
	}
	page.pmcc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PerfMonCounterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PerfMonCounterCollectionPage) NotDone() bool {
	return !page.pmcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PerfMonCounterCollectionPage) Response() PerfMonCounterCollection {
	return page.pmcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PerfMonCounterCollectionPage) Values() []PerfMonResponse {
	if page.pmcc.IsEmpty() {
		return nil
	}
	return *page.pmcc.Value
}

// Creates a new instance of the PerfMonCounterCollectionPage type.
func NewPerfMonCounterCollectionPage(getNextPage func(context.Context, PerfMonCounterCollection) (PerfMonCounterCollection, error)) PerfMonCounterCollectionPage {
	return PerfMonCounterCollectionPage{fn: getNextPage}
}

// PerfMonResponse performance monitor API response.
type PerfMonResponse struct {
	// Code - The response code.
	Code *string `json:"code,omitempty"`
	// Message - The message.
	Message *string `json:"message,omitempty"`
	// Data - The performance monitor counters.
	Data *PerfMonSet `json:"data,omitempty"`
}

// PerfMonSample performance monitor sample in a set.
type PerfMonSample struct {
	// Time - Point in time for which counter was measured.
	Time *date.Time `json:"time,omitempty"`
	// InstanceName - Name of the server on which the measurement is made.
	InstanceName *string `json:"instanceName,omitempty"`
	// Value - Value of counter at a certain time.
	Value *float64 `json:"value,omitempty"`
	// CoreCount - Core Count of worker. Not a data member
	CoreCount *int32 `json:"coreCount,omitempty"`
}

// PerfMonSet metric information.
type PerfMonSet struct {
	// Name - Unique key name of the counter.
	Name *string `json:"name,omitempty"`
	// StartTime - Start time of the period.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period.
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - Presented time grain.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Values - Collection of workers that are active during this time.
	Values *[]PerfMonSample `json:"values,omitempty"`
}

// PremierAddOn premier add-on.
type PremierAddOn struct {
	autorest.Response `json:"-"`
	// PremierAddOnProperties - PremierAddOn resource specific properties
	*PremierAddOnProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PremierAddOn.
func (pao PremierAddOn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pao.PremierAddOnProperties != nil {
		objectMap["properties"] = pao.PremierAddOnProperties
	}
	if pao.ID != nil {
		objectMap["id"] = pao.ID
	}
	if pao.Name != nil {
		objectMap["name"] = pao.Name
	}
	if pao.Kind != nil {
		objectMap["kind"] = pao.Kind
	}
	if pao.Location != nil {
		objectMap["location"] = pao.Location
	}
	if pao.Type != nil {
		objectMap["type"] = pao.Type
	}
	if pao.Tags != nil {
		objectMap["tags"] = pao.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PremierAddOn struct.
func (pao *PremierAddOn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var premierAddOnProperties PremierAddOnProperties
				err = json.Unmarshal(*v, &premierAddOnProperties)
				if err != nil {
					return err
				}
				pao.PremierAddOnProperties = &premierAddOnProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pao.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pao.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pao.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pao.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pao.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pao.Tags = tags
			}
		}
	}

	return nil
}

// PremierAddOnOffer premier add-on offer.
type PremierAddOnOffer struct {
	// PremierAddOnOfferProperties - PremierAddOnOffer resource specific properties
	*PremierAddOnOfferProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnOffer.
func (paoo PremierAddOnOffer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paoo.PremierAddOnOfferProperties != nil {
		objectMap["properties"] = paoo.PremierAddOnOfferProperties
	}
	if paoo.ID != nil {
		objectMap["id"] = paoo.ID
	}
	if paoo.Name != nil {
		objectMap["name"] = paoo.Name
	}
	if paoo.Kind != nil {
		objectMap["kind"] = paoo.Kind
	}
	if paoo.Type != nil {
		objectMap["type"] = paoo.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PremierAddOnOffer struct.
func (paoo *PremierAddOnOffer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var premierAddOnOfferProperties PremierAddOnOfferProperties
				err = json.Unmarshal(*v, &premierAddOnOfferProperties)
				if err != nil {
					return err
				}
				paoo.PremierAddOnOfferProperties = &premierAddOnOfferProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				paoo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				paoo.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				paoo.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				paoo.Type = &typeVar
			}
		}
	}

	return nil
}

// PremierAddOnOfferCollection collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PremierAddOnOffer `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PremierAddOnOfferCollectionIterator provides access to a complete listing of PremierAddOnOffer values.
type PremierAddOnOfferCollectionIterator struct {
	i    int
	page PremierAddOnOfferCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PremierAddOnOfferCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremierAddOnOfferCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PremierAddOnOfferCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PremierAddOnOfferCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PremierAddOnOfferCollectionIterator) Response() PremierAddOnOfferCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PremierAddOnOfferCollectionIterator) Value() PremierAddOnOffer {
	if !iter.page.NotDone() {
		return PremierAddOnOffer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PremierAddOnOfferCollectionIterator type.
func NewPremierAddOnOfferCollectionIterator(page PremierAddOnOfferCollectionPage) PremierAddOnOfferCollectionIterator {
	return PremierAddOnOfferCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (paooc PremierAddOnOfferCollection) IsEmpty() bool {
	return paooc.Value == nil || len(*paooc.Value) == 0
}

// premierAddOnOfferCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (paooc PremierAddOnOfferCollection) premierAddOnOfferCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if paooc.NextLink == nil || len(to.String(paooc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(paooc.NextLink)))
}

// PremierAddOnOfferCollectionPage contains a page of PremierAddOnOffer values.
type PremierAddOnOfferCollectionPage struct {
	fn    func(context.Context, PremierAddOnOfferCollection) (PremierAddOnOfferCollection, error)
	paooc PremierAddOnOfferCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PremierAddOnOfferCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremierAddOnOfferCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.paooc)
	if err != nil {
		return err
	}
	page.paooc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PremierAddOnOfferCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PremierAddOnOfferCollectionPage) NotDone() bool {
	return !page.paooc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PremierAddOnOfferCollectionPage) Response() PremierAddOnOfferCollection {
	return page.paooc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PremierAddOnOfferCollectionPage) Values() []PremierAddOnOffer {
	if page.paooc.IsEmpty() {
		return nil
	}
	return *page.paooc.Value
}

// Creates a new instance of the PremierAddOnOfferCollectionPage type.
func NewPremierAddOnOfferCollectionPage(getNextPage func(context.Context, PremierAddOnOfferCollection) (PremierAddOnOfferCollection, error)) PremierAddOnOfferCollectionPage {
	return PremierAddOnOfferCollectionPage{fn: getNextPage}
}

// PremierAddOnOfferProperties premierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	// Sku - Premier add on SKU.
	Sku *string `json:"sku,omitempty"`
	// Product - Premier add on offer Product.
	Product *string `json:"product,omitempty"`
	// Vendor - Premier add on offer Vendor.
	Vendor *string `json:"vendor,omitempty"`
	// Name - Premier add on offer Name.
	Name *string `json:"name,omitempty"`
	// PromoCodeRequired - <code>true</code> if promotion code is required; otherwise, <code>false</code>.
	PromoCodeRequired *bool `json:"promoCodeRequired,omitempty"`
	// Quota - Premier add on offer Quota.
	Quota *int32 `json:"quota,omitempty"`
	// WebHostingPlanRestrictions - App Service plans this offer is restricted to. Possible values include: 'None', 'Free', 'Shared', 'Basic', 'Standard', 'Premium'
	WebHostingPlanRestrictions AppServicePlanRestrictions `json:"webHostingPlanRestrictions,omitempty"`
	// PrivacyPolicyURL - Privacy policy URL.
	PrivacyPolicyURL *string `json:"privacyPolicyUrl,omitempty"`
	// LegalTermsURL - Legal terms URL.
	LegalTermsURL *string `json:"legalTermsUrl,omitempty"`
	// MarketplacePublisher - Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`
	// MarketplaceOffer - Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`
}

// PremierAddOnProperties premierAddOn resource specific properties
type PremierAddOnProperties struct {
	// Sku - Premier add on SKU.
	Sku *string `json:"sku,omitempty"`
	// Product - Premier add on Product.
	Product *string `json:"product,omitempty"`
	// Vendor - Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
	// PremierAddOnName - Premier add on Name.
	PremierAddOnName *string `json:"name,omitempty"`
	// Location - Premier add on Location.
	Location *string `json:"location,omitempty"`
	// Tags - Premier add on Tags.
	Tags map[string]*string `json:"tags"`
	// MarketplacePublisher - Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`
	// MarketplaceOffer - Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnProperties.
func (pao PremierAddOnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pao.Sku != nil {
		objectMap["sku"] = pao.Sku
	}
	if pao.Product != nil {
		objectMap["product"] = pao.Product
	}
	if pao.Vendor != nil {
		objectMap["vendor"] = pao.Vendor
	}
	if pao.PremierAddOnName != nil {
		objectMap["name"] = pao.PremierAddOnName
	}
	if pao.Location != nil {
		objectMap["location"] = pao.Location
	}
	if pao.Tags != nil {
		objectMap["tags"] = pao.Tags
	}
	if pao.MarketplacePublisher != nil {
		objectMap["marketplacePublisher"] = pao.MarketplacePublisher
	}
	if pao.MarketplaceOffer != nil {
		objectMap["marketplaceOffer"] = pao.MarketplaceOffer
	}
	return json.Marshal(objectMap)
}

// ProcessInfo process Information.
type ProcessInfo struct {
	autorest.Response `json:"-"`
	// ProcessInfoProperties - ProcessInfo resource specific properties
	*ProcessInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessInfo.
func (pi ProcessInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ProcessInfoProperties != nil {
		objectMap["properties"] = pi.ProcessInfoProperties
	}
	if pi.ID != nil {
		objectMap["id"] = pi.ID
	}
	if pi.Name != nil {
		objectMap["name"] = pi.Name
	}
	if pi.Kind != nil {
		objectMap["kind"] = pi.Kind
	}
	if pi.Type != nil {
		objectMap["type"] = pi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessInfo struct.
func (pi *ProcessInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processInfoProperties ProcessInfoProperties
				err = json.Unmarshal(*v, &processInfoProperties)
				if err != nil {
					return err
				}
				pi.ProcessInfoProperties = &processInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pi.Type = &typeVar
			}
		}
	}

	return nil
}

// ProcessInfoCollection collection of Kudu process information elements.
type ProcessInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProcessInfoCollectionIterator provides access to a complete listing of ProcessInfo values.
type ProcessInfoCollectionIterator struct {
	i    int
	page ProcessInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessInfoCollectionIterator) Response() ProcessInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessInfoCollectionIterator) Value() ProcessInfo {
	if !iter.page.NotDone() {
		return ProcessInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessInfoCollectionIterator type.
func NewProcessInfoCollectionIterator(page ProcessInfoCollectionPage) ProcessInfoCollectionIterator {
	return ProcessInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pic ProcessInfoCollection) IsEmpty() bool {
	return pic.Value == nil || len(*pic.Value) == 0
}

// processInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pic ProcessInfoCollection) processInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pic.NextLink == nil || len(to.String(pic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pic.NextLink)))
}

// ProcessInfoCollectionPage contains a page of ProcessInfo values.
type ProcessInfoCollectionPage struct {
	fn  func(context.Context, ProcessInfoCollection) (ProcessInfoCollection, error)
	pic ProcessInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pic)
	if err != nil {
		return err
	}
	page.pic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessInfoCollectionPage) NotDone() bool {
	return !page.pic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessInfoCollectionPage) Response() ProcessInfoCollection {
	return page.pic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessInfoCollectionPage) Values() []ProcessInfo {
	if page.pic.IsEmpty() {
		return nil
	}
	return *page.pic.Value
}

// Creates a new instance of the ProcessInfoCollectionPage type.
func NewProcessInfoCollectionPage(getNextPage func(context.Context, ProcessInfoCollection) (ProcessInfoCollection, error)) ProcessInfoCollectionPage {
	return ProcessInfoCollectionPage{fn: getNextPage}
}

// ProcessInfoProperties processInfo resource specific properties
type ProcessInfoProperties struct {
	// ID - ARM Identifier for deployment.
	ID *int32 `json:"id,omitempty"`
	// Name - Deployment name.
	Name *string `json:"name,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// MiniDump - Minidump URI.
	MiniDump *string `json:"miniDump,omitempty"`
	// IsProfileRunning - Is profile running?
	IsProfileRunning *bool `json:"isProfileRunning,omitempty"`
	// IsIisProfileRunning - Is the IIS Profile running?
	IsIisProfileRunning *bool `json:"isIisProfileRunning,omitempty"`
	// IisProfileTimeoutInSeconds - IIS Profile timeout (seconds).
	IisProfileTimeoutInSeconds *float64 `json:"iisProfileTimeoutInSeconds,omitempty"`
	// Parent - Parent process.
	Parent *string `json:"parent,omitempty"`
	// Children - Child process list.
	Children *[]string `json:"children,omitempty"`
	// Threads - Thread list.
	Threads *[]ProcessThreadInfo `json:"threads,omitempty"`
	// OpenFileHandles - List of open files.
	OpenFileHandles *[]string `json:"openFileHandles,omitempty"`
	// Modules - List of modules.
	Modules *[]ProcessModuleInfo `json:"modules,omitempty"`
	// FileName - File name of this process.
	FileName *string `json:"fileName,omitempty"`
	// CommandLine - Command line.
	CommandLine *string `json:"commandLine,omitempty"`
	// UserName - User name.
	UserName *string `json:"userName,omitempty"`
	// HandleCount - Handle count.
	HandleCount *int32 `json:"handleCount,omitempty"`
	// ModuleCount - Module count.
	ModuleCount *int32 `json:"moduleCount,omitempty"`
	// ThreadCount - Thread count.
	ThreadCount *int32 `json:"threadCount,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// TotalProcessorTime - Total CPU time.
	TotalProcessorTime *string `json:"totalProcessorTime,omitempty"`
	// UserProcessorTime - User CPU time.
	UserProcessorTime *string `json:"userProcessorTime,omitempty"`
	// PrivilegedProcessorTime - Privileged CPU time.
	PrivilegedProcessorTime *string `json:"privilegedProcessorTime,omitempty"`
	// WorkingSet64 - Working set.
	WorkingSet64 *int64 `json:"workingSet64,omitempty"`
	// PeakWorkingSet64 - Peak working set.
	PeakWorkingSet64 *int64 `json:"peakWorkingSet64,omitempty"`
	// PrivateMemorySize64 - Private memory size.
	PrivateMemorySize64 *int64 `json:"privateMemorySize64,omitempty"`
	// VirtualMemorySize64 - Virtual memory size.
	VirtualMemorySize64 *int64 `json:"virtualMemorySize64,omitempty"`
	// PeakVirtualMemorySize64 - Peak virtual memory usage.
	PeakVirtualMemorySize64 *int64 `json:"peakVirtualMemorySize64,omitempty"`
	// PagedSystemMemorySize64 - Paged system memory.
	PagedSystemMemorySize64 *int64 `json:"pagedSystemMemorySize64,omitempty"`
	// NonpagedSystemMemorySize64 - Non-paged system memory.
	NonpagedSystemMemorySize64 *int64 `json:"nonpagedSystemMemorySize64,omitempty"`
	// PagedMemorySize64 - Paged memory.
	PagedMemorySize64 *int64 `json:"pagedMemorySize64,omitempty"`
	// PeakPagedMemorySize64 - Peak paged memory.
	PeakPagedMemorySize64 *int64 `json:"peakPagedMemorySize64,omitempty"`
	// TimeStamp - Time stamp.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// EnvironmentVariables - List of environment variables.
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// IsScmSite - Is this the SCM site?
	IsScmSite *bool `json:"isScmSite,omitempty"`
	// IsWebJob - Is this a Web Job?
	IsWebJob *bool `json:"isWebJob,omitempty"`
	// Description - Description of process.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessInfoProperties.
func (pi ProcessInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ID != nil {
		objectMap["id"] = pi.ID
	}
	if pi.Name != nil {
		objectMap["name"] = pi.Name
	}
	if pi.Href != nil {
		objectMap["href"] = pi.Href
	}
	if pi.MiniDump != nil {
		objectMap["miniDump"] = pi.MiniDump
	}
	if pi.IsProfileRunning != nil {
		objectMap["isProfileRunning"] = pi.IsProfileRunning
	}
	if pi.IsIisProfileRunning != nil {
		objectMap["isIisProfileRunning"] = pi.IsIisProfileRunning
	}
	if pi.IisProfileTimeoutInSeconds != nil {
		objectMap["iisProfileTimeoutInSeconds"] = pi.IisProfileTimeoutInSeconds
	}
	if pi.Parent != nil {
		objectMap["parent"] = pi.Parent
	}
	if pi.Children != nil {
		objectMap["children"] = pi.Children
	}
	if pi.Threads != nil {
		objectMap["threads"] = pi.Threads
	}
	if pi.OpenFileHandles != nil {
		objectMap["openFileHandles"] = pi.OpenFileHandles
	}
	if pi.Modules != nil {
		objectMap["modules"] = pi.Modules
	}
	if pi.FileName != nil {
		objectMap["fileName"] = pi.FileName
	}
	if pi.CommandLine != nil {
		objectMap["commandLine"] = pi.CommandLine
	}
	if pi.UserName != nil {
		objectMap["userName"] = pi.UserName
	}
	if pi.HandleCount != nil {
		objectMap["handleCount"] = pi.HandleCount
	}
	if pi.ModuleCount != nil {
		objectMap["moduleCount"] = pi.ModuleCount
	}
	if pi.ThreadCount != nil {
		objectMap["threadCount"] = pi.ThreadCount
	}
	if pi.StartTime != nil {
		objectMap["startTime"] = pi.StartTime
	}
	if pi.TotalProcessorTime != nil {
		objectMap["totalProcessorTime"] = pi.TotalProcessorTime
	}
	if pi.UserProcessorTime != nil {
		objectMap["userProcessorTime"] = pi.UserProcessorTime
	}
	if pi.PrivilegedProcessorTime != nil {
		objectMap["privilegedProcessorTime"] = pi.PrivilegedProcessorTime
	}
	if pi.WorkingSet64 != nil {
		objectMap["workingSet64"] = pi.WorkingSet64
	}
	if pi.PeakWorkingSet64 != nil {
		objectMap["peakWorkingSet64"] = pi.PeakWorkingSet64
	}
	if pi.PrivateMemorySize64 != nil {
		objectMap["privateMemorySize64"] = pi.PrivateMemorySize64
	}
	if pi.VirtualMemorySize64 != nil {
		objectMap["virtualMemorySize64"] = pi.VirtualMemorySize64
	}
	if pi.PeakVirtualMemorySize64 != nil {
		objectMap["peakVirtualMemorySize64"] = pi.PeakVirtualMemorySize64
	}
	if pi.PagedSystemMemorySize64 != nil {
		objectMap["pagedSystemMemorySize64"] = pi.PagedSystemMemorySize64
	}
	if pi.NonpagedSystemMemorySize64 != nil {
		objectMap["nonpagedSystemMemorySize64"] = pi.NonpagedSystemMemorySize64
	}
	if pi.PagedMemorySize64 != nil {
		objectMap["pagedMemorySize64"] = pi.PagedMemorySize64
	}
	if pi.PeakPagedMemorySize64 != nil {
		objectMap["peakPagedMemorySize64"] = pi.PeakPagedMemorySize64
	}
	if pi.TimeStamp != nil {
		objectMap["timeStamp"] = pi.TimeStamp
	}
	if pi.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = pi.EnvironmentVariables
	}
	if pi.IsScmSite != nil {
		objectMap["isScmSite"] = pi.IsScmSite
	}
	if pi.IsWebJob != nil {
		objectMap["isWebJob"] = pi.IsWebJob
	}
	if pi.Description != nil {
		objectMap["description"] = pi.Description
	}
	return json.Marshal(objectMap)
}

// ProcessModuleInfo process Module Information.
type ProcessModuleInfo struct {
	autorest.Response `json:"-"`
	// ProcessModuleInfoProperties - ProcessModuleInfo resource specific properties
	*ProcessModuleInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessModuleInfo.
func (pmi ProcessModuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmi.ProcessModuleInfoProperties != nil {
		objectMap["properties"] = pmi.ProcessModuleInfoProperties
	}
	if pmi.ID != nil {
		objectMap["id"] = pmi.ID
	}
	if pmi.Name != nil {
		objectMap["name"] = pmi.Name
	}
	if pmi.Kind != nil {
		objectMap["kind"] = pmi.Kind
	}
	if pmi.Type != nil {
		objectMap["type"] = pmi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessModuleInfo struct.
func (pmi *ProcessModuleInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processModuleInfoProperties ProcessModuleInfoProperties
				err = json.Unmarshal(*v, &processModuleInfoProperties)
				if err != nil {
					return err
				}
				pmi.ProcessModuleInfoProperties = &processModuleInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pmi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pmi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pmi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pmi.Type = &typeVar
			}
		}
	}

	return nil
}

// ProcessModuleInfoCollection collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessModuleInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProcessModuleInfoCollectionIterator provides access to a complete listing of ProcessModuleInfo values.
type ProcessModuleInfoCollectionIterator struct {
	i    int
	page ProcessModuleInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessModuleInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessModuleInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessModuleInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessModuleInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessModuleInfoCollectionIterator) Response() ProcessModuleInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessModuleInfoCollectionIterator) Value() ProcessModuleInfo {
	if !iter.page.NotDone() {
		return ProcessModuleInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessModuleInfoCollectionIterator type.
func NewProcessModuleInfoCollectionIterator(page ProcessModuleInfoCollectionPage) ProcessModuleInfoCollectionIterator {
	return ProcessModuleInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmic ProcessModuleInfoCollection) IsEmpty() bool {
	return pmic.Value == nil || len(*pmic.Value) == 0
}

// processModuleInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmic ProcessModuleInfoCollection) processModuleInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pmic.NextLink == nil || len(to.String(pmic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmic.NextLink)))
}

// ProcessModuleInfoCollectionPage contains a page of ProcessModuleInfo values.
type ProcessModuleInfoCollectionPage struct {
	fn   func(context.Context, ProcessModuleInfoCollection) (ProcessModuleInfoCollection, error)
	pmic ProcessModuleInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessModuleInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessModuleInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pmic)
	if err != nil {
		return err
	}
	page.pmic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessModuleInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessModuleInfoCollectionPage) NotDone() bool {
	return !page.pmic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessModuleInfoCollectionPage) Response() ProcessModuleInfoCollection {
	return page.pmic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessModuleInfoCollectionPage) Values() []ProcessModuleInfo {
	if page.pmic.IsEmpty() {
		return nil
	}
	return *page.pmic.Value
}

// Creates a new instance of the ProcessModuleInfoCollectionPage type.
func NewProcessModuleInfoCollectionPage(getNextPage func(context.Context, ProcessModuleInfoCollection) (ProcessModuleInfoCollection, error)) ProcessModuleInfoCollectionPage {
	return ProcessModuleInfoCollectionPage{fn: getNextPage}
}

// ProcessModuleInfoProperties processModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	// BaseAddress - Base address. Used as module identifier in ARM resource URI.
	BaseAddress *string `json:"baseAddress,omitempty"`
	// FileName - File name.
	FileName *string `json:"fileName,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// FilePath - File path.
	FilePath *string `json:"filePath,omitempty"`
	// ModuleMemorySize - Module memory size.
	ModuleMemorySize *int32 `json:"moduleMemorySize,omitempty"`
	// FileVersion - File version.
	FileVersion *string `json:"fileVersion,omitempty"`
	// FileDescription - File description.
	FileDescription *string `json:"fileDescription,omitempty"`
	// Product - Product name.
	Product *string `json:"product,omitempty"`
	// ProductVersion - Product version.
	ProductVersion *string `json:"productVersion,omitempty"`
	// IsDebug - Is debug?
	IsDebug *bool `json:"isDebug,omitempty"`
	// Language - Module language (locale).
	Language *string `json:"language,omitempty"`
}

// ProcessThreadInfo process Thread Information.
type ProcessThreadInfo struct {
	autorest.Response `json:"-"`
	// ProcessThreadInfoProperties - ProcessThreadInfo resource specific properties
	*ProcessThreadInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessThreadInfo.
func (pti ProcessThreadInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pti.ProcessThreadInfoProperties != nil {
		objectMap["properties"] = pti.ProcessThreadInfoProperties
	}
	if pti.ID != nil {
		objectMap["id"] = pti.ID
	}
	if pti.Name != nil {
		objectMap["name"] = pti.Name
	}
	if pti.Kind != nil {
		objectMap["kind"] = pti.Kind
	}
	if pti.Type != nil {
		objectMap["type"] = pti.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessThreadInfo struct.
func (pti *ProcessThreadInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processThreadInfoProperties ProcessThreadInfoProperties
				err = json.Unmarshal(*v, &processThreadInfoProperties)
				if err != nil {
					return err
				}
				pti.ProcessThreadInfoProperties = &processThreadInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pti.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pti.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pti.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pti.Type = &typeVar
			}
		}
	}

	return nil
}

// ProcessThreadInfoCollection collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessThreadInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProcessThreadInfoCollectionIterator provides access to a complete listing of ProcessThreadInfo values.
type ProcessThreadInfoCollectionIterator struct {
	i    int
	page ProcessThreadInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessThreadInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessThreadInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessThreadInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessThreadInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessThreadInfoCollectionIterator) Response() ProcessThreadInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessThreadInfoCollectionIterator) Value() ProcessThreadInfo {
	if !iter.page.NotDone() {
		return ProcessThreadInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessThreadInfoCollectionIterator type.
func NewProcessThreadInfoCollectionIterator(page ProcessThreadInfoCollectionPage) ProcessThreadInfoCollectionIterator {
	return ProcessThreadInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ptic ProcessThreadInfoCollection) IsEmpty() bool {
	return ptic.Value == nil || len(*ptic.Value) == 0
}

// processThreadInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ptic ProcessThreadInfoCollection) processThreadInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ptic.NextLink == nil || len(to.String(ptic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ptic.NextLink)))
}

// ProcessThreadInfoCollectionPage contains a page of ProcessThreadInfo values.
type ProcessThreadInfoCollectionPage struct {
	fn   func(context.Context, ProcessThreadInfoCollection) (ProcessThreadInfoCollection, error)
	ptic ProcessThreadInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessThreadInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessThreadInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ptic)
	if err != nil {
		return err
	}
	page.ptic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessThreadInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessThreadInfoCollectionPage) NotDone() bool {
	return !page.ptic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessThreadInfoCollectionPage) Response() ProcessThreadInfoCollection {
	return page.ptic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessThreadInfoCollectionPage) Values() []ProcessThreadInfo {
	if page.ptic.IsEmpty() {
		return nil
	}
	return *page.ptic.Value
}

// Creates a new instance of the ProcessThreadInfoCollectionPage type.
func NewProcessThreadInfoCollectionPage(getNextPage func(context.Context, ProcessThreadInfoCollection) (ProcessThreadInfoCollection, error)) ProcessThreadInfoCollectionPage {
	return ProcessThreadInfoCollectionPage{fn: getNextPage}
}

// ProcessThreadInfoProperties processThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	// ID - ARM Identifier for deployment.
	ID *int32 `json:"id,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// Process - Process URI.
	Process *string `json:"process,omitempty"`
	// StartAddress - Start address.
	StartAddress *string `json:"startAddress,omitempty"`
	// CurrentPriority - Current thread priority.
	CurrentPriority *int32 `json:"currentPriority,omitempty"`
	// PriorityLevel - Thread priority level.
	PriorityLevel *string `json:"priorityLevel,omitempty"`
	// BasePriority - Base priority.
	BasePriority *int32 `json:"basePriority,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// TotalProcessorTime - Total processor time.
	TotalProcessorTime *string `json:"totalProcessorTime,omitempty"`
	// UserProcessorTime - User processor time.
	UserProcessorTime *string `json:"userProcessorTime,omitempty"`
	// PriviledgedProcessorTime - Priviledged processor time.
	PriviledgedProcessorTime *string `json:"priviledgedProcessorTime,omitempty"`
	// State - Thread state.
	State *string `json:"state,omitempty"`
	// WaitReason - Wait reason.
	WaitReason *string `json:"waitReason,omitempty"`
}

// ProxyOnlyResource azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// PublicCertificate public certificate object
type PublicCertificate struct {
	autorest.Response `json:"-"`
	// PublicCertificateProperties - PublicCertificate resource specific properties
	*PublicCertificateProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicCertificate.
func (pc PublicCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PublicCertificateProperties != nil {
		objectMap["properties"] = pc.PublicCertificateProperties
	}
	if pc.ID != nil {
		objectMap["id"] = pc.ID
	}
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Kind != nil {
		objectMap["kind"] = pc.Kind
	}
	if pc.Type != nil {
		objectMap["type"] = pc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicCertificate struct.
func (pc *PublicCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicCertificateProperties PublicCertificateProperties
				err = json.Unmarshal(*v, &publicCertificateProperties)
				if err != nil {
					return err
				}
				pc.PublicCertificateProperties = &publicCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PublicCertificateCollection collection of public certificates
type PublicCertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PublicCertificate `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicCertificateCollectionIterator provides access to a complete listing of PublicCertificate values.
type PublicCertificateCollectionIterator struct {
	i    int
	page PublicCertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicCertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicCertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicCertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicCertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicCertificateCollectionIterator) Response() PublicCertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicCertificateCollectionIterator) Value() PublicCertificate {
	if !iter.page.NotDone() {
		return PublicCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicCertificateCollectionIterator type.
func NewPublicCertificateCollectionIterator(page PublicCertificateCollectionPage) PublicCertificateCollectionIterator {
	return PublicCertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcc PublicCertificateCollection) IsEmpty() bool {
	return pcc.Value == nil || len(*pcc.Value) == 0
}

// publicCertificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcc PublicCertificateCollection) publicCertificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pcc.NextLink == nil || len(to.String(pcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcc.NextLink)))
}

// PublicCertificateCollectionPage contains a page of PublicCertificate values.
type PublicCertificateCollectionPage struct {
	fn  func(context.Context, PublicCertificateCollection) (PublicCertificateCollection, error)
	pcc PublicCertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicCertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicCertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcc)
	if err != nil {
		return err
	}
	page.pcc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicCertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicCertificateCollectionPage) NotDone() bool {
	return !page.pcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicCertificateCollectionPage) Response() PublicCertificateCollection {
	return page.pcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicCertificateCollectionPage) Values() []PublicCertificate {
	if page.pcc.IsEmpty() {
		return nil
	}
	return *page.pcc.Value
}

// Creates a new instance of the PublicCertificateCollectionPage type.
func NewPublicCertificateCollectionPage(getNextPage func(context.Context, PublicCertificateCollection) (PublicCertificateCollection, error)) PublicCertificateCollectionPage {
	return PublicCertificateCollectionPage{fn: getNextPage}
}

// PublicCertificateProperties publicCertificate resource specific properties
type PublicCertificateProperties struct {
	// Blob - Public Certificate byte array
	Blob *[]byte `json:"blob,omitempty"`
	// PublicCertificateLocation - Public Certificate Location. Possible values include: 'PublicCertificateLocationCurrentUserMy', 'PublicCertificateLocationLocalMachineMy', 'PublicCertificateLocationUnknown'
	PublicCertificateLocation PublicCertificateLocation `json:"publicCertificateLocation,omitempty"`
	// Thumbprint - Certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// PushSettings push settings for the App.
type PushSettings struct {
	autorest.Response `json:"-"`
	// PushSettingsProperties - PushSettings resource specific properties
	*PushSettingsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PushSettings.
func (ps PushSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.PushSettingsProperties != nil {
		objectMap["properties"] = ps.PushSettingsProperties
	}
	if ps.ID != nil {
		objectMap["id"] = ps.ID
	}
	if ps.Name != nil {
		objectMap["name"] = ps.Name
	}
	if ps.Kind != nil {
		objectMap["kind"] = ps.Kind
	}
	if ps.Type != nil {
		objectMap["type"] = ps.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PushSettings struct.
func (ps *PushSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pushSettingsProperties PushSettingsProperties
				err = json.Unmarshal(*v, &pushSettingsProperties)
				if err != nil {
					return err
				}
				ps.PushSettingsProperties = &pushSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ps.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		}
	}

	return nil
}

// PushSettingsProperties pushSettings resource specific properties
type PushSettingsProperties struct {
	// IsPushEnabled - Gets or sets a flag indicating whether the Push endpoint is enabled.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// TagWhitelistJSON - Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
	TagWhitelistJSON *string `json:"tagWhitelistJson,omitempty"`
	// TagsRequiringAuth - Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
	// Tags can consist of alphanumeric characters and the following:
	// '_', '@', '#', '.', ':', '-'.
	// Validation should be performed at the PushRequestHandler.
	TagsRequiringAuth *string `json:"tagsRequiringAuth,omitempty"`
	// DynamicTagsJSON - Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
	DynamicTagsJSON *string `json:"dynamicTagsJson,omitempty"`
}

// RampUpRule routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
// to gradually change routing % based on performance.
type RampUpRule struct {
	// ActionHostName - Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
	ActionHostName *string `json:"actionHostName,omitempty"`
	// ReroutePercentage - Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
	ReroutePercentage *float64 `json:"reroutePercentage,omitempty"`
	// ChangeStep - In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches
	// <code>MinReroutePercentage</code> or <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.
	// Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
	ChangeStep *float64 `json:"changeStep,omitempty"`
	// ChangeIntervalInMinutes - Specifies interval in minutes to reevaluate ReroutePercentage.
	ChangeIntervalInMinutes *int32 `json:"changeIntervalInMinutes,omitempty"`
	// MinReroutePercentage - Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64 `json:"minReroutePercentage,omitempty"`
	// MaxReroutePercentage - Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64 `json:"maxReroutePercentage,omitempty"`
	// ChangeDecisionCallbackURL - Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
	// https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string `json:"changeDecisionCallbackUrl,omitempty"`
	// Name - Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Recommendation represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	// RecommendationProperties - Recommendation resource specific properties
	*RecommendationProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Recommendation.
func (r Recommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RecommendationProperties != nil {
		objectMap["properties"] = r.RecommendationProperties
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Kind != nil {
		objectMap["kind"] = r.Kind
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Recommendation struct.
func (r *Recommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendationProperties RecommendationProperties
				err = json.Unmarshal(*v, &recommendationProperties)
				if err != nil {
					return err
				}
				r.RecommendationProperties = &recommendationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				r.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendationCollection collection of recommendations.
type RecommendationCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Recommendation `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecommendationCollectionIterator provides access to a complete listing of Recommendation values.
type RecommendationCollectionIterator struct {
	i    int
	page RecommendationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecommendationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecommendationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecommendationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecommendationCollectionIterator) Response() RecommendationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecommendationCollectionIterator) Value() Recommendation {
	if !iter.page.NotDone() {
		return Recommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecommendationCollectionIterator type.
func NewRecommendationCollectionIterator(page RecommendationCollectionPage) RecommendationCollectionIterator {
	return RecommendationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc RecommendationCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// recommendationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc RecommendationCollection) recommendationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rc.NextLink == nil || len(to.String(rc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// RecommendationCollectionPage contains a page of Recommendation values.
type RecommendationCollectionPage struct {
	fn func(context.Context, RecommendationCollection) (RecommendationCollection, error)
	rc RecommendationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecommendationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rc)
	if err != nil {
		return err
	}
	page.rc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecommendationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecommendationCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecommendationCollectionPage) Response() RecommendationCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecommendationCollectionPage) Values() []Recommendation {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the RecommendationCollectionPage type.
func NewRecommendationCollectionPage(getNextPage func(context.Context, RecommendationCollection) (RecommendationCollection, error)) RecommendationCollectionPage {
	return RecommendationCollectionPage{fn: getNextPage}
}

// RecommendationProperties recommendation resource specific properties
type RecommendationProperties struct {
	// CreationTime - Timestamp when this instance was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// RecommendationID - A GUID value that each recommendation object is associated with.
	RecommendationID *uuid.UUID `json:"recommendationId,omitempty"`
	// ResourceID - Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceScope - Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site. Possible values include: 'ServerFarm', 'Subscription', 'WebSite'
	ResourceScope ResourceScopeType `json:"resourceScope,omitempty"`
	// RuleName - Unique name of the rule.
	RuleName *string `json:"ruleName,omitempty"`
	// DisplayName - UI friendly name of the rule (may not be unique).
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Recommendation text.
	Message *string `json:"message,omitempty"`
	// Level - Level indicating how critical this recommendation can impact. Possible values include: 'NotificationLevelCritical', 'NotificationLevelWarning', 'NotificationLevelInformation', 'NotificationLevelNonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of channels that this recommendation can apply. Possible values include: 'Notification', 'API', 'Email', 'Webhook', 'All'
	Channels Channels `json:"channels,omitempty"`
	// Tags - The list of category tags that this recommendation belongs to.
	Tags *[]string `json:"tags,omitempty"`
	// ActionName - Name of action recommended by this object.
	ActionName *string `json:"actionName,omitempty"`
	// StartTime - The beginning time in UTC of a range that the recommendation refers to.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time in UTC of a range that the recommendation refers to.
	EndTime *date.Time `json:"endTime,omitempty"`
	// NextNotificationTime - When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
	NextNotificationTime *date.Time `json:"nextNotificationTime,omitempty"`
	// NotificationExpirationTime - Date and time in UTC when this notification expires.
	NotificationExpirationTime *date.Time `json:"notificationExpirationTime,omitempty"`
	// NotifiedTime - Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *date.Time `json:"notifiedTime,omitempty"`
	// Score - A metric value measured by the rule.
	Score *float64 `json:"score,omitempty"`
	// IsDynamic - True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// ExtensionName - Extension name of the portal if exists.
	ExtensionName *string `json:"extensionName,omitempty"`
	// BladeName - Deep link to a blade on the portal.
	BladeName *string `json:"bladeName,omitempty"`
	// ForwardLink - Forward link to an external document associated with the rule.
	ForwardLink *string `json:"forwardLink,omitempty"`
}

// RecommendationRule represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	autorest.Response `json:"-"`
	// RecommendationRuleProperties - RecommendationRule resource specific properties
	*RecommendationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationRule.
func (rr RecommendationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RecommendationRuleProperties != nil {
		objectMap["properties"] = rr.RecommendationRuleProperties
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendationRule struct.
func (rr *RecommendationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendationRuleProperties RecommendationRuleProperties
				err = json.Unmarshal(*v, &recommendationRuleProperties)
				if err != nil {
					return err
				}
				rr.RecommendationRuleProperties = &recommendationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendationRuleProperties recommendationRule resource specific properties
type RecommendationRuleProperties struct {
	// Name - Unique name of the rule.
	Name *string `json:"name,omitempty"`
	// DisplayName - UI friendly name of the rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Localized name of the rule (Good for UI).
	Message *string `json:"message,omitempty"`
	// RecommendationID - Recommendation ID of an associated recommendation object tied to the rule, if exists.
	// If such an object doesn't exist, it is set to null.
	RecommendationID *uuid.UUID `json:"recommendationId,omitempty"`
	// Description - Localized detailed description of the rule.
	Description *string `json:"description,omitempty"`
	// ActionName - Name of action that is recommended by this rule in string.
	ActionName *string `json:"actionName,omitempty"`
	// Level - Level of impact indicating how critical this rule is. Possible values include: 'NotificationLevelCritical', 'NotificationLevelWarning', 'NotificationLevelInformation', 'NotificationLevelNonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of available channels that this rule applies. Possible values include: 'Notification', 'API', 'Email', 'Webhook', 'All'
	Channels Channels `json:"channels,omitempty"`
	// Tags - An array of category tags that the rule contains.
	Tags *[]string `json:"tags,omitempty"`
	// IsDynamic - True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// ExtensionName - Extension name of the portal if exists. Applicable to dynamic rule only.
	ExtensionName *string `json:"extensionName,omitempty"`
	// BladeName - Deep link to a blade on the portal. Applicable to dynamic rule only.
	BladeName *string `json:"bladeName,omitempty"`
	// ForwardLink - Forward link to an external document associated with the rule. Applicable to dynamic rule only.
	ForwardLink *string `json:"forwardLink,omitempty"`
}

// ReissueCertificateOrderRequest class representing certificate reissue request.
type ReissueCertificateOrderRequest struct {
	// ReissueCertificateOrderRequestProperties - ReissueCertificateOrderRequest resource specific properties
	*ReissueCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReissueCertificateOrderRequest.
func (rcor ReissueCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.ReissueCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.ReissueCertificateOrderRequestProperties
	}
	if rcor.ID != nil {
		objectMap["id"] = rcor.ID
	}
	if rcor.Name != nil {
		objectMap["name"] = rcor.Name
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.Type != nil {
		objectMap["type"] = rcor.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReissueCertificateOrderRequest struct.
func (rcor *ReissueCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reissueCertificateOrderRequestProperties ReissueCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &reissueCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.ReissueCertificateOrderRequestProperties = &reissueCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		}
	}

	return nil
}

// ReissueCertificateOrderRequestProperties reissueCertificateOrderRequest resource specific properties
type ReissueCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
	// DelayExistingRevokeInHours - Delay in hours to revoke existing certificate after the new certificate is issued.
	DelayExistingRevokeInHours *int32 `json:"delayExistingRevokeInHours,omitempty"`
	// Csr - Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`
	// IsPrivateKeyExternal - Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
}

// RelayServiceConnectionEntity hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	autorest.Response `json:"-"`
	// RelayServiceConnectionEntityProperties - RelayServiceConnectionEntity resource specific properties
	*RelayServiceConnectionEntityProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelayServiceConnectionEntity.
func (rsce RelayServiceConnectionEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsce.RelayServiceConnectionEntityProperties != nil {
		objectMap["properties"] = rsce.RelayServiceConnectionEntityProperties
	}
	if rsce.ID != nil {
		objectMap["id"] = rsce.ID
	}
	if rsce.Name != nil {
		objectMap["name"] = rsce.Name
	}
	if rsce.Kind != nil {
		objectMap["kind"] = rsce.Kind
	}
	if rsce.Type != nil {
		objectMap["type"] = rsce.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelayServiceConnectionEntity struct.
func (rsce *RelayServiceConnectionEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relayServiceConnectionEntityProperties RelayServiceConnectionEntityProperties
				err = json.Unmarshal(*v, &relayServiceConnectionEntityProperties)
				if err != nil {
					return err
				}
				rsce.RelayServiceConnectionEntityProperties = &relayServiceConnectionEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rsce.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsce.Type = &typeVar
			}
		}
	}

	return nil
}

// RelayServiceConnectionEntityProperties relayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	EntityName               *string `json:"entityName,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
}

// Rendering instructions for rendering the data
type Rendering struct {
	// RenderingType - Rendering Type. Possible values include: 'NoGraph', 'Table', 'TimeSeries', 'TimeSeriesPerInstance'
	RenderingType RenderingType `json:"renderingType,omitempty"`
	// Title - Title of data
	Title *string `json:"title,omitempty"`
	// Description - Description of the data that will help it be interpreted
	Description *string `json:"description,omitempty"`
}

// RenewCertificateOrderRequest class representing certificate renew request.
type RenewCertificateOrderRequest struct {
	// RenewCertificateOrderRequestProperties - RenewCertificateOrderRequest resource specific properties
	*RenewCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RenewCertificateOrderRequest.
func (rcor RenewCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.RenewCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.RenewCertificateOrderRequestProperties
	}
	if rcor.ID != nil {
		objectMap["id"] = rcor.ID
	}
	if rcor.Name != nil {
		objectMap["name"] = rcor.Name
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.Type != nil {
		objectMap["type"] = rcor.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RenewCertificateOrderRequest struct.
func (rcor *RenewCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var renewCertificateOrderRequestProperties RenewCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &renewCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.RenewCertificateOrderRequestProperties = &renewCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		}
	}

	return nil
}

// RenewCertificateOrderRequestProperties renewCertificateOrderRequest resource specific properties
type RenewCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
	// Csr - Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`
	// IsPrivateKeyExternal - Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
}

// RequestsBasedTrigger trigger based on total requests.
type RequestsBasedTrigger struct {
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Kind != nil {
		objectMap["kind"] = r.Kind
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceCollection collection of resources.
type ResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]string `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceCollectionIterator provides access to a complete listing of string values.
type ResourceCollectionIterator struct {
	i    int
	page ResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceCollectionIterator) Response() ResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceCollectionIterator) Value() string {
	if !iter.page.NotDone() {
		return ""
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceCollectionIterator type.
func NewResourceCollectionIterator(page ResourceCollectionPage) ResourceCollectionIterator {
	return ResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ResourceCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// resourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ResourceCollection) resourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rc.NextLink == nil || len(to.String(rc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ResourceCollectionPage contains a page of string values.
type ResourceCollectionPage struct {
	fn func(context.Context, ResourceCollection) (ResourceCollection, error)
	rc ResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rc)
	if err != nil {
		return err
	}
	page.rc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceCollectionPage) Response() ResourceCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceCollectionPage) Values() []string {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the ResourceCollectionPage type.
func NewResourceCollectionPage(getNextPage func(context.Context, ResourceCollection) (ResourceCollection, error)) ResourceCollectionPage {
	return ResourceCollectionPage{fn: getNextPage}
}

// ResourceHealthMetadata used for getting ResourceHealthCheck settings.
type ResourceHealthMetadata struct {
	autorest.Response `json:"-"`
	// ResourceHealthMetadataProperties - ResourceHealthMetadata resource specific properties
	*ResourceHealthMetadataProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceHealthMetadata.
func (rhm ResourceHealthMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rhm.ResourceHealthMetadataProperties != nil {
		objectMap["properties"] = rhm.ResourceHealthMetadataProperties
	}
	if rhm.ID != nil {
		objectMap["id"] = rhm.ID
	}
	if rhm.Name != nil {
		objectMap["name"] = rhm.Name
	}
	if rhm.Kind != nil {
		objectMap["kind"] = rhm.Kind
	}
	if rhm.Type != nil {
		objectMap["type"] = rhm.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceHealthMetadata struct.
func (rhm *ResourceHealthMetadata) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceHealthMetadataProperties ResourceHealthMetadataProperties
				err = json.Unmarshal(*v, &resourceHealthMetadataProperties)
				if err != nil {
					return err
				}
				rhm.ResourceHealthMetadataProperties = &resourceHealthMetadataProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rhm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rhm.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rhm.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rhm.Type = &typeVar
			}
		}
	}

	return nil
}

// ResourceHealthMetadataCollection collection of resource health metadata.
type ResourceHealthMetadataCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ResourceHealthMetadata `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceHealthMetadataCollectionIterator provides access to a complete listing of ResourceHealthMetadata
// values.
type ResourceHealthMetadataCollectionIterator struct {
	i    int
	page ResourceHealthMetadataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceHealthMetadataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceHealthMetadataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceHealthMetadataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceHealthMetadataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceHealthMetadataCollectionIterator) Response() ResourceHealthMetadataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceHealthMetadataCollectionIterator) Value() ResourceHealthMetadata {
	if !iter.page.NotDone() {
		return ResourceHealthMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceHealthMetadataCollectionIterator type.
func NewResourceHealthMetadataCollectionIterator(page ResourceHealthMetadataCollectionPage) ResourceHealthMetadataCollectionIterator {
	return ResourceHealthMetadataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rhmc ResourceHealthMetadataCollection) IsEmpty() bool {
	return rhmc.Value == nil || len(*rhmc.Value) == 0
}

// resourceHealthMetadataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rhmc ResourceHealthMetadataCollection) resourceHealthMetadataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rhmc.NextLink == nil || len(to.String(rhmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rhmc.NextLink)))
}

// ResourceHealthMetadataCollectionPage contains a page of ResourceHealthMetadata values.
type ResourceHealthMetadataCollectionPage struct {
	fn   func(context.Context, ResourceHealthMetadataCollection) (ResourceHealthMetadataCollection, error)
	rhmc ResourceHealthMetadataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceHealthMetadataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceHealthMetadataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rhmc)
	if err != nil {
		return err
	}
	page.rhmc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceHealthMetadataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceHealthMetadataCollectionPage) NotDone() bool {
	return !page.rhmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceHealthMetadataCollectionPage) Response() ResourceHealthMetadataCollection {
	return page.rhmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceHealthMetadataCollectionPage) Values() []ResourceHealthMetadata {
	if page.rhmc.IsEmpty() {
		return nil
	}
	return *page.rhmc.Value
}

// Creates a new instance of the ResourceHealthMetadataCollectionPage type.
func NewResourceHealthMetadataCollectionPage(getNextPage func(context.Context, ResourceHealthMetadataCollection) (ResourceHealthMetadataCollection, error)) ResourceHealthMetadataCollectionPage {
	return ResourceHealthMetadataCollectionPage{fn: getNextPage}
}

// ResourceHealthMetadataProperties resourceHealthMetadata resource specific properties
type ResourceHealthMetadataProperties struct {
	// Category - The category that the resource matches in the RHC Policy File
	Category *string `json:"category,omitempty"`
	// SignalAvailability - Is there a health signal for the resource
	SignalAvailability *bool `json:"signalAvailability,omitempty"`
}

// ResourceMetric object representing a metric for any resource .
type ResourceMetric struct {
	// Name - Name of metric.
	Name *ResourceMetricName `json:"name,omitempty"`
	// Unit - Metric unit.
	Unit *string `json:"unit,omitempty"`
	// TimeGrain - Metric granularity. E.g PT1H, PT5M, P1D
	TimeGrain *string `json:"timeGrain,omitempty"`
	// StartTime - Metric start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Metric end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ResourceID - Metric resource Id.
	ResourceID *string `json:"resourceId,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// MetricValues - Metric values.
	MetricValues *[]ResourceMetricValue `json:"metricValues,omitempty"`
	// Properties - Resource metric properties collection.
	Properties *[]ResourceMetricProperty `json:"properties,omitempty"`
}

// ResourceMetricAvailability metrics availability and retention.
type ResourceMetricAvailability struct {
	// TimeGrain - Time grain .
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - Retention period for the current time grain.
	Retention *string `json:"retention,omitempty"`
}

// ResourceMetricCollection collection of metric responses.
type ResourceMetricCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ResourceMetric `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceMetricCollectionIterator provides access to a complete listing of ResourceMetric values.
type ResourceMetricCollectionIterator struct {
	i    int
	page ResourceMetricCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceMetricCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceMetricCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceMetricCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceMetricCollectionIterator) Response() ResourceMetricCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceMetricCollectionIterator) Value() ResourceMetric {
	if !iter.page.NotDone() {
		return ResourceMetric{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceMetricCollectionIterator type.
func NewResourceMetricCollectionIterator(page ResourceMetricCollectionPage) ResourceMetricCollectionIterator {
	return ResourceMetricCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmc ResourceMetricCollection) IsEmpty() bool {
	return rmc.Value == nil || len(*rmc.Value) == 0
}

// resourceMetricCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmc ResourceMetricCollection) resourceMetricCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rmc.NextLink == nil || len(to.String(rmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmc.NextLink)))
}

// ResourceMetricCollectionPage contains a page of ResourceMetric values.
type ResourceMetricCollectionPage struct {
	fn  func(context.Context, ResourceMetricCollection) (ResourceMetricCollection, error)
	rmc ResourceMetricCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceMetricCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rmc)
	if err != nil {
		return err
	}
	page.rmc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceMetricCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceMetricCollectionPage) NotDone() bool {
	return !page.rmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceMetricCollectionPage) Response() ResourceMetricCollection {
	return page.rmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceMetricCollectionPage) Values() []ResourceMetric {
	if page.rmc.IsEmpty() {
		return nil
	}
	return *page.rmc.Value
}

// Creates a new instance of the ResourceMetricCollectionPage type.
func NewResourceMetricCollectionPage(getNextPage func(context.Context, ResourceMetricCollection) (ResourceMetricCollection, error)) ResourceMetricCollectionPage {
	return ResourceMetricCollectionPage{fn: getNextPage}
}

// ResourceMetricDefinition metadata for the metrics.
type ResourceMetricDefinition struct {
	// ResourceMetricDefinitionProperties - ResourceMetricDefinition resource specific properties
	*ResourceMetricDefinitionProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceMetricDefinition.
func (rmd ResourceMetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmd.ResourceMetricDefinitionProperties != nil {
		objectMap["properties"] = rmd.ResourceMetricDefinitionProperties
	}
	if rmd.ID != nil {
		objectMap["id"] = rmd.ID
	}
	if rmd.Name != nil {
		objectMap["name"] = rmd.Name
	}
	if rmd.Kind != nil {
		objectMap["kind"] = rmd.Kind
	}
	if rmd.Type != nil {
		objectMap["type"] = rmd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceMetricDefinition struct.
func (rmd *ResourceMetricDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceMetricDefinitionProperties ResourceMetricDefinitionProperties
				err = json.Unmarshal(*v, &resourceMetricDefinitionProperties)
				if err != nil {
					return err
				}
				rmd.ResourceMetricDefinitionProperties = &resourceMetricDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rmd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmd.Type = &typeVar
			}
		}
	}

	return nil
}

// ResourceMetricDefinitionCollection collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ResourceMetricDefinition `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceMetricDefinitionCollectionIterator provides access to a complete listing of
// ResourceMetricDefinition values.
type ResourceMetricDefinitionCollectionIterator struct {
	i    int
	page ResourceMetricDefinitionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceMetricDefinitionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricDefinitionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceMetricDefinitionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceMetricDefinitionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceMetricDefinitionCollectionIterator) Response() ResourceMetricDefinitionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceMetricDefinitionCollectionIterator) Value() ResourceMetricDefinition {
	if !iter.page.NotDone() {
		return ResourceMetricDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceMetricDefinitionCollectionIterator type.
func NewResourceMetricDefinitionCollectionIterator(page ResourceMetricDefinitionCollectionPage) ResourceMetricDefinitionCollectionIterator {
	return ResourceMetricDefinitionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmdc ResourceMetricDefinitionCollection) IsEmpty() bool {
	return rmdc.Value == nil || len(*rmdc.Value) == 0
}

// resourceMetricDefinitionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmdc ResourceMetricDefinitionCollection) resourceMetricDefinitionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rmdc.NextLink == nil || len(to.String(rmdc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmdc.NextLink)))
}

// ResourceMetricDefinitionCollectionPage contains a page of ResourceMetricDefinition values.
type ResourceMetricDefinitionCollectionPage struct {
	fn   func(context.Context, ResourceMetricDefinitionCollection) (ResourceMetricDefinitionCollection, error)
	rmdc ResourceMetricDefinitionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceMetricDefinitionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricDefinitionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rmdc)
	if err != nil {
		return err
	}
	page.rmdc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceMetricDefinitionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceMetricDefinitionCollectionPage) NotDone() bool {
	return !page.rmdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceMetricDefinitionCollectionPage) Response() ResourceMetricDefinitionCollection {
	return page.rmdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceMetricDefinitionCollectionPage) Values() []ResourceMetricDefinition {
	if page.rmdc.IsEmpty() {
		return nil
	}
	return *page.rmdc.Value
}

// Creates a new instance of the ResourceMetricDefinitionCollectionPage type.
func NewResourceMetricDefinitionCollectionPage(getNextPage func(context.Context, ResourceMetricDefinitionCollection) (ResourceMetricDefinitionCollection, error)) ResourceMetricDefinitionCollectionPage {
	return ResourceMetricDefinitionCollectionPage{fn: getNextPage}
}

// ResourceMetricDefinitionProperties resourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	// Name - Name of the metric.
	Name *ResourceMetricName `json:"name,omitempty"`
	// Unit - Unit of the metric.
	Unit *string `json:"unit,omitempty"`
	// PrimaryAggregationType - Primary aggregation type.
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty"`
	// MetricAvailabilities - List of time grains supported for the metric together with retention period.
	MetricAvailabilities *[]ResourceMetricAvailability `json:"metricAvailabilities,omitempty"`
	// ResourceURI - Resource URI.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Properties - Resource metric definition properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ResourceMetricDefinitionProperties.
func (rmd ResourceMetricDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmd.Name != nil {
		objectMap["name"] = rmd.Name
	}
	if rmd.Unit != nil {
		objectMap["unit"] = rmd.Unit
	}
	if rmd.PrimaryAggregationType != nil {
		objectMap["primaryAggregationType"] = rmd.PrimaryAggregationType
	}
	if rmd.MetricAvailabilities != nil {
		objectMap["metricAvailabilities"] = rmd.MetricAvailabilities
	}
	if rmd.ResourceURI != nil {
		objectMap["resourceUri"] = rmd.ResourceURI
	}
	if rmd.ID != nil {
		objectMap["id"] = rmd.ID
	}
	if rmd.Properties != nil {
		objectMap["properties"] = rmd.Properties
	}
	return json.Marshal(objectMap)
}

// ResourceMetricName name of a metric for any resource .
type ResourceMetricName struct {
	// Value - metric name value.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized metric name value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ResourceMetricProperty resource metric property.
type ResourceMetricProperty struct {
	// Key - Key for resource metric property.
	Key *string `json:"key,omitempty"`
	// Value - Value of pair.
	Value *string `json:"value,omitempty"`
}

// ResourceMetricValue value of resource metric.
type ResourceMetricValue struct {
	// Timestamp - Value timestamp.
	Timestamp *string `json:"timestamp,omitempty"`
	// Average - Value average.
	Average *float64 `json:"average,omitempty"`
	// Minimum - Value minimum.
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - Value maximum.
	Maximum *float64 `json:"maximum,omitempty"`
	// Total - Value total.
	Total *float64 `json:"total,omitempty"`
	// Count - Value count.
	Count *float64 `json:"count,omitempty"`
	// Properties - Resource metric properties collection.
	Properties *[]ResourceMetricProperty `json:"properties,omitempty"`
}

// ResourceNameAvailability information regarding availbility of a resource name.
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - <code>true</code> indicates name is valid and available. <code>false</code> indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - <code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason InAvailabilityReasonType `json:"reason,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'CheckNameResourceTypesSite', 'CheckNameResourceTypesSlot', 'CheckNameResourceTypesHostingEnvironment', 'CheckNameResourceTypesPublishingUser', 'CheckNameResourceTypesMicrosoftWebsites', 'CheckNameResourceTypesMicrosoftWebsitesslots', 'CheckNameResourceTypesMicrosoftWebhostingEnvironments', 'CheckNameResourceTypesMicrosoftWebpublishingUsers'
	Type CheckNameResourceTypes `json:"type,omitempty"`
	// IsFqdn - Is fully qualified domain name.
	IsFqdn *bool `json:"isFqdn,omitempty"`
}

// ResponseMetaData ...
type ResponseMetaData struct {
	// DataSource - Source of the Data
	DataSource *DataSource `json:"dataSource,omitempty"`
}

// RestoreRequest description of a restore request.
type RestoreRequest struct {
	autorest.Response `json:"-"`
	// RestoreRequestProperties - RestoreRequest resource specific properties
	*RestoreRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreRequest.
func (rr RestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RestoreRequestProperties != nil {
		objectMap["properties"] = rr.RestoreRequestProperties
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreRequest struct.
func (rr *RestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restoreRequestProperties RestoreRequestProperties
				err = json.Unmarshal(*v, &restoreRequestProperties)
				if err != nil {
					return err
				}
				rr.RestoreRequestProperties = &restoreRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		}
	}

	return nil
}

// RestoreRequestProperties restoreRequest resource specific properties
type RestoreRequestProperties struct {
	// StorageAccountURL - SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - Name of a blob which contains the backup.
	BlobName *string `json:"blobName,omitempty"`
	// Overwrite - <code>true</code> if the restore operation can overwrite target app; otherwise, <code>false</code>. <code>true</code> is needed if trying to restore over an existing app.
	Overwrite *bool `json:"overwrite,omitempty"`
	// SiteName - Name of an app.
	SiteName *string `json:"siteName,omitempty"`
	// Databases - Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// IgnoreConflictingHostNames - Changes a logic when restoring an app with custom domains. <code>true</code> to remove custom domains automatically. If <code>false</code>, custom domains are added to
	// the app's object when it is being restored, but that might fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`
	// IgnoreDatabases - Ignore the databases and only restore the site content
	IgnoreDatabases *bool `json:"ignoreDatabases,omitempty"`
	// AppServicePlan - Specify app service plan that will own restored site.
	AppServicePlan *string `json:"appServicePlan,omitempty"`
	// OperationType - Operation type. Possible values include: 'BackupRestoreOperationTypeDefault', 'BackupRestoreOperationTypeClone', 'BackupRestoreOperationTypeRelocation', 'BackupRestoreOperationTypeSnapshot'
	OperationType BackupRestoreOperationType `json:"operationType,omitempty"`
	// AdjustConnectionStrings - <code>true</code> if SiteConfig.ConnectionStrings should be set in new app; otherwise, <code>false</code>.
	AdjustConnectionStrings *bool `json:"adjustConnectionStrings,omitempty"`
	// HostingEnvironment - App Service Environment name, if needed (only when restoring an app to an App Service Environment).
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// RestoreResponse response for an app restore request.
type RestoreResponse struct {
	autorest.Response `json:"-"`
	// RestoreResponseProperties - RestoreResponse resource specific properties
	*RestoreResponseProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreResponse.
func (rr RestoreResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RestoreResponseProperties != nil {
		objectMap["properties"] = rr.RestoreResponseProperties
	}
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreResponse struct.
func (rr *RestoreResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restoreResponseProperties RestoreResponseProperties
				err = json.Unmarshal(*v, &restoreResponseProperties)
				if err != nil {
					return err
				}
				rr.RestoreResponseProperties = &restoreResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		}
	}

	return nil
}

// RestoreResponseProperties restoreResponse resource specific properties
type RestoreResponseProperties struct {
	// OperationID - When server starts the restore process, it will return an operation ID identifying that particular restore operation.
	OperationID *string `json:"operationId,omitempty"`
}

// ServiceSpecification resource metrics service provided by Microsoft.Insights resource provider.
type ServiceSpecification struct {
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Site a web app, a mobile app backend, or an API app.
type Site struct {
	autorest.Response `json:"-"`
	// SiteProperties - Site resource specific properties
	*SiteProperties `json:"properties,omitempty"`
	Identity        *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SiteProperties != nil {
		objectMap["properties"] = s.SiteProperties
	}
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Site struct.
func (s *Site) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteProperties SiteProperties
				err = json.Unmarshal(*v, &siteProperties)
				if err != nil {
					return err
				}
				s.SiteProperties = &siteProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// SiteAuthSettings configuration settings for the Azure App Service Authentication / Authorization
// feature.
type SiteAuthSettings struct {
	autorest.Response `json:"-"`
	// SiteAuthSettingsProperties - SiteAuthSettings resource specific properties
	*SiteAuthSettingsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteAuthSettings.
func (sas SiteAuthSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sas.SiteAuthSettingsProperties != nil {
		objectMap["properties"] = sas.SiteAuthSettingsProperties
	}
	if sas.ID != nil {
		objectMap["id"] = sas.ID
	}
	if sas.Name != nil {
		objectMap["name"] = sas.Name
	}
	if sas.Kind != nil {
		objectMap["kind"] = sas.Kind
	}
	if sas.Type != nil {
		objectMap["type"] = sas.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteAuthSettings struct.
func (sas *SiteAuthSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteAuthSettingsProperties SiteAuthSettingsProperties
				err = json.Unmarshal(*v, &siteAuthSettingsProperties)
				if err != nil {
					return err
				}
				sas.SiteAuthSettingsProperties = &siteAuthSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sas.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sas.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sas.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sas.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteAuthSettingsProperties siteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	// Enabled - <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
	Enabled *bool `json:"enabled,omitempty"`
	// RuntimeVersion - The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
	// The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// UnauthenticatedClientAction - The action to take when an unauthenticated client attempts to access the app. Possible values include: 'RedirectToLoginPage', 'AllowAnonymous'
	UnauthenticatedClientAction UnauthenticatedClientAction `json:"unauthenticatedClientAction,omitempty"`
	// TokenStoreEnabled - <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
	//  The default is <code>false</code>.
	TokenStoreEnabled *bool `json:"tokenStoreEnabled,omitempty"`
	// AllowedExternalRedirectUrls - External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
	// This is an advanced setting typically only needed by Windows Store application backends.
	// Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls *[]string `json:"allowedExternalRedirectUrls,omitempty"`
	// DefaultProvider - The default authentication provider to use when multiple providers are configured.
	// This setting is only needed if multiple providers are configured and the unauthenticated client
	// action is set to "RedirectToLoginPage". Possible values include: 'AzureActiveDirectory', 'Facebook', 'Google', 'MicrosoftAccount', 'Twitter'
	DefaultProvider BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`
	// TokenRefreshExtensionHours - The number of hours after session token expiration that a session token can be used to
	// call the token refresh API. The default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`
	// ClientID - The Client ID of this relying party application, known as the client_id.
	// This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
	// other 3rd party OpenID Connect providers.
	// More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
	// This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
	// Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
	// More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Issuer - The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
	// When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
	// This URI is a case-sensitive identifier for the token issuer.
	// More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string `json:"issuer,omitempty"`
	// AllowedAudiences - Allowed audience values to consider when validating JWTs issued by
	// Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
	// allowed audience, regardless of this setting.
	AllowedAudiences *[]string `json:"allowedAudiences,omitempty"`
	// AdditionalLoginParams - Login parameters to send to the OpenID Connect authorization endpoint when
	// a user logs in. Each parameter must be in the form "key=value".
	AdditionalLoginParams *[]string `json:"additionalLoginParams,omitempty"`
	// GoogleClientID - The OpenID Connect Client ID for the Google web application.
	// This setting is required for enabling Google Sign-In.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string `json:"googleClientId,omitempty"`
	// GoogleClientSecret - The client secret associated with the Google web application.
	// This setting is required for enabling Google Sign-In.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string `json:"googleClientSecret,omitempty"`
	// GoogleOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
	// This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes *[]string `json:"googleOAuthScopes,omitempty"`
	// FacebookAppID - The App ID of the Facebook app used for login.
	// This setting is required for enabling Facebook Login.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string `json:"facebookAppId,omitempty"`
	// FacebookAppSecret - The App Secret of the Facebook app used for Facebook Login.
	// This setting is required for enabling Facebook Login.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string `json:"facebookAppSecret,omitempty"`
	// FacebookOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
	// This setting is optional.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes *[]string `json:"facebookOAuthScopes,omitempty"`
	// TwitterConsumerKey - The OAuth 1.0a consumer key of the Twitter application used for sign-in.
	// This setting is required for enabling Twitter Sign-In.
	// Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string `json:"twitterConsumerKey,omitempty"`
	// TwitterConsumerSecret - The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	// This setting is required for enabling Twitter Sign-In.
	// Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string `json:"twitterConsumerSecret,omitempty"`
	// MicrosoftAccountClientID - The OAuth 2.0 client ID that was created for the app used for authentication.
	// This setting is required for enabling Microsoft Account authentication.
	// Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string `json:"microsoftAccountClientId,omitempty"`
	// MicrosoftAccountClientSecret - The OAuth 2.0 client secret that was created for the app used for authentication.
	// This setting is required for enabling Microsoft Account authentication.
	// Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string `json:"microsoftAccountClientSecret,omitempty"`
	// MicrosoftAccountOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
	// This setting is optional. If not specified, "wl.basic" is used as the default scope.
	// Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes *[]string `json:"microsoftAccountOAuthScopes,omitempty"`
}

// SiteCloneability represents whether or not an app is cloneable.
type SiteCloneability struct {
	autorest.Response `json:"-"`
	// Result - Name of app. Possible values include: 'Cloneable', 'PartiallyCloneable', 'NotCloneable'
	Result CloneAbilityResult `json:"result,omitempty"`
	// BlockingFeatures - List of features enabled on app that prevent cloning.
	BlockingFeatures *[]SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`
	// UnsupportedFeatures - List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned
	// but the features in this list will not be set up on cloned app.
	UnsupportedFeatures *[]SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
	// BlockingCharacteristics - List of blocking application characteristics.
	BlockingCharacteristics *[]SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`
}

// SiteCloneabilityCriterion an app cloneability criterion.
type SiteCloneabilityCriterion struct {
	// Name - Name of criterion.
	Name *string `json:"name,omitempty"`
	// Description - Description of criterion.
	Description *string `json:"description,omitempty"`
}

// SiteConfig configuration of an App Service app.
type SiteConfig struct {
	// NumberOfWorkers - Number of workers.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`
	// DefaultDocuments - Default documents.
	DefaultDocuments *[]string `json:"defaultDocuments,omitempty"`
	// NetFrameworkVersion - .NET Framework version.
	NetFrameworkVersion *string `json:"netFrameworkVersion,omitempty"`
	// PhpVersion - Version of PHP.
	PhpVersion *string `json:"phpVersion,omitempty"`
	// PythonVersion - Version of Python.
	PythonVersion *string `json:"pythonVersion,omitempty"`
	// NodeVersion - Version of Node.js.
	NodeVersion *string `json:"nodeVersion,omitempty"`
	// LinuxFxVersion - Linux App Framework and version
	LinuxFxVersion *string `json:"linuxFxVersion,omitempty"`
	// RequestTracingEnabled - <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
	RequestTracingEnabled *bool `json:"requestTracingEnabled,omitempty"`
	// RequestTracingExpirationTime - Request tracing expiration time.
	RequestTracingExpirationTime *date.Time `json:"requestTracingExpirationTime,omitempty"`
	// RemoteDebuggingEnabled - <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
	RemoteDebuggingEnabled *bool `json:"remoteDebuggingEnabled,omitempty"`
	// RemoteDebuggingVersion - Remote debugging version.
	RemoteDebuggingVersion *string `json:"remoteDebuggingVersion,omitempty"`
	// HTTPLoggingEnabled - <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
	HTTPLoggingEnabled *bool `json:"httpLoggingEnabled,omitempty"`
	// LogsDirectorySizeLimit - HTTP logs directory size limit.
	LogsDirectorySizeLimit *int32 `json:"logsDirectorySizeLimit,omitempty"`
	// DetailedErrorLoggingEnabled - <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
	DetailedErrorLoggingEnabled *bool `json:"detailedErrorLoggingEnabled,omitempty"`
	// PublishingUsername - Publishing user name.
	PublishingUsername *string `json:"publishingUsername,omitempty"`
	// AppSettings - Application settings.
	AppSettings *[]NameValuePair `json:"appSettings,omitempty"`
	// ConnectionStrings - Connection strings.
	ConnectionStrings *[]ConnStringInfo `json:"connectionStrings,omitempty"`
	// MachineKey - Site MachineKey.
	MachineKey *SiteMachineKey `json:"machineKey,omitempty"`
	// HandlerMappings - Handler mappings.
	HandlerMappings *[]HandlerMapping `json:"handlerMappings,omitempty"`
	// DocumentRoot - Document root.
	DocumentRoot *string `json:"documentRoot,omitempty"`
	// ScmType - SCM type. Possible values include: 'ScmTypeNone', 'ScmTypeDropbox', 'ScmTypeTfs', 'ScmTypeLocalGit', 'ScmTypeGitHub', 'ScmTypeCodePlexGit', 'ScmTypeCodePlexHg', 'ScmTypeBitbucketGit', 'ScmTypeBitbucketHg', 'ScmTypeExternalGit', 'ScmTypeExternalHg', 'ScmTypeOneDrive', 'ScmTypeVSO'
	ScmType ScmType `json:"scmType,omitempty"`
	// Use32BitWorkerProcess - <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty"`
	// WebSocketsEnabled - <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
	WebSocketsEnabled *bool `json:"webSocketsEnabled,omitempty"`
	// AlwaysOn - <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
	AlwaysOn *bool `json:"alwaysOn,omitempty"`
	// JavaVersion - Java version.
	JavaVersion *string `json:"javaVersion,omitempty"`
	// JavaContainer - Java container.
	JavaContainer *string `json:"javaContainer,omitempty"`
	// JavaContainerVersion - Java container version.
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty"`
	// AppCommandLine - App command line to launch.
	AppCommandLine *string `json:"appCommandLine,omitempty"`
	// ManagedPipelineMode - Managed pipeline mode. Possible values include: 'Integrated', 'Classic'
	ManagedPipelineMode ManagedPipelineMode `json:"managedPipelineMode,omitempty"`
	// VirtualApplications - Virtual applications.
	VirtualApplications *[]VirtualApplication `json:"virtualApplications,omitempty"`
	// LoadBalancing - Site load balancing. Possible values include: 'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime', 'WeightedTotalTraffic', 'RequestHash'
	LoadBalancing SiteLoadBalancing `json:"loadBalancing,omitempty"`
	// Experiments - This is work around for polymophic types.
	Experiments *Experiments `json:"experiments,omitempty"`
	// Limits - Site limits.
	Limits *SiteLimits `json:"limits,omitempty"`
	// AutoHealEnabled - <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
	AutoHealEnabled *bool `json:"autoHealEnabled,omitempty"`
	// AutoHealRules - Auto Heal rules.
	AutoHealRules *AutoHealRules `json:"autoHealRules,omitempty"`
	// TracingOptions - Tracing options.
	TracingOptions *string `json:"tracingOptions,omitempty"`
	// VnetName - Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
	// Cors - Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings `json:"cors,omitempty"`
	// Push - Push endpoint settings.
	Push *PushSettings `json:"push,omitempty"`
	// APIDefinition - Information about the formal API definition for the app.
	APIDefinition *APIDefinitionInfo `json:"apiDefinition,omitempty"`
	// AutoSwapSlotName - Auto-swap slot name.
	AutoSwapSlotName *string `json:"autoSwapSlotName,omitempty"`
	// LocalMySQLEnabled - <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`
	// IPSecurityRestrictions - IP security restrictions.
	IPSecurityRestrictions *[]IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`
	// HTTP20Enabled - Http20Enabled: configures a web site to allow clients to connect over http2.0
	HTTP20Enabled *bool `json:"http20Enabled,omitempty"`
	// MinTLSVersion - MinTlsVersion: configures the minimum version of TLS required for SSL requests. Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinTLSVersion SupportedTLSVersions `json:"minTlsVersion,omitempty"`
}

// SiteConfigResource web app configuration ARM resource.
type SiteConfigResource struct {
	autorest.Response `json:"-"`
	// SiteConfig - Core resource properties
	*SiteConfig `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigResource.
func (scr SiteConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scr.SiteConfig != nil {
		objectMap["properties"] = scr.SiteConfig
	}
	if scr.ID != nil {
		objectMap["id"] = scr.ID
	}
	if scr.Name != nil {
		objectMap["name"] = scr.Name
	}
	if scr.Kind != nil {
		objectMap["kind"] = scr.Kind
	}
	if scr.Type != nil {
		objectMap["type"] = scr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteConfigResource struct.
func (scr *SiteConfigResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteConfig SiteConfig
				err = json.Unmarshal(*v, &siteConfig)
				if err != nil {
					return err
				}
				scr.SiteConfig = &siteConfig
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scr.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteConfigResourceCollection collection of site configurations.
type SiteConfigResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteConfigResource `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteConfigResourceCollectionIterator provides access to a complete listing of SiteConfigResource values.
type SiteConfigResourceCollectionIterator struct {
	i    int
	page SiteConfigResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteConfigResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteConfigResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteConfigResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteConfigResourceCollectionIterator) Response() SiteConfigResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteConfigResourceCollectionIterator) Value() SiteConfigResource {
	if !iter.page.NotDone() {
		return SiteConfigResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteConfigResourceCollectionIterator type.
func NewSiteConfigResourceCollectionIterator(page SiteConfigResourceCollectionPage) SiteConfigResourceCollectionIterator {
	return SiteConfigResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scrc SiteConfigResourceCollection) IsEmpty() bool {
	return scrc.Value == nil || len(*scrc.Value) == 0
}

// siteConfigResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scrc SiteConfigResourceCollection) siteConfigResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if scrc.NextLink == nil || len(to.String(scrc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scrc.NextLink)))
}

// SiteConfigResourceCollectionPage contains a page of SiteConfigResource values.
type SiteConfigResourceCollectionPage struct {
	fn   func(context.Context, SiteConfigResourceCollection) (SiteConfigResourceCollection, error)
	scrc SiteConfigResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteConfigResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.scrc)
	if err != nil {
		return err
	}
	page.scrc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteConfigResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteConfigResourceCollectionPage) NotDone() bool {
	return !page.scrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteConfigResourceCollectionPage) Response() SiteConfigResourceCollection {
	return page.scrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteConfigResourceCollectionPage) Values() []SiteConfigResource {
	if page.scrc.IsEmpty() {
		return nil
	}
	return *page.scrc.Value
}

// Creates a new instance of the SiteConfigResourceCollectionPage type.
func NewSiteConfigResourceCollectionPage(getNextPage func(context.Context, SiteConfigResourceCollection) (SiteConfigResourceCollection, error)) SiteConfigResourceCollectionPage {
	return SiteConfigResourceCollectionPage{fn: getNextPage}
}

// SiteConfigurationSnapshotInfo a snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	// SiteConfigurationSnapshotInfoProperties - SiteConfigurationSnapshotInfo resource specific properties
	*SiteConfigurationSnapshotInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigurationSnapshotInfo.
func (scsi SiteConfigurationSnapshotInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsi.SiteConfigurationSnapshotInfoProperties != nil {
		objectMap["properties"] = scsi.SiteConfigurationSnapshotInfoProperties
	}
	if scsi.ID != nil {
		objectMap["id"] = scsi.ID
	}
	if scsi.Name != nil {
		objectMap["name"] = scsi.Name
	}
	if scsi.Kind != nil {
		objectMap["kind"] = scsi.Kind
	}
	if scsi.Type != nil {
		objectMap["type"] = scsi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteConfigurationSnapshotInfo struct.
func (scsi *SiteConfigurationSnapshotInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteConfigurationSnapshotInfoProperties SiteConfigurationSnapshotInfoProperties
				err = json.Unmarshal(*v, &siteConfigurationSnapshotInfoProperties)
				if err != nil {
					return err
				}
				scsi.SiteConfigurationSnapshotInfoProperties = &siteConfigurationSnapshotInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scsi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scsi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scsi.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteConfigurationSnapshotInfoCollection collection of metadata for the app configuration snapshots that
// can be restored.
type SiteConfigurationSnapshotInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteConfigurationSnapshotInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteConfigurationSnapshotInfoCollectionIterator provides access to a complete listing of
// SiteConfigurationSnapshotInfo values.
type SiteConfigurationSnapshotInfoCollectionIterator struct {
	i    int
	page SiteConfigurationSnapshotInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteConfigurationSnapshotInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigurationSnapshotInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteConfigurationSnapshotInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) Response() SiteConfigurationSnapshotInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) Value() SiteConfigurationSnapshotInfo {
	if !iter.page.NotDone() {
		return SiteConfigurationSnapshotInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteConfigurationSnapshotInfoCollectionIterator type.
func NewSiteConfigurationSnapshotInfoCollectionIterator(page SiteConfigurationSnapshotInfoCollectionPage) SiteConfigurationSnapshotInfoCollectionIterator {
	return SiteConfigurationSnapshotInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scsic SiteConfigurationSnapshotInfoCollection) IsEmpty() bool {
	return scsic.Value == nil || len(*scsic.Value) == 0
}

// siteConfigurationSnapshotInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scsic SiteConfigurationSnapshotInfoCollection) siteConfigurationSnapshotInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if scsic.NextLink == nil || len(to.String(scsic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scsic.NextLink)))
}

// SiteConfigurationSnapshotInfoCollectionPage contains a page of SiteConfigurationSnapshotInfo values.
type SiteConfigurationSnapshotInfoCollectionPage struct {
	fn    func(context.Context, SiteConfigurationSnapshotInfoCollection) (SiteConfigurationSnapshotInfoCollection, error)
	scsic SiteConfigurationSnapshotInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteConfigurationSnapshotInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigurationSnapshotInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.scsic)
	if err != nil {
		return err
	}
	page.scsic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteConfigurationSnapshotInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteConfigurationSnapshotInfoCollectionPage) NotDone() bool {
	return !page.scsic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteConfigurationSnapshotInfoCollectionPage) Response() SiteConfigurationSnapshotInfoCollection {
	return page.scsic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteConfigurationSnapshotInfoCollectionPage) Values() []SiteConfigurationSnapshotInfo {
	if page.scsic.IsEmpty() {
		return nil
	}
	return *page.scsic.Value
}

// Creates a new instance of the SiteConfigurationSnapshotInfoCollectionPage type.
func NewSiteConfigurationSnapshotInfoCollectionPage(getNextPage func(context.Context, SiteConfigurationSnapshotInfoCollection) (SiteConfigurationSnapshotInfoCollection, error)) SiteConfigurationSnapshotInfoCollectionPage {
	return SiteConfigurationSnapshotInfoCollectionPage{fn: getNextPage}
}

// SiteConfigurationSnapshotInfoProperties siteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	// Time - The time the snapshot was taken.
	Time *date.Time `json:"time,omitempty"`
	// ID - The id of the snapshot
	ID *int32 `json:"id,omitempty"`
}

// SiteExtensionInfo site Extension Information.
type SiteExtensionInfo struct {
	autorest.Response `json:"-"`
	// SiteExtensionInfoProperties - SiteExtensionInfo resource specific properties
	*SiteExtensionInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteExtensionInfo.
func (sei SiteExtensionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sei.SiteExtensionInfoProperties != nil {
		objectMap["properties"] = sei.SiteExtensionInfoProperties
	}
	if sei.ID != nil {
		objectMap["id"] = sei.ID
	}
	if sei.Name != nil {
		objectMap["name"] = sei.Name
	}
	if sei.Kind != nil {
		objectMap["kind"] = sei.Kind
	}
	if sei.Type != nil {
		objectMap["type"] = sei.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteExtensionInfo struct.
func (sei *SiteExtensionInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteExtensionInfoProperties SiteExtensionInfoProperties
				err = json.Unmarshal(*v, &siteExtensionInfoProperties)
				if err != nil {
					return err
				}
				sei.SiteExtensionInfoProperties = &siteExtensionInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sei.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sei.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sei.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteExtensionInfoCollection collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteExtensionInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SiteExtensionInfoCollectionIterator provides access to a complete listing of SiteExtensionInfo values.
type SiteExtensionInfoCollectionIterator struct {
	i    int
	page SiteExtensionInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteExtensionInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteExtensionInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteExtensionInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteExtensionInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteExtensionInfoCollectionIterator) Response() SiteExtensionInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteExtensionInfoCollectionIterator) Value() SiteExtensionInfo {
	if !iter.page.NotDone() {
		return SiteExtensionInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteExtensionInfoCollectionIterator type.
func NewSiteExtensionInfoCollectionIterator(page SiteExtensionInfoCollectionPage) SiteExtensionInfoCollectionIterator {
	return SiteExtensionInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (seic SiteExtensionInfoCollection) IsEmpty() bool {
	return seic.Value == nil || len(*seic.Value) == 0
}

// siteExtensionInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (seic SiteExtensionInfoCollection) siteExtensionInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if seic.NextLink == nil || len(to.String(seic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(seic.NextLink)))
}

// SiteExtensionInfoCollectionPage contains a page of SiteExtensionInfo values.
type SiteExtensionInfoCollectionPage struct {
	fn   func(context.Context, SiteExtensionInfoCollection) (SiteExtensionInfoCollection, error)
	seic SiteExtensionInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteExtensionInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteExtensionInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.seic)
	if err != nil {
		return err
	}
	page.seic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteExtensionInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteExtensionInfoCollectionPage) NotDone() bool {
	return !page.seic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteExtensionInfoCollectionPage) Response() SiteExtensionInfoCollection {
	return page.seic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteExtensionInfoCollectionPage) Values() []SiteExtensionInfo {
	if page.seic.IsEmpty() {
		return nil
	}
	return *page.seic.Value
}

// Creates a new instance of the SiteExtensionInfoCollectionPage type.
func NewSiteExtensionInfoCollectionPage(getNextPage func(context.Context, SiteExtensionInfoCollection) (SiteExtensionInfoCollection, error)) SiteExtensionInfoCollectionPage {
	return SiteExtensionInfoCollectionPage{fn: getNextPage}
}

// SiteExtensionInfoProperties siteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	// ID - Site extension ID.
	ID *string `json:"id,omitempty"`
	// Title - Site extension title.
	Title *string `json:"title,omitempty"`
	// Type - Site extension type. Possible values include: 'Gallery', 'WebRoot'
	Type SiteExtensionType `json:"type,omitempty"`
	// Summary - Summary description.
	Summary *string `json:"summary,omitempty"`
	// Description - Detailed description.
	Description *string `json:"description,omitempty"`
	// Version - Version information.
	Version *string `json:"version,omitempty"`
	// ExtensionURL - Extension URL.
	ExtensionURL *string `json:"extensionUrl,omitempty"`
	// ProjectURL - Project URL.
	ProjectURL *string `json:"projectUrl,omitempty"`
	// IconURL - Icon URL.
	IconURL *string `json:"iconUrl,omitempty"`
	// LicenseURL - License URL.
	LicenseURL *string `json:"licenseUrl,omitempty"`
	// FeedURL - Feed URL.
	FeedURL *string `json:"feedUrl,omitempty"`
	// Authors - List of authors.
	Authors *[]string `json:"authors,omitempty"`
	// InstallationArgs - Installer command line parameters.
	InstallationArgs *string `json:"installationArgs,omitempty"`
	// PublishedDateTime - Published timestamp.
	PublishedDateTime *date.Time `json:"publishedDateTime,omitempty"`
	// DownloadCount - Count of downloads.
	DownloadCount *int32 `json:"downloadCount,omitempty"`
	// LocalIsLatestVersion - <code>true</code> if the local version is the latest version; <code>false</code> otherwise.
	LocalIsLatestVersion *bool `json:"localIsLatestVersion,omitempty"`
	// LocalPath - Local path.
	LocalPath *string `json:"localPath,omitempty"`
	// InstalledDateTime - Installed timestamp.
	InstalledDateTime *date.Time `json:"installedDateTime,omitempty"`
	// ProvisioningState - Provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Comment - Site Extension comment.
	Comment *string `json:"comment,omitempty"`
}

// SiteInstance instance of an app.
type SiteInstance struct {
	// SiteInstanceProperties - SiteInstance resource specific properties
	*SiteInstanceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteInstance.
func (si SiteInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.SiteInstanceProperties != nil {
		objectMap["properties"] = si.SiteInstanceProperties
	}
	if si.ID != nil {
		objectMap["id"] = si.ID
	}
	if si.Name != nil {
		objectMap["name"] = si.Name
	}
	if si.Kind != nil {
		objectMap["kind"] = si.Kind
	}
	if si.Type != nil {
		objectMap["type"] = si.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteInstance struct.
func (si *SiteInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteInstanceProperties SiteInstanceProperties
				err = json.Unmarshal(*v, &siteInstanceProperties)
				if err != nil {
					return err
				}
				si.SiteInstanceProperties = &siteInstanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				si.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				si.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				si.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				si.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteInstanceProperties siteInstance resource specific properties
type SiteInstanceProperties struct {
	// Name - Name of instance.
	Name *string `json:"name,omitempty"`
}

// SiteLimits metric limits set on an app.
type SiteLimits struct {
	// MaxPercentageCPU - Maximum allowed CPU usage percentage.
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
	// MaxMemoryInMb - Maximum allowed memory usage in MB.
	MaxMemoryInMb *int64 `json:"maxMemoryInMb,omitempty"`
	// MaxDiskSizeInMb - Maximum allowed disk size usage in MB.
	MaxDiskSizeInMb *int64 `json:"maxDiskSizeInMb,omitempty"`
}

// SiteLogsConfig configuration of App Service site logs.
type SiteLogsConfig struct {
	autorest.Response `json:"-"`
	// SiteLogsConfigProperties - SiteLogsConfig resource specific properties
	*SiteLogsConfigProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteLogsConfig.
func (slc SiteLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slc.SiteLogsConfigProperties != nil {
		objectMap["properties"] = slc.SiteLogsConfigProperties
	}
	if slc.ID != nil {
		objectMap["id"] = slc.ID
	}
	if slc.Name != nil {
		objectMap["name"] = slc.Name
	}
	if slc.Kind != nil {
		objectMap["kind"] = slc.Kind
	}
	if slc.Type != nil {
		objectMap["type"] = slc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteLogsConfig struct.
func (slc *SiteLogsConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteLogsConfigProperties SiteLogsConfigProperties
				err = json.Unmarshal(*v, &siteLogsConfigProperties)
				if err != nil {
					return err
				}
				slc.SiteLogsConfigProperties = &siteLogsConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				slc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				slc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				slc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				slc.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteLogsConfigProperties siteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	// ApplicationLogs - Application logs configuration.
	ApplicationLogs *ApplicationLogsConfig `json:"applicationLogs,omitempty"`
	// HTTPLogs - HTTP logs configuration.
	HTTPLogs *HTTPLogsConfig `json:"httpLogs,omitempty"`
	// FailedRequestsTracing - Failed requests tracing configuration.
	FailedRequestsTracing *EnabledConfig `json:"failedRequestsTracing,omitempty"`
	// DetailedErrorMessages - Detailed error messages configuration.
	DetailedErrorMessages *EnabledConfig `json:"detailedErrorMessages,omitempty"`
}

// SiteMachineKey machineKey of an app.
type SiteMachineKey struct {
	// Validation - MachineKey validation.
	Validation *string `json:"validation,omitempty"`
	// ValidationKey - Validation key.
	ValidationKey *string `json:"validationKey,omitempty"`
	// Decryption - Algorithm used for decryption.
	Decryption *string `json:"decryption,omitempty"`
	// DecryptionKey - Decryption key.
	DecryptionKey *string `json:"decryptionKey,omitempty"`
}

// SitePatchResource ARM resource for a site.
type SitePatchResource struct {
	// SitePatchResourceProperties - SitePatchResource resource specific properties
	*SitePatchResourceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SitePatchResource.
func (spr SitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spr.SitePatchResourceProperties != nil {
		objectMap["properties"] = spr.SitePatchResourceProperties
	}
	if spr.ID != nil {
		objectMap["id"] = spr.ID
	}
	if spr.Name != nil {
		objectMap["name"] = spr.Name
	}
	if spr.Kind != nil {
		objectMap["kind"] = spr.Kind
	}
	if spr.Type != nil {
		objectMap["type"] = spr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SitePatchResource struct.
func (spr *SitePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sitePatchResourceProperties SitePatchResourceProperties
				err = json.Unmarshal(*v, &sitePatchResourceProperties)
				if err != nil {
					return err
				}
				spr.SitePatchResourceProperties = &sitePatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spr.Type = &typeVar
			}
		}
	}

	return nil
}

// SitePatchResourceProperties sitePatchResource resource specific properties
type SitePatchResourceProperties struct {
	// State - Current state of the app.
	State *string `json:"state,omitempty"`
	// HostNames - Hostnames associated with the app.
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - State indicating whether the app has exceeded its quota usage. Read-only. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,
	// the app is not served on those hostnames.
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - Management information availability state for the app. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// Reserved - <code>true</code> if reserved; otherwise, <code>false</code>.
	Reserved *bool `json:"reserved,omitempty"`
	// LastModifiedTimeUtc - Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// ScmSiteAlsoStopped - <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// ClientAffinityEnabled - <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// HostNamesDisabled - <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
	//  If <code>true</code>, the app is only accessible via API management process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// OutboundIPAddresses - List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// PossibleOutboundIPAddresses - List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty"`
	// ContainerSize - Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// DailyMemoryTimeQuota - Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`
	// SuspendedTill - App suspended till in case memory-time quota is exceeded.
	SuspendedTill *date.Time `json:"suspendedTill,omitempty"`
	// MaxNumberOfWorkers - Maximum number of workers.
	// This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// SnapshotInfo - If specified during app creation, the app is created from a previous snapshot.
	SnapshotInfo *SnapshotRecoveryRequest `json:"snapshotInfo,omitempty"`
	// ResourceGroup - Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - <code>true</code> if the app is a default container; otherwise, <code>false</code>.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty"`
	// SlotSwapStatus - Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty"`
	// HTTPSOnly - HttpsOnly: configures a web site to accept only https requests. Issues redirect for
	// http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
}

// SitePhpErrorLogFlag used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	autorest.Response `json:"-"`
	// SitePhpErrorLogFlagProperties - SitePhpErrorLogFlag resource specific properties
	*SitePhpErrorLogFlagProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SitePhpErrorLogFlag.
func (spelf SitePhpErrorLogFlag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spelf.SitePhpErrorLogFlagProperties != nil {
		objectMap["properties"] = spelf.SitePhpErrorLogFlagProperties
	}
	if spelf.ID != nil {
		objectMap["id"] = spelf.ID
	}
	if spelf.Name != nil {
		objectMap["name"] = spelf.Name
	}
	if spelf.Kind != nil {
		objectMap["kind"] = spelf.Kind
	}
	if spelf.Type != nil {
		objectMap["type"] = spelf.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SitePhpErrorLogFlag struct.
func (spelf *SitePhpErrorLogFlag) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sitePhpErrorLogFlagProperties SitePhpErrorLogFlagProperties
				err = json.Unmarshal(*v, &sitePhpErrorLogFlagProperties)
				if err != nil {
					return err
				}
				spelf.SitePhpErrorLogFlagProperties = &sitePhpErrorLogFlagProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spelf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spelf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spelf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spelf.Type = &typeVar
			}
		}
	}

	return nil
}

// SitePhpErrorLogFlagProperties sitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	// LocalLogErrors - Local log_errors setting.
	LocalLogErrors *string `json:"localLogErrors,omitempty"`
	// MasterLogErrors - Master log_errors setting.
	MasterLogErrors *string `json:"masterLogErrors,omitempty"`
	// LocalLogErrorsMaxLength - Local log_errors_max_len setting.
	LocalLogErrorsMaxLength *string `json:"localLogErrorsMaxLength,omitempty"`
	// MasterLogErrorsMaxLength - Master log_errors_max_len setting.
	MasterLogErrorsMaxLength *string `json:"masterLogErrorsMaxLength,omitempty"`
}

// SiteProperties site resource specific properties
type SiteProperties struct {
	// State - Current state of the app.
	State *string `json:"state,omitempty"`
	// HostNames - Hostnames associated with the app.
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - State indicating whether the app has exceeded its quota usage. Read-only. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,
	// the app is not served on those hostnames.
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - Management information availability state for the app. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// Reserved - <code>true</code> if reserved; otherwise, <code>false</code>.
	Reserved *bool `json:"reserved,omitempty"`
	// LastModifiedTimeUtc - Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// ScmSiteAlsoStopped - <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// ClientAffinityEnabled - <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// HostNamesDisabled - <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
	//  If <code>true</code>, the app is only accessible via API management process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// OutboundIPAddresses - List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// PossibleOutboundIPAddresses - List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty"`
	// ContainerSize - Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// DailyMemoryTimeQuota - Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`
	// SuspendedTill - App suspended till in case memory-time quota is exceeded.
	SuspendedTill *date.Time `json:"suspendedTill,omitempty"`
	// MaxNumberOfWorkers - Maximum number of workers.
	// This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// SnapshotInfo - If specified during app creation, the app is created from a previous snapshot.
	SnapshotInfo *SnapshotRecoveryRequest `json:"snapshotInfo,omitempty"`
	// ResourceGroup - Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - <code>true</code> if the app is a default container; otherwise, <code>false</code>.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty"`
	// SlotSwapStatus - Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty"`
	// HTTPSOnly - HttpsOnly: configures a web site to accept only https requests. Issues redirect for
	// http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
}

// SiteSeal site seal
type SiteSeal struct {
	autorest.Response `json:"-"`
	// HTML - HTML snippet
	HTML *string `json:"html,omitempty"`
}

// SiteSealRequest site seal request.
type SiteSealRequest struct {
	// LightTheme - If <code>true</code> use the light color theme for site seal; otherwise, use the default color theme.
	LightTheme *bool `json:"lightTheme,omitempty"`
	// Locale - Locale of site seal.
	Locale *string `json:"locale,omitempty"`
}

// SiteSourceControl source control configuration for an app.
type SiteSourceControl struct {
	autorest.Response `json:"-"`
	// SiteSourceControlProperties - SiteSourceControl resource specific properties
	*SiteSourceControlProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteSourceControl.
func (ssc SiteSourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssc.SiteSourceControlProperties != nil {
		objectMap["properties"] = ssc.SiteSourceControlProperties
	}
	if ssc.ID != nil {
		objectMap["id"] = ssc.ID
	}
	if ssc.Name != nil {
		objectMap["name"] = ssc.Name
	}
	if ssc.Kind != nil {
		objectMap["kind"] = ssc.Kind
	}
	if ssc.Type != nil {
		objectMap["type"] = ssc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteSourceControl struct.
func (ssc *SiteSourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteSourceControlProperties SiteSourceControlProperties
				err = json.Unmarshal(*v, &siteSourceControlProperties)
				if err != nil {
					return err
				}
				ssc.SiteSourceControlProperties = &siteSourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssc.Type = &typeVar
			}
		}
	}

	return nil
}

// SiteSourceControlProperties siteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	// RepoURL - Repository or source control URL.
	RepoURL *string `json:"repoUrl,omitempty"`
	// Branch - Name of branch to use for deployment.
	Branch *string `json:"branch,omitempty"`
	// IsManualIntegration - <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
	IsManualIntegration *bool `json:"isManualIntegration,omitempty"`
	// DeploymentRollbackEnabled - <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
	DeploymentRollbackEnabled *bool `json:"deploymentRollbackEnabled,omitempty"`
	// IsMercurial - <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
	IsMercurial *bool `json:"isMercurial,omitempty"`
}

// SkuCapacity description of the App Service plan scale options.
type SkuCapacity struct {
	// Minimum - Minimum number of workers for this App Service plan SKU.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum number of workers for this App Service plan SKU.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - Default number of workers for this App Service plan SKU.
	Default *int32 `json:"default,omitempty"`
	// ScaleType - Available scale configurations for an App Service plan.
	ScaleType *string `json:"scaleType,omitempty"`
}

// SkuDescription description of a SKU for a scalable resource.
type SkuDescription struct {
	// Name - Name of the resource SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Service tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
	// Size - Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`
	// Family - Family code of the resource SKU.
	Family *string `json:"family,omitempty"`
	// Capacity - Current number of instances assigned to the resource.
	Capacity *int32 `json:"capacity,omitempty"`
	// SkuCapacity - Min, max, and default scale values of the SKU.
	SkuCapacity *SkuCapacity `json:"skuCapacity,omitempty"`
	// Locations - Locations of the SKU.
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// SkuInfo SKU discovery information.
type SkuInfo struct {
	// ResourceType - Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - Name and tier of the SKU.
	Sku *SkuDescription `json:"sku,omitempty"`
	// Capacity - Min, max, and default scale values of the SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
}

// SkuInfoCollection collection of SKU information.
type SkuInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SkuInfo `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SkuInfoCollectionIterator provides access to a complete listing of SkuInfo values.
type SkuInfoCollectionIterator struct {
	i    int
	page SkuInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuInfoCollectionIterator) Response() SkuInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuInfoCollectionIterator) Value() SkuInfo {
	if !iter.page.NotDone() {
		return SkuInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuInfoCollectionIterator type.
func NewSkuInfoCollectionIterator(page SkuInfoCollectionPage) SkuInfoCollectionIterator {
	return SkuInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sic SkuInfoCollection) IsEmpty() bool {
	return sic.Value == nil || len(*sic.Value) == 0
}

// skuInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sic SkuInfoCollection) skuInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if sic.NextLink == nil || len(to.String(sic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sic.NextLink)))
}

// SkuInfoCollectionPage contains a page of SkuInfo values.
type SkuInfoCollectionPage struct {
	fn  func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)
	sic SkuInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sic)
	if err != nil {
		return err
	}
	page.sic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuInfoCollectionPage) NotDone() bool {
	return !page.sic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuInfoCollectionPage) Response() SkuInfoCollection {
	return page.sic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuInfoCollectionPage) Values() []SkuInfo {
	if page.sic.IsEmpty() {
		return nil
	}
	return *page.sic.Value
}

// Creates a new instance of the SkuInfoCollectionPage type.
func NewSkuInfoCollectionPage(getNextPage func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)) SkuInfoCollectionPage {
	return SkuInfoCollectionPage{fn: getNextPage}
}

// SkuInfos collection of SKU information.
type SkuInfos struct {
	autorest.Response `json:"-"`
	// ResourceType - Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Skus - List of SKUs the subscription is able to use.
	Skus *[]GlobalCsmSkuDescription `json:"skus,omitempty"`
}

// SlotConfigNames names for connection strings and application settings to be marked as sticky to the
// deployment slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	// ConnectionStringNames - List of connection string names.
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	// AppSettingNames - List of application settings names.
	AppSettingNames *[]string `json:"appSettingNames,omitempty"`
}

// SlotConfigNamesResource slot Config names azure resource.
type SlotConfigNamesResource struct {
	autorest.Response `json:"-"`
	// SlotConfigNames - Core resource properties
	*SlotConfigNames `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SlotConfigNamesResource.
func (scnr SlotConfigNamesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scnr.SlotConfigNames != nil {
		objectMap["properties"] = scnr.SlotConfigNames
	}
	if scnr.ID != nil {
		objectMap["id"] = scnr.ID
	}
	if scnr.Name != nil {
		objectMap["name"] = scnr.Name
	}
	if scnr.Kind != nil {
		objectMap["kind"] = scnr.Kind
	}
	if scnr.Type != nil {
		objectMap["type"] = scnr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotConfigNamesResource struct.
func (scnr *SlotConfigNamesResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotConfigNames SlotConfigNames
				err = json.Unmarshal(*v, &slotConfigNames)
				if err != nil {
					return err
				}
				scnr.SlotConfigNames = &slotConfigNames
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scnr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scnr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scnr.Type = &typeVar
			}
		}
	}

	return nil
}

// SlotDifference a setting difference between two deployment slots of an app.
type SlotDifference struct {
	// SlotDifferenceProperties - SlotDifference resource specific properties
	*SlotDifferenceProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SlotDifference.
func (sd SlotDifference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.SlotDifferenceProperties != nil {
		objectMap["properties"] = sd.SlotDifferenceProperties
	}
	if sd.ID != nil {
		objectMap["id"] = sd.ID
	}
	if sd.Name != nil {
		objectMap["name"] = sd.Name
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.Type != nil {
		objectMap["type"] = sd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotDifference struct.
func (sd *SlotDifference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotDifferenceProperties SlotDifferenceProperties
				err = json.Unmarshal(*v, &slotDifferenceProperties)
				if err != nil {
					return err
				}
				sd.SlotDifferenceProperties = &slotDifferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sd.Type = &typeVar
			}
		}
	}

	return nil
}

// SlotDifferenceCollection collection of slot differences.
type SlotDifferenceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SlotDifference `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SlotDifferenceCollectionIterator provides access to a complete listing of SlotDifference values.
type SlotDifferenceCollectionIterator struct {
	i    int
	page SlotDifferenceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SlotDifferenceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SlotDifferenceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SlotDifferenceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SlotDifferenceCollectionIterator) Response() SlotDifferenceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SlotDifferenceCollectionIterator) Value() SlotDifference {
	if !iter.page.NotDone() {
		return SlotDifference{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SlotDifferenceCollectionIterator type.
func NewSlotDifferenceCollectionIterator(page SlotDifferenceCollectionPage) SlotDifferenceCollectionIterator {
	return SlotDifferenceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdc SlotDifferenceCollection) IsEmpty() bool {
	return sdc.Value == nil || len(*sdc.Value) == 0
}

// slotDifferenceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdc SlotDifferenceCollection) slotDifferenceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if sdc.NextLink == nil || len(to.String(sdc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdc.NextLink)))
}

// SlotDifferenceCollectionPage contains a page of SlotDifference values.
type SlotDifferenceCollectionPage struct {
	fn  func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)
	sdc SlotDifferenceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SlotDifferenceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sdc)
	if err != nil {
		return err
	}
	page.sdc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SlotDifferenceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SlotDifferenceCollectionPage) NotDone() bool {
	return !page.sdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SlotDifferenceCollectionPage) Response() SlotDifferenceCollection {
	return page.sdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SlotDifferenceCollectionPage) Values() []SlotDifference {
	if page.sdc.IsEmpty() {
		return nil
	}
	return *page.sdc.Value
}

// Creates a new instance of the SlotDifferenceCollectionPage type.
func NewSlotDifferenceCollectionPage(getNextPage func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)) SlotDifferenceCollectionPage {
	return SlotDifferenceCollectionPage{fn: getNextPage}
}

// SlotDifferenceProperties slotDifference resource specific properties
type SlotDifferenceProperties struct {
	// Type - Type of the difference: Information, Warning or Error.
	Type *string `json:"type,omitempty"`
	// SettingType - The type of the setting: General, AppSetting or ConnectionString.
	SettingType *string `json:"settingType,omitempty"`
	// DiffRule - Rule that describes how to process the setting difference during a slot swap.
	DiffRule *string `json:"diffRule,omitempty"`
	// SettingName - Name of the setting.
	SettingName *string `json:"settingName,omitempty"`
	// ValueInCurrentSlot - Value of the setting in the current slot.
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty"`
	// ValueInTargetSlot - Value of the setting in the target slot.
	ValueInTargetSlot *string `json:"valueInTargetSlot,omitempty"`
	// Description - Description of the setting difference.
	Description *string `json:"description,omitempty"`
}

// SlotSwapStatus the status of the last successful slot swap operation.
type SlotSwapStatus struct {
	// TimestampUtc - The time the last successful slot swap completed.
	TimestampUtc *date.Time `json:"timestampUtc,omitempty"`
	// SourceSlotName - The source slot of the last swap operation.
	SourceSlotName *string `json:"sourceSlotName,omitempty"`
	// DestinationSlotName - The destination slot of the last swap operation.
	DestinationSlotName *string `json:"destinationSlotName,omitempty"`
}

// SlowRequestsBasedTrigger trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	// TimeTaken - Time taken.
	TimeTaken *string `json:"timeTaken,omitempty"`
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Snapshot a snapshot of an app.
type Snapshot struct {
	// SnapshotProperties - Snapshot resource specific properties
	*SnapshotProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// SnapshotCollection collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Snapshot `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SnapshotCollectionIterator provides access to a complete listing of Snapshot values.
type SnapshotCollectionIterator struct {
	i    int
	page SnapshotCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SnapshotCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SnapshotCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SnapshotCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SnapshotCollectionIterator) Response() SnapshotCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SnapshotCollectionIterator) Value() Snapshot {
	if !iter.page.NotDone() {
		return Snapshot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SnapshotCollectionIterator type.
func NewSnapshotCollectionIterator(page SnapshotCollectionPage) SnapshotCollectionIterator {
	return SnapshotCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SnapshotCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// snapshotCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SnapshotCollection) snapshotCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if sc.NextLink == nil || len(to.String(sc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SnapshotCollectionPage contains a page of Snapshot values.
type SnapshotCollectionPage struct {
	fn func(context.Context, SnapshotCollection) (SnapshotCollection, error)
	sc SnapshotCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SnapshotCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sc)
	if err != nil {
		return err
	}
	page.sc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SnapshotCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SnapshotCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SnapshotCollectionPage) Response() SnapshotCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SnapshotCollectionPage) Values() []Snapshot {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SnapshotCollectionPage type.
func NewSnapshotCollectionPage(getNextPage func(context.Context, SnapshotCollection) (SnapshotCollection, error)) SnapshotCollectionPage {
	return SnapshotCollectionPage{fn: getNextPage}
}

// SnapshotProperties snapshot resource specific properties
type SnapshotProperties struct {
	// Time - The time the snapshot was taken.
	Time *string `json:"time,omitempty"`
}

// SnapshotRecoveryRequest details about app recovery operation.
type SnapshotRecoveryRequest struct {
	// SnapshotRecoveryRequestProperties - SnapshotRecoveryRequest resource specific properties
	*SnapshotRecoveryRequestProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotRecoveryRequest.
func (srr SnapshotRecoveryRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srr.SnapshotRecoveryRequestProperties != nil {
		objectMap["properties"] = srr.SnapshotRecoveryRequestProperties
	}
	if srr.ID != nil {
		objectMap["id"] = srr.ID
	}
	if srr.Name != nil {
		objectMap["name"] = srr.Name
	}
	if srr.Kind != nil {
		objectMap["kind"] = srr.Kind
	}
	if srr.Type != nil {
		objectMap["type"] = srr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotRecoveryRequest struct.
func (srr *SnapshotRecoveryRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotRecoveryRequestProperties SnapshotRecoveryRequestProperties
				err = json.Unmarshal(*v, &snapshotRecoveryRequestProperties)
				if err != nil {
					return err
				}
				srr.SnapshotRecoveryRequestProperties = &snapshotRecoveryRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				srr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srr.Type = &typeVar
			}
		}
	}

	return nil
}

// SnapshotRecoveryRequestProperties snapshotRecoveryRequest resource specific properties
type SnapshotRecoveryRequestProperties struct {
	// SnapshotTime - Point in time in which the app recovery should be attempted, formatted as a DateTime string.
	SnapshotTime *string `json:"snapshotTime,omitempty"`
	// RecoveryTarget - Specifies the web app that snapshot contents will be written to.
	RecoveryTarget *SnapshotRecoveryTarget `json:"recoveryTarget,omitempty"`
	// Overwrite - If <code>true</code> the recovery operation can overwrite source app; otherwise, <code>false</code>.
	Overwrite *bool `json:"overwrite,omitempty"`
	// RecoverConfiguration - If true, site configuration, in addition to content, will be reverted.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`
	// IgnoreConflictingHostNames - If true, custom hostname conflicts will be ignored when recovering to a target web app.
	// This setting is only necessary when RecoverConfiguration is enabled.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`
}

// SnapshotRecoveryTarget specifies the web app that snapshot contents will be written to.
type SnapshotRecoveryTarget struct {
	// Location - Geographical location of the target web app, e.g. SouthEastAsia, SouthCentralUS
	Location *string `json:"location,omitempty"`
	// ID - ARM resource ID of the target app.
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
	ID *string `json:"id,omitempty"`
}

// Solution class Representing Solution for problems detected.
type Solution struct {
	// ID - Solution Id.
	ID *float64 `json:"id,omitempty"`
	// DisplayName - Display Name of the solution
	DisplayName *string `json:"displayName,omitempty"`
	// Order - Order of the solution.
	Order *float64 `json:"order,omitempty"`
	// Description - Description of the solution
	Description *string `json:"description,omitempty"`
	// Type - Type of Solution. Possible values include: 'QuickSolution', 'DeepInvestigation', 'BestPractices'
	Type SolutionType `json:"type,omitempty"`
	// Data - Solution Data.
	Data *[][]NameValuePair `json:"data,omitempty"`
	// Metadata - Solution Metadata.
	Metadata *[][]NameValuePair `json:"metadata,omitempty"`
}

// SourceControl the source control OAuth token.
type SourceControl struct {
	autorest.Response `json:"-"`
	// SourceControlProperties - SourceControl resource specific properties
	*SourceControlProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControl.
func (sc SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SourceControlProperties != nil {
		objectMap["properties"] = sc.SourceControlProperties
	}
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.Kind != nil {
		objectMap["kind"] = sc.Kind
	}
	if sc.Type != nil {
		objectMap["type"] = sc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControl struct.
func (sc *SourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlProperties SourceControlProperties
				err = json.Unmarshal(*v, &sourceControlProperties)
				if err != nil {
					return err
				}
				sc.SourceControlProperties = &sourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// SourceControlCollection collection of source controls.
type SourceControlCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SourceControl `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// SourceControlCollectionIterator provides access to a complete listing of SourceControl values.
type SourceControlCollectionIterator struct {
	i    int
	page SourceControlCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlCollectionIterator) Response() SourceControlCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlCollectionIterator) Value() SourceControl {
	if !iter.page.NotDone() {
		return SourceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlCollectionIterator type.
func NewSourceControlCollectionIterator(page SourceControlCollectionPage) SourceControlCollectionIterator {
	return SourceControlCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc SourceControlCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// sourceControlCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc SourceControlCollection) sourceControlCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if scc.NextLink == nil || len(to.String(scc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// SourceControlCollectionPage contains a page of SourceControl values.
type SourceControlCollectionPage struct {
	fn  func(context.Context, SourceControlCollection) (SourceControlCollection, error)
	scc SourceControlCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.scc)
	if err != nil {
		return err
	}
	page.scc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlCollectionPage) Response() SourceControlCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlCollectionPage) Values() []SourceControl {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the SourceControlCollectionPage type.
func NewSourceControlCollectionPage(getNextPage func(context.Context, SourceControlCollection) (SourceControlCollection, error)) SourceControlCollectionPage {
	return SourceControlCollectionPage{fn: getNextPage}
}

// SourceControlProperties sourceControl resource specific properties
type SourceControlProperties struct {
	// Name - Name or source control type.
	Name *string `json:"name,omitempty"`
	// Token - OAuth access token.
	Token *string `json:"token,omitempty"`
	// TokenSecret - OAuth access token secret.
	TokenSecret *string `json:"tokenSecret,omitempty"`
	// RefreshToken - OAuth refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// ExpirationTime - OAuth token expiration.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// StackMajorVersion application stack major version.
type StackMajorVersion struct {
	// DisplayVersion - Application stack major version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// RuntimeVersion - Application stack major version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// IsDefault - <code>true</code> if this is the default major version; otherwise, <code>false</code>.
	IsDefault *bool `json:"isDefault,omitempty"`
	// MinorVersions - Minor versions associated with the major version.
	MinorVersions *[]StackMinorVersion `json:"minorVersions,omitempty"`
}

// StackMinorVersion application stack minor version.
type StackMinorVersion struct {
	// DisplayVersion - Application stack minor version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// RuntimeVersion - Application stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// IsDefault - <code>true</code> if this is the default minor version; otherwise, <code>false</code>.
	IsDefault *bool `json:"isDefault,omitempty"`
}

// StampCapacity stamp capacity information.
type StampCapacity struct {
	// Name - Name of the stamp.
	Name *string `json:"name,omitempty"`
	// AvailableCapacity - Available capacity (# of machines, bytes of storage etc...).
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`
	// TotalCapacity - Total capacity (# of machines, bytes of storage etc...).
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`
	// Unit - Name of the unit.
	Unit *string `json:"unit,omitempty"`
	// ComputeMode - Shared/dedicated workers. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - Size of the machines. Possible values include: 'Default', 'Small', 'Medium', 'Large', 'D1', 'D2', 'D3'
	WorkerSize WorkerSizeOptions `json:"workerSize,omitempty"`
	// WorkerSizeID - Size ID of machines:
	// 0 - Small
	// 1 - Medium
	// 2 - Large
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ExcludeFromCapacityAllocation - If <code>true</code>, it includes basic apps.
	// Basic apps are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool `json:"excludeFromCapacityAllocation,omitempty"`
	// IsApplicableForAllComputeModes - <code>true</code> if capacity is applicable for all apps; otherwise, <code>false</code>.
	IsApplicableForAllComputeModes *bool `json:"isApplicableForAllComputeModes,omitempty"`
	// SiteMode - Shared or Dedicated.
	SiteMode *string `json:"siteMode,omitempty"`
}

// StampCapacityCollection collection of stamp capacities.
type StampCapacityCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StampCapacity `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// StampCapacityCollectionIterator provides access to a complete listing of StampCapacity values.
type StampCapacityCollectionIterator struct {
	i    int
	page StampCapacityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StampCapacityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StampCapacityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StampCapacityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StampCapacityCollectionIterator) Response() StampCapacityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StampCapacityCollectionIterator) Value() StampCapacity {
	if !iter.page.NotDone() {
		return StampCapacity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StampCapacityCollectionIterator type.
func NewStampCapacityCollectionIterator(page StampCapacityCollectionPage) StampCapacityCollectionIterator {
	return StampCapacityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc StampCapacityCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// stampCapacityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc StampCapacityCollection) stampCapacityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if scc.NextLink == nil || len(to.String(scc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// StampCapacityCollectionPage contains a page of StampCapacity values.
type StampCapacityCollectionPage struct {
	fn  func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)
	scc StampCapacityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StampCapacityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.scc)
	if err != nil {
		return err
	}
	page.scc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StampCapacityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StampCapacityCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StampCapacityCollectionPage) Response() StampCapacityCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StampCapacityCollectionPage) Values() []StampCapacity {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the StampCapacityCollectionPage type.
func NewStampCapacityCollectionPage(getNextPage func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)) StampCapacityCollectionPage {
	return StampCapacityCollectionPage{fn: getNextPage}
}

// StatusCodesBasedTrigger trigger based on status code.
type StatusCodesBasedTrigger struct {
	// Status - HTTP status code.
	Status *int32 `json:"status,omitempty"`
	// SubStatus - Request Sub Status.
	SubStatus *int32 `json:"subStatus,omitempty"`
	// Win32Status - Win32 error code.
	Win32Status *int32 `json:"win32Status,omitempty"`
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StorageMigrationOptions options for app content migration.
type StorageMigrationOptions struct {
	// StorageMigrationOptionsProperties - StorageMigrationOptions resource specific properties
	*StorageMigrationOptionsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageMigrationOptions.
func (smo StorageMigrationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smo.StorageMigrationOptionsProperties != nil {
		objectMap["properties"] = smo.StorageMigrationOptionsProperties
	}
	if smo.ID != nil {
		objectMap["id"] = smo.ID
	}
	if smo.Name != nil {
		objectMap["name"] = smo.Name
	}
	if smo.Kind != nil {
		objectMap["kind"] = smo.Kind
	}
	if smo.Type != nil {
		objectMap["type"] = smo.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageMigrationOptions struct.
func (smo *StorageMigrationOptions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageMigrationOptionsProperties StorageMigrationOptionsProperties
				err = json.Unmarshal(*v, &storageMigrationOptionsProperties)
				if err != nil {
					return err
				}
				smo.StorageMigrationOptionsProperties = &storageMigrationOptionsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smo.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				smo.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smo.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageMigrationOptionsProperties storageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	// AzurefilesConnectionString - AzureFiles connection string.
	AzurefilesConnectionString *string `json:"azurefilesConnectionString,omitempty"`
	// AzurefilesShare - AzureFiles share.
	AzurefilesShare *string `json:"azurefilesShare,omitempty"`
	// SwitchSiteAfterMigration - <code>true</code>if the app should be switched over; otherwise, <code>false</code>.
	SwitchSiteAfterMigration *bool `json:"switchSiteAfterMigration,omitempty"`
	// BlockWriteAccessToSite - <code>true</code> if the app should be read only during copy operation; otherwise, <code>false</code>.
	BlockWriteAccessToSite *bool `json:"blockWriteAccessToSite,omitempty"`
}

// StorageMigrationResponse response for a migration of app content request.
type StorageMigrationResponse struct {
	autorest.Response `json:"-"`
	// StorageMigrationResponseProperties - StorageMigrationResponse resource specific properties
	*StorageMigrationResponseProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageMigrationResponse.
func (smr StorageMigrationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smr.StorageMigrationResponseProperties != nil {
		objectMap["properties"] = smr.StorageMigrationResponseProperties
	}
	if smr.ID != nil {
		objectMap["id"] = smr.ID
	}
	if smr.Name != nil {
		objectMap["name"] = smr.Name
	}
	if smr.Kind != nil {
		objectMap["kind"] = smr.Kind
	}
	if smr.Type != nil {
		objectMap["type"] = smr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageMigrationResponse struct.
func (smr *StorageMigrationResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageMigrationResponseProperties StorageMigrationResponseProperties
				err = json.Unmarshal(*v, &storageMigrationResponseProperties)
				if err != nil {
					return err
				}
				smr.StorageMigrationResponseProperties = &storageMigrationResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				smr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smr.Type = &typeVar
			}
		}
	}

	return nil
}

// StorageMigrationResponseProperties storageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	// OperationID - When server starts the migration process, it will return an operation ID identifying that particular migration operation.
	OperationID *string `json:"operationId,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// StringDictionary string dictionary resource.
type StringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Settings.
	Properties map[string]*string `json:"properties"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StringDictionary.
func (sd StringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.Properties != nil {
		objectMap["properties"] = sd.Properties
	}
	if sd.ID != nil {
		objectMap["id"] = sd.ID
	}
	if sd.Name != nil {
		objectMap["name"] = sd.Name
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.Type != nil {
		objectMap["type"] = sd.Type
	}
	return json.Marshal(objectMap)
}

// TldLegalAgreement legal agreement for a top level domain.
type TldLegalAgreement struct {
	// AgreementKey - Unique identifier for the agreement.
	AgreementKey *string `json:"agreementKey,omitempty"`
	// Title - Agreement title.
	Title *string `json:"title,omitempty"`
	// Content - Agreement details.
	Content *string `json:"content,omitempty"`
	// URL - URL where a copy of the agreement details is hosted.
	URL *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection collection of top-level domain legal agreements.
type TldLegalAgreementCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TldLegalAgreement `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// TldLegalAgreementCollectionIterator provides access to a complete listing of TldLegalAgreement values.
type TldLegalAgreementCollectionIterator struct {
	i    int
	page TldLegalAgreementCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TldLegalAgreementCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TldLegalAgreementCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TldLegalAgreementCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TldLegalAgreementCollectionIterator) Response() TldLegalAgreementCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TldLegalAgreementCollectionIterator) Value() TldLegalAgreement {
	if !iter.page.NotDone() {
		return TldLegalAgreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TldLegalAgreementCollectionIterator type.
func NewTldLegalAgreementCollectionIterator(page TldLegalAgreementCollectionPage) TldLegalAgreementCollectionIterator {
	return TldLegalAgreementCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlac TldLegalAgreementCollection) IsEmpty() bool {
	return tlac.Value == nil || len(*tlac.Value) == 0
}

// tldLegalAgreementCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlac TldLegalAgreementCollection) tldLegalAgreementCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if tlac.NextLink == nil || len(to.String(tlac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlac.NextLink)))
}

// TldLegalAgreementCollectionPage contains a page of TldLegalAgreement values.
type TldLegalAgreementCollectionPage struct {
	fn   func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)
	tlac TldLegalAgreementCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TldLegalAgreementCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlac)
	if err != nil {
		return err
	}
	page.tlac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TldLegalAgreementCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TldLegalAgreementCollectionPage) NotDone() bool {
	return !page.tlac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TldLegalAgreementCollectionPage) Response() TldLegalAgreementCollection {
	return page.tlac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TldLegalAgreementCollectionPage) Values() []TldLegalAgreement {
	if page.tlac.IsEmpty() {
		return nil
	}
	return *page.tlac.Value
}

// Creates a new instance of the TldLegalAgreementCollectionPage type.
func NewTldLegalAgreementCollectionPage(getNextPage func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)) TldLegalAgreementCollectionPage {
	return TldLegalAgreementCollectionPage{fn: getNextPage}
}

// TopLevelDomain a top level domain object.
type TopLevelDomain struct {
	autorest.Response `json:"-"`
	// TopLevelDomainProperties - TopLevelDomain resource specific properties
	*TopLevelDomainProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TopLevelDomain.
func (tld TopLevelDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tld.TopLevelDomainProperties != nil {
		objectMap["properties"] = tld.TopLevelDomainProperties
	}
	if tld.ID != nil {
		objectMap["id"] = tld.ID
	}
	if tld.Name != nil {
		objectMap["name"] = tld.Name
	}
	if tld.Kind != nil {
		objectMap["kind"] = tld.Kind
	}
	if tld.Type != nil {
		objectMap["type"] = tld.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopLevelDomain struct.
func (tld *TopLevelDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topLevelDomainProperties TopLevelDomainProperties
				err = json.Unmarshal(*v, &topLevelDomainProperties)
				if err != nil {
					return err
				}
				tld.TopLevelDomainProperties = &topLevelDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tld.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tld.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tld.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tld.Type = &typeVar
			}
		}
	}

	return nil
}

// TopLevelDomainAgreementOption options for retrieving the list of top level domain legal agreements.
type TopLevelDomainAgreementOption struct {
	// IncludePrivacy - If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise, <code>false</code>.
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
	// ForTransfer - If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise, <code>false</code>.
	ForTransfer *bool `json:"forTransfer,omitempty"`
}

// TopLevelDomainCollection collection of Top-level domains.
type TopLevelDomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TopLevelDomain `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// TopLevelDomainCollectionIterator provides access to a complete listing of TopLevelDomain values.
type TopLevelDomainCollectionIterator struct {
	i    int
	page TopLevelDomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopLevelDomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopLevelDomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopLevelDomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopLevelDomainCollectionIterator) Response() TopLevelDomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopLevelDomainCollectionIterator) Value() TopLevelDomain {
	if !iter.page.NotDone() {
		return TopLevelDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopLevelDomainCollectionIterator type.
func NewTopLevelDomainCollectionIterator(page TopLevelDomainCollectionPage) TopLevelDomainCollectionIterator {
	return TopLevelDomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tldc TopLevelDomainCollection) IsEmpty() bool {
	return tldc.Value == nil || len(*tldc.Value) == 0
}

// topLevelDomainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tldc TopLevelDomainCollection) topLevelDomainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if tldc.NextLink == nil || len(to.String(tldc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tldc.NextLink)))
}

// TopLevelDomainCollectionPage contains a page of TopLevelDomain values.
type TopLevelDomainCollectionPage struct {
	fn   func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)
	tldc TopLevelDomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopLevelDomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tldc)
	if err != nil {
		return err
	}
	page.tldc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopLevelDomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopLevelDomainCollectionPage) NotDone() bool {
	return !page.tldc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopLevelDomainCollectionPage) Response() TopLevelDomainCollection {
	return page.tldc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopLevelDomainCollectionPage) Values() []TopLevelDomain {
	if page.tldc.IsEmpty() {
		return nil
	}
	return *page.tldc.Value
}

// Creates a new instance of the TopLevelDomainCollectionPage type.
func NewTopLevelDomainCollectionPage(getNextPage func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)) TopLevelDomainCollectionPage {
	return TopLevelDomainCollectionPage{fn: getNextPage}
}

// TopLevelDomainProperties topLevelDomain resource specific properties
type TopLevelDomainProperties struct {
	// DomainName - Name of the top level domain.
	DomainName *string `json:"name,omitempty"`
	// Privacy - If <code>true</code>, then the top level domain supports domain privacy; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
}

// TriggeredJobHistory triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	autorest.Response `json:"-"`
	// TriggeredJobHistoryProperties - TriggeredJobHistory resource specific properties
	*TriggeredJobHistoryProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredJobHistory.
func (tjh TriggeredJobHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjh.TriggeredJobHistoryProperties != nil {
		objectMap["properties"] = tjh.TriggeredJobHistoryProperties
	}
	if tjh.ID != nil {
		objectMap["id"] = tjh.ID
	}
	if tjh.Name != nil {
		objectMap["name"] = tjh.Name
	}
	if tjh.Kind != nil {
		objectMap["kind"] = tjh.Kind
	}
	if tjh.Type != nil {
		objectMap["type"] = tjh.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredJobHistory struct.
func (tjh *TriggeredJobHistory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredJobHistoryProperties TriggeredJobHistoryProperties
				err = json.Unmarshal(*v, &triggeredJobHistoryProperties)
				if err != nil {
					return err
				}
				tjh.TriggeredJobHistoryProperties = &triggeredJobHistoryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tjh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tjh.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tjh.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tjh.Type = &typeVar
			}
		}
	}

	return nil
}

// TriggeredJobHistoryCollection collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TriggeredJobHistory `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// TriggeredJobHistoryCollectionIterator provides access to a complete listing of TriggeredJobHistory
// values.
type TriggeredJobHistoryCollectionIterator struct {
	i    int
	page TriggeredJobHistoryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggeredJobHistoryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredJobHistoryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggeredJobHistoryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggeredJobHistoryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggeredJobHistoryCollectionIterator) Response() TriggeredJobHistoryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggeredJobHistoryCollectionIterator) Value() TriggeredJobHistory {
	if !iter.page.NotDone() {
		return TriggeredJobHistory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggeredJobHistoryCollectionIterator type.
func NewTriggeredJobHistoryCollectionIterator(page TriggeredJobHistoryCollectionPage) TriggeredJobHistoryCollectionIterator {
	return TriggeredJobHistoryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tjhc TriggeredJobHistoryCollection) IsEmpty() bool {
	return tjhc.Value == nil || len(*tjhc.Value) == 0
}

// triggeredJobHistoryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tjhc TriggeredJobHistoryCollection) triggeredJobHistoryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if tjhc.NextLink == nil || len(to.String(tjhc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tjhc.NextLink)))
}

// TriggeredJobHistoryCollectionPage contains a page of TriggeredJobHistory values.
type TriggeredJobHistoryCollectionPage struct {
	fn   func(context.Context, TriggeredJobHistoryCollection) (TriggeredJobHistoryCollection, error)
	tjhc TriggeredJobHistoryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggeredJobHistoryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredJobHistoryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tjhc)
	if err != nil {
		return err
	}
	page.tjhc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggeredJobHistoryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggeredJobHistoryCollectionPage) NotDone() bool {
	return !page.tjhc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggeredJobHistoryCollectionPage) Response() TriggeredJobHistoryCollection {
	return page.tjhc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggeredJobHistoryCollectionPage) Values() []TriggeredJobHistory {
	if page.tjhc.IsEmpty() {
		return nil
	}
	return *page.tjhc.Value
}

// Creates a new instance of the TriggeredJobHistoryCollectionPage type.
func NewTriggeredJobHistoryCollectionPage(getNextPage func(context.Context, TriggeredJobHistoryCollection) (TriggeredJobHistoryCollection, error)) TriggeredJobHistoryCollectionPage {
	return TriggeredJobHistoryCollectionPage{fn: getNextPage}
}

// TriggeredJobHistoryProperties triggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	// TriggeredJobRuns - List of triggered web job runs.
	TriggeredJobRuns *[]TriggeredJobRun `json:"triggeredJobRuns,omitempty"`
}

// TriggeredJobRun triggered Web Job Run Information.
type TriggeredJobRun struct {
	// TriggeredJobRunProperties - TriggeredJobRun resource specific properties
	*TriggeredJobRunProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredJobRun.
func (tjr TriggeredJobRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjr.TriggeredJobRunProperties != nil {
		objectMap["properties"] = tjr.TriggeredJobRunProperties
	}
	if tjr.ID != nil {
		objectMap["id"] = tjr.ID
	}
	if tjr.Name != nil {
		objectMap["name"] = tjr.Name
	}
	if tjr.Kind != nil {
		objectMap["kind"] = tjr.Kind
	}
	if tjr.Type != nil {
		objectMap["type"] = tjr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredJobRun struct.
func (tjr *TriggeredJobRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredJobRunProperties TriggeredJobRunProperties
				err = json.Unmarshal(*v, &triggeredJobRunProperties)
				if err != nil {
					return err
				}
				tjr.TriggeredJobRunProperties = &triggeredJobRunProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tjr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tjr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tjr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tjr.Type = &typeVar
			}
		}
	}

	return nil
}

// TriggeredJobRunProperties triggeredJobRun resource specific properties
type TriggeredJobRunProperties struct {
	// ID - Job ID.
	ID *string `json:"id,omitempty"`
	// Name - Job name.
	Name *string `json:"name,omitempty"`
	// Status - Job status. Possible values include: 'TriggeredWebJobStatusSuccess', 'TriggeredWebJobStatusFailed', 'TriggeredWebJobStatusError'
	Status TriggeredWebJobStatus `json:"status,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Duration - Job duration.
	Duration *string `json:"duration,omitempty"`
	// OutputURL - Output URL.
	OutputURL *string `json:"outputUrl,omitempty"`
	// ErrorURL - Error URL.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// JobName - Job name.
	JobName *string `json:"jobName,omitempty"`
	// Trigger - Job trigger.
	Trigger *string `json:"trigger,omitempty"`
}

// TriggeredWebJob triggered Web Job Information.
type TriggeredWebJob struct {
	autorest.Response `json:"-"`
	// TriggeredWebJobProperties - TriggeredWebJob resource specific properties
	*TriggeredWebJobProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredWebJob.
func (twj TriggeredWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if twj.TriggeredWebJobProperties != nil {
		objectMap["properties"] = twj.TriggeredWebJobProperties
	}
	if twj.ID != nil {
		objectMap["id"] = twj.ID
	}
	if twj.Name != nil {
		objectMap["name"] = twj.Name
	}
	if twj.Kind != nil {
		objectMap["kind"] = twj.Kind
	}
	if twj.Type != nil {
		objectMap["type"] = twj.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredWebJob struct.
func (twj *TriggeredWebJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredWebJobProperties TriggeredWebJobProperties
				err = json.Unmarshal(*v, &triggeredWebJobProperties)
				if err != nil {
					return err
				}
				twj.TriggeredWebJobProperties = &triggeredWebJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				twj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				twj.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				twj.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				twj.Type = &typeVar
			}
		}
	}

	return nil
}

// TriggeredWebJobCollection collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TriggeredWebJob `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// TriggeredWebJobCollectionIterator provides access to a complete listing of TriggeredWebJob values.
type TriggeredWebJobCollectionIterator struct {
	i    int
	page TriggeredWebJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggeredWebJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredWebJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggeredWebJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggeredWebJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggeredWebJobCollectionIterator) Response() TriggeredWebJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggeredWebJobCollectionIterator) Value() TriggeredWebJob {
	if !iter.page.NotDone() {
		return TriggeredWebJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggeredWebJobCollectionIterator type.
func NewTriggeredWebJobCollectionIterator(page TriggeredWebJobCollectionPage) TriggeredWebJobCollectionIterator {
	return TriggeredWebJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (twjc TriggeredWebJobCollection) IsEmpty() bool {
	return twjc.Value == nil || len(*twjc.Value) == 0
}

// triggeredWebJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (twjc TriggeredWebJobCollection) triggeredWebJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if twjc.NextLink == nil || len(to.String(twjc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(twjc.NextLink)))
}

// TriggeredWebJobCollectionPage contains a page of TriggeredWebJob values.
type TriggeredWebJobCollectionPage struct {
	fn   func(context.Context, TriggeredWebJobCollection) (TriggeredWebJobCollection, error)
	twjc TriggeredWebJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggeredWebJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredWebJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.twjc)
	if err != nil {
		return err
	}
	page.twjc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggeredWebJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggeredWebJobCollectionPage) NotDone() bool {
	return !page.twjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggeredWebJobCollectionPage) Response() TriggeredWebJobCollection {
	return page.twjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggeredWebJobCollectionPage) Values() []TriggeredWebJob {
	if page.twjc.IsEmpty() {
		return nil
	}
	return *page.twjc.Value
}

// Creates a new instance of the TriggeredWebJobCollectionPage type.
func NewTriggeredWebJobCollectionPage(getNextPage func(context.Context, TriggeredWebJobCollection) (TriggeredWebJobCollection, error)) TriggeredWebJobCollectionPage {
	return TriggeredWebJobCollectionPage{fn: getNextPage}
}

// TriggeredWebJobProperties triggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	// LatestRun - Latest job run information.
	LatestRun *TriggeredJobRun `json:"latestRun,omitempty"`
	// HistoryURL - History URL.
	HistoryURL *string `json:"historyUrl,omitempty"`
	// SchedulerLogsURL - Scheduler Logs URL.
	SchedulerLogsURL *string `json:"schedulerLogsUrl,omitempty"`
	// Name - Job name. Used as job identifier in ARM resource URI.
	Name *string `json:"name,omitempty"`
	// RunCommand - Run command.
	RunCommand *string `json:"runCommand,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extraInfoUrl,omitempty"`
	// JobType - Job type. Possible values include: 'Continuous', 'Triggered'
	JobType JobType `json:"jobType,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"usingSdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for TriggeredWebJobProperties.
func (twj TriggeredWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if twj.LatestRun != nil {
		objectMap["latestRun"] = twj.LatestRun
	}
	if twj.HistoryURL != nil {
		objectMap["historyUrl"] = twj.HistoryURL
	}
	if twj.SchedulerLogsURL != nil {
		objectMap["schedulerLogsUrl"] = twj.SchedulerLogsURL
	}
	if twj.Name != nil {
		objectMap["name"] = twj.Name
	}
	if twj.RunCommand != nil {
		objectMap["runCommand"] = twj.RunCommand
	}
	if twj.URL != nil {
		objectMap["url"] = twj.URL
	}
	if twj.ExtraInfoURL != nil {
		objectMap["extraInfoUrl"] = twj.ExtraInfoURL
	}
	if twj.JobType != "" {
		objectMap["jobType"] = twj.JobType
	}
	if twj.Error != nil {
		objectMap["error"] = twj.Error
	}
	if twj.UsingSdk != nil {
		objectMap["usingSdk"] = twj.UsingSdk
	}
	if twj.Settings != nil {
		objectMap["settings"] = twj.Settings
	}
	return json.Marshal(objectMap)
}

// Usage usage of the quota resource.
type Usage struct {
	// UsageProperties - Usage resource specific properties
	*UsageProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UsageProperties != nil {
		objectMap["properties"] = u.UsageProperties
	}
	if u.ID != nil {
		objectMap["id"] = u.ID
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.Type != nil {
		objectMap["type"] = u.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Usage struct.
func (u *Usage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var usageProperties UsageProperties
				err = json.Unmarshal(*v, &usageProperties)
				if err != nil {
					return err
				}
				u.UsageProperties = &usageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UsageCollection collection of usages.
type UsageCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsageCollectionIterator provides access to a complete listing of Usage values.
type UsageCollectionIterator struct {
	i    int
	page UsageCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageCollectionIterator) Response() UsageCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageCollectionIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageCollectionIterator type.
func NewUsageCollectionIterator(page UsageCollectionPage) UsageCollectionIterator {
	return UsageCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UsageCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// usageCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UsageCollection) usageCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if uc.NextLink == nil || len(to.String(uc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UsageCollectionPage contains a page of Usage values.
type UsageCollectionPage struct {
	fn func(context.Context, UsageCollection) (UsageCollection, error)
	uc UsageCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uc)
	if err != nil {
		return err
	}
	page.uc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageCollectionPage) Response() UsageCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageCollectionPage) Values() []Usage {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UsageCollectionPage type.
func NewUsageCollectionPage(getNextPage func(context.Context, UsageCollection) (UsageCollection, error)) UsageCollectionPage {
	return UsageCollectionPage{fn: getNextPage}
}

// UsageProperties usage resource specific properties
type UsageProperties struct {
	// DisplayName - Friendly name shown in the UI.
	DisplayName *string `json:"displayName,omitempty"`
	// Name - Name of the quota.
	Name *string `json:"name,omitempty"`
	// ResourceName - Name of the quota resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// Unit - Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The resource limit.
	Limit *int64 `json:"limit,omitempty"`
	// NextResetTime - Next reset time for the resource counter.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// ComputeMode - Compute mode used for this usage. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// SiteMode - Site mode used for this usage.
	SiteMode *string `json:"siteMode,omitempty"`
}

// User user credentials used for publishing activity.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - User resource specific properties
	*UserProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.ID != nil {
		objectMap["id"] = u.ID
	}
	if u.Name != nil {
		objectMap["name"] = u.Name
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.Type != nil {
		objectMap["type"] = u.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		}
	}

	return nil
}

// UserProperties user resource specific properties
type UserProperties struct {
	// UserName - Username
	UserName *string `json:"name,omitempty"`
	// PublishingUserName - Username used for publishing.
	PublishingUserName *string `json:"publishingUserName,omitempty"`
	// PublishingPassword - Password used for publishing.
	PublishingPassword *string `json:"publishingPassword,omitempty"`
	// PublishingPasswordHash - Password hash used for publishing.
	PublishingPasswordHash *string `json:"publishingPasswordHash,omitempty"`
	// PublishingPasswordHashSalt - Password hash salt used for publishing.
	PublishingPasswordHashSalt *string `json:"publishingPasswordHashSalt,omitempty"`
}

// ValidateProperties app properties used for validation.
type ValidateProperties struct {
	// ServerFarmID - ARM resource ID of an App Service plan that would host the app.
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// SkuName - Name of the target SKU for the App Service plan.
	SkuName *string `json:"skuName,omitempty"`
	// NeedLinuxWorkers - <code>true</code> if App Service plan is for Linux workers; otherwise, <code>false</code>.
	NeedLinuxWorkers *bool `json:"needLinuxWorkers,omitempty"`
	// IsSpot - <code>true</code> if App Service plan is for Spot instances; otherwise, <code>false</code>.
	IsSpot *bool `json:"isSpot,omitempty"`
	// Capacity - Target capacity of the App Service plan (number of VM's).
	Capacity *int32 `json:"capacity,omitempty"`
	// HostingEnvironment - Name of App Service Environment where app or App Service plan should be created.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// ValidateRequest resource validation request content.
type ValidateRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'ValidateResourceTypesServerFarm', 'ValidateResourceTypesSite'
	Type ValidateResourceTypes `json:"type,omitempty"`
	// Location - Expected location of the resource.
	Location *string `json:"location,omitempty"`
	// ValidateProperties - Properties of the resource to validate.
	*ValidateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateRequest.
func (vr ValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.Name != nil {
		objectMap["name"] = vr.Name
	}
	if vr.Type != "" {
		objectMap["type"] = vr.Type
	}
	if vr.Location != nil {
		objectMap["location"] = vr.Location
	}
	if vr.ValidateProperties != nil {
		objectMap["properties"] = vr.ValidateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ValidateRequest struct.
func (vr *ValidateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar ValidateResourceTypes
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vr.Location = &location
			}
		case "properties":
			if v != nil {
				var validateProperties ValidateProperties
				err = json.Unmarshal(*v, &validateProperties)
				if err != nil {
					return err
				}
				vr.ValidateProperties = &validateProperties
			}
		}
	}

	return nil
}

// ValidateResponse describes the result of resource validation.
type ValidateResponse struct {
	autorest.Response `json:"-"`
	// Status - Result of validation.
	Status *string `json:"status,omitempty"`
	// Error - Error details for the case when validation fails.
	Error *ValidateResponseError `json:"error,omitempty"`
}

// ValidateResponseError error details for when validation fails.
type ValidateResponseError struct {
	// Code - Validation error code.
	Code *string `json:"code,omitempty"`
	// Message - Validation error message.
	Message *string `json:"message,omitempty"`
}

// VirtualApplication virtual application in an app.
type VirtualApplication struct {
	// VirtualPath - Virtual path.
	VirtualPath *string `json:"virtualPath,omitempty"`
	// PhysicalPath - Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`
	// PreloadEnabled - <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
	PreloadEnabled *bool `json:"preloadEnabled,omitempty"`
	// VirtualDirectories - Virtual directories for virtual application.
	VirtualDirectories *[]VirtualDirectory `json:"virtualDirectories,omitempty"`
}

// VirtualDirectory directory for virtual application.
type VirtualDirectory struct {
	// VirtualPath - Path to virtual application.
	VirtualPath *string `json:"virtualPath,omitempty"`
	// PhysicalPath - Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`
}

// VirtualIPMapping virtual IP mapping.
type VirtualIPMapping struct {
	// VirtualIP - Virtual IP address.
	VirtualIP *string `json:"virtualIP,omitempty"`
	// InternalHTTPPort - Internal HTTP port.
	InternalHTTPPort *int32 `json:"internalHttpPort,omitempty"`
	// InternalHTTPSPort - Internal HTTPS port.
	InternalHTTPSPort *int32 `json:"internalHttpsPort,omitempty"`
	// InUse - Is virtual IP mapping in use.
	InUse *bool `json:"inUse,omitempty"`
}

// VirtualNetworkProfile specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	// ID - Resource id of the Virtual Network.
	ID *string `json:"id,omitempty"`
	// Name - Name of the Virtual Network (read-only).
	Name *string `json:"name,omitempty"`
	// Type - Resource type of the Virtual Network (read-only).
	Type *string `json:"type,omitempty"`
	// Subnet - Subnet within the Virtual Network.
	Subnet *string `json:"subnet,omitempty"`
}

// VnetGateway the Virtual Network gateway contract. This is used to give the Virtual Network gateway
// access to the VPN package.
type VnetGateway struct {
	autorest.Response `json:"-"`
	// VnetGatewayProperties - VnetGateway resource specific properties
	*VnetGatewayProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetGateway.
func (vg VnetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vg.VnetGatewayProperties != nil {
		objectMap["properties"] = vg.VnetGatewayProperties
	}
	if vg.ID != nil {
		objectMap["id"] = vg.ID
	}
	if vg.Name != nil {
		objectMap["name"] = vg.Name
	}
	if vg.Kind != nil {
		objectMap["kind"] = vg.Kind
	}
	if vg.Type != nil {
		objectMap["type"] = vg.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetGateway struct.
func (vg *VnetGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetGatewayProperties VnetGatewayProperties
				err = json.Unmarshal(*v, &vnetGatewayProperties)
				if err != nil {
					return err
				}
				vg.VnetGatewayProperties = &vnetGatewayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vg.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vg.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vg.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetGatewayProperties vnetGateway resource specific properties
type VnetGatewayProperties struct {
	// VnetName - The Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
	// VpnPackageURI - The URI where the VPN package can be downloaded.
	VpnPackageURI *string `json:"vpnPackageUri,omitempty"`
}

// VnetInfo virtual Network information contract.
type VnetInfo struct {
	autorest.Response `json:"-"`
	// VnetInfoProperties - VnetInfo resource specific properties
	*VnetInfoProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetInfo.
func (vi VnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vi.VnetInfoProperties != nil {
		objectMap["properties"] = vi.VnetInfoProperties
	}
	if vi.ID != nil {
		objectMap["id"] = vi.ID
	}
	if vi.Name != nil {
		objectMap["name"] = vi.Name
	}
	if vi.Kind != nil {
		objectMap["kind"] = vi.Kind
	}
	if vi.Type != nil {
		objectMap["type"] = vi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetInfo struct.
func (vi *VnetInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetInfoProperties VnetInfoProperties
				err = json.Unmarshal(*v, &vnetInfoProperties)
				if err != nil {
					return err
				}
				vi.VnetInfoProperties = &vnetInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vi.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetInfoProperties vnetInfo resource specific properties
type VnetInfoProperties struct {
	// VnetResourceID - The Virtual Network's resource ID.
	VnetResourceID *string `json:"vnetResourceId,omitempty"`
	// CertThumbprint - The client certificate thumbprint.
	CertThumbprint *string `json:"certThumbprint,omitempty"`
	// CertBlob - A certificate file (.cer) blob containing the public key of the private key used to authenticate a
	// Point-To-Site VPN connection.
	CertBlob *[]byte `json:"certBlob,omitempty"`
	// Routes - The routes that this Virtual Network connection uses.
	Routes *[]VnetRoute `json:"routes,omitempty"`
	// ResyncRequired - <code>true</code> if a resync is required; otherwise, <code>false</code>.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// DNSServers - DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
	DNSServers *string `json:"dnsServers,omitempty"`
}

// VnetParameters the required set of inputs to validate a VNET
type VnetParameters struct {
	// VnetParametersProperties - VnetParameters resource specific properties
	*VnetParametersProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetParameters.
func (vp VnetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.VnetParametersProperties != nil {
		objectMap["properties"] = vp.VnetParametersProperties
	}
	if vp.ID != nil {
		objectMap["id"] = vp.ID
	}
	if vp.Name != nil {
		objectMap["name"] = vp.Name
	}
	if vp.Kind != nil {
		objectMap["kind"] = vp.Kind
	}
	if vp.Type != nil {
		objectMap["type"] = vp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetParameters struct.
func (vp *VnetParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetParametersProperties VnetParametersProperties
				err = json.Unmarshal(*v, &vnetParametersProperties)
				if err != nil {
					return err
				}
				vp.VnetParametersProperties = &vnetParametersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vp.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vp.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetParametersProperties vnetParameters resource specific properties
type VnetParametersProperties struct {
	// VnetResourceGroup - The Resource Group of the VNET to be validated
	VnetResourceGroup *string `json:"vnetResourceGroup,omitempty"`
	// VnetName - The name of the VNET to be validated
	VnetName *string `json:"vnetName,omitempty"`
	// VnetSubnetName - The subnet name to be validated
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
}

// VnetRoute virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	autorest.Response `json:"-"`
	// VnetRouteProperties - VnetRoute resource specific properties
	*VnetRouteProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetRoute.
func (vr VnetRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.VnetRouteProperties != nil {
		objectMap["properties"] = vr.VnetRouteProperties
	}
	if vr.ID != nil {
		objectMap["id"] = vr.ID
	}
	if vr.Name != nil {
		objectMap["name"] = vr.Name
	}
	if vr.Kind != nil {
		objectMap["kind"] = vr.Kind
	}
	if vr.Type != nil {
		objectMap["type"] = vr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetRoute struct.
func (vr *VnetRoute) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetRouteProperties VnetRouteProperties
				err = json.Unmarshal(*v, &vnetRouteProperties)
				if err != nil {
					return err
				}
				vr.VnetRouteProperties = &vnetRouteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetRouteProperties vnetRoute resource specific properties
type VnetRouteProperties struct {
	// VnetRouteName - The name of this route. This is only returned by the server and does not need to be set by the client.
	VnetRouteName *string `json:"name,omitempty"`
	// StartAddress - The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string `json:"startAddress,omitempty"`
	// EndAddress - The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string `json:"endAddress,omitempty"`
	// RouteType - The type of route this is:
	// DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
	// INHERITED - Routes inherited from the real Virtual Network routes
	// STATIC - Static route set on the app only
	// These values will be used for syncing an app's routes with those from a Virtual Network. Possible values include: 'DEFAULT', 'INHERITED', 'STATIC'
	RouteType RouteType `json:"routeType,omitempty"`
}

// VnetValidationFailureDetails a class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	autorest.Response `json:"-"`
	// VnetValidationFailureDetailsProperties - VnetValidationFailureDetails resource specific properties
	*VnetValidationFailureDetailsProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetValidationFailureDetails.
func (vvfd VnetValidationFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvfd.VnetValidationFailureDetailsProperties != nil {
		objectMap["properties"] = vvfd.VnetValidationFailureDetailsProperties
	}
	if vvfd.ID != nil {
		objectMap["id"] = vvfd.ID
	}
	if vvfd.Name != nil {
		objectMap["name"] = vvfd.Name
	}
	if vvfd.Kind != nil {
		objectMap["kind"] = vvfd.Kind
	}
	if vvfd.Type != nil {
		objectMap["type"] = vvfd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetValidationFailureDetails struct.
func (vvfd *VnetValidationFailureDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetValidationFailureDetailsProperties VnetValidationFailureDetailsProperties
				err = json.Unmarshal(*v, &vnetValidationFailureDetailsProperties)
				if err != nil {
					return err
				}
				vvfd.VnetValidationFailureDetailsProperties = &vnetValidationFailureDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vvfd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vvfd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vvfd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vvfd.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetValidationFailureDetailsProperties vnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	// Failed - A flag describing whether or not validation failed.
	Failed *bool `json:"failed,omitempty"`
	// FailedTests - A list of tests that failed in the validation.
	FailedTests *[]VnetValidationTestFailure `json:"failedTests,omitempty"`
}

// VnetValidationTestFailure a class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	// VnetValidationTestFailureProperties - VnetValidationTestFailure resource specific properties
	*VnetValidationTestFailureProperties `json:"properties,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetValidationTestFailure.
func (vvtf VnetValidationTestFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvtf.VnetValidationTestFailureProperties != nil {
		objectMap["properties"] = vvtf.VnetValidationTestFailureProperties
	}
	if vvtf.ID != nil {
		objectMap["id"] = vvtf.ID
	}
	if vvtf.Name != nil {
		objectMap["name"] = vvtf.Name
	}
	if vvtf.Kind != nil {
		objectMap["kind"] = vvtf.Kind
	}
	if vvtf.Type != nil {
		objectMap["type"] = vvtf.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetValidationTestFailure struct.
func (vvtf *VnetValidationTestFailure) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetValidationTestFailureProperties VnetValidationTestFailureProperties
				err = json.Unmarshal(*v, &vnetValidationTestFailureProperties)
				if err != nil {
					return err
				}
				vvtf.VnetValidationTestFailureProperties = &vnetValidationTestFailureProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vvtf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vvtf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vvtf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vvtf.Type = &typeVar
			}
		}
	}

	return nil
}

// VnetValidationTestFailureProperties vnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	// TestName - The name of the test that failed.
	TestName *string `json:"testName,omitempty"`
	// Details - The details of what caused the failure, e.g. the blocking rule name, etc.
	Details *string `json:"details,omitempty"`
}

// WorkerPool worker pool of an App Service Environment.
type WorkerPool struct {
	// WorkerSizeID - Worker size ID for referencing this worker pool.
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ComputeMode - Shared or dedicated app hosting. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - VM size of the worker pool instances.
	WorkerSize *string `json:"workerSize,omitempty"`
	// WorkerCount - Number of instances in the worker pool.
	WorkerCount *int32 `json:"workerCount,omitempty"`
	// InstanceNames - Names of all instances in the worker pool (read only).
	InstanceNames *[]string `json:"instanceNames,omitempty"`
}

// WorkerPoolCollection collection of worker pools.
type WorkerPoolCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]WorkerPoolResource `json:"value,omitempty"`
	// NextLink - Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkerPoolCollectionIterator provides access to a complete listing of WorkerPoolResource values.
type WorkerPoolCollectionIterator struct {
	i    int
	page WorkerPoolCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkerPoolCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkerPoolCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkerPoolCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkerPoolCollectionIterator) Response() WorkerPoolCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkerPoolCollectionIterator) Value() WorkerPoolResource {
	if !iter.page.NotDone() {
		return WorkerPoolResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkerPoolCollectionIterator type.
func NewWorkerPoolCollectionIterator(page WorkerPoolCollectionPage) WorkerPoolCollectionIterator {
	return WorkerPoolCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpc WorkerPoolCollection) IsEmpty() bool {
	return wpc.Value == nil || len(*wpc.Value) == 0
}

// workerPoolCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpc WorkerPoolCollection) workerPoolCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if wpc.NextLink == nil || len(to.String(wpc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpc.NextLink)))
}

// WorkerPoolCollectionPage contains a page of WorkerPoolResource values.
type WorkerPoolCollectionPage struct {
	fn  func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)
	wpc WorkerPoolCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkerPoolCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wpc)
	if err != nil {
		return err
	}
	page.wpc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkerPoolCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkerPoolCollectionPage) NotDone() bool {
	return !page.wpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkerPoolCollectionPage) Response() WorkerPoolCollection {
	return page.wpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkerPoolCollectionPage) Values() []WorkerPoolResource {
	if page.wpc.IsEmpty() {
		return nil
	}
	return *page.wpc.Value
}

// Creates a new instance of the WorkerPoolCollectionPage type.
func NewWorkerPoolCollectionPage(getNextPage func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)) WorkerPoolCollectionPage {
	return WorkerPoolCollectionPage{fn: getNextPage}
}

// WorkerPoolResource worker pool of an App Service Environment ARM resource.
type WorkerPoolResource struct {
	autorest.Response `json:"-"`
	// WorkerPool - Core resource properties
	*WorkerPool `json:"properties,omitempty"`
	Sku         *SkuDescription `json:"sku,omitempty"`
	// ID - Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkerPoolResource.
func (wpr WorkerPoolResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpr.WorkerPool != nil {
		objectMap["properties"] = wpr.WorkerPool
	}
	if wpr.Sku != nil {
		objectMap["sku"] = wpr.Sku
	}
	if wpr.ID != nil {
		objectMap["id"] = wpr.ID
	}
	if wpr.Name != nil {
		objectMap["name"] = wpr.Name
	}
	if wpr.Kind != nil {
		objectMap["kind"] = wpr.Kind
	}
	if wpr.Type != nil {
		objectMap["type"] = wpr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkerPoolResource struct.
func (wpr *WorkerPoolResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workerPool WorkerPool
				err = json.Unmarshal(*v, &workerPool)
				if err != nil {
					return err
				}
				wpr.WorkerPool = &workerPool
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wpr.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				wpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wpr.Type = &typeVar
			}
		}
	}

	return nil
}
