package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationDefinitionKind enumerates the values for application definition kind.
type ApplicationDefinitionKind string

const (
	// Compose Indicates the application is defined by compose file(s). The value is 1.
	Compose ApplicationDefinitionKind = "Compose"
	// Invalid Indicates the application definition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is 65535.
	Invalid ApplicationDefinitionKind = "Invalid"
	// ServiceFabricApplicationDescription Indicates the application is defined by a Service Fabric application
	// description. The value is 0.
	ServiceFabricApplicationDescription ApplicationDefinitionKind = "ServiceFabricApplicationDescription"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleApplicationDefinitionKindValues returns an array of possible values for the ApplicationDefinitionKind const type.
func PossibleApplicationDefinitionKindValues() []ApplicationDefinitionKind {
	return []ApplicationDefinitionKind{Compose, Invalid, ServiceFabricApplicationDescription}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationStatus enumerates the values for application status.
type ApplicationStatus string

const (
	// ApplicationStatusCreating Indicates the application status is creating. The value is 3.
	ApplicationStatusCreating ApplicationStatus = "Creating"
	// ApplicationStatusDeleting Indicates the application status is deleting. The value is 4.
	ApplicationStatusDeleting ApplicationStatus = "Deleting"
	// ApplicationStatusFailed Indicates the creation or deletion of application was terminated due to
	// persistent failures. Another create/delete request can be accepted to resume a failed application. The
	// value is 5.
	ApplicationStatusFailed ApplicationStatus = "Failed"
	// ApplicationStatusInvalid Indicates the application status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ApplicationStatusInvalid ApplicationStatus = "Invalid"
	// ApplicationStatusReady Indicates the application status is ready. The value is 1.
	ApplicationStatusReady ApplicationStatus = "Ready"
	// ApplicationStatusUpgrading Indicates the application status is upgrading. The value is 2.
	ApplicationStatusUpgrading ApplicationStatus = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleApplicationStatusValues returns an array of possible values for the ApplicationStatus const type.
func PossibleApplicationStatusValues() []ApplicationStatus {
	return []ApplicationStatus{ApplicationStatusCreating, ApplicationStatusDeleting, ApplicationStatusFailed, ApplicationStatusInvalid, ApplicationStatusReady, ApplicationStatusUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeDefinitionKind enumerates the values for application type definition kind.
type ApplicationTypeDefinitionKind string

const (
	// ApplicationTypeDefinitionKindCompose Indicates the application type is defined and created implicitly as
	// part of a compose deployment. The value is 2.
	ApplicationTypeDefinitionKindCompose ApplicationTypeDefinitionKind = "Compose"
	// ApplicationTypeDefinitionKindInvalid Indicates the application type definition kind is invalid. All
	// Service Fabric enumerations have the invalid type. The value is 0.
	ApplicationTypeDefinitionKindInvalid ApplicationTypeDefinitionKind = "Invalid"
	// ApplicationTypeDefinitionKindServiceFabricApplicationPackage Indicates the application type is defined
	// and created by a Service Fabric application package provided by the user. The value is 1.
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = "ServiceFabricApplicationPackage"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleApplicationTypeDefinitionKindValues returns an array of possible values for the ApplicationTypeDefinitionKind const type.
func PossibleApplicationTypeDefinitionKindValues() []ApplicationTypeDefinitionKind {
	return []ApplicationTypeDefinitionKind{ApplicationTypeDefinitionKindCompose, ApplicationTypeDefinitionKindInvalid, ApplicationTypeDefinitionKindServiceFabricApplicationPackage}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeStatus enumerates the values for application type status.
type ApplicationTypeStatus string

const (
	// ApplicationTypeStatusAvailable Indicates that the application type is fully provisioned and is available
	// for use. An application of this type and version can be created. The value is 2.
	ApplicationTypeStatusAvailable ApplicationTypeStatus = "Available"
	// ApplicationTypeStatusFailed Indicates that the application type provisioning failed and it is
	// unavailable for use. The failure details can be obtained from the application type information query.
	// The failed application type information remains in the cluster until it is unprovisioned or
	// reprovisioned successfully. The value is 4.
	ApplicationTypeStatusFailed ApplicationTypeStatus = "Failed"
	// ApplicationTypeStatusInvalid Indicates the application type status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ApplicationTypeStatusInvalid ApplicationTypeStatus = "Invalid"
	// ApplicationTypeStatusProvisioning Indicates that the application type is being provisioned in the
	// cluster. The value is 1.
	ApplicationTypeStatusProvisioning ApplicationTypeStatus = "Provisioning"
	// ApplicationTypeStatusUnprovisioning Indicates that the application type is in process of being
	// unprovisioned from the cluster. The value is 3.
	ApplicationTypeStatusUnprovisioning ApplicationTypeStatus = "Unprovisioning"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleApplicationTypeStatusValues returns an array of possible values for the ApplicationTypeStatus const type.
func PossibleApplicationTypeStatusValues() []ApplicationTypeStatus {
	return []ApplicationTypeStatus{ApplicationTypeStatusAvailable, ApplicationTypeStatusFailed, ApplicationTypeStatusInvalid, ApplicationTypeStatusProvisioning, ApplicationTypeStatusUnprovisioning}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosEventKind enumerates the values for chaos event kind.
type ChaosEventKind string

const (
	// ChaosEventKindExecutingFaults Indicates a Chaos event that gets generated when Chaos has decided on the
	// faults for an iteration. This Chaos event contains the details of the faults as a list of strings.
	ChaosEventKindExecutingFaults ChaosEventKind = "ExecutingFaults"
	// ChaosEventKindInvalid Indicates an invalid Chaos event kind. All Service Fabric enumerations have the
	// invalid type.
	ChaosEventKindInvalid ChaosEventKind = "Invalid"
	// ChaosEventKindStarted Indicates a Chaos event that gets generated when Chaos is started.
	ChaosEventKindStarted ChaosEventKind = "Started"
	// ChaosEventKindStopped Indicates a Chaos event that gets generated when Chaos stops because either the
	// user issued a stop or the time to run was up.
	ChaosEventKindStopped ChaosEventKind = "Stopped"
	// ChaosEventKindTestError Indicates a Chaos event that gets generated when an unexpected event has
	// occurred in the Chaos engine, for example, due to the cluster snapshot being inconsistent, while
	// faulting a faultable entity Chaos found that the entity was already faulted.
	ChaosEventKindTestError ChaosEventKind = "TestError"
	// ChaosEventKindValidationFailed Indicates a Chaos event that gets generated when the cluster entities do
	// not become stable and healthy within ChaosParameters.MaxClusterStabilizationTimeoutInSeconds.
	ChaosEventKindValidationFailed ChaosEventKind = "ValidationFailed"
	// ChaosEventKindWaiting Indicates a Chaos event that gets generated when Chaos is waiting for the cluster
	// to become ready for faulting, for example, Chaos may be waiting for the on-going upgrade to finish.
	ChaosEventKindWaiting ChaosEventKind = "Waiting"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleChaosEventKindValues returns an array of possible values for the ChaosEventKind const type.
func PossibleChaosEventKindValues() []ChaosEventKind {
	return []ChaosEventKind{ChaosEventKindExecutingFaults, ChaosEventKindInvalid, ChaosEventKindStarted, ChaosEventKindStopped, ChaosEventKindTestError, ChaosEventKindValidationFailed, ChaosEventKindWaiting}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Code enumerates the values for code.
type Code string

const (
	// EABORT ...
	EABORT Code = "E_ABORT"
	// FABRICEAPPLICATIONALREADYEXISTS ...
	FABRICEAPPLICATIONALREADYEXISTS Code = "FABRIC_E_APPLICATION_ALREADY_EXISTS"
	// FABRICEAPPLICATIONALREADYINTARGETVERSION ...
	FABRICEAPPLICATIONALREADYINTARGETVERSION Code = "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
	// FABRICEAPPLICATIONNOTFOUND ...
	FABRICEAPPLICATIONNOTFOUND Code = "FABRIC_E_APPLICATION_NOT_FOUND"
	// FABRICEAPPLICATIONNOTUPGRADING ...
	FABRICEAPPLICATIONNOTUPGRADING Code = "FABRIC_E_APPLICATION_NOT_UPGRADING"
	// FABRICEAPPLICATIONTYPEALREADYEXISTS ...
	FABRICEAPPLICATIONTYPEALREADYEXISTS Code = "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
	// FABRICEAPPLICATIONTYPEINUSE ...
	FABRICEAPPLICATIONTYPEINUSE Code = "FABRIC_E_APPLICATION_TYPE_IN_USE"
	// FABRICEAPPLICATIONTYPENOTFOUND ...
	FABRICEAPPLICATIONTYPENOTFOUND Code = "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
	// FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS ...
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS Code = "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEINPROGRESS ...
	FABRICEAPPLICATIONUPGRADEINPROGRESS Code = "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEVALIDATIONERROR ...
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR Code = "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
	// FABRICECOMMUNICATIONERROR ...
	FABRICECOMMUNICATIONERROR Code = "FABRIC_E_COMMUNICATION_ERROR"
	// FABRICECONFIGURATIONPARAMETERNOTFOUND ...
	FABRICECONFIGURATIONPARAMETERNOTFOUND Code = "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
	// FABRICECONFIGURATIONSECTIONNOTFOUND ...
	FABRICECONFIGURATIONSECTIONNOTFOUND Code = "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
	// FABRICEDIRECTORYNOTFOUND ...
	FABRICEDIRECTORYNOTFOUND Code = "FABRIC_E_DIRECTORY_NOT_FOUND"
	// FABRICEENUMERATIONCOMPLETED ...
	FABRICEENUMERATIONCOMPLETED Code = "FABRIC_E_ENUMERATION_COMPLETED"
	// FABRICEFABRICALREADYINTARGETVERSION ...
	FABRICEFABRICALREADYINTARGETVERSION Code = "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
	// FABRICEFABRICNOTUPGRADING ...
	FABRICEFABRICNOTUPGRADING Code = "FABRIC_E_FABRIC_NOT_UPGRADING"
	// FABRICEFABRICUPGRADEINPROGRESS ...
	FABRICEFABRICUPGRADEINPROGRESS Code = "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
	// FABRICEFABRICUPGRADEVALIDATIONERROR ...
	FABRICEFABRICUPGRADEVALIDATIONERROR Code = "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
	// FABRICEFABRICVERSIONALREADYEXISTS ...
	FABRICEFABRICVERSIONALREADYEXISTS Code = "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
	// FABRICEFABRICVERSIONINUSE ...
	FABRICEFABRICVERSIONINUSE Code = "FABRIC_E_FABRIC_VERSION_IN_USE"
	// FABRICEFABRICVERSIONNOTFOUND ...
	FABRICEFABRICVERSIONNOTFOUND Code = "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
	// FABRICEFILENOTFOUND ...
	FABRICEFILENOTFOUND Code = "FABRIC_E_FILE_NOT_FOUND"
	// FABRICEHEALTHENTITYNOTFOUND ...
	FABRICEHEALTHENTITYNOTFOUND Code = "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
	// FABRICEHEALTHSTALEREPORT ...
	FABRICEHEALTHSTALEREPORT Code = "FABRIC_E_HEALTH_STALE_REPORT"
	// FABRICEIMAGEBUILDERVALIDATIONERROR ...
	FABRICEIMAGEBUILDERVALIDATIONERROR Code = "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
	// FABRICEINSTANCEIDMISMATCH ...
	FABRICEINSTANCEIDMISMATCH Code = "FABRIC_E_INSTANCE_ID_MISMATCH"
	// FABRICEINVALIDADDRESS ...
	FABRICEINVALIDADDRESS Code = "FABRIC_E_INVALID_ADDRESS"
	// FABRICEINVALIDATOMICGROUP ...
	FABRICEINVALIDATOMICGROUP Code = "FABRIC_E_INVALID_ATOMIC_GROUP"
	// FABRICEINVALIDCONFIGURATION ...
	FABRICEINVALIDCONFIGURATION Code = "FABRIC_E_INVALID_CONFIGURATION"
	// FABRICEINVALIDNAMEURI ...
	FABRICEINVALIDNAMEURI Code = "FABRIC_E_INVALID_NAME_URI"
	// FABRICEINVALIDPARTITIONKEY ...
	FABRICEINVALIDPARTITIONKEY Code = "FABRIC_E_INVALID_PARTITION_KEY"
	// FABRICEKEYNOTFOUND ...
	FABRICEKEYNOTFOUND Code = "FABRIC_E_KEY_NOT_FOUND"
	// FABRICEKEYTOOLARGE ...
	FABRICEKEYTOOLARGE Code = "FABRIC_E_KEY_TOO_LARGE"
	// FABRICENAMEALREADYEXISTS ...
	FABRICENAMEALREADYEXISTS Code = "FABRIC_E_NAME_ALREADY_EXISTS"
	// FABRICENAMEDOESNOTEXIST ...
	FABRICENAMEDOESNOTEXIST Code = "FABRIC_E_NAME_DOES_NOT_EXIST"
	// FABRICENAMENOTEMPTY ...
	FABRICENAMENOTEMPTY Code = "FABRIC_E_NAME_NOT_EMPTY"
	// FABRICENODEHASNOTSTOPPEDYET ...
	FABRICENODEHASNOTSTOPPEDYET Code = "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
	// FABRICENODEISUP ...
	FABRICENODEISUP Code = "FABRIC_E_NODE_IS_UP"
	// FABRICENODENOTFOUND ...
	FABRICENODENOTFOUND Code = "FABRIC_E_NODE_NOT_FOUND"
	// FABRICENOTPRIMARY ...
	FABRICENOTPRIMARY Code = "FABRIC_E_NOT_PRIMARY"
	// FABRICENOTREADY ...
	FABRICENOTREADY Code = "FABRIC_E_NOT_READY"
	// FABRICENOWRITEQUORUM ...
	FABRICENOWRITEQUORUM Code = "FABRIC_E_NO_WRITE_QUORUM"
	// FABRICEOPERATIONNOTCOMPLETE ...
	FABRICEOPERATIONNOTCOMPLETE Code = "FABRIC_E_OPERATION_NOT_COMPLETE"
	// FABRICEPARTITIONNOTFOUND ...
	FABRICEPARTITIONNOTFOUND Code = "FABRIC_E_PARTITION_NOT_FOUND"
	// FABRICEPATHTOOLONG ...
	FABRICEPATHTOOLONG Code = "FABRIC_E_PATH_TOO_LONG"
	// FABRICEPROPERTYCHECKFAILED ...
	FABRICEPROPERTYCHECKFAILED Code = "FABRIC_E_PROPERTY_CHECK_FAILED"
	// FABRICEPROPERTYDOESNOTEXIST ...
	FABRICEPROPERTYDOESNOTEXIST Code = "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
	// FABRICERECONFIGURATIONPENDING ...
	FABRICERECONFIGURATIONPENDING Code = "FABRIC_E_RECONFIGURATION_PENDING"
	// FABRICEREPLICADOESNOTEXIST ...
	FABRICEREPLICADOESNOTEXIST Code = "FABRIC_E_REPLICA_DOES_NOT_EXIST"
	// FABRICESEQUENCENUMBERCHECKFAILED ...
	FABRICESEQUENCENUMBERCHECKFAILED Code = "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
	// FABRICESERVICEAFFINITYCHAINNOTSUPPORTED ...
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED Code = "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
	// FABRICESERVICEALREADYEXISTS ...
	FABRICESERVICEALREADYEXISTS Code = "FABRIC_E_SERVICE_ALREADY_EXISTS"
	// FABRICESERVICEDOESNOTEXIST ...
	FABRICESERVICEDOESNOTEXIST Code = "FABRIC_E_SERVICE_DOES_NOT_EXIST"
	// FABRICESERVICEGROUPALREADYEXISTS ...
	FABRICESERVICEGROUPALREADYEXISTS Code = "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
	// FABRICESERVICEGROUPDOESNOTEXIST ...
	FABRICESERVICEGROUPDOESNOTEXIST Code = "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
	// FABRICESERVICEMANIFESTNOTFOUND ...
	FABRICESERVICEMANIFESTNOTFOUND Code = "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
	// FABRICESERVICEMETADATAMISMATCH ...
	FABRICESERVICEMETADATAMISMATCH Code = "FABRIC_E_SERVICE_METADATA_MISMATCH"
	// FABRICESERVICEOFFLINE ...
	FABRICESERVICEOFFLINE Code = "FABRIC_E_SERVICE_OFFLINE"
	// FABRICESERVICETYPEMISMATCH ...
	FABRICESERVICETYPEMISMATCH Code = "FABRIC_E_SERVICE_TYPE_MISMATCH"
	// FABRICESERVICETYPENOTFOUND ...
	FABRICESERVICETYPENOTFOUND Code = "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
	// FABRICESERVICETYPETEMPLATENOTFOUND ...
	FABRICESERVICETYPETEMPLATENOTFOUND Code = "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
	// FABRICETIMEOUT ...
	FABRICETIMEOUT Code = "FABRIC_E_TIMEOUT"
	// FABRICEVALUEEMPTY ...
	FABRICEVALUEEMPTY Code = "FABRIC_E_VALUE_EMPTY"
	// FABRICEVALUETOOLARGE ...
	FABRICEVALUETOOLARGE Code = "FABRIC_E_VALUE_TOO_LARGE"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleCodeValues returns an array of possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{EABORT, FABRICEAPPLICATIONALREADYEXISTS, FABRICEAPPLICATIONALREADYINTARGETVERSION, FABRICEAPPLICATIONNOTFOUND, FABRICEAPPLICATIONNOTUPGRADING, FABRICEAPPLICATIONTYPEALREADYEXISTS, FABRICEAPPLICATIONTYPEINUSE, FABRICEAPPLICATIONTYPENOTFOUND, FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS, FABRICEAPPLICATIONUPGRADEINPROGRESS, FABRICEAPPLICATIONUPGRADEVALIDATIONERROR, FABRICECOMMUNICATIONERROR, FABRICECONFIGURATIONPARAMETERNOTFOUND, FABRICECONFIGURATIONSECTIONNOTFOUND, FABRICEDIRECTORYNOTFOUND, FABRICEENUMERATIONCOMPLETED, FABRICEFABRICALREADYINTARGETVERSION, FABRICEFABRICNOTUPGRADING, FABRICEFABRICUPGRADEINPROGRESS, FABRICEFABRICUPGRADEVALIDATIONERROR, FABRICEFABRICVERSIONALREADYEXISTS, FABRICEFABRICVERSIONINUSE, FABRICEFABRICVERSIONNOTFOUND, FABRICEFILENOTFOUND, FABRICEHEALTHENTITYNOTFOUND, FABRICEHEALTHSTALEREPORT, FABRICEIMAGEBUILDERVALIDATIONERROR, FABRICEINSTANCEIDMISMATCH, FABRICEINVALIDADDRESS, FABRICEINVALIDATOMICGROUP, FABRICEINVALIDCONFIGURATION, FABRICEINVALIDNAMEURI, FABRICEINVALIDPARTITIONKEY, FABRICEKEYNOTFOUND, FABRICEKEYTOOLARGE, FABRICENAMEALREADYEXISTS, FABRICENAMEDOESNOTEXIST, FABRICENAMENOTEMPTY, FABRICENODEHASNOTSTOPPEDYET, FABRICENODEISUP, FABRICENODENOTFOUND, FABRICENOTPRIMARY, FABRICENOTREADY, FABRICENOWRITEQUORUM, FABRICEOPERATIONNOTCOMPLETE, FABRICEPARTITIONNOTFOUND, FABRICEPATHTOOLONG, FABRICEPROPERTYCHECKFAILED, FABRICEPROPERTYDOESNOTEXIST, FABRICERECONFIGURATIONPENDING, FABRICEREPLICADOESNOTEXIST, FABRICESEQUENCENUMBERCHECKFAILED, FABRICESERVICEAFFINITYCHAINNOTSUPPORTED, FABRICESERVICEALREADYEXISTS, FABRICESERVICEDOESNOTEXIST, FABRICESERVICEGROUPALREADYEXISTS, FABRICESERVICEGROUPDOESNOTEXIST, FABRICESERVICEMANIFESTNOTFOUND, FABRICESERVICEMETADATAMISMATCH, FABRICESERVICEOFFLINE, FABRICESERVICETYPEMISMATCH, FABRICESERVICETYPENOTFOUND, FABRICESERVICETYPETEMPLATENOTFOUND, FABRICETIMEOUT, FABRICEVALUEEMPTY, FABRICEVALUETOOLARGE}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ComposeDeploymentStatus enumerates the values for compose deployment status.
type ComposeDeploymentStatus string

const (
	// ComposeDeploymentStatusCreating Indicates that the compose deployment is being created in background.
	// The value is 2.
	ComposeDeploymentStatusCreating ComposeDeploymentStatus = "Creating"
	// ComposeDeploymentStatusDeleting Indicates that the compose deployment is being deleted in background.
	// The value is 5.
	ComposeDeploymentStatusDeleting ComposeDeploymentStatus = "Deleting"
	// ComposeDeploymentStatusFailed Indicates that the compose deployment was terminated due to persistent
	// failures. The value is 6.
	ComposeDeploymentStatusFailed ComposeDeploymentStatus = "Failed"
	// ComposeDeploymentStatusInvalid Indicates that the compose deployment status is invalid. The value is
	// zero.
	ComposeDeploymentStatusInvalid ComposeDeploymentStatus = "Invalid"
	// ComposeDeploymentStatusProvisioning Indicates that the compose deployment is being provisioned in
	// background. The value is 1.
	ComposeDeploymentStatusProvisioning ComposeDeploymentStatus = "Provisioning"
	// ComposeDeploymentStatusReady Indicates that the compose deployment has been successfully created or
	// upgraded. The value is 3.
	ComposeDeploymentStatusReady ComposeDeploymentStatus = "Ready"
	// ComposeDeploymentStatusUnprovisioning Indicates that the compose deployment is being unprovisioned in
	// background. The value is 4.
	ComposeDeploymentStatusUnprovisioning ComposeDeploymentStatus = "Unprovisioning"
	// ComposeDeploymentStatusUpgrading Indicates that the compose deployment is being upgraded in the
	// background. The value is 7.
	ComposeDeploymentStatusUpgrading ComposeDeploymentStatus = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleComposeDeploymentStatusValues returns an array of possible values for the ComposeDeploymentStatus const type.
func PossibleComposeDeploymentStatusValues() []ComposeDeploymentStatus {
	return []ComposeDeploymentStatus{ComposeDeploymentStatusCreating, ComposeDeploymentStatusDeleting, ComposeDeploymentStatusFailed, ComposeDeploymentStatusInvalid, ComposeDeploymentStatusProvisioning, ComposeDeploymentStatusReady, ComposeDeploymentStatusUnprovisioning, ComposeDeploymentStatusUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ComposeDeploymentUpgradeState enumerates the values for compose deployment upgrade state.
type ComposeDeploymentUpgradeState string

const (
	// ComposeDeploymentUpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The
	// value is 9.
	ComposeDeploymentUpgradeStateFailed ComposeDeploymentUpgradeState = "Failed"
	// ComposeDeploymentUpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ComposeDeploymentUpgradeStateInvalid ComposeDeploymentUpgradeState = "Invalid"
	// ComposeDeploymentUpgradeStateProvisioningTarget The upgrade is in the progress of provisioning target
	// application type version. The value is 1.
	ComposeDeploymentUpgradeStateProvisioningTarget ComposeDeploymentUpgradeState = "ProvisioningTarget"
	// ComposeDeploymentUpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 8.
	ComposeDeploymentUpgradeStateRollingBackCompleted ComposeDeploymentUpgradeState = "RollingBackCompleted"
	// ComposeDeploymentUpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version
	// but is not complete yet. The value is 6.
	ComposeDeploymentUpgradeStateRollingBackInProgress ComposeDeploymentUpgradeState = "RollingBackInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value
	// is 5.
	ComposeDeploymentUpgradeStateRollingForwardCompleted ComposeDeploymentUpgradeState = "RollingForwardCompleted"
	// ComposeDeploymentUpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target
	// version but is not complete yet. The value is 2.
	ComposeDeploymentUpgradeStateRollingForwardInProgress ComposeDeploymentUpgradeState = "RollingForwardInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardPending The current upgrade domain has finished upgrading.
	// The overall upgrade is waiting for an explicit move next request in UnmonitoredManual mode or performing
	// health checks in Monitored mode. The value is 3
	ComposeDeploymentUpgradeStateRollingForwardPending ComposeDeploymentUpgradeState = "RollingForwardPending"
	// ComposeDeploymentUpgradeStateUnprovisioningCurrent The upgrade is in the progress of unprovisioning
	// current application type version and rolling forward to the target version is completed. The value is 4.
	ComposeDeploymentUpgradeStateUnprovisioningCurrent ComposeDeploymentUpgradeState = "UnprovisioningCurrent"
	// ComposeDeploymentUpgradeStateUnprovisioningTarget The upgrade is in the progress of unprovisioning
	// target application type version and rolling back to the current version is completed. The value is 7.
	ComposeDeploymentUpgradeStateUnprovisioningTarget ComposeDeploymentUpgradeState = "UnprovisioningTarget"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleComposeDeploymentUpgradeStateValues returns an array of possible values for the ComposeDeploymentUpgradeState const type.
func PossibleComposeDeploymentUpgradeStateValues() []ComposeDeploymentUpgradeState {
	return []ComposeDeploymentUpgradeState{ComposeDeploymentUpgradeStateFailed, ComposeDeploymentUpgradeStateInvalid, ComposeDeploymentUpgradeStateProvisioningTarget, ComposeDeploymentUpgradeStateRollingBackCompleted, ComposeDeploymentUpgradeStateRollingBackInProgress, ComposeDeploymentUpgradeStateRollingForwardCompleted, ComposeDeploymentUpgradeStateRollingForwardInProgress, ComposeDeploymentUpgradeStateRollingForwardPending, ComposeDeploymentUpgradeStateUnprovisioningCurrent, ComposeDeploymentUpgradeStateUnprovisioningTarget}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CreateFabricDump enumerates the values for create fabric dump.
type CreateFabricDump string

const (
	// False ...
	False CreateFabricDump = "False"
	// True ...
	True CreateFabricDump = "True"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleCreateFabricDumpValues returns an array of possible values for the CreateFabricDump const type.
func PossibleCreateFabricDumpValues() []CreateFabricDump {
	return []CreateFabricDump{False, True}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DataLossModeRequiredQueryParam enumerates the values for data loss mode required query param.
type DataLossModeRequiredQueryParam string

const (
	// DataLossModeRequiredQueryParamFullDataLoss FullDataLoss option will drop all the replicas which means
	// that all the data will be lost.
	DataLossModeRequiredQueryParamFullDataLoss DataLossModeRequiredQueryParam = "FullDataLoss"
	// DataLossModeRequiredQueryParamInvalid Reserved.  Do not pass into API.
	DataLossModeRequiredQueryParamInvalid DataLossModeRequiredQueryParam = "Invalid"
	// DataLossModeRequiredQueryParamPartialDataLoss PartialDataLoss option will cause a quorum of replicas to
	// go down, triggering an OnDataLoss event in the system for the given partition.
	DataLossModeRequiredQueryParamPartialDataLoss DataLossModeRequiredQueryParam = "PartialDataLoss"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleDataLossModeRequiredQueryParamValues returns an array of possible values for the DataLossModeRequiredQueryParam const type.
func PossibleDataLossModeRequiredQueryParamValues() []DataLossModeRequiredQueryParam {
	return []DataLossModeRequiredQueryParam{DataLossModeRequiredQueryParamFullDataLoss, DataLossModeRequiredQueryParamInvalid, DataLossModeRequiredQueryParamPartialDataLoss}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeactivationIntent enumerates the values for deactivation intent.
type DeactivationIntent string

const (
	// Pause Indicates that the node should be paused. The value is 1.
	Pause DeactivationIntent = "Pause"
	// RemoveData Indicates the intent is for the node to remove data. The value is 3.
	RemoveData DeactivationIntent = "RemoveData"
	// Restart Indicates that the intent is for the node to be restarted after a short period of time. The
	// value is 2.
	Restart DeactivationIntent = "Restart"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleDeactivationIntentValues returns an array of possible values for the DeactivationIntent const type.
func PossibleDeactivationIntentValues() []DeactivationIntent {
	return []DeactivationIntent{Pause, RemoveData, Restart}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationStatus enumerates the values for deployed application status.
type DeployedApplicationStatus string

const (
	// DeployedApplicationStatusActivating Indicates that the package is activating. The value is 2.
	DeployedApplicationStatusActivating DeployedApplicationStatus = "Activating"
	// DeployedApplicationStatusActive Indicates that the package is active. The value is 3.
	DeployedApplicationStatusActive DeployedApplicationStatus = "Active"
	// DeployedApplicationStatusDeactivating Indicates that the package is deactivating. The value is 5.
	DeployedApplicationStatusDeactivating DeployedApplicationStatus = "Deactivating"
	// DeployedApplicationStatusDownloading Indicates that the package is downloading from the ImageStore. The
	// value is 1.
	DeployedApplicationStatusDownloading DeployedApplicationStatus = "Downloading"
	// DeployedApplicationStatusInvalid Indicates that deployment status is not valid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	DeployedApplicationStatusInvalid DeployedApplicationStatus = "Invalid"
	// DeployedApplicationStatusUpgrading Indicates that the package is upgrading. The value is 4.
	DeployedApplicationStatusUpgrading DeployedApplicationStatus = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleDeployedApplicationStatusValues returns an array of possible values for the DeployedApplicationStatus const type.
func PossibleDeployedApplicationStatusValues() []DeployedApplicationStatus {
	return []DeployedApplicationStatus{DeployedApplicationStatusActivating, DeployedApplicationStatusActive, DeployedApplicationStatusDeactivating, DeployedApplicationStatusDownloading, DeployedApplicationStatusInvalid, DeployedApplicationStatusUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusActivating Indicates the application or service package is being activated. The value is
	// 2.
	DeploymentStatusActivating DeploymentStatus = "Activating"
	// DeploymentStatusActive Indicates the application or service package is active the node. The value is 3.
	DeploymentStatusActive DeploymentStatus = "Active"
	// DeploymentStatusDeactivating Indicates the application or service package is being deactivated. The
	// value is 5.
	DeploymentStatusDeactivating DeploymentStatus = "Deactivating"
	// DeploymentStatusDownloading Indicates the application or service package is being downloaded to the node
	// from the ImageStore. The value is 1.
	DeploymentStatusDownloading DeploymentStatus = "Downloading"
	// DeploymentStatusInvalid Indicates status of the application or service package is not known or invalid.
	// The value is 0.
	DeploymentStatusInvalid DeploymentStatus = "Invalid"
	// DeploymentStatusUpgrading Indicates the application or service package is being upgraded. The value is
	// 4.
	DeploymentStatusUpgrading DeploymentStatus = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusActivating, DeploymentStatusActive, DeploymentStatusDeactivating, DeploymentStatusDownloading, DeploymentStatusInvalid, DeploymentStatusUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindApplication Indicates the entity is a Service Fabric application. The value is 4.
	EntityKindApplication EntityKind = "Application"
	// EntityKindCluster Indicates the entity is a Service Fabric cluster. The value is 8.
	EntityKindCluster EntityKind = "Cluster"
	// EntityKindDeployedApplication Indicates the entity is a Service Fabric deployed application. The value
	// is 6.
	EntityKindDeployedApplication EntityKind = "DeployedApplication"
	// EntityKindDeployedServicePackage Indicates the entity is a Service Fabric deployed service package. The
	// value is 7.
	EntityKindDeployedServicePackage EntityKind = "DeployedServicePackage"
	// EntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	EntityKindInvalid EntityKind = "Invalid"
	// EntityKindNode Indicates the entity is a Service Fabric node. The value is 1.
	EntityKindNode EntityKind = "Node"
	// EntityKindPartition Indicates the entity is a Service Fabric partition. The value is 2.
	EntityKindPartition EntityKind = "Partition"
	// EntityKindReplica Indicates the entity is a Service Fabric replica. The value is 5.
	EntityKindReplica EntityKind = "Replica"
	// EntityKindService Indicates the entity is a Service Fabric service. The value is 3.
	EntityKindService EntityKind = "Service"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindApplication, EntityKindCluster, EntityKindDeployedApplication, EntityKindDeployedServicePackage, EntityKindInvalid, EntityKindNode, EntityKindPartition, EntityKindReplica, EntityKindService}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntryPointStatus enumerates the values for entry point status.
type EntryPointStatus string

const (
	// EntryPointStatusInvalid Indicates status of entry point is not known or invalid. The value is 0.
	EntryPointStatusInvalid EntryPointStatus = "Invalid"
	// EntryPointStatusPending Indicates the entry point is scheduled to be started. The value is 1.
	EntryPointStatusPending EntryPointStatus = "Pending"
	// EntryPointStatusStarted Indicates the entry point was started successfully and is running. The value is
	// 3.
	EntryPointStatusStarted EntryPointStatus = "Started"
	// EntryPointStatusStarting Indicates the entry point is being started. The value is 2.
	EntryPointStatusStarting EntryPointStatus = "Starting"
	// EntryPointStatusStopped Indicates the entry point is not running. The value is 5.
	EntryPointStatusStopped EntryPointStatus = "Stopped"
	// EntryPointStatusStopping Indicates the entry point is being stopped. The value is 4.
	EntryPointStatusStopping EntryPointStatus = "Stopping"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleEntryPointStatusValues returns an array of possible values for the EntryPointStatus const type.
func PossibleEntryPointStatusValues() []EntryPointStatus {
	return []EntryPointStatus{EntryPointStatusInvalid, EntryPointStatusPending, EntryPointStatusStarted, EntryPointStatusStarting, EntryPointStatusStopped, EntryPointStatusStopping}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FabricReplicaStatus enumerates the values for fabric replica status.
type FabricReplicaStatus string

const (
	// FabricReplicaStatusDown Indicates that the replica is down.
	FabricReplicaStatusDown FabricReplicaStatus = "Down"
	// FabricReplicaStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	FabricReplicaStatusInvalid FabricReplicaStatus = "Invalid"
	// FabricReplicaStatusUp Indicates that the replica is up.
	FabricReplicaStatusUp FabricReplicaStatus = "Up"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleFabricReplicaStatusValues returns an array of possible values for the FabricReplicaStatus const type.
func PossibleFabricReplicaStatusValues() []FabricReplicaStatus {
	return []FabricReplicaStatus{FabricReplicaStatusDown, FabricReplicaStatusInvalid, FabricReplicaStatusUp}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FailureAction enumerates the values for failure action.
type FailureAction string

const (
	// FailureActionInvalid Indicates the failure action is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	FailureActionInvalid FailureAction = "Invalid"
	// FailureActionManual The upgrade will switch to UnmonitoredManual upgrade mode. The value is 2
	FailureActionManual FailureAction = "Manual"
	// FailureActionRollback The upgrade will start rolling back automatically. The value is 1
	FailureActionRollback FailureAction = "Rollback"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleFailureActionValues returns an array of possible values for the FailureAction const type.
func PossibleFailureActionValues() []FailureAction {
	return []FailureAction{FailureActionInvalid, FailureActionManual, FailureActionRollback}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FailureReason enumerates the values for failure reason.
type FailureReason string

const (
	// HealthCheck The upgrade failed due to health policy violations. The value is 2
	HealthCheck FailureReason = "HealthCheck"
	// Interrupted There was an external request to rollback the upgrade. The value is 1
	Interrupted FailureReason = "Interrupted"
	// None Indicates the reason is invalid or unknown. All Service Fabric enumerations have the invalid type.
	// The value is zero.
	None FailureReason = "None"
	// OverallUpgradeTimeout The overall upgrade took longer than the allowed upgrade timeout to process. The
	// value is 4
	OverallUpgradeTimeout FailureReason = "OverallUpgradeTimeout"
	// UpgradeDomainTimeout An upgrade domain took longer than the allowed upgrade domain timeout to process.
	// The value is 3
	UpgradeDomainTimeout FailureReason = "UpgradeDomainTimeout"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleFailureReasonValues returns an array of possible values for the FailureReason const type.
func PossibleFailureReasonValues() []FailureReason {
	return []FailureReason{HealthCheck, Interrupted, None, OverallUpgradeTimeout, UpgradeDomainTimeout}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthEvaluationKind enumerates the values for health evaluation kind.
type HealthEvaluationKind string

const (
	// HealthEvaluationKindApplication Indicates that the health evaluation is for an application. The value is
	// 18.
	HealthEvaluationKindApplication HealthEvaluationKind = "Application"
	// HealthEvaluationKindApplications Indicates that the health evaluation is for the cluster applications.
	// The value is 8.
	HealthEvaluationKindApplications HealthEvaluationKind = "Applications"
	// HealthEvaluationKindApplicationTypeApplications – Indicates that the health evaluation is for
	// applications of an application type. The value is 21.
	HealthEvaluationKindApplicationTypeApplications HealthEvaluationKind = "ApplicationTypeApplications"
	// HealthEvaluationKindDeltaNodesCheck Indicates that the health evaluation is for the delta of unhealthy
	// cluster nodes. The value is 19.
	HealthEvaluationKindDeltaNodesCheck HealthEvaluationKind = "DeltaNodesCheck"
	// HealthEvaluationKindDeployedApplication Indicates that the health evaluation is for a deployed
	// application. The value is 17.
	HealthEvaluationKindDeployedApplication HealthEvaluationKind = "DeployedApplication"
	// HealthEvaluationKindDeployedApplications Indicates that the health evaluation is for the deployed
	// applications of an application. The value is 5.
	HealthEvaluationKindDeployedApplications HealthEvaluationKind = "DeployedApplications"
	// HealthEvaluationKindDeployedServicePackage Indicates that the health evaluation is for a deployed
	// service package. The value is 16.
	HealthEvaluationKindDeployedServicePackage HealthEvaluationKind = "DeployedServicePackage"
	// HealthEvaluationKindDeployedServicePackages Indicates that the health evaluation is for the deployed
	// service packages of a deployed application. The value is 4.
	HealthEvaluationKindDeployedServicePackages HealthEvaluationKind = "DeployedServicePackages"
	// HealthEvaluationKindEvent Indicates that the health evaluation is for a health event. The value is 1.
	HealthEvaluationKindEvent HealthEvaluationKind = "Event"
	// HealthEvaluationKindInvalid Indicates that the health evaluation is invalid. The value is zero.
	HealthEvaluationKindInvalid HealthEvaluationKind = "Invalid"
	// HealthEvaluationKindNode Indicates that the health evaluation is for a node. The value is 12.
	HealthEvaluationKindNode HealthEvaluationKind = "Node"
	// HealthEvaluationKindNodes Indicates that the health evaluation is for the cluster nodes. The value is 7.
	HealthEvaluationKindNodes HealthEvaluationKind = "Nodes"
	// HealthEvaluationKindPartition Indicates that the health evaluation is for a partition. The value is 14.
	HealthEvaluationKindPartition HealthEvaluationKind = "Partition"
	// HealthEvaluationKindPartitions Indicates that the health evaluation is for the partitions of a service.
	// The value is 3.
	HealthEvaluationKindPartitions HealthEvaluationKind = "Partitions"
	// HealthEvaluationKindReplica Indicates that the health evaluation is for a replica. The value is 13.
	HealthEvaluationKindReplica HealthEvaluationKind = "Replica"
	// HealthEvaluationKindReplicas Indicates that the health evaluation is for the replicas of a partition.
	// The value is 2.
	HealthEvaluationKindReplicas HealthEvaluationKind = "Replicas"
	// HealthEvaluationKindService Indicates that the health evaluation is for a service. The value is 15.
	HealthEvaluationKindService HealthEvaluationKind = "Service"
	// HealthEvaluationKindServices Indicates that the health evaluation is for services of an application. The
	// value is 6.
	HealthEvaluationKindServices HealthEvaluationKind = "Services"
	// HealthEvaluationKindSystemApplication Indicates that the health evaluation is for the system
	// application. The value is 9.
	HealthEvaluationKindSystemApplication HealthEvaluationKind = "SystemApplication"
	// HealthEvaluationKindUpgradeDomainDeltaNodesCheck Indicates that the health evaluation is for the delta
	// of unhealthy upgrade domain cluster nodes. The value is 20.
	HealthEvaluationKindUpgradeDomainDeltaNodesCheck HealthEvaluationKind = "UpgradeDomainDeltaNodesCheck"
	// HealthEvaluationKindUpgradeDomainDeployedApplications Indicates that the health evaluation is for the
	// deployed applications of an application in an upgrade domain. The value is 10.
	HealthEvaluationKindUpgradeDomainDeployedApplications HealthEvaluationKind = "UpgradeDomainDeployedApplications"
	// HealthEvaluationKindUpgradeDomainNodes Indicates that the health evaluation is for the cluster nodes in
	// an upgrade domain. The value is 11.
	HealthEvaluationKindUpgradeDomainNodes HealthEvaluationKind = "UpgradeDomainNodes"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleHealthEvaluationKindValues returns an array of possible values for the HealthEvaluationKind const type.
func PossibleHealthEvaluationKindValues() []HealthEvaluationKind {
	return []HealthEvaluationKind{HealthEvaluationKindApplication, HealthEvaluationKindApplications, HealthEvaluationKindApplicationTypeApplications, HealthEvaluationKindDeltaNodesCheck, HealthEvaluationKindDeployedApplication, HealthEvaluationKindDeployedApplications, HealthEvaluationKindDeployedServicePackage, HealthEvaluationKindDeployedServicePackages, HealthEvaluationKindEvent, HealthEvaluationKindInvalid, HealthEvaluationKindNode, HealthEvaluationKindNodes, HealthEvaluationKindPartition, HealthEvaluationKindPartitions, HealthEvaluationKindReplica, HealthEvaluationKindReplicas, HealthEvaluationKindService, HealthEvaluationKindServices, HealthEvaluationKindSystemApplication, HealthEvaluationKindUpgradeDomainDeltaNodesCheck, HealthEvaluationKindUpgradeDomainDeployedApplications, HealthEvaluationKindUpgradeDomainNodes}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HostIsolationMode enumerates the values for host isolation mode.
type HostIsolationMode string

const (
	// HostIsolationModeHyperV Indicates the ContainerHost is a Hyper-V container. This applies to only Windows
	// containers. The value is 2.
	HostIsolationModeHyperV HostIsolationMode = "HyperV"
	// HostIsolationModeNone Indicates the isolation mode is not applicable for given HostType. The value is 0.
	HostIsolationModeNone HostIsolationMode = "None"
	// HostIsolationModeProcess This is the default isolation mode for a ContainerHost. The value is 1.
	HostIsolationModeProcess HostIsolationMode = "Process"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleHostIsolationModeValues returns an array of possible values for the HostIsolationMode const type.
func PossibleHostIsolationModeValues() []HostIsolationMode {
	return []HostIsolationMode{HostIsolationModeHyperV, HostIsolationModeNone, HostIsolationModeProcess}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeContainerHost Indicates the host is a container. The value is 2.
	HostTypeContainerHost HostType = "ContainerHost"
	// HostTypeExeHost Indicates the host is an executable. The value is 1.
	HostTypeExeHost HostType = "ExeHost"
	// HostTypeInvalid Indicates the type of host is not known or invalid. The value is 0.
	HostTypeInvalid HostType = "Invalid"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeContainerHost, HostTypeExeHost, HostTypeInvalid}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ImpactLevel enumerates the values for impact level.
type ImpactLevel string

const (
	// ImpactLevelInvalid ...
	ImpactLevelInvalid ImpactLevel = "Invalid"
	// ImpactLevelNone ...
	ImpactLevelNone ImpactLevel = "None"
	// ImpactLevelRemoveData ...
	ImpactLevelRemoveData ImpactLevel = "RemoveData"
	// ImpactLevelRemoveNode ...
	ImpactLevelRemoveNode ImpactLevel = "RemoveNode"
	// ImpactLevelRestart ...
	ImpactLevelRestart ImpactLevel = "Restart"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleImpactLevelValues returns an array of possible values for the ImpactLevel const type.
func PossibleImpactLevelValues() []ImpactLevel {
	return []ImpactLevel{ImpactLevelInvalid, ImpactLevelNone, ImpactLevelRemoveData, ImpactLevelRemoveNode, ImpactLevelRestart}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Kind enumerates the values for kind.
type Kind string

const (
	// KindApplication ...
	KindApplication Kind = "Application"
	// KindApplications ...
	KindApplications Kind = "Applications"
	// KindApplicationTypeApplications ...
	KindApplicationTypeApplications Kind = "ApplicationTypeApplications"
	// KindDeltaNodesCheck ...
	KindDeltaNodesCheck Kind = "DeltaNodesCheck"
	// KindDeployedApplication ...
	KindDeployedApplication Kind = "DeployedApplication"
	// KindDeployedApplications ...
	KindDeployedApplications Kind = "DeployedApplications"
	// KindDeployedServicePackage ...
	KindDeployedServicePackage Kind = "DeployedServicePackage"
	// KindDeployedServicePackages ...
	KindDeployedServicePackages Kind = "DeployedServicePackages"
	// KindEvent ...
	KindEvent Kind = "Event"
	// KindHealthEvaluation ...
	KindHealthEvaluation Kind = "HealthEvaluation"
	// KindNode ...
	KindNode Kind = "Node"
	// KindNodes ...
	KindNodes Kind = "Nodes"
	// KindPartition ...
	KindPartition Kind = "Partition"
	// KindPartitions ...
	KindPartitions Kind = "Partitions"
	// KindReplica ...
	KindReplica Kind = "Replica"
	// KindReplicas ...
	KindReplicas Kind = "Replicas"
	// KindService ...
	KindService Kind = "Service"
	// KindServices ...
	KindServices Kind = "Services"
	// KindSystemApplication ...
	KindSystemApplication Kind = "SystemApplication"
	// KindUpgradeDomainDeltaNodesCheck ...
	KindUpgradeDomainDeltaNodesCheck Kind = "UpgradeDomainDeltaNodesCheck"
	// KindUpgradeDomainNodes ...
	KindUpgradeDomainNodes Kind = "UpgradeDomainNodes"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindApplication, KindApplications, KindApplicationTypeApplications, KindDeltaNodesCheck, KindDeployedApplication, KindDeployedApplications, KindDeployedServicePackage, KindDeployedServicePackages, KindEvent, KindHealthEvaluation, KindNode, KindNodes, KindPartition, KindPartitions, KindReplica, KindReplicas, KindService, KindServices, KindSystemApplication, KindUpgradeDomainDeltaNodesCheck, KindUpgradeDomainNodes}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicChaosEvent enumerates the values for kind basic chaos event.
type KindBasicChaosEvent string

const (
	// KindChaosEvent ...
	KindChaosEvent KindBasicChaosEvent = "ChaosEvent"
	// KindExecutingFaults ...
	KindExecutingFaults KindBasicChaosEvent = "ExecutingFaults"
	// KindStarted ...
	KindStarted KindBasicChaosEvent = "Started"
	// KindStopped ...
	KindStopped KindBasicChaosEvent = "Stopped"
	// KindTestError ...
	KindTestError KindBasicChaosEvent = "TestError"
	// KindValidationFailed ...
	KindValidationFailed KindBasicChaosEvent = "ValidationFailed"
	// KindWaiting ...
	KindWaiting KindBasicChaosEvent = "Waiting"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicChaosEventValues returns an array of possible values for the KindBasicChaosEvent const type.
func PossibleKindBasicChaosEventValues() []KindBasicChaosEvent {
	return []KindBasicChaosEvent{KindChaosEvent, KindExecutingFaults, KindStarted, KindStopped, KindTestError, KindValidationFailed, KindWaiting}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicPropertyBatchInfo enumerates the values for kind basic property batch info.
type KindBasicPropertyBatchInfo string

const (
	// KindFailed ...
	KindFailed KindBasicPropertyBatchInfo = "Failed"
	// KindPropertyBatchInfo ...
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = "PropertyBatchInfo"
	// KindSuccessful ...
	KindSuccessful KindBasicPropertyBatchInfo = "Successful"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicPropertyBatchInfoValues returns an array of possible values for the KindBasicPropertyBatchInfo const type.
func PossibleKindBasicPropertyBatchInfoValues() []KindBasicPropertyBatchInfo {
	return []KindBasicPropertyBatchInfo{KindFailed, KindPropertyBatchInfo, KindSuccessful}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicPropertyBatchOperation enumerates the values for kind basic property batch operation.
type KindBasicPropertyBatchOperation string

const (
	// KindCheckExists ...
	KindCheckExists KindBasicPropertyBatchOperation = "CheckExists"
	// KindCheckSequence ...
	KindCheckSequence KindBasicPropertyBatchOperation = "CheckSequence"
	// KindCheckValue ...
	KindCheckValue KindBasicPropertyBatchOperation = "CheckValue"
	// KindDelete ...
	KindDelete KindBasicPropertyBatchOperation = "Delete"
	// KindGet ...
	KindGet KindBasicPropertyBatchOperation = "Get"
	// KindPropertyBatchOperation ...
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = "PropertyBatchOperation"
	// KindPut ...
	KindPut KindBasicPropertyBatchOperation = "Put"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicPropertyBatchOperationValues returns an array of possible values for the KindBasicPropertyBatchOperation const type.
func PossibleKindBasicPropertyBatchOperationValues() []KindBasicPropertyBatchOperation {
	return []KindBasicPropertyBatchOperation{KindCheckExists, KindCheckSequence, KindCheckValue, KindDelete, KindGet, KindPropertyBatchOperation, KindPut}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicPropertyValue enumerates the values for kind basic property value.
type KindBasicPropertyValue string

const (
	// KindBinary ...
	KindBinary KindBasicPropertyValue = "Binary"
	// KindDouble ...
	KindDouble KindBasicPropertyValue = "Double"
	// KindGUID ...
	KindGUID KindBasicPropertyValue = "Guid"
	// KindInt64 ...
	KindInt64 KindBasicPropertyValue = "Int64"
	// KindPropertyValue ...
	KindPropertyValue KindBasicPropertyValue = "PropertyValue"
	// KindString ...
	KindString KindBasicPropertyValue = "String"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicPropertyValueValues returns an array of possible values for the KindBasicPropertyValue const type.
func PossibleKindBasicPropertyValueValues() []KindBasicPropertyValue {
	return []KindBasicPropertyValue{KindBinary, KindDouble, KindGUID, KindInt64, KindPropertyValue, KindString}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicProvisionApplicationTypeDescriptionBase enumerates the values for kind basic provision application
// type description base.
type KindBasicProvisionApplicationTypeDescriptionBase string

const (
	// KindExternalStore ...
	KindExternalStore KindBasicProvisionApplicationTypeDescriptionBase = "ExternalStore"
	// KindImageStorePath ...
	KindImageStorePath KindBasicProvisionApplicationTypeDescriptionBase = "ImageStorePath"
	// KindProvisionApplicationTypeDescriptionBase ...
	KindProvisionApplicationTypeDescriptionBase KindBasicProvisionApplicationTypeDescriptionBase = "ProvisionApplicationTypeDescriptionBase"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues returns an array of possible values for the KindBasicProvisionApplicationTypeDescriptionBase const type.
func PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues() []KindBasicProvisionApplicationTypeDescriptionBase {
	return []KindBasicProvisionApplicationTypeDescriptionBase{KindExternalStore, KindImageStorePath, KindProvisionApplicationTypeDescriptionBase}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicRepairImpactDescriptionBase enumerates the values for kind basic repair impact description base.
type KindBasicRepairImpactDescriptionBase string

const (
	// KindBasicRepairImpactDescriptionBaseKindNode ...
	KindBasicRepairImpactDescriptionBaseKindNode KindBasicRepairImpactDescriptionBase = "Node"
	// KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase ...
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = "RepairImpactDescriptionBase"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicRepairImpactDescriptionBaseValues returns an array of possible values for the KindBasicRepairImpactDescriptionBase const type.
func PossibleKindBasicRepairImpactDescriptionBaseValues() []KindBasicRepairImpactDescriptionBase {
	return []KindBasicRepairImpactDescriptionBase{KindBasicRepairImpactDescriptionBaseKindNode, KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicRepairTargetDescriptionBase enumerates the values for kind basic repair target description base.
type KindBasicRepairTargetDescriptionBase string

const (
	// KindBasicRepairTargetDescriptionBaseKindNode ...
	KindBasicRepairTargetDescriptionBaseKindNode KindBasicRepairTargetDescriptionBase = "Node"
	// KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase ...
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = "RepairTargetDescriptionBase"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicRepairTargetDescriptionBaseValues returns an array of possible values for the KindBasicRepairTargetDescriptionBase const type.
func PossibleKindBasicRepairTargetDescriptionBaseValues() []KindBasicRepairTargetDescriptionBase {
	return []KindBasicRepairTargetDescriptionBase{KindBasicRepairTargetDescriptionBaseKindNode, KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicReplicaStatusBase enumerates the values for kind basic replica status base.
type KindBasicReplicaStatusBase string

const (
	// KindKeyValueStore ...
	KindKeyValueStore KindBasicReplicaStatusBase = "KeyValueStore"
	// KindReplicaStatusBase ...
	KindReplicaStatusBase KindBasicReplicaStatusBase = "ReplicaStatusBase"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicReplicaStatusBaseValues returns an array of possible values for the KindBasicReplicaStatusBase const type.
func PossibleKindBasicReplicaStatusBaseValues() []KindBasicReplicaStatusBase {
	return []KindBasicReplicaStatusBase{KindKeyValueStore, KindReplicaStatusBase}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicReplicatorStatus enumerates the values for kind basic replicator status.
type KindBasicReplicatorStatus string

const (
	// KindActiveSecondary ...
	KindActiveSecondary KindBasicReplicatorStatus = "ActiveSecondary"
	// KindIdleSecondary ...
	KindIdleSecondary KindBasicReplicatorStatus = "IdleSecondary"
	// KindPrimary ...
	KindPrimary KindBasicReplicatorStatus = "Primary"
	// KindReplicatorStatus ...
	KindReplicatorStatus KindBasicReplicatorStatus = "ReplicatorStatus"
	// KindSecondaryReplicatorStatus ...
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = "SecondaryReplicatorStatus"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicReplicatorStatusValues returns an array of possible values for the KindBasicReplicatorStatus const type.
func PossibleKindBasicReplicatorStatusValues() []KindBasicReplicatorStatus {
	return []KindBasicReplicatorStatus{KindActiveSecondary, KindIdleSecondary, KindPrimary, KindReplicatorStatus, KindSecondaryReplicatorStatus}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicSafetyCheck enumerates the values for kind basic safety check.
type KindBasicSafetyCheck string

const (
	// KindEnsureAvailability ...
	KindEnsureAvailability KindBasicSafetyCheck = "EnsureAvailability"
	// KindEnsurePartitionQuorum ...
	KindEnsurePartitionQuorum KindBasicSafetyCheck = "EnsurePartitionQuorum"
	// KindEnsureSeedNodeQuorum ...
	KindEnsureSeedNodeQuorum KindBasicSafetyCheck = "EnsureSeedNodeQuorum"
	// KindPartitionSafetyCheck ...
	KindPartitionSafetyCheck KindBasicSafetyCheck = "PartitionSafetyCheck"
	// KindSafetyCheck ...
	KindSafetyCheck KindBasicSafetyCheck = "SafetyCheck"
	// KindWaitForInbuildReplica ...
	KindWaitForInbuildReplica KindBasicSafetyCheck = "WaitForInbuildReplica"
	// KindWaitForPrimaryPlacement ...
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = "WaitForPrimaryPlacement"
	// KindWaitForPrimarySwap ...
	KindWaitForPrimarySwap KindBasicSafetyCheck = "WaitForPrimarySwap"
	// KindWaitForReconfiguration ...
	KindWaitForReconfiguration KindBasicSafetyCheck = "WaitForReconfiguration"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicSafetyCheckValues returns an array of possible values for the KindBasicSafetyCheck const type.
func PossibleKindBasicSafetyCheckValues() []KindBasicSafetyCheck {
	return []KindBasicSafetyCheck{KindEnsureAvailability, KindEnsurePartitionQuorum, KindEnsureSeedNodeQuorum, KindPartitionSafetyCheck, KindSafetyCheck, KindWaitForInbuildReplica, KindWaitForPrimaryPlacement, KindWaitForPrimarySwap, KindWaitForReconfiguration}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KindBasicServiceTypeDescription enumerates the values for kind basic service type description.
type KindBasicServiceTypeDescription string

const (
	// KindServiceTypeDescription ...
	KindServiceTypeDescription KindBasicServiceTypeDescription = "ServiceTypeDescription"
	// KindStateful ...
	KindStateful KindBasicServiceTypeDescription = "Stateful"
	// KindStateless ...
	KindStateless KindBasicServiceTypeDescription = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleKindBasicServiceTypeDescriptionValues returns an array of possible values for the KindBasicServiceTypeDescription const type.
func PossibleKindBasicServiceTypeDescriptionValues() []KindBasicServiceTypeDescription {
	return []KindBasicServiceTypeDescription{KindServiceTypeDescription, KindStateful, KindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// High Specifies the move cost of the service as High. The value is 3.
	High MoveCost = "High"
	// Low Specifies the move cost of the service as Low. The value is 1.
	Low MoveCost = "Low"
	// Medium Specifies the move cost of the service as Medium. The value is 2.
	Medium MoveCost = "Medium"
	// Zero Zero move cost. This value is zero.
	Zero MoveCost = "Zero"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{High, Low, Medium, Zero}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationIntent enumerates the values for node deactivation intent.
type NodeDeactivationIntent string

const (
	// NodeDeactivationIntentInvalid Indicates the node deactivation intent is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationIntentInvalid NodeDeactivationIntent = "Invalid"
	// NodeDeactivationIntentPause Indicates that the node should be paused. The value is 1.
	NodeDeactivationIntentPause NodeDeactivationIntent = "Pause"
	// NodeDeactivationIntentRemoveData Indicates that the intent is to reimage the node. Service Fabric does
	// not reimage the node, this action is done outside of Service Fabric. The value is 3.
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = "RemoveData"
	// NodeDeactivationIntentRemoveNode Indicates that the node is being decommissioned and is not expected to
	// return. Service Fabric does not decommission the node, this action is done outside of Service Fabric.
	// The value is 4.
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = "RemoveNode"
	// NodeDeactivationIntentRestart Indicates that the intent is for the node to be restarted after a short
	// period of time. Service Fabric does not restart the node, this action is done outside of Service Fabric.
	// The value is 2.
	NodeDeactivationIntentRestart NodeDeactivationIntent = "Restart"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeDeactivationIntentValues returns an array of possible values for the NodeDeactivationIntent const type.
func PossibleNodeDeactivationIntentValues() []NodeDeactivationIntent {
	return []NodeDeactivationIntent{NodeDeactivationIntentInvalid, NodeDeactivationIntentPause, NodeDeactivationIntentRemoveData, NodeDeactivationIntentRemoveNode, NodeDeactivationIntentRestart}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationStatus enumerates the values for node deactivation status.
type NodeDeactivationStatus string

const (
	// NodeDeactivationStatusCompleted The task is completed. The value is 3.
	NodeDeactivationStatusCompleted NodeDeactivationStatus = "Completed"
	// NodeDeactivationStatusNone No status is associated with the task. The value is zero.
	NodeDeactivationStatusNone NodeDeactivationStatus = "None"
	// NodeDeactivationStatusSafetyCheckComplete When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that all safety checks have been completed. The value is 2.
	NodeDeactivationStatusSafetyCheckComplete NodeDeactivationStatus = "SafetyCheckComplete"
	// NodeDeactivationStatusSafetyCheckInProgress When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that one or more safety checks are in progress. The value is 1.
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = "SafetyCheckInProgress"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeDeactivationStatusValues returns an array of possible values for the NodeDeactivationStatus const type.
func PossibleNodeDeactivationStatusValues() []NodeDeactivationStatus {
	return []NodeDeactivationStatus{NodeDeactivationStatusCompleted, NodeDeactivationStatusNone, NodeDeactivationStatusSafetyCheckComplete, NodeDeactivationStatusSafetyCheckInProgress}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationTaskType enumerates the values for node deactivation task type.
type NodeDeactivationTaskType string

const (
	// NodeDeactivationTaskTypeClient Specifies that the task was created by using the public API. The value is
	// 3.
	NodeDeactivationTaskTypeClient NodeDeactivationTaskType = "Client"
	// NodeDeactivationTaskTypeInfrastructure Specifies the task created by Infrastructure hosting the nodes.
	// The value is 1.
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = "Infrastructure"
	// NodeDeactivationTaskTypeInvalid Indicates the node deactivation task type is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationTaskTypeInvalid NodeDeactivationTaskType = "Invalid"
	// NodeDeactivationTaskTypeRepair Specifies the task that was created by the Repair Manager service. The
	// value is 2.
	NodeDeactivationTaskTypeRepair NodeDeactivationTaskType = "Repair"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeDeactivationTaskTypeValues returns an array of possible values for the NodeDeactivationTaskType const type.
func PossibleNodeDeactivationTaskTypeValues() []NodeDeactivationTaskType {
	return []NodeDeactivationTaskType{NodeDeactivationTaskTypeClient, NodeDeactivationTaskTypeInfrastructure, NodeDeactivationTaskTypeInvalid, NodeDeactivationTaskTypeRepair}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeStatus enumerates the values for node status.
type NodeStatus string

const (
	// NodeStatusDisabled Indicates the node is disabled. The value is 5.
	NodeStatusDisabled NodeStatus = "Disabled"
	// NodeStatusDisabling Indicates the node is in the process of being disabled. The value is 4.
	NodeStatusDisabling NodeStatus = "Disabling"
	// NodeStatusDown Indicates the node is down. The value is 2.
	NodeStatusDown NodeStatus = "Down"
	// NodeStatusEnabling Indicates the node is in process of being enabled. The value is 3.
	NodeStatusEnabling NodeStatus = "Enabling"
	// NodeStatusInvalid Indicates the node status is invalid. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	NodeStatusInvalid NodeStatus = "Invalid"
	// NodeStatusRemoved Indicates the node is removed. A node would be in Removed state if NodeStateRemoved
	// API has been called for this node. In other words, Service Fabric has been informed that the persisted
	// state on the node has been permanently lost. The value is 7.
	NodeStatusRemoved NodeStatus = "Removed"
	// NodeStatusUnknown Indicates the node is unknown. A node would be in Unknown state if Service Fabric does
	// not have authoritative information about that node. This can happen if the system learns about a node at
	// runtime.The value is 6.
	NodeStatusUnknown NodeStatus = "Unknown"
	// NodeStatusUp Indicates the node is up. The value is 1.
	NodeStatusUp NodeStatus = "Up"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeStatusValues returns an array of possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{NodeStatusDisabled, NodeStatusDisabling, NodeStatusDown, NodeStatusEnabling, NodeStatusInvalid, NodeStatusRemoved, NodeStatusUnknown, NodeStatusUp}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeStatusFilterOptionalQueryParam enumerates the values for node status filter optional query param.
type NodeStatusFilterOptionalQueryParam string

const (
	// All This filter value will match all of the nodes.
	All NodeStatusFilterOptionalQueryParam = "all"
	// Default This filter value will match all of the nodes excepts the ones with with status as Unknown or
	// Removed.
	Default NodeStatusFilterOptionalQueryParam = "default"
	// Disabled This filter value will match nodes that are Disabled.
	Disabled NodeStatusFilterOptionalQueryParam = "disabled"
	// Disabling This filter value will match nodes that are in the process of being disabled with status as
	// Disabling.
	Disabling NodeStatusFilterOptionalQueryParam = "disabling"
	// Down This filter value will match nodes that are Down.
	Down NodeStatusFilterOptionalQueryParam = "down"
	// Enabling This filter value will match nodes that are in the process of being enabled with status as
	// Enabling.
	Enabling NodeStatusFilterOptionalQueryParam = "enabling"
	// Removed This filter value will match nodes whose status is Removed. These are the nodes that are removed
	// from the cluster using the RemoveNodeState API.
	Removed NodeStatusFilterOptionalQueryParam = "removed"
	// Unknown This filter value will match nodes whose status is Unknown. A node would be in Unknown state if
	// Service Fabric does not have authoritative information about that node. This can happen if the system
	// learns about a node at runtime.
	Unknown NodeStatusFilterOptionalQueryParam = "unknown"
	// Up This filter value will match nodes that are Up.
	Up NodeStatusFilterOptionalQueryParam = "up"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeStatusFilterOptionalQueryParamValues returns an array of possible values for the NodeStatusFilterOptionalQueryParam const type.
func PossibleNodeStatusFilterOptionalQueryParamValues() []NodeStatusFilterOptionalQueryParam {
	return []NodeStatusFilterOptionalQueryParam{All, Default, Disabled, Disabling, Down, Enabling, Removed, Unknown, Up}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeTransitionTypeRequiredQueryParam enumerates the values for node transition type required query param.
type NodeTransitionTypeRequiredQueryParam string

const (
	// NodeTransitionTypeRequiredQueryParamInvalid Reserved.  Do not pass into API.
	NodeTransitionTypeRequiredQueryParamInvalid NodeTransitionTypeRequiredQueryParam = "Invalid"
	// NodeTransitionTypeRequiredQueryParamStart Transition a stopped node to up.
	NodeTransitionTypeRequiredQueryParamStart NodeTransitionTypeRequiredQueryParam = "Start"
	// NodeTransitionTypeRequiredQueryParamStop Transition an up node to stopped.
	NodeTransitionTypeRequiredQueryParamStop NodeTransitionTypeRequiredQueryParam = "Stop"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeTransitionTypeRequiredQueryParamValues returns an array of possible values for the NodeTransitionTypeRequiredQueryParam const type.
func PossibleNodeTransitionTypeRequiredQueryParamValues() []NodeTransitionTypeRequiredQueryParam {
	return []NodeTransitionTypeRequiredQueryParam{NodeTransitionTypeRequiredQueryParamInvalid, NodeTransitionTypeRequiredQueryParamStart, NodeTransitionTypeRequiredQueryParamStop}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeUpgradePhase enumerates the values for node upgrade phase.
type NodeUpgradePhase string

const (
	// NodeUpgradePhaseInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	NodeUpgradePhaseInvalid NodeUpgradePhase = "Invalid"
	// NodeUpgradePhasePostUpgradeSafetyCheck The upgrade has completed and post upgrade safety checks are
	// being performed. The value is 3
	NodeUpgradePhasePostUpgradeSafetyCheck NodeUpgradePhase = "PostUpgradeSafetyCheck"
	// NodeUpgradePhasePreUpgradeSafetyCheck The upgrade has not started yet due to pending safety checks. The
	// value is 1
	NodeUpgradePhasePreUpgradeSafetyCheck NodeUpgradePhase = "PreUpgradeSafetyCheck"
	// NodeUpgradePhaseUpgrading The upgrade is in progress. The value is 2
	NodeUpgradePhaseUpgrading NodeUpgradePhase = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleNodeUpgradePhaseValues returns an array of possible values for the NodeUpgradePhase const type.
func PossibleNodeUpgradePhaseValues() []NodeUpgradePhase {
	return []NodeUpgradePhase{NodeUpgradePhaseInvalid, NodeUpgradePhasePostUpgradeSafetyCheck, NodeUpgradePhasePreUpgradeSafetyCheck, NodeUpgradePhaseUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// OperationState enumerates the values for operation state.
type OperationState string

const (
	// OperationStateCancelled The operation was cancelled by the user using CancelOperation, and is no longer
	// running.
	OperationStateCancelled OperationState = "Cancelled"
	// OperationStateCompleted The operation has completed successfully and is no longer running.
	OperationStateCompleted OperationState = "Completed"
	// OperationStateFaulted The operation has failed and is no longer running.
	OperationStateFaulted OperationState = "Faulted"
	// OperationStateForceCancelled The operation was cancelled by the user using CancelOperation, with the
	// force parameter set to true.  It is no longer running.  Refer to CancelOperation for more details.
	OperationStateForceCancelled OperationState = "ForceCancelled"
	// OperationStateInvalid The operation state is invalid.
	OperationStateInvalid OperationState = "Invalid"
	// OperationStateRollingBack The operation is rolling back internal system state because it encountered a
	// fatal error or was cancelled by the user.  "RollingBack"     does not refer to user state.  For example,
	// if CancelOperation is called on a command of type PartitionDataLoss, state of "RollingBack" does not
	// mean service data is being restored (assuming the command has progressed far enough to cause data loss).
	// It means the system is rolling back/cleaning up internal system state associated with the command.
	OperationStateRollingBack OperationState = "RollingBack"
	// OperationStateRunning The operation is in progress.
	OperationStateRunning OperationState = "Running"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleOperationStateValues returns an array of possible values for the OperationState const type.
func PossibleOperationStateValues() []OperationState {
	return []OperationState{OperationStateCancelled, OperationStateCompleted, OperationStateFaulted, OperationStateForceCancelled, OperationStateInvalid, OperationStateRollingBack, OperationStateRunning}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid The operation state is invalid.
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeNodeTransition An operation started using the StartNodeTransition API.
	OperationTypeNodeTransition OperationType = "NodeTransition"
	// OperationTypePartitionDataLoss An operation started using the StartDataLoss API.
	OperationTypePartitionDataLoss OperationType = "PartitionDataLoss"
	// OperationTypePartitionQuorumLoss An operation started using the StartQuorumLoss API.
	OperationTypePartitionQuorumLoss OperationType = "PartitionQuorumLoss"
	// OperationTypePartitionRestart An operation started using the StartPartitionRestart API.
	OperationTypePartitionRestart OperationType = "PartitionRestart"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeNodeTransition, OperationTypePartitionDataLoss, OperationTypePartitionQuorumLoss, OperationTypePartitionRestart}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PackageSharingPolicyScope enumerates the values for package sharing policy scope.
type PackageSharingPolicyScope string

const (
	// PackageSharingPolicyScopeAll Share all code, config and data packages from corresponding service
	// manifest. The value is 1.
	PackageSharingPolicyScopeAll PackageSharingPolicyScope = "All"
	// PackageSharingPolicyScopeCode Share all code packages from corresponding service manifest. The value is
	// 2.
	PackageSharingPolicyScopeCode PackageSharingPolicyScope = "Code"
	// PackageSharingPolicyScopeConfig Share all config packages from corresponding service manifest. The value
	// is 3.
	PackageSharingPolicyScopeConfig PackageSharingPolicyScope = "Config"
	// PackageSharingPolicyScopeData Share all data packages from corresponding service manifest. The value is
	// 4.
	PackageSharingPolicyScopeData PackageSharingPolicyScope = "Data"
	// PackageSharingPolicyScopeNone No package sharing policy scope. The value is 0.
	PackageSharingPolicyScopeNone PackageSharingPolicyScope = "None"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePackageSharingPolicyScopeValues returns an array of possible values for the PackageSharingPolicyScope const type.
func PossiblePackageSharingPolicyScopeValues() []PackageSharingPolicyScope {
	return []PackageSharingPolicyScope{PackageSharingPolicyScopeAll, PackageSharingPolicyScopeCode, PackageSharingPolicyScopeConfig, PackageSharingPolicyScopeData, PackageSharingPolicyScopeNone}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionAccessStatus enumerates the values for partition access status.
type PartitionAccessStatus string

const (
	// PartitionAccessStatusGranted Indicates that the read or write operation access is granted and the
	// operation is allowed.
	PartitionAccessStatusGranted PartitionAccessStatus = "Granted"
	// PartitionAccessStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	PartitionAccessStatusInvalid PartitionAccessStatus = "Invalid"
	// PartitionAccessStatusNotPrimary Indicates that this client request was received by a replica that is not
	// a Primary replica.
	PartitionAccessStatusNotPrimary PartitionAccessStatus = "NotPrimary"
	// PartitionAccessStatusNoWriteQuorum Indicates that no write quorum is available and, therefore, no write
	// operation can be accepted.
	PartitionAccessStatusNoWriteQuorum PartitionAccessStatus = "NoWriteQuorum"
	// PartitionAccessStatusReconfigurationPending Indicates that the client should try again later, because a
	// reconfiguration is in progress.
	PartitionAccessStatusReconfigurationPending PartitionAccessStatus = "ReconfigurationPending"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePartitionAccessStatusValues returns an array of possible values for the PartitionAccessStatus const type.
func PossiblePartitionAccessStatusValues() []PartitionAccessStatus {
	return []PartitionAccessStatus{PartitionAccessStatusGranted, PartitionAccessStatusInvalid, PartitionAccessStatusNotPrimary, PartitionAccessStatusNoWriteQuorum, PartitionAccessStatusReconfigurationPending}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeInvalid Indicates the partition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PartitionSchemeInvalid PartitionScheme = "Invalid"
	// PartitionSchemeNamed Indicates that the partition is based on string names, and is a
	// NamedPartitionSchemeDescription object. The value is 3
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemeSingleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeInvalid, PartitionSchemeNamed, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeNamed1 ...
	PartitionSchemeNamed1 PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeSingleton1 ...
	PartitionSchemeSingleton1 PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeUniformInt64Range1 ...
	PartitionSchemeUniformInt64Range1 PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeNamed1, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton1, PartitionSchemeUniformInt64Range1}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchInfoKind enumerates the values for property batch info kind.
type PropertyBatchInfoKind string

const (
	// PropertyBatchInfoKindFailed The property batch failed.
	PropertyBatchInfoKindFailed PropertyBatchInfoKind = "Failed"
	// PropertyBatchInfoKindInvalid Indicates the property batch info is invalid. All Service Fabric
	// enumerations have the invalid type.
	PropertyBatchInfoKindInvalid PropertyBatchInfoKind = "Invalid"
	// PropertyBatchInfoKindSuccessful The property batch succeeded.
	PropertyBatchInfoKindSuccessful PropertyBatchInfoKind = "Successful"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePropertyBatchInfoKindValues returns an array of possible values for the PropertyBatchInfoKind const type.
func PossiblePropertyBatchInfoKindValues() []PropertyBatchInfoKind {
	return []PropertyBatchInfoKind{PropertyBatchInfoKindFailed, PropertyBatchInfoKindInvalid, PropertyBatchInfoKindSuccessful}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchOperationKind enumerates the values for property batch operation kind.
type PropertyBatchOperationKind string

const (
	// PropertyBatchOperationKindCheckExists The operation will check that a property exists or doesn't exists,
	// depending on the provided value. The value is 3.
	PropertyBatchOperationKindCheckExists PropertyBatchOperationKind = "CheckExists"
	// PropertyBatchOperationKindCheckSequence The operation will ensure that the sequence number is equal to
	// the provided value. The value is 4.
	PropertyBatchOperationKindCheckSequence PropertyBatchOperationKind = "CheckSequence"
	// PropertyBatchOperationKindCheckValue The operation will ensure that the value of a property is equal to
	// the provided value. The value is 7.
	PropertyBatchOperationKindCheckValue PropertyBatchOperationKind = "CheckValue"
	// PropertyBatchOperationKindDelete The operation will delete a property. The value is 5.
	PropertyBatchOperationKindDelete PropertyBatchOperationKind = "Delete"
	// PropertyBatchOperationKindGet The operation will get a property. The value is 2.
	PropertyBatchOperationKindGet PropertyBatchOperationKind = "Get"
	// PropertyBatchOperationKindInvalid Indicates the property operation is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	PropertyBatchOperationKindInvalid PropertyBatchOperationKind = "Invalid"
	// PropertyBatchOperationKindPut The operation will create or edit a property. The value is 1.
	PropertyBatchOperationKindPut PropertyBatchOperationKind = "Put"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePropertyBatchOperationKindValues returns an array of possible values for the PropertyBatchOperationKind const type.
func PossiblePropertyBatchOperationKindValues() []PropertyBatchOperationKind {
	return []PropertyBatchOperationKind{PropertyBatchOperationKindCheckExists, PropertyBatchOperationKindCheckSequence, PropertyBatchOperationKindCheckValue, PropertyBatchOperationKindDelete, PropertyBatchOperationKindGet, PropertyBatchOperationKindInvalid, PropertyBatchOperationKindPut}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyValueKind enumerates the values for property value kind.
type PropertyValueKind string

const (
	// PropertyValueKindBinary The data inside the property is a binary blob. The value is 1.
	PropertyValueKindBinary PropertyValueKind = "Binary"
	// PropertyValueKindDouble The data inside the property is a double. The value is 3.
	PropertyValueKindDouble PropertyValueKind = "Double"
	// PropertyValueKindGUID The data inside the property is a guid. The value is 5.
	PropertyValueKindGUID PropertyValueKind = "Guid"
	// PropertyValueKindInt64 The data inside the property is an int64. The value is 2.
	PropertyValueKindInt64 PropertyValueKind = "Int64"
	// PropertyValueKindInvalid Indicates the property is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PropertyValueKindInvalid PropertyValueKind = "Invalid"
	// PropertyValueKindString The data inside the property is a string. The value is 4.
	PropertyValueKindString PropertyValueKind = "String"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossiblePropertyValueKindValues returns an array of possible values for the PropertyValueKind const type.
func PossiblePropertyValueKindValues() []PropertyValueKind {
	return []PropertyValueKind{PropertyValueKindBinary, PropertyValueKindDouble, PropertyValueKindGUID, PropertyValueKindInt64, PropertyValueKindInvalid, PropertyValueKindString}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ProvisionApplicationTypeKind enumerates the values for provision application type kind.
type ProvisionApplicationTypeKind string

const (
	// ProvisionApplicationTypeKindExternalStore Indicates that the provision is for an application package
	// that was previously uploaded to an external store. The application package ends with the extension
	// *.sfpkg. The value is 2.
	ProvisionApplicationTypeKindExternalStore ProvisionApplicationTypeKind = "ExternalStore"
	// ProvisionApplicationTypeKindImageStorePath Indicates that the provision is for a package that was
	// previously uploaded to the image store. The value is 1.
	ProvisionApplicationTypeKindImageStorePath ProvisionApplicationTypeKind = "ImageStorePath"
	// ProvisionApplicationTypeKindInvalid Indicates that the provision kind is invalid. This value is default
	// and should not be used. The value is zero.
	ProvisionApplicationTypeKindInvalid ProvisionApplicationTypeKind = "Invalid"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleProvisionApplicationTypeKindValues returns an array of possible values for the ProvisionApplicationTypeKind const type.
func PossibleProvisionApplicationTypeKindValues() []ProvisionApplicationTypeKind {
	return []ProvisionApplicationTypeKind{ProvisionApplicationTypeKindExternalStore, ProvisionApplicationTypeKindImageStorePath, ProvisionApplicationTypeKindInvalid}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// QuorumLossModeRequiredQueryParam enumerates the values for quorum loss mode required query param.
type QuorumLossModeRequiredQueryParam string

const (
	// QuorumLossModeRequiredQueryParamAllReplicas ...
	QuorumLossModeRequiredQueryParamAllReplicas QuorumLossModeRequiredQueryParam = "AllReplicas"
	// QuorumLossModeRequiredQueryParamInvalid Reserved.  Do not pass into API.
	QuorumLossModeRequiredQueryParamInvalid QuorumLossModeRequiredQueryParam = "Invalid"
	// QuorumLossModeRequiredQueryParamQuorumReplicas Partial Quorum loss mode : Minimum number of replicas for
	// a partition will be down that will cause a quorum loss.
	QuorumLossModeRequiredQueryParamQuorumReplicas QuorumLossModeRequiredQueryParam = "QuorumReplicas"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleQuorumLossModeRequiredQueryParamValues returns an array of possible values for the QuorumLossModeRequiredQueryParam const type.
func PossibleQuorumLossModeRequiredQueryParamValues() []QuorumLossModeRequiredQueryParam {
	return []QuorumLossModeRequiredQueryParam{QuorumLossModeRequiredQueryParamAllReplicas, QuorumLossModeRequiredQueryParamInvalid, QuorumLossModeRequiredQueryParamQuorumReplicas}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReconfigurationPhase enumerates the values for reconfiguration phase.
type ReconfigurationPhase string

const (
	// ReconfigurationPhaseAbortPhaseZero This phase is for internal use only.
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = "AbortPhaseZero"
	// ReconfigurationPhaseNone Specifies that there is no reconfiguration in progress.
	ReconfigurationPhaseNone ReconfigurationPhase = "None"
	// ReconfigurationPhasePhase0 Refers to the phase where the reconfiguration is transferring data from the
	// previous primary to the new primary.
	ReconfigurationPhasePhase0 ReconfigurationPhase = "Phase0"
	// ReconfigurationPhasePhase1 Refers to the phase where the reconfiguration is querying the replica set for
	// the progress.
	ReconfigurationPhasePhase1 ReconfigurationPhase = "Phase1"
	// ReconfigurationPhasePhase2 Refers to the phase where the reconfiguration is ensuring that data from the
	// current primary is present in a majority of the replica set.
	ReconfigurationPhasePhase2 ReconfigurationPhase = "Phase2"
	// ReconfigurationPhasePhase3 This phase is for internal use only.
	ReconfigurationPhasePhase3 ReconfigurationPhase = "Phase3"
	// ReconfigurationPhasePhase4 This phase is for internal use only.
	ReconfigurationPhasePhase4 ReconfigurationPhase = "Phase4"
	// ReconfigurationPhaseUnknown Indicates the invalid reconfiguration phase.
	ReconfigurationPhaseUnknown ReconfigurationPhase = "Unknown"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReconfigurationPhaseValues returns an array of possible values for the ReconfigurationPhase const type.
func PossibleReconfigurationPhaseValues() []ReconfigurationPhase {
	return []ReconfigurationPhase{ReconfigurationPhaseAbortPhaseZero, ReconfigurationPhaseNone, ReconfigurationPhasePhase0, ReconfigurationPhasePhase1, ReconfigurationPhasePhase2, ReconfigurationPhasePhase3, ReconfigurationPhasePhase4, ReconfigurationPhaseUnknown}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReconfigurationType enumerates the values for reconfiguration type.
type ReconfigurationType string

const (
	// ReconfigurationTypeFailover Reconfiguration triggered in response to a primary going down. This could be
	// due to many reasons such as primary replica crashing etc.
	ReconfigurationTypeFailover ReconfigurationType = "Failover"
	// ReconfigurationTypeOther Reconfigurations where the primary replica is not changing.
	ReconfigurationTypeOther ReconfigurationType = "Other"
	// ReconfigurationTypeSwapPrimary Specifies that the primary replica is being swapped with a different
	// replica.
	ReconfigurationTypeSwapPrimary ReconfigurationType = "SwapPrimary"
	// ReconfigurationTypeUnknown Indicates the invalid reconfiguration type.
	ReconfigurationTypeUnknown ReconfigurationType = "Unknown"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReconfigurationTypeValues returns an array of possible values for the ReconfigurationType const type.
func PossibleReconfigurationTypeValues() []ReconfigurationType {
	return []ReconfigurationType{ReconfigurationTypeFailover, ReconfigurationTypeOther, ReconfigurationTypeSwapPrimary, ReconfigurationTypeUnknown}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairImpactKind enumerates the values for repair impact kind.
type RepairImpactKind string

const (
	// RepairImpactKindInvalid The repair impact is not valid or is of an unknown type.
	RepairImpactKindInvalid RepairImpactKind = "Invalid"
	// RepairImpactKindNode The repair impact affects a set of Service Fabric nodes.
	RepairImpactKindNode RepairImpactKind = "Node"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleRepairImpactKindValues returns an array of possible values for the RepairImpactKind const type.
func PossibleRepairImpactKindValues() []RepairImpactKind {
	return []RepairImpactKind{RepairImpactKindInvalid, RepairImpactKindNode}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTargetKind enumerates the values for repair target kind.
type RepairTargetKind string

const (
	// RepairTargetKindInvalid The repair target is not valid or is of an unknown type.
	RepairTargetKindInvalid RepairTargetKind = "Invalid"
	// RepairTargetKindNode The repair target is a set of Service Fabric nodes.
	RepairTargetKindNode RepairTargetKind = "Node"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleRepairTargetKindValues returns an array of possible values for the RepairTargetKind const type.
func PossibleRepairTargetKindValues() []RepairTargetKind {
	return []RepairTargetKind{RepairTargetKindInvalid, RepairTargetKindNode}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskHealthCheckState enumerates the values for repair task health check state.
type RepairTaskHealthCheckState string

const (
	// InProgress Indicates that the health check is in progress.
	InProgress RepairTaskHealthCheckState = "InProgress"
	// NotStarted Indicates that the health check has not started.
	NotStarted RepairTaskHealthCheckState = "NotStarted"
	// Skipped Indicates that the health check was skipped.
	Skipped RepairTaskHealthCheckState = "Skipped"
	// Succeeded Indicates that the health check succeeded.
	Succeeded RepairTaskHealthCheckState = "Succeeded"
	// TimedOut Indicates that the health check timed out.
	TimedOut RepairTaskHealthCheckState = "TimedOut"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleRepairTaskHealthCheckStateValues returns an array of possible values for the RepairTaskHealthCheckState const type.
func PossibleRepairTaskHealthCheckStateValues() []RepairTaskHealthCheckState {
	return []RepairTaskHealthCheckState{InProgress, NotStarted, Skipped, Succeeded, TimedOut}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthReportServiceKindRequiredQueryParam enumerates the values for replica health report service
// kind required query param.
type ReplicaHealthReportServiceKindRequiredQueryParam string

const (
	// Stateful Uses Service Fabric to make its state or part of its state highly available and reliable. The
	// value is 2.
	Stateful ReplicaHealthReportServiceKindRequiredQueryParam = "Stateful"
	// Stateless Does not use Service Fabric to make its state highly available or reliable. The value is 1
	Stateless ReplicaHealthReportServiceKindRequiredQueryParam = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicaHealthReportServiceKindRequiredQueryParamValues returns an array of possible values for the ReplicaHealthReportServiceKindRequiredQueryParam const type.
func PossibleReplicaHealthReportServiceKindRequiredQueryParamValues() []ReplicaHealthReportServiceKindRequiredQueryParam {
	return []ReplicaHealthReportServiceKindRequiredQueryParam{Stateful, Stateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaKind enumerates the values for replica kind.
type ReplicaKind string

const (
	// ReplicaKindInvalid Represents an invalid replica kind. The value is zero.
	ReplicaKindInvalid ReplicaKind = "Invalid"
	// ReplicaKindKeyValueStore Represents a key value store replica. The value is 1
	ReplicaKindKeyValueStore ReplicaKind = "KeyValueStore"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicaKindValues returns an array of possible values for the ReplicaKind const type.
func PossibleReplicaKindValues() []ReplicaKind {
	return []ReplicaKind{ReplicaKindInvalid, ReplicaKindKeyValueStore}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaRole enumerates the values for replica role.
type ReplicaRole string

const (
	// ReplicaRoleActiveSecondary Refers to a replica in the set that receives state updates from the Primary
	// replica, applies them, and sends acknowledgements back. Secondary replicas must participate in the write
	// quorum for a replica set. There can be multiple active Secondary replicas in a replica set at a time.
	// The number of active Secondary replicas is configurable that the reliability subsystem should maintain.
	// The value is 4.
	ReplicaRoleActiveSecondary ReplicaRole = "ActiveSecondary"
	// ReplicaRoleIdleSecondary Refers to a replica in the set that receives a state transfer from the Primary
	// replica to prepare for becoming an active Secondary replica. There can be multiple Idle Secondary
	// replicas in a replica set at a time. Idle Secondary replicas do not count as a part of a write quorum.
	// The value is 3.
	ReplicaRoleIdleSecondary ReplicaRole = "IdleSecondary"
	// ReplicaRoleNone Specifies that the replica has no responsibility in regard to the replica set. The value
	// is 1
	ReplicaRoleNone ReplicaRole = "None"
	// ReplicaRolePrimary Refers to the replica in the set on which all read and write operations are complete
	// in order to enforce strong consistency semantics. Read operations are handled directly by the Primary
	// replica, while write operations must be acknowledged by a quorum of the replicas in the replica set.
	// There can only be one Primary replica in a replica set at a time. The value is 2.
	ReplicaRolePrimary ReplicaRole = "Primary"
	// ReplicaRoleUnknown Indicates the initial role that a replica is created in. The value is zero.
	ReplicaRoleUnknown ReplicaRole = "Unknown"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicaRoleValues returns an array of possible values for the ReplicaRole const type.
func PossibleReplicaRoleValues() []ReplicaRole {
	return []ReplicaRole{ReplicaRoleActiveSecondary, ReplicaRoleIdleSecondary, ReplicaRoleNone, ReplicaRolePrimary, ReplicaRoleUnknown}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaStatus enumerates the values for replica status.
type ReplicaStatus string

const (
	// ReplicaStatusDown ...
	ReplicaStatusDown ReplicaStatus = "Down"
	// ReplicaStatusDropped ...
	ReplicaStatusDropped ReplicaStatus = "Dropped"
	// ReplicaStatusInBuild ...
	ReplicaStatusInBuild ReplicaStatus = "InBuild"
	// ReplicaStatusInvalid ...
	ReplicaStatusInvalid ReplicaStatus = "Invalid"
	// ReplicaStatusReady ...
	ReplicaStatusReady ReplicaStatus = "Ready"
	// ReplicaStatusStandby ...
	ReplicaStatusStandby ReplicaStatus = "Standby"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicaStatusValues returns an array of possible values for the ReplicaStatus const type.
func PossibleReplicaStatusValues() []ReplicaStatus {
	return []ReplicaStatus{ReplicaStatusDown, ReplicaStatusDropped, ReplicaStatusInBuild, ReplicaStatusInvalid, ReplicaStatusReady, ReplicaStatusStandby}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaStatus1 enumerates the values for replica status 1.
type ReplicaStatus1 string

const (
	// ReplicaStatus1Down ...
	ReplicaStatus1Down ReplicaStatus1 = "Down"
	// ReplicaStatus1Dropped ...
	ReplicaStatus1Dropped ReplicaStatus1 = "Dropped"
	// ReplicaStatus1InBuild ...
	ReplicaStatus1InBuild ReplicaStatus1 = "InBuild"
	// ReplicaStatus1Invalid ...
	ReplicaStatus1Invalid ReplicaStatus1 = "Invalid"
	// ReplicaStatus1Ready ...
	ReplicaStatus1Ready ReplicaStatus1 = "Ready"
	// ReplicaStatus1Standby ...
	ReplicaStatus1Standby ReplicaStatus1 = "Standby"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicaStatus1Values returns an array of possible values for the ReplicaStatus1 const type.
func PossibleReplicaStatus1Values() []ReplicaStatus1 {
	return []ReplicaStatus1{ReplicaStatus1Down, ReplicaStatus1Dropped, ReplicaStatus1InBuild, ReplicaStatus1Invalid, ReplicaStatus1Ready, ReplicaStatus1Standby}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicatorOperationName enumerates the values for replicator operation name.
type ReplicatorOperationName string

const (
	// ReplicatorOperationNameAbort Replicator is being aborted.
	ReplicatorOperationNameAbort ReplicatorOperationName = "Abort"
	// ReplicatorOperationNameBuild Replicator is in the process of building one or more replicas.
	ReplicatorOperationNameBuild ReplicatorOperationName = "Build"
	// ReplicatorOperationNameChangeRole Replicator is in the process of changing its role.
	ReplicatorOperationNameChangeRole ReplicatorOperationName = "ChangeRole"
	// ReplicatorOperationNameClose Replicator is closing.
	ReplicatorOperationNameClose ReplicatorOperationName = "Close"
	// ReplicatorOperationNameInvalid Default value if the replicator is not yet ready.
	ReplicatorOperationNameInvalid ReplicatorOperationName = "Invalid"
	// ReplicatorOperationNameNone Replicator is not running any operation from Service Fabric perspective.
	ReplicatorOperationNameNone ReplicatorOperationName = "None"
	// ReplicatorOperationNameOnDataLoss Replicator is handling the data loss condition, where the user service
	// may potentially be recovering state from an external source.
	ReplicatorOperationNameOnDataLoss ReplicatorOperationName = "OnDataLoss"
	// ReplicatorOperationNameOpen Replicator is opening.
	ReplicatorOperationNameOpen ReplicatorOperationName = "Open"
	// ReplicatorOperationNameUpdateEpoch Due to a change in the replica set, replicator is being updated with
	// its Epoch.
	ReplicatorOperationNameUpdateEpoch ReplicatorOperationName = "UpdateEpoch"
	// ReplicatorOperationNameWaitForCatchup Replicator is waiting for a quorum of replicas to be caught up to
	// the latest state.
	ReplicatorOperationNameWaitForCatchup ReplicatorOperationName = "WaitForCatchup"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleReplicatorOperationNameValues returns an array of possible values for the ReplicatorOperationName const type.
func PossibleReplicatorOperationNameValues() []ReplicatorOperationName {
	return []ReplicatorOperationName{ReplicatorOperationNameAbort, ReplicatorOperationNameBuild, ReplicatorOperationNameChangeRole, ReplicatorOperationNameClose, ReplicatorOperationNameInvalid, ReplicatorOperationNameNone, ReplicatorOperationNameOnDataLoss, ReplicatorOperationNameOpen, ReplicatorOperationNameUpdateEpoch, ReplicatorOperationNameWaitForCatchup}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RestartPartitionModeRequiredQueryParam enumerates the values for restart partition mode required query
// param.
type RestartPartitionModeRequiredQueryParam string

const (
	// RestartPartitionModeRequiredQueryParamAllReplicasOrInstances All replicas or instances in the partition
	// are restarted at once.
	RestartPartitionModeRequiredQueryParamAllReplicasOrInstances RestartPartitionModeRequiredQueryParam = "AllReplicasOrInstances"
	// RestartPartitionModeRequiredQueryParamInvalid Reserved.  Do not pass into API.
	RestartPartitionModeRequiredQueryParamInvalid RestartPartitionModeRequiredQueryParam = "Invalid"
	// RestartPartitionModeRequiredQueryParamOnlyActiveSecondaries Only the secondary replicas are restarted.
	RestartPartitionModeRequiredQueryParamOnlyActiveSecondaries RestartPartitionModeRequiredQueryParam = "OnlyActiveSecondaries"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleRestartPartitionModeRequiredQueryParamValues returns an array of possible values for the RestartPartitionModeRequiredQueryParam const type.
func PossibleRestartPartitionModeRequiredQueryParamValues() []RestartPartitionModeRequiredQueryParam {
	return []RestartPartitionModeRequiredQueryParam{RestartPartitionModeRequiredQueryParamAllReplicasOrInstances, RestartPartitionModeRequiredQueryParamInvalid, RestartPartitionModeRequiredQueryParamOnlyActiveSecondaries}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ResultStatus enumerates the values for result status.
type ResultStatus string

const (
	// ResultStatusCancelled Indicates that the repair task was cancelled prior to execution.
	ResultStatusCancelled ResultStatus = "Cancelled"
	// ResultStatusFailed Indicates that there was a failure during execution of the repair task. Some work may
	// have been performed.
	ResultStatusFailed ResultStatus = "Failed"
	// ResultStatusInterrupted Indicates that execution of the repair task was interrupted by a cancellation
	// request after some work had already been performed.
	ResultStatusInterrupted ResultStatus = "Interrupted"
	// ResultStatusInvalid Indicates that the repair task result is invalid. All Service Fabric enumerations
	// have the invalid value.
	ResultStatusInvalid ResultStatus = "Invalid"
	// ResultStatusPending Indicates that the repair task result is not yet available, because the repair task
	// has not finished executing.
	ResultStatusPending ResultStatus = "Pending"
	// ResultStatusSucceeded Indicates that the repair task completed execution successfully.
	ResultStatusSucceeded ResultStatus = "Succeeded"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleResultStatusValues returns an array of possible values for the ResultStatus const type.
func PossibleResultStatusValues() []ResultStatus {
	return []ResultStatus{ResultStatusCancelled, ResultStatusFailed, ResultStatusInterrupted, ResultStatusInvalid, ResultStatusPending, ResultStatusSucceeded}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SafetyCheckKind enumerates the values for safety check kind.
type SafetyCheckKind string

const (
	// SafetyCheckKindEnsureAvailability Indicates that there is either a stateless service partition on the
	// node having exactly one instance, or there is a primary replica on the node for which the partition is
	// quorum loss. In both cases, bringing down the replicas due to upgrade will result in loss of
	// availability. The value is 7.
	SafetyCheckKindEnsureAvailability SafetyCheckKind = "EnsureAvailability"
	// SafetyCheckKindEnsurePartitionQuorum Indicates that there is some partition for which if we bring down
	// the replica on the node, it will result in quorum loss for that partition. The value is 2.
	SafetyCheckKindEnsurePartitionQuorum SafetyCheckKind = "EnsurePartitionQuorum"
	// SafetyCheckKindEnsureSeedNodeQuorum Indicates that if we bring down the node then this will result in
	// global seed node quorum loss. The value is 1.
	SafetyCheckKindEnsureSeedNodeQuorum SafetyCheckKind = "EnsureSeedNodeQuorum"
	// SafetyCheckKindInvalid Indicates that the upgrade safety check kind is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	SafetyCheckKindInvalid SafetyCheckKind = "Invalid"
	// SafetyCheckKindWaitForInbuildReplica Indicates that there is either a replica on the node that is going
	// through copy, or there is a primary replica on the node that is copying data to some other replica. In
	// both cases, bringing down the replica on the node due to upgrade will abort the copy. The value is 6.
	SafetyCheckKindWaitForInbuildReplica SafetyCheckKind = "WaitForInbuildReplica"
	// SafetyCheckKindWaitForPrimaryPlacement Indicates that there is some replica on the node that was moved
	// out of this node due to upgrade. Service Fabric is now waiting for the primary to be moved back to this
	// node. The value is 3.
	SafetyCheckKindWaitForPrimaryPlacement SafetyCheckKind = "WaitForPrimaryPlacement"
	// SafetyCheckKindWaitForPrimarySwap Indicates that Service Fabric is waiting for a primary replica to be
	// moved out of the node before starting upgrade on that node. The value is 4.
	SafetyCheckKindWaitForPrimarySwap SafetyCheckKind = "WaitForPrimarySwap"
	// SafetyCheckKindWaitForReconfiguration Indicates that there is some replica on the node that is involved
	// in a reconfiguration. Service Fabric is waiting for the reconfiguration to be complete before staring
	// upgrade on that node. The value is 5.
	SafetyCheckKindWaitForReconfiguration SafetyCheckKind = "WaitForReconfiguration"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleSafetyCheckKindValues returns an array of possible values for the SafetyCheckKind const type.
func PossibleSafetyCheckKindValues() []SafetyCheckKind {
	return []SafetyCheckKind{SafetyCheckKindEnsureAvailability, SafetyCheckKindEnsurePartitionQuorum, SafetyCheckKindEnsureSeedNodeQuorum, SafetyCheckKindInvalid, SafetyCheckKindWaitForInbuildReplica, SafetyCheckKindWaitForPrimaryPlacement, SafetyCheckKindWaitForPrimarySwap, SafetyCheckKindWaitForReconfiguration}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceEndpointRole enumerates the values for service endpoint role.
type ServiceEndpointRole string

const (
	// ServiceEndpointRoleInvalid Indicates the service endpoint role is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceEndpointRoleInvalid ServiceEndpointRole = "Invalid"
	// ServiceEndpointRoleStatefulPrimary Indicates that the service endpoint is of a primary replica of a
	// stateful service. The value is 2.
	ServiceEndpointRoleStatefulPrimary ServiceEndpointRole = "StatefulPrimary"
	// ServiceEndpointRoleStatefulSecondary Indicates that the service endpoint is of a secondary replica of a
	// stateful service. The value is 3.
	ServiceEndpointRoleStatefulSecondary ServiceEndpointRole = "StatefulSecondary"
	// ServiceEndpointRoleStateless Indicates that the service endpoint is of a stateless service. The value is
	// 1.
	ServiceEndpointRoleStateless ServiceEndpointRole = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceEndpointRoleValues returns an array of possible values for the ServiceEndpointRole const type.
func PossibleServiceEndpointRoleValues() []ServiceEndpointRole {
	return []ServiceEndpointRole{ServiceEndpointRoleInvalid, ServiceEndpointRoleStatefulPrimary, ServiceEndpointRoleStatefulSecondary, ServiceEndpointRoleStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicDeployedServiceReplicaDetailInfo enumerates the values for service kind basic deployed
// service replica detail info.
type ServiceKindBasicDeployedServiceReplicaDetailInfo string

const (
	// ServiceKindDeployedServiceReplicaDetailInfo ...
	ServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = "DeployedServiceReplicaDetailInfo"
	// ServiceKindStateful1 ...
	ServiceKindStateful1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateful"
	// ServiceKindStateless1 ...
	ServiceKindStateless1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaDetailInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues() []ServiceKindBasicDeployedServiceReplicaDetailInfo {
	return []ServiceKindBasicDeployedServiceReplicaDetailInfo{ServiceKindDeployedServiceReplicaDetailInfo, ServiceKindStateful1, ServiceKindStateless1}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicDeployedServiceReplicaInfo enumerates the values for service kind basic deployed service
// replica info.
type ServiceKindBasicDeployedServiceReplicaInfo string

const (
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ServiceKindBasicDeployedServiceReplicaInfo = "DeployedServiceReplicaInfo"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ServiceKindBasicDeployedServiceReplicaInfo = "Stateful"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ServiceKindBasicDeployedServiceReplicaInfo = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicDeployedServiceReplicaInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaInfoValues() []ServiceKindBasicDeployedServiceReplicaInfo {
	return []ServiceKindBasicDeployedServiceReplicaInfo{ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicReplicaHealth enumerates the values for service kind basic replica health.
type ServiceKindBasicReplicaHealth string

const (
	// ServiceKindBasicReplicaHealthServiceKindReplicaHealth ...
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = "ReplicaHealth"
	// ServiceKindBasicReplicaHealthServiceKindStateful ...
	ServiceKindBasicReplicaHealthServiceKindStateful ServiceKindBasicReplicaHealth = "Stateful"
	// ServiceKindBasicReplicaHealthServiceKindStateless ...
	ServiceKindBasicReplicaHealthServiceKindStateless ServiceKindBasicReplicaHealth = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicReplicaHealthValues returns an array of possible values for the ServiceKindBasicReplicaHealth const type.
func PossibleServiceKindBasicReplicaHealthValues() []ServiceKindBasicReplicaHealth {
	return []ServiceKindBasicReplicaHealth{ServiceKindBasicReplicaHealthServiceKindReplicaHealth, ServiceKindBasicReplicaHealthServiceKindStateful, ServiceKindBasicReplicaHealthServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicReplicaHealthState enumerates the values for service kind basic replica health state.
type ServiceKindBasicReplicaHealthState string

const (
	// ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ...
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = "ReplicaHealthState"
	// ServiceKindBasicReplicaHealthStateServiceKindStateful ...
	ServiceKindBasicReplicaHealthStateServiceKindStateful ServiceKindBasicReplicaHealthState = "Stateful"
	// ServiceKindBasicReplicaHealthStateServiceKindStateless ...
	ServiceKindBasicReplicaHealthStateServiceKindStateless ServiceKindBasicReplicaHealthState = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicReplicaHealthStateValues returns an array of possible values for the ServiceKindBasicReplicaHealthState const type.
func PossibleServiceKindBasicReplicaHealthStateValues() []ServiceKindBasicReplicaHealthState {
	return []ServiceKindBasicReplicaHealthState{ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState, ServiceKindBasicReplicaHealthStateServiceKindStateful, ServiceKindBasicReplicaHealthStateServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicReplicaInfo enumerates the values for service kind basic replica info.
type ServiceKindBasicReplicaInfo string

const (
	// ServiceKindBasicReplicaInfoServiceKindReplicaInfo ...
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = "ReplicaInfo"
	// ServiceKindBasicReplicaInfoServiceKindStateful ...
	ServiceKindBasicReplicaInfoServiceKindStateful ServiceKindBasicReplicaInfo = "Stateful"
	// ServiceKindBasicReplicaInfoServiceKindStateless ...
	ServiceKindBasicReplicaInfoServiceKindStateless ServiceKindBasicReplicaInfo = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicReplicaInfoValues returns an array of possible values for the ServiceKindBasicReplicaInfo const type.
func PossibleServiceKindBasicReplicaInfoValues() []ServiceKindBasicReplicaInfo {
	return []ServiceKindBasicReplicaInfo{ServiceKindBasicReplicaInfoServiceKindReplicaInfo, ServiceKindBasicReplicaInfoServiceKindStateful, ServiceKindBasicReplicaInfoServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicServiceDescription enumerates the values for service kind basic service description.
type ServiceKindBasicServiceDescription string

const (
	// ServiceKindBasicServiceDescriptionServiceKindServiceDescription ...
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = "ServiceDescription"
	// ServiceKindBasicServiceDescriptionServiceKindStateful ...
	ServiceKindBasicServiceDescriptionServiceKindStateful ServiceKindBasicServiceDescription = "Stateful"
	// ServiceKindBasicServiceDescriptionServiceKindStateless ...
	ServiceKindBasicServiceDescriptionServiceKindStateless ServiceKindBasicServiceDescription = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicServiceDescriptionValues returns an array of possible values for the ServiceKindBasicServiceDescription const type.
func PossibleServiceKindBasicServiceDescriptionValues() []ServiceKindBasicServiceDescription {
	return []ServiceKindBasicServiceDescription{ServiceKindBasicServiceDescriptionServiceKindServiceDescription, ServiceKindBasicServiceDescriptionServiceKindStateful, ServiceKindBasicServiceDescriptionServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicServiceInfo enumerates the values for service kind basic service info.
type ServiceKindBasicServiceInfo string

const (
	// ServiceKindBasicServiceInfoServiceKindServiceInfo ...
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = "ServiceInfo"
	// ServiceKindBasicServiceInfoServiceKindStateful ...
	ServiceKindBasicServiceInfoServiceKindStateful ServiceKindBasicServiceInfo = "Stateful"
	// ServiceKindBasicServiceInfoServiceKindStateless ...
	ServiceKindBasicServiceInfoServiceKindStateless ServiceKindBasicServiceInfo = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicServiceInfoValues returns an array of possible values for the ServiceKindBasicServiceInfo const type.
func PossibleServiceKindBasicServiceInfoValues() []ServiceKindBasicServiceInfo {
	return []ServiceKindBasicServiceInfo{ServiceKindBasicServiceInfoServiceKindServiceInfo, ServiceKindBasicServiceInfoServiceKindStateful, ServiceKindBasicServiceInfoServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicServicePartitionInfo enumerates the values for service kind basic service partition info.
type ServiceKindBasicServicePartitionInfo string

const (
	// ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ...
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = "ServicePartitionInfo"
	// ServiceKindBasicServicePartitionInfoServiceKindStateful ...
	ServiceKindBasicServicePartitionInfoServiceKindStateful ServiceKindBasicServicePartitionInfo = "Stateful"
	// ServiceKindBasicServicePartitionInfoServiceKindStateless ...
	ServiceKindBasicServicePartitionInfoServiceKindStateless ServiceKindBasicServicePartitionInfo = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicServicePartitionInfoValues returns an array of possible values for the ServiceKindBasicServicePartitionInfo const type.
func PossibleServiceKindBasicServicePartitionInfoValues() []ServiceKindBasicServicePartitionInfo {
	return []ServiceKindBasicServicePartitionInfo{ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo, ServiceKindBasicServicePartitionInfoServiceKindStateful, ServiceKindBasicServicePartitionInfoServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceKindBasicServiceUpdateDescription enumerates the values for service kind basic service update
// description.
type ServiceKindBasicServiceUpdateDescription string

const (
	// ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = "ServiceUpdateDescription"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ServiceKindBasicServiceUpdateDescription = "Stateful"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ServiceKindBasicServiceUpdateDescription = "Stateless"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceKindBasicServiceUpdateDescriptionValues returns an array of possible values for the ServiceKindBasicServiceUpdateDescription const type.
func PossibleServiceKindBasicServiceUpdateDescriptionValues() []ServiceKindBasicServiceUpdateDescription {
	return []ServiceKindBasicServiceUpdateDescription{ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription, ServiceKindBasicServiceUpdateDescriptionServiceKindStateful, ServiceKindBasicServiceUpdateDescriptionServiceKindStateless}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceOperationName enumerates the values for service operation name.
type ServiceOperationName string

const (
	// ServiceOperationNameAbort The service replica or instance is being aborted.
	ServiceOperationNameAbort ServiceOperationName = "Abort"
	// ServiceOperationNameChangeRole The service replica is changing roles.
	ServiceOperationNameChangeRole ServiceOperationName = "ChangeRole"
	// ServiceOperationNameClose The service replica or instance is being closed.
	ServiceOperationNameClose ServiceOperationName = "Close"
	// ServiceOperationNameNone The service replica or instance is not going through any life-cycle changes.
	ServiceOperationNameNone ServiceOperationName = "None"
	// ServiceOperationNameOpen The service replica or instance is being opened.
	ServiceOperationNameOpen ServiceOperationName = "Open"
	// ServiceOperationNameUnknown Reserved for future use.
	ServiceOperationNameUnknown ServiceOperationName = "Unknown"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceOperationNameValues returns an array of possible values for the ServiceOperationName const type.
func PossibleServiceOperationNameValues() []ServiceOperationName {
	return []ServiceOperationName{ServiceOperationNameAbort, ServiceOperationNameChangeRole, ServiceOperationNameClose, ServiceOperationNameNone, ServiceOperationNameOpen, ServiceOperationNameUnknown}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePackageActivationMode enumerates the values for service package activation mode.
type ServicePackageActivationMode string

const (
	// ExclusiveProcess With this activation mode, each replica or instance of service, on a given node, will
	// have its own dedicated activation of service package on a node. The value is 1.
	ExclusiveProcess ServicePackageActivationMode = "ExclusiveProcess"
	// SharedProcess This is the default activation mode. With this activation mode, replicas or instances from
	// different partition(s) of service, on a given node, will share same activation of service package on a
	// node. The value is zero.
	SharedProcess ServicePackageActivationMode = "SharedProcess"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServicePackageActivationModeValues returns an array of possible values for the ServicePackageActivationMode const type.
func PossibleServicePackageActivationModeValues() []ServicePackageActivationMode {
	return []ServicePackageActivationMode{ExclusiveProcess, SharedProcess}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePartitionKind enumerates the values for service partition kind.
type ServicePartitionKind string

const (
	// ServicePartitionKindInt64Range ...
	ServicePartitionKindInt64Range ServicePartitionKind = "Int64Range"
	// ServicePartitionKindNamed ...
	ServicePartitionKindNamed ServicePartitionKind = "Named"
	// ServicePartitionKindPartitionInformation ...
	ServicePartitionKindPartitionInformation ServicePartitionKind = "PartitionInformation"
	// ServicePartitionKindSingleton ...
	ServicePartitionKindSingleton ServicePartitionKind = "Singleton"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServicePartitionKindValues returns an array of possible values for the ServicePartitionKind const type.
func PossibleServicePartitionKindValues() []ServicePartitionKind {
	return []ServicePartitionKind{ServicePartitionKindInt64Range, ServicePartitionKindNamed, ServicePartitionKindPartitionInformation, ServicePartitionKindSingleton}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePartitionStatus enumerates the values for service partition status.
type ServicePartitionStatus string

const (
	// ServicePartitionStatusDeleting Indicates that the partition is being deleted. The value is 5.
	ServicePartitionStatusDeleting ServicePartitionStatus = "Deleting"
	// ServicePartitionStatusInQuorumLoss Indicates that the partition is in quorum loss. This means that
	// number of replicas that are up and participating in a replica set is less than MinReplicaSetSize for
	// this partition. The value is 3.
	ServicePartitionStatusInQuorumLoss ServicePartitionStatus = "InQuorumLoss"
	// ServicePartitionStatusInvalid Indicates the partition status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionStatusInvalid ServicePartitionStatus = "Invalid"
	// ServicePartitionStatusNotReady Indicates that the partition is not ready. This status is returned when
	// none of the other states apply. The value is 2.
	ServicePartitionStatusNotReady ServicePartitionStatus = "NotReady"
	// ServicePartitionStatusReady Indicates that the partition is ready. This means that for a stateless
	// service partition there is at least one instance that is up and for a stateful service partition the
	// number of ready replicas is greater than or equal to the MinReplicaSetSize. The value is 1.
	ServicePartitionStatusReady ServicePartitionStatus = "Ready"
	// ServicePartitionStatusReconfiguring Indicates that the partition is undergoing reconfiguration of its
	// replica sets. This can happen due to failover, upgrade, load balancing or addition or removal of
	// replicas from the replica set. The value is 4.
	ServicePartitionStatusReconfiguring ServicePartitionStatus = "Reconfiguring"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServicePartitionStatusValues returns an array of possible values for the ServicePartitionStatus const type.
func PossibleServicePartitionStatusValues() []ServicePartitionStatus {
	return []ServicePartitionStatus{ServicePartitionStatusDeleting, ServicePartitionStatusInQuorumLoss, ServicePartitionStatusInvalid, ServicePartitionStatusNotReady, ServicePartitionStatusReady, ServicePartitionStatusReconfiguring}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferredPrimaryDomain Indicates that the ServicePlacementPolicyDescription is
	// of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
	// Primary replica for the partitions of the service should be located in a particular domain as an
	// optimization. The value is 3.
	ServicePlacementPolicyTypePreferredPrimaryDomain ServicePlacementPolicyType = "PreferredPrimaryDomain"
	// ServicePlacementPolicyTypeRequiredDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequiredDomain ServicePlacementPolicyType = "RequiredDomain"
	// ServicePlacementPolicyTypeRequiredDomainDistribution Indicates that the
	// ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription,
	// indicating that the system will disallow placement of any two replicas from the same partition in the
	// same domain at any time. The value is 4.
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = "RequiredDomainDistribution"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferredPrimaryDomain, ServicePlacementPolicyTypeRequiredDomain, ServicePlacementPolicyTypeRequiredDomainDistribution}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceStatus enumerates the values for service status.
type ServiceStatus string

const (
	// ServiceStatusActive Indicates the service status is active. The value is 1.
	ServiceStatusActive ServiceStatus = "Active"
	// ServiceStatusCreating Indicates the service is being created. The value is 4.
	ServiceStatusCreating ServiceStatus = "Creating"
	// ServiceStatusDeleting Indicates the service is being deleted. The value is 3.
	ServiceStatusDeleting ServiceStatus = "Deleting"
	// ServiceStatusFailed Indicates creation or deletion was terminated due to persistent failures. Another
	// create/delete request can be accepted. The value is 5.
	ServiceStatusFailed ServiceStatus = "Failed"
	// ServiceStatusUnknown Indicates the service status is unknown. The value is zero.
	ServiceStatusUnknown ServiceStatus = "Unknown"
	// ServiceStatusUpgrading Indicates the service is upgrading. The value is 2.
	ServiceStatusUpgrading ServiceStatus = "Upgrading"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceStatusValues returns an array of possible values for the ServiceStatus const type.
func PossibleServiceStatusValues() []ServiceStatus {
	return []ServiceStatus{ServiceStatusActive, ServiceStatusCreating, ServiceStatusDeleting, ServiceStatusFailed, ServiceStatusUnknown, ServiceStatusUpgrading}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeRegistrationStatus enumerates the values for service type registration status.
type ServiceTypeRegistrationStatus string

const (
	// ServiceTypeRegistrationStatusDisabled Indicates that the service type is disabled on this node. A type
	// gets disabled when there are too many failures of the code package hosting the service type. If the
	// service type is disabled, new replicas of that service type will not be placed on the node until it is
	// enabled again. The service type is enabled again after the process hosting it comes up and re-registers
	// the type or a preconfigured time interval has passed. The value is 1.
	ServiceTypeRegistrationStatusDisabled ServiceTypeRegistrationStatus = "Disabled"
	// ServiceTypeRegistrationStatusEnabled Indicates that the service type is enabled on this node. Replicas
	// of this service type can be placed on this node when the code package registers the service type. The
	// value is 2.
	ServiceTypeRegistrationStatusEnabled ServiceTypeRegistrationStatus = "Enabled"
	// ServiceTypeRegistrationStatusInvalid Indicates the registration status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceTypeRegistrationStatusInvalid ServiceTypeRegistrationStatus = "Invalid"
	// ServiceTypeRegistrationStatusRegistered Indicates that the service type is enabled and registered on the
	// node by a code package. Replicas of this service type can now be placed on this node. The value is 3.
	ServiceTypeRegistrationStatusRegistered ServiceTypeRegistrationStatus = "Registered"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleServiceTypeRegistrationStatusValues returns an array of possible values for the ServiceTypeRegistrationStatus const type.
func PossibleServiceTypeRegistrationStatusValues() []ServiceTypeRegistrationStatus {
	return []ServiceTypeRegistrationStatus{ServiceTypeRegistrationStatusDisabled, ServiceTypeRegistrationStatusEnabled, ServiceTypeRegistrationStatusInvalid, ServiceTypeRegistrationStatusRegistered}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// State enumerates the values for state.
type State string

const (
	// StateApproved Indicates that the repair task has been approved by the Repair Manager and is safe to
	// execute.
	StateApproved State = "Approved"
	// StateClaimed Indicates that the repair task has been claimed by a repair executor.
	StateClaimed State = "Claimed"
	// StateCompleted Indicates that the repair task has completed, and no further state changes will occur.
	StateCompleted State = "Completed"
	// StateCreated Indicates that the repair task has been created.
	StateCreated State = "Created"
	// StateExecuting Indicates that execution of the repair task is in progress.
	StateExecuting State = "Executing"
	// StateInvalid Indicates that the repair task state is invalid. All Service Fabric enumerations have the
	// invalid value.
	StateInvalid State = "Invalid"
	// StatePreparing Indicates that the Repair Manager is preparing the system to handle the impact of the
	// repair task, usually by taking resources offline gracefully.
	StatePreparing State = "Preparing"
	// StateRestoring Indicates that the Repair Manager is restoring the system to its pre-repair state,
	// usually by bringing resources back online.
	StateRestoring State = "Restoring"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateApproved, StateClaimed, StateCompleted, StateCreated, StateExecuting, StateInvalid, StatePreparing, StateRestoring}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Status enumerates the values for status.
type Status string

const (
	// StatusInvalid Indicates an invalid Chaos status. All Service Fabric enumerations have the invalid type.
	StatusInvalid Status = "Invalid"
	// StatusRunning Indicates that Chaos is not stopped.
	StatusRunning Status = "Running"
	// StatusStopped Indicates that Chaos is not scheduling further faults.
	StatusStopped Status = "Stopped"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusInvalid, StatusRunning, StatusStopped}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Type enumerates the values for type.
type Type string

const (
	// TypeInvalidDomain ...
	TypeInvalidDomain Type = "InvalidDomain"
	// TypeNonPartiallyPlaceService ...
	TypeNonPartiallyPlaceService Type = "NonPartiallyPlaceService"
	// TypePreferPrimaryDomain ...
	TypePreferPrimaryDomain Type = "PreferPrimaryDomain"
	// TypeRequireDomain ...
	TypeRequireDomain Type = "RequireDomain"
	// TypeRequireDomainDistribution ...
	TypeRequireDomainDistribution Type = "RequireDomainDistribution"
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeInvalidDomain, TypeNonPartiallyPlaceService, TypePreferPrimaryDomain, TypeRequireDomain, TypeRequireDomainDistribution, TypeServicePlacementPolicyDescription}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UpgradeDomainState enumerates the values for upgrade domain state.
type UpgradeDomainState string

const (
	// UpgradeDomainStateCompleted The upgrade domain has completed upgrade. The value is 3
	UpgradeDomainStateCompleted UpgradeDomainState = "Completed"
	// UpgradeDomainStateInProgress The upgrade domain is being upgraded but not complete yet. The value is 2
	UpgradeDomainStateInProgress UpgradeDomainState = "InProgress"
	// UpgradeDomainStateInvalid Indicates the upgrade domain state is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	UpgradeDomainStateInvalid UpgradeDomainState = "Invalid"
	// UpgradeDomainStatePending The upgrade domain has not started upgrading yet. The value is 1
	UpgradeDomainStatePending UpgradeDomainState = "Pending"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleUpgradeDomainStateValues returns an array of possible values for the UpgradeDomainState const type.
func PossibleUpgradeDomainStateValues() []UpgradeDomainState {
	return []UpgradeDomainState{UpgradeDomainStateCompleted, UpgradeDomainStateInProgress, UpgradeDomainStateInvalid, UpgradeDomainStatePending}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UpgradeKind enumerates the values for upgrade kind.
type UpgradeKind string

const (
	// UpgradeKindInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeKindInvalid UpgradeKind = "Invalid"
	// UpgradeKindRolling The upgrade progresses one upgrade domain at a time. The value is 1
	UpgradeKindRolling UpgradeKind = "Rolling"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleUpgradeKindValues returns an array of possible values for the UpgradeKind const type.
func PossibleUpgradeKindValues() []UpgradeKind {
	return []UpgradeKind{UpgradeKindInvalid, UpgradeKindRolling}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeInvalid Indicates the upgrade mode is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeModeInvalid UpgradeMode = "Invalid"
	// UpgradeModeMonitored The upgrade will stop after completing each upgrade domain and automatically
	// monitor health before proceeding. The value is 3
	UpgradeModeMonitored UpgradeMode = "Monitored"
	// UpgradeModeUnmonitoredAuto The upgrade will proceed automatically without performing any health
	// monitoring. The value is 1
	UpgradeModeUnmonitoredAuto UpgradeMode = "UnmonitoredAuto"
	// UpgradeModeUnmonitoredManual The upgrade will stop after completing each upgrade domain, giving the
	// opportunity to manually monitor health before proceeding. The value is 2
	UpgradeModeUnmonitoredManual UpgradeMode = "UnmonitoredManual"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeInvalid, UpgradeModeMonitored, UpgradeModeUnmonitoredAuto, UpgradeModeUnmonitoredManual}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The value is 6
	UpgradeStateFailed UpgradeState = "Failed"
	// UpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeStateInvalid UpgradeState = "Invalid"
	// UpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 2
	UpgradeStateRollingBackCompleted UpgradeState = "RollingBackCompleted"
	// UpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version but is not
	// complete yet. The value is 1
	UpgradeStateRollingBackInProgress UpgradeState = "RollingBackInProgress"
	// UpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value is 5
	UpgradeStateRollingForwardCompleted UpgradeState = "RollingForwardCompleted"
	// UpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target version but is not
	// complete yet. The value is 4
	UpgradeStateRollingForwardInProgress UpgradeState = "RollingForwardInProgress"
	// UpgradeStateRollingForwardPending The current upgrade domain has finished upgrading. The overall upgrade
	// is waiting for an explicit move next request in UnmonitoredManual mode or performing health checks in
	// Monitored mode. The value is 3
	UpgradeStateRollingForwardPending UpgradeState = "RollingForwardPending"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateFailed, UpgradeStateInvalid, UpgradeStateRollingBackCompleted, UpgradeStateRollingBackInProgress, UpgradeStateRollingForwardCompleted, UpgradeStateRollingForwardInProgress, UpgradeStateRollingForwardPending}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UpgradeType enumerates the values for upgrade type.
type UpgradeType string

const (
	// UpgradeTypeInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeTypeInvalid UpgradeType = "Invalid"
	// UpgradeTypeRolling The upgrade progresses one upgrade domain at a time. The value is 1.
	UpgradeTypeRolling UpgradeType = "Rolling"
	// UpgradeTypeRollingForceRestart The upgrade gets restarted by force. The value is 2.
	UpgradeTypeRollingForceRestart UpgradeType = "Rolling_ForceRestart"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PossibleUpgradeTypeValues returns an array of possible values for the UpgradeType const type.
func PossibleUpgradeTypeValues() []UpgradeType {
	return []UpgradeType{UpgradeTypeInvalid, UpgradeTypeRolling, UpgradeTypeRollingForceRestart}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AadMetadata azure Active Directory metadata used for secured connection to cluster.
type AadMetadata struct {
	// Authority - The AAD authority url.
	Authority *string `json:"authority,omitempty"`
	// Client - The AAD client application Id.
	Client *string `json:"client,omitempty"`
	// Cluster - The AAD cluster application Id.
	Cluster *string `json:"cluster,omitempty"`
	// Login - The AAD login url.
	Login *string `json:"login,omitempty"`
	// Redirect - The client application redirect address.
	Redirect *string `json:"redirect,omitempty"`
	// Tenant - The AAD tenant Id.
	Tenant *string `json:"tenant,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AadMetadataObject azure Active Directory metadata object used for secured connection to cluster.
type AadMetadataObject struct {
	autorest.Response `json:"-"`
	// Type - The client authentication method.
	Type *string `json:"type,omitempty"`
	// Metadata - Azure Active Directory metadata used for secured connection to cluster.
	Metadata *AadMetadata `json:"metadata,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationCapacityDescription describes capacity information for services of this application. This description
// can be used for describing the following.
// - Reserving the capacity for the services on the nodes
// - Limiting the total number of nodes that services of this application can run on
// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of this
// application
type ApplicationCapacityDescription struct {
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// ApplicationMetrics - List of application capacity metric description.
	ApplicationMetrics *[]ApplicationMetricDescription `json:"ApplicationMetrics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationDescription describes a Service Fabric application.
type ApplicationDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// ParameterList - List of application parameters with overridden values from their default values specified in the application manifest.
	ParameterList *[]ApplicationParameter `json:"ParameterList,omitempty"`
	// ApplicationCapacity - Describes capacity information for services of this application. This description can be used for describing the following.
	// - Reserving the capacity for the services on the nodes
	// - Limiting the total number of nodes that services of this application can run on
	// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of this application
	ApplicationCapacity *ApplicationCapacityDescription `json:"ApplicationCapacity,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealth represents the health of the application. Contains the application aggregated health state and
// the service and deployed application health states.
type ApplicationHealth struct {
	autorest.Response `json:"-"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// ServiceHealthStates - Service health states as found in the health store.
	ServiceHealthStates *[]ServiceHealthState `json:"ServiceHealthStates,omitempty"`
	// DeployedApplicationHealthStates - Deployed application health states as found in the health store.
	DeployedApplicationHealthStates *[]DeployedApplicationHealthState `json:"DeployedApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthEvaluation represents health evaluation for an application, containing information about the
// data and the algorithm used by the health store to evaluate health.
type ApplicationHealthEvaluation struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the application. The types of the unhealthy evaluations can be DeployedApplicationsHealthEvaluation, ServicesHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplication
	objectMap := make(map[string]interface{})
	if ahe.ApplicationName != nil {
		objectMap["ApplicationName"] = ahe.ApplicationName
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return &ahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthPolicies defines the application health policy map used to evaluate the health of an
// application or one of its children entities.
type ApplicationHealthPolicies struct {
	// ApplicationHealthPolicyMap - The wrapper that contains the map with application health policies used to evaluate specific applications in the cluster.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one of its
// children entities.
type ApplicationHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyDeployedApplications - The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
	// This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32 `json:"MaxPercentUnhealthyDeployedApplications,omitempty"`
	// DefaultServiceTypeHealthPolicy - The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ServiceTypeHealthPolicy `json:"DefaultServiceTypeHealthPolicy,omitempty"`
	// ServiceTypeHealthPolicyMap - The map with service type health policy per service type name. The map is empty be default.
	ServiceTypeHealthPolicyMap *[]ServiceTypeHealthPolicyMapItem `json:"ServiceTypeHealthPolicyMap,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthPolicyMapItem defines an item in ApplicationHealthPolicyMap.
type ApplicationHealthPolicyMapItem struct {
	// Key - The key of the application health policy map item. This is the name of the application.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application health policy map item. This is the ApplicationHealthPolicy for this application.
	Value *ApplicationHealthPolicy `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthState represents the health state of an application, which contains the application identifier
// and the aggregated health state.
type ApplicationHealthState struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthStateChunk represents the health state chunk of a application.
// The application health state chunk contains the application name, its aggregated health state and any children
// services and deployed applications that respect the filters in cluster health chunk query description.
type ApplicationHealthStateChunk struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ServiceHealthStateChunks - The list of service health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ServiceHealthStateChunks *ServiceHealthStateChunkList `json:"ServiceHealthStateChunks,omitempty"`
	// DeployedApplicationHealthStateChunks - The list of deployed application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	DeployedApplicationHealthStateChunks *DeployedApplicationHealthStateChunkList `json:"DeployedApplicationHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthStateChunkList the list of application health state chunks in the cluster that respect the
// input filters in the chunk query. Returned by get cluster health state chunks query.
type ApplicationHealthStateChunkList struct {
	// Items - The list of application health state chunks that respect the input filters in the chunk query.
	Items *[]ApplicationHealthStateChunk `json:"Items,omitempty"`
	// TotalCount - Total number of entity health state objects that match the specified filters from the cluster health chunk query description.
	TotalCount *int64 `json:"TotalCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationHealthStateFilter defines matching criteria to determine whether a application should be included in
// the cluster health chunk.
// One filter can match zero, one or multiple applications, depending on its properties.
type ApplicationHealthStateFilter struct {
	// ApplicationNameFilter - The name of the application that matches the filter, as a fabric uri. The filter is applied only to the specified application, if it exists.
	// If the application doesn't exist, no application is returned in the cluster health chunk based on this filter.
	// If the application exists, it is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationNameFilter *string `json:"ApplicationNameFilter,omitempty"`
	// ApplicationTypeNameFilter - The name of the application type that matches the filter.
	// If specified, the filter is applied only to applications of the selected application type, if any exists.
	// If no applications of the specified application type exists, no application is returned in the cluster health chunk based on this filter.
	// Each application of the specified application type is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationTypeNameFilter *string `json:"ApplicationTypeNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the applications. It allows selecting applications if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only applications that match the filter are returned. All applications are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the application name or the application type name are specified. If the filter has default value and application name is specified, the matching application is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches applications with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// ServiceFilters - Defines a list of filters that specify which services to be included in the returned cluster health chunk as children of the application. The services are returned only if the parent application matches a filter.
	// If the list is empty, no services are returned. All the services are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple service filters.
	// For example, it can specify a filter to return all services with health state Error and another filter to always include a service identified by its service name.
	ServiceFilters *[]ServiceHealthStateFilter `json:"ServiceFilters,omitempty"`
	// DeployedApplicationFilters - Defines a list of filters that specify which deployed applications to be included in the returned cluster health chunk as children of the application. The deployed applications are returned only if the parent application matches a filter.
	// If the list is empty, no deployed applications are returned. All the deployed applications are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple deployed application filters.
	// For example, it can specify a filter to return all deployed applications with health state Error and another filter to always include a deployed application on a specified node.
	DeployedApplicationFilters *[]DeployedApplicationHealthStateFilter `json:"DeployedApplicationFilters,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationInfo information about a Service Fabric application.
type ApplicationInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// Status - The status of the application.
	// . Possible values include: 'ApplicationStatusInvalid', 'ApplicationStatusReady', 'ApplicationStatusUpgrading', 'ApplicationStatusCreating', 'ApplicationStatusDeleting', 'ApplicationStatusFailed'
	Status ApplicationStatus `json:"Status,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// ApplicationDefinitionKind - The mechanism used to define a Service Fabric application.
	// . Possible values include: 'Invalid', 'ServiceFabricApplicationDescription', 'Compose'
	ApplicationDefinitionKind ApplicationDefinitionKind `json:"ApplicationDefinitionKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationLoadInfo load Information about a Service Fabric application.
type ApplicationLoadInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// MinimumNodes - The minimum number of nodes for this application.
	// It is the number of nodes where Service Fabric will reserve Capacity in the cluster which equals to ReservedLoad * MinimumNodes for this Application instance.
	// For applications that do not have application capacity defined this value will be zero.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where this application can be instantiated.
	// It is the number of nodes this application is allowed to span.
	// For applications that do not have application capacity defined this value will be zero.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// NodeCount - The number of nodes on which this application is instantiated.
	// For applications that do not have application capacity defined this value will be zero.
	NodeCount *int64 `json:"NodeCount,omitempty"`
	// ApplicationLoadMetricInformation - List of application capacity metric description.
	ApplicationLoadMetricInformation *[]ApplicationMetricDescription `json:"ApplicationLoadMetricInformation,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationMetricDescription describes capacity information for a custom resource balancing metric. This can be
// used to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// Name - The name of the metric.
	Name *string `json:"Name,omitempty"`
	// MaximumCapacity - The maximum node capacity for Service Fabric application.
	// This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
	// If set to zero, capacity for this metric is unlimited on each node.
	// When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	// When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64 `json:"MaximumCapacity,omitempty"`
	// ReservationCapacity - The node reservation capacity for Service Fabric application.
	// This is the amount of load which is reserved on nodes which have instances of this application.
	// If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
	// If set to zero, no capacity is reserved for this metric.
	// When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64 `json:"ReservationCapacity,omitempty"`
	// TotalApplicationCapacity - The total metric capacity for Service Fabric application.
	// This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
	// When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64 `json:"TotalApplicationCapacity,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationNameInfo information about the application name.
type ApplicationNameInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationParameter describes an application parameter override to be applied when creating or upgrading an
// application.
type ApplicationParameter struct {
	// Key - The name of the parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the parameter.
	Value *string `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationsHealthEvaluation represents health evaluation for applications, containing health evaluations for
// each unhealthy application that impacted current aggregated health state.
type ApplicationsHealthEvaluation struct {
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications from the ClusterHealthPolicy.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplications
	objectMap := make(map[string]interface{})
	if ahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = ahe.MaxPercentUnhealthyApplications
	}
	if ahe.TotalCount != nil {
		objectMap["TotalCount"] = ahe.TotalCount
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return &ahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeApplicationsHealthEvaluation represents health evaluation for applications of a particular
// application type. The application type applications evaluation can be returned when cluster health evaluation
// returns unhealthy aggregated health state, either Error or Warning. It contains health evaluations for each
// unhealthy application of the included application type that impacted current aggregated health state.
type ApplicationTypeApplicationsHealthEvaluation struct {
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications for the application type, specified as an entry in ApplicationTypeHealthPolicyMap.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications of the application type found in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation of this application type that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	atahe.Kind = KindApplicationTypeApplications
	objectMap := make(map[string]interface{})
	if atahe.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = atahe.ApplicationTypeName
	}
	if atahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = atahe.MaxPercentUnhealthyApplications
	}
	if atahe.TotalCount != nil {
		objectMap["TotalCount"] = atahe.TotalCount
	}
	if atahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = atahe.UnhealthyEvaluations
	}
	if atahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = atahe.AggregatedHealthState
	}
	if atahe.Description != nil {
		objectMap["Description"] = atahe.Description
	}
	if atahe.Kind != "" {
		objectMap["Kind"] = atahe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return &atahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &atahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeHealthPolicyMapItem defines an item in ApplicationTypeHealthPolicyMap.
type ApplicationTypeHealthPolicyMapItem struct {
	// Key - The key of the application type health policy map item. This is the name of the application type.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application type health policy map item.
	// The max percent unhealthy applications allowed for the application type. Must be between zero and 100.
	Value *int32 `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeImageStorePath path description for the application package in the image store specified during
// the prior copy operation.
type ApplicationTypeImageStorePath struct {
	// ApplicationTypeBuildPath - The relative image store path to the application package.
	ApplicationTypeBuildPath *string `json:"ApplicationTypeBuildPath,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeInfo information about an application type.
type ApplicationTypeInfo struct {
	// Name - The application type name as defined in the application manifest.
	Name *string `json:"Name,omitempty"`
	// Version - The version of the application type as defined in the application manifest.
	Version *string `json:"Version,omitempty"`
	// DefaultParameterList - List of application type parameters that can be overridden when creating or updating the application.
	DefaultParameterList *[]ApplicationParameter `json:"DefaultParameterList,omitempty"`
	// Status - The status of the application type.
	// . Possible values include: 'ApplicationTypeStatusInvalid', 'ApplicationTypeStatusProvisioning', 'ApplicationTypeStatusAvailable', 'ApplicationTypeStatusUnprovisioning', 'ApplicationTypeStatusFailed'
	Status ApplicationTypeStatus `json:"Status,omitempty"`
	// StatusDetails - Additional detailed information about the status of the application type.
	StatusDetails *string `json:"StatusDetails,omitempty"`
	// ApplicationTypeDefinitionKind - The mechanism used to define a Service Fabric application type.
	// . Possible values include: 'ApplicationTypeDefinitionKindInvalid', 'ApplicationTypeDefinitionKindServiceFabricApplicationPackage', 'ApplicationTypeDefinitionKindCompose'
	ApplicationTypeDefinitionKind ApplicationTypeDefinitionKind `json:"ApplicationTypeDefinitionKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationTypeManifest contains the manifest describing an application type registered in a Service Fabric
// cluster.
type ApplicationTypeManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The XML manifest as a string.
	Manifest *string `json:"Manifest,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationUpgradeDescription describes the parameters for an application upgrade. Please note that upgrade
// description replaces the existing application description. This means that if the parameters are not specified,
// the existing parameters on the applications will be overwritten with the empty parameters list. This would
// results in application using the default value of the parameters from the application manifest. If you do not
// want to change any existing parameter values, please get the application parameters first using the
// GetApplicationInfo query and then supply those values as Parameters in this ApplicationUpgradeDescription.
type ApplicationUpgradeDescription struct {
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationUpgradeProgressInfo describes the parameters for an application upgrade.
type ApplicationUpgradeProgressInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Describes the parameters for an application upgrade. Please note that upgrade description replaces the existing application description. This means that if the parameters are not specified, the existing parameters on the applications will be overwritten with the empty parameters list. This would results in application using the default value of the parameters from the application manifest. If you do not want to change any existing parameter values, please get the application parameters first using the GetApplicationInfo query and then supply those values as Parameters in this ApplicationUpgradeDescription.
	UpgradeDescription *ApplicationUpgradeDescription `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated total amount of time spent processing the overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated total amount of time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The estimated UTC datetime when the upgrade started.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The estimated UTC datetime when the upgrade failed and FailureAction was executed.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - Information about the upgrade domain progress at the time of upgrade failure.
	UpgradeDomainProgressAtFailure *FailureUpgradeDomainProgressInfo `json:"UpgradeDomainProgressAtFailure,omitempty"`
	// UpgradeStatusDetails - Additional detailed information about the status of the pending upgrade.
	UpgradeStatusDetails *string `json:"UpgradeStatusDetails,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ApplicationUpgradeUpdateDescription describes the parameters for updating an ongoing application upgrade.
type ApplicationUpgradeUpdateDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
	// UpdateDescription - Describes the parameters for updating a rolling upgrade of application or cluster.
	UpdateDescription *RollingUpgradeUpdateDescription `json:"UpdateDescription,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BinaryPropertyValue describes a Service Fabric property value of type Binary.
type BinaryPropertyValue struct {
	// Data - Array of bytes to be sent as an integer array. Each element of array is a number between 0 and 255.
	Data *[]int32 `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for BinaryPropertyValue.
func (bpv BinaryPropertyValue) MarshalJSON() ([]byte, error) {
	bpv.Kind = KindBinary
	objectMap := make(map[string]interface{})
	if bpv.Data != nil {
		objectMap["Data"] = bpv.Data
	}
	if bpv.Kind != "" {
		objectMap["Kind"] = bpv.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBinaryPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return &bpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64PropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDoublePropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStringPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGUIDPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &bpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosContext describes a map, which is a collection of (string, string) type key-value pairs. The map can be
// used to record information about
// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most 4095
// characters long.
// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
type ChaosContext struct {
	// Map - Describes a map that contains a collection of ChaosContextMapItem's.
	Map interface{} `json:"Map,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosContextMapItem describes an item in the ChaosContextMap in ChaosParameters.
type ChaosContextMapItem struct {
	// Key - The key for a ChaosContextMapItem.
	Key *string `json:"Key,omitempty"`
	// Value - The value for a ChaosContextMapItem.
	Value *string `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicChaosEvent represents an event generated during a Chaos run.
type BasicChaosEvent interface {
	AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool)
	AsStartedChaosEvent() (*StartedChaosEvent, bool)
	AsStoppedChaosEvent() (*StoppedChaosEvent, bool)
	AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool)
	AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool)
	AsWaitingChaosEvent() (*WaitingChaosEvent, bool)
	AsChaosEvent() (*ChaosEvent, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosEvent represents an event generated during a Chaos run.
type ChaosEvent struct {
	// TimeStampUtc - The UTC timestamp when this Chaos event was generated.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// Kind - Possible values include: 'KindChaosEvent', 'KindExecutingFaults', 'KindStarted', 'KindStopped', 'KindTestError', 'KindValidationFailed', 'KindWaiting'
	Kind KindBasicChaosEvent `json:"Kind,omitempty"`
}

func unmarshalBasicChaosEvent(body []byte) (BasicChaosEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindExecutingFaults):
		var efce ExecutingFaultsChaosEvent
		err := json.Unmarshal(body, &efce)
		return efce, err
	case string(KindStarted):
		var sce StartedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindStopped):
		var sce StoppedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindTestError):
		var tece TestErrorChaosEvent
		err := json.Unmarshal(body, &tece)
		return tece, err
	case string(KindValidationFailed):
		var vfce ValidationFailedChaosEvent
		err := json.Unmarshal(body, &vfce)
		return vfce, err
	case string(KindWaiting):
		var wce WaitingChaosEvent
		err := json.Unmarshal(body, &wce)
		return wce, err
	default:
		var ce ChaosEvent
		err := json.Unmarshal(body, &ce)
		return ce, err
	}
}
func unmarshalBasicChaosEventArray(body []byte) ([]BasicChaosEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ceArray := make([]BasicChaosEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ce, err := unmarshalBasicChaosEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		ceArray[index] = ce
	}
	return ceArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ChaosEvent.
func (ce ChaosEvent) MarshalJSON() ([]byte, error) {
	ce.Kind = KindChaosEvent
	objectMap := make(map[string]interface{})
	if ce.TimeStampUtc != nil {
		objectMap["TimeStampUtc"] = ce.TimeStampUtc
	}
	if ce.Kind != "" {
		objectMap["Kind"] = ce.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExecutingFaultsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStartedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStartedChaosEvent() (*StartedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStoppedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStoppedChaosEvent() (*StoppedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsTestErrorChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsValidationFailedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitingChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsWaitingChaosEvent() (*WaitingChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsChaosEvent() (*ChaosEvent, bool) {
	return &ce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsBasicChaosEvent() (BasicChaosEvent, bool) {
	return &ce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosEventWrapper wrapper object for Chaos event.
type ChaosEventWrapper struct {
	// ChaosEvent - Represents an event generated during a Chaos run.
	ChaosEvent BasicChaosEvent `json:"ChaosEvent,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ChaosEventWrapper struct.
func (cew *ChaosEventWrapper) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ChaosEvent":
			if v != nil {
				chaosEvent, err := unmarshalBasicChaosEvent(*v)
				if err != nil {
					return err
				}
				cew.ChaosEvent = chaosEvent
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosParameters defines all the parameters to configure a Chaos run.
type ChaosParameters struct {
	// TimeToRunInSeconds - Total time (in seconds) for which Chaos will run before automatically stopping. The maximum allowed value is 4,294,967,295 (System.UInt32.MaxValue).
	TimeToRunInSeconds *string `json:"TimeToRunInSeconds,omitempty"`
	// MaxClusterStabilizationTimeoutInSeconds - The maximum amount of time to wait for all cluster entities to become stable and healthy. Chaos executes in iterations and at the start of each iteration it validates the health of cluster entities.
	// During validation if a cluster entity is not stable and healthy within MaxClusterStabilizationTimeoutInSeconds, Chaos generates a validation failed event.
	MaxClusterStabilizationTimeoutInSeconds *int64 `json:"MaxClusterStabilizationTimeoutInSeconds,omitempty"`
	// MaxConcurrentFaults - MaxConcurrentFaults is the maximum number of concurrent faults induced per iteration.
	// Chaos executes in iterations and two consecutive iterations are separated by a validation phase.
	// The higher the concurrency, the more aggressive the injection of faults -- inducing more complex series of states to uncover bugs.
	// The recommendation is to start with a value of 2 or 3 and to exercise caution while moving up.
	MaxConcurrentFaults *int64 `json:"MaxConcurrentFaults,omitempty"`
	// EnableMoveReplicaFaults - Enables or disables the move primary and move secondary faults.
	EnableMoveReplicaFaults *bool `json:"EnableMoveReplicaFaults,omitempty"`
	// WaitTimeBetweenFaultsInSeconds - Wait time (in seconds) between consecutive faults within a single iteration.
	// The larger the value, the lower the overlapping between faults and the simpler the sequence of state transitions that the cluster goes through.
	// The recommendation is to start with a value between 1 and 5 and exercise caution while moving up.
	WaitTimeBetweenFaultsInSeconds *int64 `json:"WaitTimeBetweenFaultsInSeconds,omitempty"`
	// WaitTimeBetweenIterationsInSeconds - Time-separation (in seconds) between two consecutive iterations of Chaos.
	// The larger the value, the lower the fault injection rate.
	WaitTimeBetweenIterationsInSeconds *int64 `json:"WaitTimeBetweenIterationsInSeconds,omitempty"`
	// ClusterHealthPolicy - Passed-in cluster health policy is used to validate health of the cluster in between Chaos iterations. If the cluster health is in error or if an unexpected exception happens during fault execution--to provide the cluster with some time to recuperate--Chaos will wait for 30 minutes before the next health-check.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// Context - Describes a map, which is a collection of (string, string) type key-value pairs. The map can be used to record information about
	// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most 4095 characters long.
	// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
	Context *ChaosContext `json:"Context,omitempty"`
	// ChaosTargetFilter - List of cluster entities to target for Chaos faults.
	// This filter can be used to target Chaos faults only to certain node types or only to certain application instances. If ChaosTargetFilter is not used, Chaos faults all cluster entities.
	// If ChaosTargetFilter is used, Chaos faults only the entities that meet the ChaosTargetFilter specification.
	ChaosTargetFilter *ChaosTargetFilter `json:"ChaosTargetFilter,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosReport contains detailed Chaos report.
type ChaosReport struct {
	autorest.Response `json:"-"`
	// ChaosParameters - Defines all the parameters to configure a Chaos run.
	ChaosParameters *ChaosParameters `json:"ChaosParameters,omitempty"`
	// Status - Current status of the Chaos run.
	// . Possible values include: 'StatusInvalid', 'StatusRunning', 'StatusStopped'
	Status Status `json:"Status,omitempty"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// History - List of ChaosEvent's that meet the user-supplied criteria.
	History *[]ChaosEventWrapper `json:"History,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ChaosTargetFilter defines all filters for targeted Chaos faults, for example, faulting only certain node types
// or faulting only certain applications.
// If ChaosTargetFilter is not used, Chaos faults all cluster entities. If ChaosTargetFilter is used, Chaos faults
// only the entities that meet the ChaosTargetFilter
// specification. NodeTypeInclusionList and ApplicationInclusionList allow a union semantics only. It is not
// possible to specify an intersection
// of NodeTypeInclusionList and ApplicationInclusionList. For example, it is not possible to specify "fault this
// application only when it is on that node type."
// Once an entity is included in either NodeTypeInclusionList or ApplicationInclusionList, that entity cannot be
// excluded using ChaosTargetFilter. Even if
// applicationX does not appear in ApplicationInclusionList, in some Chaos iteration applicationX can be faulted
// because it happens to be on a node of nodeTypeY that is included
// in NodeTypeInclusionList. If both NodeTypeInclusionList and ApplicationInclusionList are null or empty, an
// ArgumentException is thrown.
type ChaosTargetFilter struct {
	// NodeTypeInclusionList - A list of node types to include in Chaos faults.
	// All types of faults (restart node, restart code package, remove replica, restart replica, move primary, and move secondary) are enabled for the nodes of these node types.
	// If a nodetype (say NodeTypeX) does not appear in the NodeTypeInclusionList, then node level faults (like NodeRestart) will never be enabled for the nodes of
	// NodeTypeX, but code package and replica faults can still be enabled for NodeTypeX if an application in the ApplicationInclusionList.
	// happens to reside on a node of NodeTypeX.
	// At most 100 node type names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfNodeTypesInChaosEntityFilter configuration.
	NodeTypeInclusionList *[]string `json:"NodeTypeInclusionList,omitempty"`
	// ApplicationInclusionList - A list of application URI's to include in Chaos faults.
	// All replicas belonging to services of these applications are amenable to replica faults (restart replica, remove replica, move primary, and move secondary) by Chaos.
	// Chaos may restart a code package only if the code package hosts replicas of these applications only.
	// If an application does not appear in this list, it can still be faulted in some Chaos iteration if the application ends up on a node of a node type that is included in NodeTypeInclusionList.
	// However if applicationX is tied to nodeTypeY through placement constraints and applicationX is absent from ApplicationInclusionList and nodeTypeY is absent from NodeTypeInclusionList, then applicationX will never be faulted.
	// At most 1000 application names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfApplicationsInChaosEntityFilter configuration.
	ApplicationInclusionList *[]string `json:"ApplicationInclusionList,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CheckExistsPropertyBatchOperation represents a PropertyBatchOperation that compares the Boolean existence of a
// property with the Exists argument.
// The PropertyBatchOperation operation fails if the property's existence is not equal to the Exists argument.
// The CheckExistsPropertyBatchOperation is generally used as a precondition for the write operations in the batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckExistsPropertyBatchOperation struct {
	// Exists - Whether or not the property should exist for the operation to pass.
	Exists *bool `json:"Exists,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cepbo.Kind = KindCheckExists
	objectMap := make(map[string]interface{})
	if cepbo.Exists != nil {
		objectMap["Exists"] = cepbo.Exists
	}
	if cepbo.PropertyName != nil {
		objectMap["PropertyName"] = cepbo.PropertyName
	}
	if cepbo.Kind != "" {
		objectMap["Kind"] = cepbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return &cepbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cepbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CheckSequencePropertyBatchOperation compares the Sequence Number of a property with the SequenceNumber argument.
// A property's sequence number can be thought of as that property's version.
// Every time the property is modified, its sequence number is increased.
// The sequence number can be found in a property's metadata.
// The comparison fails if the sequence numbers are not equal.
// CheckSequencePropertyBatchOperation is generally used as a precondition for the write operations in the batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckSequencePropertyBatchOperation struct {
	// SequenceNumber - The expected sequence number.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cspbo.Kind = KindCheckSequence
	objectMap := make(map[string]interface{})
	if cspbo.SequenceNumber != nil {
		objectMap["SequenceNumber"] = cspbo.SequenceNumber
	}
	if cspbo.PropertyName != nil {
		objectMap["PropertyName"] = cspbo.PropertyName
	}
	if cspbo.Kind != "" {
		objectMap["Kind"] = cspbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return &cspbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cspbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CheckValuePropertyBatchOperation represents a PropertyBatchOperation that compares the value of the property
// with the expected value.
// The CheckValuePropertyBatchOperation is generally used as a precondition for the write operations in the batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckValuePropertyBatchOperation struct {
	// Value - The expected property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cvpbo.Kind = KindCheckValue
	objectMap := make(map[string]interface{})
	objectMap["Value"] = cvpbo.Value
	if cvpbo.PropertyName != nil {
		objectMap["PropertyName"] = cvpbo.PropertyName
	}
	if cvpbo.Kind != "" {
		objectMap["Kind"] = cvpbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return &cvpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cvpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for CheckValuePropertyBatchOperation struct.
func (cvpbo *CheckValuePropertyBatchOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				cvpbo.Value = value
			}
		case "PropertyName":
			if v != nil {
				var propertyName string
				err = json.Unmarshal(*v, &propertyName)
				if err != nil {
					return err
				}
				cvpbo.PropertyName = &propertyName
			}
		case "Kind":
			if v != nil {
				var kind KindBasicPropertyBatchOperation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cvpbo.Kind = kind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterConfiguration information about the standalone cluster configuration.
type ClusterConfiguration struct {
	autorest.Response `json:"-"`
	// ClusterConfiguration - The contents of the cluster configuration file.
	ClusterConfiguration *string `json:"ClusterConfiguration,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterConfigurationUpgradeDescription describes the parameters for a standalone cluster configuration upgrade.
type ClusterConfigurationUpgradeDescription struct {
	// ClusterConfig - The cluster configuration.
	ClusterConfig *string `json:"ClusterConfig,omitempty"`
	// HealthCheckRetryTimeout - The length of time between attempts to perform a health checks if the application or cluster is not healthy.
	HealthCheckRetryTimeout *string `json:"HealthCheckRetryTimeout,omitempty"`
	// HealthCheckWaitDurationInSeconds - The length of time to wait after completing an upgrade domain before starting the health checks process.
	HealthCheckWaitDurationInSeconds *string `json:"HealthCheckWaitDurationInSeconds,omitempty"`
	// HealthCheckStableDurationInSeconds - The length of time that the application or cluster must remain healthy.
	HealthCheckStableDurationInSeconds *string `json:"HealthCheckStableDurationInSeconds,omitempty"`
	// UpgradeDomainTimeoutInSeconds - The timeout for the upgrade domain.
	UpgradeDomainTimeoutInSeconds *string `json:"UpgradeDomainTimeoutInSeconds,omitempty"`
	// UpgradeTimeoutInSeconds - The upgrade timeout.
	UpgradeTimeoutInSeconds *string `json:"UpgradeTimeoutInSeconds,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterConfigurationUpgradeStatusInfo information about a standalone cluster configuration upgrade status.
type ClusterConfigurationUpgradeStatusInfo struct {
	autorest.Response `json:"-"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// ProgressStatus - The cluster manifest version.
	ProgressStatus *int32 `json:"ProgressStatus,omitempty"`
	// ConfigVersion - The cluster configuration version.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// Details - The cluster upgrade status details.
	Details *string `json:"Details,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealth represents the health of the cluster.
// Contains the cluster aggregated health state, the cluster application and node health states as well as the
// health events and the unhealthy evaluations.
type ClusterHealth struct {
	autorest.Response `json:"-"`
	// NodeHealthStates - Cluster node health states as found in the health store.
	NodeHealthStates *[]NodeHealthState `json:"NodeHealthStates,omitempty"`
	// ApplicationHealthStates - Cluster application health states as found in the health store.
	ApplicationHealthStates *[]ApplicationHealthState `json:"ApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealthChunk represents the health chunk of the cluster.
// Contains the cluster aggregated health state, and the cluster entities that respect the input filter.
type ClusterHealthChunk struct {
	autorest.Response `json:"-"`
	// HealthState - The HealthState representing the aggregated health state of the cluster computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired cluster health policy and the application health policies.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// NodeHealthStateChunks - The list of node health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	NodeHealthStateChunks *NodeHealthStateChunkList `json:"NodeHealthStateChunks,omitempty"`
	// ApplicationHealthStateChunks - The list of application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ApplicationHealthStateChunks *ApplicationHealthStateChunkList `json:"ApplicationHealthStateChunks,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealthChunkQueryDescription the cluster health chunk query description, which can specify the health
// policies to evaluate cluster health and very expressive filters to select which cluster entities to include in
// response.
type ClusterHealthChunkQueryDescription struct {
	// NodeFilters - Defines a list of filters that specify which nodes to be included in the returned cluster health chunk.
	// If no filters are specified, no nodes are returned. All the nodes are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple node filters.
	// For example, it can specify a filter to return all nodes with health state Error and another filter to always include a node identified by its NodeName.
	NodeFilters *[]NodeHealthStateFilter `json:"NodeFilters,omitempty"`
	// ApplicationFilters - Defines a list of filters that specify which applications to be included in the returned cluster health chunk.
	// If no filters are specified, no applications are returned. All the applications are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple application filters.
	// For example, it can specify a filter to return all applications with health state Error and another filter to always include applications of a specified application type.
	ApplicationFilters *[]ApplicationHealthStateFilter `json:"ApplicationFilters,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies *ApplicationHealthPolicies `json:"ApplicationHealthPolicies,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealthPolicies health policies to evaluate cluster health.
type ClusterHealthPolicies struct {
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster node.
type ClusterHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	// In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
	// The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// ApplicationTypeHealthPolicyMap - Defines a map with max percentage unhealthy applications for specific application types.
	// Each entry specifies as key the application type name and as value an integer that represents the MaxPercentUnhealthyApplications percentage used to evaluate the applications of the specified application type.
	// The application type health policy map can be used during cluster health evaluation to describe special application types.
	// The application types included in the map are evaluated against the percentage specified in the map, and not with the global MaxPercentUnhealthyApplications defined in the cluster health policy.
	// The applications of application types specified in the map are not counted against the global pool of applications.
	// For example, if some applications of a type are critical, the cluster administrator can add an entry to the map for that application type
	// and assign it a value of 0% (that is, do not tolerate any failures).
	// All other applications can be evaluated with MaxPercentUnhealthyApplications set to 20% to tolerate some failures out of the thousands of application instances.
	// The application type health policy map is used only if the cluster manifest enables application type health evaluation using the configuration entry for HealthManager/EnableApplicationTypeHealthEvaluation.
	ApplicationTypeHealthPolicyMap *[]ApplicationTypeHealthPolicyMapItem `json:"ApplicationTypeHealthPolicyMap,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterManifest information about the cluster manifest.
type ClusterManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The contents of the cluster manifest file.
	Manifest *string `json:"Manifest,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterUpgradeDescriptionObject represents a ServiceFabric cluster upgrade
type ClusterUpgradeDescriptionObject struct {
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// EnableDeltaHealthEvaluation - When true, enables delta health evaluation rather than absolute health evaluation after completion of each upgrade domain.
	EnableDeltaHealthEvaluation *bool `json:"EnableDeltaHealthEvaluation,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ClusterUpgradeHealthPolicy - Defines a health policy used to evaluate the health of the cluster during a cluster upgrade.
	ClusterUpgradeHealthPolicy *ClusterUpgradeHealthPolicyObject `json:"ClusterUpgradeHealthPolicy,omitempty"`
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterUpgradeHealthPolicyObject defines a health policy used to evaluate the health of the cluster during a
// cluster upgrade.
type ClusterUpgradeHealthPolicyObject struct {
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. The default value is 10%.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits. The default value is 15%.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterUpgradeProgressObject information about a cluster upgrade.
type ClusterUpgradeProgressObject struct {
	autorest.Response `json:"-"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Represents a ServiceFabric cluster upgrade
	UpgradeDescription *ClusterUpgradeDescriptionObject `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated elapsed time spent processing the current overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated elapsed time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The start time of the upgrade in UTC.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The failure time of the upgrade in UTC.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - The detailed upgrade progress for nodes in the current upgrade domain at the point of failure.
	UpgradeDomainProgressAtFailure *FailedUpgradeDomainProgressObject `json:"UpgradeDomainProgressAtFailure,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CodePackageEntryPoint information about setup or main entry point of a code package deployed on a Service Fabric
// node.
type CodePackageEntryPoint struct {
	// EntryPointLocation - The location of entry point executable on the node.
	EntryPointLocation *string `json:"EntryPointLocation,omitempty"`
	// ProcessID - The process id of the entry point.
	ProcessID *string `json:"ProcessId,omitempty"`
	// RunAsUserName - The user name under which entry point executable is run on the node.
	RunAsUserName *string `json:"RunAsUserName,omitempty"`
	// CodePackageEntryPointStatistics - Statistics about setup or main entry point  of a code package deployed on a Service Fabric node.
	CodePackageEntryPointStatistics *CodePackageEntryPointStatistics `json:"CodePackageEntryPointStatistics,omitempty"`
	// Status - Specifies the status of the code package entry point deployed on a Service Fabric node. Possible values include: 'EntryPointStatusInvalid', 'EntryPointStatusPending', 'EntryPointStatusStarting', 'EntryPointStatusStarted', 'EntryPointStatusStopping', 'EntryPointStatusStopped'
	Status EntryPointStatus `json:"Status,omitempty"`
	// NextActivationTime - The time (in UTC) when the entry point executable will be run next.
	NextActivationTime *date.Time `json:"NextActivationTime,omitempty"`
	// InstanceID - The instance id for current running entry point. For a code package setup entry point (if specified) runs first and after it finishes main entry point is started. Each time entry point executable is run, its instance id will change.
	InstanceID *string `json:"InstanceId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CodePackageEntryPointStatistics statistics about setup or main entry point  of a code package deployed on a
// Service Fabric node.
type CodePackageEntryPointStatistics struct {
	// LastExitCode - The last exit code of the entry point.
	LastExitCode *string `json:"LastExitCode,omitempty"`
	// LastActivationTime - The last time (in UTC) when Service Fabric attempted to run the entry point.
	LastActivationTime *date.Time `json:"LastActivationTime,omitempty"`
	// LastExitTime - The last time (in UTC) when the entry point finished running.
	LastExitTime *date.Time `json:"LastExitTime,omitempty"`
	// LastSuccessfulActivationTime - The last time (in UTC) when the entry point ran successfully.
	LastSuccessfulActivationTime *date.Time `json:"LastSuccessfulActivationTime,omitempty"`
	// LastSuccessfulExitTime - The last time (in UTC) when the entry point finished running gracefully.
	LastSuccessfulExitTime *date.Time `json:"LastSuccessfulExitTime,omitempty"`
	// ActivationCount - Number of times the entry point has run.
	ActivationCount *string `json:"ActivationCount,omitempty"`
	// ActivationFailureCount - Number of times the entry point failed to run.
	ActivationFailureCount *string `json:"ActivationFailureCount,omitempty"`
	// ContinuousActivationFailureCount - Number of times the entry point continuously failed to run.
	ContinuousActivationFailureCount *string `json:"ContinuousActivationFailureCount,omitempty"`
	// ExitCount - Number of times the entry point finished running.
	ExitCount *string `json:"ExitCount,omitempty"`
	// ExitFailureCount - Number of times the entry point failed to exit gracefully.
	ExitFailureCount *string `json:"ExitFailureCount,omitempty"`
	// ContinuousExitFailureCount - Number of times the entry point continuously failed to exit gracefully.
	ContinuousExitFailureCount *string `json:"ContinuousExitFailureCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ComposeDeploymentStatusInfo information about a Service Fabric compose deployment.
type ComposeDeploymentStatusInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of the deployment.
	Name *string `json:"Name,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// Status - The status of the compose deployment. Possible values include: 'ComposeDeploymentStatusInvalid', 'ComposeDeploymentStatusProvisioning', 'ComposeDeploymentStatusCreating', 'ComposeDeploymentStatusReady', 'ComposeDeploymentStatusUnprovisioning', 'ComposeDeploymentStatusDeleting', 'ComposeDeploymentStatusFailed', 'ComposeDeploymentStatusUpgrading'
	Status ComposeDeploymentStatus `json:"Status,omitempty"`
	// StatusDetails - The status details of compose deployment including failure message.
	StatusDetails *string `json:"StatusDetails,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ComposeDeploymentUpgradeDescription describes the parameters for a compose deployment upgrade.
type ComposeDeploymentUpgradeDescription struct {
	// DeploymentName - The name of the deployment.
	DeploymentName *string `json:"DeploymentName,omitempty"`
	// ComposeFileContent - The content of the compose file that describes the deployment to create.
	ComposeFileContent *string `json:"ComposeFileContent,omitempty"`
	// RegistryCredential - Credential information to connect to container registry.
	RegistryCredential *RegistryCredential `json:"RegistryCredential,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ComposeDeploymentUpgradeProgressInfo describes the parameters for a compose deployment upgrade.
type ComposeDeploymentUpgradeProgressInfo struct {
	autorest.Response `json:"-"`
	// DeploymentName - The name of the target deployment.
	DeploymentName *string `json:"DeploymentName,omitempty"`
	// ApplicationName - The name of the target application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// UpgradeState - The state of the compose deployment upgrade.
	// . Possible values include: 'ComposeDeploymentUpgradeStateInvalid', 'ComposeDeploymentUpgradeStateProvisioningTarget', 'ComposeDeploymentUpgradeStateRollingForwardInProgress', 'ComposeDeploymentUpgradeStateRollingForwardPending', 'ComposeDeploymentUpgradeStateUnprovisioningCurrent', 'ComposeDeploymentUpgradeStateRollingForwardCompleted', 'ComposeDeploymentUpgradeStateRollingBackInProgress', 'ComposeDeploymentUpgradeStateUnprovisioningTarget', 'ComposeDeploymentUpgradeStateRollingBackCompleted', 'ComposeDeploymentUpgradeStateFailed'
	UpgradeState ComposeDeploymentUpgradeState `json:"UpgradeState,omitempty"`
	// UpgradeStatusDetails - Additional detailed information about the status of the pending upgrade.
	UpgradeStatusDetails *string `json:"UpgradeStatusDetails,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// UpgradeDuration - The estimated amount of time that the overall upgrade elapsed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeDuration *string `json:"UpgradeDuration,omitempty"`
	// CurrentUpgradeDomainDuration - The estimated amount of time spent processing current Upgrade Domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	CurrentUpgradeDomainDuration *string `json:"CurrentUpgradeDomainDuration,omitempty"`
	// ApplicationUnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	ApplicationUnhealthyEvaluations *[]HealthEvaluationWrapper `json:"ApplicationUnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The estimated UTC datetime when the upgrade started.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The estimated UTC datetime when the upgrade failed and FailureAction was executed.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - Information about the upgrade domain progress at the time of upgrade failure.
	UpgradeDomainProgressAtFailure *FailureUpgradeDomainProgressInfo `json:"UpgradeDomainProgressAtFailure,omitempty"`
	// ApplicationUpgradeStatusDetails - Additional details of application upgrade including failure message.
	ApplicationUpgradeStatusDetails *string `json:"ApplicationUpgradeStatusDetails,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ContainerLogs container logs.
type ContainerLogs struct {
	autorest.Response `json:"-"`
	// Content - Container logs.
	Content *string `json:"Content,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CreateComposeDeploymentDescription defines description for creating a Service Fabric compose deployment.
type CreateComposeDeploymentDescription struct {
	// DeploymentName - The name of the deployment.
	DeploymentName *string `json:"DeploymentName,omitempty"`
	// ComposeFileContent - The content of the compose file that describes the deployment to create.
	ComposeFileContent *string `json:"ComposeFileContent,omitempty"`
	// RegistryCredential - Credential information to connect to container registry.
	RegistryCredential *RegistryCredential `json:"RegistryCredential,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// CurrentUpgradeDomainProgressInfo information about the current in-progress upgrade domain.
type CurrentUpgradeDomainProgressInfo struct {
	// DomainName - The name of the upgrade domain
	DomainName *string `json:"DomainName,omitempty"`
	// NodeUpgradeProgressList - List of upgrading nodes and their statuses
	NodeUpgradeProgressList *[]NodeUpgradeProgressInfo `json:"NodeUpgradeProgressList,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeactivationIntentDescription describes the intent or reason for deactivating the node.
type DeactivationIntentDescription struct {
	// DeactivationIntent - Describes the intent or reason for deactivating the node. The possible values are following.
	// . Possible values include: 'Pause', 'Restart', 'RemoveData'
	DeactivationIntent DeactivationIntent `json:"DeactivationIntent,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeletePropertyBatchOperation represents a PropertyBatchOperation that deletes a specified property if it exists.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type DeletePropertyBatchOperation struct {
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	dpbo.Kind = KindDelete
	objectMap := make(map[string]interface{})
	if dpbo.PropertyName != nil {
		objectMap["PropertyName"] = dpbo.PropertyName
	}
	if dpbo.Kind != "" {
		objectMap["Kind"] = dpbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return &dpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for DeletePropertyBatchOperation.
func (dpbo DeletePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &dpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeltaNodesCheckHealthEvaluation represents health evaluation for delta nodes, containing health evaluations for
// each unhealthy node that impacted current aggregated health state.
// Can be returned during cluster upgrade when the aggregated health state of the cluster is Warning or Error.
type DeltaNodesCheckHealthEvaluation struct {
	// BaselineErrorCount - Number of nodes with aggregated heath state Error in the health store at the beginning of the cluster upgrade.
	BaselineErrorCount *int64 `json:"BaselineErrorCount,omitempty"`
	// BaselineTotalCount - Total number of nodes in the health store at the beginning of the cluster upgrade.
	BaselineTotalCount *int64 `json:"BaselineTotalCount,omitempty"`
	// MaxPercentDeltaUnhealthyNodes - Maximum allowed percentage of delta unhealthy nodes from the ClusterUpgradeHealthPolicy.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// TotalCount - Total number of nodes in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state.
	// Includes all the unhealthy NodeHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) MarshalJSON() ([]byte, error) {
	dnche.Kind = KindDeltaNodesCheck
	objectMap := make(map[string]interface{})
	if dnche.BaselineErrorCount != nil {
		objectMap["BaselineErrorCount"] = dnche.BaselineErrorCount
	}
	if dnche.BaselineTotalCount != nil {
		objectMap["BaselineTotalCount"] = dnche.BaselineTotalCount
	}
	if dnche.MaxPercentDeltaUnhealthyNodes != nil {
		objectMap["MaxPercentDeltaUnhealthyNodes"] = dnche.MaxPercentDeltaUnhealthyNodes
	}
	if dnche.TotalCount != nil {
		objectMap["TotalCount"] = dnche.TotalCount
	}
	if dnche.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = dnche.UnhealthyEvaluations
	}
	if dnche.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = dnche.AggregatedHealthState
	}
	if dnche.Description != nil {
		objectMap["Description"] = dnche.Description
	}
	if dnche.Kind != "" {
		objectMap["Kind"] = dnche.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return &dnche, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for DeltaNodesCheckHealthEvaluation.
func (dnche DeltaNodesCheckHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &dnche, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealth information about the health of an application deployed on a Service Fabric node.
type DeployedApplicationHealth struct {
	autorest.Response `json:"-"`
	// Name - Name of the application deployed on the node whose health information is described by this object.
	Name *string `json:"Name,omitempty"`
	// NodeName - Name of the node where this application is deployed.
	NodeName *string `json:"NodeName,omitempty"`
	// DeployedServicePackageHealthStates - Deployed service package health states for the current deployed application as found in the health store.
	DeployedServicePackageHealthStates *[]DeployedServicePackageHealthState `json:"DeployedServicePackageHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealthEvaluation represents health evaluation for a deployed application, containing
// information about the data and the algorithm used by the health store to evaluate health.
type DeployedApplicationHealthEvaluation struct {
	// NodeName - Name of the node where the application is deployed to.
	NodeName *string `json:"NodeName,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// UnhealthyEvaluations - List of  unhealthy evaluations that led to the current aggregated health state of the deployed application.
	// The types of the unhealthy evaluations can be DeployedServicePackagesHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) MarshalJSON() ([]byte, error) {
	dahe.Kind = KindDeployedApplication
	objectMap := make(map[string]interface{})
	if dahe.NodeName != nil {
		objectMap["NodeName"] = dahe.NodeName
	}
	if dahe.ApplicationName != nil {
		objectMap["ApplicationName"] = dahe.ApplicationName
	}
	if dahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = dahe.UnhealthyEvaluations
	}
	if dahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = dahe.AggregatedHealthState
	}
	if dahe.Description != nil {
		objectMap["Description"] = dahe.Description
	}
	if dahe.Kind != "" {
		objectMap["Kind"] = dahe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return &dahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationHealthEvaluation.
func (dahe DeployedApplicationHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &dahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealthState represents the health state of a deployed application, which contains the entity
// identifier and the aggregated health state.
type DeployedApplicationHealthState struct {
	// NodeName - Name of the node on which the service package is deployed.
	NodeName *string `json:"NodeName,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealthStateChunk represents the health state chunk of a deployed application, which contains
// the node where the application is deployed, the aggregated health state and any deployed service packages that
// respect the chunk query description filters.
type DeployedApplicationHealthStateChunk struct {
	// NodeName - The name of node where the application is deployed.
	NodeName *string `json:"NodeName,omitempty"`
	// DeployedServicePackageHealthStateChunks - The list of deployed service package health state chunks belonging to the deployed application that respect the filters in the cluster health chunk query description.
	DeployedServicePackageHealthStateChunks *DeployedServicePackageHealthStateChunkList `json:"DeployedServicePackageHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealthStateChunkList the list of deployed application health state chunks that respect the
// input filters in the chunk query. Returned by get cluster health state chunks query.
type DeployedApplicationHealthStateChunkList struct {
	// Items - The list of deployed application health state chunks that respect the input filters in the chunk query.
	Items *[]DeployedApplicationHealthStateChunk `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationHealthStateFilter defines matching criteria to determine whether a deployed application
// should be included as a child of an application in the cluster health chunk.
// The deployed applications are only returned if the parent application matches a filter specified in the cluster
// health chunk query description.
// One filter can match zero, one or multiple deployed applications, depending on its properties.
type DeployedApplicationHealthStateFilter struct {
	// NodeNameFilter - The name of the node where the application is deployed in order to match the filter.
	// If specified, the filter is applied only to the application deployed on the specified node.
	// If the application is not deployed on the node with the specified name, no deployed application is returned in the cluster health chunk based on this filter.
	// Otherwise, the deployed application is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all deployed applications that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	NodeNameFilter *string `json:"NodeNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the deployed applications. It allows selecting deployed applications if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only deployed applications that match the filter are returned. All deployed applications are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the node name is specified. If the filter has default value and node name is specified, the matching deployed application is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches deployed applications with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// DeployedServicePackageFilters - Defines a list of filters that specify which deployed service packages to be included in the returned cluster health chunk as children of the parent deployed application. The deployed service packages are returned only if the parent deployed application matches a filter.
	// If the list is empty, no deployed service packages are returned. All the deployed service packages are used to evaluate the parent deployed application aggregated health state, regardless of the input filters.
	// The deployed application filter may specify multiple deployed service package filters.
	// For example, it can specify a filter to return all deployed service packages with health state Error and another filter to always include a deployed service package on a node.
	DeployedServicePackageFilters *[]DeployedServicePackageHealthStateFilter `json:"DeployedServicePackageFilters,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationInfo information about application deployed on the node.
type DeployedApplicationInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// Status - The status of the application deployed on the node. Following are the possible values.
	// . Possible values include: 'DeployedApplicationStatusInvalid', 'DeployedApplicationStatusDownloading', 'DeployedApplicationStatusActivating', 'DeployedApplicationStatusActive', 'DeployedApplicationStatusUpgrading', 'DeployedApplicationStatusDeactivating'
	Status DeployedApplicationStatus `json:"Status,omitempty"`
	// WorkDirectory - The work directory of the application on the node. The work directory can be used to store application data.
	WorkDirectory *string `json:"WorkDirectory,omitempty"`
	// LogDirectory - The log directory of the application on the node. The log directory can be used to store application logs.
	LogDirectory *string `json:"LogDirectory,omitempty"`
	// TempDirectory - The temp directory of the application on the node. The code packages belonging to the application are forked with this directory set as their temporary directory.
	TempDirectory *string `json:"TempDirectory,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedApplicationsHealthEvaluation represents health evaluation for deployed applications, containing health
// evaluations for each unhealthy deployed application that impacted current aggregated health state.
// Can be returned when evaluating application health and the aggregated health state is either Error or Warning.
type DeployedApplicationsHealthEvaluation struct {
	// MaxPercentUnhealthyDeployedApplications - Maximum allowed percentage of unhealthy deployed applications from the ApplicationHealthPolicy.
	MaxPercentUnhealthyDeployedApplications *int32 `json:"MaxPercentUnhealthyDeployedApplications,omitempty"`
	// TotalCount - Total number of deployed applications of the application in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy DeployedApplicationHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	dahe.Kind = KindDeployedApplications
	objectMap := make(map[string]interface{})
	if dahe.MaxPercentUnhealthyDeployedApplications != nil {
		objectMap["MaxPercentUnhealthyDeployedApplications"] = dahe.MaxPercentUnhealthyDeployedApplications
	}
	if dahe.TotalCount != nil {
		objectMap["TotalCount"] = dahe.TotalCount
	}
	if dahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = dahe.UnhealthyEvaluations
	}
	if dahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = dahe.AggregatedHealthState
	}
	if dahe.Description != nil {
		objectMap["Description"] = dahe.Description
	}
	if dahe.Kind != "" {
		objectMap["Kind"] = dahe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return &dahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for DeployedApplicationsHealthEvaluation.
func (dahe DeployedApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &dahe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedCodePackageInfo information about code package deployed on a Service Fabric node.
type DeployedCodePackageInfo struct {
	// Name - The name of the code package.
	Name *string `json:"Name,omitempty"`
	// Version - The version of the code package specified in service manifest.
	Version *string `json:"Version,omitempty"`
	// ServiceManifestName - The name of service manifest that specified this code package.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// HostType - Specifies the type of host for main entry point of a code package as specified in service manifest. Possible values include: 'HostTypeInvalid', 'HostTypeExeHost', 'HostTypeContainerHost'
	HostType HostType `json:"HostType,omitempty"`
	// HostIsolationMode - Specifies the isolation mode of main entry point of a code package when it's host type is ContainerHost. This is specified as part of container host policies in application manifest while importing service manifest. Possible values include: 'HostIsolationModeNone', 'HostIsolationModeProcess', 'HostIsolationModeHyperV'
	HostIsolationMode HostIsolationMode `json:"HostIsolationMode,omitempty"`
	// Status - Specifies the status of a deployed application or service package on a Service Fabric node.
	// . Possible values include: 'DeploymentStatusInvalid', 'DeploymentStatusDownloading', 'DeploymentStatusActivating', 'DeploymentStatusActive', 'DeploymentStatusUpgrading', 'DeploymentStatusDeactivating'
	Status DeploymentStatus `json:"Status,omitempty"`
	// RunFrequencyInterval - The interval at which code package is run. This is used for periodic code package.
	RunFrequencyInterval *string `json:"RunFrequencyInterval,omitempty"`
	// SetupEntryPoint - Information about setup or main entry point of a code package deployed on a Service Fabric node.
	SetupEntryPoint *CodePackageEntryPoint `json:"SetupEntryPoint,omitempty"`
	// MainEntryPoint - Information about setup or main entry point of a code package deployed on a Service Fabric node.
	MainEntryPoint *CodePackageEntryPoint `json:"MainEntryPoint,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealth information about the health of a service package for a specific application
// deployed on a Service Fabric node.
type DeployedServicePackageHealth struct {
	autorest.Response `json:"-"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceManifestName - Name of the service manifest.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// NodeName - Name of the node where this service package is deployed.
	NodeName *string `json:"NodeName,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealthEvaluation represents health evaluation for a deployed service package, containing
// information about the data and the algorithm used by health store to evaluate health. The evaluation is returned
// only when the aggregated health state is either Error or Warning.
type DeployedServicePackageHealthEvaluation struct {
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceManifestName - The name of the service manifest.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state. The type of the unhealthy evaluations can be EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) MarshalJSON() ([]byte, error) {
	dsphe.Kind = KindDeployedServicePackage
	objectMap := make(map[string]interface{})
	if dsphe.NodeName != nil {
		objectMap["NodeName"] = dsphe.NodeName
	}
	if dsphe.ApplicationName != nil {
		objectMap["ApplicationName"] = dsphe.ApplicationName
	}
	if dsphe.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = dsphe.ServiceManifestName
	}
	if dsphe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = dsphe.UnhealthyEvaluations
	}
	if dsphe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = dsphe.AggregatedHealthState
	}
	if dsphe.Description != nil {
		objectMap["Description"] = dsphe.Description
	}
	if dsphe.Kind != "" {
		objectMap["Kind"] = dsphe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return &dsphe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackageHealthEvaluation.
func (dsphe DeployedServicePackageHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &dsphe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealthState represents the health state of a deployed service package, containing the
// entity identifier and the aggregated health state.
type DeployedServicePackageHealthState struct {
	// NodeName - Name of the node on which the service package is deployed.
	NodeName *string `json:"NodeName,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceManifestName - Name of the manifest describing the service package.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealthStateChunk represents the health state chunk of a deployed service package, which
// contains the service manifest name and the service package aggregated health state.
type DeployedServicePackageHealthStateChunk struct {
	// ServiceManifestName - The name of the service manifest.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealthStateChunkList the list of deployed service package health state chunks that respect
// the input filters in the chunk query. Returned by get cluster health state chunks query.
type DeployedServicePackageHealthStateChunkList struct {
	// Items - The list of deployed service package health state chunks that respect the input filters in the chunk query.
	Items *[]DeployedServicePackageHealthStateChunk `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageHealthStateFilter defines matching criteria to determine whether a deployed service
// package should be included as a child of a deployed application in the cluster health chunk.
// The deployed service packages are only returned if the parent entities match a filter specified in the cluster
// health chunk query description. The parent deployed application and its parent application must be included in
// the cluster health chunk.
// One filter can match zero, one or multiple deployed service packages, depending on its properties.
type DeployedServicePackageHealthStateFilter struct {
	// ServiceManifestNameFilter - The name of the service manifest which identifies the deployed service packages that matches the filter.
	// If specified, the filter is applied only to the specified deployed service packages, if any.
	// If no deployed service packages with specified manifest name exist, nothing is returned in the cluster health chunk based on this filter.
	// If any deployed service package exists, they are included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all deployed service packages that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	ServiceManifestNameFilter *string `json:"ServiceManifestNameFilter,omitempty"`
	// ServicePackageActivationIDFilter - The activation ID of a deployed service package that matches the filter.
	// If not specified, the filter applies to all deployed service packages that match the other parameters.
	// If specified, the filter matches only the deployed service package with the specified activation ID.
	ServicePackageActivationIDFilter *string `json:"ServicePackageActivationIdFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the deployed service packages. It allows selecting deployed service packages if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only deployed service packages that match the filter are returned. All deployed service packages are used to evaluate the parent deployed application aggregated health state.
	// If not specified, default value is None, unless the deployed service package id is specified. If the filter has default value and deployed service package id is specified, the matching deployed service package is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches deployed service packages with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackageInfo information about service package deployed on a Service Fabric node.
type DeployedServicePackageInfo struct {
	// Name - The name of the service package as specified in the service manifest.
	Name *string `json:"Name,omitempty"`
	// Version - The version of the service package specified in service manifest.
	Version *string `json:"Version,omitempty"`
	// Status - Specifies the status of a deployed application or service package on a Service Fabric node.
	// . Possible values include: 'DeploymentStatusInvalid', 'DeploymentStatusDownloading', 'DeploymentStatusActivating', 'DeploymentStatusActive', 'DeploymentStatusUpgrading', 'DeploymentStatusDeactivating'
	Status DeploymentStatus `json:"Status,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServicePackagesHealthEvaluation represents health evaluation for deployed service packages, containing
// health evaluations for each unhealthy deployed service package that impacted current aggregated health state.
// Can be returned when evaluating deployed application health and the aggregated health state is either Error or
// Warning.
type DeployedServicePackagesHealthEvaluation struct {
	// TotalCount - Total number of deployed service packages of the deployed application in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy DeployedServicePackageHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) MarshalJSON() ([]byte, error) {
	dsphe.Kind = KindDeployedServicePackages
	objectMap := make(map[string]interface{})
	if dsphe.TotalCount != nil {
		objectMap["TotalCount"] = dsphe.TotalCount
	}
	if dsphe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = dsphe.UnhealthyEvaluations
	}
	if dsphe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = dsphe.AggregatedHealthState
	}
	if dsphe.Description != nil {
		objectMap["Description"] = dsphe.Description
	}
	if dsphe.Kind != "" {
		objectMap["Kind"] = dsphe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return &dsphe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for DeployedServicePackagesHealthEvaluation.
func (dsphe DeployedServicePackagesHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &dsphe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicDeployedServiceReplicaDetailInfo information about a Service Fabric service replica deployed on a node.
type BasicDeployedServiceReplicaDetailInfo interface {
	AsDeployedStatefulServiceReplicaDetailInfo() (*DeployedStatefulServiceReplicaDetailInfo, bool)
	AsDeployedStatelessServiceInstanceDetailInfo() (*DeployedStatelessServiceInstanceDetailInfo, bool)
	AsDeployedServiceReplicaDetailInfo() (*DeployedServiceReplicaDetailInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServiceReplicaDetailInfo information about a Service Fabric service replica deployed on a node.
type DeployedServiceReplicaDetailInfo struct {
	autorest.Response `json:"-"`
	// ServiceName - Full hierarchical name of the service in URI format starting with `fabric:`.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// CurrentServiceOperation - Specifies the current active life-cycle operation on a stateful service replica or stateless service instance. Possible values include: 'ServiceOperationNameUnknown', 'ServiceOperationNameNone', 'ServiceOperationNameOpen', 'ServiceOperationNameChangeRole', 'ServiceOperationNameClose', 'ServiceOperationNameAbort'
	CurrentServiceOperation ServiceOperationName `json:"CurrentServiceOperation,omitempty"`
	// CurrentServiceOperationStartTimeUtc - The start time of the current service operation in UTC format.
	CurrentServiceOperationStartTimeUtc *date.Time `json:"CurrentServiceOperationStartTimeUtc,omitempty"`
	// ReportedLoad - List of load reported by replica.
	ReportedLoad *[]LoadMetricReportInfo `json:"ReportedLoad,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindDeployedServiceReplicaDetailInfo', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicDeployedServiceReplicaDetailInfo `json:"ServiceKind,omitempty"`
}

func unmarshalBasicDeployedServiceReplicaDetailInfo(body []byte) (BasicDeployedServiceReplicaDetailInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindStateful1):
		var dssrdi DeployedStatefulServiceReplicaDetailInfo
		err := json.Unmarshal(body, &dssrdi)
		return dssrdi, err
	case string(ServiceKindStateless1):
		var dssidi DeployedStatelessServiceInstanceDetailInfo
		err := json.Unmarshal(body, &dssidi)
		return dssidi, err
	default:
		var dsrdi DeployedServiceReplicaDetailInfo
		err := json.Unmarshal(body, &dsrdi)
		return dsrdi, err
	}
}
func unmarshalBasicDeployedServiceReplicaDetailInfoArray(body []byte) ([]BasicDeployedServiceReplicaDetailInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dsrdiArray := make([]BasicDeployedServiceReplicaDetailInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsrdi, err := unmarshalBasicDeployedServiceReplicaDetailInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		dsrdiArray[index] = dsrdi
	}
	return dsrdiArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedServiceReplicaDetailInfo.
func (dsrdi DeployedServiceReplicaDetailInfo) MarshalJSON() ([]byte, error) {
	dsrdi.ServiceKind = ServiceKindDeployedServiceReplicaDetailInfo
	objectMap := make(map[string]interface{})
	if dsrdi.ServiceName != nil {
		objectMap["ServiceName"] = dsrdi.ServiceName
	}
	if dsrdi.PartitionID != nil {
		objectMap["PartitionId"] = dsrdi.PartitionID
	}
	if dsrdi.CurrentServiceOperation != "" {
		objectMap["CurrentServiceOperation"] = dsrdi.CurrentServiceOperation
	}
	if dsrdi.CurrentServiceOperationStartTimeUtc != nil {
		objectMap["CurrentServiceOperationStartTimeUtc"] = dsrdi.CurrentServiceOperationStartTimeUtc
	}
	if dsrdi.ReportedLoad != nil {
		objectMap["ReportedLoad"] = dsrdi.ReportedLoad
	}
	if dsrdi.ServiceKind != "" {
		objectMap["ServiceKind"] = dsrdi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedServiceReplicaDetailInfo.
func (dsrdi DeployedServiceReplicaDetailInfo) AsDeployedStatefulServiceReplicaDetailInfo() (*DeployedStatefulServiceReplicaDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedServiceReplicaDetailInfo.
func (dsrdi DeployedServiceReplicaDetailInfo) AsDeployedStatelessServiceInstanceDetailInfo() (*DeployedStatelessServiceInstanceDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedServiceReplicaDetailInfo.
func (dsrdi DeployedServiceReplicaDetailInfo) AsDeployedServiceReplicaDetailInfo() (*DeployedServiceReplicaDetailInfo, bool) {
	return &dsrdi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedServiceReplicaDetailInfo.
func (dsrdi DeployedServiceReplicaDetailInfo) AsBasicDeployedServiceReplicaDetailInfo() (BasicDeployedServiceReplicaDetailInfo, bool) {
	return &dsrdi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServiceReplicaDetailInfoModel ...
type DeployedServiceReplicaDetailInfoModel struct {
	autorest.Response `json:"-"`
	Value             BasicDeployedServiceReplicaDetailInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for DeployedServiceReplicaDetailInfoModel struct.
func (dsrdim *DeployedServiceReplicaDetailInfoModel) UnmarshalJSON(body []byte) error {
	dsrdi, err := unmarshalBasicDeployedServiceReplicaDetailInfo(body)
	if err != nil {
		return err
	}
	dsrdim.Value = dsrdi

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicDeployedServiceReplicaInfo information about a Service Fabric service replica deployed on a node.
type BasicDeployedServiceReplicaInfo interface {
	AsDeployedStatefulServiceReplicaInfo() (*DeployedStatefulServiceReplicaInfo, bool)
	AsDeployedStatelessServiceInstanceInfo() (*DeployedStatelessServiceInstanceInfo, bool)
	AsDeployedServiceReplicaInfo() (*DeployedServiceReplicaInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServiceReplicaInfo information about a Service Fabric service replica deployed on a node.
type DeployedServiceReplicaInfo struct {
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// ServiceManifestName - The name of the service manifest in which this service type is defined.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - The name of the code package that hosts this replica.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaStatus - The status of a replica of a service. Possible values are following.
	//   -Invalid - Indicates the replica status is invalid. All Service Fabric enumerations have the invalid type. The value is zero.
	//   -InBuild - The replica is being built. This means that a primary replica is seeding this replica. The value is 1.
	//   -Standby - The replica is in standby. The value is 2.
	//   -Ready - The replica is ready. The value is 3.
	//   -Down - The replica is down. The value is 4.
	//   -Dropped - Replica is dropped. This means that the replica has been removed from the replica set. If it is persisted, its state has been deleted. The value is 5.
	// . Possible values include: 'ReplicaStatusInvalid', 'ReplicaStatusInBuild', 'ReplicaStatusStandby', 'ReplicaStatusReady', 'ReplicaStatusDown', 'ReplicaStatusDropped'
	ReplicaStatus ReplicaStatus `json:"ReplicaStatus,omitempty"`
	// Address - The last address returned by the replica in Open or ChangeRole.
	Address *string `json:"Address,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// HostProcessID - Host process id of the process that is hosting the replica. This will be zero if the replica is down. In hyper-v containers this host process id will be from different kernel.
	HostProcessID *string `json:"HostProcessId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless'
	ServiceKind ServiceKindBasicDeployedServiceReplicaInfo `json:"ServiceKind,omitempty"`
}

func unmarshalBasicDeployedServiceReplicaInfo(body []byte) (BasicDeployedServiceReplicaInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful):
		var dssri DeployedStatefulServiceReplicaInfo
		err := json.Unmarshal(body, &dssri)
		return dssri, err
	case string(ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless):
		var dssii DeployedStatelessServiceInstanceInfo
		err := json.Unmarshal(body, &dssii)
		return dssii, err
	default:
		var dsri DeployedServiceReplicaInfo
		err := json.Unmarshal(body, &dsri)
		return dsri, err
	}
}
func unmarshalBasicDeployedServiceReplicaInfoArray(body []byte) ([]BasicDeployedServiceReplicaInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dsriArray := make([]BasicDeployedServiceReplicaInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsri, err := unmarshalBasicDeployedServiceReplicaInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		dsriArray[index] = dsri
	}
	return dsriArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedServiceReplicaInfo.
func (dsri DeployedServiceReplicaInfo) MarshalJSON() ([]byte, error) {
	dsri.ServiceKind = ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo
	objectMap := make(map[string]interface{})
	if dsri.ServiceName != nil {
		objectMap["ServiceName"] = dsri.ServiceName
	}
	if dsri.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = dsri.ServiceTypeName
	}
	if dsri.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = dsri.ServiceManifestName
	}
	if dsri.CodePackageName != nil {
		objectMap["CodePackageName"] = dsri.CodePackageName
	}
	if dsri.PartitionID != nil {
		objectMap["PartitionId"] = dsri.PartitionID
	}
	if dsri.ReplicaStatus != "" {
		objectMap["ReplicaStatus"] = dsri.ReplicaStatus
	}
	if dsri.Address != nil {
		objectMap["Address"] = dsri.Address
	}
	if dsri.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = dsri.ServicePackageActivationID
	}
	if dsri.HostProcessID != nil {
		objectMap["HostProcessId"] = dsri.HostProcessID
	}
	if dsri.ServiceKind != "" {
		objectMap["ServiceKind"] = dsri.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedServiceReplicaInfo.
func (dsri DeployedServiceReplicaInfo) AsDeployedStatefulServiceReplicaInfo() (*DeployedStatefulServiceReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedServiceReplicaInfo.
func (dsri DeployedServiceReplicaInfo) AsDeployedStatelessServiceInstanceInfo() (*DeployedStatelessServiceInstanceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedServiceReplicaInfo.
func (dsri DeployedServiceReplicaInfo) AsDeployedServiceReplicaInfo() (*DeployedServiceReplicaInfo, bool) {
	return &dsri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedServiceReplicaInfo.
func (dsri DeployedServiceReplicaInfo) AsBasicDeployedServiceReplicaInfo() (BasicDeployedServiceReplicaInfo, bool) {
	return &dsri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedServiceTypeInfo information about service type deployed on a node, information such as the status of the
// service type registration on a node.
type DeployedServiceTypeInfo struct {
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// ServiceManifestName - The name of the service manifest in which this service type is defined.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - The name of the code package that registered the service type.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// Status - The status of the service type registration on the node. Possible values include: 'ServiceTypeRegistrationStatusInvalid', 'ServiceTypeRegistrationStatusDisabled', 'ServiceTypeRegistrationStatusEnabled', 'ServiceTypeRegistrationStatusRegistered'
	Status ServiceTypeRegistrationStatus `json:"Status,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedStatefulServiceReplicaDetailInfo information about a stateful replica running in a code package. Please
// note DeployedServiceReplicaQueryResult will contain duplicate data like ServiceKind, ServiceName, PartitionId
// and replicaId.
type DeployedStatefulServiceReplicaDetailInfo struct {
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// CurrentReplicatorOperation - Specifies the operation currently being executed by the Replicator. Possible values include: 'ReplicatorOperationNameInvalid', 'ReplicatorOperationNameNone', 'ReplicatorOperationNameOpen', 'ReplicatorOperationNameChangeRole', 'ReplicatorOperationNameUpdateEpoch', 'ReplicatorOperationNameClose', 'ReplicatorOperationNameAbort', 'ReplicatorOperationNameOnDataLoss', 'ReplicatorOperationNameWaitForCatchup', 'ReplicatorOperationNameBuild'
	CurrentReplicatorOperation ReplicatorOperationName `json:"CurrentReplicatorOperation,omitempty"`
	// ReadStatus - Specifies the access status of the partition. Possible values include: 'PartitionAccessStatusInvalid', 'PartitionAccessStatusGranted', 'PartitionAccessStatusReconfigurationPending', 'PartitionAccessStatusNotPrimary', 'PartitionAccessStatusNoWriteQuorum'
	ReadStatus PartitionAccessStatus `json:"ReadStatus,omitempty"`
	// WriteStatus - Specifies the access status of the partition. Possible values include: 'PartitionAccessStatusInvalid', 'PartitionAccessStatusGranted', 'PartitionAccessStatusReconfigurationPending', 'PartitionAccessStatusNotPrimary', 'PartitionAccessStatusNoWriteQuorum'
	WriteStatus PartitionAccessStatus `json:"WriteStatus,omitempty"`
	// ReplicatorStatus - Represents a base class for primary or secondary replicator status.
	// Contains information about the service fabric replicator like the replication/copy queue utilization, last acknowledgement received timestamp, etc.
	ReplicatorStatus BasicReplicatorStatus `json:"ReplicatorStatus,omitempty"`
	// ReplicaStatus - Key value store related information for the replica.
	ReplicaStatus *KeyValueStoreReplicaStatus `json:"ReplicaStatus,omitempty"`
	// DeployedServiceReplicaQueryResult - Information about a stateful service replica deployed on a node.
	DeployedServiceReplicaQueryResult *DeployedStatefulServiceReplicaInfo `json:"DeployedServiceReplicaQueryResult,omitempty"`
	// ServiceName - Full hierarchical name of the service in URI format starting with `fabric:`.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// CurrentServiceOperation - Specifies the current active life-cycle operation on a stateful service replica or stateless service instance. Possible values include: 'ServiceOperationNameUnknown', 'ServiceOperationNameNone', 'ServiceOperationNameOpen', 'ServiceOperationNameChangeRole', 'ServiceOperationNameClose', 'ServiceOperationNameAbort'
	CurrentServiceOperation ServiceOperationName `json:"CurrentServiceOperation,omitempty"`
	// CurrentServiceOperationStartTimeUtc - The start time of the current service operation in UTC format.
	CurrentServiceOperationStartTimeUtc *date.Time `json:"CurrentServiceOperationStartTimeUtc,omitempty"`
	// ReportedLoad - List of load reported by replica.
	ReportedLoad *[]LoadMetricReportInfo `json:"ReportedLoad,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindDeployedServiceReplicaDetailInfo', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicDeployedServiceReplicaDetailInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedStatefulServiceReplicaDetailInfo.
func (dssrdi DeployedStatefulServiceReplicaDetailInfo) MarshalJSON() ([]byte, error) {
	dssrdi.ServiceKind = ServiceKindStateful1
	objectMap := make(map[string]interface{})
	if dssrdi.ReplicaID != nil {
		objectMap["ReplicaId"] = dssrdi.ReplicaID
	}
	if dssrdi.CurrentReplicatorOperation != "" {
		objectMap["CurrentReplicatorOperation"] = dssrdi.CurrentReplicatorOperation
	}
	if dssrdi.ReadStatus != "" {
		objectMap["ReadStatus"] = dssrdi.ReadStatus
	}
	if dssrdi.WriteStatus != "" {
		objectMap["WriteStatus"] = dssrdi.WriteStatus
	}
	objectMap["ReplicatorStatus"] = dssrdi.ReplicatorStatus
	if dssrdi.ReplicaStatus != nil {
		objectMap["ReplicaStatus"] = dssrdi.ReplicaStatus
	}
	if dssrdi.DeployedServiceReplicaQueryResult != nil {
		objectMap["DeployedServiceReplicaQueryResult"] = dssrdi.DeployedServiceReplicaQueryResult
	}
	if dssrdi.ServiceName != nil {
		objectMap["ServiceName"] = dssrdi.ServiceName
	}
	if dssrdi.PartitionID != nil {
		objectMap["PartitionId"] = dssrdi.PartitionID
	}
	if dssrdi.CurrentServiceOperation != "" {
		objectMap["CurrentServiceOperation"] = dssrdi.CurrentServiceOperation
	}
	if dssrdi.CurrentServiceOperationStartTimeUtc != nil {
		objectMap["CurrentServiceOperationStartTimeUtc"] = dssrdi.CurrentServiceOperationStartTimeUtc
	}
	if dssrdi.ReportedLoad != nil {
		objectMap["ReportedLoad"] = dssrdi.ReportedLoad
	}
	if dssrdi.ServiceKind != "" {
		objectMap["ServiceKind"] = dssrdi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatefulServiceReplicaDetailInfo.
func (dssrdi DeployedStatefulServiceReplicaDetailInfo) AsDeployedStatefulServiceReplicaDetailInfo() (*DeployedStatefulServiceReplicaDetailInfo, bool) {
	return &dssrdi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatefulServiceReplicaDetailInfo.
func (dssrdi DeployedStatefulServiceReplicaDetailInfo) AsDeployedStatelessServiceInstanceDetailInfo() (*DeployedStatelessServiceInstanceDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatefulServiceReplicaDetailInfo.
func (dssrdi DeployedStatefulServiceReplicaDetailInfo) AsDeployedServiceReplicaDetailInfo() (*DeployedServiceReplicaDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatefulServiceReplicaDetailInfo.
func (dssrdi DeployedStatefulServiceReplicaDetailInfo) AsBasicDeployedServiceReplicaDetailInfo() (BasicDeployedServiceReplicaDetailInfo, bool) {
	return &dssrdi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for DeployedStatefulServiceReplicaDetailInfo struct.
func (dssrdi *DeployedStatefulServiceReplicaDetailInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ReplicaId":
			if v != nil {
				var replicaID string
				err = json.Unmarshal(*v, &replicaID)
				if err != nil {
					return err
				}
				dssrdi.ReplicaID = &replicaID
			}
		case "CurrentReplicatorOperation":
			if v != nil {
				var currentReplicatorOperation ReplicatorOperationName
				err = json.Unmarshal(*v, &currentReplicatorOperation)
				if err != nil {
					return err
				}
				dssrdi.CurrentReplicatorOperation = currentReplicatorOperation
			}
		case "ReadStatus":
			if v != nil {
				var readStatus PartitionAccessStatus
				err = json.Unmarshal(*v, &readStatus)
				if err != nil {
					return err
				}
				dssrdi.ReadStatus = readStatus
			}
		case "WriteStatus":
			if v != nil {
				var writeStatus PartitionAccessStatus
				err = json.Unmarshal(*v, &writeStatus)
				if err != nil {
					return err
				}
				dssrdi.WriteStatus = writeStatus
			}
		case "ReplicatorStatus":
			if v != nil {
				replicatorStatus, err := unmarshalBasicReplicatorStatus(*v)
				if err != nil {
					return err
				}
				dssrdi.ReplicatorStatus = replicatorStatus
			}
		case "ReplicaStatus":
			if v != nil {
				var replicaStatus KeyValueStoreReplicaStatus
				err = json.Unmarshal(*v, &replicaStatus)
				if err != nil {
					return err
				}
				dssrdi.ReplicaStatus = &replicaStatus
			}
		case "DeployedServiceReplicaQueryResult":
			if v != nil {
				var deployedServiceReplicaQueryResult DeployedStatefulServiceReplicaInfo
				err = json.Unmarshal(*v, &deployedServiceReplicaQueryResult)
				if err != nil {
					return err
				}
				dssrdi.DeployedServiceReplicaQueryResult = &deployedServiceReplicaQueryResult
			}
		case "ServiceName":
			if v != nil {
				var serviceName string
				err = json.Unmarshal(*v, &serviceName)
				if err != nil {
					return err
				}
				dssrdi.ServiceName = &serviceName
			}
		case "PartitionId":
			if v != nil {
				var partitionID uuid.UUID
				err = json.Unmarshal(*v, &partitionID)
				if err != nil {
					return err
				}
				dssrdi.PartitionID = &partitionID
			}
		case "CurrentServiceOperation":
			if v != nil {
				var currentServiceOperation ServiceOperationName
				err = json.Unmarshal(*v, &currentServiceOperation)
				if err != nil {
					return err
				}
				dssrdi.CurrentServiceOperation = currentServiceOperation
			}
		case "CurrentServiceOperationStartTimeUtc":
			if v != nil {
				var currentServiceOperationStartTimeUtc date.Time
				err = json.Unmarshal(*v, &currentServiceOperationStartTimeUtc)
				if err != nil {
					return err
				}
				dssrdi.CurrentServiceOperationStartTimeUtc = &currentServiceOperationStartTimeUtc
			}
		case "ReportedLoad":
			if v != nil {
				var reportedLoad []LoadMetricReportInfo
				err = json.Unmarshal(*v, &reportedLoad)
				if err != nil {
					return err
				}
				dssrdi.ReportedLoad = &reportedLoad
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicDeployedServiceReplicaDetailInfo
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				dssrdi.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedStatefulServiceReplicaInfo information about a stateful service replica deployed on a node.
type DeployedStatefulServiceReplicaInfo struct {
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// ReplicaRole - The role of a replica of a stateful service. Possible values include: 'ReplicaRoleUnknown', 'ReplicaRoleNone', 'ReplicaRolePrimary', 'ReplicaRoleIdleSecondary', 'ReplicaRoleActiveSecondary'
	ReplicaRole ReplicaRole `json:"ReplicaRole,omitempty"`
	// ReconfigurationInformation - Information about current reconfiguration like phase, type, previous configuration role of replica and reconfiguration start date time.
	ReconfigurationInformation *ReconfigurationInformation `json:"ReconfigurationInformation,omitempty"`
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// ServiceManifestName - The name of the service manifest in which this service type is defined.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - The name of the code package that hosts this replica.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaStatus - The status of a replica of a service. Possible values are following.
	//   -Invalid - Indicates the replica status is invalid. All Service Fabric enumerations have the invalid type. The value is zero.
	//   -InBuild - The replica is being built. This means that a primary replica is seeding this replica. The value is 1.
	//   -Standby - The replica is in standby. The value is 2.
	//   -Ready - The replica is ready. The value is 3.
	//   -Down - The replica is down. The value is 4.
	//   -Dropped - Replica is dropped. This means that the replica has been removed from the replica set. If it is persisted, its state has been deleted. The value is 5.
	// . Possible values include: 'ReplicaStatusInvalid', 'ReplicaStatusInBuild', 'ReplicaStatusStandby', 'ReplicaStatusReady', 'ReplicaStatusDown', 'ReplicaStatusDropped'
	ReplicaStatus ReplicaStatus `json:"ReplicaStatus,omitempty"`
	// Address - The last address returned by the replica in Open or ChangeRole.
	Address *string `json:"Address,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// HostProcessID - Host process id of the process that is hosting the replica. This will be zero if the replica is down. In hyper-v containers this host process id will be from different kernel.
	HostProcessID *string `json:"HostProcessId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless'
	ServiceKind ServiceKindBasicDeployedServiceReplicaInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedStatefulServiceReplicaInfo.
func (dssri DeployedStatefulServiceReplicaInfo) MarshalJSON() ([]byte, error) {
	dssri.ServiceKind = ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful
	objectMap := make(map[string]interface{})
	if dssri.ReplicaID != nil {
		objectMap["ReplicaId"] = dssri.ReplicaID
	}
	if dssri.ReplicaRole != "" {
		objectMap["ReplicaRole"] = dssri.ReplicaRole
	}
	if dssri.ReconfigurationInformation != nil {
		objectMap["ReconfigurationInformation"] = dssri.ReconfigurationInformation
	}
	if dssri.ServiceName != nil {
		objectMap["ServiceName"] = dssri.ServiceName
	}
	if dssri.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = dssri.ServiceTypeName
	}
	if dssri.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = dssri.ServiceManifestName
	}
	if dssri.CodePackageName != nil {
		objectMap["CodePackageName"] = dssri.CodePackageName
	}
	if dssri.PartitionID != nil {
		objectMap["PartitionId"] = dssri.PartitionID
	}
	if dssri.ReplicaStatus != "" {
		objectMap["ReplicaStatus"] = dssri.ReplicaStatus
	}
	if dssri.Address != nil {
		objectMap["Address"] = dssri.Address
	}
	if dssri.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = dssri.ServicePackageActivationID
	}
	if dssri.HostProcessID != nil {
		objectMap["HostProcessId"] = dssri.HostProcessID
	}
	if dssri.ServiceKind != "" {
		objectMap["ServiceKind"] = dssri.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatefulServiceReplicaInfo.
func (dssri DeployedStatefulServiceReplicaInfo) AsDeployedStatefulServiceReplicaInfo() (*DeployedStatefulServiceReplicaInfo, bool) {
	return &dssri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatefulServiceReplicaInfo.
func (dssri DeployedStatefulServiceReplicaInfo) AsDeployedStatelessServiceInstanceInfo() (*DeployedStatelessServiceInstanceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatefulServiceReplicaInfo.
func (dssri DeployedStatefulServiceReplicaInfo) AsDeployedServiceReplicaInfo() (*DeployedServiceReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatefulServiceReplicaInfo.
func (dssri DeployedStatefulServiceReplicaInfo) AsBasicDeployedServiceReplicaInfo() (BasicDeployedServiceReplicaInfo, bool) {
	return &dssri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedStatelessServiceInstanceDetailInfo information about a stateless instance running in a code package.
// Please note that DeployedServiceReplicaQueryResult will contain duplicate data like ServiceKind, ServiceName,
// PartitionId and InstanceId.
type DeployedStatelessServiceInstanceDetailInfo struct {
	// InstanceID - Id of a stateless service instance. InstanceId is used by Service Fabric to uniquely identify an instance of a partition of a stateless service. It is unique within a partition and does not change for the lifetime of the instance. If the instance has failed over on the same or different node, it will get a different value for the InstanceId.
	InstanceID *string `json:"InstanceId,omitempty"`
	// DeployedServiceReplicaQueryResult - Information about a stateless service instance deployed on a node.
	DeployedServiceReplicaQueryResult *DeployedStatelessServiceInstanceInfo `json:"DeployedServiceReplicaQueryResult,omitempty"`
	// ServiceName - Full hierarchical name of the service in URI format starting with `fabric:`.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// CurrentServiceOperation - Specifies the current active life-cycle operation on a stateful service replica or stateless service instance. Possible values include: 'ServiceOperationNameUnknown', 'ServiceOperationNameNone', 'ServiceOperationNameOpen', 'ServiceOperationNameChangeRole', 'ServiceOperationNameClose', 'ServiceOperationNameAbort'
	CurrentServiceOperation ServiceOperationName `json:"CurrentServiceOperation,omitempty"`
	// CurrentServiceOperationStartTimeUtc - The start time of the current service operation in UTC format.
	CurrentServiceOperationStartTimeUtc *date.Time `json:"CurrentServiceOperationStartTimeUtc,omitempty"`
	// ReportedLoad - List of load reported by replica.
	ReportedLoad *[]LoadMetricReportInfo `json:"ReportedLoad,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindDeployedServiceReplicaDetailInfo', 'ServiceKindStateful1', 'ServiceKindStateless1'
	ServiceKind ServiceKindBasicDeployedServiceReplicaDetailInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedStatelessServiceInstanceDetailInfo.
func (dssidi DeployedStatelessServiceInstanceDetailInfo) MarshalJSON() ([]byte, error) {
	dssidi.ServiceKind = ServiceKindStateless1
	objectMap := make(map[string]interface{})
	if dssidi.InstanceID != nil {
		objectMap["InstanceId"] = dssidi.InstanceID
	}
	if dssidi.DeployedServiceReplicaQueryResult != nil {
		objectMap["DeployedServiceReplicaQueryResult"] = dssidi.DeployedServiceReplicaQueryResult
	}
	if dssidi.ServiceName != nil {
		objectMap["ServiceName"] = dssidi.ServiceName
	}
	if dssidi.PartitionID != nil {
		objectMap["PartitionId"] = dssidi.PartitionID
	}
	if dssidi.CurrentServiceOperation != "" {
		objectMap["CurrentServiceOperation"] = dssidi.CurrentServiceOperation
	}
	if dssidi.CurrentServiceOperationStartTimeUtc != nil {
		objectMap["CurrentServiceOperationStartTimeUtc"] = dssidi.CurrentServiceOperationStartTimeUtc
	}
	if dssidi.ReportedLoad != nil {
		objectMap["ReportedLoad"] = dssidi.ReportedLoad
	}
	if dssidi.ServiceKind != "" {
		objectMap["ServiceKind"] = dssidi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatelessServiceInstanceDetailInfo.
func (dssidi DeployedStatelessServiceInstanceDetailInfo) AsDeployedStatefulServiceReplicaDetailInfo() (*DeployedStatefulServiceReplicaDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatelessServiceInstanceDetailInfo.
func (dssidi DeployedStatelessServiceInstanceDetailInfo) AsDeployedStatelessServiceInstanceDetailInfo() (*DeployedStatelessServiceInstanceDetailInfo, bool) {
	return &dssidi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatelessServiceInstanceDetailInfo.
func (dssidi DeployedStatelessServiceInstanceDetailInfo) AsDeployedServiceReplicaDetailInfo() (*DeployedServiceReplicaDetailInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaDetailInfo is the BasicDeployedServiceReplicaDetailInfo implementation for DeployedStatelessServiceInstanceDetailInfo.
func (dssidi DeployedStatelessServiceInstanceDetailInfo) AsBasicDeployedServiceReplicaDetailInfo() (BasicDeployedServiceReplicaDetailInfo, bool) {
	return &dssidi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployedStatelessServiceInstanceInfo information about a stateless service instance deployed on a node.
type DeployedStatelessServiceInstanceInfo struct {
	// InstanceID - Id of a stateless service instance. InstanceId is used by Service Fabric to uniquely identify an instance of a partition of a stateless service. It is unique within a partition and does not change for the lifetime of the instance. If the instance has failed over on the same or different node, it will get a different value for the InstanceId.
	InstanceID *string `json:"InstanceId,omitempty"`
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// ServiceManifestName - The name of the service manifest in which this service type is defined.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - The name of the code package that hosts this replica.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaStatus - The status of a replica of a service. Possible values are following.
	//   -Invalid - Indicates the replica status is invalid. All Service Fabric enumerations have the invalid type. The value is zero.
	//   -InBuild - The replica is being built. This means that a primary replica is seeding this replica. The value is 1.
	//   -Standby - The replica is in standby. The value is 2.
	//   -Ready - The replica is ready. The value is 3.
	//   -Down - The replica is down. The value is 4.
	//   -Dropped - Replica is dropped. This means that the replica has been removed from the replica set. If it is persisted, its state has been deleted. The value is 5.
	// . Possible values include: 'ReplicaStatusInvalid', 'ReplicaStatusInBuild', 'ReplicaStatusStandby', 'ReplicaStatusReady', 'ReplicaStatusDown', 'ReplicaStatusDropped'
	ReplicaStatus ReplicaStatus `json:"ReplicaStatus,omitempty"`
	// Address - The last address returned by the replica in Open or ChangeRole.
	Address *string `json:"Address,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// HostProcessID - Host process id of the process that is hosting the replica. This will be zero if the replica is down. In hyper-v containers this host process id will be from different kernel.
	HostProcessID *string `json:"HostProcessId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful', 'ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless'
	ServiceKind ServiceKindBasicDeployedServiceReplicaInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DeployedStatelessServiceInstanceInfo.
func (dssii DeployedStatelessServiceInstanceInfo) MarshalJSON() ([]byte, error) {
	dssii.ServiceKind = ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless
	objectMap := make(map[string]interface{})
	if dssii.InstanceID != nil {
		objectMap["InstanceId"] = dssii.InstanceID
	}
	if dssii.ServiceName != nil {
		objectMap["ServiceName"] = dssii.ServiceName
	}
	if dssii.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = dssii.ServiceTypeName
	}
	if dssii.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = dssii.ServiceManifestName
	}
	if dssii.CodePackageName != nil {
		objectMap["CodePackageName"] = dssii.CodePackageName
	}
	if dssii.PartitionID != nil {
		objectMap["PartitionId"] = dssii.PartitionID
	}
	if dssii.ReplicaStatus != "" {
		objectMap["ReplicaStatus"] = dssii.ReplicaStatus
	}
	if dssii.Address != nil {
		objectMap["Address"] = dssii.Address
	}
	if dssii.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = dssii.ServicePackageActivationID
	}
	if dssii.HostProcessID != nil {
		objectMap["HostProcessId"] = dssii.HostProcessID
	}
	if dssii.ServiceKind != "" {
		objectMap["ServiceKind"] = dssii.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatefulServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatelessServiceInstanceInfo.
func (dssii DeployedStatelessServiceInstanceInfo) AsDeployedStatefulServiceReplicaInfo() (*DeployedStatefulServiceReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedStatelessServiceInstanceInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatelessServiceInstanceInfo.
func (dssii DeployedStatelessServiceInstanceInfo) AsDeployedStatelessServiceInstanceInfo() (*DeployedStatelessServiceInstanceInfo, bool) {
	return &dssii, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatelessServiceInstanceInfo.
func (dssii DeployedStatelessServiceInstanceInfo) AsDeployedServiceReplicaInfo() (*DeployedServiceReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicDeployedServiceReplicaInfo is the BasicDeployedServiceReplicaInfo implementation for DeployedStatelessServiceInstanceInfo.
func (dssii DeployedStatelessServiceInstanceInfo) AsBasicDeployedServiceReplicaInfo() (BasicDeployedServiceReplicaInfo, bool) {
	return &dssii, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DeployServicePackageToNodeDescription defines description for downloading packages associated with a service
// manifest to image cache on a Service Fabric node.
type DeployServicePackageToNodeDescription struct {
	// ServiceManifestName - The name of service manifest whose packages need to be downloaded.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - The version of the application type as defined in the application manifest.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// PackageSharingPolicy - List of package sharing policy information.
	PackageSharingPolicy *[]PackageSharingPolicyInfo `json:"PackageSharingPolicy,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// DoublePropertyValue describes a Service Fabric property value of type Double.
type DoublePropertyValue struct {
	// Data - The data of the property value.
	Data *float64 `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for DoublePropertyValue.
func (dpv DoublePropertyValue) MarshalJSON() ([]byte, error) {
	dpv.Kind = KindDouble
	objectMap := make(map[string]interface{})
	if dpv.Data != nil {
		objectMap["Data"] = dpv.Data
	}
	if dpv.Kind != "" {
		objectMap["Kind"] = dpv.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBinaryPropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64PropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDoublePropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return &dpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStringPropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGUIDPropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyValue is the BasicPropertyValue implementation for DoublePropertyValue.
func (dpv DoublePropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &dpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EnsureAvailabilitySafetyCheck safety check that waits to ensure the availability of the partition. It waits
// until there are replicas available such that bringing down this replica will not cause availability loss for the
// partition.
type EnsureAvailabilitySafetyCheck struct {
	// PartitionID - Id of the partition which is undergoing the safety check.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// Kind - Possible values include: 'KindSafetyCheck', 'KindPartitionSafetyCheck', 'KindEnsureAvailability', 'KindEnsurePartitionQuorum', 'KindEnsureSeedNodeQuorum', 'KindWaitForInbuildReplica', 'KindWaitForPrimaryPlacement', 'KindWaitForPrimarySwap', 'KindWaitForReconfiguration'
	Kind KindBasicSafetyCheck `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) MarshalJSON() ([]byte, error) {
	easc.Kind = KindEnsureAvailability
	objectMap := make(map[string]interface{})
	if easc.PartitionID != nil {
		objectMap["PartitionId"] = easc.PartitionID
	}
	if easc.Kind != "" {
		objectMap["Kind"] = easc.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool) {
	return &easc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsureAvailabilitySafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool) {
	return &easc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsurePartitionQurumSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSeedNodeSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForInbuildReplicaSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimaryPlacementSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimarySwapSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForReconfigurationSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsSafetyCheck() (*SafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSafetyCheck is the BasicSafetyCheck implementation for EnsureAvailabilitySafetyCheck.
func (easc EnsureAvailabilitySafetyCheck) AsBasicSafetyCheck() (BasicSafetyCheck, bool) {
	return &easc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EnsurePartitionQurumSafetyCheck safety check that ensures that a quorum of replicas are not lost for a
// partition.
type EnsurePartitionQurumSafetyCheck struct {
	// PartitionID - Id of the partition which is undergoing the safety check.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// Kind - Possible values include: 'KindSafetyCheck', 'KindPartitionSafetyCheck', 'KindEnsureAvailability', 'KindEnsurePartitionQuorum', 'KindEnsureSeedNodeQuorum', 'KindWaitForInbuildReplica', 'KindWaitForPrimaryPlacement', 'KindWaitForPrimarySwap', 'KindWaitForReconfiguration'
	Kind KindBasicSafetyCheck `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) MarshalJSON() ([]byte, error) {
	epqsc.Kind = KindEnsurePartitionQuorum
	objectMap := make(map[string]interface{})
	if epqsc.PartitionID != nil {
		objectMap["PartitionId"] = epqsc.PartitionID
	}
	if epqsc.Kind != "" {
		objectMap["Kind"] = epqsc.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool) {
	return &epqsc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsureAvailabilitySafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsurePartitionQurumSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool) {
	return &epqsc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSeedNodeSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForInbuildReplicaSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimaryPlacementSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimarySwapSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForReconfigurationSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsSafetyCheck() (*SafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSafetyCheck is the BasicSafetyCheck implementation for EnsurePartitionQurumSafetyCheck.
func (epqsc EnsurePartitionQurumSafetyCheck) AsBasicSafetyCheck() (BasicSafetyCheck, bool) {
	return &epqsc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityHealth health information common to all entities in the cluster. It contains the aggregated health state,
// health events and unhealthy evaluation.
type EntityHealth struct {
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityHealthState a base type for the health state of various entities in the cluster. It contains the
// aggregated health state.
type EntityHealthState struct {
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityHealthStateChunk a base type for the health state chunk of various entities in the cluster. It contains
// the aggregated health state.
type EntityHealthStateChunk struct {
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityHealthStateChunkList a base type for the list of health state chunks found in the cluster. It contains the
// total number of health states that match the input filters.
type EntityHealthStateChunkList struct {
	// TotalCount - Total number of entity health state objects that match the specified filters from the cluster health chunk query description.
	TotalCount *int64 `json:"TotalCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EntityKindHealthStateCount represents health state count for entities of the specified entity kind.
type EntityKindHealthStateCount struct {
	// EntityKind - The entity kind for which health states are evaluated. Possible values include: 'EntityKindInvalid', 'EntityKindNode', 'EntityKindPartition', 'EntityKindService', 'EntityKindApplication', 'EntityKindReplica', 'EntityKindDeployedApplication', 'EntityKindDeployedServicePackage', 'EntityKindCluster'
	EntityKind EntityKind `json:"EntityKind,omitempty"`
	// HealthStateCount - The health state count for the entities of the specified kind.
	HealthStateCount *HealthStateCount `json:"HealthStateCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Epoch an Epoch is a configuration number for the partition as a whole. When the configuration of the replica set
// changes, for example when the Primary replica changes, the operations that are replicated from the new Primary
// replica are said to be a new Epoch from the ones which were sent by the old Primary replica.
type Epoch struct {
	// ConfigurationVersion - The current configuration number of this Epoch. The configuration number is an increasing value that is updated whenever the configuration of this replica set changes.
	ConfigurationVersion *string `json:"ConfigurationVersion,omitempty"`
	// DataLossVersion - The current dataloss number of this Epoch. The data loss number property is an increasing value which is updated whenever data loss is suspected, as when loss of a quorum of replicas in the replica set that includes the Primary replica.
	DataLossVersion *string `json:"DataLossVersion,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// EventHealthEvaluation represents health evaluation of a HealthEvent that was reported on the entity.
// The health evaluation is returned when evaluating health of an entity results in Error or Warning.
type EventHealthEvaluation struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors. The field is specified in the health policy used to evaluate the entity.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// UnhealthyEvent - Represents health information reported on a health entity, such as cluster, application or node, with additional metadata added by the Health Manager.
	UnhealthyEvent *HealthEvent `json:"UnhealthyEvent,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for EventHealthEvaluation.
func (ehe EventHealthEvaluation) MarshalJSON() ([]byte, error) {
	ehe.Kind = KindEvent
	objectMap := make(map[string]interface{})
	if ehe.ConsiderWarningAsError != nil {
		objectMap["ConsiderWarningAsError"] = ehe.ConsiderWarningAsError
	}
	if ehe.UnhealthyEvent != nil {
		objectMap["UnhealthyEvent"] = ehe.UnhealthyEvent
	}
	if ehe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ehe.AggregatedHealthState
	}
	if ehe.Description != nil {
		objectMap["Description"] = ehe.Description
	}
	if ehe.Kind != "" {
		objectMap["Kind"] = ehe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return &ehe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for EventHealthEvaluation.
func (ehe EventHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ehe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ExecutingFaultsChaosEvent describes a Chaos event that gets generated when Chaos has decided on the faults for
// an iteration. This Chaos event contains the details of the faults as a list of strings.
type ExecutingFaultsChaosEvent struct {
	// Faults - List of string description of the faults that Chaos decided to execute in an iteration.
	Faults *[]string `json:"Faults,omitempty"`
	// TimeStampUtc - The UTC timestamp when this Chaos event was generated.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// Kind - Possible values include: 'KindChaosEvent', 'KindExecutingFaults', 'KindStarted', 'KindStopped', 'KindTestError', 'KindValidationFailed', 'KindWaiting'
	Kind KindBasicChaosEvent `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) MarshalJSON() ([]byte, error) {
	efce.Kind = KindExecutingFaults
	objectMap := make(map[string]interface{})
	if efce.Faults != nil {
		objectMap["Faults"] = efce.Faults
	}
	if efce.TimeStampUtc != nil {
		objectMap["TimeStampUtc"] = efce.TimeStampUtc
	}
	if efce.Kind != "" {
		objectMap["Kind"] = efce.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExecutingFaultsChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool) {
	return &efce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStartedChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsStartedChaosEvent() (*StartedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStoppedChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsStoppedChaosEvent() (*StoppedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsTestErrorChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsValidationFailedChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitingChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsWaitingChaosEvent() (*WaitingChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsChaosEvent() (*ChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicChaosEvent is the BasicChaosEvent implementation for ExecutingFaultsChaosEvent.
func (efce ExecutingFaultsChaosEvent) AsBasicChaosEvent() (BasicChaosEvent, bool) {
	return &efce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ExternalStoreProvisionApplicationTypeDescription describes the operation to register or provision an application
// type using an application package from an external store instead of a package uploaded to the Service Fabric
// image store.
type ExternalStoreProvisionApplicationTypeDescription struct {
	// ApplicationPackageDownloadURI - The path to the '.sfpkg' application package from where the application package can be downloaded using HTTP or HTTPS protocols. The application package can be stored in an external store that provides GET operation to download the file. Supported protocols are HTTP and HTTPS, and the path must allow READ access.
	ApplicationPackageDownloadURI *string `json:"ApplicationPackageDownloadUri,omitempty"`
	// ApplicationTypeName - The application type name represents the name of the application type found in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - The application type version represents the version of the application type found in the application manifest.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// Async - Indicates whether or not provisioning should occur asynchronously. When set to true, the provision operation returns when the request is accepted by the system, and the provision operation continues without any timeout limit. The default value is false. For large application packages, we recommend setting the value to true.
	Async *bool `json:"Async,omitempty"`
	// Kind - Possible values include: 'KindProvisionApplicationTypeDescriptionBase', 'KindImageStorePath', 'KindExternalStore'
	Kind KindBasicProvisionApplicationTypeDescriptionBase `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ExternalStoreProvisionApplicationTypeDescription.
func (espatd ExternalStoreProvisionApplicationTypeDescription) MarshalJSON() ([]byte, error) {
	espatd.Kind = KindExternalStore
	objectMap := make(map[string]interface{})
	if espatd.ApplicationPackageDownloadURI != nil {
		objectMap["ApplicationPackageDownloadUri"] = espatd.ApplicationPackageDownloadURI
	}
	if espatd.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = espatd.ApplicationTypeName
	}
	if espatd.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = espatd.ApplicationTypeVersion
	}
	if espatd.Async != nil {
		objectMap["Async"] = espatd.Async
	}
	if espatd.Kind != "" {
		objectMap["Kind"] = espatd.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ExternalStoreProvisionApplicationTypeDescription.
func (espatd ExternalStoreProvisionApplicationTypeDescription) AsProvisionApplicationTypeDescription() (*ProvisionApplicationTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExternalStoreProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ExternalStoreProvisionApplicationTypeDescription.
func (espatd ExternalStoreProvisionApplicationTypeDescription) AsExternalStoreProvisionApplicationTypeDescription() (*ExternalStoreProvisionApplicationTypeDescription, bool) {
	return &espatd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ExternalStoreProvisionApplicationTypeDescription.
func (espatd ExternalStoreProvisionApplicationTypeDescription) AsProvisionApplicationTypeDescriptionBase() (*ProvisionApplicationTypeDescriptionBase, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ExternalStoreProvisionApplicationTypeDescription.
func (espatd ExternalStoreProvisionApplicationTypeDescription) AsBasicProvisionApplicationTypeDescriptionBase() (BasicProvisionApplicationTypeDescriptionBase, bool) {
	return &espatd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FabricCodeVersionInfo information about a Service Fabric code version.
type FabricCodeVersionInfo struct {
	// CodeVersion - The product version of Service Fabric.
	CodeVersion *string `json:"CodeVersion,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FabricConfigVersionInfo information about a Service Fabric config version.
type FabricConfigVersionInfo struct {
	// ConfigVersion - The config version of Service Fabric.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FabricError the REST API operations for Service Fabric return standard HTTP status codes. This type defines the
// additional information returned from the Service Fabric API operations that are not successful.
type FabricError struct {
	// Error - Error object containing error code and error message.
	Error *FabricErrorError `json:"Error,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FabricErrorError error object containing error code and error message.
type FabricErrorError struct {
	// Code - Defines the fabric error codes that be returned as part of the error object in response to Service Fabric API operations that are not successful. Following are the error code values that can be returned for a specific HTTP status code.
	//   - Possible values of the error code for HTTP status code 400 (Bad Request)
	//     - "FABRIC_E_INVALID_PARTITION_KEY"
	//     - "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
	//     - "FABRIC_E_INVALID_ADDRESS"
	//     - "FABRIC_E_APPLICATION_NOT_UPGRADING"
	//     - "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
	//     - "FABRIC_E_FABRIC_NOT_UPGRADING"
	//     - "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
	//     - "FABRIC_E_INVALID_CONFIGURATION"
	//     - "FABRIC_E_INVALID_NAME_URI"
	//     - "FABRIC_E_PATH_TOO_LONG"
	//     - "FABRIC_E_KEY_TOO_LARGE"
	//     - "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
	//     - "FABRIC_E_INVALID_ATOMIC_GROUP"
	//     - "FABRIC_E_VALUE_EMPTY"
	//   - Possible values of the error code for HTTP status code 404 (Not Found)
	//     - "FABRIC_E_NODE_NOT_FOUND"
	//     - "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
	//     - "FABRIC_E_APPLICATION_NOT_FOUND"
	//     - "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
	//     - "FABRIC_E_SERVICE_DOES_NOT_EXIST"
	//     - "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
	//     - "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
	//     - "FABRIC_E_PARTITION_NOT_FOUND"
	//     - "FABRIC_E_REPLICA_DOES_NOT_EXIST"
	//     - "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
	//     - "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
	//     - "FABRIC_E_DIRECTORY_NOT_FOUND"
	//     - "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
	//     - "FABRIC_E_FILE_NOT_FOUND"
	//     - "FABRIC_E_NAME_DOES_NOT_EXIST"
	//     - "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
	//     - "FABRIC_E_ENUMERATION_COMPLETED"
	//     - "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
	//     - "FABRIC_E_KEY_NOT_FOUND"
	//     - "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
	//   - Possible values of the error code for HTTP status code 409 (Conflict)
	//     - "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
	//     - "FABRIC_E_APPLICATION_ALREADY_EXISTS"
	//     - "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
	//     - "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
	//     - "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
	//     - "FABRIC_E_SERVICE_ALREADY_EXISTS"
	//     - "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
	//     - "FABRIC_E_APPLICATION_TYPE_IN_USE"
	//     - "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
	//     - "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
	//     - "FABRIC_E_FABRIC_VERSION_IN_USE"
	//     - "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
	//     - "FABRIC_E_NAME_ALREADY_EXISTS"
	//     - "FABRIC_E_NAME_NOT_EMPTY"
	//     - "FABRIC_E_PROPERTY_CHECK_FAILED"
	//     - "FABRIC_E_SERVICE_METADATA_MISMATCH"
	//     - "FABRIC_E_SERVICE_TYPE_MISMATCH"
	//     - "FABRIC_E_HEALTH_STALE_REPORT"
	//     - "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
	//     - "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
	//     - "FABRIC_E_INSTANCE_ID_MISMATCH"
	//   - Possible values of the error code for HTTP status code 413 (Request Entity Too Large)
	//     - "FABRIC_E_VALUE_TOO_LARGE"
	//   - Possible values of the error code for HTTP status code 500 (Internal Server Error)
	//     - "FABRIC_E_NODE_IS_UP"
	//   - Possible values of the error code for HTTP status code 503 (Service Unavailable)
	//     - "FABRIC_E_NO_WRITE_QUORUM"
	//     - "FABRIC_E_NOT_PRIMARY"
	//     - "FABRIC_E_NOT_READY"
	//     - "FABRIC_E_RECONFIGURATION_PENDING"
	//     - "FABRIC_E_SERVICE_OFFLINE"
	//     - "E_ABORT"
	//     - "FABRIC_E_VALUE_TOO_LARGE"
	//   - Possible values of the error code for HTTP status code 504 (Gateway Timeout)
	//     - "FABRIC_E_COMMUNICATION_ERROR"
	//     - "FABRIC_E_OPERATION_NOT_COMPLETE"
	//     - "FABRIC_E_TIMEOUT"
	// . Possible values include: 'FABRICEINVALIDPARTITIONKEY', 'FABRICEIMAGEBUILDERVALIDATIONERROR', 'FABRICEINVALIDADDRESS', 'FABRICEAPPLICATIONNOTUPGRADING', 'FABRICEAPPLICATIONUPGRADEVALIDATIONERROR', 'FABRICEFABRICNOTUPGRADING', 'FABRICEFABRICUPGRADEVALIDATIONERROR', 'FABRICEINVALIDCONFIGURATION', 'FABRICEINVALIDNAMEURI', 'FABRICEPATHTOOLONG', 'FABRICEKEYTOOLARGE', 'FABRICESERVICEAFFINITYCHAINNOTSUPPORTED', 'FABRICEINVALIDATOMICGROUP', 'FABRICEVALUEEMPTY', 'FABRICENODENOTFOUND', 'FABRICEAPPLICATIONTYPENOTFOUND', 'FABRICEAPPLICATIONNOTFOUND', 'FABRICESERVICETYPENOTFOUND', 'FABRICESERVICEDOESNOTEXIST', 'FABRICESERVICETYPETEMPLATENOTFOUND', 'FABRICECONFIGURATIONSECTIONNOTFOUND', 'FABRICEPARTITIONNOTFOUND', 'FABRICEREPLICADOESNOTEXIST', 'FABRICESERVICEGROUPDOESNOTEXIST', 'FABRICECONFIGURATIONPARAMETERNOTFOUND', 'FABRICEDIRECTORYNOTFOUND', 'FABRICEFABRICVERSIONNOTFOUND', 'FABRICEFILENOTFOUND', 'FABRICENAMEDOESNOTEXIST', 'FABRICEPROPERTYDOESNOTEXIST', 'FABRICEENUMERATIONCOMPLETED', 'FABRICESERVICEMANIFESTNOTFOUND', 'FABRICEKEYNOTFOUND', 'FABRICEHEALTHENTITYNOTFOUND', 'FABRICEAPPLICATIONTYPEALREADYEXISTS', 'FABRICEAPPLICATIONALREADYEXISTS', 'FABRICEAPPLICATIONALREADYINTARGETVERSION', 'FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS', 'FABRICEAPPLICATIONUPGRADEINPROGRESS', 'FABRICESERVICEALREADYEXISTS', 'FABRICESERVICEGROUPALREADYEXISTS', 'FABRICEAPPLICATIONTYPEINUSE', 'FABRICEFABRICALREADYINTARGETVERSION', 'FABRICEFABRICVERSIONALREADYEXISTS', 'FABRICEFABRICVERSIONINUSE', 'FABRICEFABRICUPGRADEINPROGRESS', 'FABRICENAMEALREADYEXISTS', 'FABRICENAMENOTEMPTY', 'FABRICEPROPERTYCHECKFAILED', 'FABRICESERVICEMETADATAMISMATCH', 'FABRICESERVICETYPEMISMATCH', 'FABRICEHEALTHSTALEREPORT', 'FABRICESEQUENCENUMBERCHECKFAILED', 'FABRICENODEHASNOTSTOPPEDYET', 'FABRICEINSTANCEIDMISMATCH', 'FABRICEVALUETOOLARGE', 'FABRICENOWRITEQUORUM', 'FABRICENOTPRIMARY', 'FABRICENOTREADY', 'FABRICERECONFIGURATIONPENDING', 'FABRICESERVICEOFFLINE', 'EABORT', 'FABRICECOMMUNICATIONERROR', 'FABRICEOPERATIONNOTCOMPLETE', 'FABRICETIMEOUT', 'FABRICENODEISUP'
	Code Code `json:"Code,omitempty"`
	// Message - Error message.
	Message *string `json:"Message,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FailedPropertyBatchInfo derived from PropertyBatchInfo. Represents the property batch failing. Contains
// information about the specific batch failure.
type FailedPropertyBatchInfo struct {
	// ErrorMessage - The error message of the failed operation. Describes the exception thrown due to the first unsuccessful operation in the property batch.
	ErrorMessage *string `json:"ErrorMessage,omitempty"`
	// OperationIndex - The index of the unsuccessful operation in the property batch.
	OperationIndex *int32 `json:"OperationIndex,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchInfo', 'KindSuccessful', 'KindFailed'
	Kind KindBasicPropertyBatchInfo `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for FailedPropertyBatchInfo.
func (fpbi FailedPropertyBatchInfo) MarshalJSON() ([]byte, error) {
	fpbi.Kind = KindFailed
	objectMap := make(map[string]interface{})
	if fpbi.ErrorMessage != nil {
		objectMap["ErrorMessage"] = fpbi.ErrorMessage
	}
	if fpbi.OperationIndex != nil {
		objectMap["OperationIndex"] = fpbi.OperationIndex
	}
	if fpbi.Kind != "" {
		objectMap["Kind"] = fpbi.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSuccessfulPropertyBatchInfo is the BasicPropertyBatchInfo implementation for FailedPropertyBatchInfo.
func (fpbi FailedPropertyBatchInfo) AsSuccessfulPropertyBatchInfo() (*SuccessfulPropertyBatchInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsFailedPropertyBatchInfo is the BasicPropertyBatchInfo implementation for FailedPropertyBatchInfo.
func (fpbi FailedPropertyBatchInfo) AsFailedPropertyBatchInfo() (*FailedPropertyBatchInfo, bool) {
	return &fpbi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchInfo is the BasicPropertyBatchInfo implementation for FailedPropertyBatchInfo.
func (fpbi FailedPropertyBatchInfo) AsPropertyBatchInfo() (*PropertyBatchInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchInfo is the BasicPropertyBatchInfo implementation for FailedPropertyBatchInfo.
func (fpbi FailedPropertyBatchInfo) AsBasicPropertyBatchInfo() (BasicPropertyBatchInfo, bool) {
	return &fpbi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FailedUpgradeDomainProgressObject the detailed upgrade progress for nodes in the current upgrade domain at the
// point of failure.
type FailedUpgradeDomainProgressObject struct {
	// DomainName - The name of the upgrade domain
	DomainName *string `json:"DomainName,omitempty"`
	// NodeUpgradeProgressList - List of upgrading nodes and their statuses
	NodeUpgradeProgressList *[]NodeUpgradeProgressInfo `json:"NodeUpgradeProgressList,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FailureUpgradeDomainProgressInfo information about the upgrade domain progress at the time of upgrade failure.
type FailureUpgradeDomainProgressInfo struct {
	// DomainName - The name of the upgrade domain
	DomainName *string `json:"DomainName,omitempty"`
	// NodeUpgradeProgressList - List of upgrading nodes and their statuses
	NodeUpgradeProgressList *[]NodeUpgradeProgressInfo `json:"NodeUpgradeProgressList,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FileInfo information about a image store file.
type FileInfo struct {
	// FileSize - The size of file in bytes.
	FileSize *string `json:"FileSize,omitempty"`
	// FileVersion - Information about the version of image store file.
	FileVersion *FileVersion `json:"FileVersion,omitempty"`
	// ModifiedDate - The date and time when the image store file was last modified.
	ModifiedDate *date.Time `json:"ModifiedDate,omitempty"`
	// StoreRelativePath - The file path relative to the image store root path.
	StoreRelativePath *string `json:"StoreRelativePath,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FileVersion information about the version of image store file.
type FileVersion struct {
	// VersionNumber - The current image store version number for the file is used in image store for checking whether it need to be updated.
	VersionNumber *string `json:"VersionNumber,omitempty"`
	// EpochDataLossNumber - The epoch data loss number of image store replica when this file entry was updated or created.
	EpochDataLossNumber *string `json:"EpochDataLossNumber,omitempty"`
	// EpochConfigurationNumber - The epoch configuration version number of the image store replica when this file entry was created or updated.
	EpochConfigurationNumber *string `json:"EpochConfigurationNumber,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// FolderInfo information about a image store folder. It includes how many files this folder contains and its image
// store relative path.
type FolderInfo struct {
	// StoreRelativePath - The remote location within image store. This path is relative to the image store root.
	StoreRelativePath *string `json:"StoreRelativePath,omitempty"`
	// FileCount - The number of files from within the image store folder.
	FileCount *uuid.UUID `json:"FileCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// GetPropertyBatchOperation represents a PropertyBatchOperation that gets the specified property if it exists.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type GetPropertyBatchOperation struct {
	// IncludeValue - Whether or not to return the property value with the metadata.
	// True if values should be returned with the metadata; False to return only property metadata.
	IncludeValue *bool `json:"IncludeValue,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) MarshalJSON() ([]byte, error) {
	gpbo.Kind = KindGet
	objectMap := make(map[string]interface{})
	if gpbo.IncludeValue != nil {
		objectMap["IncludeValue"] = gpbo.IncludeValue
	}
	if gpbo.PropertyName != nil {
		objectMap["PropertyName"] = gpbo.PropertyName
	}
	if gpbo.Kind != "" {
		objectMap["Kind"] = gpbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return &gpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for GetPropertyBatchOperation.
func (gpbo GetPropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &gpbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// GUIDPropertyValue describes a Service Fabric property value of type Guid.
type GUIDPropertyValue struct {
	// Data - The data of the property value.
	Data *uuid.UUID `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for GUIDPropertyValue.
func (gpv GUIDPropertyValue) MarshalJSON() ([]byte, error) {
	gpv.Kind = KindGUID
	objectMap := make(map[string]interface{})
	if gpv.Data != nil {
		objectMap["Data"] = gpv.Data
	}
	if gpv.Kind != "" {
		objectMap["Kind"] = gpv.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBinaryPropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64PropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDoublePropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStringPropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGUIDPropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return &gpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyValue is the BasicPropertyValue implementation for GUIDPropertyValue.
func (gpv GUIDPropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &gpv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicHealthEvaluation represents a health evaluation which describes the data and the algorithm used by health
// manager to evaluate the health of an entity.
type BasicHealthEvaluation interface {
	AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool)
	AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool)
	AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool)
	AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool)
	AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool)
	AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool)
	AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool)
	AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool)
	AsEventHealthEvaluation() (*EventHealthEvaluation, bool)
	AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool)
	AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool)
	AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool)
	AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool)
	AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool)
	AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool)
	AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool)
	AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool)
	AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool)
	AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool)
	AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool)
	AsHealthEvaluation() (*HealthEvaluation, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthEvaluation represents a health evaluation which describes the data and the algorithm used by health
// manager to evaluate the health of an entity.
type HealthEvaluation struct {
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

func unmarshalBasicHealthEvaluation(body []byte) (BasicHealthEvaluation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindApplication):
		var ahe ApplicationHealthEvaluation
		err := json.Unmarshal(body, &ahe)
		return ahe, err
	case string(KindApplications):
		var ahe ApplicationsHealthEvaluation
		err := json.Unmarshal(body, &ahe)
		return ahe, err
	case string(KindApplicationTypeApplications):
		var atahe ApplicationTypeApplicationsHealthEvaluation
		err := json.Unmarshal(body, &atahe)
		return atahe, err
	case string(KindDeltaNodesCheck):
		var dnche DeltaNodesCheckHealthEvaluation
		err := json.Unmarshal(body, &dnche)
		return dnche, err
	case string(KindDeployedApplication):
		var dahe DeployedApplicationHealthEvaluation
		err := json.Unmarshal(body, &dahe)
		return dahe, err
	case string(KindDeployedApplications):
		var dahe DeployedApplicationsHealthEvaluation
		err := json.Unmarshal(body, &dahe)
		return dahe, err
	case string(KindDeployedServicePackage):
		var dsphe DeployedServicePackageHealthEvaluation
		err := json.Unmarshal(body, &dsphe)
		return dsphe, err
	case string(KindDeployedServicePackages):
		var dsphe DeployedServicePackagesHealthEvaluation
		err := json.Unmarshal(body, &dsphe)
		return dsphe, err
	case string(KindEvent):
		var ehe EventHealthEvaluation
		err := json.Unmarshal(body, &ehe)
		return ehe, err
	case string(KindNode):
		var nhe NodeHealthEvaluation
		err := json.Unmarshal(body, &nhe)
		return nhe, err
	case string(KindNodes):
		var nhe NodesHealthEvaluation
		err := json.Unmarshal(body, &nhe)
		return nhe, err
	case string(KindPartition):
		var phe PartitionHealthEvaluation
		err := json.Unmarshal(body, &phe)
		return phe, err
	case string(KindPartitions):
		var phe PartitionsHealthEvaluation
		err := json.Unmarshal(body, &phe)
		return phe, err
	case string(KindReplica):
		var rhe ReplicaHealthEvaluation
		err := json.Unmarshal(body, &rhe)
		return rhe, err
	case string(KindReplicas):
		var rhe ReplicasHealthEvaluation
		err := json.Unmarshal(body, &rhe)
		return rhe, err
	case string(KindService):
		var she ServiceHealthEvaluation
		err := json.Unmarshal(body, &she)
		return she, err
	case string(KindServices):
		var she ServicesHealthEvaluation
		err := json.Unmarshal(body, &she)
		return she, err
	case string(KindSystemApplication):
		var sahe SystemApplicationHealthEvaluation
		err := json.Unmarshal(body, &sahe)
		return sahe, err
	case string(KindUpgradeDomainDeltaNodesCheck):
		var uddnche UpgradeDomainDeltaNodesCheckHealthEvaluation
		err := json.Unmarshal(body, &uddnche)
		return uddnche, err
	case string(KindUpgradeDomainNodes):
		var udnhe UpgradeDomainNodesHealthEvaluation
		err := json.Unmarshal(body, &udnhe)
		return udnhe, err
	default:
		var he HealthEvaluation
		err := json.Unmarshal(body, &he)
		return he, err
	}
}
func unmarshalBasicHealthEvaluationArray(body []byte) ([]BasicHealthEvaluation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	heArray := make([]BasicHealthEvaluation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		he, err := unmarshalBasicHealthEvaluation(*rawMessage)
		if err != nil {
			return nil, err
		}
		heArray[index] = he
	}
	return heArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for HealthEvaluation.
func (he HealthEvaluation) MarshalJSON() ([]byte, error) {
	he.Kind = KindHealthEvaluation
	objectMap := make(map[string]interface{})
	if he.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = he.AggregatedHealthState
	}
	if he.Description != nil {
		objectMap["Description"] = he.Description
	}
	if he.Kind != "" {
		objectMap["Kind"] = he.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return &he, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for HealthEvaluation.
func (he HealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &he, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthEvaluationWrapper wrapper object for health evaluation.
type HealthEvaluationWrapper struct {
	// HealthEvaluation - Represents a health evaluation which describes the data and the algorithm used by health manager to evaluate the health of an entity.
	HealthEvaluation BasicHealthEvaluation `json:"HealthEvaluation,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for HealthEvaluationWrapper struct.
func (hew *HealthEvaluationWrapper) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "HealthEvaluation":
			if v != nil {
				healthEvaluation, err := unmarshalBasicHealthEvaluation(*v)
				if err != nil {
					return err
				}
				hew.HealthEvaluation = healthEvaluation
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthEvent represents health information reported on a health entity, such as cluster, application or node,
// with additional metadata added by the Health Manager.
type HealthEvent struct {
	// IsExpired - Returns true if the health event is expired, otherwise false.
	IsExpired *bool `json:"IsExpired,omitempty"`
	// SourceUtcTimestamp - The date and time when the health report was sent by the source.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// LastModifiedUtcTimestamp - The date and time when the health report was last modified by the health store.
	LastModifiedUtcTimestamp *date.Time `json:"LastModifiedUtcTimestamp,omitempty"`
	// LastOkTransitionAt - If the current health state is 'Ok', this property returns the time at which the health report was first reported with 'Ok'.
	// For periodic reporting, many reports with the same state may have been generated.
	// This property returns the date and time when the first 'Ok' health report was received.
	// If the current health state is 'Error' or 'Warning', returns the date and time at which the health state was last in 'Ok', before transitioning to a different state.
	// If the health state was never 'Ok', the value will be zero date-time.
	LastOkTransitionAt *date.Time `json:"LastOkTransitionAt,omitempty"`
	// LastWarningTransitionAt - If the current health state is 'Warning', this property returns the time at which the health report was first reported with 'Warning'. For periodic reporting, many reports with the same state may have been generated however, this property returns only the date and time at the first 'Warning' health report was received.
	// If the current health state is 'Ok' or 'Error', returns the date and time at which the health state was last in 'Warning', before transitioning to a different state.
	// If the health state was never 'Warning', the value will be zero date-time.
	LastWarningTransitionAt *date.Time `json:"LastWarningTransitionAt,omitempty"`
	// LastErrorTransitionAt - If the current health state is 'Error', this property returns the time at which the health report was first reported with 'Error'. For periodic reporting, many reports with the same state may have been generated however, this property returns only the date and time at the first 'Error' health report was received.
	// If the current health state is 'Ok' or 'Warning', returns the date and time at which the health state was last in 'Error', before transitioning to a different state.
	// If the health state was never 'Error', the value will be zero date-time.
	LastErrorTransitionAt *date.Time `json:"LastErrorTransitionAt,omitempty"`
	// SourceID - The source name which identifies the client/watchdog/system component which generated the health information.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - The property of the health information. An entity can have health reports for different properties.
	// The property is a string and not a fixed enumeration to allow the reporter flexibility to categorize the state condition that triggers the report.
	// For example, a reporter with SourceId "LocalWatchdog" can monitor the state of the available disk on a node,
	// so it can report "AvailableDisk" property on that node.
	// The same reporter can monitor the node connectivity, so it can report a property "Connectivity" on the same node.
	// In the health store, these reports are treated as separate health events for the specified node.
	// Together with the SourceId, the property uniquely identifies the health information.
	Property *string `json:"Property,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// TimeToLiveInMilliSeconds - The duration for which this health report is valid. This field is using ISO8601 format for specifying the duration.
	// When clients report periodically, they should send reports with higher frequency than time to live.
	// If clients report on transition, they can set the time to live to infinite.
	// When time to live expires, the health event that contains the health information
	// is either removed from health store, if RemoveWhenExpired is true, or evaluated at error, if RemoveWhenExpired false.
	// If not specified, time to live defaults to infinite value.
	TimeToLiveInMilliSeconds *string `json:"TimeToLiveInMilliSeconds,omitempty"`
	// Description - The description of the health information. It represents free text used to add human readable information about the report.
	// The maximum string length for the description is 4096 characters.
	// If the provided string is longer, it will be automatically truncated.
	// When truncated, the last characters of the description contain a marker "[Truncated]", and total string size is 4096 characters.
	// The presence of the marker indicates to users that truncation occurred.
	// Note that when truncated, the description has less than 4096 characters from the original string.
	Description *string `json:"Description,omitempty"`
	// SequenceNumber - The sequence number for this health report as a numeric string.
	// The report sequence number is used by the health store to detect stale reports.
	// If not specified, a sequence number is auto-generated by the health client when a report is added.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
	// RemoveWhenExpired - Value that indicates whether the report is removed from health store when it expires.
	// If set to true, the report is removed from the health store after it expires.
	// If set to false, the report is treated as an error when expired. The value of this property is false by default.
	// When clients report periodically, they should set RemoveWhenExpired false (default).
	// This way, is the reporter has issues (eg. deadlock) and can't report, the entity is evaluated at error when the health report expires.
	// This flags the entity as being in Error health state.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthInformation represents common health report information. It is included in all health reports sent to
// health store and in all health events returned by health queries.
type HealthInformation struct {
	// SourceID - The source name which identifies the client/watchdog/system component which generated the health information.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - The property of the health information. An entity can have health reports for different properties.
	// The property is a string and not a fixed enumeration to allow the reporter flexibility to categorize the state condition that triggers the report.
	// For example, a reporter with SourceId "LocalWatchdog" can monitor the state of the available disk on a node,
	// so it can report "AvailableDisk" property on that node.
	// The same reporter can monitor the node connectivity, so it can report a property "Connectivity" on the same node.
	// In the health store, these reports are treated as separate health events for the specified node.
	// Together with the SourceId, the property uniquely identifies the health information.
	Property *string `json:"Property,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// TimeToLiveInMilliSeconds - The duration for which this health report is valid. This field is using ISO8601 format for specifying the duration.
	// When clients report periodically, they should send reports with higher frequency than time to live.
	// If clients report on transition, they can set the time to live to infinite.
	// When time to live expires, the health event that contains the health information
	// is either removed from health store, if RemoveWhenExpired is true, or evaluated at error, if RemoveWhenExpired false.
	// If not specified, time to live defaults to infinite value.
	TimeToLiveInMilliSeconds *string `json:"TimeToLiveInMilliSeconds,omitempty"`
	// Description - The description of the health information. It represents free text used to add human readable information about the report.
	// The maximum string length for the description is 4096 characters.
	// If the provided string is longer, it will be automatically truncated.
	// When truncated, the last characters of the description contain a marker "[Truncated]", and total string size is 4096 characters.
	// The presence of the marker indicates to users that truncation occurred.
	// Note that when truncated, the description has less than 4096 characters from the original string.
	Description *string `json:"Description,omitempty"`
	// SequenceNumber - The sequence number for this health report as a numeric string.
	// The report sequence number is used by the health store to detect stale reports.
	// If not specified, a sequence number is auto-generated by the health client when a report is added.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
	// RemoveWhenExpired - Value that indicates whether the report is removed from health store when it expires.
	// If set to true, the report is removed from the health store after it expires.
	// If set to false, the report is treated as an error when expired. The value of this property is false by default.
	// When clients report periodically, they should set RemoveWhenExpired false (default).
	// This way, is the reporter has issues (eg. deadlock) and can't report, the entity is evaluated at error when the health report expires.
	// This flags the entity as being in Error health state.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthStateCount represents information about how many health entities are in Ok, Warning and Error health
// state.
type HealthStateCount struct {
	// OkCount - The number of health entities with aggregated health state Ok.
	OkCount *int64 `json:"OkCount,omitempty"`
	// WarningCount - The number of health entities with aggregated health state Warning.
	WarningCount *int64 `json:"WarningCount,omitempty"`
	// ErrorCount - The number of health entities with aggregated health state Error.
	ErrorCount *int64 `json:"ErrorCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// HealthStatistics the health statistics of an entity, returned as part of the health query result when the query
// description is configured to include statistics.
// The statistics include health state counts for all children types of the current entity.
// For example, for cluster, the health statistics include health state counts for nodes, applications, services,
// partitions, replicas, deployed applications and deployed service packages.
// For partition, the health statistics include health counts for replicas.
type HealthStatistics struct {
	// HealthStateCountList - List of health state counts per entity kind, which keeps track of how many children of the queried entity are in Ok, Warning and Error state.
	HealthStateCountList *[]EntityKindHealthStateCount `json:"HealthStateCountList,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ImageStoreContent information about the image store content.
type ImageStoreContent struct {
	autorest.Response `json:"-"`
	// StoreFiles - The list of image store file info objects represents files found under the given image store relative path.
	StoreFiles *[]FileInfo `json:"StoreFiles,omitempty"`
	// StoreFolders - The list of image store folder info objects represents subfolders found under the given image store relative path.
	StoreFolders *[]FolderInfo `json:"StoreFolders,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ImageStoreCopyDescription information about how to copy image store content from one image store relative path
// to another image store relative path.
type ImageStoreCopyDescription struct {
	// RemoteSource - The relative path of source image store content to be copied from.
	RemoteSource *string `json:"RemoteSource,omitempty"`
	// RemoteDestination - The relative path of destination image store content to be copied to.
	RemoteDestination *string `json:"RemoteDestination,omitempty"`
	// SkipFiles - The list of the file names to be skipped for copying.
	SkipFiles *[]string `json:"SkipFiles,omitempty"`
	// CheckMarkFile - Indicates whether to check mark file during copying. The property is true if checking mark file is required, false otherwise. The mark file is used to check whether the folder is well constructed. If the property is true and mark file does not exist, the copy is skipped.
	CheckMarkFile *bool `json:"CheckMarkFile,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Int64PropertyValue describes a Service Fabric property value of type Int64.
type Int64PropertyValue struct {
	// Data - The data of the property value.
	Data *string `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for Int64PropertyValue.
func (i6pv Int64PropertyValue) MarshalJSON() ([]byte, error) {
	i6pv.Kind = KindInt64
	objectMap := make(map[string]interface{})
	if i6pv.Data != nil {
		objectMap["Data"] = i6pv.Data
	}
	if i6pv.Kind != "" {
		objectMap["Kind"] = i6pv.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBinaryPropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64PropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return &i6pv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDoublePropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStringPropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGUIDPropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyValue is the BasicPropertyValue implementation for Int64PropertyValue.
func (i6pv Int64PropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &i6pv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Int64RangePartitionInformation describes the partition information for the integer range that is based on
// partition schemes.
type Int64RangePartitionInformation struct {
	// LowKey - Specifies the minimum key value handled by this partition.
	LowKey *string `json:"LowKey,omitempty"`
	// HighKey - Specifies the maximum key value handled by this partition.
	HighKey *string `json:"HighKey,omitempty"`
	// ID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	ID *uuid.UUID `json:"Id,omitempty"`
	// ServicePartitionKind - Possible values include: 'ServicePartitionKindPartitionInformation', 'ServicePartitionKindInt64Range', 'ServicePartitionKindNamed', 'ServicePartitionKindSingleton'
	ServicePartitionKind ServicePartitionKind `json:"ServicePartitionKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) MarshalJSON() ([]byte, error) {
	i6rpi.ServicePartitionKind = ServicePartitionKindInt64Range
	objectMap := make(map[string]interface{})
	if i6rpi.LowKey != nil {
		objectMap["LowKey"] = i6rpi.LowKey
	}
	if i6rpi.HighKey != nil {
		objectMap["HighKey"] = i6rpi.HighKey
	}
	if i6rpi.ID != nil {
		objectMap["Id"] = i6rpi.ID
	}
	if i6rpi.ServicePartitionKind != "" {
		objectMap["ServicePartitionKind"] = i6rpi.ServicePartitionKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64RangePartitionInformation is the BasicPartitionInformation implementation for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) AsInt64RangePartitionInformation() (*Int64RangePartitionInformation, bool) {
	return &i6rpi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionInformation is the BasicPartitionInformation implementation for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) AsNamedPartitionInformation() (*NamedPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionInformation is the BasicPartitionInformation implementation for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) AsSingletonPartitionInformation() (*SingletonPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionInformation is the BasicPartitionInformation implementation for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) AsPartitionInformation() (*PartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionInformation is the BasicPartitionInformation implementation for Int64RangePartitionInformation.
func (i6rpi Int64RangePartitionInformation) AsBasicPartitionInformation() (BasicPartitionInformation, bool) {
	return &i6rpi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// InvokeDataLossResult represents information about an operation in a terminal state (Completed or Faulted).
type InvokeDataLossResult struct {
	// ErrorCode - If OperationState is Completed, this is 0.  If OperationState is Faulted, this is an error code indicating the reason.
	ErrorCode *int32 `json:"ErrorCode,omitempty"`
	// SelectedPartition - This class returns information about the partition that the user-induced operation acted upon.
	SelectedPartition *SelectedPartition `json:"SelectedPartition,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// InvokeQuorumLossResult represents information about an operation in a terminal state (Completed or Faulted).
type InvokeQuorumLossResult struct {
	// ErrorCode - If OperationState is Completed, this is 0.  If OperationState is Faulted, this is an error code indicating the reason.
	ErrorCode *int32 `json:"ErrorCode,omitempty"`
	// SelectedPartition - This class returns information about the partition that the user-induced operation acted upon.
	SelectedPartition *SelectedPartition `json:"SelectedPartition,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// KeyValueStoreReplicaStatus key value store related information for the replica.
type KeyValueStoreReplicaStatus struct {
	// DatabaseRowCountEstimate - Value indicating the estimated number of rows in the underlying database.
	DatabaseRowCountEstimate *string `json:"DatabaseRowCountEstimate,omitempty"`
	// DatabaseLogicalSizeEstimate - Value indicating the estimated size of the underlying database.
	DatabaseLogicalSizeEstimate *string `json:"DatabaseLogicalSizeEstimate,omitempty"`
	// CopyNotificationCurrentKeyFilter - Value indicating the latest key-prefix filter applied to enumeration during the callback. Null if there is no pending callback.
	CopyNotificationCurrentKeyFilter *string `json:"CopyNotificationCurrentKeyFilter,omitempty"`
	// CopyNotificationCurrentProgress - Value indicating the latest number of keys enumerated during the callback. 0 if there is no pending callback.
	CopyNotificationCurrentProgress *string `json:"CopyNotificationCurrentProgress,omitempty"`
	// StatusDetails - Value indicating the current status details of the replica.
	StatusDetails *string `json:"StatusDetails,omitempty"`
	// Kind - Possible values include: 'KindReplicaStatusBase', 'KindKeyValueStore'
	Kind KindBasicReplicaStatusBase `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for KeyValueStoreReplicaStatus.
func (kvsrs KeyValueStoreReplicaStatus) MarshalJSON() ([]byte, error) {
	kvsrs.Kind = KindKeyValueStore
	objectMap := make(map[string]interface{})
	if kvsrs.DatabaseRowCountEstimate != nil {
		objectMap["DatabaseRowCountEstimate"] = kvsrs.DatabaseRowCountEstimate
	}
	if kvsrs.DatabaseLogicalSizeEstimate != nil {
		objectMap["DatabaseLogicalSizeEstimate"] = kvsrs.DatabaseLogicalSizeEstimate
	}
	if kvsrs.CopyNotificationCurrentKeyFilter != nil {
		objectMap["CopyNotificationCurrentKeyFilter"] = kvsrs.CopyNotificationCurrentKeyFilter
	}
	if kvsrs.CopyNotificationCurrentProgress != nil {
		objectMap["CopyNotificationCurrentProgress"] = kvsrs.CopyNotificationCurrentProgress
	}
	if kvsrs.StatusDetails != nil {
		objectMap["StatusDetails"] = kvsrs.StatusDetails
	}
	if kvsrs.Kind != "" {
		objectMap["Kind"] = kvsrs.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsKeyValueStoreReplicaStatus is the BasicReplicaStatusBase implementation for KeyValueStoreReplicaStatus.
func (kvsrs KeyValueStoreReplicaStatus) AsKeyValueStoreReplicaStatus() (*KeyValueStoreReplicaStatus, bool) {
	return &kvsrs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaStatusBase is the BasicReplicaStatusBase implementation for KeyValueStoreReplicaStatus.
func (kvsrs KeyValueStoreReplicaStatus) AsReplicaStatusBase() (*ReplicaStatusBase, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaStatusBase is the BasicReplicaStatusBase implementation for KeyValueStoreReplicaStatus.
func (kvsrs KeyValueStoreReplicaStatus) AsBasicReplicaStatusBase() (BasicReplicaStatusBase, bool) {
	return &kvsrs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListDeployedCodePackageInfo ...
type ListDeployedCodePackageInfo struct {
	autorest.Response `json:"-"`
	Value             *[]DeployedCodePackageInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListDeployedServicePackageInfo ...
type ListDeployedServicePackageInfo struct {
	autorest.Response `json:"-"`
	Value             *[]DeployedServicePackageInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListDeployedServiceReplicaInfo ...
type ListDeployedServiceReplicaInfo struct {
	autorest.Response `json:"-"`
	Value             *[]BasicDeployedServiceReplicaInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ListDeployedServiceReplicaInfo struct.
func (ldsri *ListDeployedServiceReplicaInfo) UnmarshalJSON(body []byte) error {
	dsri, err := unmarshalBasicDeployedServiceReplicaInfoArray(body)
	if err != nil {
		return err
	}
	ldsri.Value = &dsri

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListDeployedServiceTypeInfo ...
type ListDeployedServiceTypeInfo struct {
	autorest.Response `json:"-"`
	Value             *[]DeployedServiceTypeInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListFabricCodeVersionInfo ...
type ListFabricCodeVersionInfo struct {
	autorest.Response `json:"-"`
	Value             *[]FabricCodeVersionInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListFabricConfigVersionInfo ...
type ListFabricConfigVersionInfo struct {
	autorest.Response `json:"-"`
	Value             *[]FabricConfigVersionInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListOperationStatus ...
type ListOperationStatus struct {
	autorest.Response `json:"-"`
	Value             *[]OperationStatus `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListRepairTask ...
type ListRepairTask struct {
	autorest.Response `json:"-"`
	Value             *[]RepairTask `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ListServiceTypeInfo ...
type ListServiceTypeInfo struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceTypeInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// LoadMetricReport represents the load metric report which contains the time metric was reported, its name and
// value.
type LoadMetricReport struct {
	// LastReportedUtc - Gets the UTC time when the load was reported.
	LastReportedUtc *date.Time `json:"LastReportedUtc,omitempty"`
	// Name - The name of the load metric.
	Name *string `json:"Name,omitempty"`
	// Value - The value of the load metric.
	Value *string `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// LoadMetricReportInfo information about load reported by replica.
type LoadMetricReportInfo struct {
	// Name - The name of the metric.
	Name *string `json:"Name,omitempty"`
	// Value - The value of the load for the metric..
	Value *int32 `json:"Value,omitempty"`
	// LastReportedUtc - The UTC time when the load is reported.
	LastReportedUtc *date.Time `json:"LastReportedUtc,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MonitoringPolicyDescription describes the parameters for monitoring an upgrade in Monitored mode.
type MonitoringPolicyDescription struct {
	// FailureAction - The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Possible values include: 'FailureActionInvalid', 'FailureActionRollback', 'FailureActionManual'
	FailureAction FailureAction `json:"FailureAction,omitempty"`
	// HealthCheckWaitDurationInMilliseconds - The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckWaitDurationInMilliseconds *string `json:"HealthCheckWaitDurationInMilliseconds,omitempty"`
	// HealthCheckStableDurationInMilliseconds - The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckStableDurationInMilliseconds *string `json:"HealthCheckStableDurationInMilliseconds,omitempty"`
	// HealthCheckRetryTimeoutInMilliseconds - The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckRetryTimeoutInMilliseconds *string `json:"HealthCheckRetryTimeoutInMilliseconds,omitempty"`
	// UpgradeTimeoutInMilliseconds - The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeTimeoutInMilliseconds *string `json:"UpgradeTimeoutInMilliseconds,omitempty"`
	// UpgradeDomainTimeoutInMilliseconds - The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeDomainTimeoutInMilliseconds *string `json:"UpgradeDomainTimeoutInMilliseconds,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NameDescription describes a Service Fabric name.
type NameDescription struct {
	// Name - The Service Fabric name, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NamedPartitionInformation describes the partition information for the name as a string that is based on
// partition schemes.
type NamedPartitionInformation struct {
	// Name - Name of the partition.
	Name *string `json:"Name,omitempty"`
	// ID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	ID *uuid.UUID `json:"Id,omitempty"`
	// ServicePartitionKind - Possible values include: 'ServicePartitionKindPartitionInformation', 'ServicePartitionKindInt64Range', 'ServicePartitionKindNamed', 'ServicePartitionKindSingleton'
	ServicePartitionKind ServicePartitionKind `json:"ServicePartitionKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NamedPartitionInformation.
func (npi NamedPartitionInformation) MarshalJSON() ([]byte, error) {
	npi.ServicePartitionKind = ServicePartitionKindNamed
	objectMap := make(map[string]interface{})
	if npi.Name != nil {
		objectMap["Name"] = npi.Name
	}
	if npi.ID != nil {
		objectMap["Id"] = npi.ID
	}
	if npi.ServicePartitionKind != "" {
		objectMap["ServicePartitionKind"] = npi.ServicePartitionKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64RangePartitionInformation is the BasicPartitionInformation implementation for NamedPartitionInformation.
func (npi NamedPartitionInformation) AsInt64RangePartitionInformation() (*Int64RangePartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionInformation is the BasicPartitionInformation implementation for NamedPartitionInformation.
func (npi NamedPartitionInformation) AsNamedPartitionInformation() (*NamedPartitionInformation, bool) {
	return &npi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionInformation is the BasicPartitionInformation implementation for NamedPartitionInformation.
func (npi NamedPartitionInformation) AsSingletonPartitionInformation() (*SingletonPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionInformation is the BasicPartitionInformation implementation for NamedPartitionInformation.
func (npi NamedPartitionInformation) AsPartitionInformation() (*PartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionInformation is the BasicPartitionInformation implementation for NamedPartitionInformation.
func (npi NamedPartitionInformation) AsBasicPartitionInformation() (BasicPartitionInformation, bool) {
	return &npi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NamedPartitionSchemeDescription describes the named partition scheme of the service.
type NamedPartitionSchemeDescription struct {
	// Count - The number of partitions.
	Count *int32 `json:"Count,omitempty"`
	// Names - Array of size specified by the ‘Count’ parameter, for the names of the partitions.
	Names *[]string `json:"Names,omitempty"`
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed1', 'PartitionSchemeSingleton1', 'PartitionSchemeUniformInt64Range1'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"PartitionScheme,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	npsd.PartitionScheme = PartitionSchemeNamed1
	objectMap := make(map[string]interface{})
	if npsd.Count != nil {
		objectMap["Count"] = npsd.Count
	}
	if npsd.Names != nil {
		objectMap["Names"] = npsd.Names
	}
	if npsd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = npsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return &npsd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &npsd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationInfo information about the node deactivation. This information is valid for a node that is
// undergoing deactivation or has already been deactivated.
type NodeDeactivationInfo struct {
	// NodeDeactivationIntent - The intent or the reason for deactivating the node. Following are the possible values for it. Possible values include: 'NodeDeactivationIntentInvalid', 'NodeDeactivationIntentPause', 'NodeDeactivationIntentRestart', 'NodeDeactivationIntentRemoveData', 'NodeDeactivationIntentRemoveNode'
	NodeDeactivationIntent NodeDeactivationIntent `json:"NodeDeactivationIntent,omitempty"`
	// NodeDeactivationStatus - The status of node deactivation operation. Following are the possible values. Possible values include: 'NodeDeactivationStatusNone', 'NodeDeactivationStatusSafetyCheckInProgress', 'NodeDeactivationStatusSafetyCheckComplete', 'NodeDeactivationStatusCompleted'
	NodeDeactivationStatus NodeDeactivationStatus `json:"NodeDeactivationStatus,omitempty"`
	// NodeDeactivationTask - List of tasks representing the deactivation operation on the node.
	NodeDeactivationTask *[]NodeDeactivationTask `json:"NodeDeactivationTask,omitempty"`
	// PendingSafetyChecks - List of pending safety checks
	PendingSafetyChecks *[]SafetyCheckWrapper `json:"PendingSafetyChecks,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationTask the task representing the deactivation operation on the node.
type NodeDeactivationTask struct {
	// NodeDeactivationTaskID - Identity of the task related to deactivation operation on the node.
	NodeDeactivationTaskID *NodeDeactivationTaskID `json:"NodeDeactivationTaskId,omitempty"`
	// NodeDeactivationIntent - The intent or the reason for deactivating the node. Following are the possible values for it. Possible values include: 'NodeDeactivationIntentInvalid', 'NodeDeactivationIntentPause', 'NodeDeactivationIntentRestart', 'NodeDeactivationIntentRemoveData', 'NodeDeactivationIntentRemoveNode'
	NodeDeactivationIntent NodeDeactivationIntent `json:"NodeDeactivationIntent,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeDeactivationTaskID identity of the task related to deactivation operation on the node.
type NodeDeactivationTaskID struct {
	// ID - Value of the task id.
	ID *string `json:"Id,omitempty"`
	// NodeDeactivationTaskType - The type of the task that performed the node deactivation. Following are the possible values. Possible values include: 'NodeDeactivationTaskTypeInvalid', 'NodeDeactivationTaskTypeInfrastructure', 'NodeDeactivationTaskTypeRepair', 'NodeDeactivationTaskTypeClient'
	NodeDeactivationTaskType NodeDeactivationTaskType `json:"NodeDeactivationTaskType,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealth information about the health of a Service Fabric node.
type NodeHealth struct {
	autorest.Response `json:"-"`
	// Name - Name of the node whose health information is described by this object.
	Name *string `json:"Name,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealthEvaluation represents health evaluation for a node, containing information about the data and the
// algorithm used by health store to evaluate health. The evaluation is returned only when the aggregated health
// state is either Error or Warning.
type NodeHealthEvaluation struct {
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the node. The types of the unhealthy evaluations can be EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) MarshalJSON() ([]byte, error) {
	nhe.Kind = KindNode
	objectMap := make(map[string]interface{})
	if nhe.NodeName != nil {
		objectMap["NodeName"] = nhe.NodeName
	}
	if nhe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = nhe.UnhealthyEvaluations
	}
	if nhe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = nhe.AggregatedHealthState
	}
	if nhe.Description != nil {
		objectMap["Description"] = nhe.Description
	}
	if nhe.Kind != "" {
		objectMap["Kind"] = nhe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return &nhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for NodeHealthEvaluation.
func (nhe NodeHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &nhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealthState represents the health state of a node, which contains the node identifier and its aggregated
// health state.
type NodeHealthState struct {
	// Name - The name of a Service Fabric node.
	Name *string `json:"Name,omitempty"`
	// ID - An internal ID used by Service Fabric to uniquely identify a node. Node Id is deterministically generated from node name.
	ID *NodeID `json:"Id,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealthStateChunk represents the health state chunk of a node, which contains the node name and its
// aggregated health state.
type NodeHealthStateChunk struct {
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealthStateChunkList the list of node health state chunks in the cluster that respect the input filters in
// the chunk query. Returned by get cluster health state chunks query.
type NodeHealthStateChunkList struct {
	// Items - The list of node health state chunks that respect the input filters in the chunk query.
	Items *[]NodeHealthStateChunk `json:"Items,omitempty"`
	// TotalCount - Total number of entity health state objects that match the specified filters from the cluster health chunk query description.
	TotalCount *int64 `json:"TotalCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeHealthStateFilter defines matching criteria to determine whether a node should be included in the returned
// cluster health chunk.
// One filter can match zero, one or multiple nodes, depending on its properties.
// Can be specified in the cluster health chunk query description.
type NodeHealthStateFilter struct {
	// NodeNameFilter - Name of the node that matches the filter. The filter is applied only to the specified node, if it exists.
	// If the node doesn't exist, no node is returned in the cluster health chunk based on this filter.
	// If the node exists, it is included in the cluster health chunk if the health state matches the other filter properties.
	// If not specified, all nodes that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	NodeNameFilter *string `json:"NodeNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the nodes. It allows selecting nodes if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only nodes that match the filter are returned. All nodes are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the node name is specified. If the filter has default value and node name is specified, the matching node is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches nodes with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeID an internal ID used by Service Fabric to uniquely identify a node. Node Id is deterministically generated
// from node name.
type NodeID struct {
	// ID - Value of the node Id. This is a 128 bit integer.
	ID *string `json:"Id,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeImpact describes the expected impact of a repair to a particular node.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type NodeImpact struct {
	// NodeName - The name of the impacted node.
	NodeName *string `json:"NodeName,omitempty"`
	// ImpactLevel - The level of impact expected. Possible values include: 'ImpactLevelInvalid', 'ImpactLevelNone', 'ImpactLevelRestart', 'ImpactLevelRemoveData', 'ImpactLevelRemoveNode'
	ImpactLevel ImpactLevel `json:"ImpactLevel,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeInfo information about a node in Service Fabric cluster.
type NodeInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of a Service Fabric node.
	Name *string `json:"Name,omitempty"`
	// IPAddressOrFQDN - The IP address or fully qualified domain name of the node.
	IPAddressOrFQDN *string `json:"IpAddressOrFQDN,omitempty"`
	// Type - The type of the node.
	Type *string `json:"Type,omitempty"`
	// CodeVersion - The version of Service Fabric binaries that the node is running.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// ConfigVersion - The version of Service Fabric cluster manifest that the node is using.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// NodeStatus - The status of the node. Possible values include: 'NodeStatusInvalid', 'NodeStatusUp', 'NodeStatusDown', 'NodeStatusEnabling', 'NodeStatusDisabling', 'NodeStatusDisabled', 'NodeStatusUnknown', 'NodeStatusRemoved'
	NodeStatus NodeStatus `json:"NodeStatus,omitempty"`
	// NodeUpTimeInSeconds - Time in seconds since the node has been in NodeStatus Up. Value zero indicates that the node is not Up.
	NodeUpTimeInSeconds *string `json:"NodeUpTimeInSeconds,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// IsSeedNode - Indicates if the node is a seed node or not. Returns true if the node is a seed node, otherwise false. A quorum of seed nodes are required for proper operation of Service Fabric cluster.
	IsSeedNode *bool `json:"IsSeedNode,omitempty"`
	// UpgradeDomain - The upgrade domain of the node.
	UpgradeDomain *string `json:"UpgradeDomain,omitempty"`
	// FaultDomain - The fault domain of the node.
	FaultDomain *string `json:"FaultDomain,omitempty"`
	// ID - An internal ID used by Service Fabric to uniquely identify a node. Node Id is deterministically generated from node name.
	ID *NodeID `json:"Id,omitempty"`
	// InstanceID - The id representing the node instance. While the Id of the node is deterministically generated from the node name and remains same across restarts, the InstanceId changes every time node restarts.
	InstanceID *string `json:"InstanceId,omitempty"`
	// NodeDeactivationInfo - Information about the node deactivation. This information is valid for a node that is undergoing deactivation or has already been deactivated.
	NodeDeactivationInfo *NodeDeactivationInfo `json:"NodeDeactivationInfo,omitempty"`
	// IsStopped - Indicates if the node is stopped by calling stop node API or not. Returns true if the node is stopped, otherwise false.
	IsStopped *bool `json:"IsStopped,omitempty"`
	// NodeDownTimeInSeconds - Time in seconds since the node has been in NodeStatus Down. Value zero indicates node is not NodeStatus Down.
	NodeDownTimeInSeconds *string `json:"NodeDownTimeInSeconds,omitempty"`
	// NodeUpAt - Date time in UTC when the node came up. If the node has never been up then this value will be zero date time.
	NodeUpAt *date.Time `json:"NodeUpAt,omitempty"`
	// NodeDownAt - Date time in UTC when the node went down. If node has never been down then this value will be zero date time.
	NodeDownAt *date.Time `json:"NodeDownAt,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeLoadInfo information about load on a Service Fabric node. It holds a summary of all metrics and their load
// on a node.
type NodeLoadInfo struct {
	autorest.Response `json:"-"`
	// NodeName - Name of the node for which the load information is provided by this object.
	NodeName *string `json:"NodeName,omitempty"`
	// NodeLoadMetricInformation - List that contains metrics and their load information on this node.
	NodeLoadMetricInformation *[]NodeLoadMetricInformation `json:"NodeLoadMetricInformation,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeLoadMetricInformation represents data structure that contains load information for a certain metric on a
// node.
type NodeLoadMetricInformation struct {
	// Name - Name of the metric for which this load information is provided.
	Name *string `json:"Name,omitempty"`
	// NodeCapacity - Total capacity on the node for this metric.
	NodeCapacity *string `json:"NodeCapacity,omitempty"`
	// NodeLoad - Current load on the node for this metric.
	NodeLoad *string `json:"NodeLoad,omitempty"`
	// NodeRemainingCapacity - The remaining capacity on the node for this metric.
	NodeRemainingCapacity *string `json:"NodeRemainingCapacity,omitempty"`
	// IsCapacityViolation - Indicates if there is a capacity violation for this metric on the node.
	IsCapacityViolation *bool `json:"IsCapacityViolation,omitempty"`
	// NodeBufferedCapacity - The value that indicates the reserved capacity for this metric on the node.
	NodeBufferedCapacity *string `json:"NodeBufferedCapacity,omitempty"`
	// NodeRemainingBufferedCapacity - The remaining reserved capacity for this metric on the node.
	NodeRemainingBufferedCapacity *string `json:"NodeRemainingBufferedCapacity,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeRepairImpactDescription describes the expected impact of a repair on a set of nodes.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type NodeRepairImpactDescription struct {
	// NodeImpactList - The list of nodes impacted by a repair action and their respective expected impact.
	NodeImpactList *[]NodeImpact `json:"NodeImpactList,omitempty"`
	// Kind - Possible values include: 'KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase', 'KindBasicRepairImpactDescriptionBaseKindNode'
	Kind KindBasicRepairImpactDescriptionBase `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NodeRepairImpactDescription.
func (nrid NodeRepairImpactDescription) MarshalJSON() ([]byte, error) {
	nrid.Kind = KindBasicRepairImpactDescriptionBaseKindNode
	objectMap := make(map[string]interface{})
	if nrid.NodeImpactList != nil {
		objectMap["NodeImpactList"] = nrid.NodeImpactList
	}
	if nrid.Kind != "" {
		objectMap["Kind"] = nrid.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeRepairImpactDescription is the BasicRepairImpactDescriptionBase implementation for NodeRepairImpactDescription.
func (nrid NodeRepairImpactDescription) AsNodeRepairImpactDescription() (*NodeRepairImpactDescription, bool) {
	return &nrid, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsRepairImpactDescriptionBase is the BasicRepairImpactDescriptionBase implementation for NodeRepairImpactDescription.
func (nrid NodeRepairImpactDescription) AsRepairImpactDescriptionBase() (*RepairImpactDescriptionBase, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicRepairImpactDescriptionBase is the BasicRepairImpactDescriptionBase implementation for NodeRepairImpactDescription.
func (nrid NodeRepairImpactDescription) AsBasicRepairImpactDescriptionBase() (BasicRepairImpactDescriptionBase, bool) {
	return &nrid, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeRepairTargetDescription describes the list of nodes targeted by a repair action.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type NodeRepairTargetDescription struct {
	// NodeNames - The list of nodes targeted by a repair action.
	NodeNames *[]string `json:"NodeNames,omitempty"`
	// Kind - Possible values include: 'KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase', 'KindBasicRepairTargetDescriptionBaseKindNode'
	Kind KindBasicRepairTargetDescriptionBase `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NodeRepairTargetDescription.
func (nrtd NodeRepairTargetDescription) MarshalJSON() ([]byte, error) {
	nrtd.Kind = KindBasicRepairTargetDescriptionBaseKindNode
	objectMap := make(map[string]interface{})
	if nrtd.NodeNames != nil {
		objectMap["NodeNames"] = nrtd.NodeNames
	}
	if nrtd.Kind != "" {
		objectMap["Kind"] = nrtd.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeRepairTargetDescription is the BasicRepairTargetDescriptionBase implementation for NodeRepairTargetDescription.
func (nrtd NodeRepairTargetDescription) AsNodeRepairTargetDescription() (*NodeRepairTargetDescription, bool) {
	return &nrtd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsRepairTargetDescriptionBase is the BasicRepairTargetDescriptionBase implementation for NodeRepairTargetDescription.
func (nrtd NodeRepairTargetDescription) AsRepairTargetDescriptionBase() (*RepairTargetDescriptionBase, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicRepairTargetDescriptionBase is the BasicRepairTargetDescriptionBase implementation for NodeRepairTargetDescription.
func (nrtd NodeRepairTargetDescription) AsBasicRepairTargetDescriptionBase() (BasicRepairTargetDescriptionBase, bool) {
	return &nrtd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeResult contains information about a node that was targeted by a user-induced operation.
type NodeResult struct {
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// NodeInstanceID - The node instance id.
	NodeInstanceID *string `json:"NodeInstanceId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodesHealthEvaluation represents health evaluation for nodes, containing health evaluations for each unhealthy
// node that impacted current aggregated health state. Can be returned when evaluating cluster health and the
// aggregated health state is either Error or Warning.
type NodesHealthEvaluation struct {
	// MaxPercentUnhealthyNodes - Maximum allowed percentage of unhealthy nodes from the ClusterHealthPolicy.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// TotalCount - Total number of nodes found in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy NodeHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) MarshalJSON() ([]byte, error) {
	nhe.Kind = KindNodes
	objectMap := make(map[string]interface{})
	if nhe.MaxPercentUnhealthyNodes != nil {
		objectMap["MaxPercentUnhealthyNodes"] = nhe.MaxPercentUnhealthyNodes
	}
	if nhe.TotalCount != nil {
		objectMap["TotalCount"] = nhe.TotalCount
	}
	if nhe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = nhe.UnhealthyEvaluations
	}
	if nhe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = nhe.AggregatedHealthState
	}
	if nhe.Description != nil {
		objectMap["Description"] = nhe.Description
	}
	if nhe.Kind != "" {
		objectMap["Kind"] = nhe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return &nhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for NodesHealthEvaluation.
func (nhe NodesHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &nhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeTransitionProgress information about an NodeTransition operation.  This class contains an OperationState and
// a NodeTransitionResult.  The NodeTransitionResult is not valid until OperationState
// is Completed or Faulted.
type NodeTransitionProgress struct {
	autorest.Response `json:"-"`
	// State - The state of the operation. Possible values include: 'OperationStateInvalid', 'OperationStateRunning', 'OperationStateRollingBack', 'OperationStateCompleted', 'OperationStateFaulted', 'OperationStateCancelled', 'OperationStateForceCancelled'
	State OperationState `json:"State,omitempty"`
	// NodeTransitionResult - Represents information about an operation in a terminal state (Completed or Faulted).
	NodeTransitionResult *NodeTransitionResult `json:"NodeTransitionResult,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeTransitionResult represents information about an operation in a terminal state (Completed or Faulted).
type NodeTransitionResult struct {
	// ErrorCode - If OperationState is Completed, this is 0.  If OperationState is Faulted, this is an error code indicating the reason.
	ErrorCode *int32 `json:"ErrorCode,omitempty"`
	// NodeResult - Contains information about a node that was targeted by a user-induced operation.
	NodeResult *NodeResult `json:"NodeResult,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NodeUpgradeProgressInfo information about the upgrading node and its status
type NodeUpgradeProgressInfo struct {
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// UpgradePhase - The state of the upgrading node. Possible values include: 'NodeUpgradePhaseInvalid', 'NodeUpgradePhasePreUpgradeSafetyCheck', 'NodeUpgradePhaseUpgrading', 'NodeUpgradePhasePostUpgradeSafetyCheck'
	UpgradePhase NodeUpgradePhase `json:"UpgradePhase,omitempty"`
	// PendingSafetyChecks - List of pending safety checks
	PendingSafetyChecks *[]SafetyCheckWrapper `json:"PendingSafetyChecks,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// OperationStatus contains the OperationId, OperationState, and OperationType for user-induced operations.
type OperationStatus struct {
	// OperationID - A GUID that identifies a call to this API.  This is also passed into the corresponding GetProgress API.
	OperationID *uuid.UUID `json:"OperationId,omitempty"`
	// State - The state of the operation. Possible values include: 'OperationStateInvalid', 'OperationStateRunning', 'OperationStateRollingBack', 'OperationStateCompleted', 'OperationStateFaulted', 'OperationStateCancelled', 'OperationStateForceCancelled'
	State OperationState `json:"State,omitempty"`
	// Type - The type of the operation. Possible values include: 'OperationTypeInvalid', 'OperationTypePartitionDataLoss', 'OperationTypePartitionQuorumLoss', 'OperationTypePartitionRestart', 'OperationTypeNodeTransition'
	Type OperationType `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PackageSharingPolicyInfo represents a policy for the package sharing.
type PackageSharingPolicyInfo struct {
	// SharedPackageName - The name of code, configuration or data package that should be shared.
	SharedPackageName *string `json:"SharedPackageName,omitempty"`
	// PackageSharingScope - Represents the scope for PackageSharingPolicy. This is specified during DeployServicePackageToNode operation. Possible values include: 'PackageSharingPolicyScopeNone', 'PackageSharingPolicyScopeAll', 'PackageSharingPolicyScopeCode', 'PackageSharingPolicyScopeConfig', 'PackageSharingPolicyScopeData'
	PackageSharingScope PackageSharingPolicyScope `json:"PackageSharingScope,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedApplicationInfoList the list of applications in the cluster. The list is paged when all of the results
// cannot fit in a single message. The next set of results can be obtained by executing the same query with the
// continuation token provided in this list.
type PagedApplicationInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of application information.
	Items *[]ApplicationInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedApplicationTypeInfoList the list of application types that are provisioned or being provisioned in the
// cluster. The list is paged when all of the results cannot fit in a single message. The next set of results can
// be obtained by executing the same query with the continuation token provided in this list.
type PagedApplicationTypeInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of application type information.
	Items *[]ApplicationTypeInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedComposeDeploymentStatusInfoList the list of compose deployments in the cluster. The list is paged when all
// of the results cannot fit in a single message. The next set of results can be obtained by executing the same
// query with the continuation token provided in this list.
type PagedComposeDeploymentStatusInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of compose deployment status information.
	Items *[]ComposeDeploymentStatusInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedDeployedApplicationInfoList the list of deployed applications in activating, downloading, or active states
// on a node.
// The list is paged when all of the results cannot fit in a single message.
// The next set of results can be obtained by executing the same query with the continuation token provided in this
// list.
type PagedDeployedApplicationInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of deployed application information.
	Items *[]DeployedApplicationInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedNodeInfoList the list of nodes in the cluster. The list is paged when all of the results cannot fit in a
// single message. The next set of results can be obtained by executing the same query with the continuation token
// provided in this list.
type PagedNodeInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of node information.
	Items *[]NodeInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedPropertyInfoList the paged list of Service Fabric properties under a given name. The list is paged when all
// of the results cannot fit in a single message. The next set of results can be obtained by executing the same
// query with the continuation token provided in this list.
type PagedPropertyInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// IsConsistent - Indicates whether any property under the given name has been modified during the enumeration. If there was a modification, this property value is false.
	IsConsistent *bool `json:"IsConsistent,omitempty"`
	// Properties - List of property information.
	Properties *[]PropertyInfo `json:"Properties,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedReplicaInfoList the list of replicas in the cluster for a given partition. The list is paged when all of
// the results cannot fit in a single message. The next set of results can be obtained by executing the same query
// with the continuation token provided in this list.
type PagedReplicaInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of replica information.
	Items *[]BasicReplicaInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PagedReplicaInfoList struct.
func (pril *PagedReplicaInfoList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ContinuationToken":
			if v != nil {
				var continuationToken string
				err = json.Unmarshal(*v, &continuationToken)
				if err != nil {
					return err
				}
				pril.ContinuationToken = &continuationToken
			}
		case "Items":
			if v != nil {
				items, err := unmarshalBasicReplicaInfoArray(*v)
				if err != nil {
					return err
				}
				pril.Items = &items
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedServiceInfoList the list of services in the cluster for an application. The list is paged when all of the
// results cannot fit in a single message. The next set of results can be obtained by executing the same query with
// the continuation token provided in this list.
type PagedServiceInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of service information.
	Items *[]BasicServiceInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PagedServiceInfoList struct.
func (psil *PagedServiceInfoList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ContinuationToken":
			if v != nil {
				var continuationToken string
				err = json.Unmarshal(*v, &continuationToken)
				if err != nil {
					return err
				}
				psil.ContinuationToken = &continuationToken
			}
		case "Items":
			if v != nil {
				items, err := unmarshalBasicServiceInfoArray(*v)
				if err != nil {
					return err
				}
				psil.Items = &items
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedServicePartitionInfoList the list of partition in the cluster for a service. The list is paged when all of
// the results cannot fit in a single message. The next set of results can be obtained by executing the same query
// with the continuation token provided in this list.
type PagedServicePartitionInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// Items - List of service partition information.
	Items *[]BasicServicePartitionInfo `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PagedServicePartitionInfoList struct.
func (pspil *PagedServicePartitionInfoList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ContinuationToken":
			if v != nil {
				var continuationToken string
				err = json.Unmarshal(*v, &continuationToken)
				if err != nil {
					return err
				}
				pspil.ContinuationToken = &continuationToken
			}
		case "Items":
			if v != nil {
				items, err := unmarshalBasicServicePartitionInfoArray(*v)
				if err != nil {
					return err
				}
				pspil.Items = &items
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PagedSubNameInfoList a paged list of Service Fabric names. The list is paged when all of the results cannot fit
// in a single message. The next set of results can be obtained by executing the same query with the continuation
// token provided in this list.
type PagedSubNameInfoList struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// IsConsistent - Indicates whether any name under the given name has been modified during the enumeration. If there was a modification, this property value is false.
	IsConsistent *bool `json:"IsConsistent,omitempty"`
	// SubNames - List of the child names.
	SubNames *[]string `json:"SubNames,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionDataLossProgress information about a partition data loss user-induced operation.
type PartitionDataLossProgress struct {
	autorest.Response `json:"-"`
	// State - The state of the operation. Possible values include: 'OperationStateInvalid', 'OperationStateRunning', 'OperationStateRollingBack', 'OperationStateCompleted', 'OperationStateFaulted', 'OperationStateCancelled', 'OperationStateForceCancelled'
	State OperationState `json:"State,omitempty"`
	// InvokeDataLossResult - Represents information about an operation in a terminal state (Completed or Faulted).
	InvokeDataLossResult *InvokeDataLossResult `json:"InvokeDataLossResult,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealth information about the health of a Service Fabric partition.
type PartitionHealth struct {
	autorest.Response `json:"-"`
	// PartitionID - ID of the partition whose health information is described by this object.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaHealthStates - The list of replica health states associated with the partition.
	ReplicaHealthStates *[]BasicReplicaHealthState `json:"ReplicaHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PartitionHealth struct.
func (ph *PartitionHealth) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "PartitionId":
			if v != nil {
				var partitionID uuid.UUID
				err = json.Unmarshal(*v, &partitionID)
				if err != nil {
					return err
				}
				ph.PartitionID = &partitionID
			}
		case "ReplicaHealthStates":
			if v != nil {
				replicaHealthStates, err := unmarshalBasicReplicaHealthStateArray(*v)
				if err != nil {
					return err
				}
				ph.ReplicaHealthStates = &replicaHealthStates
			}
		case "AggregatedHealthState":
			if v != nil {
				var aggregatedHealthState HealthState
				err = json.Unmarshal(*v, &aggregatedHealthState)
				if err != nil {
					return err
				}
				ph.AggregatedHealthState = aggregatedHealthState
			}
		case "HealthEvents":
			if v != nil {
				var healthEvents []HealthEvent
				err = json.Unmarshal(*v, &healthEvents)
				if err != nil {
					return err
				}
				ph.HealthEvents = &healthEvents
			}
		case "UnhealthyEvaluations":
			if v != nil {
				var unhealthyEvaluations []HealthEvaluationWrapper
				err = json.Unmarshal(*v, &unhealthyEvaluations)
				if err != nil {
					return err
				}
				ph.UnhealthyEvaluations = &unhealthyEvaluations
			}
		case "HealthStatistics":
			if v != nil {
				var healthStatistics HealthStatistics
				err = json.Unmarshal(*v, &healthStatistics)
				if err != nil {
					return err
				}
				ph.HealthStatistics = &healthStatistics
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealthEvaluation represents health evaluation for a partition, containing information about the data
// and the algorithm used by health store to evaluate health. The evaluation is returned only when the aggregated
// health state is either Error or Warning.
type PartitionHealthEvaluation struct {
	// PartitionID - Id of the partition whose health evaluation is described by this object.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the partition. The types of the unhealthy evaluations can be ReplicasHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) MarshalJSON() ([]byte, error) {
	phe.Kind = KindPartition
	objectMap := make(map[string]interface{})
	if phe.PartitionID != nil {
		objectMap["PartitionId"] = phe.PartitionID
	}
	if phe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = phe.UnhealthyEvaluations
	}
	if phe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = phe.AggregatedHealthState
	}
	if phe.Description != nil {
		objectMap["Description"] = phe.Description
	}
	if phe.Kind != "" {
		objectMap["Kind"] = phe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return &phe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for PartitionHealthEvaluation.
func (phe PartitionHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &phe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealthState represents the health state of a partition, which contains the partition identifier and its
// aggregated health state.
type PartitionHealthState struct {
	// PartitionID - Id of the partition whose health state is described by this object.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealthStateChunk represents the health state chunk of a partition, which contains the partition id, its
// aggregated health state and any replicas that respect the filters in the cluster health chunk query description.
type PartitionHealthStateChunk struct {
	// PartitionID - The Id of the partition.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaHealthStateChunks - The list of replica health state chunks belonging to the partition that respect the filters in the cluster health chunk query description.
	ReplicaHealthStateChunks *ReplicaHealthStateChunkList `json:"ReplicaHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealthStateChunkList the list of partition health state chunks that respect the input filters in the
// chunk query description.
// Returned by get cluster health state chunks query as part of the parent application hierarchy.
type PartitionHealthStateChunkList struct {
	// Items - The list of partition health state chunks that respect the input filters in the chunk query.
	Items *[]PartitionHealthStateChunk `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionHealthStateFilter defines matching criteria to determine whether a partition should be included as a
// child of a service in the cluster health chunk.
// The partitions are only returned if the parent entities match a filter specified in the cluster health chunk
// query description. The parent service and application must be included in the cluster health chunk.
// One filter can match zero, one or multiple partitions, depending on its properties.
type PartitionHealthStateFilter struct {
	// PartitionIDFilter - ID of the partition that matches the filter. The filter is applied only to the specified partition, if it exists.
	// If the partition doesn't exist, no partition is returned in the cluster health chunk based on this filter.
	// If the partition exists, it is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all partitions that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	PartitionIDFilter *uuid.UUID `json:"PartitionIdFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the partitions. It allows selecting partitions if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only partitions that match the filter are returned. All partitions are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the partition id is specified. If the filter has default value and partition id is specified, the matching partition is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches partitions with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// ReplicaFilters - Defines a list of filters that specify which replicas to be included in the returned cluster health chunk as children of the parent partition. The replicas are returned only if the parent partition matches a filter.
	// If the list is empty, no replicas are returned. All the replicas are used to evaluate the parent partition aggregated health state, regardless of the input filters.
	// The partition filter may specify multiple replica filters.
	// For example, it can specify a filter to return all replicas with health state Error and another filter to always include a replica identified by its replica id.
	ReplicaFilters *[]ReplicaHealthStateFilter `json:"ReplicaFilters,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPartitionInformation information about the partition identity, partitioning scheme and keys supported by it.
type BasicPartitionInformation interface {
	AsInt64RangePartitionInformation() (*Int64RangePartitionInformation, bool)
	AsNamedPartitionInformation() (*NamedPartitionInformation, bool)
	AsSingletonPartitionInformation() (*SingletonPartitionInformation, bool)
	AsPartitionInformation() (*PartitionInformation, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionInformation information about the partition identity, partitioning scheme and keys supported by it.
type PartitionInformation struct {
	// ID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	ID *uuid.UUID `json:"Id,omitempty"`
	// ServicePartitionKind - Possible values include: 'ServicePartitionKindPartitionInformation', 'ServicePartitionKindInt64Range', 'ServicePartitionKindNamed', 'ServicePartitionKindSingleton'
	ServicePartitionKind ServicePartitionKind `json:"ServicePartitionKind,omitempty"`
}

func unmarshalBasicPartitionInformation(body []byte) (BasicPartitionInformation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServicePartitionKind"] {
	case string(ServicePartitionKindInt64Range):
		var i6rpi Int64RangePartitionInformation
		err := json.Unmarshal(body, &i6rpi)
		return i6rpi, err
	case string(ServicePartitionKindNamed):
		var npi NamedPartitionInformation
		err := json.Unmarshal(body, &npi)
		return npi, err
	case string(ServicePartitionKindSingleton):
		var spi SingletonPartitionInformation
		err := json.Unmarshal(body, &spi)
		return spi, err
	default:
		var pi PartitionInformation
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicPartitionInformationArray(body []byte) ([]BasicPartitionInformation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicPartitionInformation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicPartitionInformation(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PartitionInformation.
func (pi PartitionInformation) MarshalJSON() ([]byte, error) {
	pi.ServicePartitionKind = ServicePartitionKindPartitionInformation
	objectMap := make(map[string]interface{})
	if pi.ID != nil {
		objectMap["Id"] = pi.ID
	}
	if pi.ServicePartitionKind != "" {
		objectMap["ServicePartitionKind"] = pi.ServicePartitionKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64RangePartitionInformation is the BasicPartitionInformation implementation for PartitionInformation.
func (pi PartitionInformation) AsInt64RangePartitionInformation() (*Int64RangePartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionInformation is the BasicPartitionInformation implementation for PartitionInformation.
func (pi PartitionInformation) AsNamedPartitionInformation() (*NamedPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionInformation is the BasicPartitionInformation implementation for PartitionInformation.
func (pi PartitionInformation) AsSingletonPartitionInformation() (*SingletonPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionInformation is the BasicPartitionInformation implementation for PartitionInformation.
func (pi PartitionInformation) AsPartitionInformation() (*PartitionInformation, bool) {
	return &pi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionInformation is the BasicPartitionInformation implementation for PartitionInformation.
func (pi PartitionInformation) AsBasicPartitionInformation() (BasicPartitionInformation, bool) {
	return &pi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionLoadInformation represents load information for a partition, which contains the primary and secondary
// reported load metrics.
// In case there is no load reported, PartitionLoadInformation will contain the default load for the service of the
// partition.
// For default loads, LoadMetricReport's LastReportedUtc is set to 0.
type PartitionLoadInformation struct {
	autorest.Response `json:"-"`
	// PartitionID - Id of the partition.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// PrimaryLoadMetricReports - Array of load reports from the primary replica for this partition.
	PrimaryLoadMetricReports *[]LoadMetricReport `json:"PrimaryLoadMetricReports,omitempty"`
	// SecondaryLoadMetricReports - Array of aggregated load reports from all secondary replicas for this partition.
	// Array only contains the latest reported load for each metric.
	SecondaryLoadMetricReports *[]LoadMetricReport `json:"SecondaryLoadMetricReports,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionQuorumLossProgress information about a partition quorum loss user-induced operation.
type PartitionQuorumLossProgress struct {
	autorest.Response `json:"-"`
	// State - The state of the operation. Possible values include: 'OperationStateInvalid', 'OperationStateRunning', 'OperationStateRollingBack', 'OperationStateCompleted', 'OperationStateFaulted', 'OperationStateCancelled', 'OperationStateForceCancelled'
	State OperationState `json:"State,omitempty"`
	// InvokeQuorumLossResult - Represents information about an operation in a terminal state (Completed or Faulted).
	InvokeQuorumLossResult *InvokeQuorumLossResult `json:"InvokeQuorumLossResult,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionRestartProgress information about a partition restart user-induced operation.
type PartitionRestartProgress struct {
	autorest.Response `json:"-"`
	// State - The state of the operation. Possible values include: 'OperationStateInvalid', 'OperationStateRunning', 'OperationStateRollingBack', 'OperationStateCompleted', 'OperationStateFaulted', 'OperationStateCancelled', 'OperationStateForceCancelled'
	State OperationState `json:"State,omitempty"`
	// RestartPartitionResult - Represents information about an operation in a terminal state (Completed or Faulted).
	RestartPartitionResult *RestartPartitionResult `json:"RestartPartitionResult,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPartitionSafetyCheck represents a safety check for the service partition being performed by service fabric
// before continuing with operations.
type BasicPartitionSafetyCheck interface {
	AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool)
	AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool)
	AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool)
	AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool)
	AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool)
	AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool)
	AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionSafetyCheck represents a safety check for the service partition being performed by service fabric
// before continuing with operations.
type PartitionSafetyCheck struct {
	// PartitionID - Id of the partition which is undergoing the safety check.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// Kind - Possible values include: 'KindSafetyCheck', 'KindPartitionSafetyCheck', 'KindEnsureAvailability', 'KindEnsurePartitionQuorum', 'KindEnsureSeedNodeQuorum', 'KindWaitForInbuildReplica', 'KindWaitForPrimaryPlacement', 'KindWaitForPrimarySwap', 'KindWaitForReconfiguration'
	Kind KindBasicSafetyCheck `json:"Kind,omitempty"`
}

func unmarshalBasicPartitionSafetyCheck(body []byte) (BasicPartitionSafetyCheck, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindEnsureAvailability):
		var easc EnsureAvailabilitySafetyCheck
		err := json.Unmarshal(body, &easc)
		return easc, err
	case string(KindEnsurePartitionQuorum):
		var epqsc EnsurePartitionQurumSafetyCheck
		err := json.Unmarshal(body, &epqsc)
		return epqsc, err
	case string(KindWaitForInbuildReplica):
		var wfirsc WaitForInbuildReplicaSafetyCheck
		err := json.Unmarshal(body, &wfirsc)
		return wfirsc, err
	case string(KindWaitForPrimaryPlacement):
		var wfppsc WaitForPrimaryPlacementSafetyCheck
		err := json.Unmarshal(body, &wfppsc)
		return wfppsc, err
	case string(KindWaitForPrimarySwap):
		var wfpssc WaitForPrimarySwapSafetyCheck
		err := json.Unmarshal(body, &wfpssc)
		return wfpssc, err
	case string(KindWaitForReconfiguration):
		var wfrsc WaitForReconfigurationSafetyCheck
		err := json.Unmarshal(body, &wfrsc)
		return wfrsc, err
	default:
		var psc PartitionSafetyCheck
		err := json.Unmarshal(body, &psc)
		return psc, err
	}
}
func unmarshalBasicPartitionSafetyCheckArray(body []byte) ([]BasicPartitionSafetyCheck, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pscArray := make([]BasicPartitionSafetyCheck, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psc, err := unmarshalBasicPartitionSafetyCheck(*rawMessage)
		if err != nil {
			return nil, err
		}
		pscArray[index] = psc
	}
	return pscArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) MarshalJSON() ([]byte, error) {
	psc.Kind = KindPartitionSafetyCheck
	objectMap := make(map[string]interface{})
	if psc.PartitionID != nil {
		objectMap["PartitionId"] = psc.PartitionID
	}
	if psc.Kind != "" {
		objectMap["Kind"] = psc.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool) {
	return &psc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool) {
	return &psc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsureAvailabilitySafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsurePartitionQurumSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSeedNodeSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForInbuildReplicaSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimaryPlacementSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimarySwapSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForReconfigurationSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsSafetyCheck() (*SafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSafetyCheck is the BasicSafetyCheck implementation for PartitionSafetyCheck.
func (psc PartitionSafetyCheck) AsBasicSafetyCheck() (BasicSafetyCheck, bool) {
	return &psc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPartitionSchemeDescription describes how the service is partitioned.
type BasicPartitionSchemeDescription interface {
	AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool)
	AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool)
	AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool)
	AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionSchemeDescription describes how the service is partitioned.
type PartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed1', 'PartitionSchemeSingleton1', 'PartitionSchemeUniformInt64Range1'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"PartitionScheme,omitempty"`
}

func unmarshalBasicPartitionSchemeDescription(body []byte) (BasicPartitionSchemeDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["PartitionScheme"] {
	case string(PartitionSchemeNamed1):
		var npsd NamedPartitionSchemeDescription
		err := json.Unmarshal(body, &npsd)
		return npsd, err
	case string(PartitionSchemeSingleton1):
		var spsd SingletonPartitionSchemeDescription
		err := json.Unmarshal(body, &spsd)
		return spsd, err
	case string(PartitionSchemeUniformInt64Range1):
		var ui6rpsd UniformInt64RangePartitionSchemeDescription
		err := json.Unmarshal(body, &ui6rpsd)
		return ui6rpsd, err
	default:
		var psd PartitionSchemeDescription
		err := json.Unmarshal(body, &psd)
		return psd, err
	}
}
func unmarshalBasicPartitionSchemeDescriptionArray(body []byte) ([]BasicPartitionSchemeDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psdArray := make([]BasicPartitionSchemeDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psd, err := unmarshalBasicPartitionSchemeDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		psdArray[index] = psd
	}
	return psdArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	psd.PartitionScheme = PartitionSchemePartitionSchemeDescription
	objectMap := make(map[string]interface{})
	if psd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = psd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return &psd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &psd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PartitionsHealthEvaluation represents health evaluation for the partitions of a service, containing health
// evaluations for each unhealthy partition that impacts current aggregated health state. Can be returned when
// evaluating service health and the aggregated health state is either Error or Warning.
type PartitionsHealthEvaluation struct {
	// MaxPercentUnhealthyPartitionsPerService - Maximum allowed percentage of unhealthy partitions per service from the ServiceTypeHealthPolicy.
	MaxPercentUnhealthyPartitionsPerService *int32 `json:"MaxPercentUnhealthyPartitionsPerService,omitempty"`
	// TotalCount - Total number of partitions of the service from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy PartitionHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) MarshalJSON() ([]byte, error) {
	phe.Kind = KindPartitions
	objectMap := make(map[string]interface{})
	if phe.MaxPercentUnhealthyPartitionsPerService != nil {
		objectMap["MaxPercentUnhealthyPartitionsPerService"] = phe.MaxPercentUnhealthyPartitionsPerService
	}
	if phe.TotalCount != nil {
		objectMap["TotalCount"] = phe.TotalCount
	}
	if phe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = phe.UnhealthyEvaluations
	}
	if phe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = phe.AggregatedHealthState
	}
	if phe.Description != nil {
		objectMap["Description"] = phe.Description
	}
	if phe.Kind != "" {
		objectMap["Kind"] = phe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return &phe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for PartitionsHealthEvaluation.
func (phe PartitionsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &phe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PrimaryReplicatorStatus provides statistics about the Service Fabric Replicator, when it is functioning in a
// Primary role.
type PrimaryReplicatorStatus struct {
	// ReplicationQueueStatus - Details about the replication queue on the primary replicator.
	ReplicationQueueStatus *ReplicatorQueueStatus `json:"ReplicationQueueStatus,omitempty"`
	// RemoteReplicators - The status of all the active and idle secondary replicators that the primary is aware of.
	RemoteReplicators *[]RemoteReplicatorStatus `json:"RemoteReplicators,omitempty"`
	// Kind - Possible values include: 'KindReplicatorStatus', 'KindPrimary', 'KindSecondaryReplicatorStatus', 'KindActiveSecondary', 'KindIdleSecondary'
	Kind KindBasicReplicatorStatus `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) MarshalJSON() ([]byte, error) {
	prs.Kind = KindPrimary
	objectMap := make(map[string]interface{})
	if prs.ReplicationQueueStatus != nil {
		objectMap["ReplicationQueueStatus"] = prs.ReplicationQueueStatus
	}
	if prs.RemoteReplicators != nil {
		objectMap["RemoteReplicators"] = prs.RemoteReplicators
	}
	if prs.Kind != "" {
		objectMap["Kind"] = prs.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPrimaryReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool) {
	return &prs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryActiveReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryIdleReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsReplicatorStatus() (*ReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicatorStatus is the BasicReplicatorStatus implementation for PrimaryReplicatorStatus.
func (prs PrimaryReplicatorStatus) AsBasicReplicatorStatus() (BasicReplicatorStatus, bool) {
	return &prs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchDescriptionList describes a list of property batch operations to be executed. Either all or none of
// the operations will be committed.
type PropertyBatchDescriptionList struct {
	// Operations - A list of the property batch operations to be executed.
	Operations *[]BasicPropertyBatchOperation `json:"Operations,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PropertyBatchDescriptionList struct.
func (pbdl *PropertyBatchDescriptionList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Operations":
			if v != nil {
				operations, err := unmarshalBasicPropertyBatchOperationArray(*v)
				if err != nil {
					return err
				}
				pbdl.Operations = &operations
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPropertyBatchInfo information about the results of a property batch.
type BasicPropertyBatchInfo interface {
	AsSuccessfulPropertyBatchInfo() (*SuccessfulPropertyBatchInfo, bool)
	AsFailedPropertyBatchInfo() (*FailedPropertyBatchInfo, bool)
	AsPropertyBatchInfo() (*PropertyBatchInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchInfo information about the results of a property batch.
type PropertyBatchInfo struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindPropertyBatchInfo', 'KindSuccessful', 'KindFailed'
	Kind KindBasicPropertyBatchInfo `json:"Kind,omitempty"`
}

func unmarshalBasicPropertyBatchInfo(body []byte) (BasicPropertyBatchInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindSuccessful):
		var spbi SuccessfulPropertyBatchInfo
		err := json.Unmarshal(body, &spbi)
		return spbi, err
	case string(KindFailed):
		var fpbi FailedPropertyBatchInfo
		err := json.Unmarshal(body, &fpbi)
		return fpbi, err
	default:
		var pbi PropertyBatchInfo
		err := json.Unmarshal(body, &pbi)
		return pbi, err
	}
}
func unmarshalBasicPropertyBatchInfoArray(body []byte) ([]BasicPropertyBatchInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pbiArray := make([]BasicPropertyBatchInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pbi, err := unmarshalBasicPropertyBatchInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		pbiArray[index] = pbi
	}
	return pbiArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PropertyBatchInfo.
func (pbi PropertyBatchInfo) MarshalJSON() ([]byte, error) {
	pbi.Kind = KindPropertyBatchInfo
	objectMap := make(map[string]interface{})
	if pbi.Kind != "" {
		objectMap["Kind"] = pbi.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSuccessfulPropertyBatchInfo is the BasicPropertyBatchInfo implementation for PropertyBatchInfo.
func (pbi PropertyBatchInfo) AsSuccessfulPropertyBatchInfo() (*SuccessfulPropertyBatchInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsFailedPropertyBatchInfo is the BasicPropertyBatchInfo implementation for PropertyBatchInfo.
func (pbi PropertyBatchInfo) AsFailedPropertyBatchInfo() (*FailedPropertyBatchInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchInfo is the BasicPropertyBatchInfo implementation for PropertyBatchInfo.
func (pbi PropertyBatchInfo) AsPropertyBatchInfo() (*PropertyBatchInfo, bool) {
	return &pbi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchInfo is the BasicPropertyBatchInfo implementation for PropertyBatchInfo.
func (pbi PropertyBatchInfo) AsBasicPropertyBatchInfo() (BasicPropertyBatchInfo, bool) {
	return &pbi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchInfoModel ...
type PropertyBatchInfoModel struct {
	autorest.Response `json:"-"`
	Value             BasicPropertyBatchInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PropertyBatchInfoModel struct.
func (pbim *PropertyBatchInfoModel) UnmarshalJSON(body []byte) error {
	pbi, err := unmarshalBasicPropertyBatchInfo(body)
	if err != nil {
		return err
	}
	pbim.Value = pbi

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPropertyBatchOperation represents the base type for property operations that can be put into a batch and
// submitted.
type BasicPropertyBatchOperation interface {
	AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool)
	AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool)
	AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool)
	AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool)
	AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool)
	AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool)
	AsPropertyBatchOperation() (*PropertyBatchOperation, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyBatchOperation represents the base type for property operations that can be put into a batch and
// submitted.
type PropertyBatchOperation struct {
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

func unmarshalBasicPropertyBatchOperation(body []byte) (BasicPropertyBatchOperation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindCheckExists):
		var cepbo CheckExistsPropertyBatchOperation
		err := json.Unmarshal(body, &cepbo)
		return cepbo, err
	case string(KindCheckSequence):
		var cspbo CheckSequencePropertyBatchOperation
		err := json.Unmarshal(body, &cspbo)
		return cspbo, err
	case string(KindCheckValue):
		var cvpbo CheckValuePropertyBatchOperation
		err := json.Unmarshal(body, &cvpbo)
		return cvpbo, err
	case string(KindDelete):
		var dpbo DeletePropertyBatchOperation
		err := json.Unmarshal(body, &dpbo)
		return dpbo, err
	case string(KindGet):
		var gpbo GetPropertyBatchOperation
		err := json.Unmarshal(body, &gpbo)
		return gpbo, err
	case string(KindPut):
		var ppbo PutPropertyBatchOperation
		err := json.Unmarshal(body, &ppbo)
		return ppbo, err
	default:
		var pbo PropertyBatchOperation
		err := json.Unmarshal(body, &pbo)
		return pbo, err
	}
}
func unmarshalBasicPropertyBatchOperationArray(body []byte) ([]BasicPropertyBatchOperation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pboArray := make([]BasicPropertyBatchOperation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pbo, err := unmarshalBasicPropertyBatchOperation(*rawMessage)
		if err != nil {
			return nil, err
		}
		pboArray[index] = pbo
	}
	return pboArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PropertyBatchOperation.
func (pbo PropertyBatchOperation) MarshalJSON() ([]byte, error) {
	pbo.Kind = KindPropertyBatchOperation
	objectMap := make(map[string]interface{})
	if pbo.PropertyName != nil {
		objectMap["PropertyName"] = pbo.PropertyName
	}
	if pbo.Kind != "" {
		objectMap["Kind"] = pbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return &pbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PropertyBatchOperation.
func (pbo PropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &pbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyDescription description of a Service Fabric property.
type PropertyDescription struct {
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// CustomTypeID - The property's custom type id. Using this property, the user is able to tag the type of the value of the property.
	CustomTypeID *string `json:"CustomTypeId,omitempty"`
	// Value - Describes a Service Fabric property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PropertyDescription struct.
func (pd *PropertyDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "PropertyName":
			if v != nil {
				var propertyName string
				err = json.Unmarshal(*v, &propertyName)
				if err != nil {
					return err
				}
				pd.PropertyName = &propertyName
			}
		case "CustomTypeId":
			if v != nil {
				var customTypeID string
				err = json.Unmarshal(*v, &customTypeID)
				if err != nil {
					return err
				}
				pd.CustomTypeID = &customTypeID
			}
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				pd.Value = value
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyInfo information about a Service Fabric property.
type PropertyInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of the Service Fabric property.
	Name *string `json:"Name,omitempty"`
	// Value - Describes a Service Fabric property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
	// Metadata - The metadata associated with a property, including the property's name.
	Metadata *PropertyMetadata `json:"Metadata,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PropertyInfo struct.
func (pi *PropertyInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pi.Name = &name
			}
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				pi.Value = value
			}
		case "Metadata":
			if v != nil {
				var metadata PropertyMetadata
				err = json.Unmarshal(*v, &metadata)
				if err != nil {
					return err
				}
				pi.Metadata = &metadata
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyMetadata the metadata associated with a property, including the property's name.
type PropertyMetadata struct {
	// TypeID - The kind of property, determined by the type of data. Following are the possible values. Possible values include: 'PropertyValueKindInvalid', 'PropertyValueKindBinary', 'PropertyValueKindInt64', 'PropertyValueKindDouble', 'PropertyValueKindString', 'PropertyValueKindGUID'
	TypeID PropertyValueKind `json:"TypeId,omitempty"`
	// CustomTypeID - The property's custom type id.
	CustomTypeID *string `json:"CustomTypeId,omitempty"`
	// Parent - The name of the parent Service Fabric Name for the property. It could be thought of as the namespace/table under which the property exists.
	Parent *string `json:"Parent,omitempty"`
	// SizeInBytes - The length of the serialized property value.
	SizeInBytes *int32 `json:"SizeInBytes,omitempty"`
	// LastModifiedUtcTimestamp - Represents when the Property was last modified. Only write operations will cause this field to be updated.
	LastModifiedUtcTimestamp *date.Time `json:"LastModifiedUtcTimestamp,omitempty"`
	// SequenceNumber - The version of the property. Every time a property is modified, its sequence number is increased.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicPropertyValue describes a Service Fabric property value.
type BasicPropertyValue interface {
	AsBinaryPropertyValue() (*BinaryPropertyValue, bool)
	AsInt64PropertyValue() (*Int64PropertyValue, bool)
	AsDoublePropertyValue() (*DoublePropertyValue, bool)
	AsStringPropertyValue() (*StringPropertyValue, bool)
	AsGUIDPropertyValue() (*GUIDPropertyValue, bool)
	AsPropertyValue() (*PropertyValue, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PropertyValue describes a Service Fabric property value.
type PropertyValue struct {
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

func unmarshalBasicPropertyValue(body []byte) (BasicPropertyValue, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindBinary):
		var bpv BinaryPropertyValue
		err := json.Unmarshal(body, &bpv)
		return bpv, err
	case string(KindInt64):
		var i6pv Int64PropertyValue
		err := json.Unmarshal(body, &i6pv)
		return i6pv, err
	case string(KindDouble):
		var dpv DoublePropertyValue
		err := json.Unmarshal(body, &dpv)
		return dpv, err
	case string(KindString):
		var spv StringPropertyValue
		err := json.Unmarshal(body, &spv)
		return spv, err
	case string(KindGUID):
		var gpv GUIDPropertyValue
		err := json.Unmarshal(body, &gpv)
		return gpv, err
	default:
		var pv PropertyValue
		err := json.Unmarshal(body, &pv)
		return pv, err
	}
}
func unmarshalBasicPropertyValueArray(body []byte) ([]BasicPropertyValue, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pvArray := make([]BasicPropertyValue, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pv, err := unmarshalBasicPropertyValue(*rawMessage)
		if err != nil {
			return nil, err
		}
		pvArray[index] = pv
	}
	return pvArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PropertyValue.
func (pv PropertyValue) MarshalJSON() ([]byte, error) {
	pv.Kind = KindPropertyValue
	objectMap := make(map[string]interface{})
	if pv.Kind != "" {
		objectMap["Kind"] = pv.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBinaryPropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64PropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDoublePropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStringPropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGUIDPropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return &pv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyValue is the BasicPropertyValue implementation for PropertyValue.
func (pv PropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &pv, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ProvisionApplicationTypeDescription describes the operation to register or provision an application type using
// an application package uploaded to the Service Fabric image store.
type ProvisionApplicationTypeDescription struct {
	// ApplicationTypeBuildPath - The relative path for the application package in the image store specified during the prior upload operation.
	ApplicationTypeBuildPath *string `json:"ApplicationTypeBuildPath,omitempty"`
	// Async - Indicates whether or not provisioning should occur asynchronously. When set to true, the provision operation returns when the request is accepted by the system, and the provision operation continues without any timeout limit. The default value is false. For large application packages, we recommend setting the value to true.
	Async *bool `json:"Async,omitempty"`
	// Kind - Possible values include: 'KindProvisionApplicationTypeDescriptionBase', 'KindImageStorePath', 'KindExternalStore'
	Kind KindBasicProvisionApplicationTypeDescriptionBase `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ProvisionApplicationTypeDescription.
func (patd ProvisionApplicationTypeDescription) MarshalJSON() ([]byte, error) {
	patd.Kind = KindImageStorePath
	objectMap := make(map[string]interface{})
	if patd.ApplicationTypeBuildPath != nil {
		objectMap["ApplicationTypeBuildPath"] = patd.ApplicationTypeBuildPath
	}
	if patd.Async != nil {
		objectMap["Async"] = patd.Async
	}
	if patd.Kind != "" {
		objectMap["Kind"] = patd.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescription.
func (patd ProvisionApplicationTypeDescription) AsProvisionApplicationTypeDescription() (*ProvisionApplicationTypeDescription, bool) {
	return &patd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExternalStoreProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescription.
func (patd ProvisionApplicationTypeDescription) AsExternalStoreProvisionApplicationTypeDescription() (*ExternalStoreProvisionApplicationTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescription.
func (patd ProvisionApplicationTypeDescription) AsProvisionApplicationTypeDescriptionBase() (*ProvisionApplicationTypeDescriptionBase, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescription.
func (patd ProvisionApplicationTypeDescription) AsBasicProvisionApplicationTypeDescriptionBase() (BasicProvisionApplicationTypeDescriptionBase, bool) {
	return &patd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicProvisionApplicationTypeDescriptionBase represents the type of registration or provision requested, and if the
// operation needs to be asynchronous or not. Supported types of provision operations are from either image store or
// external store.
type BasicProvisionApplicationTypeDescriptionBase interface {
	AsProvisionApplicationTypeDescription() (*ProvisionApplicationTypeDescription, bool)
	AsExternalStoreProvisionApplicationTypeDescription() (*ExternalStoreProvisionApplicationTypeDescription, bool)
	AsProvisionApplicationTypeDescriptionBase() (*ProvisionApplicationTypeDescriptionBase, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ProvisionApplicationTypeDescriptionBase represents the type of registration or provision requested, and if the
// operation needs to be asynchronous or not. Supported types of provision operations are from either image store
// or external store.
type ProvisionApplicationTypeDescriptionBase struct {
	// Async - Indicates whether or not provisioning should occur asynchronously. When set to true, the provision operation returns when the request is accepted by the system, and the provision operation continues without any timeout limit. The default value is false. For large application packages, we recommend setting the value to true.
	Async *bool `json:"Async,omitempty"`
	// Kind - Possible values include: 'KindProvisionApplicationTypeDescriptionBase', 'KindImageStorePath', 'KindExternalStore'
	Kind KindBasicProvisionApplicationTypeDescriptionBase `json:"Kind,omitempty"`
}

func unmarshalBasicProvisionApplicationTypeDescriptionBase(body []byte) (BasicProvisionApplicationTypeDescriptionBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindImageStorePath):
		var patd ProvisionApplicationTypeDescription
		err := json.Unmarshal(body, &patd)
		return patd, err
	case string(KindExternalStore):
		var espatd ExternalStoreProvisionApplicationTypeDescription
		err := json.Unmarshal(body, &espatd)
		return espatd, err
	default:
		var patdb ProvisionApplicationTypeDescriptionBase
		err := json.Unmarshal(body, &patdb)
		return patdb, err
	}
}
func unmarshalBasicProvisionApplicationTypeDescriptionBaseArray(body []byte) ([]BasicProvisionApplicationTypeDescriptionBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	patdbArray := make([]BasicProvisionApplicationTypeDescriptionBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		patdb, err := unmarshalBasicProvisionApplicationTypeDescriptionBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		patdbArray[index] = patdb
	}
	return patdbArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ProvisionApplicationTypeDescriptionBase.
func (patdb ProvisionApplicationTypeDescriptionBase) MarshalJSON() ([]byte, error) {
	patdb.Kind = KindProvisionApplicationTypeDescriptionBase
	objectMap := make(map[string]interface{})
	if patdb.Async != nil {
		objectMap["Async"] = patdb.Async
	}
	if patdb.Kind != "" {
		objectMap["Kind"] = patdb.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescriptionBase.
func (patdb ProvisionApplicationTypeDescriptionBase) AsProvisionApplicationTypeDescription() (*ProvisionApplicationTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExternalStoreProvisionApplicationTypeDescription is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescriptionBase.
func (patdb ProvisionApplicationTypeDescriptionBase) AsExternalStoreProvisionApplicationTypeDescription() (*ExternalStoreProvisionApplicationTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescriptionBase.
func (patdb ProvisionApplicationTypeDescriptionBase) AsProvisionApplicationTypeDescriptionBase() (*ProvisionApplicationTypeDescriptionBase, bool) {
	return &patdb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicProvisionApplicationTypeDescriptionBase is the BasicProvisionApplicationTypeDescriptionBase implementation for ProvisionApplicationTypeDescriptionBase.
func (patdb ProvisionApplicationTypeDescriptionBase) AsBasicProvisionApplicationTypeDescriptionBase() (BasicProvisionApplicationTypeDescriptionBase, bool) {
	return &patdb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ProvisionFabricDescription describes the parameters for provisioning a cluster.
type ProvisionFabricDescription struct {
	// CodeFilePath - The cluster code package file path.
	CodeFilePath *string `json:"CodeFilePath,omitempty"`
	// ClusterManifestFilePath - The cluster manifest file path.
	ClusterManifestFilePath *string `json:"ClusterManifestFilePath,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// PutPropertyBatchOperation puts the specified property under the specified name.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type PutPropertyBatchOperation struct {
	// Value - Describes a Service Fabric property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
	// CustomTypeID - The property's custom type id. Using this property, the user is able to tag the type of the value of the property.
	CustomTypeID *string `json:"CustomTypeId,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) MarshalJSON() ([]byte, error) {
	ppbo.Kind = KindPut
	objectMap := make(map[string]interface{})
	objectMap["Value"] = ppbo.Value
	if ppbo.CustomTypeID != nil {
		objectMap["CustomTypeId"] = ppbo.CustomTypeID
	}
	if ppbo.PropertyName != nil {
		objectMap["PropertyName"] = ppbo.PropertyName
	}
	if ppbo.Kind != "" {
		objectMap["Kind"] = ppbo.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return &ppbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for PutPropertyBatchOperation.
func (ppbo PutPropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &ppbo, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for PutPropertyBatchOperation struct.
func (ppbo *PutPropertyBatchOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				ppbo.Value = value
			}
		case "CustomTypeId":
			if v != nil {
				var customTypeID string
				err = json.Unmarshal(*v, &customTypeID)
				if err != nil {
					return err
				}
				ppbo.CustomTypeID = &customTypeID
			}
		case "PropertyName":
			if v != nil {
				var propertyName string
				err = json.Unmarshal(*v, &propertyName)
				if err != nil {
					return err
				}
				ppbo.PropertyName = &propertyName
			}
		case "Kind":
			if v != nil {
				var kind KindBasicPropertyBatchOperation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ppbo.Kind = kind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReconfigurationInformation information about current reconfiguration like phase, type, previous configuration
// role of replica and reconfiguration start date time.
type ReconfigurationInformation struct {
	// PreviousConfigurationRole - Replica role before reconfiguration started. Possible values include: 'ReplicaRoleUnknown', 'ReplicaRoleNone', 'ReplicaRolePrimary', 'ReplicaRoleIdleSecondary', 'ReplicaRoleActiveSecondary'
	PreviousConfigurationRole ReplicaRole `json:"PreviousConfigurationRole,omitempty"`
	// ReconfigurationPhase - Current phase of ongoing reconfiguration. If no reconfiguration is taking place then this value will be "None". Possible values include: 'ReconfigurationPhaseUnknown', 'ReconfigurationPhaseNone', 'ReconfigurationPhasePhase0', 'ReconfigurationPhasePhase1', 'ReconfigurationPhasePhase2', 'ReconfigurationPhasePhase3', 'ReconfigurationPhasePhase4', 'ReconfigurationPhaseAbortPhaseZero'
	ReconfigurationPhase ReconfigurationPhase `json:"ReconfigurationPhase,omitempty"`
	// ReconfigurationType - Type of current ongoing reconfiguration. If no reconfiguration is taking place then this value will be "None". Possible values include: 'ReconfigurationTypeUnknown', 'ReconfigurationTypeSwapPrimary', 'ReconfigurationTypeFailover', 'ReconfigurationTypeOther'
	ReconfigurationType ReconfigurationType `json:"ReconfigurationType,omitempty"`
	// ReconfigurationStartTimeUtc - Start time (in UTC) of the ongoing reconfiguration. If no reconfiguration is taking place then this value will be zero date-time.
	ReconfigurationStartTimeUtc *date.Time `json:"ReconfigurationStartTimeUtc,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RegistryCredential credential information to connect to container registry.
type RegistryCredential struct {
	// RegistryUserName - The user name to connect to container registry.
	RegistryUserName *string `json:"RegistryUserName,omitempty"`
	// RegistryPassword - The password for supplied username to connect to container registry.
	RegistryPassword *string `json:"RegistryPassword,omitempty"`
	// PasswordEncrypted - Indicates that supplied container registry password is encrypted.
	PasswordEncrypted *bool `json:"PasswordEncrypted,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RemoteReplicatorAcknowledgementDetail provides various statistics of the acknowledgements that are being
// received from the remote replicator.
type RemoteReplicatorAcknowledgementDetail struct {
	// AverageReceiveDuration - Represents the average duration it takes for the remote replicator to receive an operation.
	AverageReceiveDuration *string `json:"AverageReceiveDuration,omitempty"`
	// AverageApplyDuration - Represents the average duration it takes for the remote replicator to apply an operation. This usually entails writing the operation to disk.
	AverageApplyDuration *string `json:"AverageApplyDuration,omitempty"`
	// NotReceivedCount - Represents the number of operations not yet received by a remote replicator.
	NotReceivedCount *string `json:"NotReceivedCount,omitempty"`
	// ReceivedAndNotAppliedCount - Represents the number of operations received and not yet applied by a remote replicator.
	ReceivedAndNotAppliedCount *string `json:"ReceivedAndNotAppliedCount,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RemoteReplicatorAcknowledgementStatus provides details about the remote replicators from the primary
// replicator's point of view.
type RemoteReplicatorAcknowledgementStatus struct {
	// ReplicationStreamAcknowledgementDetail - Details about the acknowledgements for operations that are part of the replication stream data.
	ReplicationStreamAcknowledgementDetail *RemoteReplicatorAcknowledgementDetail `json:"ReplicationStreamAcknowledgementDetail,omitempty"`
	// CopyStreamAcknowledgementDetail - Details about the acknowledgements for operations that are part of the copy stream data.
	CopyStreamAcknowledgementDetail *RemoteReplicatorAcknowledgementDetail `json:"CopyStreamAcknowledgementDetail,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RemoteReplicatorStatus represents the state of the secondary replicator from the primary replicator’s point of
// view.
type RemoteReplicatorStatus struct {
	// ReplicaID - Represents the replica id of the remote secondary replicator.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// LastAcknowledgementProcessedTimeUtc - The last timestamp (in UTC) when an acknowledgement from the secondary replicator was processed on the primary.
	// UTC 0 represents an invalid value, indicating that no acknowledgement messages were ever processed.
	LastAcknowledgementProcessedTimeUtc *date.Time `json:"LastAcknowledgementProcessedTimeUtc,omitempty"`
	// LastReceivedReplicationSequenceNumber - The highest replication operation sequence number that the secondary has received from the primary.
	LastReceivedReplicationSequenceNumber *string `json:"LastReceivedReplicationSequenceNumber,omitempty"`
	// LastAppliedReplicationSequenceNumber - The highest replication operation sequence number that the secondary has applied to its state.
	LastAppliedReplicationSequenceNumber *string `json:"LastAppliedReplicationSequenceNumber,omitempty"`
	// IsInBuild - A value that indicates whether the secondary replica is in the process of being built.
	IsInBuild *bool `json:"IsInBuild,omitempty"`
	// LastReceivedCopySequenceNumber - The highest copy operation sequence number that the secondary has received from the primary.
	// A value of -1 implies that the secondary has received all copy operations.
	LastReceivedCopySequenceNumber *string `json:"LastReceivedCopySequenceNumber,omitempty"`
	// LastAppliedCopySequenceNumber - The highest copy operation sequence number that the secondary has applied to its state.
	// A value of -1 implies that the secondary has applied all copy operations and the copy process is complete.
	LastAppliedCopySequenceNumber *string `json:"LastAppliedCopySequenceNumber,omitempty"`
	// RemoteReplicatorAcknowledgementStatus - Represents the acknowledgement status for the remote secondary replicator.
	RemoteReplicatorAcknowledgementStatus *RemoteReplicatorAcknowledgementStatus `json:"RemoteReplicatorAcknowledgementStatus,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicRepairImpactDescriptionBase describes the expected impact of executing a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type BasicRepairImpactDescriptionBase interface {
	AsNodeRepairImpactDescription() (*NodeRepairImpactDescription, bool)
	AsRepairImpactDescriptionBase() (*RepairImpactDescriptionBase, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairImpactDescriptionBase describes the expected impact of executing a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairImpactDescriptionBase struct {
	// Kind - Possible values include: 'KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase', 'KindBasicRepairImpactDescriptionBaseKindNode'
	Kind KindBasicRepairImpactDescriptionBase `json:"Kind,omitempty"`
}

func unmarshalBasicRepairImpactDescriptionBase(body []byte) (BasicRepairImpactDescriptionBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindBasicRepairImpactDescriptionBaseKindNode):
		var nrid NodeRepairImpactDescription
		err := json.Unmarshal(body, &nrid)
		return nrid, err
	default:
		var ridb RepairImpactDescriptionBase
		err := json.Unmarshal(body, &ridb)
		return ridb, err
	}
}
func unmarshalBasicRepairImpactDescriptionBaseArray(body []byte) ([]BasicRepairImpactDescriptionBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ridbArray := make([]BasicRepairImpactDescriptionBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ridb, err := unmarshalBasicRepairImpactDescriptionBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		ridbArray[index] = ridb
	}
	return ridbArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for RepairImpactDescriptionBase.
func (ridb RepairImpactDescriptionBase) MarshalJSON() ([]byte, error) {
	ridb.Kind = KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase
	objectMap := make(map[string]interface{})
	if ridb.Kind != "" {
		objectMap["Kind"] = ridb.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeRepairImpactDescription is the BasicRepairImpactDescriptionBase implementation for RepairImpactDescriptionBase.
func (ridb RepairImpactDescriptionBase) AsNodeRepairImpactDescription() (*NodeRepairImpactDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsRepairImpactDescriptionBase is the BasicRepairImpactDescriptionBase implementation for RepairImpactDescriptionBase.
func (ridb RepairImpactDescriptionBase) AsRepairImpactDescriptionBase() (*RepairImpactDescriptionBase, bool) {
	return &ridb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicRepairImpactDescriptionBase is the BasicRepairImpactDescriptionBase implementation for RepairImpactDescriptionBase.
func (ridb RepairImpactDescriptionBase) AsBasicRepairImpactDescriptionBase() (BasicRepairImpactDescriptionBase, bool) {
	return &ridb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicRepairTargetDescriptionBase describes the entities targeted by a repair action.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type BasicRepairTargetDescriptionBase interface {
	AsNodeRepairTargetDescription() (*NodeRepairTargetDescription, bool)
	AsRepairTargetDescriptionBase() (*RepairTargetDescriptionBase, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTargetDescriptionBase describes the entities targeted by a repair action.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTargetDescriptionBase struct {
	// Kind - Possible values include: 'KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase', 'KindBasicRepairTargetDescriptionBaseKindNode'
	Kind KindBasicRepairTargetDescriptionBase `json:"Kind,omitempty"`
}

func unmarshalBasicRepairTargetDescriptionBase(body []byte) (BasicRepairTargetDescriptionBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindBasicRepairTargetDescriptionBaseKindNode):
		var nrtd NodeRepairTargetDescription
		err := json.Unmarshal(body, &nrtd)
		return nrtd, err
	default:
		var rtdb RepairTargetDescriptionBase
		err := json.Unmarshal(body, &rtdb)
		return rtdb, err
	}
}
func unmarshalBasicRepairTargetDescriptionBaseArray(body []byte) ([]BasicRepairTargetDescriptionBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rtdbArray := make([]BasicRepairTargetDescriptionBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rtdb, err := unmarshalBasicRepairTargetDescriptionBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rtdbArray[index] = rtdb
	}
	return rtdbArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for RepairTargetDescriptionBase.
func (rtdb RepairTargetDescriptionBase) MarshalJSON() ([]byte, error) {
	rtdb.Kind = KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase
	objectMap := make(map[string]interface{})
	if rtdb.Kind != "" {
		objectMap["Kind"] = rtdb.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeRepairTargetDescription is the BasicRepairTargetDescriptionBase implementation for RepairTargetDescriptionBase.
func (rtdb RepairTargetDescriptionBase) AsNodeRepairTargetDescription() (*NodeRepairTargetDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsRepairTargetDescriptionBase is the BasicRepairTargetDescriptionBase implementation for RepairTargetDescriptionBase.
func (rtdb RepairTargetDescriptionBase) AsRepairTargetDescriptionBase() (*RepairTargetDescriptionBase, bool) {
	return &rtdb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicRepairTargetDescriptionBase is the BasicRepairTargetDescriptionBase implementation for RepairTargetDescriptionBase.
func (rtdb RepairTargetDescriptionBase) AsBasicRepairTargetDescriptionBase() (BasicRepairTargetDescriptionBase, bool) {
	return &rtdb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTask represents a repair task, which includes information about what kind of repair was requested, what
// its progress is, and what its final result was.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTask struct {
	// TaskID - The ID of the repair task.
	TaskID *string `json:"TaskId,omitempty"`
	// Version - The version of the repair task.
	// When creating a new repair task, the version must be set to zero.  When updating a repair task,
	// the version is used for optimistic concurrency checks.  If the version is
	// set to zero, the update will not check for write conflicts.  If the version is set to a non-zero value, then the
	// update will only succeed if the actual current version of the repair task matches this value.
	Version *string `json:"Version,omitempty"`
	// Description - A description of the purpose of the repair task, or other informational details.
	// May be set when the repair task is created, and is immutable once set.
	Description *string `json:"Description,omitempty"`
	// State - The workflow state of the repair task. Valid initial states are Created, Claimed, and Preparing. Possible values include: 'StateInvalid', 'StateCreated', 'StateClaimed', 'StatePreparing', 'StateApproved', 'StateExecuting', 'StateRestoring', 'StateCompleted'
	State State `json:"State,omitempty"`
	// Flags - A bitwise-OR of the following values, which gives additional details about the status of the repair task.
	// - 1 - Cancellation of the repair has been requested
	// - 2 - Abort of the repair has been requested
	// - 4 - Approval of the repair was forced via client request
	Flags *int32 `json:"Flags,omitempty"`
	// Action - The requested repair action. Must be specified when the repair task is created, and is immutable once set.
	Action *string `json:"Action,omitempty"`
	// Target - The target object determines what actions the system will take to prepare for the impact of the repair, prior to approving execution of the repair.
	// May be set when the repair task is created, and is immutable once set.
	Target BasicRepairTargetDescriptionBase `json:"Target,omitempty"`
	// Executor - The name of the repair executor. Must be specified in Claimed and later states, and is immutable once set.
	Executor *string `json:"Executor,omitempty"`
	// ExecutorData - A data string that the repair executor can use to store its internal state.
	ExecutorData *string `json:"ExecutorData,omitempty"`
	// Impact - The impact object determines what actions the system will take to prepare for the impact of the repair, prior to approving execution of the repair.
	// Impact must be specified by the repair executor when transitioning to the Preparing state, and is immutable once set.
	Impact BasicRepairImpactDescriptionBase `json:"Impact,omitempty"`
	// ResultStatus - A value describing the overall result of the repair task execution. Must be specified in the Restoring and later states, and is immutable once set. Possible values include: 'ResultStatusInvalid', 'ResultStatusSucceeded', 'ResultStatusCancelled', 'ResultStatusInterrupted', 'ResultStatusFailed', 'ResultStatusPending'
	ResultStatus ResultStatus `json:"ResultStatus,omitempty"`
	// ResultCode - A numeric value providing additional details about the result of the repair task execution.
	// May be specified in the Restoring and later states, and is immutable once set.
	ResultCode *int32 `json:"ResultCode,omitempty"`
	// ResultDetails - A string providing additional details about the result of the repair task execution.
	// May be specified in the Restoring and later states, and is immutable once set.
	ResultDetails *string `json:"ResultDetails,omitempty"`
	// History - An object that contains timestamps of the repair task's state transitions.
	// These timestamps are updated by the system, and cannot be directly modified.
	History *RepairTaskHistory `json:"History,omitempty"`
	// PreparingHealthCheckState - The workflow state of the health check when the repair task is in the Preparing state. Possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
	PreparingHealthCheckState RepairTaskHealthCheckState `json:"PreparingHealthCheckState,omitempty"`
	// RestoringHealthCheckState - The workflow state of the health check when the repair task is in the Restoring state. Possible values include: 'NotStarted', 'InProgress', 'Succeeded', 'Skipped', 'TimedOut'
	RestoringHealthCheckState RepairTaskHealthCheckState `json:"RestoringHealthCheckState,omitempty"`
	// PerformPreparingHealthCheck - A value to determine if health checks will be performed when the repair task enters the Preparing state.
	PerformPreparingHealthCheck *bool `json:"PerformPreparingHealthCheck,omitempty"`
	// PerformRestoringHealthCheck - A value to determine if health checks will be performed when the repair task enters the Restoring state.
	PerformRestoringHealthCheck *bool `json:"PerformRestoringHealthCheck,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for RepairTask struct.
func (rt *RepairTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "TaskId":
			if v != nil {
				var taskID string
				err = json.Unmarshal(*v, &taskID)
				if err != nil {
					return err
				}
				rt.TaskID = &taskID
			}
		case "Version":
			if v != nil {
				var version string
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				rt.Version = &version
			}
		case "Description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				rt.Description = &description
			}
		case "State":
			if v != nil {
				var state State
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				rt.State = state
			}
		case "Flags":
			if v != nil {
				var flags int32
				err = json.Unmarshal(*v, &flags)
				if err != nil {
					return err
				}
				rt.Flags = &flags
			}
		case "Action":
			if v != nil {
				var action string
				err = json.Unmarshal(*v, &action)
				if err != nil {
					return err
				}
				rt.Action = &action
			}
		case "Target":
			if v != nil {
				target, err := unmarshalBasicRepairTargetDescriptionBase(*v)
				if err != nil {
					return err
				}
				rt.Target = target
			}
		case "Executor":
			if v != nil {
				var executor string
				err = json.Unmarshal(*v, &executor)
				if err != nil {
					return err
				}
				rt.Executor = &executor
			}
		case "ExecutorData":
			if v != nil {
				var executorData string
				err = json.Unmarshal(*v, &executorData)
				if err != nil {
					return err
				}
				rt.ExecutorData = &executorData
			}
		case "Impact":
			if v != nil {
				impact, err := unmarshalBasicRepairImpactDescriptionBase(*v)
				if err != nil {
					return err
				}
				rt.Impact = impact
			}
		case "ResultStatus":
			if v != nil {
				var resultStatus ResultStatus
				err = json.Unmarshal(*v, &resultStatus)
				if err != nil {
					return err
				}
				rt.ResultStatus = resultStatus
			}
		case "ResultCode":
			if v != nil {
				var resultCode int32
				err = json.Unmarshal(*v, &resultCode)
				if err != nil {
					return err
				}
				rt.ResultCode = &resultCode
			}
		case "ResultDetails":
			if v != nil {
				var resultDetails string
				err = json.Unmarshal(*v, &resultDetails)
				if err != nil {
					return err
				}
				rt.ResultDetails = &resultDetails
			}
		case "History":
			if v != nil {
				var history RepairTaskHistory
				err = json.Unmarshal(*v, &history)
				if err != nil {
					return err
				}
				rt.History = &history
			}
		case "PreparingHealthCheckState":
			if v != nil {
				var preparingHealthCheckState RepairTaskHealthCheckState
				err = json.Unmarshal(*v, &preparingHealthCheckState)
				if err != nil {
					return err
				}
				rt.PreparingHealthCheckState = preparingHealthCheckState
			}
		case "RestoringHealthCheckState":
			if v != nil {
				var restoringHealthCheckState RepairTaskHealthCheckState
				err = json.Unmarshal(*v, &restoringHealthCheckState)
				if err != nil {
					return err
				}
				rt.RestoringHealthCheckState = restoringHealthCheckState
			}
		case "PerformPreparingHealthCheck":
			if v != nil {
				var performPreparingHealthCheck bool
				err = json.Unmarshal(*v, &performPreparingHealthCheck)
				if err != nil {
					return err
				}
				rt.PerformPreparingHealthCheck = &performPreparingHealthCheck
			}
		case "PerformRestoringHealthCheck":
			if v != nil {
				var performRestoringHealthCheck bool
				err = json.Unmarshal(*v, &performRestoringHealthCheck)
				if err != nil {
					return err
				}
				rt.PerformRestoringHealthCheck = &performRestoringHealthCheck
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskApproveDescription describes a request for forced approval of a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskApproveDescription struct {
	// TaskID - The ID of the repair task.
	TaskID *string `json:"TaskId,omitempty"`
	// Version - The current version number of the repair task. If non-zero, then the request will only succeed if this value matches the actual current version of the repair task. If zero, then no version check is performed.
	Version *string `json:"Version,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskCancelDescription describes a request to cancel a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskCancelDescription struct {
	// TaskID - The ID of the repair task.
	TaskID *string `json:"TaskId,omitempty"`
	// Version - The current version number of the repair task. If non-zero, then the request will only succeed if this value matches the actual current version of the repair task. If zero, then no version check is performed.
	Version *string `json:"Version,omitempty"`
	// RequestAbort - _True_ if the repair should be stopped as soon as possible even if it has already started executing. _False_ if the repair should be cancelled only if execution has not yet started.
	RequestAbort *bool `json:"RequestAbort,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskDeleteDescription describes a request to delete a completed repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskDeleteDescription struct {
	// TaskID - The ID of the completed repair task to be deleted.
	TaskID *string `json:"TaskId,omitempty"`
	// Version - The current version number of the repair task. If non-zero, then the request will only succeed if this value matches the actual current version of the repair task. If zero, then no version check is performed.
	Version *string `json:"Version,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskHistory a record of the times when the repair task entered each state.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskHistory struct {
	// CreatedUtcTimestamp - The time when the repair task entered the Created state.
	CreatedUtcTimestamp *date.Time `json:"CreatedUtcTimestamp,omitempty"`
	// ClaimedUtcTimestamp - The time when the repair task entered the Claimed state.
	ClaimedUtcTimestamp *date.Time `json:"ClaimedUtcTimestamp,omitempty"`
	// PreparingUtcTimestamp - The time when the repair task entered the Preparing state.
	PreparingUtcTimestamp *date.Time `json:"PreparingUtcTimestamp,omitempty"`
	// ApprovedUtcTimestamp - The time when the repair task entered the Approved state
	ApprovedUtcTimestamp *date.Time `json:"ApprovedUtcTimestamp,omitempty"`
	// ExecutingUtcTimestamp - The time when the repair task entered the Executing state
	ExecutingUtcTimestamp *date.Time `json:"ExecutingUtcTimestamp,omitempty"`
	// RestoringUtcTimestamp - The time when the repair task entered the Restoring state
	RestoringUtcTimestamp *date.Time `json:"RestoringUtcTimestamp,omitempty"`
	// CompletedUtcTimestamp - The time when the repair task entered the Completed state
	CompletedUtcTimestamp *date.Time `json:"CompletedUtcTimestamp,omitempty"`
	// PreparingHealthCheckStartUtcTimestamp - The time when the repair task started the health check in the Preparing state.
	PreparingHealthCheckStartUtcTimestamp *date.Time `json:"PreparingHealthCheckStartUtcTimestamp,omitempty"`
	// PreparingHealthCheckEndUtcTimestamp - The time when the repair task completed the health check in the Preparing state.
	PreparingHealthCheckEndUtcTimestamp *date.Time `json:"PreparingHealthCheckEndUtcTimestamp,omitempty"`
	// RestoringHealthCheckStartUtcTimestamp - The time when the repair task started the health check in the Restoring state.
	RestoringHealthCheckStartUtcTimestamp *date.Time `json:"RestoringHealthCheckStartUtcTimestamp,omitempty"`
	// RestoringHealthCheckEndUtcTimestamp - The time when the repair task completed the health check in the Restoring state.
	RestoringHealthCheckEndUtcTimestamp *date.Time `json:"RestoringHealthCheckEndUtcTimestamp,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskUpdateHealthPolicyDescription describes a request to update the health policy of a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskUpdateHealthPolicyDescription struct {
	// TaskID - The ID of the repair task to be updated.
	TaskID *string `json:"TaskId,omitempty"`
	// Version - The current version number of the repair task. If non-zero, then the request will only succeed if this value matches the actual current value of the repair task. If zero, then no version check is performed.
	Version *string `json:"Version,omitempty"`
	// PerformPreparingHealthCheck - A boolean indicating if health check is to be performed in the Preparing stage of the repair task. If not specified the existing value should not be altered. Otherwise, specify the desired new value.
	PerformPreparingHealthCheck *bool `json:"PerformPreparingHealthCheck,omitempty"`
	// PerformRestoringHealthCheck - A boolean indicating if health check is to be performed in the Restoring stage of the repair task. If not specified the existing value should not be altered. Otherwise, specify the desired new value.
	PerformRestoringHealthCheck *bool `json:"PerformRestoringHealthCheck,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RepairTaskUpdateInfo describes the result of an operation that created or updated a repair task.
//
// This type supports the Service Fabric platform; it is not meant to be used directly from your code.
type RepairTaskUpdateInfo struct {
	autorest.Response `json:"-"`
	// Version - The new version of the repair task.
	Version *string `json:"Version,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicReplicaHealth represents a base class for stateful service replica or stateless service instance health.
// Contains the replica aggregated health state, the health events and the unhealthy evaluations.
type BasicReplicaHealth interface {
	AsStatefulServiceReplicaHealth() (*StatefulServiceReplicaHealth, bool)
	AsStatelessServiceInstanceHealth() (*StatelessServiceInstanceHealth, bool)
	AsReplicaHealth() (*ReplicaHealth, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealth represents a base class for stateful service replica or stateless service instance health.
// Contains the replica aggregated health state, the health events and the unhealthy evaluations.
type ReplicaHealth struct {
	autorest.Response `json:"-"`
	// PartitionID - Id of the partition to which this replica belongs.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaHealthServiceKindReplicaHealth', 'ServiceKindBasicReplicaHealthServiceKindStateful', 'ServiceKindBasicReplicaHealthServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaHealth `json:"ServiceKind,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

func unmarshalBasicReplicaHealth(body []byte) (BasicReplicaHealth, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicReplicaHealthServiceKindStateful):
		var ssrh StatefulServiceReplicaHealth
		err := json.Unmarshal(body, &ssrh)
		return ssrh, err
	case string(ServiceKindBasicReplicaHealthServiceKindStateless):
		var ssih StatelessServiceInstanceHealth
		err := json.Unmarshal(body, &ssih)
		return ssih, err
	default:
		var rh ReplicaHealth
		err := json.Unmarshal(body, &rh)
		return rh, err
	}
}
func unmarshalBasicReplicaHealthArray(body []byte) ([]BasicReplicaHealth, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rhArray := make([]BasicReplicaHealth, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rh, err := unmarshalBasicReplicaHealth(*rawMessage)
		if err != nil {
			return nil, err
		}
		rhArray[index] = rh
	}
	return rhArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicaHealth.
func (rh ReplicaHealth) MarshalJSON() ([]byte, error) {
	rh.ServiceKind = ServiceKindBasicReplicaHealthServiceKindReplicaHealth
	objectMap := make(map[string]interface{})
	if rh.PartitionID != nil {
		objectMap["PartitionId"] = rh.PartitionID
	}
	if rh.ServiceKind != "" {
		objectMap["ServiceKind"] = rh.ServiceKind
	}
	if rh.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = rh.AggregatedHealthState
	}
	if rh.HealthEvents != nil {
		objectMap["HealthEvents"] = rh.HealthEvents
	}
	if rh.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = rh.UnhealthyEvaluations
	}
	if rh.HealthStatistics != nil {
		objectMap["HealthStatistics"] = rh.HealthStatistics
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaHealth is the BasicReplicaHealth implementation for ReplicaHealth.
func (rh ReplicaHealth) AsStatefulServiceReplicaHealth() (*StatefulServiceReplicaHealth, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceHealth is the BasicReplicaHealth implementation for ReplicaHealth.
func (rh ReplicaHealth) AsStatelessServiceInstanceHealth() (*StatelessServiceInstanceHealth, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealth is the BasicReplicaHealth implementation for ReplicaHealth.
func (rh ReplicaHealth) AsReplicaHealth() (*ReplicaHealth, bool) {
	return &rh, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaHealth is the BasicReplicaHealth implementation for ReplicaHealth.
func (rh ReplicaHealth) AsBasicReplicaHealth() (BasicReplicaHealth, bool) {
	return &rh, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthEvaluation represents health evaluation for a replica, containing information about the data and
// the algorithm used by health store to evaluate health. The evaluation is returned only when the aggregated
// health state is either Error or Warning.
type ReplicaHealthEvaluation struct {
	// PartitionID - Id of the partition to which the replica belongs.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaOrInstanceID - Id of a stateful service replica or a stateless service instance. This id is used in the queries that apply to both stateful and stateless services. It is used by Service Fabric to uniquely identify a replica of a partition of a stateful service or an instance of a stateless service partition. It is unique within a partition and does not change for the lifetime of the replica or the instance. If a stateful replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. If a stateless instance is failed over on the same or different node it will get a different value for the id.
	ReplicaOrInstanceID *string `json:"ReplicaOrInstanceId,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the replica. The types of the unhealthy evaluations can be EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) MarshalJSON() ([]byte, error) {
	rhe.Kind = KindReplica
	objectMap := make(map[string]interface{})
	if rhe.PartitionID != nil {
		objectMap["PartitionId"] = rhe.PartitionID
	}
	if rhe.ReplicaOrInstanceID != nil {
		objectMap["ReplicaOrInstanceId"] = rhe.ReplicaOrInstanceID
	}
	if rhe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = rhe.UnhealthyEvaluations
	}
	if rhe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = rhe.AggregatedHealthState
	}
	if rhe.Description != nil {
		objectMap["Description"] = rhe.Description
	}
	if rhe.Kind != "" {
		objectMap["Kind"] = rhe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return &rhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ReplicaHealthEvaluation.
func (rhe ReplicaHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &rhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthModel ...
type ReplicaHealthModel struct {
	autorest.Response `json:"-"`
	Value             BasicReplicaHealth `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ReplicaHealthModel struct.
func (rhm *ReplicaHealthModel) UnmarshalJSON(body []byte) error {
	rh, err := unmarshalBasicReplicaHealth(body)
	if err != nil {
		return err
	}
	rhm.Value = rh

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicReplicaHealthState represents a base class for stateful service replica or stateless service instance health
// state.
type BasicReplicaHealthState interface {
	AsStatefulServiceReplicaHealthState() (*StatefulServiceReplicaHealthState, bool)
	AsStatelessServiceInstanceHealthState() (*StatelessServiceInstanceHealthState, bool)
	AsReplicaHealthState() (*ReplicaHealthState, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthState represents a base class for stateful service replica or stateless service instance health
// state.
type ReplicaHealthState struct {
	// PartitionID - The ID of the partition to which this replica belongs.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState', 'ServiceKindBasicReplicaHealthStateServiceKindStateful', 'ServiceKindBasicReplicaHealthStateServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaHealthState `json:"ServiceKind,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

func unmarshalBasicReplicaHealthState(body []byte) (BasicReplicaHealthState, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicReplicaHealthStateServiceKindStateful):
		var ssrhs StatefulServiceReplicaHealthState
		err := json.Unmarshal(body, &ssrhs)
		return ssrhs, err
	case string(ServiceKindBasicReplicaHealthStateServiceKindStateless):
		var ssihs StatelessServiceInstanceHealthState
		err := json.Unmarshal(body, &ssihs)
		return ssihs, err
	default:
		var RHS ReplicaHealthState
		err := json.Unmarshal(body, &RHS)
		return RHS, err
	}
}
func unmarshalBasicReplicaHealthStateArray(body []byte) ([]BasicReplicaHealthState, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	RHSArray := make([]BasicReplicaHealthState, len(rawMessages))

	for index, rawMessage := range rawMessages {
		RHS, err := unmarshalBasicReplicaHealthState(*rawMessage)
		if err != nil {
			return nil, err
		}
		RHSArray[index] = RHS
	}
	return RHSArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicaHealthState.
func (RHS ReplicaHealthState) MarshalJSON() ([]byte, error) {
	RHS.ServiceKind = ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState
	objectMap := make(map[string]interface{})
	if RHS.PartitionID != nil {
		objectMap["PartitionId"] = RHS.PartitionID
	}
	if RHS.ServiceKind != "" {
		objectMap["ServiceKind"] = RHS.ServiceKind
	}
	if RHS.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = RHS.AggregatedHealthState
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaHealthState is the BasicReplicaHealthState implementation for ReplicaHealthState.
func (RHS ReplicaHealthState) AsStatefulServiceReplicaHealthState() (*StatefulServiceReplicaHealthState, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceHealthState is the BasicReplicaHealthState implementation for ReplicaHealthState.
func (RHS ReplicaHealthState) AsStatelessServiceInstanceHealthState() (*StatelessServiceInstanceHealthState, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthState is the BasicReplicaHealthState implementation for ReplicaHealthState.
func (RHS ReplicaHealthState) AsReplicaHealthState() (*ReplicaHealthState, bool) {
	return &RHS, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaHealthState is the BasicReplicaHealthState implementation for ReplicaHealthState.
func (RHS ReplicaHealthState) AsBasicReplicaHealthState() (BasicReplicaHealthState, bool) {
	return &RHS, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthStateChunk represents the health state chunk of a stateful service replica or a stateless service
// instance.
// The replica health state contains the replica ID and its aggregated health state.
type ReplicaHealthStateChunk struct {
	// ReplicaOrInstanceID - Id of a stateful service replica or a stateless service instance. This id is used in the queries that apply to both stateful and stateless services. It is used by Service Fabric to uniquely identify a replica of a partition of a stateful service or an instance of a stateless service partition. It is unique within a partition and does not change for the lifetime of the replica or the instance. If a stateful replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. If a stateless instance is failed over on the same or different node it will get a different value for the id.
	ReplicaOrInstanceID *string `json:"ReplicaOrInstanceId,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthStateChunkList the list of replica health state chunks that respect the input filters in the chunk
// query. Returned by get cluster health state chunks query.
type ReplicaHealthStateChunkList struct {
	// Items - The list of replica health state chunks that respect the input filters in the chunk query.
	Items *[]ReplicaHealthStateChunk `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaHealthStateFilter defines matching criteria to determine whether a replica should be included as a child
// of a partition in the cluster health chunk.
// The replicas are only returned if the parent entities match a filter specified in the cluster health chunk query
// description. The parent partition, service and application must be included in the cluster health chunk.
// One filter can match zero, one or multiple replicas, depending on its properties.
type ReplicaHealthStateFilter struct {
	// ReplicaOrInstanceIDFilter - Id of the stateful service replica or stateless service instance that matches the filter. The filter is applied only to the specified replica, if it exists.
	// If the replica doesn't exist, no replica is returned in the cluster health chunk based on this filter.
	// If the replica exists, it is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all replicas that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	ReplicaOrInstanceIDFilter *string `json:"ReplicaOrInstanceIdFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the replicas. It allows selecting replicas if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only replicas that match the filter are returned. All replicas are used to evaluate the parent partition aggregated health state.
	// If not specified, default value is None, unless the replica id is specified. If the filter has default value and replica id is specified, the matching replica is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches replicas with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicReplicaInfo information about the identity, status, health, node name, uptime, and other details about the
// replica.
type BasicReplicaInfo interface {
	AsStatefulServiceReplicaInfo() (*StatefulServiceReplicaInfo, bool)
	AsStatelessServiceInstanceInfo() (*StatelessServiceInstanceInfo, bool)
	AsReplicaInfo() (*ReplicaInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaInfo information about the identity, status, health, node name, uptime, and other details about the
// replica.
type ReplicaInfo struct {
	autorest.Response `json:"-"`
	// ReplicaStatus - The status of a replica of a service. Possible values are following.
	//   -Invalid - Indicates the replica status is invalid. All Service Fabric enumerations have the invalid type. The value is zero.
	//   -InBuild - The replica is being built. This means that a primary replica is seeding this replica. The value is 1.
	//   -Standby - The replica is in standby. The value is 2.
	//   -Ready - The replica is ready. The value is 3.
	//   -Down - The replica is down. The value is 4.
	//   -Dropped - Replica is dropped. This means that the replica has been removed from the replica set. If it is persisted, its state has been deleted. The value is 5.
	// . Possible values include: 'ReplicaStatus1Invalid', 'ReplicaStatus1InBuild', 'ReplicaStatus1Standby', 'ReplicaStatus1Ready', 'ReplicaStatus1Down', 'ReplicaStatus1Dropped'
	ReplicaStatus ReplicaStatus1 `json:"ReplicaStatus,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// Address - The address the replica is listening on.
	Address *string `json:"Address,omitempty"`
	// LastInBuildDurationInSeconds - The last in build duration of the replica in seconds.
	LastInBuildDurationInSeconds *string `json:"LastInBuildDurationInSeconds,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaInfoServiceKindReplicaInfo', 'ServiceKindBasicReplicaInfoServiceKindStateful', 'ServiceKindBasicReplicaInfoServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaInfo `json:"ServiceKind,omitempty"`
}

func unmarshalBasicReplicaInfo(body []byte) (BasicReplicaInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicReplicaInfoServiceKindStateful):
		var ssri StatefulServiceReplicaInfo
		err := json.Unmarshal(body, &ssri)
		return ssri, err
	case string(ServiceKindBasicReplicaInfoServiceKindStateless):
		var ssii StatelessServiceInstanceInfo
		err := json.Unmarshal(body, &ssii)
		return ssii, err
	default:
		var ri ReplicaInfo
		err := json.Unmarshal(body, &ri)
		return ri, err
	}
}
func unmarshalBasicReplicaInfoArray(body []byte) ([]BasicReplicaInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	riArray := make([]BasicReplicaInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ri, err := unmarshalBasicReplicaInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		riArray[index] = ri
	}
	return riArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicaInfo.
func (ri ReplicaInfo) MarshalJSON() ([]byte, error) {
	ri.ServiceKind = ServiceKindBasicReplicaInfoServiceKindReplicaInfo
	objectMap := make(map[string]interface{})
	if ri.ReplicaStatus != "" {
		objectMap["ReplicaStatus"] = ri.ReplicaStatus
	}
	if ri.HealthState != "" {
		objectMap["HealthState"] = ri.HealthState
	}
	if ri.NodeName != nil {
		objectMap["NodeName"] = ri.NodeName
	}
	if ri.Address != nil {
		objectMap["Address"] = ri.Address
	}
	if ri.LastInBuildDurationInSeconds != nil {
		objectMap["LastInBuildDurationInSeconds"] = ri.LastInBuildDurationInSeconds
	}
	if ri.ServiceKind != "" {
		objectMap["ServiceKind"] = ri.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaInfo is the BasicReplicaInfo implementation for ReplicaInfo.
func (ri ReplicaInfo) AsStatefulServiceReplicaInfo() (*StatefulServiceReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceInfo is the BasicReplicaInfo implementation for ReplicaInfo.
func (ri ReplicaInfo) AsStatelessServiceInstanceInfo() (*StatelessServiceInstanceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaInfo is the BasicReplicaInfo implementation for ReplicaInfo.
func (ri ReplicaInfo) AsReplicaInfo() (*ReplicaInfo, bool) {
	return &ri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaInfo is the BasicReplicaInfo implementation for ReplicaInfo.
func (ri ReplicaInfo) AsBasicReplicaInfo() (BasicReplicaInfo, bool) {
	return &ri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaInfoModel ...
type ReplicaInfoModel struct {
	autorest.Response `json:"-"`
	Value             BasicReplicaInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ReplicaInfoModel struct.
func (rim *ReplicaInfoModel) UnmarshalJSON(body []byte) error {
	ri, err := unmarshalBasicReplicaInfo(body)
	if err != nil {
		return err
	}
	rim.Value = ri

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicasHealthEvaluation represents health evaluation for replicas, containing health evaluations for each
// unhealthy replica that impacted current aggregated health state. Can be returned when evaluating partition
// health and the aggregated health state is either Error or Warning.
type ReplicasHealthEvaluation struct {
	// MaxPercentUnhealthyReplicasPerPartition - Maximum allowed percentage of unhealthy replicas per partition from the ApplicationHealthPolicy.
	MaxPercentUnhealthyReplicasPerPartition *int32 `json:"MaxPercentUnhealthyReplicasPerPartition,omitempty"`
	// TotalCount - Total number of replicas in the partition from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ReplicaHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) MarshalJSON() ([]byte, error) {
	rhe.Kind = KindReplicas
	objectMap := make(map[string]interface{})
	if rhe.MaxPercentUnhealthyReplicasPerPartition != nil {
		objectMap["MaxPercentUnhealthyReplicasPerPartition"] = rhe.MaxPercentUnhealthyReplicasPerPartition
	}
	if rhe.TotalCount != nil {
		objectMap["TotalCount"] = rhe.TotalCount
	}
	if rhe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = rhe.UnhealthyEvaluations
	}
	if rhe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = rhe.AggregatedHealthState
	}
	if rhe.Description != nil {
		objectMap["Description"] = rhe.Description
	}
	if rhe.Kind != "" {
		objectMap["Kind"] = rhe.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return &rhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ReplicasHealthEvaluation.
func (rhe ReplicasHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &rhe, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicReplicaStatusBase information about the replica.
type BasicReplicaStatusBase interface {
	AsKeyValueStoreReplicaStatus() (*KeyValueStoreReplicaStatus, bool)
	AsReplicaStatusBase() (*ReplicaStatusBase, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicaStatusBase information about the replica.
type ReplicaStatusBase struct {
	// Kind - Possible values include: 'KindReplicaStatusBase', 'KindKeyValueStore'
	Kind KindBasicReplicaStatusBase `json:"Kind,omitempty"`
}

func unmarshalBasicReplicaStatusBase(body []byte) (BasicReplicaStatusBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindKeyValueStore):
		var kvsrs KeyValueStoreReplicaStatus
		err := json.Unmarshal(body, &kvsrs)
		return kvsrs, err
	default:
		var rsb ReplicaStatusBase
		err := json.Unmarshal(body, &rsb)
		return rsb, err
	}
}
func unmarshalBasicReplicaStatusBaseArray(body []byte) ([]BasicReplicaStatusBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rsbArray := make([]BasicReplicaStatusBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rsb, err := unmarshalBasicReplicaStatusBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rsbArray[index] = rsb
	}
	return rsbArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicaStatusBase.
func (rsb ReplicaStatusBase) MarshalJSON() ([]byte, error) {
	rsb.Kind = KindReplicaStatusBase
	objectMap := make(map[string]interface{})
	if rsb.Kind != "" {
		objectMap["Kind"] = rsb.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsKeyValueStoreReplicaStatus is the BasicReplicaStatusBase implementation for ReplicaStatusBase.
func (rsb ReplicaStatusBase) AsKeyValueStoreReplicaStatus() (*KeyValueStoreReplicaStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaStatusBase is the BasicReplicaStatusBase implementation for ReplicaStatusBase.
func (rsb ReplicaStatusBase) AsReplicaStatusBase() (*ReplicaStatusBase, bool) {
	return &rsb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaStatusBase is the BasicReplicaStatusBase implementation for ReplicaStatusBase.
func (rsb ReplicaStatusBase) AsBasicReplicaStatusBase() (BasicReplicaStatusBase, bool) {
	return &rsb, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicatorQueueStatus provides various statistics of the queue used in the service fabric replicator.
// Contains information about the service fabric replicator like the replication/copy queue utilization, last
// acknowledgement received timestamp, etc.
// Depending on the role of the replicator, the properties in this type imply different meanings.
type ReplicatorQueueStatus struct {
	// QueueUtilizationPercentage - Represents the utilization of the queue. A value of 0 indicates that the queue is empty and a value of 100 indicates the queue is full.
	QueueUtilizationPercentage *int32 `json:"QueueUtilizationPercentage,omitempty"`
	// QueueMemorySize - Represents the virtual memory consumed by the queue in bytes.
	QueueMemorySize *string `json:"QueueMemorySize,omitempty"`
	// FirstSequenceNumber - On a primary replicator, this is semantically the sequence number of the operation for which all the secondary replicas have sent an acknowledgement.
	// On a secondary replicator, this is the smallest sequence number of the operation that is present in the queue.
	FirstSequenceNumber *string `json:"FirstSequenceNumber,omitempty"`
	// CompletedSequenceNumber - On a primary replicator, this is semantically the highest sequence number of the operation for which all the secondary replicas have sent an acknowledgement.
	// On a secondary replicator, this is semantically the highest sequence number that has been applied to the persistent state.
	CompletedSequenceNumber *string `json:"CompletedSequenceNumber,omitempty"`
	// CommittedSequenceNumber - On a primary replicator, this is semantically the highest sequence number of the operation for which a write quorum of the secondary replicas have sent an acknowledgement.
	// On a secondary replicator, this is semantically the highest sequence number of the in-order operation received from the primary.
	CommittedSequenceNumber *string `json:"CommittedSequenceNumber,omitempty"`
	// LastSequenceNumber - Represents the latest sequence number of the operation that is available in the queue.
	LastSequenceNumber *string `json:"LastSequenceNumber,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicReplicatorStatus represents a base class for primary or secondary replicator status.
// Contains information about the service fabric replicator like the replication/copy queue utilization, last
// acknowledgement received timestamp, etc.
type BasicReplicatorStatus interface {
	AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool)
	AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool)
	AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool)
	AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool)
	AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool)
	AsReplicatorStatus() (*ReplicatorStatus, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ReplicatorStatus represents a base class for primary or secondary replicator status.
// Contains information about the service fabric replicator like the replication/copy queue utilization, last
// acknowledgement received timestamp, etc.
type ReplicatorStatus struct {
	// Kind - Possible values include: 'KindReplicatorStatus', 'KindPrimary', 'KindSecondaryReplicatorStatus', 'KindActiveSecondary', 'KindIdleSecondary'
	Kind KindBasicReplicatorStatus `json:"Kind,omitempty"`
}

func unmarshalBasicReplicatorStatus(body []byte) (BasicReplicatorStatus, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindPrimary):
		var prs PrimaryReplicatorStatus
		err := json.Unmarshal(body, &prs)
		return prs, err
	case string(KindSecondaryReplicatorStatus):
		var srs SecondaryReplicatorStatus
		err := json.Unmarshal(body, &srs)
		return srs, err
	case string(KindActiveSecondary):
		var sars SecondaryActiveReplicatorStatus
		err := json.Unmarshal(body, &sars)
		return sars, err
	case string(KindIdleSecondary):
		var sirs SecondaryIdleReplicatorStatus
		err := json.Unmarshal(body, &sirs)
		return sirs, err
	default:
		var rs ReplicatorStatus
		err := json.Unmarshal(body, &rs)
		return rs, err
	}
}
func unmarshalBasicReplicatorStatusArray(body []byte) ([]BasicReplicatorStatus, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rsArray := make([]BasicReplicatorStatus, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rs, err := unmarshalBasicReplicatorStatus(*rawMessage)
		if err != nil {
			return nil, err
		}
		rsArray[index] = rs
	}
	return rsArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ReplicatorStatus.
func (rs ReplicatorStatus) MarshalJSON() ([]byte, error) {
	rs.Kind = KindReplicatorStatus
	objectMap := make(map[string]interface{})
	if rs.Kind != "" {
		objectMap["Kind"] = rs.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPrimaryReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryActiveReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryIdleReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsReplicatorStatus() (*ReplicatorStatus, bool) {
	return &rs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicatorStatus is the BasicReplicatorStatus implementation for ReplicatorStatus.
func (rs ReplicatorStatus) AsBasicReplicatorStatus() (BasicReplicatorStatus, bool) {
	return &rs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ResolvedServiceEndpoint endpoint of a resolved service partition.
type ResolvedServiceEndpoint struct {
	// Kind - The role of the replica where the endpoint is reported. Possible values include: 'ServiceEndpointRoleInvalid', 'ServiceEndpointRoleStateless', 'ServiceEndpointRoleStatefulPrimary', 'ServiceEndpointRoleStatefulSecondary'
	Kind ServiceEndpointRole `json:"Kind,omitempty"`
	// Address - The address of the endpoint. If the endpoint has multiple listeners the address is a JSON object with one property per listener with the value as the address of that listener.
	Address *string `json:"Address,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ResolvedServicePartition information about a service partition and its associated endpoints.
type ResolvedServicePartition struct {
	autorest.Response `json:"-"`
	// Name - The full name of the service with 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// PartitionInformation - A representation of the resolved partition.
	PartitionInformation BasicPartitionInformation `json:"PartitionInformation,omitempty"`
	// Endpoints - List of resolved service endpoints of a service partition.
	Endpoints *[]ResolvedServiceEndpoint `json:"Endpoints,omitempty"`
	// Version - The version of this resolved service partition result. This version should be passed in the next time the ResolveService call is made via the PreviousRspVersion query parameter.
	Version *string `json:"Version,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ResolvedServicePartition struct.
func (rsp *ResolvedServicePartition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsp.Name = &name
			}
		case "PartitionInformation":
			if v != nil {
				partitionInformation, err := unmarshalBasicPartitionInformation(*v)
				if err != nil {
					return err
				}
				rsp.PartitionInformation = partitionInformation
			}
		case "Endpoints":
			if v != nil {
				var endpoints []ResolvedServiceEndpoint
				err = json.Unmarshal(*v, &endpoints)
				if err != nil {
					return err
				}
				rsp.Endpoints = &endpoints
			}
		case "Version":
			if v != nil {
				var version string
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				rsp.Version = &version
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RestartDeployedCodePackageDescription defines description for restarting a deployed code package on Service
// Fabric node.
type RestartDeployedCodePackageDescription struct {
	// ServiceManifestName - The name of service manifest that specified this code package.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ServicePackageActivationID - The ActivationId of a deployed service package. If ServicePackageActivationMode specified at the time of creating the service
	// is 'SharedProcess' (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of ServicePackageActivationId
	// is always an empty string.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// CodePackageName - The name of the code package defined in the service manifest.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// CodePackageInstanceID - The instance ID for currently running entry point. For a code package setup entry point (if specified) runs first and after it finishes main entry point is started.
	// Each time entry point executable is run, its instance id will change. If 0 is passed in as the code package instance ID, the API will restart the code package with whatever instance ID it is currently running.
	// If an instance ID other than 0 is passed in, the API will restart the code package only if the current Instance ID matches the passed in instance ID.
	// Note, passing in the exact instance ID (not 0) in the API is safer, because if ensures at most one restart of the code package.
	CodePackageInstanceID *string `json:"CodePackageInstanceId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RestartNodeDescription describes the parameters to restart a Service Fabric node.
type RestartNodeDescription struct {
	// NodeInstanceID - The instance id of the target node. If instance id is specified the node is restarted only if it matches with the current instance of the node. A default value of "0" would match any instance id. The instance id can be obtained using get node query.
	NodeInstanceID *string `json:"NodeInstanceId,omitempty"`
	// CreateFabricDump - Specify True to create a dump of the fabric node process. This is case sensitive. Possible values include: 'False', 'True'
	CreateFabricDump CreateFabricDump `json:"CreateFabricDump,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RestartPartitionResult represents information about an operation in a terminal state (Completed or Faulted).
type RestartPartitionResult struct {
	// ErrorCode - If OperationState is Completed, this is 0.  If OperationState is Faulted, this is an error code indicating the reason.
	ErrorCode *int32 `json:"ErrorCode,omitempty"`
	// SelectedPartition - This class returns information about the partition that the user-induced operation acted upon.
	SelectedPartition *SelectedPartition `json:"SelectedPartition,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ResumeApplicationUpgradeDescription describes the parameters for resuming an unmonitored manual Service Fabric
// application upgrade
type ResumeApplicationUpgradeDescription struct {
	// UpgradeDomainName - The name of the upgrade domain in which to resume the upgrade.
	UpgradeDomainName *string `json:"UpgradeDomainName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ResumeClusterUpgradeDescription describes the parameters for resuming a cluster upgrade.
type ResumeClusterUpgradeDescription struct {
	// UpgradeDomain - The next upgrade domain for this cluster upgrade.
	UpgradeDomain *string `json:"UpgradeDomain,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// RollingUpgradeUpdateDescription describes the parameters for updating a rolling upgrade of application or
// cluster.
type RollingUpgradeUpdateDescription struct {
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// ReplicaSetCheckTimeoutInMilliseconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	ReplicaSetCheckTimeoutInMilliseconds *int64 `json:"ReplicaSetCheckTimeoutInMilliseconds,omitempty"`
	// FailureAction - The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Possible values include: 'FailureActionInvalid', 'FailureActionRollback', 'FailureActionManual'
	FailureAction FailureAction `json:"FailureAction,omitempty"`
	// HealthCheckWaitDurationInMilliseconds - The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckWaitDurationInMilliseconds *string `json:"HealthCheckWaitDurationInMilliseconds,omitempty"`
	// HealthCheckStableDurationInMilliseconds - The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckStableDurationInMilliseconds *string `json:"HealthCheckStableDurationInMilliseconds,omitempty"`
	// HealthCheckRetryTimeoutInMilliseconds - The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckRetryTimeoutInMilliseconds *string `json:"HealthCheckRetryTimeoutInMilliseconds,omitempty"`
	// UpgradeTimeoutInMilliseconds - The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeTimeoutInMilliseconds *string `json:"UpgradeTimeoutInMilliseconds,omitempty"`
	// UpgradeDomainTimeoutInMilliseconds - The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
	UpgradeDomainTimeoutInMilliseconds *string `json:"UpgradeDomainTimeoutInMilliseconds,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicSafetyCheck represents a safety check performed by service fabric before continuing with the operations. These
// checks ensure the availability of the service and the reliability of the state.
type BasicSafetyCheck interface {
	AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool)
	AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool)
	AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool)
	AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool)
	AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool)
	AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool)
	AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool)
	AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool)
	AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool)
	AsSafetyCheck() (*SafetyCheck, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SafetyCheck represents a safety check performed by service fabric before continuing with the operations. These
// checks ensure the availability of the service and the reliability of the state.
type SafetyCheck struct {
	// Kind - Possible values include: 'KindSafetyCheck', 'KindPartitionSafetyCheck', 'KindEnsureAvailability', 'KindEnsurePartitionQuorum', 'KindEnsureSeedNodeQuorum', 'KindWaitForInbuildReplica', 'KindWaitForPrimaryPlacement', 'KindWaitForPrimarySwap', 'KindWaitForReconfiguration'
	Kind KindBasicSafetyCheck `json:"Kind,omitempty"`
}

func unmarshalBasicSafetyCheck(body []byte) (BasicSafetyCheck, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindPartitionSafetyCheck):
		var psc PartitionSafetyCheck
		err := json.Unmarshal(body, &psc)
		return psc, err
	case string(KindEnsureAvailability):
		var easc EnsureAvailabilitySafetyCheck
		err := json.Unmarshal(body, &easc)
		return easc, err
	case string(KindEnsurePartitionQuorum):
		var epqsc EnsurePartitionQurumSafetyCheck
		err := json.Unmarshal(body, &epqsc)
		return epqsc, err
	case string(KindEnsureSeedNodeQuorum):
		var snsc SeedNodeSafetyCheck
		err := json.Unmarshal(body, &snsc)
		return snsc, err
	case string(KindWaitForInbuildReplica):
		var wfirsc WaitForInbuildReplicaSafetyCheck
		err := json.Unmarshal(body, &wfirsc)
		return wfirsc, err
	case string(KindWaitForPrimaryPlacement):
		var wfppsc WaitForPrimaryPlacementSafetyCheck
		err := json.Unmarshal(body, &wfppsc)
		return wfppsc, err
	case string(KindWaitForPrimarySwap):
		var wfpssc WaitForPrimarySwapSafetyCheck
		err := json.Unmarshal(body, &wfpssc)
		return wfpssc, err
	case string(KindWaitForReconfiguration):
		var wfrsc WaitForReconfigurationSafetyCheck
		err := json.Unmarshal(body, &wfrsc)
		return wfrsc, err
	default:
		var sc SafetyCheck
		err := json.Unmarshal(body, &sc)
		return sc, err
	}
}
func unmarshalBasicSafetyCheckArray(body []byte) ([]BasicSafetyCheck, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	scArray := make([]BasicSafetyCheck, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sc, err := unmarshalBasicSafetyCheck(*rawMessage)
		if err != nil {
			return nil, err
		}
		scArray[index] = sc
	}
	return scArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SafetyCheck.
func (sc SafetyCheck) MarshalJSON() ([]byte, error) {
	sc.Kind = KindSafetyCheck
	objectMap := make(map[string]interface{})
	if sc.Kind != "" {
		objectMap["Kind"] = sc.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsureAvailabilitySafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsurePartitionQurumSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSeedNodeSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForInbuildReplicaSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimaryPlacementSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimarySwapSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForReconfigurationSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsSafetyCheck() (*SafetyCheck, bool) {
	return &sc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSafetyCheck is the BasicSafetyCheck implementation for SafetyCheck.
func (sc SafetyCheck) AsBasicSafetyCheck() (BasicSafetyCheck, bool) {
	return &sc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SafetyCheckWrapper a wrapper for the safety check object. Safety checks are performed by service fabric before
// continuing with the operations. These checks ensure the availability of the service and the reliability of the
// state.
type SafetyCheckWrapper struct {
	// SafetyCheck - Represents a safety check performed by service fabric before continuing with the operations. These checks ensure the availability of the service and the reliability of the state.
	SafetyCheck BasicSafetyCheck `json:"SafetyCheck,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for SafetyCheckWrapper struct.
func (scw *SafetyCheckWrapper) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "SafetyCheck":
			if v != nil {
				safetyCheck, err := unmarshalBasicSafetyCheck(*v)
				if err != nil {
					return err
				}
				scw.SafetyCheck = safetyCheck
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SecondaryActiveReplicatorStatus status of the secondary replicator when it is in active mode and is part of the
// replica set.
type SecondaryActiveReplicatorStatus struct {
	// ReplicationQueueStatus - Details about the replication queue on the secondary replicator.
	ReplicationQueueStatus *ReplicatorQueueStatus `json:"ReplicationQueueStatus,omitempty"`
	// LastReplicationOperationReceivedTimeUtc - The last time-stamp (UTC) at which a replication operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a replication operation message was never received.
	LastReplicationOperationReceivedTimeUtc *date.Time `json:"LastReplicationOperationReceivedTimeUtc,omitempty"`
	// IsInBuild - Value that indicates whether the replica is currently being built.
	IsInBuild *bool `json:"IsInBuild,omitempty"`
	// CopyQueueStatus - Details about the copy queue on the secondary replicator.
	CopyQueueStatus *ReplicatorQueueStatus `json:"CopyQueueStatus,omitempty"`
	// LastCopyOperationReceivedTimeUtc - The last time-stamp (UTC) at which a copy operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a copy operation message was never received.
	LastCopyOperationReceivedTimeUtc *date.Time `json:"LastCopyOperationReceivedTimeUtc,omitempty"`
	// LastAcknowledgementSentTimeUtc - The last time-stamp (UTC) at which an acknowledgment was sent to the primary replicator.
	// UTC 0 represents an invalid value, indicating that an acknowledgment message was never sent.
	LastAcknowledgementSentTimeUtc *date.Time `json:"LastAcknowledgementSentTimeUtc,omitempty"`
	// Kind - Possible values include: 'KindReplicatorStatus', 'KindPrimary', 'KindSecondaryReplicatorStatus', 'KindActiveSecondary', 'KindIdleSecondary'
	Kind KindBasicReplicatorStatus `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) MarshalJSON() ([]byte, error) {
	sars.Kind = KindActiveSecondary
	objectMap := make(map[string]interface{})
	if sars.ReplicationQueueStatus != nil {
		objectMap["ReplicationQueueStatus"] = sars.ReplicationQueueStatus
	}
	if sars.LastReplicationOperationReceivedTimeUtc != nil {
		objectMap["LastReplicationOperationReceivedTimeUtc"] = sars.LastReplicationOperationReceivedTimeUtc
	}
	if sars.IsInBuild != nil {
		objectMap["IsInBuild"] = sars.IsInBuild
	}
	if sars.CopyQueueStatus != nil {
		objectMap["CopyQueueStatus"] = sars.CopyQueueStatus
	}
	if sars.LastCopyOperationReceivedTimeUtc != nil {
		objectMap["LastCopyOperationReceivedTimeUtc"] = sars.LastCopyOperationReceivedTimeUtc
	}
	if sars.LastAcknowledgementSentTimeUtc != nil {
		objectMap["LastAcknowledgementSentTimeUtc"] = sars.LastAcknowledgementSentTimeUtc
	}
	if sars.Kind != "" {
		objectMap["Kind"] = sars.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPrimaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool) {
	return &sars, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryActiveReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool) {
	return &sars, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryIdleReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsReplicatorStatus() (*ReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryActiveReplicatorStatus.
func (sars SecondaryActiveReplicatorStatus) AsBasicReplicatorStatus() (BasicReplicatorStatus, bool) {
	return &sars, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SecondaryIdleReplicatorStatus status of the secondary replicator when it is in idle mode and is being built by
// the primary.
type SecondaryIdleReplicatorStatus struct {
	// ReplicationQueueStatus - Details about the replication queue on the secondary replicator.
	ReplicationQueueStatus *ReplicatorQueueStatus `json:"ReplicationQueueStatus,omitempty"`
	// LastReplicationOperationReceivedTimeUtc - The last time-stamp (UTC) at which a replication operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a replication operation message was never received.
	LastReplicationOperationReceivedTimeUtc *date.Time `json:"LastReplicationOperationReceivedTimeUtc,omitempty"`
	// IsInBuild - Value that indicates whether the replica is currently being built.
	IsInBuild *bool `json:"IsInBuild,omitempty"`
	// CopyQueueStatus - Details about the copy queue on the secondary replicator.
	CopyQueueStatus *ReplicatorQueueStatus `json:"CopyQueueStatus,omitempty"`
	// LastCopyOperationReceivedTimeUtc - The last time-stamp (UTC) at which a copy operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a copy operation message was never received.
	LastCopyOperationReceivedTimeUtc *date.Time `json:"LastCopyOperationReceivedTimeUtc,omitempty"`
	// LastAcknowledgementSentTimeUtc - The last time-stamp (UTC) at which an acknowledgment was sent to the primary replicator.
	// UTC 0 represents an invalid value, indicating that an acknowledgment message was never sent.
	LastAcknowledgementSentTimeUtc *date.Time `json:"LastAcknowledgementSentTimeUtc,omitempty"`
	// Kind - Possible values include: 'KindReplicatorStatus', 'KindPrimary', 'KindSecondaryReplicatorStatus', 'KindActiveSecondary', 'KindIdleSecondary'
	Kind KindBasicReplicatorStatus `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) MarshalJSON() ([]byte, error) {
	sirs.Kind = KindIdleSecondary
	objectMap := make(map[string]interface{})
	if sirs.ReplicationQueueStatus != nil {
		objectMap["ReplicationQueueStatus"] = sirs.ReplicationQueueStatus
	}
	if sirs.LastReplicationOperationReceivedTimeUtc != nil {
		objectMap["LastReplicationOperationReceivedTimeUtc"] = sirs.LastReplicationOperationReceivedTimeUtc
	}
	if sirs.IsInBuild != nil {
		objectMap["IsInBuild"] = sirs.IsInBuild
	}
	if sirs.CopyQueueStatus != nil {
		objectMap["CopyQueueStatus"] = sirs.CopyQueueStatus
	}
	if sirs.LastCopyOperationReceivedTimeUtc != nil {
		objectMap["LastCopyOperationReceivedTimeUtc"] = sirs.LastCopyOperationReceivedTimeUtc
	}
	if sirs.LastAcknowledgementSentTimeUtc != nil {
		objectMap["LastAcknowledgementSentTimeUtc"] = sirs.LastAcknowledgementSentTimeUtc
	}
	if sirs.Kind != "" {
		objectMap["Kind"] = sirs.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPrimaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool) {
	return &sirs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryActiveReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryIdleReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool) {
	return &sirs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsReplicatorStatus() (*ReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryIdleReplicatorStatus.
func (sirs SecondaryIdleReplicatorStatus) AsBasicReplicatorStatus() (BasicReplicatorStatus, bool) {
	return &sirs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicSecondaryReplicatorStatus provides statistics about the Service Fabric Replicator, when it is functioning in a
// ActiveSecondary role.
type BasicSecondaryReplicatorStatus interface {
	AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool)
	AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool)
	AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SecondaryReplicatorStatus provides statistics about the Service Fabric Replicator, when it is functioning in a
// ActiveSecondary role.
type SecondaryReplicatorStatus struct {
	// ReplicationQueueStatus - Details about the replication queue on the secondary replicator.
	ReplicationQueueStatus *ReplicatorQueueStatus `json:"ReplicationQueueStatus,omitempty"`
	// LastReplicationOperationReceivedTimeUtc - The last time-stamp (UTC) at which a replication operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a replication operation message was never received.
	LastReplicationOperationReceivedTimeUtc *date.Time `json:"LastReplicationOperationReceivedTimeUtc,omitempty"`
	// IsInBuild - Value that indicates whether the replica is currently being built.
	IsInBuild *bool `json:"IsInBuild,omitempty"`
	// CopyQueueStatus - Details about the copy queue on the secondary replicator.
	CopyQueueStatus *ReplicatorQueueStatus `json:"CopyQueueStatus,omitempty"`
	// LastCopyOperationReceivedTimeUtc - The last time-stamp (UTC) at which a copy operation was received from the primary.
	// UTC 0 represents an invalid value, indicating that a copy operation message was never received.
	LastCopyOperationReceivedTimeUtc *date.Time `json:"LastCopyOperationReceivedTimeUtc,omitempty"`
	// LastAcknowledgementSentTimeUtc - The last time-stamp (UTC) at which an acknowledgment was sent to the primary replicator.
	// UTC 0 represents an invalid value, indicating that an acknowledgment message was never sent.
	LastAcknowledgementSentTimeUtc *date.Time `json:"LastAcknowledgementSentTimeUtc,omitempty"`
	// Kind - Possible values include: 'KindReplicatorStatus', 'KindPrimary', 'KindSecondaryReplicatorStatus', 'KindActiveSecondary', 'KindIdleSecondary'
	Kind KindBasicReplicatorStatus `json:"Kind,omitempty"`
}

func unmarshalBasicSecondaryReplicatorStatus(body []byte) (BasicSecondaryReplicatorStatus, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindActiveSecondary):
		var sars SecondaryActiveReplicatorStatus
		err := json.Unmarshal(body, &sars)
		return sars, err
	case string(KindIdleSecondary):
		var sirs SecondaryIdleReplicatorStatus
		err := json.Unmarshal(body, &sirs)
		return sirs, err
	default:
		var srs SecondaryReplicatorStatus
		err := json.Unmarshal(body, &srs)
		return srs, err
	}
}
func unmarshalBasicSecondaryReplicatorStatusArray(body []byte) ([]BasicSecondaryReplicatorStatus, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	srsArray := make([]BasicSecondaryReplicatorStatus, len(rawMessages))

	for index, rawMessage := range rawMessages {
		srs, err := unmarshalBasicSecondaryReplicatorStatus(*rawMessage)
		if err != nil {
			return nil, err
		}
		srsArray[index] = srs
	}
	return srsArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) MarshalJSON() ([]byte, error) {
	srs.Kind = KindSecondaryReplicatorStatus
	objectMap := make(map[string]interface{})
	if srs.ReplicationQueueStatus != nil {
		objectMap["ReplicationQueueStatus"] = srs.ReplicationQueueStatus
	}
	if srs.LastReplicationOperationReceivedTimeUtc != nil {
		objectMap["LastReplicationOperationReceivedTimeUtc"] = srs.LastReplicationOperationReceivedTimeUtc
	}
	if srs.IsInBuild != nil {
		objectMap["IsInBuild"] = srs.IsInBuild
	}
	if srs.CopyQueueStatus != nil {
		objectMap["CopyQueueStatus"] = srs.CopyQueueStatus
	}
	if srs.LastCopyOperationReceivedTimeUtc != nil {
		objectMap["LastCopyOperationReceivedTimeUtc"] = srs.LastCopyOperationReceivedTimeUtc
	}
	if srs.LastAcknowledgementSentTimeUtc != nil {
		objectMap["LastAcknowledgementSentTimeUtc"] = srs.LastAcknowledgementSentTimeUtc
	}
	if srs.Kind != "" {
		objectMap["Kind"] = srs.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPrimaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsPrimaryReplicatorStatus() (*PrimaryReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsSecondaryReplicatorStatus() (*SecondaryReplicatorStatus, bool) {
	return &srs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSecondaryReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsBasicSecondaryReplicatorStatus() (BasicSecondaryReplicatorStatus, bool) {
	return &srs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryActiveReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsSecondaryActiveReplicatorStatus() (*SecondaryActiveReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSecondaryIdleReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsSecondaryIdleReplicatorStatus() (*SecondaryIdleReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsReplicatorStatus() (*ReplicatorStatus, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicatorStatus is the BasicReplicatorStatus implementation for SecondaryReplicatorStatus.
func (srs SecondaryReplicatorStatus) AsBasicReplicatorStatus() (BasicReplicatorStatus, bool) {
	return &srs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SeedNodeSafetyCheck represents a safety check for the seed nodes being performed by service fabric before
// continuing with node level operations.
type SeedNodeSafetyCheck struct {
	// Kind - Possible values include: 'KindSafetyCheck', 'KindPartitionSafetyCheck', 'KindEnsureAvailability', 'KindEnsurePartitionQuorum', 'KindEnsureSeedNodeQuorum', 'KindWaitForInbuildReplica', 'KindWaitForPrimaryPlacement', 'KindWaitForPrimarySwap', 'KindWaitForReconfiguration'
	Kind KindBasicSafetyCheck `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) MarshalJSON() ([]byte, error) {
	snsc.Kind = KindEnsureSeedNodeQuorum
	objectMap := make(map[string]interface{})
	if snsc.Kind != "" {
		objectMap["Kind"] = snsc.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsPartitionSafetyCheck() (*PartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsBasicPartitionSafetyCheck() (BasicPartitionSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsureAvailabilitySafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsEnsureAvailabilitySafetyCheck() (*EnsureAvailabilitySafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEnsurePartitionQurumSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsEnsurePartitionQurumSafetyCheck() (*EnsurePartitionQurumSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSeedNodeSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsSeedNodeSafetyCheck() (*SeedNodeSafetyCheck, bool) {
	return &snsc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForInbuildReplicaSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsWaitForInbuildReplicaSafetyCheck() (*WaitForInbuildReplicaSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimaryPlacementSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsWaitForPrimaryPlacementSafetyCheck() (*WaitForPrimaryPlacementSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForPrimarySwapSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsWaitForPrimarySwapSafetyCheck() (*WaitForPrimarySwapSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitForReconfigurationSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsWaitForReconfigurationSafetyCheck() (*WaitForReconfigurationSafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsSafetyCheck() (*SafetyCheck, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicSafetyCheck is the BasicSafetyCheck implementation for SeedNodeSafetyCheck.
func (snsc SeedNodeSafetyCheck) AsBasicSafetyCheck() (BasicSafetyCheck, bool) {
	return &snsc, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SelectedPartition this class returns information about the partition that the user-induced operation acted upon.
type SelectedPartition struct {
	// ServiceName - The name of the service the partition belongs to.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceCorrelationDescription creates a particular correlation between services.
type ServiceCorrelationDescription struct {
	// Scheme - The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName. Possible values include: 'ServiceCorrelationSchemeInvalid', 'ServiceCorrelationSchemeAffinity', 'ServiceCorrelationSchemeAlignedAffinity', 'ServiceCorrelationSchemeNonAlignedAffinity'
	Scheme ServiceCorrelationScheme `json:"Scheme,omitempty"`
	// ServiceName - The name of the service that the correlation relationship is established with.
	ServiceName *string `json:"ServiceName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServiceDescription a ServiceDescription contains all of the information necessary to create a service.
type BasicServiceDescription interface {
	AsStatefulServiceDescription() (*StatefulServiceDescription, bool)
	AsStatelessServiceDescription() (*StatelessServiceDescription, bool)
	AsServiceDescription() (*ServiceDescription, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceDescription a ServiceDescription contains all of the information necessary to create a service.
type ServiceDescription struct {
	autorest.Response `json:"-"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// InitializationData - The initialization data as an array of bytes. Initialization data is passed to service instances or replicas when they are created.
	InitializationData *[]int32 `json:"InitializationData,omitempty"`
	// PartitionDescription - The partition description as an object.
	PartitionDescription BasicPartitionSchemeDescription `json:"PartitionDescription,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"PlacementConstraints,omitempty"`
	// CorrelationScheme - The correlation scheme.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"CorrelationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"ServiceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - The service placement policies.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"ServicePlacementPolicies,omitempty"`
	// DefaultMoveCost - The move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"DefaultMoveCost,omitempty"`
	// IsDefaultMoveCostSpecified - Indicates if the DefaultMoveCost property is specified.
	IsDefaultMoveCostSpecified *bool `json:"IsDefaultMoveCostSpecified,omitempty"`
	// ServicePackageActivationMode - The activation mode of service package to be used for a service. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ServicePackageActivationMode `json:"ServicePackageActivationMode,omitempty"`
	// ServiceDNSName - The DNS name of the service. It requires the DNS system service to be enabled in Service Fabric cluster.
	ServiceDNSName *string `json:"ServiceDnsName,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceDescriptionServiceKindServiceDescription', 'ServiceKindBasicServiceDescriptionServiceKindStateful', 'ServiceKindBasicServiceDescriptionServiceKindStateless'
	ServiceKind ServiceKindBasicServiceDescription `json:"ServiceKind,omitempty"`
}

func unmarshalBasicServiceDescription(body []byte) (BasicServiceDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicServiceDescriptionServiceKindStateful):
		var ssd StatefulServiceDescription
		err := json.Unmarshal(body, &ssd)
		return ssd, err
	case string(ServiceKindBasicServiceDescriptionServiceKindStateless):
		var ssd StatelessServiceDescription
		err := json.Unmarshal(body, &ssd)
		return ssd, err
	default:
		var sd ServiceDescription
		err := json.Unmarshal(body, &sd)
		return sd, err
	}
}
func unmarshalBasicServiceDescriptionArray(body []byte) ([]BasicServiceDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sdArray := make([]BasicServiceDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sd, err := unmarshalBasicServiceDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		sdArray[index] = sd
	}
	return sdArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServiceDescription.
func (sd ServiceDescription) MarshalJSON() ([]byte, error) {
	sd.ServiceKind = ServiceKindBasicServiceDescriptionServiceKindServiceDescription
	objectMap := make(map[string]interface{})
	if sd.ApplicationName != nil {
		objectMap["ApplicationName"] = sd.ApplicationName
	}
	if sd.ServiceName != nil {
		objectMap["ServiceName"] = sd.ServiceName
	}
	if sd.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = sd.ServiceTypeName
	}
	if sd.InitializationData != nil {
		objectMap["InitializationData"] = sd.InitializationData
	}
	objectMap["PartitionDescription"] = sd.PartitionDescription
	if sd.PlacementConstraints != nil {
		objectMap["PlacementConstraints"] = sd.PlacementConstraints
	}
	if sd.CorrelationScheme != nil {
		objectMap["CorrelationScheme"] = sd.CorrelationScheme
	}
	if sd.ServiceLoadMetrics != nil {
		objectMap["ServiceLoadMetrics"] = sd.ServiceLoadMetrics
	}
	if sd.ServicePlacementPolicies != nil {
		objectMap["ServicePlacementPolicies"] = sd.ServicePlacementPolicies
	}
	if sd.DefaultMoveCost != "" {
		objectMap["DefaultMoveCost"] = sd.DefaultMoveCost
	}
	if sd.IsDefaultMoveCostSpecified != nil {
		objectMap["IsDefaultMoveCostSpecified"] = sd.IsDefaultMoveCostSpecified
	}
	if sd.ServicePackageActivationMode != "" {
		objectMap["ServicePackageActivationMode"] = sd.ServicePackageActivationMode
	}
	if sd.ServiceDNSName != nil {
		objectMap["ServiceDnsName"] = sd.ServiceDNSName
	}
	if sd.ServiceKind != "" {
		objectMap["ServiceKind"] = sd.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceDescription is the BasicServiceDescription implementation for ServiceDescription.
func (sd ServiceDescription) AsStatefulServiceDescription() (*StatefulServiceDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceDescription is the BasicServiceDescription implementation for ServiceDescription.
func (sd ServiceDescription) AsStatelessServiceDescription() (*StatelessServiceDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceDescription is the BasicServiceDescription implementation for ServiceDescription.
func (sd ServiceDescription) AsServiceDescription() (*ServiceDescription, bool) {
	return &sd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceDescription is the BasicServiceDescription implementation for ServiceDescription.
func (sd ServiceDescription) AsBasicServiceDescription() (BasicServiceDescription, bool) {
	return &sd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceDescription struct.
func (sd *ServiceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ApplicationName":
			if v != nil {
				var applicationName string
				err = json.Unmarshal(*v, &applicationName)
				if err != nil {
					return err
				}
				sd.ApplicationName = &applicationName
			}
		case "ServiceName":
			if v != nil {
				var serviceName string
				err = json.Unmarshal(*v, &serviceName)
				if err != nil {
					return err
				}
				sd.ServiceName = &serviceName
			}
		case "ServiceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				sd.ServiceTypeName = &serviceTypeName
			}
		case "InitializationData":
			if v != nil {
				var initializationData []int32
				err = json.Unmarshal(*v, &initializationData)
				if err != nil {
					return err
				}
				sd.InitializationData = &initializationData
			}
		case "PartitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				sd.PartitionDescription = partitionDescription
			}
		case "PlacementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				sd.PlacementConstraints = &placementConstraints
			}
		case "CorrelationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				sd.CorrelationScheme = &correlationScheme
			}
		case "ServiceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				sd.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "ServicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				sd.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "DefaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				sd.DefaultMoveCost = defaultMoveCost
			}
		case "IsDefaultMoveCostSpecified":
			if v != nil {
				var isDefaultMoveCostSpecified bool
				err = json.Unmarshal(*v, &isDefaultMoveCostSpecified)
				if err != nil {
					return err
				}
				sd.IsDefaultMoveCostSpecified = &isDefaultMoveCostSpecified
			}
		case "ServicePackageActivationMode":
			if v != nil {
				var servicePackageActivationMode ServicePackageActivationMode
				err = json.Unmarshal(*v, &servicePackageActivationMode)
				if err != nil {
					return err
				}
				sd.ServicePackageActivationMode = servicePackageActivationMode
			}
		case "ServiceDnsName":
			if v != nil {
				var serviceDNSName string
				err = json.Unmarshal(*v, &serviceDNSName)
				if err != nil {
					return err
				}
				sd.ServiceDNSName = &serviceDNSName
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceDescription
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				sd.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceDescriptionModel ...
type ServiceDescriptionModel struct {
	autorest.Response `json:"-"`
	Value             BasicServiceDescription `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceDescriptionModel struct.
func (sdm *ServiceDescriptionModel) UnmarshalJSON(body []byte) error {
	sd, err := unmarshalBasicServiceDescription(body)
	if err != nil {
		return err
	}
	sdm.Value = sd

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceFromTemplateDescription defines description for creating a Service Fabric service from a template defined
// in the application manifest.
type ServiceFromTemplateDescription struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// InitializationData - The initialization data for the newly created service instance.
	InitializationData *[]int32 `json:"InitializationData,omitempty"`
	// ServicePackageActivationMode - The activation mode of service package to be used for a service. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ServicePackageActivationMode `json:"ServicePackageActivationMode,omitempty"`
	// ServiceDNSName - The DNS name of the service. It requires the DNS system service to be enabled in Service Fabric cluster.
	ServiceDNSName *string `json:"ServiceDnsName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealth information about the health of a Service Fabric service.
type ServiceHealth struct {
	autorest.Response `json:"-"`
	// Name - The name of the service whose health information is described by this object.
	Name *string `json:"Name,omitempty"`
	// PartitionHealthStates - The list of partition health states associated with the service.
	PartitionHealthStates *[]PartitionHealthState `json:"PartitionHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealthEvaluation represents health evaluation for a service, containing information about the data and
// the algorithm used by health store to evaluate health. The evaluation is returned only when the aggregated
// health state is either Error or Warning.
type ServiceHealthEvaluation struct {
	// ServiceName - Name of the service whose health evaluation is described by this object.
	ServiceName *string `json:"ServiceName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the service. The types of the unhealthy evaluations can be PartitionsHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) MarshalJSON() ([]byte, error) {
	she.Kind = KindService
	objectMap := make(map[string]interface{})
	if she.ServiceName != nil {
		objectMap["ServiceName"] = she.ServiceName
	}
	if she.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = she.UnhealthyEvaluations
	}
	if she.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = she.AggregatedHealthState
	}
	if she.Description != nil {
		objectMap["Description"] = she.Description
	}
	if she.Kind != "" {
		objectMap["Kind"] = she.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return &she, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ServiceHealthEvaluation.
func (she ServiceHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &she, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealthState represents the health state of a service, which contains the service identifier and its
// aggregated health state.
type ServiceHealthState struct {
	// ServiceName - Name of the service whose health state is represented by this object.
	ServiceName *string `json:"ServiceName,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealthStateChunk represents the health state chunk of a service, which contains the service name, its
// aggregated health state and any partitions that respect the filters in the cluster health chunk query
// description.
type ServiceHealthStateChunk struct {
	// ServiceName - The name of the service whose health state chunk is provided in this object.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionHealthStateChunks - The list of partition health state chunks belonging to the service that respect the filters in the cluster health chunk query description.
	PartitionHealthStateChunks *PartitionHealthStateChunkList `json:"PartitionHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealthStateChunkList the list of service health state chunks that respect the input filters in the chunk
// query. Returned by get cluster health state chunks query.
type ServiceHealthStateChunkList struct {
	// Items - The list of service health state chunks that respect the input filters in the chunk query.
	Items *[]ServiceHealthStateChunk `json:"Items,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceHealthStateFilter defines matching criteria to determine whether a service should be included as a child
// of an application in the cluster health chunk.
// The services are only returned if the parent application matches a filter specified in the cluster health chunk
// query description.
// One filter can match zero, one or multiple services, depending on its properties.
type ServiceHealthStateFilter struct {
	// ServiceNameFilter - The name of the service that matches the filter. The filter is applied only to the specified service, if it exists.
	// If the service doesn't exist, no service is returned in the cluster health chunk based on this filter.
	// If the service exists, it is included as the application's child if the health state matches the other filter properties.
	// If not specified, all services that match the parent filters (if any) are taken into consideration and matched against the other filter members, like health state filter.
	ServiceNameFilter *string `json:"ServiceNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the services. It allows selecting services if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only services that match the filter are returned. All services are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the service name is specified. If the filter has default value and service name is specified, the matching service is returned.
	// The state values are flag based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches services with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// PartitionFilters - Defines a list of filters that specify which partitions to be included in the returned cluster health chunk as children of the service. The partitions are returned only if the parent service matches a filter.
	// If the list is empty, no partitions are returned. All the partitions are used to evaluate the parent service aggregated health state, regardless of the input filters.
	// The service filter may specify multiple partition filters.
	// For example, it can specify a filter to return all partitions with health state Error and another filter to always include a partition identified by its partition id.
	PartitionFilters *[]PartitionHealthStateFilter `json:"PartitionFilters,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServiceInfo information about a Service Fabric service.
type BasicServiceInfo interface {
	AsStatefulServiceInfo() (*StatefulServiceInfo, bool)
	AsStatelessServiceInfo() (*StatelessServiceInfo, bool)
	AsServiceInfo() (*ServiceInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceInfo information about a Service Fabric service.
type ServiceInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the service. This is an encoded representation of the service name. This is used in the REST APIs to identify the service resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the service name is "fabric:/myapp/app1/svc1",
	// the service identity would be "myapp~app1\~svc1" in 6.0+ and "myapp/app1/svc1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The full name of the service with 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - Name of the service type as specified in the service manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// ManifestVersion - The version of the service manifest.
	ManifestVersion *string `json:"ManifestVersion,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// ServiceStatus - The status of the application. Possible values include: 'ServiceStatusUnknown', 'ServiceStatusActive', 'ServiceStatusUpgrading', 'ServiceStatusDeleting', 'ServiceStatusCreating', 'ServiceStatusFailed'
	ServiceStatus ServiceStatus `json:"ServiceStatus,omitempty"`
	// IsServiceGroup - Whether the service is in a service group.
	IsServiceGroup *bool `json:"IsServiceGroup,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceInfoServiceKindServiceInfo', 'ServiceKindBasicServiceInfoServiceKindStateful', 'ServiceKindBasicServiceInfoServiceKindStateless'
	ServiceKind ServiceKindBasicServiceInfo `json:"ServiceKind,omitempty"`
}

func unmarshalBasicServiceInfo(body []byte) (BasicServiceInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicServiceInfoServiceKindStateful):
		var ssi StatefulServiceInfo
		err := json.Unmarshal(body, &ssi)
		return ssi, err
	case string(ServiceKindBasicServiceInfoServiceKindStateless):
		var ssi StatelessServiceInfo
		err := json.Unmarshal(body, &ssi)
		return ssi, err
	default:
		var si ServiceInfo
		err := json.Unmarshal(body, &si)
		return si, err
	}
}
func unmarshalBasicServiceInfoArray(body []byte) ([]BasicServiceInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	siArray := make([]BasicServiceInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		si, err := unmarshalBasicServiceInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		siArray[index] = si
	}
	return siArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServiceInfo.
func (si ServiceInfo) MarshalJSON() ([]byte, error) {
	si.ServiceKind = ServiceKindBasicServiceInfoServiceKindServiceInfo
	objectMap := make(map[string]interface{})
	if si.ID != nil {
		objectMap["Id"] = si.ID
	}
	if si.Name != nil {
		objectMap["Name"] = si.Name
	}
	if si.TypeName != nil {
		objectMap["TypeName"] = si.TypeName
	}
	if si.ManifestVersion != nil {
		objectMap["ManifestVersion"] = si.ManifestVersion
	}
	if si.HealthState != "" {
		objectMap["HealthState"] = si.HealthState
	}
	if si.ServiceStatus != "" {
		objectMap["ServiceStatus"] = si.ServiceStatus
	}
	if si.IsServiceGroup != nil {
		objectMap["IsServiceGroup"] = si.IsServiceGroup
	}
	if si.ServiceKind != "" {
		objectMap["ServiceKind"] = si.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceInfo is the BasicServiceInfo implementation for ServiceInfo.
func (si ServiceInfo) AsStatefulServiceInfo() (*StatefulServiceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInfo is the BasicServiceInfo implementation for ServiceInfo.
func (si ServiceInfo) AsStatelessServiceInfo() (*StatelessServiceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceInfo is the BasicServiceInfo implementation for ServiceInfo.
func (si ServiceInfo) AsServiceInfo() (*ServiceInfo, bool) {
	return &si, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceInfo is the BasicServiceInfo implementation for ServiceInfo.
func (si ServiceInfo) AsBasicServiceInfo() (BasicServiceInfo, bool) {
	return &si, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceInfoModel ...
type ServiceInfoModel struct {
	autorest.Response `json:"-"`
	Value             BasicServiceInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceInfoModel struct.
func (sim *ServiceInfoModel) UnmarshalJSON(body []byte) error {
	si, err := unmarshalBasicServiceInfo(body)
	if err != nil {
		return err
	}
	sim.Value = si

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceLoadMetricDescription specifies a metric to load balance a service during runtime.
type ServiceLoadMetricDescription struct {
	// Name - The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
	Name *string `json:"Name,omitempty"`
	// Weight - The service load metric relative weight, compared to other metrics configured for this service, as a number. Possible values include: 'ServiceLoadMetricWeightZero', 'ServiceLoadMetricWeightLow', 'ServiceLoadMetricWeightMedium', 'ServiceLoadMetricWeightHigh'
	Weight ServiceLoadMetricWeight `json:"Weight,omitempty"`
	// PrimaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
	PrimaryDefaultLoad *int32 `json:"PrimaryDefaultLoad,omitempty"`
	// SecondaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
	SecondaryDefaultLoad *int32 `json:"SecondaryDefaultLoad,omitempty"`
	// DefaultLoad - Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
	DefaultLoad *int32 `json:"DefaultLoad,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceNameInfo information about the service name.
type ServiceNameInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the service. This is an encoded representation of the service name. This is used in the REST APIs to identify the service resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the service name is "fabric:/myapp/app1/svc1",
	// the service identity would be "myapp~app1\~svc1" in 6.0+ and "myapp/app1/svc1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The full name of the service with 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServicePartitionInfo information about a partition of a Service Fabric service.
type BasicServicePartitionInfo interface {
	AsStatefulServicePartitionInfo() (*StatefulServicePartitionInfo, bool)
	AsStatelessServicePartitionInfo() (*StatelessServicePartitionInfo, bool)
	AsServicePartitionInfo() (*ServicePartitionInfo, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePartitionInfo information about a partition of a Service Fabric service.
type ServicePartitionInfo struct {
	autorest.Response `json:"-"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// PartitionStatus - The status of the service fabric service partition. Possible values include: 'ServicePartitionStatusInvalid', 'ServicePartitionStatusReady', 'ServicePartitionStatusNotReady', 'ServicePartitionStatusInQuorumLoss', 'ServicePartitionStatusReconfiguring', 'ServicePartitionStatusDeleting'
	PartitionStatus ServicePartitionStatus `json:"PartitionStatus,omitempty"`
	// PartitionInformation - Information about the partition identity, partitioning scheme and keys supported by it.
	PartitionInformation BasicPartitionInformation `json:"PartitionInformation,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo', 'ServiceKindBasicServicePartitionInfoServiceKindStateful', 'ServiceKindBasicServicePartitionInfoServiceKindStateless'
	ServiceKind ServiceKindBasicServicePartitionInfo `json:"ServiceKind,omitempty"`
}

func unmarshalBasicServicePartitionInfo(body []byte) (BasicServicePartitionInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicServicePartitionInfoServiceKindStateful):
		var sspi StatefulServicePartitionInfo
		err := json.Unmarshal(body, &sspi)
		return sspi, err
	case string(ServiceKindBasicServicePartitionInfoServiceKindStateless):
		var sspi StatelessServicePartitionInfo
		err := json.Unmarshal(body, &sspi)
		return sspi, err
	default:
		var spi ServicePartitionInfo
		err := json.Unmarshal(body, &spi)
		return spi, err
	}
}
func unmarshalBasicServicePartitionInfoArray(body []byte) ([]BasicServicePartitionInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spiArray := make([]BasicServicePartitionInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		spi, err := unmarshalBasicServicePartitionInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		spiArray[index] = spi
	}
	return spiArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePartitionInfo.
func (spi ServicePartitionInfo) MarshalJSON() ([]byte, error) {
	spi.ServiceKind = ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo
	objectMap := make(map[string]interface{})
	if spi.HealthState != "" {
		objectMap["HealthState"] = spi.HealthState
	}
	if spi.PartitionStatus != "" {
		objectMap["PartitionStatus"] = spi.PartitionStatus
	}
	objectMap["PartitionInformation"] = spi.PartitionInformation
	if spi.ServiceKind != "" {
		objectMap["ServiceKind"] = spi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServicePartitionInfo is the BasicServicePartitionInfo implementation for ServicePartitionInfo.
func (spi ServicePartitionInfo) AsStatefulServicePartitionInfo() (*StatefulServicePartitionInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServicePartitionInfo is the BasicServicePartitionInfo implementation for ServicePartitionInfo.
func (spi ServicePartitionInfo) AsStatelessServicePartitionInfo() (*StatelessServicePartitionInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePartitionInfo is the BasicServicePartitionInfo implementation for ServicePartitionInfo.
func (spi ServicePartitionInfo) AsServicePartitionInfo() (*ServicePartitionInfo, bool) {
	return &spi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePartitionInfo is the BasicServicePartitionInfo implementation for ServicePartitionInfo.
func (spi ServicePartitionInfo) AsBasicServicePartitionInfo() (BasicServicePartitionInfo, bool) {
	return &spi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServicePartitionInfo struct.
func (spi *ServicePartitionInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "HealthState":
			if v != nil {
				var healthState HealthState
				err = json.Unmarshal(*v, &healthState)
				if err != nil {
					return err
				}
				spi.HealthState = healthState
			}
		case "PartitionStatus":
			if v != nil {
				var partitionStatus ServicePartitionStatus
				err = json.Unmarshal(*v, &partitionStatus)
				if err != nil {
					return err
				}
				spi.PartitionStatus = partitionStatus
			}
		case "PartitionInformation":
			if v != nil {
				partitionInformation, err := unmarshalBasicPartitionInformation(*v)
				if err != nil {
					return err
				}
				spi.PartitionInformation = partitionInformation
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServicePartitionInfo
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				spi.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePartitionInfoModel ...
type ServicePartitionInfoModel struct {
	autorest.Response `json:"-"`
	Value             BasicServicePartitionInfo `json:"value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServicePartitionInfoModel struct.
func (spim *ServicePartitionInfoModel) UnmarshalJSON(body []byte) error {
	spi, err := unmarshalBasicServicePartitionInfo(body)
	if err != nil {
		return err
	}
	spim.Value = spi

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementInvalidDomainPolicyDescription describes the policy to be used for placement of a Service Fabric
// service where a particular fault or upgrade domain should not be used for placement of the instances or replicas
// of that service.
type ServicePlacementInvalidDomainPolicyDescription struct {
	// DomainName - The name of the domain that should not be used for placement.
	DomainName *string `json:"DomainName,omitempty"`
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) MarshalJSON() ([]byte, error) {
	spidpd.Type = TypeInvalidDomain
	objectMap := make(map[string]interface{})
	if spidpd.DomainName != nil {
		objectMap["DomainName"] = spidpd.DomainName
	}
	if spidpd.Type != "" {
		objectMap["Type"] = spidpd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return &spidpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementInvalidDomainPolicyDescription.
func (spidpd ServicePlacementInvalidDomainPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &spidpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementNonPartiallyPlaceServicePolicyDescription describes the policy to be used for placement of a
// Service Fabric service where all replicas must be able to be placed in order for any replicas to be created.
type ServicePlacementNonPartiallyPlaceServicePolicyDescription struct {
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) MarshalJSON() ([]byte, error) {
	spnppspd.Type = TypeNonPartiallyPlaceService
	objectMap := make(map[string]interface{})
	if spnppspd.Type != "" {
		objectMap["Type"] = spnppspd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return &spnppspd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementNonPartiallyPlaceServicePolicyDescription.
func (spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &spnppspd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type BasicServicePlacementPolicyDescription interface {
	AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool)
	AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool)
	AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool)
	AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool)
	AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool)
	AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type ServicePlacementPolicyDescription struct {
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

func unmarshalBasicServicePlacementPolicyDescription(body []byte) (BasicServicePlacementPolicyDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Type"] {
	case string(TypeInvalidDomain):
		var spidpd ServicePlacementInvalidDomainPolicyDescription
		err := json.Unmarshal(body, &spidpd)
		return spidpd, err
	case string(TypeNonPartiallyPlaceService):
		var spnppspd ServicePlacementNonPartiallyPlaceServicePolicyDescription
		err := json.Unmarshal(body, &spnppspd)
		return spnppspd, err
	case string(TypePreferPrimaryDomain):
		var spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription
		err := json.Unmarshal(body, &spppdpd)
		return spppdpd, err
	case string(TypeRequireDomain):
		var sprdpd ServicePlacementRequiredDomainPolicyDescription
		err := json.Unmarshal(body, &sprdpd)
		return sprdpd, err
	case string(TypeRequireDomainDistribution):
		var sprddpd ServicePlacementRequireDomainDistributionPolicyDescription
		err := json.Unmarshal(body, &sprddpd)
		return sprddpd, err
	default:
		var sppd ServicePlacementPolicyDescription
		err := json.Unmarshal(body, &sppd)
		return sppd, err
	}
}
func unmarshalBasicServicePlacementPolicyDescriptionArray(body []byte) ([]BasicServicePlacementPolicyDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sppdArray := make([]BasicServicePlacementPolicyDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppd, err := unmarshalBasicServicePlacementPolicyDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		sppdArray[index] = sppd
	}
	return sppdArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) MarshalJSON() ([]byte, error) {
	sppd.Type = TypeServicePlacementPolicyDescription
	objectMap := make(map[string]interface{})
	if sppd.Type != "" {
		objectMap["Type"] = sppd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementPreferPrimaryDomainPolicyDescription describes the policy to be used for placement of a Service
// Fabric service where the service's Primary replicas should optimally be placed in a particular domain.
//
// This placement policy is usually used with fault domains in scenarios where the Service Fabric cluster is
// geographically distributed in order to indicate that a service�s primary replica should be located in a
// particular fault domain, which in geo-distributed scenarios usually aligns with regional or datacenter
// boundaries. Note that since this is an optimization it is possible that the Primary replica may not end up
// located in this domain due to failures, capacity limits, or other constraints.
type ServicePlacementPreferPrimaryDomainPolicyDescription struct {
	// DomainName - The name of the domain that should used for placement as per this policy.
	DomainName *string `json:"DomainName,omitempty"`
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) MarshalJSON() ([]byte, error) {
	spppdpd.Type = TypePreferPrimaryDomain
	objectMap := make(map[string]interface{})
	if spppdpd.DomainName != nil {
		objectMap["DomainName"] = spppdpd.DomainName
	}
	if spppdpd.Type != "" {
		objectMap["Type"] = spppdpd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return &spppdpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPreferPrimaryDomainPolicyDescription.
func (spppdpd ServicePlacementPreferPrimaryDomainPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &spppdpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementRequiredDomainPolicyDescription describes the policy to be used for placement of a Service
// Fabric service where the instances or replicas of that service must be placed in a particular domain
type ServicePlacementRequiredDomainPolicyDescription struct {
	// DomainName - The name of the domain that should used for placement as per this policy.
	DomainName *string `json:"DomainName,omitempty"`
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) MarshalJSON() ([]byte, error) {
	sprdpd.Type = TypeRequireDomain
	objectMap := make(map[string]interface{})
	if sprdpd.DomainName != nil {
		objectMap["DomainName"] = sprdpd.DomainName
	}
	if sprdpd.Type != "" {
		objectMap["Type"] = sprdpd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return &sprdpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequiredDomainPolicyDescription.
func (sprdpd ServicePlacementRequiredDomainPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &sprdpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicePlacementRequireDomainDistributionPolicyDescription describes the policy to be used for placement of a
// Service Fabric service where two replicas from the same partition should never be placed in the same fault or
// upgrade domain.
//
// While this is not common it can expose the service to an increased risk of concurrent failures due to unplanned
// outages or other cases of subsequent/concurrent failures. As an example, consider a case where replicas are
// deployed across different data center, with one replica per location. In the event that one of the datacenters
// goes offline, normally the replica that was placed in that datacenter will be packed into one of the remaining
// datacenters. If this is not desirable then this policy should be set.
type ServicePlacementRequireDomainDistributionPolicyDescription struct {
	// DomainName - The name of the domain that should used for placement as per this policy.
	DomainName *string `json:"DomainName,omitempty"`
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription', 'TypeInvalidDomain', 'TypeNonPartiallyPlaceService', 'TypePreferPrimaryDomain', 'TypeRequireDomain', 'TypeRequireDomainDistribution'
	Type Type `json:"Type,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) MarshalJSON() ([]byte, error) {
	sprddpd.Type = TypeRequireDomainDistribution
	objectMap := make(map[string]interface{})
	if sprddpd.DomainName != nil {
		objectMap["DomainName"] = sprddpd.DomainName
	}
	if sprddpd.Type != "" {
		objectMap["Type"] = sprddpd.Type
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementInvalidDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementInvalidDomainPolicyDescription() (*ServicePlacementInvalidDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementNonPartiallyPlaceServicePolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementNonPartiallyPlaceServicePolicyDescription() (*ServicePlacementNonPartiallyPlaceServicePolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPreferPrimaryDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementPreferPrimaryDomainPolicyDescription() (*ServicePlacementPreferPrimaryDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequiredDomainPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementRequiredDomainPolicyDescription() (*ServicePlacementRequiredDomainPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementRequireDomainDistributionPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementRequireDomainDistributionPolicyDescription() (*ServicePlacementRequireDomainDistributionPolicyDescription, bool) {
	return &sprddpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementRequireDomainDistributionPolicyDescription.
func (sprddpd ServicePlacementRequireDomainDistributionPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &sprddpd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServicesHealthEvaluation represents health evaluation for services of a certain service type belonging to an
// application, containing health evaluations for each unhealthy service that impacted current aggregated health
// state. Can be returned when evaluating application health and the aggregated health state is either Error or
// Warning.
type ServicesHealthEvaluation struct {
	// ServiceTypeName - Name of the service type of the services.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// MaxPercentUnhealthyServices - Maximum allowed percentage of unhealthy services from the ServiceTypeHealthPolicy.
	MaxPercentUnhealthyServices *int32 `json:"MaxPercentUnhealthyServices,omitempty"`
	// TotalCount - Total number of services of the current service type in the application from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ServiceHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) MarshalJSON() ([]byte, error) {
	she.Kind = KindServices
	objectMap := make(map[string]interface{})
	if she.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = she.ServiceTypeName
	}
	if she.MaxPercentUnhealthyServices != nil {
		objectMap["MaxPercentUnhealthyServices"] = she.MaxPercentUnhealthyServices
	}
	if she.TotalCount != nil {
		objectMap["TotalCount"] = she.TotalCount
	}
	if she.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = she.UnhealthyEvaluations
	}
	if she.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = she.AggregatedHealthState
	}
	if she.Description != nil {
		objectMap["Description"] = she.Description
	}
	if she.Kind != "" {
		objectMap["Kind"] = she.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return &she, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ServicesHealthEvaluation.
func (she ServicesHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &she, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServiceTypeDescription describes a service type defined in the service manifest of a provisioned application
// type. The properties the the ones defined in the service manifest.
type BasicServiceTypeDescription interface {
	AsStatefulServiceTypeDescription() (*StatefulServiceTypeDescription, bool)
	AsStatelessServiceTypeDescription() (*StatelessServiceTypeDescription, bool)
	AsServiceTypeDescription() (*ServiceTypeDescription, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeDescription describes a service type defined in the service manifest of a provisioned application
// type. The properties the the ones defined in the service manifest.
type ServiceTypeDescription struct {
	// IsStateful - Indicates whether the service type is a stateful service type or a stateless service type. This property is true if the service type is a stateful service type, false otherwise.
	IsStateful *bool `json:"IsStateful,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// PlacementConstraints - The placement constraint to be used when instantiating this service in a Service Fabric cluster.
	PlacementConstraints *string `json:"PlacementConstraints,omitempty"`
	// ServicePlacementPolicies - List of service placement policy descriptions.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"ServicePlacementPolicies,omitempty"`
	// Extensions - List of service type extensions.
	Extensions *[]ServiceTypeExtensionDescription `json:"Extensions,omitempty"`
	// Kind - Possible values include: 'KindServiceTypeDescription', 'KindStateful', 'KindStateless'
	Kind KindBasicServiceTypeDescription `json:"Kind,omitempty"`
}

func unmarshalBasicServiceTypeDescription(body []byte) (BasicServiceTypeDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindStateful):
		var sstd StatefulServiceTypeDescription
		err := json.Unmarshal(body, &sstd)
		return sstd, err
	case string(KindStateless):
		var sstd StatelessServiceTypeDescription
		err := json.Unmarshal(body, &sstd)
		return sstd, err
	default:
		var std ServiceTypeDescription
		err := json.Unmarshal(body, &std)
		return std, err
	}
}
func unmarshalBasicServiceTypeDescriptionArray(body []byte) ([]BasicServiceTypeDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	stdArray := make([]BasicServiceTypeDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		std, err := unmarshalBasicServiceTypeDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		stdArray[index] = std
	}
	return stdArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServiceTypeDescription.
func (std ServiceTypeDescription) MarshalJSON() ([]byte, error) {
	std.Kind = KindServiceTypeDescription
	objectMap := make(map[string]interface{})
	if std.IsStateful != nil {
		objectMap["IsStateful"] = std.IsStateful
	}
	if std.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = std.ServiceTypeName
	}
	if std.PlacementConstraints != nil {
		objectMap["PlacementConstraints"] = std.PlacementConstraints
	}
	if std.ServicePlacementPolicies != nil {
		objectMap["ServicePlacementPolicies"] = std.ServicePlacementPolicies
	}
	if std.Extensions != nil {
		objectMap["Extensions"] = std.Extensions
	}
	if std.Kind != "" {
		objectMap["Kind"] = std.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceTypeDescription is the BasicServiceTypeDescription implementation for ServiceTypeDescription.
func (std ServiceTypeDescription) AsStatefulServiceTypeDescription() (*StatefulServiceTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceTypeDescription is the BasicServiceTypeDescription implementation for ServiceTypeDescription.
func (std ServiceTypeDescription) AsStatelessServiceTypeDescription() (*StatelessServiceTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceTypeDescription is the BasicServiceTypeDescription implementation for ServiceTypeDescription.
func (std ServiceTypeDescription) AsServiceTypeDescription() (*ServiceTypeDescription, bool) {
	return &std, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceTypeDescription is the BasicServiceTypeDescription implementation for ServiceTypeDescription.
func (std ServiceTypeDescription) AsBasicServiceTypeDescription() (BasicServiceTypeDescription, bool) {
	return &std, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceTypeDescription struct.
func (std *ServiceTypeDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "IsStateful":
			if v != nil {
				var isStateful bool
				err = json.Unmarshal(*v, &isStateful)
				if err != nil {
					return err
				}
				std.IsStateful = &isStateful
			}
		case "ServiceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				std.ServiceTypeName = &serviceTypeName
			}
		case "PlacementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				std.PlacementConstraints = &placementConstraints
			}
		case "ServicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				std.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "Extensions":
			if v != nil {
				var extensions []ServiceTypeExtensionDescription
				err = json.Unmarshal(*v, &extensions)
				if err != nil {
					return err
				}
				std.Extensions = &extensions
			}
		case "Kind":
			if v != nil {
				var kind KindBasicServiceTypeDescription
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				std.Kind = kind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeExtensionDescription describes extension of a service type defined in the service manifest.
type ServiceTypeExtensionDescription struct {
	// Key - The name of the extension.
	Key *string `json:"Key,omitempty"`
	// Value - The extension value.
	Value *string `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeHealthPolicy represents the health policy used to evaluate the health of services belonging to a
// service type.
type ServiceTypeHealthPolicy struct {
	// MaxPercentUnhealthyPartitionsPerService - The maximum allowed percentage of unhealthy partitions per service. Allowed values are Byte values from zero to 100
	// The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
	// If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
	// The computation rounds up to tolerate one failure on small numbers of partitions. Default percentage is zero.
	MaxPercentUnhealthyPartitionsPerService *int32 `json:"MaxPercentUnhealthyPartitionsPerService,omitempty"`
	// MaxPercentUnhealthyReplicasPerPartition - The maximum allowed percentage of unhealthy replicas per partition. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
	// If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
	// The computation rounds up to tolerate one failure on small numbers of replicas. Default percentage is zero.
	MaxPercentUnhealthyReplicasPerPartition *int32 `json:"MaxPercentUnhealthyReplicasPerPartition,omitempty"`
	// MaxPercentUnhealthyServices - The maximum maximum allowed percentage of unhealthy services. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
	// If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
	// The computation rounds up to tolerate one failure on small numbers of services. Default percentage is zero.
	MaxPercentUnhealthyServices *int32 `json:"MaxPercentUnhealthyServices,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeHealthPolicyMapItem defines an item in ServiceTypeHealthPolicyMap.
type ServiceTypeHealthPolicyMapItem struct {
	// Key - The key of the service type health policy map item. This is the name of the service type.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the service type health policy map item. This is the ServiceTypeHealthPolicy for this service type.
	Value *ServiceTypeHealthPolicy `json:"Value,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeInfo information about a service type that is defined in a service manifest of a provisioned
// application type.
type ServiceTypeInfo struct {
	// ServiceTypeDescription - Describes a service type defined in the service manifest of a provisioned application type. The properties the the ones defined in the service manifest.
	ServiceTypeDescription BasicServiceTypeDescription `json:"ServiceTypeDescription,omitempty"`
	// ServiceManifestName - The name of the service manifest in which this service type is defined.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// ServiceManifestVersion - The version of the service manifest in which this service type is defined.
	ServiceManifestVersion *string `json:"ServiceManifestVersion,omitempty"`
	// IsServiceGroup - Indicates whether the service is a service group. If it is, the property value is true otherwise false.
	IsServiceGroup *bool `json:"IsServiceGroup,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceTypeInfo struct.
func (sti *ServiceTypeInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ServiceTypeDescription":
			if v != nil {
				serviceTypeDescription, err := unmarshalBasicServiceTypeDescription(*v)
				if err != nil {
					return err
				}
				sti.ServiceTypeDescription = serviceTypeDescription
			}
		case "ServiceManifestName":
			if v != nil {
				var serviceManifestName string
				err = json.Unmarshal(*v, &serviceManifestName)
				if err != nil {
					return err
				}
				sti.ServiceManifestName = &serviceManifestName
			}
		case "ServiceManifestVersion":
			if v != nil {
				var serviceManifestVersion string
				err = json.Unmarshal(*v, &serviceManifestVersion)
				if err != nil {
					return err
				}
				sti.ServiceManifestVersion = &serviceManifestVersion
			}
		case "IsServiceGroup":
			if v != nil {
				var isServiceGroup bool
				err = json.Unmarshal(*v, &isServiceGroup)
				if err != nil {
					return err
				}
				sti.IsServiceGroup = &isServiceGroup
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceTypeManifest contains the manifest describing a service type registered as part of an application in a
// Service Fabric cluster.
type ServiceTypeManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The XML manifest as a string.
	Manifest *string `json:"Manifest,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// BasicServiceUpdateDescription a ServiceUpdateDescription contains all of the information necessary to update a
// service.
type BasicServiceUpdateDescription interface {
	AsStatefulServiceUpdateDescription() (*StatefulServiceUpdateDescription, bool)
	AsStatelessServiceUpdateDescription() (*StatelessServiceUpdateDescription, bool)
	AsServiceUpdateDescription() (*ServiceUpdateDescription, bool)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ServiceUpdateDescription a ServiceUpdateDescription contains all of the information necessary to update a
// service.
type ServiceUpdateDescription struct {
	// Flags - Flags indicating whether other properties are set. Each of the associated properties corresponds to a flag, specified below, which, if set, indicate that the property is specified.
	// This property can be a combination of those flags obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6 then the flags for ReplicaRestartWaitDuration (2) and QuorumLossWaitDuration (4) are set.
	// - None - Does not indicate any other properties are set. The value is zero.
	// - TargetReplicaSetSize/InstanceCount - Indicates whether the TargetReplicaSetSize property (for Stateful services) or the InstanceCount property (for Stateless services) is set. The value is 1.
	// - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration property is set. The value is  2.
	// - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property is set. The value is 4.
	// - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration property is set. The value is 8.
	// - MinReplicaSetSize - Indicates the MinReplicaSetSize property is set. The value is 16.
	// - PlacementConstraints - Indicates the PlacementConstraints property is set. The value is 32.
	// - PlacementPolicyList - Indicates the ServicePlacementPolicies property is set. The value is 64.
	// - Correlation - Indicates the CorrelationScheme property is set. The value is 128.
	// - Metrics - Indicates the ServiceLoadMetrics property is set. The value is 256.
	// - DefaultMoveCost - Indicates the DefaultMoveCost property is set. The value is 512.
	Flags *string `json:"Flags,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"PlacementConstraints,omitempty"`
	// CorrelationScheme - The correlation scheme.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"CorrelationScheme,omitempty"`
	// LoadMetrics - The service load metrics.
	LoadMetrics *[]ServiceLoadMetricDescription `json:"LoadMetrics,omitempty"`
	// ServicePlacementPolicies - The service placement policies.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"ServicePlacementPolicies,omitempty"`
	// DefaultMoveCost - The move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"DefaultMoveCost,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription', 'ServiceKindBasicServiceUpdateDescriptionServiceKindStateful', 'ServiceKindBasicServiceUpdateDescriptionServiceKindStateless'
	ServiceKind ServiceKindBasicServiceUpdateDescription `json:"ServiceKind,omitempty"`
}

func unmarshalBasicServiceUpdateDescription(body []byte) (BasicServiceUpdateDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ServiceKind"] {
	case string(ServiceKindBasicServiceUpdateDescriptionServiceKindStateful):
		var ssud StatefulServiceUpdateDescription
		err := json.Unmarshal(body, &ssud)
		return ssud, err
	case string(ServiceKindBasicServiceUpdateDescriptionServiceKindStateless):
		var ssud StatelessServiceUpdateDescription
		err := json.Unmarshal(body, &ssud)
		return ssud, err
	default:
		var sud ServiceUpdateDescription
		err := json.Unmarshal(body, &sud)
		return sud, err
	}
}
func unmarshalBasicServiceUpdateDescriptionArray(body []byte) ([]BasicServiceUpdateDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sudArray := make([]BasicServiceUpdateDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sud, err := unmarshalBasicServiceUpdateDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		sudArray[index] = sud
	}
	return sudArray, nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for ServiceUpdateDescription.
func (sud ServiceUpdateDescription) MarshalJSON() ([]byte, error) {
	sud.ServiceKind = ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription
	objectMap := make(map[string]interface{})
	if sud.Flags != nil {
		objectMap["Flags"] = sud.Flags
	}
	if sud.PlacementConstraints != nil {
		objectMap["PlacementConstraints"] = sud.PlacementConstraints
	}
	if sud.CorrelationScheme != nil {
		objectMap["CorrelationScheme"] = sud.CorrelationScheme
	}
	if sud.LoadMetrics != nil {
		objectMap["LoadMetrics"] = sud.LoadMetrics
	}
	if sud.ServicePlacementPolicies != nil {
		objectMap["ServicePlacementPolicies"] = sud.ServicePlacementPolicies
	}
	if sud.DefaultMoveCost != "" {
		objectMap["DefaultMoveCost"] = sud.DefaultMoveCost
	}
	if sud.ServiceKind != "" {
		objectMap["ServiceKind"] = sud.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceUpdateDescription is the BasicServiceUpdateDescription implementation for ServiceUpdateDescription.
func (sud ServiceUpdateDescription) AsStatefulServiceUpdateDescription() (*StatefulServiceUpdateDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceUpdateDescription is the BasicServiceUpdateDescription implementation for ServiceUpdateDescription.
func (sud ServiceUpdateDescription) AsStatelessServiceUpdateDescription() (*StatelessServiceUpdateDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceUpdateDescription is the BasicServiceUpdateDescription implementation for ServiceUpdateDescription.
func (sud ServiceUpdateDescription) AsServiceUpdateDescription() (*ServiceUpdateDescription, bool) {
	return &sud, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceUpdateDescription is the BasicServiceUpdateDescription implementation for ServiceUpdateDescription.
func (sud ServiceUpdateDescription) AsBasicServiceUpdateDescription() (BasicServiceUpdateDescription, bool) {
	return &sud, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for ServiceUpdateDescription struct.
func (sud *ServiceUpdateDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Flags":
			if v != nil {
				var flags string
				err = json.Unmarshal(*v, &flags)
				if err != nil {
					return err
				}
				sud.Flags = &flags
			}
		case "PlacementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				sud.PlacementConstraints = &placementConstraints
			}
		case "CorrelationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				sud.CorrelationScheme = &correlationScheme
			}
		case "LoadMetrics":
			if v != nil {
				var loadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &loadMetrics)
				if err != nil {
					return err
				}
				sud.LoadMetrics = &loadMetrics
			}
		case "ServicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				sud.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "DefaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				sud.DefaultMoveCost = defaultMoveCost
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceUpdateDescription
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				sud.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SingletonPartitionInformation information about a partition that is singleton. The services with singleton
// partitioning scheme are effectively non-partitioned. They only have one partition.
type SingletonPartitionInformation struct {
	// ID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition id is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the ids of its partitions would be different.
	ID *uuid.UUID `json:"Id,omitempty"`
	// ServicePartitionKind - Possible values include: 'ServicePartitionKindPartitionInformation', 'ServicePartitionKindInt64Range', 'ServicePartitionKindNamed', 'ServicePartitionKindSingleton'
	ServicePartitionKind ServicePartitionKind `json:"ServicePartitionKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) MarshalJSON() ([]byte, error) {
	spi.ServicePartitionKind = ServicePartitionKindSingleton
	objectMap := make(map[string]interface{})
	if spi.ID != nil {
		objectMap["Id"] = spi.ID
	}
	if spi.ServicePartitionKind != "" {
		objectMap["ServicePartitionKind"] = spi.ServicePartitionKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsInt64RangePartitionInformation is the BasicPartitionInformation implementation for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) AsInt64RangePartitionInformation() (*Int64RangePartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionInformation is the BasicPartitionInformation implementation for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) AsNamedPartitionInformation() (*NamedPartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionInformation is the BasicPartitionInformation implementation for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) AsSingletonPartitionInformation() (*SingletonPartitionInformation, bool) {
	return &spi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionInformation is the BasicPartitionInformation implementation for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) AsPartitionInformation() (*PartitionInformation, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionInformation is the BasicPartitionInformation implementation for SingletonPartitionInformation.
func (spi SingletonPartitionInformation) AsBasicPartitionInformation() (BasicPartitionInformation, bool) {
	return &spi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SingletonPartitionSchemeDescription describes the partition scheme of a singleton-partitioned, or
// non-partitioned service.
type SingletonPartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed1', 'PartitionSchemeSingleton1', 'PartitionSchemeUniformInt64Range1'
	PartitionScheme PartitionSchemeBasicPartitionSchemeDescription `json:"PartitionScheme,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	spsd.PartitionScheme = PartitionSchemeSingleton1
	objectMap := make(map[string]interface{})
	if spsd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = spsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return &spsd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &spsd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StartClusterUpgradeDescription describes the parameters for starting a cluster upgrade.
type StartClusterUpgradeDescription struct {
	// CodeVersion - The cluster code version.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// ConfigVersion - The cluster configuration version.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// EnableDeltaHealthEvaluation - When true, enables delta health evaluation rather than absolute health evaluation after completion of each upgrade domain.
	EnableDeltaHealthEvaluation *bool `json:"EnableDeltaHealthEvaluation,omitempty"`
	// ClusterUpgradeHealthPolicy - Defines a health policy used to evaluate the health of the cluster during a cluster upgrade.
	ClusterUpgradeHealthPolicy *ClusterUpgradeHealthPolicyObject `json:"ClusterUpgradeHealthPolicy,omitempty"`
	// ApplicationHealthPolicyMap - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicyMap *ApplicationHealthPolicies `json:"ApplicationHealthPolicyMap,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StartedChaosEvent describes a Chaos event that gets generated when Chaos is started.
type StartedChaosEvent struct {
	// ChaosParameters - Defines all the parameters to configure a Chaos run.
	ChaosParameters *ChaosParameters `json:"ChaosParameters,omitempty"`
	// TimeStampUtc - The UTC timestamp when this Chaos event was generated.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// Kind - Possible values include: 'KindChaosEvent', 'KindExecutingFaults', 'KindStarted', 'KindStopped', 'KindTestError', 'KindValidationFailed', 'KindWaiting'
	Kind KindBasicChaosEvent `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StartedChaosEvent.
func (sce StartedChaosEvent) MarshalJSON() ([]byte, error) {
	sce.Kind = KindStarted
	objectMap := make(map[string]interface{})
	if sce.ChaosParameters != nil {
		objectMap["ChaosParameters"] = sce.ChaosParameters
	}
	if sce.TimeStampUtc != nil {
		objectMap["TimeStampUtc"] = sce.TimeStampUtc
	}
	if sce.Kind != "" {
		objectMap["Kind"] = sce.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsExecutingFaultsChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStartedChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsStartedChaosEvent() (*StartedChaosEvent, bool) {
	return &sce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStoppedChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsStoppedChaosEvent() (*StoppedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsTestErrorChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsValidationFailedChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsWaitingChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsWaitingChaosEvent() (*WaitingChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsChaosEvent() (*ChaosEvent, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicChaosEvent is the BasicChaosEvent implementation for StartedChaosEvent.
func (sce StartedChaosEvent) AsBasicChaosEvent() (BasicChaosEvent, bool) {
	return &sce, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceDescription describes a stateful service.
type StatefulServiceDescription struct {
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"TargetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"MinReplicaSetSize,omitempty"`
	// HasPersistedState - A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
	HasPersistedState *bool `json:"HasPersistedState,omitempty"`
	// Flags - Flags indicating whether other properties are set. Each of the associated properties corresponds to a flag, specified below, which, if set, indicate that the property is specified.
	// This property can be a combination of those flags obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6 then the flags for QuorumLossWaitDuration (2) and StandByReplicaKeepDuration(4) are set.
	// - None - Does not indicate any other properties are set. The value is zero.
	// - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration property is set. The value is 1.
	// - QuorumLossWaitDuration - Indicates the QuorumLossWaitDuration property is set. The value is 2.
	// - StandByReplicaKeepDuration - Indicates the StandByReplicaKeepDuration property is set. The value is 4.
	Flags *int32 `json:"Flags,omitempty"`
	// ReplicaRestartWaitDurationSeconds - The duration, in seconds, between when a replica goes down and when a new replica is created.
	ReplicaRestartWaitDurationSeconds *int64 `json:"ReplicaRestartWaitDurationSeconds,omitempty"`
	// QuorumLossWaitDurationSeconds - The maximum duration, in seconds, for which a partition is allowed to be in a state of quorum loss.
	QuorumLossWaitDurationSeconds *int64 `json:"QuorumLossWaitDurationSeconds,omitempty"`
	// StandByReplicaKeepDurationSeconds - The definition on how long StandBy replicas should be maintained before being removed.
	StandByReplicaKeepDurationSeconds *int64 `json:"StandByReplicaKeepDurationSeconds,omitempty"`
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceName - The full name of the service with 'fabric:' URI scheme.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// InitializationData - The initialization data as an array of bytes. Initialization data is passed to service instances or replicas when they are created.
	InitializationData *[]int32 `json:"InitializationData,omitempty"`
	// PartitionDescription - The partition description as an object.
	PartitionDescription BasicPartitionSchemeDescription `json:"PartitionDescription,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string `json:"PlacementConstraints,omitempty"`
	// CorrelationScheme - The correlation scheme.
	CorrelationScheme *[]ServiceCorrelationDescription `json:"CorrelationScheme,omitempty"`
	// ServiceLoadMetrics - The service load metrics.
	ServiceLoadMetrics *[]ServiceLoadMetricDescription `json:"ServiceLoadMetrics,omitempty"`
	// ServicePlacementPolicies - The service placement policies.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"ServicePlacementPolicies,omitempty"`
	// DefaultMoveCost - The move cost for the service. Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost MoveCost `json:"DefaultMoveCost,omitempty"`
	// IsDefaultMoveCostSpecified - Indicates if the DefaultMoveCost property is specified.
	IsDefaultMoveCostSpecified *bool `json:"IsDefaultMoveCostSpecified,omitempty"`
	// ServicePackageActivationMode - The activation mode of service package to be used for a service. Possible values include: 'SharedProcess', 'ExclusiveProcess'
	ServicePackageActivationMode ServicePackageActivationMode `json:"ServicePackageActivationMode,omitempty"`
	// ServiceDNSName - The DNS name of the service. It requires the DNS system service to be enabled in Service Fabric cluster.
	ServiceDNSName *string `json:"ServiceDnsName,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceDescriptionServiceKindServiceDescription', 'ServiceKindBasicServiceDescriptionServiceKindStateful', 'ServiceKindBasicServiceDescriptionServiceKindStateless'
	ServiceKind ServiceKindBasicServiceDescription `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceDescription.
func (ssd StatefulServiceDescription) MarshalJSON() ([]byte, error) {
	ssd.ServiceKind = ServiceKindBasicServiceDescriptionServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssd.TargetReplicaSetSize != nil {
		objectMap["TargetReplicaSetSize"] = ssd.TargetReplicaSetSize
	}
	if ssd.MinReplicaSetSize != nil {
		objectMap["MinReplicaSetSize"] = ssd.MinReplicaSetSize
	}
	if ssd.HasPersistedState != nil {
		objectMap["HasPersistedState"] = ssd.HasPersistedState
	}
	if ssd.Flags != nil {
		objectMap["Flags"] = ssd.Flags
	}
	if ssd.ReplicaRestartWaitDurationSeconds != nil {
		objectMap["ReplicaRestartWaitDurationSeconds"] = ssd.ReplicaRestartWaitDurationSeconds
	}
	if ssd.QuorumLossWaitDurationSeconds != nil {
		objectMap["QuorumLossWaitDurationSeconds"] = ssd.QuorumLossWaitDurationSeconds
	}
	if ssd.StandByReplicaKeepDurationSeconds != nil {
		objectMap["StandByReplicaKeepDurationSeconds"] = ssd.StandByReplicaKeepDurationSeconds
	}
	if ssd.ApplicationName != nil {
		objectMap["ApplicationName"] = ssd.ApplicationName
	}
	if ssd.ServiceName != nil {
		objectMap["ServiceName"] = ssd.ServiceName
	}
	if ssd.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = ssd.ServiceTypeName
	}
	if ssd.InitializationData != nil {
		objectMap["InitializationData"] = ssd.InitializationData
	}
	objectMap["PartitionDescription"] = ssd.PartitionDescription
	if ssd.PlacementConstraints != nil {
		objectMap["PlacementConstraints"] = ssd.PlacementConstraints
	}
	if ssd.CorrelationScheme != nil {
		objectMap["CorrelationScheme"] = ssd.CorrelationScheme
	}
	if ssd.ServiceLoadMetrics != nil {
		objectMap["ServiceLoadMetrics"] = ssd.ServiceLoadMetrics
	}
	if ssd.ServicePlacementPolicies != nil {
		objectMap["ServicePlacementPolicies"] = ssd.ServicePlacementPolicies
	}
	if ssd.DefaultMoveCost != "" {
		objectMap["DefaultMoveCost"] = ssd.DefaultMoveCost
	}
	if ssd.IsDefaultMoveCostSpecified != nil {
		objectMap["IsDefaultMoveCostSpecified"] = ssd.IsDefaultMoveCostSpecified
	}
	if ssd.ServicePackageActivationMode != "" {
		objectMap["ServicePackageActivationMode"] = ssd.ServicePackageActivationMode
	}
	if ssd.ServiceDNSName != nil {
		objectMap["ServiceDnsName"] = ssd.ServiceDNSName
	}
	if ssd.ServiceKind != "" {
		objectMap["ServiceKind"] = ssd.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceDescription is the BasicServiceDescription implementation for StatefulServiceDescription.
func (ssd StatefulServiceDescription) AsStatefulServiceDescription() (*StatefulServiceDescription, bool) {
	return &ssd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceDescription is the BasicServiceDescription implementation for StatefulServiceDescription.
func (ssd StatefulServiceDescription) AsStatelessServiceDescription() (*StatelessServiceDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceDescription is the BasicServiceDescription implementation for StatefulServiceDescription.
func (ssd StatefulServiceDescription) AsServiceDescription() (*ServiceDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceDescription is the BasicServiceDescription implementation for StatefulServiceDescription.
func (ssd StatefulServiceDescription) AsBasicServiceDescription() (BasicServiceDescription, bool) {
	return &ssd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for StatefulServiceDescription struct.
func (ssd *StatefulServiceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "TargetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int32
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				ssd.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "MinReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int32
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				ssd.MinReplicaSetSize = &minReplicaSetSize
			}
		case "HasPersistedState":
			if v != nil {
				var hasPersistedState bool
				err = json.Unmarshal(*v, &hasPersistedState)
				if err != nil {
					return err
				}
				ssd.HasPersistedState = &hasPersistedState
			}
		case "Flags":
			if v != nil {
				var flags int32
				err = json.Unmarshal(*v, &flags)
				if err != nil {
					return err
				}
				ssd.Flags = &flags
			}
		case "ReplicaRestartWaitDurationSeconds":
			if v != nil {
				var replicaRestartWaitDurationSeconds int64
				err = json.Unmarshal(*v, &replicaRestartWaitDurationSeconds)
				if err != nil {
					return err
				}
				ssd.ReplicaRestartWaitDurationSeconds = &replicaRestartWaitDurationSeconds
			}
		case "QuorumLossWaitDurationSeconds":
			if v != nil {
				var quorumLossWaitDurationSeconds int64
				err = json.Unmarshal(*v, &quorumLossWaitDurationSeconds)
				if err != nil {
					return err
				}
				ssd.QuorumLossWaitDurationSeconds = &quorumLossWaitDurationSeconds
			}
		case "StandByReplicaKeepDurationSeconds":
			if v != nil {
				var standByReplicaKeepDurationSeconds int64
				err = json.Unmarshal(*v, &standByReplicaKeepDurationSeconds)
				if err != nil {
					return err
				}
				ssd.StandByReplicaKeepDurationSeconds = &standByReplicaKeepDurationSeconds
			}
		case "ApplicationName":
			if v != nil {
				var applicationName string
				err = json.Unmarshal(*v, &applicationName)
				if err != nil {
					return err
				}
				ssd.ApplicationName = &applicationName
			}
		case "ServiceName":
			if v != nil {
				var serviceName string
				err = json.Unmarshal(*v, &serviceName)
				if err != nil {
					return err
				}
				ssd.ServiceName = &serviceName
			}
		case "ServiceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				ssd.ServiceTypeName = &serviceTypeName
			}
		case "InitializationData":
			if v != nil {
				var initializationData []int32
				err = json.Unmarshal(*v, &initializationData)
				if err != nil {
					return err
				}
				ssd.InitializationData = &initializationData
			}
		case "PartitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				ssd.PartitionDescription = partitionDescription
			}
		case "PlacementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssd.PlacementConstraints = &placementConstraints
			}
		case "CorrelationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssd.CorrelationScheme = &correlationScheme
			}
		case "ServiceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssd.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "ServicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssd.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "DefaultMoveCost":
			if v != nil {
				var defaultMoveCost MoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssd.DefaultMoveCost = defaultMoveCost
			}
		case "IsDefaultMoveCostSpecified":
			if v != nil {
				var isDefaultMoveCostSpecified bool
				err = json.Unmarshal(*v, &isDefaultMoveCostSpecified)
				if err != nil {
					return err
				}
				ssd.IsDefaultMoveCostSpecified = &isDefaultMoveCostSpecified
			}
		case "ServicePackageActivationMode":
			if v != nil {
				var servicePackageActivationMode ServicePackageActivationMode
				err = json.Unmarshal(*v, &servicePackageActivationMode)
				if err != nil {
					return err
				}
				ssd.ServicePackageActivationMode = servicePackageActivationMode
			}
		case "ServiceDnsName":
			if v != nil {
				var serviceDNSName string
				err = json.Unmarshal(*v, &serviceDNSName)
				if err != nil {
					return err
				}
				ssd.ServiceDNSName = &serviceDNSName
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceDescription
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssd.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceInfo information about a stateful Service Fabric service.
type StatefulServiceInfo struct {
	// HasPersistedState - Whether the service has persisted state.
	HasPersistedState *bool `json:"HasPersistedState,omitempty"`
	// ID - The identity of the service. This is an encoded representation of the service name. This is used in the REST APIs to identify the service resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the service name is "fabric:/myapp/app1/svc1",
	// the service identity would be "myapp~app1\~svc1" in 6.0+ and "myapp/app1/svc1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The full name of the service with 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - Name of the service type as specified in the service manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// ManifestVersion - The version of the service manifest.
	ManifestVersion *string `json:"ManifestVersion,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// ServiceStatus - The status of the application. Possible values include: 'ServiceStatusUnknown', 'ServiceStatusActive', 'ServiceStatusUpgrading', 'ServiceStatusDeleting', 'ServiceStatusCreating', 'ServiceStatusFailed'
	ServiceStatus ServiceStatus `json:"ServiceStatus,omitempty"`
	// IsServiceGroup - Whether the service is in a service group.
	IsServiceGroup *bool `json:"IsServiceGroup,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceInfoServiceKindServiceInfo', 'ServiceKindBasicServiceInfoServiceKindStateful', 'ServiceKindBasicServiceInfoServiceKindStateless'
	ServiceKind ServiceKindBasicServiceInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceInfo.
func (ssi StatefulServiceInfo) MarshalJSON() ([]byte, error) {
	ssi.ServiceKind = ServiceKindBasicServiceInfoServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssi.HasPersistedState != nil {
		objectMap["HasPersistedState"] = ssi.HasPersistedState
	}
	if ssi.ID != nil {
		objectMap["Id"] = ssi.ID
	}
	if ssi.Name != nil {
		objectMap["Name"] = ssi.Name
	}
	if ssi.TypeName != nil {
		objectMap["TypeName"] = ssi.TypeName
	}
	if ssi.ManifestVersion != nil {
		objectMap["ManifestVersion"] = ssi.ManifestVersion
	}
	if ssi.HealthState != "" {
		objectMap["HealthState"] = ssi.HealthState
	}
	if ssi.ServiceStatus != "" {
		objectMap["ServiceStatus"] = ssi.ServiceStatus
	}
	if ssi.IsServiceGroup != nil {
		objectMap["IsServiceGroup"] = ssi.IsServiceGroup
	}
	if ssi.ServiceKind != "" {
		objectMap["ServiceKind"] = ssi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceInfo is the BasicServiceInfo implementation for StatefulServiceInfo.
func (ssi StatefulServiceInfo) AsStatefulServiceInfo() (*StatefulServiceInfo, bool) {
	return &ssi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInfo is the BasicServiceInfo implementation for StatefulServiceInfo.
func (ssi StatefulServiceInfo) AsStatelessServiceInfo() (*StatelessServiceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceInfo is the BasicServiceInfo implementation for StatefulServiceInfo.
func (ssi StatefulServiceInfo) AsServiceInfo() (*ServiceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceInfo is the BasicServiceInfo implementation for StatefulServiceInfo.
func (ssi StatefulServiceInfo) AsBasicServiceInfo() (BasicServiceInfo, bool) {
	return &ssi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServicePartitionInfo information about a partition of a stateful Service Fabric service..
type StatefulServicePartitionInfo struct {
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int64 `json:"TargetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int64 `json:"MinReplicaSetSize,omitempty"`
	// LastQuorumLossDuration - The duration for which this partition was in quorum loss. If the partition is currently in quorum loss, it returns the duration since it has been in that state. This field is using ISO8601 format for specifying the duration.
	LastQuorumLossDuration *string `json:"LastQuorumLossDuration,omitempty"`
	// CurrentConfigurationEpoch - An Epoch is a configuration number for the partition as a whole. When the configuration of the replica set changes, for example when the Primary replica changes, the operations that are replicated from the new Primary replica are said to be a new Epoch from the ones which were sent by the old Primary replica.
	CurrentConfigurationEpoch *Epoch `json:"CurrentConfigurationEpoch,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// PartitionStatus - The status of the service fabric service partition. Possible values include: 'ServicePartitionStatusInvalid', 'ServicePartitionStatusReady', 'ServicePartitionStatusNotReady', 'ServicePartitionStatusInQuorumLoss', 'ServicePartitionStatusReconfiguring', 'ServicePartitionStatusDeleting'
	PartitionStatus ServicePartitionStatus `json:"PartitionStatus,omitempty"`
	// PartitionInformation - Information about the partition identity, partitioning scheme and keys supported by it.
	PartitionInformation BasicPartitionInformation `json:"PartitionInformation,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo', 'ServiceKindBasicServicePartitionInfoServiceKindStateful', 'ServiceKindBasicServicePartitionInfoServiceKindStateless'
	ServiceKind ServiceKindBasicServicePartitionInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServicePartitionInfo.
func (sspi StatefulServicePartitionInfo) MarshalJSON() ([]byte, error) {
	sspi.ServiceKind = ServiceKindBasicServicePartitionInfoServiceKindStateful
	objectMap := make(map[string]interface{})
	if sspi.TargetReplicaSetSize != nil {
		objectMap["TargetReplicaSetSize"] = sspi.TargetReplicaSetSize
	}
	if sspi.MinReplicaSetSize != nil {
		objectMap["MinReplicaSetSize"] = sspi.MinReplicaSetSize
	}
	if sspi.LastQuorumLossDuration != nil {
		objectMap["LastQuorumLossDuration"] = sspi.LastQuorumLossDuration
	}
	if sspi.CurrentConfigurationEpoch != nil {
		objectMap["CurrentConfigurationEpoch"] = sspi.CurrentConfigurationEpoch
	}
	if sspi.HealthState != "" {
		objectMap["HealthState"] = sspi.HealthState
	}
	if sspi.PartitionStatus != "" {
		objectMap["PartitionStatus"] = sspi.PartitionStatus
	}
	objectMap["PartitionInformation"] = sspi.PartitionInformation
	if sspi.ServiceKind != "" {
		objectMap["ServiceKind"] = sspi.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServicePartitionInfo is the BasicServicePartitionInfo implementation for StatefulServicePartitionInfo.
func (sspi StatefulServicePartitionInfo) AsStatefulServicePartitionInfo() (*StatefulServicePartitionInfo, bool) {
	return &sspi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServicePartitionInfo is the BasicServicePartitionInfo implementation for StatefulServicePartitionInfo.
func (sspi StatefulServicePartitionInfo) AsStatelessServicePartitionInfo() (*StatelessServicePartitionInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServicePartitionInfo is the BasicServicePartitionInfo implementation for StatefulServicePartitionInfo.
func (sspi StatefulServicePartitionInfo) AsServicePartitionInfo() (*ServicePartitionInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServicePartitionInfo is the BasicServicePartitionInfo implementation for StatefulServicePartitionInfo.
func (sspi StatefulServicePartitionInfo) AsBasicServicePartitionInfo() (BasicServicePartitionInfo, bool) {
	return &sspi, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for StatefulServicePartitionInfo struct.
func (sspi *StatefulServicePartitionInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "TargetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int64
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				sspi.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "MinReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int64
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				sspi.MinReplicaSetSize = &minReplicaSetSize
			}
		case "LastQuorumLossDuration":
			if v != nil {
				var lastQuorumLossDuration string
				err = json.Unmarshal(*v, &lastQuorumLossDuration)
				if err != nil {
					return err
				}
				sspi.LastQuorumLossDuration = &lastQuorumLossDuration
			}
		case "CurrentConfigurationEpoch":
			if v != nil {
				var currentConfigurationEpoch Epoch
				err = json.Unmarshal(*v, &currentConfigurationEpoch)
				if err != nil {
					return err
				}
				sspi.CurrentConfigurationEpoch = &currentConfigurationEpoch
			}
		case "HealthState":
			if v != nil {
				var healthState HealthState
				err = json.Unmarshal(*v, &healthState)
				if err != nil {
					return err
				}
				sspi.HealthState = healthState
			}
		case "PartitionStatus":
			if v != nil {
				var partitionStatus ServicePartitionStatus
				err = json.Unmarshal(*v, &partitionStatus)
				if err != nil {
					return err
				}
				sspi.PartitionStatus = partitionStatus
			}
		case "PartitionInformation":
			if v != nil {
				partitionInformation, err := unmarshalBasicPartitionInformation(*v)
				if err != nil {
					return err
				}
				sspi.PartitionInformation = partitionInformation
			}
		case "ServiceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServicePartitionInfo
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				sspi.ServiceKind = serviceKind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceReplicaHealth represents the health of the stateful service replica.
// Contains the replica aggregated health state, the health events and the unhealthy evaluations.
type StatefulServiceReplicaHealth struct {
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// PartitionID - Id of the partition to which this replica belongs.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaHealthServiceKindReplicaHealth', 'ServiceKindBasicReplicaHealthServiceKindStateful', 'ServiceKindBasicReplicaHealthServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaHealth `json:"ServiceKind,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy.
	// . Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceReplicaHealth.
func (ssrh StatefulServiceReplicaHealth) MarshalJSON() ([]byte, error) {
	ssrh.ServiceKind = ServiceKindBasicReplicaHealthServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssrh.ReplicaID != nil {
		objectMap["ReplicaId"] = ssrh.ReplicaID
	}
	if ssrh.PartitionID != nil {
		objectMap["PartitionId"] = ssrh.PartitionID
	}
	if ssrh.ServiceKind != "" {
		objectMap["ServiceKind"] = ssrh.ServiceKind
	}
	if ssrh.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ssrh.AggregatedHealthState
	}
	if ssrh.HealthEvents != nil {
		objectMap["HealthEvents"] = ssrh.HealthEvents
	}
	if ssrh.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ssrh.UnhealthyEvaluations
	}
	if ssrh.HealthStatistics != nil {
		objectMap["HealthStatistics"] = ssrh.HealthStatistics
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaHealth is the BasicReplicaHealth implementation for StatefulServiceReplicaHealth.
func (ssrh StatefulServiceReplicaHealth) AsStatefulServiceReplicaHealth() (*StatefulServiceReplicaHealth, bool) {
	return &ssrh, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceHealth is the BasicReplicaHealth implementation for StatefulServiceReplicaHealth.
func (ssrh StatefulServiceReplicaHealth) AsStatelessServiceInstanceHealth() (*StatelessServiceInstanceHealth, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealth is the BasicReplicaHealth implementation for StatefulServiceReplicaHealth.
func (ssrh StatefulServiceReplicaHealth) AsReplicaHealth() (*ReplicaHealth, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaHealth is the BasicReplicaHealth implementation for StatefulServiceReplicaHealth.
func (ssrh StatefulServiceReplicaHealth) AsBasicReplicaHealth() (BasicReplicaHealth, bool) {
	return &ssrh, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceReplicaHealthState represents the health state of the stateful service replica, which contains
// the replica id and the aggregated health state.
type StatefulServiceReplicaHealthState struct {
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// PartitionID - The ID of the partition to which this replica belongs.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState', 'ServiceKindBasicReplicaHealthStateServiceKindStateful', 'ServiceKindBasicReplicaHealthStateServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaHealthState `json:"ServiceKind,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceReplicaHealthState.
func (ssrhs StatefulServiceReplicaHealthState) MarshalJSON() ([]byte, error) {
	ssrhs.ServiceKind = ServiceKindBasicReplicaHealthStateServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssrhs.ReplicaID != nil {
		objectMap["ReplicaId"] = ssrhs.ReplicaID
	}
	if ssrhs.PartitionID != nil {
		objectMap["PartitionId"] = ssrhs.PartitionID
	}
	if ssrhs.ServiceKind != "" {
		objectMap["ServiceKind"] = ssrhs.ServiceKind
	}
	if ssrhs.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ssrhs.AggregatedHealthState
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaHealthState is the BasicReplicaHealthState implementation for StatefulServiceReplicaHealthState.
func (ssrhs StatefulServiceReplicaHealthState) AsStatefulServiceReplicaHealthState() (*StatefulServiceReplicaHealthState, bool) {
	return &ssrhs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceHealthState is the BasicReplicaHealthState implementation for StatefulServiceReplicaHealthState.
func (ssrhs StatefulServiceReplicaHealthState) AsStatelessServiceInstanceHealthState() (*StatelessServiceInstanceHealthState, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaHealthState is the BasicReplicaHealthState implementation for StatefulServiceReplicaHealthState.
func (ssrhs StatefulServiceReplicaHealthState) AsReplicaHealthState() (*ReplicaHealthState, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaHealthState is the BasicReplicaHealthState implementation for StatefulServiceReplicaHealthState.
func (ssrhs StatefulServiceReplicaHealthState) AsBasicReplicaHealthState() (BasicReplicaHealthState, bool) {
	return &ssrhs, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceReplicaInfo represents a stateful service replica. This includes information about the identity,
// role, status, health, node name, uptime, and other details about the replica.
type StatefulServiceReplicaInfo struct {
	// ReplicaRole - The role of a replica of a stateful service. Possible values include: 'ReplicaRoleUnknown', 'ReplicaRoleNone', 'ReplicaRolePrimary', 'ReplicaRoleIdleSecondary', 'ReplicaRoleActiveSecondary'
	ReplicaRole ReplicaRole `json:"ReplicaRole,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *string `json:"ReplicaId,omitempty"`
	// ReplicaStatus - The status of a replica of a service. Possible values are following.
	//   -Invalid - Indicates the replica status is invalid. All Service Fabric enumerations have the invalid type. The value is zero.
	//   -InBuild - The replica is being built. This means that a primary replica is seeding this replica. The value is 1.
	//   -Standby - The replica is in standby. The value is 2.
	//   -Ready - The replica is ready. The value is 3.
	//   -Down - The replica is down. The value is 4.
	//   -Dropped - Replica is dropped. This means that the replica has been removed from the replica set. If it is persisted, its state has been deleted. The value is 5.
	// . Possible values include: 'ReplicaStatus1Invalid', 'ReplicaStatus1InBuild', 'ReplicaStatus1Standby', 'ReplicaStatus1Ready', 'ReplicaStatus1Down', 'ReplicaStatus1Dropped'
	ReplicaStatus ReplicaStatus1 `json:"ReplicaStatus,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// Address - The address the replica is listening on.
	Address *string `json:"Address,omitempty"`
	// LastInBuildDurationInSeconds - The last in build duration of the replica in seconds.
	LastInBuildDurationInSeconds *string `json:"LastInBuildDurationInSeconds,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicReplicaInfoServiceKindReplicaInfo', 'ServiceKindBasicReplicaInfoServiceKindStateful', 'ServiceKindBasicReplicaInfoServiceKindStateless'
	ServiceKind ServiceKindBasicReplicaInfo `json:"ServiceKind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceReplicaInfo.
func (ssri StatefulServiceReplicaInfo) MarshalJSON() ([]byte, error) {
	ssri.ServiceKind = ServiceKindBasicReplicaInfoServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssri.ReplicaRole != "" {
		objectMap["ReplicaRole"] = ssri.ReplicaRole
	}
	if ssri.ReplicaID != nil {
		objectMap["ReplicaId"] = ssri.ReplicaID
	}
	if ssri.ReplicaStatus != "" {
		objectMap["ReplicaStatus"] = ssri.ReplicaStatus
	}
	if ssri.HealthState != "" {
		objectMap["HealthState"] = ssri.HealthState
	}
	if ssri.NodeName != nil {
		objectMap["NodeName"] = ssri.NodeName
	}
	if ssri.Address != nil {
		objectMap["Address"] = ssri.Address
	}
	if ssri.LastInBuildDurationInSeconds != nil {
		objectMap["LastInBuildDurationInSeconds"] = ssri.LastInBuildDurationInSeconds
	}
	if ssri.ServiceKind != "" {
		objectMap["ServiceKind"] = ssri.ServiceKind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceReplicaInfo is the BasicReplicaInfo implementation for StatefulServiceReplicaInfo.
func (ssri StatefulServiceReplicaInfo) AsStatefulServiceReplicaInfo() (*StatefulServiceReplicaInfo, bool) {
	return &ssri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceInstanceInfo is the BasicReplicaInfo implementation for StatefulServiceReplicaInfo.
func (ssri StatefulServiceReplicaInfo) AsStatelessServiceInstanceInfo() (*StatelessServiceInstanceInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsReplicaInfo is the BasicReplicaInfo implementation for StatefulServiceReplicaInfo.
func (ssri StatefulServiceReplicaInfo) AsReplicaInfo() (*ReplicaInfo, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicReplicaInfo is the BasicReplicaInfo implementation for StatefulServiceReplicaInfo.
func (ssri StatefulServiceReplicaInfo) AsBasicReplicaInfo() (BasicReplicaInfo, bool) {
	return &ssri, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceTypeDescription describes a stateful service type defined in the service manifest of a
// provisioned application type.
type StatefulServiceTypeDescription struct {
	// HasPersistedState - A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
	HasPersistedState *bool `json:"HasPersistedState,omitempty"`
	// IsStateful - Indicates whether the service type is a stateful service type or a stateless service type. This property is true if the service type is a stateful service type, false otherwise.
	IsStateful *bool `json:"IsStateful,omitempty"`
	// ServiceTypeName - Name of the service type as specified in the service manifest.
	ServiceTypeName *string `json:"ServiceTypeName,omitempty"`
	// PlacementConstraints - The placement constraint to be used when instantiating this service in a Service Fabric cluster.
	PlacementConstraints *string `json:"PlacementConstraints,omitempty"`
	// ServicePlacementPolicies - List of service placement policy descriptions.
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"ServicePlacementPolicies,omitempty"`
	// Extensions - List of service type extensions.
	Extensions *[]ServiceTypeExtensionDescription `json:"Extensions,omitempty"`
	// Kind - Possible values include: 'KindServiceTypeDescription', 'KindStateful', 'KindStateless'
	Kind KindBasicServiceTypeDescription `json:"Kind,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// MarshalJSON is the custom marshaler for StatefulServiceTypeDescription.
func (sstd StatefulServiceTypeDescription) MarshalJSON() ([]byte, error) {
	sstd.Kind = KindStateful
	objectMap := make(map[string]interface{})
	if sstd.HasPersistedState != nil {
		objectMap["HasPersistedState"] = sstd.HasPersistedState
	}
	if sstd.IsStateful != nil {
		objectMap["IsStateful"] = sstd.IsStateful
	}
	if sstd.ServiceTypeName != nil {
		objectMap["ServiceTypeName"] = sstd.ServiceTypeName
	}
	if sstd.PlacementConstraints != nil {
		objectMap["PlacementConstraints"] = sstd.PlacementConstraints
	}
	if sstd.ServicePlacementPolicies != nil {
		objectMap["ServicePlacementPolicies"] = sstd.ServicePlacementPolicies
	}
	if sstd.Extensions != nil {
		objectMap["Extensions"] = sstd.Extensions
	}
	if sstd.Kind != "" {
		objectMap["Kind"] = sstd.Kind
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatefulServiceTypeDescription is the BasicServiceTypeDescription implementation for StatefulServiceTypeDescription.
func (sstd StatefulServiceTypeDescription) AsStatefulServiceTypeDescription() (*StatefulServiceTypeDescription, bool) {
	return &sstd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsStatelessServiceTypeDescription is the BasicServiceTypeDescription implementation for StatefulServiceTypeDescription.
func (sstd StatefulServiceTypeDescription) AsStatelessServiceTypeDescription() (*StatelessServiceTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsServiceTypeDescription is the BasicServiceTypeDescription implementation for StatefulServiceTypeDescription.
func (sstd StatefulServiceTypeDescription) AsServiceTypeDescription() (*ServiceTypeDescription, bool) {
	return nil, false
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// AsBasicServiceTypeDescription is the BasicServiceTypeDescription implementation for StatefulServiceTypeDescription.
func (sstd StatefulServiceTypeDescription) AsBasicServiceTypeDescription() (BasicServiceTypeDescription, bool) {
	return &sstd, true
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// UnmarshalJSON is the custom unmarshaler for StatefulServiceTypeDescription struct.
func (sstd *StatefulServiceTypeDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "HasPersistedState":
			if v != nil {
				var hasPersistedState bool
				err = json.Unmarshal(*v, &hasPersistedState)
				if err != nil {
					return err
				}
				sstd.HasPersistedState = &hasPersistedState
			}
		case "IsStateful":
			if v != nil {
				var isStateful bool
				err = json.Unmarshal(*v, &isStateful)
				if err != nil {
					return err
				}
				sstd.IsStateful = &isStateful
			}
		case "ServiceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				sstd.ServiceTypeName = &serviceTypeName
			}
		case "PlacementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				sstd.PlacementConstraints = &placementConstraints
			}
		case "ServicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				sstd.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "Extensions":
			if v != nil {
				var extensions []ServiceTypeExtensionDescription
				err = json.Unmarshal(*v, &extensions)
				if err != nil {
					return err
				}
				sstd.Extensions = &extensions
			}
		case "Kind":
			if v != nil {
				var kind KindBasicServiceTypeDescription
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sstd.Kind = kind
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// StatefulServiceUpdateDescription describes an update for a stateful service.
type StatefulServiceUpdateDescription struct {
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"TargetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"MinReplicaSetSize,omitempty"`
	// ReplicaRestartWaitDurationSeconds - The duration, in seconds, between when a replica goes down and when a new replica is created.
	ReplicaRestartWaitDurationSeconds *string `json:"ReplicaRestartWaitDurationSeconds,omitempty"`
	// QuorumLossWaitDurationSeconds - The maximum duration, in seconds, for which a partition is allowed to be in a state of quorum loss.
	QuorumLossWaitDurationSeconds *string `json:"QuorumLossWaitDurationSeconds,omitempty"`
	// StandByReplicaKeepDurationSeconds - The definition on how long StandBy replicas should be maintained before being removed.
	StandByReplicaKeepDurationSeconds *string `json:"StandByReplicaKeepDurationSeconds,omitempty"`
	// Flags - Flags indicating whether other properties are set. Each of the associated properties corresponds to a flag, specified below, which, if set, indicate that the property is specified.
	// This property can be a combination of those flags obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6 then the flags for ReplicaRestartWaitDuration (2) and QuorumLossWaitDuration (4) are set.
	// - None - Does not indicate any other properties are set. The value is zero.
	// - TargetReplicaSetSize/InstanceCount - Indicates whether the TargetReplicaSetSize property (for Stateful services) or the InstanceCount property (for Stateless services) is set. The value is 1.
	// - ReplicaRestartWaitDuration - Indicates the ReplicaRestartWaitDuration property is set. The va