package containerservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerservice/mgmt/2018-08-01-preview/containerservice"

// AgentPoolType enumerates the values for agent pool type.
type AgentPoolType string

const (
	// AvailabilitySet ...
	AvailabilitySet AgentPoolType = "AvailabilitySet"
	// VirtualMachineScaleSets ...
	VirtualMachineScaleSets AgentPoolType = "VirtualMachineScaleSets"
)

// PossibleAgentPoolTypeValues returns an array of possible values for the AgentPoolType const type.
func PossibleAgentPoolTypeValues() []AgentPoolType {
	return []AgentPoolType{AvailabilitySet, VirtualMachineScaleSets}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAADIdentityProvider ...
	KindAADIdentityProvider Kind = "AADIdentityProvider"
	// KindOpenShiftManagedClusterBaseIdentityProvider ...
	KindOpenShiftManagedClusterBaseIdentityProvider Kind = "OpenShiftManagedClusterBaseIdentityProvider"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAADIdentityProvider, KindOpenShiftManagedClusterBaseIdentityProvider}
}

// NetworkPlugin enumerates the values for network plugin.
type NetworkPlugin string

const (
	// Azure ...
	Azure NetworkPlugin = "azure"
	// Kubenet ...
	Kubenet NetworkPlugin = "kubenet"
)

// PossibleNetworkPluginValues returns an array of possible values for the NetworkPlugin const type.
func PossibleNetworkPluginValues() []NetworkPlugin {
	return []NetworkPlugin{Azure, Kubenet}
}

// NetworkPolicy enumerates the values for network policy.
type NetworkPolicy string

const (
	// Calico ...
	Calico NetworkPolicy = "calico"
)

// PossibleNetworkPolicyValues returns an array of possible values for the NetworkPolicy const type.
func PossibleNetworkPolicyValues() []NetworkPolicy {
	return []NetworkPolicy{Calico}
}

// OpenShiftAgentPoolProfileRole enumerates the values for open shift agent pool profile role.
type OpenShiftAgentPoolProfileRole string

const (
	// Compute ...
	Compute OpenShiftAgentPoolProfileRole = "compute"
	// Infra ...
	Infra OpenShiftAgentPoolProfileRole = "infra"
)

// PossibleOpenShiftAgentPoolProfileRoleValues returns an array of possible values for the OpenShiftAgentPoolProfileRole const type.
func PossibleOpenShiftAgentPoolProfileRoleValues() []OpenShiftAgentPoolProfileRole {
	return []OpenShiftAgentPoolProfileRole{Compute, Infra}
}

// OpenShiftContainerServiceVMSize enumerates the values for open shift container service vm size.
type OpenShiftContainerServiceVMSize string

const (
	// StandardD2sV3 ...
	StandardD2sV3 OpenShiftContainerServiceVMSize = "Standard_D2s_v3"
	// StandardD4sV3 ...
	StandardD4sV3 OpenShiftContainerServiceVMSize = "Standard_D4s_v3"
)

// PossibleOpenShiftContainerServiceVMSizeValues returns an array of possible values for the OpenShiftContainerServiceVMSize const type.
func PossibleOpenShiftContainerServiceVMSizeValues() []OpenShiftContainerServiceVMSize {
	return []OpenShiftContainerServiceVMSize{StandardD2sV3, StandardD4sV3}
}

// OrchestratorTypes enumerates the values for orchestrator types.
type OrchestratorTypes string

const (
	// Custom ...
	Custom OrchestratorTypes = "Custom"
	// DCOS ...
	DCOS OrchestratorTypes = "DCOS"
	// DockerCE ...
	DockerCE OrchestratorTypes = "DockerCE"
	// Kubernetes ...
	Kubernetes OrchestratorTypes = "Kubernetes"
	// Swarm ...
	Swarm OrchestratorTypes = "Swarm"
)

// PossibleOrchestratorTypesValues returns an array of possible values for the OrchestratorTypes const type.
func PossibleOrchestratorTypesValues() []OrchestratorTypes {
	return []OrchestratorTypes{Custom, DCOS, DockerCE, Kubernetes, Swarm}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "Linux"
	// Windows ...
	Windows OSType = "Windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{Linux, Windows}
}

// StorageProfileTypes enumerates the values for storage profile types.
type StorageProfileTypes string

const (
	// ManagedDisks ...
	ManagedDisks StorageProfileTypes = "ManagedDisks"
	// StorageAccount ...
	StorageAccount StorageProfileTypes = "StorageAccount"
)

// PossibleStorageProfileTypesValues returns an array of possible values for the StorageProfileTypes const type.
func PossibleStorageProfileTypesValues() []StorageProfileTypes {
	return []StorageProfileTypes{ManagedDisks, StorageAccount}
}

// VMSizeTypes enumerates the values for vm size types.
type VMSizeTypes string

const (
	// VMSizeTypesStandardA1 ...
	VMSizeTypesStandardA1 VMSizeTypes = "Standard_A1"
	// VMSizeTypesStandardA10 ...
	VMSizeTypesStandardA10 VMSizeTypes = "Standard_A10"
	// VMSizeTypesStandardA11 ...
	VMSizeTypesStandardA11 VMSizeTypes = "Standard_A11"
	// VMSizeTypesStandardA1V2 ...
	VMSizeTypesStandardA1V2 VMSizeTypes = "Standard_A1_v2"
	// VMSizeTypesStandardA2 ...
	VMSizeTypesStandardA2 VMSizeTypes = "Standard_A2"
	// VMSizeTypesStandardA2mV2 ...
	VMSizeTypesStandardA2mV2 VMSizeTypes = "Standard_A2m_v2"
	// VMSizeTypesStandardA2V2 ...
	VMSizeTypesStandardA2V2 VMSizeTypes = "Standard_A2_v2"
	// VMSizeTypesStandardA3 ...
	VMSizeTypesStandardA3 VMSizeTypes = "Standard_A3"
	// VMSizeTypesStandardA4 ...
	VMSizeTypesStandardA4 VMSizeTypes = "Standard_A4"
	// VMSizeTypesStandardA4mV2 ...
	VMSizeTypesStandardA4mV2 VMSizeTypes = "Standard_A4m_v2"
	// VMSizeTypesStandardA4V2 ...
	VMSizeTypesStandardA4V2 VMSizeTypes = "Standard_A4_v2"
	// VMSizeTypesStandardA5 ...
	VMSizeTypesStandardA5 VMSizeTypes = "Standard_A5"
	// VMSizeTypesStandardA6 ...
	VMSizeTypesStandardA6 VMSizeTypes = "Standard_A6"
	// VMSizeTypesStandardA7 ...
	VMSizeTypesStandardA7 VMSizeTypes = "Standard_A7"
	// VMSizeTypesStandardA8 ...
	VMSizeTypesStandardA8 VMSizeTypes = "Standard_A8"
	// VMSizeTypesStandardA8mV2 ...
	VMSizeTypesStandardA8mV2 VMSizeTypes = "Standard_A8m_v2"
	// VMSizeTypesStandardA8V2 ...
	VMSizeTypesStandardA8V2 VMSizeTypes = "Standard_A8_v2"
	// VMSizeTypesStandardA9 ...
	VMSizeTypesStandardA9 VMSizeTypes = "Standard_A9"
	// VMSizeTypesStandardB2ms ...
	VMSizeTypesStandardB2ms VMSizeTypes = "Standard_B2ms"
	// VMSizeTypesStandardB2s ...
	VMSizeTypesStandardB2s VMSizeTypes = "Standard_B2s"
	// VMSizeTypesStandardB4ms ...
	VMSizeTypesStandardB4ms VMSizeTypes = "Standard_B4ms"
	// VMSizeTypesStandardB8ms ...
	VMSizeTypesStandardB8ms VMSizeTypes = "Standard_B8ms"
	// VMSizeTypesStandardD1 ...
	VMSizeTypesStandardD1 VMSizeTypes = "Standard_D1"
	// VMSizeTypesStandardD11 ...
	VMSizeTypesStandardD11 VMSizeTypes = "Standard_D11"
	// VMSizeTypesStandardD11V2 ...
	VMSizeTypesStandardD11V2 VMSizeTypes = "Standard_D11_v2"
	// VMSizeTypesStandardD11V2Promo ...
	VMSizeTypesStandardD11V2Promo VMSizeTypes = "Standard_D11_v2_Promo"
	// VMSizeTypesStandardD12 ...
	VMSizeTypesStandardD12 VMSizeTypes = "Standard_D12"
	// VMSizeTypesStandardD12V2 ...
	VMSizeTypesStandardD12V2 VMSizeTypes = "Standard_D12_v2"
	// VMSizeTypesStandardD12V2Promo ...
	VMSizeTypesStandardD12V2Promo VMSizeTypes = "Standard_D12_v2_Promo"
	// VMSizeTypesStandardD13 ...
	VMSizeTypesStandardD13 VMSizeTypes = "Standard_D13"
	// VMSizeTypesStandardD13V2 ...
	VMSizeTypesStandardD13V2 VMSizeTypes = "Standard_D13_v2"
	// VMSizeTypesStandardD13V2Promo ...
	VMSizeTypesStandardD13V2Promo VMSizeTypes = "Standard_D13_v2_Promo"
	// VMSizeTypesStandardD14 ...
	VMSizeTypesStandardD14 VMSizeTypes = "Standard_D14"
	// VMSizeTypesStandardD14V2 ...
	VMSizeTypesStandardD14V2 VMSizeTypes = "Standard_D14_v2"
	// VMSizeTypesStandardD14V2Promo ...
	VMSizeTypesStandardD14V2Promo VMSizeTypes = "Standard_D14_v2_Promo"
	// VMSizeTypesStandardD15V2 ...
	VMSizeTypesStandardD15V2 VMSizeTypes = "Standard_D15_v2"
	// VMSizeTypesStandardD16sV3 ...
	VMSizeTypesStandardD16sV3 VMSizeTypes = "Standard_D16s_v3"
	// VMSizeTypesStandardD16V3 ...
	VMSizeTypesStandardD16V3 VMSizeTypes = "Standard_D16_v3"
	// VMSizeTypesStandardD1V2 ...
	VMSizeTypesStandardD1V2 VMSizeTypes = "Standard_D1_v2"
	// VMSizeTypesStandardD2 ...
	VMSizeTypesStandardD2 VMSizeTypes = "Standard_D2"
	// VMSizeTypesStandardD2sV3 ...
	VMSizeTypesStandardD2sV3 VMSizeTypes = "Standard_D2s_v3"
	// VMSizeTypesStandardD2V2 ...
	VMSizeTypesStandardD2V2 VMSizeTypes = "Standard_D2_v2"
	// VMSizeTypesStandardD2V2Promo ...
	VMSizeTypesStandardD2V2Promo VMSizeTypes = "Standard_D2_v2_Promo"
	// VMSizeTypesStandardD2V3 ...
	VMSizeTypesStandardD2V3 VMSizeTypes = "Standard_D2_v3"
	// VMSizeTypesStandardD3 ...
	VMSizeTypesStandardD3 VMSizeTypes = "Standard_D3"
	// VMSizeTypesStandardD32sV3 ...
	VMSizeTypesStandardD32sV3 VMSizeTypes = "Standard_D32s_v3"
	// VMSizeTypesStandardD32V3 ...
	VMSizeTypesStandardD32V3 VMSizeTypes = "Standard_D32_v3"
	// VMSizeTypesStandardD3V2 ...
	VMSizeTypesStandardD3V2 VMSizeTypes = "Standard_D3_v2"
	// VMSizeTypesStandardD3V2Promo ...
	VMSizeTypesStandardD3V2Promo VMSizeTypes = "Standard_D3_v2_Promo"
	// VMSizeTypesStandardD4 ...
	VMSizeTypesStandardD4 VMSizeTypes = "Standard_D4"
	// VMSizeTypesStandardD4sV3 ...
	VMSizeTypesStandardD4sV3 VMSizeTypes = "Standard_D4s_v3"
	// VMSizeTypesStandardD4V2 ...
	VMSizeTypesStandardD4V2 VMSizeTypes = "Standard_D4_v2"
	// VMSizeTypesStandardD4V2Promo ...
	VMSizeTypesStandardD4V2Promo VMSizeTypes = "Standard_D4_v2_Promo"
	// VMSizeTypesStandardD4V3 ...
	VMSizeTypesStandardD4V3 VMSizeTypes = "Standard_D4_v3"
	// VMSizeTypesStandardD5V2 ...
	VMSizeTypesStandardD5V2 VMSizeTypes = "Standard_D5_v2"
	// VMSizeTypesStandardD5V2Promo ...
	VMSizeTypesStandardD5V2Promo VMSizeTypes = "Standard_D5_v2_Promo"
	// VMSizeTypesStandardD64sV3 ...
	VMSizeTypesStandardD64sV3 VMSizeTypes = "Standard_D64s_v3"
	// VMSizeTypesStandardD64V3 ...
	VMSizeTypesStandardD64V3 VMSizeTypes = "Standard_D64_v3"
	// VMSizeTypesStandardD8sV3 ...
	VMSizeTypesStandardD8sV3 VMSizeTypes = "Standard_D8s_v3"
	// VMSizeTypesStandardD8V3 ...
	VMSizeTypesStandardD8V3 VMSizeTypes = "Standard_D8_v3"
	// VMSizeTypesStandardDS1 ...
	VMSizeTypesStandardDS1 VMSizeTypes = "Standard_DS1"
	// VMSizeTypesStandardDS11 ...
	VMSizeTypesStandardDS11 VMSizeTypes = "Standard_DS11"
	// VMSizeTypesStandardDS11V2 ...
	VMSizeTypesStandardDS11V2 VMSizeTypes = "Standard_DS11_v2"
	// VMSizeTypesStandardDS11V2Promo ...
	VMSizeTypesStandardDS11V2Promo VMSizeTypes = "Standard_DS11_v2_Promo"
	// VMSizeTypesStandardDS12 ...
	VMSizeTypesStandardDS12 VMSizeTypes = "Standard_DS12"
	// VMSizeTypesStandardDS12V2 ...
	VMSizeTypesStandardDS12V2 VMSizeTypes = "Standard_DS12_v2"
	// VMSizeTypesStandardDS12V2Promo ...
	VMSizeTypesStandardDS12V2Promo VMSizeTypes = "Standard_DS12_v2_Promo"
	// VMSizeTypesStandardDS13 ...
	VMSizeTypesStandardDS13 VMSizeTypes = "Standard_DS13"
	// VMSizeTypesStandardDS132V2 ...
	VMSizeTypesStandardDS132V2 VMSizeTypes = "Standard_DS13-2_v2"
	// VMSizeTypesStandardDS134V2 ...
	VMSizeTypesStandardDS134V2 VMSizeTypes = "Standard_DS13-4_v2"
	// VMSizeTypesStandardDS13V2 ...
	VMSizeTypesStandardDS13V2 VMSizeTypes = "Standard_DS13_v2"
	// VMSizeTypesStandardDS13V2Promo ...
	VMSizeTypesStandardDS13V2Promo VMSizeTypes = "Standard_DS13_v2_Promo"
	// VMSizeTypesStandardDS14 ...
	VMSizeTypesStandardDS14 VMSizeTypes = "Standard_DS14"
	// VMSizeTypesStandardDS144V2 ...
	VMSizeTypesStandardDS144V2 VMSizeTypes = "Standard_DS14-4_v2"
	// VMSizeTypesStandardDS148V2 ...
	VMSizeTypesStandardDS148V2 VMSizeTypes = "Standard_DS14-8_v2"
	// VMSizeTypesStandardDS14V2 ...
	VMSizeTypesStandardDS14V2 VMSizeTypes = "Standard_DS14_v2"
	// VMSizeTypesStandardDS14V2Promo ...
	VMSizeTypesStandardDS14V2Promo VMSizeTypes = "Standard_DS14_v2_Promo"
	// VMSizeTypesStandardDS15V2 ...
	VMSizeTypesStandardDS15V2 VMSizeTypes = "Standard_DS15_v2"
	// VMSizeTypesStandardDS1V2 ...
	VMSizeTypesStandardDS1V2 VMSizeTypes = "Standard_DS1_v2"
	// VMSizeTypesStandardDS2 ...
	VMSizeTypesStandardDS2 VMSizeTypes = "Standard_DS2"
	// VMSizeTypesStandardDS2V2 ...
	VMSizeTypesStandardDS2V2 VMSizeTypes = "Standard_DS2_v2"
	// VMSizeTypesStandardDS2V2Promo ...
	VMSizeTypesStandardDS2V2Promo VMSizeTypes = "Standard_DS2_v2_Promo"
	// VMSizeTypesStandardDS3 ...
	VMSizeTypesStandardDS3 VMSizeTypes = "Standard_DS3"
	// VMSizeTypesStandardDS3V2 ...
	VMSizeTypesStandardDS3V2 VMSizeTypes = "Standard_DS3_v2"
	// VMSizeTypesStandardDS3V2Promo ...
	VMSizeTypesStandardDS3V2Promo VMSizeTypes = "Standard_DS3_v2_Promo"
	// VMSizeTypesStandardDS4 ...
	VMSizeTypesStandardDS4 VMSizeTypes = "Standard_DS4"
	// VMSizeTypesStandardDS4V2 ...
	VMSizeTypesStandardDS4V2 VMSizeTypes = "Standard_DS4_v2"
	// VMSizeTypesStandardDS4V2Promo ...
	VMSizeTypesStandardDS4V2Promo VMSizeTypes = "Standard_DS4_v2_Promo"
	// VMSizeTypesStandardDS5V2 ...
	VMSizeTypesStandardDS5V2 VMSizeTypes = "Standard_DS5_v2"
	// VMSizeTypesStandardDS5V2Promo ...
	VMSizeTypesStandardDS5V2Promo VMSizeTypes = "Standard_DS5_v2_Promo"
	// VMSizeTypesStandardE16sV3 ...
	VMSizeTypesStandardE16sV3 VMSizeTypes = "Standard_E16s_v3"
	// VMSizeTypesStandardE16V3 ...
	VMSizeTypesStandardE16V3 VMSizeTypes = "Standard_E16_v3"
	// VMSizeTypesStandardE2sV3 ...
	VMSizeTypesStandardE2sV3 VMSizeTypes = "Standard_E2s_v3"
	// VMSizeTypesStandardE2V3 ...
	VMSizeTypesStandardE2V3 VMSizeTypes = "Standard_E2_v3"
	// VMSizeTypesStandardE3216sV3 ...
	VMSizeTypesStandardE3216sV3 VMSizeTypes = "Standard_E32-16s_v3"
	// VMSizeTypesStandardE328sV3 ...
	VMSizeTypesStandardE328sV3 VMSizeTypes = "Standard_E32-8s_v3"
	// VMSizeTypesStandardE32sV3 ...
	VMSizeTypesStandardE32sV3 VMSizeTypes = "Standard_E32s_v3"
	// VMSizeTypesStandardE32V3 ...
	VMSizeTypesStandardE32V3 VMSizeTypes = "Standard_E32_v3"
	// VMSizeTypesStandardE4sV3 ...
	VMSizeTypesStandardE4sV3 VMSizeTypes = "Standard_E4s_v3"
	// VMSizeTypesStandardE4V3 ...
	VMSizeTypesStandardE4V3 VMSizeTypes = "Standard_E4_v3"
	// VMSizeTypesStandardE6416sV3 ...
	VMSizeTypesStandardE6416sV3 VMSizeTypes = "Standard_E64-16s_v3"
	// VMSizeTypesStandardE6432sV3 ...
	VMSizeTypesStandardE6432sV3 VMSizeTypes = "Standard_E64-32s_v3"
	// VMSizeTypesStandardE64sV3 ...
	VMSizeTypesStandardE64sV3 VMSizeTypes = "Standard_E64s_v3"
	// VMSizeTypesStandardE64V3 ...
	VMSizeTypesStandardE64V3 VMSizeTypes = "Standard_E64_v3"
	// VMSizeTypesStandardE8sV3 ...
	VMSizeTypesStandardE8sV3 VMSizeTypes = "Standard_E8s_v3"
	// VMSizeTypesStandardE8V3 ...
	VMSizeTypesStandardE8V3 VMSizeTypes = "Standard_E8_v3"
	// VMSizeTypesStandardF1 ...
	VMSizeTypesStandardF1 VMSizeTypes = "Standard_F1"
	// VMSizeTypesStandardF16 ...
	VMSizeTypesStandardF16 VMSizeTypes = "Standard_F16"
	// VMSizeTypesStandardF16s ...
	VMSizeTypesStandardF16s VMSizeTypes = "Standard_F16s"
	// VMSizeTypesStandardF16sV2 ...
	VMSizeTypesStandardF16sV2 VMSizeTypes = "Standard_F16s_v2"
	// VMSizeTypesStandardF1s ...
	VMSizeTypesStandardF1s VMSizeTypes = "Standard_F1s"
	// VMSizeTypesStandardF2 ...
	VMSizeTypesStandardF2 VMSizeTypes = "Standard_F2"
	// VMSizeTypesStandardF2s ...
	VMSizeTypesStandardF2s VMSizeTypes = "Standard_F2s"
	// VMSizeTypesStandardF2sV2 ...
	VMSizeTypesStandardF2sV2 VMSizeTypes = "Standard_F2s_v2"
	// VMSizeTypesStandardF32sV2 ...
	VMSizeTypesStandardF32sV2 VMSizeTypes = "Standard_F32s_v2"
	// VMSizeTypesStandardF4 ...
	VMSizeTypesStandardF4 VMSizeTypes = "Standard_F4"
	// VMSizeTypesStandardF4s ...
	VMSizeTypesStandardF4s VMSizeTypes = "Standard_F4s"
	// VMSizeTypesStandardF4sV2 ...
	VMSizeTypesStandardF4sV2 VMSizeTypes = "Standard_F4s_v2"
	// VMSizeTypesStandardF64sV2 ...
	VMSizeTypesStandardF64sV2 VMSizeTypes = "Standard_F64s_v2"
	// VMSizeTypesStandardF72sV2 ...
	VMSizeTypesStandardF72sV2 VMSizeTypes = "Standard_F72s_v2"
	// VMSizeTypesStandardF8 ...
	VMSizeTypesStandardF8 VMSizeTypes = "Standard_F8"
	// VMSizeTypesStandardF8s ...
	VMSizeTypesStandardF8s VMSizeTypes = "Standard_F8s"
	// VMSizeTypesStandardF8sV2 ...
	VMSizeTypesStandardF8sV2 VMSizeTypes = "Standard_F8s_v2"
	// VMSizeTypesStandardG1 ...
	VMSizeTypesStandardG1 VMSizeTypes = "Standard_G1"
	// VMSizeTypesStandardG2 ...
	VMSizeTypesStandardG2 VMSizeTypes = "Standard_G2"
	// VMSizeTypesStandardG3 ...
	VMSizeTypesStandardG3 VMSizeTypes = "Standard_G3"
	// VMSizeTypesStandardG4 ...
	VMSizeTypesStandardG4 VMSizeTypes = "Standard_G4"
	// VMSizeTypesStandardG5 ...
	VMSizeTypesStandardG5 VMSizeTypes = "Standard_G5"
	// VMSizeTypesStandardGS1 ...
	VMSizeTypesStandardGS1 VMSizeTypes = "Standard_GS1"
	// VMSizeTypesStandardGS2 ...
	VMSizeTypesStandardGS2 VMSizeTypes = "Standard_GS2"
	// VMSizeTypesStandardGS3 ...
	VMSizeTypesStandardGS3 VMSizeTypes = "Standard_GS3"
	// VMSizeTypesStandardGS4 ...
	VMSizeTypesStandardGS4 VMSizeTypes = "Standard_GS4"
	// VMSizeTypesStandardGS44 ...
	VMSizeTypesStandardGS44 VMSizeTypes = "Standard_GS4-4"
	// VMSizeTypesStandardGS48 ...
	VMSizeTypesStandardGS48 VMSizeTypes = "Standard_GS4-8"
	// VMSizeTypesStandardGS5 ...
	VMSizeTypesStandardGS5 VMSizeTypes = "Standard_GS5"
	// VMSizeTypesStandardGS516 ...
	VMSizeTypesStandardGS516 VMSizeTypes = "Standard_GS5-16"
	// VMSizeTypesStandardGS58 ...
	VMSizeTypesStandardGS58 VMSizeTypes = "Standard_GS5-8"
	// VMSizeTypesStandardH16 ...
	VMSizeTypesStandardH16 VMSizeTypes = "Standard_H16"
	// VMSizeTypesStandardH16m ...
	VMSizeTypesStandardH16m VMSizeTypes = "Standard_H16m"
	// VMSizeTypesStandardH16mr ...
	VMSizeTypesStandardH16mr VMSizeTypes = "Standard_H16mr"
	// VMSizeTypesStandardH16r ...
	VMSizeTypesStandardH16r VMSizeTypes = "Standard_H16r"
	// VMSizeTypesStandardH8 ...
	VMSizeTypesStandardH8 VMSizeTypes = "Standard_H8"
	// VMSizeTypesStandardH8m ...
	VMSizeTypesStandardH8m VMSizeTypes = "Standard_H8m"
	// VMSizeTypesStandardL16s ...
	VMSizeTypesStandardL16s VMSizeTypes = "Standard_L16s"
	// VMSizeTypesStandardL32s ...
	VMSizeTypesStandardL32s VMSizeTypes = "Standard_L32s"
	// VMSizeTypesStandardL4s ...
	VMSizeTypesStandardL4s VMSizeTypes = "Standard_L4s"
	// VMSizeTypesStandardL8s ...
	VMSizeTypesStandardL8s VMSizeTypes = "Standard_L8s"
	// VMSizeTypesStandardM12832ms ...
	VMSizeTypesStandardM12832ms VMSizeTypes = "Standard_M128-32ms"
	// VMSizeTypesStandardM12864ms ...
	VMSizeTypesStandardM12864ms VMSizeTypes = "Standard_M128-64ms"
	// VMSizeTypesStandardM128ms ...
	VMSizeTypesStandardM128ms VMSizeTypes = "Standard_M128ms"
	// VMSizeTypesStandardM128s ...
	VMSizeTypesStandardM128s VMSizeTypes = "Standard_M128s"
	// VMSizeTypesStandardM6416ms ...
	VMSizeTypesStandardM6416ms VMSizeTypes = "Standard_M64-16ms"
	// VMSizeTypesStandardM6432ms ...
	VMSizeTypesStandardM6432ms VMSizeTypes = "Standard_M64-32ms"
	// VMSizeTypesStandardM64ms ...
	VMSizeTypesStandardM64ms VMSizeTypes = "Standard_M64ms"
	// VMSizeTypesStandardM64s ...
	VMSizeTypesStandardM64s VMSizeTypes = "Standard_M64s"
	// VMSizeTypesStandardNC12 ...
	VMSizeTypesStandardNC12 VMSizeTypes = "Standard_NC12"
	// VMSizeTypesStandardNC12sV2 ...
	VMSizeTypesStandardNC12sV2 VMSizeTypes = "Standard_NC12s_v2"
	// VMSizeTypesStandardNC12sV3 ...
	VMSizeTypesStandardNC12sV3 VMSizeTypes = "Standard_NC12s_v3"
	// VMSizeTypesStandardNC24 ...
	VMSizeTypesStandardNC24 VMSizeTypes = "Standard_NC24"
	// VMSizeTypesStandardNC24r ...
	VMSizeTypesStandardNC24r VMSizeTypes = "Standard_NC24r"
	// VMSizeTypesStandardNC24rsV2 ...
	VMSizeTypesStandardNC24rsV2 VMSizeTypes = "Standard_NC24rs_v2"
	// VMSizeTypesStandardNC24rsV3 ...
	VMSizeTypesStandardNC24rsV3 VMSizeTypes = "Standard_NC24rs_v3"
	// VMSizeTypesStandardNC24sV2 ...
	VMSizeTypesStandardNC24sV2 VMSizeTypes = "Standard_NC24s_v2"
	// VMSizeTypesStandardNC24sV3 ...
	VMSizeTypesStandardNC24sV3 VMSizeTypes = "Standard_NC24s_v3"
	// VMSizeTypesStandardNC6 ...
	VMSizeTypesStandardNC6 VMSizeTypes = "Standard_NC6"
	// VMSizeTypesStandardNC6sV2 ...
	VMSizeTypesStandardNC6sV2 VMSizeTypes = "Standard_NC6s_v2"
	// VMSizeTypesStandardNC6sV3 ...
	VMSizeTypesStandardNC6sV3 VMSizeTypes = "Standard_NC6s_v3"
	// VMSizeTypesStandardND12s ...
	VMSizeTypesStandardND12s VMSizeTypes = "Standard_ND12s"
	// VMSizeTypesStandardND24rs ...
	VMSizeTypesStandardND24rs VMSizeTypes = "Standard_ND24rs"
	// VMSizeTypesStandardND24s ...
	VMSizeTypesStandardND24s VMSizeTypes = "Standard_ND24s"
	// VMSizeTypesStandardND6s ...
	VMSizeTypesStandardND6s VMSizeTypes = "Standard_ND6s"
	// VMSizeTypesStandardNV12 ...
	VMSizeTypesStandardNV12 VMSizeTypes = "Standard_NV12"
	// VMSizeTypesStandardNV24 ...
	VMSizeTypesStandardNV24 VMSizeTypes = "Standard_NV24"
	// VMSizeTypesStandardNV6 ...
	VMSizeTypesStandardNV6 VMSizeTypes = "Standard_NV6"
)

// PossibleVMSizeTypesValues returns an array of possible values for the VMSizeTypes const type.
func PossibleVMSizeTypesValues() []VMSizeTypes {
	return []VMSizeTypes{VMSizeTypesStandardA1, VMSizeTypesStandardA10, VMSizeTypesStandardA11, VMSizeTypesStandardA1V2, VMSizeTypesStandardA2, VMSizeTypesStandardA2mV2, VMSizeTypesStandardA2V2, VMSizeTypesStandardA3, VMSizeTypesStandardA4, VMSizeTypesStandardA4mV2, VMSizeTypesStandardA4V2, VMSizeTypesStandardA5, VMSizeTypesStandardA6, VMSizeTypesStandardA7, VMSizeTypesStandardA8, VMSizeTypesStandardA8mV2, VMSizeTypesStandardA8V2, VMSizeTypesStandardA9, VMSizeTypesStandardB2ms, VMSizeTypesStandardB2s, VMSizeTypesStandardB4ms, VMSizeTypesStandardB8ms, VMSizeTypesStandardD1, VMSizeTypesStandardD11, VMSizeTypesStandardD11V2, VMSizeTypesStandardD11V2Promo, VMSizeTypesStandardD12, VMSizeTypesStandardD12V2, VMSizeTypesStandardD12V2Promo, VMSizeTypesStandardD13, VMSizeTypesStandardD13V2, VMSizeTypesStandardD13V2Promo, VMSizeTypesStandardD14, VMSizeTypesStandardD14V2, VMSizeTypesStandardD14V2Promo, VMSizeTypesStandardD15V2, VMSizeTypesStandardD16sV3, VMSizeTypesStandardD16V3, VMSizeTypesStandardD1V2, VMSizeTypesStandardD2, VMSizeTypesStandardD2sV3, VMSizeTypesStandardD2V2, VMSizeTypesStandardD2V2Promo, VMSizeTypesStandardD2V3, VMSizeTypesStandardD3, VMSizeTypesStandardD32sV3, VMSizeTypesStandardD32V3, VMSizeTypesStandardD3V2, VMSizeTypesStandardD3V2Promo, VMSizeTypesStandardD4, VMSizeTypesStandardD4sV3, VMSizeTypesStandardD4V2, VMSizeTypesStandardD4V2Promo, VMSizeTypesStandardD4V3, VMSizeTypesStandardD5V2, VMSizeTypesStandardD5V2Promo, VMSizeTypesStandardD64sV3, VMSizeTypesStandardD64V3, VMSizeTypesStandardD8sV3, VMSizeTypesStandardD8V3, VMSizeTypesStandardDS1, VMSizeTypesStandardDS11, VMSizeTypesStandardDS11V2, VMSizeTypesStandardDS11V2Promo, VMSizeTypesStandardDS12, VMSizeTypesStandardDS12V2, VMSizeTypesStandardDS12V2Promo, VMSizeTypesStandardDS13, VMSizeTypesStandardDS132V2, VMSizeTypesStandardDS134V2, VMSizeTypesStandardDS13V2, VMSizeTypesStandardDS13V2Promo, VMSizeTypesStandardDS14, VMSizeTypesStandardDS144V2, VMSizeTypesStandardDS148V2, VMSizeTypesStandardDS14V2, VMSizeTypesStandardDS14V2Promo, VMSizeTypesStandardDS15V2, VMSizeTypesStandardDS1V2, VMSizeTypesStandardDS2, VMSizeTypesStandardDS2V2, VMSizeTypesStandardDS2V2Promo, VMSizeTypesStandardDS3, VMSizeTypesStandardDS3V2, VMSizeTypesStandardDS3V2Promo, VMSizeTypesStandardDS4, VMSizeTypesStandardDS4V2, VMSizeTypesStandardDS4V2Promo, VMSizeTypesStandardDS5V2, VMSizeTypesStandardDS5V2Promo, VMSizeTypesStandardE16sV3, VMSizeTypesStandardE16V3, VMSizeTypesStandardE2sV3, VMSizeTypesStandardE2V3, VMSizeTypesStandardE3216sV3, VMSizeTypesStandardE328sV3, VMSizeTypesStandardE32sV3, VMSizeTypesStandardE32V3, VMSizeTypesStandardE4sV3, VMSizeTypesStandardE4V3, VMSizeTypesStandardE6416sV3, VMSizeTypesStandardE6432sV3, VMSizeTypesStandardE64sV3, VMSizeTypesStandardE64V3, VMSizeTypesStandardE8sV3, VMSizeTypesStandardE8V3, VMSizeTypesStandardF1, VMSizeTypesStandardF16, VMSizeTypesStandardF16s, VMSizeTypesStandardF16sV2, VMSizeTypesStandardF1s, VMSizeTypesStandardF2, VMSizeTypesStandardF2s, VMSizeTypesStandardF2sV2, VMSizeTypesStandardF32sV2, VMSizeTypesStandardF4, VMSizeTypesStandardF4s, VMSizeTypesStandardF4sV2, VMSizeTypesStandardF64sV2, VMSizeTypesStandardF72sV2, VMSizeTypesStandardF8, VMSizeTypesStandardF8s, VMSizeTypesStandardF8sV2, VMSizeTypesStandardG1, VMSizeTypesStandardG2, VMSizeTypesStandardG3, VMSizeTypesStandardG4, VMSizeTypesStandardG5, VMSizeTypesStandardGS1, VMSizeTypesStandardGS2, VMSizeTypesStandardGS3, VMSizeTypesStandardGS4, VMSizeTypesStandardGS44, VMSizeTypesStandardGS48, VMSizeTypesStandardGS5, VMSizeTypesStandardGS516, VMSizeTypesStandardGS58, VMSizeTypesStandardH16, VMSizeTypesStandardH16m, VMSizeTypesStandardH16mr, VMSizeTypesStandardH16r, VMSizeTypesStandardH8, VMSizeTypesStandardH8m, VMSizeTypesStandardL16s, VMSizeTypesStandardL32s, VMSizeTypesStandardL4s, VMSizeTypesStandardL8s, VMSizeTypesStandardM12832ms, VMSizeTypesStandardM12864ms, VMSizeTypesStandardM128ms, VMSizeTypesStandardM128s, VMSizeTypesStandardM6416ms, VMSizeTypesStandardM6432ms, VMSizeTypesStandardM64ms, VMSizeTypesStandardM64s, VMSizeTypesStandardNC12, VMSizeTypesStandardNC12sV2, VMSizeTypesStandardNC12sV3, VMSizeTypesStandardNC24, VMSizeTypesStandardNC24r, VMSizeTypesStandardNC24rsV2, VMSizeTypesStandardNC24rsV3, VMSizeTypesStandardNC24sV2, VMSizeTypesStandardNC24sV3, VMSizeTypesStandardNC6, VMSizeTypesStandardNC6sV2, VMSizeTypesStandardNC6sV3, VMSizeTypesStandardND12s, VMSizeTypesStandardND24rs, VMSizeTypesStandardND24s, VMSizeTypesStandardND6s, VMSizeTypesStandardNV12, VMSizeTypesStandardNV24, VMSizeTypesStandardNV6}
}

// AccessProfile profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// KubeConfig - Base64-encoded Kubernetes configuration file.
	KubeConfig *[]byte `json:"kubeConfig,omitempty"`
}

// AgentPoolProfile profile for the container service agent pool.
type AgentPoolProfile struct {
	// Name - Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'VMSizeTypesStandardA1', 'VMSizeTypesStandardA10', 'VMSizeTypesStandardA11', 'VMSizeTypesStandardA1V2', 'VMSizeTypesStandardA2', 'VMSizeTypesStandardA2V2', 'VMSizeTypesStandardA2mV2', 'VMSizeTypesStandardA3', 'VMSizeTypesStandardA4', 'VMSizeTypesStandardA4V2', 'VMSizeTypesStandardA4mV2', 'VMSizeTypesStandardA5', 'VMSizeTypesStandardA6', 'VMSizeTypesStandardA7', 'VMSizeTypesStandardA8', 'VMSizeTypesStandardA8V2', 'VMSizeTypesStandardA8mV2', 'VMSizeTypesStandardA9', 'VMSizeTypesStandardB2ms', 'VMSizeTypesStandardB2s', 'VMSizeTypesStandardB4ms', 'VMSizeTypesStandardB8ms', 'VMSizeTypesStandardD1', 'VMSizeTypesStandardD11', 'VMSizeTypesStandardD11V2', 'VMSizeTypesStandardD11V2Promo', 'VMSizeTypesStandardD12', 'VMSizeTypesStandardD12V2', 'VMSizeTypesStandardD12V2Promo', 'VMSizeTypesStandardD13', 'VMSizeTypesStandardD13V2', 'VMSizeTypesStandardD13V2Promo', 'VMSizeTypesStandardD14', 'VMSizeTypesStandardD14V2', 'VMSizeTypesStandardD14V2Promo', 'VMSizeTypesStandardD15V2', 'VMSizeTypesStandardD16V3', 'VMSizeTypesStandardD16sV3', 'VMSizeTypesStandardD1V2', 'VMSizeTypesStandardD2', 'VMSizeTypesStandardD2V2', 'VMSizeTypesStandardD2V2Promo', 'VMSizeTypesStandardD2V3', 'VMSizeTypesStandardD2sV3', 'VMSizeTypesStandardD3', 'VMSizeTypesStandardD32V3', 'VMSizeTypesStandardD32sV3', 'VMSizeTypesStandardD3V2', 'VMSizeTypesStandardD3V2Promo', 'VMSizeTypesStandardD4', 'VMSizeTypesStandardD4V2', 'VMSizeTypesStandardD4V2Promo', 'VMSizeTypesStandardD4V3', 'VMSizeTypesStandardD4sV3', 'VMSizeTypesStandardD5V2', 'VMSizeTypesStandardD5V2Promo', 'VMSizeTypesStandardD64V3', 'VMSizeTypesStandardD64sV3', 'VMSizeTypesStandardD8V3', 'VMSizeTypesStandardD8sV3', 'VMSizeTypesStandardDS1', 'VMSizeTypesStandardDS11', 'VMSizeTypesStandardDS11V2', 'VMSizeTypesStandardDS11V2Promo', 'VMSizeTypesStandardDS12', 'VMSizeTypesStandardDS12V2', 'VMSizeTypesStandardDS12V2Promo', 'VMSizeTypesStandardDS13', 'VMSizeTypesStandardDS132V2', 'VMSizeTypesStandardDS134V2', 'VMSizeTypesStandardDS13V2', 'VMSizeTypesStandardDS13V2Promo', 'VMSizeTypesStandardDS14', 'VMSizeTypesStandardDS144V2', 'VMSizeTypesStandardDS148V2', 'VMSizeTypesStandardDS14V2', 'VMSizeTypesStandardDS14V2Promo', 'VMSizeTypesStandardDS15V2', 'VMSizeTypesStandardDS1V2', 'VMSizeTypesStandardDS2', 'VMSizeTypesStandardDS2V2', 'VMSizeTypesStandardDS2V2Promo', 'VMSizeTypesStandardDS3', 'VMSizeTypesStandardDS3V2', 'VMSizeTypesStandardDS3V2Promo', 'VMSizeTypesStandardDS4', 'VMSizeTypesStandardDS4V2', 'VMSizeTypesStandardDS4V2Promo', 'VMSizeTypesStandardDS5V2', 'VMSizeTypesStandardDS5V2Promo', 'VMSizeTypesStandardE16V3', 'VMSizeTypesStandardE16sV3', 'VMSizeTypesStandardE2V3', 'VMSizeTypesStandardE2sV3', 'VMSizeTypesStandardE3216sV3', 'VMSizeTypesStandardE328sV3', 'VMSizeTypesStandardE32V3', 'VMSizeTypesStandardE32sV3', 'VMSizeTypesStandardE4V3', 'VMSizeTypesStandardE4sV3', 'VMSizeTypesStandardE6416sV3', 'VMSizeTypesStandardE6432sV3', 'VMSizeTypesStandardE64V3', 'VMSizeTypesStandardE64sV3', 'VMSizeTypesStandardE8V3', 'VMSizeTypesStandardE8sV3', 'VMSizeTypesStandardF1', 'VMSizeTypesStandardF16', 'VMSizeTypesStandardF16s', 'VMSizeTypesStandardF16sV2', 'VMSizeTypesStandardF1s', 'VMSizeTypesStandardF2', 'VMSizeTypesStandardF2s', 'VMSizeTypesStandardF2sV2', 'VMSizeTypesStandardF32sV2', 'VMSizeTypesStandardF4', 'VMSizeTypesStandardF4s', 'VMSizeTypesStandardF4sV2', 'VMSizeTypesStandardF64sV2', 'VMSizeTypesStandardF72sV2', 'VMSizeTypesStandardF8', 'VMSizeTypesStandardF8s', 'VMSizeTypesStandardF8sV2', 'VMSizeTypesStandardG1', 'VMSizeTypesStandardG2', 'VMSizeTypesStandardG3', 'VMSizeTypesStandardG4', 'VMSizeTypesStandardG5', 'VMSizeTypesStandardGS1', 'VMSizeTypesStandardGS2', 'VMSizeTypesStandardGS3', 'VMSizeTypesStandardGS4', 'VMSizeTypesStandardGS44', 'VMSizeTypesStandardGS48', 'VMSizeTypesStandardGS5', 'VMSizeTypesStandardGS516', 'VMSizeTypesStandardGS58', 'VMSizeTypesStandardH16', 'VMSizeTypesStandardH16m', 'VMSizeTypesStandardH16mr', 'VMSizeTypesStandardH16r', 'VMSizeTypesStandardH8', 'VMSizeTypesStandardH8m', 'VMSizeTypesStandardL16s', 'VMSizeTypesStandardL32s', 'VMSizeTypesStandardL4s', 'VMSizeTypesStandardL8s', 'VMSizeTypesStandardM12832ms', 'VMSizeTypesStandardM12864ms', 'VMSizeTypesStandardM128ms', 'VMSizeTypesStandardM128s', 'VMSizeTypesStandardM6416ms', 'VMSizeTypesStandardM6432ms', 'VMSizeTypesStandardM64ms', 'VMSizeTypesStandardM64s', 'VMSizeTypesStandardNC12', 'VMSizeTypesStandardNC12sV2', 'VMSizeTypesStandardNC12sV3', 'VMSizeTypesStandardNC24', 'VMSizeTypesStandardNC24r', 'VMSizeTypesStandardNC24rsV2', 'VMSizeTypesStandardNC24rsV3', 'VMSizeTypesStandardNC24sV2', 'VMSizeTypesStandardNC24sV3', 'VMSizeTypesStandardNC6', 'VMSizeTypesStandardNC6sV2', 'VMSizeTypesStandardNC6sV3', 'VMSizeTypesStandardND12s', 'VMSizeTypesStandardND24rs', 'VMSizeTypesStandardND24s', 'VMSizeTypesStandardND6s', 'VMSizeTypesStandardNV12', 'VMSizeTypesStandardNV24', 'VMSizeTypesStandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the agent pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// Fqdn - FDQN for the agent pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// Ports - Ports number array used to expose on this agent pool. The default opened ports are different based on your choice of orchestrator.
	Ports *[]int32 `json:"ports,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageAccount', 'ManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the vnet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
}

// CloudError an error response from the Container service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Container service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ContainerService container service.
type ContainerService struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the container service.
	*Properties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ContainerService.
func (cs ContainerService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.Properties != nil {
		objectMap["properties"] = cs.Properties
	}
	if cs.ID != nil {
		objectMap["id"] = cs.ID
	}
	if cs.Name != nil {
		objectMap["name"] = cs.Name
	}
	if cs.Type != nil {
		objectMap["type"] = cs.Type
	}
	if cs.Location != nil {
		objectMap["location"] = cs.Location
	}
	if cs.Tags != nil {
		objectMap["tags"] = cs.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContainerService struct.
func (cs *ContainerService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				cs.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cs.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cs.Tags = tags
			}
		}
	}

	return nil
}

// ContainerServicesCreateOrUpdateFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ContainerServicesCreateOrUpdateFutureType struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ContainerServicesCreateOrUpdateFutureType) Result(client ContainerServicesClient) (cs ContainerService, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ContainerServicesCreateOrUpdateFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.ContainerServicesCreateOrUpdateFutureType")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cs.Response.Response, err = future.GetResult(sender); err == nil && cs.Response.Response.StatusCode != http.StatusNoContent {
		cs, err = client.CreateOrUpdateResponder(cs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ContainerServicesCreateOrUpdateFutureType", "Result", cs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ContainerServicesDeleteFutureType an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ContainerServicesDeleteFutureType struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ContainerServicesDeleteFutureType) Result(client ContainerServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ContainerServicesDeleteFutureType", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.ContainerServicesDeleteFutureType")
		return
	}
	ar.Response = future.Response()
	return
}

// CredentialResult the credential result response.
type CredentialResult struct {
	// Name - The name of the credential.
	Name *string `json:"name,omitempty"`
	// Value - Base64-encoded Kubernetes configuration file.
	Value *[]byte `json:"value,omitempty"`
}

// CredentialResults the list of credential result response.
type CredentialResults struct {
	autorest.Response `json:"-"`
	Kubeconfigs       *[]CredentialResult `json:"kubeconfigs,omitempty"`
}

// CustomProfile properties to configure a custom container service cluster.
type CustomProfile struct {
	// Orchestrator - The name of the custom orchestrator to use.
	Orchestrator *string `json:"orchestrator,omitempty"`
}

// DiagnosticsProfile profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// VMDiagnostics - Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// KeyVaultSecretRef reference to a secret stored in Azure Key Vault.
type KeyVaultSecretRef struct {
	// VaultID - Key vault identifier.
	VaultID *string `json:"vaultID,omitempty"`
	// SecretName - The secret name.
	SecretName *string `json:"secretName,omitempty"`
	// Version - The secret version.
	Version *string `json:"version,omitempty"`
}

// LinuxProfile profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// AdminUsername - The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// SSH - SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// ListResult the response from the List Container Services operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container services.
	Value *[]ContainerService `json:"value,omitempty"`
	// NextLink - The URL to get the next set of container service results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ContainerService values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ContainerService {
	if !iter.page.NotDone() {
		return ContainerService{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ContainerService values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ContainerService {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// ManagedCluster managed cluster.
type ManagedCluster struct {
	autorest.Response `json:"-"`
	// ManagedClusterProperties - Properties of a managed cluster.
	*ManagedClusterProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedCluster.
func (mc ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.ManagedClusterProperties != nil {
		objectMap["properties"] = mc.ManagedClusterProperties
	}
	if mc.ID != nil {
		objectMap["id"] = mc.ID
	}
	if mc.Name != nil {
		objectMap["name"] = mc.Name
	}
	if mc.Type != nil {
		objectMap["type"] = mc.Type
	}
	if mc.Location != nil {
		objectMap["location"] = mc.Location
	}
	if mc.Tags != nil {
		objectMap["tags"] = mc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedCluster struct.
func (mc *ManagedCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedClusterProperties ManagedClusterProperties
				err = json.Unmarshal(*v, &managedClusterProperties)
				if err != nil {
					return err
				}
				mc.ManagedClusterProperties = &managedClusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mc.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAADProfile aADProfile specifies attributes for Azure Active Directory integration.
type ManagedClusterAADProfile struct {
	// ClientAppID - The client AAD application ID.
	ClientAppID *string `json:"clientAppID,omitempty"`
	// ServerAppID - The server AAD application ID.
	ServerAppID *string `json:"serverAppID,omitempty"`
	// ServerAppSecret - The server AAD application secret.
	ServerAppSecret *string `json:"serverAppSecret,omitempty"`
	// TenantID - The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string `json:"tenantID,omitempty"`
}

// ManagedClusterAccessProfile managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	autorest.Response `json:"-"`
	// AccessProfile - AccessProfile of a managed cluster.
	*AccessProfile `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAccessProfile.
func (mcap ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.AccessProfile != nil {
		objectMap["properties"] = mcap.AccessProfile
	}
	if mcap.ID != nil {
		objectMap["id"] = mcap.ID
	}
	if mcap.Name != nil {
		objectMap["name"] = mcap.Name
	}
	if mcap.Type != nil {
		objectMap["type"] = mcap.Type
	}
	if mcap.Location != nil {
		objectMap["location"] = mcap.Location
	}
	if mcap.Tags != nil {
		objectMap["tags"] = mcap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterAccessProfile struct.
func (mcap *ManagedClusterAccessProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accessProfile AccessProfile
				err = json.Unmarshal(*v, &accessProfile)
				if err != nil {
					return err
				}
				mcap.AccessProfile = &accessProfile
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mcap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcap.Tags = tags
			}
		}
	}

	return nil
}

// ManagedClusterAddonProfile a Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// Enabled - Whether the add-on is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Config - Key-value pairs for configuring an add-on.
	Config map[string]*string `json:"config"`
}

// MarshalJSON is the custom marshaler for ManagedClusterAddonProfile.
func (mcap ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcap.Enabled != nil {
		objectMap["enabled"] = mcap.Enabled
	}
	if mcap.Config != nil {
		objectMap["config"] = mcap.Config
	}
	return json.Marshal(objectMap)
}

// ManagedClusterAgentPoolProfile profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// Name - Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'VMSizeTypesStandardA1', 'VMSizeTypesStandardA10', 'VMSizeTypesStandardA11', 'VMSizeTypesStandardA1V2', 'VMSizeTypesStandardA2', 'VMSizeTypesStandardA2V2', 'VMSizeTypesStandardA2mV2', 'VMSizeTypesStandardA3', 'VMSizeTypesStandardA4', 'VMSizeTypesStandardA4V2', 'VMSizeTypesStandardA4mV2', 'VMSizeTypesStandardA5', 'VMSizeTypesStandardA6', 'VMSizeTypesStandardA7', 'VMSizeTypesStandardA8', 'VMSizeTypesStandardA8V2', 'VMSizeTypesStandardA8mV2', 'VMSizeTypesStandardA9', 'VMSizeTypesStandardB2ms', 'VMSizeTypesStandardB2s', 'VMSizeTypesStandardB4ms', 'VMSizeTypesStandardB8ms', 'VMSizeTypesStandardD1', 'VMSizeTypesStandardD11', 'VMSizeTypesStandardD11V2', 'VMSizeTypesStandardD11V2Promo', 'VMSizeTypesStandardD12', 'VMSizeTypesStandardD12V2', 'VMSizeTypesStandardD12V2Promo', 'VMSizeTypesStandardD13', 'VMSizeTypesStandardD13V2', 'VMSizeTypesStandardD13V2Promo', 'VMSizeTypesStandardD14', 'VMSizeTypesStandardD14V2', 'VMSizeTypesStandardD14V2Promo', 'VMSizeTypesStandardD15V2', 'VMSizeTypesStandardD16V3', 'VMSizeTypesStandardD16sV3', 'VMSizeTypesStandardD1V2', 'VMSizeTypesStandardD2', 'VMSizeTypesStandardD2V2', 'VMSizeTypesStandardD2V2Promo', 'VMSizeTypesStandardD2V3', 'VMSizeTypesStandardD2sV3', 'VMSizeTypesStandardD3', 'VMSizeTypesStandardD32V3', 'VMSizeTypesStandardD32sV3', 'VMSizeTypesStandardD3V2', 'VMSizeTypesStandardD3V2Promo', 'VMSizeTypesStandardD4', 'VMSizeTypesStandardD4V2', 'VMSizeTypesStandardD4V2Promo', 'VMSizeTypesStandardD4V3', 'VMSizeTypesStandardD4sV3', 'VMSizeTypesStandardD5V2', 'VMSizeTypesStandardD5V2Promo', 'VMSizeTypesStandardD64V3', 'VMSizeTypesStandardD64sV3', 'VMSizeTypesStandardD8V3', 'VMSizeTypesStandardD8sV3', 'VMSizeTypesStandardDS1', 'VMSizeTypesStandardDS11', 'VMSizeTypesStandardDS11V2', 'VMSizeTypesStandardDS11V2Promo', 'VMSizeTypesStandardDS12', 'VMSizeTypesStandardDS12V2', 'VMSizeTypesStandardDS12V2Promo', 'VMSizeTypesStandardDS13', 'VMSizeTypesStandardDS132V2', 'VMSizeTypesStandardDS134V2', 'VMSizeTypesStandardDS13V2', 'VMSizeTypesStandardDS13V2Promo', 'VMSizeTypesStandardDS14', 'VMSizeTypesStandardDS144V2', 'VMSizeTypesStandardDS148V2', 'VMSizeTypesStandardDS14V2', 'VMSizeTypesStandardDS14V2Promo', 'VMSizeTypesStandardDS15V2', 'VMSizeTypesStandardDS1V2', 'VMSizeTypesStandardDS2', 'VMSizeTypesStandardDS2V2', 'VMSizeTypesStandardDS2V2Promo', 'VMSizeTypesStandardDS3', 'VMSizeTypesStandardDS3V2', 'VMSizeTypesStandardDS3V2Promo', 'VMSizeTypesStandardDS4', 'VMSizeTypesStandardDS4V2', 'VMSizeTypesStandardDS4V2Promo', 'VMSizeTypesStandardDS5V2', 'VMSizeTypesStandardDS5V2Promo', 'VMSizeTypesStandardE16V3', 'VMSizeTypesStandardE16sV3', 'VMSizeTypesStandardE2V3', 'VMSizeTypesStandardE2sV3', 'VMSizeTypesStandardE3216sV3', 'VMSizeTypesStandardE328sV3', 'VMSizeTypesStandardE32V3', 'VMSizeTypesStandardE32sV3', 'VMSizeTypesStandardE4V3', 'VMSizeTypesStandardE4sV3', 'VMSizeTypesStandardE6416sV3', 'VMSizeTypesStandardE6432sV3', 'VMSizeTypesStandardE64V3', 'VMSizeTypesStandardE64sV3', 'VMSizeTypesStandardE8V3', 'VMSizeTypesStandardE8sV3', 'VMSizeTypesStandardF1', 'VMSizeTypesStandardF16', 'VMSizeTypesStandardF16s', 'VMSizeTypesStandardF16sV2', 'VMSizeTypesStandardF1s', 'VMSizeTypesStandardF2', 'VMSizeTypesStandardF2s', 'VMSizeTypesStandardF2sV2', 'VMSizeTypesStandardF32sV2', 'VMSizeTypesStandardF4', 'VMSizeTypesStandardF4s', 'VMSizeTypesStandardF4sV2', 'VMSizeTypesStandardF64sV2', 'VMSizeTypesStandardF72sV2', 'VMSizeTypesStandardF8', 'VMSizeTypesStandardF8s', 'VMSizeTypesStandardF8sV2', 'VMSizeTypesStandardG1', 'VMSizeTypesStandardG2', 'VMSizeTypesStandardG3', 'VMSizeTypesStandardG4', 'VMSizeTypesStandardG5', 'VMSizeTypesStandardGS1', 'VMSizeTypesStandardGS2', 'VMSizeTypesStandardGS3', 'VMSizeTypesStandardGS4', 'VMSizeTypesStandardGS44', 'VMSizeTypesStandardGS48', 'VMSizeTypesStandardGS5', 'VMSizeTypesStandardGS516', 'VMSizeTypesStandardGS58', 'VMSizeTypesStandardH16', 'VMSizeTypesStandardH16m', 'VMSizeTypesStandardH16mr', 'VMSizeTypesStandardH16r', 'VMSizeTypesStandardH8', 'VMSizeTypesStandardH8m', 'VMSizeTypesStandardL16s', 'VMSizeTypesStandardL32s', 'VMSizeTypesStandardL4s', 'VMSizeTypesStandardL8s', 'VMSizeTypesStandardM12832ms', 'VMSizeTypesStandardM12864ms', 'VMSizeTypesStandardM128ms', 'VMSizeTypesStandardM128s', 'VMSizeTypesStandardM6416ms', 'VMSizeTypesStandardM6432ms', 'VMSizeTypesStandardM64ms', 'VMSizeTypesStandardM64s', 'VMSizeTypesStandardNC12', 'VMSizeTypesStandardNC12sV2', 'VMSizeTypesStandardNC12sV3', 'VMSizeTypesStandardNC24', 'VMSizeTypesStandardNC24r', 'VMSizeTypesStandardNC24rsV2', 'VMSizeTypesStandardNC24rsV3', 'VMSizeTypesStandardNC24sV2', 'VMSizeTypesStandardNC24sV3', 'VMSizeTypesStandardNC6', 'VMSizeTypesStandardNC6sV2', 'VMSizeTypesStandardNC6sV3', 'VMSizeTypesStandardND12s', 'VMSizeTypesStandardND24rs', 'VMSizeTypesStandardND24s', 'VMSizeTypesStandardND6s', 'VMSizeTypesStandardNV12', 'VMSizeTypesStandardNV24', 'VMSizeTypesStandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the vnet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// MaxPods - Maximum number of pods that can run on a node.
	MaxPods *int32 `json:"maxPods,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// MaxCount - Maximum number of nodes for auto-scaling
	MaxCount *int32 `json:"maxCount,omitempty"`
	// MinCount - Minimum number of nodes for auto-scaling
	MinCount *int32 `json:"minCount,omitempty"`
	// EnableAutoScaling - Whether to enable auto-scaler
	EnableAutoScaling *bool `json:"enableAutoScaling,omitempty"`
	// Type - AgentPoolType represents types of agentpool. Possible values include: 'VirtualMachineScaleSets', 'AvailabilitySet'
	Type AgentPoolType `json:"type,omitempty"`
}

// ManagedClusterListResult the response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed clusters.
	Value *[]ManagedCluster `json:"value,omitempty"`
	// NextLink - The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedClusterListResultIterator provides access to a complete listing of ManagedCluster values.
type ManagedClusterListResultIterator struct {
	i    int
	page ManagedClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedClusterListResultIterator) Response() ManagedClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedClusterListResultIterator) Value() ManagedCluster {
	if !iter.page.NotDone() {
		return ManagedCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedClusterListResultIterator type.
func NewManagedClusterListResultIterator(page ManagedClusterListResultPage) ManagedClusterListResultIterator {
	return ManagedClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr ManagedClusterListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// managedClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr ManagedClusterListResult) managedClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if mclr.NextLink == nil || len(to.String(mclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// ManagedClusterListResultPage contains a page of ManagedCluster values.
type ManagedClusterListResultPage struct {
	fn   func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)
	mclr ManagedClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mclr)
	if err != nil {
		return err
	}
	page.mclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedClusterListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedClusterListResultPage) Response() ManagedClusterListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedClusterListResultPage) Values() []ManagedCluster {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// Creates a new instance of the ManagedClusterListResultPage type.
func NewManagedClusterListResultPage(getNextPage func(context.Context, ManagedClusterListResult) (ManagedClusterListResult, error)) ManagedClusterListResultPage {
	return ManagedClusterListResultPage{fn: getNextPage}
}

// ManagedClusterPoolUpgradeProfile the list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// Name - Pool name.
	Name *string `json:"name,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]string `json:"upgrades,omitempty"`
}

// ManagedClusterProperties properties of the managed cluster.
type ManagedClusterProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// DNSPrefix - DNS prefix specified when creating the managed cluster.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// Fqdn - FDQN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// AgentPoolProfiles - Properties of the agent pool.
	AgentPoolProfiles *[]ManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// LinuxProfile - Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	// AddonProfiles - Profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile `json:"addonProfiles"`
	// NodeResourceGroup - Name of the resource group containing agent pool nodes.
	NodeResourceGroup *string `json:"nodeResourceGroup,omitempty"`
	// EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool `json:"enableRBAC,omitempty"`
	// NetworkProfile - Profile of network configuration.
	NetworkProfile *NetworkProfileType `json:"networkProfile,omitempty"`
	// AadProfile - Profile of Azure Active Directory configuration.
	AadProfile *ManagedClusterAADProfile `json:"aadProfile,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterProperties.
func (mcp ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcp.ProvisioningState != nil {
		objectMap["provisioningState"] = mcp.ProvisioningState
	}
	if mcp.KubernetesVersion != nil {
		objectMap["kubernetesVersion"] = mcp.KubernetesVersion
	}
	if mcp.DNSPrefix != nil {
		objectMap["dnsPrefix"] = mcp.DNSPrefix
	}
	if mcp.Fqdn != nil {
		objectMap["fqdn"] = mcp.Fqdn
	}
	if mcp.AgentPoolProfiles != nil {
		objectMap["agentPoolProfiles"] = mcp.AgentPoolProfiles
	}
	if mcp.LinuxProfile != nil {
		objectMap["linuxProfile"] = mcp.LinuxProfile
	}
	if mcp.ServicePrincipalProfile != nil {
		objectMap["servicePrincipalProfile"] = mcp.ServicePrincipalProfile
	}
	if mcp.AddonProfiles != nil {
		objectMap["addonProfiles"] = mcp.AddonProfiles
	}
	if mcp.NodeResourceGroup != nil {
		objectMap["nodeResourceGroup"] = mcp.NodeResourceGroup
	}
	if mcp.EnableRBAC != nil {
		objectMap["enableRBAC"] = mcp.EnableRBAC
	}
	if mcp.NetworkProfile != nil {
		objectMap["networkProfile"] = mcp.NetworkProfile
	}
	if mcp.AadProfile != nil {
		objectMap["aadProfile"] = mcp.AadProfile
	}
	return json.Marshal(objectMap)
}

// ManagedClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedClustersCreateOrUpdateFuture) Result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.CreateOrUpdateResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersCreateOrUpdateFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedClustersDeleteFuture) Result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedClusterServicePrincipalProfile information about a service principal identity for the cluster to
// use for manipulating Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// ClientID - The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
}

// ManagedClustersUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedClustersUpdateTagsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedClustersUpdateTagsFuture) Result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.ManagedClustersUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mc.Response.Response, err = future.GetResult(sender); err == nil && mc.Response.Response.StatusCode != http.StatusNoContent {
		mc, err = client.UpdateTagsResponder(mc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.ManagedClustersUpdateTagsFuture", "Result", mc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedClusterUpgradeProfile the list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - Id of upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - Name of upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - Type of upgrade profile.
	Type *string `json:"type,omitempty"`
	// ManagedClusterUpgradeProfileProperties - Properties of upgrade profile.
	*ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedClusterUpgradeProfile.
func (mcup ManagedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcup.ID != nil {
		objectMap["id"] = mcup.ID
	}
	if mcup.Name != nil {
		objectMap["name"] = mcup.Name
	}
	if mcup.Type != nil {
		objectMap["type"] = mcup.Type
	}
	if mcup.ManagedClusterUpgradeProfileProperties != nil {
		objectMap["properties"] = mcup.ManagedClusterUpgradeProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterUpgradeProfile struct.
func (mcup *ManagedClusterUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcup.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var managedClusterUpgradeProfileProperties ManagedClusterUpgradeProfileProperties
				err = json.Unmarshal(*v, &managedClusterUpgradeProfileProperties)
				if err != nil {
					return err
				}
				mcup.ManagedClusterUpgradeProfileProperties = &managedClusterUpgradeProfileProperties
			}
		}
	}

	return nil
}

// ManagedClusterUpgradeProfileProperties control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// ControlPlaneProfile - The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
	// AgentPoolProfiles - The list of available upgrade versions for agent pools.
	AgentPoolProfiles *[]ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`
}

// MasterProfile profile for the container service master.
type MasterProfile struct {
	// Count - Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'VMSizeTypesStandardA1', 'VMSizeTypesStandardA10', 'VMSizeTypesStandardA11', 'VMSizeTypesStandardA1V2', 'VMSizeTypesStandardA2', 'VMSizeTypesStandardA2V2', 'VMSizeTypesStandardA2mV2', 'VMSizeTypesStandardA3', 'VMSizeTypesStandardA4', 'VMSizeTypesStandardA4V2', 'VMSizeTypesStandardA4mV2', 'VMSizeTypesStandardA5', 'VMSizeTypesStandardA6', 'VMSizeTypesStandardA7', 'VMSizeTypesStandardA8', 'VMSizeTypesStandardA8V2', 'VMSizeTypesStandardA8mV2', 'VMSizeTypesStandardA9', 'VMSizeTypesStandardB2ms', 'VMSizeTypesStandardB2s', 'VMSizeTypesStandardB4ms', 'VMSizeTypesStandardB8ms', 'VMSizeTypesStandardD1', 'VMSizeTypesStandardD11', 'VMSizeTypesStandardD11V2', 'VMSizeTypesStandardD11V2Promo', 'VMSizeTypesStandardD12', 'VMSizeTypesStandardD12V2', 'VMSizeTypesStandardD12V2Promo', 'VMSizeTypesStandardD13', 'VMSizeTypesStandardD13V2', 'VMSizeTypesStandardD13V2Promo', 'VMSizeTypesStandardD14', 'VMSizeTypesStandardD14V2', 'VMSizeTypesStandardD14V2Promo', 'VMSizeTypesStandardD15V2', 'VMSizeTypesStandardD16V3', 'VMSizeTypesStandardD16sV3', 'VMSizeTypesStandardD1V2', 'VMSizeTypesStandardD2', 'VMSizeTypesStandardD2V2', 'VMSizeTypesStandardD2V2Promo', 'VMSizeTypesStandardD2V3', 'VMSizeTypesStandardD2sV3', 'VMSizeTypesStandardD3', 'VMSizeTypesStandardD32V3', 'VMSizeTypesStandardD32sV3', 'VMSizeTypesStandardD3V2', 'VMSizeTypesStandardD3V2Promo', 'VMSizeTypesStandardD4', 'VMSizeTypesStandardD4V2', 'VMSizeTypesStandardD4V2Promo', 'VMSizeTypesStandardD4V3', 'VMSizeTypesStandardD4sV3', 'VMSizeTypesStandardD5V2', 'VMSizeTypesStandardD5V2Promo', 'VMSizeTypesStandardD64V3', 'VMSizeTypesStandardD64sV3', 'VMSizeTypesStandardD8V3', 'VMSizeTypesStandardD8sV3', 'VMSizeTypesStandardDS1', 'VMSizeTypesStandardDS11', 'VMSizeTypesStandardDS11V2', 'VMSizeTypesStandardDS11V2Promo', 'VMSizeTypesStandardDS12', 'VMSizeTypesStandardDS12V2', 'VMSizeTypesStandardDS12V2Promo', 'VMSizeTypesStandardDS13', 'VMSizeTypesStandardDS132V2', 'VMSizeTypesStandardDS134V2', 'VMSizeTypesStandardDS13V2', 'VMSizeTypesStandardDS13V2Promo', 'VMSizeTypesStandardDS14', 'VMSizeTypesStandardDS144V2', 'VMSizeTypesStandardDS148V2', 'VMSizeTypesStandardDS14V2', 'VMSizeTypesStandardDS14V2Promo', 'VMSizeTypesStandardDS15V2', 'VMSizeTypesStandardDS1V2', 'VMSizeTypesStandardDS2', 'VMSizeTypesStandardDS2V2', 'VMSizeTypesStandardDS2V2Promo', 'VMSizeTypesStandardDS3', 'VMSizeTypesStandardDS3V2', 'VMSizeTypesStandardDS3V2Promo', 'VMSizeTypesStandardDS4', 'VMSizeTypesStandardDS4V2', 'VMSizeTypesStandardDS4V2Promo', 'VMSizeTypesStandardDS5V2', 'VMSizeTypesStandardDS5V2Promo', 'VMSizeTypesStandardE16V3', 'VMSizeTypesStandardE16sV3', 'VMSizeTypesStandardE2V3', 'VMSizeTypesStandardE2sV3', 'VMSizeTypesStandardE3216sV3', 'VMSizeTypesStandardE328sV3', 'VMSizeTypesStandardE32V3', 'VMSizeTypesStandardE32sV3', 'VMSizeTypesStandardE4V3', 'VMSizeTypesStandardE4sV3', 'VMSizeTypesStandardE6416sV3', 'VMSizeTypesStandardE6432sV3', 'VMSizeTypesStandardE64V3', 'VMSizeTypesStandardE64sV3', 'VMSizeTypesStandardE8V3', 'VMSizeTypesStandardE8sV3', 'VMSizeTypesStandardF1', 'VMSizeTypesStandardF16', 'VMSizeTypesStandardF16s', 'VMSizeTypesStandardF16sV2', 'VMSizeTypesStandardF1s', 'VMSizeTypesStandardF2', 'VMSizeTypesStandardF2s', 'VMSizeTypesStandardF2sV2', 'VMSizeTypesStandardF32sV2', 'VMSizeTypesStandardF4', 'VMSizeTypesStandardF4s', 'VMSizeTypesStandardF4sV2', 'VMSizeTypesStandardF64sV2', 'VMSizeTypesStandardF72sV2', 'VMSizeTypesStandardF8', 'VMSizeTypesStandardF8s', 'VMSizeTypesStandardF8sV2', 'VMSizeTypesStandardG1', 'VMSizeTypesStandardG2', 'VMSizeTypesStandardG3', 'VMSizeTypesStandardG4', 'VMSizeTypesStandardG5', 'VMSizeTypesStandardGS1', 'VMSizeTypesStandardGS2', 'VMSizeTypesStandardGS3', 'VMSizeTypesStandardGS4', 'VMSizeTypesStandardGS44', 'VMSizeTypesStandardGS48', 'VMSizeTypesStandardGS5', 'VMSizeTypesStandardGS516', 'VMSizeTypesStandardGS58', 'VMSizeTypesStandardH16', 'VMSizeTypesStandardH16m', 'VMSizeTypesStandardH16mr', 'VMSizeTypesStandardH16r', 'VMSizeTypesStandardH8', 'VMSizeTypesStandardH8m', 'VMSizeTypesStandardL16s', 'VMSizeTypesStandardL32s', 'VMSizeTypesStandardL4s', 'VMSizeTypesStandardL8s', 'VMSizeTypesStandardM12832ms', 'VMSizeTypesStandardM12864ms', 'VMSizeTypesStandardM128ms', 'VMSizeTypesStandardM128s', 'VMSizeTypesStandardM6416ms', 'VMSizeTypesStandardM6432ms', 'VMSizeTypesStandardM64ms', 'VMSizeTypesStandardM64s', 'VMSizeTypesStandardNC12', 'VMSizeTypesStandardNC12sV2', 'VMSizeTypesStandardNC12sV3', 'VMSizeTypesStandardNC24', 'VMSizeTypesStandardNC24r', 'VMSizeTypesStandardNC24rsV2', 'VMSizeTypesStandardNC24rsV3', 'VMSizeTypesStandardNC24sV2', 'VMSizeTypesStandardNC24sV3', 'VMSizeTypesStandardNC6', 'VMSizeTypesStandardNC6sV2', 'VMSizeTypesStandardNC6sV3', 'VMSizeTypesStandardND12s', 'VMSizeTypesStandardND24rs', 'VMSizeTypesStandardND24s', 'VMSizeTypesStandardND6s', 'VMSizeTypesStandardNV12', 'VMSizeTypesStandardNV24', 'VMSizeTypesStandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the vnet's subnet identifier.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// FirstConsecutiveStaticIP - FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageAccount', 'ManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// Fqdn - FDQN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
}

// NetworkProfile represents the OpenShift networking configuration
type NetworkProfile struct {
	// VnetCidr - CIDR for the OpenShift Vnet.
	VnetCidr *string `json:"vnetCidr,omitempty"`
	// PeerVnetID - CIDR of the Vnet to peer.
	PeerVnetID *string `json:"peerVnetId,omitempty"`
}

// NetworkProfileType profile of network configuration.
type NetworkProfileType struct {
	// NetworkPlugin - Network plugin used for building Kubernetes network. Possible values include: 'Azure', 'Kubenet'
	NetworkPlugin NetworkPlugin `json:"networkPlugin,omitempty"`
	// NetworkPolicy - Network policy used for building Kubernetes network. Possible values include: 'Calico'
	NetworkPolicy NetworkPolicy `json:"networkPolicy,omitempty"`
	// PodCidr - A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string `json:"podCidr,omitempty"`
	// ServiceCidr - A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
	// DNSServiceIP - An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
	DNSServiceIP *string `json:"dnsServiceIP,omitempty"`
	// DockerBridgeCidr - A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`
}

// OpenShiftManagedCluster openShift Managed cluster.
type OpenShiftManagedCluster struct {
	autorest.Response `json:"-"`
	// Plan - Define the resource plan as required by ARM for billing purposes
	Plan *PurchasePlan `json:"plan,omitempty"`
	// OpenShiftManagedClusterProperties - Properties of a openshift managed cluster.
	*OpenShiftManagedClusterProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for OpenShiftManagedCluster.
func (osmc OpenShiftManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osmc.Plan != nil {
		objectMap["plan"] = osmc.Plan
	}
	if osmc.OpenShiftManagedClusterProperties != nil {
		objectMap["properties"] = osmc.OpenShiftManagedClusterProperties
	}
	if osmc.ID != nil {
		objectMap["id"] = osmc.ID
	}
	if osmc.Name != nil {
		objectMap["name"] = osmc.Name
	}
	if osmc.Type != nil {
		objectMap["type"] = osmc.Type
	}
	if osmc.Location != nil {
		objectMap["location"] = osmc.Location
	}
	if osmc.Tags != nil {
		objectMap["tags"] = osmc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenShiftManagedCluster struct.
func (osmc *OpenShiftManagedCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "plan":
			if v != nil {
				var plan PurchasePlan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				osmc.Plan = &plan
			}
		case "properties":
			if v != nil {
				var openShiftManagedClusterProperties OpenShiftManagedClusterProperties
				err = json.Unmarshal(*v, &openShiftManagedClusterProperties)
				if err != nil {
					return err
				}
				osmc.OpenShiftManagedClusterProperties = &openShiftManagedClusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				osmc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				osmc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				osmc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				osmc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				osmc.Tags = tags
			}
		}
	}

	return nil
}

// OpenShiftManagedClusterAADIdentityProvider defines the Identity provider for MS AAD.
type OpenShiftManagedClusterAADIdentityProvider struct {
	// ClientID - The clientId password associated with the provider.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the provider.
	Secret *string `json:"secret,omitempty"`
	// TenantID - The tenantId associated with the provider.
	TenantID *string `json:"tenantId,omitempty"`
	// Kind - Possible values include: 'KindOpenShiftManagedClusterBaseIdentityProvider', 'KindAADIdentityProvider'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenShiftManagedClusterAADIdentityProvider.
func (osmcaip OpenShiftManagedClusterAADIdentityProvider) MarshalJSON() ([]byte, error) {
	osmcaip.Kind = KindAADIdentityProvider
	objectMap := make(map[string]interface{})
	if osmcaip.ClientID != nil {
		objectMap["clientId"] = osmcaip.ClientID
	}
	if osmcaip.Secret != nil {
		objectMap["secret"] = osmcaip.Secret
	}
	if osmcaip.TenantID != nil {
		objectMap["tenantId"] = osmcaip.TenantID
	}
	if osmcaip.Kind != "" {
		objectMap["kind"] = osmcaip.Kind
	}
	return json.Marshal(objectMap)
}

// AsOpenShiftManagedClusterAADIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterAADIdentityProvider.
func (osmcaip OpenShiftManagedClusterAADIdentityProvider) AsOpenShiftManagedClusterAADIdentityProvider() (*OpenShiftManagedClusterAADIdentityProvider, bool) {
	return &osmcaip, true
}

// AsOpenShiftManagedClusterBaseIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterAADIdentityProvider.
func (osmcaip OpenShiftManagedClusterAADIdentityProvider) AsOpenShiftManagedClusterBaseIdentityProvider() (*OpenShiftManagedClusterBaseIdentityProvider, bool) {
	return nil, false
}

// AsBasicOpenShiftManagedClusterBaseIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterAADIdentityProvider.
func (osmcaip OpenShiftManagedClusterAADIdentityProvider) AsBasicOpenShiftManagedClusterBaseIdentityProvider() (BasicOpenShiftManagedClusterBaseIdentityProvider, bool) {
	return &osmcaip, true
}

// OpenShiftManagedClusterAgentPoolProfile defines the configuration of the OpenShift cluster VMs.
type OpenShiftManagedClusterAgentPoolProfile struct {
	// Name - Unique name of the pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 5 (inclusive). The default value is 2.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'StandardD2sV3', 'StandardD4sV3'
	VMSize OpenShiftContainerServiceVMSize `json:"vmSize,omitempty"`
	// SubnetCidr - Subnet CIDR for the peering.
	SubnetCidr *string `json:"subnetCidr,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Role - Define the role of the AgentPoolProfile. Possible values include: 'Compute', 'Infra'
	Role OpenShiftAgentPoolProfileRole `json:"role,omitempty"`
}

// OpenShiftManagedClusterAuthProfile defines all possible authentication profiles for the OpenShift
// cluster.
type OpenShiftManagedClusterAuthProfile struct {
	// IdentityProviders - Type of authentication profile to use.
	IdentityProviders *[]OpenShiftManagedClusterIdentityProvider `json:"identityProviders,omitempty"`
}

// BasicOpenShiftManagedClusterBaseIdentityProvider structure for any Identity provider.
type BasicOpenShiftManagedClusterBaseIdentityProvider interface {
	AsOpenShiftManagedClusterAADIdentityProvider() (*OpenShiftManagedClusterAADIdentityProvider, bool)
	AsOpenShiftManagedClusterBaseIdentityProvider() (*OpenShiftManagedClusterBaseIdentityProvider, bool)
}

// OpenShiftManagedClusterBaseIdentityProvider structure for any Identity provider.
type OpenShiftManagedClusterBaseIdentityProvider struct {
	// Kind - Possible values include: 'KindOpenShiftManagedClusterBaseIdentityProvider', 'KindAADIdentityProvider'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicOpenShiftManagedClusterBaseIdentityProvider(body []byte) (BasicOpenShiftManagedClusterBaseIdentityProvider, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAADIdentityProvider):
		var osmcaip OpenShiftManagedClusterAADIdentityProvider
		err := json.Unmarshal(body, &osmcaip)
		return osmcaip, err
	default:
		var osmcbip OpenShiftManagedClusterBaseIdentityProvider
		err := json.Unmarshal(body, &osmcbip)
		return osmcbip, err
	}
}
func unmarshalBasicOpenShiftManagedClusterBaseIdentityProviderArray(body []byte) ([]BasicOpenShiftManagedClusterBaseIdentityProvider, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	osmcbipArray := make([]BasicOpenShiftManagedClusterBaseIdentityProvider, len(rawMessages))

	for index, rawMessage := range rawMessages {
		osmcbip, err := unmarshalBasicOpenShiftManagedClusterBaseIdentityProvider(*rawMessage)
		if err != nil {
			return nil, err
		}
		osmcbipArray[index] = osmcbip
	}
	return osmcbipArray, nil
}

// MarshalJSON is the custom marshaler for OpenShiftManagedClusterBaseIdentityProvider.
func (osmcbip OpenShiftManagedClusterBaseIdentityProvider) MarshalJSON() ([]byte, error) {
	osmcbip.Kind = KindOpenShiftManagedClusterBaseIdentityProvider
	objectMap := make(map[string]interface{})
	if osmcbip.Kind != "" {
		objectMap["kind"] = osmcbip.Kind
	}
	return json.Marshal(objectMap)
}

// AsOpenShiftManagedClusterAADIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterBaseIdentityProvider.
func (osmcbip OpenShiftManagedClusterBaseIdentityProvider) AsOpenShiftManagedClusterAADIdentityProvider() (*OpenShiftManagedClusterAADIdentityProvider, bool) {
	return nil, false
}

// AsOpenShiftManagedClusterBaseIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterBaseIdentityProvider.
func (osmcbip OpenShiftManagedClusterBaseIdentityProvider) AsOpenShiftManagedClusterBaseIdentityProvider() (*OpenShiftManagedClusterBaseIdentityProvider, bool) {
	return &osmcbip, true
}

// AsBasicOpenShiftManagedClusterBaseIdentityProvider is the BasicOpenShiftManagedClusterBaseIdentityProvider implementation for OpenShiftManagedClusterBaseIdentityProvider.
func (osmcbip OpenShiftManagedClusterBaseIdentityProvider) AsBasicOpenShiftManagedClusterBaseIdentityProvider() (BasicOpenShiftManagedClusterBaseIdentityProvider, bool) {
	return &osmcbip, true
}

// OpenShiftManagedClusterIdentityProvider defines the configuration of the identity providers to be used
// in the OpenShift cluster.
type OpenShiftManagedClusterIdentityProvider struct {
	// Name - Name of the provider.
	Name *string `json:"name,omitempty"`
	// Provider - Configuration of the provider.
	Provider BasicOpenShiftManagedClusterBaseIdentityProvider `json:"provider,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OpenShiftManagedClusterIdentityProvider struct.
func (osmcip *OpenShiftManagedClusterIdentityProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				osmcip.Name = &name
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicOpenShiftManagedClusterBaseIdentityProvider(*v)
				if err != nil {
					return err
				}
				osmcip.Provider = provider
			}
		}
	}

	return nil
}

// OpenShiftManagedClusterMasterPoolProfile openShiftManagedClusterMaterPoolProfile contains configuration
// for OpenShift master VMs.
type OpenShiftManagedClusterMasterPoolProfile struct {
	// Name - Unique name of the master pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of masters (VMs) to host docker containers. The default value is 3.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'StandardD2sV3', 'StandardD4sV3'
	VMSize OpenShiftContainerServiceVMSize `json:"vmSize,omitempty"`
	// SubnetCidr - Subnet CIDR for the peering.
	SubnetCidr *string `json:"subnetCidr,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
}

// OpenShiftManagedClusterProperties properties of the openshift managed cluster.
type OpenShiftManagedClusterProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OpenShiftVersion - Version of OpenShift specified when creating the cluster.
	OpenShiftVersion *string `json:"openShiftVersion,omitempty"`
	// PublicHostname - Optional user-specified FQDN for OpenShift API server.
	PublicHostname *string `json:"publicHostname,omitempty"`
	// Fqdn - User-specified FQDN for OpenShift API server loadbalancer internal hostname.
	Fqdn *string `json:"fqdn,omitempty"`
	// NetworkProfile - Configuration for OpenShift networking.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`
	// RouterProfiles - Configuration for OpenShift router(s).
	RouterProfiles *[]OpenShiftRouterProfile `json:"routerProfiles,omitempty"`
	// MasterPoolProfile - Configuration for OpenShift master VMs.
	MasterPoolProfile *OpenShiftManagedClusterMasterPoolProfile `json:"masterPoolProfile,omitempty"`
	// AgentPoolProfiles - Configuration of OpenShift cluster VMs.
	AgentPoolProfiles *[]OpenShiftManagedClusterAgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// AuthProfile - Configures OpenShift authentication.
	AuthProfile *OpenShiftManagedClusterAuthProfile `json:"authProfile,omitempty"`
}

// OpenShiftManagedClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type OpenShiftManagedClustersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OpenShiftManagedClustersCreateOrUpdateFuture) Result(client OpenShiftManagedClustersClient) (osmc OpenShiftManagedCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.OpenShiftManagedClustersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.OpenShiftManagedClustersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osmc.Response.Response, err = future.GetResult(sender); err == nil && osmc.Response.Response.StatusCode != http.StatusNoContent {
		osmc, err = client.CreateOrUpdateResponder(osmc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.OpenShiftManagedClustersCreateOrUpdateFuture", "Result", osmc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OpenShiftManagedClustersDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OpenShiftManagedClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OpenShiftManagedClustersDeleteFuture) Result(client OpenShiftManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.OpenShiftManagedClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.OpenShiftManagedClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OpenShiftManagedClustersUpdateTagsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OpenShiftManagedClustersUpdateTagsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OpenShiftManagedClustersUpdateTagsFuture) Result(client OpenShiftManagedClustersClient) (osmc OpenShiftManagedCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerservice.OpenShiftManagedClustersUpdateTagsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerservice.OpenShiftManagedClustersUpdateTagsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osmc.Response.Response, err = future.GetResult(sender); err == nil && osmc.Response.Response.StatusCode != http.StatusNoContent {
		osmc, err = client.UpdateTagsResponder(osmc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerservice.OpenShiftManagedClustersUpdateTagsFuture", "Result", osmc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OpenShiftRouterProfile represents an OpenShift router
type OpenShiftRouterProfile struct {
	// Name - Name of the router profile.
	Name *string `json:"name,omitempty"`
	// PublicSubdomain - DNS subdomain for openshift router.
	PublicSubdomain *string `json:"publicSubdomain,omitempty"`
	// Fqdn - Auto-allocated FQDN for the OpenShift router.
	Fqdn *string `json:"fqdn,omitempty"`
}

// OperationListResult the List Compute Operation operation response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of compute operations
	Value *[]OperationValue `json:"value,omitempty"`
}

// OperationValue describes the properties of a Compute Operation value.
type OperationValue struct {
	// Origin - The origin of the compute operation.
	Origin *string `json:"origin,omitempty"`
	// Name - The name of the compute operation.
	Name *string `json:"name,omitempty"`
	// OperationValueDisplay - Describes the properties of a Compute Operation Value Display.
	*OperationValueDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationValue.
func (ov OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ov.Origin != nil {
		objectMap["origin"] = ov.Origin
	}
	if ov.Name != nil {
		objectMap["name"] = ov.Name
	}
	if ov.OperationValueDisplay != nil {
		objectMap["display"] = ov.OperationValueDisplay
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationValue struct.
func (ov *OperationValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				ov.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ov.Name = &name
			}
		case "display":
			if v != nil {
				var operationValueDisplay OperationValueDisplay
				err = json.Unmarshal(*v, &operationValueDisplay)
				if err != nil {
					return err
				}
				ov.OperationValueDisplay = &operationValueDisplay
			}
		}
	}

	return nil
}

// OperationValueDisplay describes the properties of a Compute Operation Value Display.
type OperationValueDisplay struct {
	// Operation - The display name of the compute operation.
	Operation *string `json:"operation,omitempty"`
	// Resource - The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
	// Provider - The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
}

// OrchestratorProfile contains information about orchestrator.
type OrchestratorProfile struct {
	// OrchestratorType - Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty"`
	// OrchestratorVersion - Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
}

// OrchestratorProfileType profile for the container service orchestrator.
type OrchestratorProfileType struct {
	// OrchestratorType - The orchestrator to use to manage container service cluster resources. Valid values are Kubernetes, Swarm, DCOS, DockerCE and Custom. Possible values include: 'Kubernetes', 'Swarm', 'DCOS', 'DockerCE', 'Custom'
	OrchestratorType OrchestratorTypes `json:"orchestratorType,omitempty"`
	// OrchestratorVersion - The version of the orchestrator to use. You can specify the major.minor.patch part of the actual version.For example, you can specify version as "1.6.11".
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
}

// OrchestratorVersionProfile the profile of an orchestrator and its available versions.
type OrchestratorVersionProfile struct {
	// OrchestratorType - Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty"`
	// OrchestratorVersion - Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
	// Default - Installed by default if version is not specified.
	Default *bool `json:"default,omitempty"`
	// Upgrades - The list of available upgrade versions.
	Upgrades *[]OrchestratorProfile `json:"upgrades,omitempty"`
}

// OrchestratorVersionProfileListResult the list of versions for supported orchestrators.
type OrchestratorVersionProfileListResult struct {
	autorest.Response `json:"-"`
	// ID - Id of the orchestrator version profile list result.
	ID *string `json:"id,omitempty"`
	// Name - Name of the orchestrator version profile list result.
	Name *string `json:"name,omitempty"`
	// Type - Type of the orchestrator version profile list result.
	Type *string `json:"type,omitempty"`
	// OrchestratorVersionProfileProperties - The properties of an orchestrator version profile.
	*OrchestratorVersionProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OrchestratorVersionProfileListResult.
func (ovplr OrchestratorVersionProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ovplr.ID != nil {
		objectMap["id"] = ovplr.ID
	}
	if ovplr.Name != nil {
		objectMap["name"] = ovplr.Name
	}
	if ovplr.Type != nil {
		objectMap["type"] = ovplr.Type
	}
	if ovplr.OrchestratorVersionProfileProperties != nil {
		objectMap["properties"] = ovplr.OrchestratorVersionProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrchestratorVersionProfileListResult struct.
func (ovplr *OrchestratorVersionProfileListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ovplr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ovplr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ovplr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var orchestratorVersionProfileProperties OrchestratorVersionProfileProperties
				err = json.Unmarshal(*v, &orchestratorVersionProfileProperties)
				if err != nil {
					return err
				}
				ovplr.OrchestratorVersionProfileProperties = &orchestratorVersionProfileProperties
			}
		}
	}

	return nil
}

// OrchestratorVersionProfileProperties the properties of an orchestrator version profile.
type OrchestratorVersionProfileProperties struct {
	// Orchestrators - List of orchestrator version profiles.
	Orchestrators *[]OrchestratorVersionProfile `json:"orchestrators,omitempty"`
}

// Properties properties of the container service.
type Properties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OrchestratorProfile - Profile for the container service orchestrator.
	OrchestratorProfile *OrchestratorProfileType `json:"orchestratorProfile,omitempty"`
	// CustomProfile - Properties to configure a custom container service cluster.
	CustomProfile *CustomProfile `json:"customProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs. Exact one of secret or keyVaultSecretRef need to be specified.
	ServicePrincipalProfile *ServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	// MasterProfile - Profile for the container service master.
	MasterProfile *MasterProfile `json:"masterProfile,omitempty"`
	// AgentPoolProfiles - Properties of the agent pool.
	AgentPoolProfiles *[]AgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// WindowsProfile - Profile for Windows VMs in the container service cluster.
	WindowsProfile *WindowsProfile `json:"windowsProfile,omitempty"`
	// LinuxProfile - Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// DiagnosticsProfile - Profile for diagnostics in the container service cluster.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
}

// PurchasePlan used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
type PurchasePlan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Product - Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Publisher - The plan ID.
	Publisher *string `json:"publisher,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ServicePrincipalProfile information about a service principal identity for the cluster to use for
// manipulating Azure APIs. Either secret or keyVaultSecretRef must be specified.
type ServicePrincipalProfile struct {
	// ClientID - The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
	// KeyVaultSecretRef - Reference to a secret stored in Azure Key Vault.
	KeyVaultSecretRef *KeyVaultSecretRef `json:"keyVaultSecretRef,omitempty"`
}

// SSHConfiguration SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// TagsObject tags object for patch operations.
type TagsObject struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsObject.
func (toVar TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if toVar.Tags != nil {
		objectMap["tags"] = toVar.Tags
	}
	return json.Marshal(objectMap)
}

// VMDiagnostics profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// Enabled - Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageURI - The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty"`
}

// WindowsProfile profile for Windows VMs in the container service cluster.
type WindowsProfile struct {
	// AdminUsername - The administrator username to use for Windows VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - The administrator password to use for Windows VMs.
	AdminPassword *string `json:"adminPassword,omitempty"`
}
