package operationalinsightsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/operationalinsights/mgmt/2015-03-20/operationalinsights"
	"github.com/Azure/go-autorest/autorest"
)

// StorageInsightsClientAPI contains the set of methods on the StorageInsightsClient type.
type StorageInsightsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, workspaceName string, storageInsightName string, parameters operationalinsights.StorageInsight) (result operationalinsights.StorageInsight, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, storageInsightName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, storageInsightName string) (result operationalinsights.StorageInsight, err error)
	ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.StorageInsightListResultPage, err error)
}

var _ StorageInsightsClientAPI = (*operationalinsights.StorageInsightsClient)(nil)

// WorkspacesClientAPI contains the set of methods on the WorkspacesClient type.
type WorkspacesClientAPI interface {
	GetPurgeStatus(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.WorkspacePurgeStatusResponse, err error)
	GetSchema(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.SearchGetSchemaResponse, err error)
	GetSearchResults(ctx context.Context, resourceGroupName string, workspaceName string, parameters operationalinsights.SearchParameters) (result operationalinsights.WorkspacesGetSearchResultsFuture, err error)
	ListKeys(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.SharedKeys, err error)
	ListLinkTargets(ctx context.Context) (result operationalinsights.ListLinkTarget, err error)
	Purge(ctx context.Context, resourceGroupName string, workspaceName string, body operationalinsights.WorkspacePurgeBody) (result operationalinsights.WorkspacePurgeResponse, err error)
	RegenerateSharedKeys(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.SharedKeys, err error)
	UpdateSearchResults(ctx context.Context, resourceGroupName string, workspaceName string, ID string) (result operationalinsights.SearchResultsResponse, err error)
}

var _ WorkspacesClientAPI = (*operationalinsights.WorkspacesClient)(nil)

// SavedSearchesClientAPI contains the set of methods on the SavedSearchesClient type.
type SavedSearchesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, workspaceName string, savedSearchID string, parameters operationalinsights.SavedSearch) (result operationalinsights.SavedSearch, err error)
	Delete(ctx context.Context, resourceGroupName string, workspaceName string, savedSearchID string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, workspaceName string, savedSearchID string) (result operationalinsights.SavedSearch, err error)
	GetResults(ctx context.Context, resourceGroupName string, workspaceName string, savedSearchID string) (result operationalinsights.SearchResultsResponse, err error)
	ListByWorkspace(ctx context.Context, resourceGroupName string, workspaceName string) (result operationalinsights.SavedSearchesListResult, err error)
}

var _ SavedSearchesClientAPI = (*operationalinsights.SavedSearchesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result operationalinsights.OperationListResult, err error)
}

var _ OperationsClientAPI = (*operationalinsights.OperationsClient)(nil)
