package databox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/databox/mgmt/2018-01-01/databox"

// AccessProtocol enumerates the values for access protocol.
type AccessProtocol string

const (
	// NFS Network File System protocol(NFS).
	NFS AccessProtocol = "NFS"
	// SMB Server Message Block protocol(SMB).
	SMB AccessProtocol = "SMB"
)

// PossibleAccessProtocolValues returns an array of possible values for the AccessProtocol const type.
func PossibleAccessProtocolValues() []AccessProtocol {
	return []AccessProtocol{NFS, SMB}
}

// AddressType enumerates the values for address type.
type AddressType string

const (
	// Commercial Commercial Address.
	Commercial AddressType = "Commercial"
	// None Address type not known.
	None AddressType = "None"
	// Residential Residential Address.
	Residential AddressType = "Residential"
)

// PossibleAddressTypeValues returns an array of possible values for the AddressType const type.
func PossibleAddressTypeValues() []AddressType {
	return []AddressType{Commercial, None, Residential}
}

// AddressValidationStatus enumerates the values for address validation status.
type AddressValidationStatus string

const (
	// Ambiguous Address provided is ambiguous, please choose one of the alternate addresses returned.
	Ambiguous AddressValidationStatus = "Ambiguous"
	// Invalid Address provided is invalid or not supported.
	Invalid AddressValidationStatus = "Invalid"
	// Valid Address provided is valid.
	Valid AddressValidationStatus = "Valid"
)

// PossibleAddressValidationStatusValues returns an array of possible values for the AddressValidationStatus const type.
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return []AddressValidationStatus{Ambiguous, Invalid, Valid}
}

// CopyLogDetailsType enumerates the values for copy log details type.
type CopyLogDetailsType string

const (
	// CopyLogDetailsTypeCopyLogDetails ...
	CopyLogDetailsTypeCopyLogDetails CopyLogDetailsType = "CopyLogDetails"
	// CopyLogDetailsTypeDataBox ...
	CopyLogDetailsTypeDataBox CopyLogDetailsType = "DataBox"
	// CopyLogDetailsTypeDataBoxDisk ...
	CopyLogDetailsTypeDataBoxDisk CopyLogDetailsType = "DataBoxDisk"
	// CopyLogDetailsTypeDataBoxHeavy ...
	CopyLogDetailsTypeDataBoxHeavy CopyLogDetailsType = "DataBoxHeavy"
)

// PossibleCopyLogDetailsTypeValues returns an array of possible values for the CopyLogDetailsType const type.
func PossibleCopyLogDetailsTypeValues() []CopyLogDetailsType {
	return []CopyLogDetailsType{CopyLogDetailsTypeCopyLogDetails, CopyLogDetailsTypeDataBox, CopyLogDetailsTypeDataBoxDisk, CopyLogDetailsTypeDataBoxHeavy}
}

// CopyStatus enumerates the values for copy status.
type CopyStatus string

const (
	// Completed Data copy completed.
	Completed CopyStatus = "Completed"
	// CompletedWithErrors Data copy completed with errors.
	CompletedWithErrors CopyStatus = "CompletedWithErrors"
	// Failed Data copy failed. No data was copied.
	Failed CopyStatus = "Failed"
	// InProgress Data copy is in progress.
	InProgress CopyStatus = "InProgress"
	// NotReturned No copy triggered as device was not returned.
	NotReturned CopyStatus = "NotReturned"
	// NotStarted Data copy hasnt started yet.
	NotStarted CopyStatus = "NotStarted"
)

// PossibleCopyStatusValues returns an array of possible values for the CopyStatus const type.
func PossibleCopyStatusValues() []CopyStatus {
	return []CopyStatus{Completed, CompletedWithErrors, Failed, InProgress, NotReturned, NotStarted}
}

// DataDestinationType enumerates the values for data destination type.
type DataDestinationType string

const (
	// DataDestinationTypeDestinationAccountDetails ...
	DataDestinationTypeDestinationAccountDetails DataDestinationType = "DestinationAccountDetails"
	// DataDestinationTypeManagedDisk ...
	DataDestinationTypeManagedDisk DataDestinationType = "ManagedDisk"
	// DataDestinationTypeStorageAccount ...
	DataDestinationTypeStorageAccount DataDestinationType = "StorageAccount"
)

// PossibleDataDestinationTypeValues returns an array of possible values for the DataDestinationType const type.
func PossibleDataDestinationTypeValues() []DataDestinationType {
	return []DataDestinationType{DataDestinationTypeDestinationAccountDetails, DataDestinationTypeManagedDisk, DataDestinationTypeStorageAccount}
}

// JobDetailsTypeEnum enumerates the values for job details type enum.
type JobDetailsTypeEnum string

const (
	// JobDetailsTypeDataBox ...
	JobDetailsTypeDataBox JobDetailsTypeEnum = "DataBox"
	// JobDetailsTypeDataBoxDisk ...
	JobDetailsTypeDataBoxDisk JobDetailsTypeEnum = "DataBoxDisk"
	// JobDetailsTypeDataBoxHeavy ...
	JobDetailsTypeDataBoxHeavy JobDetailsTypeEnum = "DataBoxHeavy"
	// JobDetailsTypeJobDetails ...
	JobDetailsTypeJobDetails JobDetailsTypeEnum = "JobDetails"
)

// PossibleJobDetailsTypeEnumValues returns an array of possible values for the JobDetailsTypeEnum const type.
func PossibleJobDetailsTypeEnumValues() []JobDetailsTypeEnum {
	return []JobDetailsTypeEnum{JobDetailsTypeDataBox, JobDetailsTypeDataBoxDisk, JobDetailsTypeDataBoxHeavy, JobDetailsTypeJobDetails}
}

// JobSecretsTypeEnum enumerates the values for job secrets type enum.
type JobSecretsTypeEnum string

const (
	// JobSecretsTypeDataBox ...
	JobSecretsTypeDataBox JobSecretsTypeEnum = "DataBox"
	// JobSecretsTypeDataBoxDisk ...
	JobSecretsTypeDataBoxDisk JobSecretsTypeEnum = "DataBoxDisk"
	// JobSecretsTypeDataBoxHeavy ...
	JobSecretsTypeDataBoxHeavy JobSecretsTypeEnum = "DataBoxHeavy"
	// JobSecretsTypeJobSecrets ...
	JobSecretsTypeJobSecrets JobSecretsTypeEnum = "JobSecrets"
)

// PossibleJobSecretsTypeEnumValues returns an array of possible values for the JobSecretsTypeEnum const type.
func PossibleJobSecretsTypeEnumValues() []JobSecretsTypeEnum {
	return []JobSecretsTypeEnum{JobSecretsTypeDataBox, JobSecretsTypeDataBoxDisk, JobSecretsTypeDataBoxHeavy, JobSecretsTypeJobSecrets}
}

// NotificationStageName enumerates the values for notification stage name.
type NotificationStageName string

const (
	// AtAzureDC Notification at device received at azure datacenter stage.
	AtAzureDC NotificationStageName = "AtAzureDC"
	// DataCopy Notification at data copy started stage.
	DataCopy NotificationStageName = "DataCopy"
	// Delivered Notification at device delivered stage.
	Delivered NotificationStageName = "Delivered"
	// DevicePrepared Notification at device prepared stage.
	DevicePrepared NotificationStageName = "DevicePrepared"
	// Dispatched Notification at device dispatched stage.
	Dispatched NotificationStageName = "Dispatched"
	// PickedUp Notification at device picked up from user stage.
	PickedUp NotificationStageName = "PickedUp"
)

// PossibleNotificationStageNameValues returns an array of possible values for the NotificationStageName const type.
func PossibleNotificationStageNameValues() []NotificationStageName {
	return []NotificationStageName{AtAzureDC, DataCopy, Delivered, DevicePrepared, Dispatched, PickedUp}
}

// ShareDestinationFormatType enumerates the values for share destination format type.
type ShareDestinationFormatType string

const (
	// AzureFile Azure storage file format.
	AzureFile ShareDestinationFormatType = "AzureFile"
	// BlockBlob Azure storage block blob format.
	BlockBlob ShareDestinationFormatType = "BlockBlob"
	// HCS Storsimple data format.
	HCS ShareDestinationFormatType = "HCS"
	// ManagedDisk Azure Compute Disk.
	ManagedDisk ShareDestinationFormatType = "ManagedDisk"
	// PageBlob Azure storage page blob format.
	PageBlob ShareDestinationFormatType = "PageBlob"
	// UnknownType Unknown format.
	UnknownType ShareDestinationFormatType = "UnknownType"
)

// PossibleShareDestinationFormatTypeValues returns an array of possible values for the ShareDestinationFormatType const type.
func PossibleShareDestinationFormatTypeValues() []ShareDestinationFormatType {
	return []ShareDestinationFormatType{AzureFile, BlockBlob, HCS, ManagedDisk, PageBlob, UnknownType}
}

// SkuDisabledReason enumerates the values for sku disabled reason.
type SkuDisabledReason string

const (
	// SkuDisabledReasonCountry SKU is not available in the requested country.
	SkuDisabledReasonCountry SkuDisabledReason = "Country"
	// SkuDisabledReasonFeature Required features are not enabled for the SKU.
	SkuDisabledReasonFeature SkuDisabledReason = "Feature"
	// SkuDisabledReasonNone SKU is not disabled.
	SkuDisabledReasonNone SkuDisabledReason = "None"
	// SkuDisabledReasonNoSubscriptionInfo Subscription has not registered to Microsoft.DataBox and Service
	// does not have the subscription notification.
	SkuDisabledReasonNoSubscriptionInfo SkuDisabledReason = "NoSubscriptionInfo"
	// SkuDisabledReasonOfferType Subscription does not have required offer types for the SKU.
	SkuDisabledReasonOfferType SkuDisabledReason = "OfferType"
	// SkuDisabledReasonRegion SKU is not available to push data to the requested Azure region.
	SkuDisabledReasonRegion SkuDisabledReason = "Region"
)

// PossibleSkuDisabledReasonValues returns an array of possible values for the SkuDisabledReason const type.
func PossibleSkuDisabledReasonValues() []SkuDisabledReason {
	return []SkuDisabledReason{SkuDisabledReasonCountry, SkuDisabledReasonFeature, SkuDisabledReasonNone, SkuDisabledReasonNoSubscriptionInfo, SkuDisabledReasonOfferType, SkuDisabledReasonRegion}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// DataBox Databox.
	DataBox SkuName = "DataBox"
	// DataBoxDisk DataboxDisk.
	DataBoxDisk SkuName = "DataBoxDisk"
	// DataBoxHeavy DataboxHeavy.
	DataBoxHeavy SkuName = "DataBoxHeavy"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{DataBox, DataBoxDisk, DataBoxHeavy}
}

// StageName enumerates the values for stage name.
type StageName string

const (
	// StageNameAborted Order has been aborted.
	StageNameAborted StageName = "Aborted"
	// StageNameAtAzureDC Device has been received at azure datacenter from the user.
	StageNameAtAzureDC StageName = "AtAzureDC"
	// StageNameCancelled Order has been cancelled.
	StageNameCancelled StageName = "Cancelled"
	// StageNameCompleted Order has completed.
	StageNameCompleted StageName = "Completed"
	// StageNameCompletedWithErrors Order has completed with errors.
	StageNameCompletedWithErrors StageName = "CompletedWithErrors"
	// StageNameDataCopy Data copy from the device at azure datacenter.
	StageNameDataCopy StageName = "DataCopy"
	// StageNameDelivered Device has been delivered to the user of the order.
	StageNameDelivered StageName = "Delivered"
	// StageNameDeviceOrdered An order has been created.
	StageNameDeviceOrdered StageName = "DeviceOrdered"
	// StageNameDevicePrepared A device has been prepared for the order.
	StageNameDevicePrepared StageName = "DevicePrepared"
	// StageNameDispatched Device has been dispatched to the user of the order.
	StageNameDispatched StageName = "Dispatched"
	// StageNameFailedIssueDetectedAtAzureDC Order has failed due to issue detected at azure datacenter.
	StageNameFailedIssueDetectedAtAzureDC StageName = "Failed_IssueDetectedAtAzureDC"
	// StageNameFailedIssueReportedAtCustomer Order has failed due to issue reported by user.
	StageNameFailedIssueReportedAtCustomer StageName = "Failed_IssueReportedAtCustomer"
	// StageNamePickedUp Device has been picked up from user and in transit to azure datacenter.
	StageNamePickedUp StageName = "PickedUp"
)

// PossibleStageNameValues returns an array of possible values for the StageName const type.
func PossibleStageNameValues() []StageName {
	return []StageName{StageNameAborted, StageNameAtAzureDC, StageNameCancelled, StageNameCompleted, StageNameCompletedWithErrors, StageNameDataCopy, StageNameDelivered, StageNameDeviceOrdered, StageNameDevicePrepared, StageNameDispatched, StageNameFailedIssueDetectedAtAzureDC, StageNameFailedIssueReportedAtCustomer, StageNamePickedUp}
}

// StageStatus enumerates the values for stage status.
type StageStatus string

const (
	// StageStatusCancelled Stage has been cancelled.
	StageStatusCancelled StageStatus = "Cancelled"
	// StageStatusCancelling Stage is cancelling.
	StageStatusCancelling StageStatus = "Cancelling"
	// StageStatusFailed Stage has failed.
	StageStatusFailed StageStatus = "Failed"
	// StageStatusInProgress Stage is in progress.
	StageStatusInProgress StageStatus = "InProgress"
	// StageStatusNone No status available yet.
	StageStatusNone StageStatus = "None"
	// StageStatusSucceeded Stage has succeeded.
	StageStatusSucceeded StageStatus = "Succeeded"
	// StageStatusSucceededWithErrors Stage has succeeded with errors.
	StageStatusSucceededWithErrors StageStatus = "SucceededWithErrors"
)

// PossibleStageStatusValues returns an array of possible values for the StageStatus const type.
func PossibleStageStatusValues() []StageStatus {
	return []StageStatus{StageStatusCancelled, StageStatusCancelling, StageStatusFailed, StageStatusInProgress, StageStatusNone, StageStatusSucceeded, StageStatusSucceededWithErrors}
}

// AccountCopyLogDetails copy log details for a storage account of a DataBox job
type AccountCopyLogDetails struct {
	// AccountName - Destination account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - Link for copy logs.
	CopyLogLink *string `json:"copyLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	acld.CopyLogDetailsType = CopyLogDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if acld.AccountName != nil {
		objectMap["accountName"] = acld.AccountName
	}
	if acld.CopyLogLink != nil {
		objectMap["copyLogLink"] = acld.CopyLogLink
	}
	if acld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = acld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return &acld, true
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &acld, true
}

// AccountCredentialDetails credential details of the account.
type AccountCredentialDetails struct {
	// AccountName - Name of the account.
	AccountName *string `json:"accountName,omitempty"`
	// AccountConnectionString - Connection string of the account endpoint to use the account as a storage endpoint on the device.
	AccountConnectionString *string `json:"accountConnectionString,omitempty"`
	// ShareCredentialDetails - Per share level unencrypted access credentials.
	ShareCredentialDetails *[]ShareCredentialDetails `json:"shareCredentialDetails,omitempty"`
}

// AddressValidationOutput output of the address validation api.
type AddressValidationOutput struct {
	autorest.Response `json:"-"`
	// AddressValidationProperties - The address validation properties.
	*AddressValidationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationOutput.
func (avo AddressValidationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if avo.AddressValidationProperties != nil {
		objectMap["properties"] = avo.AddressValidationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressValidationOutput struct.
func (avo *AddressValidationOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressValidationProperties AddressValidationProperties
				err = json.Unmarshal(*v, &addressValidationProperties)
				if err != nil {
					return err
				}
				avo.AddressValidationProperties = &addressValidationProperties
			}
		}
	}

	return nil
}

// AddressValidationProperties the address validation output.
type AddressValidationProperties struct {
	// ValidationStatus - The address validation status. Possible values include: 'Valid', 'Invalid', 'Ambiguous'
	ValidationStatus AddressValidationStatus `json:"validationStatus,omitempty"`
	// AlternateAddresses - List of alternate addresses.
	AlternateAddresses *[]ShippingAddress `json:"alternateAddresses,omitempty"`
}

// ApplianceNetworkConfiguration the Network Adapter configuration of a DataBox.
type ApplianceNetworkConfiguration struct {
	// Name - Name of the network.
	Name *string `json:"name,omitempty"`
	// MacAddress - Mac Address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ArmBaseObject base class for all objects under resource.
type ArmBaseObject struct {
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - Type of the object.
	Type *string `json:"type,omitempty"`
}

// AvailableSkuRequest the filters for showing the available skus.
type AvailableSkuRequest struct {
	// TransferType - Type of the transfer.
	TransferType *string `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
	// SkuNames - Sku Names to filter for available skus
	SkuNames *[]SkuName `json:"skuNames,omitempty"`
}

// AvailableSkusResult the available skus operation response.
type AvailableSkusResult struct {
	autorest.Response `json:"-"`
	// Value - List of available skus.
	Value *[]SkuInformation `json:"value,omitempty"`
	// NextLink - Link for the next set of skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableSkusResultIterator provides access to a complete listing of SkuInformation values.
type AvailableSkusResultIterator struct {
	i    int
	page AvailableSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableSkusResultIterator) Response() AvailableSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableSkusResultIterator) Value() SkuInformation {
	if !iter.page.NotDone() {
		return SkuInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableSkusResultIterator type.
func NewAvailableSkusResultIterator(page AvailableSkusResultPage) AvailableSkusResultIterator {
	return AvailableSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asr AvailableSkusResult) IsEmpty() bool {
	return asr.Value == nil || len(*asr.Value) == 0
}

// availableSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asr AvailableSkusResult) availableSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if asr.NextLink == nil || len(to.String(asr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asr.NextLink)))
}

// AvailableSkusResultPage contains a page of SkuInformation values.
type AvailableSkusResultPage struct {
	fn  func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)
	asr AvailableSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asr)
	if err != nil {
		return err
	}
	page.asr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableSkusResultPage) NotDone() bool {
	return !page.asr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableSkusResultPage) Response() AvailableSkusResult {
	return page.asr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableSkusResultPage) Values() []SkuInformation {
	if page.asr.IsEmpty() {
		return nil
	}
	return *page.asr.Value
}

// Creates a new instance of the AvailableSkusResultPage type.
func NewAvailableSkusResultPage(getNextPage func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)) AvailableSkusResultPage {
	return AvailableSkusResultPage{fn: getNextPage}
}

// CancellationReason reason for cancellation.
type CancellationReason struct {
	// Reason - Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// ContactDetails contact Details.
type ContactDetails struct {
	// ContactName - Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`
	// Phone - Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`
	// PhoneExtension - Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
	// Mobile - Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`
	// EmailList - List of Email-ids to be notified about job progress.
	EmailList *[]string `json:"emailList,omitempty"`
	// NotificationPreference - Notification preference for a job stage.
	NotificationPreference *[]NotificationPreference `json:"notificationPreference,omitempty"`
}

// BasicCopyLogDetails details for log generated during copy.
type BasicCopyLogDetails interface {
	AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool)
	AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool)
	AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool)
	AsCopyLogDetails() (*CopyLogDetails, bool)
}

// CopyLogDetails details for log generated during copy.
type CopyLogDetails struct {
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

func unmarshalBasicCopyLogDetails(body []byte) (BasicCopyLogDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["copyLogDetailsType"] {
	case string(CopyLogDetailsTypeDataBox):
		var acld AccountCopyLogDetails
		err := json.Unmarshal(body, &acld)
		return acld, err
	case string(CopyLogDetailsTypeDataBoxDisk):
		var dcld DiskCopyLogDetails
		err := json.Unmarshal(body, &dcld)
		return dcld, err
	case string(CopyLogDetailsTypeDataBoxHeavy):
		var hacld HeavyAccountCopyLogDetails
		err := json.Unmarshal(body, &hacld)
		return hacld, err
	default:
		var cld CopyLogDetails
		err := json.Unmarshal(body, &cld)
		return cld, err
	}
}
func unmarshalBasicCopyLogDetailsArray(body []byte) ([]BasicCopyLogDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cldArray := make([]BasicCopyLogDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cld, err := unmarshalBasicCopyLogDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		cldArray[index] = cld
	}
	return cldArray, nil
}

// MarshalJSON is the custom marshaler for CopyLogDetails.
func (cld CopyLogDetails) MarshalJSON() ([]byte, error) {
	cld.CopyLogDetailsType = CopyLogDetailsTypeCopyLogDetails
	objectMap := make(map[string]interface{})
	if cld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = cld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return &cld, true
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &cld, true
}

// CopyProgress copy progress.
type CopyProgress struct {
	// StorageAccountName - Name of the storage account where the data needs to be uploaded.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// AccountID - Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty"`
	// BytesSentToCloud - Amount of data uploaded by the job as of now.
	BytesSentToCloud *int64 `json:"bytesSentToCloud,omitempty"`
	// TotalBytesToProcess - Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty"`
	// FilesProcessed - Number of files processed by the job as of now.
	FilesProcessed *int64 `json:"filesProcessed,omitempty"`
	// TotalFilesToProcess - Total number of files to be processed by the job.
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty"`
}

// BasicDestinationAccountDetails details of the destination of the data
type BasicDestinationAccountDetails interface {
	AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool)
	AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool)
	AsDestinationAccountDetails() (*DestinationAccountDetails, bool)
}

// DestinationAccountDetails details of the destination of the data
type DestinationAccountDetails struct {
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationType `json:"dataDestinationType,omitempty"`
}

func unmarshalBasicDestinationAccountDetails(body []byte) (BasicDestinationAccountDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["dataDestinationType"] {
	case string(DataDestinationTypeManagedDisk):
		var dmdd DestinationManagedDiskDetails
		err := json.Unmarshal(body, &dmdd)
		return dmdd, err
	case string(DataDestinationTypeStorageAccount):
		var dsad DestinationStorageAccountDetails
		err := json.Unmarshal(body, &dsad)
		return dsad, err
	default:
		var dad DestinationAccountDetails
		err := json.Unmarshal(body, &dad)
		return dad, err
	}
}
func unmarshalBasicDestinationAccountDetailsArray(body []byte) ([]BasicDestinationAccountDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dadArray := make([]BasicDestinationAccountDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dad, err := unmarshalBasicDestinationAccountDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		dadArray[index] = dad
	}
	return dadArray, nil
}

// MarshalJSON is the custom marshaler for DestinationAccountDetails.
func (dad DestinationAccountDetails) MarshalJSON() ([]byte, error) {
	dad.DataDestinationType = DataDestinationTypeDestinationAccountDetails
	objectMap := make(map[string]interface{})
	if dad.AccountID != nil {
		objectMap["accountId"] = dad.AccountID
	}
	if dad.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dad.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return nil, false
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return nil, false
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return &dad, true
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationAccountDetails.
func (dad DestinationAccountDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dad, true
}

// DestinationManagedDiskDetails details for the destination compute disks.
type DestinationManagedDiskDetails struct {
	// ResourceGroupID - Destination Resource Group Id where the Compute disks should be created.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// StagingStorageAccountID - Arm Id of the storage account that can be used to copy the vhd for staging.
	StagingStorageAccountID *string `json:"stagingStorageAccountId,omitempty"`
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationType `json:"dataDestinationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) MarshalJSON() ([]byte, error) {
	dmdd.DataDestinationType = DataDestinationTypeManagedDisk
	objectMap := make(map[string]interface{})
	if dmdd.ResourceGroupID != nil {
		objectMap["resourceGroupId"] = dmdd.ResourceGroupID
	}
	if dmdd.StagingStorageAccountID != nil {
		objectMap["stagingStorageAccountId"] = dmdd.StagingStorageAccountID
	}
	if dmdd.AccountID != nil {
		objectMap["accountId"] = dmdd.AccountID
	}
	if dmdd.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dmdd.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return &dmdd, true
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return nil, false
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return nil, false
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationManagedDiskDetails.
func (dmdd DestinationManagedDiskDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dmdd, true
}

// DestinationStorageAccountDetails details for the destination storage account.
type DestinationStorageAccountDetails struct {
	// StorageAccountID - Destination Storage Account Arm Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// AccountID - Arm Id of the destination where the data has to be moved.
	AccountID *string `json:"accountId,omitempty"`
	// DataDestinationType - Possible values include: 'DataDestinationTypeDestinationAccountDetails', 'DataDestinationTypeManagedDisk', 'DataDestinationTypeStorageAccount'
	DataDestinationType DataDestinationType `json:"dataDestinationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) MarshalJSON() ([]byte, error) {
	dsad.DataDestinationType = DataDestinationTypeStorageAccount
	objectMap := make(map[string]interface{})
	if dsad.StorageAccountID != nil {
		objectMap["storageAccountId"] = dsad.StorageAccountID
	}
	if dsad.AccountID != nil {
		objectMap["accountId"] = dsad.AccountID
	}
	if dsad.DataDestinationType != "" {
		objectMap["dataDestinationType"] = dsad.DataDestinationType
	}
	return json.Marshal(objectMap)
}

// AsDestinationManagedDiskDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationManagedDiskDetails() (*DestinationManagedDiskDetails, bool) {
	return nil, false
}

// AsDestinationStorageAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationStorageAccountDetails() (*DestinationStorageAccountDetails, bool) {
	return &dsad, true
}

// AsDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsDestinationAccountDetails() (*DestinationAccountDetails, bool) {
	return nil, false
}

// AsBasicDestinationAccountDetails is the BasicDestinationAccountDetails implementation for DestinationStorageAccountDetails.
func (dsad DestinationStorageAccountDetails) AsBasicDestinationAccountDetails() (BasicDestinationAccountDetails, bool) {
	return &dsad, true
}

// DestinationToServiceLocationMap map of destination location to service location
type DestinationToServiceLocationMap struct {
	// DestinationLocation - Location of the destination.
	DestinationLocation *string `json:"destinationLocation,omitempty"`
	// ServiceLocation - Location of the service.
	ServiceLocation *string `json:"serviceLocation,omitempty"`
}

// DiskCopyLogDetails copy Log Details for a disk
type DiskCopyLogDetails struct {
	// DiskSerialNumber - Disk Serial Number.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// ErrorLogLink - Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty"`
	// VerboseLogLink - Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	dcld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if dcld.DiskSerialNumber != nil {
		objectMap["diskSerialNumber"] = dcld.DiskSerialNumber
	}
	if dcld.ErrorLogLink != nil {
		objectMap["errorLogLink"] = dcld.ErrorLogLink
	}
	if dcld.VerboseLogLink != nil {
		objectMap["verboseLogLink"] = dcld.VerboseLogLink
	}
	if dcld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = dcld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return &dcld, true
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &dcld, true
}

// DiskCopyProgress dataBox Disk Copy Progress
type DiskCopyProgress struct {
	// SerialNumber - The serial number of the disk
	SerialNumber *string `json:"serialNumber,omitempty"`
	// BytesCopied - Bytes copied during the copy of disk.
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// PercentComplete - Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Status - The Status of the copy. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'CompletedWithErrors', 'Failed', 'NotReturned'
	Status CopyStatus `json:"status,omitempty"`
}

// DiskJobDetails dataBox Disk Job Details.
type DiskJobDetails struct {
	// PreferredDisks - User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32 `json:"preferredDisks"`
	// CopyProgress - Copy progress per disk.
	CopyProgress *[]DiskCopyProgress `json:"copyProgress,omitempty"`
	// DisksAndSizeDetails - Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks are shipped to the customer.
	DisksAndSizeDetails map[string]*int32 `json:"disksAndSizeDetails"`
	// Passkey - User entered passkey for DataBox Disk job.
	Passkey *string `json:"passkey,omitempty"`
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobDetails.
func (djd DiskJobDetails) MarshalJSON() ([]byte, error) {
	djd.JobDetailsType = JobDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djd.PreferredDisks != nil {
		objectMap["preferredDisks"] = djd.PreferredDisks
	}
	if djd.CopyProgress != nil {
		objectMap["copyProgress"] = djd.CopyProgress
	}
	if djd.DisksAndSizeDetails != nil {
		objectMap["disksAndSizeDetails"] = djd.DisksAndSizeDetails
	}
	if djd.Passkey != nil {
		objectMap["passkey"] = djd.Passkey
	}
	if djd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = djd.ExpectedDataSizeInTeraBytes
	}
	if djd.JobStages != nil {
		objectMap["jobStages"] = djd.JobStages
	}
	if djd.ContactDetails != nil {
		objectMap["contactDetails"] = djd.ContactDetails
	}
	if djd.ShippingAddress != nil {
		objectMap["shippingAddress"] = djd.ShippingAddress
	}
	if djd.DeliveryPackage != nil {
		objectMap["deliveryPackage"] = djd.DeliveryPackage
	}
	if djd.ReturnPackage != nil {
		objectMap["returnPackage"] = djd.ReturnPackage
	}
	if djd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = djd.DestinationAccountDetails
	}
	if djd.ErrorDetails != nil {
		objectMap["errorDetails"] = djd.ErrorDetails
	}
	if djd.Preferences != nil {
		objectMap["preferences"] = djd.Preferences
	}
	if djd.CopyLogDetails != nil {
		objectMap["copyLogDetails"] = djd.CopyLogDetails
	}
	if djd.ReverseShipmentLabelSasKey != nil {
		objectMap["reverseShipmentLabelSasKey"] = djd.ReverseShipmentLabelSasKey
	}
	if djd.ChainOfCustodySasKey != nil {
		objectMap["chainOfCustodySasKey"] = djd.ChainOfCustodySasKey
	}
	if djd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = djd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return &djd, true
}

// AsHeavyJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &djd, true
}

// UnmarshalJSON is the custom unmarshaler for DiskJobDetails struct.
func (djd *DiskJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "preferredDisks":
			if v != nil {
				var preferredDisks map[string]*int32
				err = json.Unmarshal(*v, &preferredDisks)
				if err != nil {
					return err
				}
				djd.PreferredDisks = preferredDisks
			}
		case "copyProgress":
			if v != nil {
				var copyProgress []DiskCopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				djd.CopyProgress = &copyProgress
			}
		case "disksAndSizeDetails":
			if v != nil {
				var disksAndSizeDetails map[string]*int32
				err = json.Unmarshal(*v, &disksAndSizeDetails)
				if err != nil {
					return err
				}
				djd.DisksAndSizeDetails = disksAndSizeDetails
			}
		case "passkey":
			if v != nil {
				var passkey string
				err = json.Unmarshal(*v, &passkey)
				if err != nil {
					return err
				}
				djd.Passkey = &passkey
			}
		case "expectedDataSizeInTeraBytes":
			if v != nil {
				var expectedDataSizeInTeraBytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTeraBytes)
				if err != nil {
					return err
				}
				djd.ExpectedDataSizeInTeraBytes = &expectedDataSizeInTeraBytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				djd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				djd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				djd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				djd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				djd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				djd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				djd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				djd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				djd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				djd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				djd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				djd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// DiskJobSecrets the secrets related to disk job.
type DiskJobSecrets struct {
	// DiskSecrets - Contains the list of secrets object for that device.
	DiskSecrets *[]DiskSecret `json:"diskSecrets,omitempty"`
	// PassKey - PassKey for the disk Job.
	PassKey *string `json:"passKey,omitempty"`
	// IsPasskeyUserDefined - Whether passkey was provided by user.
	IsPasskeyUserDefined *bool `json:"isPasskeyUserDefined,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobSecrets.
func (djs DiskJobSecrets) MarshalJSON() ([]byte, error) {
	djs.JobSecretsType = JobSecretsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djs.DiskSecrets != nil {
		objectMap["diskSecrets"] = djs.DiskSecrets
	}
	if djs.PassKey != nil {
		objectMap["passKey"] = djs.PassKey
	}
	if djs.IsPasskeyUserDefined != nil {
		objectMap["isPasskeyUserDefined"] = djs.IsPasskeyUserDefined
	}
	if djs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = djs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return &djs, true
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &djs, true
}

// DiskSecret contains all the secrets of a Disk.
type DiskSecret struct {
	// DiskSerialNumber - Serial number of the assigned disk.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// BitLockerKey - Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`
}

// Error top level error for the job.
type Error struct {
	// Code - Error code that can be used to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - Describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`
}

// HeavyAccountCopyLogDetails copy log details for a storage account for Databox heavy
type HeavyAccountCopyLogDetails struct {
	// AccountName - Destination account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - Link for copy logs.
	CopyLogLink *[]string `json:"copyLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	hacld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hacld.AccountName != nil {
		objectMap["accountName"] = hacld.AccountName
	}
	if hacld.CopyLogLink != nil {
		objectMap["copyLogLink"] = hacld.CopyLogLink
	}
	if hacld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = hacld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return &hacld, true
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &hacld, true
}

// HeavyJobDetails databox Heavy Device Job Details
type HeavyJobDetails struct {
	// CopyProgress - Copy progress per account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobDetails.
func (hjd HeavyJobDetails) MarshalJSON() ([]byte, error) {
	hjd.JobDetailsType = JobDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjd.CopyProgress != nil {
		objectMap["copyProgress"] = hjd.CopyProgress
	}
	if hjd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = hjd.ExpectedDataSizeInTeraBytes
	}
	if hjd.JobStages != nil {
		objectMap["jobStages"] = hjd.JobStages
	}
	if hjd.ContactDetails != nil {
		objectMap["contactDetails"] = hjd.ContactDetails
	}
	if hjd.ShippingAddress != nil {
		objectMap["shippingAddress"] = hjd.ShippingAddress
	}
	if hjd.DeliveryPackage != nil {
		objectMap["deliveryPackage"] = hjd.DeliveryPackage
	}
	if hjd.ReturnPackage != nil {
		objectMap["returnPackage"] = hjd.ReturnPackage
	}
	if hjd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = hjd.DestinationAccountDetails
	}
	if hjd.ErrorDetails != nil {
		objectMap["errorDetails"] = hjd.ErrorDetails
	}
	if hjd.Preferences != nil {
		objectMap["preferences"] = hjd.Preferences
	}
	if hjd.CopyLogDetails != nil {
		objectMap["copyLogDetails"] = hjd.CopyLogDetails
	}
	if hjd.ReverseShipmentLabelSasKey != nil {
		objectMap["reverseShipmentLabelSasKey"] = hjd.ReverseShipmentLabelSasKey
	}
	if hjd.ChainOfCustodySasKey != nil {
		objectMap["chainOfCustodySasKey"] = hjd.ChainOfCustodySasKey
	}
	if hjd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = hjd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return &hjd, true
}

// AsJobDetailsType is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &hjd, true
}

// UnmarshalJSON is the custom unmarshaler for HeavyJobDetails struct.
func (hjd *HeavyJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				hjd.CopyProgress = &copyProgress
			}
		case "expectedDataSizeInTeraBytes":
			if v != nil {
				var expectedDataSizeInTeraBytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTeraBytes)
				if err != nil {
					return err
				}
				hjd.ExpectedDataSizeInTeraBytes = &expectedDataSizeInTeraBytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				hjd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				hjd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				hjd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				hjd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				hjd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				hjd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				hjd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				hjd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				hjd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				hjd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				hjd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				hjd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// HeavyJobSecrets the secrets related to a databox heavy job.
type HeavyJobSecrets struct {
	// CabinetPodSecrets - Contains the list of secret objects for a databox heavy job.
	CabinetPodSecrets *[]HeavySecret `json:"cabinetPodSecrets,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobSecrets.
func (hjs HeavyJobSecrets) MarshalJSON() ([]byte, error) {
	hjs.JobSecretsType = JobSecretsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjs.CabinetPodSecrets != nil {
		objectMap["cabinetPodSecrets"] = hjs.CabinetPodSecrets
	}
	if hjs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = hjs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return &hjs, true
}

// AsJobSecretsType is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &hjs, true
}

// HeavySecret the secrets related to a databox heavy.
type HeavySecret struct {
	// DeviceSerialNumber - Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// BasicJobDetails job details.
type BasicJobDetails interface {
	AsDiskJobDetails() (*DiskJobDetails, bool)
	AsHeavyJobDetails() (*HeavyJobDetails, bool)
	AsJobDetailsType() (*JobDetailsType, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details.
type JobDetails struct {
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobDetailsType"] {
	case string(JobDetailsTypeDataBoxDisk):
		var djd DiskJobDetails
		err := json.Unmarshal(body, &djd)
		return djd, err
	case string(JobDetailsTypeDataBoxHeavy):
		var hjd HeavyJobDetails
		err := json.Unmarshal(body, &hjd)
		return hjd, err
	case string(JobDetailsTypeDataBox):
		var jdt JobDetailsType
		err := json.Unmarshal(body, &jdt)
		return jdt, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.JobDetailsType = JobDetailsTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = jd.ExpectedDataSizeInTeraBytes
	}
	if jd.JobStages != nil {
		objectMap["jobStages"] = jd.JobStages
	}
	if jd.ContactDetails != nil {
		objectMap["contactDetails"] = jd.ContactDetails
	}
	if jd.ShippingAddress != nil {
		objectMap["shippingAddress"] = jd.ShippingAddress
	}
	if jd.DeliveryPackage != nil {
		objectMap["deliveryPackage"] = jd.DeliveryPackage
	}
	if jd.ReturnPackage != nil {
		objectMap["returnPackage"] = jd.ReturnPackage
	}
	if jd.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = jd.DestinationAccountDetails
	}
	if jd.ErrorDetails != nil {
		objectMap["errorDetails"] = jd.ErrorDetails
	}
	if jd.Preferences != nil {
		objectMap["preferences"] = jd.Preferences
	}
	if jd.CopyLogDetails != nil {
		objectMap["copyLogDetails"] = jd.CopyLogDetails
	}
	if jd.ReverseShipmentLabelSasKey != nil {
		objectMap["reverseShipmentLabelSasKey"] = jd.ReverseShipmentLabelSasKey
	}
	if jd.ChainOfCustodySasKey != nil {
		objectMap["chainOfCustodySasKey"] = jd.ChainOfCustodySasKey
	}
	if jd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetails struct.
func (jd *JobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "expectedDataSizeInTeraBytes":
			if v != nil {
				var expectedDataSizeInTeraBytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTeraBytes)
				if err != nil {
					return err
				}
				jd.ExpectedDataSizeInTeraBytes = &expectedDataSizeInTeraBytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jd.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				jd.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				jd.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobDetailsType databox Job Details
type JobDetailsType struct {
	// CopyProgress - Copy progress per storage account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// ExpectedDataSizeInTeraBytes - The expected size of the data, which needs to be transfered in this job, in tera bytes.
	ExpectedDataSizeInTeraBytes *int32 `json:"expectedDataSizeInTeraBytes,omitempty"`
	// JobStages - List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
	// ErrorDetails - Error details for failure. This is optional.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobDetailsType.
func (jdt JobDetailsType) MarshalJSON() ([]byte, error) {
	jdt.JobDetailsType = JobDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if jdt.CopyProgress != nil {
		objectMap["copyProgress"] = jdt.CopyProgress
	}
	if jdt.ExpectedDataSizeInTeraBytes != nil {
		objectMap["expectedDataSizeInTeraBytes"] = jdt.ExpectedDataSizeInTeraBytes
	}
	if jdt.JobStages != nil {
		objectMap["jobStages"] = jdt.JobStages
	}
	if jdt.ContactDetails != nil {
		objectMap["contactDetails"] = jdt.ContactDetails
	}
	if jdt.ShippingAddress != nil {
		objectMap["shippingAddress"] = jdt.ShippingAddress
	}
	if jdt.DeliveryPackage != nil {
		objectMap["deliveryPackage"] = jdt.DeliveryPackage
	}
	if jdt.ReturnPackage != nil {
		objectMap["returnPackage"] = jdt.ReturnPackage
	}
	if jdt.DestinationAccountDetails != nil {
		objectMap["destinationAccountDetails"] = jdt.DestinationAccountDetails
	}
	if jdt.ErrorDetails != nil {
		objectMap["errorDetails"] = jdt.ErrorDetails
	}
	if jdt.Preferences != nil {
		objectMap["preferences"] = jdt.Preferences
	}
	if jdt.CopyLogDetails != nil {
		objectMap["copyLogDetails"] = jdt.CopyLogDetails
	}
	if jdt.ReverseShipmentLabelSasKey != nil {
		objectMap["reverseShipmentLabelSasKey"] = jdt.ReverseShipmentLabelSasKey
	}
	if jdt.ChainOfCustodySasKey != nil {
		objectMap["chainOfCustodySasKey"] = jdt.ChainOfCustodySasKey
	}
	if jdt.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jdt.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetailsType() (*JobDetailsType, bool) {
	return &jdt, true
}

// AsJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jdt, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetailsType struct.
func (jdt *JobDetailsType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				jdt.CopyProgress = &copyProgress
			}
		case "expectedDataSizeInTeraBytes":
			if v != nil {
				var expectedDataSizeInTeraBytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTeraBytes)
				if err != nil {
					return err
				}
				jdt.ExpectedDataSizeInTeraBytes = &expectedDataSizeInTeraBytes
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jdt.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jdt.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jdt.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jdt.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jdt.ReturnPackage = &returnPackage
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				jdt.DestinationAccountDetails = &destinationAccountDetails
			}
		case "errorDetails":
			if v != nil {
				var errorDetails []JobErrorDetails
				err = json.Unmarshal(*v, &errorDetails)
				if err != nil {
					return err
				}
				jdt.ErrorDetails = &errorDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jdt.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jdt.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jdt.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jdt.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jdt.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobErrorDetails job Error Details for providing the information and recommended action.
type JobErrorDetails struct {
	// ErrorMessage - Message for the error.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorCode - Code for the error.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// RecommendedAction - Recommended action for the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ExceptionMessage - Contains the non localized exception message
	ExceptionMessage *string `json:"exceptionMessage,omitempty"`
}

// JobProperties job Properties
type JobProperties struct {
	// IsCancellable - Describes whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// IsDeletable - Describes whether the job is deletable or not.
	IsDeletable *bool `json:"isDeletable,omitempty"`
	// IsShippingAddressEditable - Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool `json:"isShippingAddressEditable,omitempty"`
	// Status - Name of the stage which is in progress. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted'
	Status StageName `json:"status,omitempty"`
	// StartTime - Time at which the job was started in UTC ISO 8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Error - Top level error for the job.
	Error *Error `json:"error,omitempty"`
	// Details - Details of a job run. This field will only be sent for expand details filter.
	Details BasicJobDetails `json:"details,omitempty"`
	// CancellationReason - Reason for cancellation.
	CancellationReason *string `json:"cancellationReason,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "isCancellable":
			if v != nil {
				var isCancellable bool
				err = json.Unmarshal(*v, &isCancellable)
				if err != nil {
					return err
				}
				jp.IsCancellable = &isCancellable
			}
		case "isDeletable":
			if v != nil {
				var isDeletable bool
				err = json.Unmarshal(*v, &isDeletable)
				if err != nil {
					return err
				}
				jp.IsDeletable = &isDeletable
			}
		case "isShippingAddressEditable":
			if v != nil {
				var isShippingAddressEditable bool
				err = json.Unmarshal(*v, &isShippingAddressEditable)
				if err != nil {
					return err
				}
				jp.IsShippingAddressEditable = &isShippingAddressEditable
			}
		case "status":
			if v != nil {
				var status StageName
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				jp.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "error":
			if v != nil {
				var errorVar Error
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				jp.Error = &errorVar
			}
		case "details":
			if v != nil {
				details, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.Details = details
			}
		case "cancellationReason":
			if v != nil {
				var cancellationReason string
				err = json.Unmarshal(*v, &cancellationReason)
				if err != nil {
					return err
				}
				jp.CancellationReason = &cancellationReason
			}
		}
	}

	return nil
}

// JobResource job Resource.
type JobResource struct {
	autorest.Response `json:"-"`
	// JobProperties - Properties of a job.
	*JobProperties `json:"properties,omitempty"`
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - Type of the object.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jr.JobProperties != nil {
		objectMap["properties"] = jr.JobProperties
	}
	if jr.Name != nil {
		objectMap["name"] = jr.Name
	}
	if jr.ID != nil {
		objectMap["id"] = jr.ID
	}
	if jr.Type != nil {
		objectMap["type"] = jr.Type
	}
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.Sku != nil {
		objectMap["sku"] = jr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				jr.JobProperties = &jobProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				jr.Sku = &sku
			}
		}
	}

	return nil
}

// JobResourceList job Resource Collection
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of job resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResourceListIterator type.
func NewJobResourceListIterator(page JobResourceListPage) JobResourceListIterator {
	return JobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if jrl.NextLink == nil || len(to.String(jrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(context.Context, JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jrl)
	if err != nil {
		return err
	}
	page.jrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// Creates a new instance of the JobResourceListPage type.
func NewJobResourceListPage(getNextPage func(context.Context, JobResourceList) (JobResourceList, error)) JobResourceListPage {
	return JobResourceListPage{fn: getNextPage}
}

// JobResourceUpdateParameter the JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// UpdateJobProperties - Properties of a job to be updated.
	*UpdateJobProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobResourceUpdateParameter.
func (jrup JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrup.UpdateJobProperties != nil {
		objectMap["properties"] = jrup.UpdateJobProperties
	}
	if jrup.Tags != nil {
		objectMap["tags"] = jrup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResourceUpdateParameter struct.
func (jrup *JobResourceUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateJobProperties UpdateJobProperties
				err = json.Unmarshal(*v, &updateJobProperties)
				if err != nil {
					return err
				}
				jrup.UpdateJobProperties = &updateJobProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jrup.Tags = tags
			}
		}
	}

	return nil
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsCreateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.CreateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsCreateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsDeleteFuture) Result(client JobsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicJobSecrets the base class for the secrets
type BasicJobSecrets interface {
	AsDiskJobSecrets() (*DiskJobSecrets, bool)
	AsHeavyJobSecrets() (*HeavyJobSecrets, bool)
	AsJobSecretsType() (*JobSecretsType, bool)
	AsJobSecrets() (*JobSecrets, bool)
}

// JobSecrets the base class for the secrets
type JobSecrets struct {
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

func unmarshalBasicJobSecrets(body []byte) (BasicJobSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobSecretsType"] {
	case string(JobSecretsTypeDataBoxDisk):
		var djs DiskJobSecrets
		err := json.Unmarshal(body, &djs)
		return djs, err
	case string(JobSecretsTypeDataBoxHeavy):
		var hjs HeavyJobSecrets
		err := json.Unmarshal(body, &hjs)
		return hjs, err
	case string(JobSecretsTypeDataBox):
		var jst JobSecretsType
		err := json.Unmarshal(body, &jst)
		return jst, err
	default:
		var js JobSecrets
		err := json.Unmarshal(body, &js)
		return js, err
	}
}
func unmarshalBasicJobSecretsArray(body []byte) ([]BasicJobSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jsArray := make([]BasicJobSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		js, err := unmarshalBasicJobSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		jsArray[index] = js
	}
	return jsArray, nil
}

// MarshalJSON is the custom marshaler for JobSecrets.
func (js JobSecrets) MarshalJSON() ([]byte, error) {
	js.JobSecretsType = JobSecretsTypeJobSecrets
	objectMap := make(map[string]interface{})
	if js.JobSecretsType != "" {
		objectMap["jobSecretsType"] = js.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return &js, true
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &js, true
}

// JobSecretsType the secrets related to a databox job.
type JobSecretsType struct {
	// PodSecrets - Contains the list of secret objects for a job.
	PodSecrets *[]Secret `json:"podSecrets,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobSecretsType.
func (jst JobSecretsType) MarshalJSON() ([]byte, error) {
	jst.JobSecretsType = JobSecretsTypeDataBox
	objectMap := make(map[string]interface{})
	if jst.PodSecrets != nil {
		objectMap["podSecrets"] = jst.PodSecrets
	}
	if jst.JobSecretsType != "" {
		objectMap["jobSecretsType"] = jst.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecretsType() (*JobSecretsType, bool) {
	return &jst, true
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &jst, true
}

// JobStages job stages.
type JobStages struct {
	// StageName - Name of the job stage. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted'
	StageName StageName `json:"stageName,omitempty"`
	// DisplayName - Display name of the job stage.
	DisplayName *string `json:"displayName,omitempty"`
	// StageStatus - Status of the job stage. Possible values include: 'StageStatusNone', 'StageStatusInProgress', 'StageStatusSucceeded', 'StageStatusFailed', 'StageStatusCancelled', 'StageStatusCancelling', 'StageStatusSucceededWithErrors'
	StageStatus StageStatus `json:"stageStatus,omitempty"`
	// StageTime - Time for the job stage in UTC ISO 8601 format.
	StageTime *date.Time `json:"stageTime,omitempty"`
	// JobStageDetails - Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty"`
	// ErrorDetails - Error details for the stage.
	ErrorDetails *[]JobErrorDetails `json:"errorDetails,omitempty"`
}

// JobsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobsUpdateFuture) Result(client JobsClient) (jr JobResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("databox.JobsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jr.Response.Response, err = future.GetResult(sender); err == nil && jr.Response.Response.StatusCode != http.StatusNoContent {
		jr, err = client.UpdateResponder(jr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "databox.JobsUpdateFuture", "Result", jr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NotificationPreference notification preference for a job stage.
type NotificationPreference struct {
	// StageName - Name of the stage. Possible values include: 'DevicePrepared', 'Dispatched', 'Delivered', 'PickedUp', 'AtAzureDC', 'DataCopy'
	StageName NotificationStageName `json:"stageName,omitempty"`
	// SendNotification - Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`
}

// Operation operation entity.
type Operation struct {
	// Name - Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`
	// Display - Operation display values.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - Operation properties.
	Properties interface{} `json:"properties,omitempty"`
	// Origin - Origin of the operation. Can be : user|system|user,system
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay operation display
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized name of the operation for display purpose.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized description of the operation for display purpose.
	Description *string `json:"description,omitempty"`
}

// OperationList operation Collection.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// PackageShippingDetails shipping details.
type PackageShippingDetails struct {
	// CarrierName - Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - Url where shipment can be tracked.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// Preferences preferences related to the order
type Preferences struct {
	PreferredDataCenterRegion *[]string `json:"preferredDataCenterRegion,omitempty"`
}

// Resource model of the Resource.
type Resource struct {
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// Secret the secrets related to a DataBox.
type Secret struct {
	// DeviceSerialNumber - Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// ShareCredentialDetails credential details of the shares in account.
type ShareCredentialDetails struct {
	// ShareName - Name of the share.
	ShareName *string `json:"shareName,omitempty"`
	// ShareType - Type of the share. Possible values include: 'UnknownType', 'HCS', 'BlockBlob', 'PageBlob', 'AzureFile', 'ManagedDisk'
	ShareType ShareDestinationFormatType `json:"shareType,omitempty"`
	// UserName - User name for the share.
	UserName *string `json:"userName,omitempty"`
	// Password - Password for the share.
	Password *string `json:"password,omitempty"`
	// SupportedAccessProtocols - Access protocols supported on the device.
	SupportedAccessProtocols *[]AccessProtocol `json:"supportedAccessProtocols,omitempty"`
}

// ShipmentPickUpRequest shipment pick up request details.
type ShipmentPickUpRequest struct {
	// StartTime - Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ShipmentLocation - Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string `json:"shipmentLocation,omitempty"`
}

// ShipmentPickUpResponse shipment pick up response.
type ShipmentPickUpResponse struct {
	autorest.Response `json:"-"`
	// ConfirmationNumber - Confirmation number for the pick up request.
	ConfirmationNumber *string `json:"confirmationNumber,omitempty"`
	// ReadyByTime - Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *date.Time `json:"readyByTime,omitempty"`
}

// ShippingAddress shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// StreetAddress1 - Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`
	// StreetAddress2 - Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
	// StreetAddress3 - Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`
	// City - Name of the City.
	City *string `json:"city,omitempty"`
	// StateOrProvince - Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// Country - Name of the Country.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// ZipExtendedCode - Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
	// CompanyName - Name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressType - Type of address. Possible values include: 'None', 'Residential', 'Commercial'
	AddressType AddressType `json:"addressType,omitempty"`
}

// Sku the Sku.
type Sku struct {
	// Name - The sku name. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	Name SkuName `json:"name,omitempty"`
	// DisplayName - The display name of the sku.
	DisplayName *string `json:"displayName,omitempty"`
	// Family - The sku family.
	Family *string `json:"family,omitempty"`
}

// SkuCapacity capacity of the sku.
type SkuCapacity struct {
	// Usable - Usable capacity in TB.
	Usable *string `json:"usable,omitempty"`
	// Maximum - Maximum capacity in TB.
	Maximum *string `json:"maximum,omitempty"`
}

// SkuCost describes metadata for retrieving price info.
type SkuCost struct {
	// MeterID - Meter id of the Sku.
	MeterID *string `json:"meterId,omitempty"`
	// MeterType - The type of the meter.
	MeterType *string `json:"meterType,omitempty"`
}

// SkuInformation information of the sku.
type SkuInformation struct {
	// Sku - The Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Enabled - The sku is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// SkuProperties - Properties of the sku.
	*SkuProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.Sku != nil {
		objectMap["sku"] = si.Sku
	}
	if si.Enabled != nil {
		objectMap["enabled"] = si.Enabled
	}
	if si.SkuProperties != nil {
		objectMap["properties"] = si.SkuProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SkuInformation struct.
func (si *SkuInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				si.Sku = &sku
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				si.Enabled = &enabled
			}
		case "properties":
			if v != nil {
				var skuProperties SkuProperties
				err = json.Unmarshal(*v, &skuProperties)
				if err != nil {
					return err
				}
				si.SkuProperties = &skuProperties
			}
		}
	}

	return nil
}

// SkuProperties properties of the sku.
type SkuProperties struct {
	// DestinationToServiceLocationMap - The map of destination location to service location.
	DestinationToServiceLocationMap *[]DestinationToServiceLocationMap `json:"destinationToServiceLocationMap,omitempty"`
	// Capacity - Capacity of the Sku.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Costs - Cost of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// APIVersions - Api versions that support this Sku.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// DisabledReason - Reason why the Sku is disabled. Possible values include: 'SkuDisabledReasonNone', 'SkuDisabledReasonCountry', 'SkuDisabledReasonRegion', 'SkuDisabledReasonFeature', 'SkuDisabledReasonOfferType', 'SkuDisabledReasonNoSubscriptionInfo'
	DisabledReason SkuDisabledReason `json:"disabledReason,omitempty"`
	// DisabledReasonMessage - Message for why the Sku is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty"`
	// RequiredFeature - Required feature to access the sku.
	RequiredFeature *string `json:"requiredFeature,omitempty"`
}

// UnencryptedCredentials unencrypted credentials for accessing device.
type UnencryptedCredentials struct {
	// JobName - Name of the job.
	JobName *string `json:"jobName,omitempty"`
	// JobSecrets - Secrets related to this job.
	JobSecrets BasicJobSecrets `json:"jobSecrets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnencryptedCredentials struct.
func (uc *UnencryptedCredentials) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "jobName":
			if v != nil {
				var jobName string
				err = json.Unmarshal(*v, &jobName)
				if err != nil {
					return err
				}
				uc.JobName = &jobName
			}
		case "jobSecrets":
			if v != nil {
				jobSecrets, err := unmarshalBasicJobSecrets(*v)
				if err != nil {
					return err
				}
				uc.JobSecrets = jobSecrets
			}
		}
	}

	return nil
}

// UnencryptedCredentialsList list of unencrypted credentials for accessing device.
type UnencryptedCredentialsList struct {
	autorest.Response `json:"-"`
	// Value - List of unencrypted credentials.
	Value *[]UnencryptedCredentials `json:"value,omitempty"`
	// NextLink - Link for the next set of unencrypted credentials.
	NextLink *string `json:"nextLink,omitempty"`
}

// UpdateJobDetails job details for update.
type UpdateJobDetails struct {
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
}

// UpdateJobProperties job Properties for update
type UpdateJobProperties struct {
	// Details - Details of a job to be updated.
	Details *UpdateJobDetails `json:"details,omitempty"`
	// DestinationAccountDetails - Destination account details.
	DestinationAccountDetails *[]BasicDestinationAccountDetails `json:"destinationAccountDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateJobProperties struct.
func (ujp *UpdateJobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "details":
			if v != nil {
				var details UpdateJobDetails
				err = json.Unmarshal(*v, &details)
				if err != nil {
					return err
				}
				ujp.Details = &details
			}
		case "destinationAccountDetails":
			if v != nil {
				destinationAccountDetails, err := unmarshalBasicDestinationAccountDetailsArray(*v)
				if err != nil {
					return err
				}
				ujp.DestinationAccountDetails = &destinationAccountDetails
			}
		}
	}

	return nil
}

// ValidateAddress the requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
}
