// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package policyinsights

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/policyinsights/mgmt/2018-07-01-preview/policyinsights"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type PolicyStatesResource = original.PolicyStatesResource

const (
	Default PolicyStatesResource = original.Default
	Latest  PolicyStatesResource = original.Latest
)

type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationsListResults = original.OperationsListResults
type PolicyAssignmentSummary = original.PolicyAssignmentSummary
type PolicyDefinitionSummary = original.PolicyDefinitionSummary
type PolicyDetails = original.PolicyDetails
type PolicyEvent = original.PolicyEvent
type PolicyEventsQueryResults = original.PolicyEventsQueryResults
type PolicyState = original.PolicyState
type PolicyStatesQueryResults = original.PolicyStatesQueryResults
type PolicyTrackedResource = original.PolicyTrackedResource
type PolicyTrackedResourcesQueryResults = original.PolicyTrackedResourcesQueryResults
type PolicyTrackedResourcesQueryResultsIterator = original.PolicyTrackedResourcesQueryResultsIterator
type PolicyTrackedResourcesQueryResultsPage = original.PolicyTrackedResourcesQueryResultsPage
type QueryFailure = original.QueryFailure
type QueryFailureError = original.QueryFailureError
type Remediation = original.Remediation
type RemediationDeployment = original.RemediationDeployment
type RemediationDeploymentsListResult = original.RemediationDeploymentsListResult
type RemediationDeploymentsListResultIterator = original.RemediationDeploymentsListResultIterator
type RemediationDeploymentsListResultPage = original.RemediationDeploymentsListResultPage
type RemediationDeploymentSummary = original.RemediationDeploymentSummary
type RemediationFilters = original.RemediationFilters
type RemediationListResult = original.RemediationListResult
type RemediationListResultIterator = original.RemediationListResultIterator
type RemediationListResultPage = original.RemediationListResultPage
type RemediationProperties = original.RemediationProperties
type String = original.String
type SummarizeResults = original.SummarizeResults
type Summary = original.Summary
type SummaryResults = original.SummaryResults
type TrackedResourceModificationDetails = original.TrackedResourceModificationDetails
type TypedErrorInfo = original.TypedErrorInfo
type OperationsClient = original.OperationsClient
type PolicyEventsClient = original.PolicyEventsClient
type PolicyStatesClient = original.PolicyStatesClient
type PolicyTrackedResourcesClient = original.PolicyTrackedResourcesClient
type RemediationsClient = original.RemediationsClient

func New() BaseClient {
	return original.New()
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossiblePolicyStatesResourceValues() []PolicyStatesResource {
	return original.PossiblePolicyStatesResourceValues()
}
func NewPolicyTrackedResourcesQueryResultsIterator(page PolicyTrackedResourcesQueryResultsPage) PolicyTrackedResourcesQueryResultsIterator {
	return original.NewPolicyTrackedResourcesQueryResultsIterator(page)
}
func NewPolicyTrackedResourcesQueryResultsPage(getNextPage func(context.Context, PolicyTrackedResourcesQueryResults) (PolicyTrackedResourcesQueryResults, error)) PolicyTrackedResourcesQueryResultsPage {
	return original.NewPolicyTrackedResourcesQueryResultsPage(getNextPage)
}
func NewRemediationDeploymentsListResultIterator(page RemediationDeploymentsListResultPage) RemediationDeploymentsListResultIterator {
	return original.NewRemediationDeploymentsListResultIterator(page)
}
func NewRemediationDeploymentsListResultPage(getNextPage func(context.Context, RemediationDeploymentsListResult) (RemediationDeploymentsListResult, error)) RemediationDeploymentsListResultPage {
	return original.NewRemediationDeploymentsListResultPage(getNextPage)
}
func NewRemediationListResultIterator(page RemediationListResultPage) RemediationListResultIterator {
	return original.NewRemediationListResultIterator(page)
}
func NewRemediationListResultPage(getNextPage func(context.Context, RemediationListResult) (RemediationListResult, error)) RemediationListResultPage {
	return original.NewRemediationListResultPage(getNextPage)
}
func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}
func NewPolicyEventsClient() PolicyEventsClient {
	return original.NewPolicyEventsClient()
}
func NewPolicyEventsClientWithBaseURI(baseURI string) PolicyEventsClient {
	return original.NewPolicyEventsClientWithBaseURI(baseURI)
}
func NewPolicyStatesClient() PolicyStatesClient {
	return original.NewPolicyStatesClient()
}
func NewPolicyStatesClientWithBaseURI(baseURI string) PolicyStatesClient {
	return original.NewPolicyStatesClientWithBaseURI(baseURI)
}
func NewPolicyTrackedResourcesClient() PolicyTrackedResourcesClient {
	return original.NewPolicyTrackedResourcesClient()
}
func NewPolicyTrackedResourcesClientWithBaseURI(baseURI string) PolicyTrackedResourcesClient {
	return original.NewPolicyTrackedResourcesClientWithBaseURI(baseURI)
}
func NewRemediationsClient() RemediationsClient {
	return original.NewRemediationsClient()
}
func NewRemediationsClientWithBaseURI(baseURI string) RemediationsClient {
	return original.NewRemediationsClientWithBaseURI(baseURI)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
