// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage_common.proto

package datatypes

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type ReadRequest_Group int32

const (
	// GroupNone returns all series as a single group.
	// The single GroupFrame.TagKeys will be the union of all tag keys.
	GroupNone ReadRequest_Group = 0
	// GroupAll returns a unique group for each series.
	// As an optimization, no GroupFrames will be generated.
	GroupAll ReadRequest_Group = 1
	// GroupBy returns a group for each unique value of the specified GroupKeys.
	GroupBy ReadRequest_Group = 2
	// GroupExcept in not implemented.
	GroupExcept ReadRequest_Group = 3
)

var ReadRequest_Group_name = map[int32]string{
	0: "GROUP_NONE",
	1: "GROUP_ALL",
	2: "GROUP_BY",
	3: "GROUP_EXCEPT",
}
var ReadRequest_Group_value = map[string]int32{
	"GROUP_NONE":   0,
	"GROUP_ALL":    1,
	"GROUP_BY":     2,
	"GROUP_EXCEPT": 3,
}

func (x ReadRequest_Group) String() string {
	return proto.EnumName(ReadRequest_Group_name, int32(x))
}
func (ReadRequest_Group) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{0, 0}
}

type ReadRequest_HintFlags int32

const (
	HintNone     ReadRequest_HintFlags = 0
	HintNoPoints ReadRequest_HintFlags = 1
	HintNoSeries ReadRequest_HintFlags = 2
	// HintSchemaAllTime performs schema queries without using time ranges
	HintSchemaAllTime ReadRequest_HintFlags = 4
)

var ReadRequest_HintFlags_name = map[int32]string{
	0: "HINT_NONE",
	1: "HINT_NO_POINTS",
	2: "HINT_NO_SERIES",
	4: "HINT_SCHEMA_ALL_TIME",
}
var ReadRequest_HintFlags_value = map[string]int32{
	"HINT_NONE":            0,
	"HINT_NO_POINTS":       1,
	"HINT_NO_SERIES":       2,
	"HINT_SCHEMA_ALL_TIME": 4,
}

func (x ReadRequest_HintFlags) String() string {
	return proto.EnumName(ReadRequest_HintFlags_name, int32(x))
}
func (ReadRequest_HintFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{0, 1}
}

type Aggregate_AggregateType int32

const (
	AggregateTypeNone  Aggregate_AggregateType = 0
	AggregateTypeSum   Aggregate_AggregateType = 1
	AggregateTypeCount Aggregate_AggregateType = 2
)

var Aggregate_AggregateType_name = map[int32]string{
	0: "NONE",
	1: "SUM",
	2: "COUNT",
}
var Aggregate_AggregateType_value = map[string]int32{
	"NONE":  0,
	"SUM":   1,
	"COUNT": 2,
}

func (x Aggregate_AggregateType) String() string {
	return proto.EnumName(Aggregate_AggregateType_name, int32(x))
}
func (Aggregate_AggregateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{1, 0}
}

type ReadResponse_FrameType int32

const (
	FrameTypeSeries ReadResponse_FrameType = 0
	FrameTypePoints ReadResponse_FrameType = 1
)

var ReadResponse_FrameType_name = map[int32]string{
	0: "SERIES",
	1: "POINTS",
}
var ReadResponse_FrameType_value = map[string]int32{
	"SERIES": 0,
	"POINTS": 1,
}

func (x ReadResponse_FrameType) String() string {
	return proto.EnumName(ReadResponse_FrameType_name, int32(x))
}
func (ReadResponse_FrameType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 0}
}

type ReadResponse_DataType int32

const (
	DataTypeFloat    ReadResponse_DataType = 0
	DataTypeInteger  ReadResponse_DataType = 1
	DataTypeUnsigned ReadResponse_DataType = 2
	DataTypeBoolean  ReadResponse_DataType = 3
	DataTypeString   ReadResponse_DataType = 4
)

var ReadResponse_DataType_name = map[int32]string{
	0: "FLOAT",
	1: "INTEGER",
	2: "UNSIGNED",
	3: "BOOLEAN",
	4: "STRING",
}
var ReadResponse_DataType_value = map[string]int32{
	"FLOAT":    0,
	"INTEGER":  1,
	"UNSIGNED": 2,
	"BOOLEAN":  3,
	"STRING":   4,
}

func (x ReadResponse_DataType) String() string {
	return proto.EnumName(ReadResponse_DataType_name, int32(x))
}
func (ReadResponse_DataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 1}
}

// Request message for Storage.Read.
type ReadRequest struct {
	ReadSource     *types.Any     `protobuf:"bytes,13,opt,name=read_source,json=readSource" json:"read_source,omitempty"`
	TimestampRange TimestampRange `protobuf:"bytes,2,opt,name=timestamp_range,json=timestampRange" json:"timestamp_range"`
	// Descending indicates whether points should be returned in descending order.
	Descending bool `protobuf:"varint,3,opt,name=descending,proto3" json:"descending,omitempty"`
	// GroupKeys specifies a list of tag keys used to order the data. It is dependent on the Group property to determine
	// its behavior.
	GroupKeys []string `protobuf:"bytes,4,rep,name=group_keys,json=groupKeys" json:"group_keys,omitempty"`
	//
	Group ReadRequest_Group `protobuf:"varint,11,opt,name=group,proto3,enum=influxdata.platform.storage.ReadRequest_Group" json:"group,omitempty"`
	// Aggregate specifies an optional aggregate to apply to the data.
	// TODO(sgc): switch to slice for multiple aggregates in a single request
	Aggregate *Aggregate `protobuf:"bytes,9,opt,name=aggregate" json:"aggregate,omitempty"`
	Predicate *Predicate `protobuf:"bytes,5,opt,name=predicate" json:"predicate,omitempty"`
	// SeriesLimit determines the maximum number of series to be returned for the request. Specify 0 for no limit.
	SeriesLimit int64 `protobuf:"varint,6,opt,name=series_limit,json=seriesLimit,proto3" json:"series_limit,omitempty"`
	// SeriesOffset determines how many series to skip before processing the request.
	SeriesOffset int64 `protobuf:"varint,7,opt,name=series_offset,json=seriesOffset,proto3" json:"series_offset,omitempty"`
	// PointsLimit determines the maximum number of values per series to be returned for the request.
	// Specify 0 for no limit. -1 to return series frames only.
	PointsLimit int64 `protobuf:"varint,8,opt,name=points_limit,json=pointsLimit,proto3" json:"points_limit,omitempty"`
	// Trace contains opaque data if a trace is active.
	Trace map[string]string `protobuf:"bytes,10,rep,name=trace" json:"trace,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Hints is a bitwise OR of HintFlags to control the behavior
	// of the read request.
	Hints                HintFlags `protobuf:"fixed32,12,opt,name=hints,proto3,casttype=HintFlags" json:"hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ReadRequest) Reset()         { *m = ReadRequest{} }
func (m *ReadRequest) String() string { return proto.CompactTextString(m) }
func (*ReadRequest) ProtoMessage()    {}
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{0}
}
func (m *ReadRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRequest.Merge(dst, src)
}
func (m *ReadRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReadRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRequest proto.InternalMessageInfo

type Aggregate struct {
	Type                 Aggregate_AggregateType `protobuf:"varint,1,opt,name=type,proto3,enum=influxdata.platform.storage.Aggregate_AggregateType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Aggregate) Reset()         { *m = Aggregate{} }
func (m *Aggregate) String() string { return proto.CompactTextString(m) }
func (*Aggregate) ProtoMessage()    {}
func (*Aggregate) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{1}
}
func (m *Aggregate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Aggregate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Aggregate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Aggregate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Aggregate.Merge(dst, src)
}
func (m *Aggregate) XXX_Size() int {
	return m.Size()
}
func (m *Aggregate) XXX_DiscardUnknown() {
	xxx_messageInfo_Aggregate.DiscardUnknown(m)
}

var xxx_messageInfo_Aggregate proto.InternalMessageInfo

type Tag struct {
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{2}
}
func (m *Tag) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(dst, src)
}
func (m *Tag) XXX_Size() int {
	return m.Size()
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

// Response message for Storage.Read.
type ReadResponse struct {
	Frames               []ReadResponse_Frame `protobuf:"bytes,1,rep,name=frames" json:"frames"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ReadResponse) Reset()         { *m = ReadResponse{} }
func (m *ReadResponse) String() string { return proto.CompactTextString(m) }
func (*ReadResponse) ProtoMessage()    {}
func (*ReadResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3}
}
func (m *ReadResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse.Merge(dst, src)
}
func (m *ReadResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse proto.InternalMessageInfo

type ReadResponse_Frame struct {
	// Types that are valid to be assigned to Data:
	//	*ReadResponse_Frame_Group
	//	*ReadResponse_Frame_Series
	//	*ReadResponse_Frame_FloatPoints
	//	*ReadResponse_Frame_IntegerPoints
	//	*ReadResponse_Frame_UnsignedPoints
	//	*ReadResponse_Frame_BooleanPoints
	//	*ReadResponse_Frame_StringPoints
	Data                 isReadResponse_Frame_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ReadResponse_Frame) Reset()         { *m = ReadResponse_Frame{} }
func (m *ReadResponse_Frame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_Frame) ProtoMessage()    {}
func (*ReadResponse_Frame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 0}
}
func (m *ReadResponse_Frame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_Frame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_Frame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_Frame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_Frame.Merge(dst, src)
}
func (m *ReadResponse_Frame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_Frame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_Frame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_Frame proto.InternalMessageInfo

type isReadResponse_Frame_Data interface {
	isReadResponse_Frame_Data()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ReadResponse_Frame_Group struct {
	Group *ReadResponse_GroupFrame `protobuf:"bytes,7,opt,name=group,oneof"`
}
type ReadResponse_Frame_Series struct {
	Series *ReadResponse_SeriesFrame `protobuf:"bytes,1,opt,name=series,oneof"`
}
type ReadResponse_Frame_FloatPoints struct {
	FloatPoints *ReadResponse_FloatPointsFrame `protobuf:"bytes,2,opt,name=float_points,json=floatPoints,oneof"`
}
type ReadResponse_Frame_IntegerPoints struct {
	IntegerPoints *ReadResponse_IntegerPointsFrame `protobuf:"bytes,3,opt,name=integer_points,json=integerPoints,oneof"`
}
type ReadResponse_Frame_UnsignedPoints struct {
	UnsignedPoints *ReadResponse_UnsignedPointsFrame `protobuf:"bytes,4,opt,name=unsigned_points,json=unsignedPoints,oneof"`
}
type ReadResponse_Frame_BooleanPoints struct {
	BooleanPoints *ReadResponse_BooleanPointsFrame `protobuf:"bytes,5,opt,name=boolean_points,json=booleanPoints,oneof"`
}
type ReadResponse_Frame_StringPoints struct {
	StringPoints *ReadResponse_StringPointsFrame `protobuf:"bytes,6,opt,name=string_points,json=stringPoints,oneof"`
}

func (*ReadResponse_Frame_Group) isReadResponse_Frame_Data()          {}
func (*ReadResponse_Frame_Series) isReadResponse_Frame_Data()         {}
func (*ReadResponse_Frame_FloatPoints) isReadResponse_Frame_Data()    {}
func (*ReadResponse_Frame_IntegerPoints) isReadResponse_Frame_Data()  {}
func (*ReadResponse_Frame_UnsignedPoints) isReadResponse_Frame_Data() {}
func (*ReadResponse_Frame_BooleanPoints) isReadResponse_Frame_Data()  {}
func (*ReadResponse_Frame_StringPoints) isReadResponse_Frame_Data()   {}

func (m *ReadResponse_Frame) GetData() isReadResponse_Frame_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ReadResponse_Frame) GetGroup() *ReadResponse_GroupFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_Group); ok {
		return x.Group
	}
	return nil
}

func (m *ReadResponse_Frame) GetSeries() *ReadResponse_SeriesFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_Series); ok {
		return x.Series
	}
	return nil
}

func (m *ReadResponse_Frame) GetFloatPoints() *ReadResponse_FloatPointsFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_FloatPoints); ok {
		return x.FloatPoints
	}
	return nil
}

func (m *ReadResponse_Frame) GetIntegerPoints() *ReadResponse_IntegerPointsFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_IntegerPoints); ok {
		return x.IntegerPoints
	}
	return nil
}

func (m *ReadResponse_Frame) GetUnsignedPoints() *ReadResponse_UnsignedPointsFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_UnsignedPoints); ok {
		return x.UnsignedPoints
	}
	return nil
}

func (m *ReadResponse_Frame) GetBooleanPoints() *ReadResponse_BooleanPointsFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_BooleanPoints); ok {
		return x.BooleanPoints
	}
	return nil
}

func (m *ReadResponse_Frame) GetStringPoints() *ReadResponse_StringPointsFrame {
	if x, ok := m.GetData().(*ReadResponse_Frame_StringPoints); ok {
		return x.StringPoints
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadResponse_Frame) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadResponse_Frame_OneofMarshaler, _ReadResponse_Frame_OneofUnmarshaler, _ReadResponse_Frame_OneofSizer, []interface{}{
		(*ReadResponse_Frame_Group)(nil),
		(*ReadResponse_Frame_Series)(nil),
		(*ReadResponse_Frame_FloatPoints)(nil),
		(*ReadResponse_Frame_IntegerPoints)(nil),
		(*ReadResponse_Frame_UnsignedPoints)(nil),
		(*ReadResponse_Frame_BooleanPoints)(nil),
		(*ReadResponse_Frame_StringPoints)(nil),
	}
}

func _ReadResponse_Frame_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadResponse_Frame)
	// data
	switch x := m.Data.(type) {
	case *ReadResponse_Frame_Group:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Group); err != nil {
			return err
		}
	case *ReadResponse_Frame_Series:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Series); err != nil {
			return err
		}
	case *ReadResponse_Frame_FloatPoints:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FloatPoints); err != nil {
			return err
		}
	case *ReadResponse_Frame_IntegerPoints:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntegerPoints); err != nil {
			return err
		}
	case *ReadResponse_Frame_UnsignedPoints:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UnsignedPoints); err != nil {
			return err
		}
	case *ReadResponse_Frame_BooleanPoints:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BooleanPoints); err != nil {
			return err
		}
	case *ReadResponse_Frame_StringPoints:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringPoints); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("readResponse_Frame.Data has unexpected type %T", x)
	}
	return nil
}

func _ReadResponse_Frame_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadResponse_Frame)
	switch tag {
	case 7: // data.group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_GroupFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_Group{msg}
		return true, err
	case 1: // data.series
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_SeriesFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_Series{msg}
		return true, err
	case 2: // data.float_points
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_FloatPointsFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_FloatPoints{msg}
		return true, err
	case 3: // data.integer_points
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_IntegerPointsFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_IntegerPoints{msg}
		return true, err
	case 4: // data.unsigned_points
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_UnsignedPointsFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_UnsignedPoints{msg}
		return true, err
	case 5: // data.boolean_points
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_BooleanPointsFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_BooleanPoints{msg}
		return true, err
	case 6: // data.string_points
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadResponse_StringPointsFrame)
		err := b.DecodeMessage(msg)
		m.Data = &ReadResponse_Frame_StringPoints{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ReadResponse_Frame_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadResponse_Frame)
	// data
	switch x := m.Data.(type) {
	case *ReadResponse_Frame_Group:
		s := proto.Size(x.Group)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_Series:
		s := proto.Size(x.Series)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_FloatPoints:
		s := proto.Size(x.FloatPoints)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_IntegerPoints:
		s := proto.Size(x.IntegerPoints)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_UnsignedPoints:
		s := proto.Size(x.UnsignedPoints)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_BooleanPoints:
		s := proto.Size(x.BooleanPoints)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadResponse_Frame_StringPoints:
		s := proto.Size(x.StringPoints)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ReadResponse_GroupFrame struct {
	// TagKeys
	TagKeys [][]byte `protobuf:"bytes,1,rep,name=tag_keys,json=tagKeys" json:"tag_keys,omitempty"`
	// PartitionKeyVals is the values of the partition key for this group, order matching ReadRequest.GroupKeys
	PartitionKeyVals     [][]byte `protobuf:"bytes,2,rep,name=partition_key_vals,json=partitionKeyVals" json:"partition_key_vals,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadResponse_GroupFrame) Reset()         { *m = ReadResponse_GroupFrame{} }
func (m *ReadResponse_GroupFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_GroupFrame) ProtoMessage()    {}
func (*ReadResponse_GroupFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 1}
}
func (m *ReadResponse_GroupFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_GroupFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_GroupFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_GroupFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_GroupFrame.Merge(dst, src)
}
func (m *ReadResponse_GroupFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_GroupFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_GroupFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_GroupFrame proto.InternalMessageInfo

type ReadResponse_SeriesFrame struct {
	Tags                 []Tag                 `protobuf:"bytes,1,rep,name=tags" json:"tags"`
	DataType             ReadResponse_DataType `protobuf:"varint,2,opt,name=data_type,json=dataType,proto3,enum=influxdata.platform.storage.ReadResponse_DataType" json:"data_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ReadResponse_SeriesFrame) Reset()         { *m = ReadResponse_SeriesFrame{} }
func (m *ReadResponse_SeriesFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_SeriesFrame) ProtoMessage()    {}
func (*ReadResponse_SeriesFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 2}
}
func (m *ReadResponse_SeriesFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_SeriesFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_SeriesFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_SeriesFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_SeriesFrame.Merge(dst, src)
}
func (m *ReadResponse_SeriesFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_SeriesFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_SeriesFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_SeriesFrame proto.InternalMessageInfo

type ReadResponse_FloatPointsFrame struct {
	Timestamps           []int64   `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values               []float64 `protobuf:"fixed64,2,rep,packed,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ReadResponse_FloatPointsFrame) Reset()         { *m = ReadResponse_FloatPointsFrame{} }
func (m *ReadResponse_FloatPointsFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_FloatPointsFrame) ProtoMessage()    {}
func (*ReadResponse_FloatPointsFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 3}
}
func (m *ReadResponse_FloatPointsFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_FloatPointsFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_FloatPointsFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_FloatPointsFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_FloatPointsFrame.Merge(dst, src)
}
func (m *ReadResponse_FloatPointsFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_FloatPointsFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_FloatPointsFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_FloatPointsFrame proto.InternalMessageInfo

type ReadResponse_IntegerPointsFrame struct {
	Timestamps           []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values               []int64  `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadResponse_IntegerPointsFrame) Reset()         { *m = ReadResponse_IntegerPointsFrame{} }
func (m *ReadResponse_IntegerPointsFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_IntegerPointsFrame) ProtoMessage()    {}
func (*ReadResponse_IntegerPointsFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 4}
}
func (m *ReadResponse_IntegerPointsFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_IntegerPointsFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_IntegerPointsFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_IntegerPointsFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_IntegerPointsFrame.Merge(dst, src)
}
func (m *ReadResponse_IntegerPointsFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_IntegerPointsFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_IntegerPointsFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_IntegerPointsFrame proto.InternalMessageInfo

type ReadResponse_UnsignedPointsFrame struct {
	Timestamps           []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values               []uint64 `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadResponse_UnsignedPointsFrame) Reset()         { *m = ReadResponse_UnsignedPointsFrame{} }
func (m *ReadResponse_UnsignedPointsFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_UnsignedPointsFrame) ProtoMessage()    {}
func (*ReadResponse_UnsignedPointsFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 5}
}
func (m *ReadResponse_UnsignedPointsFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_UnsignedPointsFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_UnsignedPointsFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_UnsignedPointsFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_UnsignedPointsFrame.Merge(dst, src)
}
func (m *ReadResponse_UnsignedPointsFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_UnsignedPointsFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_UnsignedPointsFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_UnsignedPointsFrame proto.InternalMessageInfo

type ReadResponse_BooleanPointsFrame struct {
	Timestamps           []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values               []bool   `protobuf:"varint,2,rep,packed,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadResponse_BooleanPointsFrame) Reset()         { *m = ReadResponse_BooleanPointsFrame{} }
func (m *ReadResponse_BooleanPointsFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_BooleanPointsFrame) ProtoMessage()    {}
func (*ReadResponse_BooleanPointsFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 6}
}
func (m *ReadResponse_BooleanPointsFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_BooleanPointsFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_BooleanPointsFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_BooleanPointsFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_BooleanPointsFrame.Merge(dst, src)
}
func (m *ReadResponse_BooleanPointsFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_BooleanPointsFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_BooleanPointsFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_BooleanPointsFrame proto.InternalMessageInfo

type ReadResponse_StringPointsFrame struct {
	Timestamps           []int64  `protobuf:"fixed64,1,rep,packed,name=timestamps" json:"timestamps,omitempty"`
	Values               []string `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadResponse_StringPointsFrame) Reset()         { *m = ReadResponse_StringPointsFrame{} }
func (m *ReadResponse_StringPointsFrame) String() string { return proto.CompactTextString(m) }
func (*ReadResponse_StringPointsFrame) ProtoMessage()    {}
func (*ReadResponse_StringPointsFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{3, 7}
}
func (m *ReadResponse_StringPointsFrame) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadResponse_StringPointsFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadResponse_StringPointsFrame.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReadResponse_StringPointsFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadResponse_StringPointsFrame.Merge(dst, src)
}
func (m *ReadResponse_StringPointsFrame) XXX_Size() int {
	return m.Size()
}
func (m *ReadResponse_StringPointsFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadResponse_StringPointsFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ReadResponse_StringPointsFrame proto.InternalMessageInfo

type CapabilitiesResponse struct {
	Caps                 map[string]string `protobuf:"bytes,1,rep,name=caps" json:"caps,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CapabilitiesResponse) Reset()         { *m = CapabilitiesResponse{} }
func (m *CapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*CapabilitiesResponse) ProtoMessage()    {}
func (*CapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{4}
}
func (m *CapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CapabilitiesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapabilitiesResponse.Merge(dst, src)
}
func (m *CapabilitiesResponse) XXX_Size() int {
	return m.Size()
}
func (m *CapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CapabilitiesResponse proto.InternalMessageInfo

type HintsResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HintsResponse) Reset()         { *m = HintsResponse{} }
func (m *HintsResponse) String() string { return proto.CompactTextString(m) }
func (*HintsResponse) ProtoMessage()    {}
func (*HintsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{5}
}
func (m *HintsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HintsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HintsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *HintsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HintsResponse.Merge(dst, src)
}
func (m *HintsResponse) XXX_Size() int {
	return m.Size()
}
func (m *HintsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_HintsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_HintsResponse proto.InternalMessageInfo

// Specifies a continuous range of nanosecond timestamps.
type TimestampRange struct {
	// Start defines the inclusive lower bound.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// End defines the inclusive upper bound.
	End                  int64    `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampRange) Reset()         { *m = TimestampRange{} }
func (m *TimestampRange) String() string { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()    {}
func (*TimestampRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_common_01b6ac29b3fb8162, []int{6}
}
func (m *TimestampRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimestampRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimestampRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TimestampRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampRange.Merge(dst, src)
}
func (m *TimestampRange) XXX_Size() int {
	return m.Size()
}
func (m *TimestampRange) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampRange.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampRange proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ReadRequest)(nil), "influxdata.platform.storage.ReadRequest")
	proto.RegisterMapType((map[string]string)(nil), "influxdata.platform.storage.ReadRequest.TraceEntry")
	proto.RegisterType((*Aggregate)(nil), "influxdata.platform.storage.Aggregate")
	proto.RegisterType((*Tag)(nil), "influxdata.platform.storage.Tag")
	proto.RegisterType((*ReadResponse)(nil), "influxdata.platform.storage.ReadResponse")
	proto.RegisterType((*ReadResponse_Frame)(nil), "influxdata.platform.storage.ReadResponse.Frame")
	proto.RegisterType((*ReadResponse_GroupFrame)(nil), "influxdata.platform.storage.ReadResponse.GroupFrame")
	proto.RegisterType((*ReadResponse_SeriesFrame)(nil), "influxdata.platform.storage.ReadResponse.SeriesFrame")
	proto.RegisterType((*ReadResponse_FloatPointsFrame)(nil), "influxdata.platform.storage.ReadResponse.FloatPointsFrame")
	proto.RegisterType((*ReadResponse_IntegerPointsFrame)(nil), "influxdata.platform.storage.ReadResponse.IntegerPointsFrame")
	proto.RegisterType((*ReadResponse_UnsignedPointsFrame)(nil), "influxdata.platform.storage.ReadResponse.UnsignedPointsFrame")
	proto.RegisterType((*ReadResponse_BooleanPointsFrame)(nil), "influxdata.platform.storage.ReadResponse.BooleanPointsFrame")
	proto.RegisterType((*ReadResponse_StringPointsFrame)(nil), "influxdata.platform.storage.ReadResponse.StringPointsFrame")
	proto.RegisterType((*CapabilitiesResponse)(nil), "influxdata.platform.storage.CapabilitiesResponse")
	proto.RegisterMapType((map[string]string)(nil), "influxdata.platform.storage.CapabilitiesResponse.CapsEntry")
	proto.RegisterType((*HintsResponse)(nil), "influxdata.platform.storage.HintsResponse")
	proto.RegisterType((*TimestampRange)(nil), "influxdata.platform.storage.TimestampRange")
	proto.RegisterEnum("influxdata.platform.storage.ReadRequest_Group", ReadRequest_Group_name, ReadRequest_Group_value)
	proto.RegisterEnum("influxdata.platform.storage.ReadRequest_HintFlags", ReadRequest_HintFlags_name, ReadRequest_HintFlags_value)
	proto.RegisterEnum("influxdata.platform.storage.Aggregate_AggregateType", Aggregate_AggregateType_name, Aggregate_AggregateType_value)
	proto.RegisterEnum("influxdata.platform.storage.ReadResponse_FrameType", ReadResponse_FrameType_name, ReadResponse_FrameType_value)
	proto.RegisterEnum("influxdata.platform.storage.ReadResponse_DataType", ReadResponse_DataType_name, ReadResponse_DataType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Storage service

type StorageClient interface {
	// Read performs a read operation using the given ReadRequest
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Storage_ReadClient, error)
	// Capabilities returns a map of keys and values identifying the capabilities supported by the storage engine
	Capabilities(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*CapabilitiesResponse, error)
	Hints(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*HintsResponse, error)
}

type storageClient struct {
	cc *grpc.ClientConn
}

func NewStorageClient(cc *grpc.ClientConn) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (Storage_ReadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[0], "/influxdata.platform.storage.Storage/Read", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Storage_ReadClient interface {
	Recv() (*ReadResponse, error)
	grpc.ClientStream
}

type storageReadClient struct {
	grpc.ClientStream
}

func (x *storageReadClient) Recv() (*ReadResponse, error) {
	m := new(ReadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) Capabilities(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*CapabilitiesResponse, error) {
	out := new(CapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/influxdata.platform.storage.Storage/Capabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Hints(ctx context.Context, in *types.Empty, opts ...grpc.CallOption) (*HintsResponse, error) {
	out := new(HintsResponse)
	err := c.cc.Invoke(ctx, "/influxdata.platform.storage.Storage/Hints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Storage service

type StorageServer interface {
	// Read performs a read operation using the given ReadRequest
	Read(*ReadRequest, Storage_ReadServer) error
	// Capabilities returns a map of keys and values identifying the capabilities supported by the storage engine
	Capabilities(context.Context, *types.Empty) (*CapabilitiesResponse, error)
	Hints(context.Context, *types.Empty) (*HintsResponse, error)
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

func _Storage_Read_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StorageServer).Read(m, &storageReadServer{stream})
}

type Storage_ReadServer interface {
	Send(*ReadResponse) error
	grpc.ServerStream
}

type storageReadServer struct {
	grpc.ServerStream
}

func (x *storageReadServer) Send(m *ReadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Storage_Capabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(types.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Capabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/influxdata.platform.storage.Storage/Capabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Capabilities(ctx, req.(*types.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Hints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(types.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Hints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/influxdata.platform.storage.Storage/Hints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Hints(ctx, req.(*types.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "influxdata.platform.storage.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Capabilities",
			Handler:    _Storage_Capabilities_Handler,
		},
		{
			MethodName: "Hints",
			Handler:    _Storage_Hints_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Read",
			Handler:       _Storage_Read_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "storage_common.proto",
}

func (m *ReadRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintStorageCommon(dAtA, i, uint64(m.TimestampRange.Size()))
	n1, err := m.TimestampRange.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.Descending {
		dAtA[i] = 0x18
		i++
		if m.Descending {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.GroupKeys) > 0 {
		for _, s := range m.GroupKeys {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Predicate != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Predicate.Size()))
		n2, err := m.Predicate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.SeriesLimit != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.SeriesLimit))
	}
	if m.SeriesOffset != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.SeriesOffset))
	}
	if m.PointsLimit != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.PointsLimit))
	}
	if m.Aggregate != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Aggregate.Size()))
		n3, err := m.Aggregate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.Trace) > 0 {
		for k := range m.Trace {
			dAtA[i] = 0x52
			i++
			v := m.Trace[k]
			mapSize := 1 + len(k) + sovStorageCommon(uint64(len(k))) + 1 + len(v) + sovStorageCommon(uint64(len(v)))
			i = encodeVarintStorageCommon(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.Group != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Group))
	}
	if m.Hints != 0 {
		dAtA[i] = 0x65
		i++
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(m.Hints))
		i += 4
	}
	if m.ReadSource != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.ReadSource.Size()))
		n4, err := m.ReadSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *Aggregate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Aggregate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *Tag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tag) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *ReadResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Frames) > 0 {
		for _, msg := range m.Frames {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ReadResponse_Frame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_Frame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		nn5, err := m.Data.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	return i, nil
}

func (m *ReadResponse_Frame_Series) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Series != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Series.Size()))
		n6, err := m.Series.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *ReadResponse_Frame_FloatPoints) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.FloatPoints != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.FloatPoints.Size()))
		n7, err := m.FloatPoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *ReadResponse_Frame_IntegerPoints) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.IntegerPoints != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.IntegerPoints.Size()))
		n8, err := m.IntegerPoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *ReadResponse_Frame_UnsignedPoints) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.UnsignedPoints != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.UnsignedPoints.Size()))
		n9, err := m.UnsignedPoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *ReadResponse_Frame_BooleanPoints) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BooleanPoints != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.BooleanPoints.Size()))
		n10, err := m.BooleanPoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *ReadResponse_Frame_StringPoints) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StringPoints != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.StringPoints.Size()))
		n11, err := m.StringPoints.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *ReadResponse_Frame_Group) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Group != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Group.Size()))
		n12, err := m.Group.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *ReadResponse_GroupFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_GroupFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TagKeys) > 0 {
		for _, b := range m.TagKeys {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if len(m.PartitionKeyVals) > 0 {
		for _, b := range m.PartitionKeyVals {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *ReadResponse_SeriesFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_SeriesFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for _, msg := range m.Tags {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DataType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.DataType))
	}
	return i, nil
}

func (m *ReadResponse_FloatPointsFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_FloatPointsFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(num))
			i += 8
		}
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Values)*8))
		for _, num := range m.Values {
			f13 := math.Float64bits(float64(num))
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f13))
			i += 8
		}
	}
	return i, nil
}

func (m *ReadResponse_IntegerPointsFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_IntegerPointsFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(num))
			i += 8
		}
	}
	if len(m.Values) > 0 {
		dAtA15 := make([]byte, len(m.Values)*10)
		var j14 int
		for _, num1 := range m.Values {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(j14))
		i += copy(dAtA[i:], dAtA15[:j14])
	}
	return i, nil
}

func (m *ReadResponse_UnsignedPointsFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_UnsignedPointsFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(num))
			i += 8
		}
	}
	if len(m.Values) > 0 {
		dAtA17 := make([]byte, len(m.Values)*10)
		var j16 int
		for _, num := range m.Values {
			for num >= 1<<7 {
				dAtA17[j16] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j16++
			}
			dAtA17[j16] = uint8(num)
			j16++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(j16))
		i += copy(dAtA[i:], dAtA17[:j16])
	}
	return i, nil
}

func (m *ReadResponse_BooleanPointsFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_BooleanPointsFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(num))
			i += 8
		}
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Values)))
		for _, b := range m.Values {
			if b {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	return i, nil
}

func (m *ReadResponse_StringPointsFrame) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadResponse_StringPointsFrame) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(len(m.Timestamps)*8))
		for _, num := range m.Timestamps {
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(num))
			i += 8
		}
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *CapabilitiesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CapabilitiesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Caps) > 0 {
		for k := range m.Caps {
			dAtA[i] = 0xa
			i++
			v := m.Caps[k]
			mapSize := 1 + len(k) + sovStorageCommon(uint64(len(k))) + 1 + len(v) + sovStorageCommon(uint64(len(v)))
			i = encodeVarintStorageCommon(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintStorageCommon(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *HintsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HintsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TimestampRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimestampRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Start != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.Start))
	}
	if m.End != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStorageCommon(dAtA, i, uint64(m.End))
	}
	return i, nil
}

func encodeVarintStorageCommon(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ReadRequest) Size() (n int) {
	var l int
	_ = l
	l = m.TimestampRange.Size()
	n += 1 + l + sovStorageCommon(uint64(l))
	if m.Descending {
		n += 2
	}
	if len(m.GroupKeys) > 0 {
		for _, s := range m.GroupKeys {
			l = len(s)
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	if m.Predicate != nil {
		l = m.Predicate.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	if m.SeriesLimit != 0 {
		n += 1 + sovStorageCommon(uint64(m.SeriesLimit))
	}
	if m.SeriesOffset != 0 {
		n += 1 + sovStorageCommon(uint64(m.SeriesOffset))
	}
	if m.PointsLimit != 0 {
		n += 1 + sovStorageCommon(uint64(m.PointsLimit))
	}
	if m.Aggregate != nil {
		l = m.Aggregate.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	if len(m.Trace) > 0 {
		for k, v := range m.Trace {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovStorageCommon(uint64(len(k))) + 1 + len(v) + sovStorageCommon(uint64(len(v)))
			n += mapEntrySize + 1 + sovStorageCommon(uint64(mapEntrySize))
		}
	}
	if m.Group != 0 {
		n += 1 + sovStorageCommon(uint64(m.Group))
	}
	if m.Hints != 0 {
		n += 5
	}
	if m.ReadSource != nil {
		l = m.ReadSource.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}

func (m *Aggregate) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovStorageCommon(uint64(m.Type))
	}
	return n
}

func (m *Tag) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}

func (m *ReadResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Frames) > 0 {
		for _, e := range m.Frames {
			l = e.Size()
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	return n
}

func (m *ReadResponse_Frame) Size() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *ReadResponse_Frame_Series) Size() (n int) {
	var l int
	_ = l
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_FloatPoints) Size() (n int) {
	var l int
	_ = l
	if m.FloatPoints != nil {
		l = m.FloatPoints.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_IntegerPoints) Size() (n int) {
	var l int
	_ = l
	if m.IntegerPoints != nil {
		l = m.IntegerPoints.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_UnsignedPoints) Size() (n int) {
	var l int
	_ = l
	if m.UnsignedPoints != nil {
		l = m.UnsignedPoints.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_BooleanPoints) Size() (n int) {
	var l int
	_ = l
	if m.BooleanPoints != nil {
		l = m.BooleanPoints.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_StringPoints) Size() (n int) {
	var l int
	_ = l
	if m.StringPoints != nil {
		l = m.StringPoints.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_Frame_Group) Size() (n int) {
	var l int
	_ = l
	if m.Group != nil {
		l = m.Group.Size()
		n += 1 + l + sovStorageCommon(uint64(l))
	}
	return n
}
func (m *ReadResponse_GroupFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.TagKeys) > 0 {
		for _, b := range m.TagKeys {
			l = len(b)
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	if len(m.PartitionKeyVals) > 0 {
		for _, b := range m.PartitionKeyVals {
			l = len(b)
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	return n
}

func (m *ReadResponse_SeriesFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			l = e.Size()
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	if m.DataType != 0 {
		n += 1 + sovStorageCommon(uint64(m.DataType))
	}
	return n
}

func (m *ReadResponse_FloatPointsFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Values)*8)) + len(m.Values)*8
	}
	return n
}

func (m *ReadResponse_IntegerPointsFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		l = 0
		for _, e := range m.Values {
			l += sovStorageCommon(uint64(e))
		}
		n += 1 + sovStorageCommon(uint64(l)) + l
	}
	return n
}

func (m *ReadResponse_UnsignedPointsFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		l = 0
		for _, e := range m.Values {
			l += sovStorageCommon(uint64(e))
		}
		n += 1 + sovStorageCommon(uint64(l)) + l
	}
	return n
}

func (m *ReadResponse_BooleanPointsFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Values))) + len(m.Values)*1
	}
	return n
}

func (m *ReadResponse_StringPointsFrame) Size() (n int) {
	var l int
	_ = l
	if len(m.Timestamps) > 0 {
		n += 1 + sovStorageCommon(uint64(len(m.Timestamps)*8)) + len(m.Timestamps)*8
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovStorageCommon(uint64(l))
		}
	}
	return n
}

func (m *CapabilitiesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Caps) > 0 {
		for k, v := range m.Caps {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovStorageCommon(uint64(len(k))) + 1 + len(v) + sovStorageCommon(uint64(len(v)))
			n += mapEntrySize + 1 + sovStorageCommon(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *HintsResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TimestampRange) Size() (n int) {
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovStorageCommon(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovStorageCommon(uint64(m.End))
	}
	return n
}

func sovStorageCommon(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStorageCommon(x uint64) (n int) {
	return sovStorageCommon(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ReadRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TimestampRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Descending", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Descending = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupKeys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupKeys = append(m.GroupKeys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Predicate == nil {
				m.Predicate = &Predicate{}
			}
			if err := m.Predicate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeriesLimit", wireType)
			}
			m.SeriesLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeriesLimit |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeriesOffset", wireType)
			}
			m.SeriesOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeriesOffset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PointsLimit", wireType)
			}
			m.PointsLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PointsLimit |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Aggregate == nil {
				m.Aggregate = &Aggregate{}
			}
			if err := m.Aggregate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Trace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Trace == nil {
				m.Trace = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthStorageCommon
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthStorageCommon
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStorageCommon(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStorageCommon
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Trace[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (ReadRequest_Group(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			m.Hints = 0
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			m.Hints = HintFlags(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadSource == nil {
				m.ReadSource = &types.Any{}
			}
			if err := m.ReadSource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Aggregate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Aggregate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Aggregate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Aggregate_AggregateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Frames", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Frames = append(m.Frames, ReadResponse_Frame{})
			if err := m.Frames[len(m.Frames)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_Frame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Frame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Frame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_SeriesFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_Series{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FloatPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_FloatPointsFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_FloatPoints{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntegerPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_IntegerPointsFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_IntegerPoints{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnsignedPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_UnsignedPointsFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_UnsignedPoints{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BooleanPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_BooleanPointsFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_BooleanPoints{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_StringPointsFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_StringPoints{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ReadResponse_GroupFrame{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &ReadResponse_Frame_Group{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_GroupFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagKeys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TagKeys = append(m.TagKeys, make([]byte, postIndex-iNdEx))
			copy(m.TagKeys[len(m.TagKeys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionKeyVals", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PartitionKeyVals = append(m.PartitionKeyVals, make([]byte, postIndex-iNdEx))
			copy(m.PartitionKeyVals[len(m.PartitionKeyVals)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_SeriesFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, Tag{})
			if err := m.Tags[len(m.Tags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataType", wireType)
			}
			m.DataType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataType |= (ReadResponse_DataType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_FloatPointsFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FloatPointsFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FloatPointsFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.Values = append(m.Values, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.Values = append(m.Values, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_IntegerPointsFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntegerPointsFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntegerPointsFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_UnsignedPointsFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsignedPointsFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsignedPointsFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_BooleanPointsFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BooleanPointsFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BooleanPointsFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Values = append(m.Values, bool(v != 0))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Values = append(m.Values, bool(v != 0))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadResponse_StringPointsFrame) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringPointsFrame: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringPointsFrame: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v int64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.Timestamps = append(m.Timestamps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStorageCommon
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.Timestamps = append(m.Timestamps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CapabilitiesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CapabilitiesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CapabilitiesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Caps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStorageCommon
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Caps == nil {
				m.Caps = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthStorageCommon
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStorageCommon
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthStorageCommon
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStorageCommon(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStorageCommon
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Caps[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HintsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HintsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HintsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimestampRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimestampRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimestampRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStorageCommon(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStorageCommon
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStorageCommon(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStorageCommon
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStorageCommon
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStorageCommon
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStorageCommon
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStorageCommon(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStorageCommon = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStorageCommon   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("storage_common.proto", fileDescriptor_storage_common_01b6ac29b3fb8162)
}

var fileDescriptor_storage_common_01b6ac29b3fb8162 = []byte{
	// 1539 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x57, 0x5f, 0x8f, 0x2a, 0x49,
	0x15, 0xa7, 0xf9, 0xcf, 0xe1, 0xcf, 0xf4, 0xad, 0xc5, 0x09, 0xdb, 0xd7, 0x85, 0x5e, 0x62, 0x36,
	0xa8, 0x2b, 0xa3, 0xec, 0x6e, 0xbc, 0xb9, 0xea, 0x03, 0xcc, 0x70, 0x07, 0x9c, 0x19, 0x98, 0x14,
	0x8c, 0x71, 0x4d, 0x0c, 0xa9, 0x81, 0xa2, 0xb7, 0xb3, 0x4d, 0x77, 0xdb, 0xdd, 0x6c, 0x86, 0xc4,
	0x77, 0x37, 0x3c, 0x5d, 0x5f, 0x4d, 0x48, 0x4c, 0x7c, 0xf4, 0xdd, 0xcf, 0x70, 0xdf, 0xf4, 0x13,
	0x10, 0xc5, 0x0f, 0x61, 0xe2, 0x93, 0xa9, 0xaa, 0x6e, 0x68, 0x66, 0xae, 0x13, 0x78, 0xab, 0x3a,
	0x7f, 0x7e, 0xbf, 0x53, 0xa7, 0xcf, 0x39, 0x55, 0x0d, 0x45, 0xd7, 0xb3, 0x1c, 0xa2, 0xd1, 0xd1,
	0xd8, 0x9a, 0xcd, 0x2c, 0xb3, 0x6e, 0x3b, 0x96, 0x67, 0xa1, 0x97, 0xba, 0x39, 0x35, 0xe6, 0x0f,
	0x13, 0xe2, 0x91, 0xba, 0x6d, 0x10, 0x6f, 0x6a, 0x39, 0xb3, 0xba, 0x6f, 0xa9, 0x14, 0x35, 0x4b,
	0xb3, 0xb8, 0xdd, 0x19, 0x5b, 0x09, 0x17, 0xe5, 0xa5, 0x66, 0x59, 0x9a, 0x41, 0xcf, 0xf8, 0xee,
	0x7e, 0x3e, 0x3d, 0xa3, 0x33, 0xdb, 0x5b, 0xf8, 0xca, 0x0f, 0x1f, 0x2b, 0x89, 0x19, 0xa8, 0x4e,
	0x6c, 0x87, 0x4e, 0xf4, 0x31, 0xf1, 0xa8, 0x10, 0x54, 0xff, 0x93, 0x86, 0x2c, 0xa6, 0x64, 0x82,
	0xe9, 0xef, 0xe6, 0xd4, 0xf5, 0x90, 0x01, 0x27, 0x9e, 0x3e, 0xa3, 0xae, 0x47, 0x66, 0xf6, 0xc8,
	0x21, 0xa6, 0x46, 0x4b, 0x51, 0x55, 0xaa, 0x65, 0x1b, 0x3f, 0xac, 0x3f, 0x13, 0x65, 0x7d, 0x18,
	0xf8, 0x60, 0xe6, 0xd2, 0x3a, 0x7d, 0xb7, 0xae, 0x44, 0x36, 0xeb, 0x4a, 0x61, 0x5f, 0x8e, 0x0b,
	0xde, 0xde, 0x1e, 0x95, 0x01, 0x26, 0xd4, 0x1d, 0x53, 0x73, 0xa2, 0x9b, 0x5a, 0x29, 0xa6, 0x4a,
	0xb5, 0x34, 0x0e, 0x49, 0xd0, 0xa7, 0x00, 0x9a, 0x63, 0xcd, 0xed, 0xd1, 0xd7, 0x74, 0xe1, 0x96,
	0xe2, 0x6a, 0xac, 0x96, 0x69, 0xe5, 0x37, 0xeb, 0x4a, 0xe6, 0x92, 0x49, 0xaf, 0xe8, 0xc2, 0xc5,
	0x19, 0x2d, 0x58, 0xa2, 0x0b, 0xc8, 0x6c, 0x8f, 0x57, 0x4a, 0xf0, 0xa8, 0x3f, 0x79, 0x36, 0xea,
	0xdb, 0xc0, 0x1a, 0xef, 0x1c, 0x51, 0x03, 0x72, 0x2e, 0x75, 0x74, 0xea, 0x8e, 0x0c, 0x7d, 0xa6,
	0x7b, 0xa5, 0xa4, 0x2a, 0xd5, 0x62, 0xad, 0x93, 0xcd, 0xba, 0x92, 0x1d, 0x70, 0xf9, 0x35, 0x13,
	0xe3, 0xac, 0xbb, 0xdb, 0xa0, 0x2f, 0x20, 0xef, 0xfb, 0x58, 0xd3, 0xa9, 0x4b, 0xbd, 0x52, 0x8a,
	0x3b, 0xc9, 0x9b, 0x75, 0x25, 0x27, 0x9c, 0xfa, 0x5c, 0x8e, 0x7d, 0x68, 0xb1, 0x63, 0x54, 0xb6,
	0xa5, 0x9b, 0x5e, 0x40, 0x95, 0xde, 0x51, 0xdd, 0x72, 0xb9, 0x4f, 0x65, 0xef, 0x36, 0xec, 0x90,
	0x44, 0xd3, 0x1c, 0xaa, 0xb1, 0x43, 0x66, 0x0e, 0x38, 0x64, 0x33, 0xb0, 0xc6, 0x3b, 0x47, 0x34,
	0x84, 0x84, 0xe7, 0x90, 0x31, 0x2d, 0x81, 0x1a, 0xab, 0x65, 0x1b, 0x9f, 0x3d, 0x8b, 0x10, 0xaa,
	0x8f, 0xfa, 0x90, 0x79, 0xb5, 0x4d, 0xcf, 0x59, 0xb4, 0x32, 0x9b, 0x75, 0x25, 0xc1, 0xf7, 0x58,
	0x80, 0xa1, 0x0b, 0x48, 0xf0, 0xaf, 0x51, 0xca, 0xaa, 0x52, 0xad, 0xd0, 0xa8, 0x1f, 0x8c, 0xca,
	0x3f, 0x27, 0x16, 0xce, 0xe8, 0x53, 0x48, 0x7c, 0xc5, 0xce, 0x5b, 0xca, 0xa9, 0x52, 0x2d, 0xd5,
	0x3a, 0x65, 0x34, 0x1d, 0x26, 0xf8, 0xef, 0xba, 0x92, 0x61, 0x8b, 0x37, 0x06, 0xd1, 0x5c, 0x2c,
	0x8c, 0x50, 0x1b, 0xb2, 0x0e, 0x25, 0x93, 0x91, 0x6b, 0xcd, 0x9d, 0x31, 0x2d, 0xe5, 0x79, 0x46,
	0x8a, 0x75, 0xd1, 0x02, 0xf5, 0xa0, 0x05, 0xea, 0x4d, 0x73, 0xd1, 0x2a, 0x6c, 0xd6, 0x15, 0x60,
	0xb4, 0x03, 0x6e, 0x8b, 0xc1, 0xd9, 0xae, 0x95, 0x57, 0x00, 0xbb, 0xa3, 0x21, 0x19, 0x62, 0x5f,
	0xd3, 0x45, 0x49, 0x52, 0xa5, 0x5a, 0x06, 0xb3, 0x25, 0x2a, 0x42, 0xe2, 0x1b, 0x62, 0xcc, 0x45,
	0x37, 0x64, 0xb0, 0xd8, 0xbc, 0x8e, 0xbe, 0x92, 0xaa, 0x7f, 0x90, 0x20, 0xc1, 0xe3, 0x47, 0x1f,
	0x01, 0x5c, 0xe2, 0xfe, 0xdd, 0xed, 0xa8, 0xd7, 0xef, 0xb5, 0xe5, 0x88, 0x92, 0x5f, 0xae, 0x54,
	0x51, 0xa9, 0x3d, 0xcb, 0xa4, 0xe8, 0x25, 0x64, 0x84, 0xba, 0x79, 0x7d, 0x2d, 0x4b, 0x4a, 0x6e,
	0xb9, 0x52, 0xd3, 0x5c, 0xdb, 0x34, 0x0c, 0xf4, 0x21, 0xa4, 0x85, 0xb2, 0xf5, 0xa5, 0x1c, 0x55,
	0xb2, 0xcb, 0x95, 0x9a, 0xe2, 0xba, 0xd6, 0x02, 0x7d, 0x0c, 0x39, 0xa1, 0x6a, 0xff, 0xfa, 0xbc,
	0x7d, 0x3b, 0x94, 0x63, 0xca, 0xc9, 0x72, 0xa5, 0x66, 0xb9, 0xba, 0xfd, 0x30, 0xa6, 0xb6, 0xa7,
	0xc4, 0xbf, 0xfd, 0x4b, 0x39, 0x52, 0xfd, 0xab, 0x04, 0xbb, 0xfc, 0x30, 0xba, 0x4e, 0xb7, 0x37,
	0x0c, 0x82, 0xe1, 0x74, 0x4c, 0xcb, 0x63, 0xf9, 0x1e, 0x14, 0x7c, 0xe5, 0xe8, 0xb6, 0xdf, 0xed,
	0x0d, 0x07, 0xb2, 0xa4, 0xc8, 0xcb, 0x95, 0x9a, 0x13, 0x16, 0xa2, 0xfa, 0xc2, 0x56, 0x83, 0x36,
	0xee, 0xb6, 0x07, 0x72, 0x34, 0x6c, 0x25, 0x2a, 0x1b, 0x9d, 0x41, 0x91, 0x5b, 0x0d, 0xce, 0x3b,
	0xed, 0x9b, 0x26, 0x3b, 0xdd, 0x68, 0xd8, 0xbd, 0x69, 0xcb, 0x71, 0xe5, 0x3b, 0xcb, 0x95, 0xfa,
	0x82, 0xd9, 0x0e, 0xc6, 0x5f, 0xd1, 0x19, 0x69, 0x1a, 0x06, 0x9b, 0x07, 0x7e, 0xb4, 0x7f, 0x97,
	0x20, 0xb3, 0xad, 0x4d, 0xd4, 0x81, 0xb8, 0xb7, 0xb0, 0x29, 0x4f, 0x79, 0xa1, 0xf1, 0xf9, 0x61,
	0x15, 0xbd, 0x5b, 0x0d, 0x17, 0x36, 0xc5, 0x1c, 0xa1, 0xfa, 0x00, 0xf9, 0x3d, 0x31, 0xaa, 0x40,
	0xdc, 0xcf, 0x01, 0x8f, 0x67, 0x4f, 0xc9, 0x93, 0xf1, 0x11, 0xc4, 0x06, 0x77, 0x37, 0xb2, 0xa4,
	0x14, 0x97, 0x2b, 0x55, 0xde, 0xd3, 0x0f, 0xe6, 0x33, 0xf4, 0x31, 0x24, 0xce, 0xfb, 0x77, 0xbd,
	0xa1, 0x1c, 0x55, 0x4e, 0x97, 0x2b, 0x15, 0xed, 0x19, 0x9c, 0x5b, 0x73, 0x33, 0xc8, 0xff, 0x8f,
	0x20, 0x36, 0x24, 0x5a, 0xb8, 0x78, 0x72, 0xef, 0x29, 0x9e, 0x9c, 0x5f, 0x3c, 0xd5, 0x3f, 0x16,
	0x20, 0x27, 0x9a, 0xc0, 0xb5, 0x2d, 0xd3, 0xa5, 0xe8, 0x06, 0x92, 0x53, 0x87, 0xcc, 0xa8, 0x5b,
	0x92, 0x78, 0x57, 0x9e, 0x1d, 0xd0, 0x3f, 0xc2, 0xb5, 0xfe, 0x86, 0xf9, 0xb5, 0xe2, 0x6c, 0xec,
	0x62, 0x1f, 0x44, 0xf9, 0x36, 0x09, 0x09, 0x2e, 0x47, 0x7d, 0x48, 0x8a, 0xb9, 0xc3, 0x83, 0xca,
	0x36, 0xbe, 0x38, 0x1c, 0x58, 0x7c, 0x63, 0x0e, 0xd3, 0x89, 0x60, 0x1f, 0x06, 0xd9, 0x90, 0x9b,
	0x1a, 0x16, 0xf1, 0x46, 0x62, 0x32, 0xf9, 0x57, 0xc4, 0xeb, 0x23, 0xe2, 0x65, 0xde, 0xa2, 0xca,
	0x44, 0xe8, 0x7c, 0xe8, 0x85, 0xa4, 0x9d, 0x08, 0xce, 0x4e, 0x77, 0x5b, 0xf4, 0x00, 0x05, 0xdd,
	0xf4, 0xa8, 0x46, 0x9d, 0x80, 0x33, 0xc6, 0x39, 0x7f, 0x7e, 0x38, 0x67, 0x57, 0xf8, 0x87, 0x59,
	0x5f, 0x6c, 0xd6, 0x95, 0xfc, 0x9e, 0xbc, 0x13, 0xc1, 0x79, 0x3d, 0x2c, 0x40, 0xbf, 0x87, 0x93,
	0xb9, 0xe9, 0xea, 0x9a, 0x49, 0x27, 0x01, 0x75, 0x9c, 0x53, 0xff, 0xe2, 0x70, 0xea, 0x3b, 0x1f,
	0x20, 0xcc, 0x8d, 0xd8, 0xfd, 0xb8, 0xaf, 0xe8, 0x44, 0x70, 0x61, 0xbe, 0x27, 0x61, 0xe7, 0xbe,
	0xb7, 0x2c, 0x83, 0x12, 0x33, 0x20, 0x4f, 0x1c, 0x7b, 0xee, 0x96, 0xf0, 0x7f, 0x72, 0xee, 0x3d,
	0x39, 0x3b, 0xf7, 0x7d, 0x58, 0x80, 0x3c, 0xc8, 0xbb, 0x9e, 0xa3, 0x9b, 0x5a, 0x40, 0x9c, 0xe4,
	0xc4, 0x3f, 0x3b, 0xa2, 0x76, 0xb8, 0x7b, 0x98, 0x57, 0x5c, 0x88, 0x21, 0x71, 0x27, 0x82, 0x73,
	0x6e, 0x68, 0x8f, 0xae, 0x83, 0x2b, 0x24, 0xc5, 0xd9, 0x3e, 0x3f, 0x9c, 0x8d, 0xcf, 0xc3, 0xa0,
	0x50, 0x05, 0x48, 0x2b, 0x09, 0x71, 0xe6, 0xa9, 0x3c, 0x00, 0xec, 0xd4, 0xe8, 0x13, 0x48, 0x7b,
	0x44, 0x13, 0x6f, 0x0a, 0xd6, 0x69, 0xb9, 0x56, 0x76, 0xb3, 0xae, 0xa4, 0x86, 0x44, 0xe3, 0x2f,
	0x8a, 0x94, 0x27, 0x16, 0xa8, 0x05, 0xc8, 0x26, 0x8e, 0xa7, 0x7b, 0xba, 0x65, 0x32, 0xeb, 0xd1,
	0x37, 0xc4, 0x60, 0xb5, 0xce, 0x3c, 0x8a, 0x9b, 0x75, 0x45, 0xbe, 0x0d, 0xb4, 0x57, 0x74, 0xf1,
	0x2b, 0x62, 0xb8, 0x58, 0xb6, 0x1f, 0x49, 0x94, 0x3f, 0x49, 0x90, 0x0d, 0xf5, 0x10, 0x7a, 0x0d,
	0x71, 0x8f, 0x68, 0x41, 0x87, 0xab, 0xcf, 0x3f, 0xaa, 0x88, 0xe6, 0xb7, 0x34, 0xf7, 0x41, 0x7d,
	0xc8, 0x30, 0xc3, 0x11, 0x1f, 0x94, 0x51, 0x3e, 0x28, 0x1b, 0x87, 0xe7, 0xe7, 0x82, 0x78, 0x84,
	0x8f, 0xc9, 0xf4, 0xc4, 0x5f, 0x29, 0xbf, 0x04, 0xf9, 0x71, 0x23, 0xb2, 0x27, 0xd9, 0xf6, 0x91,
	0x26, 0xc2, 0x94, 0x71, 0x48, 0x82, 0x4e, 0x21, 0xc9, 0xc7, 0x97, 0x48, 0x84, 0x84, 0xfd, 0x9d,
	0x72, 0x0d, 0xe8, 0x69, 0x83, 0x1d, 0x89, 0x16, 0xdb, 0xa2, 0xdd, 0xc0, 0x07, 0xef, 0xe9, 0x99,
	0x23, 0xe1, 0xe2, 0xe1, 0xe0, 0x9e, 0x76, 0xc1, 0x91, 0x68, 0xe9, 0x2d, 0xda, 0x15, 0xbc, 0x78,
	0x52, 0xda, 0x47, 0x82, 0x65, 0x02, 0xb0, 0xea, 0x00, 0x32, 0x1c, 0xc0, 0xbf, 0xaa, 0x92, 0xfe,
	0x45, 0x1b, 0x51, 0x3e, 0x58, 0xae, 0xd4, 0x93, 0xad, 0xca, 0xbf, 0x6b, 0x2b, 0x90, 0xdc, 0xde,
	0xd7, 0xfb, 0x06, 0x22, 0x16, 0xff, 0x26, 0xfa, 0x9b, 0x04, 0xe9, 0xe0, 0x7b, 0xa3, 0xef, 0x42,
	0xe2, 0xcd, 0x75, 0xbf, 0x39, 0x94, 0x23, 0xca, 0x8b, 0xe5, 0x4a, 0xcd, 0x07, 0x0a, 0xfe, 0xe9,
	0x91, 0x0a, 0xa9, 0x6e, 0x6f, 0xd8, 0xbe, 0x6c, 0xe3, 0x00, 0x32, 0xd0, 0xfb, 0x9f, 0x13, 0x55,
	0x21, 0x7d, 0xd7, 0x1b, 0x74, 0x2f, 0x7b, 0xed, 0x0b, 0x39, 0x2a, 0xee, 0xc8, 0xc0, 0x24, 0xf8,
	0x46, 0x0c, 0xa5, 0xd5, 0xef, 0x5f, 0xb7, 0x9b, 0x3d, 0x39, 0xb6, 0x8f, 0xe2, 0xe7, 0x1d, 0x95,
	0x21, 0x39, 0x18, 0xe2, 0x6e, 0xef, 0x52, 0x8e, 0x2b, 0x68, 0xb9, 0x52, 0x0b, 0x81, 0x81, 0x48,
	0xa5, 0x1f, 0xf8, 0x9f, 0x25, 0x28, 0x9e, 0x13, 0x9b, 0xdc, 0xeb, 0x86, 0xee, 0xe9, 0xd4, 0xdd,
	0xde, 0x8d, 0x7d, 0x88, 0x8f, 0x89, 0x1d, 0xf4, 0xcd, 0xf3, 0x43, 0xe8, 0x7d, 0x00, 0x4c, 0xe8,
	0xf2, 0xc7, 0x1d, 0xe6, 0x40, 0xca, 0x4f, 0x21, 0xb3, 0x15, 0x1d, 0xf5, 0xde, 0x3b, 0x81, 0x3c,
	0x7f, 0x8d, 0x06, 0xc8, 0xd5, 0x57, 0xf0, 0xe8, 0x37, 0x87, 0x39, 0xbb, 0x1e, 0x71, 0x3c, 0x0e,
	0x18, 0xc3, 0x62, 0xc3, 0x48, 0xa8, 0x39, 0xe1, 0x80, 0x31, 0xcc, 0x96, 0x8d, 0xb7, 0x51, 0x48,
	0x0d, 0x44, 0xd0, 0xe8, 0xb7, 0x10, 0x67, 0xed, 0x8a, 0x6a, 0x87, 0x3e, 0x9a, 0x95, 0xef, 0x1f,
	0xdc, 0xfb, 0x3f, 0x96, 0xd0, 0x97, 0x90, 0x0b, 0xa7, 0x05, 0x9d, 0x3e, 0x79, 0x21, 0xb7, 0xd9,
	0x1f, 0xa4, 0xf2, 0x93, 0xa3, 0x33, 0x8b, 0xae, 0x40, 0x3c, 0xcf, 0xff, 0x2f, 0xe6, 0x0f, 0x9e,
	0xc5, 0xdc, 0x4b, 0x66, 0xab, 0xf2, 0xee, 0x5f, 0xe5, 0xc8, 0xbb, 0x4d, 0x59, 0xfa, 0xc7, 0xa6,
	0x2c, 0xfd, 0x73, 0x53, 0x96, 0xde, 0xfe, 0xbb, 0x1c, 0xf9, 0x0d, 0x9f, 0x7b, 0x6c, 0xec, 0xb9,
	0xf7, 0x49, 0x0e, 0xfe, 0xd9, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x62, 0x34, 0xad, 0x1c, 0x4b,
	0x0f, 0x00, 0x00,
}
