// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	scheme "github.com/openshift/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SriovOperatorConfigsGetter has a method to return a SriovOperatorConfigInterface.
// A group's client should implement this interface.
type SriovOperatorConfigsGetter interface {
	SriovOperatorConfigs(namespace string) SriovOperatorConfigInterface
}

// SriovOperatorConfigInterface has methods to work with SriovOperatorConfig resources.
type SriovOperatorConfigInterface interface {
	Create(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.CreateOptions) (*v1.SriovOperatorConfig, error)
	Update(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.UpdateOptions) (*v1.SriovOperatorConfig, error)
	UpdateStatus(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.UpdateOptions) (*v1.SriovOperatorConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.SriovOperatorConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.SriovOperatorConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovOperatorConfig, err error)
	SriovOperatorConfigExpansion
}

// sriovOperatorConfigs implements SriovOperatorConfigInterface
type sriovOperatorConfigs struct {
	client rest.Interface
	ns     string
}

// newSriovOperatorConfigs returns a SriovOperatorConfigs
func newSriovOperatorConfigs(c *SriovnetworkV1Client, namespace string) *sriovOperatorConfigs {
	return &sriovOperatorConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sriovOperatorConfig, and returns the corresponding sriovOperatorConfig object, and an error if there is any.
func (c *sriovOperatorConfigs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SriovOperatorConfigs that match those selectors.
func (c *sriovOperatorConfigs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SriovOperatorConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SriovOperatorConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sriovOperatorConfigs.
func (c *sriovOperatorConfigs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a sriovOperatorConfig and creates it.  Returns the server's representation of the sriovOperatorConfig, and an error, if there is any.
func (c *sriovOperatorConfigs) Create(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.CreateOptions) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a sriovOperatorConfig and updates it. Returns the server's representation of the sriovOperatorConfig, and an error, if there is any.
func (c *sriovOperatorConfigs) Update(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.UpdateOptions) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(sriovOperatorConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *sriovOperatorConfigs) UpdateStatus(ctx context.Context, sriovOperatorConfig *v1.SriovOperatorConfig, opts metav1.UpdateOptions) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(sriovOperatorConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovOperatorConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the sriovOperatorConfig and deletes it. Returns an error if one occurs.
func (c *sriovOperatorConfigs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sriovOperatorConfigs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched sriovOperatorConfig.
func (c *sriovOperatorConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovOperatorConfig, err error) {
	result = &v1.SriovOperatorConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sriovoperatorconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
