// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/sriov-network-operator/pkg/apis/sriovnetwork/v1"
	scheme "github.com/openshift/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SriovNetworkNodeStatesGetter has a method to return a SriovNetworkNodeStateInterface.
// A group's client should implement this interface.
type SriovNetworkNodeStatesGetter interface {
	SriovNetworkNodeStates(namespace string) SriovNetworkNodeStateInterface
}

// SriovNetworkNodeStateInterface has methods to work with SriovNetworkNodeState resources.
type SriovNetworkNodeStateInterface interface {
	Create(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.CreateOptions) (*v1.SriovNetworkNodeState, error)
	Update(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.UpdateOptions) (*v1.SriovNetworkNodeState, error)
	UpdateStatus(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.UpdateOptions) (*v1.SriovNetworkNodeState, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.SriovNetworkNodeState, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.SriovNetworkNodeStateList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovNetworkNodeState, err error)
	SriovNetworkNodeStateExpansion
}

// sriovNetworkNodeStates implements SriovNetworkNodeStateInterface
type sriovNetworkNodeStates struct {
	client rest.Interface
	ns     string
}

// newSriovNetworkNodeStates returns a SriovNetworkNodeStates
func newSriovNetworkNodeStates(c *SriovnetworkV1Client, namespace string) *sriovNetworkNodeStates {
	return &sriovNetworkNodeStates{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sriovNetworkNodeState, and returns the corresponding sriovNetworkNodeState object, and an error if there is any.
func (c *sriovNetworkNodeStates) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SriovNetworkNodeStates that match those selectors.
func (c *sriovNetworkNodeStates) List(ctx context.Context, opts metav1.ListOptions) (result *v1.SriovNetworkNodeStateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SriovNetworkNodeStateList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sriovNetworkNodeStates.
func (c *sriovNetworkNodeStates) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a sriovNetworkNodeState and creates it.  Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *sriovNetworkNodeStates) Create(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.CreateOptions) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodeState).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a sriovNetworkNodeState and updates it. Returns the server's representation of the sriovNetworkNodeState, and an error, if there is any.
func (c *sriovNetworkNodeStates) Update(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.UpdateOptions) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(sriovNetworkNodeState.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodeState).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *sriovNetworkNodeStates) UpdateStatus(ctx context.Context, sriovNetworkNodeState *v1.SriovNetworkNodeState, opts metav1.UpdateOptions) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(sriovNetworkNodeState.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sriovNetworkNodeState).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the sriovNetworkNodeState and deletes it. Returns an error if one occurs.
func (c *sriovNetworkNodeStates) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sriovNetworkNodeStates) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched sriovNetworkNodeState.
func (c *sriovNetworkNodeStates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.SriovNetworkNodeState, err error) {
	result = &v1.SriovNetworkNodeState{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sriovnetworknodestates").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
