// Copyright 2018 The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PodMonitorLister helps list PodMonitors.
type PodMonitorLister interface {
	// List lists all PodMonitors in the indexer.
	List(selector labels.Selector) (ret []*v1.PodMonitor, err error)
	// PodMonitors returns an object that can list and get PodMonitors.
	PodMonitors(namespace string) PodMonitorNamespaceLister
	PodMonitorListerExpansion
}

// podMonitorLister implements the PodMonitorLister interface.
type podMonitorLister struct {
	indexer cache.Indexer
}

// NewPodMonitorLister returns a new PodMonitorLister.
func NewPodMonitorLister(indexer cache.Indexer) PodMonitorLister {
	return &podMonitorLister{indexer: indexer}
}

// List lists all PodMonitors in the indexer.
func (s *podMonitorLister) List(selector labels.Selector) (ret []*v1.PodMonitor, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PodMonitor))
	})
	return ret, err
}

// PodMonitors returns an object that can list and get PodMonitors.
func (s *podMonitorLister) PodMonitors(namespace string) PodMonitorNamespaceLister {
	return podMonitorNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PodMonitorNamespaceLister helps list and get PodMonitors.
type PodMonitorNamespaceLister interface {
	// List lists all PodMonitors in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.PodMonitor, err error)
	// Get retrieves the PodMonitor from the indexer for a given namespace and name.
	Get(name string) (*v1.PodMonitor, error)
	PodMonitorNamespaceListerExpansion
}

// podMonitorNamespaceLister implements the PodMonitorNamespaceLister
// interface.
type podMonitorNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PodMonitors in the indexer for a given namespace.
func (s podMonitorNamespaceLister) List(selector labels.Selector) (ret []*v1.PodMonitor, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PodMonitor))
	})
	return ret, err
}

// Get retrieves the PodMonitor from the indexer for a given namespace and name.
func (s podMonitorNamespaceLister) Get(name string) (*v1.PodMonitor, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("podmonitor"), name)
	}
	return obj.(*v1.PodMonitor), nil
}
