/* Copyright © 2019 VMware, Inc. All Rights Reserved.
   SPDX-License-Identifier: BSD-2-Clause */

// Code generated. DO NOT EDIT.

/*
 * Data type definitions file for package: com.vmware.nsx_policy.model.
 * Includes binding types of a top level structures and enumerations.
 * Shared by client-side stubs and server-side skeletons to ensure type
 * compatibility.
 */

package model

import (
	"reflect"
	"github.com/vmware/vsphere-automation-sdk-go/runtime/bindings"
	"github.com/vmware/vsphere-automation-sdk-go/runtime/data"
)


// An ServiceEntry that represents an ALG protocol
type ALGTypeServiceEntry struct {
    // Possible values are: 
    //
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_ORACLE_TNS
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_FTP
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_SUN_RPC_TCP
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_SUN_RPC_UDP
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_MS_RPC_TCP
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_MS_RPC_UDP
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_NBNS_BROADCAST
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_NBDG_BROADCAST
    // * ALGTypeServiceEntry#ALGTypeServiceEntry_ALG_TFTP
    //
    //  The Application Layer Gateway (ALG) protocol. Please note, protocol NBNS_BROADCAST and NBDG_BROADCAST are deprecated. Please use UDP protocol and create L4 Port Set type of service instead.
	Alg *string
    // The destination_port cannot be empty and must be a single value. format: port-or-range
	DestinationPorts []string
	SourcePorts []string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IGMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ICMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ALGTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_L4PORTSETSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ETHERTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ALGTypeServiceEntry__TYPE_IDENTIFIER = "ALGTypeServiceEntry"
const ALGTypeServiceEntry_ALG_ORACLE_TNS = "ORACLE_TNS"
const ALGTypeServiceEntry_ALG_FTP = "FTP"
const ALGTypeServiceEntry_ALG_SUN_RPC_TCP = "SUN_RPC_TCP"
const ALGTypeServiceEntry_ALG_SUN_RPC_UDP = "SUN_RPC_UDP"
const ALGTypeServiceEntry_ALG_MS_RPC_TCP = "MS_RPC_TCP"
const ALGTypeServiceEntry_ALG_MS_RPC_UDP = "MS_RPC_UDP"
const ALGTypeServiceEntry_ALG_NBNS_BROADCAST = "NBNS_BROADCAST"
const ALGTypeServiceEntry_ALG_NBDG_BROADCAST = "NBDG_BROADCAST"
const ALGTypeServiceEntry_ALG_TFTP = "TFTP"

// Represents the space in which the policy is being defined.
type AbstractSpace struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * AbstractSpace#AbstractSpace_CONNECTIVITY_STRATEGY_WHITELIST
    // * AbstractSpace#AbstractSpace_CONNECTIVITY_STRATEGY_BLACKLIST
    // * AbstractSpace#AbstractSpace_CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING
    // * AbstractSpace#AbstractSpace_CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING
    // * AbstractSpace#AbstractSpace_CONNECTIVITY_STRATEGY_NONE
    //
    //  The connectivity strategy is deprecated. Use default layer3 rule, /infra/domains/default/security-policies/default-layer3-security-policy/rules/default-layer3-rule. This field indicates the default connectivity policy for the infra or tenant space WHITELIST - Adds a default drop rule. Administrator can then use \"allow\" rules (aka whitelist) to allow traffic between groups BLACKLIST - Adds a default allow rule. Admin can then use \"drop\" rules (aka blacklist) to block traffic between groups WHITELIST_ENABLE_LOGGING - Whitelising with logging enabled BLACKLIST_ENABLE_LOGGING - Blacklisting with logging enabled NONE - No default rules are added.
	ConnectivityStrategy *string
}
const AbstractSpace_CONNECTIVITY_STRATEGY_WHITELIST = "WHITELIST"
const AbstractSpace_CONNECTIVITY_STRATEGY_BLACKLIST = "BLACKLIST"
const AbstractSpace_CONNECTIVITY_STRATEGY_WHITELIST_ENABLE_LOGGING = "WHITELIST_ENABLE_LOGGING"
const AbstractSpace_CONNECTIVITY_STRATEGY_BLACKLIST_ENABLE_LOGGING = "BLACKLIST_ENABLE_LOGGING"
const AbstractSpace_CONNECTIVITY_STRATEGY_NONE = "NONE"

type AcceptableComponentVersion struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // List of component versions
	AcceptableVersions []string
    // Possible values are: 
    //
    // * AcceptableComponentVersion#AcceptableComponentVersion_COMPONENT_TYPE_HOST
    // * AcceptableComponentVersion#AcceptableComponentVersion_COMPONENT_TYPE_EDGE
    // * AcceptableComponentVersion#AcceptableComponentVersion_COMPONENT_TYPE_CCP
    // * AcceptableComponentVersion#AcceptableComponentVersion_COMPONENT_TYPE_MP
    //
    //  Node type
	ComponentType *string
}
const AcceptableComponentVersion_COMPONENT_TYPE_HOST = "HOST"
const AcceptableComponentVersion_COMPONENT_TYPE_EDGE = "EDGE"
const AcceptableComponentVersion_COMPONENT_TYPE_CCP = "CCP"
const AcceptableComponentVersion_COMPONENT_TYPE_MP = "MP"

type AcceptableComponentVersionList struct {
    // Acceptable version whitelist for different components
	Results []AcceptableComponentVersion
}

// Reaction Action is the action to take when the stipulated criteria specified in the event exist over the source. Some example actions include: - Notify Admin (or VMC's SRE) via email. - Populate a specific label with the IPSec VPN Session. - Remove the IPSec VPN Session from a specific label.
type Action struct {
    // Possible values are: 
    //
    // * Action#Action_RESOURCE_TYPE_PATCHRESOURCES
    // * Action#Action_RESOURCE_TYPE_SETFIELDS
    //
    //  Reaction Action resource type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const Action__TYPE_IDENTIFIER = "Action"
const Action_RESOURCE_TYPE_PATCHRESOURCES = "PatchResources"
const Action_RESOURCE_TYPE_SETFIELDS = "SetFields"

// Resources managed during restore process
type ActionableResource struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // A resource reference on which actions can be performed format: hostname-or-ip
	IpAddress *string
}

type ActionableResourceListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // List results
	Results []ActionableResource
}

// An identity source service that runs Microsoft Active Directory. The service allows selected user accounts defined in Active Directory to log into and access NSX-T.
type ActiveDirectoryIdentitySource struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * LdapIdentitySource#LdapIdentitySource_RESOURCE_TYPE_ACTIVEDIRECTORYIDENTITYSOURCE
    // * LdapIdentitySource#LdapIdentitySource_RESOURCE_TYPE_OPENLDAPIDENTITYSOURCE
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The subtree of the LDAP identity source to search when locating users and groups.
	BaseDn *string
    // The name of the authentication domain. When users log into NSX using an identity of the form \"user\\\\@domain\", NSX uses the domain portion to determine which LDAP identity source to use. For Active Directory, this domain name must match the domain of the Active Directory.
	DomainName *string
    // The list of LDAP servers that provide LDAP service for this identity source. Currently, only one LDAP server is supported.
	LdapServers []IdentitySourceLdapServer
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ActiveDirectoryIdentitySource__TYPE_IDENTIFIER = "ActiveDirectoryIdentitySource"

type AdvanceClusterRestoreInput struct {
    // Unique id of an instruction (as returned by the GET /restore/status call) for which input is to be provided
	Id *string
    // List of resources for which the instruction is applicable.
	Resources []SelectableResourceReference
}

type AdvanceClusterRestoreRequest struct {
    // List of instructions and their associated data
	Data []AdvanceClusterRestoreInput
}

// Aggregate of DNS forwarder statistics across enforcement points.
type AggregateDNSForwarderStatistics struct {
    // String path of the DNS forwarder intent.
	IntentPath *string
    // List of DNS forwarder statistics per enforcement point.
	StatisticsPerEnforcementPoint []*data.StructValue
}

// Aggregate of DNS forwarder status across enforcement points.
type AggregateDNSForwarderStatus struct {
    // String path of the DNS forwarder intent.
	IntentPath *string
    // List of DNS forwarder status per enforcement point.
	StatusPerEnforcementPoint []*data.StructValue
}

// Aggregate of IPSec VPN Session Statistics across Enforcement Points.
type AggregateIPSecVpnSessionStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of IPSec VPN Session Statistics per Enforcement Point.
	Results []*data.StructValue
}

// Aggregate of IPSec VPN Session Status across Enforcement Points.
type AggregateIPSecVpnSessionStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of IPSec VPN Session Status per Enforcement Point.
	Results []*data.StructValue
}

// Aggregate of L2VPN Session peer config across Enforcement Points.
type AggregateL2VPNSessionPeerConfig struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L2VPN Session peer config per Enforcement Point.
	Results []*data.StructValue
}

// Aggregate of L2VPN Session Statistics across Enforcement Points.
type AggregateL2VPNSessionStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L2VPN Session Statistics per Enforcement Point.
	Results []*data.StructValue
}

// Aggregate of L2VPN Session Status across Enforcement Points.
type AggregateL2VPNSessionStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L2VPN Session Status per Enforcement Point.
	Results []*data.StructValue
}

// Aggregate of L2Vpn peer config across Enforcement Points.
type AggregateL2VpnPeerConfig struct {
    // Policy path referencing the L2Vpn.
	L2vpnPath *string
    // List of L2Vpn peer config per Enforcement Point.
	L2vpnPeerConfigPerEnforcementPoint []*data.StructValue
}

// Aggregate of L2Vpn session remote mac across enforcement points.
type AggregateL2VpnSessionRemoteMac struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L2Vpn Session remote mac
	L2vpnSessionRemoteMacs []*data.StructValue
}

// Aggregate of L2Vpn Statistics across Enforcement Points.
type AggregateL2VpnStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L2Vpn Statistics per Enforcement Point.
	L2vpnStatisticsPerEnforcementPoint []*data.StructValue
}

// Aggregate of L3Vpn Statistics across Enforcement Points.
type AggregateL3VpnStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // List of L3Vpn Statistics per Enforcement Point.
	L3vpnStatisticsPerEnforcementPoint []*data.StructValue
}

// Aggregate of LBNodeUsageSummary across Enforcement Points.
type AggregateLBNodeUsageSummary struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBNodeUsageSummary list results.
	Results []LBNodeUsageSummary
}

// Paged Collection of LBPoolStatisticsPerEP
type AggregateLBPoolStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBPoolStatisticsPerEP list results.
	Results []*data.StructValue
}

// Paged Collection of LBPoolStatusPerEP
type AggregateLBPoolStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBPoolStatusPerEP list results.
	Results []*data.StructValue
}

// Paged Collection of LBServiceStatisticsPerEP
type AggregateLBServiceStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBServiceStatisticsPerEP list results.
	Results []*data.StructValue
}

// Paged Collection of LBServiceStatusPerEP
type AggregateLBServiceStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBServiceStatusPerEP list results.
	Results []*data.StructValue
}

// Aggregate of LBServiceUsagePerEP across Enforcement Points.
type AggregateLBServiceUsage struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBServiceUsagePerEP list results.
	Results []*data.StructValue
}

// Paged Collection of LBVirtualServerStatisticsPerEP
type AggregateLBVirtualServerStatistics struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBVirtualServerStatisticsPerEP list results.
	Results []*data.StructValue
}

// Paged Collection of LBVirtualServerStatusPerEP
type AggregateLBVirtualServerStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // LBVirtualServerStatusPerEP list results.
	Results []*data.StructValue
}

// Aggregate of DNS forwarder nslookup answer across enforcement points.
type AggregatePolicyDnsAnswer struct {
    // List of DNS forwarder nslookup answer per enforcement point.
	DnsAnswerPerEnforcementPoint []*data.StructValue
    // String path of the DNS forwarder intent.
	IntentPath *string
}

// Aggregate of PolicyRuntimeInfoPerEP across Enforcement Points.
type AggregatePolicyRuntimeInfo struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
}

type AggregatedDataCounter struct {
	RxBytes *DataCounter
	RxPackets *DataCounter
	TxBytes *DataCounter
	TxPackets *DataCounter
}

type AggregatedDataCounterEx struct {
	RxBytes *DataCounter
	RxPackets *DataCounter
	TxBytes *DataCounter
	TxPackets *DataCounter
	DroppedBySecurityPackets *PacketsDroppedBySecurity
	MacLearning *MacLearningCounters
}

type AggregatedLogicalRouterPortCounters struct {
    // Timestamp when the data was last updated; unset if data source has never updated the data. format: int64
	LastUpdateTimestamp *int64
	Rx *LogicalRouterPortCounters
	Tx *LogicalRouterPortCounters
}

// Detailed information about an API Error
type ApiError struct {
    // Further details about the error
	Details *string
    // A numeric error code format: int64
	ErrorCode *int64
    // Additional data about the error
	ErrorData *data.StructValue
    // A description of the error
	ErrorMessage *string
    // The module name where the error occurred
	ModuleName *string
    // Other errors related to this error
	RelatedErrors []RelatedApiError
}

// API Request Body is an Event Source that represents an API request body that is being reveived as part of an API. Supported Request Bodies are those received as part of a PATCH/PUT/POST request.
type ApiRequestBody struct {
    // Regex path representing a regex expression on resources. This regex is used to identify the request body(ies) that is/are the source of the Event. For instance: specifying \"Lb\* | /infra/tier-0s/vmc/ipsec-vpn-services/default\" as a source means that ANY resource starting with Lb or ANY resource with \"/infra/tier-0s/vmc/ipsec-vpn-services/default\" as path would be the source of the event in question.
	ResourcePointer *string
    // Possible values are: 
    //
    // * Source#Source_RESOURCE_TYPE_RESOURCEOPERATION
    // * Source#Source_RESOURCE_TYPE_APIREQUESTBODY
    //
    //  Event Source resource type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ApiRequestBody__TYPE_IDENTIFIER = "ApiRequestBody"

// Application is a collection of Tiers where every tier shares common Security and networking requirements. Application API exposes self service model of consumption.
type Application struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Path of the sites
	Sites []string
}

// Networking and Security policy for Application.
type ApplicationService struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Property containing attributes for Policy Application Service.
	Attributes []ApplicationServiceAttribute
    // Application Service template id using which Application Service will be created. This will be available under the application service templates.
	ServiceTemplateId *string
}

// Policy Application Service data holder
type ApplicationServiceAttribute struct {
    // Key value pair that will be used while deploying application service template.
	KeyValue *KeyValuePair
}

// A 'tier' is a set of workloads that share common networking and security services. Tiers provide a specific function for an application and are thus a collection of compute with their associated services.
type ApplicationTier struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * ApplicationTier#ApplicationTier_ACCESS_TYPE_PUBLIC
    // * ApplicationTier#ApplicationTier_ACCESS_TYPE_PRIVATE
    // * ApplicationTier#ApplicationTier_ACCESS_TYPE_SHARED
    //
    //  There are three kinds of Access Types supported for an Application. Public - Tier is accessible from external networks and its IP is picked up from public IP addresses from VHC configuration unless specified explicitly by user. Private - Tier is accessbile only within the application and its IP is picked up from private IP addresses from VHC configuration unless specified explicitly by user. Shared - Tier is accessible within the scope of VHC and its IP is picked up from private IP addresses from VHC configuration unless specified explicitly by user.
	AccessType *string
    // This represents the subnet that is associated with tier. If this is specified, size property is ignored. format: ip-cidr-block
	IpRange *string
    // Possible values are: 
    //
    // * ApplicationTier#ApplicationTier_SIZE_ONE
    // * ApplicationTier#ApplicationTier_SIZE_XXS
    // * ApplicationTier#ApplicationTier_SIZE_XS
    // * ApplicationTier#ApplicationTier_SIZE_S
    // * ApplicationTier#ApplicationTier_SIZE_M
    // * ApplicationTier#ApplicationTier_SIZE_L
    // * ApplicationTier#ApplicationTier_SIZE_XL
    // * ApplicationTier#ApplicationTier_SIZE_XXL
    // * ApplicationTier#ApplicationTier_SIZE_XXXL
    //
    //  ONE - 1 XXS - 8 XS - 16 S - 32 M - 64 L - 128 XL - 256 XXL - 512 XXXL - 1024
	Size *string
}
const ApplicationTier_ACCESS_TYPE_PUBLIC = "Public"
const ApplicationTier_ACCESS_TYPE_PRIVATE = "Private"
const ApplicationTier_ACCESS_TYPE_SHARED = "Shared"
const ApplicationTier_SIZE_ONE = "ONE"
const ApplicationTier_SIZE_XXS = "XXS"
const ApplicationTier_SIZE_XS = "XS"
const ApplicationTier_SIZE_S = "S"
const ApplicationTier_SIZE_M = "M"
const ApplicationTier_SIZE_L = "L"
const ApplicationTier_SIZE_XL = "XL"
const ApplicationTier_SIZE_XXL = "XXL"
const ApplicationTier_SIZE_XXXL = "XXXL"

type ArpHeader struct {
    // The destination IP address format: ipv4
	DstIp *string
    // Possible values are: 
    //
    // * ArpHeader#ArpHeader_OP_CODE_REQUEST
    // * ArpHeader#ArpHeader_OP_CODE_REPLY
    //
    //  This field specifies the nature of the Arp message being sent.
	OpCode *string
    // This field specifies the IP address of the sender. If omitted, the src_ip is set to 0.0.0.0. format: ipv4
	SrcIp *string
}
const ArpHeader_OP_CODE_REQUEST = "ARP_REQUEST"
const ArpHeader_OP_CODE_REPLY = "ARP_REPLY"

// Contains ARP snooping related configuration.
type ArpSnoopingConfig struct {
    // Number of arp snooped IP addresses Indicates the number of arp snooped IP addresses to be remembered per LogicalPort. Decreasing this value, will retain the latest bindings from the existing list of address bindings. Increasing this value will retain existing bindings and also learn any new address bindings discovered on the port until the new limit is reached. format: int32
	ArpBindingLimit *int64
    // Indicates whether ARP snooping is enabled
	ArpSnoopingEnabled *bool
}

// Attribute specific to a partner. There attributes are passed on to the partner appliance and is opaque to the NSX Manager. The Attributes used by the partner applicance.
type Attribute struct {
    // Possible values are: 
    //
    // * Attribute#Attribute_ATTRIBUTE_TYPE_IP_ADDRESS
    // * Attribute#Attribute_ATTRIBUTE_TYPE_PORT
    // * Attribute#Attribute_ATTRIBUTE_TYPE_PASSWORD
    // * Attribute#Attribute_ATTRIBUTE_TYPE_STRING
    // * Attribute#Attribute_ATTRIBUTE_TYPE_LONG
    // * Attribute#Attribute_ATTRIBUTE_TYPE_BOOLEAN
    //
    //  Attribute Type can be of any of the allowed enum type.
	AttributeType *string
    // Attribute display name string value.
	DisplayName *string
    // Attribute key string value.
	Key *string
    // Read only Attribute cannot be overdidden by service instance/deployment.
	ReadOnly *bool
    // Attribute value string value.
	Value *string
}
const Attribute_ATTRIBUTE_TYPE_IP_ADDRESS = "IP_ADDRESS"
const Attribute_ATTRIBUTE_TYPE_PORT = "PORT"
const Attribute_ATTRIBUTE_TYPE_PASSWORD = "PASSWORD"
const Attribute_ATTRIBUTE_TYPE_STRING = "STRING"
const Attribute_ATTRIBUTE_TYPE_LONG = "LONG"
const Attribute_ATTRIBUTE_TYPE_BOOLEAN = "BOOLEAN"

// Contains type specific properties of generic realized entity
type AttributeVal struct {
    // Possible values are: 
    //
    // * AttributeVal#AttributeVal_DATA_TYPE_STRING
    // * AttributeVal#AttributeVal_DATA_TYPE_DATE
    // * AttributeVal#AttributeVal_DATA_TYPE_INTEGER
    // * AttributeVal#AttributeVal_DATA_TYPE_BOOLEAN
    //
    //  Datatype of the property
	DataType *string
    // Attribute key
	Key *string
    // If attribute has a single value or collection of values
	Multivalue *bool
    // List of attribute values
	Values []string
}
const AttributeVal_DATA_TYPE_STRING = "STRING"
const AttributeVal_DATA_TYPE_DATE = "DATE"
const AttributeVal_DATA_TYPE_INTEGER = "INTEGER"
const AttributeVal_DATA_TYPE_BOOLEAN = "BOOLEAN"

// Represents X and Y axes of a graph. For a multi-graph, the same axes are shared by all the graphs.
type Axes struct {
    // Label for X axis of a graph
	XLabel *Label
    // Label for Y axis of a graph
	YLabel *Label
}

// Configuration for taking manual/automated backup
type BackupConfiguration struct {
    // A number of seconds after a last backup, that needs to pass, before a topology change will trigger a generation of a new cluster/node backups. If parameter is not provided, then changes in a topology will not trigger a generation of cluster/node backups. format: int64
	AfterInventoryUpdateInterval *int64
    // true if automated backup is enabled
	BackupEnabled *bool
    // Set when backups should be taken - on a weekly schedule or at regular intervals.
	BackupSchedule *data.StructValue
    // The minimum number of seconds between each upload of the inventory summary to backup server. format: int64
	InventorySummaryInterval *int64
    // Passphrase used to encrypt backup files. The passphrase specified must be at least 8 characters in length and must contain at least one lowercase, one uppercase, one numeric character and one special character (any other non-space character).
	Passphrase *string
    // The server to which backups will be sent.
	RemoteFileServer *RemoteFileServer
}

// Past backup operation details
type BackupOperationHistory struct {
    // Statuses of previous cluser backups
	ClusterBackupStatuses []BackupOperationStatus
    // Statuses of previous inventory backups
	InventoryBackupStatuses []BackupOperationStatus
    // Statuses of previous node backups
	NodeBackupStatuses []BackupOperationStatus
}

// Backup operation status
type BackupOperationStatus struct {
    // Unique identifier of a backup
	BackupId *string
    // Time when operation was ended format: int64
	EndTime *int64
    // Possible values are: 
    //
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_NOT_RUN_ON_MASTER
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_SERVER_UNREACHABLE
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_AUTHENTICATION_FAILURE
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_PERMISSION_ERROR
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_TIMEOUT
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_BAD_FINGERPRINT
    // * BackupOperationStatus#BackupOperationStatus_ERROR_CODE_GENERIC_ERROR
    //
    //  Error code
	ErrorCode *string
    // Error code details
	ErrorMessage *string
    // Time when operation was started format: int64
	StartTime *int64
    // True if backup is successfully completed, else false
	Success *bool
}
const BackupOperationStatus_ERROR_CODE_NOT_RUN_ON_MASTER = "BACKUP_NOT_RUN_ON_MASTER"
const BackupOperationStatus_ERROR_CODE_SERVER_UNREACHABLE = "BACKUP_SERVER_UNREACHABLE"
const BackupOperationStatus_ERROR_CODE_AUTHENTICATION_FAILURE = "BACKUP_AUTHENTICATION_FAILURE"
const BackupOperationStatus_ERROR_CODE_PERMISSION_ERROR = "BACKUP_PERMISSION_ERROR"
const BackupOperationStatus_ERROR_CODE_TIMEOUT = "BACKUP_TIMEOUT"
const BackupOperationStatus_ERROR_CODE_BAD_FINGERPRINT = "BACKUP_BAD_FINGERPRINT"
const BackupOperationStatus_ERROR_CODE_GENERIC_ERROR = "BACKUP_GENERIC_ERROR"

// Data for a single backup/restore card
type BackupOverview struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // List of timestamps of backed-up cluster files
	Results []ClusterBackupInfo
    // Configuration to generate a manual/automated backup
	BackupConfig *BackupConfiguration
    // Status of the last backup execution per component
	BackupOperationHistory *BackupOperationHistory
    // Backup status decribes type, phase, success/failure and time of a | latest backup execution
	CurrentBackupOperationStatus *CurrentBackupOperationStatus
    // Status of restore process executing/executed on appliance
	RestoreStatus *ClusterRestoreStatus
}

// Abstract base type for Weekly or Interval Backup Schedule
type BackupSchedule struct {
    // Possible values are: 
    //
    // * BackupSchedule#BackupSchedule_RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE
    // * BackupSchedule#BackupSchedule_RESOURCE_TYPE_INTERVALBACKUPSCHEDULE
    //
    //  Schedule type
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const BackupSchedule__TYPE_IDENTIFIER = "BackupSchedule"
const BackupSchedule_RESOURCE_TYPE_WEEKLYBACKUPSCHEDULE = "WeeklyBackupSchedule"
const BackupSchedule_RESOURCE_TYPE_INTERVALBACKUPSCHEDULE = "IntervalBackupSchedule"

// Consolidated Realized Status Per Enforcement Point.
type BaseConsolidatedStatusPerEnforcementPoint struct {
    // Alarm information details.
	Alarm *PolicyRuntimeAlarm
    // Policy Path referencing the enforcement point where the info is fetched.
	EnforcementPointPath *string
    // Consolidated Realized Status of an Intent object per enforcement point.
	ConsolidatedStatus *ConsolidatedStatus
    // Enforcement Point Id.
	EnforcementPointId *string
	ResourceType string
    // The site where this enforcement point resides.
	SitePath *string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const BaseConsolidatedStatusPerEnforcementPoint__TYPE_IDENTIFIER = "BaseConsolidatedStatusPerEnforcementPoint"

// Represents an endpoint which will be used as subject in rule. It is a polymorphic type object which can be either of the types - 1. Virtual 2. Logical We have 2 separate objects representing these 2 types. VirtualEndPoint for Virtual type and ServiceInstanceEndpoint for Logical.
type BaseEndpoint struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * BaseEndpoint#BaseEndpoint_RESOURCE_TYPE_VIRTUALENDPOINT
    // * BaseEndpoint#BaseEndpoint_RESOURCE_TYPE_SERVICEINSTANCEENDPOINT
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // IPs where either inbound or outbound traffic is to be redirected.
	TargetIps []IPInfo
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const BaseEndpoint__TYPE_IDENTIFIER = "BaseEndpoint"
const BaseEndpoint_RESOURCE_TYPE_VIRTUALENDPOINT = "VirtualEndpoint"
const BaseEndpoint_RESOURCE_TYPE_SERVICEINSTANCEENDPOINT = "ServiceInstanceEndpoint"

// Represents an instance of partner Service and its configuration.
type BasePolicyServiceInstance struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * BasePolicyServiceInstance#BasePolicyServiceInstance_DEPLOYMENT_MODE_STAND_ALONE
    // * BasePolicyServiceInstance#BasePolicyServiceInstance_DEPLOYMENT_MODE_ACTIVE_STANDBY
    //
    //  Deployment mode specifies how the partner appliance will be deployed i.e. in HA or standalone mode.
	DeploymentMode *string
    // Unique name of Partner Service in the Marketplace
	PartnerServiceName *string
    // Possible values are: 
    //
    // * BasePolicyServiceInstance#BasePolicyServiceInstance_TRANSPORT_TYPE_L2_BRIDGE
    // * BasePolicyServiceInstance#BasePolicyServiceInstance_TRANSPORT_TYPE_L3_ROUTED
    //
    //  Transport to be used while deploying Service-VM.
	TransportType *string
}
const BasePolicyServiceInstance_DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
const BasePolicyServiceInstance_DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
const BasePolicyServiceInstance_TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
const BasePolicyServiceInstance_TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"

// A rule indicates the action to be performed for various types of traffic flowing between workload groups.
type BaseRule struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // We need paths as duplicate names may exist for groups under different domains. Along with paths we support IP Address of type IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP Address, Range of IP Address). In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	DestinationGroups []string
    // If set to true, the rule gets applied on all the groups that are NOT part of the destination groups. If false, the rule applies to the destination groups
	DestinationsExcluded *bool
    // Possible values are: 
    //
    // * BaseRule#BaseRule_DIRECTION_IN
    // * BaseRule#BaseRule_DIRECTION_OUT
    // * BaseRule#BaseRule_DIRECTION_IN_OUT
    //
    //  Define direction of traffic.
	Direction *string
    // Flag to disable the rule. Default is enabled.
	Disabled *bool
    // Possible values are: 
    //
    // * BaseRule#BaseRule_IP_PROTOCOL_IPV4
    // * BaseRule#BaseRule_IP_PROTOCOL_IPV6
    // * BaseRule#BaseRule_IP_PROTOCOL_IPV4_IPV6
    //
    //  Type of IP packet that should be matched while enforcing the rule. The value is set to IPV4_IPV6 for Layer3 rule if not specified. For Layer2/Ether rule the value must be null.
	IpProtocol *string
    // A flag to indicate whether rule is a default rule.
	IsDefault *bool
    // Flag to enable packet logging. Default is disabled.
	Logged *bool
    // Text for additional notes on changes.
	Notes *string
    // Holds the list of layer 7 service profile paths. These profiles accept attributes and sub-attributes of various network services (e.g. L4 AppId, encryption algorithm, domain name, etc) as key value pairs.
	Profiles []string
    // This is a unique 4 byte positive number that is assigned by the system. This rule id is passed all the way down to the data path. The first 1GB (1000 to 2^30) will be shared by GM and LM with zebra style striped number space. For E.g 1000 to (1Million -1) by LM, (1M - 2M-1) by GM and so on. format: int64
	RuleId *int64
    // The list of policy paths where the rule is applied LR/Edge/T0/T1/LRP etc. Note that a given rule can be applied on multiple LRs/LRPs.
	Scope []string
    // This field is used to resolve conflicts between multiple Rules under Security or Gateway Policy for a Domain If no sequence number is specified in the payload, a value of 0 is assigned by default. If there are multiple rules with the same sequence number then their order is not deterministic. If a specific order of rules is desired, then one has to specify unique sequence numbers or use the POST request on the rule entity with a query parameter action=revise to let the framework assign a sequence number format: int32
	SequenceNumber *int64
    // In order to specify raw services this can be used, along with services which contains path to services. This can be empty or null.
	ServiceEntries []*data.StructValue
    // In order to specify all services, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the services array. Error will be thrown if ANY is used in conjunction with other values.
	Services []string
    // We need paths as duplicate names may exist for groups under different domains. Along with paths we support IP Address of type IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP Address, Range of IP Address). In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	SourceGroups []string
    // If set to true, the rule gets applied on all the groups that are NOT part of the source groups. If false, the rule applies to the source groups
	SourcesExcluded *bool
    // User level field which will be printed in CLI and packet logs.
	Tag *string
}
const BaseRule_DIRECTION_IN = "IN"
const BaseRule_DIRECTION_OUT = "OUT"
const BaseRule_DIRECTION_IN_OUT = "IN_OUT"
const BaseRule_IP_PROTOCOL_IPV4 = "IPV4"
const BaseRule_IP_PROTOCOL_IPV6 = "IPV6"
const BaseRule_IP_PROTOCOL_IPV4_IPV6 = "IPV4_IPV6"

// Paged Collection of Rules
type BaseRuleListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
}

// Tier-0 interface configuration for external connectivity.
type BaseTier0Interface struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Specify IP address and network prefix for interface.
	Subnets []InterfaceSubnet
}

// A set of operations to be performed in a single batch
type BatchRequest struct {
    // Flag to decide if we will continue processing subsequent requests in case of current error for atomic = false.
	ContinueOnError *bool
	Requests []BatchRequestItem
}

// A single request within a batch of operations
type BatchRequestItem struct {
	Body *data.StructValue
    // Possible values are: 
    //
    // * BatchRequestItem#BatchRequestItem_METHOD_GET
    // * BatchRequestItem#BatchRequestItem_METHOD_POST
    // * BatchRequestItem#BatchRequestItem_METHOD_PUT
    // * BatchRequestItem#BatchRequestItem_METHOD_DELETE
    // * BatchRequestItem#BatchRequestItem_METHOD_PATCH
    //
    //  http method type
	Method *string
    // relative uri (path and args), of the call including resource id (if this is a POST/DELETE), exclude hostname and port and prefix, exploded form of parameters
	Uri *string
}
const BatchRequestItem_METHOD_GET = "GET"
const BatchRequestItem_METHOD_POST = "POST"
const BatchRequestItem_METHOD_PUT = "PUT"
const BatchRequestItem_METHOD_DELETE = "DELETE"
const BatchRequestItem_METHOD_PATCH = "PATCH"

// The reponse to a batch operation
type BatchResponse struct {
    // Indicates if any of the APIs failed
	HasErrors *bool
    // Bulk list results
	Results []BatchResponseItem
    // Optional flag indicating that all items were rolled back even if succeeded initially
	RolledBack *bool
}

// A single respose in a list of batched responses
type BatchResponseItem struct {
    // object returned by api
	Body *data.StructValue
    // http status code format: int64
	Code *int64
    // The headers returned by the API call
	Headers *data.StructValue
}

// Bidirectional Forwarding Detection configuration for BGP peers
type BfdProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Time interval between heartbeat packets in milliseconds. format: int32
	Interval *int64
    // Declare dead multiple. Number of times heartbeat packet is missed before BFD declares the neighbor is down. format: int32
	Multiple *int64
}

// Paged Collection of BfdProfile.
type BfdProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Bfd Profile list results.
	Results []BfdProfile
}

type BgpAddressFamily struct {
    // Count of in prefixes format: int64
	InPrefixCount *int64
    // Count of out prefixes format: int64
	OutPrefixCount *int64
    // Possible values are: 
    //
    // * BgpAddressFamily#BgpAddressFamily_TYPE_IPV4_UNICAST
    // * BgpAddressFamily#BgpAddressFamily_TYPE_VPNV4_UNICAST
    // * BgpAddressFamily#BgpAddressFamily_TYPE_IPV6_UNICAST
    // * BgpAddressFamily#BgpAddressFamily_TYPE_L2VPN_EVPN
    //
    //  BGP address family type
	Type_ *string
}
const BgpAddressFamily_TYPE_IPV4_UNICAST = "IPV4_UNICAST"
const BgpAddressFamily_TYPE_VPNV4_UNICAST = "VPNV4_UNICAST"
const BgpAddressFamily_TYPE_IPV6_UNICAST = "IPV6_UNICAST"
const BgpAddressFamily_TYPE_L2VPN_EVPN = "L2VPN_EVPN"

// BFD configuration for BGP peers
type BgpBfdConfig struct {
    // Flag to enable BFD cofiguration.
	Enabled *bool
    // Time interval between heartbeat packets in milliseconds. format: int32
	Interval *int64
    // Declare dead multiple. Number of times heartbeat packet is missed before BFD declares the neighbor is down. format: int32
	Multiple *int64
}

// Configuration field to hold BGP restart mode and timer.
type BgpGracefulRestartConfig struct {
    // Possible values are: 
    //
    // * BgpGracefulRestartConfig#BgpGracefulRestartConfig_MODE_DISABLE
    // * BgpGracefulRestartConfig#BgpGracefulRestartConfig_MODE_GR_AND_HELPER
    // * BgpGracefulRestartConfig#BgpGracefulRestartConfig_MODE_HELPER_ONLY
    //
    //  If mode is DISABLE, then graceful restart and helper modes are disabled. If mode is GR_AND_HELPER, then both graceful restart and helper modes are enabled. If mode is HELPER_ONLY, then helper mode is enabled. HELPER_ONLY mode is the ability for a BGP speaker to indicate its ability to preserve forwarding state during BGP restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to advertise its restart to its peers.
	Mode *string
    // Configuration field to hold BGP restart timers.
	Timer *BgpGracefulRestartTimer
}
const BgpGracefulRestartConfig_MODE_DISABLE = "DISABLE"
const BgpGracefulRestartConfig_MODE_GR_AND_HELPER = "GR_AND_HELPER"
const BgpGracefulRestartConfig_MODE_HELPER_ONLY = "HELPER_ONLY"

// Configuration field to hold BGP restart timers
type BgpGracefulRestartTimer struct {
    // Maximum time taken (in seconds) for a BGP session to be established after a restart. This can be used to speed up routing convergence by its peer in case the BGP speaker does not come back up after a restart. If the session is not re-established within this timer, the receiving speaker will delete all the stale routes from that peer. format: int64
	RestartTimer *int64
    // Maximum time (in seconds) before stale routes are removed from the RIB (Routing Information Base) when BGP restarts. format: int64
	StaleRouteTimer *int64
}

// Contains information necessary to configure a BGP neighbor.
type BgpNeighborConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Flag to enable allowas_in option for BGP neighbor
	AllowAsIn *bool
    // BFD configuration for failure detection. BFD is enabled with default values when not configured.
	Bfd *BgpBfdConfig
    // Possible values are: 
    //
    // * BgpNeighborConfig#BgpNeighborConfig_GRACEFUL_RESTART_MODE_DISABLE
    // * BgpNeighborConfig#BgpNeighborConfig_GRACEFUL_RESTART_MODE_GR_AND_HELPER
    // * BgpNeighborConfig#BgpNeighborConfig_GRACEFUL_RESTART_MODE_HELPER_ONLY
    //
    //  If mode is DISABLE, then graceful restart and helper modes are disabled. If mode is GR_AND_HELPER, then both graceful restart and helper modes are enabled. If mode is HELPER_ONLY, then helper mode is enabled. HELPER_ONLY mode is the ability for a BGP speaker to indicate its ability to preserve forwarding state during BGP restart. GRACEFUL_RESTART mode is the ability of a BGP speaker to advertise its restart to its peers.
	GracefulRestartMode *string
    // Wait time in seconds before declaring peer dead. format: int32
	HoldDownTime *int64
    // Specify path of prefix-list or route map to filter routes for IN direction. This property is deprecated, use route_filtering instead. Specifying different values for both properties will result in error.
	InRouteFilters []string
    // Interval (in seconds) between keep alive messages sent to peer. format: int32
	KeepAliveTime *int64
    // Maximum number of hops allowed to reach BGP neighbor. format: int32
	MaximumHopLimit *int64
    // Neighbor IP Address format: ip
	NeighborAddress *string
    // Specify path of prefix-list or route map to filter routes for OUT direction. When not specified, a built-in prefix-list named 'prefixlist-out-default' is automatically applied. This property is deprecated, use route_filtering instead. Specifying different values for both properties will result in error.
	OutRouteFilters []string
    // Specify password for BGP neighbor authentication. Empty string (\"\") clears existing password.
	Password *string
    // 4 Byte ASN of the neighbor in ASPLAIN Format
	RemoteAsNum *string
    // Enable address families and route filtering in each direction.
	RouteFiltering []BgpRouteFiltering
    // Source addresses should belong to Tier0 external or loopback interface IP Addresses . BGP peering is formed from all these addresses. This property is mandatory when maximum_hop_limit is greater than 1. format: ip
	SourceAddresses []string
}
const BgpNeighborConfig_GRACEFUL_RESTART_MODE_DISABLE = "DISABLE"
const BgpNeighborConfig_GRACEFUL_RESTART_MODE_GR_AND_HELPER = "GR_AND_HELPER"
const BgpNeighborConfig_GRACEFUL_RESTART_MODE_HELPER_ONLY = "HELPER_ONLY"

// Paged collection of BGP Neighbor Configs
type BgpNeighborConfigListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // BGP neighbor configs list results
	Results []BgpNeighborConfig
}

// BGP neighbor learned/advertised route details.
type BgpNeighborRouteDetailsCsvRecord struct {
    // BGP AS path attribute.
	AsPath *string
    // BGP Local Preference attribute. format: int64
	LocalPref *int64
    // Logical router id
	LogicalRouterId *string
    // BGP Multi Exit Discriminator attribute. format: int64
	Med *int64
    // BGP neighbor peer IP address. format: ip
	NeighborAddress *string
    // BGP neighbor id
	NeighborId *string
    // CIDR network address. format: ip-cidr-block
	Network *string
    // Next hop IP address. format: ip
	NextHop *string
    // BGP neighbor source address. format: ip
	SourceAddress *string
    // Transport node id
	TransportNodeId *string
    // BGP Weight attribute. format: int64
	Weight *int64
}

type BgpNeighborRouteDetailsInCsvFormat struct {
    // File name set by HTTP server if API returns CSV result as a file.
	FileName *string
	Results []BgpNeighborRouteDetailsCsvRecord
}

// BGP neighbor learned/advertised route details.
type BgpNeighborRoutes struct {
    // Array of BGP neighbor route details per edge node.
	EgdeNodeRoutes []RoutesPerTransportNode
    // Enforcement point policy path
	EnforcementPointPath *string
    // BGP neighbor policy path
	NeighborPath *string
}

type BgpNeighborRoutesListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Paged Collection of Bgp neighbor routes.
	Results []BgpNeighborRoutes
}

// Enable address_families and route filtering in each direction
type BgpRouteFiltering struct {
    // Possible values are: 
    //
    // * BgpRouteFiltering#BgpRouteFiltering_ADDRESS_FAMILY_IPV4
    // * BgpRouteFiltering#BgpRouteFiltering_ADDRESS_FAMILY_IPV6
    // * BgpRouteFiltering#BgpRouteFiltering_ADDRESS_FAMILY_L2VPN_EVPN
    //
    //  Address family type. If not configured, this property automatically derived for IPv4 & IPv6 peer configuration.
	AddressFamily *string
    // Flag to enable address family.
	Enabled *bool
    // Specify path of prefix-list or route map to filter routes for IN direction.
	InRouteFilters []string
    // Maximum number of routes for the address family. format: int32
	MaximumRoutes *int64
    // Specify path of prefix-list or route map to filter routes for OUT direction. When not specified, a built-in prefix-list named 'prefixlist-out-default' is automatically applied.
	OutRouteFilters []string
}
const BgpRouteFiltering_ADDRESS_FAMILY_IPV4 = "IPV4"
const BgpRouteFiltering_ADDRESS_FAMILY_IPV6 = "IPV6"
const BgpRouteFiltering_ADDRESS_FAMILY_L2VPN_EVPN = "L2VPN_EVPN"

// Contains BGP routing configuration.
type BgpRoutingConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Flag to enable ECMP.
	Ecmp *bool
    // Flag to enable BGP configuration. Disabling will stop feature and BGP peering.
	Enabled *bool
    // Flag to enable graceful restart. This field is deprecated, please use graceful_restart_config parameter for graceful restart configuration. If both parameters are set and consistent with each other (i.e. graceful_restart=false and graceful_restart_mode=HELPER_ONLY OR graceful_restart=true and graceful_restart_mode=GR_AND_HELPER) then this is allowed, but if inconsistent with each other then this is not allowed and validation error will be thrown.
	GracefulRestart *bool
    // Configuration field to hold BGP Restart mode and timer.
	GracefulRestartConfig *BgpGracefulRestartConfig
    // Flag to enable inter SR IBGP configuration. When not specified, inter SR IBGP is automatically enabled if Tier-0 is created in ACTIVE_ACTIVE ha_mode.
	InterSrIbgp *bool
    // Specify BGP AS number for Tier-0 to advertize to BGP peers. AS number can be specified in ASPLAIN (e.g., \"65546\") or ASDOT (e.g., \"1.10\") format. Empty string disables BGP feature. It is required by normal tier0 but not required in vrf tier0.
	LocalAsNum *string
    // Flag to enable BGP multipath relax option.
	MultipathRelax *bool
    // List of routes to be aggregated.
	RouteAggregations []RouteAggregationEntry
}

type BinaryPacketData struct {
    // Up to 1000 bytes of payload may be supplied (with a base64-encoded length of 1336 bytes.) Additional bytes of traceflow metadata will be appended to the payload. The payload must contain all headers (Ethernet, IP, etc). Note that VLAN is not supported in the logical space. Hence, payload must not contain 802.1Q headers.
	Payload *string
    // If the requested frame_size is too small (given the payload and traceflow metadata requirement of 16 bytes), the traceflow request will fail with an appropriate message. The frame will be zero padded to the requested size. format: int64
	FrameSize *int64
    // Possible values are: 
    //
    // * PacketData#PacketData_RESOURCE_TYPE_BINARYPACKETDATA
    // * PacketData#PacketData_RESOURCE_TYPE_FIELDSPACKETDATA
    //
    //  Packet configuration
	ResourceType string
    // A flag, when set true, indicates that the traceflow packet is of L3 routing.
	Routed *bool
    // Possible values are: 
    //
    // * PacketData#PacketData_TRANSPORT_TYPE_BROADCAST
    // * PacketData#PacketData_TRANSPORT_TYPE_UNICAST
    // * PacketData#PacketData_TRANSPORT_TYPE_MULTICAST
    // * PacketData#PacketData_TRANSPORT_TYPE_UNKNOWN
    //
    //  transport type of the traceflow packet
	TransportType *string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const BinaryPacketData__TYPE_IDENTIFIER = "BinaryPacketData"

// configuration parameters for Bridge Profile
type BridgeProfileConfig struct {
    // Same bridge profile can be configured on different segments. Each bridge profile on a segment must unique.
	BridgeProfilePath *string
    // The name of the switching uplink teaming policy for the bridge endpoint. This name corresponds to one fot he switching uplink teaming policy names listed in teh transport zone. When this property is not specified, the teaming policy is assigned by MP.
	UplinkTeamingPolicyName *string
    // VLAN specification for bridge endpoint. Either VLAN ID or VLAN ranges can be specified. Not both.
	VlanIds []string
    // VLAN transport zone should belong to the enforcment-point as the transport zone specified in the segment.
	VlanTransportZonePath *string
}

// Represents an instance of partner's service whose wiring will be done by partner itself. As partner does all the wiring, we call it as Byod - Bring your own device.
type ByodPolicyServiceInstance struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * ByodPolicyServiceInstance#ByodPolicyServiceInstance_DEPLOYMENT_MODE_STAND_ALONE
    // * ByodPolicyServiceInstance#ByodPolicyServiceInstance_DEPLOYMENT_MODE_ACTIVE_STANDBY
    //
    //  Deployment mode specifies how the partner appliance will be deployed i.e. in HA or standalone mode.
	DeploymentMode *string
    // Unique name of Partner Service in the Marketplace
	PartnerServiceName *string
    // Possible values are: 
    //
    // * ByodPolicyServiceInstance#ByodPolicyServiceInstance_TRANSPORT_TYPE_L2_BRIDGE
    // * ByodPolicyServiceInstance#ByodPolicyServiceInstance_TRANSPORT_TYPE_L3_ROUTED
    //
    //  Transport to be used while deploying Service-VM.
	TransportType *string
}
const ByodPolicyServiceInstance_DEPLOYMENT_MODE_STAND_ALONE = "STAND_ALONE"
const ByodPolicyServiceInstance_DEPLOYMENT_MODE_ACTIVE_STANDBY = "ACTIVE_STANDBY"
const ByodPolicyServiceInstance_TRANSPORT_TYPE_L2_BRIDGE = "L2_BRIDGE"
const ByodPolicyServiceInstance_TRANSPORT_TYPE_L3_ROUTED = "L3_ROUTED"

// Collection of only Byod SI objects
type ByodPolicyServiceInstanceListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Byod Service instance list results
	Results []ByodPolicyServiceInstance
}

// Child wrapper object for Application, used in hierarchical API
type ChildApplication struct {
    // Contains the actual Application object
	Application *Application
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for ApplicationService, used in hierarchical API
type ChildApplicationService struct {
    // Contains the actual ApplicationService object
	ApplicationService *ApplicationService
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for ApplicationTier, used in hierarchical API
type ChildApplicationTier struct {
    // Contains the actual ApplicationTier object
	ApplicationTier *ApplicationTier
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for BfdProfile, used in hierarchical API.
type ChildBfdProfile struct {
    // Contains the actual BfdProfile object.
	BfdProfile *BfdProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for BgpNeighborConfig, used in hierarchical API.
type ChildBgpNeighborConfig struct {
    // Contains the actual BgpNeighborConfig object.
	BgpNeighborConfig *BgpNeighborConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for BgpRoutingConfig, used in hierarchical API.
type ChildBgpRoutingConfig struct {
    // Contains the actual BgpRoutingConfig object.
	BgpRoutingConfig *BgpRoutingConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for ByodPolicyServiceInstance used in hierarchical API.
type ChildByodPolicyServiceInstance struct {
    // Contains actual ByodPolicyServiceInstance.
	ByodPolicyServiceInstance *ByodPolicyServiceInstance
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for CommunicationEntry, used in hierarchical API This type is deprecated. Use the type ChildRule instead.
type ChildCommunicationEntry struct {
    // Contains the actual CommunicationEntry object.
	CommunicationEntry *CommunicationEntry
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for CommunicationMap, used in hierarchical API This type is deprecated. Use the type ChildSecurityPolicy instead.
type ChildCommunicationMap struct {
    // Contains the actual CommunicationMap object.
	CommunicationMap *CommunicationMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for CommunityList, used in hierarchical API
type ChildCommunityList struct {
    // Contains the actual CommunityList object
	CommunityList *CommunityList
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Wrapper object for ComputeClusterIdfwConfiguration
type ChildComputeClusterIdfwConfiguration struct {
    // Contains the actual compute cluster idfw configuration object.
	ComputeClusterIdfwConfiguration *ComputeClusterIdfwConfiguration
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for Constraint, used in hierarchical API
type ChildConstraint struct {
    // Contains the actual Constraint object
	Constraint *Constraint
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for DeploymentZone, used in hierarchical API
type ChildDeploymentZone struct {
    // Contains the actual DeploymentZone object
	DeploymentZone *DeploymentZone
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Wrapper object for FirewallConfiguration
type ChildDfwFirewallConfiguration struct {
    // Contains the actual dfw firewall configuration list object.
	DfwFirewallConfiguration *DfwFirewallConfiguration
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for DhcpRelayConfig, used in hierarchical API
type ChildDhcpRelayConfig struct {
    // Contains the actual DhcpRelayConfig object
	DhcpRelayConfig *DhcpRelayConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for DhcpServerConfig, used in hierarchical API
type ChildDhcpServerConfig struct {
    // Contains the actual DhcpServerConfig object
	DhcpServerConfig *DhcpServerConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for DhcpStaticBindingConfig, used in hierarchical API.
type ChildDhcpStaticBindingConfig struct {
    // Contains the actual DhcpStaticBindingConfig object.
	DhcpStaticBindingConfig *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for DnsSecurityProfile, used in hierarchical API
type ChildDnsSecurityProfile struct {
    // Contains the actual DnsSecurityProfile object
	DnsSecurityProfile *DnsSecurityProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper obejct for DnsSecurityProfileBindingMap used in hierarchical API
type ChildDnsSecurityProfileBindingMap struct {
    // Contains the actual DnsSecurityProfileBindingMap object
	DnsSecurityProfileBindingMap *DnsSecurityProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for domain, used in hierarchical API.
type ChildDomain struct {
    // Contains the actual domain object.
	Domain *Domain
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for DomainDeploymentMap, used in hierarchical API.
type ChildDomainDeploymentMap struct {
    // Contains the actual DomainDeploymentMap object.
	DomainDeploymentMap *DomainDeploymentMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for EndpointPolicy used in hierarchical API.
type ChildEndpointPolicy struct {
    // Contains actual EndpointPolicy.
	EndpointPolicy *EndpointPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for EndpointRule used in hierarchical API.
type ChildEndpointRule struct {
    // Contains actual EndpointRule.
	EndpointRule *EndpointRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for EnforcementPoint, used in hierarchical API.
type ChildEnforcementPoint struct {
    // Contains the actual Enforcement point object.
	EnforcementPoint *EnforcementPoint
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for EvpnConfig, used in hierarchical API.
type ChildEvpnConfig struct {
    // Contains the actual EvpnConfig object.
	EvpnConfig *EvpnConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for EvpnTunnelEndpointConfig, used in hierarchical API.
type ChildEvpnTunnelEndpointConfig struct {
    // Contains the actual EvpnTunnelEndpointConfig object.
	EvpnTunnelEndpointConfig *EvpnTunnelEndpointConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for FirewallIdentityStore, used in hierarchical API.
type ChildFirewallIdentityStore struct {
    // Contains the actual FirewallIdentityStore object.
	FirewallIdentityStore *FirewallIdentityStore
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for FloodProtectionProfile, used in hierarchical API
type ChildFloodProtectionProfile struct {
    // Contains the actual FloodProtectionProfile object
	FloodProtectionProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for FloodProtectionProfileBindingMap, used in hierarchical API
type ChildFloodProtectionProfileBindingMap struct {
    // Contains the actual FloodProtectionProfileBindingMap object
	FloodProtectionProfileBindingMap *FloodProtectionProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for ForwardingPolicy used in Hierarchical API.
type ChildForwardingPolicy struct {
    // Contains actual ForwardingPolicy.
	ForwardingPolicy *ForwardingPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for ForwardingRule used in Hierarchical API.
type ChildForwardingRule struct {
    // Contains actual ForwardingRule.
	ForwardingRule *ForwardingRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for GatewayPolicy, used in hierarchical API
type ChildGatewayPolicy struct {
    // Contains the actual GatewayPolicy object
	GatewayPolicy *GatewayPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for GatewayQosProfile, used in hierarchical API.
type ChildGatewayQosProfile struct {
    // Contains the actual GatewayQosProfile object.
	QosProfile *GatewayQosProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for GlobalConfig, used in hierarchical API
type ChildGlobalConfig struct {
    // Contains the actual GlobalConfig object.
	GlobalConfig *GlobalConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for Global Manager, used in hierarchical API.
type ChildGlobalManager struct {
    // Contains the actual Global Manager object.
	GlobalManager *GlobalManager
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for group, used in hierarchical API.
type ChildGroup struct {
    // Contains the actual group objects.
	Group *Group
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper obejct for GroupDiscoveryProfileBindingMap used in hierarchical API
type ChildGroupDiscoveryProfileBindingMap struct {
    // Contains the actual GroupDiscoveryProfileBindingMap object
	GroupDiscoveryProfileBindingMap *GroupDiscoveryProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for GroupMonitoringProfileBindingMap, used in hierarchical API
type ChildGroupMonitoringProfileBindingMap struct {
    // Contains the actual GroupMonitoringProfileBindingMap object
	GroupMonitoringProfileBindingMap *GroupMonitoringProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPDiscoveryProfile, used in hierarchical API
type ChildIPDiscoveryProfile struct {
    // Contains the actual IPDiscoveryProfile object
	IpDiscoveryProfile *IPDiscoveryProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPFIXDFWCollectorProfile, used in hierarchical API
type ChildIPFIXDFWCollectorProfile struct {
    // Contains the actual IPFIXDFWCollectorProfile object
	IPFIXDFWCollectorProfile *IPFIXDFWCollectorProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPFIXDFWProfile, used in hierarchical API
type ChildIPFIXDFWProfile struct {
    // Contains the actual IPFIXDFWProfile object
	IPFIXDFWProfile *IPFIXDFWProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPFIXL2CollectorProfile, used in hierarchical API
type ChildIPFIXL2CollectorProfile struct {
    // Contains the actual IPFIXL2CollectorProfile object
	IPFIXL2CollectorProfile *IPFIXL2CollectorProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPFIXL2Profile, used in hierarchical API
type ChildIPFIXL2Profile struct {
    // Contains the actual IPFIXL2Profile object
	IPFIXL2Profile *IPFIXL2Profile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnDpdProfile, used in hierarchical API.
type ChildIPSecVpnDpdProfile struct {
    // Contains the actual IPSecVpnDpdProfile object.
	IpSecVpnDpdProfile *IPSecVpnDpdProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnIkeProfile, used in hierarchical API.
type ChildIPSecVpnIkeProfile struct {
    // Contains the actual IPSecVpnIkeProfile object.
	IpSecVpnIkeProfile *IPSecVpnIkeProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnLocalEndpoint, used in hierarchical API.
type ChildIPSecVpnLocalEndpoint struct {
    // Contains the actual IPSecVpnLocalEndpoint object.
	IpSecVpnLocalEndpoint *IPSecVpnLocalEndpoint
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnService, used in hierarchical API.
type ChildIPSecVpnService struct {
    // Contains the actual IPSecVpnService object.
	IpSecVpnService *IPSecVpnService
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnSession, used in hierarchical API.
type ChildIPSecVpnSession struct {
    // Contains the actual IPSecVpnSession object.
	IpSecVpnSession *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IPSecVpnTunnelProfile, used in hierarchical API.
type ChildIPSecVpnTunnelProfile struct {
    // Contains the actual IPSecVpnTunnelProfile object
	IpSecVpnTunnelProfile *IPSecVpnTunnelProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsClusterConfig, used in hierarchical API
type ChildIdsClusterConfig struct {
    // Contains the IdsClusterConfig object
	IdsClusterConfig *IdsClusterConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsProfile, used in hierarchical API
type ChildIdsProfile struct {
    // Contains the IdsProfile object
	IdsProfile *IdsProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsRule, used in hierarchical API
type ChildIdsRule struct {
    // Contains the IdsRule object
	IdsRule *IdsRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsSecurityPolicy, used in hierarchical API
type ChildIdsSecurityPolicy struct {
    // Contains the IdsSecurityPolicy object
	IdsSecurityPolicy *IdsSecurityPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsSignature, used in hierarchical API
type ChildIdsSignature struct {
    // Contains the IdsSignature object
	IdsSignature *IdsSignature
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IdsStandaloneHostConfig, used in hierarchical API
type ChildIdsStandaloneHostConfig struct {
    // Contains the IdsStandaloneHostConfig object
	IdsStandaloneHostConfig *IdsStandaloneHostConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IpAddressAllocation, used in hierarchical API
type ChildIpAddressAllocation struct {
    // Contains the actual IpAddressAllocation object
	IpAddressAllocation *IpAddressAllocation
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IpAddressBlock, used in hierarchical API
type ChildIpAddressBlock struct {
    // Contains the actual IpAddressBlock object
	IpAddressBlock *IpAddressBlock
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IpAddressPool, used in hierarchical API
type ChildIpAddressPool struct {
    // Contains the actual IpAddressPool object
	IpAddressPool *IpAddressPool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for IpAddressPoolSubnet, used in hierarchical API
type ChildIpAddressPoolSubnet struct {
    // Contains the actual IpAddressPoolSubnet object
	IpAddressPoolSubnet *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for Ipv6DadProfile, used in hierarchical API
type ChildIpv6DadProfile struct {
    // Contains the actual Ipv6DadProfile objects
	Ipv6DadProfile *Ipv6DadProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for Ipv6NdraProfile, used in hierarchical API
type ChildIpv6NdraProfile struct {
    // Contains the actual Ipv6NdraProfile objects
	Ipv6NdraProfile *Ipv6NdraProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L2BridgeEndpointProfile, used in hierarchical API
type ChildL2BridgeEndpointProfile struct {
    // Contains the actual L2BridgeEndpointProfile object
	L2BridgeEndpointProfile *L2BridgeEndpointProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L2VPNService, used in hierarchical API.
type ChildL2VPNService struct {
    // Contains the actual L2VPNService object.
	L2VPNService *L2VPNService
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L2VPNSession, used in hierarchical API.
type ChildL2VPNSession struct {
    // Contains the actual L2VPNSession object.
	L2VPNSession *L2VPNSession
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L2Vpn, used in hierarchical API.
type ChildL2Vpn struct {
    // Contains the actual L2Vpn object.
	L2Vpn *L2Vpn
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L2VpnContext, used in hierarchical API.
type ChildL2VpnContext struct {
    // Contains the actual L2VpnContext object.
	L2VpnContext *L2VpnContext
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L3Vpn, used in hierarchical API.
type ChildL3Vpn struct {
    // Contains the actual L3Vpn object.
	L3Vpn *L3Vpn
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for L3VpnContext, used in hierarchical API.
type ChildL3VpnContext struct {
    // Contains the actual L3VpnContext object.
	L3VpnContext *L3VpnContext
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBAppProfile, used in hierarchical API.
type ChildLBAppProfile struct {
    // Contains the actual LBAppProfile object.
	LbAppProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBClientSslProfile, used in hierarchical API.
type ChildLBClientSslProfile struct {
    // Contains the actual LBClientSslProfile object.
	LbClientSslProfile *LBClientSslProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBMonitorProfile, used in hierarchical API.
type ChildLBMonitorProfile struct {
    // Contains the actual LBMonitorProfile object.
	LbMonitorProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBPersistenceProfile, used in hierarchical API.
type ChildLBPersistenceProfile struct {
    // Contains the actual LBPersistenceProfile object.
	LbPersistenceProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBPool, used in hierarchical API.
type ChildLBPool struct {
    // Contains the actual LBPool object.
	LbPool *LBPool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBServerSslProfile, used in hierarchical API.
type ChildLBServerSslProfile struct {
    // Contains the actual LBServerSslProfile object.
	LbServerSslProfile *LBServerSslProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBService, used in hierarchical API.
type ChildLBService struct {
    // Contains the actual LBService object.
	LbService *LBService
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper for LBVirtualServer, used in hierarchical API.
type ChildLBVirtualServer struct {
    // Contains the actual LBVirtualServer object.
	LbVirtualServer *LBVirtualServer
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for LocaleServices, used in hierarchical API
type ChildLocaleServices struct {
    // Contains the actual LocaleServices object
	LocaleServices *LocaleServices
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Child wrapper object for MacDiscoveryProfile, used in hierarchical API
type ChildMacDiscoveryProfile struct {
    // Contains the actual MacDiscoveryProfile object
	MacDiscoveryProfile *MacDiscoveryProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Wrapper object for MetadataProxyConfig
type ChildMetadataProxyConfig struct {
    // Contains the actual MetadataProxyConfig object.
	MetadataProxyConfig *MetadataProxyConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}

// Represents an object on the desired state
type ChildPolicyConfigResource struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyConfigResource__TYPE_IDENTIFIER = "ChildPolicyConfigResource"

// Child wrapper object for PolicyContextProfile, used in hierarchical API
type ChildPolicyContextProfile struct {
    // Contains the actual PolicyContextProfile objects
	PolicyContextProfile *PolicyContextProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyContextProfile__TYPE_IDENTIFIER = "ChildPolicyContextProfile"

// Child wrapper object for PolicyDnsForwarder, used in hierarchical API
type ChildPolicyDnsForwarder struct {
    // Contains the actual PolicyDnsForwarder object
	PolicyDnsForwarder *PolicyDnsForwarder
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyDnsForwarder__TYPE_IDENTIFIER = "ChildPolicyDnsForwarder"

// Child wrapper object for PolicyDnsForwarderZone, used in hierarchical API
type ChildPolicyDnsForwarderZone struct {
    // Contains the actual PolicyDnsForwarderZone object
	PolicyDnsForwarderZone *PolicyDnsForwarderZone
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyDnsForwarderZone__TYPE_IDENTIFIER = "ChildPolicyDnsForwarderZone"

// Child wrapper object for PolicyEdgeCluster, used in hierarchical API.
type ChildPolicyEdgeCluster struct {
    // Contains the actual PolicyEdgeCluster object.
	PolicyEdgeCluster *PolicyEdgeCluster
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyEdgeCluster__TYPE_IDENTIFIER = "ChildPolicyEdgeCluster"

// Child wrapper object for PolicyEdgeNode, used in hierarchical API.
type ChildPolicyEdgeNode struct {
    // Contains the actual PolicyEdgeNode object.
	PolicyEdgeNode *PolicyEdgeNode
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyEdgeNode__TYPE_IDENTIFIER = "ChildPolicyEdgeNode"

// Wrapper object for PolicyExcludeList
type ChildPolicyExcludeList struct {
    // Contains the actual policy exclude list object.
	PolicyExcludeList *PolicyExcludeList
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyExcludeList__TYPE_IDENTIFIER = "ChildPolicyExcludeList"

// Child wrapper object for PolicyFirewallCPUMemThresholdsProfileBindingMap, used in hierarchical API.
type ChildPolicyFirewallCPUMemThresholdsProfileBindingMap struct {
    // Contains the actual PolicyFirewallCPUMemThresholdsProfileBindingMap object.
	PolicyFirewallCPUMemThresholdsProfileBindingMap *PolicyFirewallCPUMemThresholdsProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallCPUMemThresholdsProfileBindingMap__TYPE_IDENTIFIER = "ChildPolicyFirewallCPUMemThresholdsProfileBindingMap"

// Child wrapper object for PolicyFirewallCpuMemThresholdsProfile, used in hierarchical API.
type ChildPolicyFirewallCpuMemThresholdsProfile struct {
    // Contains the actual PolicyFirewallCpuMemThresholdsProfile object
	PolicyFirewallCpuMemThresholdsProfile *PolicyFirewallCpuMemThresholdsProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallCpuMemThresholdsProfile__TYPE_IDENTIFIER = "ChildPolicyFirewallCpuMemThresholdsProfile"

// Child wrapper object for PolicyFirewallFloodProtectionProfileBindingMap, used in hierarchical API
type ChildPolicyFirewallFloodProtectionProfileBindingMap struct {
    // Contains the actual PolicyFirewallFloodProtectionProfileBindingMap object
	PolicyFirewallFloodProtectionProfileBindingMap *PolicyFirewallFloodProtectionProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallFloodProtectionProfileBindingMap__TYPE_IDENTIFIER = "ChildPolicyFirewallFloodProtectionProfileBindingMap"

// Child wrapper object for PolicyFirewallScheduler, used in hierarchical API
type ChildPolicyFirewallScheduler struct {
    // Contains the actual PolicyFirewallScheduler objects
	PolicyFirewallScheduler *PolicyFirewallScheduler
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallScheduler__TYPE_IDENTIFIER = "ChildPolicyFirewallScheduler"

// Child wrapper object for PolicyFirewallSessionTimerProfile, used in hierarchical API
type ChildPolicyFirewallSessionTimerProfile struct {
    // Contains the actual PolicyFirewallSessionTimerProfile object
	PolicyFirewallSessionTimerProfile *PolicyFirewallSessionTimerProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallSessionTimerProfile__TYPE_IDENTIFIER = "ChildPolicyFirewallSessionTimerProfile"

// Child wrapper object for PolicyFirewallSessionTimerProfileBindingMap, used in hierarchical API
type ChildPolicyFirewallSessionTimerProfileBindingMap struct {
    // Contains the actual PolicyFirewallSessionTimerProfileBindingMap object
	PolicyFirewallSessionTimerProfileBindingMap *PolicyFirewallSessionTimerProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyFirewallSessionTimerProfileBindingMap__TYPE_IDENTIFIER = "ChildPolicyFirewallSessionTimerProfileBindingMap"

// Child wrapper object for PolicyGroupReference, used in hierarchical API
type ChildPolicyGroupReference struct {
    // Contains the actual PolicyGroupReference object
	PolicyGroupReference *PolicyGroupReference
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyGroupReference__TYPE_IDENTIFIER = "ChildPolicyGroupReference"

// Child wrapper object for PolicyIgmpProfile used in hierarchical API.
type ChildPolicyIgmpProfile struct {
    // Contains actual PolicyIgmpProfile.
	PolicyIgmpProfile *PolicyIgmpProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyIgmpProfile__TYPE_IDENTIFIER = "ChildPolicyIgmpProfile"

// Child wrapper object for PolicyLabel, used in hierarchical API
type ChildPolicyLabel struct {
    // Contains the actual PolicyLabel object
	PolicyLabel *PolicyLabel
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLabel__TYPE_IDENTIFIER = "ChildPolicyLabel"

// Child wrapper for PolicyLbMonitorProfile, used in hierarchical API
type ChildPolicyLbMonitorProfile struct {
    // Contains the actual PolicyLbMonitorProfile object
	PolicyLbMonitorProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLbMonitorProfile__TYPE_IDENTIFIER = "ChildPolicyLbMonitorProfile"

// Child wrapper for PolicyLbPersistenceProfile, used in hierarchical API
type ChildPolicyLbPersistenceProfile struct {
    // Contains the actual PolicyLbPersistenceProfile object
	PolicyLbPersistenceProfile *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLbPersistenceProfile__TYPE_IDENTIFIER = "ChildPolicyLbPersistenceProfile"

// Child wrapper for PolicyLbPoolAccess, used in hierarchical API
type ChildPolicyLbPoolAccess struct {
    // Contains the actual PolicyLbPoolAccess object
	PolicyLbPoolAccess *PolicyLbPoolAccess
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLbPoolAccess__TYPE_IDENTIFIER = "ChildPolicyLbPoolAccess"

// Child wrapper for PolicyLbRule, used in hierarchical API
type ChildPolicyLbRule struct {
    // Contains the actual PolicyLbRule object
	PolicyLbRule *PolicyLbRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLbRule__TYPE_IDENTIFIER = "ChildPolicyLbRule"

// Child wrapper for PolicyLbVirtualServer, used in hierarchical API
type ChildPolicyLbVirtualServer struct {
    // Contains the actual PolicyLbVirtualServer object
	PolicyLbVirtualServer *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyLbVirtualServer__TYPE_IDENTIFIER = "ChildPolicyLbVirtualServer"

// Child wrapper object for PolicyMulticastConfig used in hierarchical API.
type ChildPolicyMulticastConfig struct {
    // Contains actual PolicyMulticastConfig.
	PolicyMulticastConfig *PolicyMulticastConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyMulticastConfig__TYPE_IDENTIFIER = "ChildPolicyMulticastConfig"

// Child wrapper object for PolicyNat, used in hierarchical API
type ChildPolicyNat struct {
    // Contains the actual PolicyNAT object
	PolicyNat *PolicyNat
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyNat__TYPE_IDENTIFIER = "ChildPolicyNat"

// Child wrapper object for PolicyNatRule, used in hierarchical API
type ChildPolicyNatRule struct {
    // Contains the actual PolicyNatRule object
	PolicyNatRule *PolicyNatRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyNatRule__TYPE_IDENTIFIER = "ChildPolicyNatRule"

// Child wrapper object for PolicyPimProfile used in hierarchical API.
type ChildPolicyPimProfile struct {
    // Contains actual PolicyPimProfile.
	PolicyPimProfile *PolicyPimProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyPimProfile__TYPE_IDENTIFIER = "ChildPolicyPimProfile"

// Child wrapper object for PolicyServiceInstance used in hierarchical API.
type ChildPolicyServiceChain struct {
    // Contains actual PolicyServiceChain.
	PolicyServiceChain *PolicyServiceChain
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyServiceChain__TYPE_IDENTIFIER = "ChildPolicyServiceChain"

// Child wrapper object for PolicyServiceInstance used in hierarchical API.
type ChildPolicyServiceInstance struct {
    // Contains actual PolicyServiceInstance.
	PolicyServiceInstance *PolicyServiceInstance
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyServiceInstance__TYPE_IDENTIFIER = "ChildPolicyServiceInstance"

// Child wrapper object for PolicyServiceProfile used in hierarchical API.
type ChildPolicyServiceProfile struct {
    // Contains actual PolicyServiceProfile.
	PolicyServiceProfile *PolicyServiceProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyServiceProfile__TYPE_IDENTIFIER = "ChildPolicyServiceProfile"

// Child wrapper object for PolicyTransportZone, used in hierarchical API.
type ChildPolicyTransportZone struct {
    // Contains the actual PolicyTransportZone object.
	PolicyTransportZone *PolicyTransportZone
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyTransportZone__TYPE_IDENTIFIER = "ChildPolicyTransportZone"

// Child wrapper object for PolicyUrlCategorizationConfig, used in hierarchical API
type ChildPolicyUrlCategorizationConfig struct {
    // Contains the actual PolicyUrlCategorizationConfig object
	PolicyUrlCategorizationConfig *PolicyUrlCategorizationConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPolicyUrlCategorizationConfig__TYPE_IDENTIFIER = "ChildPolicyUrlCategorizationConfig"

// Child wrapper object for PortDiscoveryProfileBindingMap, used in hierarchical API
type ChildPortDiscoveryProfileBindingMap struct {
    // Contains the actual PortDiscoveryProfileBindingMap object
	PortDiscoveryProfileBindingMap *PortDiscoveryProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPortDiscoveryProfileBindingMap__TYPE_IDENTIFIER = "ChildPortDiscoveryProfileBindingMap"

// Child wrapper object for PortMirroringProfile, used in hierarchical API
type ChildPortMirroringProfile struct {
    // Contains the actual PortMirroringProfile object
	PortMirroringProfile *PortMirroringProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPortMirroringProfile__TYPE_IDENTIFIER = "ChildPortMirroringProfile"

// Child wrapper object for PortMonitoringProfileBindingMap, used in hierarchical API
type ChildPortMonitoringProfileBindingMap struct {
    // Contains the actual PortMonitoringProfileBindingMap object
	PortMonitoringProfileBindingMap *PortMonitoringProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPortMonitoringProfileBindingMap__TYPE_IDENTIFIER = "ChildPortMonitoringProfileBindingMap"

// Child wrapper object for PortQoSProfileBindingMap, used in hierarchical API
type ChildPortQosProfileBindingMap struct {
    // Contains the actual PortQoSProfileBindingMap object
	PortQosProfileBindingMap *PortQosProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPortQosProfileBindingMap__TYPE_IDENTIFIER = "ChildPortQoSProfileBindingMap"

// Child wrapper object for PortSecurityProfileBindingMap, used in hierarchical API
type ChildPortSecurityProfileBindingMap struct {
    // Contains the actual PortSecurityProfileBindingMap object
	PortSecurityProfileBindingMap *PortSecurityProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPortSecurityProfileBindingMap__TYPE_IDENTIFIER = "ChildPortSecurityProfileBindingMap"

// Child wrapper object for PrefixList, used in hierarchical API.
type ChildPrefixList struct {
    // Contains the actual PrefixList object.
	PrefixList *PrefixList
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildPrefixList__TYPE_IDENTIFIER = "ChildPrefixList"

// Child wrapper object for QoSProfile, used in hierarchical API
type ChildQosProfile struct {
    // Contains the actual QoSProfile object
	QosProfile *QosProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildQosProfile__TYPE_IDENTIFIER = "ChildQoSProfile"

// Child wrapper object for Reaction used in hierarchical API.
type ChildReaction struct {
    // Contains the actual Reaction object.
	Reaction *Reaction
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildReaction__TYPE_IDENTIFIER = "ChildReaction"

// Child wrapper object for RedirectionPolicy used in Hierarchical API.
type ChildRedirectionPolicy struct {
    // Contains actual RedirectionPolicy.
	RedirectionPolicy *RedirectionPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildRedirectionPolicy__TYPE_IDENTIFIER = "ChildRedirectionPolicy"

// Child wrapper object for ChildRedirectionRule used in Hierarchical API.
type ChildRedirectionRule struct {
    // Contains actual RedirectionRule.
	RedirectionRule *RedirectionRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildRedirectionRule__TYPE_IDENTIFIER = "ChildRedirectionRule"

// Represents a reference to ChildPolicyConfigResource in the hierarchical API. resource_type, id and target_type are mandatory fields.
type ChildResourceReference struct {
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // The target type of this reference
	TargetType *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildResourceReference__TYPE_IDENTIFIER = "ChildResourceReference"

// Child wrapper object for Rule, used in hierarchical API
type ChildRule struct {
    // Contains the actual Rule object
	Rule *Rule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildRule__TYPE_IDENTIFIER = "ChildRule"

// Child wrapper object for SecurityPolicy, used in hierarchical API
type ChildSecurityPolicy struct {
    // Contains the actual SecurityPolicy object
	SecurityPolicy *SecurityPolicy
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSecurityPolicy__TYPE_IDENTIFIER = "ChildSecurityPolicy"

// Child wrapper object for SecurityZone, used in hierarchical API
type ChildSecurityZone struct {
    // Contains the actual SecurityZone object
	SecurityZone *SecurityZone
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSecurityZone__TYPE_IDENTIFIER = "ChildSecurityZone"

// Child wrapper object for SecurityZoneBinding, used in hierarchical API
type ChildSecurityZoneBinding struct {
    // Security zone binding for a tier.
	SecurityZoneBinding *SecurityZoneBinding
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSecurityZoneBinding__TYPE_IDENTIFIER = "ChildSecurityZoneBinding"

// Child wrapper object for SecurityZoneRule, used in hierarchical API This type is deprecated. Use the type ChildRule instead.
type ChildSecurityZoneRule struct {
    // Contains the actual SecurityZoneRule object.
	SecurityZoneRule *SecurityZoneRule
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSecurityZoneRule__TYPE_IDENTIFIER = "ChildSecurityZoneRule"

// Child wrapper object for Segment, used in hierarchical API.
type ChildSegment struct {
    // Contains the actual Segment object.
	Segment *Segment
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegment__TYPE_IDENTIFIER = "ChildSegment"

// Child wrapper object for SegmentDiscoveryProfileBindingMap, used in hierarchical API
type ChildSegmentDiscoveryProfileBindingMap struct {
    // Contains the actual SegmentDiscoveryProfileBindingMap object
	SegmentDiscoveryProfileBindingMap *SegmentDiscoveryProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentDiscoveryProfileBindingMap__TYPE_IDENTIFIER = "ChildSegmentDiscoveryProfileBindingMap"

// Child wrapper object for SegmentMonitoringProfileBindingMap, used in hierarchical API
type ChildSegmentMonitoringProfileBindingMap struct {
    // Contains the actual SegmentMonitoringProfileBindingMap object
	SegmentMonitoringProfileBindingMap *SegmentMonitoringProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentMonitoringProfileBindingMap__TYPE_IDENTIFIER = "ChildSegmentMonitoringProfileBindingMap"

// Child wrapper object for SegmentPort, used in hierarchical API
type ChildSegmentPort struct {
    // Contains the actual SegmentPort object
	SegmentPort *SegmentPort
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentPort__TYPE_IDENTIFIER = "ChildSegmentPort"

// Child wrapper object for SegmentQoSProfileBindingMap, used in hierarchical API
type ChildSegmentQosProfileBindingMap struct {
    // Contains the actual SegmentQoSProfileBindingMap object
	SegmentQosProfileBindingMap *SegmentQosProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentQosProfileBindingMap__TYPE_IDENTIFIER = "ChildSegmentQoSProfileBindingMap"

// Child wrapper object for SegmentSecurityProfile, used in hierarchical API
type ChildSegmentSecurityProfile struct {
    // Contains the actual SegmentSecurityProfile object
	SegmentSecurityProfile *SegmentSecurityProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentSecurityProfile__TYPE_IDENTIFIER = "ChildSegmentSecurityProfile"

// Child wrapper object for SegmentSecurityProfileBindingMap, used in hierarchical API
type ChildSegmentSecurityProfileBindingMap struct {
    // Contains the actual SegmentSecurityProfileBindingMap object
	SegmentSecurityProfileBindingMap *SegmentSecurityProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSegmentSecurityProfileBindingMap__TYPE_IDENTIFIER = "ChildSegmentSecurityProfileBindingMap"

// Child wrapper object for Service, used in hierarchical API.
type ChildService struct {
    // Contains the actual Service object.
	Service *Service
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildService__TYPE_IDENTIFIER = "ChildService"

// Child wrapper object for ServiceEntry, used in hierarchical API.
type ChildServiceEntry struct {
    // This is a deprecated property, Please use 'ServiceEntry' instead.
	Service *data.StructValue
    // Contains the actual ServiceEntry object.
	ServiceEntry *data.StructValue
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildServiceEntry__TYPE_IDENTIFIER = "ChildServiceEntry"

// Child wrapper object for ServiceInstanceEndpoint used in hierarchical API.
type ChildServiceInstanceEndpoint struct {
    // Contains actual ServiceInstanceEndpoint.
	ServiceInstanceEndpoint *ServiceInstanceEndpoint
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildServiceInstanceEndpoint__TYPE_IDENTIFIER = "ChildServiceInstanceEndpoint"

// Child wrapper object for ServiceInterface, used in hierarchical API.
type ChildServiceInterface struct {
    // Contains the actual ServiceInterface object.
	ServiceInterface *ServiceInterface
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildServiceInterface__TYPE_IDENTIFIER = "ChildServiceInterface"

// Child wrapper object for ServiceReference used in hierarchical API.
type ChildServiceReference struct {
    // Contains actual ServiceReference.
	ServiceReference *ServiceReference
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildServiceReference__TYPE_IDENTIFIER = "ChildServiceReference"

// Child wrapper object for ServiceSegment, used in hierarchical API
type ChildServiceSegment struct {
    // Contains the actual ServiceSegment objects
	ServiceSegment *ServiceSegment
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildServiceSegment__TYPE_IDENTIFIER = "ChildServiceSegment"

// Child wrapper object for SessionTimerProfileBindingMap, used in hierarchical API
type ChildSessionTimerProfileBindingMap struct {
    // Contains the actual SessionTimerProfileBindingMap object
	SessionTimerProfileBindingMap *SessionTimerProfileBindingMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSessionTimerProfileBindingMap__TYPE_IDENTIFIER = "ChildSessionTimerProfileBindingMap"

// Child wrapper object for Site, used in hierarchical API.
type ChildSite struct {
    // Contains the actual Site object.
	Site *Site
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSite__TYPE_IDENTIFIER = "ChildSite"

// Child wrapper object for SpoofGuardProfile, used in hierarchical API
type ChildSpoofGuardProfile struct {
    // Contains the actual SpoofGuardProfile object
	SpoofGuardProfile *SpoofGuardProfile
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSpoofGuardProfile__TYPE_IDENTIFIER = "ChildSpoofGuardProfile"

// Child wrapper for SslTrustObjectData, used in hierarchical API
type ChildSslTrustObjectData struct {
    // Contains the actual SslTrustObjectData object
	SslTrustObjectData *SslTrustObjectData
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildSslTrustObjectData__TYPE_IDENTIFIER = "ChildSslTrustObjectData"

// Wrapper object for StandaloneHostIdfwConfiguration
type ChildStandaloneHostIdfwConfiguration struct {
    // Contains the actual standalone host idfw configuration object.
	StandaloneHostIdfwConfiguration *StandaloneHostIdfwConfiguration
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildStandaloneHostIdfwConfiguration__TYPE_IDENTIFIER = "ChildStandaloneHostIdfwConfiguration"

// Child wrapper object for StaticARPConfig, used in hierarchical API.
type ChildStaticARPConfig struct {
    // Contains the actual StaticARPConfig object.
	StaticARPConfig *StaticARPConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildStaticARPConfig__TYPE_IDENTIFIER = "ChildStaticARPConfig"

// Child wrapper for StaticRouteBfdPeer, used in hierarchical API.
type ChildStaticRouteBfdPeer struct {
    // Contains the actual StaticRouteBfdPeer object.
	BfdPeer *StaticRouteBfdPeer
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildStaticRouteBfdPeer__TYPE_IDENTIFIER = "ChildStaticRouteBfdPeer"

// Child wrapper object for StaticRoutes, used in hierarchical API.
type ChildStaticRoutes struct {
    // Contains the actual StaticRoutes object.
	StaticRoutes *StaticRoutes
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildStaticRoutes__TYPE_IDENTIFIER = "ChildStaticRoutes"

// Child wrapper object for Tier-0, used in hierarchical API.
type ChildTier0 struct {
    // Contains the actual Tier-0 object.
	Tier0 *Tier0
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier0__TYPE_IDENTIFIER = "ChildTier0"

// Child wrapper object for Tier0DeploymentMap, used in hierarchical API.
type ChildTier0DeploymentMap struct {
    // Contains the actual Tier0DeploymentMap object.
	Tier0DeploymentMap *Tier0DeploymentMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier0DeploymentMap__TYPE_IDENTIFIER = "ChildTier0DeploymentMap"

// Child wrapper object for Tier0Interface, used in hierarchical API.
type ChildTier0Interface struct {
    // Contains the actual Tier0Interface object.
	Tier0Interface *Tier0Interface
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier0Interface__TYPE_IDENTIFIER = "ChildTier0Interface"

// Child wrapper object for Tier0RouteMap, used in hierarchical API
type ChildTier0RouteMap struct {
    // Contains the actual Tier0RouteMap object
	Tier0RouteMap *Tier0RouteMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier0RouteMap__TYPE_IDENTIFIER = "ChildTier0RouteMap"

// Child wrapper object for Tier-1 , used in hierarchical API.
type ChildTier1 struct {
    // Contains the actual Tier-1 object.
	Tier1 *Tier1
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier1__TYPE_IDENTIFIER = "ChildTier1"

// Child wrapper object for Tier1DeploymentMap, used in hierarchical API.
type ChildTier1DeploymentMap struct {
    // Contains the actual Tier1DeploymentMap object.
	Tier1DeploymentMap *Tier1DeploymentMap
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier1DeploymentMap__TYPE_IDENTIFIER = "ChildTier1DeploymentMap"

// Child wrapper object for Tier1Interface, used in hierarchical API.
type ChildTier1Interface struct {
    // Contains the actual Tier1Interface object.
	Tier1Interface *Tier1Interface
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTier1Interface__TYPE_IDENTIFIER = "ChildTier1Interface"

// Child wrapper for TlsCertificate, used in hierarchical API.
type ChildTlsCertificate struct {
    // Contains the actual TlsCertificate object.
	TlsCertificate *TlsCertificate
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTlsCertificate__TYPE_IDENTIFIER = "ChildTlsCertificate"

// Child wrapper for TlsCrl, used in hierarchical API.
type ChildTlsCrl struct {
    // Contains the actual TlsCrl object.
	TlsCrl *TlsCrl
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTlsCrl__TYPE_IDENTIFIER = "ChildTlsCrl"

// Child wrapper for TlsTrustData, used in hierarchical API.
type ChildTlsTrustData struct {
    // Contains the actual TlsTrustData object.
	TlsTrustData *TlsTrustData
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTlsTrustData__TYPE_IDENTIFIER = "ChildTlsTrustData"

// Child wrapper for TraceflowConfig, used in hierarchical API
type ChildTraceflowConfig struct {
    // Contains the actual TraceflowConfig object.
	TraceflowConfig *TraceflowConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildTraceflowConfig__TYPE_IDENTIFIER = "ChildTraceflowConfig"

// Child wrapper object for VHC, used in hierarchical API
type ChildVhc struct {
    // Contains the actual VHC object
	Vhc *Vhc
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildVhc__TYPE_IDENTIFIER = "ChildVhc"

// Child wrapper object for VhcDnsConfig, used in hierarchical API
type ChildVhcDnsConfig struct {
    // Contains the actual VhcDnsConfig object
	VhcDnsConfig *VhcDnsConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildVhcDnsConfig__TYPE_IDENTIFIER = "ChildVhcDnsConfig"

// Child wrapper object for VirtualEndpoint used in hierarchical API.
type ChildVirtualEndpoint struct {
    // Contains reference to actual VirtualEndpoint.
	VirtualEndpoint *VirtualEndpoint
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildVirtualEndpoint__TYPE_IDENTIFIER = "ChildVirtualEndpoint"

// Child wrapper object for VniPoolConfig, used in hierarchical API.
type ChildVniPoolConfig struct {
    // Contains the actual VniPoolConfig object.
	VniPoolConfig *VniPoolConfig
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // If this field is set to true, delete operation is triggered on the intent tree. This resource along with its all children in intent tree will be deleted. This is a cascade delete and should only be used if intent object along with its all children are to be deleted. This does not support deletion of single non-leaf node within the tree and should be used carefully.
	MarkedForDelete *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ChildVniPoolConfig__TYPE_IDENTIFIER = "ChildVniPoolConfig"

// DHCP classless static route option.
type ClasslessStaticRoute struct {
    // Destination network in CIDR format. format: address-or-block-or-range
	Network *string
    // IP address of next hop of the route. format: ip
	NextHop *string
}

// Stores the information about cloud native service instance.
type CloudNativeServiceInstance struct {
    // Id of service instance fetched from public cloud.
	ExternalId *string
    // Type of cloud native service.
	ServiceType *string
    // Reference of the public cloud gateway that reported the service instance.
	Source *ResourceReference
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}

// Cluster backup details
type ClusterBackupInfo struct {
    // IP address or FQDN of the node from which the backup was taken format: hostname-or-ip
	IpAddress *string
    // ID of the node from which the backup was taken
	NodeId *string
    // Possible values are: 
    //
    // * ClusterBackupInfo#ClusterBackupInfo_RESTORE_TYPE_REGULAR_RESTORE
    // * ClusterBackupInfo#ClusterBackupInfo_RESTORE_TYPE_POLICY_ONLY_RESTORE
    //
    //  Type of restore allowed
	RestoreType []string
    // timestamp of the cluster backup file format: int64
	Timestamp *int64
}
const ClusterBackupInfo_RESTORE_TYPE_REGULAR_RESTORE = "REGULAR_RESTORE"
const ClusterBackupInfo_RESTORE_TYPE_POLICY_ONLY_RESTORE = "POLICY_ONLY_RESTORE"

type ClusterBackupInfoListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // List of timestamps of backed-up cluster files
	Results []ClusterBackupInfo
}

// Cluster restore status
type ClusterRestoreStatus struct {
    // Timestamp when backup was initiated in epoch millisecond format: int64
	BackupTimestamp *int64
    // The list of allowed endpoints, based on the current state of the restore process
	Endpoints []ResourceLink
    // Unique id for backup request
	Id *string
    // Instructions for users to reconcile Restore operations
	Instructions []InstructionInfo
    // Timestamp when restore was completed in epoch millisecond format: int64
	RestoreEndTime *int64
    // Timestamp when restore was started in epoch millisecond format: int64
	RestoreStartTime *int64
	Status *GlobalRestoreStatus
	Step *RestoreStep
    // Total number of steps in the entire restore process format: int64
	TotalSteps *int64
}

// Represents a column of the Grid
type ColumnItem struct {
    // Identifies the column and used for fetching content upon an user click or drilldown. If column identifier is not provided, the column's data will not participate in searches and drilldowns.
	ColumnIdentifier *string
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget.
	DrilldownId *string
    // Field from which values of the column will be derived.
	Field *string
    // If set to true, hides the column
	Hidden *bool
    // Label of the column.
	Label *Label
    // Hyperlink of the specified UI page that provides details. If drilldown_id is provided, then navigation cannot be used.
	Navigation *string
    // Render configuration to be applied, if any.
	RenderConfiguration []RenderConfiguration
    // If true, the value of the column are sorted in ascending order. Otherwise, in descending order.
	SortAscending *bool
    // Sorting on column is based on the sort_key. sort_key represents the field in the output data on which sort is requested.
	SortKey *string
    // Multi-line text to be shown on tooltip while hovering over a cell in the grid.
	Tooltip []Tooltip
    // Possible values are: 
    //
    // * ColumnItem#ColumnItem_TYPE_STRING
    // * ColumnItem#ColumnItem_TYPE_NUMBER
    // * ColumnItem#ColumnItem_TYPE_DATE
    //
    //  Data type of the field.
	Type_ *string
}
const ColumnItem_TYPE_STRING = "String"
const ColumnItem_TYPE_NUMBER = "Number"
const ColumnItem_TYPE_DATE = "Date"

// A communication entry indicates the action to be performed for various types of traffic flowing between workload groups. This type is deprecated. Use the type Rule instead.
type CommunicationEntry struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * CommunicationEntry#CommunicationEntry_ACTION_ALLOW
    // * CommunicationEntry#CommunicationEntry_ACTION_DROP
    // * CommunicationEntry#CommunicationEntry_ACTION_REJECT
    //
    //  The action to be applied to all the services.
	Action *string
    // We need paths as duplicate names may exist for groups under different domains.In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	DestinationGroups []string
    // Possible values are: 
    //
    // * CommunicationEntry#CommunicationEntry_DIRECTION_IN
    // * CommunicationEntry#CommunicationEntry_DIRECTION_OUT
    // * CommunicationEntry#CommunicationEntry_DIRECTION_IN_OUT
    //
    //  Define direction of traffic.
	Direction *string
    // Flag to disable the rule. Default is enabled.
	Disabled *bool
    // Flag to enable packet logging. Default is disabled.
	Logged *bool
    // Text for additional notes on changes.
	Notes *string
    // The list of policy paths where the communication entry is applied Edge/LR/T0/T1/LRP/CGW/MGW/etc. Note that a given rule can be applied on multiple LRs/LRPs.
	Scope []string
    // This field is used to resolve conflicts between multiple CommunicationEntries under CommunicationMap for a Domain If no sequence number is specified in the payload, a value of 0 is assigned by default. If there are multiple communication entries with the same sequence number then their order is not deterministic. If a specific order of communication entry is desired, then one has to specify unique sequence numbers or use the POST request on the communication entry entity with a query parameter action=revise to let the framework assign a sequence number format: int32
	SequenceNumber *int64
    // In order to specify all services, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the services array. Error will be thrown if ANY is used in conjunction with other values.
	Services []string
    // We need paths as duplicate names may exist for groups under different domains. In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	SourceGroups []string
    // User level field which will be printed in CLI and packet logs.
	Tag *string
}
const CommunicationEntry_ACTION_ALLOW = "ALLOW"
const CommunicationEntry_ACTION_DROP = "DROP"
const CommunicationEntry_ACTION_REJECT = "REJECT"
const CommunicationEntry_DIRECTION_IN = "IN"
const CommunicationEntry_DIRECTION_OUT = "OUT"
const CommunicationEntry_DIRECTION_IN_OUT = "IN_OUT"

// This type is deprecated. Use the type RuleListResult instead.
type CommunicationEntryListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // CommunicationEntry list results
	Results []CommunicationEntry
}

// Parameters to let the admin specify a relative position of a communication map or communication entry w.r.t to another one. This type is deprecated. Use the type RuleInsertParameters instead.
type CommunicationInsertParameters struct {
    // The communication map/communication entry path if operation is 'insert_after' or 'insert_before'
	AnchorPath *string
    // Possible values are: 
    //
    // * CommunicationInsertParameters#CommunicationInsertParameters_OPERATION_TOP
    // * CommunicationInsertParameters#CommunicationInsertParameters_OPERATION_BOTTOM
    // * CommunicationInsertParameters#CommunicationInsertParameters_OPERATION_AFTER
    // * CommunicationInsertParameters#CommunicationInsertParameters_OPERATION_BEFORE
    //
    //  Operation
	Operation *string
}
const CommunicationInsertParameters_OPERATION_TOP = "insert_top"
const CommunicationInsertParameters_OPERATION_BOTTOM = "insert_bottom"
const CommunicationInsertParameters_OPERATION_AFTER = "insert_after"
const CommunicationInsertParameters_OPERATION_BEFORE = "insert_before"

// Ordered list of CommunicationEntries. This object is created by default along with the Domain. This type is deprecated. Use the type SecurityPolicy instead.
type CommunicationMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // - Distributed Firewall - Policy framework for Distributed Firewall provides four pre-defined categories for classifying a communication map. They are \"Emergency\", \"Infrastructure\", \"Environment\" and \"Application\". Amongst the layer 3 communication maps,there is a pre-determined order in which the policy framework manages the priority of these communication maps. Emergency category has the highest priority followed by Infrastructure, Environment and then Application rules. Administrator can choose to categorize a communication map into the above categories or can choose to leave it empty. If empty it will have the least precedence w.r.t the above four layer 3 categories.
	Category *string
    // CommunicationEntries that are a part of this CommunicationMap
	CommunicationEntries []CommunicationEntry
    // This field is used to resolve conflicts between communication maps across domains. In order to change the precedence of a communication map one can fire a POST request on the communication map entity with a query parameter action=revise The precedence field will reflect the value of the computed precedence upon execution of the above mentioned POST request. For scenarios where the administrator is using a template to update several communication maps, the only way to set the precedence is to explicitly specify the precedence number for each communication map. If no precedence is specified in the payload, a value of 0 is assigned by default. If there are multiple communication maps with the same precedence then their order is not deterministic. If a specific order of communication map is desired, then one has to specify a unique precedence or use the POST request on the communication map entity with a query parameter action=revise to let the framework assign a precedence format: int32
	Precedence *int64
}

// This type is deprecated. Use the type SecurityPolicyListResult instead.
type CommunicationMapListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // CommunicationMap list results
	Results []CommunicationMap
}

// Community list for BGP routing configuration
type CommunityList struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // List of BGP community entries. Both standard and large communities are supported. Standard community format: aa:nn where aa and nn must be within the range [1 - 65536]. Large BGP Community format: aa:bb:nn where aa (Global Administrator), bb (Local Data Part 1) and nn (Local Data Part 2) must be within the range [1 - 4294967295]. In additon to numbered communites (e.g. 3356:2040), predefined communities (NO_EXPORT, NO_ADVERTISE, NO_EXPORT_SUBCONFED) are supported.
	Communities []string
}

// Paged collection of CommunityLists
type CommunityListListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // CommunityList results
	Results []CommunityList
}

// Match criteria based on a community list
type CommunityMatchCriteria struct {
    // Match criteria specified as a community list path or a regular expression.
	Criteria *string
    // Possible values are: 
    //
    // * CommunityMatchCriteria#CommunityMatchCriteria_MATCH_OPERATOR_ANY
    // * CommunityMatchCriteria#CommunityMatchCriteria_MATCH_OPERATOR_ALL
    // * CommunityMatchCriteria#CommunityMatchCriteria_MATCH_OPERATOR_EXACT
    // * CommunityMatchCriteria#CommunityMatchCriteria_MATCH_OPERATOR_COMMUNITY_REGEX
    // * CommunityMatchCriteria#CommunityMatchCriteria_MATCH_OPERATOR_LARGE_COMMUNITY_REGEX
    //
    //  Match operator for community list entries. Not valid when a regular expression is specified for criteria.
	MatchOperator *string
}
const CommunityMatchCriteria_MATCH_OPERATOR_ANY = "MATCH_ANY"
const CommunityMatchCriteria_MATCH_OPERATOR_ALL = "MATCH_ALL"
const CommunityMatchCriteria_MATCH_OPERATOR_EXACT = "MATCH_EXACT"
const CommunityMatchCriteria_MATCH_OPERATOR_COMMUNITY_REGEX = "MATCH_COMMUNITY_REGEX"
const CommunityMatchCriteria_MATCH_OPERATOR_LARGE_COMMUNITY_REGEX = "MATCH_LARGE_COMMUNITY_REGEX"

// Idfw configuration for enable/disable idfw on cluster level.
type ComputeClusterIdfwConfiguration struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If set to true, idfw is enabled for this cluster
	ClusterIdfwEnabled *bool
    // Contains actual policy resource reference object
	Member *PolicyResourceReference
}

// Paged collection of compute cluster idfw configuration
type ComputeClusterIdfwConfigurationListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Compute cluster wise identity firewall configuration list results
	Results []ComputeClusterIdfwConfiguration
}

type ComputeCollection struct {
    // Local Id of the compute collection in the Compute Manager
	CmLocalId *string
    // External ID of the ComputeCollection in the source Compute manager, e.g. mo-ref in VC
	ExternalId *string
    // Id of the compute manager from where this Compute Collection was discovered
	OriginId *string
    // Key-Value map of additional specific properties of compute collection in the Compute Manager
	OriginProperties []KeyValuePair
    // ComputeCollection type like VC_Cluster. Here the Compute Manager type prefix would help in differentiating similar named Compute Collection types from different Compute Managers
	OriginType *string
    // Id of the owner of compute collection in the Compute Manager
	OwnerId *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}

// Represents the leaf level condition. Evaluation of the condition expression will be case insensitive.
type Condition struct {
    // Possible values are: 
    //
    // * Condition#Condition_KEY_TAG
    // * Condition#Condition_KEY_NAME
    // * Condition#Condition_KEY_OSNAME
    // * Condition#Condition_KEY_COMPUTERNAME
    //
    //  Key
	Key *string
    // Possible values are: 
    //
    // * Condition#Condition_MEMBER_TYPE_IPSET
    // * Condition#Condition_MEMBER_TYPE_VIRTUALMACHINE
    // * Condition#Condition_MEMBER_TYPE_LOGICALPORT
    // * Condition#Condition_MEMBER_TYPE_LOGICALSWITCH
    // * Condition#Condition_MEMBER_TYPE_SEGMENT
    // * Condition#Condition_MEMBER_TYPE_SEGMENTPORT
    //
    //  Group member type
	MemberType *string
    // Possible values are: 
    //
    // * Condition#Condition_OPERATOR_EQUALS
    // * Condition#Condition_OPERATOR_CONTAINS
    // * Condition#Condition_OPERATOR_STARTSWITH
    // * Condition#Condition_OPERATOR_ENDSWITH
    // * Condition#Condition_OPERATOR_NOTEQUALS
    //
    //  operator
	Operator *string
    // Value
	Value *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * Expression#Expression_RESOURCE_TYPE_CONDITION
    // * Expression#Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR
    // * Expression#Expression_RESOURCE_TYPE_NESTEDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_PATHEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const Condition__TYPE_IDENTIFIER = "Condition"
const Condition_KEY_TAG = "Tag"
const Condition_KEY_NAME = "Name"
const Condition_KEY_OSNAME = "OSName"
const Condition_KEY_COMPUTERNAME = "ComputerName"
const Condition_MEMBER_TYPE_IPSET = "IPSet"
const Condition_MEMBER_TYPE_VIRTUALMACHINE = "VirtualMachine"
const Condition_MEMBER_TYPE_LOGICALPORT = "LogicalPort"
const Condition_MEMBER_TYPE_LOGICALSWITCH = "LogicalSwitch"
const Condition_MEMBER_TYPE_SEGMENT = "Segment"
const Condition_MEMBER_TYPE_SEGMENTPORT = "SegmentPort"
const Condition_OPERATOR_EQUALS = "EQUALS"
const Condition_OPERATOR_CONTAINS = "CONTAINS"
const Condition_OPERATOR_STARTSWITH = "STARTSWITH"
const Condition_OPERATOR_ENDSWITH = "ENDSWITH"
const Condition_OPERATOR_NOTEQUALS = "NOTEQUALS"

// Represents the leaf level expression to restrict the target attribute value based on the set of existing values. Generally, used in combination with RelatedAttributeConditionalExpression to constraint the values related to another attribute on the same resource. This object is always used in conjunction with some exression. Example - { \"condition\" : { \"operator\":\"INCLUDES\", \"rhs_value\": [\"/infra/domains/mgw/groups/VCENTER\", \"/infra/domains/mgw/groups/SRM\", \"/infra/domains/mgw/groups/NSX\"], \"value_constraint\": { \"resource_type\": \"ValueConstraintExpression\", \"operator\":\"EXCLUDES\", \"values\":[\"/infra/domains/mgw/groups/VCENTER\", \"/infra/domains/mgw/groups/SRM\", \"/infra/domains/mgw/groups/NSX\"] } }
type ConditionalValueConstraintExpression struct {
    // Possible values are: 
    //
    // * ConditionalValueConstraintExpression#ConditionalValueConstraintExpression_OPERATOR_INCLUDES
    // * ConditionalValueConstraintExpression#ConditionalValueConstraintExpression_OPERATOR_EXCLUDES
    // * ConditionalValueConstraintExpression#ConditionalValueConstraintExpression_OPERATOR_EQUALS
    //
    //  Set operation to constraint values.
	Operator *string
    // List of values.
	RhsValue []string
    // Values to apply the conditional constraint on target.
	ValueConstraint *ValueConstraintExpression
}
const ConditionalValueConstraintExpression_OPERATOR_INCLUDES = "INCLUDES"
const ConditionalValueConstraintExpression_OPERATOR_EXCLUDES = "EXCLUDES"
const ConditionalValueConstraintExpression_OPERATOR_EQUALS = "EQUALS"

// Describes status of configuration of an entity
type ConfigurationState struct {
    // Array of configuration state of various sub systems
	Details []ConfigurationStateElement
    // Error code format: int64
	FailureCode *int64
    // Error message in case of failure
	FailureMessage *string
    // Possible values are: 
    //
    // * ConfigurationState#ConfigurationState_STATE_PENDING
    // * ConfigurationState#ConfigurationState_STATE_IN_PROGRESS
    // * ConfigurationState#ConfigurationState_STATE_SUCCESS
    // * ConfigurationState#ConfigurationState_STATE_FAILED
    // * ConfigurationState#ConfigurationState_STATE_PARTIAL_SUCCESS
    // * ConfigurationState#ConfigurationState_STATE_ORPHANED
    // * ConfigurationState#ConfigurationState_STATE_UNKNOWN
    // * ConfigurationState#ConfigurationState_STATE_ERROR
    // * ConfigurationState#ConfigurationState_STATE_IN_SYNC
    // * ConfigurationState#ConfigurationState_STATE_NOT_AVAILABLE
    // * ConfigurationState#ConfigurationState_STATE_VM_DEPLOYMENT_QUEUED
    // * ConfigurationState#ConfigurationState_STATE_VM_DEPLOYMENT_IN_PROGRESS
    // * ConfigurationState#ConfigurationState_STATE_VM_DEPLOYMENT_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_POWER_ON_IN_PROGRESS
    // * ConfigurationState#ConfigurationState_STATE_VM_POWER_ON_FAILED
    // * ConfigurationState#ConfigurationState_STATE_REGISTRATION_PENDING
    // * ConfigurationState#ConfigurationState_STATE_NODE_NOT_READY
    // * ConfigurationState#ConfigurationState_STATE_NODE_READY
    // * ConfigurationState#ConfigurationState_STATE_VM_POWER_OFF_IN_PROGRESS
    // * ConfigurationState#ConfigurationState_STATE_VM_POWER_OFF_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_UNDEPLOY_IN_PROGRESS
    // * ConfigurationState#ConfigurationState_STATE_VM_UNDEPLOY_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_UNDEPLOY_SUCCESSFUL
    // * ConfigurationState#ConfigurationState_STATE_EDGE_CONFIG_ERROR
    // * ConfigurationState#ConfigurationState_STATE_VM_DEPLOYMENT_RESTARTED
    // * ConfigurationState#ConfigurationState_STATE_REGISTRATION_FAILED
    // * ConfigurationState#ConfigurationState_STATE_TRANSPORT_NODE_SYNC_PENDING
    // * ConfigurationState#ConfigurationState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING
    // * ConfigurationState#ConfigurationState_STATE_EDGE_HARDWARE_NOT_SUPPORTED
    // * ConfigurationState#ConfigurationState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED
    // * ConfigurationState#ConfigurationState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER
    // * ConfigurationState#ConfigurationState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED
    // * ConfigurationState#ConfigurationState_STATE_NO_PNIC_PREPARED_IN_EDGE
    // * ConfigurationState#ConfigurationState_STATE_APPLIANCE_INTERNAL_ERROR
    // * ConfigurationState#ConfigurationState_STATE_VTEP_DHCP_NOT_SUPPORTED
    // * ConfigurationState#ConfigurationState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE
    // * ConfigurationState#ConfigurationState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED
    // * ConfigurationState#ConfigurationState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND
    // * ConfigurationState#ConfigurationState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED
    // * ConfigurationState#ConfigurationState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY
    // * ConfigurationState#ConfigurationState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationState#ConfigurationState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationState#ConfigurationState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationState#ConfigurationState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE
    // * ConfigurationState#ConfigurationState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE
    // * ConfigurationState#ConfigurationState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED
    // * ConfigurationState#ConfigurationState_STATE_NO_PNIC_SPECIFIED_IN_TN
    // * ConfigurationState#ConfigurationState_STATE_INVALID_PNIC_DEVICE_NAME
    // * ConfigurationState#ConfigurationState_STATE_TRANSPORT_NODE_READY
    // * ConfigurationState#ConfigurationState_STATE_VM_NETWORK_EDIT_PENDING
    // * ConfigurationState#ConfigurationState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY
    // * ConfigurationState#ConfigurationState_STATE_MPA_DISCONNECTED
    // * ConfigurationState#ConfigurationState_STATE_VM_RENAME_PENDING
    // * ConfigurationState#ConfigurationState_STATE_VM_CONFIG_EDIT_PENDING
    // * ConfigurationState#ConfigurationState_STATE_VM_NETWORK_EDIT_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_RENAME_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_CONFIG_EDIT_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_CONFIG_DISCREPANCY
    // * ConfigurationState#ConfigurationState_STATE_VM_NODE_REFRESH_FAILED
    // * ConfigurationState#ConfigurationState_STATE_VM_PLACEMENT_REFRESH_FAILED
    // * ConfigurationState#ConfigurationState_STATE_REGISTRATION_TIMEDOUT
    //
    //  Gives details of state of desired configuration. Additional enums with more details on progress/success/error states are sent for edge node. The success states are NODE_READY and TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED, VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values indicate failures. \"in_sync\" state indicates that the desired configuration has been received by the host to which it applies, but is not yet in effect. When the configuration is actually in effect, the state will change to \"success\". Please note, failed state is deprecated.
	State *string
}
const ConfigurationState_STATE_PENDING = "pending"
const ConfigurationState_STATE_IN_PROGRESS = "in_progress"
const ConfigurationState_STATE_SUCCESS = "success"
const ConfigurationState_STATE_FAILED = "failed"
const ConfigurationState_STATE_PARTIAL_SUCCESS = "partial_success"
const ConfigurationState_STATE_ORPHANED = "orphaned"
const ConfigurationState_STATE_UNKNOWN = "unknown"
const ConfigurationState_STATE_ERROR = "error"
const ConfigurationState_STATE_IN_SYNC = "in_sync"
const ConfigurationState_STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
const ConfigurationState_STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
const ConfigurationState_STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
const ConfigurationState_STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
const ConfigurationState_STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
const ConfigurationState_STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
const ConfigurationState_STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
const ConfigurationState_STATE_NODE_NOT_READY = "NODE_NOT_READY"
const ConfigurationState_STATE_NODE_READY = "NODE_READY"
const ConfigurationState_STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
const ConfigurationState_STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
const ConfigurationState_STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
const ConfigurationState_STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
const ConfigurationState_STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
const ConfigurationState_STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
const ConfigurationState_STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
const ConfigurationState_STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
const ConfigurationState_STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
const ConfigurationState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
const ConfigurationState_STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
const ConfigurationState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
const ConfigurationState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
const ConfigurationState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
const ConfigurationState_STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
const ConfigurationState_STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
const ConfigurationState_STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
const ConfigurationState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
const ConfigurationState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
const ConfigurationState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
const ConfigurationState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
const ConfigurationState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
const ConfigurationState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
const ConfigurationState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
const ConfigurationState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
const ConfigurationState_STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
const ConfigurationState_STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
const ConfigurationState_STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
const ConfigurationState_STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
const ConfigurationState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
const ConfigurationState_STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
const ConfigurationState_STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
const ConfigurationState_STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
const ConfigurationState_STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
const ConfigurationState_STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
const ConfigurationState_STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
const ConfigurationState_STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
const ConfigurationState_STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
const ConfigurationState_STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
const ConfigurationState_STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"

// Describes status of configuration of an entity
type ConfigurationStateElement struct {
    // Error code format: int64
	FailureCode *int64
    // Error message in case of failure
	FailureMessage *string
    // Possible values are: 
    //
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_IN_PROGRESS
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_SUCCESS
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_PARTIAL_SUCCESS
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_IN_SYNC
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_DEPLOYMENT_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_POWER_ON_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_POWER_OFF_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_UNDEPLOY_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_EDGE_CONFIG_ERROR
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_REGISTRATION_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_EDGE_HARDWARE_NOT_SUPPORTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_TZ_ENDPOINTS_NOT_SPECIFIED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_NO_PNIC_PREPARED_IN_EDGE
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_APPLIANCE_INTERNAL_ERROR
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VTEP_DHCP_NOT_SUPPORTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_HOSTSWITCH_PROFILE_NOT_FOUND
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_NO_PNIC_SPECIFIED_IN_TN
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_INVALID_PNIC_DEVICE_NAME
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_MPA_DISCONNECTED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_NETWORK_EDIT_PENDING
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_RENAME_PENDING
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_CONFIG_EDIT_PENDING
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_NETWORK_EDIT_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_RENAME_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_CONFIG_EDIT_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_CONFIG_DISCREPANCY
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_NODE_REFRESH_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_VM_PLACEMENT_REFRESH_FAILED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_NOT_AVAILABLE
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_REGISTRATION_TIMEDOUT
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_PENDING
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_ORPHANED
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_UNKNOWN
    // * ConfigurationStateElement#ConfigurationStateElement_STATE_ERROR
    //
    //  State of configuration on this sub system
	State *string
    // URI of backing resource on sub system
	SubSystemAddress *string
    // Identifier of backing resource on sub system
	SubSystemId *string
    // Name of backing resource on sub system
	SubSystemName *string
    // Type of backing resource on sub system
	SubSystemType *string
}
const ConfigurationStateElement_STATE_IN_PROGRESS = "in_progress"
const ConfigurationStateElement_STATE_SUCCESS = "success"
const ConfigurationStateElement_STATE_FAILED = "failed"
const ConfigurationStateElement_STATE_PARTIAL_SUCCESS = "partial_success"
const ConfigurationStateElement_STATE_IN_SYNC = "in_sync"
const ConfigurationStateElement_STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
const ConfigurationStateElement_STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
const ConfigurationStateElement_STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
const ConfigurationStateElement_STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
const ConfigurationStateElement_STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
const ConfigurationStateElement_STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
const ConfigurationStateElement_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
const ConfigurationStateElement_STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
const ConfigurationStateElement_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
const ConfigurationStateElement_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
const ConfigurationStateElement_STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
const ConfigurationStateElement_STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
const ConfigurationStateElement_STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
const ConfigurationStateElement_STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
const ConfigurationStateElement_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
const ConfigurationStateElement_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
const ConfigurationStateElement_STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
const ConfigurationStateElement_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
const ConfigurationStateElement_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
const ConfigurationStateElement_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationStateElement_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationStateElement_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
const ConfigurationStateElement_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
const ConfigurationStateElement_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
const ConfigurationStateElement_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
const ConfigurationStateElement_STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
const ConfigurationStateElement_STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
const ConfigurationStateElement_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
const ConfigurationStateElement_STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
const ConfigurationStateElement_STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
const ConfigurationStateElement_STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
const ConfigurationStateElement_STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
const ConfigurationStateElement_STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
const ConfigurationStateElement_STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
const ConfigurationStateElement_STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
const ConfigurationStateElement_STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
const ConfigurationStateElement_STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
const ConfigurationStateElement_STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
const ConfigurationStateElement_STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
const ConfigurationStateElement_STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"
const ConfigurationStateElement_STATE_PENDING = "pending"
const ConfigurationStateElement_STATE_ORPHANED = "orphaned"
const ConfigurationStateElement_STATE_UNKNOWN = "unknown"
const ConfigurationStateElement_STATE_ERROR = "error"

// Represents the operators AND or OR.
type ConjunctionOperator struct {
    // Possible values are: 
    //
    // * ConjunctionOperator#ConjunctionOperator_CONJUNCTION_OPERATOR_OR
    // * ConjunctionOperator#ConjunctionOperator_CONJUNCTION_OPERATOR_AND
    //
    //  Conjunction Operator Node
	ConjunctionOperator *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * Expression#Expression_RESOURCE_TYPE_CONDITION
    // * Expression#Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR
    // * Expression#Expression_RESOURCE_TYPE_NESTEDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_PATHEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ConjunctionOperator__TYPE_IDENTIFIER = "ConjunctionOperator"
const ConjunctionOperator_CONJUNCTION_OPERATOR_OR = "OR"
const ConjunctionOperator_CONJUNCTION_OPERATOR_AND = "AND"

// Advanced configuration for Policy connectivity
type ConnectivityAdvancedConfig struct {
    // Possible values are: 
    //
    // * ConnectivityAdvancedConfig#ConnectivityAdvancedConfig_CONNECTIVITY_ON
    // * ConnectivityAdvancedConfig#ConnectivityAdvancedConfig_CONNECTIVITY_OFF
    //
    //  Connectivity configuration to manually connect (ON) or disconnect (OFF) a logical entity from network topology. Only valid for Tier1 Segment.
	Connectivity *string
}
const ConnectivityAdvancedConfig_CONNECTIVITY_ON = "ON"
const ConnectivityAdvancedConfig_CONNECTIVITY_OFF = "OFF"

// Consolidated Realized Status of an intent object across enforcement points.
type ConsolidatedRealizedStatus struct {
    // Intent path of object, forward slashes must be escaped using %2F.
	IntentPath *string
    // Consolidated Realized Status across enforcement points.
	ConsolidatedStatus *ConsolidatedStatus
    // List of Consolidated Realized Status per enforcement point.
	ConsolidatedStatusPerEnforcementPoint []ConsolidatedStatusPerEnforcementPoint
}

// Consolidated Status of an intent object. Status Consolidation of an intent happens at multiple levels: - Per Enforcement Point: calculation of the consolidated status is performed using all realized entities that the intent objet maps to on a specific enforcement point. - Across Enforcement Points: calculation of the consolidated status is performend aggregating the consolidated status from each enforcement point.
type ConsolidatedStatus struct {
    // Possible values are: 
    //
    // * ConsolidatedStatus#ConsolidatedStatus_CONSOLIDATED_STATUS_SUCCESS
    // * ConsolidatedStatus#ConsolidatedStatus_CONSOLIDATED_STATUS_IN_PROGRESS
    // * ConsolidatedStatus#ConsolidatedStatus_CONSOLIDATED_STATUS_ERROR
    // * ConsolidatedStatus#ConsolidatedStatus_CONSOLIDATED_STATUS_UNKNOWN
    // * ConsolidatedStatus#ConsolidatedStatus_CONSOLIDATED_STATUS_UNINITIALIZED
    //
    //  Consolidated Realized Status of an intent object.
	ConsolidatedStatus *string
}
const ConsolidatedStatus_CONSOLIDATED_STATUS_SUCCESS = "SUCCESS"
const ConsolidatedStatus_CONSOLIDATED_STATUS_IN_PROGRESS = "IN_PROGRESS"
const ConsolidatedStatus_CONSOLIDATED_STATUS_ERROR = "ERROR"
const ConsolidatedStatus_CONSOLIDATED_STATUS_UNKNOWN = "UNKNOWN"
const ConsolidatedStatus_CONSOLIDATED_STATUS_UNINITIALIZED = "UNINITIALIZED"

// Detailed Realized Status of an intent object on an NSX-T type of enforcement point.
type ConsolidatedStatusNsxt struct {
    // Detailed Realized Status inherent to an NSX-T Enforcement Point.
	EnforcedStatus *EnforcedStatusDetailsNsxt
    // Alarm information details.
	Alarm *PolicyRuntimeAlarm
    // Policy Path referencing the enforcement point where the info is fetched.
	EnforcementPointPath *string
    // Consolidated Realized Status of an Intent object per enforcement point.
	ConsolidatedStatus *ConsolidatedStatus
    // Enforcement Point Id.
	EnforcementPointId *string
	ResourceType string
    // The site where this enforcement point resides.
	SitePath *string
}

// Consolidated Realized Status Per Enforcement Point.
type ConsolidatedStatusPerEnforcementPoint struct {
    // Alarm information details.
	Alarm *PolicyRuntimeAlarm
    // Policy Path referencing the enforcement point where the info is fetched.
	EnforcementPointPath *string
    // Consolidated Realized Status of an Intent object per enforcement point.
	ConsolidatedStatus *ConsolidatedStatus
    // Enforcement Point Id.
	EnforcementPointId *string
	ResourceType string
    // The site where this enforcement point resides.
	SitePath *string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ConsolidatedStatusPerEnforcementPoint__TYPE_IDENTIFIER = "ConsolidatedStatusPerEnforcementPoint"

// Constant Field Value.
type ConstantFieldValue struct {
    // Constant Value that the field must be set to.
	Constant *data.StructValue
    // Possible values are: 
    //
    // * FieldSettingValue#FieldSettingValue_RESOURCE_TYPE_CONSTANTFIELDVALUE
    //
    //  Field Setting Value resource type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ConstantFieldValue__TYPE_IDENTIFIER = "ConstantFieldValue"

// Constraint object to constraint any attribute on a resource based on specified expression. Example- Restrict the allowed services in Edge Communication Entry to list of services, if the destinationGroups contain vCenter. { \"target\":{ \"target_resource_type\":\"CommunicationEntry\", \"attribute\":\"services\", \"path_prefix\":\"/infra/domains/vmc-domain/edge-communication-maps/default/communication-entries\" } \"constraint_expression\":{ \"related_attribute\":{ \"attribute\":\"destinationGroups\" } \"condition\":{ \"operator\":\"INCLUDES\", \"rhs_value\":{\"vCenter\"} \"value_constraint\":{ \"operator\":\"ALLOW\", \"values\":{\"/ref/services/HTTPS\", \"/ref/services/HTTOP\", ...} } } } }
type Constraint struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Expression to constrain the target attribute value.
	ConstraintExpression *data.StructValue
    // User friendly message to be shown to users upon violation.
	Message *string
    // Target resource attribute details.
	Target *ConstraintTarget
}

// All the types of the expression extend from this abstract class. This is present for extensibility.
type ConstraintExpression struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_VALUECONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_RELATEDATTRIBUTECONDITIONALEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_ENTITYINSTANCECOUNTCONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_FIELDSANITYCONSTRAINTEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ConstraintExpression__TYPE_IDENTIFIER = "ConstraintExpression"
const ConstraintExpression_RESOURCE_TYPE_VALUECONSTRAINTEXPRESSION = "ValueConstraintExpression"
const ConstraintExpression_RESOURCE_TYPE_RELATEDATTRIBUTECONDITIONALEXPRESSION = "RelatedAttributeConditionalExpression"
const ConstraintExpression_RESOURCE_TYPE_ENTITYINSTANCECOUNTCONSTRAINTEXPRESSION = "EntityInstanceCountConstraintExpression"
const ConstraintExpression_RESOURCE_TYPE_FIELDSANITYCONSTRAINTEXPRESSION = "FieldSanityConstraintExpression"

// Paged Collection of Constraints
type ConstraintListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Constraint list results
	Results []Constraint
}

// Resource attribute on which constraint should be applied. Example - sourceGroups attribute of Edge CommunicationEntry to be restricted, is given as: { \"target_resource_type\":\"CommunicationEntry\", \"attribute\":\"sourceGroups\", \"path_prefix\":\"/infra/domains/vmc-domain/edge-communication-maps/default/communication-entries\" }
type ConstraintTarget struct {
    // Attribute name of the target entity.
	Attribute *string
    // Path prefix of the entity to apply constraint. This is required to further disambiguiate if multiple policy entities share the same resource type. Example - Edge FW and DFW use the same resource type CommunicationMap, CommunicationEntry, Group, etc.
	PathPrefix *string
    // Resource type of the target entity.
	TargetResourceType *string
}

// Container application within a project.
type ContainerApplication struct {
    // Identifier of the container cluster this container application belongs to.
	ContainerClusterId *string
    // Identifier of the project which this container application belongs to.
	ContainerProjectId *string
    // Identifier of the container application on container cluster e.g. PCF app id, k8s service id.
	ExternalId *string
    // List of network errors related to container application.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerApplication#ContainerApplication_NETWORK_STATUS_HEALTHY
    // * ContainerApplication#ContainerApplication_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container application.
	NetworkStatus *string
    // Array of additional specific properties of container application in key-value format.
	OriginProperties []KeyValuePair
    // Possible values are: 
    //
    // * ContainerApplication#ContainerApplication_STATUS_UNKNOWN
    // * ContainerApplication#ContainerApplication_STATUS_HEALTHY
    // * ContainerApplication#ContainerApplication_STATUS_UP
    // * ContainerApplication#ContainerApplication_STATUS_DOWN
    // * ContainerApplication#ContainerApplication_STATUS_DEGRADED
    //
    //  Status of the container application.
	Status *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerApplication__TYPE_IDENTIFIER = "ContainerApplication"
const ContainerApplication_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerApplication_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
const ContainerApplication_STATUS_UNKNOWN = "UNKNOWN"
const ContainerApplication_STATUS_HEALTHY = "HEALTHY"
const ContainerApplication_STATUS_UP = "UP"
const ContainerApplication_STATUS_DOWN = "DOWN"
const ContainerApplication_STATUS_DEGRADED = "DEGRADED"

// Container application instance within a project.
type ContainerApplicationInstance struct {
    // Cluster node id where application instance is running.
	ClusterNodeId *string
    // List of identifiers of the container application.
	ContainerApplicationIds []string
    // Identifier of the container cluster this application instance belongs to.
	ContainerClusterId *string
    // Identifier of the container project which this container application instance belongs to.
	ContainerProjectId *string
    // Identifier of the container application instance on container cluster.
	ExternalId *string
    // List of network errors related to container application instance.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerApplicationInstance#ContainerApplicationInstance_NETWORK_STATUS_HEALTHY
    // * ContainerApplicationInstance#ContainerApplicationInstance_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container application instance.
	NetworkStatus *string
    // Array of additional specific properties of container application instance in key-value format.
	OriginProperties []KeyValuePair
    // Possible values are: 
    //
    // * ContainerApplicationInstance#ContainerApplicationInstance_STATUS_UNKNOWN
    // * ContainerApplicationInstance#ContainerApplicationInstance_STATUS_HEALTHY
    // * ContainerApplicationInstance#ContainerApplicationInstance_STATUS_UP
    // * ContainerApplicationInstance#ContainerApplicationInstance_STATUS_DOWN
    // * ContainerApplicationInstance#ContainerApplicationInstance_STATUS_DEGRADED
    //
    //  Status of the container application instance.
	Status *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerApplicationInstance__TYPE_IDENTIFIER = "ContainerApplicationInstance"
const ContainerApplicationInstance_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerApplicationInstance_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
const ContainerApplicationInstance_STATUS_UNKNOWN = "UNKNOWN"
const ContainerApplicationInstance_STATUS_HEALTHY = "HEALTHY"
const ContainerApplicationInstance_STATUS_UP = "UP"
const ContainerApplicationInstance_STATUS_DOWN = "DOWN"
const ContainerApplicationInstance_STATUS_DEGRADED = "DEGRADED"

// Details of container cluster.
type ContainerCluster struct {
    // Possible values are: 
    //
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_PAS
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_PKS
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_KUBERNETES
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_OPENSHIFT
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_WCP
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_WCP_GUEST
    // * ContainerCluster#ContainerCluster_CLUSTER_TYPE_OTHER
    //
    //  Type of the container cluster. In case of creating container cluster first time, it is expected to pass the valid cluster-type. In case of update, if there is no change in cluster-type, then this field can be omitted in the request.
	ClusterType *string
    // External identifier of the container cluster.
	ExternalId *string
    // Details of underlying infrastructure that hosts the container cluster. In case of creating container cluster first time, it is expected to pass the valid infrastructure. In case of update, if there is no change in cluster-type, then this field can be omitted in the request.
	Infrastructure *ContainerInfrastructureInfo
    // List of network errors related to container cluster.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerCluster#ContainerCluster_NETWORK_STATUS_HEALTHY
    // * ContainerCluster#ContainerCluster_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container cluster.
	NetworkStatus *string
    // Array of additional specific properties of container cluster in key-value format.
	OriginProperties []KeyValuePair
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerCluster__TYPE_IDENTIFIER = "ContainerCluster"
const ContainerCluster_CLUSTER_TYPE_PAS = "PAS"
const ContainerCluster_CLUSTER_TYPE_PKS = "PKS"
const ContainerCluster_CLUSTER_TYPE_KUBERNETES = "Kubernetes"
const ContainerCluster_CLUSTER_TYPE_OPENSHIFT = "Openshift"
const ContainerCluster_CLUSTER_TYPE_WCP = "WCP"
const ContainerCluster_CLUSTER_TYPE_WCP_GUEST = "WCP_Guest"
const ContainerCluster_CLUSTER_TYPE_OTHER = "Other"
const ContainerCluster_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerCluster_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"

// Details of container cluster node i.e. container host.
type ContainerClusterNode struct {
    // External identifier of the container cluster.
	ContainerClusterId *string
    // External identifier of the container cluster node in K8S/PAS.
	ExternalId *string
    // List of IP addresses of container cluster node. format: ip
	IpAddresses []string
    // List of network errors related to container cluster node.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerClusterNode#ContainerClusterNode_NETWORK_STATUS_HEALTHY
    // * ContainerClusterNode#ContainerClusterNode_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container cluster node.
	NetworkStatus *string
    // Array of additional specific properties of container cluster node in key-value format.
	OriginProperties []KeyValuePair
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerClusterNode__TYPE_IDENTIFIER = "ContainerClusterNode"
const ContainerClusterNode_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerClusterNode_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"

// Represents a container to group widgets that belong to a common category or have a common purpose.
type ContainerConfiguration struct {
	Header *Header
    // Labels for the container.
	Labels []Label
    // Layout of widgets can be either vertical or horizontal. If layout is not specified a default horizontal layout is applied.
	Layout *Layout
    // Hyperlink of the specified UI page that provides details.
	Navigation *string
    // If not specified, creates an empty container.
	Widgets []WidgetItem
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerConfiguration__TYPE_IDENTIFIER = "ContainerConfiguration"

// Details of infrastructure hosting the container cluster e.g. vSphere, AWS, VMC etc..
type ContainerInfrastructureInfo struct {
    // Possible values are: 
    //
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_VSPHERE
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_AWS
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_AZURE
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_VMC
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_KVM
    // * ContainerInfrastructureInfo#ContainerInfrastructureInfo_INFRA_TYPE_BAREMETAL
    //
    //  Type of the infrastructure.
	InfraType *string
}
const ContainerInfrastructureInfo_INFRA_TYPE_VSPHERE = "vSphere"
const ContainerInfrastructureInfo_INFRA_TYPE_AWS = "AWS"
const ContainerInfrastructureInfo_INFRA_TYPE_AZURE = "Azure"
const ContainerInfrastructureInfo_INFRA_TYPE_VMC = "VMC"
const ContainerInfrastructureInfo_INFRA_TYPE_KVM = "KVM"
const ContainerInfrastructureInfo_INFRA_TYPE_BAREMETAL = "Baremetal"

// Details of Container Ingress Policy.
type ContainerIngressPolicy struct {
    // List of identifiers of the container application , on which ingress policy is applied. e.g. IDs of all services on which the ingress is applied in kubernetes.
	ContainerApplicationIds []string
    // Identifier of the container cluster this ingress policy belongs to.
	ContainerClusterId *string
    // Identifier of the project which this container ingress belongs to.
	ContainerProjectId *string
    // Identifier of the container ingress policy.
	ExternalId *string
    // List of network errors related to container ingress.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerIngressPolicy#ContainerIngressPolicy_NETWORK_STATUS_HEALTHY
    // * ContainerIngressPolicy#ContainerIngressPolicy_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container ingress.
	NetworkStatus *string
    // Array of additional specific properties of container ingress in key-value format.
	OriginProperties []KeyValuePair
    // Container ingress policy specification.
	Spec *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerIngressPolicy__TYPE_IDENTIFIER = "ContainerIngressPolicy"
const ContainerIngressPolicy_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerIngressPolicy_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"

// Network policy applied to container.
type ContainerNetworkPolicy struct {
    // Identifier of the container cluster this network policy belongs to.
	ContainerClusterId *string
    // Identifier of the project which this network policy belongs to.
	ContainerProjectId *string
    // Identifier of the container network policy.
	ExternalId *string
    // List of network errors related to container network policy.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerNetworkPolicy#ContainerNetworkPolicy_NETWORK_STATUS_HEALTHY
    // * ContainerNetworkPolicy#ContainerNetworkPolicy_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container network policy.
	NetworkStatus *string
    // Array of additional specific properties of container network policy in key-value format.
	OriginProperties []KeyValuePair
    // Possible values are: 
    //
    // * ContainerNetworkPolicy#ContainerNetworkPolicy_POLICY_TYPE_NETWORK_POLICY
    // * ContainerNetworkPolicy#ContainerNetworkPolicy_POLICY_TYPE_ASG
    //
    //  Type e.g. Network Policy, ASG.
	PolicyType *string
    // Container network policy specification.
	Spec *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerNetworkPolicy__TYPE_IDENTIFIER = "ContainerNetworkPolicy"
const ContainerNetworkPolicy_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerNetworkPolicy_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"
const ContainerNetworkPolicy_POLICY_TYPE_NETWORK_POLICY = "NETWORK_POLICY"
const ContainerNetworkPolicy_POLICY_TYPE_ASG = "ASG"

// Details of org/namespace within a container cluster.
type ContainerProject struct {
    // Identifier of the container cluster to which this project/namespace belongs.
	ContainerClusterId *string
    // External identifier of the container project.
	ExternalId *string
    // List of network errors related to container project.
	NetworkErrors []NetworkError
    // Possible values are: 
    //
    // * ContainerProject#ContainerProject_NETWORK_STATUS_HEALTHY
    // * ContainerProject#ContainerProject_NETWORK_STATUS_UNHEALTHY
    //
    //  Network status of container project.
	NetworkStatus *string
    // Array of additional specific properties of container project in key-value format.
	OriginProperties []KeyValuePair
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ContainerProject__TYPE_IDENTIFIER = "ContainerProject"
const ContainerProject_NETWORK_STATUS_HEALTHY = "HEALTHY"
const ContainerProject_NETWORK_STATUS_UNHEALTHY = "UNHEALTHY"

// Event Criterion is the logical evaluations by which the event may be deemed fulfilled. All the evaluations must be met in order for the criterion to be met (implicit AND).
type Criterion struct {
    // Criterion Evaluations.
	Evaluations []*data.StructValue
}

// Base type for CSV result.
type CsvListResult struct {
    // File name set by HTTP server if API returns CSV result as a file.
	FileName *string
}

// Base type for CSV records.
type CsvRecord struct {
}

// Current backup operation status
type CurrentBackupOperationStatus struct {
    // Unique identifier of current backup
	BackupId *string
    // Possible values are: 
    //
    // * CurrentBackupOperationStatus#CurrentBackupOperationStatus_CURRENT_STEP_CLUSTER_BACKUP
    // * CurrentBackupOperationStatus#CurrentBackupOperationStatus_CURRENT_STEP_NODE_BACKUP
    //
    //  Current step of operation
	CurrentStep *string
    // Additional human-readable status information about current step
	CurrentStepMessage *string
    // Time when operation is expected to end format: int64
	EndTime *int64
    // Possible values are: 
    //
    // * CurrentBackupOperationStatus#CurrentBackupOperationStatus_OPERATION_TYPE_NONE
    // * CurrentBackupOperationStatus#CurrentBackupOperationStatus_OPERATION_TYPE_BACKUP
    //
    //  Type of operation that is in progress. Returns none if no operation is in progress, in which case none of the other fields will be set.
	OperationType *string
    // Time when operation was started format: int64
	StartTime *int64
}
const CurrentBackupOperationStatus_CURRENT_STEP_CLUSTER_BACKUP = "BACKUP_CREATING_CLUSTER_BACKUP"
const CurrentBackupOperationStatus_CURRENT_STEP_NODE_BACKUP = "BACKUP_CREATING_NODE_BACKUP"
const CurrentBackupOperationStatus_OPERATION_TYPE_NONE = "NONE"
const CurrentBackupOperationStatus_OPERATION_TYPE_BACKUP = "BACKUP"

// Some applications maintain state and require all relevant connections to be sent to the same server as the application state is not synchronized among servers. Persistence is enabled on a PolicyLbVirtualServer by binding a persistence profile to it.
type CustomPolicyLbPersistenceProfile struct {
    // Possible values are: 
    //
    // * CustomPolicyLbPersistenceProfile#CustomPolicyLbPersistenceProfile_PERSISTENCE_COOKIE
    // * CustomPolicyLbPersistenceProfile#CustomPolicyLbPersistenceProfile_PERSISTENCE_SOURCE_IP
    //
    //  This field indicates the persistence method used for the PolicyLbVirtualServer. - COOKIE persistence allows related client connections, identified by the same cookie in HTTP requests [Refer to HTTP Cookie for details on HTTP cookies], to be redirected to the same server. Load balancer does not maintain any persistence table for cookie persistence. Instead, it encodes the necessary information in the HTTP cookie value sent to client and relies on the client to store it and send it back in subsequent related HTTP requests. Hence there is no limit on the number of cookie persistence entries that can be supported. - SOURCE_IP persistence ensures all connections from a client (identified by IP address) are sent to the same backend server for a specified period. - This object is not required and without creation of this object the virtual server persistence is disabled by default
	Persistence *string
    // Persistence shared setting indicates that all PolicyLbVirtualServers that consume this PolicyLbPersistenceProfile should share the same persistence mechanism when enabled. Meaning, persistence entries of a client accessing one virtual server will also affect the same client's connections to a different virtual server. For example, say there are two virtual servers vip-ip1:80 and vip-ip1:8080 bound to the same Group g1 consisting of two servers (s11:80 and s12:80). By default, each virtual server will have its own persistence table or cookie. So, in the earlier example, there will be two tables (vip-ip1:80, p1) and (vip-ip1:8080, p1) or cookies. So, if a client connects to vip1:80 and later connects to vip1:8080, the second connection may be sent to a different server than the first. When persistence_shared is enabled, then the second connection will always connect to the same server as the original connection. For COOKIE persistence type, the same cookie will be shared by multiple virtual servers. For SOURCE_IP persistenct type, the persistence table will be shared across virtual servers.
	PersistenceShared *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbPersistenceProfile#PolicyLbPersistenceProfile_RESOURCE_TYPE_L4POLICYLBPERSISTENCEPROFILE
    // * PolicyLbPersistenceProfile#PolicyLbPersistenceProfile_RESOURCE_TYPE_L7POLICYLBPERSISTENCEPROFILE
    // * PolicyLbPersistenceProfile#PolicyLbPersistenceProfile_RESOURCE_TYPE_CUSTOMPOLICYLBPERSISTENCEPROFILE
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const CustomPolicyLbPersistenceProfile__TYPE_IDENTIFIER = "CustomPolicyLbPersistenceProfile"
const CustomPolicyLbPersistenceProfile_PERSISTENCE_COOKIE = "COOKIE"
const CustomPolicyLbPersistenceProfile_PERSISTENCE_SOURCE_IP = "SOURCE_IP"

// Virtual server acts as a facade to an application, receives all client connections over a specified protocol and distributes them among the backend servers. This custom type allows for more complex settings than the simplified PolicyLbVirtualServer types. This object allows for complex configurations for PolicyLbVirtualServers of all types. All HTTP specific inputs will be rejected when combined with TPC or UDP protocols.
type CustomPolicyLbVirtualServer struct {
    // Possible values are: 
    //
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_APP_PROTOCOL_TCP
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_APP_PROTOCOL_UDP
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_APP_PROTOCOL_HTTP
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_APP_PROTOCOL_HTTPS
    //
    //  As the custom type allows for more complex settings than the simplified PolicyLbVirtualServer types, also specify the desired protocol for receiving all client connections.
	AppProtocol *string
    // Client-side SSL profile binding allows multiple certificates, for different hostnames, to be bound to the same virtual server. The setting is used when load balancer acts as an SSL server and terminating the client SSL connection
	ClientSslCertificateIds []string
    // Possible values are: 
    //
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_BASE_SECURE_111317
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_MODERATE_SECURE_111317
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_HIGH_SECURE_111317
    //
    //  Security settings representing various security settings when the VirtualServer acts as an SSL server - BASE_SECURE_111317 - MODERATE_SECURE_111317 - HIGH_SECURE_111317
	ClientSslSettings *string
    // The setting is used when load balancer acts as an SSL server and terminating the client SSL connection. A default certificate should be specified which will be used if the server does not host multiple hostnames on the same IP address or if the client does not support SNI extension.
	DefaultClientSslCertificateId *string
    // To support client authentication (load balancer acting as a client authenticating to the backend server), server_ssl_certificate_id can be specified. When supplied, the backend server certificate must be signed by one of the trusted Certificate Authorities (CAs), also referred to as root CAs, whose self signed certificates are specified. This setting is only applicable for L7 protocols and will be rejected in combination with TCP or UDP.
	ServerAuthCaCertificateIds []string
    // Possible values are: 
    //
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_BASE_SECURE_111317
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_MODERATE_SECURE_111317
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_HIGH_SECURE_111317
    // * CustomPolicyLbVirtualServer#CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_DISABLED
    //
    //  Indicates whether to enable server side SSL. Server side SSL will be enabled when a specific security setting is selected. The selected security setting or profile represents various configurations related to SSL when the VirtualServer acts as a client connecting over SSL to the backend server. This setting is only applicable for L7 protocols and will be rejected in combination with TCP or UDP. - BASE_SECURE_111317 - MODERATE_SECURE_111317 - HIGH_SECURE_111317 - DISABLED
	ServerSslSettings *string
    // Backend web servers typically log each request they handle along with the requesting client IP address. These logs are used for debugging, analytics and other such purposes. If the deployment topology requires enabling SNAT on the load balancer, then server will see the client as the SNAT IP which defeats the purpose of logging. To work around this issue, load balancer can be configured to insert XFF HTTP header with the original client IP address. Backend servers can then be configured to log the IP address in XFF header instead of the source IP address of the connection. If XFF header is not present in the incoming request, load balancer inserts a new XFF header with the client IP address.
	InsertClientIpHeader *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_TCPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_UDPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPSPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_CUSTOMPOLICYLBVIRTUALSERVER
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If access log is enabled, all HTTP requests sent to an L7 virtual server are logged to the access log file. Both successful requests (backend server returns 2xx) and unsuccessful requests (backend server returns 4xx or 5xx) are logged to access log, if enabled.
	AccessLogEnabled *bool
    // Configures the IP address of the PolicyLbVirtualServer where it receives all client connections and distributes them among the backend servers. format: ip
	IpAddress *string
    // Path to optional object that enables persistence on a virtual server allowing related client connections to be sent to the same backend server. Persistence is disabled by default.
	LbPersistenceProfile *string
    // Ports contains a list of at least one port or port range such as \"80\", \"1234-1236\". Each port element in the list should be a single port or a single port range. format: port-or-range
	Ports []string
    // Path to router type object that PolicyLbVirtualServer connects to. The only supported router object is Network.
	RouterPath *string
	TrafficSource *string
}
const CustomPolicyLbVirtualServer_APP_PROTOCOL_TCP = "TCP"
const CustomPolicyLbVirtualServer_APP_PROTOCOL_UDP = "UDP"
const CustomPolicyLbVirtualServer_APP_PROTOCOL_HTTP = "HTTP"
const CustomPolicyLbVirtualServer_APP_PROTOCOL_HTTPS = "HTTPS"
const CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_BASE_SECURE_111317 = "BASE_SECURE_111317"
const CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_MODERATE_SECURE_111317 = "MODERATE_SECURE_111317"
const CustomPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_HIGH_SECURE_111317 = "HIGH_SECURE_111317"
const CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_BASE_SECURE_111317 = "BASE_SECURE_111317"
const CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_MODERATE_SECURE_111317 = "MODERATE_SECURE_111317"
const CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_HIGH_SECURE_111317 = "HIGH_SECURE_111317"
const CustomPolicyLbVirtualServer_SERVER_SSL_SETTINGS_DISABLED = "DISABLED"

// Represents configuration for custom widget. For this widget the data source is not applicable. It defines ui identifer to identify UI component and render it on dashboard view. This configuration can only be used for system owned widgets.
type CustomWidgetConfiguration struct {
    // User defined component selector to be rendered inside view/container.
	UiComponentIdentifier *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const CustomWidgetConfiguration__TYPE_IDENTIFIER = "CustomWidgetConfiguration"

// Credential info to connect to a CVX type of enforcement point.
type CvxConnectionInfo struct {
    // Password.
	Password *string
    // Thumbprint of EnforcementPoint in the form of a SHA-256 hash represented in lower case HEX.
	Thumbprint *string
    // Username.
	Username *string
    // Value of this property could be Hostname or IP. For instance: - On an NSX-T MP running on default port, the value could be \"10.192.1.1\" - On an NSX-T MP running on custom port, the value could be \"192.168.1.1:32789\" - On an NSX-T MP in VMC deployments, the value could be \"192.168.1.1:5480/nsxapi\"
	EnforcementPointAddress *string
    // Possible values are: 
    //
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXTCONNECTIONINFO
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXVCONNECTIONINFO
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_CVXCONNECTIONINFO
    //
    //  Resource Type of Enforcement Point Connection Info.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const CvxConnectionInfo__TYPE_IDENTIFIER = "CvxConnectionInfo"

// DNS forwarder statistics per enforcement point.
type DNSForwarderStatisticsPerEnforcementPoint struct {
    // Policy path referencing the enforcement point from where the statistics are fetched.
	EnforcementPointPath *string
    // Possible values are: 
    //
    // * DNSForwarderStatisticsPerEnforcementPoint#DNSForwarderStatisticsPerEnforcementPoint_RESOURCE_TYPE_NSXTDNSFORWARDERSTATISTICS
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DNSForwarderStatisticsPerEnforcementPoint__TYPE_IDENTIFIER = "DNSForwarderStatisticsPerEnforcementPoint"
const DNSForwarderStatisticsPerEnforcementPoint_RESOURCE_TYPE_NSXTDNSFORWARDERSTATISTICS = "NsxTDNSForwarderStatistics"

// DNS forwarder status per enforcement point.
type DNSForwarderStatusPerEnforcementPoint struct {
    // Policy path referencing the enforcement point from where the status is fetched.
	EnforcementPointPath *string
    // Possible values are: 
    //
    // * DNSForwarderStatusPerEnforcementPoint#DNSForwarderStatusPerEnforcementPoint_RESOURCE_TYPE_NSXTDNSFORWARDERSTATUS
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DNSForwarderStatusPerEnforcementPoint__TYPE_IDENTIFIER = "DNSForwarderStatusPerEnforcementPoint"
const DNSForwarderStatusPerEnforcementPoint_RESOURCE_TYPE_NSXTDNSFORWARDERSTATUS = "NsxTDNSForwarderStatus"

type DataCounter struct {
    // The dropped packets or bytes format: int64
	Dropped *int64
    // The multicast and broadcast packets or bytes format: int64
	MulticastBroadcast *int64
    // The total packets or bytes format: int64
	Total *int64
}

type DataSourceParameters struct {
    // Possible values are: 
    //
    // * DataSourceParameters#DataSourceParameters_SOURCE_REALTIME
    // * DataSourceParameters#DataSourceParameters_SOURCE_CACHED
    //
    //  The data source, either realtime or cached. If not provided, cached data is returned.
	Source *string
}
const DataSourceParameters_SOURCE_REALTIME = "realtime"
const DataSourceParameters_SOURCE_CACHED = "cached"

// An instance of a datasource configuration.
type Datasource struct {
    // Name of a datasource instance.
	DisplayName *string
    // Array of urls relative to the datasource configuration. For example, api/v1/fabric/nodes is a relative url of nsx-manager instance.
	Urls []UrlAlias
}

// An instance of a datasource configuration.
type DefaultFilterValue struct {
    // Filter alias.
	Alias *string
    // Filter default value.
	Value *string
}

// Deployment Template holds the attributes specific to partner for which the service is created. These attributes are opaque to NSX.
type DeploymentTemplate struct {
    // List of attributes specific to a partner for which the service is created. There attributes are passed on to the partner appliance and is opaque to the NSX Manager.
	Attributes []Attribute
    // Deployment Template name.
	Name *string
}

// Logical grouping of enforcement points. This is a deprecated type. DeploymentZone has been renamed to Site. Use Site.
type DeploymentZone struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Logical grouping of enforcement points
	EnforcementPoints []EnforcementPoint
}

// Paged Collection of Deployment Zones. This is a deprecated type. DeploymentZone has been renamed to Site. Use SiteListResult.
type DeploymentZoneListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Deployment Zones
	Results []DeploymentZone
}

// DFW Firewall related configurations
type DfwFirewallConfiguration struct {
    // If set to true, identity firewall is enabled.
	IdfwEnabled *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * FirewallConfiguration#FirewallConfiguration_RESOURCE_TYPE_DFWFIREWALLCONFIGURATION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // To disable auto drafts, set it to true. By default, auto drafts are enabled.
	DisableAutoDrafts *bool
    // If set to true, Firewall is enabled.
	EnableFirewall *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DfwFirewallConfiguration__TYPE_IDENTIFIER = "DfwFirewallConfiguration"

type DhcpHeader struct {
    // Possible values are: 
    //
    // * DhcpHeader#DhcpHeader_OP_CODE_BOOTREQUEST
    // * DhcpHeader#DhcpHeader_OP_CODE_BOOTREPLY
    //
    //  This is used to specify the general type of message. A client sending request to a server uses an op code of BOOTREQUEST, while a server replying uses an op code of BOOTREPLY.
	OpCode *string
}
const DhcpHeader_OP_CODE_BOOTREQUEST = "BOOTREQUEST"
const DhcpHeader_OP_CODE_BOOTREPLY = "BOOTREPLY"

type DhcpIpPoolUsage struct {
    // allocated number. COULD BE INACCURATE, REFERENCE ONLY. format: int64
	AllocatedNumber *int64
    // allocated percentage. COULD BE INACCURATE, REFERENCE ONLY. format: int64
	AllocatedPercentage *int64
    // uuid of dhcp ip pool
	DhcpIpPoolId *string
    // pool size format: int64
	PoolSize *int64
}

type DhcpLeasePerIP struct {
    // expire time of the lease
	ExpireTime *string
    // ip address of client
	IpAddress *string
    // lease time of the ip address, in seconds
	LeaseTime *string
    // mac address of client
	MacAddress *string
    // start time of lease
	StartTime *string
    // subnet of client network
	Subnet *string
}

type DhcpLeases struct {
    // dhcp server uuid
	DhcpServerId *string
    // The lease info list of the server
	Leases []DhcpLeasePerIP
    // timestamp of the lease info format: int64
	Timestamp *int64
}

type DhcpLeasesResult struct {
    // dhcp server uuid
	DhcpServerId *string
    // The lease info list of the server
	Leases []DhcpLeasePerIP
    // timestamp of the lease info format: int64
	Timestamp *int64
    // Policy path to Segment, Tier0 or Tier1 gateway where DHCP server is attached.
	ConnectivityPath *string
}

// DHCP option 121 to define classless static route.
type DhcpOption121 struct {
    // Classless static route of DHCP option 121.
	StaticRoutes []ClasslessStaticRoute
}

// DHCP relay configuration. Please note, the realized-state of this entity returned by the \"GET /policy/api/v1/infra/realized-state/realized-entity\" with this entity policy-path is irrelevant with the application status of this entity. Please do not rely on this returned realized-state to determine how this dhcp-relay-config was applied. The dhcp realization information was reflected in the realization states of the referencing Segment or T0/T1 gateway.
type DhcpRelayConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // DHCP server IP addresses for DHCP relay configuration. Both IPv4 and IPv6 addresses are supported. format: ip
	ServerAddresses []string
}

// Paged collection of DhcpRelayConfigs
type DhcpRelayConfigListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // DhcpRelayConfig results
	Results []DhcpRelayConfig
}

// DHCP server configuration. Please note, the realized-state of this entity returned by the \"GET /policy/api/v1/infra/realized-state/realized-entity\" with this entity policy-path is irrelevant with the application status of this entity. Please do not rely on this returned realized-state to determine how this dhcp-server-config was applied. The dhcp realization information was reflected in the realization states of the referencing Segment or T0/T1 gateway.
type DhcpServerConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Edge cluster path. Auto assigned if only one edge cluster is configured on enforcement-point. Modifying edge cluster will reallocate DHCP server to the new edge cluster. Please note that re-allocating edge-cluster will result in losing of all exisitng DHCP lease information. Change edge cluster only when losing DHCP leases is not a real problem, e.g. cross-site migration or failover and all client hosts will be reboot and get new IP addresses.
	EdgeClusterPath *string
    // IP address lease time in seconds. format: int64
	LeaseTime *int64
    // Policy paths to edge nodes on which the DHCP servers run. The first edge node is assigned as active edge, and second one as stanby edge. If only one edge node is specified, the DHCP servers will run without HA support. When this property is not specified, edge nodes are auto-assigned during realization of the DHCP server.
	PreferredEdgePaths []string
    // DHCP server address in CIDR format. Prefix length should be less than or equal to 30. DHCP server is deployed as DHCP relay service. This property is deprecated, use server_addresses instead. Both properties cannot be specified together with different new values. format: ip-cidr-block
	ServerAddress *string
    // DHCP server address in CIDR format. Both IPv4 and IPv6 address families are supported. Prefix length should be less than or equal to 30 for IPv4 address family and less than or equal to 126 for IPv6. When not specified, IPv4 value is auto-assigned to 100.96.0.1/30. Ignored when this object is configured at a Segment. format: ip-cidr-block
	ServerAddresses []string
}

// Paged collection of DhcpServerConfigs
type DhcpServerConfigListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // DhcpServerConfig results
	Results []DhcpServerConfig
}

type DhcpServerState struct {
    // Array of configuration state of various sub systems
	Details []ConfigurationStateElement
    // Error code format: int64
	FailureCode *int64
    // Error message in case of failure
	FailureMessage *string
    // Possible values are: 
    //
    // * DhcpServerState#DhcpServerState_STATE_PENDING
    // * DhcpServerState#DhcpServerState_STATE_IN_PROGRESS
    // * DhcpServerState#DhcpServerState_STATE_SUCCESS
    // * DhcpServerState#DhcpServerState_STATE_FAILED
    // * DhcpServerState#DhcpServerState_STATE_PARTIAL_SUCCESS
    // * DhcpServerState#DhcpServerState_STATE_ORPHANED
    // * DhcpServerState#DhcpServerState_STATE_UNKNOWN
    // * DhcpServerState#DhcpServerState_STATE_ERROR
    // * DhcpServerState#DhcpServerState_STATE_IN_SYNC
    // * DhcpServerState#DhcpServerState_STATE_NOT_AVAILABLE
    // * DhcpServerState#DhcpServerState_STATE_VM_DEPLOYMENT_QUEUED
    // * DhcpServerState#DhcpServerState_STATE_VM_DEPLOYMENT_IN_PROGRESS
    // * DhcpServerState#DhcpServerState_STATE_VM_DEPLOYMENT_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_POWER_ON_IN_PROGRESS
    // * DhcpServerState#DhcpServerState_STATE_VM_POWER_ON_FAILED
    // * DhcpServerState#DhcpServerState_STATE_REGISTRATION_PENDING
    // * DhcpServerState#DhcpServerState_STATE_NODE_NOT_READY
    // * DhcpServerState#DhcpServerState_STATE_NODE_READY
    // * DhcpServerState#DhcpServerState_STATE_VM_POWER_OFF_IN_PROGRESS
    // * DhcpServerState#DhcpServerState_STATE_VM_POWER_OFF_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_UNDEPLOY_IN_PROGRESS
    // * DhcpServerState#DhcpServerState_STATE_VM_UNDEPLOY_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_UNDEPLOY_SUCCESSFUL
    // * DhcpServerState#DhcpServerState_STATE_EDGE_CONFIG_ERROR
    // * DhcpServerState#DhcpServerState_STATE_VM_DEPLOYMENT_RESTARTED
    // * DhcpServerState#DhcpServerState_STATE_REGISTRATION_FAILED
    // * DhcpServerState#DhcpServerState_STATE_TRANSPORT_NODE_SYNC_PENDING
    // * DhcpServerState#DhcpServerState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING
    // * DhcpServerState#DhcpServerState_STATE_EDGE_HARDWARE_NOT_SUPPORTED
    // * DhcpServerState#DhcpServerState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED
    // * DhcpServerState#DhcpServerState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER
    // * DhcpServerState#DhcpServerState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED
    // * DhcpServerState#DhcpServerState_STATE_NO_PNIC_PREPARED_IN_EDGE
    // * DhcpServerState#DhcpServerState_STATE_APPLIANCE_INTERNAL_ERROR
    // * DhcpServerState#DhcpServerState_STATE_VTEP_DHCP_NOT_SUPPORTED
    // * DhcpServerState#DhcpServerState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE
    // * DhcpServerState#DhcpServerState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED
    // * DhcpServerState#DhcpServerState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND
    // * DhcpServerState#DhcpServerState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED
    // * DhcpServerState#DhcpServerState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY
    // * DhcpServerState#DhcpServerState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpServerState#DhcpServerState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpServerState#DhcpServerState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpServerState#DhcpServerState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE
    // * DhcpServerState#DhcpServerState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE
    // * DhcpServerState#DhcpServerState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED
    // * DhcpServerState#DhcpServerState_STATE_NO_PNIC_SPECIFIED_IN_TN
    // * DhcpServerState#DhcpServerState_STATE_INVALID_PNIC_DEVICE_NAME
    // * DhcpServerState#DhcpServerState_STATE_TRANSPORT_NODE_READY
    // * DhcpServerState#DhcpServerState_STATE_VM_NETWORK_EDIT_PENDING
    // * DhcpServerState#DhcpServerState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY
    // * DhcpServerState#DhcpServerState_STATE_MPA_DISCONNECTED
    // * DhcpServerState#DhcpServerState_STATE_VM_RENAME_PENDING
    // * DhcpServerState#DhcpServerState_STATE_VM_CONFIG_EDIT_PENDING
    // * DhcpServerState#DhcpServerState_STATE_VM_NETWORK_EDIT_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_RENAME_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_CONFIG_EDIT_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_CONFIG_DISCREPANCY
    // * DhcpServerState#DhcpServerState_STATE_VM_NODE_REFRESH_FAILED
    // * DhcpServerState#DhcpServerState_STATE_VM_PLACEMENT_REFRESH_FAILED
    // * DhcpServerState#DhcpServerState_STATE_REGISTRATION_TIMEDOUT
    //
    //  Gives details of state of desired configuration. Additional enums with more details on progress/success/error states are sent for edge node. The success states are NODE_READY and TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED, VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values indicate failures. \"in_sync\" state indicates that the desired configuration has been received by the host to which it applies, but is not yet in effect. When the configuration is actually in effect, the state will change to \"success\". Please note, failed state is deprecated.
	State *string
}
const DhcpServerState_STATE_PENDING = "pending"
const DhcpServerState_STATE_IN_PROGRESS = "in_progress"
const DhcpServerState_STATE_SUCCESS = "success"
const DhcpServerState_STATE_FAILED = "failed"
const DhcpServerState_STATE_PARTIAL_SUCCESS = "partial_success"
const DhcpServerState_STATE_ORPHANED = "orphaned"
const DhcpServerState_STATE_UNKNOWN = "unknown"
const DhcpServerState_STATE_ERROR = "error"
const DhcpServerState_STATE_IN_SYNC = "in_sync"
const DhcpServerState_STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
const DhcpServerState_STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
const DhcpServerState_STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
const DhcpServerState_STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
const DhcpServerState_STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
const DhcpServerState_STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
const DhcpServerState_STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
const DhcpServerState_STATE_NODE_NOT_READY = "NODE_NOT_READY"
const DhcpServerState_STATE_NODE_READY = "NODE_READY"
const DhcpServerState_STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
const DhcpServerState_STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
const DhcpServerState_STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
const DhcpServerState_STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
const DhcpServerState_STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
const DhcpServerState_STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
const DhcpServerState_STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
const DhcpServerState_STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
const DhcpServerState_STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
const DhcpServerState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
const DhcpServerState_STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
const DhcpServerState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
const DhcpServerState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
const DhcpServerState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
const DhcpServerState_STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
const DhcpServerState_STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
const DhcpServerState_STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
const DhcpServerState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
const DhcpServerState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
const DhcpServerState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
const DhcpServerState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
const DhcpServerState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
const DhcpServerState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpServerState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpServerState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpServerState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
const DhcpServerState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
const DhcpServerState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
const DhcpServerState_STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
const DhcpServerState_STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
const DhcpServerState_STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
const DhcpServerState_STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
const DhcpServerState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
const DhcpServerState_STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
const DhcpServerState_STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
const DhcpServerState_STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
const DhcpServerState_STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
const DhcpServerState_STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
const DhcpServerState_STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
const DhcpServerState_STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
const DhcpServerState_STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
const DhcpServerState_STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
const DhcpServerState_STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"

type DhcpServerStatistics struct {
    // The total number of DHCP ACK packets format: int64
	Acks *int64
    // The total number of DHCP DECLINE packets format: int64
	Declines *int64
    // dhcp server uuid
	DhcpServerId *string
    // The total number of DHCP DISCOVER packets format: int64
	Discovers *int64
    // The total number of DHCP errors format: int64
	Errors *int64
    // The total number of DHCP INFORM packets format: int64
	Informs *int64
    // The DHCP ip pool usage statistics
	IpPoolStats []DhcpIpPoolUsage
    // The total number of DHCP NACK packets format: int64
	Nacks *int64
    // The total number of DHCP OFFER packets format: int64
	Offers *int64
    // The total number of DHCP RELEASE packets format: int64
	Releases *int64
    // The total number of DHCP REQUEST packets format: int64
	Requests *int64
    // timestamp of the statistics format: int64
	Timestamp *int64
}

type DhcpServerStatus struct {
    // uuid of active transport node
	ActiveNode *string
    // Error message, if available
	ErrorMessage *string
    // Possible values are: 
    //
    // * DhcpServerStatus#DhcpServerStatus_SERVICE_STATUS_UP
    // * DhcpServerStatus#DhcpServerStatus_SERVICE_STATUS_DOWN
    // * DhcpServerStatus#DhcpServerStatus_SERVICE_STATUS_ERROR
    // * DhcpServerStatus#DhcpServerStatus_SERVICE_STATUS_NO_STANDBY
    //
    //  UP means the dhcp service is working fine on both active transport-node and stand-by transport-node (if have), hence fail-over can work at this time if there is failure happens on one of the transport-node; DOWN means the dhcp service is down on both active transport-node and stand-by node (if have), hence the dhcp-service will not repsonse any dhcp request; Error means error happens on transport-node(s) or no status is reported from transport-node(s). The dhcp service may be working (or not working); NO_STANDBY means dhcp service is working in one of the transport node while not in the other transport-node (if have). Hence if the dhcp service in the working transport-node is down, fail-over will not happen and the dhcp service will go down.
	ServiceStatus *string
    // uuid of stand_by transport node. null if non-HA mode
	StandByNode *string
}
const DhcpServerStatus_SERVICE_STATUS_UP = "UP"
const DhcpServerStatus_SERVICE_STATUS_DOWN = "DOWN"
const DhcpServerStatus_SERVICE_STATUS_ERROR = "ERROR"
const DhcpServerStatus_SERVICE_STATUS_NO_STANDBY = "NO_STANDBY"

// DHCP IPv4 and IPv6 static bindings are extended from this abstract class.
type DhcpStaticBindingConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV4STATICBINDINGCONFIG
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV6STATICBINDINGCONFIG
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DhcpStaticBindingConfig__TYPE_IDENTIFIER = "DhcpStaticBindingConfig"
const DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV4STATICBINDINGCONFIG = "DhcpV4StaticBindingConfig"
const DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV6STATICBINDINGCONFIG = "DhcpV6StaticBindingConfig"

type DhcpStaticBindingConfigListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Paginated list of DhcpStaticBindingConfig
	Results []*data.StructValue
}

type DhcpStaticBindingState struct {
    // Array of configuration state of various sub systems
	Details []ConfigurationStateElement
    // Error code format: int64
	FailureCode *int64
    // Error message in case of failure
	FailureMessage *string
    // Possible values are: 
    //
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_IN_PROGRESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_SUCCESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_PARTIAL_SUCCESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_ORPHANED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UNKNOWN
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_ERROR
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_IN_SYNC
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_NOT_AVAILABLE
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_DEPLOYMENT_QUEUED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_DEPLOYMENT_IN_PROGRESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_DEPLOYMENT_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_POWER_ON_IN_PROGRESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_POWER_ON_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_REGISTRATION_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_NODE_NOT_READY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_NODE_READY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_POWER_OFF_IN_PROGRESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_POWER_OFF_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_UNDEPLOY_IN_PROGRESS
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_UNDEPLOY_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_UNDEPLOY_SUCCESSFUL
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_EDGE_CONFIG_ERROR
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_DEPLOYMENT_RESTARTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_REGISTRATION_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_TRANSPORT_NODE_SYNC_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_EDGE_HARDWARE_NOT_SUPPORTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_NO_PNIC_PREPARED_IN_EDGE
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_APPLIANCE_INTERNAL_ERROR
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VTEP_DHCP_NOT_SUPPORTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_NO_PNIC_SPECIFIED_IN_TN
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_INVALID_PNIC_DEVICE_NAME
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_TRANSPORT_NODE_READY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_NETWORK_EDIT_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_MPA_DISCONNECTED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_RENAME_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_CONFIG_EDIT_PENDING
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_NETWORK_EDIT_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_RENAME_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_CONFIG_EDIT_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_CONFIG_DISCREPANCY
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_NODE_REFRESH_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_VM_PLACEMENT_REFRESH_FAILED
    // * DhcpStaticBindingState#DhcpStaticBindingState_STATE_REGISTRATION_TIMEDOUT
    //
    //  Gives details of state of desired configuration. Additional enums with more details on progress/success/error states are sent for edge node. The success states are NODE_READY and TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED, VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values indicate failures. \"in_sync\" state indicates that the desired configuration has been received by the host to which it applies, but is not yet in effect. When the configuration is actually in effect, the state will change to \"success\". Please note, failed state is deprecated.
	State *string
}
const DhcpStaticBindingState_STATE_PENDING = "pending"
const DhcpStaticBindingState_STATE_IN_PROGRESS = "in_progress"
const DhcpStaticBindingState_STATE_SUCCESS = "success"
const DhcpStaticBindingState_STATE_FAILED = "failed"
const DhcpStaticBindingState_STATE_PARTIAL_SUCCESS = "partial_success"
const DhcpStaticBindingState_STATE_ORPHANED = "orphaned"
const DhcpStaticBindingState_STATE_UNKNOWN = "unknown"
const DhcpStaticBindingState_STATE_ERROR = "error"
const DhcpStaticBindingState_STATE_IN_SYNC = "in_sync"
const DhcpStaticBindingState_STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
const DhcpStaticBindingState_STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
const DhcpStaticBindingState_STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
const DhcpStaticBindingState_STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
const DhcpStaticBindingState_STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
const DhcpStaticBindingState_STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
const DhcpStaticBindingState_STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
const DhcpStaticBindingState_STATE_NODE_NOT_READY = "NODE_NOT_READY"
const DhcpStaticBindingState_STATE_NODE_READY = "NODE_READY"
const DhcpStaticBindingState_STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
const DhcpStaticBindingState_STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
const DhcpStaticBindingState_STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
const DhcpStaticBindingState_STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
const DhcpStaticBindingState_STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
const DhcpStaticBindingState_STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
const DhcpStaticBindingState_STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
const DhcpStaticBindingState_STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
const DhcpStaticBindingState_STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
const DhcpStaticBindingState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
const DhcpStaticBindingState_STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
const DhcpStaticBindingState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
const DhcpStaticBindingState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
const DhcpStaticBindingState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
const DhcpStaticBindingState_STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
const DhcpStaticBindingState_STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
const DhcpStaticBindingState_STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
const DhcpStaticBindingState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
const DhcpStaticBindingState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
const DhcpStaticBindingState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
const DhcpStaticBindingState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
const DhcpStaticBindingState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
const DhcpStaticBindingState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpStaticBindingState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpStaticBindingState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
const DhcpStaticBindingState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
const DhcpStaticBindingState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
const DhcpStaticBindingState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
const DhcpStaticBindingState_STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
const DhcpStaticBindingState_STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
const DhcpStaticBindingState_STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
const DhcpStaticBindingState_STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
const DhcpStaticBindingState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
const DhcpStaticBindingState_STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
const DhcpStaticBindingState_STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
const DhcpStaticBindingState_STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
const DhcpStaticBindingState_STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
const DhcpStaticBindingState_STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
const DhcpStaticBindingState_STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
const DhcpStaticBindingState_STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
const DhcpStaticBindingState_STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
const DhcpStaticBindingState_STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
const DhcpStaticBindingState_STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"

type DhcpStatistics struct {
    // The total number of DHCP ACK packets format: int64
	Acks *int64
    // The total number of DHCP DECLINE packets format: int64
	Declines *int64
    // dhcp server uuid
	DhcpServerId *string
    // The total number of DHCP DISCOVER packets format: int64
	Discovers *int64
    // The total number of DHCP errors format: int64
	Errors *int64
    // The total number of DHCP INFORM packets format: int64
	Informs *int64
    // The DHCP ip pool usage statistics
	IpPoolStats []DhcpIpPoolUsage
    // The total number of DHCP NACK packets format: int64
	Nacks *int64
    // The total number of DHCP OFFER packets format: int64
	Offers *int64
    // The total number of DHCP RELEASE packets format: int64
	Releases *int64
    // The total number of DHCP REQUEST packets format: int64
	Requests *int64
    // timestamp of the statistics format: int64
	Timestamp *int64
}

// DHCP options for IPv4 server.
type DhcpV4Options struct {
    // DHCP option 121 to define classless static routes.
	Option121 *DhcpOption121
    // To define DHCP options other than option 121 in generic format. Please note, only the following options can be defined in generic format. Those other options will be accepted without validation but will not take effect. -------------------------- Code Name -------------------------- 2 Time Offset 6 Domain Name Server 13 Boot File Size 19 Forward On/Off 26 MTU Interface 28 Broadcast Address 35 ARP Timeout 40 NIS Domain 41 NIS Servers 42 NTP Servers 44 NETBIOS Name Srv 45 NETBIOS Dist Srv 46 NETBIOS Node Type 47 NETBIOS Scope 58 Renewal Time 59 Rebinding Time 64 NIS+-Domain-Name 65 NIS+-Server-Addr 66 TFTP Server-Name (used by PXE) 67 Bootfile-Name (used by PXE) 93 PXE: Client system architecture 94 PXE: Client NDI 97 PXE: UUID/UNDI 117 Name Service Search 119 Domain Search 150 TFTP server address (used by PXE) 175 Etherboot 209 PXE Configuration File 210 PXE Path Prefix 211 PXE Reboot Time
	Others []GenericDhcpOption
}

// DHCP IPv4 static bindings are configured for each segment.
type DhcpV4StaticBindingConfig struct {
    // When not specified, gateway address is auto-assigned from segment configuration. format: ipv4
	GatewayAddress *string
    // Hostname to assign to the host.
	HostName *string
    // IP assigned to host. The IP address must belong to the subnet, if any, configured on Segment. format: ipv4
	IpAddress *string
    // DHCP lease time in seconds. format: int64
	LeaseTime *int64
    // MAC address of the host. format: mac-address
	MacAddress *string
    // IPv4 DHCP options.
	Options *DhcpV4Options
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV4STATICBINDINGCONFIG
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV6STATICBINDINGCONFIG
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DhcpV4StaticBindingConfig__TYPE_IDENTIFIER = "DhcpV4StaticBindingConfig"

// DHCP options for IPv6 server.
type DhcpV6Options struct {
}

// DHCP IPv6 static bindings are configured for each segment.
type DhcpV6StaticBindingConfig struct {
    // When not specified, no DNS nameserver will be set to client host.
	DnsNameservers []string
    // When not specified, no domain name will be assigned to client host.
	DomainNames []string
    // When not specified, no ip address will be assigned to client host. format: ipv6
	IpAddresses []string
    // Lease time, in seconds. format: int64
	LeaseTime *int64
    // The MAC address of the client host. Either client-duid or mac-address, but not both. format: mac-address
	MacAddress *string
    // Preferred time, in seconds. If this value is not provided, the value of lease_time\*0.8 will be used. format: int64
	PreferredTime *int64
    // SNTP server IP addresses. format: ipv6
	SntpServers []string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV4STATICBINDINGCONFIG
    // * DhcpStaticBindingConfig#DhcpStaticBindingConfig_RESOURCE_TYPE_DHCPV6STATICBINDINGCONFIG
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DhcpV6StaticBindingConfig__TYPE_IDENTIFIER = "DhcpV6StaticBindingConfig"

type Dhcpv6Header struct {
    // Possible values are: 
    //
    // * Dhcpv6Header#Dhcpv6Header_MSG_TYPE_SOLICIT
    // * Dhcpv6Header#Dhcpv6Header_MSG_TYPE_ADVERTISE
    // * Dhcpv6Header#Dhcpv6Header_MSG_TYPE_REQUEST
    // * Dhcpv6Header#Dhcpv6Header_MSG_TYPE_REPLY
    //
    //  This is used to specify the DHCP v6 message. To request the assignment of one or more IPv6 addresses, a client first locates a DHCP server and then requests the assignment of addresses and other configuration information from the server. The client sends a Solicit message to the All_DHCP_Relay_Agents_and_Servers address to find available DHCP servers. Any server that can meet the client's requirements responds with an Advertise message. The client then chooses one of the servers and sends a Request message to the server asking for confirmed assignment of addresses and other configuration information. The server responds with a Reply message that contains the confirmed addresses and configuration. SOLICIT - A client sends a Solicit message to locate servers. ADVERTISE - A server sends and Advertise message to indicate that it is available. REQUEST - A client sends a Request message to request configuration parameters. REPLY - A server sends a Reply message containing assigned addresses and configuration parameters.
	MsgType *string
}
const Dhcpv6Header_MSG_TYPE_SOLICIT = "SOLICIT"
const Dhcpv6Header_MSG_TYPE_ADVERTISE = "ADVERTISE"
const Dhcpv6Header_MSG_TYPE_REQUEST = "REQUEST"
const Dhcpv6Header_MSG_TYPE_REPLY = "REPLY"

type DiscoveredNode struct {
    // Certificate of the discovered node
	Certificate *string
    // Local Id of the discovered node in the Compute Manager
	CmLocalId *string
    // External id of the discovered node, ex. a mo-ref from VC
	ExternalId *string
    // Hardware Id is generated using system hardware info. It is used to retrieve fabric node of the esx.
	HardwareId *string
    // IP Addresses of the the discovered node. format: ip
	IpAddresses []string
    // Discovered Node type like Host
	NodeType *string
    // Id of the compute manager from where this node was discovered
	OriginId *string
    // Key-Value map of additional specific properties of discovered node in the Compute Manager
	OriginProperties []KeyValuePair
    // OS type of the discovered node
	OsType *string
    // OS version of the discovered node
	OsVersion *string
    // External id of the compute collection to which this node belongs
	ParentComputeCollection *string
    // The stateless property describes whether host persists its state across reboot or not. If state persists, value is set as false otherwise true.
	Stateless *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DiscoveredNode__TYPE_IDENTIFIER = "DiscoveredNode"

// Base class for resources that are discovered and automatically updated
type DiscoveredResource struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DiscoveredResource__TYPE_IDENTIFIER = "DiscoveredResource"

// Base Discovery Profile Binding Map
type DiscoveryProfileBindingMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}

type DistributedFloodProtectionProfile struct {
    // If set to true, rst spoofing will be enabled. Flag is used only for distributed firewall profiles.
	EnableRstSpoofing *bool
    // If set to true, sync cache will be enabled. Flag is used only for distributed firewall profiles.
	EnableSyncache *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_GATEWAYFLOODPROTECTIONPROFILE
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_DISTRIBUTEDFLOODPROTECTIONPROFILE
    //
    //  GatewayFloodProtectionProfile is used for all Tier0 and Tier1 gateways. DistributedFloodProtectionProfile is used for all Transport Nodes.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If this field is empty, firewall will not set a limit to active ICMP connections. format: int64
	IcmpActiveFlowLimit *int64
    // If this field is empty, firewall will not set a limit to other active connections. besides UDP, ICMP and half open TCP connections. format: int64
	OtherActiveConnLimit *int64
    // If this field is empty, firewall will not set a limit to half open TCP connections. format: int64
	TcpHalfOpenConnLimit *int64
    // If this field is empty, firewall will not set a limit to active UDP connections. format: int64
	UdpActiveFlowLimit *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DistributedFloodProtectionProfile__TYPE_IDENTIFIER = "DistributedFloodProtectionProfile"

// Distributed virtual portgroup on a VC
type DistributedVirtualPortgroup struct {
    // For distributed virtual portgroup, backing type is standard. For logical switch portgroup, the backing type is set to nsx.
	BackingType *string
    // Generated UUID of the portgroup
	Key *string
    // Possible values are: 
    //
    // * DistributedVirtualPortgroup#DistributedVirtualPortgroup_OVERALL_STATUS_RED
    // * DistributedVirtualPortgroup#DistributedVirtualPortgroup_OVERALL_STATUS_YELLOW
    // * DistributedVirtualPortgroup#DistributedVirtualPortgroup_OVERALL_STATUS_GREEN
    // * DistributedVirtualPortgroup#DistributedVirtualPortgroup_OVERALL_STATUS_GRAY
    //
    //  This parameters reflects the managed entity status of the portgroup as reported by VC.
	OverallStatus *string
    // Id of the portgroup, eg. a mo-ref from VC.
	CmLocalId *string
    // External id of the virtual portgroup
	ExternalId *string
    // Portgroup type like DistributedVirtualPortgroup
	OriginType *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
const DistributedVirtualPortgroup_OVERALL_STATUS_RED = "RED"
const DistributedVirtualPortgroup_OVERALL_STATUS_YELLOW = "YELLOW"
const DistributedVirtualPortgroup_OVERALL_STATUS_GREEN = "GREEN"
const DistributedVirtualPortgroup_OVERALL_STATUS_GRAY = "GRAY"

// DistributedVirtualSwitch on a VC
type DistributedVirtualSwitch struct {
    // Array of discovered nodes connected to this switch.
	DiscoveredNodes []DiscoveredNode
    // It contains information about VMware specific multiple dynamic LACP groups.
	LacpGroupConfigs []LacpGroupConfigInfo
    // Key-Value map of additional properties of switch
	OriginProperties []KeyValuePair
    // The uniform name of uplink ports on each host.
	UplinkPortNames []string
    // Uplink portgroup of distributed virtual switch
	UplinkPortgroup *DistributedVirtualPortgroup
    // UUID of the switch
	Uuid *string
    // ID of the virtual switch in compute manager
	CmLocalId *string
    // External id of the virtual switch
	ExternalId *string
    // ID of the compute manager where this virtual switch is discovered.
	OriginId *string
    // Switch type like VmwareDistributedVirtualSwitch
	OriginType *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Timestamp of last modification format: int64
	LastSyncTime *int64
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // The type of this resource.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}

type DnsHeader struct {
    // This is used to define what is being asked or responded. format: hostname-or-ip
	Address *string
    // Possible values are: 
    //
    // * DnsHeader#DnsHeader_ADDRESS_TYPE_V4
    // * DnsHeader#DnsHeader_ADDRESS_TYPE_V6
    //
    //  This is used to specify the type of the address. V4 - The address provided is an IPv4 domain name/IP address, the Type in query or response will be A V6 - The address provided is an IPv6 domain name/IP address, the Type in query or response will be AAAA
	AddressType *string
    // Possible values are: 
    //
    // * DnsHeader#DnsHeader_MESSAGE_TYPE_QUERY
    // * DnsHeader#DnsHeader_MESSAGE_TYPE_RESPONSE
    //
    //  Specifies the message type whether it is a query or a response.
	MessageType *string
}
const DnsHeader_ADDRESS_TYPE_V4 = "V4"
const DnsHeader_ADDRESS_TYPE_V6 = "V6"
const DnsHeader_MESSAGE_TYPE_QUERY = "QUERY"
const DnsHeader_MESSAGE_TYPE_RESPONSE = "RESPONSE"

// Used to configure DNS security profile
type DnsSecurityProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Time to live for DNS cache entry in seconds. Valid TTL values are between 3600 to 864000. However, this field accepts values between 0 through 864000. We define TTL type based on the value of TTL as follows: TTL 0 - cached entry never expires. TTL 1 to 3599 - invalid input and error is thrown TTL 3600 to 864000 - ttl is set to user input TTL field not set by user - TTL type is 'AUTO' and ttl value is set from DNS response packet. User defined TTL value is used only when it is betweeen 3600 to 864000. format: int64
	Ttl *int64
}

// This entity will be used to establish association between DNS security profile and Group. With this entity, user can specify intent for applying DNS security profile profile to particular Group.
type DnsSecurityProfileBindingMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // PolicyPath of associated Profile
	ProfilePath *string
    // Sequence number used to resolve conflicts betweeen two profiles applied on the same group. Lower sequence number takes higher precedence. Two binding maps applied to the same profile must have the same sequence number. User defined sequence numbers range from 1 through 100,000. System defined sequence numbers range from 100,001 through 200,000. format: int64
	SequenceNumber *int64
}

// Paged collection of DNS Security Profile Binding Map
type DnsSecurityProfileBindingMapListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // DNS Security Profile Binding Map List Results
	Results []DnsSecurityProfileBindingMap
}

// Paged Collection of DnsSecurityProfile
type DnsSecurityProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // DnsSecurityProfile list results
	Results []DnsSecurityProfile
}

// Domain.
type Domain struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}

// Binding of domain to the enforcement point.
type DomainDeploymentMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Path of enforcement point on which domain shall be enforced.
	EnforcementPointPath *string
}

// Paged collection of Domain Deployment Map.
type DomainDeploymentMapListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Domain Deployment Map list result.
	Results []DomainDeploymentMap
}

// Paged Collection of Domains
type DomainListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Domain list results
	Results []Domain
}

// Represents configuration of a Donut
type DonutConfiguration struct {
    // Expression to retrieve count to be shown on Donut.
	Count *string
    // If true, displays the count of entities in the donut
	DisplayCount *bool
    // Displayed at the middle of the donut, by default. It labels the entities of donut.
	Label *Label
    // Hyperlink of the specified UI page that provides details.
	Navigation *string
    // Sections
	Sections []DonutSection
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const DonutConfiguration__TYPE_IDENTIFIER = "DonutConfiguration"

// Represents an entity or portion to be plotted on a donut or stats chart.
type DonutPart struct {
    // If the condition is met then the part will be displayed. Examples of expression syntax are provided under 'example_request' section of 'CreateWidgetConfiguration' API.
	Condition *string
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // A numerical value that represents the portion or entity of the donut or stats chart.
	Field *string
    // If true, legend will be shown only if the data for the part is available. This is applicable only if legends are specified in widget configuration.
	HideEmptyLegend *bool
    // If a section 'template' holds this donut or stats part, then the label is auto-generated from the fetched field values after applying the template.
	Label *Label
    // Hyperlink of the specified UI page that provides details. If drilldown_id is provided, then navigation cannot be used.
	Navigation *string
    // Additional rendering or conditional evaluation of the field values to be performed, if any.
	RenderConfiguration []RenderConfiguration
    // Multi-line text to be shown on tooltip while hovering over the portion.
	Tooltip []Tooltip
}

// Represents high level logical grouping of portions or segments of a donut / stats chart.
type DonutSection struct {
    // Array of portions or parts of the donut or stats chart.
	Parts []DonutPart
    // Field of the root of the api result set for forming parts.
	RowListField *string
    // If true, the section will be appled as template for forming parts. Only one part will be formed from each element of 'row_list_field'.
	Template *bool
}

// Represents configuration for dropdown filter widget.
type DropdownFilterWidgetConfiguration struct {
    // Expression to specify default value of filter.
	DefaultValue *string
    // Defines the item of a dropdown.
	DropdownItem *DropdownItem
    // Placeholder message to be displayed in dropdown filter.
	PlaceholderMsg *string
    // If the condition is met then the static filter will be added. If no condition is provided, then the static filters will be applied unconditionally.
	StaticFilterCondition *string
    // Additional static items to be added in dropdown filter. Example can be 'ALL'.
	StaticFilters []StaticFilter
    // Alias to be used when emitting filter value.
	Alias *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}

// Dropdown item definition
type DropdownItem struct {
    // expression to extract display name to be shown in the drop down.
	DisplayName *string
    // An expression that represents the items of the dropdown filter.
	Field *string
    // Value of filter inside dropdown filter.
	Value *string
}

// Contains dupliacte IP detection related discovery options.
type DuplicateIPDetectionOptions struct {
    // Indicates whether duplicate IP detection should be enabled
	DuplicateIpDetectionEnabled *bool
}

// Indicate the status of End User License Agreement acceptance
type EULAAcceptance struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Acceptance status of End User License Agreement
	Acceptance *bool
}

// End User License Agreement content
type EULAContent struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Content of End User License Agreement
	Content *string
}

// This contains fields that captures state of Trackable entities. Edge and VPN state entities extend this object.
type EdgeConfigurationState struct {
    // Array of configuration state of various sub systems
	Details []ConfigurationStateElement
    // Error code format: int64
	FailureCode *int64
    // Error message in case of failure
	FailureMessage *string
    // Possible values are: 
    //
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_IN_PROGRESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_SUCCESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_PARTIAL_SUCCESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_ORPHANED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UNKNOWN
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_ERROR
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_IN_SYNC
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_NOT_AVAILABLE
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_DEPLOYMENT_QUEUED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_DEPLOYMENT_IN_PROGRESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_DEPLOYMENT_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_POWER_ON_IN_PROGRESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_POWER_ON_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_REGISTRATION_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_NODE_NOT_READY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_NODE_READY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_POWER_OFF_IN_PROGRESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_POWER_OFF_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_UNDEPLOY_IN_PROGRESS
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_UNDEPLOY_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_UNDEPLOY_SUCCESSFUL
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_EDGE_CONFIG_ERROR
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_DEPLOYMENT_RESTARTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_REGISTRATION_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_TRANSPORT_NODE_SYNC_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_EDGE_HARDWARE_NOT_SUPPORTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_NO_PNIC_PREPARED_IN_EDGE
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_APPLIANCE_INTERNAL_ERROR
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VTEP_DHCP_NOT_SUPPORTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_NO_PNIC_SPECIFIED_IN_TN
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_INVALID_PNIC_DEVICE_NAME
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_TRANSPORT_NODE_READY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_NETWORK_EDIT_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_MPA_DISCONNECTED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_RENAME_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_CONFIG_EDIT_PENDING
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_NETWORK_EDIT_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_RENAME_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_CONFIG_EDIT_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_CONFIG_DISCREPANCY
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_NODE_REFRESH_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_VM_PLACEMENT_REFRESH_FAILED
    // * EdgeConfigurationState#EdgeConfigurationState_STATE_REGISTRATION_TIMEDOUT
    //
    //  Gives details of state of desired configuration. Additional enums with more details on progress/success/error states are sent for edge node. The success states are NODE_READY and TRANSPORT_NODE_READY, pending states are {VM_DEPLOYMENT_QUEUED, VM_DEPLOYMENT_IN_PROGRESS, REGISTRATION_PENDING} and other values indicate failures. \"in_sync\" state indicates that the desired configuration has been received by the host to which it applies, but is not yet in effect. When the configuration is actually in effect, the state will change to \"success\". Please note, failed state is deprecated.
	State *string
    // Request identifier of the API which modified the entity.
	PendingChangeList []string
}
const EdgeConfigurationState_STATE_PENDING = "pending"
const EdgeConfigurationState_STATE_IN_PROGRESS = "in_progress"
const EdgeConfigurationState_STATE_SUCCESS = "success"
const EdgeConfigurationState_STATE_FAILED = "failed"
const EdgeConfigurationState_STATE_PARTIAL_SUCCESS = "partial_success"
const EdgeConfigurationState_STATE_ORPHANED = "orphaned"
const EdgeConfigurationState_STATE_UNKNOWN = "unknown"
const EdgeConfigurationState_STATE_ERROR = "error"
const EdgeConfigurationState_STATE_IN_SYNC = "in_sync"
const EdgeConfigurationState_STATE_NOT_AVAILABLE = "NOT_AVAILABLE"
const EdgeConfigurationState_STATE_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
const EdgeConfigurationState_STATE_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
const EdgeConfigurationState_STATE_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
const EdgeConfigurationState_STATE_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
const EdgeConfigurationState_STATE_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
const EdgeConfigurationState_STATE_REGISTRATION_PENDING = "REGISTRATION_PENDING"
const EdgeConfigurationState_STATE_NODE_NOT_READY = "NODE_NOT_READY"
const EdgeConfigurationState_STATE_NODE_READY = "NODE_READY"
const EdgeConfigurationState_STATE_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
const EdgeConfigurationState_STATE_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
const EdgeConfigurationState_STATE_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
const EdgeConfigurationState_STATE_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
const EdgeConfigurationState_STATE_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
const EdgeConfigurationState_STATE_EDGE_CONFIG_ERROR = "EDGE_CONFIG_ERROR"
const EdgeConfigurationState_STATE_VM_DEPLOYMENT_RESTARTED = "VM_DEPLOYMENT_RESTARTED"
const EdgeConfigurationState_STATE_REGISTRATION_FAILED = "REGISTRATION_FAILED"
const EdgeConfigurationState_STATE_TRANSPORT_NODE_SYNC_PENDING = "TRANSPORT_NODE_SYNC_PENDING"
const EdgeConfigurationState_STATE_TRANSPORT_NODE_CONFIGURATION_MISSING = "TRANSPORT_NODE_CONFIGURATION_MISSING"
const EdgeConfigurationState_STATE_EDGE_HARDWARE_NOT_SUPPORTED = "EDGE_HARDWARE_NOT_SUPPORTED"
const EdgeConfigurationState_STATE_MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED = "MULTIPLE_OVERLAY_TZS_NOT_SUPPORTED"
const EdgeConfigurationState_STATE_TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER = "TN_OVERLAY_TZ_IN_USE_BY_EDGE_CLUSTER"
const EdgeConfigurationState_STATE_TZ_ENDPOINTS_NOT_SPECIFIED = "TZ_ENDPOINTS_NOT_SPECIFIED"
const EdgeConfigurationState_STATE_NO_PNIC_PREPARED_IN_EDGE = "NO_PNIC_PREPARED_IN_EDGE"
const EdgeConfigurationState_STATE_APPLIANCE_INTERNAL_ERROR = "APPLIANCE_INTERNAL_ERROR"
const EdgeConfigurationState_STATE_VTEP_DHCP_NOT_SUPPORTED = "VTEP_DHCP_NOT_SUPPORTED"
const EdgeConfigurationState_STATE_UNSUPPORTED_HOST_SWITCH_PROFILE = "UNSUPPORTED_HOST_SWITCH_PROFILE"
const EdgeConfigurationState_STATE_UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED = "UPLINK_HOST_SWITCH_PROFILE_NOT_SPECIFIED"
const EdgeConfigurationState_STATE_HOSTSWITCH_PROFILE_NOT_FOUND = "HOSTSWITCH_PROFILE_NOT_FOUND"
const EdgeConfigurationState_STATE_LLDP_SEND_ENABLED_NOT_SUPPORTED = "LLDP_SEND_ENABLED_NOT_SUPPORTED"
const EdgeConfigurationState_STATE_UNSUPPORTED_NAMED_TEAMING_POLICY = "UNSUPPORTED_NAMED_TEAMING_POLICY"
const EdgeConfigurationState_STATE_LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM = "LBSRCID_NOT_SUPPORTED_FOR_EDGE_VM"
const EdgeConfigurationState_STATE_LACP_NOT_SUPPORTED_FOR_EDGE_VM = "LACP_NOT_SUPPORTED_FOR_EDGE_VM"
const EdgeConfigurationState_STATE_STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM = "STANDBY_UPLINKS_NOT_SUPPORTED_FOR_EDGE_VM"
const EdgeConfigurationState_STATE_MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE = "MULTIPLE_ACTIVE_UPLINKS_NOT_SUPPORTED_FOR_EDGE"
const EdgeConfigurationState_STATE_UNSUPPORTED_LACP_LB_ALGO_FOR_NODE = "UNSUPPORTED_LACP_LB_ALGO_FOR_NODE"
const EdgeConfigurationState_STATE_EDGE_NODE_VERSION_NOT_SUPPORTED = "EDGE_NODE_VERSION_NOT_SUPPORTED"
const EdgeConfigurationState_STATE_NO_PNIC_SPECIFIED_IN_TN = "NO_PNIC_SPECIFIED_IN_TN"
const EdgeConfigurationState_STATE_INVALID_PNIC_DEVICE_NAME = "INVALID_PNIC_DEVICE_NAME"
const EdgeConfigurationState_STATE_TRANSPORT_NODE_READY = "TRANSPORT_NODE_READY"
const EdgeConfigurationState_STATE_VM_NETWORK_EDIT_PENDING = "VM_NETWORK_EDIT_PENDING"
const EdgeConfigurationState_STATE_UNSUPPORTED_DEFAULT_TEAMING_POLICY = "UNSUPPORTED_DEFAULT_TEAMING_POLICY"
const EdgeConfigurationState_STATE_MPA_DISCONNECTED = "MPA_DISCONNECTED"
const EdgeConfigurationState_STATE_VM_RENAME_PENDING = "VM_RENAME_PENDING"
const EdgeConfigurationState_STATE_VM_CONFIG_EDIT_PENDING = "VM_CONFIG_EDIT_PENDING"
const EdgeConfigurationState_STATE_VM_NETWORK_EDIT_FAILED = "VM_NETWORK_EDIT_FAILED"
const EdgeConfigurationState_STATE_VM_RENAME_FAILED = "VM_RENAME_FAILED"
const EdgeConfigurationState_STATE_VM_CONFIG_EDIT_FAILED = "VM_CONFIG_EDIT_FAILED"
const EdgeConfigurationState_STATE_VM_CONFIG_DISCREPANCY = "VM_CONFIG_DISCREPANCY"
const EdgeConfigurationState_STATE_VM_NODE_REFRESH_FAILED = "VM_NODE_REFRESH_FAILED"
const EdgeConfigurationState_STATE_VM_PLACEMENT_REFRESH_FAILED = "VM_PLACEMENT_REFRESH_FAILED"
const EdgeConfigurationState_STATE_REGISTRATION_TIMEDOUT = "REGISTRATION_TIMEDOUT"

// A shaper that specifies egress rate properties in Mb/s
type EgressRateLimiter struct {
    // Average bandwidth in Mb/s format: int32
	AverageBandwidth *int64
    // Burst size in bytes format: int32
	BurstSize *int64
    // Peak bandwidth in Mb/s format: int32
	PeakBandwidth *int64
	Enabled *bool
    // Possible values are: 
    //
    // * QosBaseRateLimiter#QosBaseRateLimiter_RESOURCE_TYPE_INGRESSRATELIMITER
    // * QosBaseRateLimiter#QosBaseRateLimiter_RESOURCE_TYPE_INGRESSBROADCASTRATELIMITER
    // * QosBaseRateLimiter#QosBaseRateLimiter_RESOURCE_TYPE_EGRESSRATELIMITER
    //
    //  Type rate limiter
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const EgressRateLimiter__TYPE_IDENTIFIER = "EgressRateLimiter"

// Ordered list of Endpoint Rules ordered by sequence number of the entries. The maximum number of policies is 25.
type EndpointPolicy struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Endpoint Rules that are a part of this EndpointPolicy
	EndpointRules []EndpointRule
    // This field is used to resolve conflicts between maps across domains. format: int32
	SequenceNumber *int64
}

// Paged Collection of Groups
type EndpointPolicyListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Guest Introspection Map list results
	Results []EndpointPolicy
}

// Endpoint Rule comes from user configuration. User configures Endpoint Rule to specify what services are applied on the groups.
type EndpointRule struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // We need paths as duplicate names may exist for groups under different domains. In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	Groups []string
    // This field is used to resolve conflicts between multiple entries under EndpointPolicy. It will be system default value when not specified by user. format: int32
	SequenceNumber *int64
    // The policy paths of service profiles are listed here. It pecifies what services are applied on the group. Currently only one is allowed.
	ServiceProfiles []string
}

// Paged Collection of Endpoint Rules
type EndpointRuleListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Endpoint Rule list results
	Results []EndpointRule
}

// Detailed Realized Status of an intent object on an NSX-T type of enforcement point. This is a detailed view of the Realized Status of an intent object from an NSX-T enforcement point perspective.
type EnforcedStatusDetailsNsxt struct {
    // Information about the realized status of the intent on this enforcement point. Some very recent changes may be excluded when preparing this information, which is indicated by Pending Changes Info.
	EnforcedStatusInfo *EnforcedStatusInfoNsxt
    // Information about pending changes, if any, that aren't reflected in the Enforced Realized Status.
	PendingChangesInfo *PendingChangesInfoNsxt
}

// Information about the realized status of the intent object on an NSX-T type of enforcement point. Some very recent changes may be excluded when preparing this information, which is indicated by Pending Changes Info. In addition to the realized status across all scopes, this information holds details about enforced realized status per scope.
type EnforcedStatusInfoNsxt struct {
    // Consolidated Realized Status of an Intent object across all scopes of an NSX-T type of enforcement point.
	EnforcedStatus *EnforcedStatusNsxt
    // List of Enforced Realized Status per Scope.
	EnforcedStatusPerScope []*data.StructValue
}

// NSX-T Enforced Status.
type EnforcedStatusNsxt struct {
    // Possible values are: 
    //
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_UNINITIALIZED
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_UNKNOWN
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_UP
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_DOWN
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_DEGRADED
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_SUCCESS
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_FAILURE
    // * EnforcedStatusNsxt#EnforcedStatusNsxt_STATUS_IN_PROGRESS
    //
    //  Enforced Realized Status.
	Status *string
    // Status Message conveying hints depending on the status value.
	StatusMessage *string
}
const EnforcedStatusNsxt_STATUS_UNINITIALIZED = "UNINITIALIZED"
const EnforcedStatusNsxt_STATUS_UNKNOWN = "UNKNOWN"
const EnforcedStatusNsxt_STATUS_UP = "UP"
const EnforcedStatusNsxt_STATUS_DOWN = "DOWN"
const EnforcedStatusNsxt_STATUS_DEGRADED = "DEGRADED"
const EnforcedStatusNsxt_STATUS_SUCCESS = "SUCCESS"
const EnforcedStatusNsxt_STATUS_FAILURE = "FAILURE"
const EnforcedStatusNsxt_STATUS_IN_PROGRESS = "IN_PROGRESS"

// NSX-T Detailed Realized Status Per Scope.
type EnforcedStatusPerScopeNsxt struct {
    // Possible values are: 
    //
    // * EnforcedStatusPerScopeNsxt#EnforcedStatusPerScopeNsxt_RESOURCE_TYPE_TRANSPORTNODESPANENFORCEDSTATUS
    //
    //  Enforced Realized Status Per Scope Resource Type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const EnforcedStatusPerScopeNsxt__TYPE_IDENTIFIER = "EnforcedStatusPerScopeNsxT"
const EnforcedStatusPerScopeNsxt_RESOURCE_TYPE_TRANSPORTNODESPANENFORCEDSTATUS = "TransportNodeSpanEnforcedStatus"

// Detailed Realized Status Per Transport Node.
type EnforcedStatusPerTransportNode struct {
    // Display name of the transport node.
	DisplayName *string
    // Realized Status of an Intent object on this Transport Node.
	EnforcedStatus *EnforcedStatusNsxt
    // UUID identifying uniquely the Transport Node.
	NsxId *string
    // Policy Path referencing the transport node.
	Path *string
}

// Enforcement point is the endpoint where policy configurations are applied.
type EnforcementPoint struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Auto enforce flag suggests whether the policy objects shall be automatically enforced on this enforcement point or not. When this flag is set to true, all policy objects will be automatically enforced on this enforcement point. If this flag is set to false, user shall rely on the usual means of realization, i.e., deployment maps.
	AutoEnforce *bool
    // Connection Info of the Enforcement Point.
	ConnectionInfo *data.StructValue
    // Version of the Enforcement point.
	Version *string
}

// Contains information required to connect to enforcement point.
type EnforcementPointConnectionInfo struct {
    // Value of this property could be Hostname or IP. For instance: - On an NSX-T MP running on default port, the value could be \"10.192.1.1\" - On an NSX-T MP running on custom port, the value could be \"192.168.1.1:32789\" - On an NSX-T MP in VMC deployments, the value could be \"192.168.1.1:5480/nsxapi\"
	EnforcementPointAddress *string
    // Possible values are: 
    //
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXTCONNECTIONINFO
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXVCONNECTIONINFO
    // * EnforcementPointConnectionInfo#EnforcementPointConnectionInfo_RESOURCE_TYPE_CVXCONNECTIONINFO
    //
    //  Resource Type of Enforcement Point Connection Info.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const EnforcementPointConnectionInfo__TYPE_IDENTIFIER = "EnforcementPointConnectionInfo"
const EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXTCONNECTIONINFO = "NSXTConnectionInfo"
const EnforcementPointConnectionInfo_RESOURCE_TYPE_NSXVCONNECTIONINFO = "NSXVConnectionInfo"
const EnforcementPointConnectionInfo_RESOURCE_TYPE_CVXCONNECTIONINFO = "CvxConnectionInfo"

// Paged collection of enforcement points.
type EnforcementPointListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Enforcement Point list Results.
	Results []EnforcementPoint
}

// Represents the leaf level constraint to restrict the number instances of an entity type can be created. This is useful in restricting number of CGWs or MGWs or Providers that can created in a system.
type EntityInstanceCountConstraintExpression struct {
    // Instance count. format: int64
	Count *int64
    // Operations supported '<' and '<='.
	Operator *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_VALUECONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_RELATEDATTRIBUTECONDITIONALEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_ENTITYINSTANCECOUNTCONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_FIELDSANITYCONSTRAINTEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const EntityInstanceCountConstraintExpression__TYPE_IDENTIFIER = "EntityInstanceCountConstraintExpression"

// Metadata related to a given error_id
type ErrorResolverInfo struct {
    // The error id for which metadata information is needed format: int64
	ErrorId *int64
    // Indicates whether there is a resolver associated with the error or not
	ResolverPresent *bool
    // User supplied metadata that might be required by the resolver
	UserMetadata *ErrorResolverUserMetadata
}

// Collection of all registered ErrorResolverInfo
type ErrorResolverInfoList struct {
    // ErrorResolverInfo list
	Results []ErrorResolverInfo
}

// Error along with its metadata
type ErrorResolverMetadata struct {
    // The entity/node UUID where the error has occurred.
	EntityId *string
    // The error id as reported by the entity where the error occurred. format: int64
	ErrorId *int64
    // This can come from some external system like syslog collector
	SystemMetadata *ErrorResolverSystemMetadata
    // User supplied metadata that might be required by the resolver
	UserMetadata *ErrorResolverUserMetadata
}

// List of errors with their metadata
type ErrorResolverMetadataList struct {
    // List of errors with their corresponding metadata.
	Errors []ErrorResolverMetadata
}

// Metadata fetched from an external system like Syslog or LogInsight.
type ErrorResolverSystemMetadata struct {
    // The value fetched from another system
	Value *string
}

// Corresponds to one property entered by the user
type ErrorResolverUserInputData struct {
    // Possible values are: 
    //
    // * ErrorResolverUserInputData#ErrorResolverUserInputData_DATA_TYPE_TEXT
    // * ErrorResolverUserInputData#ErrorResolverUserInputData_DATA_TYPE_NUMBER
    // * ErrorResolverUserInputData#ErrorResolverUserInputData_DATA_TYPE_PASSWORD
    //
    //  The datatype of the given property. Useful for data validation
	DataType *string
    // Name of the property supplied by the user
	PropertyName *string
    // The value associated with the above property
	PropertyValue *string
}
const ErrorResolverUserInputData_DATA_TYPE_TEXT = "TEXT"
const ErrorResolverUserInputData_DATA_TYPE_NUMBER = "NUMBER"
const ErrorResolverUserInputData_DATA_TYPE_PASSWORD = "PASSWORD"

// User supplied metadata needed for resolving errors
type ErrorResolverUserMetadata struct {
    // List of user supplied input data.
	UserInputList []ErrorResolverUserInputData
}

// A ServiceEntry that represents an ethertype protocol
type EtherTypeServiceEntry struct {
    // Type of the encapsulated protocol format: int64
	EtherType *int64
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IGMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ICMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ALGTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_L4PORTSETSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ETHERTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const EtherTypeServiceEntry__TYPE_IDENTIFIER = "EtherTypeServiceEntry"

type EthernetHeader struct {
    // The destination MAC address of form: \"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$\". For example: 00:00:00:00:00:00.
	DstMac *string
    // This field defaults to IPv4. format: int64
	EthType *int64
    // The source MAC address of form: \"^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$\". For example: 00:00:00:00:00:00.
	SrcMac *string
}

// Criterion Evaluation is the basic logical condition to evaluate whether the event could be potentially met.
type Evaluation struct {
    // Possible values are: 
    //
    // * Evaluation#Evaluation_RESOURCE_TYPE_SOURCEFIELDEVALUATION
    //
    //  Criterion Evaluation resource type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const Evaluation__TYPE_IDENTIFIER = "Evaluation"
const Evaluation_RESOURCE_TYPE_SOURCEFIELDEVALUATION = "SourceFieldEvaluation"

// The Event is the criterion or criteria applied to the source and, when met, prompt Policy to run the action. All Reaction Events are constructed with reference to the object, the \"source\", that is logically deemed to be the object upon which the Event in question initially occurred upon. Some example events include: - New object was created. - Change in realization state. - Specific API is called.
type Event struct {
    // Criteria applied to the source and, if satisfied, would trigger the action. Criteria is composed of criterions. In order for the Criteria to be met, only one of the criterion must be fulfilled (implicit OR).
	Criteria []Criterion
    // Source that is logically deemed to be the \"object\" upon which the Event in question initially occurred upon.
	Source *data.StructValue
}

// Evpn Configuration.
type EvpnConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Encapsulation method for EVPN service that is used by the transport layer.
	EncapsulationMethod *EvpnEncapConfig
    // Possible values are: 
    //
    // * EvpnConfig#EvpnConfig_MODE_INLINE
    //
    //  EVPN service mode
	Mode *string
}
const EvpnConfig_MODE_INLINE = "INLINE"

// Encapsulation method for EVPN.
type EvpnEncapConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // vni pool path
	VniPoolPath *string
}

// Evpn Tunnel Endpoint Configuration.
type EvpnTunnelEndpointConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // edge path
	EdgePath *string
    // local addresses format: ipv4
	LocalAddresses []string
    // MTU format: int32
	Mtu *int64
}

// Collection of Evpn Tunnel Endpoint Configuration.
type EvpnTunnelEndpointConfigListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Evpn Tunnel Endpoint Configuration list results
	Results []EvpnTunnelEndpointConfig
}

// All the nodes of the expression extend from this abstract class. This is present for extensibility.
type Expression struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * Expression#Expression_RESOURCE_TYPE_CONDITION
    // * Expression#Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR
    // * Expression#Expression_RESOURCE_TYPE_NESTEDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_PATHEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const Expression__TYPE_IDENTIFIER = "Expression"
const Expression_RESOURCE_TYPE_CONDITION = "Condition"
const Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR = "ConjunctionOperator"
const Expression_RESOURCE_TYPE_NESTEDEXPRESSION = "NestedExpression"
const Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION = "IPAddressExpression"
const Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION = "MACAddressExpression"
const Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION = "ExternalIDExpression"
const Expression_RESOURCE_TYPE_PATHEXPRESSION = "PathExpression"
const Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION = "IdentityGroupExpression"

// Represents external ID expressions in the form of an array, to support addition of objects like virtual interfaces, virtual machines, CloudNativeServiceInstance PhysicalServer to a group.
type ExternalIDExpression struct {
    // This array can consist of one or more external IDs for the specified member type.
	ExternalIds []string
    // Possible values are: 
    //
    // * ExternalIDExpression#ExternalIDExpression_MEMBER_TYPE_VIRTUALMACHINE
    // * ExternalIDExpression#ExternalIDExpression_MEMBER_TYPE_VIRTUALNETWORKINTERFACE
    // * ExternalIDExpression#ExternalIDExpression_MEMBER_TYPE_CLOUDNATIVESERVICEINSTANCE
    // * ExternalIDExpression#ExternalIDExpression_MEMBER_TYPE_PHYSICALSERVER
    //
    //  External ID member type
	MemberType *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * Expression#Expression_RESOURCE_TYPE_CONDITION
    // * Expression#Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR
    // * Expression#Expression_RESOURCE_TYPE_NESTEDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_PATHEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ExternalIDExpression__TYPE_IDENTIFIER = "ExternalIDExpression"
const ExternalIDExpression_MEMBER_TYPE_VIRTUALMACHINE = "VirtualMachine"
const ExternalIDExpression_MEMBER_TYPE_VIRTUALNETWORKINTERFACE = "VirtualNetworkInterface"
const ExternalIDExpression_MEMBER_TYPE_CLOUDNATIVESERVICEINSTANCE = "CloudNativeServiceInstance"
const ExternalIDExpression_MEMBER_TYPE_PHYSICALSERVER = "PhysicalServer"

// Global configuration
type FIPSGlobalConfig struct {
    // When this flag is set to true FIPS mode will be set on ssl encryptions of load balancer feature.
	LbFipsEnabled *bool
}

// Feature Permission
type FeaturePermission struct {
    // Feature Id
	Feature *string
    // Feature Description
	FeatureDescription *string
    // Feature Name
	FeatureName *string
    // Is execute recommended
	IsExecuteRecommended *bool
    // Is internal
	IsInternal *bool
    // Possible values are: 
    //
    // * FeaturePermission#FeaturePermission_PERMISSION_CRUD
    // * FeaturePermission#FeaturePermission_PERMISSION_READ
    // * FeaturePermission#FeaturePermission_PERMISSION_EXECUTE
    // * FeaturePermission#FeaturePermission_PERMISSION_NONE
    //
    //  Permission
	Permission *string
}
const FeaturePermission_PERMISSION_CRUD = "crud"
const FeaturePermission_PERMISSION_READ = "read"
const FeaturePermission_PERMISSION_EXECUTE = "execute"
const FeaturePermission_PERMISSION_NONE = "none"

type FederationComponentUpgradeStatus struct {
    // Component type for the upgrade status
	ComponentType *string
    // Mapping of current versions of nodes and counts of nodes at the respective versions.
	CurrentVersionNodeSummary []FederationNodeSummary
    // Details about the upgrade status
	Details *string
    // Indicator of upgrade progress in percentage
	PercentComplete *float64
    // Possible values are: 
    //
    // * FederationComponentUpgradeStatus#FederationComponentUpgradeStatus_STATUS_SUCCESS
    // * FederationComponentUpgradeStatus#FederationComponentUpgradeStatus_STATUS_FAILED
    // * FederationComponentUpgradeStatus#FederationComponentUpgradeStatus_STATUS_IN_PROGRESS
    // * FederationComponentUpgradeStatus#FederationComponentUpgradeStatus_STATUS_NOT_STARTED
    // * FederationComponentUpgradeStatus#FederationComponentUpgradeStatus_STATUS_PAUSED
    //
    //  Upgrade status of component
	Status *string
    // Target component version
	TargetVersion *string
}
const FederationComponentUpgradeStatus_STATUS_SUCCESS = "SUCCESS"
const FederationComponentUpgradeStatus_STATUS_FAILED = "FAILED"
const FederationComponentUpgradeStatus_STATUS_IN_PROGRESS = "IN_PROGRESS"
const FederationComponentUpgradeStatus_STATUS_NOT_STARTED = "NOT_STARTED"
const FederationComponentUpgradeStatus_STATUS_PAUSED = "PAUSED"

// Global Manager federation configuration. This configuration is distributed to all Sites participating in federation.
type FederationConfig struct {
    // Federation configurations of all Sites
	SiteConfig []SiteFederationConfig
}

// Additional configuration required for federation.
type FederationConnectivityConfig struct {
    // Global id for by Layer3 services for federation usecases. format: int64
	GlobalOverlayId *int64
}

// Additional gateway configuration required for federation
type FederationGatewayConfig struct {
    // Global id for by Layer3 services for federation usecases. format: int64
	GlobalOverlayId *int64
    // Indicies for cross site allocation for edge cluster and its members referred by gateway.
	SiteAllocationIndices []SiteAllocationIndexForEdge
    // Global UUID for transit segment id to be used by Layer2 services for federation usecases.
	TransitSegmentId *string
}

type FederationNodeSummary struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Number of nodes of the type and at the component version. format: int32
	NodeCount *int64
    // Component version
	Version *string
}

// Provides upgrade summary for a specific site.
type FederationUpgradeSummary struct {
    // List of component statuses
	ComponentStatus []FederationComponentUpgradeStatus
    // This is NSX version for the site.
	CurrentVersion *string
    // Name of the global manager if present.
	GpmName *string
    // Unique identifier of this resource.
	Id *string
    // Indicates the time when the site was upgraded.
	LastUpgradeTimestamp *string
    // Name of the site.
	Name *string
    // Possible values are: 
    //
    // * FederationUpgradeSummary#FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_SUCCESS
    // * FederationUpgradeSummary#FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_FAILED
    // * FederationUpgradeSummary#FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_IN_PROGRESS
    // * FederationUpgradeSummary#FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_NOT_STARTED
    // * FederationUpgradeSummary#FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_PAUSED
    //
    //  Status of upgrade
	OverallUpgradeStatus *string
    // This is the Site Manager generated UUID for every NSX deployment.
	SiteId *string
    // IP address of the site.
	SiteIp *string
    // Possible values are: 
    //
    // * FederationUpgradeSummary#FederationUpgradeSummary_SITE_TYPE_ACTIVE_GM_SITE
    // * FederationUpgradeSummary#FederationUpgradeSummary_SITE_TYPE_STANDBY_GM_SITE
    // * FederationUpgradeSummary#FederationUpgradeSummary_SITE_TYPE_NON_GM_SITE
    //
    //  Type of this site.
	SiteType *string
    // This is NSX target version for the site, if it is undergoing upgrade.
	TargetVersion *string
}
const FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_SUCCESS = "SUCCESS"
const FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_FAILED = "FAILED"
const FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_IN_PROGRESS = "IN_PROGRESS"
const FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_NOT_STARTED = "NOT_STARTED"
const FederationUpgradeSummary_OVERALL_UPGRADE_STATUS_PAUSED = "PAUSED"
const FederationUpgradeSummary_SITE_TYPE_ACTIVE_GM_SITE = "ACTIVE_GM_SITE"
const FederationUpgradeSummary_SITE_TYPE_STANDBY_GM_SITE = "STANDBY_GM_SITE"
const FederationUpgradeSummary_SITE_TYPE_NON_GM_SITE = "NON_GM_SITE"

// Paged Collection of site upgrade information
type FederationUpgradeSummaryListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Paged collection of site upgrade information
	Results []FederationUpgradeSummary
}

// Represents the field value constraint to constrain specified field value based on defined sanity checks. Example - For DNS.upstream_servers, all the IP addresses must either be public or private. { \"target\": { \"target_resource_type\": \"DnsForwarderZone\", \"attribute\": \"upstreamServers\", \"path_prefix\": \"/infra/dns-forwarder-zones/\" }, \"constraint_expression\": { \"resource_type\": \"FieldSanityConstraintExpression\", \"operator\": \"OR\", \"checks\": [\"ALL_PUBLIC_IPS\", \"ALL_PRIVATE_IPS\"] } }
type FieldSanityConstraintExpression struct {
    // Possible values are: 
    //
    // * FieldSanityConstraintExpression#FieldSanityConstraintExpression_CHECKS_PUBLIC_IPS
    // * FieldSanityConstraintExpression#FieldSanityConstraintExpression_CHECKS_PRIVATE_IPS
    //
    //  List of sanity checks.
	Checks []string
    // Possible values are: 
    //
    // * FieldSanityConstraintExpression#FieldSanityConstraintExpression_OPERATOR_OR
    // * FieldSanityConstraintExpression#FieldSanityConstraintExpression_OPERATOR_AND
    //
    //  A conditional operator
	Operator *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_VALUECONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_RELATEDATTRIBUTECONDITIONALEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_ENTITYINSTANCECOUNTCONSTRAINTEXPRESSION
    // * ConstraintExpression#ConstraintExpression_RESOURCE_TYPE_FIELDSANITYCONSTRAINTEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FieldSanityConstraintExpression__TYPE_IDENTIFIER = "FieldSanityConstraintExpression"
const FieldSanityConstraintExpression_CHECKS_PUBLIC_IPS = "ALL_PUBLIC_IPS"
const FieldSanityConstraintExpression_CHECKS_PRIVATE_IPS = "ALL_PRIVATE_IPS"
const FieldSanityConstraintExpression_OPERATOR_OR = "OR"
const FieldSanityConstraintExpression_OPERATOR_AND = "AND"

// Field Setting.
type FieldSetting struct {
    // Field Pointer.
	FieldPointer *string
    // Value that the field must be set to.
	Value *data.StructValue
}

// Field Setting Value.
type FieldSettingValue struct {
    // Possible values are: 
    //
    // * FieldSettingValue#FieldSettingValue_RESOURCE_TYPE_CONSTANTFIELDVALUE
    //
    //  Field Setting Value resource type.
	ResourceType string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FieldSettingValue__TYPE_IDENTIFIER = "FieldSettingValue"
const FieldSettingValue_RESOURCE_TYPE_CONSTANTFIELDVALUE = "ConstantFieldValue"

type FieldsPacketData struct {
    // The ARP header
	ArpHeader *ArpHeader
    // The ethernet header
	EthHeader *EthernetHeader
    // The IPv4 header
	IpHeader *Ipv4Header
    // The IPv6 header
	Ipv6Header *Ipv6Header
    // Up to 1000 bytes of payload may be supplied (with a base64-encoded length of 1336 bytes.) Additional bytes of traceflow metadata will be appended to the payload. The payload contains any data the user wants to put after the transport header.
	Payload *string
    // This field contains a protocol that is above IP. It is not restricted to the 'transport' defined by the OSI model (e.g., ICMP is supported).
	TransportHeader *TransportProtocolHeader
    // If the requested frame_size is too small (given the payload and traceflow metadata requirement of 16 bytes), the traceflow request will fail with an appropriate message. The frame will be zero padded to the requested size. format: int64
	FrameSize *int64
    // Possible values are: 
    //
    // * PacketData#PacketData_RESOURCE_TYPE_BINARYPACKETDATA
    // * PacketData#PacketData_RESOURCE_TYPE_FIELDSPACKETDATA
    //
    //  Packet configuration
	ResourceType string
    // A flag, when set true, indicates that the traceflow packet is of L3 routing.
	Routed *bool
    // Possible values are: 
    //
    // * PacketData#PacketData_TRANSPORT_TYPE_BROADCAST
    // * PacketData#PacketData_TRANSPORT_TYPE_UNICAST
    // * PacketData#PacketData_TRANSPORT_TYPE_MULTICAST
    // * PacketData#PacketData_TRANSPORT_TYPE_UNKNOWN
    //
    //  transport type of the traceflow packet
	TransportType *string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FieldsPacketData__TYPE_IDENTIFIER = "FieldsPacketData"

// Remote server authentication details
type FileTransferAuthenticationScheme struct {
    // Password to authenticate with
	Password *string
    // Possible values are: 
    //
    // * FileTransferAuthenticationScheme#FileTransferAuthenticationScheme_SCHEME_NAME_PASSWORD
    //
    //  Authentication scheme name
	SchemeName *string
    // User name to authenticate with
	Username *string
}
const FileTransferAuthenticationScheme_SCHEME_NAME_PASSWORD = "PASSWORD"

// Protocol to transfer backup file to remote server
type FileTransferProtocol struct {
    // Scheme to authenticate if required
	AuthenticationScheme *FileTransferAuthenticationScheme
    // Possible values are: 
    //
    // * FileTransferProtocol#FileTransferProtocol_PROTOCOL_NAME_SFTP
    //
    //  Protocol name
	ProtocolName *string
    // The expected SSH fingerprint of the server. If the server's fingerprint does not match this fingerprint, the connection will be terminated. Only ECDSA fingerprints hashed with SHA256 are supported. To obtain the host's ssh fingerprint, you should connect via some method other than SSH to obtain this information. You can use one of these commands to view the key's fingerprint: 1. ssh-keygen -l -E sha256 -f ssh_host_ecdsa_key.pub 2. awk '{print $2}' ssh_host_ecdsa_key.pub | base64 -d | sha256sum -b | sed 's/ .\*$//' | xxd -r -p | base64 | sed 's/.//44g' | awk '{print \"SHA256:\"$1}'
	SshFingerprint *string
}
const FileTransferProtocol_PROTOCOL_NAME_SFTP = "sftp"

// Represents configuration for filter widget. This is abstract representation of filter widget.
type FilterWidgetConfiguration struct {
    // Alias to be used when emitting filter value.
	Alias *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FilterWidgetConfiguration__TYPE_IDENTIFIER = "FilterWidgetConfiguration"

// Firewall related configurations
type FirewallConfiguration struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * FirewallConfiguration#FirewallConfiguration_RESOURCE_TYPE_DFWFIREWALLCONFIGURATION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // To disable auto drafts, set it to true. By default, auto drafts are enabled.
	DisableAutoDrafts *bool
    // If set to true, Firewall is enabled.
	EnableFirewall *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FirewallConfiguration__TYPE_IDENTIFIER = "FirewallConfiguration"
const FirewallConfiguration_RESOURCE_TYPE_DFWFIREWALLCONFIGURATION = "DfwFirewallConfiguration"

// Represents a generic firewall identity store (e.g. Microsoft AD) The firewall identity store allow access to the directory group via LDAP protocol.
type FirewallIdentityStore struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Each active directory domain has a domain naming context (NC), which contains domain-specific data. The root of this naming context is represented by a domain's distinguished name (DN) and is typically referred to as the NC head.
	BaseDistinguishedName *string
    // Directory domain LDAP servers' information including host, name, port, protocol and so on.
	LdapServers []FirewallIdentityStoreLdapServer
    // Directory domain name which best describes the domain. It could be unique fqdn name or it could also be descriptive. There is no unique contraint for domain name among different domains.
	Name *string
    // NetBIOS names can contain all alphanumeric characters except for the certain disallowed characters. Names can contain a period, but names cannot start with a period. NetBIOS is similar to DNS in that it can serve as a directory service, but more limited as it has no provisions for a name hierarchy and names are limited to 15 characters. The netbios name is case insensitive and is stored in upper case regardless of input case.
	NetbiosName *string
    // SelectiveSync settings toggle the SelectiveSync feature and selected OrgUnits. If this is not specified, SelectiveSync is disabled by default.
	SelectiveSyncSettings *FirewallIdentityStoreSelectiveSyncSettings
    // Each domain sync settings can be changed using this object. It is not required since there are default values used if there is no specification for this object.
	SyncSettings *FirewallIdentityStoreSyncSettings
}

// Firewall identity LDAP server
type FirewallIdentityStoreLdapServer struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Directory domain name which best describes the domain. It could be unique fqdn name or it could also be descriptive. There is no unique constraint for domain name among different domains.
	DomainName *string
    // Directory LDAP server DNS host name or ip address which is reachable by NSX manager to be connected and do object synchronization. format: ip-or-hostname
	Host *string
    // Directory LDAP server connection password.
	Password *string
    // Directory LDAP server connection TCP/UDP port. format: int32
	Port *int64
    // Possible values are: 
    //
    // * FirewallIdentityStoreLdapServer#FirewallIdentityStoreLdapServer_PROTOCOL_LDAP
    // * FirewallIdentityStoreLdapServer#FirewallIdentityStoreLdapServer_PROTOCOL_LDAPS
    //
    //  Directory LDAP server connection protocol which is either LDAP or LDAPS.
	Protocol *string
    // Directory LDAP server certificate thumbprint used in secure LDAPS connection.
	Thumbprint *string
    // Directory LDAP server connection user name.
	Username *string
}
const FirewallIdentityStoreLdapServer_PROTOCOL_LDAP = "LDAP"
const FirewallIdentityStoreLdapServer_PROTOCOL_LDAPS = "LDAPS"

// Firewall identity selective sync settings
type FirewallIdentityStoreSelectiveSyncSettings struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Enable or disable SelectiveSync
	Enabled *bool
    // If SelectiveSync is enabled, this contains 1 or more OrgUnits, NSX will synchronize with in LDAP server. If SelectiveSync is disabled, do not define this or specify an empty list.
	SelectedOrgUnits []string
}

// Firewall identity synchronization settings
type FirewallIdentityStoreSyncSettings struct {
    // Directory domain delta synchronization interval time between two delta sync in minutes. format: int64
	DeltaSyncInterval *int64
    // Directory domain full synchronization schedule using cron expression. For example, cron expression \"0 0 12 ? \* SUN \*\" means full sync is scheduled every Sunday midnight. If this object is null, it means there is no background cron job running for full sync.
	FullSyncCronExpr *string
    // Sync delay after Directory domain has been successfully created. if delay is -1, initial full sync will not be triggered. format: int32
	SyncDelayInSec *int64
}

// A profile holding TCP, UDP and ICMP and other protcol connection limits.
type FloodProtectionProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_GATEWAYFLOODPROTECTIONPROFILE
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_DISTRIBUTEDFLOODPROTECTIONPROFILE
    //
    //  GatewayFloodProtectionProfile is used for all Tier0 and Tier1 gateways. DistributedFloodProtectionProfile is used for all Transport Nodes.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If this field is empty, firewall will not set a limit to active ICMP connections. format: int64
	IcmpActiveFlowLimit *int64
    // If this field is empty, firewall will not set a limit to other active connections. besides UDP, ICMP and half open TCP connections. format: int64
	OtherActiveConnLimit *int64
    // If this field is empty, firewall will not set a limit to half open TCP connections. format: int64
	TcpHalfOpenConnLimit *int64
    // If this field is empty, firewall will not set a limit to active UDP connections. format: int64
	UdpActiveFlowLimit *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const FloodProtectionProfile__TYPE_IDENTIFIER = "FloodProtectionProfile"
const FloodProtectionProfile_RESOURCE_TYPE_GATEWAYFLOODPROTECTIONPROFILE = "GatewayFloodProtectionProfile"
const FloodProtectionProfile_RESOURCE_TYPE_DISTRIBUTEDFLOODPROTECTIONPROFILE = "DistributedFloodProtectionProfile"

// Paged Collection of flood protection profile binding maps
type FloodProtectionProfileBindingListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Flood protection profile binding maps list results
	Results []FloodProtectionProfileBindingMap
}

// This entity will be used to establish association between Flood Protection profile and Logical Routers.
type FloodProtectionProfileBindingMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // PolicyPath of associated Profile
	ProfilePath *string
}

// Paged Collection of flood protection profiles
type FloodProtectionProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Flood protection profile list results
	Results []*data.StructValue
}

// Footer of a widget that provides additional information or allows an action such as clickable url for navigation. An example usage of footer is provided under 'example_request' section of 'CreateWidgetConfiguration' API.
type Footer struct {
    // Action to be performed at the footer of a widget. An action at the footer can be simple text description or a hyperlink to a UI page. Action allows a clickable url for navigation. An example usage of footer action is provided under 'example_request' section of 'CreateWidgetConfiguration' API.
	Actions []FooterAction
    // If the condition is met then the footer will be applied. Examples of expression syntax are provided under 'example_request' section of 'CreateWidgetConfiguration' API.
	Condition *string
}

// Action specified at the footer of a widget to provide additional information or to provide a clickable url for navigation. An example usage of footer action is provided under the 'example_request' section of 'CreateWidgetConfiguration' API.
type FooterAction struct {
    // If true, the footer will appear in the underlying container that holds the widget.
	DockToContainerFooter *bool
    // Label to be displayed against the footer action.
	Label *Label
    // Hyperlink to the UI page that provides details of action.
	Url *string
}

// Contains ordered list of forwarding rules that determine when to forward traffic to / from the underlay for accessing cloud native services.
type ForwardingPolicy struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // - Distributed Firewall - Policy framework provides five pre-defined categories for classifying a security policy. They are \"Ethernet\",\"Emergency\", \"Infrastructure\" \"Environment\" and \"Application\". There is a pre-determined order in which the policy framework manages the priority of these security policies. Ethernet category is for supporting layer 2 firewall rules. The other four categories are applicable for layer 3 rules. Amongst them, the Emergency category has the highest priority followed by Infrastructure, Environment and then Application rules. Administrator can choose to categorize a security policy into the above categories or can choose to leave it empty. If empty it will have the least precedence w.r.t the above four categories. - Edge Firewall - Policy Framework for Edge Firewall provides six pre-defined categories \"Emergency\", \"SystemRules\", \"SharedPreRules\", \"LocalGatewayRules\", \"AutoServiceRules\" and \"Default\", in order of priority of rules. All categories are allowed for Gatetway Policies that belong to 'default' Domain. However, for user created domains, category is restricted to \"SharedPreRules\" or \"LocalGatewayRules\" only. Also, the users can add/modify/delete rules from only the \"SharedPreRules\" and \"LocalGatewayRules\" categories. If user doesn't specify the category then defaulted to \"Rules\". System generated category is used by NSX created rules, for example BFD rules. Autoplumbed category used by NSX verticals to autoplumb data path rules. Finally, \"Default\" category is the placeholder default rules with lowest in the order of priority.
	Category *string
    // Comments for security policy lock/unlock.
	Comments *string
    // This field is to indicate the internal sequence number of a policy with respect to the policies across categories. format: int32
	InternalSequenceNumber *int64
    // A flag to indicate whether policy is a default policy.
	IsDefault *bool
    // ID of the user who last modified the lock for the secruity policy.
	LockModifiedBy *string
    // SecurityPolicy locked/unlocked time in epoch milliseconds. format: int64
	LockModifiedTime *int64
    // Indicates whether a security policy should be locked. If the security policy is locked by a user, then no other user would be able to modify this security policy. Once the user releases the lock, other users can update this security policy.
	Locked *bool
    // The count of rules in the policy. format: int32
	RuleCount *int64
    // Provides a mechanism to apply the rules in this policy for a specified time duration.
	SchedulerPath *string
    // The list of group paths where the rules in this policy will get applied. This scope will take precedence over rule level scope. Supported only for security and redirection policies. In case of RedirectionPolicy, it is expected only when the policy is NS and redirecting to service chain.
	Scope []string
    // This field is used to resolve conflicts between security policies across domains. In order to change the sequence number of a policy one can fire a POST request on the policy entity with a query parameter action=revise The sequence number field will reflect the value of the computed sequence number upon execution of the above mentioned POST request. For scenarios where the administrator is using a template to update several security policies, the only way to set the sequence number is to explicitly specify the sequence number for each security policy. If no sequence number is specified in the payload, a value of 0 is assigned by default. If there are multiple policies with the same sequence number then their order is not deterministic. If a specific order of policies is desired, then one has to specify unique sequence numbers or use the POST request on the policy entity with a query parameter action=revise to let the framework assign a sequence number format: int32
	SequenceNumber *int64
    // Stateful or Stateless nature of security policy is enforced on all rules in this security policy. When it is stateful, the state of the network connects are tracked and a stateful packet inspection is performed. Layer3 security policies can be stateful or stateless. By default, they are stateful. Layer2 security policies can only be stateless.
	Stateful *bool
    // Ensures that a 3 way TCP handshake is done before the data packets are sent. tcp_strict=true is supported only for stateful security policies.
	TcpStrict *bool
    // Rules that are a part of this ForwardingPolicy
	Rules []ForwardingRule
}

// Paged Collection of ForwardingPolicy objects
type ForwardingPolicyListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // ForwardingPolicy list results
	Results []ForwardingPolicy
}

// Forwarding rule that determine how to forward traffic from a VM. Traffic from VM can either be routed via Overlay or Underlay when VM is on hybrid port. Additionally NAT can be performed for VM or container on overlay to route traffic to/from underlay ROUTE_TO_UNDERLAY - Access a service on underlay space from a VM connected to hybrid port. Eg access to AWS S3 on AWS underlay ROUTE_TO_OVERLAY - Access a service on overlay space from a VM connected to hybrid port. ROUTE_FROM_UNDERLAY - Access a service hosted on a VM (that is connected to hybrid port) from underlay space. Eg access from AWS ELB to VM ROUTE_FROM_OVERLAY - Access a service hosted on a VM (that is connected to hybrid port) from overlay space NAT_FROM_UNDERLAY - Access a service on overlay VM/container from underlay space using DNAT from underlay IP to overlay IP NAT_TO_UNDERLAY - Access an underlay service from a VM/container on overlay space using SNAT from overlay IP to underlay IP
type ForwardingRule struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // We need paths as duplicate names may exist for groups under different domains. Along with paths we support IP Address of type IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP Address, Range of IP Address). In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	DestinationGroups []string
    // If set to true, the rule gets applied on all the groups that are NOT part of the destination groups. If false, the rule applies to the destination groups
	DestinationsExcluded *bool
    // Possible values are: 
    //
    // * ForwardingRule#ForwardingRule_DIRECTION_IN
    // * ForwardingRule#ForwardingRule_DIRECTION_OUT
    // * ForwardingRule#ForwardingRule_DIRECTION_IN_OUT
    //
    //  Define direction of traffic.
	Direction *string
    // Flag to disable the rule. Default is enabled.
	Disabled *bool
    // Possible values are: 
    //
    // * ForwardingRule#ForwardingRule_IP_PROTOCOL_IPV4
    // * ForwardingRule#ForwardingRule_IP_PROTOCOL_IPV6
    // * ForwardingRule#ForwardingRule_IP_PROTOCOL_IPV4_IPV6
    //
    //  Type of IP packet that should be matched while enforcing the rule. The value is set to IPV4_IPV6 for Layer3 rule if not specified. For Layer2/Ether rule the value must be null.
	IpProtocol *string
    // A flag to indicate whether rule is a default rule.
	IsDefault *bool
    // Flag to enable packet logging. Default is disabled.
	Logged *bool
    // Text for additional notes on changes.
	Notes *string
    // Holds the list of layer 7 service profile paths. These profiles accept attributes and sub-attributes of various network services (e.g. L4 AppId, encryption algorithm, domain name, etc) as key value pairs.
	Profiles []string
    // This is a unique 4 byte positive number that is assigned by the system. This rule id is passed all the way down to the data path. The first 1GB (1000 to 2^30) will be shared by GM and LM with zebra style striped number space. For E.g 1000 to (1Million -1) by LM, (1M - 2M-1) by GM and so on. format: int64
	RuleId *int64
    // The list of policy paths where the rule is applied LR/Edge/T0/T1/LRP etc. Note that a given rule can be applied on multiple LRs/LRPs.
	Scope []string
    // This field is used to resolve conflicts between multiple Rules under Security or Gateway Policy for a Domain If no sequence number is specified in the payload, a value of 0 is assigned by default. If there are multiple rules with the same sequence number then their order is not deterministic. If a specific order of rules is desired, then one has to specify unique sequence numbers or use the POST request on the rule entity with a query parameter action=revise to let the framework assign a sequence number format: int32
	SequenceNumber *int64
    // In order to specify raw services this can be used, along with services which contains path to services. This can be empty or null.
	ServiceEntries []*data.StructValue
    // In order to specify all services, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the services array. Error will be thrown if ANY is used in conjunction with other values.
	Services []string
    // We need paths as duplicate names may exist for groups under different domains. Along with paths we support IP Address of type IPv4 and IPv6. IP Address can be in one of the format(CIDR, IP Address, Range of IP Address). In order to specify all groups, use the constant \"ANY\". This is case insensitive. If \"ANY\" is used, it should be the ONLY element in the group array. Error will be thrown if ANY is used in conjunction with other values.
	SourceGroups []string
    // If set to true, the rule gets applied on all the groups that are NOT part of the source groups. If false, the rule applies to the source groups
	SourcesExcluded *bool
    // User level field which will be printed in CLI and packet logs.
	Tag *string
    // Possible values are: 
    //
    // * ForwardingRule#ForwardingRule_ACTION_ROUTE_TO_UNDERLAY
    // * ForwardingRule#ForwardingRule_ACTION_ROUTE_TO_OVERLAY
    // * ForwardingRule#ForwardingRule_ACTION_ROUTE_FROM_UNDERLAY
    // * ForwardingRule#ForwardingRule_ACTION_ROUTE_FROM_OVERLAY
    // * ForwardingRule#ForwardingRule_ACTION_NAT_FROM_UNDERLAY
    // * ForwardingRule#ForwardingRule_ACTION_NAT_TO_UNDERLAY
    //
    //  The action to be applied to all the services
	Action *string
}
const ForwardingRule_DIRECTION_IN = "IN"
const ForwardingRule_DIRECTION_OUT = "OUT"
const ForwardingRule_DIRECTION_IN_OUT = "IN_OUT"
const ForwardingRule_IP_PROTOCOL_IPV4 = "IPV4"
const ForwardingRule_IP_PROTOCOL_IPV6 = "IPV6"
const ForwardingRule_IP_PROTOCOL_IPV4_IPV6 = "IPV4_IPV6"
const ForwardingRule_ACTION_ROUTE_TO_UNDERLAY = "ROUTE_TO_UNDERLAY"
const ForwardingRule_ACTION_ROUTE_TO_OVERLAY = "ROUTE_TO_OVERLAY"
const ForwardingRule_ACTION_ROUTE_FROM_UNDERLAY = "ROUTE_FROM_UNDERLAY"
const ForwardingRule_ACTION_ROUTE_FROM_OVERLAY = "ROUTE_FROM_OVERLAY"
const ForwardingRule_ACTION_NAT_FROM_UNDERLAY = "NAT_FROM_UNDERLAY"
const ForwardingRule_ACTION_NAT_TO_UNDERLAY = "NAT_TO_UNDERLAY"

// Paged Collection of ForwardingRules
type ForwardingRuleListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Rule list results
	Results []ForwardingRule
}

// Provides FullSync state for Local Manager from Global Manager.
type FullSyncState struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Errors occurred during full sync.
	Errors []string
    // Full sync id generated by Async Replicator (AR) service.
	FullSyncId *string
    // Possible values are: 
    //
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_INITIAL
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_PAUSE_DCNS
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_DELETED_STALE_ENTITIES
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_PROCESSED_FULLSYNC_DATA
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_PROCESSED_DELTAS
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_UNPAUSE_DCNS
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_COMPLETED
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_ERROR
    // * FullSyncState#FullSyncState_LAST_COMPLETED_STAGE_ABORTED
    //
    //  The current stage of full sync completion for ongoing sync. When Local Manager (LM) receives full sync data from AR, LM starts with workflow to prserve the state and restore the full sync from where it has left off in case of change of leadership of the service to different NSX node or LM is restarted. LM starts the full sync workflow with state INITIAL capturing the AR full sync id and data location details. The stage/state transition follows the order given below INITIAL - Full sync started PROCESSED_FULLSYNC_DATA - Compelted processing the full state data provided by AR PRCESSED_DELTAS - Completed processing pending delta changes provided by AR. DELETED_STALE_ENTITIES - Completed deletion of all global entities on LM that are not in GM anymore COMPLETED - Full sync handling is completed on LM ERROR - Full sync failed with errors on LM, in which case AR will re-attempt full sync later point in time for the LM ABORTED - Indicates that the full sync cancelled as per user request
	LastCompletedStage *string
    // Timestamp of last update, could be progress or success or error. format: int64
	LastUpateTime *int64
    // Timestamp of Full Sync start. format: int64
	StartTime *int64
}
const FullSyncState_LAST_COMPLETED_STAGE_INITIAL = "INITIAL"
const FullSyncState_LAST_COMPLETED_STAGE_PAUSE_DCNS = "PAUSE_DCNS"
const FullSyncState_LAST_COMPLETED_STAGE_DELETED_STALE_ENTITIES = "DELETED_STALE_ENTITIES"
const FullSyncState_LAST_COMPLETED_STAGE_PROCESSED_FULLSYNC_DATA = "PROCESSED_FULLSYNC_DATA"
const FullSyncState_LAST_COMPLETED_STAGE_PROCESSED_DELTAS = "PROCESSED_DELTAS"
const FullSyncState_LAST_COMPLETED_STAGE_UNPAUSE_DCNS = "UNPAUSE_DCNS"
const FullSyncState_LAST_COMPLETED_STAGE_COMPLETED = "COMPLETED"
const FullSyncState_LAST_COMPLETED_STAGE_ERROR = "ERROR"
const FullSyncState_LAST_COMPLETED_STAGE_ABORTED = "ABORTED"

// Paged Collection of FullSync states.
type FullSyncStateListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // FullSync states list.
	Results []FullSyncState
}

type GatewayFloodProtectionProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_GATEWAYFLOODPROTECTIONPROFILE
    // * FloodProtectionProfile#FloodProtectionProfile_RESOURCE_TYPE_DISTRIBUTEDFLOODPROTECTIONPROFILE
    //
    //  GatewayFloodProtectionProfile is used for all Tier0 and Tier1 gateways. DistributedFloodProtectionProfile is used for all Transport Nodes.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If this field is empty, firewall will not set a limit to active ICMP connections. format: int64
	IcmpActiveFlowLimit *int64
    // If this field is empty, firewall will not set a limit to other active connections. besides UDP, ICMP and half open TCP connections. format: int64
	OtherActiveConnLimit *int64
    // If this field is empty, firewall will not set a limit to half open TCP connections. format: int64
	TcpHalfOpenConnLimit *int64
    // If this field is empty, firewall will not set a limit to active UDP connections. format: int64
	UdpActiveFlowLimit *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const GatewayFloodProtectionProfile__TYPE_IDENTIFIER = "GatewayFloodProtectionProfile"

// Contains ordered list of Rules for GatewayPolicy
type GatewayPolicy struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // - Distributed Firewall - Policy framework provides five pre-defined categories for classifying a security policy. They are \"Ethernet\",\"Emergency\", \"Infrastructure\" \"Environment\" and \"Application\". There is a pre-determined order in which the policy framework manages the priority of these security policies. Ethernet category is for supporting layer 2 firewall rules. The other four categories are applicable for layer 3 rules. Amongst them, the Emergency category has the highest priority followed by Infrastructure, Environment and then Application rules. Administrator can choose to categorize a security policy into the above categories or can choose to leave it empty. If empty it will have the least precedence w.r.t the above four categories. - Edge Firewall - Policy Framework for Edge Firewall provides six pre-defined categories \"Emergency\", \"SystemRules\", \"SharedPreRules\", \"LocalGatewayRules\", \"AutoServiceRules\" and \"Default\", in order of priority of rules. All categories are allowed for Gatetway Policies that belong to 'default' Domain. However, for user created domains, category is restricted to \"SharedPreRules\" or \"LocalGatewayRules\" only. Also, the users can add/modify/delete rules from only the \"SharedPreRules\" and \"LocalGatewayRules\" categories. If user doesn't specify the category then defaulted to \"Rules\". System generated category is used by NSX created rules, for example BFD rules. Autoplumbed category used by NSX verticals to autoplumb data path rules. Finally, \"Default\" category is the placeholder default rules with lowest in the order of priority.
	Category *string
    // Comments for security policy lock/unlock.
	Comments *string
    // This field is to indicate the internal sequence number of a policy with respect to the policies across categories. format: int32
	InternalSequenceNumber *int64
    // A flag to indicate whether policy is a default policy.
	IsDefault *bool
    // ID of the user who last modified the lock for the secruity policy.
	LockModifiedBy *string
    // SecurityPolicy locked/unlocked time in epoch milliseconds. format: int64
	LockModifiedTime *int64
    // Indicates whether a security policy should be locked. If the security policy is locked by a user, then no other user would be able to modify this security policy. Once the user releases the lock, other users can update this security policy.
	Locked *bool
    // The count of rules in the policy. format: int32
	RuleCount *int64
    // Provides a mechanism to apply the rules in this policy for a specified time duration.
	SchedulerPath *string
    // The list of group paths where the rules in this policy will get applied. This scope will take precedence over rule level scope. Supported only for security and redirection policies. In case of RedirectionPolicy, it is expected only when the policy is NS and redirecting to service chain.
	Scope []string
    // This field is used to resolve conflicts between security policies across domains. In order to change the sequence number of a policy one can fire a POST request on the policy entity with a query parameter action=revise The sequence number field will reflect the value of the computed sequence number upon execution of the above mentioned POST request. For scenarios where the administrator is using a template to update several security policies, the only way to set the sequence number is to explicitly specify the sequence number for each security policy. If no sequence number is specified in the payload, a value of 0 is assigned by default. If there are multiple policies with the same sequence number then their order is not deterministic. If a specific order of policies is desired, then one has to specify unique sequence numbers or use the POST request on the policy entity with a query parameter action=revise to let the framework assign a sequence number format: int32
	SequenceNumber *int64
    // Stateful or Stateless nature of security policy is enforced on all rules in this security policy. When it is stateful, the state of the network connects are tracked and a stateful packet inspection is performed. Layer3 security policies can be stateful or stateless. By default, they are stateful. Layer2 security policies can only be stateless.
	Stateful *bool
    // Ensures that a 3 way TCP handshake is done before the data packets are sent. tcp_strict=true is supported only for stateful security policies.
	TcpStrict *bool
    // Rules that are a part of this SecurityPolicy
	Rules []Rule
}

// Paged Collection of gateway policies
type GatewayPolicyListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // GatewayPolicy list results
	Results []GatewayPolicy
}

// QoS profile contains configuration of rate limiting properties which can be applied in ingress and egress directions at Tier1 gateways
type GatewayQosProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Burst size in bytes. format: int32
	BurstSize *int64
    // Committed bandwidth in both directions specoficd in Mbps. Bandwidth is limited to line rate when the value configured is greater than line rate. format: int32
	CommittedBandwitdth *int64
    // Possible values are: 
    //
    // * GatewayQosProfile#GatewayQosProfile_EXCESS_ACTION_DROP
    //
    //  Action on traffic exceeding bandwidth.
	ExcessAction *string
}
const GatewayQosProfile_EXCESS_ACTION_DROP = "DROP"

// Gateway QoS profile configuration
type GatewayQosProfileConfig struct {
    // Policy path to gateway QoS profile in egress direction.
	EgressQosProfilePath *string
    // Policy path to gateway QoS profile in ingress direction.
	IngressQosProfilePath *string
}

type GatewayQosProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Paginated list of GatewayQosProfile
	Results []GatewayQosProfile
}

type GatewayRouteCsvRecord struct {
    // The admin distance of the next hop format: int64
	AdminDistance *int64
    // Edge node policy path.
	EdgePath *string
    // The policy path of the interface which is used as the next hop
	_Interface *string
    // Logical router component(Service Router/Distributed Router) id
	LrComponentId *string
    // Logical router component(Service Router/Distributed Router) type
	LrComponentType *string
    // CIDR network address format: ip-cidr-block
	Network *string
    // The IP of the next hop format: ip
	NextHop *string
    // Route type (USER, CONNECTED, NSX_INTERNAL,..)
	RouteType *string
}

type GatewayRouteTableInCsvFormat struct {
    // File name set by HTTP server if API returns CSV result as a file.
	FileName *string
    // Timestamp when the data was last updated; unset if data source has never updated the data. format: int64
	LastUpdateTimestamp *int64
	Results []GatewayRouteCsvRecord
}

// Define DHCP options other than option 121.
type GenericDhcpOption struct {
    // Code of the dhcp option. format: int64
	Code *int64
    // Value of the option.
	Values []string
}

// Represents realized entity
type GenericPolicyRealizedResource struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // Alarm info detail
	Alarms []PolicyAlarmResource
    // Desire state paths of this object
	IntentReference []string
    // Realization API of this object on enforcement point
	RealizationApi *string
    // Realization id of this object
	RealizationSpecificIdentifier *string
    // It define the root cause for runtime error.
	RuntimeError *string
    // Possible values could be UP, DOWN, UNKNOWN, DEGRADED This list is not exhaustive.
	RuntimeStatus *string
    // Possible values are: 
    //
    // * GenericPolicyRealizedResource#GenericPolicyRealizedResource_STATE_UNAVAILABLE
    // * GenericPolicyRealizedResource#GenericPolicyRealizedResource_STATE_UNREALIZED
    // * GenericPolicyRealizedResource#GenericPolicyRealizedResource_STATE_REALIZED
    // * GenericPolicyRealizedResource#GenericPolicyRealizedResource_STATE_ERROR
    //
    //  Realization state of this object
	State *string
    // The path of the enforcement point.
	EnforcementPointPath *string
    // Type of realized entity
	EntityType *string
    // Collection of type specific properties
	ExtendedAttributes []AttributeVal
    // Collection of intent paths
	IntentPaths []string
    // The site where this entity resides.
	SitePath *string
}
const GenericPolicyRealizedResource_STATE_UNAVAILABLE = "UNAVAILABLE"
const GenericPolicyRealizedResource_STATE_UNREALIZED = "UNREALIZED"
const GenericPolicyRealizedResource_STATE_REALIZED = "REALIZED"
const GenericPolicyRealizedResource_STATE_ERROR = "ERROR"

// GenericPolicyRealizedResource list result
type GenericPolicyRealizedResourceListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // List of realized resources
	Results []GenericPolicyRealizedResource
}

// Global configuration
type GlobalConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Contains the FIPSGlobalConfig object.
	Fips *FIPSGlobalConfig
    // Possible values are: 
    //
    // * GlobalConfig#GlobalConfig_L3FORWARDING_MODE_ONLY
    // * GlobalConfig#GlobalConfig_L3FORWARDING_MODE_AND_IPV6
    //
    //  Configure forwarding mode for routing. This setting does not restrict configuration for other modes.
	L3ForwardingMode *string
    // Maximum transmission unit (MTU) specifies the size of the largest packet that a network protocol can transmit. format: int32
	Mtu *int64
}
const GlobalConfig_L3FORWARDING_MODE_ONLY = "IPV4_ONLY"
const GlobalConfig_L3FORWARDING_MODE_AND_IPV6 = "IPV4_AND_IPV6"

// Global Manager.
type GlobalManager struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // To create a standby GM, the connection information (username, password, and API thumbprint) for at least one NSX manager node in the remote site must be provided. Once the GM has been successfully onboarded, the connection_info is discarded and authentication to the standby GM occurs using an X.509 client certificate.
	ConnectionInfo []SiteNodeConnectionInfo
    // Fail onboarding if maximum RTT exceeded.
	FailIfRttExceeded *bool
    // Internally generated UUID to the federation of Global Manager.
	FederationId *string
    // If provided and fail_if_rtt_exceeded is true, onboarding of the site will fail if measured RTT is greater than this value. format: int64
	MaximumRtt *int64
    // Possible values are: 
    //
    // * GlobalManager#GlobalManager_MODE_ACTIVE
    // * GlobalManager#GlobalManager_MODE_STANDBY
    //
    //  There can be at most one ACTIVE global manager and one STANDBY global manager. In order to add a STANDBY manager, there must be an ACTIVE manager defined.
	Mode *string
    // UUID of the site where Global manager is running. This is the Site Manager generated UUID for every NSX deployment.
	SiteId *string
}
const GlobalManager_MODE_ACTIVE = "ACTIVE"
const GlobalManager_MODE_STANDBY = "STANDBY"

// This configuration is distributed to all Sites participating in federation.
type GlobalManagerConfig struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Global Manager federation RTEP configuration. This configuration is distributed to all Sites participating in federation.
	RtepConfig *GmRtepConfig
}

// Paged Collection of Global Managers.
type GlobalManagerListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Global Manager List Result.
	Results []GlobalManager
}

// Overall restore process status
type GlobalRestoreStatus struct {
    // A description of the restore status
	Description *string
    // Possible values are: 
    //
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_INITIAL
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_SUCCESS
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_FAILED
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_RUNNING
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_SUSPENDED_BY_USER
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_SUSPENDED_FOR_USER_ACTION
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_SUSPENDED
    // * GlobalRestoreStatus#GlobalRestoreStatus_VALUE_ABORTED
    //
    //  Global rolled-up restore status value
	Value *string
}
const GlobalRestoreStatus_VALUE_INITIAL = "INITIAL"
const GlobalRestoreStatus_VALUE_SUCCESS = "SUCCESS"
const GlobalRestoreStatus_VALUE_FAILED = "FAILED"
const GlobalRestoreStatus_VALUE_RUNNING = "RUNNING"
const GlobalRestoreStatus_VALUE_SUSPENDED_BY_USER = "SUSPENDED_BY_USER"
const GlobalRestoreStatus_VALUE_SUSPENDED_FOR_USER_ACTION = "SUSPENDED_FOR_USER_ACTION"
const GlobalRestoreStatus_VALUE_SUSPENDED = "SUSPENDED"
const GlobalRestoreStatus_VALUE_ABORTED = "ABORTED"

// Additional configuration required for federation at Site.
type GmFederationSiteConfig struct {
    // IP Addresses to be allocated for transit segment when the gateway is stretched. Note that Global Manager will carve out the IP Pool for each site to be used for edge nodes when gateway is stretched based on the user provided subnet and maximum number of edge nodes allowed per site. format: ip-cidr-block
	TransitSubnet *string
}

// Global Manager federation RTEP configuration. This configuration is distributed to all Sites participating in federation.
type GmRtepConfig struct {
    // Password to authenticate IBGP session between remote tunnel endpoints created on federated sites. This is applied to inter-site underlay IBGP neighbors created over remote tunnel endpoints on all sites. Empty string (\"\") clears existing password.
	IbgpPassword *string
}

// Represents configuration of a graph widget
type GraphConfiguration struct {
    // Axes of a graph
	Axes *Axes
    // If true, value of a point is shown as label on X axis. If false, value of point is not shown as label on X axis. false can be useful in situations where there are too many points and showing the X value as label can clutter the X axis.
	DisplayxValue *bool
    // Graphs
	Graphs []GraphDefinition
    // Hyperlink of the specified UI page that provides details.
	Navigation *string
    // Possible values are: 
    //
    // * GraphConfiguration#GraphConfiguration_SUB_TYPE_LINE_GRAPH
    // * GraphConfiguration#GraphConfiguration_SUB_TYPE_BAR_GRAPH
    // * GraphConfiguration#GraphConfiguration_SUB_TYPE_STACKED_BAR_GRAPH
    //
    //  Describes the the type of graph. LINE_GRAPH shows a line graph chart BAR_GRAPH shows a simple bar graph chart STACKED_BAR_GRAPH shows a stacked bar graph chart
	SubType *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const GraphConfiguration__TYPE_IDENTIFIER = "GraphConfiguration"
const GraphConfiguration_SUB_TYPE_LINE_GRAPH = "LINE_GRAPH"
const GraphConfiguration_SUB_TYPE_BAR_GRAPH = "BAR_GRAPH"
const GraphConfiguration_SUB_TYPE_STACKED_BAR_GRAPH = "STACKED_BAR_GRAPH"

// Defines a graph
type GraphDefinition struct {
    // Describes the graph. It labels the entities of graph. If the label is not provided then it is not shown for a graph. For example, for a single graph, the title of widget can describe the graph and a label may not be necessary to be shown.
	Label *Label
    // Defines the points of a graph.
	PointDefinition *PointDefinition
    // Additional rendering or conditional evaluation of the field values to be performed, if any.
	RenderConfiguration []RenderConfiguration
}

// Represents configuration of a Grid or Table widget.
type GridConfiguration struct {
    // Array of columns of a Grid widget
	Columns []ColumnItem
    // Number of records per page. page_size will be effective only when the urls provided in the datasource support paging. format: int32
	PageSize *int64
    // Rows of grid or table are formed from the list of objects returned by a row list field.
	RowListFields []RowListField
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Title of the widget. If display_name is omitted, the widget will be shown without a title.
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_LABELVALUECONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DONUTCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_MULTIWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CONTAINERCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_STATSCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRIDCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_GRAPHCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_CUSTOMWIDGETCONFIGURATION
    // * WidgetConfiguration#WidgetConfiguration_RESOURCE_TYPE_DROPDOWNFILTERWIDGETCONFIGURATION
    //
    //  Supported visualization types are LabelValueConfiguration, DonutConfiguration, GridConfiguration, StatsConfiguration, MultiWidgetConfiguration, GraphConfiguration, ContainerConfiguration, CustomWidgetConfiguration and DropdownFilterWidgetConfiguration.
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // The 'datasources' represent the sources from which data will be fetched. Currently, only NSX-API is supported as a 'default' datasource. An example of specifying 'default' datasource along with the urls to fetch data from is given at 'example_request' section of 'CreateWidgetConfiguration' API.
	Datasources []Datasource
    // Default filter values to be passed to datasources. This will be used when the report is requested without filter values.
	DefaultFilterValue []DefaultFilterValue
    // Id of drilldown widget, if any. Id should be a valid id of an existing widget. A widget is considered as drilldown widget when it is associated with any other widget and provides more detailed information about any data item from the parent widget.
	DrilldownId *string
    // Id of filter widget for subscription, if any. Id should be a valid id of an existing filter widget. Filter widget should be from the same view. Datasource URLs should have placeholder values equal to filter alias to accept the filter value on filter change.
	Filter *string
    // Flag to indicate that widget will continue to work without filter value. If this flag is set to false then default_filter_value is manadatory.
	FilterValueRequired *bool
	Footer *Footer
    // Icons to be applied at dashboard for widgets and UI elements.
	Icons []Icon
    // Set to true if this widget should be used as a drilldown.
	IsDrilldown *bool
    // Legend to be displayed. If legend is not needed, do not include it.
	Legend *Legend
    // Please use the property 'shared' of View instead of this. The widgets of a shared view are visible to other users.
	Shared *bool
    // Represents the horizontal span of the widget / container. format: int32
	Span *int64
    // Specify relavite weight in WidgetItem for placement in a view. Please see WidgetItem for details. format: int32
	Weight *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const GridConfiguration__TYPE_IDENTIFIER = "GridConfiguration"

// Group.
type Group struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // The expression list must follow below criteria: 1. A non-empty expression list, must be of odd size. In a list, with indices starting from 0, all non-conjunction expressions must be at even indices, separated by a conjunction expression at odd indices. 2. The total of ConditionExpression and NestedExpression in a list should not exceed 5. 3. The total of IPAddressExpression, MACAddressExpression, external IDs in an ExternalIDExpression and paths in a PathExpression must not exceed 500. 4. Each expression must be a valid Expression. See the definition of the Expression type for more information.
	Expression []*data.StructValue
    // Extended Expression allows additional higher level context to be specified for grouping criteria. (e.g. user AD group) This field allow users to specified user context as the source of a firewall rule for IDFW feature. Current version only support a single IdentityGroupExpression. In the future, this might expand to support other conjunction and non-conjunction expression. The extended expression list must follow below criteria: 1. Contains a single IdentityGroupExpression. No conjunction expression is supported. 2. No other non-conjunction expression is supported, except for IdentityGroupExpression. 3. Each expression must be a valid Expression. See the definition of the Expression type for more information. 4. Extended expression are implicitly AND with expression. 5. No nesting can be supported if this value is used. 6. If a Group is using extended expression, this group must be the only member in the source field of an communication map.
	ExtendedExpression []*data.StructValue
    // If true, indicates that this is a remote reference group. Such group will have span different from the its parent domain. Default value is false.
	Reference *bool
    // Possible values are: 
    //
    // * Group#Group_STATE_IN_PROGRESS
    // * Group#Group_STATE_SUCCESS
    // * Group#Group_STATE_FAILURE
    //
    //  Realization state of this group
	State *string
}
const Group_STATE_IN_PROGRESS = "IN_PROGRESS"
const Group_STATE_SUCCESS = "SUCCESS"
const Group_STATE_FAILURE = "FAILURE"

// This entity will be used to establish association between discovery profile and Group. With this entity, user can specify intent for applying discovery profile profile to particular Group.
type GroupDiscoveryProfileBindingMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // PolicyPath of associated Profile
	ProfilePath *string
    // Sequence number used to resolve conflicts betweeen two profiles applied on the same group. Lower sequence number takes higher precedence. Two binding maps applied to the same profile must have the same sequence number. User defined sequence numbers range from 1 through 100,000. System defined sequence numbers range from 100,001 through 200,000. format: int64
	SequenceNumber *int64
}

// GroupInfo contains information about a particular Group used in Redirection Rules. It also contains information about policy path, if the group is created from Policy.
type GroupInfo struct {
    // Group Data.
	Group *ResourceReference
    // Policy path of a particular Group.
	GroupPolicyPath *string
}

// Paged Collection of Groups
type GroupListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Group list results
	Results []Group
}

// List of same type members to either add or remove from a group.
type GroupMemberList struct {
    // This array contains group members of similar types.
	Members []string
}

// Collection of tags used in a policy group for a particular member type
type GroupMemberTagsList struct {
    // Member type for which we will list the tags
	MemberType *string
    // List of tags for the member type
	Tags []string
}

type GroupMemberTypeListResult struct {
    // Count of the member types in the results array format: int64
	ResultCount *int64
    // Possible values are: 
    //
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_VIRTUALMACHINE
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_VIRTUALNETWORKINTERFACE
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_SEGMENTPORT
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_SEGMENT
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_CLOUDNATIVESERVICEINSTANCE
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_IPADDRESS
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_MACADDRESS
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_IPSET
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_IDENTITYGROUP
    // * GroupMemberTypeListResult#GroupMemberTypeListResult_RESULTS_PHYSICALSERVER
    //
    //  Collection of member types for the given Group
	Results []string
}
const GroupMemberTypeListResult_RESULTS_VIRTUALMACHINE = "VirtualMachine"
const GroupMemberTypeListResult_RESULTS_VIRTUALNETWORKINTERFACE = "VirtualNetworkInterface"
const GroupMemberTypeListResult_RESULTS_SEGMENTPORT = "SegmentPort"
const GroupMemberTypeListResult_RESULTS_SEGMENT = "Segment"
const GroupMemberTypeListResult_RESULTS_CLOUDNATIVESERVICEINSTANCE = "CloudNativeServiceInstance"
const GroupMemberTypeListResult_RESULTS_IPADDRESS = "IPAddress"
const GroupMemberTypeListResult_RESULTS_MACADDRESS = "MACAddress"
const GroupMemberTypeListResult_RESULTS_IPSET = "IPSet"
const GroupMemberTypeListResult_RESULTS_IDENTITYGROUP = "IdentityGroup"
const GroupMemberTypeListResult_RESULTS_PHYSICALSERVER = "PhysicalServer"

// This entity will be used to establish association between monitoring profile and Group. Using this entity, you can specify intent for applying monitoring profile to particular Group. Group with membership criteria vm only supported as source group. Port mirroring is only supported on group with five vms.
type GroupMonitoringProfileBindingMap struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // PolicyPath of associated IPFIX DFW Profile
	IpfixDfwProfilePath *string
    // PolicyPath of associated IPFIX L2 Profile
	IpfixL2ProfilePath *string
    // PolicyPath of associated Port Mirroring Profile
	PortMirroringProfilePath *string
}

// Paged collection of Group Monitoring Profile Binding Maps
type GroupMonitoringProfileBindingMapListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // Group Monitoring Profile Binding Map list results
	Results []GroupMonitoringProfileBindingMap
}

// Collection of tags used in a policy group listed per member type
type GroupTagsList struct {
    // Collection of tags used in a policy group listed per member type
	Results []GroupMemberTagsList
}

// Guest virtual machine details include OS name and computer name of guest VM.
type GuestInfo struct {
    // Computer name of guest virtual machine, which is set inside guest OS. Currently this is supported for guests on ESXi that have VMware Tools installed.
	ComputerName *string
    // OS name of guest virtual machine. Currently this is supported for guests on ESXi that have VMware Tools installed.
	OsName *string
}

// Header of a widget that provides additional information. This will be shown at the container level. It includes details as label value pairs.
type Header struct {
    // If the condition is met then the header will be applied. Examples of expression syntax are provided under 'example_request' section of 'CreateWidgetConfiguration' API.
	Condition *string
    // Possible values are: 
    //
    // * Header#Header_CONTENT_ALIGNMENT_LEFT
    // * Header#Header_CONTENT_ALIGNMENT_RIGHT
    //
    //  Alignment of header labels.
	ContentAlignment *string
    // An array of label-value properties.
	SubHeaders []PropertyItem
}
const Header_CONTENT_ALIGNMENT_LEFT = "LEFT"
const Header_CONTENT_ALIGNMENT_RIGHT = "RIGHT"

// Active healthchecks are disabled by default and can be enabled for a server pool by binding a health monitor to the Group through the PolicyLbRule object. This represents active health monitoring over HTTP. Active healthchecks are initiated periodically, at a configurable interval, to each member of the Group. Only if a healthcheck fails consecutively for a specified number of times (fall_count) to a member will the member status be marked DOWN. Once a member is DOWN, a specified number of consecutive successful healthchecks (rise_count) will bring the member back to UP state. After a healthcheck is initiated, if it does not complete within a certain period, then also the healthcheck is considered to be unsuccessful. Completing a healthcheck within timeout means establishing a connection (TCP or SSL), if applicable, sending the request and receiving the response, all within the configured timeout.
type HttpPolicyLbMonitorProfile struct {
    // For HTTP active healthchecks, the HTTP request url sent can be customized and can include query parameters.
	Url *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_TCPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_UDPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_ICMPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_HTTPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_HTTPSPOLICYLBMONITORPROFILE
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Only if a healthcheck fails consecutively for a specified number of times, given with fall_count, to a member will the member status be marked DOWN. format: int64
	FallCount *int64
    // Active healthchecks are initiated periodically, at a configurable interval (in seconds), to each member of the Group. format: int64
	Interval *int64
    // Typically, monitors perform healthchecks to Group members using the member IP address and pool_port. However, in some cases, customers prefer to run healthchecks against a different port than the pool member port which handles actual application traffic. In such cases, the port to run healthchecks against can be specified in the monitor_port value. format: int32
	MonitorPort *int64
    // Once a member is DOWN, a specified number of consecutive successful healthchecks specified by rise_count will bring the member back to UP state. format: int64
	RiseCount *int64
    // Timeout specified in seconds. After a healthcheck is initiated, if it does not complete within a certain period, then also the healthcheck is considered to be unsuccessful. Completing a healthcheck within timeout means establishing a connection (TCP or SSL), if applicable, sending the request and receiving the response, all within the configured timeout. format: int64
	Timeout *int64
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const HttpPolicyLbMonitorProfile__TYPE_IDENTIFIER = "HttpPolicyLbMonitorProfile"

// Virtual server acts as a facade to an application, receives all client connections over HTTP and distributes them among the backend servers.
type HttpPolicyLbVirtualServer struct {
    // Backend web servers typically log each request they handle along with the requesting client IP address. These logs are used for debugging, analytics and other such purposes. If the deployment topology requires enabling SNAT on the load balancer, then server will see the client as the SNAT IP which defeats the purpose of logging. To work around this issue, load balancer can be configured to insert XFF HTTP header with the original client IP address. Backend servers can then be configured to log the IP address in XFF header instead of the source IP address of the connection. If XFF header is not present in the incoming request, load balancer inserts a new XFF header with the client IP address.
	InsertClientIpHeader *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_TCPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_UDPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPSPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_CUSTOMPOLICYLBVIRTUALSERVER
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If access log is enabled, all HTTP requests sent to an L7 virtual server are logged to the access log file. Both successful requests (backend server returns 2xx) and unsuccessful requests (backend server returns 4xx or 5xx) are logged to access log, if enabled.
	AccessLogEnabled *bool
    // Configures the IP address of the PolicyLbVirtualServer where it receives all client connections and distributes them among the backend servers. format: ip
	IpAddress *string
    // Path to optional object that enables persistence on a virtual server allowing related client connections to be sent to the same backend server. Persistence is disabled by default.
	LbPersistenceProfile *string
    // Ports contains a list of at least one port or port range such as \"80\", \"1234-1236\". Each port element in the list should be a single port or a single port range. format: port-or-range
	Ports []string
    // Path to router type object that PolicyLbVirtualServer connects to. The only supported router object is Network.
	RouterPath *string
	TrafficSource *string
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const HttpPolicyLbVirtualServer__TYPE_IDENTIFIER = "HttpPolicyLbVirtualServer"

// Active healthchecks are disabled by default and can be enabled for a server pool by binding a health monitor to the Group through the PolicyLbRule object. This represents active health monitoring over HTTPS. Active healthchecks are initiated periodically, at a configurable interval, to each member of the Group. Only if a healthcheck fails consecutively for a specified number of times (fall_count) to a member will the member status be marked DOWN. Once a member is DOWN, a specified number of consecutive successful healthchecks (rise_count) will bring the member back to UP state. After a healthcheck is initiated, if it does not complete within a certain period, then also the healthcheck is considered to be unsuccessful. Completing a healthcheck within timeout means establishing a connection (TCP or SSL), if applicable, sending the request and receiving the response, all within the configured timeout.
type HttpsPolicyLbMonitorProfile struct {
    // For HTTP active healthchecks, the HTTP request url sent can be customized and can include query parameters.
	Url *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_TCPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_UDPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_ICMPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_HTTPPOLICYLBMONITORPROFILE
    // * PolicyLbMonitorProfile#PolicyLbMonitorProfile_RESOURCE_TYPE_HTTPSPOLICYLBMONITORPROFILE
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Only if a healthcheck fails consecutively for a specified number of times, given with fall_count, to a member will the member status be marked DOWN. format: int64
	FallCount *int64
    // Active healthchecks are initiated periodically, at a configurable interval (in seconds), to each member of the Group. format: int64
	Interval *int64
    // Typically, monitors perform healthchecks to Group members using the member IP address and pool_port. However, in some cases, customers prefer to run healthchecks against a different port than the pool member port which handles actual application traffic. In such cases, the port to run healthchecks against can be specified in the monitor_port value. format: int32
	MonitorPort *int64
    // Once a member is DOWN, a specified number of consecutive successful healthchecks specified by rise_count will bring the member back to UP state. format: int64
	RiseCount *int64
    // Timeout specified in seconds. After a healthcheck is initiated, if it does not complete within a certain period, then also the healthcheck is considered to be unsuccessful. Completing a healthcheck within timeout means establishing a connection (TCP or SSL), if applicable, sending the request and receiving the response, all within the configured timeout. format: int64
	Timeout *int64
}

// Virtual server acts as a facade to an application, receives all client connections over HTTPS and distributes them among the backend servers.
type HttpsPolicyLbVirtualServer struct {
    // Client-side SSL profile binding allows multiple certificates, for different hostnames, to be bound to the same virtual server. The setting is used when load balancer acts as an SSL server and terminating the client SSL connection
	ClientSslCertificateIds []string
    // Possible values are: 
    //
    // * HttpsPolicyLbVirtualServer#HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_BASE_SECURE_111317
    // * HttpsPolicyLbVirtualServer#HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_MODERATE_SECURE_111317
    // * HttpsPolicyLbVirtualServer#HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_HIGH_SECURE_111317
    //
    //  Security settings representing various security settings when the VirtualServer acts as an SSL server - BASE_SECURE_111317 - MODERATE_SECURE_111317 - HIGH_SECURE_111317
	ClientSslSettings *string
    // The setting is used when load balancer acts as an SSL server and terminating the client SSL connection. A default certificate should be specified which will be used if the server does not host multiple hostnames on the same IP address or if the client does not support SNI extension.
	DefaultClientSslCertificateId *string
    // Backend web servers typically log each request they handle along with the requesting client IP address. These logs are used for debugging, analytics and other such purposes. If the deployment topology requires enabling SNAT on the load balancer, then server will see the client as the SNAT IP which defeats the purpose of logging. To work around this issue, load balancer can be configured to insert XFF HTTP header with the original client IP address. Backend servers can then be configured to log the IP address in XFF header instead of the source IP address of the connection. If XFF header is not present in the incoming request, load balancer inserts a new XFF header with the client IP address.
	InsertClientIpHeader *bool
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_TCPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_UDPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_HTTPSPOLICYLBVIRTUALSERVER
    // * PolicyLbVirtualServer#PolicyLbVirtualServer_RESOURCE_TYPE_CUSTOMPOLICYLBVIRTUALSERVER
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // If access log is enabled, all HTTP requests sent to an L7 virtual server are logged to the access log file. Both successful requests (backend server returns 2xx) and unsuccessful requests (backend server returns 4xx or 5xx) are logged to access log, if enabled.
	AccessLogEnabled *bool
    // Configures the IP address of the PolicyLbVirtualServer where it receives all client connections and distributes them among the backend servers. format: ip
	IpAddress *string
    // Path to optional object that enables persistence on a virtual server allowing related client connections to be sent to the same backend server. Persistence is disabled by default.
	LbPersistenceProfile *string
    // Ports contains a list of at least one port or port range such as \"80\", \"1234-1236\". Each port element in the list should be a single port or a single port range. format: port-or-range
	Ports []string
    // Path to router type object that PolicyLbVirtualServer connects to. The only supported router object is Network.
	RouterPath *string
	TrafficSource *string
}
const HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_BASE_SECURE_111317 = "BASE_SECURE_111317"
const HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_MODERATE_SECURE_111317 = "MODERATE_SECURE_111317"
const HttpsPolicyLbVirtualServer_CLIENT_SSL_SETTINGS_HIGH_SECURE_111317 = "HIGH_SECURE_111317"

// A ServiceEntry that represents IPv4 or IPv6 ICMP protocol
type ICMPTypeServiceEntry struct {
    // ICMP message code format: int64
	IcmpCode *int64
    // ICMP message type format: int64
	IcmpType *int64
    // Possible values are: 
    //
    // * ICMPTypeServiceEntry#ICMPTypeServiceEntry_PROTOCOL_ICMPV4
    // * ICMPTypeServiceEntry#ICMPTypeServiceEntry_PROTOCOL_ICMPV6
	Protocol *string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IGMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ICMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ALGTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_L4PORTSETSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ETHERTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const ICMPTypeServiceEntry__TYPE_IDENTIFIER = "ICMPTypeServiceEntry"
const ICMPTypeServiceEntry_PROTOCOL_ICMPV4 = "ICMPv4"
const ICMPTypeServiceEntry_PROTOCOL_ICMPV6 = "ICMPv6"

// A ServiceEntry that represents IGMP protocol
type IGMPTypeServiceEntry struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IGMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ICMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ALGTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_L4PORTSETSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ETHERTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const IGMPTypeServiceEntry__TYPE_IDENTIFIER = "IGMPTypeServiceEntry"

// Represents IP address expressions in the form of an array, to support addition of IP addresses in a group. Avoid creating groups with multiple IPAddressExpression. In future releases, group will be restricted to contain a single IPAddressExpression. To group IPAddresses, use nested groups instead of multiple IPAddressExpressions.
type IPAddressExpression struct {
    // This array can consist of a single IP address, IP address range or a subnet. Its type can be of either IPv4 or IPv6. Both IPv4 and IPv6 addresses within one expression is not allowed. Supported list of formats are, \"192.168.1.1\", \"192.168.1.1-192.168.1.100\", \"192.168.0.0/24\", \"fe80::250:56ff:fe83:318c\", \"fe80::250:56ff:fe83:3181-fe80::250:56ff:fe83:318c\", \"fe80::250:56ff:fe83:318c/64\". format: address-or-block-or-range
	IpAddresses []string
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * Expression#Expression_RESOURCE_TYPE_CONDITION
    // * Expression#Expression_RESOURCE_TYPE_CONJUNCTIONOPERATOR
    // * Expression#Expression_RESOURCE_TYPE_NESTEDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IPADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_MACADDRESSEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_EXTERNALIDEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_PATHEXPRESSION
    // * Expression#Expression_RESOURCE_TYPE_IDENTITYGROUPEXPRESSION
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const IPAddressExpression__TYPE_IDENTIFIER = "IPAddressExpression"

// Collection of IP Addresses.
type IPAddressList struct {
    // The array contains IP addresses. format: address-or-block-or-range
	IpAddresses []string
}

// IP Address and Port information
type IPAddressPortPair struct {
    // The IPAddress to be combined with Port for defining specific access point. format: ip
	IpAddress *string
    // The port to be combined with IPAddress for defining a specific access point. format: int32
	Port *int64
}

// Using this profile to configure different options of IP Discovery
type IPDiscoveryProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // This property controls the ARP and ND cache timeout period. It is recommended that this property be greater than the ARP/ND cache timeout on the VM. format: int32
	ArpNdBindingTimeout *int64
    // Duplicate IP detection is used to determine if there is any IP conflict with any other port on the same logical switch. If a conflict is detected, then the IP is marked as a duplicate on the port where the IP was discovered last. The duplicate IP will not be added to the realized address binings for the port and hence will not be used in DFW rules or other security configurations for the port.rt.
	DuplicateIpDetection *DuplicateIPDetectionOptions
    // Indicates IPv4 Discovery options
	IpV4DiscoveryOptions *IPv4DiscoveryOptions
    // Indicates IPv6 Discovery options
	IpV6DiscoveryOptions *IPv6DiscoveryOptions
    // Indicates whether \"Trust on First Use(TOFU)\" paradigm is enabled.
	TofuEnabled *bool
}

// Paged collection of IP Discovery Profiles
type IPDiscoveryProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IP Discovery profile list results
	Results []IPDiscoveryProfile
}

// IPFIX data will be collected on collector Host ip and port address should be provided for collector.
type IPFIXCollectorProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // IP address for the IPFIX collector. format: ip
	Ipaddress *string
    // Port for the IPFIX collector. format: int32
	Port *int64
}

// Paged collection of IPFIX collector profiles.
type IPFIXCollectorProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX collector Instances list results
	Results []IPFIXCollectorProfile
}

// IPFIX DFW data will be collected on collector Host IP and Port address should be provided for collector.
type IPFIXDFWCollector struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // IP address for the IPFIX DFW collector. IP addresses such as 0.0.0.0, 127.0.0.1, 255.255.255.255 are invalid. format: ip
	CollectorIpAddress *string
    // Port for the IPFIX DFW collector. format: int32
	CollectorPort *int64
}

// IPFIX data for the NSX distributed firewall will be sent to the specified IPFIX collectors.
type IPFIXDFWCollectorProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // It accepts Multiple Collectors.
	IpfixDfwCollectors []IPFIXDFWCollector
}

// Paged Collection of IPFIX DFW Collector Profile
type IPFIXDFWCollectorProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX DFW Collection Instances list results
	Results []IPFIXDFWCollectorProfile
}

// IPFIX packets from source will be sent to IPFIX DFW collector.
type IPFIXDFWProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // For long standing active flows, IPFIX records will be sent per timeout period in minutes. format: int32
	ActiveFlowExportTimeout *int64
    // Policy path for IPFIX collector profiles. IPFIX data from these logical segments will be sent to all specified IPFIX collectors.
	IpfixDfwCollectorProfilePath *string
    // An identifier that is unique to the exporting process and used to meter the flows. format: int32
	ObservationDomainId *int64
    // This priority field is used to resolve conflicts in Segment Ports which are covered by more than one IPFIX profiles. The IPFIX exporter will send records to Collectors in highest priority profile (lowest number) only. format: int32
	Priority *int64
}

// Paged Collection of IPFIX DFW Profile
type IPFIXDFWProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX DFW Profile list results
	Results []IPFIXDFWProfile
}

// IPFIX packets will be collected on collector. IP and port address should be provided for collector.
type IPFIXL2Collector struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // IP address for the IPFIX L2 collector. IP addresses such as 0.0.0.0, 127.0.0.1, 255.255.255.255 are invalid. format: ip
	CollectorIpAddress *string
    // Port number for the IPFIX L2 collector. format: int32
	CollectorPort *int64
}

// IPFIX L2 data will be collected on collectors.
type IPFIXL2CollectorProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // It accepts Multiple Collector objects.
	IpfixL2Collectors []IPFIXL2Collector
}

// Paged list of IPFIX collector profiles.
type IPFIXL2CollectorProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX collector Profile list results
	Results []IPFIXL2CollectorProfile
}

// IPFIX data from source logical segment, port, group will be forwarded to IPFIX collector.
type IPFIXL2Profile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // The time in seconds after a flow is expired even if more packets matching this flow are received by the cache. format: int32
	ActiveTimeout *int64
    // This property controls whether overlay flow info is included in the sample result.
	ExportOverlayFlow *bool
    // The time in seconds after a flow is expired if no more packets matching this flow are received by the cache. format: int32
	IdleTimeout *int64
    // Policy path for IPFIX collector profile. User can specify only one IPFIX collector.
	IpfixCollectorProfilePath *string
    // The maximum number of flow entries in each exporter flow cache. format: int64
	MaxFlows *int64
    // An identifier that is unique to the exporting process and used to meter the flows. format: int64
	ObservationDomainId *int64
    // The probability in percentage that a packet is sampled, in range 0-100. The probability is equal for every packet.
	PacketSampleProbability *float64
    // This priority field is used to resolve conflicts in Segment Ports which are covered by more than one IPFIX profiles. The IPFIX exporter will send records to Collectors in highest priority profile (lowest number) only. format: int32
	Priority *int64
}

// Paged Collection of IPFIX L2 Profile
type IPFIXL2ProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX L2 Profile list results
	Results []IPFIXL2Profile
}

// IPFIX data from source logical segment will be copied to IPFIX collector.
type IPFIXSwitchCollectionInstance struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // The time in seconds after a flow is expired even if more packets matching this flow are received by the cache. format: int32
	ActiveTimeout *int64
    // The time in seconds after a Flow is expired if no more packets matching this Flow are received by the cache. format: int32
	IdleTimeout *int64
    // Policy path for IPFIX collector profiles. IPFIX data from these logical segments will be sent to all specified IPFIX collectors.
	IpfixCollectorProfilePaths []string
    // The maximum number of flow entries in each exporter flow cache. format: int64
	MaxFlows *int64
    // An identifier that is unique to the exporting process and used to meter the Flows. format: int32
	ObservationDomainId *int64
    // The probability in percentage that a packet is sampled, in range 0-100. The probability is equal for every packet.
	PacketSampleProbability *float64
    // Policy path for source tier-1 segment. IPFIX data from these logical segments will be sent IPFIX collector.
	SourceLogicalSegmentPaths []string
}

// Paged Collection of IPFIX Switch Collection Instances
type IPFIXSwitchCollectionInstanceListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPFIX Switch Collection Instances list results
	Results []IPFIXSwitchCollectionInstance
}

type IPInfo struct {
    // IPv4 Addresses format: ipv4
	IpAddresses []string
    // Subnet Prefix Length format: int64
	PrefixLength *int64
}

// A ServiceEntry that represents an IP protocol
type IPProtocolServiceEntry struct {
	ProtocolNumber *int64
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // Possible values are: 
    //
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IPPROTOCOLSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_IGMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ICMPTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ALGTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_L4PORTSETSERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_ETHERTYPESERVICEENTRY
    // * ServiceEntry#ServiceEntry_RESOURCE_TYPE_NESTEDSERVICESERVICEENTRY
	ResourceType string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
}
// Identifier denoting this class, when it is used in polymorphic context. 
//
// This value should be assigned to the property which is used to discriminate the actual type used in the polymorphic context.
const IPProtocolServiceEntry__TYPE_IDENTIFIER = "IPProtocolServiceEntry"

// Dead peer detection (DPD) is a method that allows detection of unreachable internet key excahnge (IKE) peers. Any changes affects all IPSec VPN sessions consuming this profile.
type IPSecVpnDpdProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // DPD probe interval defines an interval for DPD probes (in seconds). - When the DPD probe mode is periodic, this interval is the number of seconds between DPD messages. - When the DPD probe mode is on-demand, this interval is the number of seconds during which traffic is not received from the peer before DPD retry messages are sent if there is IPSec traffic to send. For PERIODIC Mode: Minimum: 3 Maximum: 360 Default: 60 For ON_DEMAND Mode: Minimum: 1 Maximum: 10 Default: 3 format: int64
	DpdProbeInterval *int64
    // Possible values are: 
    //
    // * IPSecVpnDpdProfile#IPSecVpnDpdProfile_DPD_PROBE_MODE_PERIODIC
    // * IPSecVpnDpdProfile#IPSecVpnDpdProfile_DPD_PROBE_MODE_ON_DEMAND
    //
    //  DPD probe mode is used to query the liveliness of the peer. Two modes are possible: - PERIODIC: is used to query the liveliness of the peer at regular intervals (dpd_probe_interval). It does not take into consideration traffic coming from the peer. The benefit of this mode over the on-demand mode is earlier detection of dead peers. However, use of periodic DPD incurs extra overhead. When communicating to large numbers of peers, please consider using on-demand DPD instead. - ON_DEMAND: is used to query the liveliness of the peer by instructing the local endpoint to send DPD message to a peer if there is traffic to send to the peer AND the peer was idle for dpd_probe_interval seconds (i.e. there was no traffic from the peer for dpd_probe_interval seconds).
	DpdProbeMode *string
    // If true, enable dead peer detection.
	Enabled *bool
    // Maximum number of DPD messages' retry attempts. This value is applicable for both dpd probe modes, periodic and on-demand. format: int64
	RetryCount *int64
}
const IPSecVpnDpdProfile_DPD_PROBE_MODE_PERIODIC = "PERIODIC"
const IPSecVpnDpdProfile_DPD_PROBE_MODE_ON_DEMAND = "ON_DEMAND"

// Paged Collection of IPSecVpnDpdProfile.
type IPSecVpnDpdProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPSecVpnDpdProfile list results.
	Results []IPSecVpnDpdProfile
}

// IKE Profile is a reusable profile that captures IKE phase one negotiation parameters. Any changes affects all IPSec VPN sessions consuming this profile.
type IPSecVpnIkeProfile struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Possible values are: 
    //
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP2
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP5
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP14
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP15
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP16
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP19
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP20
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DH_GROUPS_GROUP21
    //
    //  Diffie-Hellman group to be used if PFS is enabled. Default is GROUP14.
	DhGroups []string
    // Possible values are: 
    //
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA1
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_256
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_384
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_512
    //
    //  Algorithm to be used for message digest during Internet Key Exchange(IKE) negotiation. Default is SHA2_256.
	DigestAlgorithms []string
    // Possible values are: 
    //
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_128
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_256
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_128
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_192
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_256
    //
    //  Encryption algorithm is used during Internet Key Exchange(IKE) negotiation. Default is AES_128.
	EncryptionAlgorithms []string
    // Possible values are: 
    //
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_IKE_VERSION_V1
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_IKE_VERSION_V2
    // * IPSecVpnIkeProfile#IPSecVpnIkeProfile_IKE_VERSION_FLEX
    //
    //  IKE protocol version to be used. IKE-Flex will initiate IKE-V2 and responds to both IKE-V1 and IKE-V2.
	IkeVersion *string
    // Life time for security association. Default is 86400 seconds (1 day). format: int64
	SaLifeTime *int64
}
const IPSecVpnIkeProfile_DH_GROUPS_GROUP2 = "GROUP2"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP5 = "GROUP5"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP14 = "GROUP14"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP15 = "GROUP15"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP16 = "GROUP16"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP19 = "GROUP19"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP20 = "GROUP20"
const IPSecVpnIkeProfile_DH_GROUPS_GROUP21 = "GROUP21"
const IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA1 = "SHA1"
const IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_256 = "SHA2_256"
const IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_384 = "SHA2_384"
const IPSecVpnIkeProfile_DIGEST_ALGORITHMS_SHA2_512 = "SHA2_512"
const IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_128 = "AES_128"
const IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_256 = "AES_256"
const IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_128 = "AES_GCM_128"
const IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_192 = "AES_GCM_192"
const IPSecVpnIkeProfile_ENCRYPTION_ALGORITHMS_GCM_256 = "AES_GCM_256"
const IPSecVpnIkeProfile_IKE_VERSION_V1 = "IKE_V1"
const IPSecVpnIkeProfile_IKE_VERSION_V2 = "IKE_V2"
const IPSecVpnIkeProfile_IKE_VERSION_FLEX = "IKE_FLEX"

// Paged Collection of IPSecVpnIkeProfile.
type IPSecVpnIkeProfileListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPSecVpnIkeProfile list results.
	Results []IPSecVpnIkeProfile
}

// Status for IPSec VPN Ike session UP, DOWN, NEGOTIATING and fail reason if Ike session is down.
type IPSecVpnIkeSessionStatus struct {
    // Reason for failure.
	FailReason *string
    // Possible values are: 
    //
    // * IPSecVpnIkeSessionStatus#IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_UP
    // * IPSecVpnIkeSessionStatus#IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_DOWN
    // * IPSecVpnIkeSessionStatus#IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_NEGOTIATING
    //
    //  Ike session service status UP, DOWN and NEGOTIATING.
	IkeSessionState *string
}
const IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_UP = "UP"
const IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_DOWN = "DOWN"
const IPSecVpnIkeSessionStatus_IKE_SESSION_STATE_NEGOTIATING = "NEGOTIATING"

// Traffic statistics for IPSec VPN Ike session. Note - Not supported in this release.
type IPSecVpnIkeTrafficStatistics struct {
    // Number of bytes in. format: int64
	BytesIn *int64
    // Number of bytes out. format: int64
	BytesOut *int64
    // Fail count. format: int64
	FailCount *int64
    // Number of packets in. format: int64
	PacketsIn *int64
    // Number of packets out. format: int64
	PacketsOut *int64
}

// Local endpoint represents a tier-0/tier-1 on which tunnel needs to be terminated.
type IPSecVpnLocalEndpoint struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
    // Absolute path of this object
	Path *string
    // Path relative from its parent
	RelativePath *string
    // This is a UUID generated by the GM/LM to uniquely identify entites in a federated environment. For entities that are stretched across multiple sites, the same ID will be used on all the stretched sites.
	UniqueId *string
    // subtree for this type within policy tree containing nested elements.
	Children []*data.StructValue
    // Intent objects are not directly deleted from the system when a delete is invoked on them. They are marked for deletion and only when all the realized entities for that intent object gets deleted, the intent object is deleted. Objects that are marked for deletion are not returned in GET call. One can use the search API to get these objects.
	MarkedForDelete *bool
    // Global intent objects cannot be modified by the user. However, certain global intent objects can be overridden locally by use of this property. In such cases, the overridden local values take precedence over the globally defined values for the properties.
	Overridden *bool
    // Policy path referencing site certificate.
	CertificatePath *string
    // IPV4 Address of local endpoint. format: ipv4
	LocalAddress *string
    // Local identifier.
	LocalId *string
    // List of policy paths referencing certificate authority (CA) to verify peer certificates.
	TrustCaPaths []string
    // List of policy paths referencing certificate revocation list (CRL) to peer certificates.
	TrustCrlPaths []string
}

// Paged Collection of IPSecVpnLocalEndpoint.
type IPSecVpnLocalEndpointListResult struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // Opaque cursor to be used for getting next page of records (supplied by current result page)
	Cursor *string
    // Count of results found (across all pages), set only on first page format: int64
	ResultCount *int64
    // If true, results are sorted in ascending order
	SortAscending *bool
    // Field by which records are sorted
	SortBy *string
    // IPSecVpnLocalEndpoint list results.
	Results []IPSecVpnLocalEndpoint
}

// IPSec VPN policy traffic statistics.
type IPSecVpnPolicyTrafficStatistics struct {
    // Aggregate traffic statistics across all ipsec tunnels.
	AggregateTrafficCounters *IPSecVpnTrafficCounters
    // L3Vpn rule path.
	RulePath *string
    // Tunnel statistics.
	TunnelStatistics []IPSecVpnTunnelTrafficStatistics
}

// For policy-based IPsec VPNs, a security policy specifies as its action the VPN tunnel to be used for transit traffic that meets the policy’s match criteria.
type IPSecVpnRule struct {
    // The server will populate this field when returing the resource. Ignored on PUT and POST.
	Links []ResourceLink
    // Schema for this resource
	Schema *string
    // Link to this resource
	Self *SelfResourceLink
    // The _revision property describes the current revision of the resource. To prevent clients from overwriting each other's changes, PUT operations must include the current _revision of the resource, which clients should obtain by issuing a GET operation. If the _revision provided in a PUT request is missing or stale, the operation will be rejected. format: int32
	Revision *int64
    // Timestamp of resource creation format: int64
	CreateTime *int64
    // ID of the user who created this resource
	CreateUser *string
    // Timestamp of last modification format: int64
	LastModifiedTime *int64
    // ID of the user who last modified this resource
	LastModifiedUser *string
    // Protection status is one of the following: PROTECTED - the client who retrieved the entity is not allowed to modify it. NOT_PROTECTED - the client who retrieved the entity is allowed to modify it REQUIRE_OVERRIDE - the client who retrieved the entity is a super user and can modify it, but only when providing the request header X-Allow-Overwrite=true. UNKNOWN - the _protection field could not be determined for this entity.
	Protection *string
    // Indicates system owned resource
	SystemOwned *bool
    // Description of this resource
	Description *string
    // Defaults to ID if not set
	DisplayName *string
    // Unique identifier of this resource
	Id *string
    // The type of this resource.
	ResourceType *string
    // Opaque identifiers meaningful to the API user
	Tags []Tag
    // Path of its parent
	ParentPath *string
   